/**                                                                
 * SGX540 Compatibility Test For S5PV210                           
 * Copyright (c) 2009 Computing Platform, Samsung Electronics, Inc.
 * All right reserved.                                             
 *                                                                 
 * This software is the confidential and proprietary information   
 * of Samsung Electronics Inc. ("Confidential Information"). You   
 * shall not disclose such Confidential Information and shall use  
 * it only in accordance with the terms of the license agreement   
 * you entered into with Samsung Electronics.                      
 */                                                                
                                                                   
/**                                                                
 * @file	SGX540Test.h                                                       
 * @brief	This is a vector for SGX540 compatibility test.          
 * @author	Cheolkyoo Kim                                        
 * @version	1.0                                                  
 */ 
 
#if !defined (__SGX540_TEST_H__)
#define __SGX540_TEST_H__

#include "sgx540defs.h"
#include <stdio.h>
#include <string.h>
#include "option.h"
#include "library.h"
#include "memcpy_lib.h"

#define SGX540_SEMIHOSTING          1
#define SGX540_DUMP_SIGINFO         0
#define SGX540_DUMP_PERFINFO        0
#define SGX540_DUMP_FRAMEBUF        0
#define SGX540_DUMP_FILE            0

//#define	SGX_API

#define		ADDR_3D_MEM			(CODEC_MEM_ST + 0x00800000)		//0x41800000
#define		ADDR_3D_PRM			(ADDR_3D_MEM  + 0x01000000)		//0x42800000


#define SGX540_MEMORY_BASE          0x20000000
#define SGX540_REGISTER_BASE        0xF3000000
#define SGX540_MEMFILE_BASE         ADDR_3D_MEM
#define SGX540_PRMFILE_BASE         ADDR_3D_PRM

//#define SGX540_MEMFILE_BASE         0x43000000
//#define SGX540_PRMFILE_BASE         0x43800000

#define COUNT_FOR_100US             100


#define SGX_READB(ADDR)             (*(volatile unsigned char *)  (ADDR))
#define SGX_READW(ADDR)             (*(volatile unsigned short *) (ADDR))
#define SGX_READL(ADDR)             (*(volatile unsigned int *)   (ADDR))

#define SGX_WRITEB(ADDR, DATA)      ((*(volatile unsigned char *)  (ADDR)) = (DATA))
#define SGX_WRITEW(ADDR, DATA)      ((*(volatile unsigned short *) (ADDR)) = (DATA))
#define SGX_WRITEL(ADDR, DATA)      ((*(volatile unsigned int *)   (ADDR)) = (DATA))

#define SGX_WRITE_REG(REG,  DATA)   (*(volatile unsigned int *)(EUR_CR_ ##REG + SGX540_REGISTER_BASE) = (DATA))
#define SGX_WRITE_MEM(ADDR, DATA)   (*(volatile unsigned int *)(ADDR) = (DATA))
#define SGX_READ_REG(REG,   DATA)   (DATA = (*(volatile unsigned int *)(EUR_CR_ ##REG + SGX540_REGISTER_BASE)))
#define SGX_READ_MEM(ADDR,  DATA)   (DATA = (*(volatile unsigned int *)(ADDR)))

#define SGX_MEMCPY                  memcpy
//#define SGX_MEMCPY                  _single_memcpy
#define SGX_COM                     UART_Printf
#define SGX_WRITE_FILE              SaveToFile
#define SGX_LOAD_FILE               LoadFromFile
#define SGX_READ_FILE               ReadFromFile

//#define SGX_DELAY(STEPS)            for(; STEPS > 0; STEPS--)           \
//                                        for(int i = 0; i < COUNT_FOR_100US; i++ )

#define SGX_DELAY(STEPS)            SysDelay(STEPS)

#if (1)

#define SGX_POLL_MEM(ADDR, VAL, MASK, OP, COUNT, DELAY)     \
do { \
int i = 0; \
SGX_DELAY(DELAY); \
if(i++ > COUNT) { SGX_COM("The poll is unsuccessful.\n"); break; } \
} while(!(((SGX_READL(ADDR)) & (MASK)) OP VAL))

#define SGX_POLL_REG(ADDR, VAL, MASK, OP, COUNT, DELAY)     \
do { \
int i = 0; \
SGX_DELAY(DELAY); \
if(i++ > COUNT) { SGX_COM("The poll is unsuccessful.\n"); break; } \
} while(!(((SGX_READL(EUR_CR_ ##ADDR + SGX540_REGISTER_BASE)) & (MASK)) OP VAL))



/* Polling Circular Buffer */
#define SGX_POLL_CB(ADDR, WVAL, PSIZE, BSIZE)               \
do {  \
unsigned int RVAL; \
RVAL = SGX_READL(ADDR); \
if(RVAL > WVAL) uiFreeSpace = RVAL - WVAL - 1; \
else uiFreeSpace = (RVAL - WVAL) + (BSIZE - 1); \
} while(uiFreeSpace < PSIZE)

#endif

#define		SGXAPI
#if (0)
extern void PollSgxReg(u32 ADDR, u32 VAL, u32 MASK, u32 COUNT, u32 DELAY);
extern void PollSgxMem(u32 ADDR, u32 VAL, u32 MASK, u32 COUNT, u32 DELAY);
extern void PollSgxCirBuffer(u32 ADDR, u32 WVAL, u32 PSIZE, u32 BSIZE);

#define SGX_POLL_MEM(ADDR, VAL, MASK, OP, COUNT, DELAY)     PollSgxMem(ADDR, VAL, MASK, COUNT, DELAY)
#define SGX_POLL_REG(ADDR, VAL, MASK, OP, COUNT, DELAY)     PollSgxReg(EUR_CR_ ##ADDR, VAL, MASK, COUNT, DELAY)
#define SGX_POLL_CB(ADDR, WVAL, PSIZE, BSIZE)				PollSgxCirBuffer(ADDR, WVAL, PSIZE, BSIZE)
#endif


typedef enum	IMAGE_tag_ePixFormat
{
	PIXFMT_RGB8			= 0x1,
	PIXFMT_RGB332		= 0x2,
	PIXFMT_KRGB555		= 0x3,
	PIXFMT_RGB565		= 0x4,
	PIXFMT_ARGB4444		= 0x5,
	PIXFMT_ARGB1555		= 0x6,
	PIXFMT_RGB888		= 0x7,
	PIXFMT_ARGB8888		= 0x8,	
	PIXFMT_YUV8			= 0x9,
	PIXFMT_AYUV4444		= 0xA,
	PIXFMT_VY0UY1_8888	= 0xB,
	PIXFMT_UY0VY1_8888	= 0xC,
	PIXFMT_Y0UY1V_8888	= 0xD,
	PIXFMT_Y0VY1U_8888	= 0xE,
	PIXFMT_YUV888		= 0xF,
	PIXFMT_UYVY10101010	= 0x10,
	PIXFMT_VYAUYA8888	= 0x11,
	PIXFMT_AYUV8888		= 0x12,
	PIXFMT_AYUV2101010	= 0x13,
	PIXFMT_YUV101010	= 0x14,
	PIXFMT_PL12Y8		= 0x15,
	PIXFMT_YUV_IMC2		= 0x16,
	PIXFMT_YUV_YV12		= 0x17,
	PIXFMT_YUV_PL8		= 0x18,
	PIXFMT_YUV_PL12		= 0x19,
	PIXFMT_422PL12YUV8	= 0x1A,
	PIXFMT_420PL12YUV8	= 0x1B,
	PIXFMT_PL12Y10		= 0x1C,
	PIXFMT_422PL12YUV10	= 0x1D,
	PIXFMT_420PL12YUV10	= 0x1E,
	PIXFMT_ABGR8888		= 0x1F,	
	PIXFMT_BGRA8888		= 0x20,	
	PIXFMT_ARGB8332		= 0x21,
	PIXFMT_RGB555		= 0x22,
	PIXFMT_F16			= 0x23,
	PIXFMT_F32			= 0x24,
	PIXFMT_L16			= 0x25,
	PIXFMT_L32			= 0x26,
	
	/* Just a marker */
	PIXFMT_UNKNOWN		= 0x27

}	IMAGE_ePixFormat;


/******************************************************************************
    SGX Data Structure 
 ******************************************************************************/
// SII Parameter Information
typedef struct
{
    char            asImageSet[256];
    char            asFileName[256];
    unsigned int    uiSize1;
    unsigned int    uiOffset1;        /* Offset of the first plane of pixel data */
    unsigned int    uiSize2;                                         
    unsigned int    uiOffset2;        
    unsigned int    uiSize3;                                         
    unsigned int    uiOffset3;        
    unsigned int    uiPixelFormat;    /* Pixel format see #TAL_ePixelFormats     */
    unsigned int    uiWidth;          /* Is the width of the image - in pixels   */
    unsigned int    uiHeight;         /* Is the height of the image - in lines   */
    unsigned int    uiStride;         /* Is the image stride - in bytes          */
    unsigned int    uiAddrMode;       /* Is the address mode                     */
} SaveImageInfo;


static void SysDelay(unsigned int steps)
{
	int i;

	for(; steps > 0; steps--)
		for(i = 0; i < COUNT_FOR_100US; i++);
}

void DumpTASignature(char * VectorName, int bWriteFile);
void Dump3DSignature(char * VectorName, int bWriteFile);
void DumpPerfCounter(char * VectorName, int bWriteFile);
void DumpFrameBuffer(char * VectorName, unsigned int ByteCnt, unsigned int Address);

/******************************************************************************
     SGX540 Compatibility Test Suite v1.1.0
 ******************************************************************************/

typedef struct 
{
	unsigned int uiIndex;
	char* psVectorName;
	int (*fp)(char *, int);
	int Width;
	int Height;
	char* FrameBufAddr; 
} SGXVectorList;


#endif /* __SGX540_TEST_H__ */



























// TODO

#if 0

#define Outp16(addr, data)	(*(volatile u16 *)(addr) = (data))
#define Outp8(addr, data)	(*(volatile u8 *)(addr) = (data))
#define Inp32(addr)			(*(volatile u32 *)(addr))
#define Inp32_SPI(addr, data) (data = (*(volatile u32 *)(addr)))
#define Inp16(addr)			(*(volatile u16 *)(addr))
#define Inp8(addr)			(*(volatile u8 *)(addr))


// TODO: SET_BIT
//       SET_REG
//       CLEAR_BIT
//       CLEAR_REG

#DEFINE SGX_SET(DATA, FIELD)	    ((DATA) | (EUR_CR_ ##FIELD ##_CLRMSK))
#DEFINE SGX_CLEAR(DATA, FIELD)	    ((DATA) & (EUR_CR_ ##FIELD ##_CLRMSK))
#DEFINE SGX_CHECK(DATA, FIELD)      ((DATA) & (0X1 << (EUR_CR_ ##FIELD ##_SHIFT)))
#DEFINE SGX_INVERT(DATA, FIELD)	    ((DATA) ^= (EUR_CR_ ##FIELD ##_CLRMSK))
#DEFINE SGX_EXTRACT(DATA, FIELD)	(((DATA) & (EUR_CR_ ##FIELD ##_CLRMSK)) >> (EUR_CR_ ##FIELD ##_SHIFT))


// Take from embedded programming C code optimization
#define clear_bit(data, loc)    ((data) &= ~(0x1 << (loc)))
#define clear_bits(data, area, loc)   ((data) &= ~((area) << (loc)))
#define set_bit(data, loc)      ((data) |= (0x1 << (loc)))
#define set_bits(data, area, loc)   ((data) |= ((area) << (loc)))
#define invert_bit(data, loc)   ((data) ^= (0x1 << (loc)))
#define invert_bits(data, area, loc)    ((data) ^= ((area) << (loc)))
#define check_bit(data, loc)    ((data) & (0x1 << (loc)))
#define extract_bit(data, area, loc)    (((data) >> (loc)) & (area))

clear_bit(a, 5);
clear_bits(a, 0x7, 3) // 5, 4, 3  3Ʈ Ŭ

set_bit(a, 5);
set_bits(a, 0x7, 3); // 5, 4, 3  3Ʈ 

invert_bit(a, 5);
invert_bits(a, 0x7, 3); // 5, 4, 3  3Ʈ 

if(check_bit(a, 5)) // 5 Ʈ  üũ
else
b = extract_bits(a, 0x7, 4); // 6, 5, 4 Ʈ Ͽ b 
#endif



