/**                                                                
 * SGX540 Compatibility Test For S5PV210                           
 * Copyright (c) 2009 Computing Platform, Samsung Electronics, Inc.
 * All right reserved.                                             
 *                                                                 
 * This software is the confidential and proprietary information   
 * of Samsung Electronics Inc. ("Confidential Information"). You   
 * shall not disclose such Confidential Information and shall use  
 * it only in accordance with the terms of the license agreement   
 * you entered into with Samsung Electronics.                      
 */                                                                
                                                                   
/**                                                                
 * @file	sgx540.cpp                                                       
 * @brief	This is a vector for SGX540 compatibility test.          
 * @author	Cheolkyoo Kim                                        
 * @version	1.0                                                  
 */                                                                

#include <stdio.h>


#include "sgx540.h"
#include "library.h"

#if 1
#ifdef		__MGR
void DumpFrameBuffer(char * VectorName, unsigned int ByteCnt, unsigned int Address)
{
    static unsigned int uiFileCount = 0;
#if (SGX540_SEMIHOSTING)
    char asFileName[256];

    memset(asFileName, 0, sizeof(asFileName));
    sprintf(asFileName, "%s%d%s", VectorName, uiFileCount, ".bin");
    
    FILE * pf = fopen(asFileName, "ab");
	SGX_READ_FILE(asFileName, ByteCnt, Address);
	fclose(pf);
	uiFileCount++;
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */      
}


void DumpTASignature(char * VectorName, int bWriteFile)
{
    static unsigned int uiTAFileCount = 0;
    static char asTAFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[5];
    
    // Dump TA signature registers
    SGX_READ_REG(CLIP_SIG1,     auiSignature[0]);
    SGX_READ_REG(MTE_SIG1,      auiSignature[1]);
    SGX_READ_REG(MTE_SIG2,      auiSignature[2]);
    SGX_READ_REG(TE1,           auiSignature[3]);
    SGX_READ_REG(TE2,           auiSignature[4]);
    
    SGX_COM("\nTA Signature Register\n\t");
    for(int i = 0; i < 5; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(asTAFile, VectorName) == NULL)
    {
        uiTAFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, "_ta.sig");
        memset(asTAFile, 0, sizeof(asTAFile));
        sprintf(asTAFile, "%s%s%d%s", VectorName, "_ta", uiTAFileCount, ".sig");
        
        FILE * pf = fopen(asTAFile, "ab");
		uiWriteSize = fwrite((unsigned char *)auiSignature, sizeof(unsigned char), (5 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		}

		fclose(pf);
		uiTAFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
  
}

void Dump3DSignature(char * VectorName, int bWriteFile)
{
    static unsigned int ui3DFileCount = 0;
    static char as3DSigFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[7];
    
    // Dump 3D signature registers
    SGX_READ_REG(ISP_FPU,       auiSignature[0]);
    SGX_READ_REG(ISP_SIG1,      auiSignature[1]);
    SGX_READ_REG(ISP_SIG2,      auiSignature[2]);
    SGX_READ_REG(ISP_SIG3,      auiSignature[3]);
    SGX_READ_REG(ISP_SIG4,      auiSignature[4]);
    SGX_READ_REG(PIXELBE_SIG01, auiSignature[5]);
    SGX_READ_REG(PIXELBE_SIG02, auiSignature[6]);

    SGX_COM("3D Signature Register\n\t");
    for(int i = 0; i < 7; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(as3DSigFile, VectorName) == NULL)
    {
        ui3DFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, "_3d.sig");
        memset(as3DSigFile, 0, sizeof(as3DSigFile));
        sprintf(as3DSigFile, "%s%s%d%s", VectorName, "_3d", ui3DFileCount, ".sig");
        
		FILE * pf = fopen(as3DSigFile, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 5), sizeof(unsigned char), (7 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		}
		
		fclose(pf);
		ui3DFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
}

void DumpPerfCounter(char * VectorName, int bWriteFile)
{
    static unsigned int uiPerfFileCount = 0;
    static char asPerfFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[22];
    
    // Dump performance counter registers
    SGX_READ_REG(PERF,          auiSignature[12]);
    SGX_READ_REG(PERF_COUNTER0, auiSignature[13]);
    SGX_READ_REG(PERF_COUNTER1, auiSignature[14]);
    SGX_READ_REG(PERF_COUNTER2, auiSignature[15]);
    SGX_READ_REG(PERF_COUNTER3, auiSignature[16]);
    SGX_READ_REG(PERF_COUNTER4, auiSignature[17]);
    SGX_READ_REG(PERF_COUNTER5, auiSignature[18]);
    SGX_READ_REG(PERF_COUNTER6, auiSignature[19]);
    SGX_READ_REG(PERF_COUNTER7, auiSignature[20]);
    SGX_READ_REG(PERF_COUNTER8, auiSignature[21]);
    
    SGX_COM("Performance Counter Register\n\t");
    for(int i = 0; i < 10; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(asPerfFile, VectorName) == NULL)
    {
        uiPerfFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, ".perf");
        memset(asPerfFile, 0, sizeof(asPerfFile));
        sprintf(asPerfFile, "%s%s%d%s", VectorName, "_3d", uiPerfFileCount, ".sig");

		FILE * pf = fopen(asPerfFile, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 12), sizeof(unsigned char), (10 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0) SGX_COM("Error total size of file write is 0 byte.\n");

		fclose(pf);
		uiPerfFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
}
#endif //mgr

#else
static void Dump3DInfo(char * VectorName, int bWriteFile)
{
    unsigned int auiSignature[22];
    
    // Dump TA signature registers
    SGX_READ_REG(CLIP_SIG1,     auiSignature[0]);
    SGX_READ_REG(MTE_SIG1,      auiSignature[1]);
    SGX_READ_REG(MTE_SIG2,      auiSignature[2]);
    SGX_READ_REG(TE1,           auiSignature[3]);
    SGX_READ_REG(TE2,           auiSignature[4]);
    // Dump 3D signature registers
    SGX_READ_REG(ISP_FPU,       auiSignature[5]);
    SGX_READ_REG(ISP_SIG1,      auiSignature[6]);
    SGX_READ_REG(ISP_SIG2,      auiSignature[7]);
    SGX_READ_REG(ISP_SIG3,      auiSignature[8]);
    SGX_READ_REG(ISP_SIG4,      auiSignature[9]);
    SGX_READ_REG(PIXELBE_SIG01, auiSignature[10]);
    SGX_READ_REG(PIXELBE_SIG02, auiSignature[11]);
    // Dump performance counter registers
    SGX_READ_REG(PERF,          auiSignature[12]);
    SGX_READ_REG(PERF_COUNTER0, auiSignature[13]);
    SGX_READ_REG(PERF_COUNTER1, auiSignature[14]);
    SGX_READ_REG(PERF_COUNTER2, auiSignature[15]);
    SGX_READ_REG(PERF_COUNTER3, auiSignature[16]);
    SGX_READ_REG(PERF_COUNTER4, auiSignature[17]);
    SGX_READ_REG(PERF_COUNTER5, auiSignature[18]);
    SGX_READ_REG(PERF_COUNTER6, auiSignature[19]);
    SGX_READ_REG(PERF_COUNTER7, auiSignature[20]);
    SGX_READ_REG(PERF_COUNTER8, auiSignature[21]);
    
    SGX_COM("\nTA Signature Register\n\t");
    for(int i = 0; i < 5; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

    SGX_COM("3D Signature Register\n\t");
    for(int i = 0; i < 7; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

    SGX_COM("Performance Counter Register\n\t");
    for(int i = 0; i < 10; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)

    if(bWriteFile)
    {
        char asFileName[256];
        unsigned int uiWriteSize;
        
		strcpy(asFileName, VectorName);
        strcat(asFileName, "_ta.sig");
        
        FILE * pf = fopen(asFileName, "ab");
		uiWriteSize = fwrite((unsigned char *)auiSignature, sizeof(unsigned char), (5 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		    goto FILE_WRITE_ERROR;
		}
		fclose(pf);
		
		strcpy(asFileName, VectorName);
        strcat(asFileName, "_3d.sig");
		pf = fopen(asFileName, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 5), sizeof(unsigned char), (7 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		    goto FILE_WRITE_ERROR;
		}
		fclose(pf);
		
		strcpy(asFileName, VectorName);
        strcat(asFileName, ".perf");
		pf = fopen(asFileName, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 12), sizeof(unsigned char), (10 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0) SGX_COM("Error total size of file write is 0 byte.\n");
		
FILE_WRITE_ERROR:
		fclose(pf);
		return;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
  
}
#endif

/* End of file */
