/**                                                                
 * SGX540 Compatibility Test For S5PV210                           
 * Copyright (c) 2009 Computing Platform, Samsung Electronics, Inc.
 * All right reserved.                                             
 *                                                                 
 * This software is the confidential and proprietary information   
 * of Samsung Electronics Inc. ("Confidential Information"). You 
 * shall not disclose such Confidential Information and shall use  
 * it only in accordance with the terms of the license agreement   
 * you entered into with Samsung Electronics.                      
 */                                                                
                                                                   
/**                                                                
 * @file	SGX540VectorList.h                                       
 * @brief	This is a vector for SGX540 compatibility test.          
 * @author	Cheolkyoo Kim                                        
 * @version	1.0                                                  
 */                                                                


#ifndef __SGX540_VECTOR_LIST_H__
#define __SGX540_VECTOR_LIST_H__



/* include SGX540 vectors */

extern int dx_gridmark_overlapped_ps_clipped(char * psVectorName, int bWriteFile);
extern int dx_addressmodes_1555_fa4mp_8x4(char * psVectorName, int bWriteFile);
extern int dx_addressmodes_1555_fa4mp_8x4_depread(char * psVectorName, int bWriteFile);
extern int dx_antialias_nt_point(char * psVectorName, int bWriteFile);
extern int dx_antialias_nt_quad(char * psVectorName, int bWriteFile);
extern int dx_blendedlines_strip_nolastpixel(char * psVectorName, int bWriteFile);
extern int dx_cache_dm4_pm9(char * psVectorName, int bWriteFile);
extern int dx_cache_forcecachelinefill_dm_0_pm_0(char * psVectorName, int bWriteFile);
extern int dx_cem_pvrtc2_fpmn(char * psVectorName, int bWriteFile);
extern int dx_cemsizes_128x128_565_fbmp(char * psVectorName, int bWriteFile);
extern int dx_cemsizes_128x128_8888_fbmn(char * psVectorName, int bWriteFile);
extern int dx_cemsizes_8x8_u8_fbmt(char * psVectorName, int bWriteFile);
extern int dx_cemsizes_8x8_u8_fpmt(char * psVectorName, int bWriteFile);
extern int dx_d3dstenciltest_nt(char * psVectorName, int bWriteFile);
extern int dx_d3dwindingorder_nt(char * psVectorName, int bWriteFile);
extern int dx_dadjust_8888_fpmt(char * psVectorName, int bWriteFile);
extern int dx_filter_4444_fallmall(char * psVectorName, int bWriteFile);
extern int dx_filter_565_fallmall(char * psVectorName, int bWriteFile);
extern int dx_filter_depread_pvrtc2_fallmn(char * psVectorName, int bWriteFile);
extern int dx_filter_depread_pvrtc4_fallmall(char * psVectorName, int bWriteFile);
extern int dx_gridmark_bench0_320x240(char * psVectorName, int bWriteFile);
extern int dx_gridmark_bench1_320x240(char * psVectorName, int bWriteFile);
extern int dx_gridmark_bench2_320x240(char * psVectorName, int bWriteFile);
extern int dx_mipmaplevels_8888_fpmn(char * psVectorName, int bWriteFile);
extern int dx_pixelshader_dp3(char * psVectorName, int bWriteFile);
extern int dx_randomfans_100t_g_sp_8888_fpmn(char * psVectorName, int bWriteFile);
extern int dx_randomfans_linefilled_100t_g(char * psVectorName, int bWriteFile);
extern int dx_randomfans_pointfilled_1t_g_sp(char * psVectorName, int bWriteFile);
extern int dx_randomlines_100l_f(char * psVectorName, int bWriteFile);
extern int dx_randomtriangles_pointfilled_100t_g_sp_8888_fpmn(char * psVectorName, int bWriteFile);
extern int dx_randomtriangles_pointfilled_1t_f(char * psVectorName, int bWriteFile);
extern int dx_rendertexture_128x16_8888(char * psVectorName, int bWriteFile);
extern int dx_use_firv_rand(char * psVectorName, int bWriteFile);
extern int dx_use_la_stall_setl_consecutive(char * psVectorName, int bWriteFile);
extern int dx_use_ld_st_dtype_2(char * psVectorName, int bWriteFile);
extern int dx_use_nop_end_next_exe_valid(char * psVectorName, int bWriteFile);
extern int dx_use_pds_texcoord_f32(char * psVectorName, int bWriteFile);
extern int dx_use_smp_2101010_tempregs_parallel(char * psVectorName, int bWriteFile);
extern int dx_use_smp_drc1_drc0(char * psVectorName, int bWriteFile);
extern int dx_use_sync_func_test_case6(char * psVectorName, int bWriteFile);
extern int dx_usecslotgen_nt_msaa(char * psVectorName, int bWriteFile);
extern int dx_vspointsize_8888_fpmn_8888_fpmn(char * psVectorName, int bWriteFile);
extern int dx_wireframe_8888_fpmn_lenna(char * psVectorName, int bWriteFile);
extern int ogl_clipping_triangles(char * psVectorName, int bWriteFile);
extern int ogl_clipping_triangles_g_front_pointfilled_back_linrfilled(char * psVectorName, int bWriteFile);
extern int ogl_clipping_tristrip(char * psVectorName, int bWriteFile);
extern int ogl_filter_arbitrarysizes_317x349_4444_fallmall(char * psVectorName, int bWriteFile);
extern int ogl_textureborder_128x32_4444_fbmn(char * psVectorName, int bWriteFile);
	   
extern int dx_d3dflatshading_nt(char * psVectorName, int bWriteFile);
extern int dx_gridmark_overlapped_ps(char * psVectorName, int bWriteFile);
extern int dx_multitexture_8888_fpmn_2layers(char * psVectorName, int bWriteFile);
extern int dx_pixelshader_abs(char * psVectorName, int bWriteFile);
extern int dx_randomfans_100t_f(char * psVectorName, int bWriteFile);
extern int dx_randomtriangles_1t_f(char * psVectorName, int bWriteFile);
extern int dx_randomtriangles_100t_g(char * psVectorName, int bWriteFile);
extern int dx_randomtstrips_100t_f(char * psVectorName, int bWriteFile);
extern int dx_randomtstrips_100t_f_8888_fpmn(char * psVectorName, int bWriteFile);

extern int navigation_1(char * psVectorName, int bWriteFile);    
extern int navigation_2(char * psVectorName, int bWriteFile);    
extern int navigation_3(char * psVectorName, int bWriteFile);    
extern int navigation_4(char * psVectorName, int bWriteFile);    
extern int user_interface_1(char * psVectorName, int bWriteFile);
extern int user_interface_2(char * psVectorName, int bWriteFile);
extern int user_interface_3(char * psVectorName, int bWriteFile);
extern int user_interface_4(char * psVectorName, int bWriteFile);

extern int vgmark_bench0_aa(char * psVectorName, int bWriteFile);
extern int vgmark_bench2_aa(char * psVectorName, int bWriteFile);
extern int vgmark_bench3(char * psVectorName, int bWriteFile);
extern int vgmark_bench3_aa(char * psVectorName, int bWriteFile);
extern int vgmark_bench4(char * psVectorName, int bWriteFile);
extern int vgmark_bench4_aa(char * psVectorName, int bWriteFile);
extern int vgmark_bench5(char * psVectorName, int bWriteFile);
extern int vgmark_bench5_aa(char * psVectorName, int bWriteFile);

extern int tigermark_2x2aa(char * psVectorName, int bWriteFile);
extern int tigermark_mraa(char * psVectorName, int bWriteFile);
extern int tigermark_noaa(char * psVectorName, int bWriteFile);

extern int samurai_aa(char * psVectorName, int bWriteFile);
extern int samurai_noaa(char * psVectorName, int bWriteFile);
extern int samurai_nopvrtc(char * psVectorName, int bWriteFile);
extern int samurai_pvrtc(char * psVectorName, int bWriteFile);


/* end of include */



SGXVectorList stVectorList[] = {
	/* Index,      VectorName,    FunctionName */
	//basic test function
#if (0)	
	1,  "dx_d3dflatshading_nt",															dx_d3dflatshading_nt, 128, 128, (char*)0x20543000, 					  //basic
	2,  "dx_multitexture_8888_fpmn_2layers",											dx_multitexture_8888_fpmn_2layers, 128, 128, (char*)0x20543000,       //basic
	3,  "dx_pixelshader_abs",															dx_pixelshader_abs, 64, 64, (char*)0x20543000,         				  //basic                     
	4,  "dx_randomfans_100t_f",															dx_randomfans_100t_f, 256, 256, (char*)0x20543000,   				  //basic                   
	5,  "dx_randomtriangles_1t_f",														dx_randomtriangles_1t_f, 256, 256, (char*)0x20543000, 				  //basic                   
	6,  "dx_randomtriangles_100t_g",													dx_randomtriangles_100t_g, 256, 256, (char*)0x20543000,				  //basic	                 
	7,  "dx_d3dwindingorder_nt",	                									dx_d3dwindingorder_nt, 320, 240,  (char*)0x20543000,   //basic //compatibility
	8,  "dx_gridmark_overlapped_ps",	              									dx_gridmark_overlapped_ps, 64, 64, (char*)0x225BF000,  //basic //compatibility
	9,	"dx_gridmark_overlapped_ps_clipped",									dx_gridmark_overlapped_ps_clipped, 64, 64, (char*)0x225BF000,  //basic 	
	// compatibility test function
	10,  "dx_antialias_nt_point",	                  									dx_antialias_nt_point, 64, 64, (char*)0x20558000,                                                               
	11, "dx_antialias_nt_quad",	                    									dx_antialias_nt_quad,  64, 64, (char*)0x20558000,                                                               
	12, "dx_blendedlines_strip_nolastpixel",	      									dx_blendedlines_strip_nolastpixel,   256,256,(char*)0x20543000,                                                 
	13, "dx_cache_dm4_pm9",	                        									dx_cache_dm4_pm9,    256,256,(char*)0x20543000,                                                                 
	14, "dx_cache_forcecachelinefill_dm_0_pm_0",	  									dx_cache_forcecachelinefill_dm_0_pm_0,    256,256,(char*)0x20543000,                                            
	15, "dx_cem_pvrtc2_fpmn",	                    									dx_cem_pvrtc2_fpmn, 96, 64, (char*)0x20543000,                                                                    
	16, "dx_cemsizes_128x128_565_fbmp",	            									dx_cemsizes_128x128_565_fbmp,  192,128, (char*)0x20543000,                                                      
	17, "dx_cemsizes_128x128_8888_fbmn",	        									dx_cemsizes_128x128_8888_fbmn,  192,128, (char*)0x20543000,                                                       
	18, "dx_cemsizes_8x8_u8_fbmt",	                									dx_cemsizes_8x8_u8_fbmt, 192,128, (char*)0x20543000,                                                            
	19, "dx_cemsizes_8x8_u8_fpmt",	                									dx_cemsizes_8x8_u8_fpmt, 192,128, (char*)0x20543000,                                                            
	20, "dx_d3dstenciltest_nt",	                    									dx_d3dstenciltest_nt, 128,128, (char*)0x20543000,                                                               
	21, "dx_pixelshader_dp3",	                            							dx_pixelshader_dp3, 64, 64, (char*)0x20543000,                                                            
	22, "dx_dadjust_8888_fpmt",	                    									dx_dadjust_8888_fpmt,  128,128,(char*)0x20543000,                                                               
	23, "dx_filter_4444_fallmall",	                									dx_filter_4444_fallmall,  320, 96, (char*)0x20543000,                                                           
	24, "dx_filter_565_fallmall",	                									dx_filter_565_fallmall, 320, 96, (char*)0x20558000,                                                               
	25, "dx_filter_depread_pvrtc2_fallmn",	        									dx_filter_depread_pvrtc2_fallmn, 320, 64, (char*)0x20558000,                                                    
	26, "dx_filter_depread_pvrtc4_fallmall",	      									dx_filter_depread_pvrtc4_fallmall, 320, 96, (char*)0x20558000,                                                    
	27, "dx_gridmark_bench0_320x240",	              									dx_gridmark_bench0_320x240, 320, 240, (char*)0x20543000,                                                          
	28, "dx_gridmark_bench1_320x240",	              									dx_gridmark_bench1_320x240, 320, 240, (char*)0x20543000,                                                          
	29, "dx_gridmark_bench2_320x240",	              									dx_gridmark_bench2_320x240, 320, 240, (char*)0x20543000,                                                          
	30, "dx_addressmodes_1555_fa4mp_8x4_depread",										dx_addressmodes_1555_fa4mp_8x4_depread, 128,128,(char*)0x20543000,  
	31, "dx_mipmaplevels_8888_fpmn",	            	        						dx_mipmaplevels_8888_fpmn, 128, 128, (char*)0x20543000,                                                   
	32, "dx_addressmodes_1555_fa4mp_8x4",	        									dx_addressmodes_1555_fa4mp_8x4,  128,128,(char*)0x20543000,                                                       
	33, "dx_randomfans_100t_g_sp_8888_fpmn",	            							dx_randomfans_100t_g_sp_8888_fpmn, 256, 256, (char*)0x20543000,                                           
	34, "dx_randomfans_linefilled_100t_g",	              								dx_randomfans_linefilled_100t_g, 256, 256, (char*)0x20543000,                                           
	35, "dx_randomfans_pointfilled_1t_g_sp",	            							dx_randomfans_pointfilled_1t_g_sp, 256, 256, (char*)0x20543000,                                           
	36, "dx_randomlines_100l_f",	                        							dx_randomlines_100l_f,  256, 256, (char*)0x20543000,                                                      
	37, "dx_randomtriangles_pointfilled_100t_g_sp_8888_fpmn",							dx_randomtriangles_pointfilled_100t_g_sp_8888_fpmn, 256, 256, (char*)0x20543000,                      
	38, "dx_randomtriangles_pointfilled_1t_f",	            							dx_randomtriangles_pointfilled_1t_f,  256, 256, (char*)0x20543000,                                      
	39, "dx_randomtstrips_100t_f",	                        							dx_randomtstrips_100t_f, 256, 256, (char*)0x20543000,                                                   
	40, "dx_randomtstrips_100t_f_8888_fpmn",	            							dx_randomtstrips_100t_f_8888_fpmn, 256, 256, (char*)0x20543000,                                           
	41, "dx_rendertexture_128x16_8888",	                    							dx_rendertexture_128x16_8888, 128, 16, (char*)0x20558000,                                               
	42, "dx_use_firv_rand",	                                							dx_use_firv_rand, 128, 128, (char*)0x20543000,                                                          
	43, "dx_use_la_stall_setl_consecutive", 	            							dx_use_la_stall_setl_consecutive, 128, 128, (char*)0x20543000,                                            
	44, "dx_use_ld_st_dtype_2",	                            							dx_use_ld_st_dtype_2, 128, 128, (char*)0x20543000,                                                      
	45, "dx_use_nop_end_next_exe_valid",	                							dx_use_nop_end_next_exe_valid, 128,128,(char*)0x20543000,                                                 
	46, "dx_use_pds_texcoord_f32",	                        							dx_use_pds_texcoord_f32, 128,128,(char*)0x20543000,                                                     
	47, "dx_use_smp_2101010_tempregs_parallel",	            							dx_use_smp_2101010_tempregs_parallel, 128,128,(char*)0x20543000,                                        
	48, "dx_use_smp_drc1_drc0",	                            							dx_use_smp_drc1_drc0,  128,128,(char*)0x20543000,                                                       
	49, "dx_use_sync_func_test_case6",	                    							dx_use_sync_func_test_case6,  128,128,(char*)0x20543000,                                                
	50, "dx_usecslotgen_nt_msaa",	                        							dx_usecslotgen_nt_msaa,  128,128,(char*)0x20558000,                                                       
	51, "dx_vspointsize_8888_fpmn_8888_fpmn",	            							dx_vspointsize_8888_fpmn_8888_fpmn,   256,256,(char*)0x20543000,                                          
	#endif
	52, "dx_wireframe_8888_fpmn_lenna", 	                							dx_wireframe_8888_fpmn_lenna,  640,480,(char*)0x20543000,                                                  
	#if 0
	53, "ogl_clipping_triangles",	                        							ogl_clipping_triangles, 128, 109, (char*)0x22DF7000,                                                       
	54, "ogl_clipping_triangles_g_front_pointfilled_back_linrfilled",					ogl_clipping_triangles_g_front_pointfilled_back_linrfilled, 128, 109, (char*)0x22E0D000,       
	55, "ogl_clipping_tristrip",    	                    							ogl_clipping_tristrip,  128, 109, (char*)0x22E0D000,                                                       
	56, "ogl_filter_arbitrarysizes_317x349_4444_fallmall",								ogl_filter_arbitrarysizes_317x349_4444_fallmall, 320, 96, (char*)0x22DF7000,                             
	57, "ogl_textureborder_128x32_4444_fbmn",	            							ogl_textureborder_128x32_4444_fbmn, 256, 256, (char*)0x22E0D000,	                                         
	//3dmarkmobileES20_v20
	58, "navigation_1",																	navigation_1, 					800,480,(char*)0x224DD000, 
	59, "navigation_2",																	navigation_2, 					800,480,(char*)0x224DD000, 
	60, "navigation_3",																	navigation_3, 					800,480,(char*)0x224DD000, 
	61, "navigation_4",																	navigation_4, 					800,480,(char*)0x224DD000, 
	62, "user_interface_1",																user_interface_1, 			800,480,(char*)0x224DD000, 
	63, "user_interface_2",																user_interface_2, 			800,480,(char*)0x224DD000, 
	64, "user_interface_3",																user_interface_3, 			800,480,(char*)0x224DD000, 
	65, "user_interface_4",																user_interface_4, 			800,480,(char*)0x224DD000, 	
	//vgmark_v11
	66, "vgmark_bench0_aa",		    	       vgmark_bench0_aa,   		640, 480, (char*)0x2073D000,
	67, "vgmark_bench2_aa",                vgmark_bench2_aa,   		640, 480, (char*)0x2073D000,
	68, "vgmark_bench3",                      vgmark_bench3,         		640, 480, (char*)0x2073D000,
	69, "vgmark_bench3_aa",                   vgmark_bench3_aa,      		640, 480, (char*)0x2073D000,
	70, "vgmark_bench4",                      vgmark_bench4,         		640, 480, (char*)0x2073D000,
	71, "vgmark_bench4_aa",                   vgmark_bench4_aa,      		640, 480, (char*)0x2073D000,
	72, "vgmark_bench5",                      vgmark_bench5,        		640, 480, (char*)0x2073D000, 
	73, "vgmark_bench5_aa",                   vgmark_bench5_aa,      		640, 480, (char*)0x2073D000,
	//3dmarkmobile06_v11
	74, "samurai_aa",	                       	samurai_aa, 864, 480, (char*)0x22FA2000,                                                       
	75, "samurai_noaa",												samurai_noaa, 864, 480, (char*)0x22FA2000,       
	76, "samurai_nopvrtc",							    	samurai_nopvrtc,  800, 480, (char*)0x20A71000,                                                       
	77, "samurai_pvrtc",											samurai_pvrtc, 800, 480, (char*)0x20A71000,  
	//openvg_test
	78, "tigermark_2x2aa",	                       	tigermark_2x2aa, 864, 480, (char*)0x20902000,                                                       
	79, "tigermark_mraa",												tigermark_mraa, 864, 480, (char*)0x20902000,       
	80, "tigermark_noaa",							    	tigermark_noaa,  800, 480, (char*)0x204FB000,           
#endif 	
	
}; /* end of vector list */

#endif /* __SGX540_VECTOR_LIST_H__ */

