/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : rotator_test.c
*  
*	File Description : This file includes the test code for rotator.
*
*	Author : Wonjoon JANG
*	Dept. : AP Development Team
*	Created Date : 2007/01/25
*	Version : 0.1a 
* 
*	History
*	- 
* 	- 
*  
**************************************************************************************/


#include "system.h"
#include "library.h"
#include "util.h"
#include "lcd.h"
#include "glib.h"
#include "rotator.h"
#include "def.h"
//#include "def_MM.h"

#include "intc.h"
//#include "fimc.h"
#include "timer.h"
#include "sysc.h"
#include "option.h"
#include "sblock.h"
#include "gpio.h"
#include "rtc.h"

extern void __irq Isr_LcdUnderRun0 (void);

static void DisplayInitLCD(IMG_FMT eBpp)
{

	int i,j;
	u32 *tmp;

	//#if TARGET==SYSTEM_6440
	GPIO_Init();
	//GPIO_SetFunctionForLts222QLdi();
	//#endif

	//jhy20090326
	//BYPASS_ -> DISP_BYPASS
	//IEIP_Select(DISP_BYPASS);
	SYSC_SetDispPath(eDISP_BYPASS);


	LCDC_Stop();
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBpp, CODEC_MEM_ST, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);


	#if 0 	// JWJ
	GLIB_InitInstance(CODEC_MEM_ST, 800, 480, eBpp);
	GLIB_DrawPattern(800, 480);
	GLIB_PutLine(0, 0, 0, 480-1, 3);
	#endif
	#if 0 	// JWJ
	GLIB_InitInstance(CODEC_MEM_ST, 800, 480, eBpp);
	GLIB_DrawPattern(800, 480);
	GLIB_PutLine(0, 0, 0, 480-1, 3);
	#endif

	#if 1 	// JWJ
	GLIB_InitInstance(CODEC_MEM_ST, 800, 480, eBpp);
	GLIB_DrawPattern(480, 800);
	GLIB_PutLine(0, 0, 0, 800-1, 3);
	#endif
	
	LCDC_Start();	

	#if 0
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBpp, CODEC_MEM_ST, WIN0, false);	
	LCDC_Start();	
	#endif

	#if 0
	tmp=(u32 *)FRAMEBUFFER_ADDR;	
	for(i=0;i<800;i++)
	{
		for(j=0;j<480;j++)tmp[i*480+j]=0;
	}
	#endif

}


void InitSysconForRot(void)
{
	// Default Path
	SYSC_InitClkForMM();
	// Clock Off & ON
	SYSC_SetClkOFF_IP(eROTATOR);
	DelayfrTimer(milli, 10);
	SYSC_SetClkON_IP(eROTATOR);

	SYSC_SetBlockPowerOFF_IP(eROTATOR);
	DelayfrTimer(milli, 10);
	SYSC_SetBlockPowerON_IP(eROTATOR);

}


void TestRotatorRGB565(void)
{
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	ROTATOR_ROT_TYPE eRotType;

	UART_Printf("Rotation Test RGB 565!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	if(eBpp != RGB16) eBpp=RGB16;
	if(uLcdFbAddr0 != uRotDstAddr) uRotDstAddr=uLcdFbAddr0;	
	ROTATOR_InitLcd(eWin, eBpp);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, eBpp);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();

	for(i=0; i<5; i++) {
		switch(i) {
			case 0 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_90;
				UART_Printf("Press any key to test 90 Rotation!\n");
				break;
			case 1 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_ROT_180;
				UART_Printf("Press any key to test 180 Rotation!\n");
				break;
			case 2 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_270;
				UART_Printf("Press any key to test 270 Rotation!\n");
				break;
			case 3 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_HOR;
				UART_Printf("Press any key to test X FLIP!\n");
				break;
			case 4 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_VER;
				UART_Printf("Press any key to test Y FLIP!\n");
				break;
			#if 0		// Not Support
			case 5 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_NONE;
				UART_Printf("Press any key to test No Rotate & Flip!\n");
				break;	
			#endif	
			default :
				break;				
		}	
		UART_Getc();
		ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();
		ROTATOR_CheckIntDone(); 


	}	

	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}

void TestRotatorRGB888(void)
{
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	ROTATOR_ROT_TYPE eRotType;

	UART_Printf("Rotation Test RGB 888!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	if(eBpp != RGB24) eBpp=RGB24;
	if(uLcdFbAddr0 != uRotDstAddr) uRotDstAddr=uLcdFbAddr0;	
	ROTATOR_InitLcd(eWin, eBpp);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, eBpp);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();

	for(i=0; i<5; i++) {
		switch(i) {
			case 0 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_90;
				UART_Printf("Press any key to test 90 Rotation!\n");
				break;
			case 1 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_ROT_180;
				UART_Printf("Press any key to test 180 Rotation!\n");
				break;
			case 2 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_270;
				UART_Printf("Press any key to test 270 Rotation!\n");
				break;
			case 3 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_HOR;
				UART_Printf("Press any key to test X FLIP!\n");
				break;
			case 4 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_VER;
				UART_Printf("Press any key to test Y FLIP!\n");
				break;
			default :
				break;				
		}	
		UART_Getc();
		ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();
		ROTATOR_CheckIntDone(); 


	}	

	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}


void TestRotatorARGB888(void)
{
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	ROTATOR_ROT_TYPE eRotType;

	UART_Printf("Rotation Test RGB 888!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	if(eBpp != RGB24) eBpp=RGB24;
	if(uLcdFbAddr0 != uRotDstAddr) uRotDstAddr=uLcdFbAddr0;	
	ROTATOR_InitLcd(eWin, eBpp);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, ARGB8888);
	GLIB_DrawPattern_Alpha(uLcdWidth, uLcdHeight, ARGB8888);
	
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, eBpp);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();

	for(i=0; i<5; i++) {
		switch(i) {
			case 0 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_90;
				UART_Printf("Press any key to test 90 Rotation!\n");
				break;
			case 1 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_ROT_180;
				UART_Printf("Press any key to test 180 Rotation!\n");
				break;
			case 2 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_270;
				UART_Printf("Press any key to test 270 Rotation!\n");
				break;
			case 3 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_HOR;
				UART_Printf("Press any key to test X FLIP!\n");
				break;
			case 4 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_VER;
				UART_Printf("Press any key to test Y FLIP!\n");
				break;
			default :
				break;				
		}	
		UART_Getc();
		ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();
		ROTATOR_CheckIntDone(); 


	}	

	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}


void TestRotatorYC420(void)
{
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;


	//u32 uLcdWidth, uLcdHeight;
	//LCD_GetFrmSz(&uLcdWidth, &uLcdHeight, 0);
	//LCD_GetFbAddr(&uLcdFbAddr, 0);

	UART_Printf("Rotation Test YC420!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	ROTATOR_InitLcd(eWin, RGB24);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, RGB24);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();


	eBpp=YC420;
	uRotDstAddr= _DRAM_BaseAddress + 0x06000000;
	uOrgFbAddr= _DRAM_BaseAddress + 0x06800000;


	for(i=0; i<5; i++) {
		switch(i) {
			case 0 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_90;
				UART_Printf("Press any key to test 90 Rotation!\n");
				break;
			case 1 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_ROT_180;
				UART_Printf("Press any key to test 180 Rotation!\n");
				break;
			case 2 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_270;
				UART_Printf("Press any key to test 270 Rotation!\n");
				break;
			case 3 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_HOR;
				UART_Printf("Press any key to test X FLIP!\n");
				break;
			case 4 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_VER;
				UART_Printf("Press any key to test Y FLIP!\n");
				break;
			default :
				break;				
		}	
		UART_Getc();
		ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
		ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();
		ROTATOR_CheckIntDone();
		ROTATOR_ConvertColorSpace(eBpp, uRotDstAddr, uLcdWidth, uLcdHeight, RGB24, uLcdFbAddr0);	
	}	

	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}

void TestRotatorYCbCr422_1P(void)
{
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;


	//u32 uLcdWidth, uLcdHeight;
	//LCD_GetFrmSz(&uLcdWidth, &uLcdHeight, 0);
	//LCD_GetFbAddr(&uLcdFbAddr, 0);

	UART_Printf("Rotation Test YC422!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	ROTATOR_InitLcd(eWin, RGB24);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, RGB24);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();


	//eBpp=YCRYCB; // for POST Processor, CbYCrY
	eBpp=CBYCRY;
	uRotDstAddr= _DRAM_BaseAddress + 0x06000000;
	uOrgFbAddr= _DRAM_BaseAddress + 0x06800000;


	for(i=0; i<5; i++) {
		switch(i) {
			case 0 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_90;
				UART_Printf("Press any key to test 90 Rotation!\n");
				break;
			case 1 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_ROT_180;
				UART_Printf("Press any key to test 180 Rotation!\n");
				break;
			case 2 :
				usRotHorSize=(u16)uLcdHeight;
				usRotVerSize=(u16)uLcdWidth;
				eRotType=ROTATOR_TYPE_ROT_270;
				UART_Printf("Press any key to test 270 Rotation!\n");
				break;
			case 3 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_HOR;
				UART_Printf("Press any key to test X FLIP!\n");
				break;
			case 4 :
				usRotHorSize=(u16)uLcdWidth;
				usRotVerSize=(u16)uLcdHeight;
				eRotType=ROTATOR_TYPE_FLIP_VER;
				UART_Printf("Press any key to test Y FLIP!\n");
				break;
			default :
				break;				
		}	
		UART_Getc();
		ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
		ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();
		ROTATOR_CheckIntDone();
		ROTATOR_ConvertColorSpace(eBpp, uRotDstAddr, uLcdWidth, uLcdHeight, RGB24, uLcdFbAddr0);	
	}	

	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}



void TestRotatorInterruptRGB565(void)
{
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;

	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);

	UART_Printf("Width:%d, Height:%d\n", usRotHorSize, usRotVerSize);

	ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, ROTATOR_TYPE_ROT_90);
	ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	
	
	ROTATOR_Start();
	ROTATOR_CheckIntDone();
	UART_Printf("Rotation with Interrupt is finished!\n");
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();	

}

void TestRotatorStatusRGB565(void)
{
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	volatile u32 uSTATCFG;


	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);

	UART_Printf("Width:%d, Height:%d\n", usRotHorSize, usRotVerSize);

	ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, ROTATOR_TYPE_ROT_90);
	ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
	
	ROTATOR_Start();
	ROTATOR_CheckDone();
	UART_Printf("Rotation without Interrupt is finished!\n");
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();	

}

void TestRotatorOneMoreJob(void)
{
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr0, uRotDstAddr0;
	u32 uRotSrcAddr1, uRotDstAddr1;
	u32 uSTATCFG;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	ROTATOR_ROT_TYPE eRotType;


	UART_Printf("Rotation Audit Test with All Size!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_RotatorOneMoreJob);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_Stop();

	uWidth=2048;
	uHeight=2048;
	usRotHorSize=usRotVerSize=2048;
	uRotSrcAddr0=  _DRAM_BaseAddress + 0x01000000;
	uRotDstAddr0= uRotSrcAddr0 + uWidth*uHeight*2;
	uRotSrcAddr1= uRotDstAddr0 + uWidth*uHeight*2;
	uRotDstAddr1= uRotSrcAddr1 + uWidth*uHeight*2;

	eBpp=RGB16;
	eRotType=ROTATOR_TYPE_ROT_90;
	ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr0);	
	ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr1);	
	UART_Printf("Setting Rotation\n");			
	ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr0, uRotDstAddr0, eRotType);
	ROTATOR_Start();

	uSTATCFG=Inp32(0xFB10002c); //read STATCFG
	UART_Printf("STATCFG:0x%x\n", uSTATCFG);

	ROTATOR_SetSrcAddr(eBpp, uRotSrcAddr1, usRotHorSize, usRotVerSize);
	ROTATOR_SetDstAddr(eBpp, uRotDstAddr1, usRotHorSize, usRotVerSize);
	ROTATOR_Start();

	uSTATCFG=Inp32(0xFB10002c); //read STATCFG
	UART_Printf("STATCFG:0x%x\n", uSTATCFG);

	ROTATOR_CheckIntDone();
	if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr0, uRotDstAddr0)) 
		UART_Printf("Rotation Error 0!\n");
	
	ROTATOR_CheckIntDone();
	if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr1, uRotDstAddr1)) 
		UART_Printf("Rotation Error 1!\n");

	UART_Printf("Test OK!\n");
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

}



u8 ROTATOR_AutoTest(void)
{
	u32 i,j,k,l;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;
	u32 aImgSizeList[12][2] = {{320, 240}, {480, 272}, {640, 480}, {800, 480}, {800, 600},{1024, 768},{1280,1024},{1600, 1200},{720,480},{720,576},{1920,1280},{1280,720} };
	//u32 aDataType[4] ={RGB16,RGB24,YC420,YCBYCR };
	//u32 aDataType[3] ={RGB16,RGB24,YCBYCR };
	u32 uNumList;
	

	u8 bFlagOrder=TRUE;


	ROTATOR_Init(ROTATOR_TEST_MODE);	



	UART_Printf("Rotation Auto Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

//	LCD_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
//	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
//	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
//	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
//	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
//	eWin=WIN0;
//	ROTATOR_InitLcd(eWin, RGB24);
//	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, RGB24);
//	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
//	LCD_Start();
//	eBpp=YCRYCB; // for POST Processor, CbYCrY


	for(uNumList=0; uNumList<1;uNumList++)
	{
	//uWidth=aImgSizeList[uNumList][0];
	//uHeight=aImgSizeList[uNumList][1];

	uWidth=320;
	uHeight=240;
	uOrgFbAddr= _DRAM_BaseAddress + 0x01000000;
	uRotSrcAddr= uOrgFbAddr  + uWidth*uHeight*4;
	uRotDstAddr= uRotSrcAddr + uWidth*uHeight*4;

	for(j=0; j<4; j++) {
	//r(j=0; j<4; j++) {
	//for(j=0; j<3; j++) {
	
		//eBpp = aDataType[j];	
		eBpp=	(j==0) ? RGB16:
				(j==1) ? RGB24:
				(j==2) ? YC420: YCBYCR;	

				
		//r(i=0; i<5; i++) {
		for(i=0; i<1; i++) {	
			eRotType=	(i==0) ? ROTATOR_TYPE_ROT_90:
						(i==1) ? ROTATOR_TYPE_ROT_180:
						(i==2) ? ROTATOR_TYPE_ROT_270:
						(i==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
			switch(eRotType) {
				case ROTATOR_TYPE_ROT_90 :
				case ROTATOR_TYPE_ROT_270 :					
					usRotHorSize=(u16)uHeight;
					usRotVerSize=(u16)uWidth;
 					break;
				case ROTATOR_TYPE_ROT_180 :
				case ROTATOR_TYPE_FLIP_HOR :
				case ROTATOR_TYPE_FLIP_VER :
					usRotHorSize=(u16)uWidth;
					usRotVerSize=(u16)uHeight;
 					break;
 				default :
					break;				
			}
			if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[ BPP=%d, ROTATION=%d]\n", uNumList,eBpp, eRotType); bFlagOrder=true;}
			else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=false;}
			if(eBpp==YC420 || eBpp== YCBYCR) {
				ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
				ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
			}
			else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
			
			ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
			ROTATOR_Start();
			ROTATOR_CheckIntDone();
			if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
				UART_Printf("Rotation Error!\n");
				bFlagOrder=FALSE;
				return FALSE;
				UART_Getc();
			}
			for(l=0; l<0; l++) {
			//for(l=0; l<4; l++) {
			//for(l=0; l<3; l++) {
	
				//eBpp = aDataType[l];		
				eBpp=	(l==0) ? RGB16:
						(l==1) ? RGB24:
						(l==2) ? YC420: YCBYCR;				
				for(k=0; k<1; k++) {
				//for(k=0; k<5; k++) {
					eRotType=	(k==0) ? ROTATOR_TYPE_ROT_90:
								(k==1) ? ROTATOR_TYPE_ROT_180:
								(k==2) ? ROTATOR_TYPE_ROT_270:
								(k==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
					switch(eRotType) {
						case ROTATOR_TYPE_ROT_90 :
						case ROTATOR_TYPE_ROT_270 :					
							usRotHorSize=(u16)uHeight;
							usRotVerSize=(u16)uWidth;
		 					break;
						case ROTATOR_TYPE_ROT_180 :
						case ROTATOR_TYPE_FLIP_HOR :
						case ROTATOR_TYPE_FLIP_VER :
							usRotHorSize=(u16)uWidth;
							usRotVerSize=(u16)uHeight;
		 					break;
		 				default :
							break;				
					}
					if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=true;}
					else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n", uNumList, eBpp, eRotType); bFlagOrder=false;}
					if(eBpp==YC420 || eBpp== YCBYCR) {
						ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
						ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
					}
					else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
					
					ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
					ROTATOR_Start();
					ROTATOR_CheckIntDone();
					if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
						UART_Printf("Rotation Error!\n");
						bFlagOrder=FALSE;
						return FALSE;
						UART_Getc();
					}
				}	
			}			
		}	
	}
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

	if(bFlagOrder==TRUE) 
	{
		UART_Printf("Test OK!\n");
		return TRUE;		
	}
	else return FALSE;
	

}


u8 ROTATOR_FullTest(void)
{
	u32 i,j,k,l;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;
	//u32 aImgSizeList[12][2] = {{320, 240}, {480, 272}, {640, 480}, {800, 480}, {800, 608},{1024, 768},{1280,1024},{1600, 1200},{720,480},{720,576},{1920,1280},{1280,720} };
	u32 aImgSizeList[14][2] = {{16,16},{320, 240}, {480, 272}, {640, 480}, {800, 480}, {800, 608},{1024, 768},{1280,1024},{1600, 1200},{720,480},{720,576},{1920,1280},{1280,720},{2048, 2048} };
	u32 aDataType[4] ={RGB16,RGB24,YC420,YCBYCR };
	//u32 aDataType[3] ={RGB16,RGB24,YCBYCR };
	u32 uNumList;
	

	u8 bFlagOrder=TRUE;


	ROTATOR_Init(ROTATOR_TEST_MODE);	



	UART_Printf("Rotation Auto Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

//	LCD_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
//	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
//	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
//	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
//	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
//	eWin=WIN0;
//	ROTATOR_InitLcd(eWin, RGB24);
//	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, RGB24);
//	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
//	LCD_Start();
//	eBpp=YCRYCB; // for POST Processor, CbYCrY


	for(uNumList=0; uNumList<14;uNumList++)
	{
	uWidth=aImgSizeList[uNumList][0];
	uHeight=aImgSizeList[uNumList][1];

	//uWidth=320;
	//uHeight=240;
	uOrgFbAddr= _DRAM_BaseAddress + 0x01000000;
	uRotSrcAddr= uOrgFbAddr  + uWidth*uHeight*4;
	uRotDstAddr= uRotSrcAddr + uWidth*uHeight*4;

	for(j=0; j<4; j++) {
	//r(j=0; j<4; j++) {
	//for(j=0; j<3; j++) {
	
		eBpp = aDataType[j];	
		eBpp=	(j==0) ? RGB16:
				(j==1) ? RGB24:
				(j==2) ? YC420: YCBYCR;	

				
		for(i=0; i<5; i++) {
		//for(i=0; i<1; i++) {	
			eRotType=	(i==0) ? ROTATOR_TYPE_ROT_90:
						(i==1) ? ROTATOR_TYPE_ROT_180:
						(i==2) ? ROTATOR_TYPE_ROT_270:
						(i==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
			switch(eRotType) {
				case ROTATOR_TYPE_ROT_90 :
				case ROTATOR_TYPE_ROT_270 :					
					usRotHorSize=(u16)uHeight;
					usRotVerSize=(u16)uWidth;
 					break;
				case ROTATOR_TYPE_ROT_180 :
				case ROTATOR_TYPE_FLIP_HOR :
				case ROTATOR_TYPE_FLIP_VER :
					usRotHorSize=(u16)uWidth;
					usRotVerSize=(u16)uHeight;
 					break;
 				default :
					break;				
			}
			if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[ BPP=%d, ROTATION=%d]\n", uNumList,eBpp, eRotType); bFlagOrder=true;}
			else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=false;}
			if(eBpp==YC420 || eBpp== YCBYCR) {
				ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
				ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
			}
			else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
			
			ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
			ROTATOR_Start();
			ROTATOR_CheckIntDone();
			if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
				UART_Printf("Rotation Error!\n");
				bFlagOrder=FALSE;
				return FALSE;
				UART_Getc();
			}
			//for(l=0; l<0; l++) {
			for(l=0; l<4; l++) {
			//for(l=0; l<3; l++) {
	
				eBpp = aDataType[l];		
				eBpp=	(l==0) ? RGB16:
						(l==1) ? RGB24:
						(l==2) ? YC420: YCBYCR;				
				//for(k=0; k<1; k++) {
				for(k=0; k<5; k++) {
					eRotType=	(k==0) ? ROTATOR_TYPE_ROT_90:
								(k==1) ? ROTATOR_TYPE_ROT_180:
								(k==2) ? ROTATOR_TYPE_ROT_270:
								(k==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
					switch(eRotType) {
						case ROTATOR_TYPE_ROT_90 :
						case ROTATOR_TYPE_ROT_270 :					
							usRotHorSize=(u16)uHeight;
							usRotVerSize=(u16)uWidth;
		 					break;
						case ROTATOR_TYPE_ROT_180 :
						case ROTATOR_TYPE_FLIP_HOR :
						case ROTATOR_TYPE_FLIP_VER :
							usRotHorSize=(u16)uWidth;
							usRotVerSize=(u16)uHeight;
		 					break;
		 				default :
							break;				
					}
					if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=true;}
					else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n", uNumList, eBpp, eRotType); bFlagOrder=false;}
					if(eBpp==YC420 || eBpp== YCBYCR) {
						ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
						ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
					}
					else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
					
					ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
					ROTATOR_Start();
					ROTATOR_CheckIntDone();
					if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
						UART_Printf("Rotation Error!\n");
						bFlagOrder=FALSE;
						return FALSE;
						UART_Getc();
					}
				}	
			}			
		}	
	}
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

	if(bFlagOrder==TRUE) 
	{
		UART_Printf("Test OK!\n");
		return TRUE;		
	}
	else return FALSE;
	

}


u8 ROTATOR_SizeTest(void)
{
	u32 i,j,k,l;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;
	u32 aImgSizeList[14][2] = {{16,16},{320, 240}, {480, 272}, {640, 480}, {800, 480}, {800, 608},{1024, 768},{1280,1024},{1600, 1200},{720,480},{720,576},{1920,1280},{1280,720},{2048, 2048} };
	u32 uNumList;
	u32 aDataType[4] ={RGB16,RGB24,YC420,YCBYCR };
	//u32 aDataType[3] ={RGB16,RGB24,YCBYCR };
	
	u8 bFlagOrder=TRUE;


	ROTATOR_Init(ROTATOR_TEST_MODE);	



	UART_Printf("Rotation Size Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

//	LCDC_Stop();

	for(uNumList=0; uNumList<14;uNumList++)
	{
	uWidth=aImgSizeList[uNumList][0];
	uHeight=aImgSizeList[uNumList][1];

	//uWidth=320;
	//uHeight=240;
	uOrgFbAddr= _DRAM_BaseAddress + 0x01000000;
	uRotSrcAddr= uOrgFbAddr  + uWidth*uHeight*4;
	uRotDstAddr= uRotSrcAddr + uWidth*uHeight*4;

	for(j=0; j<4; j++) {
	//for(j=0; j<3; j++) {
	
		eBpp = aDataType[j];
			
		eBpp=	(j==0) ? RGB16:
				(j==1) ? RGB24:
				(j==2) ? YC420: YCBYCR;				
			
				
		for(i=0; i<5; i++) {
			eRotType=	(i==0) ? ROTATOR_TYPE_ROT_90:
						(i==1) ? ROTATOR_TYPE_ROT_180:
						(i==2) ? ROTATOR_TYPE_ROT_270:
						(i==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
			switch(eRotType) {
				case ROTATOR_TYPE_ROT_90 :
				case ROTATOR_TYPE_ROT_270 :					
					usRotHorSize=(u16)uHeight;
					usRotVerSize=(u16)uWidth;
 					break;
				case ROTATOR_TYPE_ROT_180 :
				case ROTATOR_TYPE_FLIP_HOR :
				case ROTATOR_TYPE_FLIP_VER :
					usRotHorSize=(u16)uWidth;
					usRotVerSize=(u16)uHeight;
 					break;
 				default :
					break;				
			}
			UART_Printf("Size[%d][BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType);
			
			if(eBpp==YC420 || eBpp== YCBYCR) {
				ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
				ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
			}
			else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
			
			ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
			ROTATOR_Start();
			ROTATOR_CheckIntDone();
			if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
				UART_Printf("Rotation Error!\n");
				bFlagOrder=FALSE;
				return FALSE;
				UART_Getc();
			}
					
		}	
	}
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

	if(bFlagOrder==TRUE) 
	{
		printf("Test OK!\n");
		return TRUE;		
	}
	else return FALSE;

}



u8 ROTATOR_CLKONOFF(void)
{
	u32 i,j,k,l;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;
	//u32 aImgSizeList[12][2] = {{320, 240}, {480, 272}, {640, 480}, {800, 480}, {800, 600},{1024, 768},{1280,1024},{1600, 1200},{720,480},{720,576},{1920,1280},{1280,720} };
	//u32 aDataType[4] ={RGB16,RGB24,YC420,YCBYCR };
	//u32 aDataType[3] ={RGB16,RGB24,YCBYCR };
	u32 uNumList, uNumErr =0;
	u32 uNumtest =0;
	
	u8 bFlagOrder=TRUE;


	ROTATOR_Init(ROTATOR_TEST_MODE);	

	UART_Printf("Rotator Clock ON/OFF Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_Stop();

	while(!UART_GetKey())
	{

	uNumtest++;

	if(uNumtest%100 == 0) (UART_Printf("Test No(err) : %d(%d) \n", uNumtest));

	for(uNumList=0; uNumList<1;uNumList++)
	{
	//uWidth=aImgSizeList[uNumList][0];
	//uHeight=aImgSizeList[uNumList][1];

	uWidth=320;
	uHeight=240;
	uOrgFbAddr= _DRAM_BaseAddress + 0x01000000;
	uRotSrcAddr= uOrgFbAddr  + uWidth*uHeight*4;
	uRotDstAddr= uRotSrcAddr + uWidth*uHeight*4;

	for(j=0; j<4; j++) {
	//for(j=0; j<3; j++) {
	
		//eBpp = aDataType[j];	
		eBpp=	(j==0) ? RGB16:
				(j==1) ? RGB24:
				(j==2) ? YC420: YCBYCR;	

				
		for(i=0; i<5; i++) {
			eRotType=	(i==0) ? ROTATOR_TYPE_ROT_90:
						(i==1) ? ROTATOR_TYPE_ROT_180:
						(i==2) ? ROTATOR_TYPE_ROT_270:
						(i==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
			switch(eRotType) {
				case ROTATOR_TYPE_ROT_90 :
				case ROTATOR_TYPE_ROT_270 :					
					usRotHorSize=(u16)uHeight;
					usRotVerSize=(u16)uWidth;
 					break;
				case ROTATOR_TYPE_ROT_180 :
				case ROTATOR_TYPE_FLIP_HOR :
				case ROTATOR_TYPE_FLIP_VER :
					usRotHorSize=(u16)uWidth;
					usRotVerSize=(u16)uHeight;
 					break;
 				default :
					break;				
			}
			if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[ BPP=%d, ROTATION=%d]\n", uNumList,eBpp, eRotType); bFlagOrder=true;}
			else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=false;}
			if(eBpp==YC420 || eBpp== YCBYCR) {
				ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
				ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
			}
			else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
			
			ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);

			SYSC_SetClkOFF_IP(eROTATOR);
			DelayfrTimer(milli, 10);
			SYSC_SetClkON_IP(eROTATOR);
			
			ROTATOR_Start();
			ROTATOR_CheckIntDone();
			if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
				UART_Printf("Rotation Error!\n");
				bFlagOrder=FALSE;
				uNumErr++;
				return FALSE;
				//UART_Getc();
			}
			for(l=0; l<4; l++) {
			//for(l=0; l<3; l++) {
	
				//eBpp = aDataType[l];		
				eBpp=	(l==0) ? RGB16:
						(l==1) ? RGB24:
						(l==2) ? YC420: YCBYCR;				
				for(k=0; k<5; k++) {
					eRotType=	(k==0) ? ROTATOR_TYPE_ROT_90:
								(k==1) ? ROTATOR_TYPE_ROT_180:
								(k==2) ? ROTATOR_TYPE_ROT_270:
								(k==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
					switch(eRotType) {
						case ROTATOR_TYPE_ROT_90 :
						case ROTATOR_TYPE_ROT_270 :					
							usRotHorSize=(u16)uHeight;
							usRotVerSize=(u16)uWidth;
		 					break;
						case ROTATOR_TYPE_ROT_180 :
						case ROTATOR_TYPE_FLIP_HOR :
						case ROTATOR_TYPE_FLIP_VER :
							usRotHorSize=(u16)uWidth;
							usRotVerSize=(u16)uHeight;
		 					break;
		 				default :
							break;				
					}
					if(bFlagOrder==false) {UART_Printf("Size[%d]<Before>[BPP=%d, ROTATION=%d]\n",uNumList, eBpp, eRotType); bFlagOrder=true;}
					else {UART_Printf("Size[%d]	<After >[BPP=%d, ROTATION=%d]\n", uNumList, eBpp, eRotType); bFlagOrder=false;}
					if(eBpp==YC420 || eBpp== YCBYCR) {
						ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
						ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
					}
					else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
					
					ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);

					SYSC_SetClkOFF_IP(eROTATOR);
					DelayfrTimer(milli, 10);
					SYSC_SetClkON_IP(eROTATOR);

					ROTATOR_Start();
					ROTATOR_CheckIntDone();
					if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
						UART_Printf("Rotation Error!\n");
						bFlagOrder=FALSE;
						uNumErr++;
						return FALSE;
						//UART_Getc();
					}
				}	
			}			
		}	
	}
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();


	if(bFlagOrder==TRUE) 
	{
		printf("Test OK!\n");
		return TRUE;		
	}
	else return FALSE;
	}
}

u8 ROTATOR_BLKPwrONOFF(void)
{

	u32  uNumErr =0;
	u32 uNumtest =0;
	
	u8 bFlagOrder=TRUE;

	UART_Printf("Rotator Block Power ON/OFF Test!!\n");
	
	while(!UART_GetKey())
	{

	uNumtest++;
	if(uNumtest%100 == 0) (UART_Printf("Test No(err) : %d(%d) \n", uNumtest));

	bFlagOrder= ROTATOR_AutoTest();
	SYSC_SetBlockPowerOFF_IP(eROTATOR);
	DelayfrTimer(milli, 10);
	SYSC_SetBlockPowerON_IP(eROTATOR);
	
	if(bFlagOrder==TRUE) 
	{
		//printf("Test OK!\n");
	}
	else
	{
		uNumErr++;
	}
      }

	if(uNumErr == 0)	return TRUE;
	else return FALSE;

	
}

void __irq Isr_RtcAlamForTest(void)
{
	INTC_Disable(NUM_RTC_ALARM);
	RTC_ClearPending(ALARM);
	
	//uAlarm=true;
	//UART_Printf("\nRTC Alarm Occur!!!\n");	

	INTC_ClearVectAddr();
}

static __irq void Isr_EInt4_(void)
{
	Disp("EINT4 ISR\n");

	// interrupt clear in EINT SFR
	GPIO_EINT30ClrPend(4);
	INTC_ClearVectAddr();
}

void TestSimplePowerMode_Temp(u32 PowerMode)
{
	u32 uSelMode, uSelAging;
	u32 uInformReg, uAgingCnt;
	u8	ucSelTop, ucSelL2;
	POWER_MODE ePwrMode;
	WAKEUP_ID eWakeupSrc, eEintWakeup;
	u32 uEintNum;

	// Clear wakeup status..
	SYSC_ClearWakeupStatus(eWAKEUP_ALL);
	
	INTC_SetVectAddr(NUM_EINT4, Isr_EInt4_);
	GPIO_SetFunctionEach(eGPIO_H0, eGPIO_4, eGINT);
	GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_4, eGPUDdis);
	GPIO_SetEint30(4, Both_Edge, eDisFLT, 0x1f); // EINT1, falling edge, enable filter, filter width
	GPIO_EINT30UnMask(4);
	eEintWakeup = eWAKEUP_EINT4;
	uEintNum = NUM_EINT4;

	INTC_SetVectAddr(NUM_RTC_ALARM, Isr_RtcAlamForTest); // for aging test 

	eWakeupSrc = eWAKEUP_EINT;

	// Set all wakeup source 
	SYSC_SetWakeupMask(eWAKEUP_ALL , TRUE); // mask all wakeup sources
	SYSC_SetWakeupMask(eWAKEUP_EINT4 , FALSE); // unmask wakeup sources
	SYSC_SetWakeupMask(eWAKEUP_RTCALARM, FALSE); // unmask wakeup sources
	SYSC_SetWakeupMask(eWAKEUP_CEC , FALSE); // unmask wakeup sources

	SYSC_SetSleepGPIO(); // use deep(top off/retention) & sleep mode

	// Select mode configurations
	//Disp("Select Test mode : 1.Idle(D), 2.DeepIdle, 3.Stop, 4.DeepStop, 5.Sleep, 6.S/W reset\n");
	uSelMode = PowerMode;

	//Disp("Select Top module status(DeepIdle/DeepStop only) : 0.Off, 1.Retention(D), 2.On \n");
	ucSelTop = 1;

	if ((ucSelTop!=0)) 
		ucSelL2 = 1;
	else 
		ucSelL2 = 0;

	if ((ucSelTop>2)||(ucSelTop<1)) 
		ucSelTop = 1; // default retention
 
	//Disp("Select Aging : 1.General(D), 2.Aging\n");
	uSelAging = 1;
	uSelAging = (uSelAging != 2) ? 1 : 2;	// default	General

	// Implement configuration
	switch(uSelMode)
	{
		case 1:
			ePwrMode = eMODE_IDLE;
			SYSC_SetClkOut(eCLKOUT_ARMCLK_DIV4, 2); // ARMCLK / 8
			SYSC_SetIdleModeConfig(ucSelTop, ucSelTop, ucSelL2, eCFG_NODEEP);
			uInformReg |= INFORM_IDLE;
			break;
		case 2 :
			ePwrMode = eMODE_DEEPIDLE;
			SYSC_SetClkOut(eCLKOUT_ARMCLK_DIV4, 2); // ARMCLK / 8
			SYSC_SetIdleModeConfig(ucSelTop, ucSelTop, ucSelL2, eCFG_DEEP);
			uInformReg |= INFORM_DIDLE;	// 0x2x = deep idle mode
			break;
		case 3 :
			ePwrMode = eMODE_STOP;
			SYSC_SetClkOut(eCLKOUT_HCLKDSYS, 2); 
			SYSC_SetStopModeConfig(ucSelTop, (u8)eCFG_RET, ucSelL2, eCFG_NODEEP);
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_MAIN, true);
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_USB, true);
			uInformReg |= INFORM_STOP;	// 0x3x = stop mode
			break;
		case 4 :
			ePwrMode = eMODE_DEEPSTOP;
			SYSC_SetClkOut(eCLKOUT_HCLKDSYS, 2); 
			SYSC_SetStopModeConfig(ucSelTop, (u8)eCFG_RET, ucSelL2, eCFG_DEEP);
			SYSC_SetStopMemConfig(eMEMCFG_ALL, ucSelL2);			
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_MAIN, true);
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_USB, true);
			uInformReg |= INFORM_DSTOP;	// 0x4x = deep stop mode
			break;
		case 5 :
			ePwrMode = eMODE_SLEEP;
			SYSC_SetClkOut(eCLKOUT_HCLKDSYS, 2); 
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_MAIN, true);
			SYSC_SetOscPadOnOff(ePwrMode, eOSC_USB, true);
			uInformReg |= INFORM_SLEEP;	// 0x5x = sleep mode
			break;
		case 6 :
			SYSC_SwReset();
			uInformReg |= INFORM_SWRST;
			break;
		default:
			ePwrMode = eMODE_IDLE;
			SYSC_SetClkOut(eCLKOUT_ARMCLK_DIV4, 2); // ARMCLK / 8
			SYSC_SetIdleModeConfig(ucSelTop, ucSelTop, ucSelL2, eCFG_NODEEP);
			uInformReg |= INFORM_IDLE;	// 0x1x = Idle mode
			break;
	}

	UART_Printf("Enter Power Mode\n");
	SYSC_SetInformReg(5, uInformReg); 	// Power Mode


	if ( (ePwrMode==eMODE_IDLE)||(ePwrMode==eMODE_STOP) )
	{
		GPIO_EINT30ClrPend(1);
		INTC_Enable(uEintNum); // Set interrupt controller enable
	}

	SYSC_StartPowerMode(ePwrMode, SW_WFI, USER_CONFIG); // selected power mode, selected enterfing method, Set user config

	INTC_Disable(uEintNum); // Set interrupt controller disable

	SYSC_ClearWakeupStatus(eWakeupSrc);

	SYSC_UpdateClkInform();
	OpenConsole(3);


	Disp("Return to Normal Mode\n");
}



u8  ROTATOR_PowerMode(void)
{

	s32 uRanOffset;
	u32 i;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	LCD_WINDOW eWin;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	ROTATOR_ROT_TYPE eRotType;

	u32 uSel;

	while(!UART_GetKey())
	{

	UART_Printf("Rotator PowerMode Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

	LCDC_GetFrmSz(&uLcdWidth, &uLcdHeight, WIN0);
	ROTATOR_GetLcdFbAddr(&uLcdFbAddr0, &uLcdFbAddr1);
	ROTATOR_GetFbAddr(&uRotSrcAddr, &uRotDstAddr);
	ROTATOR_GetFrmSz(&usRotHorSize, &usRotVerSize);
	ROTATOR_GetBppMode(&eBpp);


	LCDC_Stop();
	eWin=WIN0;
	if(eBpp != RGB24) eBpp=RGB24;
	if(uLcdFbAddr0 != uRotDstAddr) uRotDstAddr=uLcdFbAddr0;	
	ROTATOR_InitLcd(eWin, eBpp);
	GLIB_InitInstance(uLcdFbAddr0, uLcdWidth, uLcdHeight, eBpp);
	GLIB_DrawPattern(uLcdWidth, uLcdHeight);	
	LCDC_Start();

	
	usRotHorSize=(u16)uLcdHeight;
	usRotVerSize=(u16)uLcdWidth;
	eRotType=ROTATOR_TYPE_ROT_90;

	SYSC_SetInformReg(7, 0xc110c110); 




		ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);

		#if 0
		ROTATOR_Start();
		DelayfrTimer(micro, SBLK_GetRand()%1000);
		TestSimplePowerMode_Temp(SBLK_GetRand()%6+1);

		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();	
		#endif
		#if 1	// Stop
		ROTATOR_Start();
		UART_Printf("1: Idle 2: Deep Idle 3:Stop 4 DeepStop 5 Sleep 6 SW reset\n");
		uSel = UART_GetIntNum();
	
		//DelayfrTimer(milli, rand()%1000);
		DelayfrTimer(micro, SBLK_GetRand()%1000);
		// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
		//SYSCT_TestSimplePowerMode_Temp(rand()%6+1);
		// 1: Idle, 2: Deep Idle, 3:Stop, 4:DeepStop, 5:Sleep, 6: SW reset
		// 1, 3 -> tested
		//SYSCT_TestSimplePowerMode_Temp(uSel);	
		TestSimplePowerMode_Temp(uSel);
		
		ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
		ROTATOR_Start();	
		#endif 
		
		SYSC_SetClkOut(eCLKOUT_ARMCLK_DIV4, 10);
		//ROTATOR_CheckIntDone(); 
	
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();
	
	return true;

	
}


u8 ROTATOR_PerfTest(void)
{
	u32 i,j,k,l;
	u16 usRotHorSize, usRotVerSize;
	u32 uRotSrcAddr, uRotDstAddr;
	IMG_FMT eBpp;
	u32 uWidth, uHeight;
	u32 uOrgFbAddr;
	ROTATOR_ROT_TYPE eRotType;
	//u32 aImgSizeList[10][2] = {{16,16},{320, 240}, {480, 272}, {640, 480},{720,480}, { 480, 800}, {1024, 768},{1280,1024},{1600, 1200},{1920,1080} };
	u32 aImgSizeList[10][2] = {{480, 800}, {1024, 768} };
	u32 aDataType[4] ={RGB16,RGB24,YC420,YCBYCR };
	u32 uNumList;
	u32 uTestTime;	

	u8 bFlagOrder=TRUE;
	u32 uLcdWidth, uLcdHeight, uLcdFbAddr0, uLcdFbAddr1;
	


	ROTATOR_Init(ROTATOR_TEST_MODE);	


	UART_Printf("Rotation Perf Test!!\n");
	
	INTC_SetVectAddr(NUM_ROTATOR, Isr_Rotator);
	INTC_Enable(NUM_ROTATOR);
	ROTATOR_IntEnable();	

#if 1
	LCDC_Stop();
#endif
#if 0
	LCDC_Start();
#endif


	for(uNumList=0; uNumList<2;uNumList++)
	//for(uNumList=0;uNumList<1;uNumList++)
	{
	uWidth=aImgSizeList[uNumList][0];
	uHeight=aImgSizeList[uNumList][1];

	uOrgFbAddr= _DRAM_BaseAddress + 0x01000000;
	uRotSrcAddr  = uOrgFbAddr+0x2000000;
	//uRotSrcAddr= uOrgFbAddr  + uWidth*uHeight*4;
	//uRotDstAddr= uRotSrcAddr + uWidth*uHeight*4;
	uRotDstAddr = uOrgFbAddr;

	for(j=0; j<4; j++) {
	
		eBpp = aDataType[j];	
		eBpp=	(j==0) ? RGB16:
				(j==1) ? RGB24:
				(j==2) ? YC420: YCBYCR;	

				
		for(i=0; i<5; i++) {
			eRotType=	(i==0) ? ROTATOR_TYPE_ROT_90:
						(i==1) ? ROTATOR_TYPE_ROT_180:
						(i==2) ? ROTATOR_TYPE_ROT_270:
						(i==3) ? ROTATOR_TYPE_FLIP_VER:	ROTATOR_TYPE_FLIP_HOR;
			switch(eRotType) {
				case ROTATOR_TYPE_ROT_90 :
				case ROTATOR_TYPE_ROT_270 :					
					usRotHorSize=(u16)uHeight;
					usRotVerSize=(u16)uWidth;
 					break;
				case ROTATOR_TYPE_ROT_180 :
				case ROTATOR_TYPE_FLIP_HOR :
				case ROTATOR_TYPE_FLIP_VER :
					usRotHorSize=(u16)uWidth;
					usRotVerSize=(u16)uHeight;
 					break;
 				default :
					break;				
			}
		#if 1
			if(eBpp==YC420 || eBpp== YCBYCR) {
				ROTATOR_DrawImage(RGB24, usRotHorSize, usRotVerSize, uOrgFbAddr);	
				ROTATOR_ConvertColorSpace(RGB24, uOrgFbAddr, usRotHorSize, usRotVerSize, eBpp, uRotSrcAddr);
			}
			else ROTATOR_DrawImage(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr);	
		#endif	
			ROTATOR_InitSetting(eBpp, usRotHorSize, usRotVerSize, uRotSrcAddr, uRotDstAddr, eRotType);
			StartTimer(0);
			ROTATOR_Start();
			ROTATOR_CheckIntDone();
			uTestTime = StopTimer(0);

			UART_Printf("Size[%dx%d], BPP[%d], ROTATION[%d] : Time[%d]us\n", aImgSizeList[uNumList][0],aImgSizeList[uNumList][1],eBpp, eRotType, uTestTime);

		//	UART_Getc();
			
			if(!ROTATOR_AuditOperation(eBpp, (u32)usRotHorSize, (u32)usRotVerSize, eRotType, uRotSrcAddr, uRotDstAddr)) {
				UART_Printf("Rotation Error!\n");
				bFlagOrder=FALSE;
				return FALSE;
				UART_Getc();
			}
	
		}	
	}
	}
	
	INTC_Disable(NUM_ROTATOR);
	ROTATOR_IntDisable();

	if(bFlagOrder==TRUE) 
	{
		UART_Printf("Test OK!\n");
		return TRUE;		
	}
	else return FALSE;
	

}




// JWJ
void __irq Isr_LcdUnderRunStop (void)
{
	u32 uIntFlag;

	LCDC_GetIntFlag(&uIntFlag);
		
	Disp(".");
	UART_Getc();
	LCDC_ClearPending(uIntFlag);
	INTC_ClearVectAddr();	

}


void Test_ROTATOR(void)
{
	testFuncMenu rotator_menu[]=
	{
		0,                             			    			"Exit\n",
		TestRotator_SFR,						"SFR R/W Test",	
		TestRotatorRGB565,						"RGB 565",	
		TestRotatorARGB888,						"ARGB888",
		TestRotatorRGB888,						"RGB 888",		
		TestRotatorYC420,						"YCbYCr 420",
		TestRotatorYCbCr422_1P,					"YCbYCr 422 1P",		
		TestRotatorStatusRGB565,				"Checking Status",
		TestRotatorInterruptRGB565,				"Checking Interrupt",		
		TestRotatorOneMoreJob,					"Rotation with One More Job",
		ROTATOR_SizeTest,						"Size Test",
		ROTATOR_FullTest,						"Full Test",		
		ROTATOR_AutoTest,						"Rotator-Auto Test\n",

		ROTATOR_CLKONOFF,						"Clock ON/OFF Test",
		ROTATOR_BLKPwrONOFF,					"BlockPower ON/OFF test",
		//ROTATOR_PowerMode,					"Power Mode Test-1time",
		ROTATOR_PerfTest,						"Performance Test",

		
		0,0
	};

	u32 i;
	s32 sSel;

	// LCDC_SetPort();
	// 
	InitSysconForRot();

	INTC_SetVectAddr(NUM_LCD0, Isr_LcdUnderRunStop);
	INTC_Enable(NUM_LCD0);

	DisplayInitLCD(RGB24);

	UART_Printf("[Graphic Rotator Test]\n\n");
	
	ROTATOR_Init(ROTATOR_TEST_MODE);	

	while(1)
	{
		for (i=0; (u32)(rotator_menu[i].desc)!=0; i++) {
			UART_Printf("%2d: %s\n", i, rotator_menu[i].desc);
		}

		UART_Printf("\nSelect the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == 0)
		{
			break;
		}
 		else if (sSel>0 && sSel<(sizeof(rotator_menu)/8-1))
			 ( rotator_menu[sSel].func) ();

	}
}
