/**************************************************************************************
* 
*	Project Name : S5PV210 validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File name : mie_test.c
*
*	File Description : This file implements test codes of MIE
*
*	Author : Woojin,Kim
*	Dept : AP application
*	Created Date : 2009/02/09
*	Version	: v0.1
*
*	History 
*		- Created(Woojin.Kim 2009/02/09)
*
******************************************************************************/

#include "system.h"
#include "util.h"
#include "lcd.h"
#include "lcd_module.h"
#include "intc.h"
#include "glib.h"
#include "option.h"
#include "library.h"
#include "timer.h"
//#include "mie_test_img.h"
#include "sysc.h"
#include "mie.h"


const static u32 uLcdFbAddr = CODEC_MEM_ST;
const static u32 uBMPSrcAddr = CODEC_MEM_ST+0x1000000;

const static char *pMieTest_Image[13] = {
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/fb_000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/A_strawberries_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/B_tomato_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/C_Sunflower_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/D_Grayscale-Kekkonen-1_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/E_fruits_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/F_map_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/A2-011_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/B2_Magenta-flower_Landscape.bmp",	
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/C2-002_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/C3-000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/E2_Grayscale-Moon_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/fw_RED_Landscape.bmp"
};

const static char *pMieTest_MOVIE_Image[13] = {
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_fb_000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_A_strawberries_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_B_tomato_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_C_Sunflower_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_D_Grayscale-Kekkonen-1_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_E_fruits_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_F_map_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_A2-011_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_B2_Magenta-flower_Landscape.bmp",	
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_C2-002_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_C3-000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_E2_Grayscale-Moon_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/MOVIE_fw_RED_Landscape.bmp"
};

const static char *pMieTest_STILL_Image[13] = {
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_fb_000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_A_strawberries_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_B_tomato_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_C_Sunflower_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_D_Grayscale-Kekkonen-1_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_E_fruits_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_F_map_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_A2-011_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_B2_Magenta-flower_Landscape.bmp",	
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_C2-002_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_C3-000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_E2_Grayscale-Moon_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/STILL_fw_RED_Landscape.bmp"
};

const static char *pMieTest_UI_Image[13] = {
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_fb_000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_A_strawberries_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_B_tomato_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_C_Sunflower_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_D_Grayscale-Kekkonen-1_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_E_fruits_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_F_map_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_A2-011_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_B2_Magenta-flower_Landscape.bmp",	
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_C2-002_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_C3-000_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_E2_Grayscale-Moon_Landscape.bmp",
	"D:/00_Work/99_Study/MIE/test_imgs/Landscape_imgs/UI_fw_RED_Landscape.bmp"
};



extern u32 gLCDM_HSIZE;
extern u32 gLCDM_VSIZE;	

void InitSysconForMIE(void)
{
	// T-Block Power Off and On
	SYSC_SetBlockPowerOFF_IP(eMIE);
	DelayfrTimer(milli, 100);
	SYSC_SetBlockPowerON_IP(eMIE);

	// IP Clock Off and On
	SYSC_SetClkOFF_IP(eMIE);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eMIE);
}


void Test_MIE_ModeSelect(void)
{
	u32 uSelNum;
	u32 uTmpReg;
	u8	cSelMode;
	MODE_SEL eMieModeSel;
	CTRL_DIMMING eCtDimm;
	u32 k,j,n;
	u32 uFbAddrB;

	Disp("Select MIE test Image [0~12] : \n");
	n=UART_GetIntNum();	


	if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 320, 240);
	}

	uFbAddrB = uLcdFbAddr + (320*240*4);
		
	Disp("1. MIE off		2. UI mode		3. Still mode		4.Moving mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eMieModeSel =  
	(uSelNum == 1) ? MIE_off :
	(uSelNum == 2) ? UI :
	(uSelNum == 3) ? STILL : MOVING;

	Disp("1. Ctrl Dimming disable       2. Ctrl Dimming enable\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eCtDimm =
	(uSelNum == 1) ? CT_DIMM_DIS : CT_DIMM_EN;

	MIE_SetOutputSignal();
	MIE_SetSize(gLCDM_HSIZE, gLCDM_VSIZE);
	MIE_SetCatCst(CAT_1,CST_32);
	MIE_SetWinPosition((gLCDM_HSIZE-1),(gLCDM_VSIZE-1));
	MIE_SetPWMPorch();

	MIE_SelectMode(eMieModeSel, eCtDimm);	  	


	if(eMieModeSel == UI)
		{
		if(LoadFromFile(pMieTest_UI_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_UI_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
								}
		}
	
	else if(eMieModeSel == MOVING)
		{
		if(LoadFromFile(pMieTest_MOVIE_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_MOVIE_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
								}
		}
	
	else if(eMieModeSel == STILL)
		{
		if(LoadFromFile(pMieTest_STILL_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_STILL_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
								}
		}

	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24,320,240,0,0,320,240,0,0,uLcdFbAddr,WIN0,false);
	
//	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_InitWin(RGB24,320,240,0,0,320,240,0,0,uFbAddrB,WIN1,false);
	LCDC_SetWinOnOff(0,WIN1);
	LCDC_Trigger();

/*	
	GLIB_InitInstance(uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE, RGB24);

	k=0;
	for(i=0; i<gLCDM_VSIZE; i++)
	for(j=0; j<gLCDM_HSIZE; j++)
		GLIB_PutPixel2(j, i, mie_B_land[k++]);

*/
	LCDC_Start();

	while(1)
	{
		Disp("Press 'Enter' key will break mie test\n");

//		Disp("Press 'x' key to turn off MIE \nPress 'z' key to turn on MIE\nPress 'a' key to load on A type MIE Image\nPress 'b' key to load on B type MIE Image\nPress 'r' key will read TMF\n");
		Disp("Press 'x' key to turn off MIE \nPress 'z' key to turn on MIE\nPress 'e' key to see MIE IMG\nPress 'r' key to see original IMG\nPress 't' key tol read TMF\nPress 'c' key to change img\n");

		cSelMode = UART_Getc();

			switch(cSelMode)
				{

				case 'x' : MIE_SelectMode(MIE_off,eCtDimm);
						 break;
				case 'z' : MIE_SelectMode(eMieModeSel,eCtDimm);
						 break;
				case 'r' : LCDC_SetWinOnOff(0,WIN0);
						SYSC_SetDispPath(eDISP_BYPASS);				
						IEIP_Select(DISP_BYPASS);
						LCDC_SetWinOnOff(1,WIN1);
						break;
				case 'e' : LCDC_SetWinOnOff(0,WIN1);
						SYSC_SetDispPath(eDISP_MIE);
						IEIP_Select(DISP_MIE);
						LCDC_SetWinOnOff(1,WIN0);
						break;
				case 't' : uTmpReg = MIE_GetTMF();
						Disp ( " Previous frame is   %d     , Current frame is %d  \n",uTmpReg&(0xf) , uTmpReg&(0xf0)>>4);
						break;
				case 'c' : Disp("Select MIE test Image [0~12] : \n");
						n=UART_GetIntNum();	

						if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
						{
							UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
							ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 320, 240);
						}

							if(eMieModeSel == UI)
								{
								if(LoadFromFile(pMieTest_UI_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_UI_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
														}
								}
							
							else if(eMieModeSel == MOVING)
								{
								if(LoadFromFile(pMieTest_MOVIE_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_MOVIE_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
														}
								}
							
							else if(eMieModeSel == STILL)
								{
								if(LoadFromFile(pMieTest_STILL_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_STILL_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 320, 240);
														}
								}
							
						break;
				case '\r' : break;
						
				default : break;
						
				}
		if (cSelMode == '\r')
			break;
/*			
		if (UART_Getc()=='x')
			MIE_SelectMode(MIE_off,eCtDimm);
		else if (UART_Getc()=='z')
			MIE_SelectMode(eMieModeSel,eCtDimm);

		else if (UART_Getc()=='a')
		{

		
			k=0;
			for(i=0; i<gLCDM_VSIZE; i++)
			for(j=0; j<gLCDM_HSIZE; j++)
				GLIB_PutPixel2(j, i, mie_A_land[k++]);
			Disp("\n End to load A type Img \n");
		}

		else if (UART_Getc()=='b')
		{
		
			k=0;
			for(i=0; i<gLCDM_VSIZE; i++)
			for(j=0; j<gLCDM_HSIZE; j++)
				GLIB_PutPixel2(j, i, mie_B_land[k++]);

			Disp("\n End to load B type Img \n");
		}

		else if(UART_Getc()=='r')
		{
			uTmpReg = MIE_GetTMF();

			Disp ( " Previous frame is   %d     , Current frame is %d  \n",uTmpReg&(0xf) , uTmpReg&(0xf0)>>4);

		}
		else if(UART_Getc()=='c')
		{
			Disp("Select MIE test Image [0~12] : \n");
			n=UART_GetIntNum();	


			if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
			{
				UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
				ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE);
			}

		}
		
		else if (UART_Getc()=='\r')
		break;

*/

	}

}


void Test_MIE_PWMcontrol(void)
{

	u32 uSelNum;
	u32 uTmpReg;
	u8	cSelMode;
	MODE_SEL eMieModeSel;
	CTRL_DIMMING eCtDimm;
	BCMODE_SEL eBcModeSel;
	BLU_CONTROL	eBLU;
	BR_ENABLE eBR;
	PWM_DM_SEL ePwmDm;
	DD_ENABLE eDD;
	DT_SEL eDT;
	u32 uManBr;
	u32 k,j,n;
	u32 uFbAddrB;

	Disp("Select MIE test Image [0~12] : \n");
	n=UART_GetIntNum();	



	if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE);
	}

	uFbAddrB = uLcdFbAddr + (gLCDM_HSIZE*gLCDM_VSIZE*4);
		
	Disp("1. MIE off		2. UI mode		3. Still mode		4.Moving mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eMieModeSel =  
	(uSelNum == 1) ? MIE_off :
	(uSelNum == 2) ? UI :
	(uSelNum == 3) ? STILL : MOVING;

	Disp("1. Ctrl Dimming disable       2. Ctrl Dimming enable\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eCtDimm =
	(uSelNum == 1) ? CT_DIMM_DIS : CT_DIMM_EN;


	MIE_SetOutputSignal();
	MIE_SetSize(gLCDM_HSIZE, gLCDM_VSIZE);
	MIE_SetCatCst(CAT_1,CST_32);
	MIE_SetWinPosition((gLCDM_HSIZE-1),(gLCDM_VSIZE-1));
	MIE_SetPWMPorch();


	Disp("1. Backlight Unit On           2. Backlight Unit Off \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	

	eBLU =
	(uSelNum == 1) ? BCTRL_ON : BCTRL_OFF ;

	if(eBLU == BCTRL_ON)
	{
	Disp("1.PWM off		2.PWM Manual		3.PWM MIE		4.PWM Manual x MIE\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eBcModeSel =
	(uSelNum == 1 ) ? MODEOFF :
	(uSelNum == 2 ) ? MANUALONLY :
	(uSelNum == 3 ) ? MIEONLY : MANUALMIE ;

	if(eBcModeSel != MODEOFF)
	{
	Disp("1.PWM 256		2.PWM 128		3.PWM 64		4.PWM 32\n");
	Disp("Select PWM dimming step to test : ");
	uSelNum = UART_GetIntNum();	
	ePwmDm =
	(uSelNum == 1 ) ? PWMDM_256 :
	(uSelNum == 2 ) ? PWMDM_128 :
	(uSelNum == 3 ) ? PWMDM_64 : PWMDM_32 ;
	}




		if(eBcModeSel == MIEONLY)
		{
		MIE_SetPWMcontrol(eBLU, DDoff, BLon, eBcModeSel);
		MIE_SetPWMManual(DDoff,DT_32,BRoff,0x0);	
		MIE_SetPWMdefault(ePwmDm,0x1,0x0);
		}
		else if(eBcModeSel == MANUALONLY)
		{
		Disp("1. Manual BR disable       2. Manual BR enable\n");
		Disp("Select the function to test : ");
		uSelNum = UART_GetIntNum();	
		eBR =
		(uSelNum == 1 ) ? BRoff : BRon ;
		
		Disp("Brightness value as manual setting : ");
		uManBr = UART_GetIntNum();			
		
		Disp("1. Manual BR Dimming disable       2. Manual BR Dimming enable\n");
		Disp("Select the function to test : ");
		uSelNum = UART_GetIntNum();	
		eDD =
		(uSelNum == 1) ? DDoff : DDon;

			if(eDD == DDon)
				{
				Disp("0. 16frms		1. 24frms		2. 32frms		3. 40frms		4. 48frms		5. 56frms		6. 65frms		7. 72frms\n");
				Disp("Select Manual BR dimming transition time control : ");
				uSelNum = UART_GetIntNum();
				eDT =
				(uSelNum == 0) ? DT_16 :
				(uSelNum == 1) ? DT_24 :
				(uSelNum == 2) ? DT_32 :					
				(uSelNum == 3) ? DT_40 :
				(uSelNum == 4) ? DT_48 :
				(uSelNum == 5) ? DT_56 :					
				(uSelNum == 6) ? DT_65 :	DT_72 ;				
				MIE_SetPWMcontrol(eBLU, eDD, BLon, eBcModeSel);
				MIE_SetPWMManual(eDD,eDT,eBR,uManBr);
				MIE_SetPWMdefault(ePwmDm,0x1,0x0);				
				
				}
		MIE_SetPWMcontrol(eBLU, eDD, BLon, eBcModeSel);
		MIE_SetPWMManual(eDD,DT_32,eBR,uManBr);			
		MIE_SetPWMdefault(ePwmDm,0x1,0x0);						
		}
	
	}


	MIE_SelectMode(eMieModeSel, eCtDimm);	  	


	if(eMieModeSel == UI)
		{
		if(LoadFromFile(pMieTest_UI_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_UI_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
								}
		}
	
	else if(eMieModeSel == MOVING)
		{
		if(LoadFromFile(pMieTest_MOVIE_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_MOVIE_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
								}
		}
	
	else if(eMieModeSel == STILL)
		{
		if(LoadFromFile(pMieTest_STILL_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
								{
									UART_Printf("Success to load image(%s)\n", pMieTest_STILL_Image[n]);
									ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
								}
		}

	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_InitWin(RGB24,gLCDM_HSIZE,gLCDM_VSIZE,0,0,gLCDM_HSIZE,gLCDM_VSIZE,0,0,uFbAddrB,WIN1,false);
	LCDC_SetWinOnOff(0,WIN1);
	MIE_InitGPIOpwm(MIE_PWMon);
	LCDC_Trigger();

	LCDC_Start();

	while(1)
	{
		Disp("Press 'Enter' key will break mie test\n");

		Disp("Press 'x' key to turn off MIE \nPress 'z' key to turn on MIE\nPress 'e' key to see MIE IMG\nPress 'r' key to see original IMG\nPress 't' key tol read TMF\nPress 'c' key to change img\n");

		cSelMode = UART_Getc();

			switch(cSelMode)
				{

				case 'x' : MIE_SelectMode(MIE_off,eCtDimm);
						 break;
				case 'z' : MIE_SelectMode(eMieModeSel,eCtDimm);
						 break;
				case 'r' : LCDC_SetWinOnOff(0,WIN0);
						SYSC_SetDispPath(eDISP_BYPASS);
						IEIP_Select(DISP_BYPASS);
						LCDC_SetWinOnOff(1,WIN1);
						break;
				case 'e' : LCDC_SetWinOnOff(0,WIN1);
						SYSC_SetDispPath(eDISP_MIE);
						IEIP_Select(DISP_MIE);
						LCDC_SetWinOnOff(1,WIN0);
						break;
				case 't' : uTmpReg = MIE_GetTMF();
						Disp ( " Previous frame is   %d     , Current frame is %d  \n",uTmpReg&(0xf) , uTmpReg&(0xf0)>>4);
						break;
				case 'c' : Disp("Select MIE test Image [0~12] : \n");
						n=UART_GetIntNum();	

						if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
						{
							UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
							ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE);
						}

							if(eMieModeSel == UI)
								{
								if(LoadFromFile(pMieTest_UI_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_UI_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
							else if(eMieModeSel == MOVING)
								{
								if(LoadFromFile(pMieTest_MOVIE_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_MOVIE_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
							else if(eMieModeSel == STILL)
								{
								if(LoadFromFile(pMieTest_STILL_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_STILL_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
						break;
				case '\r' : break;
						
				default : break;
						
				}
		if (cSelMode == '\r')
			break;

	}


}


void Test_MIE_DualLCD(void)
{
	u32 uSelNum;
	u32 uTmpReg;
	u32 uHSz,uVSz;
	MODE_SEL eMieModeSel;
	CTRL_DIMMING eCtDimm;
	u32 k,i,j,n;
	u32 uFbAddrB;




	Disp("[0] LCD Landscape Scan type \n");
	Disp("[1] LCD Portrait Scan type \n");
	Disp("Select LCD Scan type  :");
	i = UART_GetIntNum();
	Disp("\n");
	LCDC_InitLdi(MAIN);
	if(i == 0)
	{
	LCDC_InitBaseDualFs();
	LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, WIN0, false);
//	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, WIN0,WIN1, false,LCD_LANDSCAPE);
	}
	else
	{
	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, WIN0,WIN1, false,LCD_PORTRAIT);
	}

	LCDC_SetDualDisplay(FRAME_SPLIT,MIE_DUAL,VDEN_DIS);
	LCDC_InitGpioDualLCD(LCD_DUAL);

	LCDC_GetLcdSz(&uHSz,&uVSz);



	Disp("1. MIE off		2. UI mode		3. Still mode		4.Moving mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eMieModeSel =  
	(uSelNum == 1) ? MIE_off :
	(uSelNum == 2) ? UI :
	(uSelNum == 3) ? STILL : MOVING;

	Disp("1. Ctrl Dimming disable       2. Ctrl Dimming enable\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eCtDimm =
	(uSelNum == 1) ? CT_DIMM_DIS : CT_DIMM_EN;

	MIE_SetOutputSignal();
	MIE_SetSize(uHSz, uVSz);
	MIE_SetCatCst(CAT_1,CST_32);
	MIE_SetWinPosition((uHSz-1),(uVSz-1));
	MIE_SetPWMPorch();

	MIE_SelectMode(eMieModeSel, eCtDimm);	  	




/*	
	GLIB_InitInstance(uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE, RGB24);

	k=0;
	for(i=0; i<gLCDM_VSIZE; i++)
	for(j=0; j<gLCDM_HSIZE; j++)
		GLIB_PutPixel2(j, i, mie_B_land[k++]);

*/
	LCDC_Start();
/*
	while(1)
	{
		Disp("Press 'Enter' key will break mie test\n");

//		Disp("Press 'x' key to turn off MIE \nPress 'z' key to turn on MIE\nPress 'a' key to load on A type MIE Image\nPress 'b' key to load on B type MIE Image\nPress 'r' key will read TMF\n");
		Disp("Press 'x' key to turn off MIE \nPress 'z' key to turn on MIE\nPress 'e' key to see MIE IMG\nPress 'r' key to see original IMG\nPress 't' key tol read TMF\nPress 'c' key to change img\n");

		cSelMode = UART_Getc();

			switch(cSelMode)
				{

				case 'x' : MIE_SelectMode(MIE_off,eCtDimm);
						 break;
				case 'z' : MIE_SelectMode(eMieModeSel,eCtDimm);
						 break;
				case 'r' : LCDC_SetWinOnOff(0,WIN0);
						IEIP_Select(DISP_BYPASS);
						LCDC_SetWinOnOff(1,WIN1);
						break;
				case 'e' : LCDC_SetWinOnOff(0,WIN1);
						IEIP_Select(DISP_MIE);
						LCDC_SetWinOnOff(1,WIN0);
						break;
				case 't' : uTmpReg = MIE_GetTMF();
						Disp ( " Previous frame is   %d     , Current frame is %d  \n",uTmpReg&(0xf) , uTmpReg&(0xf0)>>4);
						break;
				case 'c' : Disp("Select MIE test Image [0~12] : \n");
						n=UART_GetIntNum();	

						if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
						{
							UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
							ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE);
						}

							if(eMieModeSel == UI)
								{
								if(LoadFromFile(pMieTest_UI_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_UI_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
							else if(eMieModeSel == MOVING)
								{
								if(LoadFromFile(pMieTest_MOVIE_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_MOVIE_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
							else if(eMieModeSel == STILL)
								{
								if(LoadFromFile(pMieTest_STILL_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
														{
															UART_Printf("Success to load image(%s)\n", pMieTest_STILL_Image[n]);
															ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, gLCDM_HSIZE, gLCDM_VSIZE);
														}
								}
							
						break;
				case '\r' : break;
						
				default : break;
						
				}
		if (cSelMode == '\r')
			break;
*/
/*			
		if (UART_Getc()=='x')
			MIE_SelectMode(MIE_off,eCtDimm);
		else if (UART_Getc()=='z')
			MIE_SelectMode(eMieModeSel,eCtDimm);

		else if (UART_Getc()=='a')
		{

		
			k=0;
			for(i=0; i<gLCDM_VSIZE; i++)
			for(j=0; j<gLCDM_HSIZE; j++)
				GLIB_PutPixel2(j, i, mie_A_land[k++]);
			Disp("\n End to load A type Img \n");
		}

		else if (UART_Getc()=='b')
		{
		
			k=0;
			for(i=0; i<gLCDM_VSIZE; i++)
			for(j=0; j<gLCDM_HSIZE; j++)
				GLIB_PutPixel2(j, i, mie_B_land[k++]);

			Disp("\n End to load B type Img \n");
		}

		else if(UART_Getc()=='r')
		{
			uTmpReg = MIE_GetTMF();

			Disp ( " Previous frame is   %d     , Current frame is %d  \n",uTmpReg&(0xf) , uTmpReg&(0xf0)>>4);

		}
		else if(UART_Getc()=='c')
		{
			Disp("Select MIE test Image [0~12] : \n");
			n=UART_GetIntNum();	


			if(LoadFromFile(pMieTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
			{
				UART_Printf("Success to load image(%s)\n", pMieTest_Image[n]);
				ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, gLCDM_HSIZE, gLCDM_VSIZE);
			}

		}
		
		else if (UART_Getc()=='\r')
		break;

*/



}


void Test_MIE_Enhancement(void)
{
	u32 uTmpReg;
	u32 uTmpVal;
	u32 uSelNum;

	Disp("\n1. Image Enhancement ratio     2. Backlight Reduction ratio     3. Saturation enhance ratio \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();


	switch(uSelNum)
	{

	case 1 : 
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount Image Enhancement ratio till Max value (255)\n ");				
				while(uTmpVal < 255)
				{
					Disp(" Image Enhancement ratio = %d\n ",uTmpVal);
					MIE_SetIERC(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 10;
				}
				
			 	uTmpVal = 255;
				Disp(" Image Enhancement ratio = %d (MAX VALUE)\n",uTmpVal);

				MIE_SetIERC(uTmpVal);		
				
				Disp("\n Press any key to end Image Enhancement ratio test \n");
				UART_Getc();

				uTmpVal = 0x80;
				Disp(" Image Enhancement ratio = %d (Default VALUE)\n\n",uTmpVal);		
				MIE_SetIERC(uTmpVal);
				break;

	case 2 : 

				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount Backlight Reduction ratio till Max value (255)\n ");		
				while(uTmpVal < 255)
				{
					Disp(" Backlight Reduction ratio = %d \n",uTmpVal);
					MIE_SetBRRC(uTmpVal);


					UART_Getc();
					
					uTmpVal = uTmpVal + 10;
				}
				
			 	uTmpVal = 255;
				Disp(" Backlight Reduction ratio = %d (MAX VALUE)\n",uTmpVal);

				MIE_SetBRRC(uTmpVal);		
				
				Disp("\n Press any key to end Backlight Reduction ratio test \n");
				UART_Getc();

				uTmpVal = 0x80;
				Disp(" Backlight Reduction ratio = %d (Default VALUE)\n\n",uTmpVal);		
				MIE_SetBRRC(uTmpVal);
				break;

	case 3 :
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount Saturation enhance ratio till Max value (31) \n");		
				
				while(uTmpVal < 31)
				{
			
					Disp(" Saturation enhance ratio = %d\n ",uTmpVal);
					MIE_SetSERC(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 10;
				}
				
			 	uTmpVal = 31;
				Disp(" Saturation enhance ratio = %d (MAX VALUE)\n",uTmpVal);

				MIE_SetSERC(uTmpVal);		
				
				Disp("\n Press any key to end Saturation enhance ratio test \n");
				UART_Getc();

				uTmpVal = 0x10;
				Disp(" Saturation enhance ratio = %d (Default VALUE)\n\n",uTmpVal);		
				MIE_SetSERC(uTmpVal);
				break;

	default:
				break;
	
	}

}

void Test_MIE_PowerGatingAging(void)
{
	MODE_SEL eMieModeSel;
	CTRL_DIMMING eCtDimm;

	while(!UART_GetKey())
	{
		// T-Block Power Off and On
		SYSC_SetBlockPowerOFF_IP(eFIMD);
		DelayfrTimer(milli, 100);
//		TestRegAccessInClockPowerOff(CPTEST_FIMD);
		SYSC_SetBlockPowerON_IP(eFIMD);
		DelayfrTimer(milli, 100);


		SYSC_SetDispPath(eDISP_MIE);
		IEIP_Select(DISP_MIE);

		
		if(LoadFromFile(pMieTest_Image[1], uBMPSrcAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pMieTest_Image[1]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 320, 240);
		}

		eMieModeSel =  UI;
		eCtDimm =	CT_DIMM_DIS;

		MIE_SetOutputSignal();
		MIE_SetSize(gLCDM_HSIZE, gLCDM_VSIZE);
		MIE_SetCatCst(CAT_1,CST_32);
		MIE_SetWinPosition((gLCDM_HSIZE-1),(gLCDM_VSIZE-1));
		MIE_SetPWMPorch();

		MIE_SelectMode(eMieModeSel, eCtDimm);	  	

		LCDC_InitLdi(MAIN);
		LCDC_InitBase();
		LCDC_InitWin(RGB24,320,240,0,0,320,240,0,0,uLcdFbAddr,WIN0,false);
		
		LCDC_Start();
		DelayfrTimer(milli, 2000);

		// IP Clock Off and On
		SYSC_SetClkOFF_IP(eMIE);
//		SYSC_SetClkOFF_IP(eFIMD);
		DelayfrTimer(milli, 100);
//		TestRegAccessInClockPowerOff(CPTEST_FIMD);		
//		SYSC_SetClkON_IP(eFIMD);
		SYSC_SetClkON_IP(eMIE);
		DelayfrTimer(milli, 100);
		
	}





}



void MIE_Test(void)
{
	int i, nSel;

	const testFuncMenu menu[]=
	{
		0,                                 "Exit\n",
		Test_MIE_ModeSelect,                 "Test MIE mode Select(default value)",
		Test_MIE_Enhancement,		                "Test MIE HDTR",		
		Test_MIE_PWMcontrol,			"Test MIE PWM control",
		Test_MIE_DualLCD,				"Test MIE Dual LCD",
		Test_MIE_PowerGatingAging,	"Test MIE Power/Clock gating Aging",
		0,							       0
	};

	InitSysconForMIE();
	SYSC_InitClkForMM();


	SYSC_SetDispPath(eDISP_MIE);
	IEIP_Select(DISP_MIE);





	while (1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("\nSelect the function to test : ");
		nSel = UART_GetIntNum();
		Disp("\n");

		if (nSel == 0)
		{
			break;
		}
		if (nSel>0 && nSel<(sizeof(menu)/8-1))
		{
			 (menu[nSel].func)();
		}
	}

	
}






