/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : mie.h
*  
*	File Description : This file declares prototypes of MIE API funcions.
*
*	Author : Woojin,Kim
*	Dept. : AP Application
*	Created Date : 2009/02/10
*	Version : 0.1 
* 
*	History
*	- Created(Woojin,Kim 2009/02/10)
*  
**************************************************************************************/

#ifndef __MIE_H__
#define __MIE_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"

#define DBG_MIE 1

typedef enum
{
	MIE_off,UI,STILL,MOVING
} MODE_SEL;

typedef enum
{
	CT_DIMM_DIS,CT_DIMM_EN
} CTRL_DIMMING;

typedef enum
{
	CAT_1,CAT_2,CAT_4,CAT_8
} CAT_SEL;

typedef enum
{
	CST_32,CST_64,CST_96,CST_128
} CST_SEL;


typedef enum
{
	DT_16,DT_24,DT_32,DT_40,DT_48,DT_56,DT_65,DT_72
} DT_SEL;

typedef enum
{
	BRoff,BRon
}BR_ENABLE;		//Manual Brightness enable

typedef enum
{
	PWMDM_256,PWMDM_128,PWMDM_64,PWMDM_32
} PWM_DM_SEL;


typedef enum
{
	BCTRL_OFF,BCTRL_ON
}BLU_CONTROL;

typedef enum
{
	DDoff,DDon
}DD_ENABLE;		//Manual Brightness dimming enable

typedef enum
{
	BLoff,BLon
}BL_ENABLE;		//PWM output enable

typedef enum
{
	MIE_PWMon,MIE_PWMoff
}MIE_PWMENABLE;

typedef enum
{
	MODEOFF,MANUALONLY,MIEONLY,MANUALMIE
}BCMODE_SEL;


void MIE_InitGPIOpwm(MIE_PWMENABLE ePWMen);
void MIE_SetOutputSignal(void);
void MIE_SelectMode(MODE_SEL eModeSel, CTRL_DIMMING eCtDimm);
void MIE_SetSize(u32 uHSize, u32 uVSize);
void MIE_SetCatCst(CAT_SEL eCAT,CST_SEL eCST);

void MIE_SetIERC(u32 uIEratio);
void MIE_SetBRRC(u32 uBRratio);
void MIE_SetSERC(u32 uSEratio);
void MIE_SetWinPosition(u32 uHpSize,u32 uVpSize);
void MIE_SetPWMPorch(void);
void MIE_SetPWMcontrol(BLU_CONTROL eBluCon,DD_ENABLE eDdEn,BL_ENABLE eBlEn,BCMODE_SEL eBcMode);	
void MIE_SetPWMdefault(PWM_DM_SEL ePwmDm,u32 uPwmFq,u32 uPwmMin);
void MIE_SetPWMManual(DD_ENABLE eDdEn, DT_SEL eDtSel, BR_ENABLE eBrEn, u32 uManBr);
u32 MIE_GetTMF(void);


#endif


