#ifndef __VSPARSER_H__
#define __VSPARSER_H__

#include "system.h"
#include "mfc.h"

#define RCV_VC1_TYPE (0x85)
/* Bit 6 of the type indicates V1 if 0, V2 if 1 */
#define RCV_V2_MASK (1 << 6)
/* Top nibble bits of frame size word are flags in V2 */
#define RCV_V2_FRAMESIZE_FLAGS (0xf0000000)
#define RCV_V2_KEYFRAME_FLAG   (0x80000000)
/* V2 extra information has a VBR flag */
#define RCV_V2_VBR_FLAG (0x10000000)

//#define _SLICE_BASED_INTERFACE_	(1)

#if 0
u8 ParseVc1Stream(u32  uBufferStartAddr, u32 uBufferByteSize,  u8 bIsHeader,
	u32* uFrameStartAddr, u32* uCurFrameSize, u32* uNumOfTotalFrames); //outputs

u8 ParseMp4Stream(u32 uRdPtr, u32 uRemainBytes, u8 bIsHeader,  //inputs
	u32* uFrameStAddr, u32* uFrameSize, u8* bIsShortHeader);//outputs

u8 ParseH264Stream(u32 uStreamStAddr, u32 uStreamFileSize, u32 uFrameArrayStAddr, u32* uNumOfFrames, u32* uEndOfFrameArray);

u32 vc1_parse_MFC50RCV_Frame(u32  buffer_start_addr, u32  buffer_size, u8 *src_mem, u32 *frame_start_addr,  u32 *frame_size);
//u32 vc1_parseRCV_Frame(u32 *frame_start_addr, u8 *src_mem, u32  buffer_size, u32* frameSize, u32 firstFrameFlag);
u32 vc1_parseRCV_Frame(u8 *src_mem, u32  buffer_size, u32* frameSize, u32 firstFrameFlag);

#endif

typedef struct __AVI_INFOs
{
	VIDEO_CODEC_TYPE standard;
	unsigned char fccHandler[5];
	u32 total_frames;
	u32 width;
	u32 height;
}AVI_INFOs;

typedef struct _RAMFILE {
	unsigned long filestart;
	unsigned long offset;
	unsigned long filesize;
}RFILE;

u32 VsParser(VIDEO_CODEC_TYPE standard, u32 buffer_start_addr, u32 buffer_size, /*u8* src_mem,*/
	u32 *frame_start_addr, u32 *frame_size, u8 bIsRcvFlag, u8 is_first_seq_header, u8 bSliceIfDec);

u32 mpeg4_parse(VIDEO_CODEC_TYPE standard, u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr,
	u32* frame_size, u8 is_first_seq_header, u8 bSliceIfDec);

u32 mpeg2_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr, 
	u32* frame_size, u8 is_first_seq_header) ;

u32 h264_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr, 
	u32* frame_size, u8 is_first_seq_header, u8 bSliceIfDec);

u8 SkippedPictureCheck(u8 *src_mem, u32 index);

u32 vc1_parse(u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32* frame_start_addr,
	u32* frame_size,	u8 rcvFlag, u8 is_first_seq_header);

u32 vc1_parse_advancedProfile_Frame(   u32 buffer_start_addr, u32 buffer_size, u8 *src_mem, u32 *frame_start_addr,
	u32 *frame_size, u8 is_first_seq_header);

u32 rcv_parse(u32  buffer_start_addr, u32  buffer_size,	u8 *src_mem, u32 *frame_start_addr, u32 *frame_size);

u8 _parse_avi_header(RFILE* fp, u32 start_position, u32 total_size, AVI_INFOs* info);

u8 parse_avi_header(RFILE* fp, int position, u32 total_size, VIDEO_CODEC_TYPE* standard, u32* width, u32* height);

u32 _read_word_little(unsigned char* buffer);
u8 get_fourcc1(unsigned char* buffer, unsigned char* FourCC);
u32 avi_parse(u32  buffer_start_addr, u32   buffer_size,   u8* src_mem,
							   u32* frame_start_addr,   u32* frame_size, u32* consumed_frame_size);


u32 VsParserForAvi(VIDEO_CODEC_TYPE standard, u32 buffer_start_addr, u32 buffer_size,
	u32 *frame_start_addr, u32 *frame_size, u32* consumed_frame_size);
#endif// __VSPARSER_H__

