/*----------------------------------------------------------------------
 *
 * Filename: mfc_test.c
 *
 * Contents: Testing application of "MFC v5.0"
 *
 * Authors: 
 *
 * Notes: 
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 *
 *---------------------------------------------------------------------- 
 */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "system.h"
#include "util.h"
#include "sysc.h"
#include "mfc.h"
#include "intc.h"
#include "vsparser.h"
#include "avireader.h"
#include "lcd.h"
#include "glib.h"
#include "fimc.h" 
#include "gpio.h"
#include "sdhc.h"
#include "fs.h"
#include "ProtocolStack.h"
#include "ProtocolStackUDP.h"
#include "EthernetFileTransfer.h"
#include "timer.h"
#include "dma.h"
#include "sblock.h"
#include "csi.h"
#include "mixer.h"
#include "hdmi.h"
#include "mipi_camera.h"

#include "smsc911x.h"
//#include "dm9000.h"
//#include "sysc_test.c"


#define STREAM_FILE_BUF_SIZE 			(0x3000000) 
#define MULTI_STREAM_FILE_BUF_SIZE 	(0x1000000) 
#define MFC_ENC_STREAM_BUF_SIZE			(0x2000000)
#define ONLY_SEQ_HEADER_PARSE_MODE		1
//#define FIMC_DIN_FOUT

static DMAC oDmac;
static u32 uFirstFailed;
static LCD_WINDOW eWin;
static IMG_FMT eMfcFbType;
static IMG_FMT eBpp;
static u32 uTestFileNum;
static u8 volatile bProcessingDoneA=false;
static u8 volatile bProcessingDoneB=false;
static u8 volatile bProcessingDoneC=false;
static u32 uFrameHsz[MAX_PROCESS_NUM];
static u32 uFrameVsz[MAX_PROCESS_NUM];
static u32 bFinishedProcess[MAX_PROCESS_NUM];
static u8 bNoMoreStream[MAX_PROCESS_NUM];
static u8 bIsFirstFrame[MAX_PROCESS_NUM];
static u32 uFrameCnt[MAX_PROCESS_NUM];
static u32 sel[MAX_PROCESS_NUM];
static char aFileName[MAX_FILENAME_SIZE];
//static char aCfgFileName[MAX_FILENAME_SIZE];
static u8 bSdMode;
static u32 uIdx;
static u8 bRandomMultiDec=false;
static u8 bSdLoadMode=true;
static u32 uDispHorizontalDiv;
static u32 uDispVerticalDiv;
static u32 uDispWidth, uDispHeight;
static u32 uLcdFbAddr;
static u32 uLcdHSz, uLcdVSz;
static u32 uFinishedProcessNum=0;
static u8 bConformanceTestAll=false;
static CSC_EQUATION eCscEquation = CSC_ITU601;
static YCBCR_RANGE eYCbCrRange = YCBCR_WIDE;
static MFC_MB_LINEAR_TILE_MODE eLinearTileMode = MB_LINEAR_MODE;
static u8 bOneFrameStream[MAX_PROCESS_NUM];
static u8 bMustbeChecked[MAX_PROCESS_NUM];
static u32 uCrcBufStAddr[MAX_PROCESS_NUM];
static u32 uRefCrcBufAddr[MAX_PROCESS_NUM];
static u32 uRefCrcFileSize[MAX_PROCESS_NUM];
static VIDEO_CODEC_TYPE eStandard;
static VIDEO_CODEC_TYPE eDecStandard[MAX_PROCESS_NUM];
static VIDEO_CODEC_TYPE eEncStandard[MAX_PROCESS_NUM];
static char pFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
static u8 ebDecStandard=false;
static u8 bVc1Field[MAX_PROCESS_NUM];
static u32 uErrorCnt=0;
static u32 uMultiDecTotFrameCnt=0;
static u32 uCurCrcBufStAddr[MAX_PROCESS_NUM];
static u8 bDispOnlyFrame[MAX_PROCESS_NUM];
static u32 uPreFrameSize[MAX_PROCESS_NUM];
static u32 uRdPtr[MAX_PROCESS_NUM];
static u32 uRemainSz[MAX_PROCESS_NUM];
static u32 uOneFrameSz[MAX_PROCESS_NUM];
static u8 bFirstCrcCheck=true;
static u8 bSaveResult=false;
static u32 g_uStreamBufStAddr, g_uStreamBufOffset, g_uReadStreamSize;
static u32 uNumOfInstance;
static u32 uTestNum=0;
static u32 nDecProcessCount;
static u32 nEncProcessCount;
static u8 bRandomMultiTest=false;
static volatile u8 bDmaDone=false;
static u32 g_uStreamFileSize;
static VIDEO_CODEC_TYPE g_eDecStandard;
static u8 bPixelCacheEn = true;
static u8 bFimcDinDout=true;
static u32 uLcdcUnderRunCnt=0;
static u32 uVpUnderRunCnt=0;
static u32 uMixer0UnderRunCnt=0;
static u32 uMixer1UnderRunCnt=0;
static u8 bFirstFimcFifoOut=true;
static u8 bBufferInitDone=false;
static u8 bFirstConformance=true;
static u8 bSliceBaseDec=false;
static u8 bOneFrameEncDone=false;

static u32 uSrcNv12YAddr, uSrcNv12CAddr;
static u32 uOutImgAddr1OfY, uOutImgAddr2OfY, uOutImgAddr3OfY, uOutImgAddr4OfY;
static u32 uOutImgAddr1OfC, uOutImgAddr2OfC, uOutImgAddr3OfC, uOutImgAddr4OfC;
static u32 uOutImgAddrOfY[8], uOutImgAddrOfC[8];
static u32 uEncAddrOfY[4], uEncAddrOfC[4];
static u32 uFimcFrmCnt;
static u32 uStreamBufOffset;
static u32 uStreamBufStAddr;
static u32 uFrameCount=0;
static u32 uDisplayDevice;
static u8 bPreviewMode=true;
static u8  bMfsEncDone = true;
static u32 uEncSlowCnt;
static u32 uEncRawImgHsz;
static u32 uEncRawImgVsz;
static u32 uFimc0TotalCount;
static u32 uFimc1TotalCount;
static u32 uFimc2TotalCount;

enum {
		FIMC_DinFout = 1<<0, 
		FIMC_DinDout = 1<<1,
		HDMI_DemoOut = 1<<2
		};

// For Ethernet
#define MyMAC0 00
#define MyMAC1 11
#define MyMAC2 22
#define MyMAC3 33
#define MyMAC4 44
#define MyMAC5 54
#define MyIP0 192	
#define MyIP1 168
#define MyIP2 0
#define MyIP3 54
#define K_FileServerIP0 192
#define K_FileServerIP1 168
#define K_FileServerIP2 0
#define K_FileServerIP3 199

static u8 DefaultMACAddress[6]={MyMAC0,MyMAC1,MyMAC2,MyMAC3,MyMAC4,MyMAC5};
static u8 DefaultIPAddress[4]={MyIP0,MyIP1,MyIP2,MyIP3};
static u8 TargetIPAddress[4]={K_FileServerIP0,K_FileServerIP1,K_FileServerIP2,K_FileServerIP3};

static u8 CheckCrcDiff(VIDEO_CODEC_TYPE uDecMode, u32 uRefCrcBufAddr, u32 uNomOfCrc)
{
	u32 i;
	u32 uGotCrcVal;
	u32 uRefCrcVal;
	u32 uDiffCnt=0;
	
	if(uNomOfCrc == 4)
	{
		for(i=0; i<4; i++)
		{
			uGotCrcVal = Inp32(0xf1702030+4*i);
			uRefCrcVal = Inp32(uRefCrcBufAddr+4*i);
	
			if(uGotCrcVal != uRefCrcVal)
			{
				Disp("\nDiff:%s\n",(i==0)?"Top Luma": (i==1)?"Top Chroma":
										(i==2)?"Bottom Luma": (i==3)?"Bottom Chroma": 0);
				Disp("RefCrcAddr : 0x%x, RefCrc : 0x%x\n",uRefCrcBufAddr+4*i, uRefCrcVal);	
				Disp("GenCrcAddr : 0x%x, GenCrc : 0x%x\n",0xf1702030+4*i, uGotCrcVal);
				uDiffCnt++;
			}
		}
	}
	else // uNomOfCrc == 2
	{
		for(i=0; i<2; i++)
		{
			uGotCrcVal = Inp32(0xf1702030+4*i);
			uRefCrcVal = Inp32(uRefCrcBufAddr+4*i);	

			if(uGotCrcVal != uRefCrcVal)
			{
 				Disp("\nDiff:%s\n",(i==0)?"Luma": (i==1)?"Chroma": 0);
				Disp("RefCrcAddr : 0x%x, RefCrc : 0x%x\n",uRefCrcBufAddr+4*i, uRefCrcVal);	
				Disp("GenCrcAddr : 0x%x, GenCrc : 0x%x\n",0xf1702030+4*i, uGotCrcVal);				
				uDiffCnt++;
			}
		}	
	}
	return (uDiffCnt)? false : true ;
}


const char *pMultiDecFileList[]=
{
//	"3096.m4v",	"4097.dvx",	"test72.263", "152_CVMP_MOT_FLD_L30_B.264",
	"3096.m4v",	"4097.dvx",	"test72.263", "5134.dvx4",
	"2001.xvd",	"test81.es", "10_HP.264", "100.vc1",
	"test196.es", "3064.m4v", "test1375.es", "2012.xvd",
//	"test136.263", "5164.dvx4",	"187_fireworks_mbaff_pq38bq42_spatial.264",	"test1276.rcv",
	"97.264", "5164.dvx4",	"3064.m4v",	"1185.rcv",
	0
};

u8	CompareStreamData(u32 a0, u32 a1, u32 size)
{
	u32 i;

	for(i=0; i<size; i++)
	{
		if(*(u8 *)(a0+i)!=*(u8 *)(a1+i))
		{
			Disp(" 0x%08x=0x%02x <-> 0x%08x=0x%02x\n", (a0+i), *(u8 *)(a0+i), (a1+i), *(u8 *)(a1+i));
			return 0;
		}
	}
	return 1;
}

static void MemCopy16(u32 sa, u32 da, u32 Hwords)
{
	u32 i;
	for (i=0; i<Hwords; i += 2)
		*(u16 *)(da+i) = *(u16 *)(sa+i);
	for (;i<Hwords; i ++)
		*(u8 *)(da+i) = *(u8 *)(sa+i);
}

static void MemCopy32(u32 sa, u32 da, u32 words)
{
	u32 i;

	for (i=0; i<words; i += 4)
		*(u32 *)(da+i) = *(u32 *)(sa+i);
	for (; i<words; i ++)
		*(u8 *)(da+i) = *(u8 *)(sa+i);
}

static void __irq Isr_Dmac(void)
{	
	u32 uInt;

	INTC_Disable(NUM_MDMA);

	DMA_GetIntrSrc(&uInt, &oDmac);
	
	if (uInt==32)
	{
		Disp("[DMA FAULT & STOP]");
		DMA_StopDmac(&oDmac);
	}
	else
	{
		DMA_ClearIntPending(uInt, &oDmac);	
		bDmaDone = true;
		DMA_StopCh(&oDmac);
	}
	INTC_ClearVectAddr();
	INTC_Enable(NUM_MDMA);
}


static void __irq Isr_Mfc(void)
{
	MFC_FACADE_RESPONSE eFlag;
	
	MFC_GetIntFlag(&eFlag);	

	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET)||
		(eFlag == R2H_CMD_ERR_RET)||(eFlag == R2H_CMD_SLICE_DONE_RET)||
		(eFlag == R2H_CMD_INIT_BUFFER_RET) || (eFlag == R2H_CMD_ENC_COMPLETE_RET))
	{
		if(eFlag==R2H_CMD_SEQ_DONE_RET)
			MFC_GetPicResolution();
#if 0
		if(eFlag==R2H_CMD_FRAME_DONE_RET)
			Disp("[FRAME]\n");
		if(eFlag==R2H_CMD_SLICE_DONE_RET)
			Disp("[SLICE]\n");
#endif			
		MFC_ClearRtnInstance();
	}

	MFC_ClearPending();
	INTC_ClearVectAddr();
}

static void __irq Isr_MfcForSmallStreamBuf(void)
{
	MFC_FACADE_RESPONSE eFlag;
	MFC_EDFU_STR_BUF_STATUS eStrBufSts;
	u32 uEncStrSzPerFrame;
	
	MFC_GetIntFlag(&eFlag);	
	if( (eFlag==R2H_CMD_SEQ_DONE_RET)&&(ebDecStandard == true) )
	{
		MFC_GetPicResolution();
	}
	
	if(((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET))&&(ebDecStandard == false))
	{
		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

#if 0 // if uEncStrSzPerFrame means One frame enc size.
		if(uEncStrSzPerFrame > g_uReadStreamSize)
		{
			MFC_ReadEncOneFrameStream((g_uStreamBufStAddr+g_uStreamBufOffset), (uEncStrSzPerFrame-g_uReadStreamSize));
			g_uStreamBufOffset += (uEncStrSzPerFrame-g_uReadStreamSize);
		}
#else	// if uEncStrSzPerFrame means enc size by allocated stream buffer size.
			MFC_ReadEncOneFrameStream((g_uStreamBufStAddr+g_uStreamBufOffset), (uEncStrSzPerFrame));
			g_uStreamBufOffset += uEncStrSzPerFrame;

#endif
		bOneFrameEncDone = true;
	}
	else if (eFlag == R2H_CMD_EDFU_INT_RET)
	{
		MFC_ReadEncOneFrameStream((g_uStreamBufStAddr+g_uStreamBufOffset), MFC_STR_BUF_SIZE);
#if 0
		g_uReadStreamSize += MFC_STR_BUF_SIZE;
#endif
		g_uStreamBufOffset += MFC_STR_BUF_SIZE;
		bOneFrameEncDone = false;
		MFC_ContinueEncoding();
 	}
	else if(eFlag == R2H_CMD_ENC_COMPLETE_RET)
	{
		Disp("Complete Encoding\n");
	}
	
	MFC_ClearPending();
	MFC_ClearRtnInstance();
	INTC_ClearVectAddr();
}

static void __irq Isr_MfcForDecBy2Ch(void)
{
	MFC_FACADE_RESPONSE eFlag;
	u32 uRtnId;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	MFC_DISP_TYPE eDispType;
	RESOL_CHANGE eResChange;
	u8 bProgressive;
	
	MFC_GetIntFlag(&eFlag);	

	if(eFlag==R2H_CMD_SEQ_DONE_RET)
	{
		MFC_GetPicResolution();
	}
	else if(eFlag==R2H_CMD_FRAME_DONE_RET)
	{
		if(eDecStandard[0] == H264_DEC)
		{
			MFC_GetDispInfo(&eDispType, &eResChange, &bProgressive);
			
			if(eDispType==DISP_ONLY)
				bDispOnlyFrame[0]=true;
			else
				bDispOnlyFrame[0]=false;
		}

		if((eDecStandard[0]!=H264_DEC)&&(bNoMoreStream[0]==false))
		{
			uFrameCnt[0]++;
			Disp("[%d]",uFrameCnt[0]);
		}
		
		if((eDecStandard[0]==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt[0]++;
			Disp("[%d] ",uFrameCnt[0]);
		}

		if(MFC_IsDecodingFinished())
		{
			bFinishedProcess[0] = true;
		}

		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC))
		{
			if(bFimcDinDout==true)
			{
				FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
				FIMC_StartProcessingForMfc(FIMC_A);
				FIMC_WaitForProcessingDone(FIMC_A);
				FIMC_StopProcessing(FIMC_A);
			}
			else
			{
				FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
				FIMC_StartProcessingForMfc(FIMC_A);
			}
		}
		bIsFirstFrame[0]=false;
	}
	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET)||
		(eFlag == R2H_CMD_ERR_RET)||(eFlag == R2H_CMD_SLICE_DONE_RET)||
		(eFlag == R2H_CMD_INIT_BUFFER_RET) || (eFlag == R2H_CMD_ENC_COMPLETE_RET))
	{
		MFC_ClearRtnInstance();
	}

	MFC_ClearPending();
	INTC_ClearVectAddr(); 
}

static void __irq Isr_MfcForMultiDec(void)
{
	u32 uRtnId;
	u32 uProcessIdx;
	u32 xPos, yPos;
	MFC_FACADE_RESPONSE eFlag;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	MFC_DISP_TYPE eDispType;
	
	MFC_GetIntFlag(&eFlag);	
	
	if(eFlag==R2H_CMD_SEQ_DONE_RET)
	{
		MFC_GetPicResolution();
	}
	else if(eFlag==R2H_CMD_FRAME_DONE_RET)
	{
		MFC_GetRtnInstanceId(&uRtnId);
		MFC_GetProcessIdxFromInstId(uRtnId, &uProcessIdx);

		if(MFC_IsDecodingFinished()&&(bFinishedProcess[uProcessIdx]==false))
		{
			bFinishedProcess[uProcessIdx] = true;
	 		Disp("[ID:%d] BUF FLUSHED\n", uRtnId);
			uFinishedProcessNum++;	
		}

		if((eDecStandard[uProcessIdx]!=H264_DEC)&&(bNoMoreStream[uProcessIdx]==false))
		{
			Disp("[ID:%d] %d\n",  uRtnId, uFrameCnt[uProcessIdx]);
			if(eFlag==R2H_CMD_ERR_RET)
				Disp("=> %s","DEC ERR");
			uFrameCnt[uProcessIdx]++; 	
		}
		else if(eDecStandard[uProcessIdx]==H264_DEC)
		{
			MFC_GetDispType(&eDispType);
			
			if(eDispType==DISP_ONLY)
			{
				bDispOnlyFrame[uProcessIdx]=true;
				uPreFrameSize[uProcessIdx]=uOneFrameSz[uProcessIdx];
				uRdPtr[uProcessIdx] = uRdPtr[uProcessIdx] - uOneFrameSz[uProcessIdx];
				uRemainSz[uProcessIdx] += uOneFrameSz[uProcessIdx];
			}
			else
			{
				bDispOnlyFrame[uProcessIdx]=false;
				Disp("[ID:%d] %d\n",  uRtnId, uFrameCnt[uProcessIdx]);
				if(eFlag==R2H_CMD_ERR_RET)
					Disp("=> %s","DEC ERR");
				uFrameCnt[uProcessIdx]++;
			}
		}

		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC))
		{
			xPos = uProcessIdx%uDispHorizontalDiv;
			yPos = uProcessIdx/uDispHorizontalDiv;	
			FIMC_InitIpForDinDout(FIMC_A,
				uFrameHsz[uProcessIdx], uFrameVsz[uProcessIdx],	0,
				0, 0, uFrameHsz[uProcessIdx], uFrameVsz[uProcessIdx],
				0, TILE_NV12,
				uLcdHSz, uLcdVSz,
				uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight,	0,
				uLcdFbAddr, eBpp,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
			FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(FIMC_A);
			FIMC_WaitForProcessingDone(FIMC_A);
			FIMC_StopProcessing(FIMC_A);
		}
		bIsFirstFrame[uProcessIdx]=false;
	}
	else if(eFlag==R2H_CMD_ERR_RET)
	{
		Disp("[ID:%d] %d \n",  uRtnId, uFrameCnt[uProcessIdx]);
		uFrameCnt[uProcessIdx]++; 
		Disp("DEC ERR\n");
	}
	
	// next instace interrupt is generated after current instance (rtn id==0xffff) && (Risc2Host==0) 
	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET)||
		(eFlag == R2H_CMD_ERR_RET)||(eFlag == R2H_CMD_SLICE_DONE_RET)||
		(eFlag == R2H_CMD_INIT_BUFFER_RET) || (eFlag == R2H_CMD_ENC_COMPLETE_RET))
	{
		MFC_ClearRtnInstance();
	}
	MFC_ClearPending();
	INTC_ClearVectAddr();
}

static void __irq Isr_MfcForClkCtrl(void)
{
	MFC_FACADE_RESPONSE eFlag;
	
	MFC_GetIntFlag(&eFlag);	

	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET)||
		(eFlag == R2H_CMD_ERR_RET)||(eFlag == R2H_CMD_SLICE_DONE_RET)||
		(eFlag == R2H_CMD_INIT_BUFFER_RET) || (eFlag == R2H_CMD_ENC_COMPLETE_RET))
	{
		if(eFlag==R2H_CMD_SEQ_DONE_RET)
			MFC_GetPicResolution();
#if 0
		if(eFlag==R2H_CMD_FRAME_DONE_RET)
			Disp("[FRAME]\n");
		if(eFlag==R2H_CMD_SLICE_DONE_RET)
			Disp("[SLICE]\n");
#endif			
		MFC_ClearRtnInstance();
	}

	MFC_ClearPending();

#if MFC_CLK_CONTROL
	SYSC_SetClkOFF_IP(eMFC);
#endif

	INTC_ClearVectAddr();
}

static void __irq Isr_FimcADone(void)
{
	FIMC_INTR_SRC eIntSrc;
	FIMC_GetIntrSrc(FIMC_A, &eIntSrc);
	//Disp("[A]\n");
	if(eIntSrc == FIMC_SUCCESS)
		bProcessingDoneA = true;
	else
		bProcessingDoneA = false;
	FIMC_ClearInterrupt(FIMC_A);
	INTC_ClearVectAddr();
}

static void __irq Isr_FimcBDone(void)
{
	FIMC_INTR_SRC eIntSrc;
	FIMC_GetIntrSrc(FIMC_B, &eIntSrc);
	//Disp("[B]\n");
	if(eIntSrc == FIMC_SUCCESS)
		bProcessingDoneB = true;
	else
		bProcessingDoneB = false;
	FIMC_ClearInterrupt(FIMC_B);
	INTC_ClearVectAddr();
}

static void __irq Isr_FimcCDone(void)
{
	FIMC_INTR_SRC eIntSrc;
	FIMC_GetIntrSrc(FIMC_C, &eIntSrc);
	//Disp("[C]\n");
	if(eIntSrc == FIMC_SUCCESS)
		bProcessingDoneC = true;
	else
		bProcessingDoneC = false;
	FIMC_ClearInterrupt(FIMC_C);
	INTC_ClearVectAddr();
}

static void __irq Isr_LcdcUnderRun(void)
{
	u32 uIntFlag;

	LCDC_GetIntFlag(&uIntFlag);
	Disp("[UR]\n");
	LCDC_ClearPending(uIntFlag);
	INTC_ClearVectAddr();
	uLcdcUnderRunCnt++;
}

static void __irq Isr_CsisIntSrc(void)
{
	u32 uCsisInt;
	u32 uIntStatus;
	u32 uIntMask;

	CSI_ChkIntStatus(&uIntStatus);
	CSI_GetIntMask(&uIntMask);

	uCsisInt = uIntMask&uIntStatus;	

	if(uCsisInt & (0x1<<0))
		Disp("Unknown ID error\n");

	if(uCsisInt & (0x1<<1))
		Disp("CRC error\n");

	if(uCsisInt & (0x1<<2))
		Disp("ECC error\n");

	if(uCsisInt & (0x1<<3))
		Disp("Overflow error\n");

	// Datalane 0~3 SOT error
	if(uCsisInt & (0xF<<12))
		Disp("Start of transmission error\n");

	if(uCsisInt & (0x1<<28))
		Disp("Embedded Data : OddAfter\n");

	if(uCsisInt & (0x1<<29))
		Disp("Embedded Data : OddBefore\n");

	if(uCsisInt & (0x1<<30))
		Disp("Embedded Data : EvenAfter\n");

	if(uCsisInt & (0x1u<<31))
		Disp("Embedded Data : EvenBefore\n");	

	CSI_ClearInterrupt(uCsisInt);
	INTC_ClearVectAddr();
}

static void __irq Isr_Mixer(void)
{
	MX_INTR_SRC eIntStatus;
	
	//Disp("MIXER_IRQHandler\n");

	MIXER_GetIntrSrc(&eIntStatus);

	switch(eIntStatus)
	{
		case VP_UNDERRUN	:		//Disp("Occured VP Under-Run Interrupt!!!!\n");
									//Pending Clear
									uVpUnderRunCnt++;
									Outp32(0xF920000c, 1<<VP_UNDERRUN);
									break;
		case GRP0_UNDERRUN	:		//Disp("Occured GRAPHIC0 Under-Run Interrupt!!!!\n");
									//Pending Clear
									uMixer0UnderRunCnt++;
									Outp32(0xF920000c, 1<<GRP0_UNDERRUN);
									break;
		case GRP1_UNDERRUN	:		//Disp("Occured GRAPHIC1 Under-Run Interrupt!!!!\n");
									//Pending Clear
									uMixer1UnderRunCnt++;
									Outp32(0xF920000c, 1<<GRP1_UNDERRUN);
									break;
		case LINEBUF_UNDERRUN	:	//Disp("Occured Line Buffer Under-Run Interrupt!!!!\n");
									//Pending Clear
									Outp32(0xF920000c, 1<<LINEBUF_UNDERRUN);
									break;
		default	:					Disp("Invalid Interrupt!!!!\n");	
									break;

	}

	INTC_ClearVectAddr();
}

static void __irq Isr_TimerForEnc(void)
{
	u32 uTmp, fimcaddr;
	s32 ret;
	u32 tmpYval;
	u32 tmpCbval;
	u32 IDRPeriodidx;
	
	if(uFrameCount >= 0xffff0000)
	{
		goto skip_out;
	}
	
	if(bMfsEncDone == true)
	{
		FIMC_GetDoutFrmCnt(FIMC_C,   &uFimcFrmCnt);

		switch(uFimcFrmCnt)
		{
			case 0:
				tmpYval = uEncAddrOfY[uFrameCount % 4];
				tmpCbval = uEncAddrOfC[uFrameCount % 4];
				uEncAddrOfY[uFrameCount % 4] = uOutImgAddr3OfY;
				uEncAddrOfC[uFrameCount % 4] = uOutImgAddr3OfC;
				uOutImgAddr3OfY = tmpYval;
				uOutImgAddr3OfC = tmpCbval;
				MFC_SetEncCurrentYCBufAddr(uEncAddrOfY[uFrameCount % 4], uEncAddrOfC[uFrameCount % 4]);	
				break;
			case 1:
				tmpYval = uEncAddrOfY[uFrameCount % 4];
				tmpCbval = uEncAddrOfC[uFrameCount % 4];
				uEncAddrOfY[uFrameCount % 4] = uOutImgAddr4OfY;
				uEncAddrOfC[uFrameCount % 4] = uOutImgAddr4OfC;
				uOutImgAddr4OfY = tmpYval;
				uOutImgAddr4OfC = tmpCbval;
				MFC_SetEncCurrentYCBufAddr(uEncAddrOfY[uFrameCount % 4], uEncAddrOfC[uFrameCount % 4]);	
				break;
			case 2:
				tmpYval = uEncAddrOfY[uFrameCount % 4];
				tmpCbval = uEncAddrOfC[uFrameCount % 4];
				uEncAddrOfY[uFrameCount % 4] = uOutImgAddr1OfY;
				uEncAddrOfC[uFrameCount % 4] = uOutImgAddr1OfC;
				uOutImgAddr1OfY = tmpYval;
				uOutImgAddr1OfC = tmpCbval;
				MFC_SetEncCurrentYCBufAddr(uEncAddrOfY[uFrameCount % 4], uEncAddrOfC[uFrameCount % 4]);	
				break;
			case 3:
				tmpYval = uEncAddrOfY[uFrameCount % 4];
				tmpCbval = uEncAddrOfC[uFrameCount % 4];
				uEncAddrOfY[uFrameCount % 4] = uOutImgAddr2OfY;
				uEncAddrOfC[uFrameCount % 4] = uOutImgAddr2OfC;
				uOutImgAddr2OfY = tmpYval;
				uOutImgAddr2OfC = tmpCbval;
				MFC_SetEncCurrentYCBufAddr(uEncAddrOfY[uFrameCount % 4], uEncAddrOfC[uFrameCount % 4]);	
				break;
			default:
				Assert(0);
				break;
		}
			
		FIMC_SetDoutDispAddrForMfc(FIMC_C, NV12,
		uOutImgAddr1OfY, uOutImgAddr2OfY, uOutImgAddr3OfY, uOutImgAddr4OfY, 
		uOutImgAddr1OfC, uOutImgAddr2OfC, uOutImgAddr3OfC, uOutImgAddr4OfC);

		bMfsEncDone = false;

		// encode a frame
		// Disp("[%d]", uFrameCount); 
		MFC_EncodingOneFrame(FRAME);

		if(uDisplayDevice & FIMC_DinFout)
		{
			//FIMC_SetChB();
			FIMC_SetDinImgAddrForMfc(FIMC_B, NV12, uSrcNv12YAddr, uSrcNv12CAddr);	
		}
	#if 0
		if(uDisplayDevice & HDMI_DemoOut)
		{		
			if(eTVScanMode == PROGRESSIVE)
				VP_SetStartAddress(uSrcNv12YAddr, uSrcNv12CAddr, uSrcNv12YAddr, uSrcNv12CAddr);
			else
				VP_SetStartAddress(uSrcNv12YAddr, uSrcNv12CAddr, uSrcNv12YAddr+uEncRawImgHsz*uEncRawImgVsz, uSrcNv12CAddr+uEncRawImgHsz*uEncRawImgVsz/2);	
		}
	#endif

	}
	else
	{
		Disp("Encoding Speed Slow [%d]\n", uFrameCount);
		uEncSlowCnt++;
	}

skip_out:


	uTmp = Inp32(rTINT_CSTAT);
	uTmp = (uTmp & 0x1f)| (1<<5);
	Outp32(rTINT_CSTAT,uTmp);       //  Timer0 Interrupt Clear register

	INTC_ClearVectAddr();
}


static void __irq Isr_MfcForEnc(void)
{
	u32 uTimer;
	u32 uEncStrSzPerFrame;
	MFC_FACADE_RESPONSE eFlag;

	MFC_GetIntFlag(&eFlag);
	if(eFlag == R2H_CMD_FRAME_DONE_RET)
	{
		Disp("[M]");
		//Disp("Frame Count : %3d   ", uFrameCount); 
		//Disp("^%d^", uFrameCount); 
		uFrameCount++;
		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
		//Disp("Stream Size : %6x   ",  uEncStrSzPerFrame );

		if ( uEncStrSzPerFrame == 0 )
		{
			Disp("Stream Count is 0 \n");
		}
		else
		{
			if(bPreviewMode)
			{
				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
		}
		bMfsEncDone = true;
	}
	else if(eFlag==R2H_CMD_SEQ_DONE_RET)
	{
		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
 		MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
		uStreamBufOffset += uEncStrSzPerFrame;
	}
	
	MFC_ClearPending();

	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET)||
		(eFlag == R2H_CMD_SLICE_DONE_RET)||(eFlag == R2H_CMD_INIT_BUFFER_RET)
		|| (eFlag == R2H_CMD_ENC_COMPLETE_RET))
	{
		MFC_ClearRtnInstance();
	}
	else if(eFlag==R2H_CMD_ERR_RET)
	{
		MFC_ClearRtnInstance();
		Disp("[ERR]\n");
	}

	INTC_ClearVectAddr();
}

static void DispCodecName(VIDEO_CODEC_TYPE eCodecType)
{
	char* cCodecModeStr;

	switch(eCodecType)
	{
		case MPEG4_DEC:
			cCodecModeStr = "MPEG4_DEC";
			break;
		case H264_DEC:
			cCodecModeStr = "H264_DEC";
			break;
		case DivX502_DEC:
			cCodecModeStr = "DivX502_DEC(Ver 5.00, 5.01, 5.02)";
			break;
		case DivX503_DEC:
			cCodecModeStr = "DivX503_DEC(Ver 5.03 and upper)";
			break;
		case DivX412_DEC:
			cCodecModeStr = "DivX412_DEC";
			break;
		case DivX311_DEC:
			cCodecModeStr = "DivX311_DEC";
			break;
		case XviD_DEC:
			cCodecModeStr = "XviD_DEC";
			break;
		case H263_DEC:
			cCodecModeStr = "H263_DEC";
			break;
		case MPEG2_DEC:
			cCodecModeStr = "MPEG2_DEC";
			break;
		case VC1RCV_DEC:
			cCodecModeStr = "VC1RCV_DEC";
			break;
		case VC1AP_DEC:
			cCodecModeStr = "VC1AP_DEC";
			break;
		case H264_ENC:
			cCodecModeStr = "H264_ENC";
			break;
		case MPEG4_ENC:
			cCodecModeStr = "MPEG4_ENC";
			break;
		case H263_ENC:
			cCodecModeStr = "H263_ENC";
			break;
		default:
			Assert(0);
			break;
	}

	Disp("Standard : %s\n", cCodecModeStr);
}

static u32 Lcdc_CheckFrameBufAddr(u32 uFrameAddr)
{
	u32 uWinBaseAddr;

	if( (uFrameAddr & 0x00e00000) == 0x00e00000)
		uWinBaseAddr= uFrameAddr+0x00200000;
	else
		uWinBaseAddr = uFrameAddr;
	
	return uWinBaseAddr;
}

static void LoadVsParsingInfo(VIDEO_CODEC_TYPE eDecStandard, u32 uStreamBufStAddr, 
	u32 uStreamSize, u32 uFrameInfoListAddr, u8 bIsRcv, u32* pStreamInFoIdx, u32* pFrameInFoListEndAddr)
{
	u32 i=0;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u8 bIsFirstFrame=true;
	u8 bFirstSeqheader=true;
		
	uRemainSz = uStreamSize;
	uRdPtr = uStreamBufStAddr;
	
	while(1)
	{
		uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, 
			&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, false);


		//if( (uRet==1)||(uRet==2) ) uOneFrameSz = uRemainSz;
		uRdPtr = uOneFrameAddr+uOneFrameSz;
		if(eDecStandard==VC1RCV_DEC)
		{
			if(bFirstSeqheader==true)
			{
				uRemainSz -= uOneFrameSz+8;
				bFirstSeqheader = false;
			}
			else
			{
  				uRemainSz -= uOneFrameSz+4;
			}
		}
		else
		{
			uRemainSz -= uOneFrameSz;
		}
		
		bIsFirstFrame=false;
		Outp32(uFrameInfoListAddr, uOneFrameAddr);
		Outp32(uFrameInfoListAddr+4, uOneFrameSz);
		uFrameInfoListAddr+=8;
		i++;

		if(uRet==3)
		{
			Disp("Parsing Error\n");
			return;
		}
		if(uRet==1 ||uRet==2)
			break;
	};
	*pStreamInFoIdx = i;
	*pFrameInFoListEndAddr = uFrameInfoListAddr;
	Disp("FrameList Done\n");
}

#if 0
static void TestDecoding(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstPostProcessing=true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	u32 uDispFrameCnt=0;
	u8 bFirstSeqheader=true;
	u32 uElapsedTime;
	u32 uConTextEndAddr;

	ebDecStandard=true;
	bFirstFimcFifoOut = true;

	uFwCodeStAddr =	0x20000000;
	uStreamFileStAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);

		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;
	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_SetCmdChNum(ONE_CH_CMD);

	if(bSliceBaseDec)
		MFC_SetDpbCfg(CMD_CH0, true, false, 0);
	else
		MFC_SetDpbCfg(CMD_CH0, false, false, 0);	
	
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		//uLcdFbAddr=Align(uFreeMemBufB, 0xe00000);
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream)
		{ 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
			
			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				bNoMoreStream=true;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		if(MFC_IsDecodingFinished())
		{
			Disp("Buffer flushed!\n");
			break;
		}

		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
		{	
			continue;
		}

		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");
}
#else // add resolution change procedure
static void TestDecoding(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstPostProcessing=true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	u32 uDispFrameCnt=0;
	u8 bFirstSeqheader=true;
	u32 uElapsedTime;
	u32 uConTextEndAddr;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	u8 bResChanged=false;
	MFC_DEC_TYPE eDecType;

	ebDecStandard=true;
	bFirstFimcFifoOut = true;

	uFwCodeStAddr =	0x20000000;
	uStreamFileStAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);

		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;

#if ONLY_SEQ_HEADER_PARSE_MODE	
	bFirstSeqheader = true;
#else
	bFirstSeqheader = false;
#endif

	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	Disp("[0]One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_SetCmdChNum(ONE_CH_CMD);

	if(bSliceBaseDec)
		MFC_SetDpbCfg(CMD_CH0, true, false, 0);
	else
		MFC_SetDpbCfg(CMD_CH0, false, false, 0);	
	
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		//uLcdFbAddr=Align(uFreeMemBufB, 0xe00000);
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;

#if ONLY_SEQ_HEADER_PARSE_MODE	
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
#else
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
#endif
		}
		else if((eResInfo == RESOL_INCR) || (eResInfo == RESOL_DECR) || (bResChanged==true))
		{
			if(bResChanged==false)
				eDecType = FRAME_START_REALLOC;
			else
				eDecType = FRAME;
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, eDecType);
			bResChanged = true;
		}
		else if(bNoMoreStream)
		{ 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
			
			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				bNoMoreStream=true;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		if(bResChanged == false)
		{
			if(MFC_IsDecodingFinished())
			{
				Disp("[DEC END]\n");
				break;
			}
		}
		else
		{	
			if(MFC_IsDecodingFinished())
			{
				Disp("[Resolution Reallocation & Restart]\n");

				bIsFirstFrame = true;
#if ONLY_SEQ_HEADER_PARSE_MODE
				bFirstSeqheader = true;
				uRdPtr = uRdPtr - uOneFrameSz;
				uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
				bFirstSeqheader = false;
				//Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eDecStandard==VC1RCV_DEC)
					uRemainSz -= uOneFrameSz+8;
				else
					uRemainSz -= uOneFrameSz;
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
#endif
				if(bSliceBaseDec)
					MFC_SetDpbCfg(CMD_CH0, true, false, 0);
				else
					MFC_SetDpbCfg(CMD_CH0, false, false, 0);	

				MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
				MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
				MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
				MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
				Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
				Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

				if(bFimcDinDout==false)
				{
					LCDC_InitBase();
					LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
					LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
					LCDC_SetWinOnOff(1, WIN0);
					LCDC_Start();
					FIMC_InitIpForDinFout(FIMC_A,
						uFrameHsz, uFrameVsz, 0,
						0, 0, uFrameHsz, uFrameVsz,
						NULL, TILE_NV12, false,
						uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
				}
				else
				{
					//uLcdFbAddr=Align(uFreeMemBufB, 0xe00000);
					uLcdFbAddr = uFreeMemBufB;
					LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
					LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
					LCDC_EnableAllWinFifoLvlInt(EMPTY);
					LCDC_Start();
					FIMC_InitIpForDinDout(FIMC_A,
						uFrameHsz, uFrameVsz, 0,
						0, 0, uFrameHsz, uFrameVsz,
						0, TILE_NV12,
						uLcdHSz, uLcdVSz,
						0, 0, uLcdHSz, uLcdVSz, 0,		
						uLcdFbAddr, eBpp,		
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
				}
				bResChanged = false;
			}
		}

		//MFC_GetDispType(&eDispType);
		MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
		{	
			continue;
		}

		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");
}
#endif

static void TestFastDecoding(void)
{
	u32 i, uIdx;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	char aFileName[MAX_FILENAME_SIZE];
	char pFileName[MAX_FILENAME_SIZE];
	char aFrameListName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uOneFrameAddrOffset;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uFrameHsz, uFrameVsz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uNumOfFrmList;
	u32 uStreamFileStAddr;
	u32 uFrameListEndAddr;
	u32 uFrameListAddr;
	u32 uFrmIndex=0;
	FRAME_INFO *pFrameInfoTable;
	u8 bMp4DeblkEn = false;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE FrameListEftInfo;
	t_file_handler FwHandler;
	t_file_handler StreamHandler;
	t_file_handler FrameListHandler;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame;
	u8 bNoMoreStream=false;
	u32 uRealReadSize;
	MFC_DISP_TYPE eDispType;
	
	ebDecStandard=true;
	bFirstFimcFifoOut = true;
	
	uStreamFileStAddr = 0x41000000;
	uFreeMemBuf=uStreamFileStAddr;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize; //file size
		uFreeMemBuf += uStreamFileSize;
	}
	else
	{	
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);
		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Invalid file name.\n");
			return;
		}
		EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
		uStreamFileSize = StreamEftInfo.fileSize; //file size
		uFreeMemBuf += uStreamFileSize;
		EFT_GetFileNameExt(aFileName, cFileExt);
	}
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	bIsFirstFrame = true;

	uFrameListAddr = Align(uFreeMemBuf, 16);

	strcpy(pFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (pFileName[--uIdx] == '.')
			break;
	}
	strcpy(&pFileName[uIdx+1], "Info"); 

	if(bSdLoadMode)
	{
		if(FS_Open(pFileName, &FrameListHandler)!=0)
			return;
		if(FS_Read(&FrameListHandler, FrameListHandler.nSize, (u32 *)uFrameListAddr, &uRealReadSize) !=0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		uNumOfFrmList = FrameListHandler.nSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListHandler.nSize;
	}
	else
	{	
		sprintf(aFrameListName,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\", pFileName);

		FrameListEftInfo = EFT_RequestFileInfo(aFrameListName);
		if(FrameListEftInfo.fileID==-1 || FrameListEftInfo.fileSize==0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		EFT_ReadFile(&FrameListEftInfo, (u32 *)(uFrameListAddr));
		uNumOfFrmList = FrameListEftInfo.fileSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListEftInfo.fileSize;
	}

	uDramBBaseAddr = Align(uFrameListEndAddr, 128*1024);
	uFwCodeStAddr = 0x20000000;
	
	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)(uFwCodeStAddr));
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	DispCodecName(eDecStandard);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	pFrameInfoTable = (FRAME_INFO*)uFrameListAddr;
	uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
	uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
	uFrmIndex++;
	
	Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr,  uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		uLcdFbAddr=uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}
	
	uFrameCnt = 0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(uFrmIndex==uNumOfFrmList)
		{ 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
			uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;

			if(uFrmIndex==uNumOfFrmList-1)
			{
				Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				Disp("Empty\n");
			}
			else
			{
				Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			
			uFrmIndex++;
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished())
			break;
		
		if(uFrmIndex!=uNumOfFrmList)
		{
			uFrameCnt++;
			Disp("[%d]\n",uFrameCnt);
		}
		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		
		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);

	Disp("Decoding Done All Frame!!!\n");
	Disp("Total Frame Count : %d\n", uFrameCnt);
}

static void TestDecodingBy2Ch(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	MFC_CMD_CH_NUM ePreparedCh;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uLastFrameSz;
	u32 uInstanceId;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uPicHsz, uPicVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uFrameHsz, uFrameVsz;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	u32 uRealReadSize;
	u32 uCurCpbBufStAddr;
	u32 uFileOffset;
	u32 uReadSizeUnit;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uFreeMemBufA, uFreeMemBufB;	
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bPartialLoad=false;
	u8 bMp4DeblkEn = false;
	u8 bFirstSeqheader = true;
	
	bFinishedProcess[0] = false;
	bNoMoreStream[0] = false;
	uFrameCnt[0]=0;

	uFwCodeStAddr = 0x20000000;
	uStreamFileStAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
		}
		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		uStreamFileSize = StreamEftInfo.fileSize; 
	
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else //(uStreamFileSize>STREAM_FILE_BUF_SIZE)
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		
		EFT_GetFileNameExt(aFileName, cFileExt);
		uDramBBaseAddr = Align(uStreamFileStAddr+uStreamFileSize, 128*1024);

		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard[0])==false)
		return;

	INTC_SetVectAddr(NUM_MFC, Isr_MfcForDecBy2Ch);
	INTC_Enable(NUM_MFC);

	DispCodecName(eDecStandard[0]);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard[0], bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame[0] = true;
	uRemainSz = uStreamFileSize;
	uRet = VsParser(eDecStandard[0], uStreamFileStAddr, uStreamFileSize,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard[0]==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);	
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);	
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{	
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0, // Scaler		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bFinishedProcess[0] == false)
		{
			if(bIsFirstFrame[0]==true)
			{
				bIsFirstFrame[0] = false;
				if(eDecStandard[0] == H263_DEC)
				{
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);	
				}
				else
				{
					continue;
				}
			}
			else if(bNoMoreStream[0]==true)
			{ 
				while(!MFC_GetPreparedChAndCpbBuf(&ePreparedCh, &uCurCpbBufStAddr));	
				MFC_StartDecodingOneFrame(ePreparedCh, 0, LAST_SEQ);
			}
			else if((eDecStandard[0] == H264_DEC) && (bDispOnlyFrame[0]==true) && (bNoMoreStream[0]==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(ePreparedCh);
			}
			else
			{
				uOneFrameSz = 0;
				uRet = VsParser(eDecStandard[0], uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
				//Disp("uOneFrameAddr : 0x%x, uOneFrameSz: %d\n", uOneFrameAddr, uOneFrameSz);
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eDecStandard[0]==VC1RCV_DEC)	
					uRemainSz -= uOneFrameSz+4;
				else
					uRemainSz -= uOneFrameSz;	
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					while(!MFC_GetPreparedChAndCpbBuf(&ePreparedCh, &uCurCpbBufStAddr));	
					Copy8(uOneFrameAddr, uCurCpbBufStAddr, uOneFrameSz);	
					MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz, FRAME);
				}
				else if((uRet==1) || (uRet==2))
				{
					if(uTotalRemainSz && bPartialLoad)
					{
						uTotalRemainSz += uRemainSz;
						if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
						{
							uFileOffset -= uRemainSz;
							uReadSizeUnit = STREAM_FILE_BUF_SIZE;
						}
						else
						{
							uFileOffset-= uRemainSz;
							uReadSizeUnit = uTotalRemainSz;
						}
						if(bSdLoadMode)
						{
							if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
							{
								Disp("Seek Fail\n");
								return;
							}
							if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
							{
								Disp("Stream Read Fail\n");
								return;
							}
							uFileOffset = StreamHandler.nOffset;
						}
						else
						{
							EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
							uFileOffset += uReadSizeUnit;
						}
						uTotalRemainSz = uStreamFileSize-uFileOffset;
						uRdPtr = uStreamFileStAddr;
						uRemainSz = uReadSizeUnit;
						continue;
					}

					bNoMoreStream[0]=true;
					while(!MFC_GetPreparedChAndCpbBuf(&ePreparedCh, &uCurCpbBufStAddr));	
					Copy8(uOneFrameAddr, uCurCpbBufStAddr, uOneFrameSz);	
					MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz, LAST_SEQ);
					uLastFrameSz = uOneFrameSz;
				}
				else
					Assert(0);	
			}
		}
		else
			break;
	}

	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Decoding Done All Frame!!!\n");
	Disp("Total Frame Count : %d\n", uFrameCnt[0]);
}

#if 0
static void TestDecodingForPerformance(void)
{
	u32 i, uIdx;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	char aFileName[MAX_FILENAME_SIZE];
	char pFileName[MAX_FILENAME_SIZE];
	char aFrameListName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uOneFrameAddrOffset;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u8 bIsRcv;
	u32 uFrameCount;
	u8 bIsFirstFrame=true;
	u32 uPicHsz, uPicVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uFrameHsz, uFrameVsz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uNumOfFrmList;
	u32 uStreamFileStAddr;
	u32 uFrameListEndAddr;
	u32 uFrameListAddr;
	u32 uFrmIndex=0;
	FRAME_INFO *pFrameInfoTable;
	u8 bMp4DeblkEn = false;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE FrameListEftInfo;
	t_file_handler FwHandler;
	t_file_handler StreamHandler;
	t_file_handler FrameListHandler;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame=false;
	u8 bNoMoreStream=false;
	u32 uRealReadSize;
	MFC_DISP_TYPE eDispType;
	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u32 uOneDecMaxElapaedTime=0;
	u32 uOneDecMaxElaspedFrame=0;
	u32 uBurstTransSize;
	
	ebDecStandard=true;
	uLcdcUnderRunCnt=0;
	
	uStreamFileStAddr = 0x41000000;
	uFreeMemBuf=uStreamFileStAddr;
	uFwCodeStAddr = 0x20000000;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize; //file size
		uFreeMemBuf += uStreamFileSize;
	}
	else
	{	
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);
		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Invalid file name.\n");
			return;
		}
		EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
		uStreamFileSize = StreamEftInfo.fileSize; //file size
		uFreeMemBuf += uStreamFileSize;
		EFT_GetFileNameExt(aFileName, cFileExt);
	}
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	bIsFirstFrame = true;

	uFrameListAddr = Align(uFreeMemBuf, 16);

	strcpy(pFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (pFileName[--uIdx] == '.')
			break;
	}
	strcpy(&pFileName[uIdx+1], "Info"); 

	if(bSdLoadMode)
	{
		if(FS_Open(pFileName, &FrameListHandler)!=0)
			return;
		if(FS_Read(&FrameListHandler, FrameListHandler.nSize, (u32 *)uFrameListAddr, &uRealReadSize) !=0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		uNumOfFrmList = FrameListHandler.nSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListHandler.nSize;
	}
	else
	{	
		sprintf(aFrameListName,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\", pFileName);

		FrameListEftInfo = EFT_RequestFileInfo(aFrameListName);
		if(FrameListEftInfo.fileID==-1 || FrameListEftInfo.fileSize==0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		EFT_ReadFile(&FrameListEftInfo, (u32 *)(uFrameListAddr));
		uNumOfFrmList = FrameListEftInfo.fileSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListEftInfo.fileSize;
	}

	uDramBBaseAddr = Align(uFrameListEndAddr, 128*1024);

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)(uFwCodeStAddr));
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	INTC_Enable(NUM_LCD0);	

	DispCodecName(eDecStandard);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false); 
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	pFrameInfoTable = (FRAME_INFO*)uFrameListAddr;
	uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
	uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
	uFrmIndex++;


	Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr,  uOneFrameSz);

	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

#ifdef FIMC_DIN_FOUT
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
	FIMC_InitIpForDinFout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		NULL, TILE_NV12, false,				// 800x480 ROT90 
		uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	Disp("FIMD DMA in FIFO out\n");
#else
	uFreeMemBufB = Align(uFreeMemBufB, 0xe00000);
	uLcdFbAddr=uFreeMemBufB;
	LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_Start();

	#if 0
	FIMC_InitIpForDinDout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		0, TILE_NV12,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdVSz, uLcdHSz, 0,		// ROT 90
		uLcdFbAddr, eBpp,		
		ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	// 480x358
	FIMC_InitIpForDinDout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		0, TILE_NV12,
		uLcdHSz, uLcdVSz,
		0, 0, 480, 358, 0,		// 480x358 ROT_NO
		uFreeMemBufA, eBpp,		
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	#endif
	FIMC_InitIpForDinDout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		0, TILE_NV12,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdVSz, 0,		// ROT 90
		uLcdFbAddr, eBpp,		
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);

	Disp("FIMD DMA in DMA out\n");
#endif

	uFrameCount= 0;
//	StartTimer(0);
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				StartTimer(0);
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(uFrmIndex==uNumOfFrmList)
		{	
			bNoMoreStream = true;
			StartTimer(0); 
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			StartTimer(0);
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
			uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
			Disp("OneFrameAddrOffset : 0x%x\t", uOneFrameAddrOffset);

			Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr, uOneFrameSz);

			StartTimer(0);
			if(uFrmIndex==uNumOfFrmList-1)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}

			uFrmIndex++;
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}

#if 0
		if(bDispOnlyFrame==false)
		{
			uElapsedTime=StopTimer(0);
			Disp("[%d] : Elasped Time: %d", uFrameCount,uElapsedTime);
		//uTotElapsedTime += uElapsedTime;
		}
#else
		uElapsedTime=StopTimer(0);
		uTotElapsedTime += uElapsedTime;

		if(bDispOnlyFrame==false)
			Disp("[%d] : Elasped Time: %d", uFrameCount,uElapsedTime);
		else
			Disp("[%d] : Disp Only Elasped Time: %d", uFrameCount,uElapsedTime);			
#endif
		if(MFC_IsDecodingFinished())
			break;
	
		if(uFrmIndex!=uNumOfFrmList)
		{
			uFrameCount++;
			Disp("[%d]\n",uFrameCount);
		}
		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;	
	
		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		
		bProcessingDoneA = false;
#if 0
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		FIMC_StartProcessingForMfc(FIMC_A);

		while(!bProcessingDoneA);
#endif

	}

	uElapsedTime=StopTimer(0);
	uTotElapsedTime += uElapsedTime;

#if 0	
	FIMC_StopProcessing(FIMC_A);
#endif

	MFC_CloseInstance(uInstanceId);

	Disp("Decoding Done All Frame!!!\n");
	Disp("One Den Max Elapsed Time : %d\n", uOneDecMaxElapaedTime);
	Disp("One Den Max Elapsed Frame Number : %d\n", uOneDecMaxElaspedFrame);
	Disp("Total Frame Count : %d\n", uFrameCount);
	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uFrameCount*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));
}
#else
static void TestDecodingForPerformance(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uRet;
	u32 uRdPtr;
	u8 bIsRcv;
	u32 uRemainSz;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	u32 uFwCodeStAddr;
	u32 uRealReadSize;
	u32 uReadSizeUnit;
	u8 bDispOnlyFrame;
	u8 bFirstPostProcessing=true;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u8 bFirstSeqheader=true;
	MFC_DISP_TYPE eDispType; 
 	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u32 uTotalRemainSz;
	u8 bPartialLoad;
	u32 uFileOffset;
	
	ebDecStandard=true;
	bFirstFimcFifoOut=true;
	uFwCodeStAddr =	0x20000000;
	uStreamFileStAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
				
		EFT_GetFileNameExt(aFileName, cFileExt);

		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	if(bFimcDinDout==true)
	{
		INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
		INTC_Enable(NUM_FIMC_A);	
	}
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uStreamFileSize;
	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_SetCmdChNum(ONE_CH_CMD);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

#if 0
	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}
#endif

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}			
		}
		else if(bNoMoreStream)
		{
			StartTimer(0); 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}	
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			StartTimer(0);
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);

			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
 				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
 				StartTimer(0);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				bNoMoreStream=true;
 				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);				
				StartTimer(0);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
				Assert(0);
			
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		
		uElapsedTime=StopTimer(0);
		uTotElapsedTime += uElapsedTime;

		if(MFC_IsDecodingFinished())
		{
			Disp("Buffer flushed!\n");
			break;
		}

		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
#if 0
		if(bDispOnlyFrame==false)
			Disp("[%d] : Elasped Time: %d\n", uFrameCnt, uElapsedTime);
		else
			Disp("[%d] : DispOnly Time: %d\n", uFrameCnt, uElapsedTime);			
#endif

		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == true)
		{	
#if 0
			bProcessingDoneA = false;
			FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			if(bFimcDinDout==true)
			{		
				FIMC_StartProcessingForMfc(FIMC_A);
				while(!bProcessingDoneA);			
				FIMC_StopProcessing(FIMC_A);

			}
			else
			{
				if(bFirstFimcFifoOut)
				{
					FIMC_StartProcessingForMfc(FIMC_A);
					bFirstFimcFifoOut = false;
				}
			}
#endif
		}

		//uElapsedTime=StopTimer(0);
		//uTotElapsedTime += uElapsedTime;
  	}
#if 0
	if(bFimcDinDout==false)
	{
		FIMC_StopProcessing(FIMC_A);
	}
#endif

	MFC_CloseInstance(uInstanceId);
	Disp("Decoding Done All Frame!!!\n");
	Disp("Total Frame Count : %d\n", uFrameCnt); 
 	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uFrameCnt*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));
 }
#endif

#if 0
static void TestDecodingWithCrcComparison(void)
{
	u32 i, uIdx;
	u32 uStreamFileStAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	MFC_DISP_TYPE eDispType;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	char cCodecName[50];
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uErrorCnt=0;
	u32 uFileOffset;
	u32 uReadSizeUnit;
	u32 uTotalRemainSz;
	MFC_PIC_TYPE ePictype;
	u32 uCrcBufStAddr=0x46000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;	
	u32 uH264FirstErrFrameNum=0;
	u32 uRealReadSize;
	ETHERNET_FILE StreamEthernetFile;
	ETHERNET_FILE CrcFileEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CrcFileHandler;	
	u8 binterlace=false;
	u8 bNoMoreStream = false;
	u8 bPartialLoad = false;
	u8 bOneFrameStream=false;
	u8 bMustbeChecked=true;
	u8 bDispOnlyFrame=false;
	u8 bFirstSeqheader=true;
	u32 uNumOfCrc;

	ebDecStandard=true;

	uFwCodeStAddr = 0x21000000;
	uStreamFileStAddr = 0x41000000;

#if 1
	if(!bConformanceTestAll)
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);
	}
#endif	

	if(bSdLoadMode)
	{
		// 1. Stream load 
#if 1
		if(FS_Open(aFileName, &StreamHandler)!=0)
			return;
	
		FS_GetFileNameExt(aFileName, cFileExt);
#else
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;		
#endif
		uStreamFileSize=StreamHandler.nSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		// 2. REF CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else // ethernet mode
	{
		// 1. Stream load
		if(eStandard == H263_DEC)
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\H263\\Stream\\",aFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\VC1\\Stream\\all_stream\\",aFileName);

		StreamEthernetFile = EFT_RequestFileInfo(aStreamFilePath);
		if(StreamEthernetFile.fileID==-1 || StreamEthernetFile.fileSize==0)
		{
			Disp("invalid stream file name \n");
			return;
		}
		uStreamFileSize = StreamEthernetFile.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEthernetFile, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		
		// 2. Ref CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 16);

		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 

		if(eStandard == H263_DEC)
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\H263\\RefCrc\\",aCrcFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\VC1\\RefCrc\\",aCrcFileName);		
			
		CrcFileEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcFileEftInfo.fileID==-1 || CrcFileEftInfo.fileSize==0)
		{
			Disp("Invalid file name \n");
			return;
		}
		EFT_ReadFile(&CrcFileEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcFileEftInfo.fileSize; 
		uDramBBaseAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("Invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	if(MFC_GetCodecType(cFileExt, &eStandard)==false)
		return;
	DispCodecName(eStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	uRemainSz  = uReadSizeUnit;

	uRet = VsParser(eStandard, uStreamFileStAddr, uRemainSz,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader);
	bFirstSeqheader = false;
	//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);

	bIsFirstFrame = true;	

	if((uRet==1) && (bPartialLoad==false))
	{
		uOneFrameSz = uStreamFileSize;
		bNoMoreStream = true;
		bOneFrameStream = true;
	}
	else if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;

	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	while(!bBufferInitDone);
	bBufferInitDone = false;
	uFrameCnt = 0;	
	uCurCrcBufStAddr = uCrcBufStAddr;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true )	
		{
			bIsFirstFrame = false;
			if(eStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader);
			//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);
						
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eStandard==VC1RCV_DEC)	
					uRemainSz -= uOneFrameSz+4;
				else
					uRemainSz -= uOneFrameSz;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1)||(uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}
					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
			
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;	
					continue;
				}

				if((eStandard!=H264_DEC))
					break; // last frame decoding skip
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
				bMustbeChecked = false;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished() || ((bMustbeChecked==false) && bOneFrameStream))	// Because One frame stream
			break;

		if(!bNoMoreStream)
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}
		
		MFC_GetPictureType(&ePictype, &binterlace);
		if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
		{
			if((eStandard != H264_DEC) && (ePictype == SKIP_FRAME))
				continue;
				
			if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(uNumOfCrc==2)
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 8);
				uCurCrcBufStAddr+=8;
				uRefCrcBufAddr+=8;
			}
			else // uNumOfCrc==4
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 16);
				uCurCrcBufStAddr+=16;
				uRefCrcBufAddr+=16;
			}
			if(uRefCrcFileSize == (uCurCrcBufStAddr-uCrcBufStAddr))
				break;
		}
		
		if(bOneFrameStream)
			bMustbeChecked = false;
		if(uErrorCnt>5) break;
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);

	if(eStandard != H264_DEC)	
		uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;
	else
		uTotCrcSize = uRefCrcFileSize;

	if(uRefCrcFileSize>=uTotCrcSize)
	{
		if(eStandard==VC1AP_DEC)
		{
			if( (uRefCrcFileSize-uTotCrcSize)>16 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
		else
		{
			if( (uRefCrcFileSize-uTotCrcSize)>8 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
	}
	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}

	if(uErrorCnt)
	{
		strcpy(&aCrcFileName[uIdx+1], "err.crc");
		if(eStandard == H263_DEC)
			sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\error\\",aCrcFileName);
		else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\error\\",aCrcFileName);
		else if(eStandard == H264_DEC)
			sprintf(aGotCrcPath,"%s%s_[%d]_FrameDiff","E:\\CCV\\SA2\\SW\\K-FileServer\\",aCrcFileName, uH264FirstErrFrameNum);		
		CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
		EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, 0);
	}
	
	if(bSaveResult)
	{
		strcpy(&aCrcFileName[uIdx+1], "result.crc");

		if(bSdLoadMode)
		{
			FS_Creat(aCrcFileName, &CrcFileHandler);
			FS_Write(&CrcFileHandler, uTotCrcSize, (u32 *)uCrcBufStAddr, &uRealReadSize);
		}
		else
		{
			if(eStandard == H263_DEC)
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\result\\",aCrcFileName);
			else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\result\\",aCrcFileName);

			CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
			EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, uTotCrcSize);
		}
		if(uErrorCnt)
		{
			strcpy(&aCrcFileName[uIdx+1], "err.crc");

			if(bSdLoadMode)
			{
				FS_Creat(aCrcFileName, &CrcFileHandler);
				FS_Write(&CrcFileHandler, 0, (u32 *)uCrcBufStAddr, &uRealReadSize);
			}
			else
			{
				if(eStandard == H263_DEC)
					sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\error\\",aCrcFileName);
				else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
					sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\error\\",aCrcFileName);
				else if(eStandard == H264_DEC)
					sprintf(aGotCrcPath,"%s%s_[%d]_FrameDiff","E:\\CCV\\SA2\\SW\\K-FileServer\\",aCrcFileName, uH264FirstErrFrameNum);		
				CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
				EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, 0);
			}
		}
	}
}
#else
static void TestDecodingWithCrcComparison(void)
{
	u32 i, uIdx;
	u32 uStreamFileStAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	MFC_DISP_TYPE eDispType;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	char cCodecName[50];
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uErrorCnt=0;
	u32 uFileOffset;
	u32 uReadSizeUnit;
	u32 uTotalRemainSz;
	MFC_PIC_TYPE ePictype;
	u32 uCrcBufStAddr=0x24000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;	
	u32 uH264FirstErrFrameNum=0;
	u32 uRealReadSize;
	ETHERNET_FILE StreamEthernetFile;
	ETHERNET_FILE CrcFileEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CrcFileHandler;	
	u8 binterlace=false;
	u8 bNoMoreStream = false;
	u8 bPartialLoad = false;
	u8 bOneFrameStream=false;
	u8 bMustbeChecked=true;
	u8 bDispOnlyFrame=false;
	u8 bFirstSeqheader=true;
	u32 uNumOfCrc;
	u32 uElapsedTime;
	u8 bLastFrame=false;

	ebDecStandard=true;

	uFwCodeStAddr = 0x21000000;
	uStreamFileStAddr = 0x41000000;

#if 1
	if(!bConformanceTestAll)
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);
	}
#endif	

	if(bSdLoadMode)
	{
		// 1. Stream load 
#if 1
		if(FS_Open(aFileName, &StreamHandler)!=0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
	
		FS_GetFileNameExt(aFileName, cFileExt);
#else
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;		
#endif
		uStreamFileSize=StreamHandler.nSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		// 2. REF CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		if(bFirstConformance == true)
		{
			if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
				return;
			if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
			{
				Disp("F/W Read Fail\n");
				return;
			}
		}
	}
	else // ethernet mode
	{
		// 1. Stream load
		if(eStandard == H263_DEC)
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\H263\\Stream\\",aFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\VC1\\Stream\\all_stream\\",aFileName);

		StreamEthernetFile = EFT_RequestFileInfo(aStreamFilePath);
		if(StreamEthernetFile.fileID==-1 || StreamEthernetFile.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEthernetFile.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEthernetFile, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		
		// 2. Ref CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 16);

		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 

		if(eStandard == H263_DEC)
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\H263\\RefCrc\\",aCrcFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\VC1\\RefCrc\\",aCrcFileName);		
			
		CrcFileEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcFileEftInfo.fileID==-1 || CrcFileEftInfo.fileSize==0)
		{
			Disp("CRC File Open Fail\n");
			return;
		}
		EFT_ReadFile(&CrcFileEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcFileEftInfo.fileSize; 
		uDramBBaseAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		if(bFirstConformance == true)
		{
			FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
			if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
			{
				Disp("F/W Open Fail\n");
				return;
			}
			EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
		}
	}

	if(MFC_GetCodecType(cFileExt, &eStandard)==false)
		return;
	DispCodecName(eStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);

	if(bFirstConformance == true)
	{
		uDramBBaseAddr = 0x45500000;
		MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
		bFirstConformance = false;
	}
	MFC_InitProcessForDecoding(0, eStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	uRemainSz  = uReadSizeUnit;

	uRet = VsParser(eStandard, uStreamFileStAddr, uRemainSz,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);

	bIsFirstFrame = true;	

	if((uRet==1) && (bPartialLoad==false))
	{
		uOneFrameSz = uStreamFileSize;
		bNoMoreStream = true;
		bOneFrameStream = true;
	}
	else if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;

	MFC_SetDpbCfg(CMD_CH0, false, false, 0);	
	
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;	
	uCurCrcBufStAddr = uCrcBufStAddr;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true )	
		{
			bIsFirstFrame = false;
			if(eStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);
						
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eStandard==VC1RCV_DEC)	
					uRemainSz -= uOneFrameSz+4;
				else
					uRemainSz -= uOneFrameSz;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);

				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1)||(uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}
					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
			
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;	
					continue;
				}

				if((eStandard!=H264_DEC))
					break; // last frame decoding skip
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);

				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
				if((eStandard!=H264_DEC))
					bMustbeChecked = false;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
	
		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;

		if(MFC_IsDecodingFinished() || ((bMustbeChecked==false) && bOneFrameStream))	// Because One frame stream
		//if(MFC_IsDecodingFinished())	// Because One frame stream
			break;
		
		if((eStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}
		
		if((eStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			//Disp("[%d] ",uFrameCnt);
		}
		
		MFC_GetPictureType(&ePictype, &binterlace);
		if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
		{			
			if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(uNumOfCrc==2)
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 8);
				uCurCrcBufStAddr+=8;
				uRefCrcBufAddr+=8;
			}
			else // uNumOfCrc==4
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 16);
				uCurCrcBufStAddr+=16;
				uRefCrcBufAddr+=16;
			}
			if(uRefCrcFileSize == (uCurCrcBufStAddr-uCrcBufStAddr))
				break;
		}
		
		if(bOneFrameStream)
			bMustbeChecked = false;
		if(uErrorCnt>5) break;
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);
	
#if 1
	if(eStandard != H264_DEC)	
		uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;
	else
		uTotCrcSize = uRefCrcFileSize;
	if(uRefCrcFileSize>=uTotCrcSize)
	{
		if(eStandard==VC1AP_DEC)
		{
			if( (uRefCrcFileSize-uTotCrcSize)>16 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
		else
		{
			if( (uRefCrcFileSize-uTotCrcSize)>8 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
	}
#endif

	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}

	if(uErrorCnt)
	{
		if(bSdLoadMode)
		{
		}
		else
		{
			strcpy(&aCrcFileName[uIdx+1], "err.crc");
			if(eStandard == H263_DEC)
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\error\\",aCrcFileName);
			else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\error\\",aCrcFileName);
			else if(eStandard == H264_DEC)
				sprintf(aGotCrcPath,"%s%s_[%d]_FrameDiff","E:\\CCV\\SA2\\SW\\K-FileServer\\",aCrcFileName, uH264FirstErrFrameNum);		
			CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
			EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, 0);
		}
	}
	
	if(bSaveResult)
	{
		strcpy(&aCrcFileName[uIdx+1], "result.crc");

		if(bSdLoadMode)
		{
			FS_Creat(aCrcFileName, &CrcFileHandler);
			FS_Write(&CrcFileHandler, uTotCrcSize, (u32 *)uCrcBufStAddr, &uRealReadSize);
		}
		else
		{
			if(eStandard == H263_DEC)
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\result\\",aCrcFileName);
			else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
				sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\result\\",aCrcFileName);

			CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
			EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, uTotCrcSize);
		}
		if(uErrorCnt)
		{
			strcpy(&aCrcFileName[uIdx+1], "err.crc");

			if(bSdLoadMode)
			{
				FS_Creat(aCrcFileName, &CrcFileHandler);
				FS_Write(&CrcFileHandler, 0, (u32 *)uCrcBufStAddr, &uRealReadSize);
			}
			else
			{
				if(eStandard == H263_DEC)
					sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\H263\\error\\",aCrcFileName);
				else if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
					sprintf(aGotCrcPath,"%s%s","E:\\dec_result\\VC1\\error\\",aCrcFileName);
				else if(eStandard == H264_DEC)
					sprintf(aGotCrcPath,"%s%s_[%d]_FrameDiff","E:\\CCV\\SA2\\SW\\K-FileServer\\",aCrcFileName, uH264FirstErrFrameNum);		
				CrcFileEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
				EFT_WriteFile(&CrcFileEftInfo, (u32 *)uCrcBufStAddr, 0);
			}
		}
	}
}
#endif


#if 1
static void TestDecodingWithDivX311CrcComparison(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	ETHERNET_FILE AviEftInfo;
	ETHERNET_FILE CrcEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	AVI_INFO sAviInfo;
	int uChunkSize;
	int uAudioChunk;
	u32 uAviFileSize;
	u8* pFileSteamAddr;
	int AviOffsetTmp;
	int ChunkSizeTmp;
	int Codec;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uCrcBufStAddr= 0x47000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	u32 uNumOfCrc;

	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;
	uAviFileAddr = 0x41000000;

	bConformanceTestAll = true;
	if(!bConformanceTestAll)
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);
	}

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_Open(aFileName, &AviHandler)!=0)
			return;

		if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uAviFileSize = AviHandler.nSize;
		// 2. REF CRC load
		uRefCrcBufAddr = Align(uAviFileAddr+uAviFileSize, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);

		// 3. FW load	
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
	// 1. Stream load
		sprintf(aAviFilePath,"%s%s","X:\\MPEG4\\STREAM\\DivX_3\\",aFileName);

		AviEftInfo = EFT_RequestFileInfo(aAviFilePath);
		if(AviEftInfo.fileID==-1 || AviEftInfo.fileSize==0)
		{
			Disp("Avi Open Fail\n");
			return;
		}
		uAviFileSize = AviEftInfo.fileSize;

		EFT_ReadFile(&AviEftInfo, (u32 *)uAviFileAddr);
		uReadSizeUnit = uAviFileSize; 

		uAviFileEndAddr=uAviFileAddr+uAviFileSize;
		
		//2. Golden CRC load 
		uRefCrcBufAddr = Align(uAviFileAddr+uAviFileSize, 16);
		
		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 
		sprintf(aRefCrcPath,"%s%s","X:\\MPEG4\\STREAM\\REFCRC\\",aCrcFileName);
			
		CrcEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcEftInfo.fileID==-1 || CrcEftInfo.fileSize==0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		EFT_ReadFile(&CrcEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcEftInfo.fileSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W  Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	
	bIsFirstFrame = true;
	if(!AVI_IsAVIFile((char *)uAviFileAddr))
	{
		Disp("This is NOT AVI file!\n");
		return;
	}
	if(AVI_OpenAVIFile((char *)uAviFileAddr, &sAviInfo))
	{
		Codec = AVI_GetVideoCodec(&sAviInfo);

		switch(Codec)
		{
			case AVI_VIDEO_CODEC_H263:
				eDecStandard = H263_DEC;
				Disp("This is H263 video codec\n");
				break;
			case AVI_VIDEO_CODEC_H264:
			case AVI_VIDEO_CODEC_h264:
				eDecStandard = H264_DEC;
				Disp("This is H264 video codec\n");
				break;
			case AVI_VIDEO_CODEC_MPEG4:
			case AVI_VIDEO_CODEC_divx:
			case AVI_VIDEO_CODEC_MP43:
			case AVI_VIDEO_CODEC_dx50:
			case AVI_VIDEO_CODEC_XVID:
			case AVI_VIDEO_CODEC_xvid:
				eDecStandard = MPEG4_DEC;
				Disp("This is MPEG4 video codec\n");
				break;		
			case AVI_VIDEO_CODEC_DVIX3:
			case AVI_VIDEO_CODEC_div3:
				eDecStandard = DivX311_DEC;
				Disp("This is Divx311 video codec\n");
				break;
			default:
				//Assert(0);
				Disp("Unknown Codec\n");
				break;
		}
	}
	else
	{
		Disp("Fail to open avi file\n");
		Assert(0);
	}
	AVI_GetStreamResolution(&uAviHsize, &uAviVsize);
	Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);
	
	pFileSteamAddr = AVI_GetVideoData(&uChunkSize,&sAviInfo,&uAudioChunk);
	if(pFileSteamAddr==0 && uChunkSize==0)
		return;

	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	if(eDecStandard==DivX311_DEC)
		MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

	Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;
	uCurCrcBufStAddr = uCrcBufStAddr;

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)	
		{
			bIsFirstFrame = false;
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0 ,LAST_SEQ);
		}
		else
		{
			if(bIsFirstFrame==true || (bChunkEmpty))
			{
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				if(!bChunkEmpty)
				{
					pFileSteamAddr = AVI_GetVideoData(&uChunkSize,&sAviInfo,&uAudioChunk);		
					AviOffsetTmp=sAviInfo.offset_movi;
					if( AVI_GetVideoData(&ChunkSizeTmp,&sAviInfo,&uAudioChunk)==0 &&  (ChunkSizeTmp==0) )
					{
						bLastFrame = true;
					}
					else
					{
						sAviInfo.offset_movi=AviOffsetTmp;
						bLastFrame = false;
					}
				}
				if(bLastFrame==false)
				{	
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}
				else if(bLastFrame==true)
				{
					bNoMoreStream =true;
					bMustbeChecked = false;
					break; //  last frame decoding skip
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_SEQ);
				}
				else
					Assert(0);
			}
			if( (uAviFileEndAddr-(50*1024)) <= (u32)pFileSteamAddr+uChunkSize )
				break;
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished())
			break;

		if(!bNoMoreStream)
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}

		MFC_GetPictureType(&ePictype, &binterlace);
		if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
		{
			if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(bSaveResult)
				Copy8(0xf1702030, uCurCrcBufStAddr, 8);
			uCurCrcBufStAddr+=8;
			uRefCrcBufAddr+=8;
			if(uRefCrcFileSize == (uCurCrcBufStAddr-uCrcBufStAddr))
				break;
		}
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);
	
	uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;

	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}
	
	if(bSaveResult)
	{
		strcpy(&aCrcFileName[uIdx+1], "result.crc");
		if(bSdLoadMode)
		{
			FS_Creat(aCrcFileName, &CrcFileHandler);
			FS_Write(&CrcFileHandler, uTotCrcSize, (u32 *)uCrcBufStAddr, &uRealReadSize);
		}
		else
		{
			sprintf(aGotCrcPath,"%s%s","F:\\Divx3\\Result\\",aCrcFileName);
			CrcEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
			EFT_WriteFile(&CrcEftInfo, (u32 *)uCrcBufStAddr, uTotCrcSize);
		}
		if(uErrorCnt)
		{
			strcpy(&aCrcFileName[uIdx+1], "err.crc");
			
			if(bSdLoadMode)
			{
				FS_Creat(aCrcFileName, &CrcFileHandler);
				FS_Write(&CrcFileHandler, 0, (u32 *)uCrcBufStAddr, &uRealReadSize);
			}
			else
			{
				sprintf(aGotCrcPath,"%s%s","F:\\Divx3\\Error\\",aCrcFileName);
				CrcEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
				EFT_WriteFile(&CrcEftInfo, (u32 *)uCrcBufStAddr, 0);
			}
		}
	}
}
#else
static void TestDecodingWithDivX311CrcComparison(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	ETHERNET_FILE AviEftInfo;
	ETHERNET_FILE CrcEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uCrcBufStAddr= 0x47000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	u32 uRdPtr;
	bool bDispOnlyFrame=false;
	u32 uRemainSz;

	ebDecStandard=true;
	uAviFileAddr = 0x20000000;

	bConformanceTestAll = true;
	if(!bConformanceTestAll)
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);
	}

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_Open(aFileName, &AviHandler)!=0)
			return;

		if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		// 2. REF CRC load
		uRefCrcBufAddr = Align(uAviFileAddr+uAviFileSize, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;

		// 3. FW load	
		uFwCodeStAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);

		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
	// 1. Stream load

		sprintf(aAviFilePath,"%s%s","X:\\MPEG4\\STREAM\\DivX_3\\",aFileName);

		AviEftInfo = EFT_RequestFileInfo(aAviFilePath);
		if(AviEftInfo.fileID==-1 || AviEftInfo.fileSize==0)
		{
			Disp("Avi Open Fail\n");
			return;
		}
		uAviFileSize = AviEftInfo.fileSize;

		EFT_ReadFile(&AviEftInfo, (u32 *)uAviFileAddr);
		uReadSizeUnit = uAviFileSize; 

		uAviFileAddr = 0x20000000;
		uAviFileSize = 6291456;
		strcpy(aFileName, "5098.avi");
		uAviFileEndAddr=uAviFileAddr+uAviFileSize;
		
		//2. Golden CRC load 
		uRefCrcBufAddr = Align(uAviFileAddr+uAviFileSize, 16);
		
		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 
		sprintf(aRefCrcPath,"%s%s","X:\\MPEG4\\STREAM\\REFCRC\\",aCrcFileName);
			
		CrcEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcEftInfo.fileID==-1 || CrcEftInfo.fileSize==0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		EFT_ReadFile(&CrcEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcEftInfo.fileSize;
		
		// 3. FW load
		uFwCodeStAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W  Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	
	uDramBBaseAddr = 0x41000000;
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	
	bIsFirstFrame = true;

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}
	
	Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

	uRemainSz = uAviFileSize;

	VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);

	uRdPtr = pFileSteamAddr+uComsumedFrameSize;
	uRemainSz -= uComsumedFrameSize;
	
	if(pFileSteamAddr==0 && uChunkSize==0)
		return;

	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	if(eDecStandard==DivX311_DEC)
		MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

	Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;
	uCurCrcBufStAddr = uCrcBufStAddr;

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{

		if(bIsFirstFrame==true )	
		{
			bIsFirstFrame = false;
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}

		else
		{
			uRet = VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);

			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
				uRemainSz -= uComsumedFrameSize;
				Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
				MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
			}	
			else if(uRet==1)
			{					
				bNoMoreStream =true;
				bMustbeChecked = false;
				break; //  last frame decoding skip
				Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
				MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_SEQ);
			}
			else
				Assert(0);
			
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished())
			break;

		if(!bNoMoreStream)
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}

		if(uFrameCnt ==1122)
			Disp("");
		MFC_GetPictureType(&ePictype, &binterlace);
		if(bMustbeChecked && (ePictype != SKIP_FRAME))
		{
			if(CheckCrcDiff(eDecStandard, uRefCrcBufAddr, false)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(bSaveResult)
				Copy8(0xf1702030, uCurCrcBufStAddr, 8);
			uCurCrcBufStAddr+=8;
			uRefCrcBufAddr+=8;
		}
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);
	
	uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;

#if 0
	if(uRefCrcFileSize>=uTotCrcSize)
	{
		if( (uRefCrcFileSize-uTotCrcSize)>8 )
		{
			uErrorCnt++;
			Disp("Fail\n");
		}
	}
#endif

	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}
	
	if(bSaveResult)
	{
		strcpy(&aCrcFileName[uIdx+1], "result.crc");
		if(bSdLoadMode)
		{
			FS_Creat(aCrcFileName, &CrcFileHandler);
			FS_Write(&CrcFileHandler, uTotCrcSize, (u32 *)uCrcBufStAddr, &uRealReadSize);
		}
		else
		{
			sprintf(aGotCrcPath,"%s%s","F:\\Divx3\\Result\\",aCrcFileName);
			CrcEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
			EFT_WriteFile(&CrcEftInfo, (u32 *)uCrcBufStAddr, uTotCrcSize);
		}
		if(uErrorCnt)
		{
			strcpy(&aCrcFileName[uIdx+1], "err.crc");
			
			if(bSdLoadMode)
			{
				FS_Creat(aCrcFileName, &CrcFileHandler);
				FS_Write(&CrcFileHandler, 0, (u32 *)uCrcBufStAddr, &uRealReadSize);
			}
			else
			{
				sprintf(aGotCrcPath,"%s%s","F:\\Divx3\\Error\\",aCrcFileName);
				CrcEftInfo=EFT_RequestCreateFileInfo(aGotCrcPath);
				EFT_WriteFile(&CrcEftInfo, (u32 *)uCrcBufStAddr, 0);
			}
		}
	}
}
#endif

static void TestMultiDecBy1Ch(void)
{
	u32 i, uIdx;
	u32 uNumOfInstance;
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uProcessIdx;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u8 bMp4DeblkEn=false;
	u32 uFinishedProcessNum=0;
	u8 bNoMoreStream[MAX_FILENAME_SIZE];	
	u32 uLcdFbAddr;
	u32 uRealReadSize;
	u32 xPos, yPos;
	u32 uLcdHSz, uLcdVSz;
	u32 uDispWidth, uDispHeight;
	u32 uDispHorizontalDiv, uDispVerticalDiv;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uDecABufStAddr, uDecBBufStAddr;
	u32 sel[MAX_PROCESS_NUM];
	char aFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	u32 uStreamFileSize[MAX_PROCESS_NUM];
	char cFileExt[MAX_PROCESS_NUM][50];
	VIDEO_CODEC_TYPE eDecStandard[MAX_PROCESS_NUM]; 
	u32 uRet[MAX_PROCESS_NUM];
	u32 uRdPtr[MAX_PROCESS_NUM];
	u8 bIsRcv[MAX_PROCESS_NUM];
	u32 uRemainSz[MAX_PROCESS_NUM];
	u32 uFrameCnt[MAX_PROCESS_NUM];
	u8 bIsFirstFrame[MAX_PROCESS_NUM];
	u32 uPicHsz[MAX_PROCESS_NUM], uPicVsz[MAX_PROCESS_NUM];
	u32 uFrameHsz[MAX_PROCESS_NUM], uFrameVsz[MAX_PROCESS_NUM];
	char cCodecName[MAX_PROCESS_NUM][50];
	u32 uStreamBufStAddr[MAX_PROCESS_NUM];
	u32 uInstanceId[MAX_PROCESS_NUM];
	u32 uFileOffset[MAX_PROCESS_NUM];
	u32 uFatReadSizeUnit[MAX_PROCESS_NUM];
	u32 uDpbBufStAddr[MAX_PROCESS_NUM];
	u32 uDpbBufEndAddr[MAX_PROCESS_NUM];
	u32 uTotalRemainSz[MAX_PROCESS_NUM];
	u32 uReadSizeUnit[MAX_PROCESS_NUM];
	u8 bPartialLoad[MAX_PROCESS_NUM];
	u8 bFinishedProcess[MAX_PROCESS_NUM];
	u32 uLastFrameSize[MAX_PROCESS_NUM];
	u8 bDispOnlyFrame[MAX_PROCESS_NUM];
	u32 uPreFrameSize[MAX_PROCESS_NUM];
	u8 bFirstSeqheader[MAX_PROCESS_NUM];
	MFC_CMD_CH_NUM ePreparedCh;
	MFC_DISP_TYPE eDispType;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE StreamEftInfo[MAX_PROCESS_NUM];
	t_file_handler FwHandler;
	t_file_handler StreamHandler[MAX_PROCESS_NUM];
	u8 bFirstDecInstance=true;
	
	ebDecStandard=true;
	
	Disp("How many processes do you want for decoding[1~%d]?\n", MAX_PROCESS_NUM);
	uNumOfInstance = UART_GetIntNum();
	
	uFwCodeStAddr = 0x20000000;
	uFreeMemBufB = 0x41000000;
	// 1. lcdc setting
	uLcdFbAddr=uFreeMemBufB;
	LCDC_InitIp(eBpp, uLcdFbAddr,  eWin, false);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
	LCDC_GetFbEndAddr(&uFreeMemBufB, eWin);	
	LCDC_Start();

	uDispHorizontalDiv = (uNumOfInstance == 1) ? 1 : (uNumOfInstance <= 4) ? 2 : 
						(uNumOfInstance <= 9) ? 3 : 4;
	uDispVerticalDiv = (uNumOfInstance <= 2) ? 1 : (uNumOfInstance <= 6) ? 2 :
						(uNumOfInstance <= 9) ? 3 : 4;
	uDispWidth = uLcdHSz/uDispHorizontalDiv;
	uDispHeight = uLcdVSz/uDispVerticalDiv;

	// OutImgHsz must be aligned 16' multiple. That is fimc constraint.
	uDispWidth -= uDispWidth%16;
	
	for(i=0; i<uNumOfInstance; i++)
	{
		bFinishedProcess[i] = false;
		uFrameCnt[i] = 0;
		bPartialLoad[i] = false;
		bNoMoreStream[i] = false;
		bDispOnlyFrame[i]=false;
		bFirstSeqheader[i] = true;
	}

	uStreamBufStAddr[0] = Align(uFreeMemBufB, 16);
	for(i=0; i<uNumOfInstance; i++)
	{
		uIdx = i;
		if(bSdLoadMode)
		{
			// 1. Stream load 
			if(FS_OpenFromDirlist("mfc", &StreamHandler[uIdx], sel[uIdx], true, aFileName[uIdx], cFileExt[uIdx])!=0)
			{
				Disp("Stream Open Fail\n");
				return;
			}
			uStreamFileSize[uIdx]=StreamHandler[uIdx].nSize;
			uTotalRemainSz[uIdx] = uStreamFileSize[uIdx];
			
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				bPartialLoad[uIdx] = true;
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}
		else // Load by ethernet
		{ 
			Disp("Write down filename to test : ");
			UART_GetString(aFileName[uIdx]);
			
			StreamEftInfo[uIdx] = EFT_RequestFileInfo(aFileName[uIdx]);
			
			if(StreamEftInfo[uIdx].fileID==-1 || StreamEftInfo[uIdx].fileSize==0)
			{
				Disp("Stream Open Fail\n");
				return;
			}
			uStreamFileSize[uIdx] = StreamEftInfo[uIdx].fileSize;
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				EFT_ReadFile(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]));			
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]), uFileOffset[uIdx], STREAM_FILE_BUF_SIZE);
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				bPartialLoad[uIdx] = true;
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			EFT_GetFileNameExt(aFileName[uIdx], cFileExt[uIdx]);
		}
		if(bPartialLoad[uIdx]==false)
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + uStreamFileSize[uIdx], 16);
		else
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + MULTI_STREAM_FILE_BUF_SIZE, 16);
		
		uFreeMemBufB = uStreamBufStAddr[uIdx+1];

		if(MFC_GetCodecType(cFileExt[uIdx], &eDecStandard[uIdx])==false)
			return;

		DispCodecName(eDecStandard[uIdx]);
		Disp("=======================\n");
	}

	uDramBBaseAddr = Align(uFreeMemBufB, 128*1024);
	
	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	 uDramBBaseAddr);
	ePreparedCh = CMD_CH0;
	for(i=0; i<uNumOfInstance; i++)
	{
		uIdx = i;
		MFC_InitProcessForDecoding(uIdx, eDecStandard[uIdx], bPixelCacheEn, bMp4DeblkEn, false);
		MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

		bIsRcv[uIdx] = (strcmp(cFileExt[uIdx],"rcv")==0) ? true : false;
		uRemainSz[uIdx] = uReadSizeUnit[uIdx];
		uRet[uIdx] = VsParser(eDecStandard[uIdx], uStreamBufStAddr[uIdx], uRemainSz[uIdx], 
								&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
		bFirstSeqheader[uIdx] = false;

		uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
		if(eDecStandard[uIdx]==VC1RCV_DEC)
			uRemainSz[uIdx] -= uOneFrameSz+8;
		else
			uRemainSz[uIdx] -= uOneFrameSz;
		
		if (uRet[uIdx]==3)
		{
			Disp("Parsing Error\n");
			return;
		}
		Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
		MFC_SetCmdChNum(ONE_CH_CMD);
		MFC_SetDramBDpbBufStAddr(uDramBBaseAddr);

		if(bFirstDecInstance == true)
		{
			MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
			bFirstDecInstance = false;
		}
		else
		{
			uDecABufStAddr = uFreeMemBufA;
			uDecBBufStAddr = uFreeMemBufB;
			MFC_ParseStreamHeader(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
			MFC_SetBufAddrOfDecoder(uFreeMemBufA, uFreeMemBufB);
			MFC_InitBuffer(CMD_CH0, uIdx);
		}	
		
		MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
		MFC_GetImagePicSize(&uPicHsz[uIdx], &uPicVsz[uIdx]);
		MFC_GetImageFrameSize(&uFrameHsz[uIdx], &uFrameVsz[uIdx]);
		MFC_GetDbpBufEndAddr(uIdx, &uFreeMemBufA, &uFreeMemBufB);	
		Disp("ProcessId:[%d], StreamID:[%d]\n", uIdx, uInstanceId[uIdx]);
		Disp("PicHsz=%d, PicVsz=%d\n", uPicHsz[uIdx], uPicVsz[uIdx]);
		Disp("FrameHsz=%d, FrameVsz=%d\n", uFrameHsz[uIdx], uFrameVsz[uIdx]);

		if(eDecStandard[uIdx] == H263_DEC)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME); 
		}
		else
		{
			#if 1
			continue;
			#else
			uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
			&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
			uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard[uIdx]==VC1RCV_DEC)
				uRemainSz[uIdx] -= uOneFrameSz+4;
			else
				uRemainSz[uIdx] -= uOneFrameSz;
			Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			#endif
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}

		uFrameCnt[uIdx]++;

		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		
		bProcessingDoneA = false;
		xPos = i%uDispHorizontalDiv;
		yPos = i/uDispHorizontalDiv;
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
			0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight,	0, // Scaler		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		FIMC_StartProcessingForMfc(FIMC_A);
		while(!bProcessingDoneA);
		bProcessingDoneA = false;
	}

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		for(i=0; i<uNumOfInstance; i++)
		{
			uIdx = i;
			if(bFinishedProcess[uIdx] == false)
			{
				MFC_SetProcessIdx(uIdx);

				if(bNoMoreStream[uIdx]==true)
				{
					MFC_StartDecodingOneFrame(CMD_CH0, uLastFrameSize[uIdx], LAST_SEQ);
				}
#if 0
				else if((eDecStandard[uIdx]==H264_DEC) && (bDispOnlyFrame[uIdx]) && (bNoMoreStream[uIdx]==false))
				{
					MFC_StartDecodingOneFrame(ePreparedCh, uPreFrameSize[uIdx], FRAME);
				}
#endif
				else if(bNoMoreStream[uIdx]==false)
				{
					uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
							&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
			
					if(uRet[uIdx]==3)
					{
						Disp("Parsing Error\n");
						return;
					}
					else if(uRet[uIdx]==0)
					{
						uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
						if(eDecStandard[uIdx]==VC1RCV_DEC)
							uRemainSz[uIdx] -= uOneFrameSz+4;
						else
							uRemainSz[uIdx] -= uOneFrameSz;
						Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
						MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
					}
					else if((uRet[uIdx]==1) || (uRet[uIdx]==2))
					{
						if(uTotalRemainSz[uIdx] && bPartialLoad[uIdx])
							{
								Disp("Partial Load\n");
								UART_Getc();
								uTotalRemainSz[uIdx] += uRemainSz[uIdx];
								if(MULTI_STREAM_FILE_BUF_SIZE<=uTotalRemainSz[uIdx])
								{
									uFileOffset[uIdx] -= uRemainSz[uIdx];
									uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
								}
								else
								{
									uFileOffset[uIdx]-= uRemainSz[uIdx];
									uReadSizeUnit[uIdx] = uTotalRemainSz[uIdx];
								}
								if(bSdLoadMode)
								{
									if(FS_Seek(&StreamHandler[uIdx], uFileOffset[uIdx], 0) != 0)
									{
										Disp("Stream Seek Fail\n");
										return;
									}
									if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
									{
										Disp("Stream Read Fail\n");
										return;
									}
									uFileOffset[uIdx] = StreamHandler[uIdx].nOffset;
								}
								else
								{
									EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx], uFileOffset[uIdx], uReadSizeUnit[uIdx]);
									uFileOffset[uIdx] += uReadSizeUnit[uIdx];
								}
								uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
								uRdPtr[uIdx] = uStreamBufStAddr[uIdx];
								uRemainSz[uIdx] = uReadSizeUnit[uIdx];
								continue;
						}

						Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
						MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
						uLastFrameSize[uIdx] = uOneFrameSz;
						bNoMoreStream[uIdx] = true;
						Disp("Emtpy\n");
					}
				}
				if(!MFC_WaitForFrameDone())
				{
					Disp("[ERR]\n");
					break;
				}
				if(MFC_IsDecodingFinished())
				{
					Disp("[BUF flushed]\n");
					bFinishedProcess[uIdx] = true;
					MFC_CloseInstance(uInstanceId[uIdx]);
					uFinishedProcessNum++;
					break;	
				}
			
				//MFC_GetDispType(&eDispType);
				MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		

				if(eDecStandard[uIdx] == H264_DEC)
				{
					if(eDispType==DISP_ONLY)
					{
						bDispOnlyFrame[uIdx]=true;
						uPreFrameSize[uIdx] = uOneFrameSz;
						uRdPtr[uIdx] = uRdPtr[uIdx] - uOneFrameSz;
						uRemainSz[uIdx] += uOneFrameSz;
					}
					else
					{
						bDispOnlyFrame[uIdx]=false;
					}
				}

				if((eDecStandard[uIdx]!=H264_DEC)&&(!bNoMoreStream[uIdx]))
				{
					uFrameCnt[uIdx]++;
					Disp("[%d]",uFrameCnt[uIdx]);
				}
				
				if((eDecStandard[uIdx]==H264_DEC)&&(eDispType!=DISP_ONLY))
				{
					uFrameCnt[uIdx]++;
					Disp("[%d] ",uFrameCnt[uIdx]);
				}

				if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
					continue;
				
				bProcessingDoneA = false;
				xPos = i%uDispHorizontalDiv;
				yPos = i/uDispHorizontalDiv;
				FIMC_InitIpForDinDout(FIMC_A,
					uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
					0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
					0, TILE_NV12,
					uLcdHSz, uLcdVSz,
					uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight, 0,	
					uLcdFbAddr, eBpp,		
					ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
				FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
				FIMC_StartProcessingForMfc(FIMC_A);
				while(!bProcessingDoneA);
			}
		}
		if(uFinishedProcessNum == uNumOfInstance)
			break;
	}

	Disp("\n");
	for (i=0; i<uNumOfInstance; i	++)
	{
		Disp("%d: [%d] frames decoded\n", i,  uFrameCnt[i]);
	}
}


static void TestMultiDecBy2Ch(void)
{
	u32 i, uIdx;
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	MFC_CMD_CH_NUM ePreparedCh;
	u32 uProcessIdx;
	u32 uOneFrameAddr;
	u32 uStrLen;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uDecABufStAddr, uDecBBufStAddr;
	char aFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	u32 uStreamBufStAddr[MAX_PROCESS_NUM];
	u32 uStreamFileSize[MAX_PROCESS_NUM];
	char cFileExt[MAX_PROCESS_NUM][50];
	u32 uPicHsz[MAX_PROCESS_NUM], uPicVsz[MAX_PROCESS_NUM];
	u32 uRet[MAX_PROCESS_NUM];
	u8 bIsRcv[MAX_PROCESS_NUM];
	u8 bIsFirstFrame[MAX_PROCESS_NUM];
	char cCodecName[MAX_PROCESS_NUM][50];
	u32 uInstanceId[MAX_PROCESS_NUM];
	u32 uFileOffset[MAX_PROCESS_NUM];
	u32 uFatReadSizeUnit[MAX_PROCESS_NUM];
	u32 uDpbBufStAddr[MAX_PROCESS_NUM];
	u32 uDpbBufEndAddr[MAX_PROCESS_NUM];
	u32 uTotalRemainSz[MAX_PROCESS_NUM];
	u32 uReadSizeUnit[MAX_PROCESS_NUM];
	u8 bPartialLoad[MAX_PROCESS_NUM];
	u8 bFirstSeqheader[MAX_PROCESS_NUM];
	u8 bClosedInstance[MAX_PROCESS_NUM];
	ETHERNET_FILE StreamEftInfo[MAX_PROCESS_NUM];
	ETHERNET_FILE RefCrcEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler[MAX_PROCESS_NUM];
	t_file_handler RefCrcHandler;
	t_file_handler FwHandler;
	u32 uCurCpbBufStAddr;
	u32 uRealReadSize;
	u8 bFirstInstance = true;
	u8 bMp4DeblkEn = false;
		
	ebDecStandard=true;
	
	Disp("How many processes do you want for decoding[1~%d]?\n", MAX_PROCESS_NUM);
	uNumOfInstance = UART_GetIntNum();

	if(uNumOfInstance == 0)	return;

	uFwCodeStAddr = 0x20000000;
	uFreeMemBufB = 0x41000000;

	// 1. lcdc setting
	uLcdFbAddr=uFreeMemBufB;
	LCDC_InitIp(eBpp, uLcdFbAddr,  eWin, false);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
	LCDC_GetFbEndAddr(&uFreeMemBufB, eWin);	
	LCDC_Start();

	uDispHorizontalDiv = (uNumOfInstance == 1) ? 1 : (uNumOfInstance <= 4) ? 2 : 
						(uNumOfInstance <= 9) ? 3 : 4;
	uDispVerticalDiv = (uNumOfInstance <= 2) ? 1 : (uNumOfInstance <= 6) ? 2 :
						(uNumOfInstance <= 9) ? 3 : 4;
#if 0
	uDispWidth = uLcdHSz/uDispHorizontalDiv;
	uDispHeight = uLcdVSz/uDispVerticalDiv;
#else
	uDispWidth = uLcdHSz/uDispHorizontalDiv;
	uDispHeight = uLcdVSz/uDispVerticalDiv;

	// OutImgHsz must be aligned 16' multiple. That is fimc constraint.
	uDispWidth -= uDispWidth%16;
#endif

	uFinishedProcessNum=0;
	for(i=0; i<uNumOfInstance; i++)
	{
		bFinishedProcess[i] = false;
		uFrameCnt[i] = 0;
		bNoMoreStream[i] = false;
		bPartialLoad[i] = false;
		bClosedInstance[i] = false;
		bFirstSeqheader[i] = true;
	}
	
	uStreamBufStAddr[0] = uFreeMemBufB;
	for(uIdx=0; uIdx<uNumOfInstance; uIdx++)
	{
		if(bSdLoadMode)
		{
			// 1. Stream load 
			if(FS_OpenFromDirlist("mfc", &StreamHandler[uIdx], sel[uIdx], true, aFileName[uIdx], cFileExt[uIdx])!=0)
				return;
			uStreamFileSize[uIdx]=StreamHandler[uIdx].nSize;
			uTotalRemainSz[uIdx] = uStreamFileSize[uIdx];
			
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			else
			{
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				bPartialLoad[uIdx] = true;
			}
			if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}
		else // Load by ethernet
		{ 
			Disp("Write down filename to test : ");
			UART_GetString(aFileName[uIdx]);
			
			StreamEftInfo[uIdx] = EFT_RequestFileInfo(aFileName[uIdx]);
			
			if(StreamEftInfo[uIdx].fileID==-1 || StreamEftInfo[uIdx].fileSize==0)
			{
				Disp("Stream open fail\n");
				return;
			}
			uStreamFileSize[uIdx] = StreamEftInfo[uIdx].fileSize;
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				EFT_ReadFile(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]));			
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]), uFileOffset[uIdx], STREAM_FILE_BUF_SIZE);
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				bPartialLoad[uIdx] = true;
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			EFT_GetFileNameExt(aFileName[uIdx], cFileExt[uIdx]);
		}
		
		if(MFC_GetCodecType(cFileExt[uIdx], &eDecStandard[uIdx])==false)
			return;
		DispCodecName(eDecStandard[uIdx]);
		
		if(bPartialLoad[uIdx]==false)
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + uStreamFileSize[uIdx], 16);
		else
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + MULTI_STREAM_FILE_BUF_SIZE+512, 16);
		uFreeMemBufB = uStreamBufStAddr[uIdx+1];
	}

	uDramBBaseAddr = Align(uFreeMemBufB, 128*1024);
	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_MfcForMultiDec);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);	
	
	ePreparedCh = CMD_CH0;
	for(i=0; i<uNumOfInstance; i++)
	{
		uIdx = i;
		MFC_InitProcessForDecoding(uIdx, eDecStandard[uIdx], bPixelCacheEn, bMp4DeblkEn, false);
		MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

		bIsRcv[uIdx] = (strcmp(cFileExt[uIdx],"rcv")==0) ? true : false;
		uRemainSz[uIdx] = uReadSizeUnit[uIdx];
		uRet[uIdx] = VsParser(eDecStandard[uIdx], uStreamBufStAddr[uIdx], uRemainSz[uIdx], 
								&uOneFrameAddr, &uOneFrameSz[uIdx], bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
		bFirstSeqheader[uIdx] = false;
		uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz[uIdx];
		
		if(eDecStandard[uIdx]==VC1RCV_DEC)
			uRemainSz[uIdx] -= uOneFrameSz[uIdx]+8;
		else
			uRemainSz[uIdx] -= uOneFrameSz[uIdx];

		if (uRet[uIdx]==3)
		{
			Disp("Parsing Error\n");
			return;
		}
		
		if(bFirstInstance)
		{
 			Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz[uIdx]);
			MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz[uIdx]);
			bFirstInstance=false;
		}
		else
		{
			uDecABufStAddr = uFreeMemBufA;
			uDecBBufStAddr = uFreeMemBufB;
			while(!MFC_GetPreparedChAndCpbBuf(&ePreparedCh, &uCurCpbBufStAddr));
  			Copy8(uOneFrameAddr, uCurCpbBufStAddr, uOneFrameSz[uIdx]);
			MFC_ParseStreamHeader(ePreparedCh, uCpbBufStAddr, uOneFrameSz[uIdx]);
			MFC_SetBufAddrOfDecoder(uFreeMemBufA, uFreeMemBufB);
			MFC_InitBuffer(CMD_CH0, uIdx);
		}	
		MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
		MFC_GetDbpBufEndAddr(uIdx, &uFreeMemBufA, &uFreeMemBufB);	
		MFC_GetImagePicSize(&uPicHsz[uIdx], &uPicVsz[uIdx]);
		MFC_GetImageFrameSize(&uFrameHsz[uIdx], &uFrameVsz[uIdx]);
		Disp("ProcessId:[%d], StreamID:[%d]\n", uIdx, uInstanceId[uIdx]);
		Disp("PicHsz=%d, PicVsz=%d\n", uPicHsz[uIdx], uPicVsz[uIdx]);
		
		if(eDecStandard[uIdx] == H263_DEC)
		{
			MFC_StartDecodingOneFrameOfTheBuffer(ePreparedCh);
		}
	}

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		for(i=0; i<uNumOfInstance; i++)
		{
			uIdx = i;
			if(bFinishedProcess[uIdx] == false)
			{
				MFC_SetProcessIdx(uIdx);
				while(!MFC_GetPreparedChAndCpbBuf(&ePreparedCh, &uCurCpbBufStAddr));	

				if(bNoMoreStream[uIdx]==false)
				{
					uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], &uOneFrameAddr, 
						&uOneFrameSz[uIdx], bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
					
					if(uRet[uIdx]==0)
					{
						uPreFrameSize[uIdx] = uOneFrameSz[uIdx];
						uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz[uIdx];
						if(eDecStandard[uIdx]==VC1RCV_DEC)
							uRemainSz[uIdx] -= uOneFrameSz[uIdx]+4;
						else
							uRemainSz[uIdx] -= uOneFrameSz[uIdx];
						Copy8(uOneFrameAddr, uCurCpbBufStAddr, uOneFrameSz[uIdx]);
						MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz[uIdx], FRAME);
					}
					else if((uRet[uIdx]==1) || (uRet[uIdx]==2))
					{
						if(uTotalRemainSz[uIdx] && bPartialLoad[uIdx])
						{
							uTotalRemainSz[uIdx] += uRemainSz[uIdx];
							if(MULTI_STREAM_FILE_BUF_SIZE<=uTotalRemainSz[uIdx])
							{
								uFileOffset[uIdx] -= uRemainSz[uIdx];
								uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
							}
							else
							{
								uFileOffset[uIdx]-= uRemainSz[uIdx];
								uReadSizeUnit[uIdx] = uTotalRemainSz[uIdx];
							}
							if(bSdLoadMode)
							{
								if(FS_Seek(&StreamHandler[uIdx], uFileOffset[uIdx], 0) != 0)
								{
									Disp("Seek Fail\n");
									return;
								}
								if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
								{
									Disp("Stream Read Fail\n");
									return;
								}
								uFileOffset[uIdx] = StreamHandler[uIdx].nOffset;
							}
							else
							{
								EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx], uFileOffset[uIdx], uReadSizeUnit[uIdx]);
								uFileOffset[uIdx] += uReadSizeUnit[uIdx];
							}
							uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
							uRdPtr[uIdx] = uStreamBufStAddr[uIdx];
							uRemainSz[uIdx] = uReadSizeUnit[uIdx];
							continue;
						}

						bNoMoreStream[uIdx] = true;
						Copy8(uOneFrameAddr, uCurCpbBufStAddr, uOneFrameSz[uIdx]);
						MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz[uIdx], LAST_SEQ);
					}
					else if(uRet[uIdx]==3)
					{
						Disp("Parsing Error\n");
						return;
					}
				}
				else if(bNoMoreStream[uIdx]==true)
				{
					MFC_StartDecodingOneFrame(ePreparedCh, uPreFrameSize[uIdx], LAST_SEQ);
				}
			}
			else
			{
				if(bClosedInstance[uIdx] == false)
				{
					MFC_CloseInstance(uInstanceId[uIdx]);
					Disp("[ID:%d] Closed\n", uIdx);
				}
				bClosedInstance[uIdx] = true;
			}
		}
		if(uFinishedProcessNum == uNumOfInstance)
			break;
	}

#if 0	
	for(i=0; i<uNumOfInstance; i++)
	{
		MFC_CloseInstance(uInstanceId[i]);
	}
#endif

	Disp("\n");
	for (i=0; i<uNumOfInstance; i++)
	{
		Disp("%d: [%d] frames decoded\n", i,  uFrameCnt[i]);
	}
}

#if 1
static void TestAviDecoding(void)
{
	u32 i, sel;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uAviFileAddr;
	VIDEO_CODEC_TYPE eDecStandard;
	char aFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uInstanceId;
	u32 uDisplayAddrOfY;
	u32 uDisplayAddrOfC;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	int Codec;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	int uChunkSize;
	int uAudioChunk;
	u32 uAviFileSize;
	u8* pFileSteamAddr;
	u8 bChunkEmpty=false;
	u32 uNumOfTotFrame;
	u32 uNumOfRemainFrame;
	u32 uLcdFbAddr;
	u32 uLcdHSz, uLcdVSz;
	u32 uProcessIdx;
	ETHERNET_FILE AviEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler AviHandler;
	t_file_handler FwHandler;
	AVI_INFO sAviInfo;
	u32 uRealReadSize;
	int AviOffsetTmp;
	int ChunkSizeTmp;
	u32 uDramABaseAddr;
	u32 uDramBBaseAddr;
	u8 bLastFrame=false;
	u8 bNoMoreStream=false;
	u8 bMp4DeblkEn=false;
	u8 bDispOnlyFrame=false;
	u32 uAviFileBufEndAddr;
	MFC_DISP_TYPE eDispType;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bResChanged=false;
	u8 bProgressive;
	
	ebDecStandard=true;
	uFwCodeStAddr = 0x20000000;
	uAviFileAddr = 0x41000000;

	uFreeMemBuf=uAviFileAddr;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
			return;	
		
		if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		
		uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

		// 2. FW load	
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		// 1. Stream load
		sprintf(aAviFilePath,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\",aFileName);

		AviEftInfo = EFT_RequestFileInfo(aAviFilePath);
		if(AviEftInfo.fileID==-1 || AviEftInfo.fileSize==0)
		{
			Disp("Avi Open Fail\n");
			return;
		}
		uAviFileSize = AviEftInfo.fileSize;

		EFT_ReadFile(&AviEftInfo, (u32 *)uAviFileAddr);

		uDramBBaseAddr = Align(uAviFileAddr + AviEftInfo.fileSize, 128*1024);
		
		// 3. FW load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W  Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	bIsFirstFrame = true;
	if(!AVI_IsAVIFile((char *)uAviFileAddr))
	{
		Disp("This is NOT AVI file!\n");
		return;
	}
	if(AVI_OpenAVIFile((char *)uAviFileAddr, &sAviInfo))
	{
		Codec = AVI_GetVideoCodec(&sAviInfo);

		switch(Codec)
		{
			case AVI_VIDEO_CODEC_H263:
				eDecStandard = H263_DEC;
				Disp("This is H263 video codec\n");
				break;
			case AVI_VIDEO_CODEC_H264:
			case AVI_VIDEO_CODEC_h264:
				eDecStandard = H264_DEC;
				Disp("This is H264 video codec\n");
				break;
			case AVI_VIDEO_CODEC_MPEG4:
			case AVI_VIDEO_CODEC_MP43:
			case AVI_VIDEO_CODEC_XVID:
			case AVI_VIDEO_CODEC_xvid:
				eDecStandard = MPEG4_DEC;
				Disp("This is MPEG4 video codec\n");
				break;		
			case AVI_VIDEO_CODEC_divx:
			case AVI_VIDEO_CODEC_dx50:
				eDecStandard = DivX503_DEC;
				Disp("This is DivX video codec\n");
				break;				
			case AVI_VIDEO_CODEC_DVIX3:
			case AVI_VIDEO_CODEC_div3:
				eDecStandard = DivX311_DEC;
				Disp("This is Divx311 video codec\n");
				break;
			default:
				//Assert(0);
				Disp("Unknown Codec\n");
				break;
		}
	}
	else
	{
		Disp("Fail to open avi file\n");
		Assert(0);
	}
	AVI_GetStreamResolution(&uPicHsz, &uPicVsz);
	Disp("AviHsize:%d, AviVsize:%d\n ",uPicHsz, uPicVsz);
	
	pFileSteamAddr = AVI_GetVideoData(&uChunkSize,&sAviInfo,&uAudioChunk);
	if(pFileSteamAddr==0 && uChunkSize==0)
		return;

	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	if(eDecStandard==DivX311_DEC)
		MFC_SetDivX311ImgSize(uPicHsz, uPicVsz);

	Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	if(bFimcDinDout==false)
	{	
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		LCDC_InitIp(eBpp, uFreeMemBufB, eWin, false);
		LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		
			uFreeMemBufB, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt = 0;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)	
		{
			bIsFirstFrame = false;
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0 ,LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			if(!bChunkEmpty)
			{
				pFileSteamAddr = AVI_GetVideoData(&uChunkSize,&sAviInfo,&uAudioChunk);		
				AviOffsetTmp=sAviInfo.offset_movi;
				if( AVI_GetVideoData(&ChunkSizeTmp,&sAviInfo,&uAudioChunk)==0 &&  (ChunkSizeTmp==0) )
				{
					bLastFrame = true;
				}
				else
				{
					sAviInfo.offset_movi=AviOffsetTmp;
					bLastFrame = false;
				}
				
				if(bLastFrame==false)
				{	
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}
				else if(bLastFrame==true)
				{
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_SEQ);
					bNoMoreStream =true;
				}
				else
					Assert(0);
			}
		}
		
		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		
		if(MFC_IsDecodingFinished())
			break;

		MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
		{	
			continue;
		}

		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}		
	}
	MFC_CloseInstance(uInstanceId);

	Disp("AVI file Decoding Done All Frame!!!\n");
	Disp("Total Frame Count : %d\n", uFrameCnt);
}
#else
static void TestAviDecoding(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	u32 uRdPtr;
	bool bDispOnlyFrame=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u8 a=true;
	
	ebDecStandard=true;
	bFirstFimcFifoOut = true;
	
	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uAviFileSize =   AviHandler.nSize;

		uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

		// 3. FW load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr,    uDramBBaseAddr);
	
	bIsFirstFrame = true;

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}
	
	Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

	uRemainSz = uAviFileSize;
	VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize,  &uComsumedFrameSize);
	uRdPtr = pFileSteamAddr+uComsumedFrameSize;
	uRemainSz -= uComsumedFrameSize;
	
	if(pFileSteamAddr==0 && uChunkSize==0)
		return;

	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	if(eDecStandard==DivX311_DEC)
		MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

	Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	if(bFimcDinDout==false)
	{	
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uFreeMemBufA = Align(uFreeMemBufA, 0x10);
		uLcdFbAddr=uFreeMemBufA;
		LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
		LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		
			uFreeMemBufA, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt = 0;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true )	
		{
			if(eDecStandard == VC1RCV_DEC )
			{
				bIsFirstFrame = false;
				continue;
			}
			bIsFirstFrame = false;
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}

		else
		{
			uRet = VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize,  &uComsumedFrameSize);
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
				uRemainSz -= uComsumedFrameSize;
				Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
				MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
			}	
			else if(uRet==1)
			{					
				bNoMoreStream =true;
				bMustbeChecked = false;
				Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
				MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_SEQ);
			}
			else
				Assert(0);
			
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished())
			break;

		if(!bNoMoreStream)
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}

		MFC_GetDispType(&eDispType);
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;

		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;

		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		FIMC_StartProcessingForMfc(FIMC_A);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);

	Disp("uRawStreamBufStAddr :0x%x\n", uRawStreamBufStAddr);

	strcpy(aCrcFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (aCrcFileName[--uIdx] == '.')
			break;
	}
	strcpy(&aCrcFileName[uIdx+1], "264");
}
#endif

#if 0  // file compare
static void TestEncoding(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameCount=0;
	u32 uValidFrmCnt=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	//char aConfigFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler GoldenStreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE GoldenStreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	uFwCodeStAddr = 0x20000000;	
	uDramBBaseAddr = 0x41000000;
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

	MFC_SelectEncStandard(0, &eEncStandard);
	//MFC_SetCodecStandard(0, eEncStandard);	

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	// Load a golden stream file
	strcpy(aStreamFileName, aCfgFileName);
	uIdx = strlen(aCfgFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
	Disp("Golden Stream File Name is %s\n", aStreamFileName);
	
 	uFreeMemBuf = Align(uFreeMemBuf, 16);
	
	uGoldenStreamBufAddr = uFreeMemBuf;
	uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
	if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
	{
		Disp("Golden Stream Open Fail\n");
		return;
	}
	if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
	{
		Disp("Golden Stream Read Fail\n");
		return;
	}
	
	uGoldenStreamSize = GoldenStreamHandler.nSize;
	uFreeMemBuf += uGoldenStreamSize;

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	

	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
	
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;

	Disp("\nENC : Seq_Parsing\t"); 
	Disp("Sequence Size : 0x%x\t",  uEncStrSzPerFrame);

	uFrameCount = 0;
	uValidFrmCnt = 0;
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;

			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			//uStreamBufOffset += uEncStrSzPerFrame;
		}

		if(uIsInterlace == 1)
		{
			MFC_EncodingOneFrame(eCmdType);

			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}

			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);

				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				//uStreamBufOffset += uEncStrSzPerFrame;
			}
		}
			
		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;		
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
	//MFC_ResetIp();

	// Save a stream file to SD card and then unload file system
	//Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	//Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	if(uErrCnt==0)
	{
		Disp("\n########## Encoding Pass ##########\n");
	}
	else
	{
		Disp("\n########## Encoding Fail ##########\n");
	}
}
#else
static void TestEncoding(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE StreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u32 uBitRate;
	u32 uElapsedTime;
	u32 uTotElapsedTime;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uFrameCount=0;
	u32 uValidFrmCnt=0;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	uFwCodeStAddr = 0x20000000;	
	uDramBBaseAddr = 0x41000000;
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

	MFC_SelectEncStandard(0, &eEncStandard);
	//MFC_SetCodecStandard(0, eEncStandard);	

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	
	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
	
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
	uStreamBufOffset += uEncStrSzPerFrame;

	uFrameCount = 0;
	uValidFrmCnt = 0;
	
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("YUV Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		//StartTimer(0);
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		MFC_ReleaseCurrentYCBuf();	

		if(MFC_IsEncodingFinished()==true)
			break;	
		
		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;

			// Read a stream from stream buffer
			MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			uStreamBufOffset += uEncStrSzPerFrame;
		}

		if (uIsInterlace == 1)
		{
			//StartTimer(0);
			MFC_EncodingOneFrame(eCmdType);

			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
			
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();

		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;		
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);

	//Save a stream file to SD card and then unload file system
	Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	// Enc stream
	strcpy(aStreamFileName, aCfgFileName);
	uIdx = strlen(aCfgFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	if(eEncStandard ==H263_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.263");
	else if(eEncStandard ==H264_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.264");
	else if(eEncStandard ==MPEG4_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.m4v");
	else
		Assert(0);

	FS_Creat(aStreamFileName, &StreamHandler);
	FS_Write(&StreamHandler, uStreamBufOffset, (u32 *)uStreamBufStAddr, &uRealReadSize);
}
#endif

static void TestEncodingOnSmallStreamBuf(void)
{
	u32 uIdx;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameCount=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	char aConfigFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	ETHERNET_FILE ConfigEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE StreamInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler FwHandler;
	t_file_handler ConfigHandler;
	t_file_handler StreamHandler;
	t_file_handler YuvHandler;
	u32 uConfigFileSize;
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uGoldenStreamBufAddr;
	u32 uRealReadSize;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;
	
	ebDecStandard=false;
	uFwCodeStAddr = 0x20000000;
	uDramBBaseAddr = 0x41000000;
	
	Disp("[FW loading...]");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	 
	INTC_SetVectAddr(NUM_MFC, Isr_MfcForSmallStreamBuf);
	INTC_Enable(NUM_MFC); 

	// Enable encoding interrupt
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;
	
	// Select encoding standard
	MFC_SelectEncStandard(0, &eEncStandard);

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aConfigFileName);
		
		if(FS_Open(aConfigFileName, &ConfigHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&ConfigHandler, ConfigHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = ConfigHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aConfigFileName);

		ConfigEftInfo = EFT_RequestFileInfo(aConfigFileName);
		if(ConfigEftInfo.fileID==-1 || ConfigEftInfo.fileSize==0)
		{
			Disp("iCfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&ConfigEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = ConfigEftInfo.fileSize; //file size
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	// Load a golden stream file
	strcpy(aStreamFileName, aConfigFileName);
	uIdx = strlen(aConfigFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
	Disp("Golden Stream File Name is %s\n", aStreamFileName);
	
	if(bSdLoadMode)
	{
		if(FS_Open(aStreamFileName, &StreamHandler)!=0)
			return;

		uFreeMemBuf=Align(uFreeMemBuf, 16);
		uGoldenStreamBufAddr = uFreeMemBuf;
		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		uGoldenStreamSize = StreamHandler.nSize;
		uFreeMemBuf += uGoldenStreamSize;
	}
	else
	{
		StreamInfo = EFT_RequestFileInfo(aStreamFileName);
		if(StreamInfo.fileID==-1 || StreamInfo.fileSize==0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		uFreeMemBuf=Align(uFreeMemBuf, 16);
		uGoldenStreamBufAddr = uFreeMemBuf;
		EFT_ReadFile(&StreamInfo, (u32 *)(uGoldenStreamBufAddr));
		uGoldenStreamSize = StreamInfo.fileSize;
		uFreeMemBuf += uGoldenStreamSize;
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();
		
	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);

	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	
	uFreeMemBuf = uFreeMemBufB;
			
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(bSdLoadMode)
	{
		if(FS_Open(aYuvFileName, &YuvHandler)!=0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	else
	{
		YuvEftInfo = EFT_RequestFileInfo(aYuvFileName);
		if(YuvEftInfo.fileID==-1 || YuvEftInfo.fileSize==0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	g_uStreamBufStAddr = uStreamBufStAddr;
	g_uStreamBufOffset = 0;
	uFrameCount = 0;
	uValidFrmCnt = 0;
	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(bSdLoadMode)
			{
				if(FS_Seek(&YuvHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
				{
					Disp("Seek Fail\n");
					return;
				}
				if(FS_Read(&YuvHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
				{
					Disp("Yuv Read Fail\n");
					return;
				}
			}
			else
			{
				EFT_ReadFilePartial(&YuvEftInfo, (u32 *)uSrcYuvAddr, uFrameCount*uSrcYuvFrameSizeInBytes, uSrcYuvFrameSizeInBytes);
			}
		}
		
		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);

#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else		
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		g_uReadStreamSize = 0;
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		while(!bOneFrameEncDone)
		bOneFrameEncDone = false;

		MFC_ReleaseCurrentYCBuf();	
	
		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;
		}

		if (uIsInterlace == 1)
		{
			g_uReadStreamSize = 0;
			MFC_EncodingOneFrame(eCmdType);

			while(!bOneFrameEncDone)
			bOneFrameEncDone = false;

			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
			}
		}

		MFC_ReleaseCurrentYCBuf();
		
		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
	
	// Save a stream file to SD card and then unload file system
	uStreamBufOffset = g_uStreamBufOffset;
	Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));
	
	// Compare encoded stream with golden strem
	if (uStreamBufOffset == uGoldenStreamSize)
	{
		if (CompareStreamData(uGoldenStreamBufAddr, uStreamBufStAddr, uGoldenStreamSize))
		{
			Disp("\n########## Encoding Pass ##########\n");
		}
		else
		{
			Disp("\n########## Encoding Fail ##########\n");
		}
	}
	else
	{
		Disp("\n## FAIL : Encoded Stream Size(%d) is different from Gloden Stream Size(%d) ##\n", uStreamBufOffset, uGoldenStreamSize);
	}

	if(bSaveResult)
	{
		// Enc stream
		strcpy(aStreamFileName, aConfigFileName);
		uIdx = strlen(aConfigFileName);
		while (1)
		{
			if (aStreamFileName[--uIdx] == '.')
				break;
		}
		if(eEncStandard ==H263_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.263");
		else if(eEncStandard ==H264_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.264");
		else if(eEncStandard ==MPEG4_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.m4v");
		else
			Assert(0);

		Disp("Enc Stream file name : %s\n",aStreamFileName);
		Disp("Enc Stream Size : 0x%08x\n", uStreamBufOffset);
		Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));
		
		if(bSdLoadMode)
		{
			FS_Creat(aStreamFileName, &StreamHandler);
			FS_Write(&StreamHandler, uStreamBufOffset, (u32 *)uStreamBufStAddr, &uRealReadSize);
		}
		else
		{
			sprintf(aStreamFilePath,"%s%s","F:\\MFC_Result\\Result\\",aStreamFileName);
			StreamInfo=EFT_RequestCreateFileInfo(aStreamFilePath);
			EFT_WriteFile(&StreamInfo, (u32 *)uStreamBufStAddr, uStreamBufOffset);
		}
	}
}

static void TestEncodingForPerformance(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameCount=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	//char aConfigFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;
	t_file_handler GoldenStreamHandler;
	ETHERNET_FILE StreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE GoldenStreamInfo;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	uFwCodeStAddr = 0x20000000;
	uDramBBaseAddr = 0x41000000;
	
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

	MFC_SelectEncStandard(0, &eEncStandard);

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

#if 1
	if(bSdLoadMode)
	{
		// Load a golden stream file
		strcpy(aStreamFileName, aCfgFileName);
		uIdx = strlen(aCfgFileName);
		while (1)
		{
			if (aStreamFileName[--uIdx] == '.')
				break;
		}
		switch(eEncStandard)
		{
			case H263_ENC:
				strcpy(&aStreamFileName[uIdx+1], "263");
				break;
			case MPEG4_ENC:
				strcpy(&aStreamFileName[uIdx+1], "bits");
				break;
			case H264_ENC:
				strcpy(&aStreamFileName[uIdx+1], "264");
				break;
			default:
				Disp("Wrong Format!!!\n");
		}
		Disp("Golden Stream File Name is %s\n", aStreamFileName);
		
	 	uFreeMemBuf = Align(uFreeMemBuf, 16);
		
		uGoldenStreamBufAddr = uFreeMemBuf;
		uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
		if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
		{
			Disp("Golden Stream Read Fail\n");
			return;
		}
		
		uGoldenStreamSize = GoldenStreamHandler.nSize;
		uFreeMemBuf += uGoldenStreamSize;
	}
	else
	{
	}
#endif

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();
		
	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);

	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);

	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
			
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

	Disp("\nENC : Seq_Parsing\t"); 
	Disp("Sequence Size : 0x%x\t",  uEncStrSzPerFrame);

	///////////////////////////////////////////////////////////////////////////////////////////
	// compare per frame.
	MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
	if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
	{
		Disp("[.]\n");
	}
	else
	{
		Disp("Diff\n");
		uErrCnt++;
	}
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
	///////////////////////////////////////////////////////////////////////////////////////////
	
	MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
	uStreamBufOffset += uEncStrSzPerFrame;
	Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer		if(uFrameCount <= uNumOfTotFrames-1)
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);

#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		StartTimer(0);
		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		uElapsedTime=StopTimer(0);

		MFC_ReleaseCurrentYCBuf();	

		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{			
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : %d\t",  uEncStrSzPerFrame*8);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uTotElapsedTime += uElapsedTime;
			Disp("\n[%d] : Elasped Time: %d", uValidFrmCnt, uElapsedTime);

			uValidFrmCnt++;
			
			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			uStreamBufOffset += uEncStrSzPerFrame;
		}
		
		if (uIsInterlace == 1)
		{
			StartTimer(0);
			MFC_EncodingOneFrame(eCmdType);
			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}

			uElapsedTime=StopTimer(0);

			if(MFC_IsEncodingFinished()==true)
				break;		

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : %d\t",  uEncStrSzPerFrame*8);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				uTotElapsedTime += uElapsedTime;
				Disp("Interlaced Elasped Time: %d",  uElapsedTime);

				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();

		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	
	}
	
	// Close instance
	MFC_CloseInstance(uInstanceId);

	Disp("Total Frame Count : %d\n", uValidFrmCnt);
	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uValidFrmCnt*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));

	//Save a stream file to SD card and then unload file system
	Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	// Enc stream
	strcpy(aStreamFileName, aCfgFileName);
	uIdx = strlen(aCfgFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	if(eEncStandard ==H263_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.263");
	else if(eEncStandard ==H264_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.264");
	else if(eEncStandard ==MPEG4_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.m4v");
	else
		Assert(0);
	
	FS_Creat(aStreamFileName, &StreamHandler);
	FS_Write(&StreamHandler, uStreamBufOffset, (u32 *)uStreamBufStAddr, &uRealReadSize);
}

static void TestEncodingWithComparion(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	char aCfgFilePath[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler GoldenStreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE GoldenStreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uFrameCount=0;
	u32 uValidFrmCnt=0;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	uFwCodeStAddr = 0x21000000;
	uDramBBaseAddr = 0x41000000;

	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
 
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);
 
	uFreeMemBuf = uDramBBaseAddr;

#if 1
	MFC_SelectEncStandard(0, &eEncStandard);
#else
	eEncStandard = MPEG4_ENC;
	MFC_SetCodecStandard(0, eEncStandard);						
#endif


	// Load a config file
	if(bSdLoadMode)
	{
		if(!bConformanceTestAll)
		{
			Disp("Write config filename to test : ");
			UART_GetString((s8 *)aFileName);
		}

		Disp("[%s]\n", aFileName);
		if(FS_Open(aFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;

		strcpy(aStreamFileName, aFileName);
		uIdx = strlen(aFileName);
	}
	else
	{
		if(!bConformanceTestAll)
		{
			Disp("Write config filename to test : ");
			UART_GetString((s8 *)aFileName);
		}

		Disp("[%s]\n", aFileName);

		//sprintf(aCfgFilePath, "%s%s","E:\\MFC\\v210 MFC\\SampleStream\\enc\\mpeg4\\",aCfgFileName);
		sprintf(aCfgFilePath, "%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\encsamplestream\\",aFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFilePath);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;

		strcpy(aStreamFileName, aCfgFilePath);
		uIdx = strlen(aCfgFilePath);
	}

	// Load a golden stream file

	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
	Disp("Golden Stream File Name is %s\n", aStreamFileName);
	
 	uFreeMemBuf = Align(uFreeMemBuf, 16);
	
	uGoldenStreamBufAddr = uFreeMemBuf;
	uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
	if(bSdLoadMode)
	{	
		if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
		{
			Disp("Golden Stream Read Fail\n");
			return;
		}
		uGoldenStreamSize = GoldenStreamHandler.nSize;
		uFreeMemBuf += uGoldenStreamSize;
	}
	else
	{
		GoldenStreamInfo = EFT_RequestFileInfo(aStreamFileName);
		if(GoldenStreamInfo.fileID==-1 || GoldenStreamInfo.fileSize==0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		EFT_ReadFile(&GoldenStreamInfo, (u32 *)(uGoldenStreamBufAddr));
		uGoldenStreamSize = GoldenStreamInfo.fileSize;
		uFreeMemBuf += uGoldenStreamSize;
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);		

	// Set Buffer Address for Encoding 
//	uFreeMemBufB = Align(uFreeMemBuf, 2*1024); 
	uFreeMemBufB = Align(uFreeMemBuf, 64*1024); 
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB; 
		
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(bSdLoadMode)
	{
		if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	else
	{
		YuvEftInfo = EFT_RequestFileInfo(aYuvFileName);
		if(YuvEftInfo.fileID==-1 || YuvEftInfo.fileSize==0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	//Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	//Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
	
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{	
			if(bSdLoadMode)
			{
				if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
				{
					Disp("Seek Fail\n");
					return;
				}
				if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
				{
					Disp("Stream Read Fail\n");
					return;
				}
			}
			else
			{
				EFT_ReadFilePartial(&YuvEftInfo, (u32 *)uSrcYuvAddr, uFrameCount*uSrcYuvFrameSizeInBytes, uSrcYuvFrameSizeInBytes);
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		MFC_ReleaseCurrentYCBuf();	
		
		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;

			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			uStreamBufOffset += uEncStrSzPerFrame;
		}
		
		if (uIsInterlace == 1)
		{
			MFC_EncodingOneFrame(eCmdType);
			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
		
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);

				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}			
		}

		MFC_ReleaseCurrentYCBuf();		

		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);

	// Save a stream file to SD card and then unload file system
	//Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	//Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	if(uErrCnt==0)
	{
		Disp("\n########## Encoding Pass ##########\n");
		uFirstFailed=  0;
	}
	else
	{
		Disp("\n########## Encoding Fail ##########\n");
		uFirstFailed=  uErrCnt;
	}

	if(bSaveResult==true)
	{

		// Enc stream
		uIdx = strlen(aStreamFileName);
		while (1)
		{
			if (aStreamFileName[--uIdx] == '.')
				break;
		}
		if(eEncStandard ==H263_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.263");
		else if(eEncStandard==H264_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.264");
		else if(eEncStandard ==MPEG4_ENC)
			strcpy(&aStreamFileName[uIdx], "_gen.m4v");
		else
			Assert(0);

		if(uErrCnt)
		{
			if(bSdLoadMode)
			{
			}
			else
			{
				GoldenStreamInfo=EFT_RequestCreateFileInfo(aStreamFileName);
				//EFT_WriteFile(&GoldenStreamInfo, (u32 *)uStreamBufStAddr, uStreamBufOffset);
				EFT_WriteFile(&GoldenStreamInfo, (u32 *)uStreamBufStAddr, 0);
			}
		}
	}
}


static void TestEncodingConformance(void)
{
	u32 i,j, uIdx;
	u32 uTestCnt=0;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uFailCnt; 
	char cFileExt[50];
	ETHERNET_FILE FilelistEftInfo;
	t_file_handler StreamHandler;
	u8* uFileListBuf;
	u32 uFileListSize;
	u32 uAviFileAddr;
	int Codec;
	
	bConformanceTestAll=true;
	ebDecStandard=true;
	if(bSdLoadMode)
	{
	}
	else
	{
		FilelistEftInfo = EFT_RequestFileInfo("E:\\CCV\\SA2\\SW\\K-FileServer\\H264_FileList.txt");
		if(FilelistEftInfo.fileID==-1 || FilelistEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
		}

		uFileListBuf = (u8 *)malloc(FilelistEftInfo.fileSize);
		EFT_ReadFile(&FilelistEftInfo, (u32*)  uFileListBuf);
		uFileListSize = FilelistEftInfo.fileSize; //file size

		j=0;
		for(i=0; i<uFileListSize; i++)
		{
			if(	UART_GetKey() == '0')
				break;

			aFileName[j] = uFileListBuf[i];
			if(aFileName[j] == 0x20 ||aFileName[j] == 0x0D || aFileName[j] == 0x0a)
			{
				aFileName[j]=0; //null

				if(strlen(aFileName)!=0)
				{						
					EFT_GetFileNameExt(aFileName, cFileExt);
					uFirstFailed = 0xffff;

					if(strcmp(cFileExt, "cfg")==0)
					{
						TestEncodingWithComparion();
					}

					if(uFirstFailed==0xffff)	// when the file is not in.
					{
						Disp("[%s]:File is NOT Existed !\n", aFileName);
						memset(aFileName, 0, j);
						j=0;
						continue;
					}
					uFailCnt += (uFirstFailed==0) ? 0 : 1;
					uTestCnt++;
					memset(aFileName, 0, j);
					j=0;
				}	
			}		
			else
			{
				 j++;
			}
		}
		free(uFileListBuf);
	}
	bConformanceTestAll=false;
	if(uFailCnt==0) 
		Disp("All Case PASS!!\n");
	Disp("TOTAL:%d PASS:%d FAIL:%d\n", uTestCnt, (uTestCnt-uFailCnt), uFailCnt );
}

static void TestConformanceForMulti(void)
{
	u32 i, j, uIdx, uStrIdx;
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	MFC_CMD_CH_NUM ePreparedCh;
	u32 uProcessIdx;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uFinishedProcessNum=0;	
	u32 uFreeMemBuf; 	
	u32 uLcdFbAddr;
	u32 uRealReadSize;
	u32 xPos, yPos;
	u32 uLcdHSz, uLcdVSz;
	u32 uDispWidth, uDispHeight;
	u32 uDispHorizontalDiv, uDispVerticalDiv;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uDecABufStAddr, uDecBBufStAddr;
	u32 uRefCrcBufAddr[MAX_PROCESS_NUM];
	u32 uRefCrcFileSize[MAX_PROCESS_NUM];
	u8 bNoMoreStream[MAX_PROCESS_NUM];
	char aStreamFilePath[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aRefCrcFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	u32 sel[MAX_PROCESS_NUM];
	u32 uStreamFileSize[MAX_PROCESS_NUM];
	char cFileExt[MAX_PROCESS_NUM][10];
	VIDEO_CODEC_TYPE eDecStandard[MAX_PROCESS_NUM];
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 bSeqHeadPasing[MAX_PROCESS_NUM];
	u32 uRet[MAX_PROCESS_NUM];
	u32 uRdPtr[MAX_PROCESS_NUM];
	u8 bIsRcv[MAX_PROCESS_NUM];
	u8 bVc1Field[MAX_PROCESS_NUM];
	u32 uDispOrderFrameCnt[MAX_PROCESS_NUM]={0,};
	u32 uDecErrorCnt[MAX_PROCESS_NUM]={0,};
	u32 uEncErrorCnt[MAX_PROCESS_NUM]={0,};	
	u8 bIsFirstFrame[MAX_PROCESS_NUM];
	u32 uPicHsz[MAX_PROCESS_NUM], uPicVsz[MAX_PROCESS_NUM];
	u32 uFrameHsz[MAX_PROCESS_NUM], uFrameVsz[MAX_PROCESS_NUM];
	u32 uRemainSz[MAX_PROCESS_NUM];
	char cCodecName[MAX_PROCESS_NUM][50];
	u32 uStreamBufStAddr[MAX_PROCESS_NUM];
	u32 uInstanceId[MAX_PROCESS_NUM];
	u32 uFileOffset[MAX_PROCESS_NUM]={0,};
	u32 uFatReadSizeUnit[MAX_PROCESS_NUM];
	u32 uDpbBufStAddr[MAX_PROCESS_NUM];
	u32 uDpbBufEndAddr[MAX_PROCESS_NUM];
	u32 uTotalRemainSz[MAX_PROCESS_NUM];
	u32 uReadSizeUnit[MAX_PROCESS_NUM];
	u8 bPartialLoad[MAX_PROCESS_NUM];
	u8 bFinishedProcess[MAX_PROCESS_NUM];
	u32 bDispOnlyFrame[MAX_PROCESS_NUM];
	u8 bMustbeChecked[MAX_PROCESS_NUM];	
	MFC_PIC_TYPE ePictype[MAX_PROCESS_NUM];
	u8 binterlace[MAX_PROCESS_NUM];
	ETHERNET_FILE EftInfo;
	ETHERNET_FILE StreamEftInfo[MAX_PROCESS_NUM];
	ETHERNET_FILE GoldenStreamEftInfo[MAX_PROCESS_NUM];
	ETHERNET_FILE CfgEftInfo[MAX_PROCESS_NUM];
	ETHERNET_FILE YuvEftInfo[MAX_PROCESS_NUM];
	t_file_handler Handler;
	t_file_handler StreamHandler[MAX_PROCESS_NUM];
	t_file_handler GoldenStreamHandler[MAX_PROCESS_NUM];
	t_file_handler CfgHandler[MAX_PROCESS_NUM];
	t_file_handler YuvHandler[MAX_PROCESS_NUM];
	u8 bMpeg1Flag[MAX_PROCESS_NUM];
	u32 uFrameIdx[MAX_PROCESS_NUM];
	u32 uEncStrSzPerFrame[MAX_PROCESS_NUM];
	u8 bFirstSeqheader[MAX_PROCESS_NUM];
	//char aCfgFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aGoldenStreamFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	char aGoldenStreamPath[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	u32 uGoldenStreamBufAddr[MAX_PROCESS_NUM];
	u32 uCurGoldenStreamBufAddr[MAX_PROCESS_NUM];
	char* cFrameType[MAX_PROCESS_NUM];
	u32 uGoldenStreamSize[MAX_PROCESS_NUM];
	u32 uSrcYuvStAddr[MAX_PROCESS_NUM];
	u32 uSrcYuvAddr[MAX_PROCESS_NUM];
	u32 uCfgFileBufAddr[MAX_PROCESS_NUM];
	u32 uCfgFileSize[MAX_PROCESS_NUM];
	u32 uSrcNv12YAddr[MAX_PROCESS_NUM], uSrcNv12CAddr[MAX_PROCESS_NUM];
	u32 uEncWidth[MAX_PROCESS_NUM], uEncHeight[MAX_PROCESS_NUM];
	u32 uNumOfTotFrames[MAX_PROCESS_NUM];
	u32 uNumOfBFrames[MAX_PROCESS_NUM];
	u32 uIsInterlace[MAX_PROCESS_NUM];
	u32 uIDR_period[MAX_PROCESS_NUM];
	u32 uSrcYuvFrameSizeInBytes[MAX_PROCESS_NUM];
	u32 uStreamBufOffset[MAX_PROCESS_NUM]={0,};
	u8 bCreatedProcess[MAX_PROCESS_NUM];
	MFC_DISP_TYPE eDispType;
	u32 uPreFrameSize[MAX_PROCESS_NUM];
	u32 uCurCrcBufStAddr[MAX_PROCESS_NUM];
	u32 uCrcBufStAddr[MAX_PROCESS_NUM];
	u32 uEncStreamBufAddr[MAX_PROCESS_NUM];	
	u8 bLastOrNoMoreYC[MAX_PROCESS_NUM];
	u32 uNumOfCrc;
	u8 bFirstDecInstance = true;
	u8 bLastFrameDec[MAX_PROCESS_NUM];
	u8 bNoMoreYC[MAX_PROCESS_NUM];
	u32 uDecFrameCnt[MAX_PROCESS_NUM]={0,};
	u32 uEncFrameCnt[MAX_PROCESS_NUM]={0,};
	u32 uFrameCnt[MAX_PROCESS_NUM]={0,};
	MFC_DEC_TYPE eCmdType;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	u8 bDispMode=true;

	if(bRandomMultiTest != true)
	{
		Disp("How many processes do you want for decoding[1~%d]?\n", MAX_PROCESS_NUM);
		nDecProcessCount = UART_GetIntNum();
		//nDecProcessCount = 5;

		Disp("How many processes do you want for encoding? (1~%d)\n", MAX_PROCESS_NUM-nDecProcessCount);
		nEncProcessCount = UART_GetIntNum();
		//nEncProcessCount = 0;
	}

	if( (nDecProcessCount+nEncProcessCount) ==0)
		return;

	Assert (nDecProcessCount+nEncProcessCount <= MAX_PROCESS_NUM);

	uFreeMemBufA = 0x20000000;
	uFreeMemBufB = 0x41000000;
	
	if(bDispMode)
	{
		// 1. lcdc setting
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr,  eWin, false);
		LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
		LCDC_GetFbEndAddr(&uFreeMemBufB, eWin);	
		LCDC_Start();

		uDispHorizontalDiv = (nDecProcessCount == 1) ? 1 : (nDecProcessCount <= 4) ? 2 : 
							(nDecProcessCount <= 9) ? 3 : 4;
		uDispVerticalDiv = (nDecProcessCount <= 2) ? 1 : (nDecProcessCount <= 6) ? 2 :
							(nDecProcessCount <= 9) ? 3 : 4;
		uDispWidth = uLcdHSz/uDispHorizontalDiv;
		uDispHeight = uLcdVSz/uDispVerticalDiv;

		// OutImgHsz must be aligned 16' multiple. That is fimc constraint.
		uDispWidth -= uDispWidth%16;
	}

	for(i=0; i<nDecProcessCount+nEncProcessCount; i++)
	{
		bFinishedProcess[i] = false;
		bPartialLoad[i] = false;
		bNoMoreStream[i] = false;
		bMpeg1Flag[i] = true;
		bCreatedProcess[i] = false;
		bSeqHeadPasing[i] = true;
		bIsFirstFrame[i] = true;
		bMustbeChecked[i] = true;
		bLastFrameDec[i] = false;
		bFirstSeqheader[i] = true;
		bLastOrNoMoreYC[i] = false;
		bNoMoreYC[i] = false;
	}

	for(i=0; i<nDecProcessCount; i++)
	{
		uCrcBufStAddr[i] = 0x46000000+0x10000*i;
		uCurCrcBufStAddr[i] = uCrcBufStAddr[i];
	}

	// Dec: load stream + ref_crc 
	uStreamBufStAddr[0] = Align(uFreeMemBufB, 16);
	for(i=0; i<nDecProcessCount; i++)
	{
		uIdx = i;
		if(bSdLoadMode)
		{
			if(bRandomMultiTest != true)
			{
				Disp(" Which file to decode ? ");
				//sel[uIdx]=UART_GetIntNum();
				UART_GetString(pFileName[uIdx]);
			}				
			// 1. Stream load 
			if(FS_Open(pFileName[uIdx], &StreamHandler[uIdx])!=0)
				return;
			
			uStreamFileSize[uIdx] = StreamHandler[uIdx].nSize;

			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				bPartialLoad[uIdx] = true;
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}

			uStreamBufStAddr[0] = 0x42000000;
			uStreamBufStAddr[1] = 0x43000000;
				
			if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)(uStreamBufStAddr[uIdx]), &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
			uFreeMemBufB = Align(uStreamBufStAddr[uIdx] + uReadSizeUnit[uIdx]+512, 16);

			FS_GetFileNameExt(pFileName[uIdx], cFileExt[uIdx]);

			// 2. Golden CRC load
			uRefCrcBufAddr[uIdx] = Align(uFreeMemBufB, 16);
			if(FS_GetFileByReplacedExt(pFileName[uIdx], "crc", &Handler)!=0)
			{
				Disp("CRC Open Fail\n");
				return;
			}
			if(FS_Read(&Handler, Handler.nSize, (u32 *)uRefCrcBufAddr[uIdx], &uRealReadSize) !=0)
			{
				Disp("CRC Read Fail\n");
				return;
			}
			uRefCrcFileSize[uIdx] = Handler.nSize;
		}
		else // Load by ethernet
		{ 
			if(bRandomMultiTest != true)
				Disp("Write down filename to decode : ");
#if 1
			UART_GetString(pFileName[uIdx]);
#else
			strncpy(pFileName[uIdx], pMultiDecFileList[uIdx], 256);
#endif
			// 1. Stream load
			sprintf(aStreamFilePath[uIdx],"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\",pFileName[uIdx]);
			StreamEftInfo[uIdx] = EFT_RequestFileInfo(aStreamFilePath[uIdx]);
			if(StreamEftInfo[uIdx].fileID==-1 || StreamEftInfo[uIdx].fileSize==0)
			{
				Disp("Stream Open Fail\n");
				return;
			}
			uStreamFileSize[uIdx] = StreamEftInfo[uIdx].fileSize; //file size
		
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				EFT_ReadFile(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx]);
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx], uFileOffset[uIdx], MULTI_STREAM_FILE_BUF_SIZE);
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				bPartialLoad[uIdx] = true;
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			
			EFT_GetFileNameExt(pFileName[uIdx], cFileExt[uIdx]);
		
			uFreeMemBufB = Align(uStreamBufStAddr[uIdx] + uReadSizeUnit[uIdx], 16);

			// 2. Golden CRC load
			uRefCrcBufAddr[uIdx] = Align(uFreeMemBufB, 16);
			strcpy(aRefCrcFileName[uIdx], pFileName[uIdx]);
			uStrIdx = strlen(pFileName[uIdx]);
			while (1)
			{
				if (aRefCrcFileName[uIdx][--uStrIdx] == '.')
					break;
			}
			strcpy(&aRefCrcFileName[uIdx][uStrIdx+1], "crc");
			sprintf(aRefCrcPath[uIdx],"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\",aRefCrcFileName[uIdx]);

			EftInfo = EFT_RequestFileInfo(aRefCrcPath[uIdx]);
			if(EftInfo.fileID==-1 || EftInfo.fileSize==0)
			{
				Disp("CRC Open Fail\n");
				return;
			}
			EFT_ReadFile(&EftInfo, (u32 *)uRefCrcBufAddr[uIdx]);
			uRefCrcFileSize[uIdx] = EftInfo.fileSize;
		}
		
		//Disp("RefCRCBufAddr :0x%x\n", uRefCrcBufAddr[uIdx]);
		uStreamBufStAddr[uIdx+1] = Align(uRefCrcBufAddr[uIdx] + uRefCrcFileSize[uIdx], 16);
		uFreeMemBufB = uStreamBufStAddr[uIdx+1];
		
		if(MFC_GetCodecType(cFileExt[uIdx], &eDecStandard[uIdx])==false)
			return;

		DispCodecName(eDecStandard[uIdx]);
	}
	//Disp("==========================\n");

	// Enc: config parameter
	for (i=nDecProcessCount; i<nEncProcessCount+nDecProcessCount; i++)
	{
		// select encoding mode
		if(bRandomMultiTest == true)
		{
			MFC_SetCodecStandard(i, eEncStandard[i]);						
		}
		else
		{
			MFC_SelectEncStandard(i, &eEncStandard[i]);	
			Disp("Write config filename to test : ");
			UART_GetString((s8 *)pFileName[i]); // pFileName = aCfgFileName;
		}
		
		// load a config file
		if(bSdLoadMode)
		{
			if(FS_Open(pFileName[i], &CfgHandler[i])!=0)
			{
				Disp("Cfg File Open Fail\n");
				return;
			}

			uCfgFileBufAddr[i] = uFreeMemBufB;
			if(FS_Read(&CfgHandler[i], CfgHandler[i].nSize, (u32 *)(uCfgFileBufAddr[i]), &uRealReadSize) !=0)
			{
				Disp("Cfg File Read Fail\n");
				return;
			}
			uCfgFileSize[i] = CfgHandler[i].nSize;
			uFreeMemBufB += uCfgFileSize[i];
			*(char *)uFreeMemBufB++ = NULL;
		}
		else
		{
			CfgEftInfo[i] = EFT_RequestFileInfo(pFileName[i]);
			if(CfgEftInfo[i].fileID==-1 || CfgEftInfo[i].fileSize==0)
			{
				Disp("Cfg File Read Fail\n");
				return;
			}
			uCfgFileBufAddr[i] = uFreeMemBufB;
			EFT_ReadFile(&CfgEftInfo[i], (u32 *)(uCfgFileBufAddr[i]));
			uCfgFileSize[i] = CfgEftInfo[i].fileSize;
			uFreeMemBufB += uCfgFileSize[i];
			*(char *)uFreeMemBufB++ = NULL;
		}

		// load a golden stream file
		strcpy(aGoldenStreamFileName[i], pFileName[i]);
		uStrIdx = strlen(pFileName[i]);
		while (1)
		{
			if (aGoldenStreamFileName[i][--uStrIdx] == '.')
				break;
		}
		switch(eEncStandard[i])
		{
			case H263_ENC:
				strcpy(&aGoldenStreamFileName[i][uStrIdx+1], "263");
				break;
			case MPEG4_ENC:
				strcpy(&aGoldenStreamFileName[i][uStrIdx+1], "bits");
				break;
			case H264_ENC:
				strcpy(&aGoldenStreamFileName[i][uStrIdx+1], "264");
				break;
			default:
				Disp("Wrong Format!!!\n");
		}

		//Disp("Golden Stream File Name is %s\n", aGoldenStreamFileName[i]);

		if(bSdLoadMode)
		{
			if(FS_Open(aGoldenStreamFileName[i], &GoldenStreamHandler[i])!=0)
			{
				Disp("Golden Stream Open Fail\n");
				return;
			}
			uFreeMemBufB=Align(uFreeMemBufB, 16);
			uGoldenStreamBufAddr[i] = uFreeMemBufB;
			uCurGoldenStreamBufAddr[i] = uGoldenStreamBufAddr[i];
			if(FS_Read(&GoldenStreamHandler[i], GoldenStreamHandler[i].nSize, (u32 *)(uGoldenStreamBufAddr[i]), &uRealReadSize) !=0)
			{
				Disp("Golden Stream Read Fai\n");
				return;
			}
			uGoldenStreamSize[i] = GoldenStreamHandler[i].nSize;
			uFreeMemBufB += Align(uGoldenStreamSize[i], 16);
		}
		else
		{
			GoldenStreamEftInfo[i] = EFT_RequestFileInfo(aGoldenStreamFileName[i]);
			if(GoldenStreamEftInfo[i].fileID==-1 || GoldenStreamEftInfo[i].fileSize==0)
			{
				Disp("Golden Stream Read Fai \n");
				return;
			}
			uFreeMemBufB=Align(uFreeMemBufB, 16);
			uGoldenStreamBufAddr[i] = uFreeMemBufB;
			uCurGoldenStreamBufAddr[i] = uGoldenStreamBufAddr[i];
			EFT_ReadFile(&GoldenStreamEftInfo[i], (u32 *)(uGoldenStreamBufAddr[i]));
			uGoldenStreamSize[i] = GoldenStreamEftInfo[i].fileSize;
			uFreeMemBufB += Align(uGoldenStreamSize[i], 16);
		}
		DispCodecName(eEncStandard[i]);
	}
	
	uFreeMemBufA = Align(uFreeMemBufA, 128*1024);
	uFwCodeStAddr = uFreeMemBufA;

	uFreeMemBufB = Align(uFreeMemBufB, 128*1024);
	
	// Load F/W
	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &Handler)!=0)
		{
			Disp("F/W Open Fail \n");
			return;
		}
		if(FS_Read(&Handler, Handler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		EftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(EftInfo.fileID==-1 || EftInfo.fileSize==0)
		{
			Disp("F/W Open Fail \n");
			return;
		}
		EFT_ReadFile(&EftInfo, (u32 *)uFwCodeStAddr);
	}
 
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC); 
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	for(i=0; i<nDecProcessCount+nEncProcessCount; i++)
	{
		bFinishedProcess[i]=false;
	}

	uDramBBaseAddr = uFreeMemBufB;
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	uFreeMemBufA = uCpbBufStAddr; // Needs for Enc codec buffer.
	ePreparedCh = CMD_CH0;

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		// DEC
		for(i=0; i<nDecProcessCount; i++)
		{
			uIdx = i;
			if(bFinishedProcess[uIdx] == false)
			{
				ebDecStandard=true;
				MFC_SetProcessIdx(uIdx);
				
				// sequence parsing
				if(bSeqHeadPasing[uIdx]==true)
				{		
					MFC_InitProcessForDecoding(uIdx, eDecStandard[uIdx], bPixelCacheEn, false, true);  

					bIsRcv[uIdx] = (strcmp(cFileExt[uIdx],"rcv")==0) ? true : false;
					uRemainSz[uIdx] = uReadSizeUnit[uIdx];
					uRet[uIdx] = VsParser(eDecStandard[uIdx], uStreamBufStAddr[uIdx], uRemainSz[uIdx], 
											&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
					//Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);

					bFirstSeqheader[uIdx] = false;
					uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
					if(eDecStandard[uIdx]==VC1RCV_DEC)
						uRemainSz[uIdx] -= uOneFrameSz+8;
					else
						uRemainSz[uIdx] -= uOneFrameSz;
					if (uRet[uIdx]==3)
					{
						Disp("Parsing Error\n");
						return;
					}
					Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);
					MFC_SetCmdChNum(ONE_CH_CMD);
					MFC_SetDramBDpbBufStAddr(uDramBBaseAddr);
					
					if(bFirstDecInstance == true)
					{
						MFC_ParseStreamHeaderAndSetBuf(ePreparedCh, uCpbBufStAddr, uOneFrameSz);
						bFirstDecInstance = false;
					}
					else
					{
						uDecABufStAddr = uFreeMemBufA;
						uDecBBufStAddr = uFreeMemBufB;
						MFC_ParseStreamHeader(ePreparedCh, uCpbBufStAddr, uOneFrameSz);
						MFC_SetBufAddrOfDecoder(uFreeMemBufA, uFreeMemBufB);
						MFC_InitBuffer(CMD_CH0, uIdx);
					}

					MFC_GetDbpBufEndAddr(uIdx, &uFreeMemBufA, &uFreeMemBufB);	
					MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
					MFC_GetImagePicSize(&uPicHsz[uIdx], &uPicVsz[uIdx]);
					MFC_GetImageFrameSize(&uFrameHsz[uIdx], &uFrameVsz[uIdx]);
					bSeqHeadPasing[uIdx] = false;
				}
				
				if(bIsFirstFrame[uIdx]==true)
				{
					bIsFirstFrame[uIdx] = false;
					if(eDecStandard[uIdx] == H263_DEC)
					{
						MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz, FRAME); 
					}
					else
					{
						continue;
					}
				}
				else if(bNoMoreStream[uIdx]==true)
				{
					MFC_StartDecodingOneFrame(ePreparedCh, uPreFrameSize[uIdx], LAST_SEQ);
				}
#if 0
				else if((eDecStandard[uIdx]==H264_DEC) && (bDispOnlyFrame[uIdx]==true) && (bNoMoreStream[uIdx]==false))
				{
					MFC_StartDecodingOneFrame(CMD_CH0, uPreFrameSize[uIdx], FRAME);
				}
#endif
				else
				{
					uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
						&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);

					//Disp("One Frame Addr:0x%x, One Frame Size:0x%x, uRemainSz:0x%x\n", uOneFrameAddr, uOneFrameSz, uRemainSz[uIdx]);
					//Disp("uRdPtr[uIdx]:0x%x, uRdPtr[uIdx] + uRemainSz[uIdx]=0x%x\n", uRdPtr[uIdx], uRdPtr[uIdx]+uRemainSz[uIdx]);

					if(uRet[uIdx]==0)
					{
						uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
						//Disp("RdPtr[uIdx]:0x%x\n", uRdPtr[uIdx] );

						if(eDecStandard[uIdx]==VC1RCV_DEC)
							uRemainSz[uIdx] -= uOneFrameSz+4;
						else
							uRemainSz[uIdx] -= uOneFrameSz;
						Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
						MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz, FRAME);
					}
					else if((uRet[uIdx]==1) || (uRet[uIdx]==2))
					{
						if(uTotalRemainSz[uIdx] && bPartialLoad[uIdx])
						{
							Disp("[PartialLoad]");
							//UART_Getc();
							uTotalRemainSz[uIdx] += uRemainSz[uIdx];
							if(MULTI_STREAM_FILE_BUF_SIZE<=uTotalRemainSz[uIdx])
							{
								uFileOffset[uIdx] -= uRemainSz[uIdx];
								uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
							}
							else
							{
								uFileOffset[uIdx]-= uRemainSz[uIdx];
								uReadSizeUnit[uIdx] = uTotalRemainSz[uIdx];
							}
							if(bSdLoadMode)
							{
								//Disp("1. FileOffset:0x%x\n", uFileOffset[uIdx]);
								if(FS_Seek(&StreamHandler[uIdx], uFileOffset[uIdx], 0) != 0)
								{
									Disp("Stream Seek Fail\n");
									return;
								}
								if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
								{
									Disp("Stream Read Fail\n");
									return;
								}
								uFileOffset[uIdx] = StreamHandler[uIdx].nOffset;
								//Disp("2. FileOffset:0x%x\n", uFileOffset[uIdx]);
							}
							else
							{
								EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx], uFileOffset[uIdx], uReadSizeUnit[uIdx]);
								uFileOffset[uIdx] += uReadSizeUnit[uIdx];
							}
							uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
							uRdPtr[uIdx] = uStreamBufStAddr[uIdx];
							uRemainSz[uIdx] = uReadSizeUnit[uIdx];
							continue;
						}

						if(eDecStandard[uIdx]!= H264_DEC)
						{
							bMustbeChecked[uIdx] = false;	
							uFinishedProcessNum++;
							bFinishedProcess[uIdx] = true;
							continue;
						}
						Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
						MFC_StartDecodingOneFrame(ePreparedCh, uOneFrameSz, LAST_SEQ);
						bNoMoreStream[uIdx] = true;
					}
					if(uRet[uIdx]==3)
					{
						Disp("Parsing Error\n");
						return;
					}
				}
				
				if(!MFC_WaitForFrameDone())
				{
					Disp("[ERR]\n");
					//break;
				}
				if(MFC_IsDecodingFinished())
				{
					Disp("[BUF FLUSHED]\n");
					if(eDecStandard[uIdx] == H264_DEC)
					{
						bFinishedProcess[uIdx] = true;
						//MFC_CloseInstance(uInstanceId[uIdx]);
						uFinishedProcessNum++;
					}
					break;	
				}

				//MFC_GetDispType(&eDispType);
				MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		
		
				if((eDecStandard[uIdx]!=H264_DEC)&&(!bNoMoreStream[uIdx]))
				{
					uDecFrameCnt[uIdx]++;
					//Disp("[%d]",uDecFrameCnt[uIdx]);
				}
				else if(eDecStandard[uIdx]==H264_DEC)
				{
					if(eDispType==DISP_ONLY)
					{
						bDispOnlyFrame[uIdx]=true;
						uPreFrameSize[uIdx]=uOneFrameSz;
						uRdPtr[uIdx] = uRdPtr[uIdx] - uOneFrameSz;
						uRemainSz[uIdx] += uOneFrameSz;
					}
					else
					{
						uDecFrameCnt[uIdx]++;
						//Disp("[%d] ",uDecFrameCnt[uIdx]);
						bDispOnlyFrame[uIdx]=false;
					}
				}

				if(bDispMode)
				{
					if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == true)
					{
						bProcessingDoneA = false;
						xPos = i%uDispHorizontalDiv;
						yPos = i/uDispHorizontalDiv;
		
						uDispWidth = uDispWidth/16*16;	// uDispWidth must be 16's multiple

						FIMC_InitIpForDinDout(FIMC_A,
							uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
							0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
							0, TILE_NV12,
							uLcdHSz, uLcdVSz,
							uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight,	0,	
							uLcdFbAddr, eBpp,		
							ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
						FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
						FIMC_StartProcessingForMfc(FIMC_A);
						while(!bProcessingDoneA);
						bProcessingDoneA = false;
						FIMC_StopProcessing(FIMC_A);
					}
				}
				
				MFC_GetPictureType(&ePictype[uIdx], &binterlace[uIdx]);
				if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked[uIdx])
				{				
					if(CheckCrcDiff(eDecStandard[uIdx], uRefCrcBufAddr[uIdx], uNumOfCrc)==false)
					{
						Disp("Dec[%d] Fail : Mismatch %d frames!!\n", uIdx,  uDecFrameCnt[uIdx]);
						uDecErrorCnt[uIdx]++;
						uFirstFailed++;
						Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
					}
					else
					{
						Disp("[%d]", uIdx);
					}
					if(uNumOfCrc==2)
					{
						if(bSaveResult)
							Copy8(0xf1702030, uCurCrcBufStAddr[uIdx], 8);
						uCurCrcBufStAddr[uIdx]+=8;
						uRefCrcBufAddr[uIdx]+=8;
					}
					else // uNumOfCrc==4
					{
						if(bSaveResult)
							Copy8(0xf1702030, uCurCrcBufStAddr[uIdx], 16);
						uCurCrcBufStAddr[uIdx]+=16;
						uRefCrcBufAddr[uIdx]+=16;
					}
					if(uRefCrcFileSize[uIdx] == (uCurCrcBufStAddr[uIdx]-uCrcBufStAddr[uIdx]))
					{
						bMustbeChecked[uIdx] = false;
					}
				}
			}
		}

		// ENC
		for(i=nDecProcessCount; i<nDecProcessCount+nEncProcessCount; i++)
		{
			uIdx = i;
			if(bFinishedProcess[uIdx] == false)
			{
				ebDecStandard=false;
				MFC_SetProcessIdx(uIdx);
			
				if(bCreatedProcess[uIdx] == false)
				{	
					// parse a config file
					MFC_ParseConfigFile(uCfgFileBufAddr[uIdx]);
					
					// set the encoding parameters
					MFC_SetConfigParameters();		
					
					// calculate total frame count to encode
					MFC_CalculateTotalFramesToEnc();
					UART_Putc('\n');

					//MFC_CreateInstance(uIdx, eEncStandard[uIdx], true,&uEncInstanceId[uIdx]);
					// get encoding parameters
					MFC_GetEncFrameSizeCfg(&uEncWidth[uIdx], &uEncHeight[uIdx]);   
					MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames[uIdx]);
					MFC_GetEncPicTypeCfg(&uNumOfBFrames[uIdx]);
					MFC_GetInterlace(&uIsInterlace[uIdx]);
					MFC_GetIDRPeriod(&uIDR_period[uIdx]);
					MFC_GetSrcImgFileName(aYuvFileName[uIdx]);
					uSrcYuvFrameSizeInBytes[uIdx] = uEncWidth[uIdx] * uEncHeight[uIdx] *3/2;

					uFreeMemBufA = Align(uFreeMemBufA, 2*1024);
					uFreeMemBufB = Align(uFreeMemBufB, 2*1024);
					MFC_InitProcessForEncoding(uIdx, eEncStandard[uIdx], bPixelCacheEn, eLinearTileMode);
					MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
					MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
					MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
					if(bSdLoadMode)
					{
						if(FS_Open(aYuvFileName[uIdx], &YuvHandler[uIdx])!=0)
						{
							Disp("Yuv Open Fail\n");
							return;
						}
					}
					else
					{	
						YuvEftInfo[uIdx] = EFT_RequestFileInfo(aYuvFileName[uIdx]);
						if(YuvEftInfo[uIdx].fileID==-1 || YuvEftInfo[uIdx].fileSize==0)
						{
							Disp("Yuv Open Fail\n");
							return;
						}
					}
					uSrcYuvStAddr[uIdx] = uFreeMemBufB;
					uSrcYuvAddr[uIdx] = uSrcYuvStAddr[uIdx];
					uFreeMemBufB += uSrcYuvFrameSizeInBytes[uIdx];
					//Disp("YUV Buf Start Addr[%2d] : 0x%08x\n", uIdx, uSrcYuvStAddr[uIdx]);

					if(bSaveResult==true)
					{
						uStreamBufStAddr[uIdx] = uFreeMemBufB;
						uFreeMemBufB += MFC_ENC_STREAM_BUF_SIZE;
					}

					//Disp("Stream Buf Start Addr[%2d] : 0x%08x\n", uIdx, uStreamBufStAddr[uIdx]);

					// seq header
					MFC_EncodingOneFrame(SEQ_HEADER);
					MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame[uIdx]);
					MFC_GetEncSteamBufAddr(&uEncStreamBufAddr[uIdx]);
					if(CompareStreamData(uCurGoldenStreamBufAddr[uIdx], uEncStreamBufAddr[uIdx], uEncStrSzPerFrame[uIdx]))
					{
						Disp("[%d]", uIdx);
						//Disp("[*]");
					}
					else
					{
						Disp("Enc[%d]:: SEQ Header Mismatch %d frames!!\n", uIdx);
						uEncErrorCnt[uIdx]++;
						uFirstFailed++;
					}
					
					// Read a stream from stream buffer
					if(bSaveResult==true)
					{
						MFC_ReadEncOneFrameStream((uStreamBufStAddr[uIdx]+uStreamBufOffset[uIdx]), uEncStrSzPerFrame[uIdx]);
						uStreamBufOffset[uIdx] += uEncStrSzPerFrame[uIdx];
					}

					uCurGoldenStreamBufAddr[uIdx] += uEncStrSzPerFrame[uIdx];
					//Disp("\nENC : Seq_Parsing\t"); 
					//Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame[uIdx]);
					
					bCreatedProcess[uIdx] = true;
				}
				
				// Load one frame to the temporary buffer
				if(uFrameCnt[uIdx] <= uNumOfTotFrames[uIdx]-1)
				{
					if(bSdLoadMode)
					{
						if(FS_Seek(&YuvHandler[uIdx], uFrameCnt[uIdx]*uSrcYuvFrameSizeInBytes[uIdx], 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						
						if(FS_Read(&YuvHandler[uIdx], uSrcYuvFrameSizeInBytes[uIdx], (u32 *)uSrcYuvAddr[uIdx], &uRealReadSize) !=0)
						{
							Disp("Yuv Read Fail\n");
							return;
						}			
					}
					else
					{
						EFT_ReadFilePartial(&YuvEftInfo[uIdx], (u32 *)uSrcYuvAddr[uIdx], uFrameCnt[uIdx]*uSrcYuvFrameSizeInBytes[uIdx], uSrcYuvFrameSizeInBytes[uIdx]);
					}
				}
				
				MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr[uIdx], &uSrcNv12CAddr[uIdx]);
#if 0
				Copy8(uSrcYuvAddr[uIdx], uSrcNv12YAddr[uIdx], (uEncWidth[uIdx]*uEncHeight[uIdx]));
				MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr[uIdx]+(uEncWidth[uIdx]*uEncHeight[uIdx])), uEncWidth[uIdx], uEncHeight[uIdx], uSrcNv12CAddr[uIdx]);		
#else
				if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
				{
					FIMC_InitIpForDinDout(FIMC_A,
						uEncWidth[uIdx], uEncHeight[uIdx], 0,
						0, 0, uEncWidth[uIdx], uEncHeight[uIdx],
						uSrcYuvAddr[uIdx], YC420,
						uEncWidth[uIdx], uEncHeight[uIdx],
						0, 0, uEncWidth[uIdx], uEncHeight[uIdx], 0, // Scaler	
						uSrcNv12YAddr[uIdx], NV12,		
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
				}
				else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
				{
					FIMC_InitIpForDinDout(FIMC_A,
						uEncWidth[uIdx], uEncHeight[uIdx], 0,
						0, 0, uEncWidth[uIdx], uEncHeight[uIdx],
						uSrcYuvAddr[uIdx], YC420,
						uEncWidth[uIdx], uEncHeight[uIdx],
						0, 0, uEncWidth[uIdx], uEncHeight[uIdx], 0, // Scaler		
						uSrcNv12YAddr[uIdx], TILE_NV12,		
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
				}

				FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
				uSrcNv12YAddr[uIdx], uSrcNv12YAddr[uIdx], uSrcNv12YAddr[uIdx], uSrcNv12YAddr[uIdx],
				uSrcNv12CAddr[uIdx], uSrcNv12CAddr[uIdx], uSrcNv12CAddr[uIdx], uSrcNv12CAddr[uIdx]);
				bProcessingDoneA = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
				while(!bProcessingDoneA);		
				FIMC_StopProcessing(FIMC_A);
#endif
				// Encode a frame
				if(bLastOrNoMoreYC[uIdx] == false)
					eCmdType = FRAME;
				else
					eCmdType = LAST_SEQ;
				
				MFC_EncodingOneFrame(eCmdType);

				if(!MFC_WaitForFrameDone())
				{
					Disp("[ERR]\n");
					//break;
				}

				MFC_ReleaseCurrentYCBuf();						

				// Stop if encoding is completed.
				if(MFC_IsEncodingFinished()==true)
				{
					bFinishedProcess[uIdx] = true;
					uFinishedProcessNum++;
					//MFC_CloseInstance(uEncInstanceId[uIdx]);
					break;
				}

				MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame[uIdx]);

				if(uEncStrSzPerFrame[uIdx] != 0)
				{
					//Disp("\nENC[%2d] : [%d]\t ", uIdx, uEncFrameCnt[uIdx]); 
					//Disp("Stream Size[%2d] : 0x%x\t ",  uIdx, uEncStrSzPerFrame[uIdx]);
					//Disp("Frame Type[%2d] : %s\n",  uIdx, cFrameType[uIdx] );
										
					///////////////////////////////////////////////////////////////////////////////////////////
					// compare per frame.
					MFC_GetEncSteamBufAddr(&uEncStreamBufAddr[uIdx]);
					//Disp(" EncStreamBufAddr : 0x%x\n", uEncStreamBufAddr[uIdx]);
					if(CompareStreamData(uCurGoldenStreamBufAddr[uIdx], uEncStreamBufAddr[uIdx], uEncStrSzPerFrame[uIdx]))
					{
						Disp("[%d]", uIdx);
						//Disp("[*]");
					}
					else
					{
						Disp("Enc[%d]:: Mismatch %d frames!!\n", uIdx, uEncFrameCnt[uIdx]);
						uEncErrorCnt[uIdx]++;
						uFirstFailed++;
					}
					uCurGoldenStreamBufAddr[uIdx] += uEncStrSzPerFrame[uIdx];
					///////////////////////////////////////////////////////////////////////////////////////////
					uEncFrameCnt[uIdx]++;
					
					// Read a stream from stream buffer
					if(bSaveResult==true)
					{
						MFC_ReadEncOneFrameStream((uStreamBufStAddr[uIdx]+uStreamBufOffset[uIdx]), uEncStrSzPerFrame[uIdx]);
						uStreamBufOffset[uIdx] += uEncStrSzPerFrame[uIdx];
					}
				}
				
				if (uIsInterlace[uIdx] == 1)
				{
					MFC_EncodingOneFrame(eCmdType);
					
					if(!MFC_WaitForFrameDone())
					{
						Disp("[ERR]\n");
						//break;
					}
					
					// Stop if encoding is completed.	
					if(MFC_IsEncodingFinished()==true)
					{
						bFinishedProcess[uIdx] = true;
						uFinishedProcessNum++;
						//MFC_CloseInstance(uEncInstanceId[uIdx]);
						break;
					}

					MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame[uIdx]);

					if(uEncStrSzPerFrame[uIdx] != 0)
					{
						//Disp("\nENC[%2d] : [%d]\t ", uIdx, uEncFrameCnt[uIdx]); 
						//Disp("Stream Size[%2d] : 0x%x\t ",  uIdx, uEncStrSzPerFrame[uIdx]);
						//MFC_GetFrameType(&cFrameType[uIdx]);
						//Disp("Frame Type[%2d] : %s\n",  uIdx, cFrameType[uIdx] );

						///////////////////////////////////////////////////////////////////////////////////////////
						// compare per frame.
						MFC_GetEncSteamBufAddr(&uEncStreamBufAddr[uIdx]);
						///Disp(" EncStreamBufAddr : 0x%x\n", uEncStreamBufAddr[uIdx]);
						if(CompareStreamData(uCurGoldenStreamBufAddr[uIdx], uEncStreamBufAddr[uIdx], uEncStrSzPerFrame[uIdx]))
						{
							//Disp("ENC[%d]:[.]\n", uIdx);
							Disp("[*]");
						}
						else
						{
							Disp("ENC[%d]:: Bottom Field Mismatch %d frames!!\n", uIdx, uEncFrameCnt[uIdx]-1);
							uEncErrorCnt[uIdx]++;
							uFirstFailed++;
						}
						uCurGoldenStreamBufAddr[uIdx] += uEncStrSzPerFrame[uIdx];
						///////////////////////////////////////////////////////////////////////////////////////////

						if(bSaveResult==true)
						{
							MFC_ReadEncOneFrameStream((uStreamBufStAddr[uIdx]+uStreamBufOffset[uIdx]), uEncStrSzPerFrame[uIdx]);
							uStreamBufOffset[uIdx] += uEncStrSzPerFrame[uIdx];
						}
					}
				}

				MFC_ReleaseCurrentYCBuf();

				uFrameCnt[uIdx]++;
				
				if(uFrameCnt[uIdx] == uNumOfTotFrames[uIdx]-1)
					bLastOrNoMoreYC[uIdx] = true;	
			}
		}
		if(uFinishedProcessNum == nDecProcessCount+nEncProcessCount)
			break;
	}

	for(i=0; i<nDecProcessCount+nEncProcessCount; i++)
	{
		MFC_CloseInstance(uInstanceId[i]);
	}

	MFC_ResetIp();
	
	for(i=0; i<nDecProcessCount; i++)
	{
		if(uDecErrorCnt[i]==0)
		{
			Disp("\n[%s]", pFileName[i]);
			Disp("\n########## [%d] Decoding Pass ##########\n", i);
			uFirstFailed=0;
		}
		else
		{
			Disp("\n[%s]", pFileName[i]);
			Disp("\n########## [%d] Decoding Fail ##########\n", i);
		}
	}

	for(i=nDecProcessCount; i<nDecProcessCount+nEncProcessCount; i++)
	{
		if(uEncErrorCnt[i]==0)
		{
			Disp("\n[%s]", pFileName[i]);
			Disp("\n########## [%d] Encoding Pass ##########\n", i);
			uFirstFailed=0;
		}
		else
		{
			Disp("\n[%s], ", pFileName[i]);
			Disp("\n########## [%d] Encoding Fail ##########\n", i);
		}
	}

#if 0
	// Enc:compare encoded stream with golden strem
	for(i=nDecProcessCount; i<nDecProcessCount+nEncProcessCount; i++)
	{
		if(uStreamBufOffset[i] == uGoldenStreamSize[i])
		{
			if (CompareStreamData(uGoldenStreamBufAddr[i], uStreamBufStAddr[i], uGoldenStreamSize[i]))
			{
				Disp("\n########## [%d] Encoding Pass ##########\n", i);
			}
			else
			{
				Disp("\n########## [%d] Encoding Fail ##########\n", i);
				uEncErrCnt++;
			}
		}
		else
		{
			Disp("\n## FAIL : Encoded Stream Size(%d) is different from Gloden Stream Size(%d) ##\n", uStreamBufOffset, uStreamFileSize);
			uEncErrCnt++;
		}
	}
#endif

	if(bSaveResult==true)
	{
		for(i=0; i<nDecProcessCount+nEncProcessCount; i++)
		{
			if(i<nDecProcessCount)
			{

				strcpy(aFileName, pFileName[i]);
				uIdx = strlen(aFileName);
				while (1)
				{
					if (aFileName[--uIdx] == '.')
						break;
				}
				strcpy(&aFileName[uIdx+1], "crc"); 

				if(bSdLoadMode)
				{
					FS_Creat(pFileName[i], &StreamHandler[i]);
					FS_Write(&StreamHandler[i], uStreamBufOffset[i], (u32 *)uStreamBufStAddr[i], &uRealReadSize);
				}
				else
				{
					sprintf(aGotCrcPath[i],"%s%s%s","F:\\MFC_Result\\Result\\", aFileName, ".result.crc");
					EftInfo=EFT_RequestCreateFileInfo(aGotCrcPath[i]);
					EFT_WriteFile(&EftInfo, (u32 *)uCrcBufStAddr[i], uCurCrcBufStAddr[i]-uCrcBufStAddr[i]);
				}
			}
			else
			{
				// Enc stream
				strcpy(aGoldenStreamFileName[i], pFileName[i]);
				uIdx = strlen(pFileName[i]);
				while (1)
				{
					if (aGoldenStreamFileName[i][--uIdx] == '.')
						break;
				}
				if(eEncStandard[i] ==H263_ENC)
					strcpy(&aGoldenStreamFileName[i][uIdx], "_gen.263");
				else if(eEncStandard[i] ==H264_ENC)
					strcpy(&aGoldenStreamFileName[i][uIdx], "_gen.264");
				else if(eEncStandard[i] ==MPEG4_ENC)
					strcpy(&aGoldenStreamFileName[i][uIdx], "_gen.m4v");
				else
					Assert(0);
	 
				if(bSdLoadMode)
				{
					FS_Creat(aGoldenStreamFileName[i], &GoldenStreamHandler[i]);
					FS_Write(&GoldenStreamHandler[i], uStreamBufOffset[i], (u32 *)uStreamBufStAddr[i], &uRealReadSize);
				}
				else
				{
					sprintf(aGoldenStreamPath[i],"%s%s","F:\\MFC_Result\\Result\\",aGoldenStreamFileName[i]);
					StreamEftInfo[i]=EFT_RequestCreateFileInfo(aGoldenStreamPath[i]);
					EFT_WriteFile(&StreamEftInfo[i], (u32 *)uStreamBufStAddr[i], uStreamBufOffset[i]);
				}
			}
		}
	}

#if 0		
	Disp("\n");
	Disp("===============// DEC //==============\n");
	for (i=0; i<nDecProcessCount; i++)
	{
		Disp("%d: [%d] frames decoded\n", i,  uDecFrameCnt[i]);
	}
	// . save a stream file to SD card and then unload file system
	//----------------------------------------------------
	Disp("\n");
	Disp("===============// ENC //===============\n");
	for (i=nDecProcessCount; i<nDecProcessCount+nEncProcessCount; i++)
	{
		Disp("\nTotal Stream Size[%2d] : 0x%08x(%d)\n", i, uStreamBufOffset[i], uStreamBufOffset[i]);
		Disp("Stream[%2d] : 0x%08x ~ 0x%08x\n", i, uStreamBufStAddr[i], (uStreamBufStAddr[i]+uStreamBufOffset[i]-1));
	}
	Disp("=======================================\n");
#endif
}


////////////////////////////////////////////////////////////////////////////////
// 1. If CIR is ON, Multi instance encoding is not support [H/W constraint] ////
////////////////////////////////////////////////////////////////////////////////

static void TestRandomConformanceForMulti(void)
{
	u32 i, j, k, m, uIdx;
	u32 uCodecRandNum;
	u32 uEncCodecRandNum;
	u32 uDecCodecRandNum;
	u32 uTestCnt=0;
	u32 uFailCnt;
	char cFileExt[50];
	ETHERNET_FILE FilelistEftInfo;
	u8* uFileListBuf[MAX_PROCESS_NUM];
	u32 uFileListSize[MAX_PROCESS_NUM];
	u32 uNumOfRanDomTest;
	u32 uNumOfInstance;
	VIDEO_CODEC_TYPE eStandard;
	char* aFileList;
	char aFileListPath[MAX_FILENAME_SIZE];
	char cFileName[MAX_FILENAME_SIZE];
	t_file_handler FileListHandler;
	u32 uRealReadSize;
	u32 uLoopCnt=0;

	k=0;
	bRandomMultiTest = true;
	
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		Disp("How many processes do you want for decoding[1~%d]?\n", MAX_PROCESS_NUM);
		//nDecProcessCount = UART_GetIntNum();

		#if 0
		//nDecProcessCount = rand()%16;
		#else
		nDecProcessCount = 1;
		#endif
		
		//Disp("How many processes do you want for encoding? (1~%d)\n", MAX_PROCESS_NUM-nDecProcessCount);
		//nEncProcessCount = UART_GetIntNum();

		#if 0
		nEncProcessCount = rand()%(16-nDecProcessCount);
		#else
		nEncProcessCount = 0;
		#endif

		uLoopCnt++;
		Disp("Loop Count : %d\n", uLoopCnt);
		
#if 0 // dec+enc test
		for(uDecCodecRandNum=0; uDecCodecRandNum<8; uDecCodecRandNum++)
		{
			for(uEncCodecRandNum=0; uEncCodecRandNum<3; uEncCodecRandNum++)
			{
#endif

				for(i=0; i<nDecProcessCount; i++)
				{
					uCodecRandNum = SBLK_GetRand()%8;
					//uCodecRandNum = rand()%8;

					//odecRandNum = 5;
					//if((uCodecRandNum==0)||(uCodecRandNum==6)||(uCodecRandNum==7))
					//	uCodecRandNum = 0;
					//uDecCodecRandNum = nDecProcessCount;

					switch(uCodecRandNum)
					{
						case 0:		
							aFileList = "H264_StreamFileList.txt"; // H264_ENC
							eDecStandard[i] = H264_DEC;
							break;
						case 1:		
							aFileList = "VC1AP_StreamFileList.txt"; // MPEG4_ENC
							eDecStandard[i] = VC1AP_DEC;
							break;
						case 2:		
							aFileList = "VC1RCV_StreamFileList.txt"; //  VC1RCV_DEC
							eDecStandard[i] = VC1RCV_DEC;
							break;
						case 3:		
							aFileList = "MPEG4_StreamFileList.txt";
							eDecStandard[i] = MPEG4_DEC;
							break;
						case 4:		
							aFileList = "MPEG2_StreamFileList.txt";
							eDecStandard[i] = MPEG2_DEC;
							break;
						case 5:		
							aFileList = "H263_StreamFileList.txt";
							eDecStandard[i] = H263_DEC;
							break;
						case 6:		
							aFileList = "DVIX4_StreamFileList.txt";
							eDecStandard[i] = DivX412_DEC;
							break;
						case 7:		
							aFileList = "DVIX5_StreamFileList.txt"; // DivX502_DEC, DivX503_DEC
							eDecStandard[i] = DivX503_DEC;
							break;
						default:
							break;
					}
					if(bSdLoadMode)
					{
						if(FS_Open(aFileList, &FileListHandler)!=0)
							return;

						uFileListBuf[i] = (u8 *)malloc(FileListHandler.nSize);		
						if(FS_Read(&FileListHandler, FileListHandler.nSize, (u32 *)uFileListBuf[i], &uRealReadSize) !=0)
						{
							Disp("FileList Open Fail\n");
							return;
						}	
						uFileListSize[i] = FileListHandler.nSize;

					}
					else
					{
						sprintf(aFileListPath,"%s%s","E:\\CCV\\FileList_Folder\\",aFileList);
						FilelistEftInfo = EFT_RequestFileInfo(aFileListPath);
						if(FilelistEftInfo.fileID==-1 || FilelistEftInfo.fileSize==0)
						{
							Disp("FileList Open Fail\n");
						}

						uFileListBuf[i] = (u8 *)malloc(FilelistEftInfo.fileSize);
						EFT_ReadFile(&FilelistEftInfo, (u32*)  (uFileListBuf[i]));
						uFileListSize[i] = FilelistEftInfo.fileSize;
					}
				}

				for(i=nDecProcessCount; i<nDecProcessCount+nEncProcessCount; i++)
				{
					uCodecRandNum = SBLK_GetRand()%3;
					//uCodecRandNum = 1;

					//uEncCodecRandNum = (nDecProcessCount+nEncProcessCount-1)-i;
					switch(uCodecRandNum)
					{
						case 0:		
							aFileList = "H263_CfgFileList.txt"; // H264_ENC
							eEncStandard[i] = H263_ENC;
							break;
						case 1:		
							aFileList = "MPEG4_CfgFileList.txt"; // MPEG4_ENC
							eEncStandard[i] = MPEG4_ENC;
							break;
						case 2:		
							aFileList = "H264_CfgFileList.txt"; // H263_ENC
							eEncStandard[i] = H264_ENC;
							break;
						default:
							break;
					}
					if(bSdLoadMode)
					{
						if(FS_Open(aFileList, &FileListHandler)!=0)
						return;

						uFileListBuf[i] = (u8 *)malloc(FileListHandler.nSize);
						if(FS_Read(&FileListHandler, FileListHandler.nSize, (u32 *)uFileListBuf[i], &uRealReadSize) !=0)
						{
							Disp("FileList Open Fail\n");
							return;
						}
						uFileListSize[i] = FileListHandler.nSize;
					}
					else
					{
						sprintf(aFileListPath,"%s%s","E:\\CCV\\FileList_Folder\\",aFileList);
						FilelistEftInfo = EFT_RequestFileInfo(aFileListPath);
						if(FilelistEftInfo.fileID==-1 || FilelistEftInfo.fileSize==0)
						{
							Disp("FileList Open Fail\n");
						}

						uFileListBuf[i] = (u8 *)malloc(FilelistEftInfo.fileSize);
						EFT_ReadFile(&FilelistEftInfo, (u32*)  (uFileListBuf[i]));
						uFileListSize[i] = FilelistEftInfo.fileSize;
					}
				}

				j=0;
				for(uIdx=0; uIdx<nDecProcessCount+nEncProcessCount; uIdx++)
				{
					if(uIdx<nDecProcessCount)
					{
						if(eDecStandard[uIdx] == H264_DEC)
							m = SBLK_GetRand()%70;
						else if(eDecStandard[uIdx] == DivX412_DEC)
							m = SBLK_GetRand()%9;
						else if(eDecStandard[uIdx] == H263_DEC)
							m = SBLK_GetRand()%54;
						else if(eDecStandard[uIdx] == DivX503_DEC)
							m = SBLK_GetRand()%11;
						else if(eDecStandard[uIdx] == MPEG4_DEC)
							m = SBLK_GetRand()%25;
						else if(eDecStandard[uIdx] == VC1AP_DEC)
							m = SBLK_GetRand()%56;
						else if(eDecStandard[uIdx] == VC1RCV_DEC)
							m = SBLK_GetRand()%37;
						else if(eDecStandard[uIdx] == MPEG2_DEC)
							m = SBLK_GetRand()%67;
					}
					else
					{
						if(eEncStandard[uIdx] == H263_ENC)
							m = SBLK_GetRand()%2;
						else if(eEncStandard[uIdx] == H264_ENC)
							m = SBLK_GetRand()%20;
						else if(eEncStandard[uIdx] == MPEG4_ENC)
							m = SBLK_GetRand()%6;
					}

					for(i=0; i<uFileListSize[uIdx]; i++)
					{	
						if(	UART_GetKey() == '0')
							break;
						aFileName[j] = uFileListBuf[uIdx][i];
						if(aFileName[j] == 0x20 ||aFileName[j] == 0x0d || aFileName[j] == 0x0a)
						{
							if(aFileName[j] == 0x0a)
								k++;
							aFileName[j]=0;

							if(strlen(aFileName)!=0 && (k==m))
							{
								strcpy(pFileName[uIdx], aFileName); // pFileName = streamFileName or cfgFileName
								memset(aFileName, 0, j);
								j=0;
								k=0;

								Disp("[%s]\n", pFileName[uIdx]);
								strcpy(cFileName, pFileName[uIdx]);
								break;
							}
							memset(aFileName, 0, j);
							j=0;
						}
						else
						{
							j++;
						}
					}
				}

				uFirstFailed = 0xffff;
				
				TestConformanceForMulti();
				
				for(i=0; i<nDecProcessCount+nEncProcessCount ; i++)
					free(uFileListBuf[i]);
				
				if(uFirstFailed==0xffff)
				{
					Disp("*************************\n");
					Disp("[%s]:File isn't existed !\n", cFileName);
					Disp("*************************\n");
					memset(cFileName, 0, j);
					j=0;
					k=0;
					continue;
				}
				uFailCnt += (uFirstFailed==0) ? 0 : 1;
				uTestCnt++;
				
#if 0 // dec+enc test
			}
		}
#endif
	}
	Disp("Random Conformance end\n");
	bRandomMultiTest = false;
}

static void MakeStreamFrameListInfoFile(void)
{
	u32 i=0;
	u32 uIdx;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uStreamSize;
	u8 bIsFirstFrame=true;
	u32 uStreamBufStAddr = 0x20000000;
	ETHERNET_FILE StreamEftInfo;
	t_file_handler StreamHandler;
	char cFileExt[50];
	char aFileName[MAX_FILENAME_SIZE];
	char pFileName[MAX_FILENAME_SIZE];
	char aFrameListName[MAX_FILENAME_SIZE];
	u32 uRealReadSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u8 bIsRcv=false;
	u32 uFrameInfoListAddr;
	u32 uFrameInfoListStAddr;
	u32 uOneFrameAddrOffset;
	u8 bFirstSeqheader = true;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uStreamBufStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}		
		uStreamSize = StreamHandler.nSize;
	}
	else
	{
		// 0. Download the stream file by Ethernet.
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		
		EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamBufStAddr);
		uStreamSize = StreamEftInfo.fileSize;
		EFT_GetFileNameExt(aFileName, cFileExt);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	
	uRemainSz = uStreamSize;
	uRdPtr = uStreamBufStAddr;

	uFrameInfoListStAddr = Align(uStreamBufStAddr+uStreamSize, 16);
	uFrameInfoListAddr=uFrameInfoListStAddr;
	
	while(1)
	{
		uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, false);
		bFirstSeqheader = false;
		
		//if( (uRet==1)||(uRet==2) ) uOneFrameSz = uRemainSz;
		uRdPtr = uOneFrameAddr+uOneFrameSz;
		if(eDecStandard==VC1RCV_DEC)
		{
			if(bFirstSeqheader==true)
			{
				uRemainSz -= uOneFrameSz+8;
				bFirstSeqheader = false;
			}
			else
			{
  				uRemainSz -= uOneFrameSz+4;
			}
		}
		else
		{
			uRemainSz -= uOneFrameSz;
		}
		
		bIsFirstFrame=false;
		
		uOneFrameAddrOffset = uOneFrameAddr - uStreamBufStAddr;
		
		Outp32(uFrameInfoListAddr, uOneFrameAddrOffset);
		Outp32(uFrameInfoListAddr+4, uOneFrameSz);
		uFrameInfoListAddr+=8;
		i++;

		if(uRet==3)
		{
			Disp("Parsing Error\n");
			return;
		}
		if(uRet==1 ||uRet==2)
			break;
	};
	Disp("FrameList Done\n");

	strcpy(pFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (pFileName[--uIdx] == '.')
			break;
	}
	strcpy(&pFileName[uIdx+1], "Info");

	Disp("FrameInfo:0x%x ~~ 0x%x\n", uFrameInfoListStAddr, uFrameInfoListAddr);
	
	if(bSdLoadMode)
	{
		FS_Creat(pFileName, &StreamHandler);
		if(FS_Write(&StreamHandler, uFrameInfoListAddr-uFrameInfoListStAddr, (u32 *)uFrameInfoListStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}		
	}
	else
	{
		sprintf(aFrameListName,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\", pFileName);
		StreamEftInfo=EFT_RequestCreateFileInfo(aFrameListName);
		EFT_WriteFile(&StreamEftInfo, (u32 *)uFrameInfoListStAddr, uFrameInfoListAddr-uFrameInfoListStAddr);
	}	
}

static void ChangeEndian(void)
{
	u32 i, x;
	ETHERNET_FILE FwEftInfo;
	t_file_handler	FwHandler;
	char aFileName[MAX_FILENAME_SIZE];
	char aFwFileName[MAX_FILENAME_SIZE];
	u32 uRealReadSize;
	u32 uFwSize;
	u32 temp_value;
	u32 val1, val2, val3, val4;

	Disp("Write down F/W FileName to change endian : ");
	UART_GetString(aFileName);
	
	if(bSdLoadMode)
	{
		if(FS_Open(aFileName, &FwHandler)!=0)
			return;

		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)(0x20000000), &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}

		for(i=0; i<FwHandler.nSize ; i+=4)
		{
			temp_value=Inp32(0x20000000+i);

			val1=0;
			val2=0;
			val3=0;
			val4=0;

			val1 = (temp_value & 0xff) << 24;
			val2 = ((temp_value >> 8) & 0xff) << 16;
			val3 = ((temp_value >> 16) & 0xff) << 8;
			val4 = ((temp_value >> 24) & 0xff);

			temp_value = (val1 | val2 | val3 | val4);

			Outp32(0x20000000+i, temp_value);
		}
		Disp(">>>>> Endian Change OK! <<<<<\n");	
		
		uFwSize = FwHandler.nSize;
		FS_Creat("mfd_vo.bin", &FwHandler);
		FS_Write(&FwHandler, uFwSize, (u32 *)0x20000000, &uRealReadSize);
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo(aFileName);
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("Invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)(0x20000000));
		uFwSize = FwEftInfo.fileSize; //file size

		for(i=0; i<FwEftInfo.fileSize; i+=4)
		{
			temp_value=Inp32(0x20000000+i);

			val1=0;
			val2=0;
			val3=0;
			val4=0;

			val1 = (temp_value & 0xff) << 24;
			val2 = ((temp_value >> 8) & 0xff) << 16;
			val3 = ((temp_value >> 16) & 0xff) << 8;
			val4 = ((temp_value >> 24) & 0xff);

			temp_value = (val1 | val2 | val3 | val4);

			Outp32(0x20000000+i, temp_value);
		}
		Disp(">>>>> Endian Change OK! <<<<<\n");

		FwEftInfo=EFT_RequestCreateFileInfo("E:\\CCV\\SA2\\SW\\K-FileServer\\mfd_vo.bin");
		EFT_WriteFile(&FwEftInfo, (u32 *)0x20000000, uFwSize);
	}

	Disp("Endian Change Done.");
}

static void SetSrcClkAndClkDivider(u32 uPll, u32 uDivA2M, u32 uDivMfc, u8* bChangedClk)
{
	u32 m, k, i=0, j=0;
	u32 uFoutAPLL = 0;
    u32 uFoutMPLL = 0;
	u32 uFoutEPLL = 0;
	u32 uFoutVPLL = 0;
	u32 uMaxMfcClk = 200000000;
	u32 uMinMfcClk =  50000000;
	u32 uApll = 0;
	u32 uMpll = 1;
	u32 uEpll = 2;
	u32 uVpll = 3;
	u32 uCLKSRC = 0;
	u32 uRegCLKSRC2 = 0xE0100208;
	u32 uRegCLKDIV2  = 0xE0100308;
	u32 uRegCLKDIV0 = 0xE0100300;
	u32 uRegMusStatus = 0xE0101104;
	u32 uClkSrc2Reg;
	u32 uClkDiv2Reg;
	u32 uClkDiv0Reg;
	u32 uFailCnt=0;
	u32 uTestCnt=0;
	u32 uMuxStatus;
	u32 uMuxSel;

	if(uPll == 0) // Apll
	{
		m = uApll;
		uCLKSRC = g_uAPLL;
		Disp("========================\n");
		Disp("[MFC Source Clk : APLL]\n");
		Disp("========================\n");
			
		if((uCLKSRC/(uDivA2M+1)/(uDivMfc+1) <= uMaxMfcClk) && (uCLKSRC/(uDivA2M+1)/(uDivMfc+1) >= uMinMfcClk))
		{
			Disp("[MFC Core CLK : %d MHz]", uCLKSRC/(uDivA2M+1)/(uDivMfc+1)/1000000);
			Disp("-[uDivMFC : 0x%x ]",uDivMfc);             
   			Disp("-[uDivA2M : 0x%x ]\n",uDivA2M);   

			uClkSrc2Reg = Inp32(uRegCLKSRC2);
		    uClkSrc2Reg &= ~(0x3<<4);
		    uClkSrc2Reg |= (m<<4);
			Outp32(uRegCLKSRC2, uClkSrc2Reg);

			Delay(2000);
			
			uClkDiv2Reg = Inp32(uRegCLKDIV2);
		    uClkDiv2Reg &= ~(0xf<<4);
		    uClkDiv2Reg |= (uDivMfc<<4);
			Outp32(uRegCLKDIV2, uClkDiv2Reg);

			Delay(2000);
			
			uClkDiv0Reg = Inp32(uRegCLKDIV0);
		    uClkDiv0Reg &= ~(0x7<<4);
		    uClkDiv0Reg |= (uDivA2M<<4);
			Outp32(uRegCLKDIV0, uClkDiv0Reg);

			Delay(2000);

			*bChangedClk = true;
		}
		else
		{
			Disp("[MFC Core CLK : %d MHz]", uCLKSRC/(uDivA2M+1)/(uDivMfc+1)/1000000);
			Disp("-[uDivMFC : 0x%x ]",uDivMfc);             
   			Disp("-[uDivA2M : 0x%x ]\n",uDivA2M);
			Disp("Not operation Clock\n\n");
			*bChangedClk = false;
		}
	}
	
	if((uPll == 1)||(uPll == 2)||(uPll == 3))
	{
		if(uPll == 1)
		{
			m = uMpll;
			uCLKSRC = g_uMPLL;
			uMuxSel = 0x1;
			Disp("========================\n");
			Disp("[MFC Source Clk : MPLL]\n");
			Disp("========================\n");
		}
		else if(uPll == 2)
		{
			m = uEpll;
			uCLKSRC = g_uEPLL;
			uMuxSel = 0x4;
			Disp("========================\n");
			Disp("[MFC Source Clk : EPLL]\n");
			Disp("========================\n");
		}
		else if(uPll == 3)
		{
			m = uVpll;
			uCLKSRC = g_uVPLL;
			uMuxSel = 0x6;
			Disp("========================\n");
			Disp("[MFC Source Clk : VPLL]\n");
			Disp("========================\n");
		}
		
		if((uCLKSRC/(uDivMfc+1) <= uMaxMfcClk) && (uCLKSRC/(uDivMfc+1) >= (uMinMfcClk)))
		{
			Disp("[MFC Core CLK : %d MHz]",uCLKSRC/(uDivMfc+1)/1000000);
			Disp("-[uDivMFC : 0x%x ]\n",uDivMfc);
			
			uClkSrc2Reg = Inp32(uRegCLKSRC2);
		    uClkSrc2Reg &= ~(0x3<<4);
		    uClkSrc2Reg |= (m<<4);
			Outp32(uRegCLKSRC2, uClkSrc2Reg);

			Delay(2000);

			uClkDiv2Reg = Inp32(uRegCLKDIV2);
		    uClkDiv2Reg &= ~(0xf<<4);
		    uClkDiv2Reg |= (uDivMfc<<4);
			Outp32(uRegCLKDIV2, uClkDiv2Reg);

			Delay(2000);
			
			uClkDiv0Reg = Inp32(uRegCLKDIV0);
		    uClkDiv0Reg &= ~(0x7<<4);
		    uClkDiv0Reg |= (uDivA2M<<4);
			Outp32(uRegCLKDIV0, uClkDiv0Reg);

			Delay(2000);

			do {
				uMuxStatus = Inp32(uRegMusStatus);
			}while(!( ((uMuxStatus>>4) & uMuxSel) == uMuxSel));

			//Disp("Mux Status : 0x%x\n", uMuxStatus);
			*bChangedClk = true;
		}
		else
		{
			Disp("[MFC Core CLK : %d MHz]",uCLKSRC/(uDivMfc+1)/1000000);
			Disp("-[uDivMFC : 0x%x ]\n",uDivMfc);  
			Disp("Not operation Clock\n\n");
			*bChangedClk = false;
		}
	}
}


static void SetCrcSaveMode(void)
{
	int x;
	Disp(" Enter the Dec CRC save mode (0:Non Save, 1:Saves) ? ");
	x = UART_GetIntNum();
	Disp("\n\n");

	bSaveResult = (x==0) ? (false) :
					(x==1) ? (true) : bSaveResult;
}

static void SetFimcPath(void)
{
 	int x;
	
	Disp("1:DMA IN DMA OUT	2.DMA IN FIFO OUT	:");
	x = UART_GetIntNum();

	bFimcDinDout= (x==1) ? true : false;
}

static void SetSliceIfDec(void)
{
 	int x;
	
	Disp("1:Frame Base Decoding 	2.Slice Base Decoding	:");
	x = UART_GetIntNum();
	bSliceBaseDec= (x==1) ? false : true;
}
	
static void SetMemStructType(void)
{
 	int x;
	Disp("1:Linear Mode 	2.64x32 tiled Mode	:");
	x = UART_GetIntNum();
	eLinearTileMode = (x==1) ? MB_LINEAR_MODE : MB_TILE_MODE_FOR_ENC;
}

static void SetConformanceMode(void)
{
 	int x;
	
	Disp("1:Comformance Mode	2.No Conformance Mode	:");
	x = UART_GetIntNum();

	bConformanceTestAll= (x==1) ? true : false;
}

#if 1
static void SMSC_SenderWapper(u8 *pBuf,u16 usLen)
{
	SMSC_Sender((u32 *)pBuf, usLen);
}
#endif
 
static void SelectFileLoadMode(void)
{
	int x;
	
	Disp("1:SD LOAD		2.ETHERNET LOAD :");
	x = UART_GetIntNum();
	
	bSdLoadMode =(x==1) ? true : false;
	
	if(bSdLoadMode)
	{
	    GPIO_Init();
		if(FS_Init()!=0)
			Disp("Fail to open FAT with SD CARD\n");
	}
	else
	{
		if(EFT_Init(DefaultMACAddress,DefaultIPAddress,TargetIPAddress)==false)
		{
			Disp("Fail to init Network System\n");
			return;
		}
		//Init Protocol stacks
#if 1
		PROTOCOL_InitStackWithUDP(DefaultMACAddress,DefaultIPAddress,SMSC_SenderWapper,UDP_ReceiveHandler);
		SMSC_RegisterReceiveHandler(PROTOCOL_FrameHander);
		SMSC_Init(DefaultMACAddress);
#else
		PROTOCOL_InitStackWithUDP(DefaultMACAddress,DefaultIPAddress,DM9000_SendFrame,UDP_ReceiveHandler);
		DM9000_SetGPIO();
		DM9000_Reset();
		DM9000_RegisterReceiveHandler(PROTOCOL_FrameHander);
		DM9000_Init(DefaultMACAddress);
#endif
	}
		
}

u8 TestEncodingForAutoTest(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	//char aConfigFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler GoldenStreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;
	u32 uFrameCount=0;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
		
	uFwCodeStAddr = 0x20000000;
	uDramBBaseAddr = 0x41000000;


	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

#if 0
	// aFileName : Cfg File Name
	eEncStandard = (strcmp(aFileName,"fpga_rc_Whale_30_cfg000x.cfg")==0) ? H263_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg100.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg084x.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg000.cfg")==0) ? H264_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg089.cfg")==0) ? H264_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg679.cfg")==0) ? H264_ENC :  Assert(0);

	MFC_SetCodecStandard(0, eEncStandard);						
#elif 0
	eEncStandard = (strcmp(aFileName,"fpga_rc_Whale_30_cfg000x.cfg")==0) ? H263_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg000x.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg084x.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg000x.cfg")==0) ? H264_ENC :
#elif 1
	eEncStandard = H263_ENC;
	MFC_SetCodecStandard(0, eEncStandard);		
#endif
	
	// Load a config file
	uCfgFileBufAddr = uFreeMemBuf;
	if(FS_Open(aFileName, &CfgFileHandler)!=0)
	{
		Disp("Cfg Open Fail\n");
		return;
	}
	if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
	{
		Disp("Cfg Read Fail\n");
		return;
	}
	uFreeMemBuf += CfgFileHandler.nSize;
	*(char *)uFreeMemBuf++ = NULL;

	// Load a golden stream file
	strcpy(aStreamFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
 	uFreeMemBuf = Align(uFreeMemBuf, 16);
	
	uGoldenStreamBufAddr = uFreeMemBuf;
	uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
	if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
	{
		Disp("Golden Stream Open Fail\n");
		return;
	}
	if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
	{
		Disp("Golden Stream Read Fail\n");
		return;
	}
	
	uGoldenStreamSize = GoldenStreamHandler.nSize;
	uFreeMemBuf += uGoldenStreamSize;

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		
	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	
	uFreeMemBuf = uFreeMemBufB;

	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes+512;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;

	Disp("\nENC : Seq_Parsing\t"); 
	Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);

	uFrameCount = 0;
	uValidFrmCnt = 0;
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		
		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		MFC_ReleaseCurrentYCBuf();	
		
		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;
			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			//uStreamBufOffset += uEncStrSzPerFrame;
		}
		
		if (uIsInterlace == 1)
		{
			MFC_EncodingOneFrame(eCmdType);
			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
		
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				//uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();

		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	

		if(uValidFrmCnt == 3)
			break;
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
//	MFC_ResetIp();

	// Save a stream file to SD card and then unload file system
	Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	if(uErrCnt==0)
	{
		Disp("[%s]: PASS\n",aFileName);
		Disp("\n########## Encoding Pass ##########\n");
	}
	else
	{
		Disp("[%s]: FAIL\n",aFileName);
		Disp("\n########## Encoding Fail ##########\n");
	}
#if 0	
	// Compare encoded stream with golden strem
	if (CompareStreamData(uGoldenStreamBufAddr, uStreamBufStAddr, uStreamBufOffset))
	{
		Disp("\n########## Encoding Pass ##########\n");
	}
	else
	{
		Disp("\n########## Encoding Fail ##########\n");
		uErrCnt++;
	}
#endif

	if(uErrCnt)
	{
		uFirstFailed=  uErrCnt;
		return false;
	}
	else
	{
		uFirstFailed=0;
		return true;
	}
}

u8 TestDecodingForAutoTest(void)
{
	u32 i, uIdx;
	u32 uStreamFileStAddr;
	u32 uFreeMemBufA;
	u32 uFreeMemBufB;
	VIDEO_CODEC_TYPE eDecStandard;
	MFC_DISP_TYPE eDispType;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	u8 bNoMoreStream = false;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uRemainSz;
	char cCodecName[50];
	u8 binterlace=false;
	u32 uErrorCnt=0;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr;
	u32 uDramBBaseAddr;
	u8 bMustbeChecked=true;
	MFC_PIC_TYPE ePictype;
	u8 bVc1Field=false;
	u8 bDispOnlyFrame=false;
	u8 bFirstSeqheader = true;
	u32 uCurrCrcSize=0;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CrcFileHandler;	
	u32 uRealReadSize;
	char pFileName[255];
	u32 uNumOfCrc;
	
	uFwCodeStAddr = 0x20000000;
	uStreamFileStAddr = 0x41000000;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);

	// aFileName : Stream File Name
	if(FS_Open(aFileName, &StreamHandler)!=0)
	{
		Disp("Stream Open Fail\n");
		return;
	}
	
	uStreamFileSize=StreamHandler.nSize; 
	
	if(FS_Read(&StreamHandler, uStreamFileSize, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}

	// 2. REF CRC load
	uRefCrcBufAddr = Align(uStreamFileStAddr+uStreamFileSize, 4);
	
	if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
	{
		Disp("CRC Open Fail\n");
		return;
	}

	if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
	{
		Disp("CRC Read Fail\n");
		return;
	}
	
	uRefCrcFileSize = CrcFileHandler.nSize;
	
	uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);

	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	FS_GetFileNameExt(aFileName, cFileExt);
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	uRemainSz  = uStreamFileSize;

	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
 	bFirstSeqheader = false;
 
	bIsFirstFrame = true;	
 
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;

	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;	
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true )	
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC )
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			//Disp("uOneFrameAddr:x0%x, uOneFrameSz:0x%\n",uOneFrameAddr, uOneFrameSz);
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				uErrorCnt++;
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eDecStandard==VC1RCV_DEC)	
					uRemainSz -= uOneFrameSz+4;
				else
					uRemainSz -= uOneFrameSz;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1)||(uRet==2))
			{ 
				if((eDecStandard!=H264_DEC))
				{
					bMustbeChecked = false;
					break; // last frame decoding skip
				}
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[DEC ERR]\n");
			uErrorCnt++;
			break;
		}
		if(MFC_IsDecodingFinished() || (bMustbeChecked==false))	// Because One frame stream
			break;
		
		MFC_GetDispType(&eDispType);
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;

		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			//Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
		{			
			if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(uNumOfCrc==2)
			{
				uCurrCrcSize+=8;
				uRefCrcBufAddr+=8;
			}
			else // uNumOfCrc==4
			{
				uCurrCrcSize+=16;
				uRefCrcBufAddr+=16;
			}
			if(uRefCrcFileSize == uCurrCrcSize)
				break;
		}
		
		if(uErrorCnt)
		{
			uFirstFailed =  uErrorCnt;
			break;
		}
		else
			uFirstFailed = 0;
	}

	MFC_CloseInstance(uInstanceId);
	MFC_ResetIp();
	
	if(uErrorCnt)
	{
		Disp("\n[%s]:[%d Tot Frame] FAIL\n",aFileName,uFrameCnt);
		return false;
	}
	else
	{
		Disp("\n[%s]:[%d Tot Frame] PASS\n",aFileName,uFrameCnt);
		return true;
	}
}

u8 MFC_AutoTest(void)
{
	u32 i,j;
	u32 uTestCnt=0;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uFailCnt;
	char cFileExt[50];
	t_file_handler FileListHandler;
	t_file_handler FileInfoHandler;
	u8* uFileListBuf;
	u32 uFileListSize;
	u32 uRealReadSize;
	u8 bTestFail=false;
	
	bConformanceTestAll=true;
	
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");
	
	// In Fillist, Stream File Name and Cfg file Name must be written.
	if(FS_Open("Filelist.txt", &FileListHandler)!=0)
		return;

	uFileListBuf = (u8 *)malloc(FileListHandler.nSize);

	if(FS_Read(&FileListHandler, FileListHandler.nSize, (u32 *)uFileListBuf, &uRealReadSize) !=0)
	{
		Disp("FileList Read Fail\n");
		return;
	}
	uFileListSize = FileListHandler.nSize;

	j=0;
	for(i=0; i<uFileListSize; i++)
	{
		if(	UART_GetKey() == '0')
			break;

		aFileName[j] = uFileListBuf[i];
		if(aFileName[j] == 0x20 ||aFileName[j] == 0x0D || aFileName[j] == 0x0a)
		{
			aFileName[j]=0; //null

			if(strlen(aFileName)!=0)
			{						
				uFirstFailed = 0xffff;
				Disp("\n[%s]\n",aFileName);
				FS_GetFileNameExt(aFileName, cFileExt);

				if(MFC_GetCodecType(cFileExt, &eDecStandard) == true)
				{		
					if(TestDecodingForAutoTest()==false)
					{
						bTestFail = true;
						return false;
					}
				}
				else // cfg extension
				{
					if(TestEncodingForAutoTest()==false)
					{
						bTestFail = true;
						return false;
					}
				}
	
				if(uFirstFailed==0xffff)	// when the file is not in.
				{
					Disp("[%s]:File is NOT Existed !\n", aFileName);
					memset(aFileName, 0, j);
					j=0;
					continue;
				}
				uFailCnt += (uFirstFailed==0) ? 0 : 1;
				uTestCnt++;
				memset(aFileName, 0, j);
				j=0;
			}	
		}		
		else
		{
			 j++;
		}
	}
	free(uFileListBuf);	
	
	if(uFailCnt==0) 
		Disp("DEC : All PASS!!\n");
	Disp("TOTAL:%d PASS:%d FAIL:%d\n", uTestCnt, (uTestCnt-uFailCnt), uFailCnt);
	return true;
}

static void TestConformance(void)
{
	u32 i,j, uIdx;
	u32 uTestCnt=0;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uFailCnt; 
	char cFileExt[50];
	ETHERNET_FILE FilelistEftInfo;
	t_file_handler FileListHandler;
	u32 uRealReadSize;
	u8* uFileListBuf;
	u32 uFileListSize;
	u32 uAviFileAddr;
	int Codec;
	
	bConformanceTestAll=true;
	ebDecStandard=true;
	
	if(bSdLoadMode)
	{
		if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");
	
		// In Filelist, Stream File Name and Cfg file Name must be written.
		if(FS_Open("FileList.txt", &FileListHandler)!=0)
			return;

		uFileListBuf = (u8 *)malloc(FileListHandler.nSize);

		if(FS_Read(&FileListHandler, FileListHandler.nSize, (u32 *)uFileListBuf, &uRealReadSize) !=0)
		{
			Disp("FileList Read Fail\n");
			return;
		}
		uFileListSize = FileListHandler.nSize;

		j=0;
		for(i=0; i<uFileListSize; i++)
		{
			if(	UART_GetKey() == '0')
				break;

			aFileName[j] = uFileListBuf[i];
			if(aFileName[j] == 0x20 ||aFileName[j] == 0x0D || aFileName[j] == 0x0a)
			{
				aFileName[j]=0; //null

				if(strlen(aFileName)!=0)
				{						
					uFirstFailed = 0xffff;
					//Disp("\n[%s]\n",aFileName);
					FS_GetFileNameExt(aFileName, cFileExt);

					if(strcmp(cFileExt, "avi")==0)
					{
						TestDecodingWithDivX311CrcComparison();
					}
					else if(MFC_GetCodecType(cFileExt, &eDecStandard) == true)
					{		
						TestDecodingWithCrcComparison();
					}
					else if(strcmp(cFileExt, "cfg")==0)
					{
						//TestEncodingForAutoTest();
						TestEncodingWithComparion();
					}

					if(uFirstFailed==0xffff)	// when the file is not in.
					{
						Disp("[%s]:File is NOT Existed !\n", aFileName);
						memset(aFileName, 0, j);
						j=0;
						continue;
					}
					uFailCnt += (uFirstFailed==0) ? 0 : 1;
					uTestCnt++;
					memset(aFileName, 0, j);
					j=0;
				}	
			}		
			else
			{
				 j++;
			}
		}
		free(uFileListBuf);	
		
	}
	else
	{
		FilelistEftInfo = EFT_RequestFileInfo("E:\\CCV\\SA2\\SW\\K-FileServer\\DivX_3_filtered.txt");
		if(FilelistEftInfo.fileID==-1 || FilelistEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
		}

		uFileListBuf = (u8 *)malloc(FilelistEftInfo.fileSize);
		EFT_ReadFile(&FilelistEftInfo, (u32*)  uFileListBuf);
		uFileListSize = FilelistEftInfo.fileSize; //file size

		j=0;
		for(i=0; i<uFileListSize; i++)
		{
			if(	UART_GetKey() == '0')
				break;

			aFileName[j] = uFileListBuf[i];
			if(aFileName[j] == 0x20 ||aFileName[j] == 0x0D || aFileName[j] == 0x0a)
			{
				aFileName[j]=0; //null

				if(strlen(aFileName)!=0)
				{						
					EFT_GetFileNameExt(aFileName, cFileExt);
					uFirstFailed = 0xffff;

					if(strcmp(cFileExt, "avi")==0)
					{
						TestDecodingWithDivX311CrcComparison();
					}
					else
					{
						if(MFC_GetCodecType(cFileExt, &eDecStandard) == true)
						{		
								TestDecodingWithCrcComparison();
						}
					}
					if(uFirstFailed==0xffff)	// when the file is not in.
					{
						Disp("[%s]:File is NOT Existed !\n", aFileName);
						memset(aFileName, 0, j);
						j=0;
						continue;
					}
					uFailCnt += (uFirstFailed==0) ? 0 : 1;
					uTestCnt++;
					memset(aFileName, 0, j);
					j=0;
				}	
			}		
			else
			{
				 j++;
			}
		}
		free(uFileListBuf);
	}
	bConformanceTestAll=false;
	if(uFailCnt==0) 
		Disp("All Case PASS!!\n");
	Disp("TOTAL:%d PASS:%d FAIL:%d\n", uTestCnt, (uTestCnt-uFailCnt), uFailCnt );
}

static void TestDecodingPowerGating(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uFreeMemBufA;
	u32 uFreeMemBufB;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstSeqheader=true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;

	ebDecStandard=true;
	bFirstFimcFifoOut = true;
	uFwCodeStAddr = 0x20000000;
	uStreamFileStAddr = 0x41000000;
	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;
	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);	
	MFC_SetCmdChNum(ONE_CH_CMD);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);


	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uLcdFbAddr=uFreeMemBufA;
		LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		
			uFreeMemBufA, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}	
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);

			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		
		if(MFC_IsDecodingFinished())
		{
			Disp("Buffer flushed!\n");
			break;
		}
		
		if(!bNoMoreStream)
		{
			uFrameCnt++;
			Disp("[%d]\n",uFrameCnt);
		}

		MFC_GetDispType(&eDispType);
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		bProcessingDoneA = false;

		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");

	// block power off & on]
	//MFC_ResetIp();
	//Outp32(0xf1700000, 0);
	//Outp32(0xf1700000, 0x3fe);
	//Delay(1000);
	
	SYSC_SetBlockPowerOFF_IP(eMFC);
	//DelayfrTimer(milli, SBLK_GetRand()%10);
	//Delay(1000);	
	//SYSC_SetBlockPowerON_IP(eMFC);
	//MFC_ResetIp();
}

static void TestDecodingClkGating(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uFreeMemBufA;
	u32 uFreeMemBufB;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstSeqheader = true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;

	ebDecStandard=true;
	bFirstFimcFifoOut=true;
	uFwCodeStAddr = 0x20000000;
	uStreamFileStAddr = 0x41000000;
	
	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;
	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);	
	MFC_SetCmdChNum(ONE_CH_CMD);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uLcdFbAddr=uFreeMemBufA;
		LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		
			uFreeMemBufA, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}	
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);

			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		
		if(MFC_IsDecodingFinished())
		{
			Disp("Buffer flushed!\n");
			break;
		}
		
		if(!bNoMoreStream)
		{
			uFrameCnt++;
			Disp("[%d]\n",uFrameCnt);
		}

		if( (uFrameCnt%5) ==0)
		{
			// Clock off & on
			SYSC_SetClkOFF_IP(eMFC);
			DelayfrTimer(milli, SBLK_GetRand()%10);	
			SYSC_SetClkON_IP(eMFC);		
		}
		
		MFC_GetDispType(&eDispType);
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		bProcessingDoneA = false;

		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");
}

static void TestEncodingClkGating(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameCount=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	//char aConfigFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler GoldenStreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE GoldenStreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	uFwCodeStAddr = 0x20000000;	
	uDramBBaseAddr = 0x41000000;
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

	MFC_SelectEncStandard(0, &eEncStandard);

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	// Load a golden stream file
	strcpy(aStreamFileName, aCfgFileName);
	uIdx = strlen(aCfgFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
	Disp("Golden Stream File Name is %s\n", aStreamFileName);
	
 	uFreeMemBuf = Align(uFreeMemBuf, 16);
	
	uGoldenStreamBufAddr = uFreeMemBuf;
	uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
	if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
	{
		Disp("Golden Stream Open Fail\n");
		return;
	}
	if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
	{
		Disp("Golden Stream Read Fail\n");
		return;
	}
	
	uGoldenStreamSize = GoldenStreamHandler.nSize;
	uFreeMemBuf += uGoldenStreamSize;

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	

	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
	
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;

	Disp("\nENC : Seq_Parsing\t"); 
	Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		// Clock off & on
		SYSC_SetClkOFF_IP(eMFC);
		DelayfrTimer(milli, SBLK_GetRand()%10);	
		SYSC_SetClkON_IP(eMFC);	

		MFC_ReleaseCurrentYCBuf();	
			
		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;
			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			//uStreamBufOffset += uEncStrSzPerFrame;
		}

		if (uIsInterlace == 1)
		{
			MFC_EncodingOneFrame(FRAME);

			// Clock off & on
			SYSC_SetClkOFF_IP(eMFC);
			DelayfrTimer(milli, SBLK_GetRand()%10);	
			SYSC_SetClkON_IP(eMFC);	
			
			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
		
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				//MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				//uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();
		
		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
	//MFC_ResetIp();

	// Save a stream file to SD card and then unload file system
	//Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	//Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	if(uErrCnt==0)
	{
		Disp("\n########## Encoding Pass ##########\n");
	}
	else
	{
		Disp("\n########## Encoding Fail ##########\n");
	}
}

static void TestDecodingPowerClkOnOff(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uFreeMemBufA;
	u32 uFreeMemBufB;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstPostProcessing=true;
	u8 bFirstSeqheader = true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;

	ebDecStandard=true;
	bFirstFimcFifoOut = true;
	SYSC_SetBlockPowerOFF_IP(eMFC);
	SYSC_SetClkOFF_IP(eMFC);
		
	uStreamFileStAddr = 0x20000000;
	uDramBBaseAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		
		// 2. F/W load
		uFwCodeStAddr = Align(uStreamFileStAddr+uReadSizeUnit+512, 128*1024);

		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);

		// 2. F/W load
		uFwCodeStAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	


	SYSC_SetBlockPowerON_IP(eMFC);
	SYSC_SetClkON_IP(eMFC);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;
	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);	
	MFC_SetCmdChNum(ONE_CH_CMD);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,		
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		uLcdFbAddr=uFreeMemBufA;
		LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		
			uFreeMemBufA, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC )
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}	
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		
		if(MFC_IsDecodingFinished())
		{
			Disp("Buffer flushed!\n");
			break;
		}
		
		if(!bNoMoreStream)
		{
			uFrameCnt++;
			Disp("[%d]\n",uFrameCnt);
		}
		
		MFC_GetDispType(&eDispType);
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		bProcessingDoneA = false;

		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");

	SYSC_SetBlockPowerOFF_IP(eMFC);
	SYSC_SetClkOFF_IP(eMFC);
}

static void TestSrcClkAndDivider(void)
{
	u32 m, k, i=0, j=0;
	u32 uFoutAPLL = 0;
    u32 uFoutMPLL = 0;
	u32 uFoutEPLL = 0;
	u32 uFoutVPLL = 0;
	u32 uMaxMfcClk = 200000000;
	u32 uMinMfcClk =  50000000;
	u32 uApll = 0;
	u32 uMpll = 1;
	u32 uEpll = 2;
	u32 uVpll = 3;
	u32 uCLKSRC = 0;
	u32 uDivA2M = 0;
	u32 uDivMfc = 0;
	u32 uRegCLKSRC2 = 0xE0100208;
	u32 uRegCLKDIV2  = 0xE0100308;
	u32 uRegCLKDIV0 = 0xE0100300;
	u32 uRegMusStatus = 0xE0101104;
	u32 uClkSrc2Reg;
	u32 uClkDiv2Reg;
	u32 uClkDiv0Reg;
	u32 uFailCnt=0;
	u32 uTestCnt=0;
	u32 uMuxStatus;
	u32 uMuxSel;
	
	bConformanceTestAll = true;
	ebDecStandard=true;
	
	for(uDivA2M=0; uDivA2M<8; uDivA2M++)
	{
		m = uApll;
		uCLKSRC = g_uAPLL;
		Disp("========================\n");
		Disp("[MFC Source Clk : APLL]\n");
		Disp("========================\n");
		
		for(uDivMfc = 0; uDivMfc<16; uDivMfc++)
		{
			if((uCLKSRC/(uDivA2M+1)/(uDivMfc+1) <= uMaxMfcClk) && (uCLKSRC/(uDivA2M+1)/(uDivMfc+1) >= uMinMfcClk))
			{
				Disp("[MFC Core CLK : %d MHz]", uCLKSRC/(uDivA2M+1)/(uDivMfc+1)/1000000);
				Disp("-[uDivMFC : 0x%x ]",uDivMfc);             
	   			Disp("-[uDivA2M : 0x%x ]\n",uDivA2M);   

				uClkSrc2Reg = Inp32(uRegCLKSRC2);
			    uClkSrc2Reg &= ~(0x3<<4);
			    uClkSrc2Reg |= (m<<4);
				Outp32(uRegCLKSRC2, uClkSrc2Reg);

				Delay(2000);
				
				uClkDiv2Reg = Inp32(uRegCLKDIV2);
			    uClkDiv2Reg &= ~(0xf<<4);
			    uClkDiv2Reg |= (uDivMfc<<4);
				Outp32(uRegCLKDIV2, uClkDiv2Reg);

				Delay(2000);
				
				uClkDiv0Reg = Inp32(uRegCLKDIV0);
			    uClkDiv0Reg &= ~(0x7<<4);
			    uClkDiv0Reg |= (uDivA2M<<4);
				Outp32(uRegCLKDIV0, uClkDiv0Reg);

				Delay(2000);
				
				k = SBLK_GetRand()%8;
				k=0;
				switch(k)
				{
					case 0:
						strcpy(aFileName, "3210.m4v");
						break;
					case 1:
						strcpy(aFileName, "h263_test933.263");
						break;
					case 2:
						strcpy(aFileName, "mpeg2_test647.es");
						break;
					case 3:
						strcpy(aFileName, "vc1_test437.vc1");
						break;
					case 4:
						strcpy(aFileName, "25_HCAMFF1_HHI.264");
						break;
					case 5:
						strcpy(aFileName, "5121.dvx4");
						break;
					case 6:
						strcpy(aFileName, "4031.dvx");
						break;
					case 7:
						strcpy(aFileName, "vc1_test1252.rcv");
						break;
					default:
						Assert(0);
						break;
				}
				TestDecodingWithCrcComparison();
			}
			else
			{
				Disp("[MFC Core CLK : %d MHz]", uCLKSRC/(uDivA2M+1)/(uDivMfc+1)/1000000);
				Disp("-[uDivMFC : 0x%x ]",uDivMfc);             
	   			Disp("-[uDivA2M : 0x%x ]\n",uDivA2M);
				Disp("Not operation Clock\n\n");
			}
		}
	}


	for(i=0;i<3;i++)
	{
		if(i==0)
		{
			m = uMpll;
			uCLKSRC = g_uMPLL;
			uMuxSel = 0x1;
			Disp("========================\n");
			Disp("[MFC Source Clk : MPLL]\n");
			Disp("========================\n");
		}
		else if(i==1)
		{
			m = uEpll;
			uCLKSRC = g_uEPLL;
			uMuxSel = 0x4;
			Disp("========================\n");
			Disp("[MFC Source Clk : EPLL]\n");
			Disp("========================\n");
		}
		else if(i==2)
		{
			m = uVpll;
			uCLKSRC = g_uVPLL;
			uMuxSel = 0x6;
			Disp("========================\n");
			Disp("[MFC Source Clk : VPLL]\n");
			Disp("========================\n");
		}
		
		for(uDivMfc = 0; uDivMfc<16; uDivMfc++)
		{
			if((uCLKSRC/(uDivMfc+1) <= uMaxMfcClk) && (uCLKSRC/(uDivMfc+1) >= (uMinMfcClk)))
			{
				Disp("[MFC Core CLK : %d MHz]",uCLKSRC/(uDivMfc+1)/1000000);
				Disp("-[uDivMFC : 0x%x ]\n",uDivMfc);
				
				uClkSrc2Reg = Inp32(uRegCLKSRC2);
			    uClkSrc2Reg &= ~(0x3<<4);
			    uClkSrc2Reg |= (m<<4);
				Outp32(uRegCLKSRC2, uClkSrc2Reg);

				Delay(2000);

				uClkDiv2Reg = Inp32(uRegCLKDIV2);
			    uClkDiv2Reg &= ~(0xf<<4);
			    uClkDiv2Reg |= (uDivMfc<<4);
				Outp32(uRegCLKDIV2, uClkDiv2Reg);

				Delay(2000);
				
				uClkDiv0Reg = Inp32(uRegCLKDIV0);
			    uClkDiv0Reg &= ~(0x7<<4);
			    uClkDiv0Reg |= (uDivA2M<<4);
				Outp32(uRegCLKDIV0, uClkDiv0Reg);

				Delay(2000);

				do {
					uMuxStatus = Inp32(uRegMusStatus);
				}while(!( ((uMuxStatus>>4) & uMuxSel) == uMuxSel));

				//Disp("Mux Status : 0x%x\n", uMuxStatus);

				k = SBLK_GetRand()%8;
				
				k=0;
				switch(k)
				{
					case 0:
						strcpy(aFileName, "3210.m4v");
						break;
					case 1:
						strcpy(aFileName, "h263_test933.263");
						break;
					case 2:
						strcpy(aFileName, "mpeg2_test647.es");
						break;
					case 3:
						strcpy(aFileName, "vc1_test437.vc1");
						break;
					case 4:
						strcpy(aFileName, "25_HCAMFF1_HHI.264");
						break;
					case 5:
						strcpy(aFileName, "5121.dvx4");
						break;
					case 6:
						strcpy(aFileName, "4031.dvx");
						break;
					case 7:
						strcpy(aFileName, "vc1_test1252.rcv");
						break;
					default:
						Assert(0);
						break;
				}
				TestDecodingWithCrcComparison();
			}
			else
			{
				Disp("[MFC Core CLK : %d MHz]",uCLKSRC/(uDivMfc+1)/1000000);
				Disp("-[uDivMFC : 0x%x ]\n",uDivMfc);  
				Disp("Not operation Clock\n\n");
			}
		}
	}
	if(uFirstFailed==0xffff)	// when the file is not in.
	{
		Disp("[%s]:File is NOT Existed !\n", aFileName);
	}
	uFailCnt += (uFirstFailed==0) ? 0 : 1;
	uTestCnt++;
}

static void TestChangeSrcClkAndDividerOnDec(void)
{
	u32 uIdx;
	u32 uStreamFileStAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	MFC_DISP_TYPE eDispType;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	char cCodecName[50];
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uErrorCnt=0;
	u32 uFileOffset;
	u32 uReadSizeUnit;
	u32 uTotalRemainSz;
	MFC_PIC_TYPE ePictype;
	u32 uCrcBufStAddr=0x24000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;	
	u32 uH264FirstErrFrameNum=0;
	u32 uRealReadSize;
	ETHERNET_FILE StreamEthernetFile;
	ETHERNET_FILE CrcFileEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CrcFileHandler;	
	u8 binterlace=false;
	u8 bNoMoreStream = false;
	u8 bPartialLoad = false;
	u8 bOneFrameStream=false;
	u8 bMustbeChecked=true;
	u8 bDispOnlyFrame=false;
	u8 bFirstSeqheader=true;
	u32 uNumOfCrc;
	u32 uPll=0;
	u32 uDivA2M=0;
	u32 uDivMfc=0;
	u8 bChangedClk=true;
	
	ebDecStandard=true;

	uFwCodeStAddr = 0x21000000;
	uStreamFileStAddr = 0x41000000;
	
#if 1
	Disp("Write down filename to test : ");
	UART_GetString(aFileName);

#else
	k = SBLK_GetRand()%8;
	switch(k)
	{
		case 0:
			strcpy(aFileName, "3210.m4v");
			break;
		case 1:
			strcpy(aFileName, "h263_test933.263");
			break;
		case 2:
			strcpy(aFileName, "mpeg2_test647.es");
			break;
		case 3:
			strcpy(aFileName, "vc1_test437.vc1");
			break;
		case 4:
			strcpy(aFileName, "25_HCAMFF1_HHI.264");
			break;
		case 5:
			strcpy(aFileName, "5121.dvx4");
			break;
		case 6:
			strcpy(aFileName, "4031.dvx");
			break;
		case 7:
			strcpy(aFileName, "vc1_test1252.rcv");
			break;
		default:
			Assert(0);
			break;
	}
#endif

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_Open(aFileName, &StreamHandler)!=0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
	
		FS_GetFileNameExt(aFileName, cFileExt);

		uStreamFileSize=StreamHandler.nSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		// 2. REF CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		if(bFirstConformance == true)
		{
			if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
				return;
			if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
			{
				Disp("F/W Read Fail\n");
				return;
			}
		}
	}
	else // ethernet mode
	{
		// 1. Stream load
		if(eStandard == H263_DEC)
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\H263\\Stream\\",aFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\VC1\\Stream\\all_stream\\",aFileName);

		StreamEthernetFile = EFT_RequestFileInfo(aStreamFilePath);
		if(StreamEthernetFile.fileID==-1 || StreamEthernetFile.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEthernetFile.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEthernetFile, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		
		// 2. Ref CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 16);

		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 

		if(eStandard == H263_DEC)
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\H263\\RefCrc\\",aCrcFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\VC1\\RefCrc\\",aCrcFileName);		
			
		CrcFileEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcFileEftInfo.fileID==-1 || CrcFileEftInfo.fileSize==0)
		{
			Disp("CRC File Open Fail\n");
			return;
		}
		EFT_ReadFile(&CrcFileEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcFileEftInfo.fileSize; 
		uDramBBaseAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	if(MFC_GetCodecType(cFileExt, &eStandard)==false)
		return;
	DispCodecName(eStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	uRemainSz  = uReadSizeUnit;

	uRet = VsParser(eStandard, uStreamFileStAddr, uRemainSz,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);

	bIsFirstFrame = true;	

	if((uRet==1) && (bPartialLoad==false))
	{
		uOneFrameSz = uStreamFileSize;
		bNoMoreStream = true;
		bOneFrameStream = true;
	}
	else if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;

	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;	
	uCurCrcBufStAddr = uCrcBufStAddr;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bChangedClk == true)
		{
			if(bIsFirstFrame==true )	
			{
				bIsFirstFrame = false;
				if(eStandard == H263_DEC)
				{
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
				}
				else
				{
					continue;
				}
			}
			else if(bNoMoreStream==true)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
			}
			else if((eStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				uOneFrameSz = 0;
				uRet = VsParser(eStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
				//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);
							
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = uOneFrameAddr+uOneFrameSz;
					if(eStandard==VC1RCV_DEC)	
						uRemainSz -= uOneFrameSz+4;
					else
						uRemainSz -= uOneFrameSz;
					Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
					MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
				}
				else if((uRet==1)||(uRet==2))
				{
					if(uTotalRemainSz && bPartialLoad)
					{
						uTotalRemainSz += uRemainSz;
						if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
						{
							uFileOffset -= uRemainSz;
							uReadSizeUnit = STREAM_FILE_BUF_SIZE;
						}
						else
						{
							uFileOffset-= uRemainSz;
							uReadSizeUnit = uTotalRemainSz;
						}
						if(bSdLoadMode)
						{
							if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
							{
								Disp("Seek Fail\n");
								return;
							}
				
							if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
							{
								Disp("Stream Read Fail\n");
								return;
							}
							uFileOffset = StreamHandler.nOffset;
						}
						else
						{
							EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
							uFileOffset += uReadSizeUnit;
						}
						uTotalRemainSz = uStreamFileSize-uFileOffset;
						uRdPtr = uStreamFileStAddr;
						uRemainSz = uReadSizeUnit;	
						continue;
					}

					if((eStandard!=H264_DEC))
						break; // last frame decoding skip
					Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
					MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
					bNoMoreStream=true;
					bMustbeChecked = false;
				}
				else
					Assert(0);
			}

			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsDecodingFinished() || ((bMustbeChecked==false) && bOneFrameStream))	// Because One frame stream
				break;

			MFC_GetDispType(&eDispType);
			
			if(eDispType==DISP_ONLY)
				bDispOnlyFrame=true;
			else 
				bDispOnlyFrame=false;

			if((eStandard!=H264_DEC)&&(!bNoMoreStream))
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}
			
			if((eStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
			{
				uFrameCnt++;
				Disp("[%d] ",uFrameCnt);
			}
			
			MFC_GetPictureType(&ePictype, &binterlace);
			if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
			{			
				if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
				{
					Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
					uErrorCnt++;
				}
				else
				{
					Disp(".", uFrameCnt);
				}
				if(uNumOfCrc==2)
				{
					if(bSaveResult)
						Copy8(0xf1702030, uCurCrcBufStAddr, 8);
					uCurCrcBufStAddr+=8;
					uRefCrcBufAddr+=8;
				}
				else // uNumOfCrc==4
				{
					if(bSaveResult)
						Copy8(0xf1702030, uCurCrcBufStAddr, 16);
					uCurCrcBufStAddr+=16;
					uRefCrcBufAddr+=16;
				}
				if(uRefCrcFileSize == (uCurCrcBufStAddr-uCrcBufStAddr))
					break;
			}
		}

		// source clk change & clk divider
		if(uPll<4)
		{
			if(uPll==0)
			{
				if(uDivA2M<8)
				{
					if(uDivMfc<16)
					{
						Disp("\n\n[ Pll:%d, DivA2M:%d, DivMfc:%d ]\n", uPll, uDivA2M, uDivMfc);
						SetSrcClkAndClkDivider(uPll, uDivA2M, uDivMfc, &bChangedClk);
						uDivMfc++;
					}
					else
					{
						uDivA2M++;
						uDivMfc=0;
					}
				}
				else
				{
					uPll++;
					uDivMfc=0;
				}
			}
			else // ((uPll>=1) && (uPll<=4))
			{
				if(uDivMfc <16)
				{
					Disp("\n\n[ Pll:%d, DivA2M:%d, DivMfc:%d ]\n", uPll, uDivA2M, uDivMfc);
					SetSrcClkAndClkDivider(uPll, uDivA2M, uDivMfc, &bChangedClk);
					uDivMfc++;
				}
				else
				{
					uPll++;
					uDivMfc=0;
				}
			}
		}
		
		if(bOneFrameStream)
			bMustbeChecked = false;
		if(uErrorCnt>5) break;
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);

	if(eStandard != H264_DEC)	
		uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;
	else
		uTotCrcSize = uRefCrcFileSize;
	
	if(uRefCrcFileSize>=uTotCrcSize)
	{
		if(eStandard==VC1AP_DEC)
		{
			if( (uRefCrcFileSize-uTotCrcSize)>16 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
		else
		{
			if( (uRefCrcFileSize-uTotCrcSize)>8 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
	}

	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}
}

static void TestChangeSrcClkAndDividerOnEnc(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameCount=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	char aCfgFilePath[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler GoldenStreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE GoldenStreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u32 uPll=0;
	u32 uDivA2M=5;
	u32 uDivMfc=0;
	u8 bChangedClk=true;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;

	Disp("Set Initial DivA2M value:");
	uDivA2M = UART_GetIntNum();
	
	Disp("Set Initial DivMfc value:");
	uDivMfc = UART_GetIntNum();
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	
	uFwCodeStAddr = 0x21000000;
	uDramBBaseAddr = 0x41000000;

	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
 
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);
 
	uFreeMemBuf = uDramBBaseAddr;

#if 1
	MFC_SelectEncStandard(0, &eEncStandard);
#else
	// aFileName : Cfg File Name
	eEncStandard = (strcmp(aFileName,"fpga_rc_Whale_30_cfg000x.cfg")==0) ? H263_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg000x.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"fpga_city_720p_cfg084x.cfg")==0) ? MPEG4_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg000x.cfg")==0) ? H264_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg456x.cfg")==0) ? H264_ENC :
					(strcmp(aFileName,"rand00_sunflower_cfg971x.cfg")==0) ? H264_ENC :  Assert(0);

	MFC_SetCodecStandard(0, eEncStandard);						
#endif


	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
		
		strcpy(aStreamFileName, aCfgFileName);
		uIdx = strlen(aCfgFileName);
	}
	else
	{
		if(!bConformanceTestAll)
		{
			Disp("Write config filename to test : ");
			UART_GetString((s8 *)aCfgFileName);
		}

		//sprintf(aCfgFilePath, "%s%s","E:\\MFC\\v210 MFC\\SampleStream\\enc\\mpeg4\\",aCfgFileName);
		sprintf(aCfgFilePath, "%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\encsamplestream\\",aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFilePath);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
		
		strcpy(aStreamFileName, aCfgFilePath);
		uIdx = strlen(aCfgFilePath);
	}

	// Load a golden stream file
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	switch(eEncStandard)
	{
		case H263_ENC:
			strcpy(&aStreamFileName[uIdx+1], "263");
			break;
		case MPEG4_ENC:
			strcpy(&aStreamFileName[uIdx+1], "bits");
			break;
		case H264_ENC:
			strcpy(&aStreamFileName[uIdx+1], "264");
			break;
		default:
			Disp("Wrong Format!!!\n");
	}
	//Disp("Golden Stream File Name is %s\n", aStreamFileName);
	
 	uFreeMemBuf = Align(uFreeMemBuf, 16);
	
	uGoldenStreamBufAddr = uFreeMemBuf;
	uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
	
	if(bSdLoadMode)
	{	
		if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
		{
			Disp("Golden Stream Read Fail\n");
			return;
		}
		uGoldenStreamSize = GoldenStreamHandler.nSize;
		uFreeMemBuf += uGoldenStreamSize;
	}
	else
	{
		GoldenStreamInfo = EFT_RequestFileInfo(aStreamFileName);
		if(GoldenStreamInfo.fileID==-1 || GoldenStreamInfo.fileSize==0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		EFT_ReadFile(&GoldenStreamInfo, (u32 *)(uGoldenStreamBufAddr));
		uGoldenStreamSize = GoldenStreamInfo.fileSize;
		uFreeMemBuf += uGoldenStreamSize;
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);		

	// Set Buffer Address for Encoding 
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024); 
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB; 
		
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(bSdLoadMode)
	{
		if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	else
	{
		YuvEftInfo = EFT_RequestFileInfo(aYuvFileName);
		if(YuvEftInfo.fileID==-1 || YuvEftInfo.fileSize==0)
		{
			Disp("Yuv Open Fail\n");
			return;
		}
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	//Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	//Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;

	uFrameCount = 0;
	uValidFrmCnt = 0;	
	while (GetKey() == 0)
	{
		if(bChangedClk == true)
		{
			//Load one frame to the temporary buffer
			if(uFrameCount <= uNumOfTotFrames-1)
			{	
				if(bSdLoadMode)
				{
					if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
					{
						Disp("Seek Fail\n");
						return;
					}
					if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
					{
						Disp("Stream Read Fail\n");
						return;
					}
				}
				else
				{
					EFT_ReadFilePartial(&YuvEftInfo, (u32 *)uSrcYuvAddr, uFrameCount*uSrcYuvFrameSizeInBytes, uSrcYuvFrameSizeInBytes);
				}
			}

			// If necessary, convert non-NV12 to NV12
			MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
			Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
			MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
			if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
			{
				FIMC_InitIpForDinDout(FIMC_A,
					uWidth, uHeight, 0,
					0, 0, uWidth, uHeight,
					uSrcYuvAddr, YC420,
					uWidth, uHeight,
					0, 0, uWidth, uHeight, 0, // Scaler	
					uSrcNv12YAddr, NV12,		
					ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
			}
			else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
			{
				FIMC_InitIpForDinDout(FIMC_A,
					uWidth, uHeight, 0,
					0, 0, uWidth, uHeight,
					uSrcYuvAddr, YC420,
					uWidth, uHeight,
					0, 0, uWidth, uHeight, 0, // Scaler		
					uSrcNv12YAddr, TILE_NV12,		
					ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
			}

			FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
			uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
			uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
			bProcessingDoneA = false;
			FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
			while(!bProcessingDoneA);		
			FIMC_StopProcessing(FIMC_A);
#endif
			// Encode a frame
			if(bLastOrNoMoreYC == false)
				eCmdType = FRAME;
			else
				eCmdType = LAST_SEQ;

			MFC_EncodingOneFrame(eCmdType);

			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nENC : [%d]\t ", uValidFrmCnt); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				uValidFrmCnt++;
				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////

				// Read a stream from stream buffer
				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
			
			if (uIsInterlace == 1)
			{
				MFC_EncodingOneFrame(eCmdType);
				if(!MFC_WaitForFrameDone())
				{
					Disp("[ERR]\n");
					//break;
				}
			
				if(MFC_IsEncodingFinished()==true)
					break;			

				MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

				if(uEncStrSzPerFrame != 0)
				{
					Disp("\nBottom\t "); 
					Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
					MFC_GetFrameType(&cFrameType);
					Disp("Frame Type : %s\n",  cFrameType);
					///////////////////////////////////////////////////////////////////////////////////////////
					// compare per frame.
					MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
					if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
					{
						Disp("[.]\n");
					}
					else
					{
						Disp("Diff\n");
						uErrCnt++;
					}
					uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
					///////////////////////////////////////////////////////////////////////////////////////////

					MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
					uStreamBufOffset += uEncStrSzPerFrame;
				}
			}
			
			uFrameCount++;
			
			if(uFrameCount == uNumOfTotFrames-1)
				bLastOrNoMoreYC = true;	
		}
		
		// source clk change & clk divider
		if(uPll<4)
		{
			if(uPll==0)
			{
				if(uDivA2M<8)
				{
					if(uDivMfc<16)
					{
						Disp("\n\n[ Pll:%d, DivA2M:%d, DivMfc:%d ]\n", uPll, uDivA2M, uDivMfc);
						SetSrcClkAndClkDivider(uPll, uDivA2M, uDivMfc, &bChangedClk);
						uDivMfc++;
					}
					else
					{
						uDivA2M++;
						uDivMfc=0;
					}
				}
				else
				{
					uPll++;
					uDivMfc=0;
				}
			}
			else // ((uPll>=1) && (uPll<=4))
			{
				if(uDivMfc <16)
				{
					Disp("\n\n[ Pll:%d, DivA2M:%d, DivMfc:%d ]\n", uPll, uDivA2M, uDivMfc);
					SetSrcClkAndClkDivider(uPll, uDivA2M, uDivMfc, &bChangedClk);
					uDivMfc++;
				}
				else
				{
					uPll++;
					uDivMfc=0;
				}
			}
		}		
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
	
	if(uErrCnt==0)
	{
		Disp("\n########## Encoding Pass ##########\n");
		uFirstFailed=  0;
	}
	else
	{
		Disp("\n########## Encoding Fail ##########\n");
		uFirstFailed=  uErrCnt;
	}
}

static void TestDecPerfForScenario1(void)
{
	u32 i, uIdx;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	char aFileName[MAX_FILENAME_SIZE];
	char pFileName[MAX_FILENAME_SIZE];
	char aFrameListName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uOneFrameAddrOffset;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u8 bIsRcv;
	u8 bIsFirstFrame=true;
	u32 uPicHsz, uPicVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uFrameHsz, uFrameVsz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uNumOfFrmList;
	u32 uStreamFileStAddr;
	u32 uFrameListEndAddr;
	u32 uFrameListAddr;
	u32 uFrmIndex=0;
	FRAME_INFO *pFrameInfoTable;
	u8 bMp4DeblkEn = false;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE FrameListEftInfo;
	t_file_handler FwHandler;
	t_file_handler StreamHandler;
	t_file_handler FrameListHandler;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame=false;
	u8 bNoMoreStream=false;
	u32 uRealReadSize;
	MFC_DISP_TYPE eDispType;
	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u32 uDispFrameCnt=0;
	u32 uOneDecMaxElapaedTime=0;
	u32 uOneDecMaxElaspedFrame=0;
	u32 uBurstTransSize;
	u32 uFrameCount=0;

	ebDecStandard=true;
	uLcdcUnderRunCnt=0;
	
	uStreamFileStAddr = 0x41000000;
	uFreeMemBuf=uStreamFileStAddr;
	uFwCodeStAddr = 0x20000000;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize; //file size
		uFreeMemBuf += uStreamFileSize;
	}
	else
	{	
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);
		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Invalid file name.\n");
			return;
		}
		EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
		uStreamFileSize = StreamEftInfo.fileSize; //file size
		uFreeMemBuf += uStreamFileSize;
		EFT_GetFileNameExt(aFileName, cFileExt);
	}
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	bIsFirstFrame = true;

	uFrameListAddr = Align(uFreeMemBuf, 16);

	strcpy(pFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (pFileName[--uIdx] == '.')
			break;
	}
	strcpy(&pFileName[uIdx+1], "Info"); 

	if(bSdLoadMode)
	{
		if(FS_Open(pFileName, &FrameListHandler)!=0)
			return;
		if(FS_Read(&FrameListHandler, FrameListHandler.nSize, (u32 *)uFrameListAddr, &uRealReadSize) !=0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		uNumOfFrmList = FrameListHandler.nSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListHandler.nSize;
	}
	else
	{	
		sprintf(aFrameListName,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\", pFileName);

		FrameListEftInfo = EFT_RequestFileInfo(aFrameListName);
		if(FrameListEftInfo.fileID==-1 || FrameListEftInfo.fileSize==0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		EFT_ReadFile(&FrameListEftInfo, (u32 *)(uFrameListAddr));
		uNumOfFrmList = FrameListEftInfo.fileSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListEftInfo.fileSize;
	}

	uDramBBaseAddr = Align(uFrameListEndAddr, 128*1024);

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)(uFwCodeStAddr));
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	INTC_Enable(NUM_LCD0);	

	DispCodecName(eDecStandard);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	pFrameInfoTable = (FRAME_INFO*)uFrameListAddr;
	uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
	uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
	uFrmIndex++;

	Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr,  uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

#if 1	// MFC Stand Alone Test
	if(bFimcDinDout==false)
	{		
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, 480, 358, 0, 0);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_SetWinOnOff(1, WIN0);
		//LCDC_Start();
#if 0
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,				// 800x480 ROT90 
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange);
#else
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,				// 480X358 
			480, 358, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
#endif
		Disp("FIMC DMA in FIFO out\n");
	}
	else
	{
		uFreeMemBufB = Align(uFreeMemBufB, 0xe00000);
		uLcdFbAddr=uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_GetFbEndAddr(&uFreeMemBufB, WIN0);
		//LCDC_Start();

		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdVSz, uLcdHSz, 0,		// Output ROT 90
			uLcdFbAddr, eBpp,		
			ROT_90_FLIP_NO, eCscEquation, eYCbCrRange, false);
		Disp("FIMC DMA in DMA out\n");

		#if 0
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,	// ROT 90
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		// 480x358
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, 480, 358, 0,		// 480x358 ROT_NO
			uFreeMemBufA, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		#endif	
	}
#endif	// MFC Stand Alone Test

#if 1
	uFreeMemBufB=Align(uFreeMemBufB, 0xe00000);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN1, false);	
	LCDC_SetWinOnOff(1, WIN1);
	
	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN1);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN2, false);	
	LCDC_SetWinOnOff(1, WIN2);
	
	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN2);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN3, false);	
	LCDC_SetWinOnOff(1, WIN3);

	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN3);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN4, false);	
	LCDC_SetWinOnOff(1, WIN4);

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN1);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN2);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN3);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN4);
#endif

	/////////////////////////// Temporary
	if(bFimcDinDout==false)
	{
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, 0x44000000, 0x23000000);
		FIMC_StartProcessingForMfc(FIMC_A);
		LCDC_Start();
	}
	else
	{
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, 0x44000000, 0x23000000);
		FIMC_StartProcessingForMfc(FIMC_A);
		while(!bProcessingDoneA);
		FIMC_StopProcessing(FIMC_A);
		LCDC_Start();
	}
	/////////////////////////// Temporary	
		
	uFrameCount= 0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				StartTimer(0);
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(uFrmIndex==uNumOfFrmList)
		{
			StartTimer(0);
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			StartTimer(0);
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
			uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
			//Disp("OneFrameAddrOffset : 0x%x\t", uOneFrameAddrOffset);
			//StartTimer(0);

			Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr, uOneFrameSz);
			StartTimer(0);
			if(uFrmIndex==uNumOfFrmList-1)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream = true;
			}
			else
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}

			uFrmIndex++;
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}

		if(bDispOnlyFrame==false)
		{
			uElapsedTime=StopTimer(0);
			Disp("[%d] : Elasped Time: %d\n", uFrameCount,uElapsedTime);
			//uTotElapsedTime += uElapsedTime;
		}

		if(MFC_IsDecodingFinished())
			break;
	
		if(uFrmIndex!=uNumOfFrmList)
		{
			uFrameCount++;
			//Disp("[%d]\n",uFrameCount);
		}
		MFC_GetDispType(&eDispType);
	
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;	
	
		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;

		uDispFrameCnt++;

		bProcessingDoneA = false;
		if(bFimcDinDout==false)
		{
			FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			if(bFirstFimcFifoOut==true)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
				LCDC_Start();
			}
		}
		else
		{
			FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);
			FIMC_StopProcessing(FIMC_A);
			LCDC_Start();
		}
	}

	//uElapsedTime=StopTimer(0);
	//uTotElapsedTime += uElapsedTime;

	if(eDecStandard == H264_DEC)
		uFrameCount=uDispFrameCnt;
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);

	Disp("Decoding Done All Frame!!!\n");
	Disp("LCD Under Run  Count : %d\n", uLcdcUnderRunCnt);
	Disp("One Den Max Elapsed Time : %d\n", uOneDecMaxElapaedTime);
	Disp("One Den Max Elapsed Frame Number : %d\n", uOneDecMaxElaspedFrame);
	Disp("Total Frame Count : %d\n", uFrameCount);
	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uFrameCount*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));
}

// 1. MFC - MEM - FIMC(Ch A) - FIMD
// 2. MEM - FIMD(W1~W4) - FIMC(Ch C) - MEM  :  [DIRECT-FIFO-in DMA-out]
static void TestDecPerfForScenario2(void)
{
	u32 i, uIdx;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	char aFileName[MAX_FILENAME_SIZE];
	char pFileName[MAX_FILENAME_SIZE];
	char aFrameListName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uOneFrameAddrOffset;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u8 bIsRcv;
	u32 uFrameCount;
	u8 bIsFirstFrame=true;
	u32 uPicHsz, uPicVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uFrameHsz, uFrameVsz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uNumOfFrmList;
	u32 uStreamFileStAddr;
	u32 uFrameListEndAddr;
	u32 uFrameListAddr;
	u32 uFrmIndex=0;
	FRAME_INFO *pFrameInfoTable;
	u8 bMp4DeblkEn = false;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE FrameListEftInfo;
	t_file_handler FwHandler;
	t_file_handler StreamHandler;
	t_file_handler FrameListHandler;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame=false;
	u8 bNoMoreStream=false;
	u32 uRealReadSize;
	MFC_DISP_TYPE eDispType;
	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u32 uDispFrameCnt=0;
	u32 uOneDecMaxElapaedTime=0;
	u32 uOneDecMaxElaspedFrame=0;
	u32 uBurstTransSize;

	ebDecStandard=true;
	uLcdcUnderRunCnt=0;
	
	uStreamFileStAddr = 0x41000000;
	uFreeMemBuf=uStreamFileStAddr;
	uFwCodeStAddr = 0x20000000;

	if(bSdLoadMode)
	{
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		if(FS_Read(&StreamHandler, StreamHandler.nSize, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize; //file size
		uFreeMemBuf += uStreamFileSize;
	}
	else
	{	
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		StreamEftInfo = EFT_RequestFileInfo(aFileName);
		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Invalid file name.\n");
			return;
		}
		EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
		uStreamFileSize = StreamEftInfo.fileSize; //file size
		uFreeMemBuf += uStreamFileSize;
		EFT_GetFileNameExt(aFileName, cFileExt);
	}
	
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	bIsFirstFrame = true;

	uFrameListAddr = Align(uFreeMemBuf, 16);

	strcpy(pFileName, aFileName);
	uIdx = strlen(aFileName);
	while (1)
	{
		if (pFileName[--uIdx] == '.')
			break;
	}
	strcpy(&pFileName[uIdx+1], "Info"); 

	if(bSdLoadMode)
	{
		if(FS_Open(pFileName, &FrameListHandler)!=0)
			return;
		if(FS_Read(&FrameListHandler, FrameListHandler.nSize, (u32 *)uFrameListAddr, &uRealReadSize) !=0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		uNumOfFrmList = FrameListHandler.nSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListHandler.nSize;
	}
	else
	{	
		sprintf(aFrameListName,"%s%s","E:\\CCV\\SA2\\SW\\K-FileServer\\", pFileName);

		FrameListEftInfo = EFT_RequestFileInfo(aFrameListName);
		if(FrameListEftInfo.fileID==-1 || FrameListEftInfo.fileSize==0)
		{
			Disp("Framelist Read Fail\n");
			return;
		}
		EFT_ReadFile(&FrameListEftInfo, (u32 *)(uFrameListAddr));
		uNumOfFrmList = FrameListEftInfo.fileSize/8;
		uFrameListEndAddr = uFrameListAddr+FrameListEftInfo.fileSize;
	}

	uDramBBaseAddr = Align(uFrameListEndAddr, 128*1024);

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)(uFwCodeStAddr));
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	INTC_Enable(NUM_LCD0);	

	DispCodecName(eDecStandard);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	  uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	pFrameInfoTable = (FRAME_INFO*)uFrameListAddr;
	uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
	uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
	uFrmIndex++;

	Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr,  uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

// 1. MFC - MEM - FIMC(Ch A) - FIMD
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_InitWinForFifoIn3(IN_POST, WIN0, 480, 358, 0, 0);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_SetWinOnOff(1, WIN0);
	//LCDC_Start();
	FIMC_InitIpForDinFout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		NULL, TILE_NV12, false,				// 480X358 
		480, 358, LOCAL_IF_RGB24, PROGRESSIVE,
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, 0x44000000, 0x23000000);
	FIMC_StartProcessingForMfc(FIMC_A);
	Disp("FIMC DMA in FIFO out\n");

// 2. MEM - FIMD(W1~W4) - FIMC(Ch C) - MEM  :  [DIRECT-FIFO-in DMA-out]
	uFreeMemBufB=Align(uFreeMemBufB, 0xe00000);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN1, false);	
	LCDC_SetWinOnOff(1, WIN1);
	
	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN1);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN2, false);	
	LCDC_SetWinOnOff(1, WIN2);
	
	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN2);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN3, false);	
	LCDC_SetWinOnOff(1, WIN3);

	LCDC_GetFbEndAddr(&uFreeMemBufB, WIN3);
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN4, false);	
	LCDC_SetWinOnOff(1, WIN4);

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN1);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN2);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN3);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN4);

	LCDC_SetOutputPath(LCD_TVRGB);
	
#if 0
	FIMC_InitIpForDFinDout(FIMC_C,
		uLcdHSz, uLcdVSz,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdVSz, 0,
		0x44000000, 0x44000000, RGB24,
		ROT_90_FLIP_NO, eCscEquation, eYCbCrRange);
#else // ROT90
	FIMC_InitIpForDFinDout(FIMC_C,
		uLcdHSz, uLcdVSz,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdHSz, 0,
		0x44000000, 0x44000000, RGB24,
		ROT_90_FLIP_NO, eCscEquation, eYCbCrRange);
#endif

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);

	LCDC_Start();

	uFrameCount= 0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;
			if(eDecStandard == H263_DEC)
			{
				StartTimer(0);
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(uFrmIndex==uNumOfFrmList)
		{
			StartTimer(0);
			MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			StartTimer(0);
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameAddrOffset = pFrameInfoTable[uFrmIndex].uFrameOffset;
			uOneFrameSz = pFrameInfoTable[uFrmIndex].uFrameSize;
			//Disp("OneFrameAddrOffset : 0x%x\t", uOneFrameAddrOffset);
			//StartTimer(0);

			Copy8(uStreamFileStAddr+uOneFrameAddrOffset, uCpbBufStAddr, uOneFrameSz);
			StartTimer(0);
			if(uFrmIndex==uNumOfFrmList-1)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream = true;
			}
			else
			{
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}

			uFrmIndex++;
		}
		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}

		if(bDispOnlyFrame==false)
		{
			uElapsedTime=StopTimer(0);
			Disp("[%d] : Elasped Time: %d\n", uFrameCount,uElapsedTime);
			//uTotElapsedTime += uElapsedTime;
		}

		if(MFC_IsDecodingFinished())
			break;
	
		if(uFrmIndex!=uNumOfFrmList)
		{
			uFrameCount++;
			//Disp("[%d]\n",uFrameCount);
		}
		MFC_GetDispType(&eDispType);
	
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;	
	
		if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		uDispFrameCnt++;
		
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
	}

	//uElapsedTime=StopTimer(0);
	//uTotElapsedTime += uElapsedTime;

	if(eDecStandard == H264_DEC)
		uFrameCount=uDispFrameCnt;

	Disp("LCD Under Run  Count : %d\n", uLcdcUnderRunCnt);

	FIMC_PreProcessForLastFrmCpt(FIMC_A);
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);

	Disp("Decoding Done All Frame!!!\n");
	Disp("LCD Under Run  Count : %d\n", uLcdcUnderRunCnt);
	Disp("One Den Max Elapsed Time : %d\n", uOneDecMaxElapaedTime);
	Disp("One Den Max Elapsed Frame Number : %d\n", uOneDecMaxElaspedFrame);
	Disp("Total Frame Count : %d\n", uFrameCount);
	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uFrameCount*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));
}


// MIPI - FIMC_A - MEM1(NV12) - FIMC_B - FIMD(FIFO I/F, 480x800 60Hz) & MEM0 - FIMD(WVGA WIN 0,2,3,4 60Hz)
static void TestEncPerfForScenario3(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uValidFrmCnt=0;
	u32 uFrameCount=0;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	//char aConfigFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	t_file_handler GoldenStreamHandler;
	ETHERNET_FILE StreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE GoldenStreamInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u32 uElapsedTime=0;
	u32 uTotElapsedTime=0;
	u32 uLcdHSz,uLcdVSz;
	// csi
	CSIS_DATA_LANE_NUM eCSISDataLaneNum;
	CSIS_INTV_SETTING eCSISIntvSetting;
	MIPI_DATA_ALIGN eDataAlign;
	IMG_FMT eFinImgType;
	IMG_RESOLUTION eInSize;
	u8 eHSsettle;
	u32 uFinImgHsz, uFinImgVsz;
	u32 uLcdFbAddr;
	// hdmi
	u32 uMxWin0Addr, uMxWin1Addr;
	u32 uMxWin0HSize=960, uMxWin0VSize=1080, uMxWin1HSize=960, uMxWin1VSize=1080;
	u32 uMxWin0On=1, uMxWin1On=0;
	SCAN_MODE eTVScanMode;
	u32 uDisplayAddrOfVP;
	u32 uMxGraphicWinOn;
	
	uVpUnderRunCnt = 0;
	uMixer0UnderRunCnt = 0;
	uLcdcUnderRunCnt = 0;
	uMixer1UnderRunCnt = 0;
	
	uMxGraphicWinOn = (1<<MX_WIN1) | (1<<MX_WIN0);
	uLcdcUnderRunCnt = 0;
	eTVScanMode = PROGRESSIVE;
	eCSISIntvSetting.CSIS_INTV_Lintv=0x0;
	eCSISIntvSetting.CSIS_INTV_Sintv=0x0;
	eCSISIntvSetting.CSIS_INTV_Eintv=0x0;
	eDataAlign = MIPI_32BIT_ALIGN;
	eFinImgType = CBYCRY;
	//eInSize = USER_DEFINE_SIZE; 
	eInSize = HD1080; 
	eHSsettle = 12;	
	eCSISDataLaneNum = DATALANE2;

	uFreeMemBufA = 0x20000000;
	uFreeMemBufB = 0x41000000;

	SYSC_InitClkForMM();
	InitBaseHwForI2C();
	InitBaseHwForFIMC();
	InitBaseHwForCSIS();

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	INTC_SetVectAddr(NUM_FIMC_B, Isr_FimcBDone);
	INTC_Enable(NUM_FIMC_B);
	INTC_SetVectAddr(NUM_FIMC_C, Isr_FimcCDone);
	INTC_Enable(NUM_FIMC_C);
	INTC_SetVectAddr(NUM_MIPI_CSI, Isr_CsisIntSrc);
	INTC_Enable(NUM_MIPI_CSI);
	INTC_SetVectAddr(NUM_MIXER, Isr_Mixer);
	INTC_Enable(NUM_MIXER);

	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);

	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN0, false);	
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFbEndAddr(&uFreeMemBufA, WIN0);
	
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN2, false);	
	LCDC_SetWinOnOff(1, WIN2);
	LCDC_GetFbEndAddr(&uFreeMemBufA, WIN2);
	
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN3, false);	
	LCDC_SetWinOnOff(1, WIN3);
	LCDC_GetFbEndAddr(&uFreeMemBufA, WIN3);
	
	LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN4, false);	
	LCDC_SetWinOnOff(1, WIN4);
	LCDC_GetFbEndAddr(&uFreeMemBufA, WIN4);

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN0);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN0);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN2);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN3);
	LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN4);
		
	MIPICAM_Prepare(S5K4EAG, eFinImgType, eInSize, eCSISDataLaneNum);
	CSI_Start(eCSISDataLaneNum, eFinImgType, eInSize, eDataAlign, WCLKSRC_PCLK, &eCSISIntvSetting, eHSsettle);
	MIPICAM_Start(S5K4EAG, eFinImgType, eInSize);
	Disp("\n Sensor initialization! please wait.......... \n");

	FIMC_InitCamera(S5K4EAG, eFinImgType, eInSize);
	FIMC_GetFinImgSize(&uFinImgHsz, &uFinImgVsz);
	FIMC_InitIpForMFinDout(FIMC_A,
		0, 0, uFinImgHsz, uFinImgVsz,
		uFinImgHsz, uFinImgVsz,
		0, 0, uFinImgHsz, uFinImgVsz, 0,
		uFreeMemBufB, uFreeMemBufB, NV12,  		// CSI -> FIMC_A -> NV12 format
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, eDataAlign);
	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);

	FIMC_InitIpForDinFout(FIMC_B,
		uFinImgHsz, uFinImgVsz, 0,
		0, 0, uFinImgHsz, uFinImgVsz,
		uFreeMemBufB, NV12, false,
		uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
	
	LCDC_InitWinForFifoIn3(IN_POST, WIN1, uLcdHSz, uLcdVSz, 0, 0);
	LCDC_SetWinOnOff(1, WIN1);
	LCDC_Start();

	uFwCodeStAddr = Align(uFreeMemBufA, 128*1024);
	uFreeMemBufB = uFreeMemBufB + uFinImgHsz*uFinImgVsz*3/2;
	uDramBBaseAddr = Align(uFreeMemBufB, 128*1024);
	
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);
	MFC_SelectEncStandard(0, &eEncStandard);

	uFreeMemBuf = uDramBBaseAddr;
	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	if(bSdLoadMode)
	{
		// Load a golden stream file
		strcpy(aStreamFileName, aCfgFileName);
		uIdx = strlen(aCfgFileName);
		while (1)
		{
			if (aStreamFileName[--uIdx] == '.')
				break;
		}
		switch(eEncStandard)
		{
			case H263_ENC:
				strcpy(&aStreamFileName[uIdx+1], "263");
				break;
			case MPEG4_ENC:
				strcpy(&aStreamFileName[uIdx+1], "bits");
				break;
			case H264_ENC:
				strcpy(&aStreamFileName[uIdx+1], "264");
				break;
			default:
				Disp("Wrong Format!!!\n");
		}
		Disp("Golden Stream File Name is %s\n", aStreamFileName);
		
	 	uFreeMemBuf = Align(uFreeMemBuf, 16);
		
		uGoldenStreamBufAddr = uFreeMemBuf;
		uCurGoldenStreamBufAddr = uGoldenStreamBufAddr;
		if(FS_Open(aStreamFileName, &GoldenStreamHandler)!=0)
		{
			Disp("Golden Stream Open Fail\n");
			return;
		}
		if(FS_Read(&GoldenStreamHandler, GoldenStreamHandler.nSize, (u32 *)uGoldenStreamBufAddr, &uRealReadSize) !=0)
		{
			Disp("Golden Stream Read Fail\n");
			return;
		}
		
		uGoldenStreamSize = GoldenStreamHandler.nSize;
		uFreeMemBuf += uGoldenStreamSize;
	}
	else
	{
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();
		
	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);

	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);

	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
		
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
	uStreamBufOffset += uEncStrSzPerFrame;
	Disp("Sequence Size : 0x%x\t",  uEncStrSzPerFrame);

	///////////////////////////////////////////////////////////////////////////////////////////
	// compare per frame.
	MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
	if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
	{
		Disp("[.]\n");
	}
	else
	{
		Disp("Diff\n");
		uErrCnt++;
	}
	uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
	///////////////////////////////////////////////////////////////////////////////////////////

	uFrameCount = 0;
	uValidFrmCnt = 0;	
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);

		FIMC_InitIpForDinDout(FIMC_C,
			uWidth, uHeight, 0,
			0, 0, uWidth, uHeight,
			uSrcYuvAddr, YC420,
			uWidth, uHeight,
			0, 0, uWidth, uHeight, 0, // Scaler	
			uSrcNv12YAddr, NV12,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		
		FIMC_SetDoutDispAddrForMfc(FIMC_C, NV12,
			uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
			uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneC = false;
		FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);
		while(!bProcessingDoneC);		
		FIMC_StopProcessing(FIMC_C);
		
		// Encode a frame
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;
		
		StartTimer(0);

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		uElapsedTime=StopTimer(0);

		MFC_ReleaseCurrentYCBuf();	

		if(MFC_IsEncodingFinished()==true)
			break;			

		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uTotElapsedTime += uElapsedTime;
			Disp("\n[%d] : Elasped Time: %d", uValidFrmCnt, uElapsedTime);

			uValidFrmCnt++;

			///////////////////////////////////////////////////////////////////////////////////////////
			// compare per frame.
			MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
			if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
			{
				Disp("[.]\n");
			}
			else
			{
				Disp("Diff\n");
				uErrCnt++;
			}
			uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
			///////////////////////////////////////////////////////////////////////////////////////////

			// Read a stream from stream buffer
			MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			uStreamBufOffset += uEncStrSzPerFrame;
		}
		
		if (uIsInterlace == 1)
		{
			StartTimer(0);
			MFC_EncodingOneFrame(eCmdType);
			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}

			uElapsedTime=StopTimer(0);

			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{			
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x, %d(bit)\t",  uEncStrSzPerFrame, uEncStrSzPerFrame*8);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				uTotElapsedTime += uElapsedTime;
				Disp("\nInterlaced Elasped Time: %d",  uElapsedTime);

				///////////////////////////////////////////////////////////////////////////////////////////
				// compare per frame.
				MFC_GetEncSteamBufAddr(&uEncStreamBufAddr);
				if(CompareStreamData(uCurGoldenStreamBufAddr, uEncStreamBufAddr, uEncStrSzPerFrame))
				{
					Disp("[.]\n");
				}
				else
				{
					Disp("Diff\n");
					uErrCnt++;
				}
				uCurGoldenStreamBufAddr += uEncStrSzPerFrame;
				///////////////////////////////////////////////////////////////////////////////////////////
			
				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();
		
		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;	
	}
	// stop fimc
	FIMC_PreProcessForLastFrmCpt(FIMC_A);
	FIMC_PreProcessForLastFrmCpt(FIMC_B);
	FIMC_StopProcessing(FIMC_A);
	FIMC_StopProcessing(FIMC_B);

	// stop csi
	CSI_DisableCSI();
	MIPICAM_Disable();
	
	// Close instance
	MFC_CloseInstance(uInstanceId);

	Disp("LCDC UnderRun Cnt:%d\n", uLcdcUnderRunCnt);
	
	Disp("Total Frame Count : %d\n", uValidFrmCnt);
	Disp("Total Elasped time[ns] : %d\n", uTotElapsedTime);
	Disp("FPS:%.3f(TOTAL),	Tot Elapsed Time:%.3f[ms]\n",  (float)(uValidFrmCnt*1000000/uTotElapsedTime), (float)(uTotElapsedTime/1000));

	//Save a stream file to SD card and then unload file system
	Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
	Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

	// Enc stream
	strcpy(aStreamFileName, aCfgFileName);
	uIdx = strlen(aCfgFileName);
	while (1)
	{
		if (aStreamFileName[--uIdx] == '.')
			break;
	}
	if(eEncStandard ==H263_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.263");
	else if(eEncStandard ==H264_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.264");
	else if(eEncStandard ==MPEG4_ENC)
		strcpy(&aStreamFileName[uIdx], "_gen.m4v");
	else
		Assert(0);
	
	FS_Creat(aStreamFileName, &StreamHandler);
	FS_Write(&StreamHandler, uStreamBufOffset, (u32 *)uStreamBufStAddr, &uRealReadSize);
}

void TestPowerMode(void)
{
	u32 i, uIdx;
	u32 uStreamFileStAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	MFC_DISP_TYPE eDispType;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	char cCodecName[50];
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uErrorCnt=0;
	u32 uFileOffset;
	u32 uReadSizeUnit;
	u32 uTotalRemainSz;
	MFC_PIC_TYPE ePictype;
	u32 uCrcBufStAddr=0x24000000;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;	
	u32 uH264FirstErrFrameNum=0;
	u32 uRealReadSize;
	ETHERNET_FILE StreamEthernetFile;
	ETHERNET_FILE CrcFileEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CrcFileHandler;	
	u8 binterlace=false;
	u8 bNoMoreStream = false;
	u8 bPartialLoad = false;
	u8 bOneFrameStream=false;
	u8 bMustbeChecked=true;
	u8 bDispOnlyFrame=false;
	u8 bFirstSeqheader=true;
	u32 uNumOfCrc;

	ebDecStandard=true;

	uFwCodeStAddr = 0x21000000;
	uStreamFileStAddr = 0x41000000;

	Disp("[Stop]\n");
	DelayfrTimer(milli, rand()%1000);

	//SYSCT_TestSimplePowerMode_mfc(3);
	
	Disp("\n[Wake Up]\n");



	Disp("[Stop]\n");
	DelayfrTimer(milli, rand()%1000);

	//SYSCT_TestSimplePowerMode_mfc(3);
	
	Disp("\n[Wake Up]\n");
	
	
	if(bSdLoadMode)
	{
		// 1. Stream load 
		Disp("Write down filename to test : ");
		//UART_GetString(aFileName);

		strcpy(aFileName, "3210.m4v");

		if(FS_Open(aFileName, &StreamHandler)!=0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
	
		FS_GetFileNameExt(aFileName, cFileExt);

		uStreamFileSize=StreamHandler.nSize;

		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		// 2. REF CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 4);

		if(FS_GetFileByReplacedExt(aFileName, "crc", &CrcFileHandler)!=0)
		{
			Disp("CRC Open Fail\n");
			return;
		}
		if(FS_Read(&CrcFileHandler, CrcFileHandler.nSize, (u32 *)uRefCrcBufAddr, &uRealReadSize) !=0)
		{
			Disp("CRC Read Fail\n");
			return;
		}
		
		uRefCrcFileSize = CrcFileHandler.nSize;
		uDramBBaseAddr = Align(uRefCrcBufAddr+uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		if(bFirstConformance == true)
		{
			if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
				return;
			if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
			{
				Disp("F/W Read Fail\n");
				return;
			}
		}
	}
	else // ethernet mode
	{
		// 1. Stream load
		if(eStandard == H263_DEC)
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\H263\\Stream\\",aFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aStreamFilePath,"%s%s","E:\\dec\\VC1\\Stream\\all_stream\\",aFileName);

		StreamEthernetFile = EFT_RequestFileInfo(aStreamFilePath);
		if(StreamEthernetFile.fileID==-1 || StreamEthernetFile.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEthernetFile.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEthernetFile, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);
		
		// 2. Ref CRC load
		uRefCrcBufAddr = Align(uStreamFileStAddr+uReadSizeUnit, 16);

		strcpy(aCrcFileName, aFileName);
		uIdx = strlen(aFileName);
		while (1)
		{
			if (aCrcFileName[--uIdx] == '.')
				break;
		}
		strcpy(&aCrcFileName[uIdx+1], "crc"); 

		if(eStandard == H263_DEC)
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\H263\\RefCrc\\",aCrcFileName);
		if((eStandard == VC1AP_DEC)||(eStandard == VC1RCV_DEC))
			sprintf(aRefCrcPath,"%s%s","E:\\dec\\VC1\\RefCrc\\",aCrcFileName);		
			
		CrcFileEftInfo = EFT_RequestFileInfo(aRefCrcPath);
		if(CrcFileEftInfo.fileID==-1 || CrcFileEftInfo.fileSize==0)
		{
			Disp("CRC File Open Fail\n");
			return;
		}
		EFT_ReadFile(&CrcFileEftInfo, (u32 *)uRefCrcBufAddr);
		uRefCrcFileSize = CrcFileEftInfo.fileSize; 
		uDramBBaseAddr = Align(uRefCrcBufAddr + uRefCrcFileSize, 128*1024);
		
		// 3. FW load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	if(MFC_GetCodecType(cFileExt, &eStandard)==false)
		return;
	DispCodecName(eStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eStandard, bPixelCacheEn, false, true);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;
	uRemainSz  = uReadSizeUnit;

	uRet = VsParser(eStandard, uStreamFileStAddr, uRemainSz,	&uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	bFirstSeqheader = false;
	//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);

	bIsFirstFrame = true;	

	if((uRet==1) && (bPartialLoad==false))
	{
		uOneFrameSz = uStreamFileSize;
		bNoMoreStream = true;
		bOneFrameStream = true;
	}
	else if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}	
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eStandard==VC1RCV_DEC)	
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;

	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

	uFrameCnt = 0;	
	uCurCrcBufStAddr = uCrcBufStAddr;
	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		if(bIsFirstFrame==true )	
		{
			bIsFirstFrame = false;
			if(eStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream==true)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eStandard == H264_DEC) && (bDispOnlyFrame) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			//Disp("FrameAddr:0x%x, FrameSz : 0x%x, %d\n", uOneFrameAddr, uOneFrameSz, uOneFrameSz);
						
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eStandard==VC1RCV_DEC)	
					uRemainSz -= uOneFrameSz+4;
				else
					uRemainSz -= uOneFrameSz;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1)||(uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}
					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
			
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEthernetFile, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;	
					continue;
				}

				if((eStandard!=H264_DEC))
					break; // last frame decoding skip
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
				bNoMoreStream=true;
				bMustbeChecked = false;
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[DECODING ERR]\n");
			break;
		}
		if(MFC_IsDecodingFinished() || ((bMustbeChecked==false) && bOneFrameStream))	// Because One frame stream
			break;

		if(!bNoMoreStream)
		{
			uFrameCnt++;
			//Disp("[%d]",uFrameCnt);
		}

#if 0 
		if(uFrameCnt == 5)
		{
	//		MFC_SetSleepOrWakeUpMode(H2R_CMD_SLEEP);

			// sleep&wakeup
			DelayfrTimer(milli, rand()%1000);

			Disp("SleepMode\n");
			SYSCT_TestSimplePowerMode_mfc(5);
	//		SYSCT_TestSimplePowerMode_Temp(3); //stop
			
	//		MFC_SetSleepOrWakeUpMode(H2R_CMD_WAKEUP);
		}
#else
		if(uFrameCnt == 5)
		{
			DelayfrTimer(milli, rand()%1000);

			Disp("\n[Idle]\n");
			//SYSCT_TestSimplePowerMode_mfc(7);
			Disp("\n[Wake Up]\n");
		}
#endif

		MFC_GetPictureType(&ePictype, &binterlace);
		if(MFC_GeneratedCrcValue(&uNumOfCrc)==true && bMustbeChecked)
		{			
			if(CheckCrcDiff(eStandard, uRefCrcBufAddr, uNumOfCrc)==false)
			{
				Disp("Fail : Mismatch %d frames!!\n", uFrameCnt);
				uErrorCnt++;
			}
			else
			{
				Disp(".", uFrameCnt);
			}
			if(uNumOfCrc==2)
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 8);
				uCurCrcBufStAddr+=8;
				uRefCrcBufAddr+=8;
			}
			else // uNumOfCrc==4
			{
				if(bSaveResult)
					Copy8(0xf1702030, uCurCrcBufStAddr, 16);
				uCurCrcBufStAddr+=16;
				uRefCrcBufAddr+=16;
			}
			if(uRefCrcFileSize == (uCurCrcBufStAddr-uCrcBufStAddr))
				break;
		}

		if(bOneFrameStream)
			bMustbeChecked = false;
		if(uErrorCnt>5) break;
	}
	Disp("\n");
	MFC_CloseInstance(uInstanceId);

	if(eStandard != H264_DEC)	
		uTotCrcSize = uCurCrcBufStAddr-uCrcBufStAddr;
	else
		uTotCrcSize = uRefCrcFileSize;
	if(uRefCrcFileSize>=uTotCrcSize)
	{
		if(eStandard==VC1AP_DEC)
		{
			if( (uRefCrcFileSize-uTotCrcSize)>16 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
		else
		{
			if( (uRefCrcFileSize-uTotCrcSize)>8 )
			{
				uErrorCnt++;
				Disp("Fail\n");
			}
		}
	}

	if(uErrorCnt)
	{
		Disp("[%s]:Tot Mismatch FrameCnt:[%d]\n",aFileName, uErrorCnt);
		uFirstFailed=  uFrameCnt;
	}
	else
	{
		Disp("[%s]:[%d Tot Frame] PASS\n",aFileName, uFrameCnt);
		uFirstFailed=0;
	}

	DelayfrTimer(milli, rand()%1000);

	Disp("SleepMode\n");
	//SYSCT_TestSimplePowerMode_mfc(5);
}

static void CamPlayBack(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uLcdFbAddr;
	u32 uFreeMemBufA;
	u32 uFreeMemBufB;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u8 bDispOnlyFrame;
	u32 uLastFrameSize;
	u32 uRealReadSize;
	u8 bFirstPostProcessing=true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	u8 firstdec = true;
	u8 bFirstSeqheader=true;

	uStreamFileStAddr = uStreamBufStAddr;

	if(bSdLoadMode)
	{
		uStreamFileSize = uStreamBufOffset;
		uReadSizeUnit = uStreamFileSize;

		// 2. F/W load
		uFwCodeStAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
	}
	else //ethernet
	{
	}
	
	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	uDramBBaseAddr = 0x41000000;
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	MFC_InitProcessForDecoding(0, eStandard, true, bMp4DeblkEn, false);  // mpeg4Dec, pixel_cache disable 

	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;

	bFirstSeqheader = true;
	uRet = VsParser(eStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, false);
	Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	
	if(eStandard==VC1RCV_DEC)
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_SetCmdChNum(ONE_CH_CMD);
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

#if 0
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();

	FIMC_InitIpForDinFout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		NULL, TILE_NV12, false,
		uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);
#else
	uLcdFbAddr = uFreeMemBufB;
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_Start();
	FIMC_InitIpForDinDout(FIMC_A,
		uFrameHsz, uFrameVsz, 0,
		0, 0, uFrameHsz, uFrameVsz,
		0, TILE_NV12,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdVSz, 0,		
		uLcdFbAddr, RGB24,		
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE, false);
#endif

	LCDC_Start();
	
	uFrameCnt=0;
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{				
		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;

			if(eStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
		}
		else if(bNoMoreStream)
		{ 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, false);
			Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
			uRdPtr = uOneFrameAddr+uOneFrameSz;
			
			if(eStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				bNoMoreStream=true;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}
		
		if(MFC_IsDecodingFinished())
		{
			Disp("[DEC END]\n");
			break;
		}
		
		MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if((eStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}
		
		if((eStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
		{	
			continue;
		}
		
		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
#if 0
		if(firstdec == true)
		{
			firstdec = false;
			FIMC_StartProcessingForMfc(FIMC_A);
		}
#else
		FIMC_StartProcessingForMfc(FIMC_A);
		while(!bProcessingDoneA);			
		FIMC_StopProcessing(FIMC_A);
#endif
	}

	eCscEquation = CSC_ITU601;
	LCDC_Stop();
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");
}

static u32 CamCording(void)
{	
	u32 i, uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	u32 uStreamFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	u32 uEncStrSzPerFrame;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uWidth, uHeight;
	u32 uFrameIdx;
	char aCfgFileName[MAX_FILENAME_SIZE];
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aStreamFilePath[MAX_FILENAME_SIZE];
	char cFileExt[8];
	MFC_MB_LINEAR_TILE_MODE eLinearTileMode = MB_LINEAR_MODE;
	ETHERNET_FILE ConfigEftInfo;
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler FwHandler;
	t_file_handler ConfigHandler;
	t_file_handler StreamHandler;
	u32 uUpStreamBufAddr;
	u32 uRealReadSize;
	u32 uConfigFileSize;
	u32 uStreamFileSize;
	u32 uConfigFileNameLength;
	u32 uCamEncStreamBufSize = 0x1000000; // 16MB enc stream buf size
	SCAN_MODE eTVScanMode;
	// For camera
	u32 uFinImgHsz, uFinImgVsz;
	u32 uFPS;
	char tmp_post[12];
	char *tmppt;
	char *tmppt2;
	char keyvalue;
	u32 uDoubleBufAddr;
	u32 uElapsedTime;		
	// MIPI camera
	CSIS_DATA_LANE_NUM eCSISDataLaneNum;
	CSIS_INTV_SETTING eCSISIntvSetting;
	MIPI_DATA_ALIGN eDataAlign;
	IMG_FMT eFinImgType;
	IMG_RESOLUTION eInSize;
	u8 eHSsettle;
	u32 uRotation;
	
	eCscEquation = CSC_ITU709;
	eYCbCrRange = YCBCR_WIDE;
	eCSISIntvSetting.CSIS_INTV_Lintv=0x0;
	eCSISIntvSetting.CSIS_INTV_Sintv=0x0;
	eCSISIntvSetting.CSIS_INTV_Eintv=0x0;
	eDataAlign = MIPI_32BIT_ALIGN;
	eFinImgType = CBYCRY;
	eInSize = HD1080;
	eHSsettle = 12;	
	eCSISDataLaneNum = DATALANE2;
	
	uDisplayDevice = FIMC_DinFout;

	Disp("FIMC Rotation : 90('1'), No(other key)\n");
	uRotation = UART_GetIntNum();
	
	uFwCodeStAddr = 0x20000000;
	
	uStreamBufOffset = 0;
	uFrameCount=0;
	uEncSlowCnt = 0;

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_Init(); // Initialize interrupt controller
	INTC_SetVectAddr(NUM_MFC, Isr_MfcForEnc );
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	INTC_SetVectAddr(NUM_FIMC_B, Isr_FimcBDone);
	INTC_Enable(NUM_FIMC_B);
	INTC_SetVectAddr(NUM_FIMC_C, Isr_FimcCDone);
	INTC_Enable(NUM_FIMC_C);
	
	uDramABaseAddr = uFwCodeStAddr;
	uDramBBaseAddr = CODEC_MEM_ST;
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);	
	uFreeMemBuf = uDramBBaseAddr;
		
	// Load a config file
	if(bSdLoadMode)
	{
		Disp("\n\n==========  CONFIG FILE SELECT =========\n\n");
		if(FS_OpenFromDirlist("camconfig", &ConfigHandler, 0, true, aCfgFileName, cFileExt) != 0)
		{
			Disp("Open fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&ConfigHandler, ConfigHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = ConfigHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;

		eEncStandard = H264_ENC;		//intial vale is H264_ENC
		
		if(strncmp(aCfgFileName, "h263", 4) == 0)
			eEncStandard = H263_ENC;
		if(strncmp(aCfgFileName, "h264", 4) == 0)
			eEncStandard = H264_ENC;
		if(strncmp(aCfgFileName, "mpeg", 4) == 0)
			eEncStandard = MPEG4_ENC;

		MFC_SetCodecStandard(0, eEncStandard);
	}
	else
	{
		// Select encoding standard
		MFC_SelectEncStandard(0, &eEncStandard);


		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		ConfigEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(ConfigEftInfo.fileID==-1 || ConfigEftInfo.fileSize==0)
		{
			Disp("iCfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&ConfigEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = ConfigEftInfo.fileSize; //file size
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	eStandard = 0xffff;
	if(H264_ENC == eEncStandard)
		eStandard = H264_DEC;
	else if(H263_ENC == eEncStandard)
		eStandard = H263_DEC;
	else if(MPEG4_ENC == eEncStandard)
		eStandard = MPEG4_DEC;
	
	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

//////////////////////////////////////////////////////////////////////////////////////		
	// Initialize a mfc process
#if 0	
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
#else
	MFC_InitProcessForEncoding(0, eEncStandard, false, eLinearTileMode);
#endif

//////////////////////////////////////////////////////////////////////////////////////	


	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	
	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 64*1024);

	// Alloc Processing buffer(mem port0,1) , Stream buffer(mem port0 @encoding), Source Image(Y,C in mem port1 @encoding)
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;

	////Recon data write on at B-frame
	//Outp32(0xf170c508, 0x1);

	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	// stream copy to mem0 port (size : 16MB)
	uStreamBufStAddr = uFreeMemBufA;  
	uFreeMemBufA += uCamEncStreamBufSize;	// 16MB enc stream buf size

	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	MFC_EncodingOneFrame(SEQ_HEADER);
	
	INTC_SetVectAddr(NUM_MIPI_CSI,Isr_CsisIntSrc);
	INTC_Enable(NUM_MIPI_CSI);	


	SYSC_InitClkForMM();
	InitBaseHwForI2C();
	InitBaseHwForFIMC();
	InitBaseHwForCSIS();
	
	MIPICAM_Prepare(S5K4EAG, eFinImgType, eInSize, eCSISDataLaneNum);
	CSI_Start(eCSISDataLaneNum, eFinImgType, eInSize, eDataAlign, WCLKSRC_PCLK, &eCSISIntvSetting, eHSsettle);
	MIPICAM_Start(S5K4EAG, eFinImgType, eInSize);
	Disp("\n Sensor initialization! please wait.......... \n");

	//FIMC_SetChC(); // FIMC_C	
	FIMC_InitCamera(S5K4EAG, eFinImgType, eInSize);
	FIMC_GetFinImgSize(&uFinImgHsz, &uFinImgVsz);

#if 0
	uOutImgAddr1OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddr1OfY+uWidth * uHeight;
	uOutImgAddr1OfC = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddr1OfC+uWidth * uHeight *1/2;
	
	uOutImgAddr2OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddr2OfY+uWidth * uHeight;
	uOutImgAddr2OfC = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddr2OfC+uWidth * uHeight *1/2;
	
	uOutImgAddr3OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddr3OfY+uWidth * uHeight;
	uOutImgAddr3OfC = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddr3OfC+uWidth * uHeight *1/2;
	
	uOutImgAddr4OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddr4OfY+uWidth * uHeight;
	uOutImgAddr4OfC = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddr4OfC+uWidth * uHeight *1/2;

	uOutImgAddrOfY[0] = uOutImgAddr1OfY;
	uOutImgAddrOfY[1] = uOutImgAddr2OfY;
	uOutImgAddrOfY[2] = uOutImgAddr3OfY;
	uOutImgAddrOfY[3] = uOutImgAddr4OfY;
	uOutImgAddrOfC[0] = uOutImgAddr1OfC;
	uOutImgAddrOfC[1] = uOutImgAddr2OfC;
	uOutImgAddrOfC[2] = uOutImgAddr3OfC;
	uOutImgAddrOfC[3] = uOutImgAddr4OfC;

	uOutImgAddrOfY[4] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddrOfY[4]+uWidth * uHeight;
	uOutImgAddrOfC[4] = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddrOfC[4]+uWidth * uHeight *1/2;

	uOutImgAddrOfY[5] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddrOfY[5]+uWidth * uHeight;
	uOutImgAddrOfC[5] = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddrOfC[5]+uWidth * uHeight *1/2;

	uOutImgAddrOfY[6] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddrOfY[6]+uWidth * uHeight;
	uOutImgAddrOfC[6] = uFreeMemBufB;
	uFreeMemBufB = uOutImgAddrOfC[6]+uWidth * uHeight *1/2;

	uOutImgAddrOfY[7] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = uOutImgAddrOfY[7]+uWidth * uHeight;
	uOutImgAddrOfC[7] = uFreeMemBufB;		//Align(uFreeMemBuf, 0);
	uFreeMemBufB = uOutImgAddrOfC[7]+uWidth * uHeight *1/2;
#else

	#if 1
	uOutImgAddr1OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddr1OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr1OfC = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddr1OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr2OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddr2OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr2OfC = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddr2OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr3OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddr3OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr3OfC = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddr3OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr4OfY = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddr4OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr4OfC = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddr4OfC+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[0] = uOutImgAddr1OfY;
	uOutImgAddrOfY[1] = uOutImgAddr2OfY;
	uOutImgAddrOfY[2] = uOutImgAddr3OfY;
	uOutImgAddrOfY[3] = uOutImgAddr4OfY;
	uOutImgAddrOfC[0] = uOutImgAddr1OfC;
	uOutImgAddrOfC[1] = uOutImgAddr2OfC;
	uOutImgAddrOfC[2] = uOutImgAddr3OfC;
	uOutImgAddrOfC[3] = uOutImgAddr4OfC;

	uOutImgAddrOfY[4] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddrOfY[4]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[4] = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddrOfC[4]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[5] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddrOfY[5]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[5] = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddrOfC[5]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[6] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddrOfY[6]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[6] = uFreeMemBufB;
	uFreeMemBufB = Align(uOutImgAddrOfC[6]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[7] = Align(uFreeMemBufB, 8192);
	uFreeMemBufB = Align(uOutImgAddrOfY[7]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[7] = uFreeMemBufB;		//Align(uFreeMemBuf, 0);
	uFreeMemBufB = Align(uOutImgAddrOfC[7]+uWidth * uHeight *1/2, 0x1000);

	#else
	uOutImgAddr1OfY = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddr1OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr1OfC = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddr1OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr2OfY = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddr2OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr2OfC = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddr2OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr3OfY = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddr3OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr3OfC = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddr3OfC+uWidth * uHeight *1/2, 0x1000);
	
	uOutImgAddr4OfY = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddr4OfY+uWidth * uHeight, 0x1000);
	uOutImgAddr4OfC = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddr4OfC+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[0] = uOutImgAddr1OfY;
	uOutImgAddrOfY[1] = uOutImgAddr2OfY;
	uOutImgAddrOfY[2] = uOutImgAddr3OfY;
	uOutImgAddrOfY[3] = uOutImgAddr4OfY;
	uOutImgAddrOfC[0] = uOutImgAddr1OfC;
	uOutImgAddrOfC[1] = uOutImgAddr2OfC;
	uOutImgAddrOfC[2] = uOutImgAddr3OfC;
	uOutImgAddrOfC[3] = uOutImgAddr4OfC;

	uOutImgAddrOfY[4] = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddrOfY[4]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[4] = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddrOfC[4]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[5] = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddrOfY[5]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[5] = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddrOfC[5]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[6] = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddrOfY[6]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[6] = uFreeMemBufA;
	uFreeMemBufA = Align(uOutImgAddrOfC[6]+uWidth * uHeight *1/2, 0x1000);

	uOutImgAddrOfY[7] = Align(uFreeMemBufA, 8192);
	uFreeMemBufA = Align(uOutImgAddrOfY[7]+uWidth * uHeight, 0x1000);
	uOutImgAddrOfC[7] = uFreeMemBufA;		//Align(uFreeMemBuf, 0);
	uFreeMemBufA = Align(uOutImgAddrOfC[7]+uWidth * uHeight *1/2, 0x1000);
	#endif

#endif

	uEncAddrOfY[0] = uOutImgAddrOfY[4];
	uEncAddrOfC[0] = uOutImgAddrOfC[4];
	uEncAddrOfY[1] = uOutImgAddrOfY[5];
	uEncAddrOfC[1] = uOutImgAddrOfC[5];
	uEncAddrOfY[2] = uOutImgAddrOfY[6];
	uEncAddrOfC[2] = uOutImgAddrOfC[6];
	uEncAddrOfY[3] = uOutImgAddrOfY[7];
	uEncAddrOfC[3] = uOutImgAddrOfC[7];
	
	FIMC_InitIpForMFinDout(FIMC_C,
		0, 0, uFinImgHsz, uFinImgVsz,
		uFinImgHsz, uFinImgVsz,
		0, 0, uFinImgHsz, uFinImgVsz, 0,
		uOutImgAddr1OfY, uOutImgAddr1OfY, NV12,
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange,eDataAlign);
	
	FIMC_SetDoutDispAddrForMfc(FIMC_C, NV12,
		uOutImgAddr1OfY, uOutImgAddr2OfY, uOutImgAddr3OfY, uOutImgAddr4OfY, 
		uOutImgAddr1OfC, uOutImgAddr2OfC, uOutImgAddr3OfC, uOutImgAddr4OfC);
	
	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);
	FIMC_GetDoutFrmCnt(FIMC_C, &uFimcFrmCnt);

	switch(uFimcFrmCnt)
	{
		case 0:
			uSrcNv12YAddr = uOutImgAddr3OfY;
			uSrcNv12CAddr = uOutImgAddr3OfC;
			break;
		case 1:
			uSrcNv12YAddr = uOutImgAddr4OfY;
			uSrcNv12CAddr = uOutImgAddr4OfC;
			break;
		case 2:
			uSrcNv12YAddr = uOutImgAddr1OfY;
			uSrcNv12CAddr = uOutImgAddr1OfC;
			break;
		case 3:
			uSrcNv12YAddr = uOutImgAddr2OfY;
			uSrcNv12CAddr = uOutImgAddr2OfC;
			break;
		default:
			Assert(0);
			break;
	}
	
	if(uDisplayDevice & FIMC_DinFout) // FIMC-FIMD local I/F
	{
		LCDC_InitLdi(MAIN);
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN1, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN1);

		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
		INTC_Enable(NUM_LCD0);

		Disp("============================\n");
#if 0
		uFreeMemBufA = LCDCT_WINOn(uLcdFbAddr, uLcdHSz, uLcdVSz, (1<<WIN4)|(1<<WIN3)|(1<<WIN2));
		// uFreeMemBufA = LCDCT_WINOn(uLcdFbAddr, uLcdHSz, uLcdVSz, (1<<WIN3)|(1<<WIN2));
		// uFreeMemBufA = LCD frame buffer end address
#else
	#if 1
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN0, false);	
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_GetFbEndAddr(&uFreeMemBufA, WIN0);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN2, false);	
		LCDC_SetWinOnOff(1, WIN2);
		LCDC_GetFbEndAddr(&uFreeMemBufA, WIN2);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN3, false);	
		LCDC_SetWinOnOff(1, WIN3);
		LCDC_GetFbEndAddr(&uFreeMemBufA, WIN3);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufA, WIN4, false);	
		LCDC_SetWinOnOff(1, WIN4);
		LCDC_GetFbEndAddr(&uFreeMemBufA, WIN4);
	#else
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN0, false);	
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_GetFbEndAddr(&uFreeMemBufB, WIN0);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN2, false);	
		LCDC_SetWinOnOff(1, WIN2);
		LCDC_GetFbEndAddr(&uFreeMemBufB, WIN2);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN3, false);	
		LCDC_SetWinOnOff(1, WIN3);
		LCDC_GetFbEndAddr(&uFreeMemBufB, WIN3);

		LCDC_InitWin(RGB24, uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,	0, 0, uFreeMemBufB, WIN4, false);	
		LCDC_SetWinOnOff(1, WIN4);
		LCDC_GetFbEndAddr(&uFreeMemBufB, WIN4);
	#endif
		LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN0);
		LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
		LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
		LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
		LCDC_SetAlphaClear(ALLWIN);
		LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN0);
		LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN2);
		LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN3);
		LCDC_SetAlpha(	0, 0, 0, 0, 0, 0, WIN4);
#endif
		
		//FIMC_SetChB();	
		if(uRotation == 1)
		{
			FIMC_InitIpForDinFout(FIMC_B,
				uFinImgHsz, uFinImgVsz+8, 0,
				0, 0, uFinImgHsz, uFinImgVsz+8,
				uSrcNv12YAddr, NV12, false,
				uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
				ROT_90_FLIP_NO, CSC_ITU709, YCBCR_WIDE);	

			Disp("FIMC Rotation : 90 degree\n");
		}
		else
		{
			FIMC_InitIpForDinFout(FIMC_B,
				uFinImgHsz, uFinImgVsz+8, 0,
				0, 0, uFinImgHsz, uFinImgVsz+8,
				uSrcNv12YAddr, NV12, false,
				uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
				ROT_NO_FLIP_NO, CSC_ITU709, YCBCR_WIDE);

			Disp("FIMC Rotation : No\n");
		}
		FIMC_SetDinImgAddrForMfc(FIMC_B, NV12, uSrcNv12YAddr, uSrcNv12CAddr);	
	}
	
	if(uDisplayDevice & FIMC_DinFout)
	{	
		//FIMC_SetChB();
		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);	
		LCDC_InitWinForFifoIn3(IN_POST, WIN1, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN1);
		LCDC_Start();
	}

	INTC_SetVectAddr(NUM_TIMER0,Isr_TimerForEnc);
	INTC_Enable(NUM_TIMER0);
	MFC_GetEncFrameRate(&uFPS);
	Disp("FPS : %d\n", uFPS);

	uFimc1TotalCount = 0;
	uFimc2TotalCount = 0;
	uLcdcUnderRunCnt = 0;

	StartTimer(1);
	Disp("Preview Camera Image\n");

	while(UART_GetKey() == 0)
	{
		static u32 uFrmCnt_Temp=0xff;
		
		//FIMC_SetChC();
		FIMC_GetDoutFrmCnt(FIMC_C, &uFimcFrmCnt);

		if(uFrmCnt_Temp != uFimcFrmCnt)
		{
			uFrmCnt_Temp = uFimcFrmCnt;
			
			switch(uFimcFrmCnt)
			{
				case 0:
					uSrcNv12YAddr = uOutImgAddr3OfY;
					uSrcNv12CAddr = uOutImgAddr3OfC;
					break;
				case 1:
					uSrcNv12YAddr = uOutImgAddr4OfY;
					uSrcNv12CAddr = uOutImgAddr4OfC;
					break;
				case 2:
					uSrcNv12YAddr = uOutImgAddr1OfY;
					uSrcNv12CAddr = uOutImgAddr1OfC;
					break;
				case 3:
					uSrcNv12YAddr = uOutImgAddr2OfY;
					uSrcNv12CAddr = uOutImgAddr2OfC;
					break;
				default:
					Assert(0);
					break;
			}

			//FIMC_SetChB();
			FIMC_SetDinImgAddrForMfc(FIMC_B, NV12, uSrcNv12YAddr, uSrcNv12CAddr);	
		}
	}
	
	uElapsedTime = StopTimer(1);
	Disp("======================================\n");
	Disp("Elapsed time : %d [us]\n", uElapsedTime);
	Disp("uFimc1TotalCount : %d\n", uFimc1TotalCount);
	Disp("uFimc2TotalCount : %d\n", uFimc2TotalCount);
	Disp("uFimdUnderRun : %d\n", uLcdcUnderRunCnt);
	Disp("======================================\n");
	Disp("\n");
	Disp("\n");
	
	//FIMC_SetChC();
	uLcdcUnderRunCnt = 0;

	PWM_Select(0,(g_uPclkPsys/1000000),0,1000000 / uFPS, ((1000000 / uFPS)/2),0,0,0,1,0,1);	//timer0,prescaler=PCLK/1M,divider=1/1,autoreload
	StartTimer(1);

	Disp("[Camcording]\n");
	while (GetKey() == 0)
	{
		if (uStreamBufOffset > uCamEncStreamBufSize)
		{
			Disp("\nEncoded Stream Size is Over Allocated Buffer Size\n");
			break;
		}
	}
	uFrameCount = 0xffff0000;
	StopTimer(0);
	uElapsedTime = StopTimer(1);

	Disp("\n");	
	Disp("======================================\n");
	Disp("Elapsed time : %d [us]\n", uElapsedTime);
	Disp("uFimdUnderRun : %d\n", uLcdcUnderRunCnt);
	Disp("======================================\n");
	Disp("\n");
	Disp("Camcording End\n");
	
	while(bMfsEncDone == false);

	MFC_CloseInstance(uInstanceId);
	
	//FIMC_SetChC();
	FIMC_PreProcessForLastFrmCpt(FIMC_C);
	FIMC_StopProcessing(FIMC_C);

	CSI_DisableCSI();
	
	if(uDisplayDevice & FIMC_DinFout)
	{
		//FIMC_SetChB();
		FIMC_PreProcessForLastFrmCpt(FIMC_B);
		FIMC_StopProcessing(FIMC_B);
		LCDC_Stop();
	}
	
	Disp("Do you want review ?  (yes = y)  (no = other key)\n");
	keyvalue = UART_Getc();
	if(keyvalue == 'y' || keyvalue == 'Y')
	{
		CamPlayBack();
	}
	
	LCDC_InitGpioMux(MAIN);	
	Disp("Do you want save ?  (yes = y)  (no = other key)\n");
	keyvalue = UART_Getc();

	if(keyvalue != 'y' && keyvalue != 'Y')
	{}
	else
	{
		// save a stream file to SD card and then unload file system
		Disp("\n\nTotal Stream Size : 0x%08x(%d)\n", uStreamBufOffset, uStreamBufOffset);
		Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));

		if(1)
		{
			if(eEncStandard ==H263_ENC)
				strcpy(tmp_post, ".263");
			else if(eEncStandard ==H264_ENC)
				strcpy(tmp_post, ".264");
			else if(eEncStandard ==MPEG4_ENC)
				strcpy(tmp_post, ".m4v");
			else
				Assert(0);

			tmppt = strrchr(aCfgFileName, '.');

			if(tmppt != NULL)
				*tmppt = '\0';

			tmppt2 = strchr(aCfgFileName, '/') + 1;
			
			uIdx = 0;
			while(1)
			{
				// Enc stream
				if(bSdLoadMode)
				{
					sprintf(aStreamFileName, "mfc/%s_%03d%s", tmppt2, uIdx, tmp_post);
				}
				else
				{
					sprintf(aStreamFileName, "mfc\\%s_%03d%s", tmppt2, uIdx, tmp_post);
				}

				if(0 != FS_Open(aStreamFileName, &StreamHandler))
					break;
				uIdx++;
			}
			
			Disp("Enc Stream file name : %s\n",aStreamFileName);
			Disp("Enc Stream Size : 0x%08x\n", uStreamBufOffset);
			Disp("Stream : 0x%08x ~ 0x%08x\n", uStreamBufStAddr, (uStreamBufStAddr+uStreamBufOffset-1));
			
			if(bSdLoadMode)
			{
				if(0 != FS_Creat(aStreamFileName, &StreamHandler))
				{
					Disp("FS_Creat Fail\n");
					return 1;
				}
				if(0 != FS_Write(&StreamHandler, uStreamBufOffset, (u32 *)uStreamBufStAddr, &uRealReadSize))
				{
					Disp("FS_Write Fail\n");
					return 1;
				}
			}
			else
			{
				sprintf(aStreamFilePath,"%s%s","F:\\MFC_Result\\Result\\",aStreamFileName);
				StreamEftInfo=EFT_RequestCreateFileInfo(aStreamFilePath);
				EFT_WriteFile(&StreamEftInfo, (u32 *)uStreamBufStAddr, uStreamBufOffset);
			}
		}
	}
	return 0;
}

// for two instance decoding, add third instance decoding.
static void TestDecodingForScenario1(void)
{
	u32 i, uIdx;
	u32 uNumOfInstance;
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uProcessIdx;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u8 bMp4DeblkEn=false;
	u32 uFinishedProcessNum=0;
	u8 bNoMoreStream[MAX_FILENAME_SIZE];	
	u32 uLcdFbAddr;
	u32 uRealReadSize;
	u32 xPos, yPos;
	u32 uLcdHSz, uLcdVSz;
	u32 uDispWidth, uDispHeight;
	u32 uDispHorizontalDiv, uDispVerticalDiv;
	u32 uFreeMemBuf;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uDecABufStAddr, uDecBBufStAddr;
	u32 sel[MAX_PROCESS_NUM];
	char aFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
	u32 uStreamFileSize[MAX_PROCESS_NUM];
	char cFileExt[MAX_PROCESS_NUM][50];
	VIDEO_CODEC_TYPE eDecStandard[MAX_PROCESS_NUM]; 
	u32 uRet[MAX_PROCESS_NUM];
	u32 uRdPtr[MAX_PROCESS_NUM];
	u8 bIsRcv[MAX_PROCESS_NUM];
	u32 uRemainSz[MAX_PROCESS_NUM];
	u32 uFrameCnt[MAX_PROCESS_NUM];
	u8 bIsFirstFrame[MAX_PROCESS_NUM];
	u32 uPicHsz[MAX_PROCESS_NUM], uPicVsz[MAX_PROCESS_NUM];
	u32 uFrameHsz[MAX_PROCESS_NUM], uFrameVsz[MAX_PROCESS_NUM];
	char cCodecName[MAX_PROCESS_NUM][50];
	u32 uStreamBufStAddr[MAX_PROCESS_NUM];
	u32 uInstanceId[MAX_PROCESS_NUM];
	u32 uFileOffset[MAX_PROCESS_NUM];
	u32 uFatReadSizeUnit[MAX_PROCESS_NUM];
	u32 uDpbBufStAddr[MAX_PROCESS_NUM];
	u32 uDpbBufEndAddr[MAX_PROCESS_NUM];
	u32 uTotalRemainSz[MAX_PROCESS_NUM];
	u32 uReadSizeUnit[MAX_PROCESS_NUM];
	u8 bPartialLoad[MAX_PROCESS_NUM];
	u8 bFinishedProcess[MAX_PROCESS_NUM];
	u32 uLastFrameSize[MAX_PROCESS_NUM];
	u8 bDispOnlyFrame[MAX_PROCESS_NUM];
	u32 uPreFrameSize[MAX_PROCESS_NUM];
	u8 bFirstSeqheader[MAX_PROCESS_NUM];
	MFC_CMD_CH_NUM ePreparedCh;
	MFC_DISP_TYPE eDispType;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	ETHERNET_FILE FwEftInfo;
	ETHERNET_FILE StreamEftInfo[MAX_PROCESS_NUM];
	t_file_handler FwHandler;
	t_file_handler StreamHandler[MAX_PROCESS_NUM];
	u8 bFirstDecInstance=true;
	u8 bAdded3thInstForDec=false;
	
	ebDecStandard=true;
	
	Disp("How many processes do you want for decoding[1~%d]?\n", MAX_PROCESS_NUM);
	uNumOfInstance = UART_GetIntNum();
	
	uFwCodeStAddr = 0x20000000;
	uFreeMemBufB = 0x41000000;
	
	// 1. lcdc setting
	uLcdFbAddr=uFreeMemBufB;
	LCDC_InitIp(eBpp, uLcdFbAddr,  eWin, false);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, eWin);
	LCDC_GetFbEndAddr(&uFreeMemBufB, eWin);	
	LCDC_Start();

	uDispHorizontalDiv = (uNumOfInstance == 1) ? 1 : (uNumOfInstance <= 4) ? 2 : 
						(uNumOfInstance <= 9) ? 3 : 4;
	uDispVerticalDiv = (uNumOfInstance <= 2) ? 1 : (uNumOfInstance <= 6) ? 2 :
						(uNumOfInstance <= 9) ? 3 : 4;
	uDispWidth = uLcdHSz/uDispHorizontalDiv;
	uDispHeight = uLcdVSz/uDispVerticalDiv;

	// OutImgHsz must be aligned 16' multiple. That is fimc constraint.
	uDispWidth -= uDispWidth%16;

	for(i=0; i<uNumOfInstance; i++)
	{
		bFinishedProcess[i] = false;
		uFrameCnt[i] = 0;
		bPartialLoad[i] = false;
		bNoMoreStream[i] = false;
		bDispOnlyFrame[i]=false;
		bFirstSeqheader[i] = true;
	}

	uStreamBufStAddr[0] = Align(uFreeMemBufB, 16);
	for(i=0; i<uNumOfInstance; i++)
	{
		uIdx = i;
		if(bSdLoadMode)
		{
			// 1. Stream load 
			if(FS_OpenFromDirlist("mfc", &StreamHandler[uIdx], sel[uIdx], true, aFileName[uIdx], cFileExt[uIdx])!=0)
			{
				Disp("Stream Open Fail\n");
				return;
			}
			uStreamFileSize[uIdx]=StreamHandler[uIdx].nSize;
			uTotalRemainSz[uIdx] = uStreamFileSize[uIdx];
			
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				bPartialLoad[uIdx] = true;
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}
		else // Load by ethernet
		{ 
			Disp("Write down filename to test : ");
			UART_GetString(aFileName[uIdx]);
			
			StreamEftInfo[uIdx] = EFT_RequestFileInfo(aFileName[uIdx]);
			
			if(StreamEftInfo[uIdx].fileID==-1 || StreamEftInfo[uIdx].fileSize==0)
			{
				Disp("Stream Open Fail\n");
				return;
			}
			uStreamFileSize[uIdx] = StreamEftInfo[uIdx].fileSize;
			if(uStreamFileSize[uIdx]<=MULTI_STREAM_FILE_BUF_SIZE)
			{
				EFT_ReadFile(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]));			
				uReadSizeUnit[uIdx] = uStreamFileSize[uIdx];
			}
			else
			{
				uFileOffset[uIdx]=0;
				uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
				EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)(uStreamBufStAddr[uIdx]), uFileOffset[uIdx], STREAM_FILE_BUF_SIZE);
				uFileOffset[uIdx] += uReadSizeUnit[uIdx];
				bPartialLoad[uIdx] = true;
				uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
			}
			EFT_GetFileNameExt(aFileName[uIdx], cFileExt[uIdx]);
		}
		if(bPartialLoad[uIdx]==false)
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + uStreamFileSize[uIdx], 16);
		else
			uStreamBufStAddr[uIdx+1] = Align(uStreamBufStAddr[uIdx] + MULTI_STREAM_FILE_BUF_SIZE, 16);
		
		uFreeMemBufB = uStreamBufStAddr[uIdx+1];

		if(MFC_GetCodecType(cFileExt[uIdx], &eDecStandard[uIdx])==false)
			return;

		DispCodecName(eDecStandard[uIdx]);
		Disp("=======================\n");
	}

	uDramBBaseAddr = Align(uFreeMemBufB, 128*1024);
	
	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("invalid file name \n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, 	 uDramBBaseAddr);

	ePreparedCh = CMD_CH0;
	for(i=0; i<uNumOfInstance-1; i++)
	{
		uIdx = i;
		MFC_InitProcessForDecoding(uIdx, eDecStandard[uIdx], bPixelCacheEn, bMp4DeblkEn, false);
		MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

		bIsRcv[uIdx] = (strcmp(cFileExt[uIdx],"rcv")==0) ? true : false;
		uRemainSz[uIdx] = uReadSizeUnit[uIdx];
		uRet[uIdx] = VsParser(eDecStandard[uIdx], uStreamBufStAddr[uIdx], uRemainSz[uIdx], 
								&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
		bFirstSeqheader[uIdx] = false;

		uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
		if(eDecStandard[uIdx]==VC1RCV_DEC)
			uRemainSz[uIdx] -= uOneFrameSz+8;
		else
			uRemainSz[uIdx] -= uOneFrameSz;
		
		if (uRet[uIdx]==3)
		{
			Disp("Parsing Error\n");
			return;
		}
		Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
		MFC_SetCmdChNum(ONE_CH_CMD);
		MFC_SetDramBDpbBufStAddr(uDramBBaseAddr);

		if(bFirstDecInstance == true)
		{
			MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
			bFirstDecInstance = false;
		}
		else
		{
			uDecABufStAddr = uFreeMemBufA;
			uDecBBufStAddr = uFreeMemBufB;
			MFC_ParseStreamHeader(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
			MFC_SetBufAddrOfDecoder(uFreeMemBufA, uFreeMemBufB);
			MFC_InitBuffer(CMD_CH0, uIdx);
		}	
		
		MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
		MFC_GetImagePicSize(&uPicHsz[uIdx], &uPicVsz[uIdx]);
		MFC_GetImageFrameSize(&uFrameHsz[uIdx], &uFrameVsz[uIdx]);
		MFC_GetDbpBufEndAddr(uIdx, &uFreeMemBufA, &uFreeMemBufB);	
		Disp("ProcessId:[%d], StreamID:[%d]\n", uIdx, uInstanceId[uIdx]);
		Disp("PicHsz=%d, PicVsz=%d\n", uPicHsz[uIdx], uPicVsz[uIdx]);
		Disp("FrameHsz=%d, FrameVsz=%d\n", uFrameHsz[uIdx], uFrameVsz[uIdx]);

		if(eDecStandard[uIdx] == H263_DEC)
		{
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME); 
		}
		else
		{
			#if 1
			continue;
			#else
			uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
			&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
			uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard[uIdx]==VC1RCV_DEC)
				uRemainSz[uIdx] -= uOneFrameSz+4;
			else
				uRemainSz[uIdx] -= uOneFrameSz;
			Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			#endif
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			break;
		}

		uFrameCnt[uIdx]++;

		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
			continue;
		
		bProcessingDoneA = false;
		xPos = i%uDispHorizontalDiv;
		yPos = i/uDispHorizontalDiv;
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
			0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight,	0, // Scaler		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		FIMC_StartProcessingForMfc(FIMC_A);
		while(!bProcessingDoneA);
		bProcessingDoneA = false;
	}

	while(UART_GetKey() == 0)   // exit when any key is pressed.
	{
		for(i=0; i<uNumOfInstance; i++)
		{
			uIdx = i;

			if( (bAdded3thInstForDec==false) && (uIdx==2) )
				continue;
				
			if(bFinishedProcess[uIdx] == false)
			{
				MFC_SetProcessIdx(uIdx);

				if(bNoMoreStream[uIdx]==true)
				{
					MFC_StartDecodingOneFrame(CMD_CH0, uLastFrameSize[uIdx], LAST_SEQ);
				}
#if 0
				else if((eDecStandard[uIdx]==H264_DEC) && (bDispOnlyFrame[uIdx]) && (bNoMoreStream[uIdx]==false))
				{
					MFC_StartDecodingOneFrame(ePreparedCh, uPreFrameSize[uIdx], FRAME);
				}
#endif
				else if(bNoMoreStream[uIdx]==false)
				{
					uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
							&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
			
					if(uRet[uIdx]==3)
					{
						Disp("Parsing Error\n");
						return;
					}
					else if(uRet[uIdx]==0)
					{
						uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
						if(eDecStandard[uIdx]==VC1RCV_DEC)
							uRemainSz[uIdx] -= uOneFrameSz+4;
						else
							uRemainSz[uIdx] -= uOneFrameSz;
						Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
						MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
					}
					else if((uRet[uIdx]==1) || (uRet[uIdx]==2))
					{
						if(uTotalRemainSz[uIdx] && bPartialLoad[uIdx])
							{
								Disp("Partial Load\n");
								UART_Getc();
								uTotalRemainSz[uIdx] += uRemainSz[uIdx];
								if(MULTI_STREAM_FILE_BUF_SIZE<=uTotalRemainSz[uIdx])
								{
									uFileOffset[uIdx] -= uRemainSz[uIdx];
									uReadSizeUnit[uIdx] = MULTI_STREAM_FILE_BUF_SIZE;
								}
								else
								{
									uFileOffset[uIdx]-= uRemainSz[uIdx];
									uReadSizeUnit[uIdx] = uTotalRemainSz[uIdx];
								}
								if(bSdLoadMode)
								{
									if(FS_Seek(&StreamHandler[uIdx], uFileOffset[uIdx], 0) != 0)
									{
										Disp("Stream Seek Fail\n");
										return;
									}
									if(FS_Read(&StreamHandler[uIdx], uReadSizeUnit[uIdx], (u32 *)uStreamBufStAddr[uIdx], &uRealReadSize) !=0)
									{
										Disp("Stream Read Fail\n");
										return;
									}
									uFileOffset[uIdx] = StreamHandler[uIdx].nOffset;
								}
								else
								{
									EFT_ReadFilePartial(&StreamEftInfo[uIdx], (u32 *)uStreamBufStAddr[uIdx], uFileOffset[uIdx], uReadSizeUnit[uIdx]);
									uFileOffset[uIdx] += uReadSizeUnit[uIdx];
								}
								uTotalRemainSz[uIdx] = uStreamFileSize[uIdx]-uFileOffset[uIdx];
								uRdPtr[uIdx] = uStreamBufStAddr[uIdx];
								uRemainSz[uIdx] = uReadSizeUnit[uIdx];
								continue;
						}

						Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
						MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
						uLastFrameSize[uIdx] = uOneFrameSz;
						bNoMoreStream[uIdx] = true;
						Disp("Emtpy\n");
					}
				}
				if(!MFC_WaitForFrameDone())
				{
					Disp("[ERR]\n");
					break;
				}
				if(MFC_IsDecodingFinished())
				{
					Disp("[BUF flushed]\n");
					bFinishedProcess[uIdx] = true;
					MFC_CloseInstance(uInstanceId[uIdx]);
					uFinishedProcessNum++;
					break;	
				}
			
				//MFC_GetDispType(&eDispType);
				MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		

				if(eDecStandard[uIdx] == H264_DEC)
				{
					if(eDispType==DISP_ONLY)
					{
						bDispOnlyFrame[uIdx]=true;
						uPreFrameSize[uIdx] = uOneFrameSz;
						uRdPtr[uIdx] = uRdPtr[uIdx] - uOneFrameSz;
						uRemainSz[uIdx] += uOneFrameSz;
					}
					else
					{
						bDispOnlyFrame[uIdx]=false;
					}
				}

				if((eDecStandard[uIdx]!=H264_DEC)&&(!bNoMoreStream[uIdx]))
				{
					uFrameCnt[uIdx]++;
					Disp("[%d]",uFrameCnt[uIdx]);
				}
				
				if((eDecStandard[uIdx]==H264_DEC)&&(eDispType!=DISP_ONLY))
				{
					uFrameCnt[uIdx]++;
					Disp("[%d] ",uFrameCnt[uIdx]);
				}

				if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
					continue;
				
				bProcessingDoneA = false;
				xPos = i%uDispHorizontalDiv;
				yPos = i/uDispHorizontalDiv;
				FIMC_InitIpForDinDout(FIMC_A,
					uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
					0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
					0, TILE_NV12,
					uLcdHSz, uLcdVSz,
					uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight, 0,	
					uLcdFbAddr, eBpp,		
					ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
				FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
				FIMC_StartProcessingForMfc(FIMC_A);
				while(!bProcessingDoneA);

				// add third instance decoding
				if(bAdded3thInstForDec==false)
				{
					if(uFrameCnt[uIdx]==70) // 70 is temp frame count.
					{
						bAdded3thInstForDec = true;
						uIdx = 2;
						MFC_InitProcessForDecoding(uIdx, eDecStandard[uIdx], bPixelCacheEn, bMp4DeblkEn, false);
						MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);

						bIsRcv[uIdx] = (strcmp(cFileExt[uIdx],"rcv")==0) ? true : false;
						uRemainSz[uIdx] = uReadSizeUnit[uIdx];
						uRet[uIdx] = VsParser(eDecStandard[uIdx], uStreamBufStAddr[uIdx], uRemainSz[uIdx], 
												&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
						bFirstSeqheader[uIdx] = false;

						uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
						if(eDecStandard[uIdx]==VC1RCV_DEC)
							uRemainSz[uIdx] -= uOneFrameSz+8;
						else
							uRemainSz[uIdx] -= uOneFrameSz;
						
						if (uRet[uIdx]==3)
						{
							Disp("Parsing Error\n");
							return;
						}
						Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
						MFC_SetCmdChNum(ONE_CH_CMD);
						MFC_SetDramBDpbBufStAddr(uDramBBaseAddr);

						if(bFirstDecInstance == true)
						{
							MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
							bFirstDecInstance = false;
						}
						else
						{
							uDecABufStAddr = uFreeMemBufA;
							uDecBBufStAddr = uFreeMemBufB;
							MFC_ParseStreamHeader(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
							MFC_SetBufAddrOfDecoder(uFreeMemBufA, uFreeMemBufB);
							MFC_InitBuffer(CMD_CH0, uIdx);
						}	
						
						MFC_GetInstanceId(&uInstanceId[uIdx], &uProcessIdx);
						MFC_GetImagePicSize(&uPicHsz[uIdx], &uPicVsz[uIdx]);
						MFC_GetImageFrameSize(&uFrameHsz[uIdx], &uFrameVsz[uIdx]);
						MFC_GetDbpBufEndAddr(uIdx, &uFreeMemBufA, &uFreeMemBufB);	
						Disp("ProcessId:[%d], StreamID:[%d]\n", uIdx, uInstanceId[uIdx]);
						Disp("PicHsz=%d, PicVsz=%d\n", uPicHsz[uIdx], uPicVsz[uIdx]);
						Disp("FrameHsz=%d, FrameVsz=%d\n", uFrameHsz[uIdx], uFrameVsz[uIdx]);

						if(eDecStandard[uIdx] == H263_DEC)
						{
							MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME); 
						}
						else
						{
							#if 1
							continue;
							#else
							uRet[uIdx] = VsParser(eDecStandard[uIdx], uRdPtr[uIdx], uRemainSz[uIdx], 
							&uOneFrameAddr, &uOneFrameSz, bIsRcv[uIdx], bFirstSeqheader[uIdx], bSliceBaseDec);
							uRdPtr[uIdx] = uOneFrameAddr+uOneFrameSz;
							if(eDecStandard[uIdx]==VC1RCV_DEC)
								uRemainSz[uIdx] -= uOneFrameSz+4;
							else
								uRemainSz[uIdx] -= uOneFrameSz;
							Copy8(uOneFrameAddr, uCpbBufStAddr,  uOneFrameSz);					
							MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
							#endif
						}

						if(!MFC_WaitForFrameDone())
						{
							Disp("[ERR]\n");
							break;
						}

						uFrameCnt[uIdx]++;

						if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
							continue;
						
						bProcessingDoneA = false;
						xPos = i%uDispHorizontalDiv;
						yPos = i/uDispHorizontalDiv;
						FIMC_InitIpForDinDout(FIMC_A,
							uFrameHsz[uIdx], uFrameVsz[uIdx], 0,
							0, 0, uFrameHsz[uIdx], uFrameVsz[uIdx],
							0, TILE_NV12,
							uLcdHSz, uLcdVSz,
							uDispWidth*xPos, uDispHeight*yPos, uDispWidth, uDispHeight,	0, // Scaler		
							uLcdFbAddr, eBpp,		
							ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
						FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
						FIMC_StartProcessingForMfc(FIMC_A);
						while(!bProcessingDoneA);
						bProcessingDoneA = false;
					}
				}
			}
		}
		if(uFinishedProcessNum == uNumOfInstance)
			break;
	}

	Disp("\n");
	for (i=0; i<uNumOfInstance; i	++)
	{
		Disp("%d: [%d] frames decoded\n", i,  uFrameCnt[i]);
	}
}

static void TestDecodingUsingClkOnOff(void)
{
	u32 i;
	char aFileName[MAX_FILENAME_SIZE];
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uTotalNumOfFiles;
	u32 uStreamFileSize;
	char cFileExt[50];
	u32 uCpbBufStAddr;
	u32 uOneFrameAddr;
	u32 uOneFrameSz;
	u32 uInstanceId;
	u32 uRet;
	u32 uRdPtr;
	u32 uRemainSz;
	u8 bIsRcv;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uLcdHSz, uLcdVSz;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	char cCodecName[50];
	u32 uMaxAbsDiff;
	u32 uLcdFbAddr;
	u32 uProcessIdx;
	u32 uStreamFileStAddr;
	u8 bMp4DeblkEn = false;
	u8 bNoMoreStream=false;
	u32 uReadSizeUnit;
	u32 uFileOffset;
	u8 bPartialLoad=false;
	u32 uTotalRemainSz;
	u32 uFwCodeStAddr;
	u32 uDramABaseAddr, uDramBBaseAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u8 bDispOnlyFrame;
	u32 uRealReadSize;
	u8 bFirstPostProcessing=true;
	MFC_DISP_TYPE eDispType;	
	ETHERNET_FILE StreamEftInfo;
	ETHERNET_FILE FwEftInfo;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	u32 uDispFrameCnt=0;
	u8 bFirstSeqheader=true;
	u32 uElapsedTime;
	u32 uConTextEndAddr;
	RESOL_CHANGE  eResInfo=NO_CHANGE;
	u8 bProgressive;
	u8 bResChanged=false;
	MFC_DEC_TYPE eDecType;

	ebDecStandard=true;
	bFirstFimcFifoOut = true;

	uFwCodeStAddr =	0x20000000;
	uStreamFileStAddr = 0x41000000;

	if(bSdLoadMode)
	{
		// 1. Stream load 
		if(FS_OpenFromDirlist("mfc", &StreamHandler, 0, true, aFileName, cFileExt)!=0)
			return;

		uStreamFileSize=StreamHandler.nSize;
		
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
			uReadSizeUnit = uStreamFileSize;
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			bPartialLoad = true;
			uFileOffset += uReadSizeUnit;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}

		if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}
		uStreamFileSize = StreamHandler.nSize;
		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);
		
		// 2. F/W load
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		Disp("Write down filename to test : ");
		UART_GetString(aFileName);

		// 1. Stream load 
		StreamEftInfo = EFT_RequestFileInfo(aFileName);

		if(StreamEftInfo.fileID==-1 || StreamEftInfo.fileSize==0)
		{
			Disp("Stream Open Fail\n");
			return;
		}
		uStreamFileSize = StreamEftInfo.fileSize;
		if(uStreamFileSize<=STREAM_FILE_BUF_SIZE)
		{
			EFT_ReadFile(&StreamEftInfo, (u32 *)uStreamFileStAddr);
			uReadSizeUnit = uStreamFileSize;
		}
		else
		{
			uFileOffset=0;
			uReadSizeUnit = STREAM_FILE_BUF_SIZE;
			EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, STREAM_FILE_BUF_SIZE);
			uFileOffset += uReadSizeUnit;
			bPartialLoad = true;
			uTotalRemainSz = uStreamFileSize-uFileOffset;
		}
		EFT_GetFileNameExt(aFileName, cFileExt);

		uDramBBaseAddr = Align(uStreamFileStAddr+uReadSizeUnit, 128*1024);

		// 2. F/W load
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Open Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}
	if(MFC_GetCodecType(cFileExt, &eDecStandard)==false)
		return;
	DispCodecName(eDecStandard);

	INTC_SetVectAddr(NUM_MFC, Isr_MfcForClkCtrl);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);	

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, bMp4DeblkEn, false);
	MFC_GetSharedMemRegBufEndAddr(&uCpbBufStAddr);
	bIsRcv = (strcmp(cFileExt,"rcv")==0) ? true : false;	
	bIsFirstFrame = true;
	uRemainSz = uReadSizeUnit;

#if ONLY_SEQ_HEADER_PARSE_MODE	
	bFirstSeqheader = true;
#else
	bFirstSeqheader = false;
#endif

	uRet = VsParser(eDecStandard, uStreamFileStAddr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
	Disp("[0]One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
	bFirstSeqheader = false;
	uRdPtr = uOneFrameAddr+uOneFrameSz;
	if(eDecStandard==VC1RCV_DEC)
		uRemainSz -= uOneFrameSz+8;
	else
		uRemainSz -= uOneFrameSz;
	if(uRet==3)
	{
		Disp("Parsing Error\n");
		return;
	}
	Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
	MFC_SetCmdChNum(ONE_CH_CMD);

	if(bSliceBaseDec)
		MFC_SetDpbCfg(CMD_CH0, true, false, 0);
	else
		MFC_SetDpbCfg(CMD_CH0, false, false, 0);	
	
	MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
	MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
	MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
	Disp("[Stream Instance ID] : %d\n", uInstanceId);
	Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
	Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

	if(bFimcDinDout==false)
	{
		LCDC_InitBase();
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();
		FIMC_InitIpForDinFout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			NULL, TILE_NV12, false,
			uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
	}
	else
	{
		//uLcdFbAddr=Align(uFreeMemBufB, 0xe00000);
		uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
		uLcdFbAddr = uFreeMemBufB;
		LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		LCDC_Start();
		FIMC_InitIpForDinDout(FIMC_A,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
	}

	uFrameCnt=0;
	
	while(UART_GetKey()==0)   // exit when any key is pressed.
	{

#if MFC_CLK_CONTROL
		SYSC_SetClkON_IP(eMFC);
#endif

		if(bIsFirstFrame==true)
		{
			bIsFirstFrame = false;

#if ONLY_SEQ_HEADER_PARSE_MODE	
			if(eDecStandard == H263_DEC)
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else
			{
				continue;
			}
#else
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
#endif
		}
		else if((eResInfo == RESOL_INCR) || (eResInfo == RESOL_DECR) || (bResChanged==true))
		{
			if(bResChanged==false)
				eDecType = FRAME_START_REALLOC;
			else
				eDecType = FRAME;
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, eDecType);
			bResChanged = true;
		}
		else if(bNoMoreStream)
		{ 
			MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
		}
		else if((eDecStandard == H264_DEC) && (bDispOnlyFrame==true) && (bNoMoreStream==false))
		{
			MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
		}
		else
		{
			uOneFrameSz = 0;
			uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
			Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
			
			uRdPtr = uOneFrameAddr+uOneFrameSz;
			if(eDecStandard==VC1RCV_DEC)	
				uRemainSz -= uOneFrameSz+4;
			else
				uRemainSz -= uOneFrameSz;
			if(uRet==3)
			{
				Disp("Parsing Error\n");
				return;
			}
			else if(uRet==0)
			{
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, FRAME);
			}
			else if((uRet==1) || (uRet==2))
			{
				if(uTotalRemainSz && bPartialLoad)
				{
					uTotalRemainSz += uRemainSz;
					if(STREAM_FILE_BUF_SIZE<=uTotalRemainSz)
					{
						uFileOffset -= uRemainSz;
						uReadSizeUnit = STREAM_FILE_BUF_SIZE;
					}
					else
					{
						uFileOffset-= uRemainSz;
						uReadSizeUnit = uTotalRemainSz;
					}

					if(bSdLoadMode)
					{
						if(FS_Seek(&StreamHandler, uFileOffset, 0) != 0)
						{
							Disp("Seek Fail\n");
							return;
						}
						if(FS_Read(&StreamHandler, uReadSizeUnit, (u32 *)uStreamFileStAddr, &uRealReadSize) !=0)
						{
							Disp("Stream Read Fail\n");
							return;
						}
						uFileOffset = StreamHandler.nOffset;
					}
					else
					{
						EFT_ReadFilePartial(&StreamEftInfo, (u32 *)uStreamFileStAddr, uFileOffset, uReadSizeUnit);
						uFileOffset += uReadSizeUnit;
					}
					uTotalRemainSz = uStreamFileSize-uFileOffset;
					uRdPtr = uStreamFileStAddr;
					uRemainSz = uReadSizeUnit;
					continue;
				}

				bNoMoreStream=true;
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
				MFC_StartDecodingOneFrame(CMD_CH0, uOneFrameSz, LAST_SEQ);
			}
			else
				Assert(0);
		}

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		if(bResChanged == false)
		{
			if(MFC_IsDecodingFinished())
			{
				Disp("[DEC END]\n");
				break;
			}
		}
		else
		{	
			if(MFC_IsDecodingFinished())
			{
				Disp("[Resolution Reallocation & Restart]\n");

				bIsFirstFrame = true;
#if ONLY_SEQ_HEADER_PARSE_MODE
				bFirstSeqheader = true;
				uRdPtr = uRdPtr - uOneFrameSz;
				uRet = VsParser(eDecStandard, uRdPtr, uRemainSz, &uOneFrameAddr, &uOneFrameSz, bIsRcv, bFirstSeqheader, bSliceBaseDec);
				bFirstSeqheader = false;
				//Disp("One Frame Addr:0x%x, One Frame Size:0x%x\n", uOneFrameAddr, uOneFrameSz);
				uRdPtr = uOneFrameAddr+uOneFrameSz;
				if(eDecStandard==VC1RCV_DEC)
					uRemainSz -= uOneFrameSz+8;
				else
					uRemainSz -= uOneFrameSz;
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				
				Copy8(uOneFrameAddr, uCpbBufStAddr, uOneFrameSz);
#endif
				if(bSliceBaseDec)
					MFC_SetDpbCfg(CMD_CH0, true, false, 0);
				else
					MFC_SetDpbCfg(CMD_CH0, false, false, 0);	

				MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uOneFrameSz);
				MFC_GetDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
				MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
				MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);
				Disp("[PicHsz=%d, PicVsz=%d]\n", uPicHsz, uPicVsz);
				Disp("[FrameHsz=%d, FrameVsz=%d]\n", uFrameHsz, uFrameVsz);

				if(bFimcDinDout==false)
				{
					LCDC_InitBase();
					LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
					LCDC_InitWinForFifoIn3(IN_POST, WIN0, uLcdHSz, uLcdVSz, 0, 0);
					LCDC_SetWinOnOff(1, WIN0);
					LCDC_Start();
					FIMC_InitIpForDinFout(FIMC_A,
						uFrameHsz, uFrameVsz, 0,
						0, 0, uFrameHsz, uFrameVsz,
						NULL, TILE_NV12, false,
						uLcdHSz, uLcdVSz, LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange);
				}
				else
				{
					//uLcdFbAddr=Align(uFreeMemBufB, 0xe00000);
					uLcdFbAddr = uFreeMemBufB;
					LCDC_InitIp(eBpp, uLcdFbAddr, eWin, false);
					LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
					LCDC_EnableAllWinFifoLvlInt(EMPTY);
					LCDC_Start();
					FIMC_InitIpForDinDout(FIMC_A,
						uFrameHsz, uFrameVsz, 0,
						0, 0, uFrameHsz, uFrameVsz,
						0, TILE_NV12,
						uLcdHSz, uLcdVSz,
						0, 0, uLcdHSz, uLcdVSz, 0,		
						uLcdFbAddr, eBpp,		
						ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
				}
				bResChanged = false;
			}
		}

		//MFC_GetDispType(&eDispType);
		MFC_GetDispInfo(&eDispType, &eResInfo, &bProgressive);		
		
		if(eDispType==DISP_ONLY)
			bDispOnlyFrame=true;
		else 
			bDispOnlyFrame=false;
		
		if((eDecStandard!=H264_DEC)&&(!bNoMoreStream))
		{
			uFrameCnt++;
			Disp("[%d]",uFrameCnt);
		}
		
		if((eDecStandard==H264_DEC)&&(eDispType!=DISP_ONLY))
		{
			uFrameCnt++;
			Disp("[%d] ",uFrameCnt);
		}
		
		if(MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
		{	
			continue;
		}

		bProcessingDoneA = false;
		FIMC_SetDinImgAddrForMfc(FIMC_A, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
		if(bFimcDinDout==true)
		{		
			FIMC_StartProcessingForMfc(FIMC_A);
			while(!bProcessingDoneA);			
			FIMC_StopProcessing(FIMC_A);

		}
		else
		{
			if(bFirstFimcFifoOut)
			{
				FIMC_StartProcessingForMfc(FIMC_A);
				bFirstFimcFifoOut = false;
			}
		}
	}
	FIMC_StopProcessing(FIMC_A);
	MFC_CloseInstance(uInstanceId);
	Disp("Total Frame Count : %d\n", uFrameCnt);
	Disp("Decoding Done All Frame!!!\n");
}

static void TestEncodingUsingClkOnOff(void)
{
	u32 uIdx;
	u32 uFreeMemBuf, uFreeMemBufA, uFreeMemBufB;
	u32 uProcessIdx = 0;
	u32 uInstanceId;
	u32 uCfgFileBufAddr;
	VIDEO_CODEC_TYPE eEncStandard;
	u32 uWidth, uHeight;
	u32 uNumOfTotFrames;
	u32 uNumberBFrames;
	u32 uIsInterlace;
	u32 uIDR_period;
	char* cFrameType;
	u32 uSrcYuvStAddr, uSrcYuvAddr;
	u32 uStreamBufStAddr;
	u32 uStreamBufOffset = 0;
	u32 uSrcNv12YAddr, uSrcNv12CAddr;
	u32 uSrcYuvFrameSizeInBytes;
	u32 uEncStrSzPerFrame;
	u32 uFrameIdx;
	u32 uGoldenStreamSize;
	char aStreamFileName[MAX_FILENAME_SIZE];
	char aYuvFileName[MAX_FILENAME_SIZE];
	char aCfgFileName[MAX_FILENAME_SIZE];
	u32 uDramBBaseAddr;
	u32 uDramABaseAddr;
	u32 uFwCodeStAddr;
	u32 uCodeBufEndAddr;
	u32 uEncStreamBufAddr;
	u32 uGoldenStreamBufAddr;
	u32 uCurGoldenStreamBufAddr;
	t_file_handler StreamHandler;
	t_file_handler FwHandler;
	t_file_handler CfgFileHandler;	
	t_file_handler YuvFileHandler;	
	ETHERNET_FILE StreamInfo;
	ETHERNET_FILE CfgEftInfo;
	ETHERNET_FILE YuvEftInfo;
	ETHERNET_FILE FwEftInfo;
	u32 uRealReadSize;
	u32 uErrCnt=0;
	u32 uConfigFileSize;
	u32 uBitRate;
	u32 uElapsedTime;
	u32 uTotElapsedTime;
	u8 bNoMoreYC=false;
	u8 bLastOrNoMoreYC = false;
	MFC_DEC_TYPE eCmdType;
	u32 uFrameCount=0;
	u32 uValidFrmCnt=0;
	u32 uLcdHSz, uLcdVSz;
	u32 uLcdFbAddr;
	
	INTC_SetVectAddr(NUM_MFC, Isr_MfcForClkCtrl);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	INTC_SetVectAddr(NUM_FIMC_B, Isr_FimcBDone);
	INTC_Enable(NUM_FIMC_B);
	
	uFwCodeStAddr = 0x20000000;	
	uDramBBaseAddr = 0x41000000;
	Disp("[FW loading...]\n");

	if(bSdLoadMode)
	{
		if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
			return;
		if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
		{
			Disp("F/W Read Fail\n");
			return;
		}	
	}
	else
	{
		FwEftInfo = EFT_RequestFileInfo("mfd_vo.bin");
		if(FwEftInfo.fileID==-1 || FwEftInfo.fileSize==0)
		{
			Disp("F/W Read Fail\n");
			return;
		}
		EFT_ReadFile(&FwEftInfo, (u32 *)uFwCodeStAddr);
	}

	MFC_LoadFirmwareIntoIp(uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetSharedMemRegBufEndAddr(&uFreeMemBufA);

	uFreeMemBuf = uDramBBaseAddr;

	MFC_SelectEncStandard(0, &eEncStandard);
	//MFC_SetCodecStandard(0, eEncStandard);	

	// Load a config file
	if(bSdLoadMode)
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);
	
		if(FS_Open(aCfgFileName, &CfgFileHandler)!=0)
			return;

		uCfgFileBufAddr = uFreeMemBuf;	
		if(FS_Read(&CfgFileHandler, CfgFileHandler.nSize, (u32 *)uCfgFileBufAddr, &uRealReadSize) !=0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uConfigFileSize = CfgFileHandler.nSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}
	else
	{
		Disp("Write config filename to test : ");
		UART_GetString((s8 *)aCfgFileName);

		CfgEftInfo = EFT_RequestFileInfo(aCfgFileName);
		if(CfgEftInfo.fileID==-1 || CfgEftInfo.fileSize==0)
		{
			Disp("Cfg File Read Fail\n");
			return;
		}
		uCfgFileBufAddr = uFreeMemBuf;
		EFT_ReadFile(&CfgEftInfo, (u32 *)(uCfgFileBufAddr));
		uConfigFileSize = CfgEftInfo.fileSize;
		uFreeMemBuf += uConfigFileSize;
		*(char *)uFreeMemBuf++ = NULL;
	}

	// Parse a config file
	MFC_ParseConfigFile(uCfgFileBufAddr);
	
	// Set the encoding parameters
	MFC_SetConfigParameters();
	MFC_CalculateTotalFramesToEnc();

	//  Initialize a mfc process
	MFC_InitProcessForEncoding(0, eEncStandard, true, eLinearTileMode);
	MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
	
	// Set Buffer Address for Encoding
	uFreeMemBufB = Align(uFreeMemBuf, 2*1024);
	
	MFC_SetBufAddrOfEncoder(uFreeMemBufA, uFreeMemBufB);
	MFC_GetEncBufEndAddr(&uFreeMemBufA, &uFreeMemBufB);
	uFreeMemBuf = uFreeMemBufB;
	
	// Get encoding parameters
	MFC_GetEncFrameSizeCfg(&uWidth, &uHeight);   
	MFC_GetEncNumOfTotalFrames(&uNumOfTotFrames);
	MFC_GetEncPicTypeCfg(&uNumberBFrames);
	MFC_GetInterlace(&uIsInterlace);
	MFC_GetIDRPeriod(&uIDR_period);
	MFC_GetSrcImgFileName(aYuvFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight *3/2;

	if(FS_Open(aYuvFileName, &YuvFileHandler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}
	
	uSrcYuvStAddr = uFreeMemBuf;
	uSrcYuvAddr = uSrcYuvStAddr;
	uFreeMemBuf += uSrcYuvFrameSizeInBytes;
	Disp("YUV Buf Start Addr : 0x%08x\n", uSrcYuvStAddr);

	uStreamBufStAddr = uFreeMemBuf;
	uFreeMemBuf += MFC_ENC_STREAM_BUF_SIZE;
	Disp("Stream Buf Start Addr : 0x%08x\n", uStreamBufStAddr);

	// seq header
	MFC_EncodingOneFrame(SEQ_HEADER);
	MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);
	MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
	uStreamBufOffset += uEncStrSzPerFrame;

	uFrameCount = 0;
	uValidFrmCnt = 0;

	// yuv data preview
	uFreeMemBufB=Lcdc_CheckFrameBufAddr(uFreeMemBufB);
	uLcdFbAddr = uFreeMemBufB;
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_Start();
	FIMC_InitIpForDinDout(FIMC_A,
		uWidth, uHeight, 0,
		0, 0, uWidth, uHeight,
		uSrcYuvAddr, YC420,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdVSz, 0,		
		uLcdFbAddr, RGB24,		
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		
	while (GetKey() == 0)
	{
		// Load one frame to the temporary buffer
		if(uFrameCount <= uNumOfTotFrames-1)
		{
			if(FS_Seek(&YuvFileHandler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
			{
				Disp("Seek Fail\n");
				return;
			}
			if(FS_Read(&YuvFileHandler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcYuvAddr, &uRealReadSize) !=0)
			{
				Disp("Stream Read Fail\n");
				return;
			}
		}

		// If necessary, convert non-NV12 to NV12
		MFC_GetEncCurrentYCBufAddr(&uSrcNv12YAddr, &uSrcNv12CAddr);
#if 0
		Copy8(uSrcYuvAddr, uSrcNv12YAddr, (uWidth*uHeight));
		MFC_ConvertYuv420ToNv12OnlyCbCr((uSrcYuvAddr+(uWidth*uHeight)), uWidth, uHeight, uSrcNv12CAddr);		
#else
		if(eLinearTileMode == MB_LINEAR_MODE)	// YC420 to NV12
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler	
				uSrcNv12YAddr, NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}
		else	// YC420 to TILE_NV12 (eLinearTileMode == MB_TILE_MODE_FOR_ENC)
		{
			FIMC_InitIpForDinDout(FIMC_A,
				uWidth, uHeight, 0,
				0, 0, uWidth, uHeight,
				uSrcYuvAddr, YC420,
				uWidth, uHeight,
				0, 0, uWidth, uHeight, 0, // Scaler		
				uSrcNv12YAddr, TILE_NV12,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, true);
		}

		FIMC_SetDoutDispAddrForMfc(FIMC_A, NV12,
		uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr, uSrcNv12YAddr,
		uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr, uSrcNv12CAddr);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);
#endif
		// Encode a frame
		//StartTimer(0);
		if(bLastOrNoMoreYC == false)
			eCmdType = FRAME;
		else
			eCmdType = LAST_SEQ;

#if MFC_CLK_CONTROL
		SYSC_SetClkON_IP(eMFC);
#endif
		Delay(100);

		MFC_EncodingOneFrame(eCmdType);

		if(!MFC_WaitForFrameDone())
		{
			Disp("[ERR]\n");
			//break;
		}

		MFC_ReleaseCurrentYCBuf();	

		if(MFC_IsEncodingFinished()==true)
			break;	
		
		MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

		if(uEncStrSzPerFrame != 0)
		{
			Disp("\nENC : [%d]\t ", uValidFrmCnt); 
			Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
			MFC_GetFrameType(&cFrameType);
			Disp("Frame Type : %s\n",  cFrameType);
			uValidFrmCnt++;

			// Read a stream from stream buffer
			MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
			uStreamBufOffset += uEncStrSzPerFrame;
		}

		if (uIsInterlace == 1)
		{
#if MFC_CLK_CONTROL
			SYSC_SetClkON_IP(eMFC);
#endif
			Delay(100);		

			MFC_EncodingOneFrame(eCmdType);

			if(!MFC_WaitForFrameDone())
			{
				Disp("[ERR]\n");
				//break;
			}
			
			if(MFC_IsEncodingFinished()==true)
				break;			

			MFC_GetEncStrSzPerFrame(&uEncStrSzPerFrame);

			if(uEncStrSzPerFrame != 0)
			{
				Disp("\nBottom\t "); 
				Disp("Stream Size : 0x%x\t",  uEncStrSzPerFrame);
				MFC_GetFrameType(&cFrameType);
				Disp("Frame Type : %s\n",  cFrameType);
				MFC_ReadEncOneFrameStream((uStreamBufStAddr+uStreamBufOffset), uEncStrSzPerFrame);
				uStreamBufOffset += uEncStrSzPerFrame;
			}
		}

		MFC_ReleaseCurrentYCBuf();

		uFrameCount++;
		
		if(uFrameCount == uNumOfTotFrames-1)
			bLastOrNoMoreYC = true;		
	}

	// Close instance
	MFC_CloseInstance(uInstanceId);
}

static void ImgYuv422ToYuv420FormatConvert(void)
{
	u32 uIdx, uFileCnt;
	t_file_handler Yuv422Handler;
	t_file_handler YuvHandler;
	char aRgbFileName[256];
	u32 uSrcYuvFrameSizeInBytes;
	u32 uFrameCount=0;
	u32 uSrcRgbAddr=0x20000000;
	u32 uRealReadSize;
	u32 uYuvFileSize;
	u32 uTotalFrameCnt;
	u32 uWidth, uHeight;
	u32 uDstYuvAddr=0x41000000;
	char aYuvFileName[256];
	char aYuvFileCntName[256];
	u32 uYuvBufOffset=0;
	u32 uLcdHSz, uLcdVSz;

	uFileCnt = 0;
	uWidth = 1920;
	uHeight = 1080;
	
	Disp("Write Yuv filename to test : ");
	UART_GetString((s8 *)aRgbFileName);

	uSrcYuvFrameSizeInBytes = uWidth * uHeight * 2; //YUV422

	uYuvBufOffset = uWidth * uHeight * 3/2; //YUV420

	INTC_SetVectAddr(NUM_FIMC_A, Isr_FimcADone);
	INTC_Enable(NUM_FIMC_A);
	
	if(FS_Open(aRgbFileName, &Yuv422Handler)!=0)
	{
		Disp("YUV File open fail");
		return;
	}

	uYuvFileSize = Yuv422Handler.nSize;

	uTotalFrameCnt = uYuvFileSize/uSrcYuvFrameSizeInBytes;

#if 1
	for(uFrameCount=0; uFrameCount < uTotalFrameCnt; uFrameCount++)
	{
		if(FS_Seek(&Yuv422Handler, uFrameCount*uSrcYuvFrameSizeInBytes, 0) != 0)
		{
			Disp("Seek Fail\n");
			return;
		}
		if(FS_Read(&Yuv422Handler, uSrcYuvFrameSizeInBytes, (u32 *)uSrcRgbAddr, &uRealReadSize) !=0)
		{
			Disp("Stream Read Fail\n");
			return;
		}

		FIMC_InitIpForDinDout(FIMC_A,
			uWidth, uHeight, 0,
			0, 0, uWidth, uHeight,
			uSrcRgbAddr, CRYCBY,
			uWidth, uHeight,
			0, 0, uWidth, uHeight, 0, // Scaler	
			uDstYuvAddr, NV12,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);

#if 1
		LCDC_InitIp(RGB24, uSrcRgbAddr, WIN0, false);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz); 

		FIMC_InitIpForDinDout(FIMC_A,
			uWidth, uHeight, 0,
			0, 0, uWidth, uHeight,
			uDstYuvAddr, NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0, // Scaler	
			uSrcRgbAddr, RGB24,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);		
		LCDC_Start();
#endif

		Disp("FrameCount : %d\n", uFrameCount);
		uDstYuvAddr += uYuvBufOffset;
	}

	strcpy(aYuvFileName, aRgbFileName);
	uIdx = strlen(aYuvFileName);
	while (1)
	{
		if (aYuvFileName[--uIdx] == '.')
			break;
	}
	strcpy(&aYuvFileName[uIdx], ".nv12");
	sprintf(aYuvFileCntName, "%s%s", aYuvFileName, "_2");
	
	FS_Creat(aYuvFileName, &YuvHandler);
	FS_Write(&YuvHandler, (uDstYuvAddr-0x41000000)/2, (u32 *)0x41000000, &uRealReadSize);

	FS_Creat(aYuvFileCntName, &YuvHandler);
	FS_Write(&YuvHandler, (uDstYuvAddr-0x41000000)/2, (u32 *)(0x41000000+(uDstYuvAddr-0x41000000)/2), &uRealReadSize);

	Disp("SD Write Complete\n");

#endif

#if 1
	LCDC_InitIp(RGB24, 0x20000000, WIN0, false);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_Start();
	
	for(uFrameCount=0; uFrameCount < uTotalFrameCnt; uFrameCount++)
	{		
		FIMC_InitIpForDinDout(FIMC_A,
		uWidth, uHeight, 0,
		0, 0, uWidth, uHeight,
		0x41000000+uYuvBufOffset*uFrameCount, NV12,
		uLcdHSz, uLcdVSz,
		0, 0, uLcdHSz, uLcdVSz, 0, // Scaler	
		0x20000000, RGB24,		
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		
		bProcessingDoneA = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
		while(!bProcessingDoneA);		
		FIMC_StopProcessing(FIMC_A);		
	}
#endif
}


void Test_MFC(void)
{
	int i, sel;

	const testFuncMenu menu[]=
	{
		0,                                  		"Exit",
		TestDecoding,                         		"Test decoding",
		TestFastDecoding,							"Test fast decoding",
		TestDecodingBy2Ch,							"Test decoding by 2ch cmd",
		TestDecodingWithCrcComparison,				"Test decoding with Comparison",
		TestDecodingWithDivX311CrcComparison,		"Test decoding with DivX3.11 Comparison",
		TestMultiDecBy1Ch,							"Test multi dec 1ch cmd",
		TestMultiDecBy2Ch,							"Test multi dec 2ch cmd",
		TestAviDecoding,							"Test avi file decoding\n",
		
		TestEncoding,								"Test encoding",
		TestEncodingOnSmallStreamBuf,				"Test encoding with double buf[Up+Lo]",
		TestEncodingWithComparion,					"Test encoding with comparion",
		TestEncodingConformance,					"Test encoding conformance\n",

		TestConformance,							"Test conformance",
		TestConformanceForMulti ,					"Test Comformance For Multi Instance",
		TestRandomConformanceForMulti,				"Test Random Comformance For Multi Instance\n",
		
		MFC_AutoTest,								"MFC_AutoTest\n",
	
		TestDecodingPowerGating,					"Test decoding Power Gating",
		TestDecodingClkGating,						"Test decoding Clk Gating",
		TestEncodingClkGating,						"Test encoding Clk Gating",
		TestSrcClkAndDivider,						"Test SrcClk and Divider",
		TestChangeSrcClkAndDividerOnDec,			"Test Change SrcClk and Divider On Dec",
		TestChangeSrcClkAndDividerOnEnc,			"Test Change SrcClk and Divider On Enc",
		TestDecodingUsingClkOnOff,					"Test decoding using mfc clk On/Off",
		TestEncodingUsingClkOnOff,					"Test encoding using mfc clk On/Off",
		TestPowerMode,								"Test Power Mode\n",
		
		TestDecodingForPerformance,		 			"Test decoding for performance measure",
		TestEncodingForPerformance,					"Test encoding for performance measure",
		TestDecPerfForScenario1,					"Test dec perf. for Scenario1",
		TestDecPerfForScenario2,					"Test dec perf. for Scenario2 [Direct FiFo]",
		TestEncPerfForScenario3,					"Test enc perf. For Scenario3 [MFC+FIMD+FIMC] ",

		SelectFileLoadMode,							"Select File Load Mode",
		SetMemStructType,							"Set Mem Struct Type",
		SetCrcSaveMode,								"Set Crc Save Mode",
		SetConformanceMode,							"Set ConformanceMode",
		SetFimcPath,								"Set Fimc Path",
		SetSliceIfDec,								"Set Slice I/F Dec",
		ChangeEndian,								"Change Endian",
		MakeStreamFrameListInfoFile,				"Make Stream FrameListInfo File\n",

		TestDecodingForScenario1,					"Test decoding for application scenario[1]",

		ImgYuv422ToYuv420FormatConvert, 			"Img Yuv422 To Yuv420 Format Convert",
		0,											0
	};
	
	if(bSdLoadMode)
	{
		if(FS_Init()!=0)
		{
			Disp("Fail to open FAT with SD CARD\n");
			if(FS_Init()!=0)
			{
				Disp("Fail to open FAT with SD CARD\n");
			}
			else
			{
				Disp("OK to open FAT with SD CARD\n");
			}
		}
	}
	else
	{
		if(EFT_Init(DefaultMACAddress,DefaultIPAddress,TargetIPAddress)==false)
		{
			Disp("Fail to init Network System\n");
			return;
		}
		//Init Protocol stacks
		#if 1 
		PROTOCOL_InitStackWithUDP(DefaultMACAddress,DefaultIPAddress, SMSC_SenderWapper, UDP_ReceiveHandler);
		SMSC_RegisterReceiveHandler(PROTOCOL_FrameHander);
		SMSC_Init(DefaultMACAddress);
		#else
		PROTOCOL_InitStackWithUDP(DefaultMACAddress,DefaultIPAddress,DM9000_SendFrame,UDP_ReceiveHandler);
		DM9000_SetGPIO();
		DM9000_Reset();
		DM9000_RegisterReceiveHandler(PROTOCOL_FrameHander);
		DM9000_Init(DefaultMACAddress);
		#endif
	}

	Disp("\n\n");
	if(bPixelCacheEn)
		Disp("MFC Pixel Cache On\n");
	else
		Disp("MFC Pixel Cache Off\n");

	Disp("\n\n");
		
	eBpp = RGB24;
	eWin = WIN0;
	LCDC_InitLdi(MAIN);
	MFC_SetCmdChNum(TWO_CH_CMD);
	SYSC_SetDispPath(eDISP_BYPASS);
	SYSC_InitClkForMM();

	while(1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		//sel = 18;
		Disp("\n");

		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func)();
	}
}
