#ifndef __MFC50_H__
#define __MFC50_H__

#include "system.h"
#include "util.h" 
#include "intc.h"
#include "option.h"
#include "library.h"

#define MAX_PROCESS_NUM		(16)
#define BUF_ALIGN_UNIT   	(64)
#define MAX_DEC_FRAME    	(19)
#define CPB_BUF_SIZE		(0x400000)	// 4MB
#define DESC_BUF_SIZE		(0x20000)	// 128K
#define MFC_STR_BUF_SIZE	(0x300000)	// 3MB
//#define MFC_STR_BUF_SIZE	(0x100)	// 4KB, allocating  small size

#define Align(x, alignbyte) (((x)+(alignbyte)-1)/(alignbyte)*(alignbyte))
#define MFC_GET_ADDR(Addr, DramBaseAddr)	((Addr-DramBaseAddr)/2048)
#define MAX_PARAMETER_NUM (61)
#define MAX_FILENAME_SIZE	(256)

#define MAX_MSG_SIZE 				512
#define MAX_PARAM_NUM 				3
#define PROFILE_IDC     			77
#define LEVEL_IDC       			31
#define INIT_FRAME_RATE 			30
#define MIN_QP          			0
#define MAX_QP          			51
#define SHIFT_QP        			12
#define MAXSLICEGROUPIDS 			8
#define MAX_CONFIGFILE_COUNT		1600

#define RECON_B_ENABLE 		1
#define ACOMPANY			1
#define MFC_CLK_CONTROL		0

typedef enum 
{
	DUMP_STREAM,	DUMP_YUV
}DUMPFLAG;

typedef struct 
{
	u32 uFrameOffset;
	u32 uFrameSize;
}FRAME_INFO;

typedef enum
{
	H264_DEC,
	VC1AP_DEC,	
	MPEG4_DEC,
	XviD_DEC,
	MPEG1_DEC,
	MPEG2_DEC,
	H263_DEC,
	VC1RCV_DEC,	// VC1RCV_DEC <AP/MP>
	DivX311_DEC,
	DivX412_DEC,
	DivX502_DEC, // DivX (Ver 5.00, 5.01, 5.02)
	DivX503_DEC, // DivX (Ver 5.03 and upper)
	H264_ENC,
	MPEG4_ENC,
	H263_ENC
}VIDEO_CODEC_TYPE;

typedef enum
{
	MFC_FIRMWARE_BUF_SIZE				= 0x00100000,	// 1MB
	MFC_STR_U_BUF_SIZE					= MFC_STR_BUF_SIZE,	// 64KB
	MFC_STR_L_BUF_SIZE					= MFC_STR_BUF_SIZE,	// 64KB
	MFC_UPPER_MV_BUF_SIZE				= 0x00010000,	// 64KB
	MFC_DIRECT_COZERO_FLAG_BUF_SIZE	= 0x00010000,		// 64KB
	MFC_UPPER_INTRA_MD_BUF_SIZE			= 0x00010000,	// 64KB
	MFC_UPPER_INTRA_PRED_BUF_SIZE		= 0x00010000,	// 64KB
	MFC_NBOR_INFO_MPENC_BUF_SIZE		= 0x00010000,	// 64KB
	MFC_STAT_LOG_BUF_SIZE				= 0x00010000,	// 64KB
	MFC_MV_BUF_BUF_SIZE					= 0x00010000,	// 64KB
	MFC_CUR_Y_BUF_SIZE					= 0x00400000,	// 4MB
	MFC_CUR_C_BUF_SIZE					= 0x00200000,	// 2MB
	MFC_REF_Y_BUF_SIZE					= 0x00200000,	// 2MB
	MFC_REF_C_BUF_SIZE					= 0x00100000,	// 1MB
}MFC_BUFFER_SIZE;


typedef enum
{
	H264DEC_CONTEXT_SIZE		= 600 * 1024,
	VC1DEC_CONTEXT_SIZE			= 10 * 1024,
	MPEG2DEC_CONTEXT_SIZE		= 10 * 1024,
	H263DEC_CONTEXT_SIZE		= 10 * 1024,
	MPEG4DEC_CONTEXT_SIZE		= 10 * 1024,
	H264ENC_CONTEXT_SIZE		= 10 * 1024,
	MPEG4ENC_CONTEXT_SIZE		= 10 * 1024,
	H263ENC_CONTEXT_SIZE		= 10 * 1024	
}MFC_CONTEXT_SIZE;

typedef enum
{
	MB_LINEAR_MODE = 0,
	MB_TILE_MODE_FOR_ENC = 3
} MFC_MB_LINEAR_TILE_MODE;

typedef enum
{
	STREAM_UPPER_BUF_FULL = 0x1,
	STREAM_BOTH_FULL_L_FIRST = 0x2,
	STREAM_LOWER_BUF_FULL = 0x4,
	STREAM_BOTH_FULL_U_FIRST = 0x8,
	STREAM_ENCODING_DONE = 0x10,
	STREAM_ACTIVE_U_BUF = 0x000,
	STREAM_ACTIVE_L_BUF = 0x100
} MFC_EDFU_STR_BUF_STATUS;

typedef enum
{
	CMD_CH0		= 1,
	CMD_CH1		= 2
}MFC_CMD_CH_NUM;

typedef enum
{
	TOP_FIELD	=1,
	BOT_FIELD	=2
}MFC_FILED_TYPE;

typedef enum
{
	SEQ_HEADER				= 1,
	FRAME					= 2,
	LAST_SEQ				= 3,
	INIT_BUFFER				= 4,
	FRAME_START_REALLOC		= 5
}MFC_DEC_TYPE;

typedef enum
{
	SKIP_FRAME		=0,
	I_FRAME			=1,
	P_FRAME			=2,
	B_FRAME			=3,
	OTHERS_FRAME	=4
}MFC_PIC_TYPE;

typedef enum
{
	NO_CHANGE		=0,
	RESOL_INCR		=1,
	RESOL_DECR		=2
}RESOL_CHANGE;

typedef enum
{
	H2R_CMD_EMPTY				= 0,
	H2R_CMD_OPEN_INSTANCE		= 1,
	H2R_CMD_CLOSE_INSTANCE		= 2,
	H2R_CMD_SYS_INIT			= 3,
	H2R_CMD_SLEEP				= 5,
	H2R_CMD_WAKEUP				= 6,
	H2R_CMD_CONTINUE_ENC		= 7
}MFC_FACADE_CMD;

typedef enum
{
	R2H_CMD_EMPTY 					= 0,
	R2H_CMD_OPEN_INSTANCE_RET	 	= 1,	
	R2H_CMD_CLOSE_INSTANCE_RET 		= 2,
	R2H_CMD_SEQ_DONE_RET 			= 4,
	R2H_CMD_FRAME_DONE_RET 			= 5,
	R2H_CMD_SLICE_DONE_RET 			= 6,
	R2H_CMD_ENC_COMPLETE_RET 		= 7,	
	R2H_CMD_SYS_INIT_RET 			= 8,
	R2H_CMD_FW_STATUS_RET 			= 9,
	R2H_CMD_SLEEP_RET 				= 10,
	R2H_CMD_WAKEUP_RET 				= 11,	
	R2H_CMD_INIT_BUFFER_RET			= 15,
	R2H_CMD_EDFU_INT_RET 			= 16,
	R2H_CMD_ERR_RET 				= 32	
}MFC_FACADE_RESPONSE;	

typedef enum
{
	ONE_CH_CMD,
	TWO_CH_CMD
}MFC_CMD_CH;

typedef enum
{
	P_ONLY,
	B_ONLY,
	P_AND_B,
	PIX_CACHE_OFF
}MFC_DEC_PIXEL_CACHE_TYPE;

typedef enum 
{
  UVLC,  CABAC
} SymbolMode;

typedef enum
{
	DEC_ONLY,
	DEC_AND_DISP,
	DISP_ONLY,
	DPB_EMPTY
}MFC_DISP_TYPE;

typedef struct {
  char *TokenName;
  void *Place;
  int Type;
  int Default;
  int param_limits; //! 0: no limits, 1: both min and max, 2: only min (i.e. no negatives), 3: specialcase for QPs since min needs bitdepth_qp_scale
  int min_limit;
  int max_limit;
  int use_field;
} MapList;

typedef struct
{
	char infile[MAX_FILENAME_SIZE];     
	int no_frames;                
	int ProfileIDC;               // profile idc
  	int LevelIDC;                 // level idc
	int img_width;                // image width
 	int img_height;               // image height
	int intra_period;             // Random Access period though intra
	int IDR_period;
	int num_ref_frames;           // number of reference frames to be used
	int NUM_REFS_FOR_P;
	int SliceMode;
	int SliceArgument;
	int successive_Bframe;        // number of B frames that will be used
	int jumpd;                    // number of frames to skip in input sequence (e.g 2 takes frame 0,3,6,9...)
	int directInferenceFlag;      // Direct Inference Flag
	int LFDisableIdc;
 	int LFAlphaC0Offset;
 	int LFBetaOffset;
	int symbol_mode;              // Specifies the mode the symbols are mapped on bits
	int PicInterlace;             // picture adaptive frame/field
	int Transform8x8Mode;
	int IntraMD8x8Disable;
	int IntraMD4x4Disable;
	int IntraMD4x4Weight;
	int IntraMD8x8Weight;
	int IntraMD16x16Weight;
 	int InterSearch16x8;
  	int InterSearch8x16;
  	int InterSearch8x8;
  	int DisableHpelME;
	int DisableQpelME;
	int MDInterWeightPPS;
	int MDIntraWeightPPS;
	int RandomIntraMBRefresh;     // Number of pseudo-random intra-MBs per picture
	int pad_ctrl_on;
	int luma_pad_val;
	int cb_pad_val;
	int cr_pad_val;
	///RC
	int enablefrmratecontrol;
	int enablembratecontrol;
	int FrameRate;
	int BitRate;
	u32 frame_qp;
	u32 b_frame_qp;
	u32 p_frame_qp;
	u32 qs_code_max;
  	u32 qs_code_min;
	u32 rf;
	u32 dark_disable;
	u32 smooth_disable;
	u32 static_disable;
	u32 act_disable;	
	int acd_intra_motion_en;	// enable motion estimation phase of intra picture
} InputParameters;

typedef struct {
	char ucInputFileName[MAX_FILENAME_SIZE];
	u32 m_uProfileLevel;
	u32 m_uNumberBFrames;
	u32 m_uSourceWidth;
	u32 m_uSourceHeight;
	u32 m_uFrameRate;
	u32 m_uFramesToBeEncoded;
	u32 m_uBitrate;
	u32 m_uFrameQp;
	u32 m_uPFrameQp;
	u32 m_uBFrameQp;
	u32 m_uDisableQpelME;
	u32 m_uIDRPeriod;
	u32 m_uRandomIntraMBRefresh;
	u32 m_uResyncEnable;
	u32 m_uResyncType;
	u32 m_uEnableFRMRateControl;
	u32 m_uEnableMBRateControl;
	u32 m_uQSCodeMax;
	u32 m_uQSCodeMin;
	u32 m_uCBRPeriodRf;
	u32 m_uDarkDisable;
	u32 m_uSmoothDisable;
	u32 m_uStaticDisable;
	u32 m_uActivityDisable;
	u32 m_uSliceArgument1;	
	u32 m_uSliceArgument2;
	u32 m_uEnableVopTiming;
	u32 m_uVopTimeResolution;
	u32 m_uFrameDelta;
}MapMpeg4Enc;

typedef struct {
	char ucInputFileName[MAX_FILENAME_SIZE];
	u32 m_uSourceResolution;
	u32 m_uSourceWidth;
	u32 m_uSourceHeight;
	u32 m_uFrameRate;
	u32 m_uFramesToBeEncoded;
	u32 m_uBitrate;
	u32 m_uFrameQp;
	u32 m_uIDRPeriod;
	u32 m_uRandomIntraMBRefresh;
	u32 m_uSliceMode;
	u32 m_uEnableFRMRateControl;
	u32 m_uEnableMBRateControl;
	u32 m_uQSCodeMax;
	u32 m_uQSCodeMin;
	u32 m_uCBRPeriodRf;	
}MapH263Enc;

typedef struct
{
	// File	
	char m_pInputFile[MAX_FILENAME_SIZE];
	char *m_pReconFile;
	char *m_pOutputFile;

	u32 m_uFramesToBeEncoded;
	u32 m_uTotalFramesToBeEncoded;
	u32 m_uSourceWidth;		// frame width
	u32 m_uSourceHeight;	// frame height
	
	// Encoder control
	u32 m_uProfileIDC;		// profile IDC
							// -basic profiles
							//   66=baseline, 77=main, 88=extended
							// -FREXT profiles
							//   100=high, 110=high 10, 122=high 4:2:2, 244=high 4:4:4, 44=CAVLC 4:4:4 Intra
	u32 m_uLevelIDC;		// level IDC (e.g. 20 = level 2.0)
	u32 m_uIDRPeriod;		// period of IDR pictures (e.g. 0 = only first 'I')
	u32 m_uNumberReferenceFrames;	// # of previous frames used for inter-motion search (0~16)
	u32 m_uNumberRefForPframes;	// # of reference picture for P frames (1~2)
	u32 m_uSliceMode;		// slice mode
							//  0=single slice in a picture
							//  1=divide slices by MB counts
							//  2=divide slices by bit counts
	u32 m_uSliceArgument;	// slice argument according to slice mode
	u32 m_uInterSearch16x8;	// P/B-slice inter block search 16x8 (0=disable, 1=enable)
	u32 m_uInterSearch8x16;	// P/B-slice inter block search 8x16 (0=disable, 1=enable)
	u32 m_uInterSearch8x8;	// P/B-slice inter block search 8x8 (0=disable, 1=enable)

	// B slices
	u32 m_uNumberBFrames;		// number of B coded frame inserted (0=not used)
	u32 m_uDirectInferenceFlag;	// direct inference flag (0:disable, 1:enable)
	
	// loop filter
	u32 m_uLoopFilterDisable;		// disable loop filter in slice header ( 0=filter, 1=no filter)
	s32 m_sLoopFilterAlphaC0Offset;	// alpha & C0 offset div. 2, (-6, -5, ..., -1, 0, +1, ..., +6)
	s32 m_sLoopFilterBetaOffset;	// beta offset div. 2, (-6, -5, ..., -1, 0, +1, ..., +6)

	// output control, NALs
	u32 m_uSymbolMode;		// symbol mode (entropy coding method : 0=CAVLC, 1=CABAC)

	// interlace handling
	u32 m_uPictureInterlace;	// 0=frame coding, 1=field coding

	// FREXT stuff
	u32 m_uTransform8x8Mode;	// 0=only 4x4 transform, 1=allow using 8x8 transform
								// (transform8x8 mode is allowed only in the High profile)

	// parameters for ME
	u32 m_uDisableHpelME;	// disable half-pixel motion estimation (0=off/default, 1=on)
	u32 m_uDisableQpelME;	// disable quarter-pixel motion estimation (0=off/deafult, 1=on)
	u32 m_uMDInterWeightPPS;
	u32 m_uMDIntraWeightPPS;
	u32 m_uRandomIntraMBRefresh;	// cyclic intra refresh

	// parameters for IMD
	// (parameters for generating stress test-bitstreams for the verificatioan of H.264 decoder  are eliminated 
	//  because they have nothing to do with encoder verification)
	u32 m_uIntraMD4x4Disable;
	u32 m_uIntraMD8x8Disable;
	u32 m_uIntraMD4x4Weight;
	u32 m_uIntraMD8x8Weight;
	u32 m_uIntraMD16x16Weight;

	// parameters for padding control
	u32 m_uPadControlOn;	// 1=enable, 0=disable padding with the specified values
							// if this feature is disabled, 
							// the boundary pixels are used to enlarge the picture
							// otherwise, LUMA_PAD_VAL, CB_PAD_VAL, CR_PAD_VAL are used.
	u32 m_uLumaPadVal;
	u32 m_uCbPadVal;
	u32 m_uCrPadVal;
	// parameters for Frame/Slice-level Control
	// (parameters for generating stress test-bitstreams for the verification of H.264 decoder are eliminated 
	// because they have nothing to do with encoder verification)


	// parameters for Rate Control
	u32 m_uEnableFRMRateControl;
	u32 m_uEnableMBRateControl;
	u32 m_uFrameRate;	// Frame Rate per second (0.1-100.0)
	u32 m_uBitrate;		// Bitrate(bps)
	u32 m_uFrameQp;
	u32 m_uPFrameQp;
	u32 m_uBFrameQp;
	u32 m_uQSCodeMax;
	u32 m_uQSCodeMin;
	u32 m_uCBRPeriodRf;
	u32 m_uDarkDisable;
	u32 m_uSmoothDisable;
	u32 m_uStaticDisable;
	u32 m_uActivityDisable;
	
	u32 m_uACDIntraMotionEn;

	u32 m_uEnableVopTiming;
	u32 m_uVopTimeResolution;
	u32 m_uFrameDelta;

	// mpeg4
	u32 m_uResyncEnable;
	u32 m_uResyncType;
}MFC_ENC_COFIG;

typedef struct
{
	u32 m_uProcessIdx;
	MFC_CMD_CH m_uCmdChType;
	u32 m_uADramDpbBufEndAddr[MAX_PROCESS_NUM]; 
	u32 m_uBDramDpbBufEndAddr[MAX_PROCESS_NUM];
	VIDEO_CODEC_TYPE m_eCodecMode[MAX_PROCESS_NUM];
	u32 m_uPicHsz[MAX_PROCESS_NUM];
	u32 m_uPicVsz[MAX_PROCESS_NUM];
	u32 m_uFrameHsz[MAX_PROCESS_NUM];
	u32 m_uFrameVsz[MAX_PROCESS_NUM];
	u32 m_uDramABaseAddr;
	u32 m_uDramADpbStAddr;
	u32 m_uDramBDpbStAddr;
	u32 m_uDramBBaseAddr;
	u32 m_uDramBaseAddr;
	u32 m_uCodecBufEndAddr;
	u32 m_uNumOfDpb;
	u32 m_uDisplayStatus[MAX_PROCESS_NUM];
	u32 m_uInstanceId[MAX_PROCESS_NUM];
	u32 m_uCpbBaseAddr[2]; 
	u32 m_uDescBaseAddr[2];
	u32 m_uFrameAddrY[MAX_PROCESS_NUM][MAX_DEC_FRAME];
	u32 m_uFrameAddrC[MAX_PROCESS_NUM][MAX_DEC_FRAME];
	u32 m_uFrameAddrMv[MAX_PROCESS_NUM][MAX_DEC_FRAME];
	u8 m_bIntFlag;
	u8 m_bOpenInstance;
	u8 m_bCloseInstance;
	u8 m_bCmdError;
	u8 m_bSeqDone;
	u8 m_bFrameDone[MAX_PROCESS_NUM];
	u8 m_bSliceDone[MAX_PROCESS_NUM];
	u8 m_bEncComplete[MAX_PROCESS_NUM];
	u8 m_bInitBufferDone;
	u8 m_bSleepDone;
	u8 m_bWakeupDone;
	u8 m_bSysInit;
	u8 m_bFwReady;
	u8 m_bEdfuInt[MAX_PROCESS_NUM];
	u8 m_bError;
	u8 m_bFatalErr;
	u8 m_bbEnableCrc;
	u32 m_uStreamBufAddr[MAX_PROCESS_NUM];
	u32 m_uEncABufEndAddr;
	u32 m_uEncBBufEndAddr;
	u32 m_uCurrLumaAddr[MAX_PROCESS_NUM][4];
	u32 m_uCurrChromaAddr[MAX_PROCESS_NUM][4];	
	u32 m_uConTextBufEndAddr;
	u32 m_uDescBufEndAddr;
	u32 m_uShardMemBufAddr[2];
	u32 m_uConTextBufAddr[MAX_PROCESS_NUM];
	u32 m_uConTextBufSize[MAX_PROCESS_NUM];
	u32 m_uDecCodecBufStAddr;
	u32 m_uFwBufEndAddr;
	u8 m_bDecFirstInstance;
	u32 m_uCurrReleaseIdx;
	u32 m_uCurrAddrState[MAX_PROCESS_NUM][4];
	u8 m_bLastImageEncoding[MAX_PROCESS_NUM];
	u8 m_bFirstImageEncoding[MAX_PROCESS_NUM];
}MFC;


void MFC_SetDramBDpbBufStAddr(u32 uDramBDpbBufAddr);
void MFC_ResetIp(void);
u8 MFC_GetDisplayFbAddr(u32* pDisplayAddrOfY, u32* pDisplayAddrOfC);
void MFC_LoadFirmwareIntoIp(u32 uDramABaseAddr, u32 uDramBBaseAddr);
void MFC_InitProcessForDecoding(u32 uProcessIdx, VIDEO_CODEC_TYPE eCodecMode, u8 bPixelCacheEn, u8 bMp4DeblkEn, u8 bCrcEn);
void MFC_ParseStreamHeaderAndSetBuf(MFC_CMD_CH_NUM eCmdCh, u32 uCpbBufStAddr, u32 uOneFrameSz);
void MFC_SetDecPixelCacheType(MFC_DEC_PIXEL_CACHE_TYPE ePixelCacheType);
void MFC_ParseStreamHeader(MFC_CMD_CH_NUM eCmdCh, u32 uCpbBufStAddr, u32 uOneFrameSz);
void MFC_GetDecCodecBufEndAddr(u32* pDecCodecBufEndAddr);
void MFC_SetDpbBuf(u32 uProcessIdx, u32 uBDpbBufStAddr, u32 uADpbBufStAddr);
void MFC_SendH2RCmd(MFC_FACADE_CMD eCmd, u32 uArg);
void MFC_SendH2RCmdWithFullArg(MFC_FACADE_CMD eCmd, u32 uArg1, u32 uArg2, u32 uArg3, u32 uArg4);
void MFC_GetOneMasterDpbBufEndAddr(u32 uProcessIdx, u32* pDpbBufEndAddr);
void MFC_GetDbpBufEndAddr(u32 uProcessIdx, u32* pADramDpbBufEndAddr, u32* pBDramDpbBufEndAddr);
void MFC_CloseInstance(u32 uInstanceId);
void MFC_SetProcessIdx(u32 uProcessIdx);
void MFC_InitBuffer(MFC_CMD_CH_NUM eCmdCh, u32 uProcessIdx);
void MFC_GetPicResolution(void);
void MFC_GetInstanceId(u32* pInstanceId, u32* pProcessIdx);
void MFC_GetRtnInstanceId(u32* pRtnInstId);
void MFC_ClearRtnInstance(void);
void MFC_GetDescriptorBufEndAddr(u32* pDescBufEndAddr);
void MFC_GetProcessIdxFromInstId(u32 uInstanceId, u32* pProcessIdx);
void MFC_GetInstIdFromProcessIdx(u32 uProcessIdx, u32* pInstanceId);
u8 MFC_GetPreparedChAndCpbBuf(MFC_CMD_CH_NUM* pChId, u32* pCpbBuf);
void MFC_GetIntFlag(MFC_FACADE_RESPONSE* eIntFlag);
void MFC_StartDecodingOneFrameOfTheBuffer(MFC_CMD_CH_NUM uCmdCh);
void MFC_StartDecodingOneFrame(MFC_CMD_CH_NUM eCmdCh, u32 uOneFrameSZ, MFC_DEC_TYPE eDecType);
u8 MFC_WaitForFrameDone(void);
void MFC_ClearR2HCmdRtn(void);
void MFC_ClearPending(void);
void MFC_GetErrorType(void);
void MFC_GetSharedMemRegBufEndAddr(u32 *pSharedMemRegBufEndAddr);
void MFC_GetDecodedFrmSize(u32* pConsumedbyteSize);
void MFC_SetSleepOrWakeUpMode(MFC_FACADE_CMD eH2RCmd);
void MFC_SetDecCodecBuf(u32 uDecCodecStAddr);
void MFC_GetPictureType(MFC_PIC_TYPE *ePicType, u8* bInterlace);
void MFC_GetImagePicSize(u32* pPicX, u32* pPicY);
void MFC_GetImageFrameSize(u32* pWidth, u32* pHeight);
u8 MFC_IsDecodingFinished(void);
u8 MFC_GetCodecType(char* fileExt, VIDEO_CODEC_TYPE* eCodecMode);
void MFC_GetCodecName(VIDEO_CODEC_TYPE eCodecMode, char* pCodecName);
void MFC_SetDivX311ImgSize(u32 Hsize, u32 Vsize);
void MFC_ParseConfigFile(u32 uConfigFileBufAddr);
void MFC_GetEncBufEndAddr(u32* pEncABufAddr, u32* pEncBBufAddr);
void MFC_SelectEncStandard(u32 uProcessIdx, VIDEO_CODEC_TYPE *eEncStandard);
void MFC_SetCodecStandard(u32 uProcessIdx, VIDEO_CODEC_TYPE eStandard);
void MFC_SetConfigParameters(void);
void MFC_CalculateTotalFramesToEnc(void);
void MFC_SetNumOfTotalDpbBuf(u32 uExtraDpbNum);
void MFC_GetMinNumOfDpbBuf(u32* pNumOfDpbBuf);
void MFC_SetDpbCfg(MFC_CMD_CH_NUM eCmdCh, u8 bIsSliceBaseDec, u8 bEnableCfgDelay, u32 uFrameNumOfDispDelay);
void MFC_CreateInstance(u32 uProcessIdx, VIDEO_CODEC_TYPE eCodec, u8 bPixelCacheEn, u32* pInstanceId);
void MFC_SetBufAddrOfEncoder(u32 uEncABaseAddr, u32 uEncBBaseAddr);
void MFC_InitProcessForEncoding(u32 uProcessIdx, VIDEO_CODEC_TYPE eEncCodec, u8 bPixelCacheEn, MFC_MB_LINEAR_TILE_MODE eLinearTileMode);
void MFC_GetEncStandard(u32 uProcessIdx, VIDEO_CODEC_TYPE *eStandard);
void MFC_GetInstanceIdFromIdx(u32 uProcessIdx, u32 *uInstanceId);
void MFC_GetEncFrameSizeCfg(u32* uPicWidth, u32* uPicHeight);
void MFC_GetEncNumOfFramesCfg(u32* uNumOfFrames);
void MFC_GetEncNumOfTotalFrames(u32* uNumOfTotalFrames);
void MFC_GetEncPicTypeCfg(u32* uNumberBFrames);
void MFC_GetInterlace(u32* uIsInterlace);
void MFC_GetIDRPeriod(u32* uIDR_period);
void MFC_GetEncFrameRate(u32* pFrameRate);
void MFC_GetBitRate(u32* pBitRate);
void MFC_GetGOP(u32* uGOP);
void MFC_GetSrcImgFileName(char *aFileName);
void MFC_ReleaseCurrentYCBuf(void);
u8 MFC_IsEncodingFinished(void);
void MFC_GetDispInfo(MFC_DISP_TYPE *eDispType, RESOL_CHANGE *eResChange, u8* bProgressive);
void MFC_GetEncCurrentYCBufAddr(u32 *pCurrLumeAddr, u32 * pCurrChromaAddr);
void MFC_GetDIspType(MFC_DISP_TYPE *eDispType);
void MFC_ConvertYuv420ToNv12OnlyCbCr(u32 uSrcAddrOfCbCr, u32 uPicHsz, u32 uPicVsz, u32 uDstAddrOfCbCr);
void MFC_EncodingOneFrame(MFC_DEC_TYPE eEncType);
void MFC_EncodingOneField(MFC_FILED_TYPE eEncFieldType, MFC_DEC_TYPE eEncType);
void MFC_GetEncBufEndAddr(u32* pEncABufAddr, u32* pEncBBufAddr);
void MFC_GetEncStrSzPerFrame(u32 *uEncStrSzPerFrame);
void MFC_GetFrameType(char **cFrameType);
void MFC_ReadEncOneFrameStream(u32 uDstAddr, u32 uSize);
void MFC_ParseConfigListFile(u32 uConfigListFileBufAddr, u32 *uCount);
void MFC_GetConfigFileFromList(u32 uIdx, char *pFileName);
void MFC_GetEncSteamBufAddr(u32* pStreamBufAddr);
u8 MFC_GeneratedCrcValue(u32* pNumOfCrc);
void MFC_SearchFrameIdxToEnc(u32 uFrameCount, u32* uFrameIdx);
void MFC_FrameIdxToBeLoaded(u32 uFrameCount, s32* sFrameIdx);
void MFC_GetEncYCBufAddrFromBufIdx(u32 uBufIdx, u32 *pCurrLumeAddr, u32 *pCurrChromaAddr);
void MFC_SetEncCurrentYCBufAddr(u32 uCurrLumeAddr, u32 uCurrChromaAddr);

int TILE_4x2_READ(unsigned char* pLinearImgStAddr, unsigned char* pTiledImgStAddr, int I_XSIZE, int I_YSIZE, int x_pos, int y_pos);
void Tile2Linear_4x2(unsigned char* pLinearImgStAddr, unsigned char* pTiledImgStAddr, unsigned int I_XSIZE, unsigned int I_YSIZE);
void SplitInterveneCbCr(unsigned char* pLinearCBufAddr, u32 uHsize, u32 uVsize, unsigned char* pCbStBufAddr, unsigned char* pCrStBufAddr);
void ConvertTiled4x2ToLinear(u32 uHsize, u32 uVsize, u32 uLumaSrcAddr, u32 uChromaSrcAddr, u32 uDstImgAddr, u32* uImgEndAddr);

#endif  // __MFC50_H__
