/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_util.h
* @module
          	Base header file for the utiltity functions of the MOREX II
* @purpose
			This file defines utility functions of the MOREX II
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/09/08
* @revision history
            2005/09/08 [YoungWon Yun]: First writing
*/
 
#ifndef __MOREX_UTIL_H__
#define __MOREX_UTIL_H__
 
#include "morex_types.h"
#include "morex_config.h"
#include <stdarg.h>
 
#include <string.h>
#include <time.h>
 
#define MOREX_memset(a, b, c)	memset((a), (b), (c))
#define MOREX_memcpy(a, b, c)	Copy8((UINT32)(b), (UINT32)(a), (UINT32)(c))
#define MOREX_sizeof(a)	sizeof((a))
 
#if (MOREX_BYTE_ORDER == MOREX_LITTLE_ENDIAN)
 
	#define TFFN_BO_int16(x)	(x)
	#define TFFN_BO_uint16(x)	(x)
	#define TFFN_BO_int32(x)	(x)
	#define TFFN_BO_uint32(x)	(x)
 
#else 
 
	#define TFFN_BO_int16(x)	((INT16) (0xffff & (((x) << 8) | (((x) >> 8) & 0xff))))
	#define TFFN_BO_uint16(x)	((UINT16) (0xffffU & (((x) << 8) | ((x) >> 8))))
 
	#define TFFN_BO_int32(x)	(((x) << 24) |  \
								(((x) <<  8) & 0x00ff0000) |   \
								(((x) >>  8) & 0x0000ff00) |   \
								(((x) >> 24) & 0x000000ff))
 
	#define TFFN_BO_uint32(x)	(((x) << 24) |  \
								(((x) <<  8) & 0x00ff0000U) |  \
								(((x) >>  8) & 0x0000ff00U) |  \
								((x) >> 24))
 
#endif 
 
 
#ifdef MOREX_DEBUG
	#ifndef __FUNCTION__
		#if (__CC_ARM == 1)
			#define __FUNCTION__ __func__ 
		#else
			#define __FUNCTION__	"[]"
		#endif
	#endif
#endif
 
#ifdef MOREX_DEBUG
	#define TFFN_Print_Log(msg) \
			TFFN_Debug_Msg(msg, __FILE__, __LINE__, __FUNCTION__)
#else
	#define	TFFN_Print_Log(msg)	NULL
#endif	
 
 
extern INT32	TFFN_Strncmp(UINT8* szStr1, UINT8* szStr2, UINT32 nSize);
extern INT32	TFFN_Mstricmp(UINT8* szStr1, UINT8* szStr2, INT32 nLength);
 
extern INT32	TFFN_Strlen(UINT8* szStr);
extern INT32	TFFN_Mstrlen(UINT8* szStr);
extern VOID		TFFN_ToUpperCase(UINT8* szStr1, UINT32	nLength);
extern VOID		TFFN_ToLowerCase(UINT8* szStr1, UINT32	nLength);
extern INT32	TFFN_Multi2Single(UINT8* szStr1, UINT8* szStr2);
extern INT32	TFFN_Single2Multi(UINT8* szStr1, UINT8* szStr2);
 
extern INT32	TFFN_Log2(UINT32 nValue);
extern UINT32	TFFN_Cdiv(UINT32 nNumber, UINT32 nDenom);
 
extern INT32	TFFN_TO_Upper(INT32 nValue);
extern INT32	TFFN_TO_Lower(INT32 nValue);
 
 
extern INT32		TFFN_get_char(void);
extern INT32		TFFN_get_int(void);
extern INT32		TFFN_gets(UINT8* pBuff);
extern VOID		TFFN_printf(const INT8* pFmt, ...);
 
 
 
 
 
extern struct tm*   TFFN_localtime(void);
extern VOID         TFFN_get_time(UINT16* pwDate, UINT16* pwTime);
 
 
 
 
 
 
 
extern time_t       TFFN_time(time_t* tloc);
 
 
extern INT32	TFFN_Memory_Init(void);
extern VOID*	TFFN_Memory_Alloc(UINT32 nSize);
extern VOID		TFFN_Memory_Free(VOID* szMem);
 
extern VOID	TFFN_Debug_Msg(const INT8* stMsg, const INT8* stFileName, INT32 nLineNumber, const INT8* stFuncName);

#endif /* __MOREX_UTIL_H__ */
 
