/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_types.h
* @module
          	Base header file for the types of the MOREX II
* @purpose
			This file defines basic types of the MOREX II
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/09/08
* @revision history
            2005/09/08 [YoungWon Yun]: First writing
*/
 
#ifndef __MOREX_TYPES_H__
#define __MOREX_TYPES_H__
 
 
 
#define MOREX_OK			0x00000000		
#define MOREX_ERROR			-0x00000001	
#define MOREX_ENOTEXIST		-0x00000002	
#define MOREX_EIO			-0x00000003	
#define MOREX_EINVALID		-0x00000004	
#define MOREX_EOF			-0x00000005	
 
#define	true				1
#define	false				0
 
#ifndef __UINT32
#define	__UINT32
typedef	unsigned int		UINT32;
#endif

#ifndef __INT32
#define	__INT32
typedef signed int			INT32;
#endif

#ifndef __UINT16
#define	__UINT16
typedef	unsigned short	UINT16;
#endif

#ifndef __INT16
#define	__INT16
typedef	signed short		INT16;
#endif

#ifndef __UINT8
#define	__UINT8
typedef	unsigned char		UINT8;
#endif

#ifndef __INT8
#define	__INT8
typedef	signed char		INT8;
#endif

#ifndef __BOOL32
#define	__BOOL32
typedef	UINT32		BOOL32;
#endif
#if 0//!defined(MOREX_NO_BASIC_TYPES)
	typedef	unsigned int		UINT32;
	typedef signed int			INT32;
	typedef unsigned short		UINT16;
	typedef signed short		INT16;
	typedef unsigned char		UINT8;
	typedef signed char 		INT8;
	typedef UINT32					BOOL32;
#endif
 
#if 1
#ifndef VOID
#define VOID                    void
#endif
#else
#ifndef __VOID
#define	__VOID
typedef void					VOID;
#endif
#endif

typedef struct
{
	UINT32	nIsDir;						
	UINT32	nParentCluster;				
	UINT32	nParentClusterStart;		
	UINT32	nParentClusterOffset;		
	UINT32	nMyCluster;					
	UINT32	nMyClusterCurrentStart;		
	UINT32	nMyClusterCurrentOffset;	
	UINT32	nSize;						
	UINT32	nOffset;					
	UINT32	bFlag_8_3_format;			
	INT32	nLFNEntsNumber;				
	UINT32	nFreeEntryIndexOffset;		
	UINT32	nFreeEntryNumber;			
} t_file_handler;
 
typedef struct
{
	UINT32	nFATType;					
	UINT32	nTotalClusters;				
	UINT32	nSectorPerCluster;			
	UINT32	nTotalFreeClusters;			
} t_statfs;
 
#endif /* __MOREX_TYPES_H__ */
 
