/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_tty.c
* @module
          	Source file for tty functions of the MOREX II
* @purpose
			This file defines tty functions of the MOREX II
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/10/25
* @revision history
            2005/10/25 [YoungWon Yun]: First writing
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
 
#include "morex_types.h"
#include "morex_tty.h"
#include "morex_util.h"
 
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
 
//extern VOID UARTSendString(INT32 nTemp, UINT8 *szString);
//extern INT32 UARTGetString(INT32 nTemp, UINT8 *szString);
 
#ifdef __cplusplus
};
#endif // __cplusplus
 
/**
* 
* Get a character
*
* @param		VOID
* @return		character
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32
TFFN_get_char(VOID)
{
    INT32 i;
 
    UINT8	psCommand[128];
 
//    UARTGetString(0, psCommand);
    i = psCommand[0];
 
    return i;
}
 
/**
* 
* Get int value
*
* @param		VOID
* @return		int value
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32
TFFN_get_int(VOID)
{
	UINT8  szBuff[32];
    INT32 nIdx;
    
//    UARTGetString(0, szBuff);
 
    nIdx = (INT32)atol((const char *)szBuff);
    return nIdx;
}
 
 
/**
* 
* Get a string from STDIN
*
* @param		pBuff		buffer pointer
* @return		number of chars on success
				< 0			Failure
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32 
TFFN_gets(UINT8 *pBuff)
{
    INT32 r;
 
 //   UARTGetString(0, pBuff);
 
    r = TFFN_Strlen(pBuff);
    if (r > 0)
    {
        if (pBuff[r - 1] == '\n')
        {
            pBuff[r - 1] = '\0';
            r--;
        }
    }
    return r;
}
 
static UINT8 string[2048];
/**
* 
* Print a string to UART
*
* @param		fmt			print format string
				...			parameters
* @return		number of chars on success
				0 <			Failure
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
VOID 
TFFN_printf(const INT8 *pFmt, ...)
{
    va_list ap;
    va_start(ap, pFmt);
 
    vsprintf((char *)string, (const char *)pFmt, ap);
//    UARTSendString(0, string);
    va_end(ap);
}
 
 
 
 
 
 
 
 
 
 
 
 
 
