/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_time.h
* @module
          	Source file for time functions of the MOREX II
* @purpose
			This file defines time functions of the MOREX II
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/10/25
* @revision history
            2005/10/25 [YoungWon Yun]: First writing
*/
 
#include <stdio.h>
#include <ctype.h>
 
 
#include "morex_types.h"
#include "morex_time.h"
#include "morex_util.h"
 
 
// static time_t	nSetTime = 0xCCCC;	
 
/**
* 
* Return local time
*
* @param		VOID
* @return		struct tm pointer
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
struct tm *
TFFN_localtime(VOID)
{
	time_t time_data;
	
	time_data = TFFN_time(&time_data);
	return localtime(&time_data);
}
 
/**
* 
* Get current date/time in FAT format
*
* @param		tv			timeval pointer
				nDate		Date
				nTime		Time
* @return		VOID
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
VOID
TFFN_get_time(UINT16 *nDate, UINT16 *nTime)
{
    struct tm *pTime;
 
    pTime = TFFN_localtime();
 
    *nDate = (UINT16) (((pTime->tm_year + 1900 - MOREX_MSDOS_EPOCH) << 9) |
                                ((pTime->tm_mon + 1) << 5) | pTime->tm_mday);
    *nTime = (UINT16) ((pTime->tm_hour << 11) | (pTime->tm_min << 5) | (pTime->tm_sec >> 1));
 
}
/**
* 
* Get system time
*
* @param		*tloc		pointer to the storage location for time
* @return		number of seconds elapsed since midnight (00:00:00), January 1, 1970,
				coordinated universal time (UTC)
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
time_t 
TFFN_time(time_t *tloc)
{
	time_t	nCurTime;

//	Implement time function here 
//	nCurTime = nSetTime + (NU_Retrieve_Clock() / 1000);

	if (tloc != NULL)
	{
		*tloc = nCurTime;
	}
 
	return (nCurTime);
}
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
