/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_pdev.h
* @module
          	Template of Physical Device Driver 
* @purpose
			This file defines Physical Device Driver Interface of the MOREX II  
* @author
            developer
* @date
            
* @revision history
            
*/
 
#ifndef __MOREX_PDEV_H__
#define __MOREX_PDEV_H__
 
typedef enum 
{
	DIAG_STORAGE_NAND =  0,
	DIAG_STORAGE_ATA,
	DIAG_STORAGE_CEATA,
	DIAG_STORAGE_SD_CARD,
	DIAG_STORAGE_RAM
}DIAGStorage_t;

typedef enum
{
	SP_OK,
	SP_ERROR
}spErrorCode_t;


/****************************************************************/
/*				header files to be included						*/
/****************************************************************/
#include "morex_types.h"
 
/****************************************************************/
/*				functions to be exported						*/
/****************************************************************/
extern INT32	TFFN_Pdev_Init(UINT32 *nTotalSectors);
extern INT32	TFFN_Pdev_Open(VOID);
extern INT32	TFFN_Pdev_Close(VOID);
 
extern INT32	TFFN_Pdev_ReadSectors(UINT32	nSecNum,
									 UINT32		nReadCount, 
									 UINT8		*pBuff);								
 
extern INT32	TFFN_Pdev_WriteSectors(UINT32	nSecNum,
									  UINT32	nWriteCount,
									  UINT8		*pBuff);
 
#endif	
