/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_pdev.h
* @module
          	Physical Device Driver 
* @purpose
			This file defines Physical Device Driver Interface of the MOREX II  
* @author
            developer
* @date
            
* @revision history
 - 2007-APR-07 include the _USE_ATA define(jy43.seo@samsung.com)            
*/

#define MOREX_NO_BASIC_TYPES
#include "morex_pdev.h"
#include "v210_sfr.h"
#include "morex_iobuffer.h"
#include "morex_util.h"

/************************************************************************/
/*						Global Variable									*/
/************************************************************************/
DIAGStorage_t	MOREX_STORAGE_TYPE = DIAG_STORAGE_SD_CARD;

/************************************************************************/
/*						Extern Variable									*/
/************************************************************************/
 
/************************************************************************/
/*						Local Definition								*/
/************************************************************************/
 
/************************************************************************/
/*						Local typedef									*/
/************************************************************************/
//#define _USE_RAM	/* boot code size is not enough to include RAM Disk files*/
#define _SDIO_VER_1_
#ifdef _SDIO_VER_1_
#include "Sdhc.h"
SDHC SDDevice;
#endif
#ifdef _ATA_VER_X_
#undef _ATA_VER_1_
#endif
/************************************************************************/
/*						Local Functions									*/
/************************************************************************/
#define MBR_PARTITION_NUM 4
#define MOREX_PDEV_SECTOR_SIZE	512

// Little Endian value caculation
#define LSB_GET_4BYTES(x) ((*((x)+3)) << 24) | ((*((x)+2)) << 16) | \
                            ((*((x)+1)) << 8) | ((*((x))))
#define LSB_GET_3BYTES(x) ((*((x)+2)) << 16) | \
                            ((*((x)+1)) << 8) | ((*((x))))
#define LSB_GET_2BYTES(x) ((*((x)+1)) << 8 ) | ((*((x))))
//#define UNICODEtOCHAR(x)    ((*((x)+1)) << 16) | ((*((x))))
#define UNICODEtOCHAR(x)    ((*((x)+1)) << 16) | ((*((x))))


#define LSB_SET_4BYTES(p, x)    { *((p)+3)= 0x0ff&(x>>24) ;      \
                                *((p)+2) = 0x0ff&(x>>16);        \
                                *((p)+1) = 0x0ff&(x>>8);         \
                                *(p) = 0x00ff&x;  }
#define LSB_SET_3BYTES(p, x)    { *((p)+2) = 0xff&(x>>16);      \
                                *((p)+1) = 0xff&(x>>8);         \
                                *(p) = 0xff&x;  }
#define LSB_SET_2BYTES(p, x)    { *((p)+1) = 0xff&(x>>8);       \
                                *(p) = 0xff&x;  }

#define UNICODE2CHAR(x) (char)(x&0xff)
#define CHAR2UNICODE(x) (UNICODE)x&0x00ff 

typedef struct partitionStruct
{
    u8 bBootIndicator;
    u8 bStartingHeader;
    u16 wStartingSectorAndCylinder;
    u8 bSystemID;
    u8 bEndingHeader;
    u16 wEndingSectorAndCylinder;
    u32 dwRelativeSector;
    u32 dwTotalSector;
} PARTITION, * PPARTITION;

static PARTITION partition[MBR_PARTITION_NUM];
static int SelectedPartitionIndex;

extern UINT32			*gaBuffer;

bool static FAT_GetPartition()
{
	u8 *buf = (u8 *)gaBuffer;
	int i;
	int a;
	u32 j;

//	FAT_ReadSector(0,(u32 *)buf);
	SDHC_ReadBlocks(0, 1, (u32)buf, &SDDevice);
	
	for(i=0;i<MBR_PARTITION_NUM;i++)
	{
		a = 0x01be;
		partition[i].bBootIndicator = buf[a+i*16];

		partition[i].bStartingHeader = buf[0x1bf+i*16];
		partition[i].wStartingSectorAndCylinder = LSB_GET_2BYTES(buf+0x1c0+i*16);
		partition[i].bSystemID = buf[0x1c2+i*16];
		partition[i].bEndingHeader = buf[0x1c3+i*16];
		partition[i].wEndingSectorAndCylinder = LSB_GET_2BYTES(buf+0x1c4+i*16);
		partition[i].dwRelativeSector = LSB_GET_4BYTES(buf+0x1c6+i*16);
		partition[i].dwTotalSector = LSB_GET_4BYTES(buf+0x1ca+i*16);

		if(partition[i].bSystemID==0xb || partition[i].bSystemID==0xc)
		{
			SelectedPartitionIndex = i;
		
			Disp("BootIndicator =0x%x SystemID=0x%x PartitionStartSector=%d TotalSector=%d-> TotalSize=%uKBytes\n",
				partition[i].bBootIndicator,partition[i].bSystemID,partition[i].dwRelativeSector,
				partition[i].dwTotalSector,partition[i].dwTotalSector/(1024/MOREX_PDEV_SECTOR_SIZE));

			return true;
		}
	}

	Disp("There is no partition table\n");
	
	partition[0].bStartingHeader = 0;
	partition[0].wStartingSectorAndCylinder = 0;
	partition[0].bSystemID = 0;
	partition[0].bEndingHeader = 0;
	partition[0].wEndingSectorAndCylinder = 0;
	partition[0].dwRelativeSector = 0;
	partition[0].dwTotalSector = 0;

	SelectedPartitionIndex=0;

  	for(j= 0; j< 512; j++)
	{
		SDHC_ReadBlocks(j, 1, (u32)buf, &SDDevice);
		if((buf[0x36] == 'F' && buf[0x37] == 'A' && buf[0x38] == 'T') ||(buf[0x52] == 'F' && buf[0x53] == 'A' && buf[0x54] == 'T'))
		{
			partition[0].bStartingHeader = 0;
			partition[0].wStartingSectorAndCylinder = 0;
			partition[0].bSystemID = 0;
			partition[0].bEndingHeader = 0;
			partition[0].wEndingSectorAndCylinder = 0;
			partition[0].dwRelativeSector = j;
			partition[0].dwTotalSector = 0;	
			break;
		}
	}
	return false;
}

 
INT32
TFFN_Pdev_Init(UINT32 *nTotalSectors)
{
	DIAGStorage_t	eType;
	INT32			n32Status = MOREX_OK;
	
	eType = MOREX_STORAGE_TYPE;
	alloc_MorexBuffer();
	switch(eType)
	{
#if defined(_NAND_VER_1_)
	case DIAG_STORAGE_NAND:
		if (NAND_Init(nTotalSectors) != SP_OK)
		{
			n32Status = MOREX_ERROR;
		}
	break;
#endif
#if (TARGET_FOR_ISRAM != 1)
#ifdef _ATA_VER_1_	
	case DIAG_STORAGE_ATA:
		if (ATA_Init(ATA_HAL_UDMA, ATA_GetMaxMode(ATA_HAL_UDMA)) != SP_OK)
		{
			n32Status = MOREX_ERROR;		
		}

		*nTotalSectors = ATA_GetTotalSectors();
	break;
#endif
#if defined(_CEATA_VER_1_) || defined(_CEATA_VER_2_)
	case DIAG_STORAGE_CEATA:
		if(CEATA_Init() != SP_OK)
		{
			n32Status = MOREX_ERROR;
		}

		*nTotalSectors = CEATA_GetTotalSectors();
	break;
#endif
#if defined(_SDIO_VER_1_) || defined(_SDIO_VER_2_) || defined(_SDIO_VER_3_)
	case DIAG_STORAGE_SD_CARD:
/* SD INIT */
		SDDevice.m_uBaseAddr = (u8 *)HSMMC0_BASE;	/*SD MMC base address */
		SDDevice.m_eOpMode = SDHC_SDMA_MODE;
		SDDevice.m_uClockDivision = 4;
		//SDDevice.m_eOpMode = SDHC_POLLING_MODE;
		SDHC_OpenMedia(1, &SDDevice);
//		if(false == FAT_GetPartition())
//			n32Status = MOREX_ERROR;
		if(true == FAT_GetPartition())
		{
			*nTotalSectors = partition[SelectedPartitionIndex].dwTotalSector;
		}else
		{
		*nTotalSectors = ((u32)(1<<SDDevice.m_sReadBlockLen))*(SDDevice.m_sCSize+1)*(1<<(SDDevice.m_sCSizeMult+2))/512;
		}
/* SD Get sectors */
//		*nTotalSectors = 0x200000;
	break;
#endif
#ifdef _USE_RAM
	case DIAG_STORAGE_RAM:
		if(RAM_INIT() != SP_OK)
		{
			n32Status = MOREX_ERROR;
		}

		*nTotalSectors = RAM_GetTotalSectors();
	break;
#endif
#endif //(TARGET_FOR_ISRAM != 1)
	default:
		n32Status = MOREX_ERROR;
	break;
	}

	return n32Status;
}
 
INT32
TFFN_Pdev_Open(VOID)
{
	return MOREX_OK;
}
 
INT32
TFFN_Pdev_Close(VOID)
{
	free_MorexBuffer();
	return MOREX_OK;
}
 
INT32
TFFN_Pdev_ReadSectors(UINT32	nSecNum,
					 UINT32		nReadCount, 
					 UINT8		*pBuff)
{
	DIAGStorage_t	eType;
	INT32			n32Status = MOREX_OK;
	u8 *buf = (u8 *)gaBuffer;
	u32 i;
	
#if (TARGET_FOR_ISRAM != 1)
#ifdef _ATA_VER_1_	
	spErrorCode_t		u32Err;
#endif
#if defined(_CEATA_VER_1_) || defined(_CEATA_VER_2_) || defined(_CEATA_VER_3_)
	spErrorCode_t		u32Err1;
#endif
#if defined(_SDIO_VER_1_) || defined(_SDIO_VER_2_) || defined(_SDIO_VER_3_)
	spErrorCode_t		u32Err2;
#endif
#ifdef _USE_RAM
	spErrorCode_t		u32Err3;
#endif
#endif// (TARGET_FOR_ISRAM != 1)

	eType = MOREX_STORAGE_TYPE;
	switch(eType)
	{
#if defined(_NAND_VER_1_)
	case DIAG_STORAGE_NAND:
		n32Status = FTL_Read(nSecNum, nReadCount, pBuff);
		if(n32Status != FTL_SUCCESS)
		{
			n32Status = MOREX_EIO;
		}
	break;
#endif
#if (TARGET_FOR_ISRAM != 1)
#ifdef _ATA_VER_1_	
	case DIAG_STORAGE_ATA:
		u32Err = ATA_ReadLBA(nSecNum, nReadCount, pBuff);
		if (u32Err != SP_OK) 
		{
			n32Status = MOREX_EIO;
		}
	break;
#endif
#if defined(_CEATA_VER_1_) || defined(_CEATA_VER_2_)
	case DIAG_STORAGE_CEATA:
		u32Err1 = CEATA_ReadLBA(nSecNum, nReadCount, pBuff, 0);
		if(u32Err1 != SP_OK)
		{
			n32Status = MOREX_EIO;
		}
	break;
#endif
#if defined(_SDIO_VER_1_) || defined(_SDIO_VER_2_) || defined(_SDIO_VER_3_)
	case DIAG_STORAGE_SD_CARD:
		if(((u32)pBuff) % 4)
		{
			for(i = 0; i < nReadCount; i++)
			{
				if(0 == SDHC_ReadBlocks(i + nSecNum + (partition[SelectedPartitionIndex].dwRelativeSector), 1, (u32)buf, &SDDevice))
					n32Status = MOREX_ERROR;
				MOREX_memcpy(pBuff + (i * 512),  buf, 512);
			}

		}else
		{
		if(0 == SDHC_ReadBlocks(nSecNum + (partition[SelectedPartitionIndex].dwRelativeSector), nReadCount, (u32)pBuff, &SDDevice))
				n32Status = MOREX_ERROR;
		}
	break;
#endif
#ifdef _USE_RAM
	case DIAG_STORAGE_RAM:
		u32Err3 = RAM_ReadLBA(nSecNum, nReadCount, pBuff);
		if(u32Err3 != SP_OK)
		{
			n32Status = MOREX_ERROR;
		}
	break;
#endif
#endif// (TARGET_FOR_ISRAM != 1)

	default:
		n32Status = MOREX_EIO;
	break;
	}

	if(n32Status == MOREX_OK)
	{			
    		return (INT32)nReadCount;
	}
	else
	{
		return n32Status;
	}
}
 
INT32
TFFN_Pdev_WriteSectors(UINT32	nSecNum,
					  UINT32	nWriteCount,
					  UINT8		*pBuff)
{
	DIAGStorage_t	eType;
	INT32			n32Status = MOREX_OK;

#if (TARGET_FOR_ISRAM != 1)
#ifdef _ATA_VER_1_	
	spErrorCode_t		u32Err;
#endif
#if defined(_CEATA_VER_1_) || defined(_CEATA_VER_2_) || defined(_CEATA_VER_3_)
	spErrorCode_t		u32Err1;
#endif
#if defined(_SDIO_VER_1_) || defined(_SDIO_VER_2_) || defined(_SDIO_VER_3_)
	spErrorCode_t		u32Err2;
#endif
#ifdef _USE_RAM
	spErrorCode_t		u32Err3;
#endif
#endif// (TARGET_FOR_ISRAM != 1)

	eType = MOREX_STORAGE_TYPE;
	switch(eType)
	{
#if defined(_NAND_VER_1_)
	case DIAG_STORAGE_NAND:
		n32Status = FTL_Write(nSecNum,	nWriteCount, pBuff);		
		if(n32Status != FTL_SUCCESS)
		{
			n32Status =  MOREX_EIO;
		}
	break;
#endif
#if (TARGET_FOR_ISRAM != 1)
#ifdef _ATA_VER_1_		
	case DIAG_STORAGE_ATA:
		u32Err = ATA_WriteLBA(nSecNum, nWriteCount, pBuff);
		if (u32Err != SP_OK) 
		{
			n32Status =  MOREX_EIO;
		}
	break;
#endif
#if defined(_CEATA_VER_1_) || defined(_CEATA_VER_2_) 
	case DIAG_STORAGE_CEATA:
		u32Err1 = CEATA_WriteLBA(nSecNum, nWriteCount, pBuff, 0);
		if(u32Err1 != SP_OK)
		{
			n32Status =  MOREX_EIO;
		}
	break;
#endif
#if defined(_SDIO_VER_1_) || defined(_SDIO_VER_2_) || defined(_SDIO_VER_3_)
	case DIAG_STORAGE_SD_CARD:
		if(0 == SDHC_WriteBlocks(nSecNum + (partition[SelectedPartitionIndex].dwRelativeSector), nWriteCount, (u32)pBuff, &SDDevice))
			n32Status = MOREX_ERROR;;
	break;
#endif
#ifdef _USE_RAM
	case DIAG_STORAGE_RAM:
		u32Err3 = RAM_WriteLBA(nSecNum, nWriteCount, pBuff);
		if(u32Err3 != SP_OK)
		{
			n32Status = MOREX_ERROR;
		}
	break;
#endif
#endif // (TARGET_FOR_ISRAM != 1)
	default:
		n32Status =  MOREX_EIO;
	break;
	}
 
	if(n32Status == MOREX_OK)
	{
		return nWriteCount;
	}
	else
	{
		return n32Status;
	}
}
