/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_memory.h
* @module
          	source file for memory functions of the MOREX II
* @purpose
			This file defines memory functions of the MOREX II
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/10/25
* @revision history
            2005/10/25 [YoungWon Yun]: First writing
*/
 
#include <stdio.h>
#include <ctype.h>
 
#include "morex_types.h"
#include "morex_memory.h"
 
static UINT32 bIsMemoryInitialized = false;
 
/**
* 
* Memory Initialize
*
* @param		VOID
* @return		0			Success
				> 0			Failure
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32
TFFN_Memory_Init(VOID)
{
	if (bIsMemoryInitialized == true)
	{
		return MOREX_OK;
	}

	/* Initialize Memory here */
	
    bIsMemoryInitialized = true;
 
    return MOREX_OK;
}
 
 
/**
* Memory Allocation
*
* @param		nSize		Moemory allocation size
* @return		VOID
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
VOID *
TFFN_Memory_Alloc(UINT32 nSize)
{
    VOID *szMem;

	/* Allocate Memory here */
	    
    szMem = NULL;
	
    return szMem;
}
 
/**
* 
* Deallocate memory
*
* @param		*szMem		Memory pointer to free
* @return		VOID
* @author		Young Won Yun (youngwon.yun@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
VOID
TFFN_Memory_Free(VOID *szMem)
{
	/* Free Memory here */
}
