/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_fat.h
* @module
          	FAT core
* @purpose
			This file defines FAT core of the MOREX II  
* @author
            Young Won Yun (youngwon.yun@samsung.com)
* @date
            2005/09/08
* @revision history
            2005/09/08 [YoungWon Yun]: First writing
*/
 
#ifndef __MOREX_FAT_H__
#define __MOREX_FAT_H__
 
#include "morex_types.h"
#include "morex_config.h"
 
#define MOREX_FAT16		1
#define MOREX_FAT32		2
#define MOREX_FAT16_RESERVED	0x0000fff0       /* start of reserved value range */
#define MOREX_FAT16_DEFECT		0x0000fff7       /* cluster w. defective block */
#define MOREX_FAT16_EOF			0x0000fff8       /* start of EOF range */
#define MOREX_FAT16_END			0x0000ffff       /* end of reserved range */
 
#define MOREX_FAT32_RESERVED	0x0ffffff0   /* start of reserved value range */
#define MOREX_FAT32_DEFECT		0x0ffffff7   /* cluster w. defective block */
#define MOREX_FAT32_EOF			0x0ffffff8   /* start of EOF range */
#define MOREX_FAT32_END			0x0fffffff   /* end of reserved range */
 
#define FAT16_CLUSTER_PER_SECTOR		256
#define FAT16_CLUSTER_PER_SECTOR_BITS	8
 
#define FAT32_CLUSTER_PER_SECTOR		128
#define FAT32_CLUSTER_PER_SECTOR_BITS	7
 
#define MOREX_MAX_FILE_SIZE		2147483647		
#define MOREX_SECTOR_SIZE		512				
#define	MOREX_SECTOR_SIZE_BITS	9				
#define MOREX_SECTOR_SIZE_MASK	(MOREX_SECTOR_SIZE - 1)
 
 
#define MOREX_ATTR_READ_ONLY	0x01
#define MOREX_ATTR_HIDDEN		0x02
#define MOREX_ATTR_SYSTEM		0x04
#define MOREX_ATTR_VOLUME		0x08
#define MOREX_ATTR_DIRECTORY	0x10
#define MOREX_ATTR_ARCHIVE		0x20
 
#define MOREX_ATTR_LONG_NAME	0x0F	
#define MOREX_LONG_NAME_MASK	0x3F	
 
#define MOREX_LAST_LONG_ENTRY		0x40
 
 
#define MOREX_OPEN_MODE			1
#define MOREX_CREATE_MODE		2
 
#define MOREX_DIR_NAME_MAX_LENGTH		244
#define MOREX_FILE_NAME_MAX_LENGTH	255
#define MOREX_PATH_NAME_MAX_LENGTH	255		
 
#define MOREX_DIR_SIZE_MAX		(32 * 65536)
 
#define	MOREX_SEEK_SET				0
#define	MOREX_SEEK_CUR				1
#define	MOREX_SEEK_END				2
 
#define MOREX_EEOC				-0x00000001		
#define MOREX_FAT_CHAIN_CONT	-0x00000002		
 
#define MOREX_2BYTE_ALIGN		2		
#define MOREX_2BYTE_ALIGN_MASK	(MOREX_2BYTE_ALIGN - 1)
#define MOREX_4BYTE_ALIGN		4		
#define MOREX_4BYTE_ALIGN_MASK	(MOREX_4BYTE_ALIGN - 1)
 
#define MOREX_DIR_ENTRY_PER_SECTOR		16
#define MOREX_DIR_ENTRY_PER_SECTOR_BITS	4
#define MOREX_DIR_ENTRY_PER_SECTOR_MASK	(MOREX_DIR_ENTRY_PER_SECTOR - 1)

#define ATT_DIRECTORY 0x10


#define ATT_DIR 1
#define ATT_FILE 0

 
/* type definition */
typedef struct
{
	UINT8	aDirName[11];
	UINT8	nDirAttr;
	UINT8	nDirNTRes;
	UINT8	nDirCtrTimeTenth;
	UINT16	nDirCrtTime;
	UINT16	nDirCrtDate;
	UINT16	nDirLstAccDate;
	UINT16	nDirFstClusHi;
	UINT16	nDirWrtTime;
	UINT16	nDirWrtDate;
	UINT16	nDirFstClusLo;
	UINT32	nDirFileSize;
} t_dir_entry;
 
typedef struct
{
	UINT8	nDirOrd;
	UINT8	szName1[10];
	UINT8	nDirAttr;
	UINT8	nDirLongType;
	UINT8	nDirChecksum;
	UINT8	szName2[12];
	UINT16	nFstClusLo;
	UINT8	szName3[4];
} t_dir_entry_long;
 
typedef struct
{
	t_dir_entry		aDirEnts[16];	
	UINT32			nCurCluster;
	UINT32			nCurSector;
	BOOL32			bChanged;		
} t_dir_entries;
 
typedef struct
{
	UINT32	nFATType;				
	UINT32	nReservedSect;			
 
	UINT32	nTotalSectors;			
	UINT32	nTotalClusters;			
	UINT32	nSectorPerClt;			
	UINT32	nSectorPerCltBits;		
	UINT32	nSectorPerFAT;			
	
	UINT32	nFAT1Addr;				
	UINT32	nFAT2Addr;				
 
	UINT32	nRootCluster;			
	UINT32 	nROOTAddr;				
	UINT32	nDATAAddr;				
	UINT32	nFirstRootAddr;			
 
	UINT32	nEndCltMask;			
	UINT32	nClusterPerSector;		
	UINT32	nClusterPerSectorBits;	
} t_volume_info;
 
typedef struct
{
	UINT8		sJmpBoot[3];		// Jump Instruction to boot code
									// 0xEB, 0x??, 0x90 or 0xE9, 0x??, 0x??
	UINT8		sOemName[8];		// OEM Name "MSWIN4.1"
	UINT8		nBytesPerSec[2];	// bytes per sector, 512, 1024, 2048, 4096 are possible
	UINT8		nSectorsPerClus;	// number of sectors per allocation unit
									// must be power of two: 1, 2, 4, ..., 128
									// nBytesPerSec * nSectorsPerClus <= 32 KB
	UINT16		nRsvdSecCnt;		// FAT12, FAT16 --> 1, FAT32 > 0, normally 32
	UINT8		nNumFATs;			// number of FAT data structure on the volume. 2 is recommended
	UINT8		nRootEntCnt[2];		// FAT12, FAT16 --> the count of 32-byte directory entries
									// nBytesPerSec x even = nRootEntCnt * 32
									// FAT16 --> 512
									// FAT32 --> 0
	UINT8		nTotSec16[2];		// old 16-bit total count of sectors on the volume
									// 0 --> TotSec32 should be non-zero
									// FAT32 --> 0
									// > 0 and fits --> TotSec32 = 0
	UINT8		bMedia;				// 0xF8 --> fixed, 0xF0 --> removable
	UINT16		nFATSz16;			// count of sectors occupied by one FAT. FAT32 --> 0
	UINT16		nSecPerTrack;		// sectors per track
	UINT16		nNumHeads;			// number of heads
	UINT32		nHiddSec;			// count of hidden sectors preceding the partition that
									// contains this FAT volume
	UINT32		nTotSec32;			// 32-bit total count of sectors on the volume	
} t_boot_sector_common;
 
typedef struct 
{
 
	UINT32		nFATSz32;			// 32-bit count of sectors occupied by one FAT
	UINT16		bExtFlags;			// 0-3 : zero-based number of active FAT
									//      only valid if mirroring is disabled
									// 4-6 : Reserved
									// 7   : 0 means the FAT is mirrored at runtime into all FATs
									// 1   : 1 means only one FAT is active; it is the one referenced
									//          in bits 0-3
									// 8-15 : reserved
	
	UINT16		nFSVer;				// High Byte : major revision number, Low Byte :
									// minor revision number
									// 0x0000
	UINT32		nRootClus;			// Cluster number of the first cluster of the root
									// directory. Usually 2
	UINT16		nFSInfo;			// Sector number of FSINFO structure in the
									// reserved area. Usually 1
	UINT16		nBkBootSec;			// > 0 : sector number in the reserved area of
									// the volume of a copy
									// of the boot record. Usually 6.
	UINT8		sReserved[12];		// Reserved. initialized to zero at format
	UINT8		nDrvNum;			// drive number 0x00 for floppy, 0x80 for hard disks
	UINT8		nReserved1;			// reserved, 0
	UINT8		nBootSig;			// extended boot signature 0x29
	UINT8		nVolID[4];			// Volume serial number
	UINT8		nVolLab[11];		// Volume label. "NO NAME   "
	UINT8		sFileSysType[8];	// "FAT32   "
} t_boot_sector_32;
 
typedef struct 
{
 
	UINT8		nDrvNum;			// drive number 0x00 for floppy, 0x80 for hard disks
	UINT8		nReserved1;			// reserved, 0
	UINT8		nBootSig;			// extended boot signature 0x29
	UINT8		nVolID[4];			// Volume serial number
	UINT8		nVolLab[11];		// Volume label. "NO NAME   "
	UINT8		sFileSysType[8];	// "FAT12  ", "FAT16  ", "FAT    "
} t_boot_sector_16;
 
typedef struct
{
    UINT32		nFSI_LeadSig;
    UINT8		aFSI_Reserved1[480];
    UINT32		nFSI_StrucSig;
    UINT32		nFSI_FreeCount;
    UINT32		nFSI_Nxt_Free;
    UINT8		aFSI_Reserved2[12];
    UINT32		nFSI_TrailSig;
} t_fat32_FSInfo;
 
typedef enum
{
    enuCASE_None    = 0x00000001,
    enuCASE_Upper   = 0x00000002,
    enuCASE_Lower   = 0x00000004,
    enuCASE_Mixed   = 0x00000008,
    enuCASE_Dummy	= 0x00000000
} t_case_enum;
 
#ifdef __cplusplus
extern "C" 
{
#endif // __cplusplus
 
/* mandatory functions */
extern INT32 TFFN_FS_Init(void);
extern INT32 TFFN_FS_Creat(UINT16* szPath, t_file_handler* stFileHandler);
extern INT32 TFFN_FS_Open(UINT16* szPath, t_file_handler* stFileHandler);
extern INT32 TFFN_FS_Read(t_file_handler* stFileHandler, UINT32 nSize, UINT32* szBuffer, UINT32* nReadSize);
extern INT32 TFFN_FS_Write(t_file_handler* stFileHandler, UINT32 nSize, UINT32* szBuffer, UINT32* nWrittenSize);
extern INT32 TFFN_FS_Lseek(t_file_handler* stFileHandler, INT32 nOffset, INT32 nWhence);
 
extern INT32 TFFN_FS_OpenDir(UINT16* szPath, t_file_handler* stDirHandler);
extern INT32 TFFN_FS_Open_Ex(t_file_handler* stDirHandler, UINT16* szPath, t_file_handler* stFileHandler);
extern INT32 TFFN_FS_GetHandleinfo(UINT16* szPath, t_file_handler* stDirHandler);
extern INT32 TFFN_FS_Getlist(t_file_handler *stFileHandler, UINT8 *filename, UINT32 *size, UINT32 *dirinfo);

 
/* fat core function */
// Read & Write directory entry
INT32 _Read_Dir_Entry(UINT32 nCurCluster, UINT32 nCurSector);
INT32 _Write_Dir_Entry(void);
INT32 _Path_Resolve(UINT16* szPath, t_file_handler* stFileHandler, UINT32 bFlag);
INT32 _Lookup(UINT32 nStartCluster, UINT16* szName, t_file_handler* stFileHandler);
INT32 _Get_Next_FAT_Value(UINT32 nCurCluster, UINT32* nNextCluster);
INT32 _Get_Free_FAT_Value(UINT32 nStartCluster, UINT32* nFreeCluster);
INT32 _Check_FAT_Chain_Continuous(UINT32 nStartCluster, UINT32 nBodyClusters);
INT32 _Allocate_Cluster(UINT32 nCurCluster, UINT32* nNextCluster, UINT32 nClusters);
INT32 _Check_Same_FAT(UINT32 nStartCluster, UINT32 nNextCluster);
INT32 _Clean_Cluster(UINT32 nCluster);
INT32 _Update_FAT(UINT32 nCluster, INT32 nValue, BOOL32 nWriteFlag);
INT32 _getEntry( t_file_handler *stFileHandler, t_dir_entry *stDirEnt1);
void _fileName2str(UINT8  * filename);

 
#ifdef __cplusplus
};
#endif // __cplusplus
 
#endif /* __MOREX_FAT_H__ */

