/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_ddm.h
* @module
          	Device Driver Manager
* @purpose
			This file defines DDM of the MOREX II  
* @author
            HyunJu Ahn (hyunju.ahn@samsung.com)
* @date
            2005/09/15
* @revision history
            2005/09/15 [HyunJu Ahn]: First writing
*/
 
#ifndef __MOREX_DDM_H__
#define __MOREX_DDM_H__
 
#include "morex_types.h"
 
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
 
extern INT32	TFFN_DDM_Init(UINT32 *nTotalSectors);
extern INT32	TFFN_DDM_Close(VOID);
extern UINT32	TFFN_Read_Sectors(UINT32 nStartSector, UINT32 nNumOfSectors, UINT8 *szBuffer);
extern UINT32	TFFN_Write_Sectors(UINT32 nStartSector, UINT32 nNumOfSectors, UINT8 *szBuffer);
 
#ifdef __cplusplus
};
#endif // __cplusplus
 
#endif /* __MOREX_DDM_H__ */
