/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_ddm.c
* @module
          	Device Driver Manager
* @purpose
			This file defines DDM of the MOREX II  
* @author
            HyunJu Ahn (hyunju.@samsung.com)
* @date
            2005/09/15
* @revision history
            2005/09/15 [HyunJu Ahn]: First writing
			2005/10/27 [HyunJu Ahn]: modified for porting
*/
#include "morex_config.h"
#include "morex_ddm.h"
#include "morex_types.h"
#include "morex_pdev.h"
 
/**
* 
* Initialize Device Driver Manager
* 
* @param		VOID
* @return		MOREX_OK : Success
				< 0		 : failure
* @author		Hyun Ju Ahn (hyunju.ahn@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32
TFFN_DDM_Init(UINT32 *nTotalSectors)
{
	INT32	nRe;
 
	// Initialize physical device driver
	nRe = TFFN_Pdev_Init(nTotalSectors);
	if (nRe < 0)
	{
		return MOREX_ERROR;
	}
	
	// physical device open
	nRe = TFFN_Pdev_Open();
 
	if (nRe < 0)
	{
		return MOREX_EIO;
	}
	return MOREX_OK;
 
}
 
/**
* 
* Close Device Driver Manager
* 
* @param		VOID
* @return		MOREX_OK : Success
				< 0		 : failure
* @author		Hyun Ju Ahn (hyunju.ahn@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
INT32
TFFN_DDM_Close(VOID)
{
	INT32 nRe;
 
	nRe = TFFN_Pdev_Close();
 
 	if(nRe < 0)
 	{
 		return MOREX_ERROR;
 	}
 	
	return MOREX_OK;
}
/**
* 
* Read Sectors From Device
* 
* @param		nStartSector : start sector number
*				nNumOfSectors : number of sectors to read
*				szBuffer	  : buffer pointer for the read data
* @return		number of sectors have been read : Success
*				< 0		 : failure
* @author		Hyun Ju Ahn (hyunju.ahn@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
UINT32
TFFN_Read_Sectors(UINT32 nStartSector, UINT32 nNumOfSectors, UINT8 *szBuffer)
{
	INT32 nRe;
 
	nRe = TFFN_Pdev_ReadSectors(nStartSector, nNumOfSectors, szBuffer);
 
	if((nRe < 0) || ((UINT32)nRe != nNumOfSectors))
	{
		return (UINT32)MOREX_EIO;
	}
 
	return nNumOfSectors;
}
/**
* 
* Write Sectors to Device
* 
* @param		nStartSector : start sector number
*				nNumOfSectors : number of sectors to write
*				szBuffer	  : buffer pointer for the written data
* @return		number of sectors have been written : Success
*				< 0		 : failure
* @author		Hyun Ju Ahn (hyunju.ahn@samsung.com)
* @version		1.0
* @see			
* @since		1.0
*/
UINT32
TFFN_Write_Sectors(UINT32 nStartSector, UINT32 nNumOfSectors, UINT8 *szBuffer)
{
	INT32 nRe;
 
	nRe = TFFN_Pdev_WriteSectors(nStartSector, nNumOfSectors, szBuffer);	
 
	if ((nRe < 0) || ((UINT32)nRe != nNumOfSectors))
	{
		return  (UINT32)MOREX_EIO;
	}
	return nNumOfSectors;
}
 
