/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          COPYRIGHT 2003-2005 SAMSUNG ELECTRONICS CO., LTD.                */
/*                          ALL RIGHTS RESERVED                              */ 
/*                                                                           */
/*   Permission is hereby granted to licensees of Samsung Electronics        */
/*   Co., Ltd. products to use or abstract this computer program for the     */
/*   sole purpose of implementing a product based on Samsung                 */
/*   Electronics Co., Ltd. products. No other rights to reproduce, use,      */
/*   or disseminate this computer program, whether in part or in whole,      */
/*   are granted.                                                            */
/*                                                                           */
/*   Samsung Electronics Co., Ltd. makes no representation or warranties     */
/*   with respect to the performance of this computer program, and           */
/*   specifically disclaims any responsibility for any damages,              */
/*   special or consequential, connected with the use of this program.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/**
* @project 
			MOREX II
* @file
          	morex_config.h
* @module
          	configuration of the MOREX II
* @purpose
			This file defines configuration options for the MOREX II
* @author
            Ahn HyunJu (hyunju.ahn@samsung.com)
* @date
            2005/10/14
* @revision history
            2005/10/14 [HyunJu Ahn]: First writing
*/
#ifndef __MOREX_CONFIG_H__
#define __MOREX_CONFIG_H__
 
// OS 
#define MOREX_OS				1
#define MORE_FIRMWARE			1

#if defined (MOREX_WIN32)
	#undef	MOREX_WIN32
	#define MOREX_WIN32			1
#elif defined (MOREX_NUCLEUS)
	#undef MOREX_NUCLEUS	
	#define MOREX_NUCLEUS		1
#elif defined (MOREX_SOLARIS)
	#undef MOREX_SOLARIS	
	#define MOREX_SOLARIS		1
#elif defined (MOREX_LINUX)
	#undef MOREX_LINUX	
	#define MOREX_LINUX			1
#elif defined (MOREX_uCOSII)
	#undef MOREX_uCOSII
	#define MOREX_uCOSII		1
#elif defined (MORE_FIRMWARE)
	#undef MORE_FIRMWARE
	#define MORE_FIRMWARE		1
#else
	#error MOREX OS NOT DEFINED!!
#endif
 
 
// compile option	
#define MOREX_LITTLE_ENDIAN	1
#define MOREX_BIG_ENDIAN	0
 
#define MOREX_BYTE_ORDER	MOREX_LITTLE_ENDIAN
 
// debug option
#define MOREX_DEBUG			1
#define MOREX_STRICT_CHECK	1
 
// operation option
#define MOREX_FOR_DEVELOPER	1		// for developer
 
#define MOREX_OPEN			1		// TFFN_Open
#define MOREX_CREAT			1		// TFFN_Creat
#define MOREX_READ			1		// TFFN_Read
#define MOREX_WRITE			1		// TFFN_Write
#define MOREX_LSEEK			1		// TFFN_Lssek
#define MOREX_UNLINK		0		// TFFN_Unlink
 
#define MOREX_OPENDIR		0		// TFFN_Opendir
#define MOREX_MKDIR			0		// TFFN_Mkdir
#define MOREX_RMDIR			0		// TFFN_Rmdir
#define MOREX_READDIR		0		// TFFN_Readdir
 
#define MOREX_FORMAT		0		// TFFN_Format
 
#define MOREX_OPEN_HINT		0		// TFFN_Open_WithHint
#define MOREX_OPENDIR_HINT	0		// TFFN_OpenDir_WithHint
 
#endif /* __MOREX_CONFIG_H__ */
