#ifndef __FS_HEADER__
#define __FS_HEADER__
#include "string.h"
#include "library.h"
#include "morex_fat.h"
#include "morex_util.h"


extern s32 FS_Init(void);
extern s32 FS_Creat(u8* filePath, t_file_handler* stFileHandler);
extern s32 FS_Open(u8* filePath, t_file_handler* stFileHandler);
extern s32 FS_Read(t_file_handler* stFileHandler, u32 nSize, u32* szBuffer, u32* nReadSize);
extern s32 FS_Write(t_file_handler* stFileHandler, u32 nSize, u32* szBuffer, u32* nWrittenSize);
extern s32 FS_Lseek(t_file_handler* stFileHandler, s32 nOffset, s32 nWhence);
 
extern s32 FS_OpenDir(u16* szPath, t_file_handler* stDirHandler);
extern s32 FS_Open_Ex(t_file_handler* stDirHandler, u16* szPath, t_file_handler* stFileHandler);
extern s32 FS_GetHandleinfo(u16* szPath, t_file_handler* stDirHandler);
extern s32 FS_Getlist(t_file_handler *stFileHandler, u8 *filename, u32 *size, u32 *dirinfo);

extern s32 FS_Unicode2Ascii(u8* szStr1, u8* szStr2);
extern s32 FS_Ascii2UniCode(u8* szStr1, u8* szStr2);

extern s32 FS_OpenFromDirlist(u8* DirPath, t_file_handler* stFileHandler, u32 OpenIdx, bool DispList, u8* filePath, u8* filext);
extern s32 FS_GetFileByReplacedExt(char* pFileName, char* pExt, t_file_handler* stFileHandler);
extern s32 FS_GetFileNameExt(char *pFileName, char *pExtension);
#endif

