#include "fs.h"

#ifndef Disp
#define Disp(x...)	UART_Printf(x)
#endif

s32 FS_Init(void)
{
	return TFFN_FS_Init();
}
s32 FS_Read(t_file_handler* stFileHandler, u32 nSize, u32* szBuffer, u32* nReadSize)
{
	return TFFN_FS_Read(stFileHandler, nSize, szBuffer, nReadSize);
}
s32 FS_Write(t_file_handler* stFileHandler, u32 nSize, u32* szBuffer, u32* nWrittenSize)
{
	return TFFN_FS_Write(stFileHandler, nSize, szBuffer, nWrittenSize);
}
s32 FS_Seek(t_file_handler* stFileHandler, s32 nOffset, s32 nWhence)
{
	return TFFN_FS_Lseek(stFileHandler, nOffset, nWhence);
}
 
s32 FS_OpenDir(u16* szPath, t_file_handler* stDirHandler)
{
	return TFFN_FS_OpenDir(szPath, stDirHandler);
}
s32 FS_Open_Ex(t_file_handler* stDirHandler, u16* szPath, t_file_handler* stFileHandler)
{
	return TFFN_FS_Open_Ex(stDirHandler, szPath, stFileHandler);
}
s32 FS_GetHandleinfo(u16* szPath, t_file_handler* stDirHandler)
{
	return TFFN_FS_GetHandleinfo(szPath, stDirHandler);
}
s32 FS_Getlist(t_file_handler *stFileHandler, u8 *filename, u32 *size, u32 *dirinfo)
{
	return TFFN_FS_Getlist(stFileHandler, filename, size, dirinfo);
}
s32 FS_Unicode2Ascii(u8* szStr1, u8* szStr2)
{
	return TFFN_Multi2Single(szStr1, szStr2);
}
s32 FS_Ascii2UniCode(u8* szStr1, u8* szStr2)
{
	return TFFN_Single2Multi(szStr1, szStr2);
}

s32 FS_Creat(u8* filePath, t_file_handler* stFileHandler)
{
	char ptempPath[256]={0,};
	
	TFFN_Single2Multi(filePath, (u8*)ptempPath);
	
	if(MOREX_OK != TFFN_FS_Creat((u16 *)ptempPath, stFileHandler))
	{
		return MOREX_ERROR;
	}
	return MOREX_OK;
}

s32 FS_Open(u8* filePath, t_file_handler* stFileHandler)
{
	char ptempPath[256]={0,};
	
	TFFN_Single2Multi(filePath, (u8*)ptempPath);

	if(MOREX_OK != TFFN_FS_Open((u16 *)ptempPath, stFileHandler))
	{
		return MOREX_ERROR;
	}
	return MOREX_OK;
}

s32	FS_OpenFromDirlist(u8* DirPath, t_file_handler* stFileHandler, u32 OpenIdx, bool DispList, u8* filePath, u8* filext)
{
	char ptempDirPath[128]={0,};
	char ptempPath[128]={0,};
	char ptempPath2[128]={0,};
	t_file_handler		rootdir;
	s32 nReturn;
	u32 ufileflag; 
	u32 ufilesize;
	u32 idx;
	u32 uSel;
	char *strrchrtmp;
	
	TFFN_Single2Multi(DirPath, (u8*)ptempDirPath);


	uSel = OpenIdx;
	
	if(DispList == true)
	{
		idx = 0;
		
		if(MOREX_OK != 	TFFN_FS_OpenDir((UINT16*)ptempDirPath, &rootdir))
			return MOREX_ERROR;
		do
		{
			nReturn = TFFN_FS_Getlist(&rootdir, ptempPath, &ufilesize, &ufileflag);
			if(nReturn == MOREX_OK)
			{
				if(idx >= 2)
					Disp("[%d] [%s]   %d Bytes\n", idx-2, ptempPath, ufilesize);
				idx++;
			}
		}while(nReturn == MOREX_OK);

		UART_Printf("\nSelect File : ");
		uSel =UART_GetIntNum();
	}


	if(MOREX_OK != 	TFFN_FS_OpenDir((UINT16*)ptempDirPath, &rootdir))
		return MOREX_ERROR;

	idx = 0;
	do
	{
		nReturn = TFFN_FS_Getlist(&rootdir, ptempPath, &ufilesize, &ufileflag);
		if(nReturn == MOREX_OK)
		{

			if((uSel + 2) == idx)
			{
				sprintf(ptempPath2, "%s/%s", DirPath, ptempPath);
				TFFN_Single2Multi(ptempPath2, ptempPath);
				if(MOREX_OK == TFFN_FS_Open((u16 *)ptempPath, stFileHandler))
				{
					strcpy(filePath, ptempPath2);
					strrchrtmp = strrchr(ptempPath2, '.');
					strcpy(filext, strrchrtmp+1);
					return MOREX_OK;
				}else
				{
					return MOREX_ERROR;
				}
			}
			idx++;
		}
	}while(nReturn == MOREX_OK);

	return MOREX_ERROR;
}

s32 FS_GetFileByReplacedExt(char* pFileName, char* pExt, t_file_handler* stFileHandler)
{
	u32 i;
	char aFileName[256] = {0,};
	char ptempPath[256] = {0,};
	u32 uIdx;
		
	strcpy(aFileName, pFileName);
	
	uIdx = strlen(pFileName);

	while (1)
	{
		if (aFileName[--uIdx] == '.')
			break;
	}
	strcpy(&aFileName[uIdx+1], pExt);

	TFFN_Single2Multi(aFileName, (u8*)ptempPath);

	if(MOREX_OK != 	TFFN_FS_Open((UINT16*)ptempPath, stFileHandler))
		return MOREX_ERROR;

	return MOREX_OK;
}

s32 FS_GetFileNameExt(char *pFileName, char *pExtension)
{
	int i, j;
	bool bExt;
	u32 uStrIdx;
	
	bExt = false;
	j=0;
	
	uStrIdx = strlen(pFileName);
	while (1)
	{
		if (pFileName[--uStrIdx] == '.')
		{
			bExt = true;
			break;
		}
		j++;
	}

	for(i=0; i<j; i++)
		pExtension[i] = (char)pFileName[uStrIdx+1+i];

	pExtension[j]=0;
	
	return bExt;
}

