/*-------------------------------------------------------------
 * Filename: protocolstackudp.c
 *
 * Contents: Implemention of UDP of TCP/IP
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/

 #ifndef __PROTOCOL_STACK_UDP_H__
 #define __PROTOCOL_STACK_UDP_H__

typedef struct
 {
	u16 receivedSourcePort;
	u16 receviedDestinationPort;
	u16 receviedLength;
	u16 receviedChecksum;
 }UDP_PACKET_INFO;

int UDP_Init(u8 *macAddress,u8 *ipAddress,u16 port, u8 *destIPAddress,u16 destPort,void (*receiver)(u8 *data,u16 length));
 void UDP_SendDatagram(u8 *data,u16 length);
 void UDP_SendDatagramFast(u16 length);
u8 *UDP_GetWriteBuffer(void);
void UDP_ReceiveHandler(u8 *data,u16 length);
void UDP_SendDatagramRaw(u8 *data,u16 length);
void UDP_ReceiveHandlerRaw(u8 *data,u16 length);
int UDP_InitRaw(u8 *macAddress,u8 *ipAddress,u16 port, u8 *destIPAddress,u16 destPort,void (*receiver)(u8 *data,u16 length,UDP_PACKET_INFO info));

 #endif