/*-------------------------------------------------------------
 * Filename: protocolstack.h
 *
 * Contents: Implemention of Ethernet Frame, ICMP ping of TCP/IP and ARP
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
#ifndef __PROTOCOL_STACK_H__
#define __PROTOCOL_STACK_H__


//#define PROTOCOL_ETHERNET_DEBUG
//#define PROTOCOL_IP_DEBUG
//#define PROTOCOL_ICMP_DEBUG
//#define PROTOCOL_ARP_DEBUG

#ifdef PROTOCOL_ETHERNET_DEBUG
#define ETHERNETDEBUG(x) Disp x
#else
#define ETHERNETDEBUG(x) 0
#endif

#ifdef PROTOCOL_IP_DEBUG
#define IPDEBUG(x) Disp x
#else
#define IPDEBUG(x) 0
#endif

#ifdef PROTOCOL_ICMP_DEBUG
#define ICMPDEBUG(x) Disp x
#else
#define ICMPDEBUG(x) 0
#endif

#ifdef PROTOCOL_ARP_DEBUG
#define ARPDEBUG(x) Disp x
#else
#define ARPDEBUG(x) 0
#endif

#define PROTOCOL_MAX_ARP_TABLE 100

#define SWAP16(x) (u16)((u16)(x<<8)|(u16)(x>>8))

typedef enum
{
	PROTOCOL_ETHERNET_IPv4=0x800,
	PROTOCOL_ETHERNET_ARP=0x806,
	PROTOCOL_ETHERNET_IPv6=0x85dd,
	PROTOCOL_ETHERNET_NORMAL=0
}PROTOCOL_ETHERNET_TYPE;

typedef enum
{
	PROTOCOL_IP_ICMP=1,
	PROTOCOL_IP_IGMP=2,
	PROTOCOL_IP_TCP=6,
	PROTOCOL_IP_UDP=17
}PROTOCOL_IP_TYPE;	

typedef enum
{
	PROTOCOL_ICMP_ECHO_REPLY=0,
	PROTOCOL_ICMP_ECHO_REQUEST=8
}PROTOCOL_ICMP_TYPE;

typedef __packed struct
{
	u8 type;
	u8 code;
	u16 checksum;
}PROTOCOL_ICMPFormat;

typedef __packed struct
{
	u16 HWType;
	u16 ProtocolType;
	u8 HLEN;
	u8 PLEN;
	u16 Operation;
	u8 SenderMAC[6];
	u8 SenderIP[4];
	u8 TargetMAC[6];
	u8 TargetIP[4];
}PROTOCOL_ARPFormat;

typedef __packed struct
{
	u8 Version_IHL;
	u8 TOS;
	u16 Length;
	u16 ID;
	u16 Flags_Fragment;
	u8 TTL;
	u8 Protocol;
	u16 HeaderChecksum;
	u8 SrcIP[4];
	u8 DestIP[4];
	u32 options;
}PROTOCOL_IPFormat;

typedef struct
{
	u8 MAC[6];
	u8 IP[4];
	u32 IsUsed;
	u32 Seq;
}PROTOCOL_ARPTABLE;

typedef __packed struct
{
	u8 DestMAC[6];
	u8 SrcMAC[6];
	u16 type;
}PROTOCOL_ETHERNETFormat;

void PROTOCOL_InitStack(u8* srcEthernetAddr,u8 *srcIPAddr,
	void (*sender)(u8 *data, u16 length));
void PROTOCOL_InitStackWithUDP(u8* srcEthernetAddr,u8 *srcIPAddress,
	void (*sender)(u8 *data, u16 length),void (*udpHandler)(u8 *data,u16 length));

void PROTOCOL_FrameHander(u8 *data,u16 length);

void PROTOCOL_EthernetHandler(u8 *data, u16 length);
void PROTOCOL_EthernetSender(u8 *data,u16 length,u16 type,u8 *DestMAC);
void PROTOCOL_ARPHandler(u8 *data,u16 length);
void PROTOCOL_IPHandler(u8 *data,u16 length,PROTOCOL_ETHERNETFormat *MACFormat);
void PROTOCOL_IPSender(u8 *data,u16 length,u8 Protocol,u8 *DestIP,u16 ID);
void PROTOCOL_ICMPHandler(u8 *data,u16 length,PROTOCOL_IPFormat *ipHeader);
void PROTOCOL_ARPRequest(u8 *targetIPAddress);
u32 *PROTOCOL_GetIPBuffer(void);
u32 *PROTOCOL_GetEthernetBuffer(void);
void PROTOCOL_EthernetSenderFast(u16 length,u16 type,u8 *DestMAC);
void PROTOCOL_IPSenderFast(u16 length,u8 Protocol,u8 *DestIP,u16 ID);
	
#endif
