/*-------------------------------------------------------------
 * Filename: ethernetfiletransfor.h
 *
 * Contents: Implemention of transfor application through udp protocol
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/

 #ifndef __ETHERNET_FILE_TRANSFOR_H__
 #define __ETHERNET_FILE_TRANSFOR_H__

typedef enum
 {
	ETHERNET_FILE_TYPE_FILE=0, ETHERNET_FILE_TYPE_DIRECTORY
 }ETHERNET_FILE_TYPE;

typedef __packed struct
{
	u32 fileID;
	u32 fileSize;
	u8 fileType;
	u8 fileName[256];
}ETHERNET_FILE;

int EFT_Init(u8 *MACAddress,u8 *IPAddress,u8 *ServerIPAddress);
void EFT_ReadFile(ETHERNET_FILE *file,u32 *buffer);
ETHERNET_FILE EFT_RequestFileInfo(char *fileName);
ETHERNET_FILE EFT_RequestCreateFileInfo(char * fileName);
void EFT_WriteFile(ETHERNET_FILE *file,u32 *buf, u32 size);
void EFT_ReadFilePartial(ETHERNET_FILE *file,u32 *buffer,u32 offset,u32 length);
bool EFT_GetFileNameExt(char *pFileName, char *pExtension);
 #endif