/*-------------------------------------------------------------
 * Filename: ethernetfiletransfor.c
 *
 * Contents: Implemention of transfor application through udp protocol
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
#include "system.h"
#include "ProtocolStack.h"
#include "ProtocolStackUDP.h"
#include "EthernetFileTransfer.h"


#define TargetUDPPort 22000
#define SourceUDPPort 22001

typedef __packed struct
{
	u8 message_type;
	u16 header_size; // size of entire header in bytes
}MESSAGE_HEADER;
typedef enum
{
	REQUEST_FILE_INFO=0,
	REQUEST_DOWNLOAD_FILE,
	REQUEST_DOWNLOAD_DIRECTORY,
	REQUEST_CREATE_FILE,
	REQUEST_CREATE_DIRECTORY,
	RESPONSE_FILE_INFO,
	RESPONSE_DOWNLOAD_FILE,
	RESPONSE_DOWNLOAD_DIRECTORY,
	RESPONSE_CREATE_FILE,
	REQUEST_UPLOAD_FILE
}MESSAGE_TYPE;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 request_file_name[256];
}REQUEST_FILE_INFO_HEADER;
typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 request_file_name[256];
	u32 file_size;
	u32 fileID;
}RESPONSE_FILE_INFO_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u32 fileID;
	u32 offset;
	u32 length;
}REQUEST_DONWLOAD_FILE_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u32 requested_size;
	u32 current_chunk_offset;
	u32 current_chunk_length;
	u32 fileID;
}RESPONSE_DONWLOAD_FILE_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 request_directory[256];
}REQUEST_DOWNLOAD_DIRECTORY_HEADER;


typedef __packed struct
{
	MESSAGE_HEADER header;
	u32 data_size;
	u32 current_chunk_offset;
	u32 current_chunk_length;
	u32 num_of_files;
}RESPONSE_DOWNLOAD_DIRECTORY_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 request_file_name[256];
}REQUEST_CREATE_FILE_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 request_file_name[256];
	u32 fileID;	
}RESPONSE_CREATE_FILE_HEADER;

typedef __packed struct
{
	MESSAGE_HEADER header;
	u8 reserved;
	u32 file_size;
	u32 current_chunk_offset;
	u32 current_chunk_length;
	u32 fileID;
}REQUEST_UPLOAD_FILE_HEADER;

static void dump(u8 *buf,u32 size)
{
	u32 i;
	for(i=0;i<size;i++)
	{
		if(i!=0 && i%16==0)Disp("\n");
		if(buf[i]<0x10)Disp("0x0%x ",buf[i]);
		else Disp("0x%x ",buf[i]);
	}
	Disp("\n");
}


static u32 fileInfoReceived=0;
static u32 fileCreateReceived = 0;
static RESPONSE_FILE_INFO_HEADER fileInfo;
static RESPONSE_CREATE_FILE_HEADER createInfo;
static u32 * fileBuffer;
static u32 fileRecevied=0;
static u32 fileReceviedSize=0;
static u32 directoryReceived=0;
static u32 directoryFileNum = 0;
void Receiver(u8 *data,u16 length)
{
	int i,j;
	u32 tmp;
	u32 num;
	u8 *fileBuffer8 = (u8 *)fileBuffer;
	u32 offset;
	RESPONSE_DONWLOAD_FILE_HEADER *responseDownloadHeader;
	RESPONSE_DOWNLOAD_DIRECTORY_HEADER *responseDirectoryHeader;
	MESSAGE_HEADER *header = (MESSAGE_HEADER *)data;
	if(header->message_type == RESPONSE_FILE_INFO)
	{
		fileInfo = *((RESPONSE_FILE_INFO_HEADER *)data);
		fileInfoReceived = 1;
	}
	else if(header->message_type == RESPONSE_CREATE_FILE)
	{
		createInfo = *((RESPONSE_CREATE_FILE_HEADER *)data);
		fileCreateReceived = 1;
	}
	else if(header->message_type==RESPONSE_DOWNLOAD_FILE)
	{
		responseDownloadHeader = (RESPONSE_DONWLOAD_FILE_HEADER *)data;
		if(responseDownloadHeader->fileID==-1)
		{
			Disp("invalid file ID\n");
			fileRecevied=1;

			return;
		}
		tmp = (u32)(&(data[sizeof(RESPONSE_DONWLOAD_FILE_HEADER)]));
		num = responseDownloadHeader->current_chunk_length/(4*8);
		offset = (u32)fileBuffer + responseDownloadHeader->current_chunk_offset;
		#if 0
		for(i=responseDownloadHeader->current_chunk_offset,j=sizeof(RESPONSE_DONWLOAD_FILE_HEADER);
			i<responseDownloadHeader->current_chunk_offset+responseDownloadHeader->current_chunk_length;
			i++,j++)
		{
			fileBuffer8[i]= data[j];
		}
		#else
		if((tmp%4)==0 && (offset%4)==0)
		{
		//	Disp("ldm mode\n");
			#if 0
			__asm
			{
				LDR r0,[&tmp]
				LDR r1,[&offset]
				LDR r2,[&num]
			loop:
				CMP r2,#0
				BEQ endLoop
				LDMIA r0!, {r3,r4,r5,r6,r7,r8,r9,r10}
				STMIA r1!, {r3,r4,r5,r6,r7,r8,r9,r10}
				SUB r2,r2,#1
				B loop
			endLoop:
			}
			#else
			burst8_memcpy_inc_src_inc_dst(offset, tmp, num);
	
			#endif

			//Disp("offset=%u size=%u\n",responseDownloadHeader->current_chunk_offset+i+num*(4*8),
			//	responseDownloadHeader->current_chunk_length%(4*8));

			for(i=0;i<responseDownloadHeader->current_chunk_length%(4*8);i++)
			{
				fileBuffer8[responseDownloadHeader->current_chunk_offset+i+num*(4*8)] = data[sizeof(RESPONSE_DONWLOAD_FILE_HEADER)+i+num*(4*8)];
			}
		}
		else
		{
			for(i=responseDownloadHeader->current_chunk_offset,j=sizeof(RESPONSE_DONWLOAD_FILE_HEADER);
				i<responseDownloadHeader->current_chunk_offset+responseDownloadHeader->current_chunk_length;
				i++,j++)
			{
				fileBuffer8[i]= data[j];
			}
		}
		#endif
		fileReceviedSize +=responseDownloadHeader->current_chunk_length;
		if(fileReceviedSize>=responseDownloadHeader->requested_size)fileRecevied=1;
	}
	else if(header->message_type==RESPONSE_DOWNLOAD_DIRECTORY)
	{
		responseDirectoryHeader = (RESPONSE_DOWNLOAD_DIRECTORY_HEADER *)data;
		if(responseDirectoryHeader->num_of_files==-1)
		{
			Disp("invalid directory name\n");
			fileRecevied=1;

			return;
		}
		
		tmp = (u32)(&(data[sizeof(RESPONSE_DOWNLOAD_DIRECTORY_HEADER)]));
		num = responseDirectoryHeader->current_chunk_length/(4*8);
		offset = (u32)fileBuffer + responseDirectoryHeader->current_chunk_offset;

		if((tmp%4)==0 && (offset%4)==0)
		{
		//	Disp("ldm mode\n");
			__asm
			{
				LDR r0,[&tmp]
				LDR r1,[&offset]
				LDR r2,[&num]
			loop2:
				CMP r2,#0
				BEQ endLoop2
				LDMIA r0!, {r3,r4,r5,r6,r7,r8,r9,r10}
				STMIA r1!, {r3,r4,r5,r6,r7,r8,r9,r10}
				SUB r2,r2,#1
				B loop2
			endLoop2:
			}

			//Disp("offset=%u size=%u\n",responseDownloadHeader->current_chunk_offset+i+num*(4*8),
			//	responseDownloadHeader->current_chunk_length%(4*8));

			for(i=0;i<responseDirectoryHeader->current_chunk_length%(4*8);i++)
			{
				fileBuffer8[responseDirectoryHeader->current_chunk_offset+i+num*(4*8)] = data[sizeof(RESPONSE_DOWNLOAD_DIRECTORY_HEADER)+i+num*(4*8)];
			}
		}
		else
		{
			for(i=responseDirectoryHeader->current_chunk_offset,j=sizeof(RESPONSE_DOWNLOAD_DIRECTORY_HEADER);
				i<responseDirectoryHeader->current_chunk_offset+responseDirectoryHeader->current_chunk_length;
				i++,j++)
			{
				fileBuffer8[i]= data[j];
			}
		}

		fileReceviedSize +=responseDirectoryHeader->current_chunk_length;
		directoryFileNum = responseDirectoryHeader->num_of_files;
		if(fileReceviedSize>=responseDirectoryHeader->data_size)directoryReceived=1;
	}
}

ETHERNET_FILE EFT_RequestFileInfo(char *fileName)
{
	int i;
	REQUEST_FILE_INFO_HEADER request;
	ETHERNET_FILE ethernetFile;
	ethernetFile.fileID=-1;
	ethernetFile.fileName[0]=0;
	ethernetFile.fileSize=0;
	ethernetFile.fileType=ETHERNET_FILE_TYPE_FILE;
	request.header.message_type = REQUEST_FILE_INFO;
	for(i=0;i<256;i++)
	{
		request.request_file_name[i] = fileName[i];
		ethernetFile.fileName[i] = fileName[i];
		if(fileName[i]==0)break;
	}
	if(i>=256)
	{
		Disp("Too large file name\n");
		return ethernetFile;
	}

	request.header.header_size = sizeof(REQUEST_FILE_INFO_HEADER);

	fileInfoReceived = 0;
	UDP_SendDatagram((u8 *)(&request),sizeof(REQUEST_FILE_INFO_HEADER));
	while(1)if(fileInfoReceived)break;

	ethernetFile.fileID = fileInfo.fileID;
	ethernetFile.fileSize = fileInfo.file_size;
	return ethernetFile;
	
}

void EFT_ReadFile(ETHERNET_FILE *file,u32 *buffer)
{
	REQUEST_DONWLOAD_FILE_HEADER header;
	if(file->fileID==-1)
	{
		Disp("Invalid file id\n");
		return;
	}
	
	header.header.message_type = REQUEST_DOWNLOAD_FILE;
	header.fileID = file->fileID;
	header.header.header_size = sizeof(REQUEST_DONWLOAD_FILE_HEADER);
	header.offset=0;
	header.length=file->fileSize;

	fileBuffer = buffer;
	fileRecevied = 0;
	fileReceviedSize = 0;
	UDP_SendDatagram((u8 *)(&header),sizeof(REQUEST_DONWLOAD_FILE_HEADER));
	while(1)if(fileRecevied)break;

}

void EFT_ReadFilePartial(ETHERNET_FILE *file,u32 *buffer,u32 offset,u32 length)
{
	REQUEST_DONWLOAD_FILE_HEADER header;
	if(file->fileID==-1)
	{
		Disp("Invalid file id\n");
		return;
	}
	
	header.header.message_type = REQUEST_DOWNLOAD_FILE;
	header.fileID = file->fileID;
	header.header.header_size = sizeof(REQUEST_DONWLOAD_FILE_HEADER);
	header.offset=offset;
	header.length=length;

	fileBuffer = buffer;
	fileRecevied = 0;
	fileReceviedSize = 0;
	UDP_SendDatagram((u8 *)(&header),sizeof(REQUEST_DONWLOAD_FILE_HEADER));
	while(1)if(fileRecevied)break;
}

// It needs 265bytes per single file.
// eg) If there are 20 files in directory. It needs 20*265 bytes for buffer.
// directoryName is not supported yet. Do input directoryName as "" 
int EFT_ReadDirectory(char *directoryName,u32 *buffer)
{
	int i;
	REQUEST_DOWNLOAD_DIRECTORY_HEADER request;
	for(i=0;i<256;i++)
	{
		request.request_directory[i] = directoryName[i];
		if(directoryName[i]==0)break;
	}
	if(i>=256)
	{
		Disp("Too large directory name\n");
		return 0;
	}	

	request.header.message_type = REQUEST_DOWNLOAD_DIRECTORY;
	request.header.header_size = sizeof(REQUEST_DOWNLOAD_DIRECTORY_HEADER);
	fileBuffer = buffer;
	directoryReceived = 0;
	fileReceviedSize = 0;
	UDP_SendDatagram((u8 *)(&request),sizeof(REQUEST_DOWNLOAD_DIRECTORY_HEADER));
	while(1)if(directoryReceived)break;

	return directoryFileNum;
}

ETHERNET_FILE EFT_RequestCreateFileInfo(char * fileName)
{
	int i;
	REQUEST_CREATE_FILE_HEADER request;
	ETHERNET_FILE ethernetFile;
	ethernetFile.fileID=-1;
	ethernetFile.fileName[0]=0;
	ethernetFile.fileSize=0;
	ethernetFile.fileType=ETHERNET_FILE_TYPE_FILE;
		
	request.header.message_type = REQUEST_CREATE_FILE;
	for(i=0;i<256;i++)
	{
		request.request_file_name[i] = fileName[i];
		ethernetFile.fileName[i] = fileName[i];
		if(fileName[i]==0)break;
	}
	if(i>=256)
	{
		Disp("Too large file name\n");
		return ethernetFile;
	}

	request.header.header_size = sizeof(REQUEST_CREATE_FILE_HEADER);

	fileCreateReceived = 0;
	UDP_SendDatagram((u8 *)(&request),sizeof(REQUEST_CREATE_FILE_HEADER));
	while(1)if(fileCreateReceived)break;	

	ethernetFile.fileID = createInfo.fileID;

	return ethernetFile;
}

#define PROPER_WRITE_BUF_SIZE 1400 // this value must be 4bytes-aligned. Do not make it to be exceed 1400
void EFT_WriteFile(ETHERNET_FILE *file,u32 *buf, u32 size)
{
	u32 i,j;
	u32 realBuf[PROPER_WRITE_BUF_SIZE/4];
	u8 *buf8;
	u32 src,dest,num,rest;
	u8 *realBuf8;
	REQUEST_UPLOAD_FILE_HEADER *header;
	realBuf8 = (u8 *)realBuf;
	buf8 = (u8 *)buf;
	if(file->fileID==-1)
	{
		Disp("Invalid file id\n");
		return;
	}
	
	realBuf8 = UDP_GetWriteBuffer();
	header = (REQUEST_UPLOAD_FILE_HEADER *)realBuf8;
	header->header.message_type = REQUEST_UPLOAD_FILE;
	header->header.header_size = sizeof(REQUEST_UPLOAD_FILE_HEADER);
	header->fileID = file->fileID;
	header->file_size = size;

	for(i=0;i<size;i=i+PROPER_WRITE_BUF_SIZE-sizeof(REQUEST_UPLOAD_FILE_HEADER))
	{
		for(j=0;j<PROPER_WRITE_BUF_SIZE-sizeof(REQUEST_UPLOAD_FILE_HEADER) && j+i<size;j++)
			realBuf8[sizeof(REQUEST_UPLOAD_FILE_HEADER)+j] = buf8[i+j];

		header->current_chunk_offset = i;
		header->current_chunk_length = j;

		UDP_SendDatagramFast(header->current_chunk_length+sizeof(REQUEST_UPLOAD_FILE_HEADER));
	}

}

int EFT_Init(u8 *MACAddress,u8 *IPAddress,u8 *ServerIPAddress)
{
	return UDP_Init(MACAddress,IPAddress,SourceUDPPort, ServerIPAddress,TargetUDPPort,Receiver);
}

bool EFT_GetFileNameExt(char *pFileName, char *pExtension)
{
	int i, j;
	bool bExt;
	
	bExt = false;
	j=0;
	
	for(i=0; pFileName[i]; i++)
	{
		if(bExt)
		{
				pExtension[j] = (char)pFileName[i];
				j++;
		}
		if((char)pFileName[i] == '.')
			bExt = true;
	}
	
	pExtension[j]=0;
	
	return bExt;
}



