/*-------------------------------------------------------------
 * Filename: avireader.h
 *
 * Contents: Implemention of AVI file reader
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created 2008.05.28 by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
#ifndef __AVIREADER_H__
#define __AVIREADER_H__


#ifndef DWORD
#define DWORD unsigned int
#endif

#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned short
#endif

#ifndef LONG
#define LONG int
#endif

#ifndef RECT
typedef __packed struct
{
	WORD x;
	WORD y;
	WORD width;
	WORD height;
}RECT;
#endif

#ifndef FOURCC
#define FOURCC DWORD
#endif

#define FOURCC2DW(ch0, ch1 ,ch2, ch3) ((DWORD)(BYTE)(ch0) |((DWORD)(BYTE)(ch1)<<8)|((DWORD)(BYTE)(ch2)<<16)|((DWORD)(BYTE)(ch3)<<24))

#define AVI_VIDEO_CODEC_H263 FOURCC2DW('H', '2','6', '3')
#define AVI_VIDEO_CODEC_H264 FOURCC2DW('H', '2','6', '4')
#define AVI_VIDEO_CODEC_h264 FOURCC2DW('h', '2','6', '4')
#define AVI_VIDEO_CODEC_XVID FOURCC2DW('X','V','I','D')
#define AVI_VIDEO_CODEC_xvid FOURCC2DW('x','v','i','d')
#define AVI_VIDEO_CODEC_DVIX3 FOURCC2DW('D','I','V','3')
#define AVI_VIDEO_CODEC_MP43 FOURCC2DW('M','P','4','3')
#define AVI_VIDEO_CODEC_MPEG4 FOURCC2DW('F','M','P','4')
#define AVI_VIDEO_CODEC_dx50 FOURCC2DW('d','x','5','0')
#define AVI_VIDEO_CODEC_divx FOURCC2DW('d','i','v','x')
#define AVI_VIDEO_CODEC_div3 FOURCC2DW('d','i','v','3')

#define AVI_VIDEO_CODEC_INDEO_VIDEO_5 FOURCC2DW('I', 'V','5', '0')

#define AVIF_HASINDEX           0x00000010      // Index at end of file?
#define AVIF_MUSTUSEINDEX       0x00000020
#define AVIF_ISINTERLEAVED      0x00000100
#define AVIF_TRUSTCKTYPE        0x00000800      // Use CKType to find key frames?
#define AVIF_WASCAPTUREFILE     0x00010000
#define AVIF_COPYRIGHTED        0x00020000

#define AVISF_DISABLED 0x00000001
#define AVISF_VIDEO_PALCHANGES 0x00010000

#define AVI_INDEX_OF_INDEXES 0x00	// when each entry in aIndex
#define AVI_INDEX_OF_CHUNKS 0x01	// when each entry in aIndex
#define AVI_INDEX_IS_DATA	0x80	// when each entry is aIndex is

#define AVI_INDEX_2FIELD 0x01

#define WAVE_FORMAT_MP3 0x55
#define WAVE_FORMAT_AC3 0x2000
#define WAVE_FORMAT_DTS 0x2001


typedef __packed struct
{
	DWORD dwFourCC;
	DWORD dwSize;
	BYTE data[4];
} AVI_CHUNK;

typedef  __packed struct
{
	DWORD dwList;
	DWORD dwSize;
	DWORD dwFourCC;
	BYTE data[4];
} AVI_LIST;

typedef  struct
{
	AVI_CHUNK *chunk;
	AVI_LIST *list;
	int offset;
}AVI_ELEMENT;

typedef  __packed struct
{
	DWORD dwMicroSecPerFrame; // frame display rate (or 0)
	DWORD dwMaxBytesPerSec; // max. transfer rate
	DWORD dwPaddingGranularity; // pad to multiples of this size;
	DWORD dwFlags; // the ever-present flags
	DWORD dwTotalFrames; // # frames in file
	DWORD dwInitialFrames;
	DWORD dwStreams;
	DWORD dwSuggestedBufferSize;
	DWORD dwWidth;
	DWORD dwHeight;
	DWORD dwReserved[4];
} MainAVIHeader;

typedef  __packed struct {
	DWORD fccType;
	DWORD fccHandler;
	DWORD dwFlags;
	WORD wPriority;
	WORD wLanguage;
	DWORD dwInitialFrames;
	DWORD dwScale;
	DWORD dwRate; /* dwRate / dwScale == samples/second */
	DWORD dwStart;
	DWORD dwLength; /* In units above... */
	DWORD dwSuggestedBufferSize;
	DWORD dwQuality;
	DWORD dwSampleSize;
	RECT rcFrame;
} AVIStreamHeader;

/* do not use this
typedef __packed struct _avisuperindex_chunk {
	FOURCC fcc;
	DWORD cb;
	WORD wLongsPerEntry;
	BYTE bIndexSubType;
	BYTE bIndexType;
	DWORD nEntriesInUse;
	DWORD dwChunkId;
	DWORD dwReserved[3];
	struct _avisuperindex_entry {
		long long qwOffset;
		DWORD dwSize;
		DWORD dwDuration;
	}  * aIndex;
} AVISUPERINDEX;
*/

typedef struct
{
	AVIStreamHeader *StreamHeader;
	AVI_CHUNK *strf;
	AVI_CHUNK *indx;
	AVI_CHUNK *strn;
}AVIStreamInfor;

#ifndef BITMAPINFOHEADER_DEF
#define BITMAPINFOHEADER_DEF
typedef __packed struct
{
 	DWORD  biSize; 
	LONG   biWidth; 
	LONG   biHeight; 
	WORD   biPlanes; 
	WORD   biBitCount; 
	DWORD  biCompression; 
	DWORD  biSizeImage; 
	LONG   biXPelsPerMeter; 
	LONG   biYPelsPerMeter; 
	DWORD  biClrUsed; 
	DWORD  biClrImportant; 
}BITMAPINFOHEADER;
#endif

#ifndef WAVEFORMATEX_DEF
#define WAVEFORMATEX_DEF
typedef  __packed struct { 
  WORD  wFormatTag; 
  WORD  nChannels; 
  DWORD nSamplesPerSec; 
  DWORD nAvgBytesPerSec; 
  WORD  nBlockAlign; 
  WORD  wBitsPerSample; 
  WORD  cbSize; 
} WAVEFORMATEX; 
#endif


typedef struct
{
	MainAVIHeader *mainAVIHeader;
	AVIStreamInfor VideoInfor;
	AVIStreamInfor AudioInfor;
	AVIStreamInfor TextInfor;
	int VideoStreamIndex;
	int AudioStreamIndex;
	int TextStreamIndex;
	AVI_LIST *movi;
	AVI_LIST *current_REC;
	AVI_CHUNK *current_CHUNK;
	char *buffer;
	int offset_movi;
	int offset_audio_movi;
}AVI_INFO;


int AVI_IsAVIFile(char *buffer);
 int AVI_OpenAVIFile(char *buffer,AVI_INFO *aviInfo);
 void AVI_CloseAVIFile(AVI_INFO *aviInfo);
 int AVI_GetSuggestedVideoBuffer(AVI_INFO *aviInfo);
 int AVI_GetSuggestedAudioBuffer(AVI_INFO *aviInfo);
unsigned char * AVI_GetVideoData(int *chunkSize,AVI_INFO *aviInfo,int *numOfAudioChunk);
 unsigned char * AVI_GetAudioData(int *chunkSize,AVI_INFO *aviInfo);
 unsigned int  AVI_GetVideoCodec(AVI_INFO *aviInfo);
 unsigned int  AVI_GetAudioCodec(AVI_INFO *aviInfo);
 void AVI_ResetVideoDataOffset(AVI_INFO *aviInfo);
 void AVI_ResetAudioDataOffset(AVI_INFO *aviInfo);
// void printf_cfcc(DWORD value);
 float AVI_GetFPSinAVI(AVI_INFO *aviInfo);
 WAVEFORMATEX * AVI_GetAudioParameter(AVI_INFO *aviInfo);
 float AVI_GetAudioChunkPerSec(AVI_INFO *aviInfo);
 void AVI_GetStreamResolution(u32* pHsize, u32* pVsize);
#endif

