/*-------------------------------------------------------------
 * Filename: avireader.c
 *
 * Contents: Implemention of AVI file reader
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created 2008.05.28 by chun gil lee
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include "system.h"
#include "AviReader.h"

#define GetStreamIndex(dword) ((char)dword-0x30)*10+((char)(dword>>8))-0x30
#define GetDataType(dword) (char)(dword>>16)
#define GetDataCompress(dword) (char)(dword>>24)

#define DEBUG nullprint
//#define DEBUG Disp("[AVI]");Disp

#define DEBUG_INFO nullprint
//#define DEBUG_INFO Disp

static AVI_INFO *aviInfo;

static void nullprint(char *str,...)
{

}

#define LSB_GET_4BYTES(x) ((*((x)+3)) << 24) | ((*((x)+2)) << 16) | \
                            ((*((x)+1)) << 8) | ((*((x))))
#define LSB_GET_3BYTES(x) ((*((x)+2)) << 16) | \
                            ((*((x)+1)) << 8) | ((*((x))))
#define LSB_GET_2BYTES(x) ((*((x)+1)) << 8 ) | ((*((x))))


static u8 cfcc(DWORD value1, char *value2) // check four CC
{
	if( (char)value1 == value2[0] &&(char)(value1>>8) == value2[1] &&	
		(char)(value1>>16)== value2[2] &&	(char)(value1>>24) == value2[3] )
		return true;
	
	else 
		return false;
}

#if 0
static void memset(void *dest,int value,int size)
{
	char *tmp;
	int i;
	tmp = (char *)dest;
	for(i=0;i<size;i++)tmp[i] = (char)value;
}
#endif

static void printf_cfcc(DWORD value)
{
	DEBUG_INFO("%c%c%c%c",(char)value,(char)(value>>8),(char)(value>>16),(char)(value>>24));
}

/************************************************************************
description : 
		close opened avi file handler
Input :
 		aviInfo -> AVI handler point
Ouput :
 		none
************************************************************************/
void AVI_CloseAVIFile(AVI_INFO *aviInfo)
{

}

static AVI_ELEMENT GetAVIElement(AVI_LIST *list_input, int offset_input)
{
	
	AVI_ELEMENT element;
	element.chunk = NULL;
	element.list = NULL;

	if((DWORD)offset_input+1>=list_input->dwSize-4)
	{
		return element;
	}

	element.list = (AVI_LIST *)(list_input->data+offset_input);
	element.chunk = (AVI_CHUNK *)(list_input->data+offset_input);
	element.offset = offset_input+4+4+element.chunk->dwSize;
	if(element.offset%2!=0)element.offset++;
	
	return element;
}

static void ShowElements(AVI_LIST *list)
{
	AVI_CHUNK *chunk;
	int offset=0;
	int index=0;
	BYTE *tmp;
	while(1)
	{
		
		chunk = (AVI_CHUNK *)(list->data+offset);
		tmp = (BYTE *)chunk;
		
		DEBUG_INFO("[%d] addr=0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",index,tmp,
			tmp[0],tmp[1],tmp[2],tmp[3],tmp[4],tmp[5],tmp[6],tmp[7]);
		
		if((char)(chunk->dwFourCC) == 'L' &&
			(char)(chunk->dwFourCC>>8) == 'I' &&
			(char)(chunk->dwFourCC>>16) == 'S' &&
			(char)(chunk->dwFourCC>>24) == 'T')
		{
			DEBUG_INFO("[%d]List Item FourCC=%c%c%c%c size=%d\n",
				index,chunk->data[0],chunk->data[1],chunk->data[2],chunk->data[3],chunk->dwSize);
		}
		else
		{
			DEBUG_INFO("[%d]Chunk Item FourCC=%c%c%c%c size=%d\n",
				index,(char)(chunk->dwFourCC),(char)(chunk->dwFourCC>>8),(char)(chunk->dwFourCC>>16),(char)(chunk->dwFourCC>>24),
				chunk->dwSize);
		}

		index++;

		offset = offset+chunk->dwSize+4+4;
		if(offset%2!=0)offset++;

		if((DWORD)offset+1>=list->dwSize-4)break;

	}
}

// 0--> fail, 1--> success
static int ParseAVIHeader(AVI_LIST *list)
{
	//AVI_LIST *child_list;
	AVI_ELEMENT element;
	AVI_CHUNK *child_chunk;

	int offset=0;
//	int i;
//	ShowElements(list);
	int streamCounter = 0;
	
	DEBUG_INFO("parsing avi++++++++++++ list length=%d\n",list->dwSize);
	while(1)
	{
		element = GetAVIElement(list,offset);
		if(element.list ==NULL && element.chunk==NULL)break;

		child_chunk = element.chunk;
		if(cfcc(child_chunk->dwFourCC,(char *)"avih"))
		{
		//	DEBUG_INFO("FCC=");printf_cfcc(child_chunk->dwFourCC);printf("\n");
			aviInfo->mainAVIHeader = (MainAVIHeader *)child_chunk->data;
			
			DEBUG_INFO("MicroSecPerFrame=%d\n",aviInfo->mainAVIHeader->dwMicroSecPerFrame);
			DEBUG_INFO("MaxBytesPerSec=%d\n",aviInfo->mainAVIHeader->dwMaxBytesPerSec);
			DEBUG_INFO("PaddingGranularity=%d\n",aviInfo->mainAVIHeader->dwPaddingGranularity);
			DEBUG_INFO("Flags=0x%x\n",aviInfo->mainAVIHeader->dwFlags);
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_COPYRIGHTED){DEBUG_INFO("[COPYRIGHTED] ");}
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_HASINDEX){DEBUG_INFO("[HASINDEX] ");}
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_ISINTERLEAVED){DEBUG_INFO("[ISINTERLEAVED] ");}
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_MUSTUSEINDEX){DEBUG_INFO("[MUSTUSEINDEX] ");}
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_TRUSTCKTYPE){DEBUG_INFO("[TRUSTCKTYPE] ");}
			if(aviInfo->mainAVIHeader->dwFlags & AVIF_WASCAPTUREFILE){DEBUG_INFO("[WASCAPTUREFILE] ");}
			DEBUG_INFO("\n");
			DEBUG_INFO("TotalFrames=%d\n",aviInfo->mainAVIHeader->dwTotalFrames);
			DEBUG_INFO("InitialFrames=%d\n",aviInfo->mainAVIHeader->dwInitialFrames);
			DEBUG_INFO("Streams=%d\n",aviInfo->mainAVIHeader->dwStreams);
			DEBUG_INFO("SuggestedBufferSize=%d\n",aviInfo->mainAVIHeader->dwSuggestedBufferSize);
			DEBUG_INFO("Width=%d Heigth=%d\n",aviInfo->mainAVIHeader->dwWidth,aviInfo->mainAVIHeader->dwHeight);

		//	if(StreamInfor!=0)free(StreamInfor);
		//	StreamInfor = (AVIStreamInfor *)malloc(sizeof(AVIStreamInfor) * mainAVIHeader->dwStreams);
		//	memset(StreamInfor,0,sizeof(AVIStreamInfor) * mainAVIHeader->dwStreams);
		}

		
		if(cfcc(element.list->dwFourCC,(char *)"strl"))
		{
			AVI_ELEMENT strlElement;
			int strlOffset = 0;
			AVI_CHUNK *strf=0;
			AVI_CHUNK *indx=0;
			AVI_CHUNK *strn=0;
			AVIStreamHeader *strh=0;
			
			DEBUG("strl++++++++++++++++++++length=%d\n",element.list->dwSize);

			ShowElements(element.list);

			if((DWORD)streamCounter>=aviInfo->mainAVIHeader->dwStreams)
			{
				Disp("Number of LIST strl exceeds dwStreams !!!!!\n"); 
				AVI_CloseAVIFile(aviInfo);
				return 0;
			}
			
			while(1)
			{
				strlElement =GetAVIElement(element.list,strlOffset);
				if(strlElement.chunk==NULL && strlElement.list==NULL)break;

				if(cfcc(strlElement.chunk->dwFourCC,(char *)"strh"))strh = (AVIStreamHeader *)strlElement.chunk->data;
				else if(cfcc(strlElement.chunk->dwFourCC,(char *)"strf"))strf= (AVI_CHUNK *)strlElement.chunk;
				else if(cfcc(strlElement.chunk->dwFourCC,(char *)"indx"))indx= (AVI_CHUNK *)strlElement.chunk;
				else if(cfcc(strlElement.chunk->dwFourCC,(char *)"strn"))strn= (AVI_CHUNK *)strlElement.chunk;
								
				strlOffset = strlElement.offset;
			}

			if(cfcc(strh->fccType,(char *)"vids"))
			{
				aviInfo->VideoInfor.StreamHeader = strh;
				aviInfo->VideoInfor.strf = strf;
				aviInfo->VideoInfor.strn = strn;
				aviInfo->VideoInfor.indx = indx;
				aviInfo->VideoStreamIndex = streamCounter;
			}
			else if(cfcc(strh->fccType,(char *)"auds"))
			{
				aviInfo->AudioInfor.StreamHeader = strh;
				aviInfo->AudioInfor.strf = strf;
				aviInfo->AudioInfor.strn = strn;
				aviInfo->AudioInfor.indx = indx;
				aviInfo->AudioStreamIndex = streamCounter;
			}
			else if(cfcc(strh->fccType,(char *)"txts"))
			{
				aviInfo->TextInfor.StreamHeader = strh;
				aviInfo->TextInfor.strf = strf;
				aviInfo->TextInfor.strn = strn;
				aviInfo->TextInfor.indx = indx;
				aviInfo->TextStreamIndex = streamCounter;
			}

			DEBUG_INFO("STRH:fccType=");printf_cfcc(strh->fccType);DEBUG_INFO("\n");
			DEBUG_INFO("STRH:InitialFrames=%d\n",strh->dwInitialFrames);
			DEBUG_INFO("STRH:Scale=%d Rate=%d --> %f fps(or samples per sec)\n",strh->dwScale,
				strh->dwRate,((float)strh->dwRate)/((float)strh->dwScale));
			DEBUG_INFO("STRH:Start time of stream=%d\n",strh->dwStart);

			/*
			DEBUG_INFO("StreamInfor[%d]+++++++++++++++++++++++++\n",streamCounter);
			DEBUG_INFO("STRH:fccType=");DEBUG_INFO_cfcc(strh->fccType);DEBUG_INFO("\n");
			DEBUG_INFO("STRH:flags=");
			if(strh->dwFlags && AVISF_DISABLED)DEBUG_INFO("[AVISF_DISABLED] ");
			if(strh->dwFlags && AVISF_VIDEO_PALCHANGES)DEBUG_INFO("[AVISF_VIDEO_PALCHANGES] ");
			DEBUG_INFO("\n");
			DEBUG_INFO("STRH:InitialFrames=%d\n",strh->dwInitialFrames);
			DEBUG_INFO("STRH:Scale=%d Rate=%d --> %f fps(or samples per sec)\n",strh->dwScale,
				strh->dwRate,(float)strh->dwRate/strh->dwScale);
			DEBUG_INFO("STRH:Start time of stream=%d\n",strh->dwStart);
			DEBUG_INFO("STRH:size of stream in units(Rate,Scale)=%d\n",strh->dwLength);
			DEBUG_INFO("STRH:SuggestedBufferSize=%d\n",strh->dwSuggestedBufferSize);
			DEBUG_INFO("STRH:Num of bytes of one stream atom=%d\n",strh->dwSampleSize);
			if(strf!=NULL)DEBUG_INFO("STRF exists!! length=%d\n",strf->dwSize);
			if(indx!=NULL)DEBUG_INFO("INDX exists!! length=%d\n",indx->dwSize);
			if(strn!=NULL)DEBUG_INFO("STRN exists!! length=%d STRN=%s\n",strn->dwSize,strn->data);
			*/

			if(strf!=NULL)
			{
	
			
			}
			if(indx!=NULL)
			{
				/*
				AVISUPERINDEX *sindex = (AVISUPERINDEX *)indx;
				if(sindex->bIndexType & AVI_INDEX_OF_INDEXES)DEBUG_INFO("INDX:IndexType=[AVI_INDEX_OF_INDEXES\n");
				else DEBUG_INFO("INDX:IndexType = NOT AVI_INDEX_OF_INDEXES\n");
				if(sindex->bIndexSubType & AVI_INDEX_2FIELD)DEBUG_INFO("INDX:IndexSubType=[AVI_INDEX_2FIELD\n");
				else DEBUG_INFO("INDX:IndexSubType = NOT_AVI_INDEX_2FILED\n");

				DEBUG_INFO("INDX:LognsPerEntry=%d\n",sindex->wLongsPerEntry);
				*/
			}
				
			DEBUG_INFO("StreamInfor[%d]--------------------------------\n",streamCounter);

			streamCounter++;
			
			DEBUG("strl---------------------------\n");
		}
			

		offset = element.offset;
		DEBUG_INFO("offset = %d\n",offset);
	}
	
	if(aviInfo->AudioInfor.strf!=NULL)
	{
		/*
		typedef struct { 
 		 WORD  wFormatTag; 
		  WORD  nChannels; 
		  DWORD nSamplesPerSec; 
		  DWORD nAvgBytesPerSec; 
		  WORD  nBlockAlign; 
		  WORD  wBitsPerSample; 
		  WORD  cbSize; 
		} WAVEFORMATEX; 
		*/
		WAVEFORMATEX *wex = (WAVEFORMATEX *)(aviInfo->AudioInfor.strf->data);
		DEBUG_INFO("FormatTag:%d(0x%x)\n",wex->wFormatTag,wex->wFormatTag);
		DEBUG_INFO("nChannels:%d\n",wex->nChannels);
		DEBUG_INFO("nSamplesPerSec:%d\n",wex->nSamplesPerSec);
		DEBUG_INFO("nAvgBytesPerSec:%d\n",wex->nAvgBytesPerSec);
		DEBUG_INFO("nBlockAlign:%d\n",wex->nBlockAlign);
		DEBUG_INFO("wBitsPerSample:%d\n",wex->wBitsPerSample);
		DEBUG_INFO("cbSize:%d\n",wex->cbSize);
	//	DEBUG_INFO("STRH:InitialFrames=%d\n",aviInfo->AudioInfor.strh->dwInitialFrames);

	}	
	
	DEBUG_INFO("parsing avi end----------------\n");

	return 1;	
}


/************************************************************************
description : 
		It verifies if this buffer object is avi file or not.
Input :
 		buffer --> buffer contains avi file data
Ouput :
 		0 --> It's NOT avi file.
 		1 --> this is avi file
************************************************************************/
int AVI_IsAVIFile(char *buffer)
{
	AVI_LIST *list = (AVI_LIST *)buffer;
	
	if(cfcc(list->dwList,(char *)"RIFF") && cfcc(list->dwFourCC,(char *)"AVI "))
	{
		return 1;
		//DEBUG("RIFF AVI List!\n");
	}
	else return 0;
}

/************************************************************************
description : 
		It opens avi handler with avi buffer object
Input :
 		aviInfo -> AVI handler point. It will be setup by this function.
Ouput :
 		0--> fail
 		1--> success
************************************************************************/
int AVI_OpenAVIFile(char *buffer,AVI_INFO *info)
{
	AVI_LIST *list = (AVI_LIST *)buffer;
	AVI_ELEMENT element;
	AVI_LIST *child;

	int offset=0;
	aviInfo = info;
	memset(aviInfo,0,sizeof(AVI_INFO));

	aviInfo->buffer = buffer;
	
	if(cfcc(list->dwList,(char *)"RIFF") && cfcc(list->dwFourCC,(char *)"AVI "))
	{
		DEBUG("RIFF AVI List!\n");
	}
	else return 0;

	while(1)
	{	
		element = GetAVIElement(list,offset);
		if(element.list ==NULL && element.chunk==NULL)
			break;

		if(cfcc(element.list->dwList,(char *)"LIST") && cfcc(element.list->dwFourCC,(char *)"hdrl"))
		{
			DEBUG("hdrl size = %d\n",element.list->dwSize);
			if(ParseAVIHeader(element.list))
			{
			}
			else return 0;
		}
		else if(cfcc(element.list->dwList,(char *)"LIST") && cfcc(element.list->dwFourCC,(char *)"movi"))
		{
			aviInfo->movi = element.list;
			child = (AVI_LIST *)element.list->data;
			if(cfcc(child->dwList,(char *)"LIST") && cfcc(child->dwList,(char *)"rec "))
			{
				aviInfo->current_REC = child;
			}
			else
			{
				aviInfo->current_CHUNK = (AVI_CHUNK *)child;
			}

			break; //To avoid page fault which causes real I/O operation
		}
			
		offset = element.offset;
	}
	return 1;
	
}

void AVI_GetStreamResolution(u32* pHsize, u32* pVsize)
{
	*pHsize = aviInfo->mainAVIHeader->dwWidth;
	*pVsize =  aviInfo->mainAVIHeader->dwHeight;
}

/************************************************************************
description : 
		It returns suggest buffer size for video. This information suggested by AVI file header
Input :
 		aviInfo -> AVI handler point
Ouput :
 		0--> fail
 		otherwise --> suggested buffer size
************************************************************************/
int AVI_GetSuggestedVideoBuffer(AVI_INFO *aviInfo)
{
	if(aviInfo->VideoInfor.StreamHeader!=NULL)
		return aviInfo->VideoInfor.StreamHeader->dwSuggestedBufferSize;
	else return 0;
}

/************************************************************************
description : 
		It returns suggest buffer size for audio. This information suggested by AVI file header
Input :
 		aviInfo -> AVI handler point
Ouput :
 		0--> fail
 		otherwise --> suggested buffer size
************************************************************************/
int AVI_GetSuggestedAudioBuffer(AVI_INFO *aviInfo)
{
	if(aviInfo->AudioInfor.StreamHeader!=NULL)
		return aviInfo->AudioInfor.StreamHeader->dwSuggestedBufferSize;
	else return 0;
}

/************************************************************************
description : 
		It returns point of video chunk. It informs us the chunk size and how many audio
		chunks are associated with this video chunk.
Input :
 		aviInfo -> AVI handler point
Ouput :
 		chunkSize -> video chunk size
 		numOfAudioChunk -> number of audio chunks associated with this video chunk.
 		return value --> NULL -> there is no more video chunk.
 		                        otherwise -> video chunk address
************************************************************************/
unsigned char * AVI_GetVideoData(int *chunkSize,AVI_INFO *aviInfo,int *numOfAudioChunk)
{
	int offset = 0;
	AVI_ELEMENT child;
	(*numOfAudioChunk) =0;
	if(aviInfo->current_REC!=NULL) //There is REC list in movi
	{
		/* Do review it, you must re-implement it because following code has bug related with calculating  offset
		AVI_ELEMENT element;
		element=GetAVIElement(aviInfo->movi,aviInfo->offset_movi);
		if(cfcc(element.list->dwList,"LIST") && cfcc(element.list->dwFourCC,"rec "))
		{
			while(1)
			{
				child = GetAVIElement(element.list,offset);
				if(child.list== NULL && child.chunk==NULL)
				{
					break;
				}
				if(GetStreamIndex(child.chunk->dwFourCC)==aviInfo->VideoStreamIndex 
					&& GetDataType(child.chunk->dwFourCC)=='d')
				{
					aviInfo->offset_movi = aviInfo->offset_movi+ element.list->dwSize+4+4;
					if(aviInfo->offset_movi%2!=0)aviInfo->offset_movi++;
					(*chunkSize) = child.chunk->dwSize;
					return child.chunk->data;
				}
				offset = child.offset;
			}
			DEBUG_INFO("There is NOT vaild video chunk!!!\n");
		}
		else
		{
			DEBUG_INFO("This is NOT rec list !!!!\n");
		}
		*/
		
		(*chunkSize) = 0;
		return 0;
	}
	else //There is NOT REC list in movi
	{
		//ShowElements(aviInfo->movi);
		
		offset = aviInfo->offset_movi;
		
		while(1)
		{
			child = GetAVIElement(aviInfo->movi,offset);
			if(child.list== NULL && child.chunk==NULL)
			{
				(*chunkSize) = 0;
				return NULL;
			}

			if(GetStreamIndex(child.chunk->dwFourCC)==aviInfo->AudioStreamIndex 
				&& GetDataType(child.chunk->dwFourCC)=='w')
			{
				(*numOfAudioChunk)++;
			}
			
			if(GetStreamIndex(child.chunk->dwFourCC)==aviInfo->VideoStreamIndex 
				&& GetDataType(child.chunk->dwFourCC)=='d')
			{
				aviInfo->offset_movi = child.offset;
				if(aviInfo->offset_movi%2!=0)aviInfo->offset_movi++;
				(*chunkSize) = child.chunk->dwSize;
				return child.chunk->data;
			}
			offset = child.offset;
		}		
		
	}
}

/************************************************************************
description : 
		It sets video seek offset to initial position
Input :
 		aviInfo -> AVI handler point
Ouput :
		None
************************************************************************/
void AVI_ResetVideoDataOffset(AVI_INFO *aviInfo)
{
	aviInfo->offset_movi = 0;
}

/************************************************************************
description : 
		It sets audio seek offset to initial position
Input :
 		aviInfo -> AVI handler point
Ouput :
		None
************************************************************************/
void AVI_ResetAudioDataOffset(AVI_INFO *aviInfo)
{
	aviInfo->offset_audio_movi = 0;
}

/************************************************************************
description : 
		It returns frames per sec.
Input :
 		aviInfo -> AVI handler point
Ouput :
		fps
************************************************************************/
float AVI_GetFPSinAVI(AVI_INFO *aviInfo)
{
//DEBUG_INFO("STRH:Scale=%d Rate=%d --> %f fps(or samples per sec)\n",strh->dwScale,
	//			strh->dwRate,(float)strh->dwRate/strh->dwScale);
	Disp("total frame=%d\n",aviInfo->mainAVIHeader->dwTotalFrames);
	return (float)(aviInfo->VideoInfor.StreamHeader->dwRate) / (float)(aviInfo->VideoInfor.StreamHeader->dwScale);
}

/************************************************************************
description : 
		?
Input :
 		aviInfo -> AVI handler point
Ouput :
		?
************************************************************************/
float AVI_GetAudioChunkPerSec(AVI_INFO *aviInfo)
{
	return (float)(aviInfo->AudioInfor.StreamHeader->dwRate) /  (float)(aviInfo->AudioInfor.StreamHeader->dwScale);
}

/************************************************************************
description : 
		It returns point of audio chunk. It informs us the chunk size.
Input :
 		aviInfo -> AVI handler point
Ouput :
 		chunkSize -> audio chunk size
 		return value --> NULL -> there is no more audio chunk.
 		                        otherwise -> audio chunk address
************************************************************************/
unsigned char * AVI_GetAudioData(int *chunkSize,AVI_INFO *aviInfo)
{
	int offset = 0;
	AVI_ELEMENT child;
	if(aviInfo->current_REC!=NULL) //There is REC list in movi
	{	
	//	AVI_ELEMENT element;
		(*chunkSize) = 0;
		return 0;
	}
	else //There is NOT REC list in movi
	{
		//ShowElements(aviInfo->movi);
		
		offset = aviInfo->offset_audio_movi;
		while(1)
		{
			child = GetAVIElement(aviInfo->movi,offset);
			if(child.list== NULL && child.chunk==NULL)
			{
				(*chunkSize) = 0;
				return NULL;
			}
			if(GetStreamIndex(child.chunk->dwFourCC)==aviInfo->AudioStreamIndex 
				&& GetDataType(child.chunk->dwFourCC)=='w')
			{
				aviInfo->offset_audio_movi = child.offset;
				if(aviInfo->offset_audio_movi%2!=0)aviInfo->offset_audio_movi++;
				(*chunkSize) = child.chunk->dwSize;
				return child.chunk->data;
			}
			offset = child.offset;
		}		
		
	}
}

/************************************************************************
description : 
		It returns video codec FourCC
Input :
 		aviInfo -> AVI handler point
Ouput :
 		FourCC
************************************************************************/
unsigned int AVI_GetVideoCodec(AVI_INFO *aviInfo)
{

	BITMAPINFOHEADER *bitmapheader=  (BITMAPINFOHEADER *)aviInfo->VideoInfor.strf->data;

	printf_cfcc(bitmapheader->biCompression);
	return bitmapheader->biCompression;
}

/************************************************************************
description : 
		It returns audio codec FourCC
Input :
 		aviInfo -> AVI handler point
Ouput :
 		FourCC
************************************************************************/
unsigned int AVI_GetAudioCodec(AVI_INFO *aviInfo)
{

	WAVEFORMATEX *wex;

	if(aviInfo->AudioInfor.strf==NULL)return 0;
	
	wex = (WAVEFORMATEX *)(aviInfo->AudioInfor.strf->data);	
	
	return wex->wFormatTag;
}

/************************************************************************
description : 
		It returns waveformateex of audio stream
Input :
 		aviInfo -> AVI handler point
Ouput :
 		WAVEFORMATEX
************************************************************************/
WAVEFORMATEX * AVI_GetAudioParameter(AVI_INFO *aviInfo)
{
	WAVEFORMATEX *wex;
	if(aviInfo->AudioInfor.strf==NULL)return 0;
	wex = (WAVEFORMATEX *)(aviInfo->AudioInfor.strf->data);	
	return wex;
}
