#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "system.h"
#include "util.h"
#include "sysc.h"
#include "mfc.h"
#include "intc.h"
#include "vsparser.h"
#include "avireader.h"
#include "lcd.h"
#include "lcd_module.h"
#include "glib.h"
#include "fimc.h" 
#include "gpio.h"
#include "sdhc.h"
#include "fs.h"
#include "mdnie.h"

#define STREAM_FILE_BUF_SIZE 			(0x1000000) 


static u32 uFirstFailed;
static LCD_WINDOW eWin;
static IMG_FMT eMfcFbType;
static IMG_FMT eBpp;
static u8 bDetailDiff;
static u32 uTestFileNum;
static u8 volatile bProcessingDone;
static u32 uFrameHsz[MAX_PROCESS_NUM];
static u32 uFrameVsz[MAX_PROCESS_NUM];
static u32 bFinishedProcess[MAX_PROCESS_NUM];
static u8 bNoMoreStream[MAX_PROCESS_NUM];
static u8 bIsFirstFrame[MAX_PROCESS_NUM];
static u32 uFrameCnt[MAX_PROCESS_NUM];
static u32 sel[MAX_PROCESS_NUM];
static char aFileName[MAX_FILENAME_SIZE];
static char aCfgFileName[MAX_FILENAME_SIZE];
static u8 bSdMode;
static u32 uIdx;
static u8 bRandomMultiDec=false;
static u8 bSdLoadMode=true;
static u8 bDualMasterMode=true;
static u32 uDispHorizontalDiv;
static u32 uDispVerticalDiv;
static u32 uDispWidth, uDispHeight;
static u32 uLcdFbAddr;
static u32 uLcdHSz, uLcdVSz;
static u32 uFinishedProcessNum=0;
static u8 bConformanceTestAll=false;
static CSC_EQUATION eCscEquation = CSC_ITU601;
static YCBCR_RANGE eYCbCrRange = YCBCR_WIDE;
static u8 bOneFrameStream[MAX_PROCESS_NUM];
static u8 bMustbeChecked[MAX_PROCESS_NUM];
static u32 uCrcBufStAddr[MAX_PROCESS_NUM];
static u32 uRefCrcBufAddr[MAX_PROCESS_NUM];
static u32 uRefCrcFileSize[MAX_PROCESS_NUM];
static VIDEO_CODEC_TYPE eDecStandard[MAX_PROCESS_NUM];
static VIDEO_CODEC_TYPE eEncStandard[MAX_PROCESS_NUM];
static char pFileName[MAX_PROCESS_NUM][MAX_FILENAME_SIZE];
static u8 ebDecStandard=false;
static u8 bVc1Field[MAX_PROCESS_NUM];
static u32 uErrorCnt=0;
static u32 uMultiDecTotFrameCnt=0;
static u32 uCurCrcBufStAddr[MAX_PROCESS_NUM];
static u8 bPreFrameDispOnly[MAX_PROCESS_NUM];
static u8 bFirstCrcCheck=true;
static u8 bSaveResult=false;
static u32 g_uStreamBufStAddr, g_uStreamBufOffset, g_uReadStreamSize;
static u32 uNumOfInstance;
static u32 uTestNum=0;
static u32 nDecProcessCount;
static u32 nEncProcessCount;
static u8 bRandomMultiTest=false;
extern u8 MPEG1_FLAG;
static volatile u8 bDmaDone=false;
static u32 g_uStreamFileSize;
static VIDEO_CODEC_TYPE g_eDecStandard;
static u8 bPixelCacheEn = true;
static u8 bFimcDinDout=false;
static u32 uLcdcUnderRunCnt=0;
static u8 bFirstFimcFifoOut=true;
static FIMC_CH eCh = FIMC_A;
static u8 bisRGBif = false;



static __irq void Isr_EInt31(void)
{
	Disp("E31\n");
	if (bisRGBif == true)
		bisRGBif = false;
	else
		bisRGBif = true;


	// interrupt clear in EINT SFR
	GPIO_EINT33ClrPend(7);
	INTC_ClearVectAddr();
}




  __irq static void Isr_Mfc(void)
{
	MFC_FACADE_RESPONSE eFlag;
	
	MFC_GetIntFlag(&eFlag);	
	if(eFlag==R2H_CMD_SEQ_DONE_RET)
	{
		MFC_GetPicResolution();
	}
	MFC_ClearPending();
	if((eFlag == R2H_CMD_SEQ_DONE_RET)||(eFlag == R2H_CMD_FRAME_DONE_RET))
	{
		MFC_ClearRtnInstance();
	}
	else if(eFlag==R2H_CMD_DECODE_ERR_RET)
	{
		MFC_ClearRtnInstance();
		Disp("[DEC ERR]\n");
	}
	INTC_ClearVectAddr();
}
  __irq static void Isr_ProcessingDone(void)
{
	FIMC_INTR_SRC eIntSrc;
	FIMC_GetIntrSrc(eCh, &eIntSrc);
	//sp("[P]\n");
	if(eIntSrc == FIMC_SUCCESS)
		bProcessingDone = true;
	else
		bProcessingDone = false;
	FIMC_ClearInterrupt(eCh);
	INTC_ClearVectAddr();
}

#if 0
static void TestMdnie_AviDec(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;

	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 
	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
		return;

	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	
	
	uDramABaseAddr = uFwCodeStAddr;
	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr, uDramABaseAddr, uDramBBaseAddr, bDualMasterMode);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);


	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}

	IEIP_Select(DISP_MDNIE);
	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;
	LCDC_InitBase();
	LCDC_InitWin(eBpp,uAviHsize,uAviVsize,0,0,uAviHsize,uAviVsize,0,0,uFreeMemBufA,eWin,false);
//	LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_GetFbEndAddr(&uFreeMemBufA,eWin);

	uCpbBufStAddr = Align(uFreeMemBufA,2048);
	
//------------------------------- mDNIE setting --------------------------------//
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uLcdHSz, uLcdVSz);

	Disp("mDNIE setting done. Press any key to start test\n");
	UART_Getc();

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

//----------------------------------------------------------------------------------//

	
	LCDC_Start();


	while(!UART_GetKey())
	{
		bIsFirstFrame = true;

		sRfile.filestart = uAviFileAddr;
		sRfile.offset = 0;
		sRfile.filesize = uAviFileSize;
		
		if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
		{
			Disp("Avi Open Fail");
			return;
		}
		
		Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

		uRemainSz = uAviFileSize;
		VsParserForCrc1(true,   eDecStandard, uAviFileAddr, uAviFileSize,
			&pFileSteamAddr, &uChunkSize, false, &bVC1_field, &uComsumedFrameSize);
		uRdPtr = pFileSteamAddr+uComsumedFrameSize;
		uRemainSz -= uComsumedFrameSize;
		
		if(pFileSteamAddr==0 && uChunkSize==0)
			return;

		MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

		if(eDecStandard==DivX311_DEC)
			MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

		Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
		MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
		MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
		MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
		MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

		FIMC_InitIpForDinDout(eCh,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uFrameHsz, uFrameVsz,
			0, 0, uFrameHsz, uFrameVsz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		

		uFrameCnt = 0;

		while(UART_GetKey() == 0)   // exit when any key is pressed.
		{
			if(bIsFirstFrame==true )	
			{
				if(eDecStandard == VC1RCV_DEC )
				{
					bIsFirstFrame = false;
					continue;
				}
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if(bNoMoreStream==true)
			{
				if(eDecStandard == H264_DEC)
					MFC_StartDecodingOneFrame(CMD_CH0, uLastFrameSize, LAST_FRAME);
				else
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}

			else
			{
				uRet = VsParserForCrc1(true,   eDecStandard, uRdPtr, uAviFileSize,
						&pFileSteamAddr, &uChunkSize, false, &bVC1_field, &uComsumedFrameSize);
					
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
					uRemainSz -= uComsumedFrameSize;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}	
				else if(uRet==1)
				{					
					bNoMoreStream =true;
					bMustbeChecked = false;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
				}
				else
					Assert(0);
				
			}
			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsBufferFlushed())
				break;

			if(!bNoMoreStream)
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}

			if(uFrameCnt == 960)
				break;

			MFC_GetDispType(&eDispType);
			if(eDispType==DISP_ONLY)
				bPreFrameDispOnly=true;
			else 
				bPreFrameDispOnly=false;

			if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
				continue;

			Delay(45);
			bProcessingDone = false;
			FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(eCh);
			while(!bProcessingDone);
			FIMC_StopProcessing(eCh);
		}
		Disp("\n");
		MFC_CloseInstance(uInstanceId);
	}
}
#else
static void TestMdnie_AviDec(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;

	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 
	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
		return;

	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	
	
	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}

	IEIP_Select(DISP_MDNIE);
	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;
	LCDC_InitBase();
	LCDC_InitWin(eBpp,uAviHsize,uAviVsize,0,0,uAviHsize,uAviVsize,0,0,uFreeMemBufA,eWin,false);
//	LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_GetFbEndAddr(&uFreeMemBufA,eWin);

	uCpbBufStAddr = Align(uFreeMemBufA,2048);
	
//------------------------------- mDNIE setting --------------------------------//
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uLcdHSz, uLcdVSz);

	Disp("mDNIE setting done. Press any key to start test\n");
	UART_Getc();

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

//----------------------------------------------------------------------------------//

	
	LCDC_Start();


	while(!UART_GetKey())
	{
		bIsFirstFrame = true;

		sRfile.filestart = uAviFileAddr;
		sRfile.offset = 0;
		sRfile.filesize = uAviFileSize;
		
		if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
		{
			Disp("Avi Open Fail");
			return;
		}
		
		Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

		uRemainSz = uAviFileSize;
		VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);

		uRdPtr = pFileSteamAddr+uComsumedFrameSize;
		uRemainSz -= uComsumedFrameSize;
		
		if(pFileSteamAddr==0 && uChunkSize==0)
			return;

		MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

		if(eDecStandard==DivX311_DEC)
			MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

		Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
		MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
		MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
		MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
		MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

		FIMC_InitIpForDinDout(eCh,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uFrameHsz, uFrameVsz,
			0, 0, uFrameHsz, uFrameVsz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		

		uFrameCnt = 0;

		while(UART_GetKey() == 0)   // exit when any key is pressed.
		{
			if(bIsFirstFrame==true )	
			{
				if(eDecStandard == VC1RCV_DEC )
				{
					bIsFirstFrame = false;
					continue;
				}
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if(bNoMoreStream==true)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_FRAME);
			}
			else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}

			else
			{
				uRet = VsParserForAvi(eDecStandard, uRdPtr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
					
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
					uRemainSz -= uComsumedFrameSize;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}	
				else if(uRet==1)
				{					
					bNoMoreStream =true;
					bMustbeChecked = false;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
				}
				else
					Assert(0);
				
			}
			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsBufferFlushed())
				break;

			if(!bNoMoreStream)
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}

			if(uFrameCnt == 960)
				break;

			MFC_GetDispType(&eDispType);
			if(eDispType==DISP_ONLY)
				bPreFrameDispOnly=true;
			else 
				bPreFrameDispOnly=false;

			if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
				continue;

			Delay(45);
			bProcessingDone = false;
			FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(eCh);
			while(!bProcessingDone);
			FIMC_StopProcessing(eCh);
		}
		Disp("\n");
		MFC_CloseInstance(uInstanceId);
	}
}
#endif

#if 0 
static void TestMdnie_AviDec2(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;

	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 
	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
		return;

	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	
	
	uDramABaseAddr = uFwCodeStAddr;
	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr, uDramABaseAddr, uDramBBaseAddr, bDualMasterMode);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);


	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}
	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;
	LCDC_InitIp(eBpp,uFreeMemBufA,eWin,false);
//	LCDC_InitBase();
//	LCDC_InitWin(eBpp,uAviHsize,uAviVsize,0,0,uAviHsize,uAviVsize,0,0,uFreeMemBufA,eWin,false);
//	LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
//	LCDC_SetFreeRun(1);
//	LCDC_SetOutputPath(LCD_MDNIE);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_GetFbEndAddr(&uFreeMemBufA,eWin);

	uCpbBufStAddr = Align(uFreeMemBufA,2048);
/*	
//------------------------------- mDNIE setting --------------------------------//
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uLcdHSz, uLcdVSz);

	Disp("mDNIE setting done. Press any key to start test\n");
	UART_Getc();

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

//----------------------------------------------------------------------------------//
*/
	
	LCDC_Start();


	while(!UART_GetKey())
	{
		bIsFirstFrame = true;

		sRfile.filestart = uAviFileAddr;
		sRfile.offset = 0;
		sRfile.filesize = uAviFileSize;
		
		if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
		{
			Disp("Avi Open Fail");
			return;
		}
		
		Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

		uRemainSz = uAviFileSize;
		VsParserForCrc1(true,   eDecStandard, uAviFileAddr, uAviFileSize,
			&pFileSteamAddr, &uChunkSize, false, &bVC1_field, &uComsumedFrameSize);
		uRdPtr = pFileSteamAddr+uComsumedFrameSize;
		uRemainSz -= uComsumedFrameSize;
		
		if(pFileSteamAddr==0 && uChunkSize==0)
			return;

		MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

		if(eDecStandard==DivX311_DEC)
			MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

		Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
		MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
		MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
		MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
		MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

		FIMC_InitIpForDinDout(eCh,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		

		uFrameCnt = 0;

		while(UART_GetKey() == 0)   // exit when any key is pressed.
		{
			if(bIsFirstFrame==true )	
			{
				if(eDecStandard == VC1RCV_DEC )
				{
					bIsFirstFrame = false;
					continue;
				}
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if(bNoMoreStream==true)
			{
				if(eDecStandard == H264_DEC)
					MFC_StartDecodingOneFrame(CMD_CH0, uLastFrameSize, LAST_FRAME);
				else
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}

			else
			{
				uRet = VsParserForCrc1(true,   eDecStandard, uRdPtr, uAviFileSize,
						&pFileSteamAddr, &uChunkSize, false, &bVC1_field, &uComsumedFrameSize);
					
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
					uRemainSz -= uComsumedFrameSize;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}	
				else if(uRet==1)
				{					
					bNoMoreStream =true;
					bMustbeChecked = false;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
				}
				else
					Assert(0);
				
			}
			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsBufferFlushed())
				break;

			if(!bNoMoreStream)
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}

			if(uFrameCnt == 960)
				break;

			MFC_GetDispType(&eDispType);
			if(eDispType==DISP_ONLY)
				bPreFrameDispOnly=true;
			else 
				bPreFrameDispOnly=false;

			if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
				continue;

//			Delay(45);
			bProcessingDone = false;
			FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(eCh);
			while(!bProcessingDone);
			FIMC_StopProcessing(eCh);
		}
		Disp("\n");
		MFC_CloseInstance(uInstanceId);
	}

}
#else
static void TestMdnie_AviDec2(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;

	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 
	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
		return;

	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	
	
	uDramABaseAddr = uFwCodeStAddr;

	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr, uDramBBaseAddr);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}
	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;
	LCDC_InitIp(eBpp,uFreeMemBufA,eWin,false);
//	LCDC_InitBase();
//	LCDC_InitWin(eBpp,uAviHsize,uAviVsize,0,0,uAviHsize,uAviVsize,0,0,uFreeMemBufA,eWin,false);
//	LCDC_InitIp(eBpp, uFreeMemBufA, eWin, false);
//	LCDC_SetFreeRun(1);
//	LCDC_SetOutputPath(LCD_MDNIE);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_GetFbEndAddr(&uFreeMemBufA,eWin);

	uCpbBufStAddr = Align(uFreeMemBufA,2048);
/*	
//------------------------------- mDNIE setting --------------------------------//
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uLcdHSz, uLcdVSz);

	Disp("mDNIE setting done. Press any key to start test\n");
	UART_Getc();

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

//----------------------------------------------------------------------------------//
*/
	
	LCDC_Start();


	while(!UART_GetKey())
	{
		bIsFirstFrame = true;

		sRfile.filestart = uAviFileAddr;
		sRfile.offset = 0;
		sRfile.filesize = uAviFileSize;
		
		if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
		{
			Disp("Avi Open Fail");
			return;
		}
		
		Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

		uRemainSz = uAviFileSize;
		VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
		uRdPtr = pFileSteamAddr+uComsumedFrameSize;
		uRemainSz -= uComsumedFrameSize;
		
		if(pFileSteamAddr==0 && uChunkSize==0)
			return;

		MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

		if(eDecStandard==DivX311_DEC)
			MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

		Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
		MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
		MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
		MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
		MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

		FIMC_InitIpForDinDout(eCh,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		

		uFrameCnt = 0;

		while(UART_GetKey() == 0)   // exit when any key is pressed.
		{
			if(bIsFirstFrame==true )	
			{
				if(eDecStandard == VC1RCV_DEC )
				{
					bIsFirstFrame = false;
					continue;
				}
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if(bNoMoreStream==true)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_FRAME);
			}
			else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}

			else
			{
				uRet = VsParserForAvi(eDecStandard, uRdPtr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
					
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
					uRemainSz -= uComsumedFrameSize;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}	
				else if(uRet==1)
				{					
					bNoMoreStream =true;
					bMustbeChecked = false;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
				}
				else
					Assert(0);
				
			}
			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsBufferFlushed())
				break;

			if(!bNoMoreStream)
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}

			if(uFrameCnt == 960)
				break;

			MFC_GetDispType(&eDispType);
			if(eDispType==DISP_ONLY)
				bPreFrameDispOnly=true;
			else 
				bPreFrameDispOnly=false;

			if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
				continue;

//			Delay(45);
			bProcessingDone = false;
			FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(eCh);
			while(!bProcessingDone);
			FIMC_StopProcessing(eCh);
		}
		Disp("\n");
		MFC_CloseInstance(uInstanceId);
	}

}
#endif


void Test_DMC(void)
{
	int i, sel;

	const testFuncMenu menu[]=
	{
		0,                                  		"Exit",
		TestMdnie_AviDec,							"Test avi file decoding\n",
		TestMdnie_AviDec2,							"Test HD LCD avi file decoding\n",		
		0,											0
	};
	
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");

	eBpp = RGB24;
	eWin = WIN0;
	LCDC_InitLdi(MAIN);
	MFC_SetCmdChNum(TWO_CH_CMD);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	while(1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func)();
	}
}

//------------------------------------------------------------------------------------
static void TestTriple_AviDec(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;
	t_file_handler ImgHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 uImgAddr;
	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 
	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
		return;

	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	



//------------------  EINT31 setup ------------------------//
	GPIO_SetFunctionEach(eGPIO_H3, eGPIO_7, eGINT);
	GPIO_SetPullUpDownEach(eGPIO_H3, eGPIO_7, eGPUDdis);
	GPIO_SetEint33(7, Falling_Edge, eDisFLT, 0x1f); // EINT31, falling edge, enable filter, filter width
	GPIO_EINT33UnMask(7);
	INTC_SetVectAddr(NUM_EINT16_31, Isr_EInt31);
	INTC_Enable(NUM_EINT16_31); // Set interrupt controller enable
//--------------------------------------------------------//

	
	uDramABaseAddr = uFwCodeStAddr;
	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr,    uDramBBaseAddr);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}

	IEIP_Select(DISP_BYPASS);


	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;

	LCDC_InitLdiSel(LCD_LMS280GS01,MAIN);
//	LCDC_InitIpDualLsSel(LCD_LMS280GS01,RGB24, uLcdFbAddr, eWin, WIN1, false,LCD_PORTRAIT);
	LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eWin, WIN1, false,LCD_PORTRAIT);

	LCDC_InitGpioDualSel(LCD_LMS280GS01,LCD_DUAL);
	LCDC_SetDualDisplaySel(LCD_LMS280GS01,LINE_SPLIT,FIMD_DUAL,VDEN_EN);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
/*	
	LCDC_InitBaseSel(LCD_LMS280GS01);
	LCDC_InitWin(eBpp,uAviHsize,uAviVsize,0,0,uAviHsize,uAviVsize,0,0,uFreeMemBufA,eWin,false);
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
*/	
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_GetFbEndAddr(&uFreeMemBufA,eWin);

	uFreeMemBufA = uLcdFbAddr + (480*320*4);

	
	if(FS_Open("bourne.bin", &ImgHandler)!=0)
		return;
	if(FS_Read(&ImgHandler, ImgHandler.nSize, (u32 *)uFreeMemBufA, &uRealReadSize) !=0)
	{
		Disp("Read Fail\n");
		return;
	}	

	uImgAddr = uFreeMemBufA;

	uFreeMemBufA = uFreeMemBufA + ImgHandler.nSize;

	uCpbBufStAddr = Align(uFreeMemBufA,2048);
	
	LCDC_Start();


	while(!UART_GetKey())
	{
		bIsFirstFrame = true;

		sRfile.filestart = uAviFileAddr;
		sRfile.offset = 0;
		sRfile.filesize = uAviFileSize;
		
		if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
		{
			Disp("Avi Open Fail");
			return;
		}
		
		Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

		uRemainSz = uAviFileSize;
		VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
		uRdPtr = pFileSteamAddr+uComsumedFrameSize;
		uRemainSz -= uComsumedFrameSize;
		
		if(pFileSteamAddr==0 && uChunkSize==0)
			return;

		MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

		if(eDecStandard==DivX311_DEC)
			MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

		Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
		MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
		MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
		MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
		MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
		MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

		FIMC_InitIpForDinDout(eCh,
			uFrameHsz, uFrameVsz, 0,
			0, 0, uFrameHsz, uFrameVsz,
			0, TILE_NV12,
			uLcdHSz, uLcdVSz,
			0, 0, uLcdHSz, uLcdVSz, 0,		
			uLcdFbAddr, eBpp,		
			ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
		

		uFrameCnt = 0;

		while(UART_GetKey() == 0)   // exit when any key is pressed.
		{
			if(bIsFirstFrame==true )	
			{
				if(eDecStandard == VC1RCV_DEC )
				{
					bIsFirstFrame = false;
					continue;
				}
				bIsFirstFrame = false;
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}
			else if(bNoMoreStream==true)
			{
				MFC_StartDecodingOneFrame(CMD_CH0, 0, LAST_FRAME);
			}
			else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
			{
				MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
			}

			else
			{
				uRet = VsParserForAvi(eDecStandard, uRdPtr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
					
				if(uRet==3)
				{
					Disp("Parsing Error\n");
					return;
				}
				else if(uRet==0)
				{
					uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
					uRemainSz -= uComsumedFrameSize;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
				}	
				else if(uRet==1)
				{					
					bNoMoreStream =true;
					bMustbeChecked = false;
					Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
					MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
				}
				else
					Assert(0);
				
			}
			if(!MFC_WaitForFrameDone())
			{
				Disp("[DECODING ERR]\n");
				break;
			}
			if(MFC_IsBufferFlushed())
				break;

			if(!bNoMoreStream)
			{
				uFrameCnt++;
				Disp("[%d]",uFrameCnt);
			}

			if(uFrameCnt == 960)
				break;

			MFC_GetDispType(&eDispType);
			if(eDispType==DISP_ONLY)
				bPreFrameDispOnly=true;
			else 
				bPreFrameDispOnly=false;

			if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
				continue;

			Delay(45);
			bProcessingDone = false;
			FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
			FIMC_StartProcessingForMfc(eCh);
			while(!bProcessingDone);
			FIMC_StopProcessing(eCh);
		}
		Disp("\n");
		MFC_CloseInstance(uInstanceId);
	}
}


static void TestTriple_LCD(void)
{
	u32 i, uIdx;
	u32 uProcessIdx;
	u32 uRefCrcBufAddr;
	u32 uRefCrcFileSize;
	VIDEO_CODEC_TYPE eDecStandard;
	u32 uAviFileAddr;
	u32 uAviFileEndAddr;
	u32 uFreeMemBufA, uFreeMemBufB;
	u32 uDramABaseAddr, uDramBBaseAddr;
	char aCrcFileName[MAX_FILENAME_SIZE];
	char aAviFilePath[MAX_FILENAME_SIZE];
	char aRefCrcPath[MAX_FILENAME_SIZE];
	char aGotCrcPath[MAX_FILENAME_SIZE];
	char cFileExt[50];
	u32 uFwCodeStAddr;
	u32 uCpbBufStAddr;
	u32 uDpbBufEndAddr;
	u32 uInstanceId;
	u32 uFrameCnt;
	u8 bIsFirstFrame;
	u32 uPicHsz, uPicVsz;
	u32 uFrameHsz, uFrameVsz;
	u32 uAviHsize, uAviVsize;
	char cCodecName[50];
	t_file_handler AviHandler;
	t_file_handler CrcFileHandler;
	t_file_handler FwHandler;
	t_file_handler ImgHandler;	
	u32 uErrorCnt=0;
	u32 uReadSizeUnit;
	MFC_PIC_TYPE ePictype;
	u8 binterlace=false;
	u32 uGenCrcSize=0;
	u32 uOneFrameCrcSize;
	u32 uSizeIdx;
	int uChunkSize;
	u32 uAviFileSize;
	u32 pFileSteamAddr;
	u8 bLastFrame=false;
	u8 bMustbeChecked=true;
	u8 bChunkEmpty=false;
	u8 bNoMoreStream = false;
	u32 uTotCrcSize;
	u32 uCurCrcBufStAddr;
	u32 uRealReadSize;
	u32 uAviFileBufEndAddr;
	RFILE sRfile;
	u8 bVC1_field;
	u32 uComsumedFrameSize;
	u32 uRet;
	bool uLastFrameSize;
	u32 uRdPtr;
	bool bPreFrameDispOnly=false;
	u32 uRemainSz;
	u32 uLcdHSz, uLcdVSz;
	MFC_DISP_TYPE eDispType;
	u32 uDisplayAddrOfY, uDisplayAddrOfC;
	u32 uRawStreamBufStAddr=0x22000000;
	MFC_PIC_TYPE ePicType;
	u8 bInterlace;
	u32 uFirstFrame;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 uImgAddr;
	
	ebDecStandard=true;

	uFwCodeStAddr = 0x20000000;	
	uAviFileAddr = 0x41000000;

	// 1. Stream load 

//	if(FS_OpenFromDirlist("mfc", &AviHandler, 0, true, aFileName, cFileExt)!=0)
//		return;

	if(FS_Open("x264_bon.avi", &AviHandler)!=0)
		return;


	if(FS_Read(&AviHandler, AviHandler.nSize, (u32 *)uAviFileAddr, &uRealReadSize) !=0)
	{
		Disp("Stream Read Fail\n");
		return;
	}
	uAviFileSize =   AviHandler.nSize;

	uDramBBaseAddr = Align(uAviFileAddr+AviHandler.nSize, 128*1024);

	// 3. FW load
	if(FS_Open("mfd_vo.bin", &FwHandler)!=0)
		return;
	if(FS_Read(&FwHandler, FwHandler.nSize, (u32 *)uFwCodeStAddr, &uRealReadSize) !=0)
	{
		Disp("F/W Read Fail\n");
		return;
	}	

	INTC_SetVectAddr(NUM_MFC, Isr_Mfc);
	INTC_Enable(NUM_MFC);
	INTC_SetVectAddr(NUM_FIMC_A, Isr_ProcessingDone);
	INTC_Enable(NUM_FIMC_A);	



//------------------  EINT31 setup ------------------------//
	GPIO_SetFunctionEach(eGPIO_H3, eGPIO_7, eGINT);
	GPIO_SetPullUpDownEach(eGPIO_H3, eGPIO_7, eGPUDdis);
	GPIO_SetEint33(7, Falling_Edge, eDisFLT, 0x1f); // EINT31, falling edge, enable filter, filter width
	GPIO_EINT33UnMask(7);
	INTC_SetVectAddr(NUM_EINT16_31, Isr_EInt31);
	INTC_Enable(NUM_EINT16_31); // Set interrupt controller enable
//--------------------------------------------------------//

	MFC_LoadFirmwareIntoIp(1, uFwCodeStAddr,    uDramBBaseAddr);
	MFC_GetFwWorkBufEndAddr(&uCpbBufStAddr);

	sRfile.filestart = uAviFileAddr;
	sRfile.offset = 0;
	sRfile.filesize = uAviFileSize;
	
	if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
	{
		Disp("Avi Open Fail");
		return;
	}

	IEIP_Select(DISP_BYPASS);


	uFreeMemBufA = Align(uCpbBufStAddr,0xe00000);
	uLcdFbAddr = uFreeMemBufA;

	uFreeMemBufA = uLcdFbAddr + (480*320*4);

	
	if(FS_Open("glib16bpp.bin", &ImgHandler)!=0)
		return;
	if(FS_Read(&ImgHandler, ImgHandler.nSize, (u32 *)uFreeMemBufA, &uRealReadSize) !=0)
	{
		Disp("Read Fail\n");
		return;
	}	

	uImgAddr = uFreeMemBufA;

	uFreeMemBufA = uFreeMemBufA + ImgHandler.nSize;

	uCpbBufStAddr = Align(uFreeMemBufA,2048);




	while(1)
	{
		while(bisRGBif)
		{



		LCDC_Stop();

		LCDC_InitLdiSel(LCD_LMS280GS01,MAIN);
//		LCDC_InitIpDualLsSel(LCD_LMS280GS01,RGB24, uLcdFbAddr, eWin, WIN1, false,LCD_PORTRAIT);
		LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eWin, WIN1, false,LCD_PORTRAIT);

		LCDC_InitGpioDualSel(LCD_LMS280GS01,LCD_DUAL);
		LCDC_SetDualDisplaySel(LCD_LMS280GS01,LINE_SPLIT,FIMD_DUAL,VDEN_EN);
		LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);

		LCDC_EnableAllWinFifoLvlInt(EMPTY);
		
		LCDC_Start();



			bIsFirstFrame = true;

			sRfile.filestart = uAviFileAddr;
			sRfile.offset = 0;
			sRfile.filesize = uAviFileSize;
			
			if(parse_avi_header(&sRfile, uAviFileAddr, uAviFileSize, &eDecStandard,  &uAviHsize, &uAviVsize) == 0)
			{
				Disp("Avi Open Fail");
				return;
			}
			
			Disp("AviHsize:%d, AviVsize:%d\n ",uAviHsize, uAviVsize);

			uRemainSz = uAviFileSize;
			VsParserForAvi(eDecStandard, uAviFileAddr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);

			uRdPtr = pFileSteamAddr+uComsumedFrameSize;
			uRemainSz -= uComsumedFrameSize;
			
			if(pFileSteamAddr==0 && uChunkSize==0)
				return;

			MFC_InitProcessForDecoding(0, eDecStandard, bPixelCacheEn, false, true);  // mpeg4Dec, pixel_cache disable 

			if(eDecStandard==DivX311_DEC)
				MFC_SetDivX311ImgSize(uAviHsize, uAviVsize);

			Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
			MFC_ParseStreamHeaderAndSetBuf(CMD_CH0, uCpbBufStAddr, uChunkSize);
			MFC_GetInstanceId(&uInstanceId, &uProcessIdx);
			MFC_GetTwoMastersDbpBufEndAddr(uProcessIdx, &uFreeMemBufA, &uFreeMemBufB);
			MFC_GetImagePicSize(&uPicHsz, &uPicVsz);
			MFC_GetImageFrameSize(&uFrameHsz, &uFrameVsz);

			FIMC_InitIpForDinDout(eCh,
				uFrameHsz, uFrameVsz, 0,
				0, 0, uFrameHsz, uFrameVsz,
				0, TILE_NV12,
				uLcdHSz, uLcdVSz,
				0, 0, uLcdHSz, uLcdVSz, 0,		
				uLcdFbAddr, eBpp,		
				ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);
			

			uFrameCnt = 0;

			while(bisRGBif)   // exit when any key is pressed.
			{
				if(bIsFirstFrame==true )	
				{
					if(eDecStandard == VC1RCV_DEC )
					{
						bIsFirstFrame = false;
						continue;
					}
					bIsFirstFrame = false;
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
				}
				else if(bNoMoreStream==true)
				{
					if(eDecStandard == H264_DEC)
						MFC_StartDecodingOneFrame(CMD_CH0, uLastFrameSize, LAST_FRAME);
					else
						MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
				}
				else if((eDecStandard == H264_DEC) && (bPreFrameDispOnly) && (bNoMoreStream==false))
				{
					MFC_StartDecodingOneFrameOfTheBuffer(CMD_CH0);
				}

				else
				{
					uRet = VsParserForAvi(eDecStandard, uRdPtr, uAviFileSize, &pFileSteamAddr, &uChunkSize, &uComsumedFrameSize);
						
					if(uRet==3)
					{
						Disp("Parsing Error\n");
						return;
					}
					else if(uRet==0)
					{
						uRdPtr = (u32)pFileSteamAddr+uComsumedFrameSize;
						uRemainSz -= uComsumedFrameSize;
						Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
						MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, FRAME);
					}	
					else if(uRet==1)
					{					
						bNoMoreStream =true;
						bMustbeChecked = false;
						Copy8((u32)pFileSteamAddr, uCpbBufStAddr, uChunkSize);
						MFC_StartDecodingOneFrame(CMD_CH0, uChunkSize, LAST_FRAME);
					}
					else
						Assert(0);
					
				}
				if(!MFC_WaitForFrameDone())
				{
					Disp("[DECODING ERR]\n");
					break;
				}
				if(MFC_IsBufferFlushed())
					break;

				if(!bNoMoreStream)
				{
					uFrameCnt++;
					Disp("[%d]",uFrameCnt);
				}

				if(uFrameCnt == 1500)
					break;

				MFC_GetDispType(&eDispType);
				if(eDispType==DISP_ONLY)
					bPreFrameDispOnly=true;
				else 
					bPreFrameDispOnly=false;

				if (MFC_GetDisplayFbAddr(&uDisplayAddrOfY, &uDisplayAddrOfC) == false)
					continue;

				Delay(45);
				bProcessingDone = false;
				FIMC_SetDinImgAddrForMfc(eCh, TILE_NV12, uDisplayAddrOfY, uDisplayAddrOfC);
				FIMC_StartProcessingForMfc(eCh);
				while(!bProcessingDone);
				FIMC_StopProcessing(eCh);
			}
			Disp("\n");
			MFC_CloseInstance(uInstanceId);
		}


		LCDC_Stop();
		
		LCDC_InitLdiSel(LCD_UF24U276A,MAIN);

		LCDC_PutCmdToLdiByManual(0x2c, MAIN);

		while(!bisRGBif)
		{
		for (i=0; i<240*320; i++)
			{
				LCDC_PutDataToLdiByManual(*((u16*)(uImgAddr+i*2)), MAIN);
			}
		}

		LCDC_PutCmdToLdiByManual( 0x28,MAIN); Delay(1);	// Diaplay On


	}
	
}





void Test_Triple(void)
{
	int i, sel;

	const testFuncMenu menu[]=
	{
		0,                                  		"Exit",
		TestTriple_AviDec,						"Test Triple avi file decoding",
		TestTriple_LCD,							"Test Triple LCD\n",
		0,											0
	};

	
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");

	eBpp = RGB24;
	eWin = WIN0;

	InitSysconForFIMD();
	SYSC_InitClkForMM();
	
	MFC_SetCmdChNum(TWO_CH_CMD);

	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	
	while(1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func)();
	}
}





