/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : mDNIe.h
*  
*	File Description : This file declares prototypes of mDNIe API funcions.
*
*	Author : Woojin,Kim
*	Dept. : AP Application
*	Created Date : 2009/01/22
*	Version : 0.1 
* 
*	History
*	- Created(Woojin,Kim 2009/01/22)
*  
**************************************************************************************/

#ifndef __mDNIe_H__
#define __mDNIe_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"
#include "lcd.h"

#define DBG_MDNIE 1
#define DBG_IELCDC 1

typedef enum
{
	HDTRonly,HDTRwCP,HDTRwVE
} ALGO_SEL;

typedef enum
{
	MCM,NOMCM
} MCM_SEL;

typedef enum
{
	LPA,NOLPA
} LPA_SEL;

typedef enum
{
	MDNIE_MASK,MDNIE_UNMASK
} MODE_CHANGE_MASK;

typedef enum
{
	CEon,CEoff
}CE_ENABLE;

typedef enum
{
	SKIN_ON,SKIN_OFF
}SKIN_ENABLE;

typedef enum
{
	DUAL_EN,DUAL_DIS
} MIE_DUAL_EN;



void MDNIE_SelectMode(ALGO_SEL eAlgoSel, MCM_SEL eMcmSel, LPA_SEL eLpaSel);
void MDNIE_SelectModeMask(MODE_CHANGE_MASK eModeMask);
void MDNIE_SetSize(u32 uHSize, u32 uVSize);

void MDNIE_SetDeContour_Th(u32 uDeConVal);
void MDNIE_SetDirectional_Th(u32 uDirecVal);
void MDNIE_SetSimplicity_Th(u32 uSimpVal);
void MDNIE_SetEdgeEnhance(u32 uEdgeEnh);
void MDNIE_SetEdgeDetect(u32 uEdgeDet);
void MDNIE_SetCEenable(CE_ENABLE eCEsel);
void MDNIE_SetCECurve(u32 uCEcurve);
void MDNIE_SetSkinEnable(SKIN_ENABLE eSkinSel);
void MDNIE_SetCScontrol(u32 uCScontrol);


void IELCDIP_Select(MDNIE_SEL eSel);
void IELCDC_InitGpioMux(CPUIF_LDI eLdiMode);
void IELCDC_InitLdi(CPUIF_LDI eLdiMode);	
void IELCDC_InitIp(void);
void IELCDC_InitBase(void);	
void IELCDC_Start(void);
void IELCDC_LogicStart(void);
void IELCDC_LogicStop(void);
void IELCDC_Stop(void); // Direct off
void IELCDC_PerFrameOff(void);


void IELCDC_InitWin(IMG_FMT eBpp, u32 uFrameH, u32 uFrameV, u32 uX_Frame, u32 uY_Frame,  u32 uViewH, u32 uViewV,
		u32 uX_Lcd, u32 uY_Lcd, u32 uFbAddr, LCD_WINDOW eWin, bool bIsDoubleBuf); // For WIN0
// In Fifo Input mode, Interface Data Format is RGB	

void IELCDC_SetWinOnOff(u32 uOnOff, LCD_WINDOW eWin);
void IELCDC_SetViewPosOnLcd(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin);
void IELCDC_SetViewPosOnFrame(u32 uX_Frame, u32 uY_Frame, LCD_WINDOW eWin); // For WIN0~4

void IELCDC_GetDoubleBufAddr(u32* uFbAddr, u32 uWhichAddr, LCD_WINDOW eWin);
void IELCDC_GetBufIdx(u32* uBufNum, LCD_WINDOW eWin);
void IELCDC_SetColorMapOnOff(u32 uOnOff, LCD_WINDOW eWin);
void IELCDC_SetRgbFormat(PNR_MODE ePnr);
void IELCDC_SetByteSwap(SWAP_MODE eBitSwap, SWAP_MODE eByteSwap, SWAP_MODE eHawSwap, SWAP_MODE eWordSwap, LCD_WINDOW eWin);	
void IELCDC_SetColorKeyOnOff(u32 uOnOff, LCD_WINDOW eWin);
void IELCDC_SetScanMode(SCAN_MODE eScanMode);
void IELCDC_SetOutputPath(LCD_LOCAL_OUTPUT eOutLocal);
void IELCDC_SetClkVal(u8 uClkVal);
void IELCDC_GetLcdSz(u32* uLcdHSz, u32* uLcdVSz);
void IELCDC_GetFrmSz(u32* uFrmHSz, u32* uFrmVSz, LCD_WINDOW eWin);
void IELCDC_GetFbStAddr(u32* uFbAddr, LCD_WINDOW eWin);
void IELCDC_GetFbEndAddr(u32* uFbAddr, LCD_WINDOW eWin);
void IELCDC_GetImgStAddr(u32* uImgStAddr, LCD_WINDOW eWin);
void IELCDC_InitIpForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin);
void IELCDC_InitWinForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin);
void IELCDC_InitWinForFifoIn1(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS);
void IELCDC_InitWinForFifoIn2(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS, u32 uLcdHsize, u32 uLcdVsize);
void IELCDC_InitWinForFifoIn3(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd);
void IELCDC_InitWinForFifoIn4 (LOCAL_IF_TYPE eLocalInCS, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd);
void IELCDC_WTrigger(LCD_WINDOW eWin);

/////////////////////////////////////////////////////////////////////////////////////
// CPU-IF LCD
/////////////////////////////////////////////////////////////////////////////////////	
void IELCDC_Trigger(void);	
void IELCDC_SetCpuIfDataFormat(CPUIF_LDI eLdiMode, CPUIF_DATA_FORMAT eFormat);
void IELCDC_SetCpuIfTiming(u8 ucWrActTime, u8 ucWrHoldTime, CPUIF_LDI eLdi);	
bool IELCDC_IsFrameDone(void);
void IELCDC_SetFrameSkipRate(CPU_FRAME_SKIP eFrmSkip, CPUIF_LDI eLdi);
void IELCDC_SetAutoCmdRate(CPU_AUTO_CMD_RATE eCmdRate, CPUIF_LDI eLdi);
void IELCDC_DisplayPartialArea(u32 uSrcStX, u32 uSrcStY, u32 uDstStX, u32 uDstStY, 
	u32 uPartialHSz, u32 uPartialVsz, u32 uSrcFbStAddr, LCD_WINDOW eWin);
void IELCDC_SetTriggerMode(TRIGGER_MODE eTrig);


void IELCDC_InitLts222QForRgbif(void);
void IELCDC_InitLtv350QVForRgbif(void);
void IELCDC_InitLts222QForI80if(CPUIF_LDI eLdiMode);
void IELCDC_InitS6D0139ForI80if(CPUIF_LDI eLdiMode);

// Manual
void IELCDC_PutCmdToLdiByManual(u32 uData, CPUIF_LDI eLdiMode);
void IELCDC_PutDataToLdiByManual(u32 uData, CPUIF_LDI eLdiMode);
void IELCDC_GetCmdFromLdiByManual(u32* uCmd, CPUIF_LDI eLdiMode );
void IELCDC_GetDataFromLdiByManual(u32* uData, CPUIF_LDI eLdiMode );
// Normal/ Auto/ NormalNAuto way
void IELCDC_PutCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode);
void IELCDC_PutDataToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode);
void IELCDC_PutDataOrCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode, bool IsCmd);	

//void IELCDC_InitStartPosOnLcdI80If(CPUIF_LDI eLdiMode);
// uclkDir: 1 -> divieded clk. uClkDir: 0 -> direct clk.
void IELCDC_GetClkValAndClkDir(u32 uLcdHSz, u32 uLcdVSz, u32* uClkVal, u32* uClkDir);
void IELCDC_InitWinRegs(LCD_WINDOW eWin);
void IELCDC_WriteCmd(u32 uAddr, u32 uData);
void IELCDC_SetRsOnOff(u32 uOnOff);
void IELCDC_SetnWE(u32 uLowHigh);
void IELCDC_InitStartPosOnLcd(CPUIF_LDI eLdiMode);	
void IELCDC_DisableInterrupt(void);
void IELCDC_EnableAllWinFifoLvlInt(LCDC_FIFO_LEVEL eFifoLvl);
void IELCDC_EnableAllWinFrameInt(LCDC_FRAME_INT_SEL eIntSel);
void IELCDC_SetAllWinIntCnt(LCDC_FIFO_LEVEL eFifoLvl, LCDC_FRAME_INT_SEL eIntSel);
void IELCDC_DisableIntFifoLevel(LCD_WINDOW eWin);
void IELCDC_DisableFifoInterrupt(void);
void IELCDC_EnableInterrupt(void);
void IELCDC_ClearPending(u32 uIntFlag);
void IELCDC_GetIntFlag(u32* pFlag);

void IELCDC_SetDualDisplay(LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual,LCD_DUAL_VDEN_EN eSelVden);
void IELCDC_InitIpDualFs(LCD_SCAN_TYPE eScan);
void IELCDC_InitIpDualLs(LCD_SCAN_TYPE eScan);
void IELCDC_InitBaseDualFs(void);
void IELCDC_InitBaseDualLs(void);;

#endif


