/**************************************************************************************
* 
*	Project Name : S5PV210 validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File name : mDNIe_test.c
*
*	File Description : This file implements test codes of mDNIe
*
*	Author : Woojin,Kim
*	Dept : AP application
*	Created Date : 2009/01/22
*	Version	: v0.1
*
*	History 
*		- Created(Woojin.Kim 2006/12/27)
*
******************************************************************************/

#include "system.h"
#include "sysc.h"
#include "util.h"
#include "lcd.h"
#include "intc.h"
#include "glib.h"
#include "option.h"
#include "library.h"
#include "timer.h"
//#include "sun320240_24bpp.h"
#include "mDNIe_QVGA_320x240_02.h"
#include "mDNIe.h"

const static u32 uLcdFbAddr = CODEC_MEM_ST;
static u32 uHSize, uVSize;


void __irq Isr_IELcdcUnderRun (void)
{
	u32 uIntFlag;

//	INTC_Disable(INT_LCD1);
//	LCDC_DisableInterrupt();

	IELCDC_GetIntFlag(&uIntFlag);
	
	Disp("[IE FIFO UnderRun]\n");

	IELCDC_ClearPending(uIntFlag);
	
	INTC_ClearVectAddr();	

//	INTC_Enable(INT_LCD1);
//	LCDC_EnableInterrupt();
}

  
void __irq Isr_IELcdcFrameInt(void) 
 {
	u32 uIntFlag;

	Disp("[IE FRAME]");
	INTC_Disable(NUM_LCD1);
	IELCDC_DisableInterrupt();

	IELCDC_GetIntFlag(&uIntFlag);
	IELCDC_ClearPending(uIntFlag);

	INTC_ClearVectAddr();

	GPIO_SetDataEach(eGPIO_D0,eGPIO_2, 0x0);		// pwm_TOUT3 as Output Data Low
	Delay(5);
	GPIO_SetDataEach(eGPIO_D0,eGPIO_2, 0x1);		// Data High


	INTC_Enable(NUM_LCD1);
	IELCDC_EnableInterrupt();
}


void InitSysconForMDNIE(void)
{
	// T-Block Power Off and On
	SYSC_SetBlockPowerOFF_IP(eMDNIE);
	DelayfrTimer(milli, 100);
	SYSC_SetBlockPowerON_IP(eMDNIE);

	// IP Clock Off and On
	SYSC_SetClkOFF_IP(eMDNIE);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eMDNIE);
}





void Test_mDNIE_GoldenIMGview(void)
{
	u32 i,j,k;
	u32 uHSz,uVSz;

	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24, 320, 240, 0, 0, 320, 240, 0, 0, uLcdFbAddr, WIN0, false);
//	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);

	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);

/*
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/	

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	LCDC_Start();

	Disp("Press any key to see original Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, IN_RGB_QVGA_320X240_02[k++]);
		}

	Disp("Press any key to see DEBLOCK out \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, DEBLOCK_OUT_RGB_QVGA_320X240_02[k++]);
		}

	Disp("Press any key to see HDTR only Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02[k++]);
		}

	Disp("Press any key to see HDTR with OVE Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE[k++]);
		}

	Disp("Press any key to see HDTR with OVE and MCM Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE_MCM[k++]);
		}


	Disp("Press any key to see HDTR with OVE, MCM and LPA Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE_MCM_LPA[k++]);
		}



	
}



void Test_mDNIE_ModeSelect(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 i,j,k;
	u32 uHSz,uVSz;
	u8 cGetc;

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);


	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);
	
/*
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/
/*

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);

	Disp("Press any key to load original Image \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, IN_RGB_QVGA_320X240_02[k++]);
		}

*/


	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

	
	LCDC_Start();



	Disp("press anykey to start loop");
	
	UART_Getc();

/*	
		
	for(i=0; i<100 ; i++)
	{
	Delay(1000);
	Outp32(0xfae00084,0x0);
	Outp32(0xfae00084,0x40);
	}
	*/
/*
	while(1)
	{
	Disp("Press Enterkey to stop test, otherkey will go on mode change test\n");
	cGetc = UART_Getc();

	if(cGetc == '\r')
	{
	break;
	}
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	
	Disp("mDNIe ModeChange Done \n");
	
	}

*/

}


void Test_mDNIE_StreamModeSelect(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 uFbAddrTmp, uTmpFrmNum;
	u32 i,j,k;
	u32 uHSz,uVSz;
	u8 cGetc;


	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);

	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);


	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);
/*
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/


	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);

	Disp("Press any key to load original Image \n");
	UART_Getc();
/*	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, IN_RGB_QVGA_320X240_02[k++]);
		}
*/


	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

	
	LCDC_Start();

	Disp("How many frame are you going to play ? ");
	uTmpFrmNum = UART_GetIntNum();
	Disp("\n");


	while(1)
	{

	i = 0;
	Disp("Press any key to stop stream and change mode\n");	

		while(!UART_GetKey())
		{
			if( i >= uTmpFrmNum )
				i = 0;
			
			
			uFbAddrTmp = uLcdFbAddr + (uHSz * uVSz * 4 * i );

			LCDC_SetWinShadowP(WIN0, 1);
			LCDC_SetWinFrmBfAddr(uFbAddrTmp, WIN0, false);
			LCDC_SetWinShadowP(WIN0, 0);
			i++;
			Delay(3000);
		}

	
	Disp("Press Enterkey to stop test, otherkey will go on mode change test\n");
	cGetc = UART_Getc();

	if(cGetc == '\r')
	{
		break;
	}



	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	
	Disp("mDNIe ModeChange Done \n");
	
	}

}


void Test_mDNIE_ModeCompare(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 i,j,k;
	u32 uHSz,uVSz;
	u8 cGetc;
	u32 uFbAddrA, uFbAddrB, uFbAddrC, uFbAddrD;

	// uLcdFbAddr  = Input SRC address
	uFbAddrA = uLcdFbAddr + (320 * 240 *4 ); 	// uFbAddrA = HDTR + DE on golden data address
	uFbAddrB = uFbAddrA + (320 * 240 *4 ); 	// uFbAddrB = HDTR + DE + OVE on  golden data address
	uFbAddrC = uFbAddrB + (320 * 240 *4 );	// uFbAddrC = HDTR + DE + OVE + MCM on  golden data address
	uFbAddrD = uFbAddrC + (320 * 240 *4 );	// uFbAddrD = HDTR + DE + OVE + MCM + LPA on  golden data address


	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24, 320, 240, 0, 0, 320, 240, 0, 0, uLcdFbAddr, WIN0, false);
	
//	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);

	LCDC_InitWin(RGB24, 320, 240,0,0,320,240,0,0,uFbAddrA,WIN1,false);
	LCDC_SetWinOnOff(0,WIN1);



	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);

	Disp("Press any key to Load Golden Images \n");
	UART_Getc();
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, IN_RGB_QVGA_320X240_02[k++]);
		}
////////////////////////
	GLIB_InitInstance(uFbAddrA, uHSz, uVSz, RGB24);
	Disp("Loading HDTR only Image \n");
	
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02[k++]);
		}
////////////////////////
	GLIB_InitInstance(uFbAddrB, uHSz, uVSz, RGB24);
	Disp("Loading HDTR with OVE Image \n");
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE[k++]);
		}
////////////////////////
	GLIB_InitInstance(uFbAddrC, uHSz, uVSz, RGB24);
	Disp("Loading HDTR with OVE and MCM Image \n");
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE_MCM[k++]);
		}
////////////////////////
	GLIB_InitInstance(uFbAddrD, uHSz, uVSz, RGB24);
	Disp("Loading HDTR with OVE, MCM and LPA Image \n");
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, HDTR_OUT_RGB_QVGA_320X240_02_OVE_MCM_LPA[k++]);
		}

	Disp("Press any key to see HDTR image from mDNIE\n");
	UART_Getc();
	
	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(HDTRonly, NOMCM, NOLPA);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();

	
	LCDC_Start();

	i = 0;
	
	while(1)
		{
			switch(i)
			{
			case 0 :		eAlgoModeSel = HDTRonly;
						eMcmModeSel = NOMCM;
						eLpaModeSel = NOLPA;
						LCDC_SetWinFrmBfAddr(uFbAddrA,WIN1,false);
						Disp("HDTR only mode \n");
						break;
			case 1 :		eAlgoModeSel = HDTRwVE;
						eMcmModeSel = NOMCM;
						eLpaModeSel = NOLPA;
						LCDC_SetWinFrmBfAddr(uFbAddrB,WIN1,false);						
						Disp("HDTR + VE mode \n");
						break;
			case 2 :		eAlgoModeSel = HDTRwVE;
						eMcmModeSel = MCM;
						eLpaModeSel = NOLPA;
						LCDC_SetWinFrmBfAddr(uFbAddrC,WIN1,false);						
						Disp("HDTR + VE + MCM mode \n");
						break;
			case 3 :		eAlgoModeSel = HDTRwVE;
						eMcmModeSel = MCM;
						eLpaModeSel = LPA;
						LCDC_SetWinFrmBfAddr(uFbAddrD,WIN1,false);						
						Disp("HDTR + VE + MCM + LPA mode \n");
						break;
			default :		break;
			}


		MDNIE_SelectModeMask(MDNIE_MASK);
		MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
		MDNIE_SelectModeMask(MDNIE_UNMASK);

		Disp("Press 'r' key to see Golden data \n");
		Disp("Press 'e' key to see mDNIe pass data \n");
		Disp("Press 'n' key to see next mode \n");
		Disp("Press 'b' key to see previous mode \n");
		Disp("Press 'Enter' key to stop Compare test \n");
		cGetc = UART_Getc();

			switch(cGetc)
			{
				case 'r' :		SYSC_SetDispPath(eDISP_BYPASS);
								IEIP_Select(DISP_BYPASS);
								LCDC_SetWinOnOff(0,WIN0);
								LCDC_SetWinOnOff(1,WIN1);
								break;

				case 'e' :		SYSC_SetDispPath(eDISP_MDNIE);
								IEIP_Select(DISP_MDNIE);
								LCDC_SetWinOnOff(1,WIN0);
								LCDC_SetWinOnOff(0,WIN1);
								break;

				case 'n' :		i = i + 1;
								break;

				case 'b' :		i = i -1 ;
								break;

				case '\r' :		break;
					

			}
		if(cGetc == '\r')
			break;

		}
	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);

}



void Test_mDNIE_DualLCD(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 i,j,k,h;
	u32 uHSz,uVSz;
	u8 cGetc;

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);

//******************* FIMD Dual LCD setting ***************************
	Disp("[0] LCD Landscape Scan type \n");
	Disp("[1] LCD Portrait Scan type \n");
	Disp("Select LCD Scan type  :");
	h = UART_GetIntNum();
	Disp("\n");
	LCDC_InitLdi(MAIN);
	if(h == 0)
	{
	LCDC_InitBaseDualFs();
	LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, WIN0, false);
//	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, WIN0,WIN1, false,LCD_LANDSCAPE);
	}
	else
	{
	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, WIN0,WIN1, false,LCD_PORTRAIT);
	}

	LCDC_SetDualDisplay(FRAME_SPLIT,MDNIE_DUAL,VDEN_DIS);
	LCDC_InitGpioDualLCD(LCD_DUAL);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);

//******************************************************************************
//*********************************mDNIe setting***********************************
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;


	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	LCDC_GetLcdSz(&uHSz,&uVSz);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

//*****************************************************************************


//****************************IELCD Dual LCD setting********************************
	IELCDIP_Select(DISP_MDNIE);

	if(h == 0)
	{
	IELCDC_InitIpDualFs(LCD_LANDSCAPE);
	}
	else
	{
	IELCDC_InitIpDualFs(LCD_PORTRAIT);
	}
	IELCDC_SetDualDisplay(FRAME_SPLIT,MDNIE_DUAL,VDEN_DIS);


	IELCDC_Start();
	LCDC_Start();
	Disp("press anykey to start loop");
	
	UART_Getc();

/*	
		
	for(i=0; i<100 ; i++)
	{
	Delay(1000);
	Outp32(0xfae00084,0x0);
	Outp32(0xfae00084,0x40);
	}
	*/
/*
	while(1)
	{
	Disp("Press Enterkey to stop test, otherkey will go on mode change test\n");
	cGetc = UART_Getc();

	if(cGetc == '\r')
	{
	break;
	}
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	
	Disp("mDNIe ModeChange Done \n");
	
	}

*/

}





void Test_mDNIE_DE(void)
{
	u32 uTmpReg;
	u32 uTmpVal;
	u32 uSelNum;

	Disp("\n1. DeContour Threshold     2. Directional Threshold     3. Simplicity Threshold \n");
	Disp("4. Edge Enhance control    5. edge detect control \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();


	switch(uSelNum)
	{

	case 1 : 
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount threshold value till Max value (4095)\n ");				
				while(uTmpVal < 4095)
				{
					Disp(" DeContour Threshold = %d\n ",uTmpVal);
					MDNIE_SetDeContour_Th(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 100;
				}
				
			 	uTmpVal = 4095;
				Disp(" DeContour Threshold = %d (MAX VALUE)\n",uTmpVal);

				MDNIE_SetDeContour_Th(uTmpVal);		
				
				Disp("\n Press any key to end DeContour Threshold test \n");
				UART_Getc();

				uTmpVal = 120;
				Disp(" DeContour Threshold = %d (Default VALUE)\n\n",uTmpVal);		
				MDNIE_SetDeContour_Th(uTmpVal);
				break;

	case 2 : 

				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount threshold value till Max value (4095)\n ");		
				while(uTmpVal < 4095)
				{
					Disp(" Directional Threshold = %d \n",uTmpVal);
					MDNIE_SetDirectional_Th(uTmpVal);


					UART_Getc();
					
					uTmpVal = uTmpVal + 100;
				}
				
			 	uTmpVal = 4095;
				Disp(" Directional Threshold = %d (MAX VALUE)\n",uTmpVal);

				MDNIE_SetDirectional_Th(uTmpVal);		
				
				Disp("\n Press any key to end Directional Threshold test \n");
				UART_Getc();

				uTmpVal = 40;
				Disp(" Directional Threshold = %d (Default VALUE)\n\n",uTmpVal);		
				MDNIE_SetDirectional_Th(uTmpVal);
				break;

	case 3 :
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount threshold value till Max value (92) \n");		
				
				while(uTmpVal < 92)
				{
			
					Disp(" Simplicity Threshold = %d\n ",uTmpVal);
					MDNIE_SetSimplicity_Th(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 10;
				}
				
			 	uTmpVal = 92;
				Disp(" Simplicity Threshold = %d (MAX VALUE)\n",uTmpVal);

				MDNIE_SetSimplicity_Th(uTmpVal);		
				
				Disp("\n Press any key to end Simplicity Threshold test \n");
				UART_Getc();

				uTmpVal = 30;
				Disp(" Simplicity Threshold = %d (Default VALUE)\n\n",uTmpVal);		
				MDNIE_SetSimplicity_Th(uTmpVal);
				break;


	case 4:
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount control value till Max value (127) \n");		
				
				while(uTmpVal < 127)
				{
				
					Disp(" Edge Enhance control value  = %d\n ",uTmpVal);
					MDNIE_SetEdgeEnhance(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 10;
				}
				
			 	uTmpVal = 127;
				Disp(" Edge Enhance control value = %d (MAX VALUE)\n",uTmpVal);

				MDNIE_SetEdgeEnhance(uTmpVal);		
				
				Disp("\n Press any key to end Edge Enhance control test \n");
				UART_Getc();

				uTmpVal = 20;
				Disp(" Edge Enhance control value  = %d (Default VALUE)\n\n",uTmpVal);		
				MDNIE_SetEdgeEnhance(uTmpVal);
				break;

	case 5:
				Disp("\n Press any key to test \n");
				UART_Getc();
				uTmpVal = 0;

				Disp(" Press Anykey to upcount control value till Max value (1023) \n");		
				
				while(uTmpVal < 1023)
				{
				
					Disp(" Edge Detect control value  = %d\n ",uTmpVal);
					MDNIE_SetEdgeDetect(uTmpVal);

					UART_Getc();

					uTmpVal = uTmpVal + 100;
				}
				
			 	uTmpVal = 1023;
				Disp(" Edge Detect control value = %d (MAX VALUE)\n",uTmpVal);

				MDNIE_SetEdgeDetect(uTmpVal);		
				
				Disp("\n Press any key to end Edge Detect control test \n");
				UART_Getc();

				uTmpVal = 300;
				Disp(" Edge Detect control value  = %d (Default VALUE)\n\n",uTmpVal);		
				MDNIE_SetEdgeDetect(uTmpVal);
				break;

	default:
				break;
	
	}

}



void Test_mDNIE_CE(void)
{
	u8 cTmpChar;
	u32 uTmpReg;
	u32 uTmpVal;
	u32 uSelNum;

	Disp("\n1. Contrast Enhancement on/off     2. CE Curve control\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();


	if (uSelNum == 1)
	{
		Disp("\n 'x' key will turn off Contrast Enhancement ,   'z' key will turn on contrast Enhancement\n");
		Disp(" To end this test, Press Enter key\n");

		while(1)
		{
			cTmpChar = UART_Getc();
			if (cTmpChar == 'x')
			MDNIE_SetCEenable(CEoff);
			else if (cTmpChar == 'z')
			MDNIE_SetCEenable(CEon);
			else if (cTmpChar == '\r')
			break;
			
		}

	}

	else if (uSelNum == 2)
	{
		uTmpVal = 1;
	
		while(uTmpVal <5)
		{
		MDNIE_SetCECurve(uTmpVal);
		MDNIE_SetCEenable(CEon);
		Disp("\n CE Curve range  = %d\n",uTmpVal);
		Disp(" Press Any key to increase CE curve range \n");
		UART_Getc();
		uTmpVal = uTmpVal + 1;
		}
		uTmpVal = 5;
		MDNIE_SetCECurve(uTmpVal);
		MDNIE_SetCEenable(CEon);
		Disp("\n CE Curve range  = %d(MAX)\n",uTmpVal);
		Disp(" Press Any key to end CE curve range test \n");
		UART_Getc();		
		uTmpVal = 3;			//default value
		MDNIE_SetCECurve(uTmpVal);
		
	}



}



void Test_mDNIE_CS(void)
{
	u8 cTmpChar;
	u32 uTmpReg;
	u32 uTmpVal;
	u32 uSelNum;

	Disp("\n1. Skin detect on/off     2. CS intense control\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();


	if (uSelNum == 1)
	{
		Disp("\n 'x' key will turn off Skin detect ,   'z' key will turn on Skin detect\n");
		Disp(" To end this test, Press Enter key\n");

		while(1)
		{
			cTmpChar = UART_Getc();
			if (cTmpChar == 'x')
			MDNIE_SetSkinEnable(SKIN_OFF);
			else if (cTmpChar == 'z')
			MDNIE_SetSkinEnable(SKIN_ON);
			else if (cTmpChar == '\r')
			break;
			
		}

	}

	else if (uSelNum == 2)
	{
		uTmpVal = 0;
	
		while(uTmpVal <1024)
		{
		MDNIE_SetCScontrol(uTmpVal);
		MDNIE_SetSkinEnable(SKIN_ON);
		Disp("\n CS Control range  = %d\n",uTmpVal);
		Disp(" Press Any key to increase CS control range \n");
		UART_Getc();
		uTmpVal = uTmpVal + 100;
		}
		uTmpVal = 1023;
		MDNIE_SetCScontrol(uTmpVal);
		Disp("\n CS control range  = %d(MAX) \n",uTmpVal);
		Disp(" Press Any key to end CS control range test\n");
		UART_Getc();
		
		uTmpVal = 0x200;		//default value
		MDNIE_SetCScontrol(uTmpVal);		
	}



}


void Test_mDNIE_HDTR(void)
{
	u32 uTmpReg;
	u32 uTmpVal;
	u32 uSelNum;

	Disp("Displaying HDTR only mode\n");
	
	MDNIE_SelectMode(HDTRonly, NOMCM, NOLPA);
	MDNIE_SetSize(uHSize, uVSize);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);



	Disp("1. Detail Enhancement     2. Contrast Enhancement     3. Color Saturation \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	if (uSelNum == 1)
	Test_mDNIE_DE();
	else if (uSelNum == 2)
	Test_mDNIE_CE();
	else if (uSelNum == 3)	
	Test_mDNIE_CS();
	
}



void Test_mDNIE_CP(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SetSize(uHSize, uVSize);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);


}

void Test_mDNIE_VE(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SetSize(uHSize, uVSize);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);


}


void Test_mDNIE_MCM(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SetSize(uHSize, uVSize);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);


}


void Test_mDNIE_LPA(void)
{
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	
	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;
	
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SetSize(uHSize, uVSize);

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);


}


void Test_IELCD_Underrun(void)
{

	u32 uFgAddr,uWin1Addr,uWin2Addr,uWin3Addr,uWin4Addr;
	u32 uHSz, uVSz;
	IMG_FMT eBgBpp = RGB24;
	IMG_FMT eFgBpp = RGB24;	
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	u32 i,j,k;

	

	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
		
	Disp("Enter Any Key To Test Fifo Under-run Interrupt\n");
	UART_Getc();

	INTC_Init();
	INTC_SetVectAddr(NUM_MDNIE0, Isr_IELcdcUnderRun);
	INTC_Enable(NUM_MDNIE0);
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);


	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();
	IELCDC_EnableAllWinFifoLvlInt(EMPTY);
	
	LCDC_Start();


	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);

/*
	LCDC_InitLdi(MAIN);

	// 1. Set WIN0
	LCDC_InitIp(eBgBpp, uLcdFbAddr, WIN0, false);	// For WIN0
	LCDC_GetFrmSz(&uHSz,&uVSz,WIN0);
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_Start();
*/
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN0);
	LCDC_Trigger();
	
	Disp("Window 0\n");
	UART_Getc();

	// 2. Set WIN1
	LCDC_GetFbEndAddr(&uWin1Addr, WIN0);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uWin1Addr, WIN1, false); 
	GLIB_InitInstance(uWin1Addr, uHSz, uVSz, eBgBpp);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_ClearFrame(C_WHITE);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN1);
	LCDC_Trigger();

	Disp("Window 1\n");
	UART_Getc();

	// 3. Set WIN2
	LCDC_GetFbEndAddr(&uWin2Addr, WIN1);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,0, 0, uWin2Addr, WIN2, false); 	

	GLIB_InitInstance(uWin2Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern2(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN2);
	LCDC_Trigger();

	Disp("Window 2\n");
	UART_Getc();

	// 4. Set WIN3
	LCDC_GetFbEndAddr(&uWin3Addr, WIN2);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uWin3Addr, WIN3, false); 	
	
	GLIB_InitInstance(uWin3Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN3);
	LCDC_Trigger();

	Disp("Window 3\n");
	UART_Getc();
	
	// 5. Set WIN4
	LCDC_GetFbEndAddr(&uWin4Addr, WIN3);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uWin4Addr, WIN4, false); 	

	GLIB_InitInstance(uWin4Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern2(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN4);
	LCDC_Trigger();

	Disp("Window 4\n");

	Disp("Press any key to stop Underrun Interrupt Test \n");
	UART_Getc();


	LCDC_Trigger();
	INTC_Disable(NUM_MDNIE0);
	LCDC_Stop();
	IELCDC_Stop();
	



}


void Test_IELCD_FrameInt(void)
{
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	LCDC_FRAME_INT_SEL	uFrInt;
	u32 uSelNum;
	ALGO_SEL eAlgoModeSel;
	MCM_SEL eMcmModeSel;
	LPA_SEL eLpaModeSel;
	
	
	SYSC_SetDispPath(eDISP_MDNIE);
	IEIP_Select(DISP_MDNIE);
	
	INTC_Init();
	INTC_SetVectAddr(NUM_MDNIE1, Isr_IELcdcFrameInt);
	INTC_Enable(NUM_MDNIE1);

	GPIO_Init();
	GPIO_SetFunctionEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output to test Interrupt
	GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output data High


	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetFreeRun(1);
	LCDC_SetOutputPath(LCD_MDNIE);

	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)WIN0);	


	Disp("1. HDTR only mode     2. HDTR with Color Preference mode     3. HDTR with Visibility Enhance \n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();

	eAlgoModeSel = 
	(uSelNum == 1) ? HDTRonly :
	(uSelNum == 2) ? HDTRwCP :
	(uSelNum == 3) ? HDTRwVE : HDTRonly;

	Disp("1. MCM mode       2. No MCM mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eMcmModeSel =
	(uSelNum == 1) ? MCM :
	(uSelNum == 2) ? NOMCM : NOMCM;

	Disp("1. LPA mode       2. No LPA mode\n");
	Disp("Select the function to test : ");
	uSelNum = UART_GetIntNum();	
	eLpaModeSel =
	(uSelNum == 1) ? LPA :
	(uSelNum == 2) ? NOLPA : NOLPA;

	MDNIE_SelectModeMask(MDNIE_MASK);
	MDNIE_SelectMode(eAlgoModeSel, eMcmModeSel, eLpaModeSel);
	MDNIE_SelectModeMask(MDNIE_UNMASK);
	MDNIE_SetSize(uHSz, uVSz);

	IELCDC_LogicStart();

	IELCDC_InitIp();

	IELCDC_Start();
	
	LCDC_Start();

	uFrInt = FINT_NONE;
	LCDC_EnableAllWinFrameInt(uFrInt);
	
	
	Disp("Enter Any Key To Test FINT_BACKPORCH Interrupt\n");
	UART_Getc();

	uFrInt = FINT_BACKPORCH;
	IELCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_BACKPORCH \n");



	Disp("Enter Any Key To Test FINT_VSYNC Interrupt\n");
	UART_Getc();

	uFrInt = FINT_VSYNC;
	IELCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_VSYNC \n");


	Disp("Enter Any Key To Test FINT_ACTIVE(VDEN) Interrupt\n");
	UART_Getc();

	uFrInt = FINT_ACTIVE;
	IELCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_ACTIVE(VDEN) signal \n");



	Disp("Enter Any Key To Test FRONT_PORCH Interrupt\n");
	UART_Getc();

	uFrInt = FINT_FRONTPORCH;
	IELCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FRONT_PORCH signal \n");
	UART_Getc();
	

	INTC_Disable(NUM_MDNIE1);


}




void MDNIE_Test(void)
{
	int i, nSel;

	const testFuncMenu menu[]=
	{
		0,                                 "Exit\n",
		Test_mDNIE_GoldenIMGview,		   "Observe mDNIE Golden IMG",
		Test_mDNIE_ModeSelect,                 "Test mDNIe mode Select(default value)",
		Test_mDNIE_ModeCompare,		   "Test mDNIe mode by comparing with Golden Data",
		Test_mDNIE_DualLCD,			   "Test mDNIe Dual LCD output",
		Test_mDNIE_StreamModeSelect,		"Test mDNIe stream img control\n",
		Test_mDNIE_HDTR,		                "Test mDNIe HDTR",		
		Test_mDNIE_CP, 			                "Test mDNIe Color Preference",		
		Test_mDNIE_VE, 			                "Test mDNIe Visibility Enhance",		
		Test_mDNIE_MCM,				   "Test mDNIe MCM",		
		Test_mDNIE_LPA,				   "Test mDNIe LPA\n",

		Test_IELCD_Underrun,		"Test IELCD under-run Interrup",
		Test_IELCD_FrameInt,		"Test IELCD Frame Interrupt",
		0,							       0
	};

	InitSysconForMDNIE();
	SYSC_InitClkForMM();

	if ((LCD_MODEL == LCD_LTV350QV_RGB) ||( LCD_MODEL == LCD_LTS350Q1))
	{
	uHSize = (u32)QVGA_HSIZE;
	uVSize = (u32)QVGA_VSIZE;
	}
	else if ((LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_LTS222Q_RGB) || (LCD_MODEL == LCD_LTS222Q_SRGB) || (LCD_MODEL == LCD_LTS222Q_SPI))
	{
	uHSize = (u32)QVGA_HSIZE;
	uVSize = (u32)QVGA_VSIZE;
	}
	else if ((LCD_MODEL == LCD_LTE480WV_RGB) || (LCD_LTP700WV_RGB))
	{
	uHSize = (u32)WVGA_HSIZE;
	uVSize = (u32)WVGA_VSIZE;
	}
	else if (LCD_MODEL == LCD_TL2796)
	{
	uHSize = (u32)WVGA_PORT_HSIZE;
	uVSize = (u32)WVGA_PORT_VSIZE;
	}

	
	while (1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}


		Disp("\nSelect the function to test : ");
		nSel = UART_GetIntNum();
		Disp("\n");

		if (nSel == 0)
		{
			break;
		}
		if (nSel>0 && nSel<(sizeof(menu)/8-1))
		{
			 (menu[nSel].func)();
		}
	}


}






