/**************************************************************************************
* 
*	Project Name : S5PV210 validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File name : mDNIe.c
*
*	File Description : This file implements the API functons for mDNIe
*
*	Author : Woojin,Kim
*	Dept : AP application
*	Created Date : 2009/01/22
*	Version	: v0.1
*
*	History 
*		- Created(Woojin.Kim 2009/01/22)
*
******************************************************************************/

#include "system.h"
#include "library.h"
#include "util.h"
#include "mDNIe.h"
#include "v210_sfr.h"
#include "lcd.h"


#if DBG_MDNIE
#define mDNIeOutp32(offset, x) {Disp("Outp1w(32'h%x, 32'h%x);\n", (MDNIE_BASE+offset), (x)); Outp32(MDNIE_BASE+offset, x);}
#define mDNIeInp32(offset, x) {x=Inp32(MDNIE_BASE+offset); /*Disp("Inp1w(32'h%x, 32'h%x);\n", (IELCDC_BASE+offset), (x));*/}
#else
#define mDNIeOutp32(offset, x) Outp32(MDNIE_BASE+offset, x)
#define mDNIeInp32(offset, x) {x=Inp32(MDNIE_BASE+offset);}
#endif

enum mDNIE_SFR
{
// Algorithm Control Registers
	rR1			= 0x0084,
	rR2			= 0x0088,
	rR3			= 0x008C,

// Decontour/HDTR Algorithm Registers	
	rR36		= 0x0090,
	rR37		= 0x0094,
	rR38		= 0x0098,
	rR39		= 0x009C,
	rR40		= 0x00A0,
	rR41		= 0x00A4,
	rR42		= 0x00A8,
	rR43		= 0x00AC,
	rR44		= 0x00B0,
	rR45		= 0x00B4,
	rR46		= 0x00B8,
// ȣ Algorithm Register
	rR48		= 0x00C0,

// Skin/Red mode Level Parameter Registers
	rR49		= 0x00C4,
	rR50		= 0x00C8,
	rR51		= 0x00CC,
	rR52		= 0x00D0,
	rR53		= 0x00D4,
	rR54		= 0x00D8,
	rR55		= 0x00DC,
	rR56		= 0x00E0,

// ߿ܽμ Algorithm Registers
	rR64		= 0x0100,
	rR65		= 0x0104,
	rR66		= 0x0108,
	rR67		= 0x010C,
	rR68		= 0x0110,
	rR69		= 0x0114,

// MCM Control Algorithm Registers
	rR72		= 0x0120,
	rR73		= 0x0124,
	rR74		= 0x0128,
	rR75		= 0x012C,
	rR76		= 0x0130,
	rR77		= 0x0134,
	rR78		= 0x0138,
	rR79		= 0x013C,
	rR80		= 0x0140,
	rR81		= 0x0144,
	rR82		= 0x0148,
	rR83		= 0x014C,
	rR84		= 0x0150,
	rR85		= 0x0154,
	rR86		= 0x0158,
	rR87		= 0x015C,	

//LPA(CABC) Algorithm Registers
	rR88		= 0x0160,									
	rR89		= 0x0164,								
	rR90		= 0x0168,								
	rR91		= 0x016C,								
	rR92		= 0x0170,								
	rR93		= 0x0174,								
	rR94		= 0x0178,								
	rR95		= 0x017C,								
	rR96		= 0x0180,								
	rR97		= 0x0184,								
	rR98		= 0x0188,								
	rR99		= 0x018C,								
	rR100		= 0x0190,
	rR101		= 0x0194,

//CABC Control
	rR102		= 0x0198,

// PWM Control
	rR103		= 0x019C

};



//R1
#define HDTR					(0<<6)
#define HDTR_CP				(1<<6)		// Color Preference
#define HDTR_VE				(2<<6)		// Visibility Enhancement
#define MCM_OFF				(0<<5)
#define MCM_ON				(1<<5)
#define LPA_OFF				(0<<4)
#define LPA_ON				(1<<4)
#define REG_UNMASK			(0<<0)
#define REG_MASK			(1<<0)
//R2
#define HSIZE(n)				(((n)&0x7FF)<<0)
//R3
#define VSIZE(n)				(((n)&0x7FF)<<0)


//R36
#define DECONT_TH(n)		(((n)&0xFFF)<<0)
//R37
#define DIRECT_TH(n)			(((n)&0xFFF)<<0)
//R38
#define SIMPLE_TH(n)			(((n)&0x7F)<<0)
//R39
#define DE_CONT(n)			(((n)&0x7F)<<5)
#define CE_ON				(0<<4)
#define CE_OFF				(1<<4)
#define CE_CURVE(n)			(((n)&0x7)<<1)
#define AMOLED_NOTSELECT	(0<<0)
#define AMOLED_SELECT		(1<<0)
//R40
#define IPF_ALPHA(n)			(((n)&0xFF)<<7)
#define IPF_BETA(n)			(((n)&0xFF)<<0)
//R41
#define IPF_THETA(n)			(((n)&0xFF)<<0)
//R42
#define IPF_CNTRST(n)		(((n)&0x3)<<12)
#define IPF_G(n)				(((n)&0xF)<<8)
#define IPF_T(n)				(((n)&0xFF)<<0)

//R43
#define CS_SKIN_OFF			(0<<10)
#define CS_SKIN_ON			(1<<10)
#define CS_CONT(n)			(((n)&0x3FF)<<0)

//R45
#define DE_TH(n)				(((n)&0x3FF)<<0)

//R48
#define SN_LVL_0				(0<<10)
#define SN_LVL_1				(1<<10)
#define SN_LVL_2				(2<<10)
#define SN_LVL_3				(3<<10)
#define SY_LVL_0				(0<<8)
#define SY_LVL_1				(1<<8)
#define SY_LVL_2				(2<<8)
#define SY_LVL_3				(3<<8)
#define GR_LVL_0				(0<<6)
#define GR_LVL_1				(1<<6)
#define GR_LVL_2				(2<<6)
#define GR_LVL_3				(3<<6)
#define RD_LVL_0				(0<<4)
#define RD_LVL_1				(1<<4)
#define RD_LVL_2				(2<<4)
#define RD_LVL_3				(3<<4)
#define YE_LVL_0				(0<<2)
#define YE_LVL_1				(1<<2)
#define YE_LVL_2				(2<<2)
#define YE_LVL_3				(3<<2)
#define PU_LVL_0				(0<<0)
#define PU_LVL_1				(1<<0)
#define PU_LVL_2				(2<<0)
#define PU_LVL_3				(3<<0)

//R49
#define SN_L1_TCB(n)			(((n)&0xFF)<<8)
#define SN_L2_TCB(n)			(((n)&0xFF)<<0)
//R50
#define SN_L3_TCB(n)			(((n)&0xFF)<<8)
#define SN_L1_TCR(n)			(((n)&0xFF)<<0)
//R51
#define SN_L2_TCR(n)			(((n)&0xFF)<<8)
#define SN_L3_TCR(n)			(((n)&0xFF)<<0)
//R52
#define SN_L1_S(n)			(((n)&0x7)<<6)
#define SN_L2_S(n)			(((n)&0x7)<<3)
#define SN_L3_S(n)			(((n)&0x7)<<0)
//R53
#define RD_L1_TCB(n)			(((n)&0xFF)<<8)
#define RD_L2_TCB(n)			(((n)&0xFF)<<0)
//R54
#define RD_L3_TCB(n)			(((n)&0xFF)<<8)
#define RD_L1_TCR(n)			(((n)&0xFF)<<0)
//R55
#define RD_L2_TCR(n)			(((n)&0xFF)<<8)
#define RD_L3_TCR(n)			(((n)&0xFF)<<0)
//R56
#define RD_L1_S(n)			(((n)&0x7)<<6)
#define RD_L2_S(n)			(((n)&0x7)<<3)
#define RD_L3_S(n)			(((n)&0x7)<<0)

//R64
#define LIGHT_P(n)			(((n)&0xFF)<<8)
#define CHROMA_P(n)			(((n)&0xFF)<<0)
//R65
#define TRANSFUNL_1(n)		(((n)&0x7F)<<8)
#define TRANSFUNL_2(n)		(((n)&0x7F)<<0)
//R66
#define TRANSFUNL_3(n)		(((n)&0x7F)<<8)
#define TRANSFUNL_4(n)		(((n)&0x7F)<<0)
//R67
#define TRANSFUNL_5(n)		(((n)&0x7F)<<8)
#define TRANSFUNL_6(n)		(((n)&0x7F)<<0)
//R68
#define TRANSFUNL_7(n)		(((n)&0x7F)<<8)
#define TRANSFUNL_8(n)		(((n)&0x7F)<<0)
//R69
#define TRANSFUNL_9(n)		(((n)&0x7F)<<8)

//R72
#define QUADRANT_OFF		(0<<8)		// ⺻
#define QUADRAND_ON		(1<<8)		// 4Ҹ
#define COLOR_TEMP_DEST(n)	((((n)&0xFF)<<0)
//R73
#define COLOR_TEMP1(n)		(((n)&0xFF)<<8)
#define COLOR_TEMP2(n)		(((n)&0xFF)<<0)
//R74
#define COLOR_TEMP3(n)		(((n)&0xFF)<<8)
#define COLOR_TEMP4(n)		(((n)&0xFF)<<0)
//R75
#define COLOR_TEMP5(n)		(((n)&0xFF)<<8)
#define LSF1(n)				(((n)&0xFF)<<0)
//R76
#define LSF2(n)				(((n)&0xFF)<<8)
#define LSF3(n)				(((n)&0xFF)<<0)
//R76
#define LSF4(n)				(((n)&0xFF)<<8)
#define LSF5(n)				(((n)&0xFF)<<0)
//R78
#define CT1_HIGH_CB(n)		(((n)&0xFF)<<8)
#define CT2_HIGH_CB(n)		(((n)&0xFF)<<0)
//R79
#define CT3_HIGH_CB(n)		(((n)&0xFF)<<8)
#define CT4_HIGH_CB(n)		(((n)&0xFF)<<0)
//R80
#define CT5_HIGH_CB(n)		(((n)&0xFF)<<8)
#define CT1_HIGH_CR(n)		(((n)&0xFF)<<0)
//R81
#define CT2_HIGH_CR(n)		(((n)&0xFF)<<8)
#define CT3_HIGH_CR(n)		(((n)&0xFF)<<0)
//R82
#define CT4_HIGH_CR(n)		(((n)&0xFF)<<8)
#define CT5_HIGH_CR(n)		(((n)&0xFF)<<0)
//R83
#define GRAY_AXIS_LONG(n)	(((n)&0xFF)<<8)
#define GRAY_AXIS_SHORT(n)	(((n)&0xFF)<<0)
//R84
#define GRAY_ANGLE_COS(n)	(((n)&0x3ff)<<0)
//R85
#define GRAY_ANGLE_SIN(n)	(((n)&0x3ff)<<0)
//R86
#define QUADRANT_TMP1(n)	(((n)&0xFF)<<8)
#define QUADRANT_TMP2(n)	(((n)&0xFF)<<0)
//R87
#define QUADRANT_TMP3(n)	(((n)&0xFF)<<8)
#define QUADRANT_TMP4(n)	(((n)&0xFF)<<0)

//R88
#define FGain_LUT0(n)		(((n)&0x7F)<<8)
#define FGain_LUT1(n)		(((n)&0x7F)<<0)
//R89
#define FGain_LUT2(n)		(((n)&0x7F)<<8)
#define FGain_LUT3(n)		(((n)&0x7F)<<0)
//R90
#define FGain_LUT4(n)		(((n)&0x7F)<<8)
#define FGain_LUT5(n)		(((n)&0x7F)<<0)
//R91
#define FGain_LUT6(n)		(((n)&0x7F)<<8)
#define FGain_LUT7(n)		(((n)&0x7F)<<0)
//R92
#define DGain_LUT0(n)		(((n)&0x7F)<<8)
#define DGain_LUT1(n)		(((n)&0x7F)<<0)
//R93
#define DGain_LUT2(n)		(((n)&0x7F)<<8)
#define DGain_LUT3(n)		(((n)&0x7F)<<0)
//R94
#define DGain_LUT4(n)		(((n)&0x7F)<<8)
#define DGain_LUT5(n)		(((n)&0x7F)<<0)
//R95
#define DGain_LUT6(n)		(((n)&0x7F)<<8)
#define DGain_LUT7(n)		(((n)&0x7F)<<0)
//R96
#define Power_LUT0(n)		(((n)&0x7F)<<8)
#define Power_LUT1(n)		(((n)&0x7F)<<0)
//R97
#define Power_LUT2(n)		(((n)&0x7F)<<8)
#define Power_LUT3(n)		(((n)&0x7F)<<0)
//R98
#define Power_LUT4(n)		(((n)&0x7F)<<8)
#define Power_LUT5(n)		(((n)&0x7F)<<0)
//R99
#define Power_LUT6(n)		(((n)&0x7F)<<8)
#define Power_LUT7(n)		(((n)&0x7F)<<0)
//R100
#define Power_LUT8(n)		(((n)&0x7F)<<8)

//R101
#define ZONAL_PARA0(n)		(((n)&0x3)<<4)
#define ZONAL_PARA1(n)		(((n)&0x3)<<0)
//R102
#define BLU_DISABLE			(0<<1)
#define BLU_ENABLE			(1<<1)
#define DISPLAY_LCD			(0<<0)
#define DISPLAY_OLED		(1<<0)

//R103
#define PWM_PHIGH			(1<<15)
#define PWM_PLOW			(0<<15)
#define PWM_CT_LPA			(0<<14) // using LPA counter
#define PWM_CT_PWM		(1<<14) // using PWM counter
#define PWM_CT(n)			(((n)&0x3F)<<0)


#if DBG_IELCDC
#define IeLcdcOutp32(offset, x) {Disp("Outp1w(32'h%x, 32'h%x);\n", (IELCDC_BASE+offset), (x)); Outp32(IELCDC_BASE+offset, x);}
#define IeLcdcInp32(offset, x) {x=Inp32(IELCDC_BASE+offset); /*Disp("Inp1w(32'h%x, 32'h%x);\n", (IELCDC_BASE+offset), (x));*/}
#else
#define IeLcdcOutp32(offset, x) Outp32(IELCDC_BASE+offset, x)
#define IeLcdcInp32(offset, x) {x=Inp32(IELCDC_BASE+offset);}
#endif

enum IELCDC_SFR
{
	VIDCON0		= 0x00000,
	VIDCON1		= 0x00004, 
	VIDCON2		= 0x00008,
	VIDCON3		= 0x0000C,		//new(v6.0)
	VIDTCON0		= 0x00010,
	VIDTCON1		= 0x00014, 
	VIDTCON2		= 0x00018,
	VIDTCON3		= 0x0001c,
	WINCON0		= 0x00020,
	WINCON1		= 0x00024,
	WINCON2		= 0x00028,
	WINCON3		= 0x0002C,
	WINCON4	     	= 0x00030,
	SHADOWCON	= 0x00034,		//new(v6.0)
	VIDOSD0A		= 0x00040,
	VIDOSD0B		= 0x00044,
	VIDOSD0C		= 0x00048,
	VIDOSD1A		= 0x00050,
	VIDOSD1B		= 0x00054,
	VIDOSD1C		= 0x00058,
	VIDOSD1D		= 0x0005C,
	VIDOSD2A		= 0x00060,
	VIDOSD2B		= 0x00064,
	VIDOSD2C		= 0x00068,
	VIDOSD2D		= 0x0006c,
	VIDOSD3A		= 0x00070,
	VIDOSD3B		= 0x00074,
	VIDOSD3C		= 0x00078,
	VIDOSD4A		= 0x00080,
	VIDOSD4B		= 0x00084,
	VIDOSD4C		= 0x00088,

	VIDW00ADD0B0	= 0x000A0,
	VIDW00ADD0B1	= 0x000A4,
	VIDW01ADD0B0	= 0x000A8,
	VIDW01ADD0B1	= 0x000AC,
	VIDW02ADD0B0	= 0x000B0,		//new(v6.0) win2~4 have double buffer
	VIDW02ADD0B1	= 0x000B4,
	VIDW03ADD0B0	= 0x000B8,
	VIDW03ADD0B1	= 0x000BC,
	VIDW04ADD0B0	= 0x000C0,
	VIDW04ADD0B1	= 0x000C4,

	VIDW00ADD1B0	= 0x000D0,
	VIDW00ADD1B1	= 0x000D4,
	VIDW01ADD1B0	= 0x000D8,
	VIDW01ADD1B1	= 0x000DC,
	VIDW02ADD1B0	= 0x000E0,		//new(v6.0) win2~4 have double buffer
	VIDW02ADD1B1	= 0x000E4,
	VIDW03ADD1B0	= 0x000E8,
	VIDW03ADD1B1	= 0x000EC,
	VIDW04ADD1B0	= 0x000F0,
	VIDW04ADD1B1	= 0x000F4,

	VIDW00ADD2     	= 0x00100,
	VIDW01ADD2     	= 0x00104,
	VIDW02ADD2     	= 0x00108,
	VIDW03ADD2     	= 0x0010C,
	VIDW04ADD2     	= 0x00110,

	VP1TCON0		= 0x00118,		//new(v6.0)
	VP1TCON1		= 0x0011c,

	VIDINTCON0		= 0x00130,
	VIDINTCON1		= 0x00134,
	W1KEYCON0		= 0x00140,
	W1KEYCON1		= 0x00144,
	W2KEYCON0		= 0x00148,
	W2KEYCON1		= 0x0014C,
	W3KEYCON0		= 0x00150,
	W3KEYCON1		= 0x00154,
	W4KEYCON0		= 0x00158,
	W4KEYCON1		= 0x0015C,

	W1KEYALPHA	= 0x00160,		//new(v6.0)
	W2KEYALPHA	= 0x00164,
	W3KEYALPHA	= 0x00168,
	W4KEYALPHA	= 0x0016C,

	DITHMODE		= 0x00170,

	WIN0MAP		= 0x00180,
	WIN1MAP		= 0x00184,
	WIN2MAP		= 0x00188,
	WIN3MAP		= 0x0018C,
	WIN4MAP		= 0x00190,

	WPALCON_H		= 0x0019C,
	WPALCON_L		= 0x001A0,	
	TRIGCON		= 0x001A4,

	ITUIFCON		= 0x001A8, 

	I80IFCONA0		= 0x001B0,
	I80IFCONA1		= 0x001B4,
	I80IFCONB0		= 0x001B8,
	I80IFCONB1		= 0x001BC,

	COLORGAINCON	= 0x001C0,		//new(v6.0)
	
	VESFRCON0		= 0x001C4,		//new(v6.0)
	VESFRCON1		= 0x001C8,	
	VESFRCON2		= 0x001CC,
	
	LDI_CMDCON0	= 0x001D0,
	LDI_CMDCON1	= 0x001D4,

	SIFCCON0		= 0x001E0,
	SIFCCON1		= 0x001E4,
	SIFCCON2		= 0x001E8,

	HUECOEF00		= 0x001EC,		//new(v6.0)
	HUECOEF01		= 0x001F0,
	HUECOEF10		= 0x001F4,	
	HUECOEF11		= 0x001F8,
	HUEOFFSET		= 0x001FC,
	
	VIDW0ALPHA0	= 0x00200,
	VIDW0ALPHA1	= 0x00204,
	VIDW1ALPHA0	= 0x00208,
	VIDW1ALPHA1	= 0x0020C,
	VIDW2ALPHA0	= 0x00210,
	VIDW2ALPHA1	= 0x00214,
	VIDW3ALPHA0	= 0x00218,
	VIDW3ALPHA1	= 0x0021C,
	VIDW4ALPHA0	= 0x00220,
	VIDW4ALPHA1	= 0x00224,
	BLENDEQ1		= 0x00244,
	BLENDEQ2		= 0x00248,
	BLENDEQ3		= 0x0024C,
	BLENDEQ4		= 0x00250,
	BLENDCON		= 0x00260,

	W0RTQOSCON	= 0x00264,		//new(v6.0)
	W1RTQOSCON	= 0x00268,
	W2RTQOSCON	= 0x0026C,
	W3RTQOSCON	= 0x00270,
	W4RTQOSCON	= 0x00274,
	GPOUTCON0		= 0x00278,
	DUALCON		= 0x0027C,		//new(v6.0) need to change Reg. name (Temporary name now 09.Feb.16th)

	LDI_CMD0		= 0x00280,
	LDI_CMD1		= 0x00284,
	LDI_CMD2		= 0x00288,
	LDI_CMD3		= 0x0028C,
	LDI_CMD4		= 0x00290,
	LDI_CMD5		= 0x00294,
	LDI_CMD6		= 0x00298,
	LDI_CMD7		= 0x0029C,
	LDI_CMD8		= 0x002A0,
	LDI_CMD9		= 0x002A4,
	LDI_CMD10		= 0x002A8,
	LDI_CMD11		= 0x002AC,

	GAMMALUT_01_00	= 0x0037C,		//new(v6.0)
	GAMMALUT_03_02	= 0x00380,
	GAMMALUT_05_04	= 0x00384,
	GAMMALUT_07_06	= 0x00388,
	GAMMALUT_09_08	= 0x0038C,
	GAMMALUT_11_10	= 0x00390,
	GAMMALUT_13_12	= 0x00394,
	GAMMALUT_15_14	= 0x00398,
	GAMMALUT_17_16	= 0x0039C,
	GAMMALUT_19_18	= 0x003A0,
	GAMMALUT_21_20	= 0x003A4,
	GAMMALUT_23_22	= 0x003A8,
	GAMMALUT_25_24	= 0x003AC,
	GAMMALUT_27_26	= 0x003B0,
	GAMMALUT_29_28	= 0x003B4,
	GAMMALUT_31_30	= 0x003B8,
	GAMMALUT_33_32	= 0x003BC,
	GAMMALUT_35_34	= 0x003C0,
	GAMMALUT_37_36	= 0x003C4,
	GAMMALUT_39_38	= 0x003C8,
	GAMMALUT_41_40	= 0x003CC,
	GAMMALUT_43_42	= 0x003D0,
	GAMMALUT_45_44	= 0x003D4,
	GAMMALUT_47_46	= 0x003D8,
	GAMMALUT_49_48	= 0x003DC,
	GAMMALUT_51_50	= 0x003E0,
	GAMMALUT_53_52	= 0x003E4,
	GAMMALUT_55_54	= 0x003E8,
	GAMMALUT_57_56	= 0x003EC,
	GAMMALUT_59_58	= 0x003F0,
	GAMMALUT_61_60	= 0x003F4,
	GAMMALUT_63_62	= 0x003F8,
	GAMMALUT_xx_64	= 0x003FC,
	
	W0PDATA01_L		= 0x022c0,
	W0PDATA23_L		= 0x022c4,
	W0PDATA45_L		= 0x022c8,
	W0PDATA67_L		= 0x022cc,
	W0PDATA89_L		= 0x022d0,
	W0PDATAAB_L		= 0x022d4,
	W0PDATACD_L		= 0x022d8,
	W0PDATAEF_L		= 0x022dc,
	W0PDATA01_H		= 0x022e0,
	W0PDATA23_H		= 0x022e4,
	W0PDATA45_H		= 0x022e8,
	W0PDATA67_H		= 0x022ec,
	W0PDATA89_H		= 0x022f0,
	W0PDATAAB_H		= 0x022f4,
	W0PDATACD_H		= 0x022f8,
	W0PDATAEF_H		= 0x022fc,
	W1PDATA01_L		= 0x02300,
	W1PDATA23_L		= 0x02304,
	W1PDATA45_L		= 0x02308,
	W1PDATA67_L		= 0x0230c,
	W1PDATA89_L		= 0x02310,
	W1PDATAAB_L		= 0x02314,
	W1PDATACD_L		= 0x02318,
	W1PDATAEF_L		= 0x0231c,
	W1PDATA01_H		= 0x02320,
	W1PDATA23_H		= 0x02324,
	W1PDATA45_H		= 0x02328,
	W1PDATA67_H		= 0x0232c,
	W1PDATA89_H		= 0x02330,
	W1PDATAAB_H		= 0x02334,
	W1PDATACD_H		= 0x02338,
	W1PDATAEF_H		= 0x0233c,	
	W2PDATA01_L		= 0x02340,
	W2PDATA23_L		= 0x02344,
	W2PDATA45_L		= 0x02348,
	W2PDATA67_L		= 0x0234c,
	W2PDATA89_L		= 0x02350,
	W2PDATAAB_L		= 0x02354,
	W2PDATACD_L		= 0x02358,
	W2PDATAEF_L		= 0x0235c,
	W2PDATA01_H		= 0x02360,
	W2PDATA23_H		= 0x02364,
	W2PDATA45_H		= 0x02368,
	W2PDATA67_H		= 0x0236c,
	W2PDATA89_H		= 0x02370,
	W2PDATAAB_H		= 0x02374,
	W2PDATACD_H		= 0x02378,
	W2PDATAEF_H		= 0x0237c,
	W3PDATA01_L		= 0x02380,
	W3PDATA23_L		= 0x02384,
	W3PDATA45_L		= 0x02388,
	W3PDATA67_L		= 0x0238c,
	W3PDATA89_L		= 0x02390,
	W3PDATAAB_L		= 0x02394,
	W3PDATACD_L		= 0x02398,
	W3PDATAEF_L		= 0x0239c,
	W3PDATA01_H		= 0x023a0,
	W3PDATA23_H		= 0x023a4,
	W3PDATA45_H		= 0x023a8,
	W3PDATA67_H		= 0x023ac,
	W3PDATA89_H		= 0x023b0,
	W3PDATAAB_H		= 0x023b4,
	W3PDATACD_H		= 0x023b8,
	W3PDATAEF_H		= 0x023bc,
	W4PDATA01_L		= 0x023c0,
	W4PDATA23_L		= 0x023c4,
	W4PDATA45_L		= 0x023c8,
	W4PDATA67_L		= 0x023cc,
	W4PDATA89_L		= 0x023d0,
	W4PDATAAB_L		= 0x023d4,
	W4PDATACD_L		= 0x023d8,
	W4PDATAEF_L		= 0x023dc,
	W4PDATA01_H		= 0x023e0,
	W4PDATA23_H		= 0x023e4,
	W4PDATA45_H		= 0x023e8,
	W4PDATA67_H		= 0x023ec,
	W4PDATA89_H		= 0x023f0,
	W4PDATAAB_H		= 0x023f4,
	W4PDATACD_H		= 0x023f8,
	W4PDATAEF_H		= 0x023fc,


	W0PRAMSTART		= 0x02400,
	W1PRAMSTART   	 	= 0x02800,
	W2PRAMSTART   		= 0x02c00,
	W3PRAMSTART    		= 0x03000,
	W4PRAMSTART    		= 0x03400,
	
// VELUT1_00~VELUT1_FF need to be defined (08.Nov.15th)
	VELUT1_00			= 0x04800,

// VELUT2_000~VELUT1_1FF need to be defined (08.Nov.15th)
	VELUT2_000			= 0x05000

};

// VIDCON0 (VIDeo main CONtrol 0 register)
#define DSI_DISABLE				(0<<30)
#define DSI_ENABLE				(1<<30)

#define VID_PROGRESSIVE			(0<<29)
#define VID_INTERLACE			(1<<29)

#define VIDOUT_RGBIF			(0<<26)
#define VIDOUT_TV				(1<<26)		 // v6.0's case this is Write Back path
#define VIDOUT_I80IF0			(2<<26)
#define VIDOUT_I80IF1			(3<<26)
#define VIDOUT_TVNRGBIF	     		(4<<26)		// v6.0's case this is RGB(LCD) and WriteBack dual path (TV = WB)
#define VIDOUT_TVNI80IF0		(6<<26)	
#define VIDOUT_TVNI80IF1		(7<<26)	

// CPU Interface Data Format (SUB LDI)
#define SUB_16_MODE			(0<<23)
#define SUB_16PLUS2_MODE		(1<<23)
#define SUB_9PLUS9_MODE	    	(2<<23)
#define SUB_16PLUS8_MODE		(3<<23)
#define SUB_18_MODE		    	(4<<23)
#define SUB_8PLUS8_MODE		(5<<23)

// CPU Interface Data Format (MAIN LDI)
#define MAIN_16_MODE			(0<<20)
#define MAIN_16PLUS2_MODE		(1<<20)
#define MAIN_9PLUS9_MODE		(2<<20)
#define MAIN_16PLUS8_MODE		(3<<20)
#define MAIN_18_MODE			(4<<20)
#define MAIN_8PLUS8_MODE		(5<<20)		// new(v6.0)

// VIDCON0 (CPU I/F Masking)
#define LCD_OUT_MASKING	    	~(0x3<<26)
#define SUB_DATA_MASKING		~(0x7<<23)
#define MAIN_DATA_MASKING		~(0x7<<20)

#define PNRMODE_RGB_P			(0<<17)
#define PNRMODE_BGR_P			(1<<17)
#define PNRMODE_RGB_S			(2<<17)
#define PNRMODE_BGR_S			(3<<17)
#define PNRMODE_MASK			(3<<17)

#define CLKVALUP_ALWAYS	    	(0<<16)
#define CLKVALUP_ST_FRM	    	(1<<16)

#define CLKVAL_F(n)				(((n)&0xFF)<<6)

#define VCLKFREE_NORMAL		(0<<5) 
#define VCLKFREE_FREERUN		(1<<5) 

#define CLKDIR_F(n)				(((n)&0x1)<<4)
#define CLKDIR_DIRECT			(0<<4)
#define CLKDIR_DIVIDED			(1<<4)
 
#define CLKSEL_F_HCLK			(0<<2)
#define CLKSEL_F_SCLK        	(1<<2)		// LCD video Clock(fr SYSCON)
 
#define ENVID_DISABLE			(0<<1)
#define ENVID_ENABLE			(1<<1)

#define ENVID_F_DISABLE			(0<<0)
#define ENVID_F_ENABLE			(1<<0)

// VIDCON1 (VIDeo main CONtrol 1 register)
#define IVCLK_FALL_EDGE			(0<<7)
#define IVCLK_RISE_EDGE			(1<<7)
#define IHSYNC_NORMAL			(0<<6)
#define IHSYNC_INVERT			(1<<6)
#define IVSYNC_NORMAL			(0<<5)
#define IVSYNC_INVERT			(1<<5)
#define IVDEN_NORMAL			(0<<4)
#define IVDEN_INVERT			(1<<4)

// VIDCON2 (VIDeo main CONtrol 2 register)
#define RGB_SKIP_DISABLE		(0<<27)		// new(v6.0)
#define RGB_SKIP_ENABLE			(1<<27)
#define RGB_DUMMY_LAST			(0<<25)
#define RGB_DUMMY_FIRST		(1<<25)
#define RGB_DUMMY_DISABLE		(0<<24)
#define RGB_DUMMY_ENABLE		(1<<24)

#define EN601_DISABLE			(0<<23)
#define EN601_ENABLE			(1<<23)
#define EN656_DISABLE			(0<<22)
#define EN656_ENABLE			(1<<22)

#define RGB_ORDER_E_RGB		(0<<19)		// new(v6.0)
#define RGB_ORDER_E_GBR		(1<<19)
#define RGB_ORDER_E_BRG		(2<<19)
#define RGB_ORDER_E_BGR		(4<<19)
#define RGB_ORDER_E_RBG		(5<<19)
#define RGB_ORDER_E_GRB		(6<<19)

#define RGB_ORDER_O_RGB		(0<<16)		// new(v6.0)
#define RGB_ORDER_O_GBR		(1<<16)
#define RGB_ORDER_O_BRG		(2<<16)
#define RGB_ORDER_O_BGR		(4<<16)
#define RGB_ORDER_O_RBG		(5<<16)
#define RGB_ORDER_O_GRB		(6<<16)

#define TVFORMATSEL0_HW	    	(0<<14)
#define TVFORMATSEL0_SW	    	(1<<14)
#define TVFORMATSEL1_RGB		(0<<12)
#define TVFORMATSEL1_YUV422	(1<<12)
#define TVFORMATSEL1_YUV444	(1<<13)	
#define ORGYCBCR_YCBCR		(0<<8)
#define ORGYCBCR_CBCRY		(1<<8)
#define YUVORD_CB_CR			(0<<7)
#define YUVORD_CR_CB			(1<<7)

#define TV_FRAM_SKIP(n)			(((n-1)&0x1F)<<0)		// new(v6.0) /  n=1 ; 1:1 /  n=2 ; 1:2 /   n=3 ; 1:3 ...

// VIDCON3 (VIDeo main CONtrol 3 register)		//new(v6.0)
#define VE_ON_DISABLE			(0<<20)
#define VE_ON_ENABLE			(1<<20)
#define CG_ON_DISABLE			(0<<18)
#define CG_ON_ENABLE			(1<<18)
#define GM_ON_DISABLE			(0<<16)
#define GM_ON_ENABLE			(1<<16)
#define HUE_CSC_F_WIDE			(0<<14)
#define HUE_CSC_F_NARROW		(1<<14)
#define HUE_CSC_F_EQ601		(0<<13)
#define HUE_CSC_F_EQ709		(1<<13)
#define HUE_CSC_F_DISABLE		(0<<12)
#define HUE_CSC_F_ENABLE		(1<<12)
#define HUE_CSC_B_WIDE			(0<<10)
#define HUE_CSC_B_NARROW		(1<<10)
#define HUE_CSC_B_EQ601		(0<<9)
#define HUE_CSC_B_EQ709		(1<<9)
#define HUE_CSC_B_DISABLE		(0<<8)
#define HUE_CSC_B_ENABLE		(1<<8)
#define HUE_ON_DISABLE			(0<<7)
#define HUE_ON_ENABLE			(1<<7)
#define PC_DIR_POS				(0<<1)
#define PC_DIR_NEG				(1<<1)
#define PC_ON_DISABLE			(0<<0)
#define PC_ON_ENABLE			(1<<0)



// VIDTCON0 (VIDeo Time CONtrol 0 register)
#define VBPDE(n)					(((n)&0xFF)<<24)
#define VBPD(n)					(((n)&0xFF)<<16)
#define VFPD(n)					(((n)&0xFF)<<8)
#define VSPW(n)					(((n)&0xFF)<<0)

// VIDTCON1 (VIDeo Time CONtrol 1 register)
#define VFPDE(n)					(((n)&0xFF)<<24)
#define HBPD(n)					(((n)&0xFF)<<16)
#define HFPD(n)					(((n)&0xFF)<<8)
#define HSPW(n)					(((n)&0xFF)<<0)

// VIDTCON2 (VIDeo Time CONtrol 2 register)
#define LINEVAL(n)				(((n)&0x7FF)<<11)
#define HOZVAL(n)				(((n)&0x7FF)<<0)

// VIDTCON3 (VIDeo Time CONtrol 3 register)
#define VSYNC_DISABLE			(0<<31)
#define VSYNC_ENABLE			(1<<31)
#define FRM_DISABLE				(0<<29)
#define FRM_ENABLE				(1<<29)
#define INVFRM_HIGH				(0<<28)
#define INVFRM_LOW				(1<<28)
#define FRMVRATE(n)				(((n)&0xF)<<24)
#define FRMVFPD(n)				(((n)&0xFF)<<8)
#define FRMVSPW(n)				(((n)&0xFF)<<0)

// WINCON0 (WINdow 0 CONtrol register) SFR for local path


// WINCON1 (WINdow 1 CONtrol register) SFR for local path
#define W1VP_DISABLE			(0<<24)
#define W1VP_ENABLE			(1<<24)


// WINCON2 (WINdow 2 CONtrol register) SFR for local path


// WINCON0, 1, 2, 3, 4 SFR's
#define LIMIT_DISABLE			(0<<29)		//new(v6.0)
#define LIMIT_ENABLE			(1<<29)
#define EQ601					(0<<28)
#define EQ709					(1<<28)
#define WIDE						(0<<26)
#define NARROW					(3<<26)
#define PATH_DMA				(0<<22)
#define PATH_LOCAL				(1<<22)

#define WBUF0					(0<<20)
#define WBUF1					(1<<20)
#define WBUF_MASK				(1<<20)
#define WBUFAUTO_DISABLE		(0<<19)
#define WBUFAUTO_ENABLE		(1<<19)
#define WBUFAUTO_MASK	    		(1<<19)

#define BITSWP_DISABLE			(0<<18)
#define BITSWP_ENABLE			(1<<18)
#define BYTSWP_DISABLE			(0<<17)
#define BYTSWP_ENABLE		 	(1<<17)
#define HAWSWP_DISABLE	    	(0<<16)
#define HAWSWP_ENABLE			(1<<16)
#define WRDSWP_DISABLE		    	(0<<15)
#define WRDSWP_ENABLE			(1<<15)

#define IN_LOCAL_RGB			(0<<13)
#define IN_LOCAL_YUV			(1<<13)
#define INRGB_MASK				(1<<13)

#define MAX_BURSTLEN_16WORD	(0<<9)
#define MAX_BURSTLEN_8WORD	(1<<9)
#define MAX_BURSTLEN_4WORD	(2<<9)

#define ALPHA_MUL_DISABLE		(0<<7)
#define ALPHA_MUL_ENABLE		(1<<7)

#define BLD_PIX_PLANE			(0<<6)
#define BLD_PIX_PIXEL			(1<<6)
#define BLD_PIX_MASK			(1<<6)

#define BPPMODE_F_1BPP			(0<<2)
#define BPPMODE_F_2BPP			(1<<2)
#define BPPMODE_F_4BPP			(2<<2)
#define BPPMODE_F_8BPP_PAL	(3<<2)
#define BPPMODE_F_8BPP_NOPAL	(4<<2) // A:1 R:2 G:3 B:2
#define BPPMODE_F_16BPP_565	(5<<2)
#define BPPMODE_F_16BPP_A555	(6<<2)
#define BPPMODE_F_16BPP_I555	(7<<2)
#define BPPMODE_F_18BPP_666	(8<<2)
#define BPPMODE_F_18BPP_A665	(9<<2)
#define BPPMODE_F_19BPP_A666	(0xa<<2)
#define BPPMODE_F_24BPP_888	(0xb<<2)
#define BPPMODE_F_24BPP_A887	(0xc<<2)
#define BPPMODE_F_25BPP_A888	(0xd<<2)
#define BPPMODE_F_13BPP_A444	(0xe<<2)
#define BPPMODE_F_32BPP_8888	(0xd<<2)
#define BPPMODE_F_16BPP_4444	(0xe<<2)
#define BPPMODE_F_15BPP_555	(0xf<<2)
#define BPPMODE_F_MASK		(0xf<<2)

// WINCON1,2,3,4 BLEND_SELECT_MODE
#define BLEND_ALPHA0_PLANE		(0<<1)
#define BLEND_ALPHA1_PLANE		(1<<1)
#define BLEND_AEN_PIXEL  		(0<<1)
#define BLEND_DATA_PIXEL		(1<<1)

#define ALPHA_SEL_0				~(1<<1)		// 

#define BLEND_COLORKEY_AREA	(0<<1) 		// ???

#define BLEND_SEL_MASK			(1<<1)

#define ENWIN_F_DISABLE	    	(0<<0)
#define ENWIN_F_ENABLE			(1<<0)

// SHADOWCON (window SHADOW CONtrol register)      new(v6.0)
#define W4_SHADOW_UPDATE		(0<<14)
#define W4_SHADOW_PROTECT	(1<<14)
#define W3_SHADOW_UPDATE		(0<<13)
#define W3_SHADOW_PROTECT	(1<<13)
#define W2_SHADOW_UPDATE		(0<<12)
#define W2_SHADOW_PROTECT	(1<<12)
#define W1_SHADOW_UPDATE		(0<<11)
#define W1_SHADOW_PROTECT	(1<<11)
#define W0_SHADOW_UPDATE		(0<<10)
#define W0_SHADOW_PROTECT	(1<<10)


// VIDOSD0A, VIDOSD1A, VIDOSD2A,VIDOSD3A, VIDOSD4A
// (VIDeo window 0, 1, 2, 3, 4 position control A register)
#define OSD_LTX_F(n)				(((n)&0x7FF)<<11)
#define OSD_LTY_F(n)				(((n)&0x7FF)<<0)

// VIDOSD0B, VIDOSD1B, VIDOSD2B,VIDOSD3B, VIDOSD4B
// (VIDeo window 0, 1, 2, 3, 4 position control B register)
#define OSD_RBX_F(n)			(((n)&0x7FF)<<11)
#define OSD_RBY_F(n)			(((n)&0x7FF)<<0)

// VIDOSD0C, VIDOSD1D, VIDOSD2D
// (VIDeo window 0 position control C & window 1,2 position control D register)
#define OSDSIZE(n)				(((n)&0xFFFFFF)<<0)



// VIDINTCON0 (VIDeo INTerrupt CONtrol 0 register)
// (LCD INTERRUPT CONTROL REGISTER)
#define INTVPEN_DISABLE			(0<<26)		//new(v6.0)
#define INTVPEN_ENABLE			(1<<26)
#define SYSMAINCON_DISABLE		(0<<19)
#define SYSMAINCON_ENABLE		(1<<19)
#define SYSSUBCON_DISABLE		(0<<18)
#define SYSSUBCON_ENABLE		(1<<18)
#define I80IFDONE_DISABLE		(0<<17)
#define I80IFDONE_ENABLE		(1<<17)
#define FRAMESEL0_BACK			(0<<15)
#define FRAMESEL0_VSYNC	    	(1<<15)
#define FRAMESEL0_ACTIVE		(2<<15)
#define FRAMESEL0_FRONT	    	(3<<15)
#define FRAMESEL1_NONE			(0<<13)
#define FRAMESEL1_BACK			(1<<13)
#define FRAMESEL1_VSYNC	    	(2<<13)
#define FRAMESEL1_FRONT		(3<<13)
#define INTFRMEN_DISABLE		(0<<12)
#define INTFRMEN_ENABLE	    	(1<<12)
#define FIFOSEL_WIN4			(1<<11)		// enable FIFO Interrupt of WIN4
#define FIFOSEL_WIN3			(1<<10)
#define FIFOSEL_WIN2			(1<<9)
#define FIFOSEL_WIN1			(1<<6)
#define FIFOSEL_WIN0			(1<<5)
#define FIFOSEL_ALL				(FIFOSEL_WIN0 | FIFOSEL_WIN1 | FIFOSEL_WIN2 | FIFOSEL_WIN3 | FIFOSEL_WIN4)
#define FIFOLEVEL_25			(0<<2)
#define FIFOLEVEL_50			(1<<2)
#define FIFOLEVEL_75			(2<<2)
#define FIFOLEVEL_EMPTY			(3<<2)
#define FIFOLEVEL_FULL			(4<<2)
#define INTFIFOEN_DISABLE		(0<<1)
#define INTFIFOEN_ENABLE		(1<<1)
#define INTEN_DISABLE			(0<<0)
#define INTEN_ENABLE			(1<<0)

// VIDINTCON1 (VIDeo INTerrupt CONtrol 1 register)
// (Video interrupt pending register)
#define INTVPPEND_NOREQ		(0<<5)
#define INTVPPEND_REQ			(1<<5)
#define INTI80PEND_NOREQ		(0<<2)
#define INTI80PEND_REQ			(1<<2)
#define INTFRMPEND_NOREQ		(0<<1)
#define INTFRMPEND_REQ			(1<<1)
#define INTFIFOPEND_NOREQ		(0<<0)
#define INTFIFOPEND_REQ   		(1<<0)

// W1KEYCON0, W2KEYCON0, W3KEYCON0, W4KEYCON0(Color Key Control Register)
#define KEYBLACKOUT_DISABLE		(0<<31)
#define KEYBLACKOUT_ENABLE		(1<<31)
#define KEYBLEN_F_DISABLE			(0<<26)
#define KEYBLEN_F_ENABLE			(1<<26)
#define KEYEN_F_DISABLE	    		(0<<25)
#define KEYEN_F_ENABLE			(1<<25)
#define DIRCON_MATCH_FG_IMAGE		(0<<24)		//display pixel from BG img
#define DIRCON_MATCH_BG_IMAGE	(1<<24)		//display pixel from FG img

// DITHMODE (DITHering MODE register)
#define RDITHPOS_8BIT			(0<<5)
#define RDITHPOS_6BIT			(1<<5)
#define RDITHPOS_5BIT			(2<<5)
#define GDITHPOS_8BIT			(0<<3)
#define GDITHPOS_6BIT			(1<<3)
#define GDITHPOS_5BIT			(2<<3)
#define BDITHPOS_8BIT			(0<<1)
#define BDITHPOS_6BIT			(1<<1)
#define BDITHPOS_5BIT			(2<<1)
#define RGB_DITHPOS_MASK		(0x3f<<1)
#define DITHERING_DISABLE		(0<<0)
#define DITHERING_ENABLE		(1<<0)

// WIN0MAP, WIN1MAP, WIN2MAP, WIN3MAP, WIN4MAP (WINdow color (MAP) control)
#define COLOR_MAP_DISABLE		(0<<24)
#define COLOR_MAP_ENABLE		(1<<24)

// TRIGCON (I80/RGB LCDC_Trigger CONtrol)
// LCDC_Trigger
#define W4_SW_TRIGGER			(1<<26)
#define W4_SW_TRIG_MODE		(1<<25)
#define W3_SW_TRIGGER			(1<<21)
#define W3_SW_TRIG_MODE		(1<<20)
#define W2_SW_TRIGGER			(1<<16)
#define W2_SW_TRIG_MODE		(1<<15)
#define W1_SW_TRIGGER			(1<<11)
#define W1_SW_TRIG_MODE		(1<<10)
#define W0_SW_TRIGGER			(1<<6)
#define W0_SW_TRIG_MODE		(1<<5)
#define I80_SW_TRIGGER			(1<<1)
#define I80_SW_TRIG_MODE		(1<<0)
#define SW_TRIGGER				(1<<1)		//need to be changed with src code(08.12.10)
#define SW_TRIG_MODE			(1<<0)		//need to be changed with src code(08.12.10)


// ITUIFCON0 (ITU(BT.601/656) InterFace CONtrol)
#define SELVSYNC_HSYNC			(0<<24)		// equal leading edge with Hsync
#define SELVSYNC_DELAYED		(1<<24)		// Delayed Vsync(standard)
#define DLYVSYNC(n)				(((n)&0xFF)<<16) // Numbers of clock cycles for delay fo the VSYNC signal
#define I656FIELD_NORMAL		(0<<9)		// new code on v6.0
#define I656FIELD_INVERT			(1<<9)
#define I656CLK_NORMAL			(0<<8)
#define I656CLK_INVERT			(1<<8)
#define I601HREF_NORMAL	    	(0<<6)
#define I601HREF_INVERT			(1<<6)
#define I601VSYNC_NORMAL		(0<<5)
#define I601VSYNC_INVERT		(1<<5)
#define I601HSYNC_NORMAL		(0<<4)
#define I601HSYNC_INVERT		(1<<4)
#define I601FIELD_NORMAL		(0<<3)
#define I601FIELD_INVERT			(1<<3)
#define I601CLK_NORMAL			(0<<2)
#define I601CLK_INVERT			(1<<2)

// I80IFCONA0, I80IFCONA1 (I80 InterFace CONtrol for main & sub LDI(LCD))
// (Main LCD System Interface Control)
#define LCD_CS_SETUP(n)			(((n)&0xF)<<16)
#define LCD_WR_SETUP(n)			(((n)&0xF)<<12)
#define LCD_WR_ACT(n)			(((n)&0xF)<<8)
#define LCD_WR_HOLD(n)			(((n)&0xF)<<4)
#define RSPOL_LOW				(0<<2)
#define RSPOL_HIGH				(1<<2)
#define I80IFEN_DISABLE			(0<<0)
#define I80IFEN_ENABLE			(1<<0)

// I80IFCONB0, I80IFCONB1 (I80 InterFace CONtrol for main & sub LDI(LCD))  added on v6.0 code
#define NORMAL_CMD_ST			(1<<9)
#define FRAME_SKIP_1			(0<<5)	//no skip
#define FRAME_SKIP_2			(1<<5)	
#define FRAME_SKIP_3			(2<<5)	
#define AUTO_CMD_DISABLE		(0x0<<0)
#define AUTO_CMD_RATE(n)		((((n>>1)&0xF))<<0)		//per n frame

// W1KEYALPHA, W2KEYALPHA, W3KEYALPHA, W4KEYALPHA (Color KEY ALPHA value register) there is no W0KEYALPHA
#define KEYALPHA_R(n)				(((n)&0xFF)<<16)
#define KEYALPHA_G(n)				(((n)&0xFF)<<8)
#define KEYALPHA_B(n)				(((n)&0xFF)<<0)

// VIDW0ALPHA0, VIDW0ALPHA1 (VIDeo Window 0 ALPHA register)
#define ALPHA0_R(n)				(((n)&0xFF)<<16)
#define ALPHA0_G(n)				(((n)&0xFF)<<8)
#define ALPHA0_B(n)				(((n)&0xFF)<<0)
#define ALPHA1_R(n)				(((n)&0xFF)<<16)
#define ALPHA1_G(n)				(((n)&0xFF)<<8)
#define ALPHA1_B(n)				(((n)&0xFF)<<0)


// VIDOSD1C, VIDOSD2C, VIDOSD3C, VIDOSD4C       new(v6.0)
// (VIDeo window 1,2,3,4 position control C register)
#define ALPHA0_R_H(n)			(((n)&0xF)<<20)
#define ALPHA0_G_H(n)			(((n)&0xF)<<16)
#define ALPHA0_B_H(n)			(((n)&0xF)<<12)
#define ALPHA1_R_H(n)			(((n)&0xF)<<8)
#define ALPHA1_G_H(n)			(((n)&0xF)<<4)
#define ALPHA1_B_H(n)			(((n)&0xF)<<0)

// VIDW1ALPHA0, VIDW1ALPHA1 (VIDeo Window 1 ALPHA register)
// VIDW2ALPHA0, VIDW2ALPHA1 (VIDeo Window 2 ALPHA register)
// VIDW3ALPHA0, VIDW3ALPHA1 (VIDeo Window 3 ALPHA register)
// VIDW4ALPHA0, VIDW4ALPHA1 (VIDeo Window 4 ALPHA register)
#define ALPHA0_R_L(n)			(((n)&0xF)<<16)
#define ALPHA0_G_L(n)			(((n)&0xF)<<8)
#define ALPHA0_B_L(n)			(((n)&0xF)<<0)
#define ALPHA1_R_L(n)			(((n)&0xF)<<16)
#define ALPHA1_G_L(n)			(((n)&0xF)<<8)
#define ALPHA1_B_L(n)			(((n)&0xF)<<0)

// New feature of FIMD v6.0 (Image Enhancement Block)
// BLENDEQ1, BLENDEQ2, BLENDEQ3, BLENDEQ4 (BLENDing EQuation)
#define Q_FUNC(n)				(((n)&0xF)<<18)
#define P_FUNC(n)				(((n)&0xF)<<12)
#define B_FUNC(n)				(((n)&0xF)<<6)
#define A_FUNC(n)				(((n)&0xF)<<0)

// BLENDCON (BLENDing CONtrol register)
#define BLEND_NEW_4BIT			(0<<0)	//for FIMD v4.2 usability
#define BLEND_NEW_8BIT			(1<<0)

// COLORGAINCON (COLOR GAIN CONtrol register)
#define CG_RGAIN(n)				(((n)&0x3FF)<<20)
#define CG_GGAIN(n)				(((n)&0x3FF)<<10)
#define CG_BGAIN(n)				(((n)&0x3FF)<<0)

// VESFRCON0 (Visibility Enhancement (ALPS) CONtrol register)
#define LUX_LOW					(0<<0)
#define LUX_HIGH				(1<<2)
#define VE_SW_RESET_F_DISABLE	(0<<1)
#define VE_SW_RESET_F_ENABLE	(1<<1)

// VESFRCON1 (Visibility Enhancement (ALPS) CONtrol register)
#define VE_VSIZE_F(n)			(((n)&0x7FF)<<21)
#define VE_HSIZE_F(n)			(((n)&0x7FF)<<10)

/*
#define ODV_SEL_DISABLE		(0<<8)
#define ODV_SEL_ENABLE			(1<<8)
*/
// VESFRCON2 (Visibility Enhancement (ALPS) CONtrol register)
#define ODV_PARA1_720_288		(0x14<<12)
#define ODV_PARA1_720_240		(0x18<<12)
#define ODV_PARA1_640_240		(0x1b<<12)
#define ODV_PARA1_640_288		(0x5b<<12)

#define ODV_PARA2_640_288		(0x00<<4)
#define ODV_PARA2_720_240		(0x2d<<4)
#define ODV_PARA2_720_288		(0x2e<<4)
#define ODV_PARA2_640_240		(0x2e<<4)

#define ODV_SEL_720_288		(0x00<<0)
#define ODV_SEL_720_240		(0x00<<0)
#define ODV_SEL_640_240		(0x00<<0)
#define ODV_SEL_640_288		(0x10<<0)

#define ODV_SEL_FREESIZE		(0x11<<0)

// HUECOEF00 (HUE COEFficient control register (coeff 00))
#define CBG0_P(n)				(((n)&0x3FF)<<16)
#define CBG0_N(n)				(((n)&0x3FF)<<0)

// HUECOEF01 (HUE COEFficient control register (coeff 00))
#define CBG1_P(n)				(((n)&0x3FF)<<16)
#define CBG1_N(n)				(((n)&0x3FF)<<0)


// HUECOEF10 (HUE COEFficient control register (coeff 00))
#define CRG0_P(n)				(((n)&0x3FF)<<16)
#define CRG0_N(n)				(((n)&0x3FF)<<0)


// HUECOEF11 (HUE COEFficient control register (coeff 00))
#define CRG1_P(n)				(((n)&0x3FF)<<16)
#define CRG1_N(n)				(((n)&0x3FF)<<0)

// HUEOFFSET (HUE OFFSET control register)
#define OFFSET_IN(n)				(((n)&0x1FF)<<16)
#define OFFSET_OUT(n)			(((n)&0x1FF)<<0)

// W0RTQOSCON, W1RTQOSCON, W2RTQOSCON, W3RTQOSCON, W4RTQOSCON (Window RTQOS CONtrol register)
#define FIFOLEVEL(n)				(((n)&0xFF)<<4)		// new(v6.0)
#define QOS_GATE				(0<<1)		// gated
#define QOS_GATE_DISABLE		(1<<1)		// not gated

/*
// DUALCON								//new(v6.0)
#define MIEDUAL_DIS				(0<<0)
#define MIEDUAL_ENABLE			(1<<0)
#define DUAL_LINESPLIT			(0<<2)
#define DUAL_FRAMESPLIT			(1<<2)
#define DUAL_SUBCOUNT(n)			(((n)&0xFFF)<<4)
#define DUAL_MAINCOUNT(n)			(((n)&0xFFF)<<18)
#define DUAL_VDEN_EN			(1<<16)
#define DUAL_VDEN_DIS			(0<<16)
*/
	
// DUALCON									//new(v6.0)
#define DUAL_DIS					(0<<0)		// FIMD Single
#define DUAL_FIMD				(1<<0)
#define DUAL_MIE				(2<<0)
#define DUAL_MDNIE				(3<<0)
#define DUAL_LINESPLIT			(0<<2)
#define DUAL_FRAMESPLIT			(1<<2)
#define DUAL_SUBCOUNT(n)			(((n)&0xFFF)<<4)
#define DUAL_MAINCOUNT(n)			(((n)&0xFFF)<<17)
#define DUAL_VDEN_EN			(1<<16)
#define DUAL_VDEN_DIS			(0<<16)






// Timing parameter for LTS_222Q i80 I/F
#if (LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL==LCD_S6D0139_CPU)
	#define WR_ACT_TIME	    	(4&0xf)
	#define WR_HOLD_TIME		(0&0xf)
#elif (LCD_MODEL == LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI)

#endif


LCDC oIeLcdc;



//-------------------------------------------------------------------------
// Function Name : MDNIE_Select
// Function Description : This function select mDNIe's Algorithm
// Input : eAlgoSel ; HDTRonly, HDTRwCP(Color Preference), HDTRwVE(visibility Enhance)
//           eMcmSel ; NOMCM, MCM
//           eLpaSel  ; NOLPA, LPA
// Output : none
// Version : v0.0
//-------------------------------------------------------------------------
void MDNIE_SelectMode(ALGO_SEL eAlgoSel, MCM_SEL eMcmSel, LPA_SEL eLpaSel)
{
	u32 uTmpReg;
	u32 uTmpVal = 0x0;


	uTmpVal = (uTmpVal & ~(HDTR_VE)) | 
	((eAlgoSel == HDTRonly) ? HDTR :
	(eAlgoSel == HDTRwCP) ? HDTR_CP :
	(eAlgoSel == HDTRwVE) ? HDTR_VE : Assert(0));
									
	uTmpVal = (uTmpVal & ~(MCM_ON)) |
	((eMcmSel == NOMCM) ? MCM_OFF :
	(eMcmSel == MCM) ? MCM_ON : Assert(0));

	uTmpVal = (uTmpVal & ~(LPA_ON)) |
	((eLpaSel == NOLPA) ? LPA_OFF :
	(eLpaSel == LPA) ? LPA_ON : Assert(0));	
	
	mDNIeInp32(rR1, uTmpReg);

	uTmpReg = (uTmpReg & ~(0xf0)) | uTmpVal ;

	mDNIeOutp32(rR1,uTmpReg);


}



//-------------------------------------------------------------------------
// Function Name : MDNIE_Select
// Function Description : This function select mDNIe's Algorithm
// Input : eAlgoSel ; HDTRonly, HDTRwCP(Color Preference), HDTRwVE(visibility Enhance)
//           eMcmSel ; NOMCM, MCM
//           eLpaSel  ; NOLPA, LPA
// Output : none
// Version : v0.0
//-------------------------------------------------------------------------
void MDNIE_SelectModeMask(MODE_CHANGE_MASK eModeMask)
{
	u32 uTmpReg;

	mDNIeInp32(rR1, uTmpReg);

	if(eModeMask == MDNIE_MASK)
		{
	uTmpReg = uTmpReg & ~(0x1) | 0x1;
		}
	else
		{
	uTmpReg = uTmpReg & ~(0x1) | 0x0;
		}
	mDNIeOutp32(rR1,uTmpReg);


}


//---------------------------------------------------------
// Function Name : MDNIE_SetSize
// Function Description : This function set Output Image Size
// Input : eHSize ; output Horizental Size       eVSize ; output Vertical Size
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetSize(u32 uHSize, u32 uVSize)
{
	u32 uTmpReg;

//	if (uHSize > 1024 || uVSize > 768)		// v210 target XGA (1024 x 768)
//		Assert(0);
	
	mDNIeInp32(rR2, uTmpReg);
	uTmpReg = uTmpReg & ~(0x7ff) | HSIZE(uHSize);
	
	mDNIeOutp32(rR2, uTmpReg);


	mDNIeInp32(rR3, uTmpReg);
	uTmpReg = uTmpReg & ~(0x7ff) | VSIZE(uVSize);
	
	mDNIeOutp32(rR3, uTmpReg);

}

//---------------------------------------------------------
// Function Name : MDNIE_SetDeContour_Th
// Function Description : This function set DeContour Threshold value
// Input : uDirecVal ; 0~4095
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetDeContour_Th(u32 uDeConVal)
{
	u32 uTmpReg;

	if (uDeConVal > 4095)
		Assert(0);


	mDNIeInp32(rR36,uTmpReg);
	uTmpReg = uTmpReg & ~(0xFFF) | DECONT_TH(uDeConVal);
	mDNIeOutp32(rR36,uTmpReg);		

}


//---------------------------------------------------------
// Function Name : MDNIE_SetDirectional_Th
// Function Description : This function set Directional Threshold value
// Input : uDirecVal ; 0~4095
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetDirectional_Th(u32 uDirecVal)
{
	u32 uTmpReg;

	if (uDirecVal > 4095)
		Assert(0);


	mDNIeInp32(rR37,uTmpReg);
	uTmpReg = uTmpReg & ~(0xFFF) | DIRECT_TH(uDirecVal);
	mDNIeOutp32(rR37,uTmpReg);		

}

//---------------------------------------------------------
// Function Name : MDNIE_SetSimplicity_Th
// Function Description : This function set Simplicity Threshold value
// Input : uSimpVal ; 0~92
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetSimplicity_Th(u32 uSimpVal)
{
	u32 uTmpReg;

	if (uSimpVal > 92)
		Assert(0);

	mDNIeInp32(rR38,uTmpReg);
	uTmpReg = uTmpReg & ~(0x7F) | SIMPLE_TH(uSimpVal);
	mDNIeOutp32(rR38,uTmpReg);		

}

//---------------------------------------------------------
// Function Name : MDNIE_SetEdgeEnhance
// Function Description : This function set Edge Enhance control value
// Input : uEdgeEnh ; 0~127		0 = DE off
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetEdgeEnhance(u32 uEdgeEnh)
{
	u32 uTmpReg;

	if (uEdgeEnh > 127)
		Assert(0);

	mDNIeInp32(rR39,uTmpReg);
	uTmpReg = uTmpReg & ~(0x7F<<5) | DE_CONT(uEdgeEnh);
	mDNIeOutp32(rR39,uTmpReg);		

}

//---------------------------------------------------------
// Function Name : MDNIE_SetEdgeDetect
// Function Description : This function set Edge Detect control value
// Input : uEdgeDet ; 0~1023
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetEdgeDetect(u32 uEdgeDet)
{
	u32 uTmpReg;

	if (uEdgeDet > 1023)
		Assert(0);

	mDNIeInp32(rR45,uTmpReg);
	uTmpReg = uTmpReg & ~(0x3FF<<5) | DE_TH(uEdgeDet);
	mDNIeOutp32(rR45,uTmpReg);		

}

//---------------------------------------------------------
// Function Name : MDNIE_SetCEenable
// Function Description : This function set Contrast Enhancement enable/disable
// Input : eCEsel ; CEon / CEoff
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetCEenable(CE_ENABLE eCEsel)
{
	u32 uTmpReg;

	mDNIeInp32(rR39,uTmpReg);
	

	if(eCEsel == CEon)
		uTmpReg = uTmpReg & ~(0x10) | CE_ON;

	else if (eCEsel == CEoff)
		uTmpReg = uTmpReg & ~(0x10) | CE_OFF;

	mDNIeOutp32(rR39,uTmpReg);
	

}

//---------------------------------------------------------
// Function Name : MDNIE_SetCECurve
// Function Description : This function set CE curve range
// Input : uCEcurve ; 1~5
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetCECurve(u32 uCEcurve)
{
	u32 uTmpReg;

	if (uCEcurve > 5 || uCEcurve <1 )
		Assert(0);

	mDNIeInp32(rR39,uTmpReg);
	
	uTmpReg = uTmpReg & ~(0xE) | CE_CURVE(uCEcurve);
	
	mDNIeOutp32(rR39,uTmpReg);
	

}


//---------------------------------------------------------
// Function Name : MDNIE_SetSkinEnable
// Function Description : This function set Skin detect mode enable/disable
// Input : eSkinSel ; SKIN_ON  / SKIN_OFF
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetSkinEnable(SKIN_ENABLE eSkinSel)
{
	u32 uTmpReg;

	mDNIeInp32(rR43,uTmpReg);
	

	if(eSkinSel == SKIN_ON)
		uTmpReg = uTmpReg & ~(0x400) | CS_SKIN_ON;

	else if (eSkinSel == SKIN_OFF)
		uTmpReg = uTmpReg & ~(0x400) | CS_SKIN_OFF;

	mDNIeOutp32(rR43,uTmpReg);
	

}

//---------------------------------------------------------
// Function Name : MDNIE_SetCScontrol
// Function Description : This function set CS control range
// Input : uCScontrol ; 0~1023
// Output : none
// Version : v0.0
//---------------------------------------------------------
void MDNIE_SetCScontrol(u32 uCScontrol)
{
	u32 uTmpReg;

	if (uCScontrol > 1023)
		Assert(0);

	mDNIeInp32(rR43,uTmpReg);
	
	uTmpReg = uTmpReg & ~(0x3ff) | CS_CONT(uCScontrol);
	
	mDNIeOutp32(rR43,uTmpReg);

}




//---------------------------------------------------------
// Function Name : IEIP_Select
// Function Description : This function select Image Enhancement IP
// Input : eSel ; MDNIE or MIE or BYPASS
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDIP_Select(MDNIE_SEL eSel)		// need to be created at VIC controller code later (09.01.23 WJ.Kim)
{


	u32 uTmpReg;

	IeLcdcInp32(DUALCON,uTmpReg);

	if(eSel == DISP_MDNIE)
		uTmpReg = uTmpReg & ~(0x3) | DUAL_MDNIE ;		//mDNIe single or Dual (selectable in mDNIe IELCD SFR)
	else if(eSel == DISP_MIE)
		uTmpReg = uTmpReg & ~(0x3) | DUAL_MDNIE ;		//MIE Single
	else		//bypass
		uTmpReg = uTmpReg & ~(0x3) | DUAL_DIS ;		

	IeLcdcOutp32(DUALCON,uTmpReg);
	
}



//---------------------------------------------------------
// Function Name : IELCDC_Start
// Function Description : This function starts IELCDC
// Input : none
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_Start(void)
{
	u32 uLcdCon;

	IeLcdcInp32(VIDCON0, uLcdCon);
	uLcdCon |= 0x3<<0;
	IeLcdcOutp32(VIDCON0, uLcdCon);

}


void IELCDC_LogicStart(void)
{
	IeLcdcOutp32(GPOUTCON0, 0x2ff47);
//	IeLcdcOutp32(GPOUTCON0, 0x2ff4f);
}




void IELCDC_LogicStop(void)
{
	IeLcdcOutp32(GPOUTCON0, 0x0);
//	IeLcdcOutp32(GPOUTCON0, 0x2ff4f);
}

//---------------------------------------------------------
// Function Name : IELCDC_Stop
// Function Description : This function stops IELCDC
// Input : none
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_Stop(void)	// Direct off
{
	u32 uLcdCon;
	u32 uSfr;

	IeLcdcInp32(VIDCON0, uLcdCon);
	uLcdCon &=~ (3<<0);
	IeLcdcOutp32(VIDCON0, uLcdCon);
}

//---------------------------------------------------------
// Function Name : IELCDC_InitIp
// Function Description : This function init IELCDC base and window
// Input : eBpp ; 
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_InitIp(void)
{
	IELCDC_InitBase();
	IELCDC_InitWin(RGB888, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz, 0, 0, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz,
		0, 0, 0, WIN0, false);
}	


void IELCDC_InitIpDualFs(LCD_SCAN_TYPE eScan)
{
	IELCDC_InitBaseDualFs();

	if(eScan == LCD_LANDSCAPE)
	{
	
	IELCDC_InitWin(RGB888,oIeLcdc.m_uLcdHSz, (oIeLcdc.m_uLcdVSz), 0, 0, oIeLcdc.m_uLcdHSz, (oIeLcdc.m_uLcdVSz),
	0, 0, 0, WIN0, false);
	}

	else
	{
	IELCDC_InitWin(RGB888,(oIeLcdc.m_uLcdHSz), (oIeLcdc.m_uLcdVSz), 0, 0, oIeLcdc.m_uLcdHSz*2, (oIeLcdc.m_uLcdVSz/2),
	0, 0, 0, WIN0, false);
	}	
}


void IELCDC_InitIpDualLs(LCD_SCAN_TYPE eScan)
{
	IELCDC_InitBaseDualLs();


	if(eScan == LCD_LANDSCAPE)
	{
	//LCD A Init
	IELCDC_InitWin(RGB888, (oIeLcdc.m_uLcdHSz), oIeLcdc.m_uLcdVSz, 0, 0, (oIeLcdc.m_uLcdHSz), oIeLcdc.m_uLcdVSz,
	0, 0, 0, WIN0, false);

	}
	else
	{
	//LCD A Init
	IELCDC_InitWin(RGB888, (oIeLcdc.m_uLcdHSz), (oIeLcdc.m_uLcdVSz), 0, 0, (oIeLcdc.m_uLcdHSz), (oIeLcdc.m_uLcdVSz),
	0, 0, 0, WIN0, false);
	}
}




//---------------------------------------------------------
// Function Name : IELCDC_InitBase
// Function Description : This function set VIDCON0,1 VIDTCON0,1,2 & VIDINTCON0
// Input : none
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_InitBase(void)
{
	u32 uVidconReg=0;
	u32 uVidOutFormat;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	LCD_WINDOW eWin;
	u32 i;
	
	oIeLcdc.m_bAutoBuf = false;
	oIeLcdc.m_uScanMode = 0; // progressive mode
	oIeLcdc.m_bFifoIn[1] = false;
	oIeLcdc.m_bFifoIn[2] = false;

// IELCDC input is Local path
	oIeLcdc.m_bFifoIn[0] = true;
	oIeLcdc.m_eLocalIn[0] = IN_POST;
	oIeLcdc.m_uLocalInColorSpace[WIN0] = LOCAL_IF_RGB24;

	
#if (LCD_MODEL == LCD_LTV350QV_RGB)
	
	oIeLcdc.m_uLcdHSz = 320;
	oIeLcdc.m_uLcdVSz = 240;
	uVidOutFormat = VIDOUT_RGBIF;

	IeLcdcOutp32(VIDCON1, IHSYNC_INVERT | IVSYNC_INVERT); 	
	IeLcdcOutp32(VIDTCON0, VBPDE(VBPD_LTV350QV) | VBPD(VBPD_LTV350QV) | VFPD(VFPD_LTV350QV) | VSPW(VSPW_LTV350QV));
	IeLcdcOutp32(VIDTCON1, VFPDE(VFPD_LTV350QV) | HBPD(HBPD_LTV350QV) | HFPD(HFPD_LTV350QV) | HSPW(HSPW_LTV350QV));

#elif ( LCD_MODEL == LCD_LTS350Q1 )
	oIeLcdc.m_uLcdHSz = 240;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;

	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_NORMAL | IVSYNC_NORMAL | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_240320) | VFPD(VFPD_240320) | VSPW(VSPW_240320));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_240320) | HFPD(HFPD_240320) | HSPW(HSPW_240320));
	
#elif ( LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU )
	oIeLcdc.m_uLcdHSz = 240;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_I80IF0;
	
#elif ( LCD_MODEL == LCD_LTS222Q_RGB )
	oIeLcdc.m_uLcdHSz = 240;
	oIeLcdc.m_uLcdVSz = 320;

	uVidOutFormat = VIDOUT_RGBIF;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	
#elif ( LCD_MODEL == LCD_LTS222Q_SRGB)
	oIeLcdc.m_uLcdHSz = 240;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	uVidconReg |= PNRMODE_RGB_S;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));

#elif (LCD_MODEL == LCD_LTE480WV_RGB)
	oIeLcdc.m_uLcdHSz = 800;
	oIeLcdc.m_uLcdVSz = 480;
	uVidOutFormat = VIDOUT_RGBIF;
	IeLcdcOutp32(VIDCON1,IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(6) | VBPD(6) | VFPD(4) | VSPW(0) );
	IeLcdcOutp32(VIDTCON1, VFPDE(4) | HBPD(12) | HFPD(7) | HSPW(2));


#elif (LCD_MODEL == LTM030DK)
	
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 800;
	uVidOutFormat = VIDOUT_RGBIF;

	IeLcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_NORMAL); //Check 

	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTM030DK3A ) | VFPD(VFPD_LTM030DK3A ) | VSPW(VSPW_LTM030DK3A ));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTM030DK3A ) | HFPD(HFPD_LTM030DK3A ) | HSPW(HSPW_LTM030DK3A ));

#elif (LCD_MODEL == LCD_TL2796)
	
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 800;
	uVidOutFormat = VIDOUT_RGBIF;
	IeLcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_INVERT); //Check 

	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_TL2796) | VFPD(VFPD_TL2796 ) | VSPW(VSPW_TL2796 ));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_TL2796 ) | HFPD(HFPD_TL2796 ) | HSPW(HSPW_TL2796 ));

#elif (LCD_MODEL == LCD_HD)
	oIeLcdc.m_uLcdHSz = 1366;
	oIeLcdc.m_uLcdVSz = 768;
	uVidOutFormat = VIDOUT_RGBIF;

	IeLcdcOutp32(VIDCON1, IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(VBPD_HD) | VBPD(VBPD_HD) | VFPD(VFPD_HD) | VSPW(VSPW_HD));
	IeLcdcOutp32(VIDTCON1, VFPDE(VFPD_HD) | HBPD(HBPD_HD) | HFPD(HFPD_HD) | HSPW(HSPW_HD));



#else
	Assert(0);
#endif

	IeLcdcOutp32(VIDTCON2, LINEVAL(oIeLcdc.m_uLcdVSz-1) | HOZVAL(oIeLcdc.m_uLcdHSz-1));
	IELCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		IeLcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	IELCDC_GetClkValAndClkDir(oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(LCD_MODEL==LCD_LTS222Q_SRGB)
		{

			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	


	IeLcdcOutp32(VIDCON0, uVidconReg);

	IeLcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	IELCDC_SetWinOnOff(0,WIN0); // Turn all windows off
	IELCDC_SetColorMapOnOff(0,WIN0); // Turn all windows color map off
//	IELCDC_SetColorKeyOnOff(0,WIN0); // Turn all windows Color Key off
}


void IELCDC_InitBaseDualFs(void)
{
	u32 uVidconReg=0;
	u32 uVidOutFormat;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	LCD_WINDOW eWin;
	u32 i;
	
	oIeLcdc.m_bAutoBuf = false;
	oIeLcdc.m_uScanMode = 0; // progressive mode
	oIeLcdc.m_bFifoIn[1] = false;
	oIeLcdc.m_bFifoIn[2] = false;

// IELCDC input is Local path
	oIeLcdc.m_bFifoIn[0] = true;
	oIeLcdc.m_eLocalIn[0] = IN_POST;
	oIeLcdc.m_uLocalInColorSpace[WIN0] = LOCAL_IF_RGB24;




#if (LCD_MODEL == LCD_LTV350QV_RGB)
	
	oIeLcdc.m_uLcdHSz = 320;
	oIeLcdc.m_uLcdVSz = 480;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	IeLcdcOutp32(VIDCON1, IHSYNC_INVERT | IVSYNC_INVERT); 	
	IeLcdcOutp32(VIDTCON0, VBPDE(VBPD_LTV350QV) | VBPD(VBPD_LTV350QV) | VFPD(VFPD_LTV350QV) | VSPW(VSPW_LTV350QV));
	IeLcdcOutp32(VIDTCON1, VFPDE(VFPD_LTV350QV) | HBPD(HBPD_LTV350QV) | HFPD(HFPD_LTV350QV) | HSPW(HSPW_LTV350QV));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix



#elif ( LCD_MODEL == LCD_LTS350Q1 )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_NORMAL | IVSYNC_NORMAL | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_240320) | VFPD(VFPD_240320) | VSPW(VSPW_240320));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_240320) | HFPD(HFPD_240320) | HSPW(HSPW_240320));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix
	
#elif ( LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_I80IF0;
	
#elif ( LCD_MODEL == LCD_LTS222Q_RGB )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	//oIeLcdc.m_uLcdHSz = 320;
	//oIeLcdc.m_uLcdVSz = 240;

	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix
	
#elif ( LCD_MODEL == LCD_LTS222Q_SRGB)
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	uVidconReg |= PNRMODE_RGB_S;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix

#elif (LCD_MODEL == LCD_LTE480WV_RGB)
	oIeLcdc.m_uLcdHSz = 800;
	oIeLcdc.m_uLcdVSz = 960;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1,IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(6) | VBPD(6) | VFPD(4) | VSPW(0) );
	IeLcdcOutp32(VIDTCON1, VFPDE(4) | HBPD(12) | HFPD(7) | HSPW(2));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix

#elif (LCD_MODEL == LTM030DK)
	
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 1600;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	
	IeLcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_NORMAL); //Check 

	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTM030DK3A ) | VFPD(VFPD_LTM030DK3A ) | VSPW(VSPW_LTM030DK3A ));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTM030DK3A ) | HFPD(HFPD_LTM030DK3A ) | HSPW(HSPW_LTM030DK3A ));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix


#else
	Assert(0);
#endif

	IeLcdcOutp32(VIDTCON2, LINEVAL(oIeLcdc.m_uLcdVSz-1) | HOZVAL(oIeLcdc.m_uLcdHSz-1));
	IELCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		IeLcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	IELCDC_GetClkValAndClkDir(oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);


	if(LCD_MODEL==LCD_LTS222Q_SRGB)
		{

			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	

	IeLcdcOutp32(VIDCON0, uVidconReg);

	IeLcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	IELCDC_SetWinOnOff(0,WIN0); // Turn all windows off
	IELCDC_SetColorMapOnOff(0,WIN0); // Turn all windows color map off


}

void IELCDC_InitBaseDualLs(void)
{
	u32 uVidconReg=0;
	u32 uVidOutFormat;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	LCD_WINDOW eWin;
	u32 i;

	oIeLcdc.m_bAutoBuf = false;
	oIeLcdc.m_uScanMode = 0; // progressive mode
	oIeLcdc.m_bFifoIn[1] = false;
	oIeLcdc.m_bFifoIn[2] = false;

// IELCDC input is Local path
	oIeLcdc.m_bFifoIn[0] = true;
	oIeLcdc.m_eLocalIn[0] = IN_POST;
	oIeLcdc.m_uLocalInColorSpace[WIN0] = LOCAL_IF_RGB24;

	
#if (LCD_MODEL == LCD_LTV350QV_RGB)
	
//	oIeLcdc.m_uLcdHSz = 320;
//	oIeLcdc.m_uLcdVSz = 480;
	oIeLcdc.m_uLcdHSz = 640;
	oIeLcdc.m_uLcdVSz = 240;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	IeLcdcOutp32(VIDCON1, IHSYNC_INVERT | IVSYNC_INVERT); 	
	IeLcdcOutp32(VIDTCON0, VBPDE(VBPD_LTV350QV) | VBPD(VBPD_LTV350QV) | VFPD(VFPD_LTV350QV) | VSPW(VSPW_LTV350QV));
	IeLcdcOutp32(VIDTCON1, VFPDE(VFPD_LTV350QV) | HBPD(HBPD_LTV350QV) | HFPD(HFPD_LTV350QV) | HSPW(HSPW_LTV350QV));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix



#elif ( LCD_MODEL == LCD_LTS350Q1 )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_NORMAL | IVSYNC_NORMAL | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_240320) | VFPD(VFPD_240320) | VSPW(VSPW_240320));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_240320) | HFPD(HFPD_240320) | HSPW(HSPW_240320));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix
	
#elif ( LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_I80IF0;
	
#elif ( LCD_MODEL == LCD_LTS222Q_RGB )
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	//oIeLcdc.m_uLcdHSz = 320;
	//oIeLcdc.m_uLcdVSz = 240;

	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix
	
#elif ( LCD_MODEL == LCD_LTS222Q_SRGB)
	oIeLcdc.m_uLcdHSz = 480;
	oIeLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	uVidconReg |= PNRMODE_RGB_S;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix

#elif ( LCD_MODEL == LCD_S6D66A0_RGB )
	oIeLcdc.m_uLcdHSz = 640;
	oIeLcdc.m_uLcdVSz = 480;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_NORMAL | IVSYNC_NORMAL | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix

#elif (LCD_MODEL == LCD_LTE480WV_RGB)
	oIeLcdc.m_uLcdHSz = 1600;
	oIeLcdc.m_uLcdVSz = 480;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	IeLcdcOutp32(VIDCON1,IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	IeLcdcOutp32(VIDTCON0, VBPDE(6) | VBPD(6) | VFPD(4) | VSPW(0) );
	IeLcdcOutp32(VIDTCON1, VFPDE(4) | HBPD(12) | HFPD(7) | HSPW(2));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix

#elif (LCD_MODEL == LTM030DK)
	
	oIeLcdc.m_uLcdHSz = 960;
	oIeLcdc.m_uLcdVSz = 800;
	uVidOutFormat = VIDOUT_RGBIF;
	oIeLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oIeLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	
	IeLcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_NORMAL); //Check 

	IeLcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTM030DK3A ) | VFPD(VFPD_LTM030DK3A ) | VSPW(VSPW_LTM030DK3A ));
	IeLcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTM030DK3A ) | HFPD(HFPD_LTM030DK3A ) | HSPW(HSPW_LTM030DK3A ));
	IeLcdcOutp32(DITHMODE, oIeLcdc.m_uDitherMode); // Fixed Dithering Matrix


#else
	Assert(0);
#endif

	IeLcdcOutp32(VIDTCON2, LINEVAL(oIeLcdc.m_uLcdVSz-1) | HOZVAL(oIeLcdc.m_uLcdHSz-1));
	IELCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		IeLcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	IELCDC_GetClkValAndClkDir(oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(LCD_MODEL==LCD_LTS222Q_SRGB)
	uVidconReg =
		VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
		CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
		ENVID_DISABLE | ENVID_F_DISABLE;
	else
	uVidconReg =
		VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
		CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
		ENVID_DISABLE | ENVID_F_DISABLE;

	IeLcdcOutp32(VIDCON0, uVidconReg);

	IeLcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	IELCDC_SetWinOnOff(0,WIN0); // Turn all windows off
	IELCDC_SetColorMapOnOff(0,WIN0); // Turn all windows color map off
}




//---------------------------------------------------------
// Function Name : IELCDC_InitWin
// Function Description : This function set
// Input : eBpp ; input IMG format   uFrameH ; frame buffer 
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_InitWin(IMG_FMT eBpp, u32 uFrameH, u32 uFrameV, u32 uX_Frame, u32 uY_Frame,  u32 uViewH, u32 uViewV,
		u32 uX_Lcd, u32 uY_Lcd, u32 uFbAddr, LCD_WINDOW eWin, bool bIsDoubleBuf) // For WIN0
{
	u32 uOffset;
	u32 uLineVal;
	u32 uBurstSize;

	Assert( (uFbAddr&0xf00000)!=0xf00000);
	
	// Viewport size must be less than LCD size
	Assert(uViewH <= oIeLcdc.m_uLcdHSz);
	Assert(uViewV <= oIeLcdc.m_uLcdVSz);

	// Check (X,Y) coordinate is valid in LCD and Frame?
	Assert( ((uX_Frame + uViewH) <= uFrameH) && ((uY_Frame + uViewV) <= uFrameV) );
	Assert( (uX_Lcd + uViewH <= oIeLcdc.m_uLcdHSz) && (uY_Lcd + uViewV <= oIeLcdc.m_uLcdVSz) );
	
	oIeLcdc.m_uFrmHSz[eWin] = uFrameH;
	oIeLcdc.m_uFrmVSz[eWin] = uFrameV;

	oIeLcdc.m_uViewHSz[eWin] = uViewH;
	oIeLcdc.m_uViewVSz[eWin] = uViewV;

	oIeLcdc.m_uLcdStX = uX_Lcd;
	oIeLcdc.m_uLcdStY = uY_Lcd;

	uOffset = oIeLcdc.m_uFrmHSz[eWin] - oIeLcdc.m_uViewHSz[eWin];

	oIeLcdc.m_uBitSwpMode = BITSWP_DISABLE;
	oIeLcdc.m_uBytSwpMode = BYTSWP_DISABLE;
	oIeLcdc.m_uHawSwpMode = HAWSWP_DISABLE;

	oIeLcdc.m_uMaxBurstLen = MAX_BURSTLEN_16WORD;
	
	if (eBpp == PAL1)
	{
		oIeLcdc.m_uBytes = 1;
		oIeLcdc.m_uBits = 4;
		Assert( !(uOffset%32) ); // Must keep to word-alignment
		oIeLcdc.m_uBppMode = BPPMODE_F_1BPP;

		oIeLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL2)
	{
		oIeLcdc.m_uBytes = 1;
		oIeLcdc.m_uBits = 4;
		Assert( !(uOffset%16) ); // Must keep to word-alignment
		oIeLcdc.m_uBppMode = BPPMODE_F_2BPP;

		oIeLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL4)
	{
		oIeLcdc.m_uBytes = 1;
		oIeLcdc.m_uBits = 2;

		Assert( !(uOffset%8) ); // Must keep to word-alignment
		oIeLcdc.m_uBppMode = BPPMODE_F_4BPP;

		oIeLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL8)
	{
		oIeLcdc.m_uBytes = 1;
		oIeLcdc.m_uBits = 1;
		Assert( !(uOffset%4) ); // Must keep to word-alignment
		oIeLcdc.m_uBppMode = BPPMODE_F_8BPP_PAL;
		oIeLcdc.m_uBytSwpMode = BYTSWP_ENABLE;
	}
	else if (eBpp == ARGB8) // A232
	{
		oIeLcdc.m_uBytes = 1;
		oIeLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oIeLcdc.m_uBppMode = BPPMODE_F_8BPP_NOPAL;
		oIeLcdc.m_uHawSwpMode = BYTSWP_ENABLE;
	}
	else if (eBpp == RGB16)
	{
		oIeLcdc.m_uBytes = 2;
		oIeLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oIeLcdc.m_uBppMode = BPPMODE_F_16BPP_565;
		oIeLcdc.m_uHawSwpMode = HAWSWP_ENABLE;
		oIeLcdc.m_uWordSwpMode = WRDSWP_DISABLE;
	}
	else if (eBpp == ARGB16)
	{
		oIeLcdc.m_uBytes = 2;
		oIeLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oIeLcdc.m_uBppMode = BPPMODE_F_16BPP_A555;
		oIeLcdc.m_uHawSwpMode = HAWSWP_ENABLE;
	}
	else if (eBpp == RGB24)
	{
		oIeLcdc.m_uBytes = 4;
		oIeLcdc.m_uBits = 1;

		oIeLcdc.m_uWordSwpMode = WRDSWP_ENABLE;
		oIeLcdc.m_uBppMode = BPPMODE_F_24BPP_888;
	}
	else if (eBpp == ARGB24)
	{
		oIeLcdc.m_uBytes = 4;
		oIeLcdc.m_uBits = 1;

		oIeLcdc.m_uWordSwpMode = WRDSWP_ENABLE;
		oIeLcdc.m_uBppMode = BPPMODE_F_24BPP_A887;
	}

	else if (eBpp == ARGB25)
	{
		oIeLcdc.m_uBytes = 4;
		oIeLcdc.m_uBits = 1;
		oIeLcdc.m_uBppMode = BPPMODE_F_25BPP_A888;
	}

	else if (eBpp == ARGB8888)
	{
		oIeLcdc.m_uBytes = 4;
		oIeLcdc.m_uBits = 1;
		oIeLcdc.m_uBppMode = BPPMODE_F_32BPP_8888;
	}
	else
	{
		Assert(0);
	}

	// Get offsetsize, pagewidth and lineVal
	if (oIeLcdc.m_uFrmHSz[eWin] >= oIeLcdc.m_uViewHSz[eWin])
	{
		oIeLcdc.m_uOffsetSz[eWin] = uOffset*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;
		oIeLcdc.m_uPageWidth[eWin] = oIeLcdc.m_uViewHSz[eWin]*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;

		uBurstSize =
			(oIeLcdc.m_uMaxBurstLen == MAX_BURSTLEN_16WORD) ? 16*4 :
			(oIeLcdc.m_uMaxBurstLen == MAX_BURSTLEN_8WORD) ? 8*4 : 4*4;

		// Offset size must be more than the burst size
		Assert(oIeLcdc.m_uOffsetSz[eWin] == 0 || !(oIeLcdc.m_uOffsetSz[eWin]%4) );
		Assert(oIeLcdc.m_uPageWidth[eWin] > uBurstSize); // Page width must be more than burst size and be word-aligned
		Assert( !( (oIeLcdc.m_uPageWidth[eWin]+oIeLcdc.m_uOffsetSz[eWin])%8 ) );

		uLineVal = oIeLcdc.m_uViewVSz[eWin] - 1;
	}
	else
	{
		Assert(0);
	}
	
	oIeLcdc.m_uImgStAddr[eWin] = uFbAddr;

	oIeLcdc.m_uFbStAddr[eWin] = uFbAddr + (oIeLcdc.m_uFrmHSz[eWin]*uY_Frame + uX_Frame)*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;
	oIeLcdc.m_uFbEndAddr[eWin] = oIeLcdc.m_uFbStAddr[eWin] + (oIeLcdc.m_uOffsetSz[eWin]+oIeLcdc.m_uPageWidth[eWin])*(uFrameV);  // ref.VIDWxxADD1

//	if ( (bIsDoubleBuf == true) && ((eWin == WIN0) || (eWin == WIN1)) )
//   v6.0's all windows support double buffer
	if ( bIsDoubleBuf == true )
	{
		oIeLcdc.m_uDoubleBufImgStAddr[eWin] = oIeLcdc.m_uImgStAddr[eWin] + oIeLcdc.m_uFrmHSz[eWin]*oIeLcdc.m_uFrmVSz[eWin]*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;
		oIeLcdc.m_uDoubleBufStAddr[eWin] = oIeLcdc.m_uFbStAddr[eWin] + oIeLcdc.m_uFrmHSz[eWin]*oIeLcdc.m_uFrmVSz[eWin]*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;
		oIeLcdc.m_uDoubleBufEndAddr[eWin] = oIeLcdc.m_uDoubleBufStAddr[eWin] + (oIeLcdc.m_uOffsetSz[eWin]+oIeLcdc.m_uPageWidth[eWin])*(uFrameV);
	}
//	else if ( (bIsDoubleBuf == false) && ((eWin == WIN0) || (eWin == WIN1)) )
	else if ( bIsDoubleBuf == false )
	{
		oIeLcdc.m_uDoubleBufStAddr[eWin] = oIeLcdc.m_uFbStAddr[eWin];
		oIeLcdc.m_uDoubleBufEndAddr[eWin] = oIeLcdc.m_uFbEndAddr[eWin];
	}

	IELCDC_InitWinRegs(eWin);

	IELCDC_SetWinOnOff(1, eWin);	// Turn on window's ENWIN_F

}

void IELCDC_InitWinRegs(LCD_WINDOW eWin)
{
	u32 uWinConXReg;
	u32 uFrmBufStAddrReg;
	u32 uFrmBufEndAddrReg;
	u32 uOffsetPageWidthReg;
	u32 uOsdLeftPosReg;
	u32 uOsdRightPosReg;
	u32 uWinConXRegVal;
	u32 uAlphaRegH;
	u32 uAlpha0RegL;
	u32 uAlpha1RegL;
	u32 uLcdEndX, uLcdEndY;

	uWinConXReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	uFrmBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0:
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	uFrmBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B0 :
		(eWin == WIN1) ? VIDW01ADD1B0 :
		(eWin == WIN2) ? VIDW02ADD1B0 :
		(eWin == WIN3) ? VIDW03ADD1B0 : VIDW04ADD1B0;

	uOffsetPageWidthReg =
		(eWin == WIN0) ? VIDW00ADD2 :
		(eWin == WIN1) ? VIDW01ADD2 :
		(eWin == WIN2) ? VIDW02ADD2 :
		(eWin == WIN3) ? VIDW03ADD2 : VIDW04ADD2;

	uOsdLeftPosReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;

	uOsdRightPosReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	uWinConXRegVal = 0;
	
	if (eWin == WIN0)
	{
		if (!oIeLcdc.m_bFifoIn[0]) // Input path is DMA
		{
			uWinConXRegVal =
				PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
				oIeLcdc.m_uBytSwpMode | oIeLcdc.m_uHawSwpMode|oIeLcdc.m_uWordSwpMode|
				oIeLcdc.m_uMaxBurstLen |oIeLcdc.m_uBppMode | ENWIN_F_DISABLE;
			
		}
		
		else // Input path is Local
		
		{
			Assert(oIeLcdc.m_eLocalIn[0] == IN_POST);

			if(oIeLcdc.m_uLocalInColorSpace[0] == LOCAL_IF_YCBCR444)
			{
				uWinConXRegVal =
				PATH_LOCAL | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE | 
				HAWSWP_DISABLE | WRDSWP_DISABLE |IN_LOCAL_YUV |
				oIeLcdc.m_uMaxBurstLen | oIeLcdc.m_uBppMode | ENWIN_F_DISABLE;
			}
			else
			{
				uWinConXRegVal =
				PATH_LOCAL | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE | 
				HAWSWP_DISABLE | WRDSWP_DISABLE |IN_LOCAL_RGB |
				oIeLcdc.m_uMaxBurstLen | oIeLcdc.m_uBppMode | ENWIN_F_DISABLE;
			}
		}


		IeLcdcOutp32(VIDW00ADD0B1, oIeLcdc.m_uDoubleBufStAddr[0]);
		IeLcdcOutp32(VIDW00ADD1B1, oIeLcdc.m_uDoubleBufEndAddr[0]);
		IeLcdcOutp32(VIDOSD0C, OSDSIZE(oIeLcdc.m_uViewHSz[0]*oIeLcdc.m_uViewVSz[0]));

		// Set WIN0 alpha value
		IeLcdcOutp32(VIDW0ALPHA0, ALPHA0_R(0xFF) | ALPHA0_G(0xFF) | ALPHA0_B(0xFF));
		IeLcdcOutp32(VIDW0ALPHA1, ALPHA1_R(0xFF) | ALPHA1_G(0xFF) | ALPHA1_B(0xFF));
	}
	
	else //((eWin==WIN1)||(eWin==WIN2)||(eWin==WIN3)||(eWin==WIN4))
	{
		if (eWin == WIN1)
		{
			if (!oIeLcdc.m_bFifoIn[1]) // Input path is DMA
			{
				uWinConXRegVal =
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
					oIeLcdc.m_uBytSwpMode | oIeLcdc.m_uHawSwpMode|oIeLcdc.m_uWordSwpMode|
					oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE| oIeLcdc.m_uBppMode | 
					BLEND_ALPHA0_PLANE| ENWIN_F_DISABLE;
			}
			else // Input path is Local
			{
				Assert(oIeLcdc.m_eLocalIn[1] == IN_POST || oIeLcdc.m_eLocalIn[1] == IN_CIM);
				
				if(oIeLcdc.m_uLocalInColorSpace[1] == LOCAL_IF_YCBCR444)
				{
					uWinConXRegVal = PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
					HAWSWP_DISABLE |WRDSWP_DISABLE | IN_LOCAL_YUV |
					oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode |
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
				}
				else
				{	
					uWinConXRegVal = PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
					HAWSWP_DISABLE|WRDSWP_DISABLE| IN_LOCAL_RGB |
					oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode |
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;		
				}
			}
			
			// set double buf. addr. and offset size
			IeLcdcOutp32(VIDW01ADD0B1, oIeLcdc.m_uDoubleBufStAddr[1]);
			IeLcdcOutp32(VIDW01ADD1B1, oIeLcdc.m_uDoubleBufEndAddr[1]);

			IeLcdcOutp32(VIDOSD1D, OSDSIZE(oIeLcdc.m_uViewHSz[1]*oIeLcdc.m_uViewVSz[1]));					
		}
		
		else // eWin == WIN2 OR WIN3 OR WIN4
		{
			if (eWin == WIN2)
			{
				if (!oIeLcdc.m_bFifoIn[2]) // Input path is DMA
				{
					uWinConXRegVal =
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
						oIeLcdc.m_uBytSwpMode | oIeLcdc.m_uHawSwpMode|oIeLcdc.m_uWordSwpMode|
						oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode |
						BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
				}
				else // Input path is Local
				{
					Assert(oIeLcdc.m_eLocalIn[2] == IN_POST || oIeLcdc.m_eLocalIn[2] == IN_CIM);					
		
					if(oIeLcdc.m_uLocalInColorSpace[2] == LOCAL_IF_YCBCR444)
					{
						uWinConXRegVal = 
							PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
							HAWSWP_DISABLE |WRDSWP_DISABLE | IN_LOCAL_YUV |
							oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode |
							BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
					}
					else
					{
						uWinConXRegVal = 
							PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
							HAWSWP_DISABLE|WRDSWP_DISABLE| IN_LOCAL_RGB |
							oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode |
							BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;		
					}
				}

				// set double buf. addr. and offset size
				IeLcdcOutp32(VIDW02ADD0B1, oIeLcdc.m_uDoubleBufStAddr[2]);
				IeLcdcOutp32(VIDW02ADD1B1, oIeLcdc.m_uDoubleBufEndAddr[2]);

				IeLcdcOutp32(VIDOSD2D, OSDSIZE(oIeLcdc.m_uViewHSz[2]*oIeLcdc.m_uViewVSz[2]));				
			}
			else // eWin == WIN3 || eWin == WIN4
			{
				uWinConXRegVal = 
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE |					
					BITSWP_DISABLE | oIeLcdc.m_uBytSwpMode | oIeLcdc.m_uHawSwpMode |oIeLcdc.m_uWordSwpMode|
					oIeLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oIeLcdc.m_uBppMode | 
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
				
				if(eWin == WIN3)
				{
					IeLcdcOutp32(VIDW03ADD0B1, oIeLcdc.m_uDoubleBufStAddr[3]);
					IeLcdcOutp32(VIDW03ADD1B1, oIeLcdc.m_uDoubleBufEndAddr[3]);
				}
				else
				{
					IeLcdcOutp32(VIDW04ADD0B1, oIeLcdc.m_uDoubleBufStAddr[4]);
					IeLcdcOutp32(VIDW04ADD1B1, oIeLcdc.m_uDoubleBufEndAddr[4]);
				}
			}
		}

		// Set WIN1, WIN2, WIN3, WIN4 alpha Value
		uAlphaRegH =
			(eWin == WIN1) ? VIDOSD1C :
			(eWin == WIN2) ? VIDOSD2C :
			(eWin == WIN3) ? VIDOSD3C : VIDOSD4C;
		uAlpha0RegL = 
			(eWin == WIN1) ? VIDW1ALPHA0 :
			(eWin == WIN2) ? VIDW2ALPHA0 :
			(eWin == WIN3) ? VIDW3ALPHA0 : VIDW4ALPHA0;
		uAlpha1RegL = 
			(eWin == WIN1) ? VIDW1ALPHA1 :
			(eWin == WIN2) ? VIDW2ALPHA1 :
			(eWin == WIN3) ? VIDW3ALPHA1 : VIDW4ALPHA1;
		IeLcdcOutp32(uAlphaRegH,
			ALPHA0_R_H(0xF) | ALPHA0_G_H(0xF) | ALPHA0_B_H(0xF) |
			ALPHA1_R_H(0xF) | ALPHA1_G_H(0xF) | ALPHA1_B_H(0xF));
		IeLcdcOutp32(uAlpha0RegL, ALPHA0_R_L(0xF) | ALPHA0_G_L(0xF) | ALPHA0_B_L(0xF));
		IeLcdcOutp32(uAlpha1RegL, ALPHA1_R_L(0xF) | ALPHA1_G_L(0xF) | ALPHA1_B_L(0xF));
	}

	IeLcdcOutp32(uWinConXReg, uWinConXRegVal);		
	IeLcdcOutp32(uFrmBufStAddrReg, oIeLcdc.m_uFbStAddr[eWin]);
	IeLcdcOutp32(uFrmBufEndAddrReg, oIeLcdc.m_uFbEndAddr[eWin]);
	IeLcdcOutp32(uOffsetPageWidthReg, (oIeLcdc.m_uOffsetSz[eWin]<<13) | oIeLcdc.m_uPageWidth[eWin]);

	uLcdEndX = oIeLcdc.m_uLcdStX + oIeLcdc.m_uViewHSz[eWin] - 1;
	uLcdEndY = oIeLcdc.m_uLcdStY + oIeLcdc.m_uViewVSz[eWin] - 1;

	if (oIeLcdc.m_uScanMode == 1) // Interlace mode
	{
		Assert(!(oIeLcdc.m_uLcdStX%2)); // Left top Y coordinate must be even number in interlace mode
		Assert(uLcdEndY%2); // Rigth bottom  Y coordinate must be odd number in interlace mode

		// In interlace mode, Left Top Y(oIeLcdc.m_uLcdStY) and Right Bottom Y(uLcdEndY) must be divided by 2.
		// And, Right Bottom Y must be rounded down
		IeLcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(oIeLcdc.m_uLcdStX) | (OSD_LTY_F(oIeLcdc.m_uLcdStY)>>1));
		IeLcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uLcdEndX) | (OSD_RBY_F(uLcdEndY)>>1));
	}
	else // Progressive mode
	{
		IeLcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(oIeLcdc.m_uLcdStX) | OSD_LTY_F(oIeLcdc.m_uLcdStY));
		IeLcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uLcdEndX) | OSD_RBY_F(uLcdEndY));
	}
}


//---------------------------------------------------------
// Function Name : IELCDC_SetWinOnOff
// Function Description : This function turns Window On or Off
// Input : uOnOff : 0 = window off     1 = window on
//            eWin : WIN0~4 : Windows0 ~ Windows4 which to turn on or off
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IELCDC_SetWinOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uWinTemp;
	u32 uWinConReg;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	IeLcdcInp32(uWinConReg, uWinTemp);

	if (uOnOff) // Turn OSD on
	{
		uWinTemp |= ENWIN_F_ENABLE;
	}
	else // Turn OSD off
	{
		uWinTemp &= ~ENWIN_F_ENABLE;
	}

	IeLcdcOutp32(uWinConReg, uWinTemp);

}

// Set the View-Port's position of LCD
void IELCDC_SetViewPosOnLcd(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin) // For WIN0~4,
{
	u32 uDiv;
	u32 uX_Lcd1, uX_Lcd2, uY_Lcd2;
	u32 uTempLeftReg, uTempRightReg;

	Assert(eWin != WIN0);

	uDiv = oIeLcdc.m_uBytes/oIeLcdc.m_uBits;

	uTempLeftReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;


	uTempRightReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	if ((uX_Lcd+oIeLcdc.m_uViewHSz[eWin] < oIeLcdc.m_uLcdHSz+1) && (uY_Lcd+oIeLcdc.m_uViewVSz[eWin] < oIeLcdc.m_uLcdVSz+1))
	{
		uX_Lcd1 = (uX_Lcd/uDiv)*uDiv;

		uX_Lcd2 = uX_Lcd1 + oIeLcdc.m_uViewHSz[eWin] - 1;
		uY_Lcd2 = uY_Lcd + oIeLcdc.m_uViewVSz[eWin] - 1;

		IeLcdcOutp32( uTempLeftReg, OSD_LTX_F(uX_Lcd1) | OSD_LTY_F(uY_Lcd) );
		IeLcdcOutp32( uTempRightReg,OSD_RBX_F(uX_Lcd2) | OSD_RBY_F(uY_Lcd2) );
	}
}

// Set the View-Port's position of Frame
void IELCDC_SetViewPosOnFrame(u32 uX_Frame, u32 uY_Frame, LCD_WINDOW eWin) // For WIN0~4
{
	u32 uFbStAddrReg;

	uFbStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0 :
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	if ( (uX_Frame < oIeLcdc.m_uFrmHSz[eWin] - oIeLcdc.m_uLcdHSz + 1) && (uY_Frame < oIeLcdc.m_uFrmVSz[eWin] - oIeLcdc.m_uLcdVSz + 1) )
	{
		IeLcdcOutp32(uFbStAddrReg,
			oIeLcdc.m_uFbStAddr[eWin] + oIeLcdc.m_uFrmHSz[eWin]*uY_Frame*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits) + uX_Frame*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits));

		if (eWin == WIN0)
		{
			IeLcdcOutp32(VIDW00ADD0B1,
					oIeLcdc.m_uDoubleBufStAddr[0] + oIeLcdc.m_uFrmHSz[eWin]*uY_Frame*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits) + uX_Frame*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits));
		}
	}
}

// if uWhichAddr is 0, then Buffer 0 is selected
// else then Buffer 1 is selected

void IELCDC_GetDoubleBufAddr(u32* uFbAddr, u32 uWhichAddr, LCD_WINDOW eWin)
{
//	Assert (eWin == WIN0 || eWin == WIN1);
	Assert(oIeLcdc.m_uFbStAddr[eWin] != oIeLcdc.m_uDoubleBufStAddr[eWin]);

	*uFbAddr = (!uWhichAddr) ? oIeLcdc.m_uImgStAddr[eWin] : oIeLcdc.m_uDoubleBufImgStAddr[eWin];

}

void IELCDC_GetBufIdx(u32* uBufNum, LCD_WINDOW eWin)
{
	u32 uWinCtrlReg, uWinCtrlVal;
	u32 uTmpVal;

//	Assert (eWin == WIN0 || eWin == WIN1);

	uWinCtrlReg = (eWin == WIN0) ? WINCON0 :
		             (eWin == WIN1) ? WINCON1 :
				(eWin == WIN2) ? WINCON2 :
				(eWin == WIN3) ? WINCON3 : WINCON4 ;

	IeLcdcInp32(uWinCtrlReg, uWinCtrlVal);
	uTmpVal = (uWinCtrlVal&(0x1<<21));
	*uBufNum = (uTmpVal == (0x1<<21)) ? 1 : 0;
}

void IELCDC_GetClkValAndClkDir(u32 uLcdHSz, u32 uLcdVSz, u32* uClkVal, u32* uClkDir)
{
	double dTmpVal;
	u32 uTmpClkVal;
	u32 uTotalTime;
	u32 uIELCD_VCLK;
	double dFrmRate ;
	u32 uFrameRate = LCD_FRM_RATE;	

#if (LCD_MODEL == LCD_LTS222Q_RGB|| LCD_MODEL == LCD_LTS222Q_SRGB)
	uLcdHSz+= HBPD_LTS222Q +HFPD_LTS222Q +HSPW_LTS222Q +3;
	uLcdVSz+= VBPD_LTS222Q +VFPD_LTS222Q +VSPW_LTS222Q +3;

#elif (LCD_MODEL == LCD_LTV350QV_RGB)
	uLcdHSz+= HBPD_LTV350QV +HFPD_LTV350QV +HSPW_LTV350QV +3; 	// HSYNC period
	uLcdVSz+= VBPD_LTV350QV +VFPD_LTV350QV +VSPW_LTV350QV +3;		// VSYNC period

#elif (LCD_MODEL == LCD_LTS350Q1)
	uLcdHSz+= HBPD_240320 +HFPD_240320 +HSPW_240320 +3;
	uLcdVSz+= VBPD_240320 +VFPD_240320 +VSPW_240320 +3;

#elif (LCD_MODEL == LCD_LTP700WV_RGB  || LCD_MODEL == LCD_LTE480WV_RGB)
	uLcdHSz+= HBPD_LTP700WV + HFPD_LTP700WV + HSPW_LTP700WV +3;
	uLcdVSz+= VBPD_LTP700WV + VFPD_LTP700WV + VSPW_LTP700WV +3;

#elif (LCD_MODEL == LCD_TL2796)
	uLcdHSz+= HBPD_TL2796 + HFPD_TL2796 + HSPW_TL2796 +3;
	uLcdVSz+= VBPD_TL2796 + VFPD_TL2796 + VSPW_TL2796 +3;



#endif
	
	uTotalTime =
#if (LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL==LCD_S6D0139_CPU) 
	WR_ACT_TIME + WR_HOLD_TIME;
#else
	1;
#endif


	if(LCD_VCLKSRC == LCD_HCLK)
	{
		uIELCD_VCLK = g_uHclkDsys;
	}
	else
	{
		uIELCD_VCLK = g_uHclkDsys;		// need to be defined later (09.07.14 by WJ.KIM)
	}
	

	dTmpVal = (double)(uIELCD_VCLK)/(uTotalTime*uLcdHSz*uLcdVSz*uFrameRate) - 1;

	*uClkVal = (int)(dTmpVal+0.5);
	*uClkDir = (*uClkVal<1) ? 0 : 1;
	uTmpClkVal = *uClkVal;
	
#ifdef DBG_LCDC
	dFrmRate = (double)((u32)(uIELCD_VCLK))/((uTmpClkVal+1)*uLcdHSz*uLcdVSz);
	Dbg("Frame Rate: %f\t ClkVal: %d\n", dFrmRate, (int)dTmpVal);
#endif

}

//---------------------------------------------------------
// Function Name :IELCDC_WTrigger
// Function Description : This function changes(triggers) windows' frame buffer
// Input : eWin ; WINDOW number to trigger
// Output : none
// Version :v0.1
//---------------------------------------------------------
void IELCDC_WTrigger(LCD_WINDOW eWin)
{
	u32 uTrigCtrl;
	
	IeLcdcInp32(TRIGCON, uTrigCtrl);
	
	if (oIeLcdc.m_bAutoBuf == true)
	{
		switch(eWin)
			{
			case WIN0 :
				IeLcdcOutp32(TRIGCON, uTrigCtrl | W0_SW_TRIG_MODE | W0_SW_TRIGGER);				
				break;

			case WIN1 :
				IeLcdcOutp32(TRIGCON, uTrigCtrl | W1_SW_TRIG_MODE | W1_SW_TRIGGER);				
				break;

			case WIN2 :
				IeLcdcOutp32(TRIGCON, uTrigCtrl | W2_SW_TRIG_MODE | W2_SW_TRIGGER);				
				break;

			case WIN3 :
				IeLcdcOutp32(TRIGCON, uTrigCtrl | W3_SW_TRIG_MODE | W3_SW_TRIGGER);				
				break;

			case WIN4 :
				IeLcdcOutp32(TRIGCON, uTrigCtrl | W4_SW_TRIG_MODE | W4_SW_TRIGGER);				
				break;

			}

	}
	else
	{
#if ((LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_S6D0139_CPU))
		IeLcdcOutp32(TRIGCON, uTrigCtrl | I80_SW_TRIG_MODE | I80_SW_TRIGGER);
#endif
	}
}



// CPU Interface
void IELCDC_Trigger(void)
{
	u32 uTrigCtrl;
	
	IeLcdcInp32(TRIGCON, uTrigCtrl);
	
	if (oIeLcdc.m_bAutoBuf == true)
	{
		IeLcdcOutp32(TRIGCON, uTrigCtrl | SW_TRIG_MODE | SW_TRIGGER);
	}
	else
	{
#if ((LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_S6D0139_CPU))
		IeLcdcOutp32(TRIGCON, uTrigCtrl | SW_TRIG_MODE | SW_TRIGGER);
#endif
	}
}

// if uScanMode is 0, progressive mode
// else interlace mode
void IELCDC_SetScanMode(SCAN_MODE eScanMode)
{
	u32 uVidConRegVal;

	oIeLcdc.m_uScanMode = (eScanMode == PROGRESSIVE) ? 0 : 1;

	IeLcdcInp32(VIDCON0, uVidConRegVal);
	uVidConRegVal &= ~(1<<29);
	IeLcdcOutp32(VIDCON0, (uVidConRegVal | oIeLcdc.m_uScanMode<<29));
}

void IELCDC_SetOutputPath(LCD_LOCAL_OUTPUT eOutLocal)
{
	u32 uVidConRegVal;
	u32 uPathVal;
	
	// if output mode is LCD mode, Scan mode always should be progressive mode
	if (eOutLocal != LCD_TV)
	{
		IELCDC_SetScanMode(PROGRESSIVE);
	}

	uPathVal = 
		(eOutLocal == LCD_RGB) ? VIDOUT_RGBIF :
		(eOutLocal == LCD_TV) ? VIDOUT_TV :			
		(eOutLocal == LCD_I80F) ? VIDOUT_I80IF0 :
		(eOutLocal == LCD_I80S) ? VIDOUT_I80IF1 :
		(eOutLocal == LCD_TVRGB) ? VIDOUT_TVNRGBIF :
		(eOutLocal == LCD_TVI80F) ? VIDOUT_TVNI80IF0 : VIDOUT_TVNI80IF1;

	IeLcdcInp32(VIDCON0, uVidConRegVal);
	uVidConRegVal &= ~(0x7<<26); // masking [28:26]
	uVidConRegVal |= uPathVal;
	IeLcdcOutp32(VIDCON0, uVidConRegVal);
//	IELCDC_SetClkVal(0);
}



void IELCDC_SetDualDisplay(LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual,LCD_DUAL_VDEN_EN eSelVden)
{
	u32 uDualSelReg;
	u32 uDualSel;
	u32 uHorVerSel;
	u32 uDualCount;
	u32 uVdenEn;


#if (LCD_MODEL == LCD_LTV350QV_RGB)
	if(eSelMethod == FRAME_SPLIT)
		{
	uDualCount = 240;
	uHorVerSel = DUAL_FRAMESPLIT;
		}
	else
		{
	uDualCount = 320;
	uHorVerSel = DUAL_LINESPLIT;

		}
//	oLcdc.m_uLcdHSz = 320;
//	oLcdc.m_uLcdVSz = 240;

#elif (( LCD_MODEL == LCD_LTS350Q1 )|| (LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_S6D0139_CPU) || (LCD_MODEL == LCD_LTS222Q_RGB) || (LCD_MODEL == LCD_LTS222Q_SRGB))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
	

//	oLcdc.m_uLcdHSz = 240;
//	oLcdc.m_uLcdVSz = 320;
	
//	oLcdc.m_uLcdHSz = 320;
//	oLcdc.m_uLcdVSz = 480;

#elif ((LCD_MODEL == LCD_LTE480WV_RGB)||(LCD_MODEL == LCD_LTP700WV_RGB ))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 480;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 800;
		uHorVerSel = DUAL_LINESPLIT;
	}

//	oLcdc.m_uLcdHSz = 800;
//	oLcdc.m_uLcdVSz = 480;



#elif (LCD_MODEL == LTM030DK)
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}

#elif (LCD_MODEL == LCD_TL2796)
	
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}

//	oLcdc.m_uLcdHSz = 480;
//	oLcdc.m_uLcdVSz = 800;

#else
	Assert(0);
#endif

	uDualSel = 
		( eSelDual == FIMD_SINGLE ) ? DUAL_DIS :
		( eSelDual == FIMD_DUAL )	? DUAL_FIMD :
		( eSelDual == MIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MIE_DUAL )	? DUAL_MIE :
		( eSelDual == MDNIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MDNIE_DUAL )? DUAL_MDNIE :
			Assert(0);


	uVdenEn =
		( eSelVden == VDEN_DIS) ? DUAL_VDEN_DIS :
		( eSelVden == VDEN_EN) ? DUAL_VDEN_EN :
			Assert(0);					

	IeLcdcInp32(DUALCON,uDualSelReg);
/*
	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUALCOUNT(uDualCount) | (0x1<<3) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}
*/
	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUAL_MAINCOUNT(uDualCount +2)|uVdenEn|DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |uVdenEn| DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}

	IeLcdcOutp32(DUALCON,uDualSelReg);
	
/*


#if (LCD_MODEL == LCD_LTV350QV_RGB)
	if(eSelMethod == FRAME_SPLIT)
		{
	uDualCount = 240;
	uHorVerSel = DUAL_FRAMESPLIT;
		}
	else
		{
	uDualCount = 320;
	uHorVerSel = DUAL_LINESPLIT;

		}
//	oIeLcdc.m_uLcdHSz = 320;
//	oIeLcdc.m_uLcdVSz = 240;

#elif (( LCD_MODEL == LCD_LTS350Q1 )|| (LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_S6D0139_CPU) || (LCD_MODEL == LCD_LTS222Q_RGB) || (LCD_MODEL == LCD_LTS222Q_SRGB))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
	


#elif ((LCD_MODEL == LCD_LTE480WV_RGB)||(LCD_MODEL == LCD_LTP700WV_RGB ))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 480;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 800;
		uHorVerSel = DUAL_LINESPLIT;
	}

//	oIeLcdc.m_uLcdHSz = 800;
//	oIeLcdc.m_uLcdVSz = 480;



#elif (LCD_MODEL == LTM030DK)
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}

//	oIeLcdc.m_uLcdHSz = 480;
//	oIeLcdc.m_uLcdVSz = 800;


#elif (LCD_MODEL == LCD_TL2796)
	
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}


#else
	Assert(0);
#endif

	uDualSel = 
		( eEnDual == DUAL_DIS ) ? MIEDUAL_DIS :
		( eEnDual == DUAL_EN ) ? MIEDUAL_ENABLE : Assert(0);


	uVdenEn =
		( eSelVden == VDEN_DIS) ? DUAL_VDEN_DIS :
		( eSelVden == VDEN_EN) ? DUAL_VDEN_EN :
			Assert(0);					

	IeLcdcInp32(DUALCON,uDualSelReg);

	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUAL_MAINCOUNT(uDualCount +2)|uVdenEn|DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |uVdenEn| DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}


	IeLcdcOutp32(DUALCON,uDualSelReg);
	*/
}


void IELCDC_SetClkVal(u8 uClkVal)
{
	u32 uVidConRegVal;

	uClkVal &= 0xff;

	IeLcdcInp32(VIDCON0, uVidConRegVal);
	if ( uClkVal > 0 )
	{
		uVidConRegVal &= ~(0x1<<4);
		IeLcdcOutp32(VIDCON0, uVidConRegVal | (1<<4));
	}
	else if ( uClkVal == 0 )
	{
		uVidConRegVal &= ~(0x1<<4);
		IeLcdcOutp32(VIDCON0, uVidConRegVal | (0<<4));
	}
	
	uVidConRegVal &= ~(0xff<<6);
	IeLcdcOutp32(VIDCON0, uVidConRegVal | (uClkVal<<6));

	
}

void IELCDC_SetColorMapOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uWinMapReg, uWinMapVal;

	uWinMapReg =
		(eWin == WIN0) ? WIN0MAP :
		(eWin == WIN1) ? WIN1MAP :
		(eWin == WIN2) ? WIN2MAP :
		(eWin == WIN3) ? WIN3MAP : WIN4MAP;

	// Color Map is activated when next frame is run or ENVID_F is '0' and positive edge
	IeLcdcInp32(uWinMapReg, uWinMapVal);

	if (uOnOff)
	{
		IeLcdcOutp32(uWinMapReg, COLOR_MAP_ENABLE|uWinMapVal);
	}
	else
	{
		IeLcdcOutp32(uWinMapReg, ~COLOR_MAP_ENABLE&uWinMapVal);
	}

}

// Modified IELCDC_SetColorKey func.
void IELCDC_SetColorKeyOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uColorKeyReg, uColorKeyVal;

	Assert(eWin != WIN0);

	uColorKeyReg =
		(eWin == WIN1) ? W1KEYCON0 :
		(eWin == WIN2) ? W2KEYCON0 :
		(eWin == WIN3) ? W3KEYCON0 : W4KEYCON0;

	IeLcdcInp32(uColorKeyReg, uColorKeyVal);

	if (uOnOff) // Turn Color Key On
	{
		IeLcdcOutp32(uColorKeyReg, uColorKeyVal | KEYEN_F_ENABLE);
	}
	else
	{
		IeLcdcOutp32(uColorKeyReg, uColorKeyVal & KEYBLEN_F_DISABLE & KEYEN_F_DISABLE);
	}

}


// select RGB sequence
void IELCDC_SetRgbFormat(PNR_MODE uPnr)
{
	u32 uVidConVal;
	u32 uStatus, uPnrMode;

	IeLcdcInp32(VIDCON0, uVidConVal);
	uStatus = uVidConVal&(0X3<<26); // Get VIDOUT [28:26]

	if ( (uStatus == VIDOUT_RGBIF) || (uStatus == VIDOUT_TVNRGBIF) )
	{
		uPnrMode =
			(uPnr == RGB_P) ? PNRMODE_RGB_P :
			(uPnr == BGR_P) ? PNRMODE_BGR_P :
			(uPnr == RGB_S) ? PNRMODE_RGB_S : PNRMODE_BGR_S;
	}
	else if ( (uStatus == VIDOUT_I80IF0) || (uStatus == VIDOUT_I80IF1) ||
		(uStatus == VIDOUT_TVNI80IF0) || (uStatus == VIDOUT_TVNI80IF1) )
	{
		uPnrMode = PNRMODE_RGB_P;
	}
	else
	{
		Assert(0);
	}

	IeLcdcOutp32(VIDCON0, uVidConVal & ~PNRMODE_MASK | uPnrMode);
}

void IELCDC_SetByteSwap(SWAP_MODE eBitSwap, SWAP_MODE eByteSwap, SWAP_MODE eHawSwap, SWAP_MODE eWordSwap, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal;
	u32 uBitTemp, uByteTemp, uHalfTemp, uWordTemp;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	uBitTemp = (eBitSwap == SWAP_BIT_ENABLE) ? 1 : 0;
	uByteTemp = (eByteSwap == SWAP_BYTE_ENABLE) ? 1 : 0;
	uHalfTemp = (eHawSwap == SWAP_HALFWORD_ENABLE) ? 1 : 0;
	uWordTemp = (eWordSwap == SWAP_WORD_ENABLE) ? 1 : 0;

	IeLcdcInp32(uWinConReg, uWinConVal);
	IeLcdcOutp32(uWinConReg, uWinConVal&~(0xf<<15)|(uBitTemp<<18)|(uByteTemp<<17)|(uHalfTemp<<16)|(uWordTemp<<15));
}

void IELCDC_SetCpuIfDataFormat(CPUIF_LDI eLdiMode, CPUIF_DATA_FORMAT eFormat)
{
	u32 uVidConVal;
	u32 uLdi, uFormat;

	IeLcdcInp32(VIDCON0, uVidConVal);

	uLdi = (eLdiMode == MAIN) ? VIDOUT_I80IF0: VIDOUT_I80IF1;
	uVidConVal = (uVidConVal & LCD_OUT_MASKING) | uLdi;

	if (eLdiMode == MAIN)
	{
		uFormat =
			(eFormat == D16BIT) ? MAIN_16_MODE :
			(eFormat == D16PLUS2BIT) ? MAIN_16PLUS2_MODE :
			(eFormat == D9PLUS9BIT) ? MAIN_9PLUS9_MODE :
			(eFormat == D16PLUS8BIT) ? MAIN_16PLUS8_MODE : MAIN_18_MODE;

		uVidConVal = (uVidConVal & MAIN_DATA_MASKING) | uFormat;
	}
	else //ldiMode == SUB
	{
		uFormat =
			(eFormat == D16BIT) ? SUB_16_MODE :
			(eFormat == D16PLUS2BIT) ? SUB_16PLUS2_MODE :
			(eFormat == D9PLUS9BIT) ? SUB_9PLUS9_MODE :
			(eFormat == D16PLUS8BIT) ? SUB_16PLUS8_MODE : SUB_18_MODE;

		uVidConVal = (uVidConVal & SUB_DATA_MASKING) | uFormat;
	}

	IeLcdcOutp32(VIDCON0, uVidConVal);
}

void IELCDC_SetTriggerMode(TRIGGER_MODE eTrig)
{
	u32 uTrigConVal, uTrigVal;

	uTrigVal = (eTrig == SW_TRIG) ? 1 : 0;
	uTrigVal |= (eTrig == SW_TRIG) ? 0x0<<0 : 0x3<<3;

	IeLcdcInp32(TRIGCON, uTrigConVal);
	uTrigConVal &= ~(0x1<<0); // Mask Trigger mode
	uTrigConVal &= ~(0x3<<3); // Mask H/W IELCDC_Trigger Mask and H/W Trigger Enable bit
	IeLcdcOutp32(TRIGCON, uTrigConVal|uTrigVal);
}

void IELCDC_SetCpuIfTiming(u8 ucWrActTime, u8 ucWrHoldTime, CPUIF_LDI eLdi)
{
	u32 uCpuIfTimeReg, uCpuIfTimeVal;


	Outp32(0xe0200120,0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x33333333);	//set GPF1 as SYS_VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x33333333);	//set GPF2 as SYS_VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00303333);	//set GPF4 as SYS_VD[23:20], SYS_OEn
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set TOUT3 as Output signal for PWRRESET
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High

	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(33);


	uCpuIfTimeReg = (eLdi == MAIN) ? I80IFCONA0 : I80IFCONA1;

	IeLcdcInp32(uCpuIfTimeReg, uCpuIfTimeVal);
	uCpuIfTimeVal =
		LCD_CS_SETUP((u32)0) |
		LCD_WR_SETUP((u32)0) |
		LCD_WR_ACT((u32)ucWrActTime) |
		LCD_WR_HOLD((u32)ucWrHoldTime) |
		RSPOL_HIGH |I80IFEN_ENABLE;
		//RSPOL_HIGH | (1<<1) | I80IFEN_ENABLE;
	IeLcdcOutp32(uCpuIfTimeReg, uCpuIfTimeVal);

}

void IELCDC_DisplayPartialArea(
	u32 uSrcStX, u32 uSrcStY, u32 uDstStX, u32 uDstStY,
	u32 uPartialHSz, u32 uPartialVsz, u32 uSrcFbStAddr,
	LCD_WINDOW eWin)
{
	u32 uSrcEndX, uSrcEndY;
	u32 uOffsetSz, uPageWidth;

	u32 uFrmBufStAddrReg, uFrmBufEndAddrReg;
	u32 uOffsetPageWidthReg;
	u32 uOsdLeftPosReg, uOsdRightPosReg;

	u32 uFbEndAddr;

	u32 uCmdVal[6];
	u32 uLdiStYReg1, uLdiStYReg2;
	u32 uStYQutotient, uStYRemainder;
	u32 uLdiEndX, uLdiEndY;
	u32 uLdiEndYReg1, uLdiEndYReg2;
	u32 uEndYQutotient, uEndYRemainder;

	uSrcEndX = uSrcStX + uPartialHSz - 1;
	uSrcEndY = uSrcStY + uPartialVsz - 1;

	uFrmBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0:
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	uFrmBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B0 :
		(eWin == WIN1) ? VIDW01ADD1B0 :
		(eWin == WIN2) ? VIDW02ADD1B0 :
		(eWin == WIN3) ? VIDW03ADD1B0 : VIDW04ADD1B0;

	uOffsetPageWidthReg =
		(eWin == WIN0) ? VIDW00ADD2 :
		(eWin == WIN1) ? VIDW01ADD2 :
		(eWin == WIN2) ? VIDW02ADD2 :
		(eWin == WIN3) ? VIDW03ADD2 : VIDW04ADD2;

	uOsdLeftPosReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;

	uOsdRightPosReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	uFbEndAddr = uSrcFbStAddr + uPartialHSz*uPartialVsz*oIeLcdc.m_uBytes/oIeLcdc.m_uBits;

	uOffsetSz = (oIeLcdc.m_uFrmHSz[eWin] - uPartialHSz)*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits);
	uPageWidth = uPartialHSz*(oIeLcdc.m_uBytes/oIeLcdc.m_uBits);

	/////////////////////////////////////////////////////////
	// Set LCD Controller's SFR                            //
	/////////////////////////////////////////////////////////

	// Set display size
	IeLcdcOutp32(VIDTCON2, LINEVAL(uPartialVsz-1) | HOZVAL(uPartialHSz-1));

	// Set start/ end addr. of frame buffer
	IeLcdcOutp32(uFrmBufStAddrReg, uSrcFbStAddr);
	IeLcdcOutp32(uFrmBufEndAddrReg, uFbEndAddr);

	// Set page width and offset size
	IeLcdcOutp32(uOffsetPageWidthReg, (oIeLcdc.m_uOffsetSz[eWin]<<13) | oIeLcdc.m_uPageWidth[eWin]);

	// Set window's left top and right down (X, Y) coordinate
	IeLcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(uSrcStX) | OSD_LTY_F(uSrcStY));
	IeLcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uSrcEndX) | OSD_RBY_F(uSrcEndY));

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU) 	
	Assert(0);

#elif ( LCD_MODEL==LCD_LTS222Q_CPU  ) 
	Assert( (uDstStX == 0) && (uPartialHSz == 240) );
	
	uStYQutotient = uDstStY/0xff;
	uStYRemainder = uDstStY%0xff;
	uCmdVal[0] = 0x4200 + uDstStX;
	uCmdVal[1] = 0x4300 + uStYQutotient;
	uCmdVal[2] = 0x4400 + uStYRemainder;
	uLdiEndX = uDstStX + uPartialHSz - 1;
	uLdiEndY = uDstStY + uPartialVsz - 1;
	uEndYQutotient = uLdiEndY/0xff;
	uEndYRemainder = uLdiEndY%0xff;
	
	IELCDC_PutCmdToLdi(uCmdVal, 3, MAIN, LCD_NORMAL_CMD);
		
#else
	Assert(0);
#endif

}

void IELCDC_ClearPending(u32 uIntFlag)
{	
	IeLcdcOutp32(VIDINTCON1, uIntFlag);	
}

void IELCDC_GetIntFlag(u32* pFlag)
{
	IeLcdcInp32(VIDINTCON1, *pFlag);
}

bool IELCDC_IsFrameDone(void)
{
	u32 uTrigConVal;

	IeLcdcInp32(TRIGCON, uTrigConVal);

	// IELCDC_IsFrameDone Function is valid only when TRGMODE[0] is set to 1
	Assert( (uTrigConVal&(0x1<<0)) == (0x1<<0) );

	return ( ((uTrigConVal&(0x1<<2)) == (0x1<<2)) ? true : false );
}

void IELCDC_SetFrameSkipRate(CPU_FRAME_SKIP eFrmSkip, CPUIF_LDI eLdi)
{
	u32 uSkipVal;
	u32 uI80IfConReg, uI80IfConRegVal;

	// SKIP_PER_TWO_FRM : display one frame per two frame
	// SKIP_PER_THREE_FRM : display one frame per three frame
	uSkipVal =
		(eFrmSkip == NO_SKIP) ? (0x0<<5) :
		(eFrmSkip == SKIP_PER_TWO_FRM) ? (0x1<<5) : (0x2<<5);

	uI80IfConReg = (eLdi == MAIN) ? I80IFCONB0 : I80IFCONB1;

	IeLcdcInp32(uI80IfConReg, uI80IfConRegVal);
	uI80IfConRegVal &= ~(0x3<<5);
	uI80IfConRegVal |= uSkipVal;
	IeLcdcOutp32(uI80IfConReg, uI80IfConRegVal);
}

void IELCDC_SetAutoCmdRate(CPU_AUTO_CMD_RATE eCmdRate, CPUIF_LDI eLdi)
{
	u32 uCmdRateVal;
	u32 uI80IfConReg, uI80IfConRegVal;

	uI80IfConReg = (eLdi == MAIN) ? I80IFCONB0 : I80IFCONB1;

	uCmdRateVal =
		(eCmdRate == DISABLE_AUTO_FRM) ? (0x0<<0) :
		(eCmdRate == PER_TWO_FRM) ? (0x1<<0) :
		(eCmdRate == PER_FOUR_FRM) ? (0x2<<0) :
		(eCmdRate == PER_SIX_FRM) ? (0x3<<0) :
		(eCmdRate == PER_EIGHT_FRM) ? (0x4<<0) :
		(eCmdRate == PER_TEN_FRM) ? (0x5<<0) :
		(eCmdRate == PER_TWELVE_FRM) ? (0x6<<0) :
		(eCmdRate == PER_FOURTEEN_FRM) ? (0x7<<0) :
		(eCmdRate == PER_SIXTEEN_FRM) ? (0x8<<0) :
		(eCmdRate == PER_EIGHTEEN_FRM) ? (0x9<<0) :
		(eCmdRate == PER_TWENTY_FRM) ? (0xa<<0) :
		(eCmdRate == PER_TWENTY_TWO_FRM) ? (0xb<<0) :
		(eCmdRate == PER_TWENTY_FOUR_FRM) ? (0xc<<0) :
		(eCmdRate == PER_TWENTY_SIX_FRM) ? (0xd<<0) :
		(eCmdRate == PER_TWENTY_EIGHT_FRM) ? (0xe<<0) : (0xf<<0);

	IeLcdcInp32(uI80IfConReg, uI80IfConRegVal);
	uI80IfConRegVal &= ~(0xf<<0);
	uI80IfConRegVal |= uCmdRateVal;
	IeLcdcOutp32(uI80IfConReg, uI80IfConRegVal);

}


//-----------------------------------------------------------------------------
// Function Name : IELCDC_InitLdi
// Function Description : This function inits LDI case by defined LCD_MODEL
//					   Therefore, LCD_MODEL should be defined before to use this function
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void IELCDC_InitGpioMux(CPUIF_LDI eLdiMode)
{

#if (LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI || LCD_MODEL == LCD_LTS350Q1 || LCD_MODEL==LCD_LTE480WV_RGB || LCD_LTV350QV_RGB)


	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(3);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(1);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)

	
	/*
	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00002222);	//set GPF3 as VD[23:20]
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x3000);	//set GPD0's TOUT3 as PWM_MIE signal
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High


	
	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);
	*/
	
#elif (LCD_MODEL == LCD_LTS222Q_CPU|| LCD_MODEL == LCD_S6D0139_CPU || LCD_MODEL == LCD_HD)

#else
	Assert(0);
#endif

	
}




//-----------------------------------------------------------------------------
// Function Name : IELCDC_InitLdi
// Function Description : This function inits LDI case by defined LCD_MODEL
//					   Therefore, LCD_MODEL should be defined before to use this function
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void IELCDC_InitLdi(CPUIF_LDI eLdiMode)
{
	
	IELCDC_InitGpioMux(eLdiMode);


#if (LCD_MODEL==LCD_LTV350QV_RGB)
	IELCDC_InitLtv350QVForRgbif();

#elif (LCD_MODEL == LCD_LTS222Q_CPU)
	IELCDC_SetCpuIfTiming(WR_ACT_TIME, WR_HOLD_TIME, MAIN);
	IELCDC_SetAutoCmdRate(PER_TWO_FRM, MAIN);	
	
	// In CPU I/F Normal, VIDOUT is determined and LCD is turned on
	// before RS, Enable and Normal Start bits are set
	IeLcdcOutp32(VIDCON0, (eLdiMode == MAIN) ? VIDOUT_I80IF0 : VIDOUT_I80IF1);
	IELCDC_Start();
	IELCDC_InitLts222QForI80if(eLdiMode);
	IELCDC_InitStartPosOnLcd(eLdiMode);		
#elif (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI)
	IELCDC_InitLts222QForRgbif();
	IELCDC_InitStartPosOnLcd(MAIN);	
#elif (LCD_MODEL == LCD_S6D0139_CPU)
	IELCDC_SetCpuIfTiming(WR_ACT_TIME, WR_HOLD_TIME, MAIN);
	IELCDC_SetAutoCmdRate(PER_TWO_FRM, MAIN);	
	IELCDC_InitS6D0139ForI80if(eLdiMode);
#elif (LCD_MODEL == LCD_LTS350Q1 || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL == LCD_HD)
	// Do nothing.
#else
	Assert(0);
#endif

}

void IELCDC_InitStartPosOnLcd(CPUIF_LDI eLdiMode)
{
	u32 uVal[3];

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI)
	// start addr setting
	IELCDC_WriteCmd(0x44, 0x00);		// y addr 2
	IELCDC_WriteCmd(0x42, 0x00);		// x addr
	IELCDC_WriteCmd(0x43, 0x00);		// y addr 1
#elif (LCD_MODEL == LCD_LTS222Q_CPU|| LCD_MODEL == LCD_S6D0139_CPU)
	// Auto cmd. mode in CPU(i80) I/F
	uVal[0] = 0x4400;
	uVal[1] = 0x4200;
	uVal[2] = 0x4300;
	IELCDC_PutCmdToLdi(uVal, 3, eLdiMode, LCD_AUTO_CMD);
#elif (LCD_MODEL == LCD_LTS350Q1 || LCD_MODEL==LCD_LTE480WV_RGB)
	return;
#else
	Assert(0);
#endif
}

#ifdef LDI_INIT_GPIO

void IELCDC_WriteCmd(u32 uAddr, u32 uData)
{
	u32 uTemp;

	IELCDC_SetRsOnOff(0);		// RS signal low	
	IELCDC_SetnWE(0);			// WE enable

	LCDC_SetGPIODataForLts222QLdi(uAddr);
	LCDC_SetGPIODataForLts222QLdi(uData);
}



void Write_IELDI_LTV350(u32 uAddr, u32 uData)
{
 	u8	dev_id_code=0x1D;
    	s8  	j;
	u8	DELAY=50;
		
	LCD_DEN_Hi; 		//	EN = High					CS high
	LCD_DCLK_Hi;							//	SCL High
	LCD_DSERI_Hi;							//	Data Low

	Delay(1);

	LCD_DEN_Lo; 		//	EN = Low				CS Low
	Delay(1);
	
	for (j = 5; j >= 0; j--)
	{	
		LCD_DCLK_Lo;							//	SCL Low

		if ((dev_id_code >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCD_DSERI_Hi;		
		}
		else
		{
			LCD_DSERI_Lo;
		}

		Delay(1);

		LCD_DCLK_Hi;			// CLOCK = High
		Delay(1);

	}
	
	// RS = "0" : index uData
	LCD_DCLK_Lo;			// CLOCK = Low
	LCD_DSERI_Lo;		// RS = 0
	Delay(1);
	LCD_DCLK_Hi;			// CLOCK = High
	Delay(1);

	// Write (Low)
	LCD_DCLK_Lo;			// CLOCK = Low
	LCD_DSERI_Lo;		// Write
	Delay(1);
	LCD_DCLK_Hi;			// CLOCK = High
	Delay(1);

	for (j = 15; j >= 0; j--)
	{
		LCD_DCLK_Lo;							//	SCL Low

		if ((uAddr >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCD_DSERI_Hi;		
		}
		else
		{
			LCD_DSERI_Lo;
		}

		Delay(1);

		LCD_DCLK_Hi;			// CLOCK = High
		Delay(1);

	}
	LCD_DSERI_Hi;
	Delay(1);
	
	LCD_DEN_Hi; 				// EN = High
	Delay(5*1);

	LCD_DEN_Lo; 		//	EN = Low				CS Low
	Delay(1);
	
	for (j = 5; j >= 0; j--)
	{	
		LCD_DCLK_Lo;							//	SCL Low

		if ((dev_id_code >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCD_DSERI_Hi;		
		}
		else
		{
			LCD_DSERI_Lo;
		}

		Delay(1);

		LCD_DCLK_Hi;			// CLOCK = High
		Delay(1);

	}
	
	// RS = "1" instruction uData
	LCD_DCLK_Lo;			// CLOCK = Low
	LCD_DSERI_Hi;		// RS = 1
	Delay(1);
	LCD_DCLK_Hi;			// CLOCK = High
	Delay(1);

	// Write
	LCD_DCLK_Lo;			// CLOCK = Low
	LCD_DSERI_Lo;		// Write
	Delay(1);
	LCD_DCLK_Hi;			// CLOCK = High
	Delay(1);

	for (j = 15; j >= 0; j--)
	{
		LCD_DCLK_Lo;							//	SCL Low

		if ((uData >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCD_DSERI_Hi;		
		}
		else
		{
			LCD_DSERI_Lo;
		}

		Delay(1);

		LCD_DCLK_Hi;			// CLOCK = High
		Delay(1);

	}

	LCD_DSERI_Hi;
	LCD_DEN_Hi; 				// EN = High
	Delay(1);

}




#define LTV350	1

void IELCDC_InitLtv350QVForRgbif(void)
{	

/*
	// LCD module reset
	rGPBDAT |= (1<<1);
	rGPBDAT &= ~(1<<1); // goes to LOW
	// delay about 5ms
	delayLoop(LCD_DELAY_1MS*10);	
	rGPBDAT |= (1<<1);  // goes to HIGH

	//debug_continue = TRUE;
	debug_continue = FALSE;
*/

/*


	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00002222);	//set GPF4 as VD[23:20]
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set TOUT3 as Output signal for PWRRESET
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High

	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);
*/
	
/*
	Outp32(0xe0200040,0x11110100);	//set spi1 signal as output signal, SPI0MISO as output signal(for RESET (fit1 bug))
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);

	// Reset
	Outp32(0xe0200044,0x4);			// Reset High
	Delay(3);
	Outp32(0xe0200044,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe0200044,0x4);			// Reset High
*/
	

	
/*
	// pull-up pull-down disable
	rGPLUDP &= ~(((3<<(LCD_DEN_BIT*2))) | ((3<<(LCD_DCLK_BIT*2))) | ((3<<(LCD_DSERI_BIT*2))));	
	rGPLUDP |= (((2<<(LCD_DEN_BIT*2))) | ((2<<(LCD_DCLK_BIT*2))) | ((2<<(LCD_DSERI_BIT*2))));
	
	// delay about 5ms
	delayLoop(LCD_DELAY_1MS*10);	
*/

	LCD_DEN_Hi;
	LCD_DCLK_Hi;
	LCD_DSERI_Hi;	

	///////////////////////////////////////////////////////////////////
	// Init_Lcd_Function
	//////////////////////////////////////////////////////////////////
#if LTV350
	Write_IELDI_LTV350(0x01,0x001d);	
	Write_IELDI_LTV350(0x02,0x0000);    
    Write_IELDI_LTV350(0x03,0x0000);    
    Write_IELDI_LTV350(0x04,0x0000);
    Write_IELDI_LTV350(0x05,0x50a3);
    Write_IELDI_LTV350(0x06,0x0000);
    Write_IELDI_LTV350(0x07,0x0000);
    Write_IELDI_LTV350(0x08,0x0000);
   	Write_IELDI_LTV350(0x09,0x0000);
   	Write_IELDI_LTV350(0x0a,0x0000);
   	Write_IELDI_LTV350(0x10,0x0000);
   	Write_IELDI_LTV350(0x11,0x0000);
   	Write_IELDI_LTV350(0x12,0x0000);
   	Write_IELDI_LTV350(0x13,0x0000);
   	Write_IELDI_LTV350(0x14,0x0000);
   	Write_IELDI_LTV350(0x15,0x0000);
   	Write_IELDI_LTV350(0x16,0x0000);
   	Write_IELDI_LTV350(0x17,0x0000);
   	Write_IELDI_LTV350(0x18,0x0000);
   	Write_IELDI_LTV350(0x19,0x0000);
#else
	Write_IELDI_LTV350(0x09,0x0000);
#endif
	///////////////////////////////////////////////////////////////////
	// Power On Reset Display off State
	//////////////////////////////////////////////////////////////////
	//Write_IELDI_LTV350(0x09,0x0000);

	Delay(33);
	// delay about 10ms
//	delayLoop(LCD_DELAY_1MS*10);
	
	///////////////////////////////////////////////////////////////////
	// Power Setting Function 1
	//////////////////////////////////////////////////////////////////
#if LTV350
	Write_IELDI_LTV350(0x09,0x4055);
	Write_IELDI_LTV350(0x0a,0x0000);
#else
	Write_IELDI_LTV350(0x09,0x4055);
	Write_IELDI_LTV350(0x0a,0x2000);
#endif

	Delay(132);
	// delay about 40ms
//	delayLoop(LCD_DELAY_1MS*10);
	
	/////////////////////////////////////////////////////////////////////
	// Power Setting 2
	/////////////////////////////////////////////////////////////////////
#if LTV350
	Write_IELDI_LTV350(0x0a,0x2000);
#else
	Write_IELDI_LTV350(0x09,0x4055);
#endif

	Delay(50);
	// delay about 50ms
//	delayLoop(LCD_DELAY_1MS*50);
	
	///////////////////////////////////////////////////////////////////
	// Instruction Setting
	///////////////////////////////////////////////////////////////////
#if LTV350
	Write_IELDI_LTV350(0x01,0x409d);
	Write_IELDI_LTV350(0x02,0x0204);
	Write_IELDI_LTV350(0x03,0x2100);
	Write_IELDI_LTV350(0x04,0x1000);
	Write_IELDI_LTV350(0x05,0x5003);
	Write_IELDI_LTV350(0x06,0x0009);	//vbp
	Write_IELDI_LTV350(0x07,0x000f);	//hbp
	Write_IELDI_LTV350(0x08,0x0800);
	Write_IELDI_LTV350(0x10,0x0000);
	Write_IELDI_LTV350(0x11,0x0000);
	Write_IELDI_LTV350(0x12,0x000f);
	Write_IELDI_LTV350(0x13,0x1f00);
	Write_IELDI_LTV350(0x14,0x0000);
	Write_IELDI_LTV350(0x15,0x0000);
	Write_IELDI_LTV350(0x16,0x0000);
	Write_IELDI_LTV350(0x17,0x0000);
	Write_IELDI_LTV350(0x18,0x0000);
	Write_IELDI_LTV350(0x19,0x0000);
#else
	Write_IELDI_LTV350(0x01,0x409d);
	Write_IELDI_LTV350(0x02,0x0204);
	Write_IELDI_LTV350(0x03,0x0100);
	Write_IELDI_LTV350(0x04,0x3000);
	Write_IELDI_LTV350(0x05,0x4003);
	Write_IELDI_LTV350(0x06,0x0009);	//vbp
	Write_IELDI_LTV350(0x07,0x000f);	//hbp
	Write_IELDI_LTV350(0x08,0x0c00);
	Write_IELDI_LTV350(0x10,0x0103);
	Write_IELDI_LTV350(0x11,0x0301);
	Write_IELDI_LTV350(0x12,0x1f0f);
	Write_IELDI_LTV350(0x13,0x1f0f);
	Write_IELDI_LTV350(0x14,0x0707);
	Write_IELDI_LTV350(0x15,0x0307);
	Write_IELDI_LTV350(0x16,0x0707);
	Write_IELDI_LTV350(0x17,0x0000);
	Write_IELDI_LTV350(0x18,0x0004);
	Write_IELDI_LTV350(0x19,0x0000);
#endif
	

	Delay(198);
	// delay about 2 frames(60ms)
//	delayLoop(LCD_DELAY_1MS*50);
	

	///////////////////////////////////////////////////////////////////
	// Display On Sequence
	///////////////////////////////////////////////////////////////////
#if LTV350
	Write_IELDI_LTV350(0x09,0x4a55);
	Write_IELDI_LTV350(0x0a,0x2000);	
#else
	Write_IELDI_LTV350(0x09,0x4a55);
	Write_IELDI_LTV350(0x05,0x5003);	

#endif
 	Delay(10);
}




void IELCDC_InitLts222QForRgbif(void)
{
#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI)
	{

	GPIO_Init();
/*
	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00002222);	//set GPF4 as VD[23:20]
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set TOUT3 as Output signal for PWRRESET
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High

	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(33);
*/
	}
#else
	Assert(0);
#endif



	///////////////////////////////////////////////////////////////////
	// Power Setting Function 1
	//////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x22,0x01);	 // PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 1
	IELCDC_WriteCmd(0x03,0x01);	 // RESET REGISTER

	///////////////////////////////////////////////////////////////////
	// Initializing Function 1
	///////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x00,0xa0); Delay(2); // CONTROL REGISTER 1, delay about 300ns
	IELCDC_WriteCmd(0x01,0x10); Delay(2); // CONTROL REGISTER 2, delay about 300ns
	IELCDC_WriteCmd(0x02,0x00); Delay(2);	// RGB INTERFACE REGISTER
	IELCDC_WriteCmd(0x05,0x00); Delay(2);	// DATA ACCESS CONTROL REGISTER
	IELCDC_WriteCmd(0x0D,0x00); Delay(132); // delay about 40ms

	///////////////////////////////////////////////////////////////////
	// Initializing Function 2
	///////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x0E,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x0F,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x10,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x11,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x12,0x00); Delay(2);  // delay about 300ns 
	IELCDC_WriteCmd(0x13,0x00); Delay(2); // DISPLAY SIZE CONTROL REGISTER
	IELCDC_WriteCmd(0x14,0x00); Delay(2); // PARTIAL-OFF AREA COLOR REGISTER 1
	IELCDC_WriteCmd(0x15,0x00); Delay(2); // PARTIAL-OFF AREA COLOR REGISTER 2
	IELCDC_WriteCmd(0x16,0x00); Delay(2);  // PARTIAL 1 DISPLAY AREA STARTING REGISTER 1
	IELCDC_WriteCmd(0x17,0x00); Delay(2); // PARTIAL 1 DISPLAY AREA STARTING REGISTER 2
	IELCDC_WriteCmd(0x34,0x01); Delay(2); // POWER SUPPLY SYSTEM CONTROL REGISTER 14
	IELCDC_WriteCmd(0x35,0x00); Delay(132); // POWER SUPPLY SYSTEM CONTROL REGISTER 7

	////////////////////////////////////////////////////////////////////
	// Initializing Function 3
	////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x8D,0x01); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x8B,0x28); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x4B,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x4C,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x4D,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x4E,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x4F,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x50,0x00); Delay(200);  //  ID CODE REGISTER 2, Check it out, delay about 50 ms
	IELCDC_WriteCmd(0x86,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x87,0x26); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x88,0x02); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x89,0x05); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x33,0x01); Delay(2);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 13
	IELCDC_WriteCmd(0x37,0x06); Delay(200); //  POWER SUPPLY SYSTEM CONTROL REGISTER 12, Check it out
	IELCDC_WriteCmd(0x76,0x00); Delay(132); //  SCROLL AREA START REGISTER 2, delay about 30ms

	/////////////////////////////////////////////////////////////////////
	// Initializing Function 4
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x42,0x00); Delay(2); // delay about 300ns
	IELCDC_WriteCmd(0x43,0x00); Delay(2); // delay about 300ns
	IELCDC_WriteCmd(0x44,0x00); Delay(2); // delay about 300ns
	IELCDC_WriteCmd(0x45,0x00); Delay(2); //  CALIBRATION REGISTER
	IELCDC_WriteCmd(0x46,0xef); Delay(2);
	IELCDC_WriteCmd(0x47,0x00); Delay(2);
	IELCDC_WriteCmd(0x48,0x00); Delay(2);
	IELCDC_WriteCmd(0x49,0x01); Delay(2);  //  ID CODE REGISTER 1							check it out
	IELCDC_WriteCmd(0x4A,0x3f); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x3C,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x3D,0x00); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x3E,0x01); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x3F,0x3f); Delay(2);  // delay about 300ns
	IELCDC_WriteCmd(0x40,0x01); Delay(2);  // delay about 300ns, horizontal back porch, 050105 Boaz.Kim
//	IELCDC_WriteCmd(0x40,0x02); Delay(5); //	horizontal back porch	 //050105 Boaz.Kim
	IELCDC_WriteCmd(0x41,0x0a); Delay(2); //	vertical back porch
//	IELCDC_WriteCmd(0x41,0x08); Delay(5); //	vertical back porch
	IELCDC_WriteCmd(0x8F,0x3f); Delay(132); // this value is more comfortable to look

	/////////////////////////////////////////////////////////////////////
	// Initializing Function 5
	/////////////////////////////////////////////////////////////////////


	IELCDC_WriteCmd(0x90,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x91,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x92,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x93,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x94,0x17); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x95,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x96,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x97,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x98,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x99,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9A,0x17); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9B,0x07); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9C,0x07); Delay(5);  // delay about 300ns

/*
	IELCDC_WriteCmd(0x90,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x91,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x92,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x93,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x94,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x95,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x96,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x97,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x98,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x99,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9A,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9B,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9C,0x33); Delay(5);  // delay about 300ns
*/

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SPI)
	IELCDC_WriteCmd(0x9D,0x80); Delay(132); //	16 or 18bit RGB (BWS2="H": 16bit, BWS2="L": 18bit[default config in DualLcd b'd])		
#elif (LCD_MODEL == LCD_LTS222Q_SRGB)
	IELCDC_WriteCmd(0x9D,0x81); Delay(132); //	6bit*3transfer RGB
#else 
	Assert(0);
#endif

	/////////////////////////////////////////////////////////////////////
	// Power Setting 2
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x1D,0x08); Delay(132); // delay about 50 us
	IELCDC_WriteCmd(0x23,0x00); Delay(1); //  PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2
	IELCDC_WriteCmd(0x24,0x94); Delay(1); //  POWER SUPPLY SYSTEM CONTROL REGISTER 1
	IELCDC_WriteCmd(0x25,0x6f); Delay(132);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 2

	/////////////////////////////////////////////////////////////////////
	// Power Setting 3
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x28,0x1e); Delay(1); // 
	IELCDC_WriteCmd(0x1A,0x00); Delay(1);// 
	IELCDC_WriteCmd(0x21,0x10); Delay(1);//  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	IELCDC_WriteCmd(0x18,0x25); Delay(1);//  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 40ms
	Delay(132);					
	IELCDC_WriteCmd(0x19,0x48); Delay(1); //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 2
	IELCDC_WriteCmd(0x18,0xe5);  Delay(1);//  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 10ms
	Delay(132);					
	IELCDC_WriteCmd(0x18,0xF7);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1 

	// delay about 40ms
	Delay(132);					
	IELCDC_WriteCmd(0x1B,0x07);  // VS regulator ON at 4.5V

	// delay about 40ms
	Delay(132); 				
	IELCDC_WriteCmd(0x1F,0x5a); Delay(1);
	IELCDC_WriteCmd(0x20,0x54); Delay(1);
	IELCDC_WriteCmd(0x1E,0xc1); Delay(1);

	// delay about 10ms
	Delay(33);					
	IELCDC_WriteCmd(0x21,0x00); Delay(1);//  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	IELCDC_WriteCmd(0x3B,0x01); Delay(1); // 

	// delay about 20ms
	Delay(66);					
	IELCDC_WriteCmd(0x00,0x20);  Delay(1);//  CONTROL REGISTER 1

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB)
	IELCDC_WriteCmd(0x02,0x01);  //  RGB INTERFACE REGISTER
#elif (LCD_MODEL == LCD_LTS222Q_SPI)
	IELCDC_WriteCmd(0x02,0x00);  //  SPI INTERFACE REGISTER
#else		//Disp("Wrong model in InitLTS222Q()\n");
	Assert(0);
#endif
	// delay about 10ms
	Delay(400);			
}

#else




void IELCDC_WriteCmd(u32 uAddr, u32 uData)
{
	u32 uTemp;

	IELCDC_SetRsOnOff(0);		// RS signal low	
	IELCDC_SetnWE(0);			// WE enable

/*                                                           need to build this code later
	uTemp = uAddr;
	SPI_Send((u32)&uTemp, 1, false, &oIeLcdc.oSpi);
	uTemp = uData;
	SPI_Send((u32)&uTemp, 1, false, &oIeLcdc.oSpi);
*/
}

void IELCDC_InitLts222QForRgbif(void)
{
#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI)
	;
#else
	Assert(0);
#endif

//	oIeLcdc.m_oSpi.InitAsMaster(TX, 2500000, false, FALLING, FORMAT_B);
//	SPI_InitCh(SPI_A, &oIeLcdc.oSpi);
//	SPI_InitAsMaster(TX, 2500000, false, FALLING, FORMAT_B, BYTE, 0, MANUAL_CS, 0, BYTE, 0, 0, 0, 0, &oIeLcdc.oSpi);
	
	///////////////////////////////////////////////////////////////////
	// Power Setting Function 1
	//////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x22,0x01);	 // PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 1
	IELCDC_WriteCmd(0x03,0x01);	 // RESET REGISTER

	///////////////////////////////////////////////////////////////////
	// Initializing Function 1
	///////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x00,0xa0); Delay(1); // CONTROL REGISTER 1, delay about 300ns
	IELCDC_WriteCmd(0x01,0x10); Delay(1); // CONTROL REGISTER 2, delay about 300ns
	IELCDC_WriteCmd(0x02,0x00); Delay(1);	// RGB INTERFACE REGISTER
	IELCDC_WriteCmd(0x05,0x00); Delay(1);	// DATA ACCESS CONTROL REGISTER
	IELCDC_WriteCmd(0x0D,0x00); Delay(400); // delay about 40ms

	///////////////////////////////////////////////////////////////////
	// Initializing Function 2
	///////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x0E,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x0F,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x10,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x11,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x12,0x00); Delay(5);  // delay about 300ns 
	IELCDC_WriteCmd(0x13,0x00); Delay(5); // DISPLAY SIZE CONTROL REGISTER
	IELCDC_WriteCmd(0x14,0x00); Delay(5); // PARTIAL-OFF AREA COLOR REGISTER 1
	IELCDC_WriteCmd(0x15,0x00); Delay(5); // PARTIAL-OFF AREA COLOR REGISTER 2
	IELCDC_WriteCmd(0x16,0x00); Delay(5);  // PARTIAL 1 DISPLAY AREA STARTING REGISTER 1
	IELCDC_WriteCmd(0x17,0x00); Delay(5); // PARTIAL 1 DISPLAY AREA STARTING REGISTER 2
	IELCDC_WriteCmd(0x34,0x01); Delay(5); // POWER SUPPLY SYSTEM CONTROL REGISTER 14
	IELCDC_WriteCmd(0x35,0x00); Delay(400); // POWER SUPPLY SYSTEM CONTROL REGISTER 7

	////////////////////////////////////////////////////////////////////
	// Initializing Function 3
	////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x8D,0x01); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x8B,0x28); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x4B,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x4C,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x4D,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x4E,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x4F,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x50,0x00); Delay(500);  //  ID CODE REGISTER 2, Check it out, delay about 50 ms
	IELCDC_WriteCmd(0x86,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x87,0x26); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x88,0x02); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x89,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x33,0x01); Delay(5);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 13
	IELCDC_WriteCmd(0x37,0x06); Delay(500); //  POWER SUPPLY SYSTEM CONTROL REGISTER 12, Check it out
	IELCDC_WriteCmd(0x76,0x00); Delay(400); //  SCROLL AREA START REGISTER 2, delay about 30ms

	/////////////////////////////////////////////////////////////////////
	// Initializing Function 4
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x42,0x00); Delay(5); // delay about 300ns
	IELCDC_WriteCmd(0x43,0x00); Delay(5); // delay about 300ns
	IELCDC_WriteCmd(0x44,0x00); Delay(5); // delay about 300ns
	IELCDC_WriteCmd(0x45,0x00); Delay(5); //  CALIBRATION REGISTER
	IELCDC_WriteCmd(0x46,0xef); Delay(5);
	IELCDC_WriteCmd(0x47,0x00); Delay(5);
	IELCDC_WriteCmd(0x48,0x00); Delay(5);
	IELCDC_WriteCmd(0x49,0x01); Delay(5);  //  ID CODE REGISTER 1							check it out
	IELCDC_WriteCmd(0x4A,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x3C,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x3D,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x3E,0x01); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x3F,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x40,0x01); Delay(5);  // delay about 300ns, horizontal back porch, 050105 Boaz.Kim
//	IELCDC_WriteCmd(0x40,0x02); Delay(5); //	horizontal back porch	 //050105 Boaz.Kim
	IELCDC_WriteCmd(0x41,0x0a); Delay(5); //	vertical back porch
//	IELCDC_WriteCmd(0x41,0x08); Delay(5); //	vertical back porch
#if 0 /// 6.15
	IELCDC_WriteCmd(0x8f, 0x05); Delay(400); // Gamma adjustment (upper amplitude-positive) (default: 0x05)
#else
	IELCDC_WriteCmd(0x8F,0x3f); Delay(400); // this value is more comfortable to look
#endif
	 
	/////////////////////////////////////////////////////////////////////
	// Initializing Function 5
	/////////////////////////////////////////////////////////////////////
#if 0 /// 6.15 0->1

	// Gamma adjustment regs
	IELCDC_WriteCmd(0x90,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x91,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x92,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x93,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x94,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x95,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x96,0x05); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x97,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x98,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x99,0x44); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9A,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9B,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9C,0x33); Delay(5);  // delay about 300ns
#else  // this value is more comfortable to look
	IELCDC_WriteCmd(0x90,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x91,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x92,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x93,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x94,0x17); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x95,0x3f); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x96,0x00); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x97,0x33); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x98,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x99,0x77); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9A,0x17); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9B,0x07); Delay(5);  // delay about 300ns
	IELCDC_WriteCmd(0x9C,0x07); Delay(5);  // delay about 300ns
#endif

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SPI)
	IELCDC_WriteCmd(0x9D,0x80); Delay(400); //	16 or 18bit RGB (BWS2="H": 16bit, BWS2="L": 18bit[default config in DualLcd b'd])		
#elif (LCD_MODEL == LCD_LTS222Q_SRGB)
	IELCDC_WriteCmd(0x9D,0x81); Delay(400); //	6bit*3transfer RGB
#else 
	Assert(0);
#endif

	/////////////////////////////////////////////////////////////////////
	// Power Setting 2
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x1D,0x08); Delay(400); // delay about 50 us
	IELCDC_WriteCmd(0x23,0x00); Delay(400); //  PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2
	IELCDC_WriteCmd(0x24,0x94); Delay(400); //  POWER SUPPLY SYSTEM CONTROL REGISTER 1
	IELCDC_WriteCmd(0x25,0x6f); Delay(400);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 2

	/////////////////////////////////////////////////////////////////////
	// Power Setting 3
	/////////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x28,0x1e);  // 
	IELCDC_WriteCmd(0x1A,0x00);  // 
	IELCDC_WriteCmd(0x21,0x10);  //  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	IELCDC_WriteCmd(0x18,0x25);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 40ms
	Delay(400);					

	IELCDC_WriteCmd(0x19,0x48);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 2
	IELCDC_WriteCmd(0x18,0xe5);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 10ms
	Delay(400);					

	IELCDC_WriteCmd(0x18,0xF7);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1 

	// delay about 40ms
	Delay(400);					
#if 1 /// 6.15 best look
	IELCDC_WriteCmd(0x1B,0x07);  // VS regulator ON at 4.5V

	// delay about 40ms
	Delay(400); 				

	IELCDC_WriteCmd(0x1F,0x5a);
	IELCDC_WriteCmd(0x20,0x54);
	IELCDC_WriteCmd(0x1E,0xc1);
#elif 0 /// 6.15 
	IELCDC_WriteCmd(0x1B,0x01);  // 0x01 - VS regulator ON at 3.5V // 0x03 - ON at 4.0V

	// delay about 40ms
	Delay(400); 				

	IELCDC_WriteCmd(0x1F,0x5e); // Specify the VCOM1 amplitude between 0x33 and 0xb4.
	IELCDC_WriteCmd(0x20,0x5f); // Specify the VCOM1 center voltage between 0x07 and 0xbd.
	IELCDC_WriteCmd(0x1E,0xc1); // VCOM1: Normal operation, use the boosting circuit, use the extra CP1(twin CP1)
#else
	IELCDC_WriteCmd(0x1B,0x07);  // org

	// delay about 80ms
	Delay(400); 				

	IELCDC_WriteCmd(0x1F,0x68); // Specify the VCOM1 amplitude between 0x33 and 0xb4.
	IELCDC_WriteCmd(0x20,0x45);  // Specify the VCOM1 center voltage between 0x07 and 0xbd.
	IELCDC_WriteCmd(0x1E,0xc1);  // VCOM1: Normal operation, use the boosting circuit, use the extra CP1(twin CP1) 
#endif
	// delay about 10ms
	Delay(400);					

	IELCDC_WriteCmd(0x21,0x00);  //  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	IELCDC_WriteCmd(0x3B,0x01);  // 

	// delay about 20ms
	Delay(400);					

	IELCDC_WriteCmd(0x00,0x20);  //  CONTROL REGISTER 1

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB)
	IELCDC_WriteCmd(0x02,0x01);  //  RGB INTERFACE REGISTER
#elif (LCD_MODEL == LCD_LTS222Q_SPI)
	IELCDC_WriteCmd(0x02,0x00);  //  SPI INTERFACE REGISTER
#else		//Disp("Wrong model in InitLTS222Q()\n");
	Assert(0);
#endif
	
	// delay about 10ms
	Delay(400);			
}





void IELCDC_InitLtv350QVForRgbif(void)
{
#if (LCD_MODEL==LCD_LTV350QV_RGB)
	;
#else
	Assert(0);
#endif

//	oIeLcdc.m_oSpi.InitAsMaster(TX, 2500000, false, FALLING, FORMAT_B);
//	SPI_InitCh(SPI_B, &oIeLcdc.oSpi);
//	SPI_InitAsMaster(TX, 2500000, false, FALLING, FORMAT_B, BYTE, 0, MANUAL_CS, 0, BYTE, 0, 0, 0, 0, &oIeLcdc.oSpi);
	
	///////////////////////////////////////////////////////////////////
	//  Power On Reset State
	//////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x09,0x0000);	
	Delay(10);

	///////////////////////////////////////////////////////////////////
	//  Power Setting Function 1
	//////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x09, 0x4000); 
	IELCDC_WriteCmd(0x0a, 0x2000); 

	///////////////////////////////////////////////////////////////////
	//  Power Setting Function 2
	//////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x09, 0x4055); 
	Delay(50);

	///////////////////////////////////////////////////////////////////
	// Instruction Setting
	///////////////////////////////////////////////////////////////////
	IELCDC_WriteCmd(0x01, 0x409d);
	IELCDC_WriteCmd(0x02, 0x0204);
	IELCDC_WriteCmd(0x03, 0x0100);
	IELCDC_WriteCmd(0x04, 0x3000);
	IELCDC_WriteCmd(0x05, 0x4003);
	IELCDC_WriteCmd(0x06, 0x0009);
	IELCDC_WriteCmd(0x07, 0x000f);
	IELCDC_WriteCmd(0x08, 0x0c00);
	IELCDC_WriteCmd(0x10, 0x0103);
	IELCDC_WriteCmd(0x11, 0x0301);
	IELCDC_WriteCmd(0x12, 0x1f0f);
	IELCDC_WriteCmd(0x13, 0x1f0f);
	IELCDC_WriteCmd(0x14, 0x0707);
	IELCDC_WriteCmd(0x15, 0x0307);
	IELCDC_WriteCmd(0x16, 0x0707);
	IELCDC_WriteCmd(0x17, 0x0000);
	IELCDC_WriteCmd(0x18, 0x0004);
	IELCDC_WriteCmd(0x19, 0x0000);
//	Delay(100);
//	IELCDC_WriteCmd(0x00, 0x0001);
	Delay(500);

	///////////////////////////////////////////////////////////////////
	// Display On Sequence
	///////////////////////////////////////////////////////////////////
//	IELCDC_WriteCmd(0x00, 0x0002);
	
	IELCDC_WriteCmd(0x09, 0x4a55);
	IELCDC_WriteCmd(0x05, 0x5003);
	
}

#endif







// For LDI ==========================================================================================

// Normal way in CPU(i80) I/F
void IELCDC_InitLts222QForI80if(CPUIF_LDI eLdiMode)
{
	u32 temp;
	u32 uCmd[1];


 	
	// power funtion 1
	uCmd[0] = 0x2201; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1); // 50us, min. value. is 1
	uCmd[0] = 0x0301; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(42);	// 5ms
	
	//Initial funtion 1
	uCmd[0] = 0x00a0; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x0110; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x0200; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x0510; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x0d00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334); // 40ms, 40000us/120us = 333.33, in HCLK 20Mhz

	//Initial funtion 2
	uCmd[0] = 0x0e00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x0f01; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1000; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1100; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1200; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1300; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1400; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1500; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1600; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1700; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3401; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3500; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334); // 15 ms, 15000us/120us = 120, in HCLK 20Mhz

	//Initial funtion 3
	uCmd[0] = 0x8d01; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x8b28; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4b00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4c00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4d00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4e00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4f00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x5000; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x8600; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x8726; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x8802; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x8905; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3301; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3701; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1); // modified by kwan. letter
	uCmd[0] = 0x7600; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);	 // 15ms, 15000us/120us = 120 in HCLK 20Mhz

	//Initial funtion 4
	uCmd[0] = 0x4200; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4300; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4400; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4500; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x46ef; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4700; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4800; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4901; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4a3f; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3c00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3d00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3e01; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3f3f; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x4003; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1); // modified by kwan. letter
	uCmd[0] = 0x410a; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);

	//Initial funtion 5
	uCmd[0] = 0x8f00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x903f; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9133; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9277; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9377; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9417; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9500; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9600; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9733; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9877; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9977; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9a17; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9b00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9c00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x9d80; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);
	uCmd[0] = 0x1d08; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);
	
	//power funtion 2
	uCmd[0] = 0x2300; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(5);
	uCmd[0] = 0x2494; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(5);
	uCmd[0] = 0x256f; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334); 	// 40ms

	//power funtion 3
	uCmd[0] = 0x2810; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1); // modified by kwan. letter
	uCmd[0] = 0x1a00; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x2110; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1825; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);
	uCmd[0] = 0x1994; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1); // modified by kwan. letter
	uCmd[0] = 0x18e5; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);	 //40ms
	uCmd[0] = 0x18f7; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);
	uCmd[0] = 0x1b09; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);	 //40ms, modified by kwan. letter
	uCmd[0] = 0x1f78; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);// modified by kwan. letter
	uCmd[0] = 0x2045; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x1ec1; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);
	uCmd[0] = 0x2100; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(1);
	uCmd[0] = 0x3b01; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);	 //10ms
	uCmd[0] = 0x0020; IELCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(334);	 //40ms
}


void IELCDC_InitS6D0139ForI80if(CPUIF_LDI eLdiMode)
{
	IELCDC_PutCmdToLdiByManual(0x0007, eLdiMode);		Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	 Delay(1);	// GON 0, D1,0 =0

	IELCDC_PutCmdToLdiByManual(0x0011, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x3003, eLdiMode);	Delay(1);	// GVD 48, VC 3..
	
	IELCDC_PutCmdToLdiByManual(0x0014, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x1819, eLdiMode); Delay(1);   	// VCM24, VML 25	(VCM_SEL=0, VCMR=0)
	
	IELCDC_PutCmdToLdiByManual(0x0003, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x1000, eLdiMode);	Delay(1);	// bgr 1
	
	IELCDC_PutCmdToLdiByManual(0x0010, eLdiMode);		Delay(1);
	IELCDC_PutDataToLdiByManual(0x3b60, eLdiMode);	Delay(1);	// SAP 7, BT 3, DC 3
		
	IELCDC_PutCmdToLdiByManual(0x0013, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0040, eLdiMode);	Delay(334); // PON 1	
	
	IELCDC_PutCmdToLdiByManual(0x0013, eLdiMode);Delay(1);
	IELCDC_PutDataToLdiByManual(0x0060, eLdiMode);	Delay(334);	// PON 1,PON1 1

	IELCDC_PutCmdToLdiByManual(0x0013, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0070, eLdiMode);	Delay(334);	// PON 1,PON1 1,AON 1
	
	IELCDC_PutCmdToLdiByManual(0x0001, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0127, eLdiMode);	Delay(1);	// SS 0N, NL 39
	
	IELCDC_PutCmdToLdiByManual(0x0002, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0700, eLdiMode);	Delay(1);	// FLD0 ON, B/C ON, 	EOR ON

	IELCDC_PutCmdToLdiByManual(0x0003, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x1030, eLdiMode);	Delay(1);	// BGR 0N, I/D0 ON, I/D1 ON
	
	IELCDC_PutCmdToLdiByManual(0x0008, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// FP 0, BP 0
	
	IELCDC_PutCmdToLdiByManual(0x000B, eLdiMode);	Delay(1);	
	IELCDC_PutDataToLdiByManual(0x0183, eLdiMode);	 Delay(1);	// case if FrameMark-type mode 
//	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode); Delay(1);		// case if vsync-type mode	
	
	IELCDC_PutCmdToLdiByManual(0x0042, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x013F, eLdiMode);	Delay(1);	// SE1 319		: screen end positin
		
	IELCDC_PutCmdToLdiByManual(0x0043, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// SS1 0: :screen start position
	
	IELCDC_PutCmdToLdiByManual(0x0046, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0xEF00, eLdiMode);	Delay(1);	// HEA 239, HSA 0
	
	IELCDC_PutCmdToLdiByManual(0x0047, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x013F, eLdiMode);	Delay(1);	// VEA 319 : vertical win addr end position
	
	IELCDC_PutCmdToLdiByManual(0x0048, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// VSA 0	 :vertical win addr start position
	
	IELCDC_PutCmdToLdiByManual(0x0030, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0020, eLdiMode);Delay(1);		//	  PKP1 0, RATIO0 1, PKP0 0 
		
	IELCDC_PutCmdToLdiByManual(0x0031, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x06E0, eLdiMode);	Delay(1);	// PKP3 6, RATIO1 7, PKP2 0	
	
	IELCDC_PutCmdToLdiByManual(0x0032, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0304, eLdiMode);	Delay(1);	// PKP5 3, PKP4 4
	
	IELCDC_PutCmdToLdiByManual(0x0033, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// PRP1 0 , PRP0 0
	
	// SEQUENCE 
	IELCDC_PutCmdToLdiByManual(0x0034, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0020, eLdiMode);	Delay(1);	// PKN1 0, RATIO0 1
		
	IELCDC_PutCmdToLdiByManual(0x0035, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// PKN3 0, RATIO1 0, PKN2 0
	
	IELCDC_PutCmdToLdiByManual(0x0036, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0707, eLdiMode);	Delay(1);	// PKN5 7, PKN4 7
	
	IELCDC_PutCmdToLdiByManual(0x0037, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	//	PRN1 0, PRN0 0,
	
	IELCDC_PutCmdToLdiByManual(0x0038, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	// VRP1 0, VRP0 0
		
	IELCDC_PutCmdToLdiByManual(0x0039, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0000, eLdiMode);	Delay(1);	//  VRN1 0, VRN0 0
	
	IELCDC_PutCmdToLdiByManual(0x0007, eLdiMode); Delay(1);
	IELCDC_PutDataToLdiByManual(0x0811, eLdiMode);	Delay(334);	// PT 1, GON 1, D1

	IELCDC_PutCmdToLdiByManual(0x0007, eLdiMode);	Delay(1);
	IELCDC_PutDataToLdiByManual(0x0817, eLdiMode);	Delay(1);	// PT 1, GON 1, REV 1, D3
	
	IELCDC_PutCmdToLdiByManual(0x0022, eLdiMode);	Delay(1);	// GON 1, D1, D3
}

void IELCDC_PutCmdToLdiByManual(u32 uData, CPUIF_LDI eLdiMode)
{
	u32 uMode = 0;

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI ) 	
	; //No operation
#elif ( LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL==LCD_S6D0139_CPU ) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	IeLcdcOutp32(SIFCCON0, uMode|0x01);   // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x03);  // ADDR(RS) = 3'b00, OE = 0, WE = 1, enable = 1
	IeLcdcOutp32(SIFCCON1, uData);   // Put Cmd
	IeLcdcOutp32(SIFCCON0, uMode|0x01);   // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x00); // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 0
#else
	Assert(0);
#endif

}

void IELCDC_PutDataToLdiByManual(u32 uData, CPUIF_LDI eLdiMode)
{
	u32 uMode = 0;

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI ) 	
	; //No operation
#elif(LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU)
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	IeLcdcOutp32(SIFCCON0, uMode|0x61);	// ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x63);	// ADDR(RS) = 3'b11, OE = 0, WE = 1, enable = 1
	IeLcdcOutp32(SIFCCON1, uData);		// Put data
	IeLcdcOutp32(SIFCCON0, uMode|0x61);	// ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x00);	// OE = 0, WE = 0, enable = 0
#else
		Assert(0);
#endif

}

void IELCDC_GetCmdFromLdiByManual(u32* uCmd, CPUIF_LDI eLdiMode )
{
	u32 uMode = 0;

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU ) 	
	; //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	IeLcdcOutp32(SIFCCON0, uMode|0x01); // OE = 0, WE = 1, ADDR(RS) = 3'b00, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x05); // OE = 1, WE = 1, ADDR(RS) = 3'b00, enable = 1
	IeLcdcInp32(SIFCCON2, *uCmd); // get command
	IeLcdcOutp32(SIFCCON0, uMode|0x01); // OE = 0, WE = 1, ADDR(RS) = 3'b00, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x00); // OE = 0, WE = 0, ADDR(RS) = 3'b00, enable = 0
	IeLcdcOutp32(SIFCCON0, uMode|0x03); // OE = 0, WR = 1, ADDR(RS) = 3'b00, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x07); // OE = 1, WR = 1, ADDR(RS) = 3'b00, enable = 1
	IeLcdcInp32(SIFCCON2, *uCmd); // Get command
	IeLcdcOutp32(SIFCCON0, uMode|0x00);	// OE = 0, WE = 0, ADDR(RS) = 3'b00, enable = 0
#else
	Assert(0);
#endif
}

void IELCDC_GetDataFromLdiByManual(u32* uData, CPUIF_LDI eLdiMode )
{
	u32 uMode = 0;

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU ) 	
	; //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	IeLcdcOutp32(SIFCCON0, uMode|0x61); // ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x65); // ADDR(RS) = 3'b11, OE = 1, WE = 0, enable = 1
	IeLcdcInp32(SIFCCON2, *uData); // Get Data
	IeLcdcOutp32(SIFCCON0, uMode|0x61); // ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	IeLcdcOutp32(SIFCCON0, uMode|0x00);	 // OE = 0, WE = 0, enable = 0
#else
	Assert(0);
#endif
}

// Max. of uDtaNum : 12
void IELCDC_PutCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode)
{
	IELCDC_PutDataOrCmdToLdi(uData, uDataNum, eLdiMode, eCmdMode, true);
}

void IELCDC_PutDataToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode)
{
	IELCDC_PutDataOrCmdToLdi(uData, uDataNum, eLdiMode, eCmdMode, false);
}

// if IsCmd == 1, put cmd to LDI
// else put data to LDI
void IELCDC_PutDataOrCmdToLdi(u32 uData[], u32 uDataNum,
	CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode, bool bIsCmd)
{
	u32 uCmdCnt;
	u32 uCmdEnVal = 0;
	u32 uEnBit;
	u32 uRsVal=0;
	u32 uCmdBaseAddr;
	u32 uConRegAddr;
	u32 uConRegVal;
	u32 uRsBitVal;
	u32 j;

	Assert(0 < uDataNum <= 12);

	if (eCmdMode == LCD_NORMAL_CMD || eCmdMode == LCD_NORMAL_N_AUTO_CMD)
	{
		uConRegAddr = (eLdiMode == MAIN) ? I80IFCONB0 : I80IFCONB1;

		// check the LCD_NORMAL_CMD CMD START bit to zero
		while(true)
		{
			IeLcdcInp32(uConRegAddr, uConRegVal);
			if ( (uConRegVal&(1<<9)) == 0)
				break;
		}
	}

#if (LCD_MODEL==LCD_S6D66A0_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU ) 	
	Assert(0); //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU) 
	uCmdBaseAddr = LDI_CMD0;
	uCmdCnt = 0;
	uEnBit = 
		(eCmdMode == LCD_NORMAL_CMD) ? 0x1 :
		(eCmdMode == LCD_AUTO_CMD) ? 0x2 : 0x3;
	for (j=0; j<uDataNum; j++)
	{
		// set enable bit
		uCmdEnVal |= uEnBit<<(2*uCmdCnt);

		uRsBitVal = (bIsCmd == true) ? 0x0 : 0x1;

		// set RS bit to 0
		uRsVal |= (uRsBitVal<<uCmdCnt);

		// set data
		IeLcdcOutp32(uCmdBaseAddr, uData[j]);
		uCmdBaseAddr += 0x4;
		uCmdCnt++;
	}
	IeLcdcOutp32(LDI_CMDCON0, uCmdEnVal);
	IeLcdcOutp32(LDI_CMDCON1, uRsVal);

	if (eCmdMode == LCD_NORMAL_CMD || eCmdMode == LCD_NORMAL_N_AUTO_CMD)
	{
		// start NORMAL COMMAND START
		IeLcdcOutp32(uConRegAddr, uConRegVal|(1<<9));
	}	
#else
	Assert(0);
#endif

}

void IELCDC_SetRsOnOff(u32 uOnOff)
{
	u32 uI80CmdVal;

	Assert (uOnOff == 1 || uOnOff == 0);

	IeLcdcInp32(SIFCCON0, uI80CmdVal);

	uI80CmdVal |= (0x1<<0);		// manual command mode enable

	uI80CmdVal = (uOnOff == 0) ? uI80CmdVal&~(0x7<<5) : uI80CmdVal|(0x7<<5); // Rs signal control 1:high, 0:low 

	IeLcdcOutp32(SIFCCON0, uI80CmdVal);
}

// uLowHigh: 0 - Write, 1- Read
void IELCDC_SetnWE(u32 uLowHigh)
{
	u32 uI80CmdVal;
	
	Assert (uLowHigh == 1 || uLowHigh == 0);

	IeLcdcInp32(SIFCCON0, uI80CmdVal);

	uI80CmdVal |= (0x1<<0);		// manual command mode enable

	uI80CmdVal = (uLowHigh == 0) ? uI80CmdVal&~(0x3<<1)|(1<<1) : uI80CmdVal&~(0x3<<1)|(0x1<<2);

	IeLcdcOutp32(SIFCCON0, uI80CmdVal);
}


void IELCDC_GetLcdSz(u32* uLcdHSz, u32* uLcdVSz)
{
	*uLcdHSz = oIeLcdc.m_uLcdHSz;
	*uLcdVSz = oIeLcdc.m_uLcdVSz;
}

void IELCDC_GetFrmSz(u32* uFrmHSz, u32* uFrmVSz, LCD_WINDOW eWin)
{
	*uFrmHSz = oIeLcdc.m_uFrmHSz[eWin];
	*uFrmVSz = oIeLcdc.m_uFrmVSz[eWin];
}

void IELCDC_GetFbStAddr(u32* uFbAddr, LCD_WINDOW eWin) 
{ 
	*uFbAddr = oIeLcdc.m_uFbStAddr[eWin]; 
}

void IELCDC_GetFbEndAddr(u32* uFbAddr, LCD_WINDOW eWin) 
{ 
	*uFbAddr = oIeLcdc.m_uFbEndAddr[eWin]; 
}

void IELCDC_GetImgStAddr(u32* uImgStAddr, LCD_WINDOW eWin) 
{ 
	*uImgStAddr = oIeLcdc.m_uImgStAddr[eWin]; 
}

void IELCDC_InitIpForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin)
{
	IELCDC_InitBase();
	IELCDC_InitWinForFifoIn(eInLocal, eWin);
}

void IELCDC_InitWinForFifoIn(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oIeLcdc.m_bFifoIn[eWin] = true;
	oIeLcdc.m_eLocalIn[eWin] = eLocalIn;
	IELCDC_InitWin(RGB24, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz, 0, 0, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz, 0, 0, 0, eWin, false);
}

void IELCDC_InitWinForFifoIn1(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oIeLcdc.m_bFifoIn[eWin] = true;
	oIeLcdc.m_eLocalIn[eWin] = eLocalIn;
	oIeLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	IELCDC_InitWin(RGB24, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz, 0, 0, oIeLcdc.m_uLcdHSz, oIeLcdc.m_uLcdVSz, 0, 0, 0, eWin, false);
}

void IELCDC_InitWinForFifoIn2(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS, u32 uLcdHsize, u32 uLcdVsize)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oIeLcdc.m_bFifoIn[eWin] = true;
	oIeLcdc.m_eLocalIn[eWin] = eLocalIn;
	oIeLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	IELCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, 0, 0, 0, eWin, false);
}

void IELCDC_InitWinForFifoIn3(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oIeLcdc.m_bFifoIn[eWin] = true;
	oIeLcdc.m_eLocalIn[eWin] = eLocalIn;

	IELCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, uX_Lcd, uY_Lcd, 0, eWin, false);
}


void IELCDC_InitWinForFifoIn4 (LOCAL_IF_TYPE eLocalInCS, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd)
{
	Assert(eLocalInCS == LOCAL_IF_RGB24 || eLocalInCS == LOCAL_IF_YCBCR444);
	
	oIeLcdc.m_bFifoIn[eWin] = true;
	oIeLcdc.m_eLocalIn[eWin] = IN_POST;
	oIeLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	IELCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, uX_Lcd, uY_Lcd, 0, eWin, false);
}



// Full Win fifo UnderRun Check
void IELCDC_EnableAllWinFifoLvlInt(LCDC_FIFO_LEVEL eFifoLvl)
{
	u32 uFifoLvl;
	u32 uFifoStatus;

	switch(eFifoLvl)
	{
		case UNDER25:
			uFifoLvl = 0<<2;
			break;
		case UNDER50:
			uFifoLvl = 0x1<<2;
			break;
		case UNDER75:
			uFifoLvl = 0x2<<2;
			break;
		case EMPTY:
			uFifoLvl = 0x3<<2;
			break;
		case FULL:
			uFifoLvl = 0x4<<2;
			break;
		default:
			Assert(0);
			break;
	}
	
 	IeLcdcInp32(VIDINTCON0, uFifoStatus);
	uFifoStatus |= ((0x73<<5) | uFifoLvl | 0x3); 
	IeLcdcOutp32(VIDINTCON0, uFifoStatus);
}
// Full Win fifo UnderRun Check


// Full Win fifo UnderRun Check
void IELCDC_EnableAllWinFrameInt(LCDC_FRAME_INT_SEL eIntSel)
{
	u32 uFifoLvl;
	u32 uVidIntCon;
	u32 uIntSel;

	IeLcdcInp32(VIDINTCON0, uVidIntCon);

	switch(eIntSel)
	{
		case FINT_BACKPORCH:
			uIntSel = (1<<12)|(0<<15);
			break;
		case FINT_VSYNC:
			uIntSel = (1<<12)|(0x1<<15);
			break;
		case FINT_ACTIVE:
			uIntSel = (1<<12)|(0x2<<15);
			break;
		case FINT_FRONTPORCH:
			uIntSel = (1<<12)|(0x3<<15);
			break;
		case FINT_NONE:
			uIntSel = (0<<12);
			break;	
		default:
			Assert(0);
			break;
	}
	
	uVidIntCon |= ((0x73<<5) | uIntSel | 0x1); 
	IeLcdcOutp32(VIDINTCON0, uVidIntCon);
}

void IELCDC_SetAllWinIntCnt(LCDC_FIFO_LEVEL eFifoLvl, LCDC_FRAME_INT_SEL eIntSel)
{
	u32 uFifoLvl;
	u32 uVidIntCon;
	u32 uIntSel;

	IeLcdcInp32(VIDINTCON0, uVidIntCon);

	switch(eFifoLvl)
	{
		case UNDER25:
			uFifoLvl = (1<<1)|(0<<2);
			break;
		case UNDER50:
			uFifoLvl = (1<<1)|(0x1<<2);
			break;
		case UNDER75:
			uFifoLvl = (1<<1)|(0x2<<2);
			break;
		case EMPTY:
			uFifoLvl = (1<<1)|(0x3<<2);
			break;
		case FULL:
			uFifoLvl = (1<<1)|(0x4<<2);
			break;
		default:
			Assert(0);
			break;
	}

	switch(eIntSel)
	{
		case FINT_BACKPORCH:
			uIntSel = (1<<12)|(0<<15);
			break;
		case FINT_VSYNC:
			uIntSel = (1<<12)|(0x1<<15);
			break;
		case FINT_ACTIVE:
			uIntSel = (1<<12)|(0x2<<15);
			break;
		case FINT_FRONTPORCH:
			uIntSel = (1<<12)|(0x3<<15);
			break;
		case FINT_NONE:
			uIntSel = (0<<12);
			break;	
		default:
			Assert(0);
			break;
	}
	
	uVidIntCon |= ((0x73<<5) | uIntSel | uFifoLvl | 0x1); 
	IeLcdcOutp32(VIDINTCON0, uVidIntCon);
}


void IELCDC_DisableInterrupt(void)
{
	u32 uLcdcInt;

	IeLcdcInp32(VIDINTCON0, uLcdcInt);
	uLcdcInt &=~ 0x1;
	IeLcdcOutp32(VIDINTCON0, uLcdcInt);
}

void IELCDC_EnableInterrupt(void)
{
	u32 uLcdcInt;

	IeLcdcInp32(VIDINTCON0, uLcdcInt);
	uLcdcInt |= 0x1;
	IeLcdcOutp32(VIDINTCON0, uLcdcInt);
}

void IELCDC_DisableFifoInterrupt(void)
{
	u32 uLcdcInt;

	IeLcdcInp32(VIDINTCON0, uLcdcInt);
	uLcdcInt &=~ 0x1;
	IeLcdcOutp32(VIDINTCON0, uLcdcInt);
}


void IELCDC_DisableIntFifoLevel(LCD_WINDOW eWin)
{
	u32 uFifoStatus;
	
 	IeLcdcInp32(VIDINTCON0, uFifoStatus);

	if(eWin == WIN0)
		uFifoStatus &=~ (0x1<<5);
	else if(eWin == WIN1)
		uFifoStatus &=~ (0x1<<6);
	else if(eWin == WIN2)
		uFifoStatus &=~ (0x1<<9);
	else if(eWin == WIN3)
		uFifoStatus &=~ (0x1<<10);
	else if(eWin == WIN4)
		uFifoStatus &=~ (0x1<<11);
	else
		Assert(0);
	
	IeLcdcOutp32(VIDINTCON0, uFifoStatus);
}

