
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>


//#include "system.h"
#include "def.h"
#include "intc.h"
#include "jpeg.h"
#include "lcd.h"
#include "camera.h"//camif.h -> camera.h jhy20090326
#include "fimc.h" //jhy20090326
#include "glib.h"
#include "option.h"
#include "library.h"
//#include "sdhc.h"
//#include "fat.h"
#include "uart.h"
#include "timer.h"
#include "sblock.h"

#include "jpeg_image.h"
#include "jpeg_sfr.h"
#include "sysc.h"

#define CAPTURED_JPEG      "Saved.jpg"
//#define CAPTURED_JPEG      "./Test_sample/Captured_444.jpg"
//#define CAPTURED_JPEG      "j400_00.jpg"
#define SAVE_JPEG		  "Saved.jpg"
#define YUV_FILE_NAME      "Captured.yuv"

// CAM I/F 
static u32 volatile bProcessingDone;

// LCDC
static IMG_FMT eLcdBpp;
static IMG_FMT eRawImgFormat;
static IMG_FMT eJpgOutputType;
static u32 uLcdFbAddr, uLcdHSz, uLcdVSz;

// JPEG
static u8 bIsOneStep;
static u8 bIsJpgLoaded;
static volatile u8 bJpegDone;
static u32 uJpgSize;
static u32 uJpgAddr;
static u32 uJpgAddr0;
static u32 uJpgAddr1;
static JPEG_TYPE eJpgFormat;
static JPEG_IRQSTATUS eJpgIrq;
static JPEG_STATUS eJpgSts;
static u32 uRawImgHsz_Enc, uRawImgVsz_Enc, uGlibAddr;
static u32 uRawImgHsz_EncTemp, uRawImgVsz_EncTemp;
static u32 uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr;

#define WaitForSet(bDone) while (!bDone)
#define WaitForConversionDone(bDone) while(!bDone)

static void __irq Isr_Jpeg(void)
{
	u32 uStatus;

	INTC_Disable(NUM_JPEG);

	JPEG_ReadStatus(&eJpgIrq);
	switch (eJpgIrq)
	{
		case 0x40 : UART_Printf("JPGIRQ : 0x%x   Enc or Dec is OK\n",eJpgIrq); break;	//ERR_HD_PARSING2
		case 0x20 : UART_Printf("JPGIRQ : 0x%x   Error! Syntax or Abnormally\n",eJpgIrq); break;		//ERR_ENC_OR_DEC
	}
	
	bJpegDone = true;
	//UART_Printf("JpegDone: %d\n", bJpegDone); 

	JPEG_Wait_Done();
	JPEG_IntClear();

	INTC_Enable(NUM_JPEG);
	INTC_ClearVectAddr();	
	
}
static void TestSfr(void)
{
	static REGINFO *sRegInfo;
	
	volatile u32 *pAddr;	
	s32 i,j, count , nPattern;
	u32 uRegStatus, uWritePatternWithMask, uReadWithMask;	
	
	u32 uPatternShitfOneBit[] = 
	{
		0x00000001,		0x00000002,		0x00000004,		0x00000008,		0x00000010,		0x00000020,		0x00000040,		0x00000080,
		0x00000100,		0x00000200,		0x00000400,		0x00000800,		0x00001000,		0x00002000,		0x00004000,		0x00008000,
		0x00010000,		0x00020000,		0x00040000,		0x00080000,		0x00100000,		0x00200000,		0x00400000,		0x00800000,
		0x01000000,		0x02000000,		0x04000000,		0x08000000,		0x10000000,		0x20000000,		0x40000000,		0x80000000,
	};
	
	u32 uDefaultBitMask[] =
	{
		0x00000001,		0x00000003,		0x00000007,		0x0000000F,		0x0000001F,		0x0000003F,		0x0000007F,		0x000000FF,
		0x000001FF,		0x000003FF,		0x000007FF,		0x00000FFF,		0x00001FFF,		0x00003FFF,		0x00007FFF,		0x0000FFFF,
		0x0001FFFF,		0x0003FFFF,		0x0007FFFF,		0x000FFFFF,		0x001FFFFF,		0x003FFFFF,		0x007FFFFF,		0x00FFFFFF,
		0x01FFFFFF,		0x03FFFFFF,		0x07FFFFFF,		0x0FFFFFFF,		0x1FFFFFFF,		0x3FFFFFFF,		0x7FFFFFFF,		0xFFFFFFFF,
	};


			 sRegInfo = sRegInfo_Jpeg;
			 count = sizeof(sRegInfo_Jpeg)/sizeof(REGINFO);
	
	for(i=0; i<count; i++)
	{		
		pAddr = (u32*)sRegInfo[i].uAddr;		
		
		if(sRegInfo[i].uFlag == DPDB)
		{		
			if(sRegInfo[i].uRWType == RW)
			{
				for(j=0; j< sRegInfo[i].uBitLen ; j++)
				{			 
					uWritePatternWithMask = (uPatternShitfOneBit[j] &uDefaultBitMask[j]);
					*pAddr = uWritePatternWithMask;					
					
					uReadWithMask = (*pAddr & uDefaultBitMask[j]);	
					sRegInfo[i].rValue = uReadWithMask;
					
					uRegStatus = (	uWritePatternWithMask !=uReadWithMask );					
					RPRINTF(sRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);
				}
			}
		}		
		else if(sRegInfo[i].uFlag == DPPB)
		{		
			nPattern = (sizeof(uPatternShitfOneBit)/sizeof(uPatternShitfOneBit[0]));			
			if(sRegInfo[i].uRWType == RW)
			{
				for(j=0; j<nPattern; j++)
				{
					if(uPatternShitfOneBit[j] & sRegInfo[i].uPrivateBitMask)
					{
						uWritePatternWithMask = (uPatternShitfOneBit[j] & sRegInfo[i].uPrivateBitMask);
						*pAddr = uWritePatternWithMask;
						
						uReadWithMask = (*pAddr & sRegInfo[i].uPrivateBitMask);
						sRegInfo[i].rValue = uReadWithMask;
						
						uRegStatus = (	uWritePatternWithMask != uReadWithMask );												
						RPRINTF(sRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);					
					}
				}
			}			
		}					
	}
	
	UART_Printf("\n\nTest Complete!\n\n");
}

static void GetJpegStreamFromPc(void)
{
	#if	 SEMIHOSTING
		const char *pFileName = CAPTURED_JPEG;
		UART_Printf(" Loading %s from PC ...\n", pFileName);
		LoadFromFile1(pFileName, uJpgAddr, &uJpgSize);

		UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr, uJpgSize);
		bIsJpgLoaded = true;
	#else
		UART_Printf("Check Semihosting....\n");
	#endif
}

static void GetJpegStreamFromSd(void)
{
#if 0
#if !SEMIHOSTING
	u32 uTotalNumOfFiles, i;
	int sel;
	char pFileName[50];

	//if (!SDHC_OpenMedia(SDHC_HCLK, &oSdhc) || !FAT_LoadFileSystem(&oSdhc))
	if (!SDHC_OpenMediaWithMode(4, SDHC_POLLING_MODE, SDHC_HCLK, 4, 1, &oSdhc) || !FAT_LoadFileSystem(&oSdhc))

	
		Assert(0);
	
	FAT_GetTotalNumOfFiles(&uTotalNumOfFiles, &oSdhc);
	for (i=0; i<uTotalNumOfFiles; i++)
	{
		FAT_GetFileName(i, pFileName, &oSdhc);
		UART_Printf("%02d -- %s\n", i, pFileName);
	}

	UART_Printf(" Which file to read ? ");
	sel = UART_GetIntNum();
	if (!FAT_ReadFile2(sel, uJpgAddr, &uJpgSize, &oSdhc))
		UART_Printf(" Loading failed ....\n");

	FAT_UnloadFileSystem(&oSdhc);
	SDHC_CloseMedia(&oSdhc);

	UART_Printf(" Stream size = %d bytes\n", uJpgSize);
	bIsJpgLoaded = true;
#endif
#endif
}
#if 1
void TestEncoding(void)
{
	u32 uSelSrcFmt, uSelOutFmt;
	
	bIsOneStep = false;	

	// Input Encoding format
	while (true)
	{
		// Input Encoding format		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] RGB565 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the encoding source format: ");

		uSelSrcFmt = UART_GetIntNum();
		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV422 \n");
		UART_Printf("[2] YUV420 \n");
		UART_Printf("\nEnter the encoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0 || uSelSrcFmt == 0)
			return;
		else if ((uSelSrcFmt >=1 && uSelSrcFmt <= 2) || (uSelOutFmt >=1 && uSelOutFmt <=2))
		{
			eRawImgFormat = (uSelSrcFmt == 1) ? RGB16: CRYCBY;
			if (uSelSrcFmt == 1) UART_Printf("JPG Input Raw Format : RGB16\n");
			else UART_Printf("JPG Input Raw Format : YUV422\n");		
			
			eJpgFormat = (uSelOutFmt == 1) ? YCBYCR: YCBCR420_2P_CRCB_LE; // YCBCR420_2P_CRCB_LE: YCBCR422_1P_CRYCBY NV12
			if (uSelOutFmt == 1) UART_Printf("JPG Format : YUV 422\n");
			else UART_Printf("JPG Format : YUV 420\n");		

			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

	// Input Encoding test size
	//UART_Printf("\nInput JPEG X size (min size 32): ");	uRawImgHsz_Enc = UART_GetIntNum(); uRawImgHsz_EncTemp = uRawImgHsz_Enc;
	//UART_Printf("\nInput JPEG Y size (min size 32): ");	uRawImgVsz_Enc = UART_GetIntNum(); uRawImgVsz_EncTemp = uRawImgVsz_Enc;
	UART_Printf("\nInput JPEG X size (min size 32): ");	uRawImgHsz_Enc = uRawImgHsz_EncTemp = UART_GetIntNum();
	UART_Printf("\nInput JPEG Y size (min size 32): ");	uRawImgVsz_Enc = uRawImgVsz_EncTemp = UART_GetIntNum();

	Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	

	JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
	UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_Enc, uRawImgVsz_Enc);
	UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);

	// Draw src. img.
	//uGlibAddr = 0x20000000;
//	memset((void *)uGlibAddr, 0, uRawImgHsz_EncTemp*uRawImgVsz_EncTemp*4);
	GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
	GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
	GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

	if(eRawImgFormat == CRYCBY)
	{
	// MEM TO MEM


		FIMC_InitIpForDinDout(FIMC_A,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0,
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
						uGlibAddr, RGB16,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0,// Scaler	
						uRawImgAddr, eRawImgFormat, 
						ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

		bProcessingDone = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
		FIMC_WaitForProcessingDone(FIMC_A);	
		FIMC_StopProcessing(FIMC_A);
	
	}
	
	uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;

	bJpegDone = false;
	JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
							uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
	WaitForSet(bJpegDone);	

	JPEG_GetStreamLen(&uJpgSize);
	UART_Printf("\nEncoded Stream = %d bytes\n", uJpgSize);

	INTC_Disable(NUM_JPEG);

}

#else
void TestEncoding(void)
{
	u32 uSelSrcFmt, uSelOutFmt;
	
	bIsOneStep = false;	

	// Input Encoding format
	while (true)
	{
		// Input Encoding format		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] RGB565 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the encoding source format: ");

		uSelSrcFmt = UART_GetIntNum();
		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV422 \n");
		UART_Printf("[2] YUV420 \n");
		UART_Printf("\nEnter the encoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0 || uSelSrcFmt == 0)
			return;
		else if ((uSelSrcFmt >=1 && uSelSrcFmt <= 2) || (uSelOutFmt >=1 && uSelOutFmt <=2))
		{
			eRawImgFormat = (uSelSrcFmt == 1) ? RGB16: CRYCBY;
			if (uSelSrcFmt == 1) UART_Printf("JPG Input Raw Format : RGB16\n");
			else UART_Printf("JPG Input Raw Format : YUV422\n");		
			
			eJpgFormat = (uSelOutFmt == 1) ? YCBYCR: YCBCR420_2P_CRCB_LE; // YCBCR420_2P_CRCB_LE: YCBCR422_1P_CRYCBY NV12
			if (uSelOutFmt == 1) UART_Printf("JPG Format : YUV 422\n");
			else UART_Printf("JPG Format : YUV 420\n");		

			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

	// Input Encoding test size
	//UART_Printf("\nInput JPEG X size (min size 32): ");	uRawImgHsz_Enc = UART_GetIntNum(); uRawImgHsz_EncTemp = uRawImgHsz_Enc;
	//UART_Printf("\nInput JPEG Y size (min size 32): ");	uRawImgVsz_Enc = UART_GetIntNum(); uRawImgVsz_EncTemp = uRawImgVsz_Enc;
	UART_Printf("\nInput JPEG X size (min size 32): ");	uRawImgHsz_Enc = uRawImgHsz_EncTemp = UART_GetIntNum();
	UART_Printf("\nInput JPEG Y size (min size 32): ");	uRawImgVsz_Enc = uRawImgVsz_EncTemp = UART_GetIntNum();

	Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
	UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_Enc, uRawImgVsz_Enc);
	UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);

	// Draw src. img.
	GLIB_InitInstance(uGlibAddr, 240, 320, RGB16);
	GLIB_DrawPattern(240, 320);
	GLIB_PutLine(0, 0, 0, 320-1, C_BLUE);

	if(eRawImgFormat == CRYCBY)
	{
	// MEM TO MEM


		FIMC_InitIpForDinDout(
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0,
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
						uGlibAddr, RGB16,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0,// Scaler	
						uRawImgAddr, eRawImgFormat, 
						ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

		bProcessingDone = false;
		FIMC_StartProcessing(false, 0, 0, false, 0);	
		FIMC_WaitForProcessingDone();	
		FIMC_StopProcessing();
	
	}
	else if(eRawImgFormat == RGB16)
	{
		FIMC_InitIpForDinDout(
						240, 320,0,
						0, 0, 240, 320, 
						uGlibAddr, RGB16,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0,// Scaler	
						uRawImgAddr, eRawImgFormat, 
						ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

		bProcessingDone = false;
		FIMC_StartProcessing(false, 0, 0, false, 0);	
		FIMC_WaitForProcessingDone();	
		FIMC_StopProcessing();
	}
	
	//uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;

	bJpegDone = false;
	JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
							uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
	WaitForSet(bJpegDone);	

	JPEG_GetStreamLen(&uJpgSize);
	UART_Printf("\nEncoded Stream = %d bytes\n", uJpgSize);

	INTC_Disable(NUM_JPEG);

}
#endif

void TestEncodingForOddInputImage(void)
{
	u32 uSelSrcFmt, uSelOutFmt;
	char NameIdx;
	u32 i, j, uOffset_H, uOffset_V;
	u32 tmp;
	char src[20]={0};
	char dest[30]={0};
	char decstr[30]={0};
	char jpg[5]={0};
	
		
	bIsOneStep = false;	

	// Input Encoding format
	while (true)
	{
		// Input Encoding format		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] RGB565 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the encoding source format: ");

		uSelSrcFmt = UART_GetIntNum();
		
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV422 \n");
		UART_Printf("[2] YUV420 \n");
		UART_Printf("\nEnter the encoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0 || uSelSrcFmt == 0)
			return;
		else if ((uSelSrcFmt >=1 && uSelSrcFmt <= 2) || (uSelOutFmt >=1 && uSelOutFmt <=2))
		{
			eRawImgFormat = (uSelSrcFmt == 1) ? RGB16: CRYCBY;
			if (uSelSrcFmt == 1)
			{
				UART_Printf("JPG Input Raw Format : RGB16\n");
				strcpy(dest, "Saved_RGBto");				
			}
			else
			{
				UART_Printf("JPG Input Raw Format : YUV422\n");		
				strcpy(dest, "Saved_YUV422to");
			}
			
			eJpgFormat = (uSelOutFmt == 1) ? YCBYCR: YCBCR420_2P_CRCB_LE; // YCBCR420_2P_CRCB_LE: YCBCR422_1P_CRYCBY NV12
			if (uSelOutFmt == 1) 
			{
				UART_Printf("JPG Format : YUV 422\n");
				strcpy(src,"YUV422");
			}
			else
			{
				UART_Printf("JPG Format : YUV 420\n");		
				strcpy(src,"YUV420");			
			}
			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

	strcat(dest,src);
	strcpy(jpg,".jpg");
	
	// Input Encoding test size
	//UART_Printf("\nInput JPEG X size (min size 32): ");	uRawImgHsz_Enc = UART_GetIntNum(); uRawImgHsz_EncTemp = uRawImgHsz_Enc;
	//UART_Printf("\nInput JPEG Y size (min size 32): ");	uRawImgVsz_Enc = UART_GetIntNum(); uRawImgVsz_EncTemp = uRawImgVsz_Enc;
	UART_Printf("\nInput Start JPEG X size (min size 32): ");	uRawImgHsz_Enc = uRawImgHsz_EncTemp = UART_GetIntNum();
	UART_Printf("\nInput Start JPEG Y size (min size 32): ");	uRawImgVsz_Enc = uRawImgVsz_EncTemp = UART_GetIntNum();
	UART_Printf("\nInput Horizontal Size Offset  [1~16]: ");	uOffset_H  = UART_GetIntNum();
	UART_Printf("\nInput Vertical Size Offset V[1~16]: ");	uOffset_V  = UART_GetIntNum();

	tmp = uRawImgVsz_Enc;

	Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	
	for(j = 1 ; j <  uOffset_H+1; j++)
	{

			uRawImgHsz_Enc += 1;
			uRawImgVsz_Enc = tmp;
				
		for(i = 1 ; i < uOffset_V+1; i++)
		{
			
			uRawImgVsz_Enc += 1;
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;
			
			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_Enc, uRawImgVsz_Enc);
			UART_Printf("temp_h = %d, temp_v = %d\n", uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);

			// Draw src. img.
			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			if(eRawImgFormat == CRYCBY)
			{
			#if 0	// LOCAL
				CI_InitIpForDinFout(
					uRawImgHSz_Dec, uRawImgVSz_Dec,
					0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
					uRawImgAddr, YCBCR422_1P_CRYCBY,
					uLcdHSz, uLcdVSz, // Fifo out display size
					LOCAL_IF_RGB24, PROGRESSIVE,
					ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				Disp("\n Press any key to stop! \n");
				UART_Getc();
				FIMC_StopProcessing();
			#else	// MEM TO MEM

				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A,
								uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0,
								0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
								uGlibAddr, RGB16,
								uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 
								0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0,// Scaler	
								uRawImgAddr, eRawImgFormat, 
								ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
			#endif
			}
			
			uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;

			bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("\nEncoded Stream = %d bytes\n", uJpgSize);


			if(j < 10)
			{
				decstr[0] = '[';
				decstr[1] = '0';
				decstr[2] = j+48;
				decstr[3] = ']';
			}
			else if(j<20)
			{
				decstr[0] = '[';
				decstr[1] = '1';
				decstr[2] = j%10+48;
				decstr[3] = ']';
			}

			if(i < 10)
			{
				decstr[4] = '[';
				decstr[5] = '0';
				decstr[6] = i+48;
				decstr[7] = ']';
			}
			else if(i<20)
			{
				decstr[4] = '[';
				decstr[5] = '1';
				decstr[6] = i%10+48;
				decstr[7] = ']';
			}
			
		//	UART_PutString(decstr); Disp("\n");
			//itoa(i,decstr,10);
			
			if(!strstr(decstr,dest))
			{
					decstr[8] = NULL;
					strcat(decstr,dest);
			}
			if(!strpbrk(decstr,jpg))
					strcat(decstr,jpg);
			
			
			UART_PutString(decstr); Disp("\n\n");
			//SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr);
			SaveToFile(decstr, uJpgSize, uJpgAddr);

			}
		}
	INTC_Disable(NUM_JPEG);
}

static void TestDecoding(void)
{

	u32 temp;
	u32 i;
	u32 uSelOutFmt;
	
	bIsOneStep = true;


	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first!!\n");
		return;
	}
	while (true)
	{
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV420 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the Decoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0)
			return;
		else if (uSelOutFmt >=1 && uSelOutFmt <=2) 
		{
			eRawImgFormat =(uSelOutFmt == 1) ? YCBCR420_2P_CRCB_LE: CRYCBY;
			if(eRawImgFormat == YCBCR420_2P_CRCB_LE)
				UART_Printf("JpgOutFormat = YCBCR420\n");
			else
				UART_Printf("JpgOutFormat = YCBCR422\n");
			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);
	
	uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

	
	bJpegDone = false;

	JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
	
	WaitForSet(bJpegDone);

	JPEG_GetFormat();
	JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

	
	
	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

	JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);



	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
	{
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
	#if 1
		#if 0	// LOCAL
		CI_InitIpForDinFout(
				uRawImgHSz_Dec, uRawImgVSz_Dec,
				0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
				uRawImgAddr, eRawImgFormat,		
				uLcdHSz, uLcdVSz, // Fifo out display size
				LOCAL_IF_RGB24, PROGRESSIVE,
				ROT_NO_FLIP_NO, 0);

		FIMC_StartProcessing(false, 0, 0, false, 0);
		Disp("\n Press any key to stop! \n");
		UART_Getc();
		FIMC_StopProcessing();
	
		#elif 1	// MEM TO MEM

		FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
							0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
							uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
							uLcdFbAddr, RGB565, 
							ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
		
		bProcessingDone = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
		FIMC_WaitForProcessingDone(FIMC_A);	
		FIMC_StopProcessing(FIMC_A);
		
		#endif
	#endif

	}

	bJpegDone = false;

	INTC_Disable(NUM_JPEG);

}

static void TestDecodingForOddInputImage(void)
{

	u32 temp;
	//char NameIdx;
	u32 i, j, uOffset_H, uOffset_V;
	u32 uSelInFmt;
	u32 uSelOutFmt;
	char dest[40]={0};
	char decstr[40]={0};

	char pFileName[100];
	bIsJpgLoaded = true;
	
	bIsOneStep = true;

	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first!!\n");
		return;
	}
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV422 \n");
		UART_Printf("[2] YUV420 \n");
		UART_Printf("[3] YUV444 \n");
		UART_Printf("[4] Gray \n");
		UART_Printf("\nEnter the Decoding source format: ");
		uSelInFmt = UART_GetIntNum();

		switch(uSelInFmt)
		{
			case 0:
				return ;				
			case 1:
				strcpy(dest, "Saved_RGBtoYUV422.jpg");		
				break;
			case 2:
				strcpy(dest, "Saved_RGBtoYUV420.jpg");		
				break;
			case 3:
				strcpy(dest, "Captured_YUV444.jpg");		
				break;
			case 4:
				strcpy(dest, "Captured_Gray.jpg");		
				break;
			default:
				Assert(0);
		}	
	
	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first!!\n");
		return;
	}	
	while (true)
	{
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV420 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the Decoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0)
			return;
		else if (uSelOutFmt >=1 && uSelOutFmt <=2) 
		{
			eRawImgFormat =(uSelOutFmt == 1) ? YCBCR420_2P_CRCB_LE: CRYCBY;
			if(eRawImgFormat == YCBCR420_2P_CRCB_LE)
				UART_Printf("JpgOutFormat = YCBCR420\n");
			else
				UART_Printf("JpgOutFormat = YCBCR422\n");
			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

		UART_Printf("\nInput Horizontal Size Offset [1~16]: ");	uOffset_H  = UART_GetIntNum();
		UART_Printf("\nInput Vertical Size Offset [1~16]: ");	uOffset_V  = UART_GetIntNum();
	
	for(j = 1 ; j < uOffset_H+1; j++)
	{
			for(i = 1 ; i <  uOffset_V+1; i++)
			{

				if(j < 10)
				{
					decstr[0] = '[';
					decstr[1] = '0';
					decstr[2] = j+48;
					decstr[3] = ']';
				}
				else if(j<20)
				{
					decstr[0] = '[';
					decstr[1] = '1';
					decstr[2] = j%10+48;
					decstr[3] = ']';
				}

				if(i < 10)
				{
					decstr[4] = '[';
					decstr[5] = '0';
					decstr[6] = i+48;
					decstr[7] = ']';
				}
				else if(i<20)
				{
					decstr[4] = '[';
					decstr[5] = '1';
					decstr[6] = i%10+48;
					decstr[7] = ']';
				}

				if(!strstr(decstr,dest))
				{
						decstr[8] = NULL;
						strcat(decstr,dest);
				}

				strcpy(pFileName,decstr);
			
				UART_Printf(" Loading %s from PC ...\n", pFileName);
				LoadFromFile1(pFileName, uJpgAddr, &uJpgSize);

				UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr, uJpgSize);
			
 				bIsJpgLoaded = true;
				DelayfrTimer(milli, 100);
				
				//UART_GetIntNum();

				INTC_Init();
				INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
				INTC_Enable(NUM_JPEG);
				
				uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;
				
				bJpegDone = false;

				JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
				
				WaitForSet(bJpegDone);

				JPEG_GetFormat();
				JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);		
				if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
					UART_Printf("Error! Widht or Height is zero\n");
				else 
					UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

				JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

				if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
					UART_Printf("Error! Widht or Height is zero\n");
				else 
				{
					UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 1
					#if 0	// LOCAL
					CI_InitIpForDinFout(
							uRawImgHSz_Dec, uRawImgVSz_Dec,
							0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
							uRawImgAddr, eRawImgFormat,		
							uLcdHSz, uLcdVSz, // Fifo out display size
							LOCAL_IF_RGB24, PROGRESSIVE,
							ROT_NO_FLIP_NO, 0);

					FIMC_StartProcessing(false, 0, 0, false, 0);
					Disp("\n Press any key to stop! \n");
					UART_Getc();
					FIMC_StopProcessing();
				
					#elif 1	// MEM TO MEM
#if 1 
					if(uRawImgHSz_Dec%16 != 0)
						uRawImgHSz_Dec += (16 -uRawImgHSz_Dec%16);

					FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
										0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
										uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
										uLcdFbAddr, RGB565, 
										ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

				
					bProcessingDone = false;
					FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
					FIMC_WaitForProcessingDone(FIMC_A);

					Disp("\n Press any key to stop! \n");
					UART_Getc();
					FIMC_StopProcessing(FIMC_A);
#endif		
					#endif
				#endif

				}

				bJpegDone = false;

				

			
			}
		}
	INTC_Disable(NUM_JPEG);
}

static void TestAgingEncoding(void)
{
	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	// CASE 1
	// Raw input = RGB16, JPG = YUV420
	eRawImgFormat = RGB16, eJpgFormat=YCBCR420_2P_CRCB_LE;

	UART_Printf("\n************************\n");
	UART_Printf("RAW=RGB16, JPG = YUV420\n");
	UART_Printf("************************\n");
	
	for(uRawImgHsz_Enc=385 ; uRawImgHsz_Enc <=400 ; uRawImgHsz_Enc++)
	{
		for(uRawImgVsz_Enc=273 ; uRawImgVsz_Enc <= 288 ; uRawImgVsz_Enc++)
		{

			// Encoding
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;
		
			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("\nOriginal X,Y = %d, %d => AfterCv X,Y = %d, %d ====> ", uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);

			eRawImgFormat = RGB16;
			uRawImgAddr =  uGlibAddr;

			memset((void *)uJpgAddr, 0, uLcdHSz*uLcdVSz*4);
			memset((void *)uRawImgAddr, 0, uLcdHSz*uLcdVSz*4);
			
			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			//uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;

			
			bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("Encoded Stream = %d bytes\n", uJpgSize);

			// Decoding
			eRawImgFormat = CRYCBY;
			uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

			JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
			//JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eJpgFormat, uJpgAddr, uRawImgAddr);
			
			WaitForSet(bJpegDone);

			JPEG_GetFormat();
			JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
				UART_Printf("Hsz = %d, Vsz = %d => ", uRawImgHSz_Dec, uRawImgVSz_Dec);

			JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
			{
				UART_Printf("Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 0	// LOCAL
				CI_InitIpForDinFout(
						uRawImgHSz_Dec, uRawImgVSz_Dec,
						0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
						uRawImgAddr, eRawImgFormat,		
						uLcdHSz, uLcdVSz, // Fifo out display size
						LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				Disp("\n Press any key to stop! \n");
				UART_Getc();
				FIMC_StopProcessing();
			
				#elif 1	// MEM TO MEM
				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
									0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
									uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
									uLcdFbAddr, RGB565, 
									ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
									

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
				UART_Getc();
				#endif
			}	
		}
	}

	// CASE 2
	// Raw input = RGB16, JPG = YUV422
	eRawImgFormat = RGB16, eJpgFormat=YCBYCR;
	UART_Printf("\n************************\n");	
	UART_Printf("RAW=RGB16, JPG = YUV422\n");
	UART_Printf("************************\n");
	
	for(uRawImgHsz_Enc=385 ; uRawImgHsz_Enc <=400 ; uRawImgHsz_Enc++)
	{
		for(uRawImgVsz_Enc=273 ; uRawImgVsz_Enc <= 288 ; uRawImgVsz_Enc++)
		{
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;

			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("\nOriginal X,Y = %d, %d => AfterCv X,Y = %d, %d ====> ", uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			
			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			//uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;
			
			eRawImgFormat = RGB16;
			uRawImgAddr =  uGlibAddr;
//			memset((void *)uJpgAddr, 0, uLcdHSz*uLcdVSz*4);
//			memset((void *)uRawImgAddr, 0, uLcdHSz*uLcdVSz*4);

				bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("\nEncoded Stream = %d bytes\n", uJpgSize);

			// Decoding
			eRawImgFormat = CRYCBY;
			uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

			JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
			
			WaitForSet(bJpegDone);

			JPEG_GetFormat();
			JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
				UART_Printf("Hsz = %d, Vsz = %d => ", uRawImgHSz_Dec, uRawImgVSz_Dec);

			JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
			{
				UART_Printf("Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 0	// LOCAL
				CI_InitIpForDinFout(
						uRawImgHSz_Dec, uRawImgVSz_Dec,
						0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
						uRawImgAddr, eRawImgFormat,		
						uLcdHSz, uLcdVSz, // Fifo out display size
						LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				Disp("\n Press any key to stop! \n");
				UART_Getc();
				FIMC_StopProcessing();
			
				#elif 1	// MEM TO MEM
				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
									0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
									uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
									uLcdFbAddr, RGB565, 
									ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
									

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
				UART_Getc();
				#endif
			}				
		}
	}			

	// CASE 3
	// Raw input = YUV422, JPG = YUV420
	eRawImgFormat = CRYCBY, eJpgFormat=YCBCR420_2P_CRCB_LE;
	UART_Printf("\n************************\n");
	UART_Printf("RAW=YUV422, JPG = YUV420\n");
	UART_Printf("************************\n");
	
	for(uRawImgHsz_Enc=385 ; uRawImgHsz_Enc <=400 ; uRawImgHsz_Enc++)
	{
		for(uRawImgVsz_Enc=273 ; uRawImgVsz_Enc <= 288 ; uRawImgVsz_Enc++)
		{
			eRawImgFormat = CRYCBY;
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;

			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("\nOriginal X,Y = %d, %d => AfterCv X,Y = %d, %d ====> ", uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			
			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			//Conversion RGB16 -> CRYCBY
			//jhy20090326
			//CI_xxx() -> FIMC_xx()
			FIMC_InitIpForDinDout(FIMC_A, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0,
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, uGlibAddr, RGB16,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0, // Scaler	
						uRawImgAddr, eRawImgFormat, 
						ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW,false);

						bProcessingDone = false;
			FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
			FIMC_WaitForProcessingDone(FIMC_A);	
			FIMC_StopProcessing(FIMC_A);

			uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;
			bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("\nEncoded Stream = %d bytes", uJpgSize);

			// Decoding
			eRawImgFormat = CRYCBY;
			uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

			JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
			
			WaitForSet(bJpegDone);

			JPEG_GetFormat();
			JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
				UART_Printf("Hsz = %d, Vsz = %d => ", uRawImgHSz_Dec, uRawImgVSz_Dec);

			JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
			{
				UART_Printf("Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 0	// LOCAL
				CI_InitIpForDinFout(
						uRawImgHSz_Dec, uRawImgVSz_Dec,
						0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
						uRawImgAddr, eRawImgFormat,		
						uLcdHSz, uLcdVSz, // Fifo out display size
						LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				Disp("\n Press any key to stop! \n");
				UART_Getc();
				FIMC_StopProcessing();
			
				#elif 1	// MEM TO MEM
				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
									0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
									uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz, 0,// Scaler	
									uLcdFbAddr, RGB565, 
									ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
									

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
				UART_Getc();
				#endif

			}				
		}
	}		

	//CASE 4
	// Raw input = YUV422, JPG = YUV422
	eRawImgFormat = CRYCBY, eJpgFormat=YCBYCR;
	UART_Printf("\n************************\n");
	UART_Printf("RAW=YUV422, JPG = YUV420\n");
	UART_Printf("************************\n");
	
	for(uRawImgHsz_Enc=385 ; uRawImgHsz_Enc <=400 ; uRawImgHsz_Enc++)
	{
		for(uRawImgVsz_Enc=273 ; uRawImgVsz_Enc <= 288 ; uRawImgVsz_Enc++)
		{

			eRawImgFormat = CRYCBY;
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;

			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("\nOriginal X,Y = %d, %d => AfterCv X,Y = %d, %d ====> ", uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			
			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			//Conversion RGB16 -> CRYCBY
			//jhy20090326
			//CI_xxx() -> FIMC_xx()
			FIMC_InitIpForDinDout(FIMC_A, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp,0,
						0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, uGlibAddr, RGB16,
						uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0, 0, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, 0,// Scaler	
						uRawImgAddr, eRawImgFormat, 
						ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);

						bProcessingDone = false;
			FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
			FIMC_WaitForProcessingDone(FIMC_A);	
			FIMC_StopProcessing(FIMC_A);

			uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;
			bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("\nEncoded Stream = %d bytes\n", uJpgSize);

			// Decoding
			eRawImgFormat = CRYCBY;
			uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

			JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
			
			WaitForSet(bJpegDone);

			JPEG_GetFormat();
			JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
				UART_Printf("Hsz = %d, Vsz = %d => ", uRawImgHSz_Dec, uRawImgVSz_Dec);

			JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
			{
				UART_Printf("Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 0	// LOCAL
				CI_InitIpForDinFout(
						uRawImgHSz_Dec, uRawImgVSz_Dec,
						0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
						uRawImgAddr, eRawImgFormat,		
						uLcdHSz, uLcdVSz, // Fifo out display size
						LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				Disp("\n Press any key to stop! \n");
				UART_Getc();
				FIMC_StopProcessing();
			
				#elif 1	// MEM TO MEM
				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
									0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
									uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
									uLcdFbAddr, RGB565, 
									ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
									

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
				UART_Getc();
				#endif

			}				
		}
	}		

	INTC_Disable(NUM_JPEG);

}

static void TestAgingDecoding(void)
{

	u32 temp;
	u32 i;
	u32 uSelOutFmt;
	
	


	const char *pFileName = CAPTURED_JPEG;
	
	bIsOneStep = true;
	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr, &uJpgSize);

	UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr, uJpgSize);

	bIsJpgLoaded = true;

	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first!!\n");
		return;
	}
	while (true)
	{
		UART_Printf("\n[0] Exit\n");
		UART_Printf("[1] YUV420 \n");
		UART_Printf("[2] YUV422 \n");
		UART_Printf("\nEnter the Decoding output format: ");

		uSelOutFmt = UART_GetIntNum();

		if (uSelOutFmt == 0)
			return;
		else if (uSelOutFmt >=1 && uSelOutFmt <=2) 
		{
			eRawImgFormat =(uSelOutFmt == 1) ? YCBCR420_2P_CRCB_LE: CRYCBY;
			if(eRawImgFormat == YCBCR420_2P_CRCB_LE)
				UART_Printf("JpgOutFormat = YCBCR420\n");
			else
				UART_Printf("JpgOutFormat = YCBCR422\n");
			break;
		}
		else
			UART_Printf("Invalid Input! Retry It!!\n");
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);
	
	uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

	bJpegDone = false;

	JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr, uRawImgAddr);
	
	WaitForSet(bJpegDone);

	JPEG_GetFormat();
	JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

	JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
	{
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
	#if 1
		#if 0	// LOCAL
		CI_InitIpForDinFout(
				uRawImgHSz_Dec, uRawImgVSz_Dec,
				0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
				uRawImgAddr, eRawImgFormat,		
				uLcdHSz, uLcdVSz, // Fifo out display size
				LOCAL_IF_RGB24, PROGRESSIVE,
				ROT_NO_FLIP_NO, 0);

		FIMC_StartProcessing(false, 0, 0, false, 0);
		Disp("\n Press any key to stop! \n");
		UART_Getc();
		FIMC_StopProcessing();
	
		#elif 1	// MEM TO MEM

		GLIB_InitInstance(uGlibAddr, 320, 240, RGB16);
		GLIB_DrawPattern(320, 240);
	
		//jhy20090326
		//CI_xxx() -> FIMC_xx()
		FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
							0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eRawImgFormat,
							uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz, 0,// Scaler	
							uLcdFbAddr, RGB565, 
							ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
							

		bProcessingDone = false;
		FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
		FIMC_WaitForProcessingDone(FIMC_A);	
		FIMC_StopProcessing(FIMC_A);
		
		#endif
	#endif

	}

	bJpegDone = false;

	INTC_Disable(NUM_JPEG);

}

static void temp_test(void)
{
#if 0
    // Initialize LCDC v6.0

    LCDC_InitLdi(MAIN);
    //LCDC_InitIp(RGB16, uLcdOutFbAddr, WIN0, false); 
    LCDC_InitIp(RGB16, 0x27000000, WIN0, false); 
    LCDC_Start();

    //LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);
    //GLIB_InitInstance(uLcdFbAddr, 320, 240, RGB16); 
    GLIB_InitInstance(0x21000000, 320, 240, RGB16); 
    GLIB_FillRectangle(0,0,320,240,C_YELLOW);

    FIMC_InitIpForDinDout(320, 240,
					0, 0, 320, 240, 0x21000000, RGB565,
					4096, 4096, 0, 0, 4096, 4096, // Scaler 
					0x22000000, CRYCBY, ROT_NO_FLIP_NO, 0, false);

    FIMC_StartProcessing(false, 0, 0, false, 0);  
    FIMC_WaitForProcessingDone(); 
    FIMC_StopProcessing();

    FIMC_InitIpForDinDout(4096, 4096,
                        0, 0, 4096, 4096, 0x22000000, CRYCBY,
                        320, 240, 0, 0, 320, 240, // Scaler 
                        0x27000000, RGB565, ROT_NO_FLIP_NO, 0, false);

    FIMC_StartProcessing(false, 0, 0, false, 0);
    FIMC_WaitForProcessingDone();
    FIMC_StopProcessing();

#elif 1
	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	// CASE 1
	//eRawImgFormat = RGB16, eJpgFormat=YCBCR420_2P_CRCB_LE;
	eRawImgFormat = RGB16, eJpgFormat=YCBYCR;

	UART_Printf("\n************************\n");
	UART_Printf("RAW=RGB16, JPG = YUV422\n");
	UART_Printf("************************\n");
	
	for(uRawImgHsz_Enc=385 ; uRawImgHsz_Enc <=400 ; uRawImgHsz_Enc++)
	{
		for(uRawImgVsz_Enc=273 ; uRawImgVsz_Enc <= 288 ; uRawImgVsz_Enc++)
		{
			////////////
			// Encoding//
			////////////
			eRawImgFormat = RGB16;
			uRawImgHsz_EncTemp = uRawImgHsz_Enc;
			uRawImgVsz_EncTemp = uRawImgVsz_Enc;
		
			JPEG_GetEncodingImgSz(eJpgFormat, &uRawImgHsz_EncTemp, &uRawImgVsz_EncTemp);
			UART_Printf("\nOriginal X,Y = %d, %d => AfterCv X,Y = %d, %d ====> ", uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);

			GLIB_InitInstance(uGlibAddr, uRawImgHsz_EncTemp, uRawImgVsz_EncTemp, RGB16);
			GLIB_DrawPattern(uRawImgHsz_EncTemp, uRawImgVsz_EncTemp);
			GLIB_PutLine(0, 0, 0, uRawImgVsz_EncTemp-1, C_BLUE);

			uRawImgAddr = (eRawImgFormat == CRYCBY) ? uRawImgAddr : uGlibAddr;
			bJpegDone = false;
			JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
									uRawImgAddr, eRawImgFormat, uJpgAddr, eJpgFormat);
			WaitForSet(bJpegDone);	

			JPEG_GetStreamLen(&uJpgSize);
			UART_Printf("Encoded Stream = %d bytes\n", uJpgSize);

			////////////
			// Decoding//
			////////////			
			eJpgOutputType = CRYCBY;
			//eJpgOutputType = YCBCR420_2P_CRCB_LE;
			uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;

			JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eJpgOutputType, uJpgAddr, uRawImgAddr);
			
			WaitForSet(bJpegDone);

			JPEG_GetFormat();
			JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
				UART_Printf("Hsz = %d, Vsz = %d => ", uRawImgHSz_Dec, uRawImgVSz_Dec);

			JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

			if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
				UART_Printf("Error! Widht or Height is zero\n");
			else 
			{
				UART_Printf("Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
				#if 0	// LOCAL
				CI_InitIpForDinFout(
						uRawImgHSz_Dec, uRawImgVSz_Dec,
						0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec,
						uRawImgAddr, eRawImgFormat,		
						uLcdHSz, uLcdVSz, // Fifo out display size
						LOCAL_IF_RGB24, PROGRESSIVE,
						ROT_NO_FLIP_NO, 0);

				FIMC_StartProcessing(false, 0, 0, false, 0);
				//Disp("\n Press any key to stop! \n");
				//UART_Getc();
				//FIMC_StopProcessing();
			
				#elif 1	// MEM TO MEM
				//jhy20090326
				//CI_xxx() -> FIMC_xx()
				FIMC_InitIpForDinDout(FIMC_A, uRawImgHSz_Dec, uRawImgVSz_Dec,0,
									0, 0, uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eJpgOutputType,
									uLcdHSz, uLcdVSz, 0, 0, uLcdHSz, uLcdVSz,0, // Scaler	
									uLcdFbAddr, RGB565, 
									ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_NARROW, false);
				
				UART_Printf("uRawImgHSz_Dec =%d, uRawImgVSz_Dec=%d, uRawImgAddr=0x%x, eJpgOutputType=%d,	uLcdHSz=%d, uLcdVSz=%d, uLcdFbAddr=0x%x\n",
							uRawImgHSz_Dec, uRawImgVSz_Dec, uRawImgAddr, eJpgOutputType,	uLcdHSz, uLcdVSz, uLcdFbAddr);
									

				bProcessingDone = false;
				FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);	
				FIMC_WaitForProcessingDone(FIMC_A);	
				FIMC_StopProcessing(FIMC_A);
				#endif
			}	
			UART_Printf("press any keys....\n");
			UART_Getc();
			//FIMC_StopProcessing();
		}
	}

	bJpegDone = false;
	INTC_Disable(NUM_JPEG);
	
#endif


}


static void SaveRawImgToFile(void)
{
#if	 SEMIHOSTING
	SaveToFile(YUV_FILE_NAME, uRawImgHSz_Dec*uRawImgVSz_Dec*2, uRawImgAddr);
#else
	// Under Construction. SD will be used.
#endif
}

static void SaveJpegStreamToFile(void)
{

#if	 SEMIHOSTING
	SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr);
#else
	// Under Construction. SD will be used.
#endif

}

#if 0
u8 JPEG_AutoTest(void)
{
	char pType[30];
//	char pFileName[50];
	const char *pFileName = CAPTURED_JPEG;
	
	int sel, temp;
	u32 uTotalNumOfFiles, i;
	u32 compare_size;

	SDHC_InitCh(SDHC_CHANNEL_0, &oSdhc);

      //---------------  JPEG Basic Setting ----------------------------------------//
	temp = Inp32(0x7e00f020);					// 0x7e00f020 = CLK_DIV0
	Outp32(0x7e00f020, temp |(0x3<<24));			// JPEG_RATIO setting , 4 dividing (266/4 =66.5MHz)

	JPEG_Init();
	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;


	uLcdFbAddr = (u32)malloc(15000);
	uGlibAddr = (u32)malloc(15000);

//	uLcdFbAddr = CODEC_MEM_ST+0x3000000;
//	uGlibAddr = uLcdFbAddr + 240*320*4;

	
	uJpgAddr = CODEC_MEM_ST;

	eRawImgFormat = RGB16;

	uRawImgAddr = uJpgAddr + 0x1000000;

	uRawImgHsz_Enc = 320;
	uRawImgVsz_Enc = 240;

	bIsJpgLoaded = false;
	bIsOneStep = false;
//------------------------------------------------------------------------------------------//
#if	 SEMIHOSTING

	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr, &uJpgSize);

	UART_Printf(" Stream size = %d bytes\n", uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#else
	UART_Printf("Check Semihosting....\n");
#endif
//------------------------------------------------------------------------------------------//
	
#if !SEMIHOSTING	

	if (!SDHC_OpenMediaWithMode(4, SDHC_POLLING_MODE, SDHC_HCLK, 4, 1, &oSdhc) || !FAT_LoadFileSystem(&oSdhc))
		Assert(0);

	FAT_GetFileIndex("auto_test_image.jpg", &sel, &oSdhc);
		
	if (!FAT_ReadFile2(sel, uJpgAddr, &uJpgSize, &oSdhc))
		UART_Printf(" Loading failed ....\n");

	FAT_UnloadFileSystem(&oSdhc);
	SDHC_CloseMedia(&oSdhc);

	UART_Printf(" Stream size = %d bytes\n", uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#endif

	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first !!\n");
		return;
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	// Header Parsing
	bJpegDone = false;
	JPEG_StartParsingHeader(uJpgAddr);
	WaitForSet(bJpegDone);
	
	Assert(eJpgIrq == OK_HD_PARSING);

	JPEG_GetJpegType(pType);
	UART_Printf(" 1. Sub-Sampling Mode = %s\n", pType);

	JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
	
	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Width or Height is zero\n");
	else
		UART_Printf(" 2. Resolution : Width = %d, Height = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

	// Decoding body.
	uRawImgAddr = uJpgAddr+((uJpgSize+16)/16)*16;
	bJpegDone = false;
	JPEG_StartDecodingBody(uRawImgAddr, false);
	WaitForSet(bJpegDone);
	Assert(eJpgIrq == OK_ENC_OR_DEC);
	
	UART_Printf("JPEG Decoding Test Pass!!!\n");

	//UART_Printf("Encoding Start!!!\n");

	////////////////////////////////////////////////////////////
	
	bIsOneStep = false;	

	eJpgFormat = JPEG_422;

	uRawImgHsz_Enc = 1600;
	uRawImgVsz_Enc = 1200;
	
	Assert(eRawImgFormat == YCBYCR || eRawImgFormat == RGB16);

	bJpegDone = false;
	JPEG_StartEncodingOneFrame(uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgAddr, YCBYCR,
						  		 uJpgAddr, eJpgFormat);
	WaitForSet(bJpegDone);

	Assert(eJpgIrq == OK_ENC_OR_DEC);

	JPEG_GetStreamLen(&uJpgSize);

	if(compare_size == uJpgSize)
	{
		UART_Printf("JPEG Encoding Test Pass!!!\n");
		return true;
	}	
	else
	{
		UART_Printf("Jpeg Encoding Test Fail!!!!\n original size = %d bytes, encoding size = %d bytes\n", compare_size, uJpgSize);
		return false;
	}	

}
#endif

u8 JPEG_AutoTest(void)
{
	char pType[30];
	const char *pFileName = CAPTURED_JPEG;
	u32 *tmp;
	
	int sel, temp;
	u32 uTotalNumOfFiles, i;
	u32 compare_size;

      //---------------  JPEG Basic Setting ----------------------------------------//
//	temp = Inp32(0x7e00f020);					// 0x7e00f020 = CLK_DIV0
//	Outp32(0x7e00f020, temp |(0x3<<24));			// JPEG_RATIO setting , 4 dividing (266/4 =66.5MHz)

	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;



	
	uJpgAddr0 = CODEC_MEM_ST;
	uJpgAddr1 = CODEC_MEM_ST + 0x1000000;

	eRawImgFormat = RGB16;

	uRawImgAddr = uJpgAddr1 + 0x1000000;
	tmp =(u32*) uJpgAddr0;

	bIsJpgLoaded = false;
	bIsOneStep = false;

//------------------------------------------------------------------------------------------//
#if	 0

	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr0, &uJpgSize);

	UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr0, uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#else

	UART_Printf(" wait ...\n", pFileName);
	
	for(i=0;i<1600*1200;i++)
	{
		tmp[i] = race16001200_jpg[i];

	}
	compare_size = 0x2d809;
	bIsJpgLoaded = true;


#endif
//------------------------------------------------------------------------------------------//
	


	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first !!\n");
		return;
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	eRawImgFormat = CRYCBY; //YCBCR422


	// Header Parsing
	bJpegDone = false;

	JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr0, uRawImgAddr);
	
	WaitForSet(bJpegDone);
	

	JPEG_GetFormat();
	JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
	
	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

	JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

	if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
		UART_Printf("Error! Widht or Height is zero\n");
	else 
	{
		UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
	}
	

	bJpegDone = false;
	
	UART_Printf("JPEG Decoding Test Pass!!!\n");
	

	//UART_Printf("\nEncoding Start!!!\n");

	////////////////////////////////////////////////////////////
	
	bIsOneStep = false;	

	uRawImgHsz_Enc = 1600;
	uRawImgVsz_Enc = 1200;
	eJpgFormat = YCBYCR;
	
	Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

	bJpegDone = false;
	
	JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
							uRawImgAddr, eRawImgFormat, uJpgAddr1, eJpgFormat);
	WaitForSet(bJpegDone);

	JPEG_GetStreamLen(&uJpgSize);

	UART_Printf("JPEG Size 0x%x\n",uJpgSize);

	SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr1);
	
	if(compare_size == uJpgSize)
	{
		UART_Printf("JPEG Encoding Test Pass!!!\n");
		return true;
	}	
	else
	{
		UART_Printf("Jpeg Encoding Test Fail!!!!\n original size = %d bytes, encoding size = %d bytes\n", compare_size, uJpgSize);
		return false;
	}	


}
void JPEG_BlockPowerOnOff(void)
{
	char pType[30];
	const char *pFileName = CAPTURED_JPEG;
	u32 *tmp;
	
	int sel, temp;
	u32 uTotalNumOfFiles, i;
	u32 compare_size;

	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;
	
	uJpgAddr0 = CODEC_MEM_ST;
	uJpgAddr1 = CODEC_MEM_ST + 0x1000000;

	eRawImgFormat = RGB16;

	uRawImgAddr = uJpgAddr1 + 0x1000000;
	tmp =(u32*) uJpgAddr0;

	bIsJpgLoaded = false;
	bIsOneStep = false;

//------------------------------------------------------------------------------------------//
#if	 0

	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr0, &uJpgSize);

	UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr0, uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#else

	UART_Printf("[JPEG_BlockPowerOnOff]\n");
	UART_Printf(" wait ...\n", pFileName);
	
	for(i=0;i<1600*1200;i++)
	{
		tmp[i] = race16001200_jpg[i];

	}
	compare_size = 0x2d809;
	bIsJpgLoaded = true;


#endif
//------------------------------------------------------------------------------------------//
	


	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first !!\n");
		return;
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	eRawImgFormat = CRYCBY; //YCBCR422

	while(!UART_GetKey())
	{
		// Header Parsing
		bJpegDone = false;

		JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr0, uRawImgAddr);
		
		WaitForSet(bJpegDone);
		

		JPEG_GetFormat();
		JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
		
		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

		JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
		{
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
		}
		

		bJpegDone = false;
		
		UART_Printf("JPEG Decoding Test Pass!!!\n");
		

		//UART_Printf("\nEncoding Start!!!\n");

		////////////////////////////////////////////////////////////
		
		bIsOneStep = false;	

		uRawImgHsz_Enc = 1600;
		uRawImgVsz_Enc = 1200;
		eJpgFormat = YCBYCR;
		
		Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

		bJpegDone = false;
		
		JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
								uRawImgAddr, eRawImgFormat, uJpgAddr1, eJpgFormat);
		WaitForSet(bJpegDone);

		JPEG_GetStreamLen(&uJpgSize);

		UART_Printf("JPEG Size 0x%x\n",uJpgSize);

		SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr1);
		
		if(compare_size == uJpgSize)
		{
			UART_Printf("JPEG Encoding Test Pass!!!\n");
		//	return true;
		}	
		else
		{
			UART_Printf("Jpeg Encoding Test Fail!!!!\n original size = %d bytes, encoding size = %d bytes\n", compare_size, uJpgSize);
		//	return false;
		}	

		// T-Block Power Off and On
		SYSC_SetBlockPowerOFF_IP(eJPEG);
		//DelayfrTimer(milli, rand()%10);			// under 10ms
		DelayfrTimer(milli, SBLK_GetRand()%10);
		SYSC_SetBlockPowerON_IP(eJPEG);
		
	}


}
void JPEG_ClockOnOff(void)
{
	char pType[30];
	const char *pFileName = CAPTURED_JPEG;
	u32 *tmp;
	
	int sel, temp;
	u32 uTotalNumOfFiles, i;
	u32 compare_size;

	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;
	
	uJpgAddr0 = CODEC_MEM_ST;
	uJpgAddr1 = CODEC_MEM_ST + 0x1000000;

	eRawImgFormat = RGB16;

	uRawImgAddr = uJpgAddr1 + 0x1000000;
	tmp =(u32*) uJpgAddr0;

	bIsJpgLoaded = false;
	bIsOneStep = false;

//------------------------------------------------------------------------------------------//
#if	 0

	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr0, &uJpgSize);

	UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr0, uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#else
	UART_Printf("[JPEG_ClockOnOff]\n");
	UART_Printf(" wait ...\n", pFileName);
	
	for(i=0;i<1600*1200;i++)
	{
		tmp[i] = race16001200_jpg[i];

	}
	compare_size = 0x2d809;
	bIsJpgLoaded = true;


#endif
//------------------------------------------------------------------------------------------//
	


	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first !!\n");
		return;
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	eRawImgFormat = CRYCBY; //YCBCR422

	while(!UART_GetKey())
	{
		// Header Parsing
		bJpegDone = false;

//		JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr0, uRawImgAddr);

		Assert(uJpgAddr%16 == 0);		
		UART_Printf("Dec: jpeg=%08x, raw=%08x", uJpgAddr0, uRawImgAddr);
		JPEG_Reset();
		JPEG_CLK_Enable(JPEG_CLK_ON);
		JPEG_InitDecoding(JPEG_FULL_CLK, eRawImgFormat, uJpgAddr0, uRawImgAddr);
		
		// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eJPEG);
		//DelayfrTimer(milli, rand()%10);			// under 10ms
		DelayfrTimer(milli, SBLK_GetRand()%10);
		SYSC_SetClkON_IP(eJPEG);
		
		JPEG_Start();
		
		WaitForSet(bJpegDone);
		

		JPEG_GetFormat();
		JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
		
		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

		JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
		{
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
		}
		

		bJpegDone = false;
		
		UART_Printf("JPEG Decoding Test Pass!!!\n");
		
	
		//UART_Printf("\nEncoding Start!!!\n");

		////////////////////////////////////////////////////////////
		
		bIsOneStep = false;	

		uRawImgHsz_Enc = 1600;
		uRawImgVsz_Enc = 1200;
		eJpgFormat = YCBYCR;
		
		Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

		bJpegDone = false;


		
//		JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
//								uRawImgAddr, eRawImgFormat, uJpgAddr1, eJpgFormat);
		JPEG_Reset();
		JPEG_CLK_Enable(JPEG_CLK_ON);
		JPEG_InitForEncoding(JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc, uRawImgAddr, eRawImgFormat, uJpgAddr1, eJpgFormat);
		
		// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eJPEG);
		//DelayfrTimer(milli, rand()%10);			// under 10ms
		DelayfrTimer(milli, SBLK_GetRand()%10);
		SYSC_SetClkON_IP(eJPEG);
		
		JPEG_Start();
	
		WaitForSet(bJpegDone);

		JPEG_GetStreamLen(&uJpgSize);

		UART_Printf("JPEG Size 0x%x\n",uJpgSize);

		SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr1);
		
		if(compare_size == uJpgSize)
		{
			UART_Printf("JPEG Encoding Test Pass!!!\n");
		//	return true;
		}	
		else
		{
			UART_Printf("Jpeg Encoding Test Fail!!!!\n original size = %d bytes, encoding size = %d bytes\n", compare_size, uJpgSize);
		//	return false;
		}	

		
	}

}
void JPEG_PowerMode(void)
{
	char pType[30];
	const char *pFileName = CAPTURED_JPEG;
	u32 *tmp;
	
	int sel, temp;
	u32 uTotalNumOfFiles, i;
	u32 compare_size;

	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;
	
	uJpgAddr0 = CODEC_MEM_ST;
	uJpgAddr1 = CODEC_MEM_ST + 0x1000000;

	eRawImgFormat = RGB16;

	uRawImgAddr = uJpgAddr1 + 0x1000000;
	tmp =(u32*) uJpgAddr0;

	bIsJpgLoaded = false;
	bIsOneStep = false;

//------------------------------------------------------------------------------------------//
#if	 0

	UART_Printf(" Loading %s from PC ...\n", pFileName);
	LoadFromFile1(pFileName, uJpgAddr0, &uJpgSize);

	UART_Printf(" Stream add = 0x%x, size = %d bytes\n", uJpgAddr0, uJpgSize);
	compare_size = uJpgSize;
	bIsJpgLoaded = true;
#else

		UART_Printf("[JPEG_PowerMode]\n");
	UART_Printf(" wait ...\n", pFileName);
	
	for(i=0;i<1600*1200;i++)
	{
		tmp[i] = race16001200_jpg[i];

	}
	compare_size = 0x2d809;
	bIsJpgLoaded = true;


#endif
//------------------------------------------------------------------------------------------//
	


	if (bIsJpgLoaded == false)
	{
		UART_Printf("ERROR! Load a raw image first !!\n");
		return;
	}

	INTC_Init();
	INTC_SetVectAddr(NUM_JPEG, Isr_Jpeg);
	INTC_Enable(NUM_JPEG);

	eRawImgFormat = CRYCBY; //YCBCR422

	while(!UART_GetKey())
	{
		// Header Parsing
		bJpegDone = false;

		JPEG_InitDecodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, eRawImgFormat, uJpgAddr0, uRawImgAddr);
		
		//DelayfrTimer(micro, rand()%20);
		DelayfrTimer(milli, SBLK_GetRand()%20);
		// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
		//SYSCT_TestSimplePowerMode_Temp(rand()%6+1);		
		SYSCT_TestSimplePowerMode_Temp(SBLK_GetRand()%6+1);	
		
		WaitForSet(bJpegDone);
		

		JPEG_GetFormat();
		JPEG_GetWidthAndHeight(&uRawImgHSz_Dec, &uRawImgVSz_Dec);
		
		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);

		JPEG_GetDecodedImgSz(&uRawImgHSz_Dec, &uRawImgVSz_Dec);

		if ( uRawImgHSz_Dec == 0 || uRawImgVSz_Dec == 0 )
			UART_Printf("Error! Widht or Height is zero\n");
		else 
		{
			UART_Printf(" Hsz = %d, Vsz = %d\n", uRawImgHSz_Dec, uRawImgVSz_Dec);
		}
		

		bJpegDone = false;
		
		UART_Printf("JPEG Decoding Test Pass!!!\n");
		

		////////////////////////////////////////////////////////////
		
		bIsOneStep = false;	

		uRawImgHsz_Enc = 1600;
		uRawImgVsz_Enc = 1200;
		eJpgFormat = YCBYCR;
		
		Assert(eRawImgFormat == CRYCBY || eRawImgFormat == RGB16);

		bJpegDone = false;
		
		JPEG_InitEncodingAndStart(JPEG_CLK_ON, JPEG_FULL_CLK, uRawImgHsz_Enc, uRawImgVsz_Enc,
								uRawImgAddr, eRawImgFormat, uJpgAddr1, eJpgFormat);

		//DelayfrTimer(micro, rand()%20);
		DelayfrTimer(milli, SBLK_GetRand()%20);
		// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
		//SYSCT_TestSimplePowerMode_Temp(rand()%6+1);		
		SYSCT_TestSimplePowerMode_Temp(SBLK_GetRand()%6+1);		
		//UART_Printf("\nEncoding Start!!!\n");
		
		WaitForSet(bJpegDone);

		JPEG_GetStreamLen(&uJpgSize);

		UART_Printf("JPEG Size 0x%x\n",uJpgSize);

		SaveToFile(SAVE_JPEG, uJpgSize, uJpgAddr1);
		
		if(compare_size == uJpgSize)
		{
			UART_Printf("JPEG Encoding Test Pass!!!\n");
		//	return true;
		}	
		else
		{
			UART_Printf("Jpeg Encoding Test Fail!!!!\n original size = %d bytes, encoding size = %d bytes\n", compare_size, uJpgSize);
		//	return false;
		}	

		
	}
}

const AutotestFuncMenu JPEG_ETC_menu[]=
{
	JPEG_BlockPowerOnOff,					"JPEG Block Power On/Off",
	JPEG_ClockOnOff,						"JPEG Clock On/Off",
	JPEG_PowerMode,						"JPEG Power Mode",
	0,0
};

u32 JPEG_ETCTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;
	s32 sSel;
	
	while (true)
	{
		UART_Printf("\n");
		UART_Printf("\n");
		for ( i=0; (int)(JPEG_ETC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, JPEG_ETC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(JPEG_ETC_menu)/8-1))
			(JPEG_ETC_menu[sSel].func) (eTest_Manual, oPara);
	}


	return OK;
}

void InitSysconForJPEG(void)
{
	SYSC_SetBlockPowerOFF_IP(eJPEG);	
	DelayfrTimer(milli, 100);
	SYSC_SetBlockPowerON_IP(eJPEG);
	DelayfrTimer(milli, 100);

	SYSC_SetClkOFF_IP(eJPEG);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eJPEG);
	DelayfrTimer(milli, 100);
	

}
void JPEG_Test(void)
{
	int i, sel;
	u32 temp;

	const testFuncMenu menu[]=
	{
		0,                                  		"Exit",
		TestSfr,						"Test SFR",
		GetJpegStreamFromPc,		"Load Jpg File from PC",
		//GetJpegStreamFromSd,		"Load Jpg File from SD",
		TestEncoding,				"Encoding test (with Image)",	
		TestEncodingForOddInputImage, "Encoding test for odd input image",
		TestDecoding,				"Decoding Test with LCD Display",
		TestDecodingForOddInputImage, "Decoding Test with LCD Display for odd input image",
		TestAgingEncoding,			"Aging Encoding Test",
		TestAgingDecoding,			"Aging Decoding Test",
		SaveRawImgToFile,			"Save Raw Image",
		SaveJpegStreamToFile,		"Save Jpg file to PC",
		temp_test,					"Encoding + Decoding Test with LCD Display",
		JPEG_AutoTest,				"Auto Test",
		JPEG_ETCTest,				"ETC Test",
		//TestDscSubsys,				"Camera Capture test",
		//TestJpegPerformance,		"JPG Performance Test",
		//JPEG_AutoTest,				"Auto Test (JPEG)\n",
		0,0
	};

	eJpgFormat = JPEG_422;
	eLcdBpp = RGB16;

#if 0
	uLcdFbAddr = CODEC_MEM_ST+0x2000000;
	uGlibAddr = uLcdFbAddr + 240*320*4;
	uJpgAddr = CODEC_MEM_ST;
#else
	uLcdFbAddr = _DRAM0_BaseAddress+0x2000000;
	uGlibAddr = uLcdFbAddr + 240*320*4;
	uJpgAddr = _DRAM0_BaseAddress;
#endif

	eRawImgFormat = RGB16;
	uRawImgAddr = uJpgAddr + 0x1000000;

	uRawImgHsz_Enc = 320;
	uRawImgVsz_Enc = 240;

	bIsJpgLoaded = false;
	bIsOneStep = false;

	SYSC_InitClkForMM();	
	InitSysconForJPEG();
	
	//FIMC_SetChA();
	
	#if 1	//S5PV210
	SYSC_SetDispPath(eDISP_BYPASS);
//	IEIP_Select(DISP_BYPASS);
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eLcdBpp, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, WIN0);

#if 0
	GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, RGB16);
	GLIB_DrawPattern(uLcdHSz, uLcdVSz);
	GLIB_PutLine(0, 0, 0, uLcdVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)WIN0);	
#endif

	#else

	GLIB_InitInstance(uLcdFbAddr, 320, 240, RGB16);
	GLIB_DrawPattern(320, 240);
	GLIB_PutLine(0, 0, 0, 320-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)WIN0);	

	#endif
	

	LCDC_Start();

	while(1)
	{
		UART_Printf("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++) {
			UART_Printf("%2d: %s\n", i, menu[i].desc);
		}

		UART_Printf("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		UART_Printf("\n");

		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func) ();
	}
}

