
#ifndef __JPEG_H__
#define __JPEG_H__


typedef enum
{
	JPEG_CLK_OFF, JPEG_CLK_ON
}JPEG_CLK_ON_OFF;

typedef enum
{
	JPEG_FULL_CLK, JPEG_HALF_CLK
}JPEG_CLK;


typedef enum
{
	JPEG_420, JPEG_422, JPEG_444, JPEG_400
} JPEG_TYPE;

typedef enum
{
	ERR_ENC_OR_DEC, OK_HD_PARSING=0x08,ERR_HD_PARSING1,ERR_HD_PARSING2,OK_ENC_OR_DEC=0x40,
} JPEG_IRQSTATUS;

typedef enum
{
	JPEG_DONE=0x0, JPEG_RUNNING=0x1,
} JPEG_STATUS;


void JPEG_Init(void);

void JPEG_CLK_Enable(JPEG_CLK_ON_OFF eJpgClkOn);

void JPEG_Reset(void);
void JPEG_Start(void);
void JPEG_Wait_Done(void);

void JPEG_GetFormat(void);
void JPEG_GetEncodingImgSz(IMG_FMT eJpgOutFmt, u32* uHsize, u32* uVsize);
void JPEG_GetDecodedImgSz(u32* uHsize, u32* uVsize);
void JPEG_GetJpegType(char * pType);
void JPEG_GetStreamLen(u32* uSize);
void JPEG_GetWidthAndHeight(u32* hsz, u32* vsz);

//void JPEG_ReadStatus(JPEG_STATUS* eStatus, JPEG_IRQSTATUS* eIrqStatus);
void JPEG_ReadStatus(JPEG_IRQSTATUS* eIrqStatus);
void JPEG_IntClear(void);
void JPEG_SetNextFrameStartAddr(u32 uAddr);


void JPEG_InitRegsForEncoding(	u32 uHSz, u32 uVsz, u32 uSrcAddr, IMG_FMT eRawType, u32 uDstAddr, JPEG_TYPE eJpgType);
void JPEG_StartEncodingOneFrame(u16 usHSz, u16 usVSz, u32 uSrcAddr, IMG_FMT eRawType,	u32 uDestAddr, JPEG_TYPE eJpgType);

void JPEG_InitForEncoding(JPEG_CLK eJpgClk, u16 uRawHsz, u16 uRawVsz, u32 uRawAddr, IMG_FMT eRawType, u32 uJpgAddr, JPEG_TYPE uJpgType);
void JPEG_InitEncodingAndStart(JPEG_CLK_ON_OFF eJpgClkOn, JPEG_CLK eJpgClk, u16 usHSz, u16 usVSz, 
									u32 uSrcAddr, IMG_FMT eRawType, u32 uDestAddr, JPEG_TYPE eJpgType);


void JPEG_InitRegsForDecoding(	u32 uSrcAddr, u32 uDstAddr);
void JPEG_StartDecodingOneFrame(u32 uJpgAddr, u32 uRawAddr);

void JPEG_InitDecoding(JPEG_CLK eJpgClk, IMG_FMT eRawType, u32 uSrcAddr, u32 uDstAddr);
void JPEG_InitDecodingAndStart(JPEG_CLK_ON_OFF eJpgClkOn, JPEG_CLK eJpgClk, IMG_FMT eRawType, u32 uJpgAddr, u32 uRawAddr);

void JPEG_StartParsingHeader(u32 uJpgAddr);
void Jpeg_to_hex_Conversion(u32 size, u32* addr);
//void JPEG_StartDecodingBody(u32 uRawAddr, u8 bIsIncremental);
	
#endif // __JPEG_H__

