/*----------------------------------------------------------------------
 *
 * Filename: jpeg.c
 *
 * Contents:
 *
 * History: 

 	1. 081223
 	    - BASIC fucntion edited
     	    - Deleted no used  fucntion
 
 * Contributors:
 *
 * Copyright (c) 2003 SAMSUNG Electronics.
 *
 *----------------------------------------------------------------------
 */

#include <string.h>
#include <stdio.h>
#include "system.h"
#include "jpeg.h"
#include "jpeg_tables.h"

#include "option.h"
#include "library.h"
#include "v210_sfr.h"

enum JPEG_REG
{
	rJPGMOD	= (JPEG_BASE+0x000),		/* SUB-SAMPLING MODE REG */
	rJPGOPR		= (JPEG_BASE+0x004),		/* OPERATION STATUS REG */
	rJPGQTBL	= (JPEG_BASE+0x008),
	rJPGHTBL	= (JPEG_BASE+0x00C),
	

	rJPGDRI_U	= (JPEG_BASE+0x010),
	rJPGDRI_L	= (JPEG_BASE+0x014),
	rJPGY_U		= (JPEG_BASE+0x018),
	rJPGY_L		= (JPEG_BASE+0x01C),

	rJPGX_U		= (JPEG_BASE+0x020),
	rJPGX_L		= (JPEG_BASE+0x024),
	rJPGCNT_U	= (JPEG_BASE+0x028),
	rJPGCNT_M	= (JPEG_BASE+0x02C),
	
	rJPGCNT_L	= (JPEG_BASE+0x030),
	rJPGINTSE	= (JPEG_BASE+0x034),
	rJPGINTST	= (JPEG_BASE+0x038),
	rJPGCOM	= (JPEG_BASE+0x04c),
	
	rJPGIMGADR	= (JPEG_BASE+0x050),
	rJPGADR		= (JPEG_BASE+0x058),
	rJPGCOEF1	= (JPEG_BASE+0x05C),
	
	rJPGCOEF2	= (JPEG_BASE+0x060),
	rJPGCOEF3	= (JPEG_BASE+0x064),
	rJPGCMOD	= (JPEG_BASE+0x068),
	rJPGCLKCON	= (JPEG_BASE+0x06C),
	
	rJPGJSTART		= (JPEG_BASE+0x070),
	rJPGFRSTART	= (JPEG_BASE+0x074),
	rJPGSW_RESET	= (JPEG_BASE+0x078),
	rJPGTIMER_SE	= (JPEG_BASE+0x07C),
	
	rJPGTIMER_ST	= (JPEG_BASE+0x080),
	rJPGCOMSTAT	= (JPEG_BASE+0x084),
	rJPGOUTFORM	= (JPEG_BASE+0x088),
	rJPGVERSION	= (JPEG_BASE+0x08C),
	
	rJPGDEC_STREAM_SIZE	= (JPEG_BASE+0x094),
	rJPGENC_STREAM_INTSE	= (JPEG_BASE+0x098),
	rJPGENC_STREAM_INTST	= (JPEG_BASE+0x09C),

	rJPGQTBL0        = (JPEG_BASE+0x400),
	rJPGQTBL1        = (JPEG_BASE+0x500),
	rJPGQTBL2        = (JPEG_BASE+0x600),
	rJPGQTBL3        = (JPEG_BASE+0x700),
	
	rJPGHDCTBL0      = (JPEG_BASE+0x800),
	rJPGHDCTBLG0    = (JPEG_BASE+0x840),
	rJPGHACTBL0      = (JPEG_BASE+0x880),
	rJPGHACTBLG0    = (JPEG_BASE+0x8c0),
	
	rJPGHDCTBL1      = (JPEG_BASE+0xc00),
	rJPGHDCTBLG1    = (JPEG_BASE+0xc40),
	rJPGHACTBL1      = (JPEG_BASE+0xc80),
	rJPGHACTBLG1    = (JPEG_BASE+0xcc0)
};

// Coefficients for RGB to YUV
#define COEF1_RGB_2_YUV         0x4D971E
#define COEF2_RGB_2_YUV         0x2C5783
#define COEF3_RGB_2_YUV         0x836E13


void Jpeg_to_hex_Conversion(u32 size, u32* addr)
{
	u32 * uJpgAddrptr;
	u32 i;
	
	uJpgAddrptr = addr;	
	
	for( i = 0; i < size/4+1; i++)	//word 
	{

		if(i%10 == 0)
			UART_Printf("\n");

			UART_Printf("0x%x, ",*uJpgAddrptr++);

		
	}
	
}

void JPEG_CLK_Enable(bool cOnoFF)
{
	Outp32(rJPGCLKCON, (cOnoFF== JPEG_CLK_ON)? (0x1) : (0x0));		// 
}


void JPEG_Reset(void)
{
	Outp32(rJPGSW_RESET, 1); //0: enable, 1: disable(default value)
}

void JPEG_Start(void)
{
	Outp32(rJPGJSTART, 1);
}

void JPEG_Wait_Done(void)
{
	u32 temp;

	do{
		temp = Inp32(rJPGOPR);
		//UART_Printf("jpgsts = 0x%x	",temp);
	}while(temp);
}

void JPEG_GetJpegType(char* pType)
{
	u32 uSampleMode;
	uSampleMode = (Inp32(rJPGMOD) & 0x07);

	if (uSampleMode == 0)
		strcpy(pType, "JPEG 444");
	else if (uSampleMode == 1)
		strcpy(pType, "JPEG 422");
	else if (uSampleMode == 2)
		strcpy(pType, "JPEG 420");
	else if (uSampleMode == 3)
		strcpy(pType, "JPEG 400 (Gray)");
	/*
	else if (uSampleMode == 6)
		strcpy(pType, "JPEG 411");
	*/
	else
		Assert(0);
}

void JPEG_GetStreamLen(u32* uSize)
{
	*uSize = ((Inp32(rJPGCNT_U)<<16)|(Inp32(rJPGCNT_M)<<8)|(Inp32(rJPGCNT_L)<<0));
}

void JPEG_GetWidthAndHeight(u32* hsz, u32* vsz)
{
	*hsz = ((Inp32(rJPGX_U)<<8)|Inp32(rJPGX_L));
	*vsz = ((Inp32(rJPGY_U)<<8)|Inp32(rJPGY_L));
}


#if 0 
void JPEG_ReadStatus(JPEG_STATUS* eStatus, JPEG_IRQSTATUS* eIrqStatus)
{
	u32 uIntEn;
	u32 uStatus;
	u32 uJpgStsReg;
	
	uJpgStsReg = Inp32(rJPGOPR);
	UART_Printf("1: JPGOPR = 0x%x\n",uJpgStsReg);

	*eStatus = uJpgStsReg;

	uStatus = Inp32(rJPGINTST);
	uStatus &= ((1<<6)|(1<<4));

	*eIrqStatus = uStatus;
 }
#else
 
void JPEG_ReadStatus(JPEG_IRQSTATUS* eIrqStatus)
{
	u32 uIntEn;
	u32 uStatus;
	u32 uJpgStsReg;

	uStatus = Inp32(rJPGINTST);
	uStatus &= ((1<<6)|(1<<5));

	*eIrqStatus = uStatus;
 }

u32 JPEG_ReadStatus_Timer(void)
{
	u32 uStatus;

	uStatus = Inp32(rJPGTIMER_ST);
	uStatus &= 1<<31;

	return uStatus;
 }

#endif

void JPEG_Timer_On(void)
{
	u32 uStatus;

	uStatus = Inp32(rJPGTIMER_SE);
	uStatus &= 1<<31;
	Outp32(rJPGTIMER_SE, uStatus);
}

void JPEG_Timer_Off(void)
{
	u32 uStatus;

	uStatus = Inp32(rJPGTIMER_SE);
	uStatus &= 0<<31;
	Outp32(rJPGTIMER_SE, uStatus);

}

void JPEG_Timer_Set(u32 count)
{
	u32 uStatus;

	uStatus = Inp32(rJPGTIMER_SE);
	
	Assert(count<0x7fffffff);
	
	uStatus &= count<<0;
	Outp32(rJPGTIMER_SE, uStatus);
	
}

void JPEG_IntClear(void)
{
	Outp32(rJPGCOM, 0x4);
}

void JPEG_GetFormat(void)
{
	u32 uColorFmtRegVal;
	
	uColorFmtRegVal = Inp32(rJPGMOD);
	uColorFmtRegVal = uColorFmtRegVal & 0x7;

	switch(uColorFmtRegVal)
	{
		case 0x0: // JPEG444 (8x8)
			UART_Printf("    YUV 4:4:4 Format\n");	break;
		case 0x1: // JPEG422 (16x8)
			UART_Printf("    YUV 4:2:2 Format\n");	break;
		case 0x2: // JPEG420 (16x16)
			UART_Printf("    YUV 4:2:0 Format\n");	break;
		case 0x3: // JPEG400(Gray) (8x8)
			UART_Printf("    GRAY Format\n");	break;
		default:
			UART_Printf("    Unknown Format\n");	break;
			//Assert(0);
			break;
	}
}

//YCBYCR: YCBCR420_2P_CRCB_LE; // YCBCR420_2P_CRCB_LE: YCBCR422_1P_CRYCBY NV12


void JPEG_GetEncodingImgSz(IMG_FMT eJpgOutFmt, u32* uHsize, u32* uVsize)
{	
	switch(eJpgOutFmt)
	{
		case YCBYCR: // JPEG422 (16x8)
			if((*uHsize%16) != 0)
			{
				//*uHsize = *uHsize - (16-(*uHsize%16));
				*uHsize = *uHsize -(*uHsize%16)+16;
			}
			if((*uVsize%8) != 0)
			{
				//*uVsize = *uVsize - (8-(*uVsize%8));
				*uVsize = *uVsize -(*uVsize%8)+8;
			}		
			break;
		case YCBCR420_2P_CRCB_LE: // JPEG420 (16x16)
			if((*uHsize%16) != 0)
			{
				//*uHsize = *uHsize - (16-(*uHsize%16));
				*uHsize = *uHsize - (*uHsize%16)+16;
			}
			if((*uVsize%16) != 0)
			{
				//*uVsize = *uVsize - (16-(*uVsize%16));
				*uVsize = *uVsize - (*uVsize%16)+16;
			}
			break;
		default:
			//Assert(0);
			break;
	}
}

void JPEG_GetDecodedImgSz(u32* uHsize, u32* uVsize)
{	
	u32 uColorFmtRegVal;
	
	//JPEG_GetWidthAndHeight(uHsize, uVsize);

	uColorFmtRegVal = Inp32(rJPGMOD);
	uColorFmtRegVal = uColorFmtRegVal & 0x7;

	switch(uColorFmtRegVal)
	{
		case 0x0: // JPEG444 (8x8)
			if((*uHsize%8) != 0)
			{
				*uHsize = *uHsize + (8-(*uHsize%8));
			}
			if((*uVsize%8) != 0)
			{
				*uVsize = *uVsize + (8-(*uVsize%8));
			}
			break;
		case 0x1: // JPEG422 (16x8)
			if((*uHsize%16) != 0)
			{
				*uHsize = *uHsize + (16-(*uHsize%16));
			}
			if((*uVsize%8) != 0)
			{
				*uVsize = *uVsize + (8-(*uVsize%8));
			}		
			break;
		case 0x2: // JPEG420 (16x16)
			if((*uHsize%16) != 0)
			{
				*uHsize = *uHsize + (16-(*uHsize%16));
			}
			if((*uVsize%16) != 0)
			{
				*uVsize = *uVsize + (16-(*uVsize%16));
			}
			break;
		case 0x3: // JPEG400(Gray) (8x8)
			if((*uHsize%8) != 0)
			{
				*uHsize = *uHsize + (8-(*uHsize%8));
			}
			if((*uVsize%8) != 0)
			{
				*uVsize = *uVsize + (8-(*uVsize%8));
			}
			break;
		default:
			//Assert(0);
			break;
	}
}

void JPEG_InitForEncoding(JPEG_CLK eJpgClk, u16 uRawHsz, u16 uRawVsz, u32 uRawAddr, IMG_FMT eRawType, u32 uJpgAddr, JPEG_TYPE uJpgType)
{
	u32 i, uJpgCModeTemp, uJpgCModereg;

	Assert(eRawType == CRYCBY || eRawType == RGB16);

	uJpgCModereg = Inp32(rJPGCMOD);
	uJpgCModeTemp = (eRawType == CRYCBY)? (0x1<<5) : (0x2<<5);	
	uJpgCModereg = ((uJpgCModereg & 0xf)|eJpgClk|uJpgCModeTemp);
	Outp32(rJPGCMOD, uJpgCModereg);

	Outp32(rJPGMOD, (uJpgType == YCBYCR)? (0x1<<0) : (0x2<<0));		// Encoded to yuv422 or yuv420
	Outp32(rJPGDRI_L, 2);		// MCU inserts RST marker LOWER BYTE
	Outp32(rJPGDRI_U, 0);		// MCU inserts RST marker 

	Outp32(rJPGQTBL, 0x0);
	Outp32(rJPGHTBL, 0x0);	//+daedoo
	
	Outp32(rJPGY_U, (uRawVsz>>8));
	Outp32(rJPGY_L, uRawVsz);
	Outp32(rJPGX_U, (uRawHsz>>8));
	Outp32(rJPGX_L, uRawHsz);

	Outp32(rJPGIMGADR, uRawAddr); // Address of input image
	Outp32(rJPGADR, uJpgAddr); // Address of JPEG stream

	Outp32(rJPGCOEF1, COEF1_RGB_2_YUV); // Coefficient value 1 for RGB to YCbCr
	Outp32(rJPGCOEF2, COEF2_RGB_2_YUV); // Coefficient value 2 for RGB to YCbCr
	Outp32(rJPGCOEF3, COEF3_RGB_2_YUV); // Coefficient value 3 for RGB to YCbCr


	//+ daedoo
	Outp32(rJPGINTSE, 0xe0);
	//Outp32(rJPGENC_STREAM_INTSE, 0x1ffffe0);

	// Quantiazation and Huffman Table setting
	for (i=0; i<64; i++)
		Outp32((rJPGQTBL0+i*4), (u32)QTBL0[i]);

	for (i=0; i<64; i++)
		Outp32((rJPGQTBL1+i*4), (u32)std_chrominance_quant_tbl_plus[i]);

	for (i=0; i<16; i++)
		Outp32((rJPGHDCTBL0+i*4), (u32)HDCTBL0[i]);

	for (i=0; i<12; i++)
		Outp32((rJPGHDCTBLG0+i*4), (u32)HDCTBLG0[i]);

	for (i=0; i<16; i++)
		Outp32((rJPGHACTBL0+i*4), (u32)HACTBL0[i]);

	for (i=0; i<162; i++)
		Outp32((rJPGHACTBLG0+i*4), (u32)HACTBLG0[i]);
	
}

void JPEG_InitDecoding(JPEG_CLK eJpgClk, IMG_FMT eRawType, u32 uSrcAddr, u32 uDstAddr)
{
	u32 i, uJpgCModereg;

	Outp32(rJPGMOD, 0x8); // Process mode: Decoding		
	
	uJpgCModereg = Inp32(rJPGCMOD);
	//uJpgCModeTemp = (eRawType == YCBYCR)? (0x1<<5) : (0x2<<5);
	uJpgCModereg = ((uJpgCModereg & 0xf)|eJpgClk);
	Outp32(rJPGCMOD, uJpgCModereg);
	//Outp32(rJPGCMOD, 0x20);
	// Outp32(rJPGCMOD, 0x21);

	Outp32(rJPGINTSE, 0xe0); // JPGIRQEN[6:3]=For several error conditions @2006.6.8	
	//Outp32(rJPGINTSE, 0x0); // IRQ Disable
	
	//Outp32(rJPGMOD, (eRawType == JPEG_422)? (0x1<<0) : (0x2<<0));		// Encoded to yuv422 or yuv420
	//Outp32(rJPGOUTFORM, (eRawType == YCBCR420_2P_CRCB_LE)? (0x1<<0) : (0x2<<0));	// YCbCr 420
	Outp32(rJPGOUTFORM, (eRawType == YCBCR420_2P_CRCB_LE) ? 0x1 : 0x0);	// YCbCr 420
	//Outp32(rJPGCLKCON, 0x1);	// JPEG CLK & POWER ON
	
	//Outp32(rJPGOUTFORM, 0x1);	// YCbCr 420
	//Outp32(rJPGOUTFORM, 0x0);	// YCbCr 422
	//Outp32(rJPGOUTFORM, (uJpgType == JPEG_422)? (0x1<<0) : (0x2<<0));		// Encoded to yuv422 or yuv420
	//CSPACE eRawType
	Outp32(rJPGIMGADR, uDstAddr); // Address of compresed input data
	Outp32(rJPGADR, uSrcAddr); // Address of decompresed image
}

void JPEG_InitDecodingAndStart(JPEG_CLK_ON_OFF eJpgClkOn, JPEG_CLK eJpgClk, IMG_FMT eRawType, u32 uJpgAddr, u32 uRawAddr)
{
	Assert(uJpgAddr%16 == 0);
	
	UART_Printf("Dec: jpeg=%08x, raw=%08x", uJpgAddr, uRawAddr);

	JPEG_Reset();
	JPEG_CLK_Enable(eJpgClkOn);	
	JPEG_InitDecoding(eJpgClk, eRawType, uJpgAddr, uRawAddr);
	JPEG_Start();

}

void JPEG_InitEncodingAndStart(JPEG_CLK_ON_OFF eJpgClkOn, JPEG_CLK eJpgClk, u16 usHSz, u16 usVSz, 
									u32 uSrcAddr, IMG_FMT eRawType, u32 uDestAddr, JPEG_TYPE eJpgType)
{
	//Assert(eRawType == YCBYCR || eRawType == RGB16);

	JPEG_Reset();
	JPEG_CLK_Enable(eJpgClkOn);
	JPEG_InitForEncoding(eJpgClk, usHSz, usVSz, uSrcAddr, eRawType, uDestAddr, eJpgType);
	JPEG_Start();
}


