#include <string.h>

#include "def.h"
#include "option.h"
#include "library.h"
#include "sysc.h"
#include "system.h"

#include "lcd.h"
#include "glib.h"
#include "intc.h"

#include "util.h"
#include "ipc.h"
#include "fimc.h"
#include "timer.h"

#include <string.h>

#include "def.h"
#include "option.h"
#include "library.h"

#include "lcd.h"
#include "glib.h"
#include "intc.h"
#include "sblock.h"

#include "util.h"
#include "ipc.h" 
#include "fimc.h"
#include "ipc_sfr.h"


//#define FIMC_POLLING

static CAMERA eCamera;
static FIMC_CH eFimc;
static CIS_MODEL eCisModel;
static CSC_EQUATION eCscEquation;
static YCBCR_RANGE eYCbCrRange;
static LOCAL_IF_TYPE eLocalInCS;



static u32 uLcdHSz, uLcdVSz;

static IMG_FMT eBpp;
static u32 uLcdFbAddr;
static u32 uInFbAddr;
static u32 uOutFbAddr;
static u32 uLcdOutFbAddr;

// =====
static TEST_PATTERN eTestPattern; // Set test pattern

static IMG_FMT eBppInFmt; // Set input image format

static u32 uInImgHsz, uInImgVsz; // Set input image size

// Set cropping region
static u32 uInImgCropStartX, uInImgCropStartY;
static u32 uInImgCropHsz, uInImgCropVsz;

static u32 uOutImgHsz, uOutImgVsz; // Set scaler

static ROT_FLIP eRotFlip; // Set rotator & flip

static IMG_FMT eBppOutFmt; // Set output image format

static u32 uOutDispHsz, uOutDispVsz; // Set output display size

static u32 uOutImgStartX, uOutImgStartY; // Set output offset

static SCAN_MODE eScanMode; // Set FIFO-out scan mode

static DMA_OUT_MODE eDmaOutMode; // Set FIFO-in DMA-out mode

// Set image effect
static IMG_EFF eImgEff;
static u32 uCbVal, uCrVal;

// Set capture frame control
static bool bCptFrmCtrl;
static u32 uCptSeqPattern, uCptSeqPointer;
// Set capture count control
static bool bCptCntCtrl;
static u32 uCptCnt;

static u32 uLcdFbAddr = CODEC_MEM_ST;
static u32 uInFbAddr = CODEC_MEM_ST + 0x00300000;
static u32 uOutFbAddr = CODEC_MEM_ST + 0x00300000 + 0x05000000;
static u32 uLcdOutFbAddr = CODEC_MEM_ST + 0x00300000 + 0x05000000 + 0x00300000;

static bool volatile bProcessingDone;


void RPRINTF_Isp(REGINFO sReg, u32 uPattern, u8 uRegStatus, s32 Nth,u8 uInDetail)
{

	if(uInDetail)
		UART_Printf("\n%20s (0x%08X): Pattern 0x%08X, Read 0x%08X", sReg.name, sReg.uAddr, uPattern, sReg.rValue);	
	else
	{	
		if(!Nth)	
		UART_Printf("\n%20s, 0x%08X\t", sReg.name, sReg.uAddr);
	}
	if(uRegStatus)
	{
		if(uInDetail)
			UART_Printf(", Error Pattern Bit[%d]",Nth);
		else
			UART_Printf("%d)",Nth);			
	}

	return;
}

void TestSFR_Ipc(void)
{
	
	static REGINFO *sRegInfo;
	
	volatile u32 *pAddr;	
	s32 i,j, count , nPattern;
	u32 uRegStatus, uWritePatternWithMask, uReadWithMask;	
	
	
	
	u32 uPatternShitfOneBit[] = 
	{
		0x00000001,		0x00000002,		0x00000004,		0x00000008,		0x00000010,		0x00000020,		0x00000040,		0x00000080,
		0x00000100,		0x00000200,		0x00000400,		0x00000800,		0x00001000,		0x00002000,		0x00004000,		0x00008000,
		0x00010000,		0x00020000,		0x00040000,		0x00080000,		0x00100000,		0x00200000,		0x00400000,		0x00800000,
		0x01000000,		0x02000000,		0x04000000,		0x08000000,		0x10000000,		0x20000000,		0x40000000,		0x80000000,
	};
	
	u32 uDefaultBitMask[] =
	{
		0x00000001,		0x00000003,		0x00000007,		0x0000000F,		0x0000001F,		0x0000003F,		0x0000007F,		0x000000FF,
		0x000001FF,		0x000003FF,		0x000007FF,		0x00000FFF,		0x00001FFF,		0x00003FFF,		0x00007FFF,		0x0000FFFF,
		0x0001FFFF,		0x0003FFFF,		0x0007FFFF,		0x000FFFFF,		0x001FFFFF,		0x003FFFFF,		0x007FFFFF,		0x00FFFFFF,
		0x01FFFFFF,		0x03FFFFFF,		0x07FFFFFF,		0x0FFFFFFF,		0x1FFFFFFF,		0x3FFFFFFF,		0x7FFFFFFF,		0xFFFFFFFF,
	};


	 sRegInfo = ipcRegInfo;
	 count = sizeof(ipcRegInfo)/sizeof(REGINFO);


//	count = sizeof(sRegInfo)/sizeof(REGINFO);
	
		
	for(i=0; i<count; i++)
	{		
		pAddr = (u32*)sRegInfo[i].uAddr;		
		
		if(sRegInfo[i].uFlag == DPDB)
		{		
			if(sRegInfo[i].uRWType == RW)
			{
				for(j=0; j< sRegInfo[i].uBitLen ; j++)
				{			
					uWritePatternWithMask = (uPatternShitfOneBit[j] &uDefaultBitMask[j]);
					*pAddr = uWritePatternWithMask;					
					
					uReadWithMask = (*pAddr & uDefaultBitMask[j]);	
					sRegInfo[i].rValue = uReadWithMask;
					
					uRegStatus = (	uWritePatternWithMask !=uReadWithMask );					
					RPRINTF(sRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);
				}
			}
		}		
		else if(sRegInfo[i].uFlag == DPPB)
		{		
			nPattern = (sizeof(uPatternShitfOneBit)/sizeof(uPatternShitfOneBit[0]));			
			if(sRegInfo[i].uRWType == RW)
			{
				for(j=0; j<nPattern; j++)
				{
					if(uPatternShitfOneBit[j] & sRegInfo[i].uPrivateBitMask)
					{
						uWritePatternWithMask = (uPatternShitfOneBit[j] & sRegInfo[i].uPrivateBitMask);
						*pAddr = uWritePatternWithMask;
						
						uReadWithMask = (*pAddr & sRegInfo[i].uPrivateBitMask);
						sRegInfo[i].rValue = uReadWithMask;
						
						uRegStatus = (	uWritePatternWithMask != uReadWithMask );												
						RPRINTF(sRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);					
					}
				}
			}			
		}					
	}
	UART_Printf("\n\nTest Complete!\n\n");

	
	return ;
}

static void __irq Isr_Fimd(void)
{
	u32 uIntFlag;

	LCDC_GetIntFlag(&uIntFlag);	
	Disp("[u]");
	LCDC_ClearPending(uIntFlag);	
	INTC_ClearVectAddr();	
}


static void __irq Isr_Fimc(void)
{
	FIMC_INTR_SRC eSrc;
	FIMC_GetIntrSrc(FIMC_B, &eSrc);
	switch(eSrc)
	{
		case FIMC_SUCCESS:
			bProcessingDone = true;
			break;
		case FIFO_Y_OVF:
			bProcessingDone = false;
			Disp("\n FIFO Y overflow \n");
			break;
		case FIFO_CB_OVF:
			bProcessingDone = false;
			Disp("\n FIFO Cb overflow \n");
			break;
		case FIFO_CR_OVF:
			bProcessingDone = false;
			Disp("\n FIFO Cr overflow \n");
			break;
		case ROT_LINE_BUF_OVF:
			bProcessingDone = false;
			Disp("\n Rotation line buffer overflow \n");
			break;
		default:
			bProcessingDone = false;
			Assert(0);
			break;		
	}

	FIMC_ClearInterrupt(FIMC_B);
	INTC_ClearVectAddr();
}

static void InitVariables(void)
{
	eTestPattern=EXTERNAL_CAMERA_INPUT; // Set test pattern

	eBppInFmt=RGB24; // Set input image format

	uInImgHsz=uLcdHSz, uInImgVsz=uLcdVSz; // Set input image size

	// Set cropping region
	uInImgCropStartX=0, uInImgCropStartY=0;
	uInImgCropHsz=uLcdHSz, uInImgCropVsz=uLcdVSz;

	uOutImgHsz=uLcdHSz, uOutImgVsz=uLcdVSz; // Set scaler

	eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

	eBppOutFmt=RGB24; // Set output image format

	uOutDispHsz=uLcdHSz, uOutDispVsz=uLcdVSz; // Set output display size

	uOutImgStartX=0, uOutImgStartY=0; // Set output offset

	eScanMode = PROGRESSIVE; // Set FIFO-out scan mode

	eDmaOutMode = PROGRESSIVE_OUT; // Set FIFO-in DMA-out mode

	// Set image effect
	eImgEff=EFF_BYPASS;
	uCbVal=0, uCrVal=0;

	// Set capture frame control
	bCptFrmCtrl=false;
	uCptSeqPattern=0, uCptSeqPointer=0;
	// Set capture count control
	bCptCntCtrl=false;
	uCptCnt=0;
}

//////////
// Function Name 	: 	TestSimple2DIpc
// Description		:	2D IPC simple test using FIMC(DIN-FOUT)
// 					FIMC 2:1 Scaling Down
// Input 			:	None
static void TestSimple2DIpc(void)
{

	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;


	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
//	uLcdHSz = 480; uLcdVSz = 768;

		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
	//Assert(uDispHSz>=32 && uDispHSz<=1024);
	//Assert(uDispVSz>=4 && uDispVSz<=768);

				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_On();
				
		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		
		
//*******************************************************//
//*******************************************************//
//														*//
//					IPC Post Processor Test					*//
//														*//
//*******************************************************//
//*******************************************************//
		
		Disp("\n Press any key to start post processor! \n");
		Disp("\n If you dont want this test, Click 'p' key! \n");
		
		if(UART_Getc() == 'p'){
		Disp("\n[1]"); IPC_SaturationTest();	Disp("  Click any key..");
		Disp("\n[2]"); IPC_SharpnessTH_HNOISE_Test();	Disp("  Click any key..");
		Disp("\n[3]"); IPC_ContrastTest();		Disp("  Click any key..");
		Disp("\n[4]"); IPC_Brightness_Test();	Disp("  Click any key..");
		Disp("\n[6]");IPC_BRIGHTOffsetTest();	Disp("  Click any key..");
		Disp("\n[6]");IPC_IPC_VERSION_INFO(); Disp("  Click any key..");
		IPC_SetPostProcessingOnOff(0);		

		}

		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	
}


//////////
// Function Name 	: 	TestSimpleIpcforHDS
// Description		:	HDS (Horizontal Double Scaling test using FIMC(DIN-FOUT))
//					FIMC 1:1 Scaling up
// Input 			:	None
static void TestSimpleIpcforHDS(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;


 for(i = 2 ; i <8; i +=2){	
	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;
	Disp("\n[LCD TYPE][%dx%d]\n",uLcdHSz,uLcdVSz);

				/* for HDS */
				Disp("\nwait............");
				uLcdHSz =( uLcdHSz/i)-((uLcdHSz/i)%16);
				uLcdVSz = (uLcdVSz/(i/2))-((uLcdVSz/(i/2))%16);			
				// Generate DMA input image
				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);
	

				/* 1 : 1 Scaling up   */
				/* 2D IPC OFF	  */
				/* Top Field		  */
				/* NO Rotation	  */				

				uDispHSz = uLcdHSz;
				uDispVSz = uLcdVSz;

	
	//Assert(uDispHSz>=32 && uDispHSz<=1024);
	//Assert(uDispVSz>=4 && uDispVSz<=768);
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;
				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz*2, uDispVSz, 0, 0);
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();
				//eRotFlip=ROT_90_FLIP_NO; // Set rotator & flip
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_HDS);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();
				eRotFlip=ROT_NO_FLIP_NO;

	Disp("\n FIMC OUT IMAGE SIZE : %d X %d",uInIpcHSz,uInIpcVSz);


		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
//*******************************************************//
//*******************************************************//
//														*//
//					IPC Post Processor Test					*//
//														*//
//*******************************************************//
//*******************************************************//
		
		Disp("\n Press any key to start post processor! \n");
		Disp("\n If you dont want this test, Click 'p' key! \n");
		
		if(UART_Getc() == 'p'){
		Disp("\n[1]"); IPC_SaturationTest();	Disp("  Click any key..");
		Disp("\n[2]"); IPC_SharpnessTH_HNOISE_Test();	Disp("  Click any key..");
		Disp("\n[3]"); IPC_ContrastTest();		Disp("  Click any key..");
		Disp("\n[4]"); IPC_Brightness_Test();	Disp("  Click any key..");
		Disp("\n[6]");IPC_BRIGHTOffsetTest();	Disp("  Click any key..");
		Disp("\n[6]");IPC_IPC_VERSION_INFO(); Disp("  Click any key..");
		IPC_SetPostProcessingOnOff(0);		
			
		}

		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	
 	}

}

//////////
// Function Name 	: 	TestSimple2DIpc
// Description		:	2D IPC simple test using FIMC(DIN-FOUT)
// 					FIMC 2:1 Scaling Down
// Input 			:	None
static void TestScalingforIpc(void)
{

	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 uOutIpcHSz,uOUtIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;
	u32 uSelRot;

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	


	InitVariables();
	

	do{
		
		UART_Printf("\nInput FIMC H size (min size 16, 16'multiple): ");	uInImgHsz = UART_GetIntNum();
		UART_Printf("\nInput FIMC V size (min size 8): ");				uInImgVsz = UART_GetIntNum();

		UART_Printf("\nOutput FIMC H size (min size 16, 16'multiple): ");	uInIpcHSz = uDispHSz = UART_GetIntNum();
		UART_Printf("\nOutput FIMC V size (min size 8): ");				uInIpcVSz = uDispVSz = UART_GetIntNum();

		UART_Printf("\nOutput IPC H size : ");						uOutIpcHSz  = UART_GetIntNum();
		UART_Printf("\nOutput IPC V size : ");						uOUtIpcVSz  = UART_GetIntNum();

	}while(uInImgHsz%16);

	LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uOutIpcHSz, uOUtIpcVSz, 0, 0);				
	LCDC_SetWinOnOff(1, WIN1);	
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_Start();
		
		
		UART_Printf("[1] Bypass \n");
		UART_Printf("[2] 90 \n");
		UART_Printf("\nSelect Rotation: ");

		uSelRot = UART_GetIntNum();

		if(uSelRot == 1)
			eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip
		else if(uSelRot ==2)
			eRotFlip=ROT_90_FLIP_NO; // Set rotator & flip

		// Generate DMA input image	
		GLIB_InitInstance(uLcdFbAddr, uInImgHsz, uInImgVsz, eBpp);
		Disp("\nwait............");
		GLIB_DrawPattern(uInImgHsz, uInImgVsz);		
		
				
		IPC_InitIp_Exp(uInIpcHSz,uInIpcVSz,uOutIpcHSz,uOUtIpcVSz, IPC_Scale);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
		IPC_FILED_ID_Mode(INTERNAL, BYUSER);
		IPC_FILED_ID_Control(IPC_TOP_FIELD);
		IPC_On();
				
		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			0, 0, uInImgHsz, uInImgVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		

		UART_Getc();
		
		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	
		
}


static void TestSimple2DIpcMaxSize(void)
{

	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;

		
	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
//	uLcdHSz = 480; uLcdVSz = 768;
	Disp("\n[LCD Size : %xX%x",uLcdHSz,uLcdVSz);
	
		// Generate DMA input image

	uDispHSz = (1024)-((1024)%16);
	uDispVSz = (768/2)-((768/2)%16);	
	
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uLcdHSz, uLcdVSz, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_On();
				
		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		
		
		UART_Getc();
		
		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();

	
}

//////////
// Function Name 	  : 	Test2DIpcforFieldSelFunc
// Description		  :	User Mode Field ID test using FIMC(DIN-FOUT)
//				 	FIMC 1:1 Scaling up
// Input Image Size :	320x240
// Input 			  :	None
static void Test2DIpcforFieldSelFunc(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 uDrawp;
	u32 *tmp;	
	
	unsigned long long *tmp1;

	tmp1= (unsigned long long *)CODEC_MEM_ST;
	tmp = (u32 *)tmp1;


sel:
	Disp("\n [IPC][ Select Image ] ");
		Disp("\n 1> Color Bar1   2> Line ");
	
		switch(UART_Getc())
		{
			case '1':							
				uDrawp = 1;
				break;
			case '2':				
				uDrawp = 2;
				break;
			default:
				goto sel;
				break;
			}		
	
	// Initialize LCDC v6.0
for ( i = 0 ; i<4 ; i++){
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;

	//	uLcdHSz = 320;
	//	uLcdVSz = 240;

	GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);

	
		switch(uDrawp)
		{
			case 1:			
				Disp("\nwait............");				
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);
				break;
			case 2:
				Disp("\nwait............");				
				GLIB_DrawPattern4(uLcdHSz, uLcdVSz);
				break;
			default:
				break;
			}
				
				Disp("\n FIMC OUT IMAGE SIZE : %d X %d",uLcdHSz,uLcdVSz);
	
				
				/* 1 : 1 Scaling up   */
				/* 2D IPC ON		  */
				/* Top Field		  */
				/* No Rotation	  */
				uDispHSz = uLcdHSz;		//320
				uDispVSz = uLcdVSz;		//240
	
//Assert(uDispHSz>=32 && uDispHSz<=1024);
//Assert(uDispVSz>=4 && uDispVSz<=768);

				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

		switch(i)
			{
				case 0:
				Disp("\n[IPC Bypass]");
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_Off();
				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz, 0, 0);				
				break;
				case 1:
				Disp("\n[2D IPC TOP FIELD]");
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);		
				break;
				case 2:
				Disp("\n[2D IPC BOTTOM FIELD]");
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_BOTTOM_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);		
				break;
				case 3:
				Disp("\n[2D IPC AUTO FIELD TOGGLE]");	
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_BOTTOM_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, AUTO);
				IPC_On();

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);		
				break;
				default:
					Disp("\n uknown\n");
					break;
			}
					
		
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				
				InitVariables();
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip
				
		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
//*******************************************************//
//*******************************************************//
//														*//
//					IPC Post Processor Test					*//
//														*//
//*******************************************************//
//*******************************************************//
		
		Disp("\n Press any key to start post processor! \n");
		Disp("\n If you dont want this test, Click 'p' key! \n");
		
		if(UART_Getc() == 'p'){
			//Disp("\n Clicked 'p' key! \n");
		Disp("\n[1]"); IPC_SaturationTest();	Disp("  Click any key..");
		Disp("\n[2]"); IPC_SharpnessTH_HNOISE_Test();	Disp("  Click any key..");
		Disp("\n[3]"); IPC_ContrastTest();		Disp("  Click any key..");
		Disp("\n[4]"); IPC_Brightness_Test();	Disp("  Click any key..");
		Disp("\n[6]");IPC_BRIGHTOffsetTest();	Disp("  Click any key..");
		Disp("\n[6]");IPC_IPC_VERSION_INFO(); Disp("  Click any key..");
		IPC_SetPostProcessingOnOff(0);		
			//goto pass;
		}

		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	
}

}

//////////
// Function Name 	  : 	Test2DIpcVsFimcVDS
// Description		  :	User Mode Field ID test using FIMC(DIN-FOUT)
//				 	FIMC 1:1 Scaling up
// Input Image Size :	800x240
// Test Case		  :	1> FIMC 1:1 scaling up & IPC Bypass
//				  :	2> FIMC 1:2 scaling up & IPC Bypass
//				  : 	3> FIMC 1:1 scaling up & 2D IPC
// Input 			  :	None
static void Test2DIpcVsFimcVDS(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 uDrawp;
	u32 *tmp;	
	
	unsigned long long *tmp1;

	tmp1= (unsigned long long *)CODEC_MEM_ST;
	tmp = (u32 *)tmp1;


sel:
	Disp("\n [IPC][ Select Image ] ");
		Disp("\n 1> Color Bar1   2> Line ");
	
		switch(UART_Getc())
		{
			case '1':							
				uDrawp = 1;				
				break;
			case '2':				
				uDrawp = 2;			
				break;
			default:
				goto sel;
				break;
			}		
	
	// Initialize LCDC v6.0
for ( i = 0 ; i<3 ; i++){
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 384;

	//	uLcdHSz = 800;
	//	uLcdVSz = 240;

	GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);

	
		switch(uDrawp)
		{
			case 1:			
				Disp("\nwait............");				
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);
				break;
			case 2:
				Disp("\nwait............");				
				GLIB_DrawPattern5(uLcdHSz, uLcdVSz);
				break;
			default:
			//	goto sel;
				break;
			}
				
				Disp("\n FIMC OUT IMAGE SIZE : %d X %d",uLcdHSz,uLcdVSz);
								
				/* 1 : 1 Scaling up   */
				/* 2D IPC ON		  */
				/* Top Field		  */
				/* No Rotation	  */
				uDispHSz = uLcdHSz;		//800
				uDispVSz = uLcdVSz;		//240
	
//Assert(uDispHSz>=32 && uDispHSz<=1024);
//Assert(uDispVSz>=4 && uDispVSz<=768);

				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

		switch(i)
			{
				case 0:
				Disp("\n[IPC Bypass]");
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_Off();
				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz, 0, 0);				
				break;
				case 1:
				Disp("\n[FIMC VDS & IPC Bypass]");
				uDispVSz = uDispVSz*2;
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_Off();
				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz, 0, 0);		
				break;
				case 2:
				Disp("\n[2D IPC ON]");
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);		
				break;
				default:
					Disp("\n uknown\n");
					break;
			}
					

				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				
				InitVariables();
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip
				
		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
//*******************************************************//
//*******************************************************//
//														*//
//					IPC Post Processor Test					*//
//														*//
//*******************************************************//
//*******************************************************//
		
		Disp("\n Press any key to start post processor! \n");
		Disp("\n If you dont want this test, Click 'p' key! \n");
		
		if(UART_Getc() == 'p'){
		Disp("\n[1]"); IPC_SaturationTest();	Disp("  Click any key..");
		Disp("\n[2]"); IPC_SharpnessTH_HNOISE_Test();	Disp("  Click any key..");
		Disp("\n[3]"); IPC_ContrastTest();		Disp("  Click any key..");
		Disp("\n[4]"); IPC_Brightness_Test();	Disp("  Click any key..");
		Disp("\n[6]");IPC_BRIGHTOffsetTest();	Disp("  Click any key..");
		Disp("\n[6]");IPC_IPC_VERSION_INFO(); Disp("  Click any key..");
		IPC_SetPostProcessingOnOff(0);		
		}

		FIMC_StopProcessing(FIMC_B);
		IPC_On();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	
}

}


//////////
// Function Name 	: 	TestSimple2DIpc
// Description		:	2D IPC each function test using FIMC(DIN-FOUT)
// Test Case		:	1> 2D IPC
//				:	2> HDC(Horizontal Double Scaling)
//				:	3> Post Processor
//				:	4> Variable input size
// Input 			:	None
static void Test2DIpcforEachFunc(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 uDrawp;
	u32 uPath;
	u32 *tmp;	
	unsigned long long *tmp1;

	tmp1= (unsigned long long *)CODEC_MEM_ST;
	tmp = (u32 *)tmp1;
	

//variable input size + post processor Test 
sel1:
		Disp("\n [IPC][ Select Image ] ");
		Disp("\n 1> Color Bar1   2> Color Bar2   3> Line  :");
	
		switch(UART_Getc())
		{
			case '1':							
				uDrawp = 1;				
				break;
			case '2':				
				uDrawp = 2;			
				break;
			case '3':
				uDrawp = 3;
				break;
			default:
				goto sel1;
				break;
			}		
sel2:
	
		Disp("\n [IPC][ Select Path ] ");
		Disp("\n 1> 2D  2> HDS (Horizontal Double Scaling:");
	
		switch(UART_Getc())
		{
			case '1':							
				uPath = 1;				
				break;
			case '2':				
				uPath = 2;			
				break;
			default:
				goto sel1;
				break;
		}
		
for (i = 2;i<11 ;i+=2 ){		
	
	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;



		Disp("\nwait............");

		switch(uDrawp)
		{
			case 1:
				if(uPath==1){
					uLcdHSz =( uLcdHSz/(i/2))-((uLcdHSz/(i/2))%16);
					uLcdVSz = (uLcdVSz/i)-((uLcdVSz/i)%16);	
					}
				else{
					uLcdHSz =( uLcdHSz/i)-((uLcdHSz/i)%16);
					uLcdVSz = (uLcdVSz/(i/2))-((uLcdVSz/(i/2))%16);	
					}
					GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);
				break;
			case 2:
				if(uPath==1){
					uLcdHSz =( uLcdHSz/(i/2))-((uLcdHSz/(i/2))%16);
					uLcdVSz = (uLcdVSz/i)-((uLcdVSz/i)%16);	
					}
				else{
					uLcdHSz =( uLcdHSz/i)-((uLcdHSz/i)%16);
					uLcdVSz = (uLcdVSz/(i/2))-((uLcdVSz/(i/2))%16);	
					}
					GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				GLIB_DrawPattern2(uLcdHSz, uLcdVSz);
				break;
			case 3: /* for VDS */
				if(uPath==1){
					uLcdHSz =( uLcdHSz/(i/2))-((uLcdHSz/(i/2))%16);
					uLcdVSz = (uLcdVSz/i)-((uLcdVSz/i)%16);	
					}
				else{
					uLcdHSz =( uLcdHSz/i)-((uLcdHSz/i)%16);
					uLcdVSz = (uLcdVSz/(i/2))-((uLcdVSz/(i/2))%16);	
					}
					GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				GLIB_DrawPattern4(uLcdHSz, uLcdVSz);
				break;

			default:
				Assert(0);
				break;
		}		
		
	
		switch(uPath){
			
			case 1:
				/* 1/2 Scaling down */
				/* 2D IPC ON		  */
				/* Top Field		  */
				/* No Rotation	  */

				uDispHSz = uLcdHSz;
				uDispVSz = uLcdVSz;
				
//Assert(uDispHSz>=32 && uDispHSz<=1024);
//Assert(uDispVSz>=4 && uDispVSz<=768);
				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();
				
				IPC_InitIp(uDispHSz,uDispVSz,IPC_2D);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

				break;

			case 2:				

				/* 1 : 1 Scaling up   */
				/* HDS			  */
				/* Top Field		  */
				/* 90 Rotation	  	  */	
	
				uDispHSz = uLcdHSz;
				uDispVSz = uLcdVSz;
				
//Assert(uDispHSz>=32 && uDispHSz<=1024);
//Assert(uDispVSz>=4 && uDispVSz<=768);

				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz*2, uDispVSz, 0, 0);
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();
				//eRotFlip=ROT_90_FLIP_NO; // Set rotator & flip
				IPC_InitIp(uDispHSz,uDispVSz,IPC_HDS);	//You can select IPC_2D or IPC_HDS
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_FILED_ID_Mode(INTERNAL, BYUSER);
				IPC_On();				

				eRotFlip=ROT_NO_FLIP_NO;

			break;

			default:
				Assert(0);
				break;
				
			}

	Disp("\n FIMC OUT IMAGE SIZE : %d X %d",uDispHSz,uDispVSz);


		FIMC_InitIpForDinFout(FIMC_B,
			uInImgHsz, uInImgVsz, 0,
			uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
			uLcdFbAddr, eBpp,false,
			uDispHSz, uDispVSz, // Fifo out display size
			eLocalInCS, PROGRESSIVE,
			eRotFlip, eCscEquation, eYCbCrRange);

		FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
//*******************************************************//
//*******************************************************//
//														*//
//					IPC Post Processor Test					*//
//														*//
//*******************************************************//
//*******************************************************//
		
		Disp("\n Press any key to start post processor! \n");
		Disp("\n If you dont want this test, Click 'p' key! \n");
		
		if(UART_Getc() == 'p'){
			//Disp("\n Clicked 'p' key! \n");
		Disp("\n[1]"); IPC_SaturationTest();	Disp("  Click any key..");
		Disp("\n[2]"); IPC_SharpnessTH_HNOISE_Test();	Disp("  Click any key..");
		Disp("\n[3]"); IPC_ContrastTest();		Disp("  Click any key..");
		Disp("\n[4]"); IPC_Brightness_Test();	Disp("  Click any key..");
		Disp("\n[6]");IPC_BRIGHTOffsetTest();	Disp("  Click any key..");
		Disp("\n[6]");IPC_IPC_VERSION_INFO(); Disp("  Click any key..");
		IPC_SetPostProcessingOnOff(0);		
			//goto pass;
		}

		FIMC_StopProcessing(FIMC_B);
		IPC_Off();
		IPC_SWReset();
		Disp("\n Press any key to go next! \n");
		UART_Getc();	


	}
}


void IPC_Clock_Sel(CLKMUX_STATE_ID eId)
{
	//eCLKMUX_FIMC1LCLK_XXTI, eCLKMUX_FIMC1LCLK_XUSBXTI, eCLKMUX_FIMC1LCLK_SHDMI27M, 
	//eCLKMUX_FIMC1LCLK_SUSBPHY0, eCLKMUX_FIMC1LCLK_SUSBPHY1, eCLKMUX_FIMC1LCLK_SHDMIPHY,
	//eCLKMUX_FIMC1LCLK_SMPLL, eCLKMUX_FIMC1LCLK_SEPLL, eCLKMUX_FIMC1LCLK_SVPLL,
	
	SYSC_SetClkMuxState(eId);	
}
void IPC_Clock_Div(u32 val)
{
	Assert(val<17);
	SYSC_SetClkDiv(eCLKDIV_FIMC1, val);
	
}

void IPC_ClockDivCon(void)
{
	u32 i=0,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;

	UART_Printf("[IPC_ClockDivCon]\n");

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;

		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
//	Assert(uDispHSz>=32 && uDispHSz<=1024);
//	Assert(uDispVSz>=4 && uDispVSz<=768);

				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

	while(i < 17)
	{
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_On();
				
				FIMC_InitIpForDinFout(FIMC_B,
					uInImgHsz, uInImgVsz, 0,
					uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
					uLcdFbAddr, eBpp,false,
					uDispHSz, uDispVSz, // Fifo out display size
					eLocalInCS, PROGRESSIVE,
					eRotFlip, eCscEquation, eYCbCrRange);

				FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		
				
				DelayfrTimer(milli, 3000);
				
				FIMC_StopProcessing(FIMC_B);

				SYSC_UpdateClkInform();
				Disp("\nIPC LCLK : %d",g_uMPLL/i+1);
				IPC_Clock_Div(i++);
				
				UART_Getc();
				
				IPC_Off();
				IPC_SWReset();

	}
	
}

void IPC_BlockPowerOnOff(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;
	

	UART_Printf("[IPC_BlockPowerOnOff]\n");

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	
	uLcdHSz = 480; uLcdVSz = 768;
		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		

	while(!UART_GetKey())
	{
	
				LCDC_InitBase();
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_On();
				
				FIMC_InitIpForDinFout(FIMC_B,
					uInImgHsz, uInImgVsz, 0,
					uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
					uLcdFbAddr, eBpp,false,
					uDispHSz, uDispVSz, // Fifo out display size
					eLocalInCS, PROGRESSIVE,
					eRotFlip, eCscEquation, eYCbCrRange);

				FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		
				
				DelayfrTimer(milli, 3000);
				
				FIMC_StopProcessing(FIMC_B);
				IPC_Off();
				IPC_SWReset();

				// T-Block Power Off and On
				SYSC_SetBlockPowerOFF_IP(eIPC);
				//DelayfrTimer(milli, rand()%10);			// under 10ms
				DelayfrTimer(milli, SBLK_GetRand()%10);
				AccessOtherRegsInClockPowerOff(CPTEST_IPC,1);
				SYSC_SetBlockPowerON_IP(eIPC);
	}
}

void IPC_ClockOnOff(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;
	

	UART_Printf("[IPC_ClockOnOff]\n");

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	
	uLcdHSz = 480; uLcdVSz = 768;
		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		

	while(!UART_GetKey())
	{
	
				LCDC_InitBase();
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);

				// IP Clock Off and On Before IP Running.....	
				SYSC_SetClkOFF_IP(eIPC);
				//DelayfrTimer(milli, rand()%10);			// under 10ms
				DelayfrTimer(milli, SBLK_GetRand()%10);
				AccessOtherRegsInClockPowerOff(CPTEST_IPC,1);
				SYSC_SetClkON_IP(eIPC);
				
				IPC_On();
				
				FIMC_InitIpForDinFout(FIMC_B,
					uInImgHsz, uInImgVsz, 0,
					uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
					uLcdFbAddr, eBpp,false,
					uDispHSz, uDispVSz, // Fifo out display size
					eLocalInCS, PROGRESSIVE,
					eRotFlip, eCscEquation, eYCbCrRange);

				FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);		
				
				DelayfrTimer(milli, 3000);
				
				FIMC_StopProcessing(FIMC_B);
				IPC_Off();
				IPC_SWReset();

	}
}

#if 0
void IPC_ClockOnOff(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;

	UART_Printf("[IPC_ClockOnOff]\n");

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;
		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

	while(!UART_GetKey())
	{
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);

				// IP Clock Off and On Before IP Running.....	with Fimc?
				SYSC_SetClkOFF_IP(eIPC);
				//DelayfrTimer(milli, rand()%10);			// under 10ms
				DelayfrTimer(milli, SBLK_GetRand()%10);
				SYSC_SetClkON_IP(eIPC);
				
				IPC_On();
				
				FIMC_InitIpForDinFout(
					uInImgHsz, uInImgVsz, 0,
					uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
					uLcdFbAddr, eBpp,
					uDispHSz, uDispVSz, // Fifo out display size
					eLocalInCS, PROGRESSIVE,
					eRotFlip, eCscEquation, eYCbCrRange);

				FIMC_StartProcessing(false, 0, 0, false, 0);		
				
				DelayfrTimer(milli, 3000);
				
				FIMC_StopProcessing();
				IPC_Off();
				IPC_SWReset();

	}
}
#endif

void IPC_PowerMode(void)
{
	u32 i,j;
	u32 uDispHSz, uDispVSz;
	u32 uInIpcHSz, uInIpcVSz;
	u32 *tmp;	
	unsigned long long *tmp1;

	UART_Printf("[IPC_PowerMode]\n");

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHSz, &uLcdVSz);		//240 x 320  or 800 x 480
	uLcdHSz = 480; uLcdVSz = 768;
		// Generate DMA input image


	uDispHSz = (uLcdHSz)-((uLcdHSz)%16);
	uDispVSz = (uLcdVSz/2)-((uLcdVSz/2)%16);	
	
//	Assert(uDispHSz>=32 && uDispHSz<=1024);
//	Assert(uDispVSz>=4 && uDispVSz<=768);

				
				uInIpcHSz = uDispHSz;
				uInIpcVSz = uDispVSz;

				
				LCDC_InitWinForFifoIn4 (eLocalInCS, WIN1, uDispHSz, uDispVSz*2, 0, 0);				
				LCDC_SetWinOnOff(1, WIN1);	
				LCDC_EnableAllWinFifoLvlInt(EMPTY);
				LCDC_Start();
				InitVariables();

				GLIB_InitInstance(uLcdFbAddr, uLcdHSz, uLcdVSz, eBpp);
				Disp("\nwait............");
				GLIB_DrawPattern(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern2(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern3(uLcdHSz, uLcdVSz);		
				//GLIB_DrawPattern4(uLcdHSz, uLcdVSz);		
				
				eRotFlip=ROT_NO_FLIP_NO; // Set rotator & flip

	while(!UART_GetKey())
	{
				IPC_InitIp(uInIpcHSz,uInIpcVSz,IPC_2D);	// _2D_IPC_ENABLE or _2D_IPC_DISABLE
				IPC_FILED_ID_Control(IPC_TOP_FIELD);
				IPC_On();

				FIMC_InitIpForDinFout(FIMC_B,
					uInImgHsz, uInImgVsz, 0,
					uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz,
					uLcdFbAddr, eBpp,false,
					uDispHSz, uDispVSz, // Fifo out display size
					eLocalInCS, PROGRESSIVE,
					eRotFlip, eCscEquation, eYCbCrRange);

				FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);	
				
				//DelayfrTimer(milli, rand()%1000);
				DelayfrTimer(milli, SBLK_GetRand()%1000);
				// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
				//SYSCT_TestSimplePowerMode_Temp(rand()%6+1);	
				SYSCT_TestSimplePowerMode_Temp(SBLK_GetRand()%6+1);	
				
				DelayfrTimer(milli, 3000);
				
				FIMC_StopProcessing(FIMC_B);
				IPC_Off();
				IPC_SWReset();

	}
}
const AutotestFuncMenu IPC_ETC_menu[]=
{
	0,									"Exit",
	IPC_ClockDivCon,					"IPC Clock Divider Control\n",

	IPC_BlockPowerOnOff,				"IPC Block Power On/Off",
	IPC_ClockOnOff,						"IPC Clock On/Off",
	IPC_PowerMode,						"IPC Power Mode\n",
	0,0
};

u32 IPC_ETCTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;
	s32 sSel;
	
	while (true)
	{
		UART_Printf("\n");
		UART_Printf("\n");
		for ( i=0; (int)(IPC_ETC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, IPC_ETC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(IPC_ETC_menu)/8-1))
			(IPC_ETC_menu[sSel].func) (eTest_Manual, oPara);
	}


	return OK;
}

void IPC_Clock_Con(void)
{
	u32 uSelSrcClk;
	u32 uSelDivVal;
	u32 uRegtmp;


	UART_Printf("\n[ Input Clock Source ]\n");
	UART_Printf("[0] Exit\n");
	UART_Printf("[1] Mpll \n");
	UART_Printf("[2] Epll \n");
	UART_Printf("[2] Vpll \n");
	UART_Printf("\nEnter the source clock: ");

	uSelSrcClk = UART_GetIntNum();

	if (uSelSrcClk == 0)
			return;

	UART_Printf("\n[ Divider Value ][ Range : 1~16 ] \n");
	UART_Printf("\nEnter the divider value : ");
	
	uSelDivVal = UART_GetIntNum();

	switch(uSelSrcClk)			//eCLKMUX_FIMC1LCLK_SMPLL, eCLKMUX_FIMC1LCLK_SEPLL, eCLKMUX_FIMC1LCLK_SVPLL,
	{
		case 1:	
				SYSC_SetClkMuxState(eCLKMUX_FIMC1LCLK_SMPLL);	
				UART_Printf("IPC Clock : %d\n", g_uMPLL/uSelDivVal);
				break;
		case 2:		
				SYSC_SetClkMuxState(eCLKMUX_FIMC1LCLK_SEPLL);	
				UART_Printf("IPC Clock : %d\n", g_uEPLL/uSelDivVal);
				break;
		case 3:
				SYSC_SetClkMuxState(eCLKMUX_FIMC1LCLK_SVPLL);	
				UART_Printf("IPC Clock : %d\n", g_uVPLL/uSelDivVal);
				break;
		default:
				break;
	}

	
	Assert(uSelDivVal<17);
	SYSC_SetClkDiv(eCLKDIV_FIMC1, uSelDivVal);

	do{
		uRegtmp = SYSC_GetClkDivStatusReg(0);
		//UART_Printf("uRegtmp = %x\n", uRegtmp);
	}while(uRegtmp&(1<<21));

	UART_Printf("\nClock Setting Done!!\n");
	
}
	
void InitSysconForIPC(void)
{
	SYSC_InitClkForMM();

	SYSC_SetBlockPowerOFF_IP(eIPC);	
	DelayfrTimer(milli, 100);
	SYSC_SetBlockPowerON_IP(eIPC);
	DelayfrTimer(milli, 100);

	SYSC_SetClkOFF_IP(eIPC);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eIPC);
	DelayfrTimer(milli, 100);
	
}

void Test_IPC(void)
{
	int sel, i;

	
	const testFuncMenu menu[] = 
		{
			0,								"Exit",
		Test_initReg,							"Reset Value Test for IPC",
		TestSFR_Ipc,							"SFR R/W Test for IPC",
		TestSimple2DIpc,						"Simple Test for 2D IPC", 
		TestSimpleIpcforHDS,					"Simple Test for HDS IPC",
		TestScalingforIpc,						"Variable Scaling Test",
		Test2DIpcforFieldSelFunc,				"Field ID Test for 2D IPC",
		Test2DIpcVsFimcVDS,					"2D IPC & FIMC VDS Comparison",
		Test2DIpcforEachFunc,					"Each Function Test for 2D IPC",
		TestSimple2DIpcMaxSize,					"Max Input Size for 2D IPC\n",	

		IPC_Clock_Con,							"IPC Clock setting \n",

		IPC_ETCTest,							"IPC ETC Test",
		
			0,0
		};

	
	InitSysconForIPC();
	
	//FIMC_SetChB();

	eCscEquation = CSC_ITU709;
	eYCbCrRange = YCBCR_NARROW;
	
	eLocalInCS = LOCAL_IF_YCBCR444;

	InitBaseHwForFIMC();

	eBpp = RGB24;
	uLcdFbAddr = CODEC_MEM_ST;
#if 0	
	uInFbAddr = CODEC_MEM_ST + 0x02000000;
	uOutFbAddr = CODEC_MEM_ST + 0x02000000 + 0x02000000;
	uLcdOutFbAddr = CODEC_MEM_ST + 0x02000000 + 0x02000000 + 0x02000000;
#else
	uInFbAddr = CODEC_MEM_ST + 0x00300000;
	uOutFbAddr = CODEC_MEM_ST + 0x00300000 + 0x05000000;
	uLcdOutFbAddr = CODEC_MEM_ST + 0x00300000 + 0x05000000 + 0x00300000;
#endif
	SYSC_SetDispPath(eDISP_BYPASS);
//	IEIP_Select(DISP_BYPASS); // mDNIE bypass

#ifndef FIMC_POLLING	
	INTC_Init(); // Initialize interrupt controller
	INTC_SetVectAddr(NUM_FIMC_B, Isr_Fimc);
	INTC_Enable(NUM_FIMC_B);

	INTC_SetVectAddr(NUM_LCD0, Isr_Fimd);
	INTC_Enable(NUM_LCD0);
#endif



	
	while(true)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("\n Select the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
		{
			break;
		}
		else if (sel>0 && sel<(sizeof(menu)/8-1))
		{
			(menu[sel].func) ();
		}
	}
	
}



