
#ifndef __IPC_H__
#define __IPC_H__

#include "def.h"
#include "option.h"
#include "library.h"
#include "util.h"

typedef enum{
	OFF,
	ON
}IPC_eONOFF;

typedef enum{

	DISABLED,		
	ENABLED
	
}IPC_eON;

typedef enum{
	
	IPC_TOP_FIELD,
	IPC_BOTTOM_FIELD
	
}IPC_eFIELD_ID;

typedef enum{
	
	INTERNAL,
	CAM_FIELD_SIG
	
}IPC_eFIELD_ID_SEL;

typedef enum{
	
	BYUSER,
	AUTO
	
}IPC_eFIELD_ID_TOGL;

typedef enum{
	
	IPC_HDS, // Horizontal Double scaling
	IPC_2D, // 2D IPC
	IPC_Scale // General Scaling
	
}_2D_eIPC;

typedef enum{
	
	_1PIX_PER_1CYCLE,
	_1PIX_PER_2CYCLE,
	_1PIX_PER_3CYCLE,
	_1PIX_PER_4CYCLE
	
}IPC_ePEL_RATE_CTRL;

typedef enum IPC_SHARPNESS {
	NO_EFFECT, MIN_EDGE, MODERATE_EDGE, MAX_EDGE
}IPC_eSHARPNESS;

typedef enum IPC_PP_LINEEQ_VAL {
	
	IPC_PP_LINEEQ_0 = 0,
	IPC_PP_LINEEQ_1,
	IPC_PP_LINEEQ_2,
	IPC_PP_LINEEQ_3,
	IPC_PP_LINEEQ_4,
	IPC_PP_LINEEQ_5,
	IPC_PP_LINEEQ_6,
	IPC_PP_LINEEQ_7,
	IPC_PP_LINEEQ_ALL
	
}IPC_ePP_LINEEQ_VAL;

typedef enum IPC_FILTER_H_PP {
	/* Don't change the order and the value */
	IPC_PP_H_NORMAL = 0,
	IPC_PP_H_8_9,		/* 720 to 640 */
	IPC_PP_H_1_2,
	IPC_PP_H_1_3,
	IPC_PP_H_1_4
}IPC_eFILTER_H_PP;

typedef enum IPC_FILTER_V_PP {
	/* Don't change the order and the value */
	IPC_PP_V_NORMAL = 0,
	IPC_PP_V_5_6,		/* PAL to NTSC */
	IPC_PP_V_3_4,
	IPC_PP_V_1_2,
	IPC_PP_V_1_3,
	IPC_PP_V_1_4
}IPC_eFILTER_V_PP;

typedef enum IPC_SRC_X_POS_FRACTION_STEP
{
	STEP0 = 0, // 0/16 = 0
	STEP1, // 1/16 = 0.0625
	STEP2, // 2/16 = 0.125
	STEP3, // 3/16 = 0.1875
	STEP4, // 4/16 = 0.25
	STEP5, // 5/16 = 0.3125
	STEP6, // 6/16 = 0.375
	STEP7, // 7/16 = 0.4375
	STEP8, // 8/16 = 0.5
	STEP9, // 9/16 = 0.5625
	STEP10, // 10/16 = 0.625
	STEP11, // 11/16 = 0.6875
	STEP12, // 12/16 = 0.75
	STEP13, // 13/16 = 0.8125
	STEP14, // 14/16 = 0.875
	STEP15 // 15/16 = 0.9375
}IPC_eSRC_X_POS_FRACTION_STEP;

////////////////////////////////////////////////
// Source Image Processing Infomation
////////////////////////////////////////////////
typedef struct IPC_xSource
{
	IMG_FMT 	eSrcBpp;
	u32 		uSrcStAddr;
//	u32 		uTopYAddr[VP_MAX_FRM_BUF_NUM];
//	u32 		uBotYAddr[VP_MAX_FRM_BUF_NUM];	
//	u32 		uTopCAddr[VP_MAX_FRM_BUF_NUM];
//	u32 		uBotCAddr[VP_MAX_FRM_BUF_NUM];		
	u32 		uImgHsz;
	u32 		uImgVsz;
	u32 		uSrcXPos;
	u32 		uSrcYPos;
	u32 		uSrcHsz;
	u32 		uSrcVsz; 
	u32 		uSrcNumOfFrm;	
	u32 		uLastFrmBufIdx;	
	IPC_eSRC_X_POS_FRACTION_STEP eStep;	
}oIPC_Source;

//extern oVP_Source oIPC_SrcInf;

////////////////////////////////////////////////
// Destination Image Processing Infomation
////////////////////////////////////////////////	
typedef struct IPC_xDestination
{
	SCAN_MODE 	eScanMode;
	u32 			uOrgDstHsz;
	u32 			uOrgDstVsz;	
	u32 			uDstXPos;
	u32 			uDstYPos;
	u32 			uDstHsz;
	u32 			uDstVsz; 
	IMG_RESOLUTION 	eImgSz;
}oIPC_Destination;

//extern oVP_Destination oVP_DstInf;

////////////////////////////////////////////////
// Variable Structure(Control, Source, Destination, Enhancing)
////////////////////////////////////////////////
typedef struct IPC_xControlVariable
{
	u32 uModeVal;
	u32 uLineEqVal;
	u32 uScanConversionIdx;
}oIPC_ControlVariable;

typedef struct IPC_xEnhancingVariable
{
	u32 				aContrast[8];
	u32				aBrightness[8];
	u32				uSaturation;
	IPC_eSHARPNESS	eSharpness;
	u32				uThHnoise;
	u32				uBrightOffset;
}oIPC_EnhancingVariable;

typedef enum
{
	REG_READ=0x1, 
	REG_WRITE=0x2
}REG_TYPE;
typedef struct
{
	u8 name[32];
	u32 offset;
	REG_TYPE type;
	u32 readableBits;
	u32 writebleBits;
	u32 resetValue;
	u32 resetValueMask; // if((register real value)&(resetValueMask) == resetValue){the reset value is OK}
	u32 tmp; //this is temp.
}REGISTER;

#define IPC_v210_BASE IPC_BASE


typedef enum
{
	IPC_ENABLE = 0x0,
	IPC_SRESET = 0x04,
	IPC_SHADOW_UPDATE = 0x08,
	IPC_FIELD_ID	 = 0x0C,
	IPC_MODE = 0x10,
	IPC_PEL_RATE_CTRL = 0x1C,
//	IPC_ENDIAN_MODE = 0x3CC,
	IPC_SRC_WIDTH = 0x4C,
	IPC_SRC_HEIGHT = 0x50,
	IPC_DST_WIDTH = 0x5C,
	IPC_DST_HEIGHT = 0x60,
	IPC_H_RATIO = 0x64,
	IPC_V_RATIO = 0x68,


	IPC_POLY8_Y0_LL = 0x6C,
	IPC_POLY8_Y0_LH = 0x70,
	IPC_POLY8_Y0_HL = 0x74,
	IPC_POLY8_Y0_HH = 0x78,
	
	IPC_POLY8_Y1_LL = 0x7C,
	IPC_POLY8_Y1_LH = 0x80,
	IPC_POLY8_Y1_HL = 0x84,
	IPC_POLY8_Y1_HH = 0x88,
	
	IPC_POLY8_Y2_LL = 0x8C,
	IPC_POLY8_Y2_LH = 0x90,
	IPC_POLY8_Y2_HL = 0x94,
	IPC_POLY8_Y2_HH = 0x98,

	IPC_POLY8_Y3_LL = 0x9C,
	IPC_POLY8_Y3_LH = 0xA0,
	IPC_POLY8_Y3_HL = 0xA4,
	IPC_POLY8_Y3_HH = 0xA8,

	IPC_POLY4_Y0_LL = 0xEC,
	IPC_POLY4_Y0_LH = 0xF0,
	IPC_POLY4_Y0_HL = 0xF4,
	IPC_POLY4_Y0_HH = 0xF8,	

	IPC_POLY4_Y1_LL = 0xFC,
	IPC_POLY4_Y1_LH = 0x100,
	IPC_POLY4_Y1_HL = 0x104,
	IPC_POLY4_Y1_HH = 0x108,	

	IPC_POLY4_Y2_LL = 0x10C,
	IPC_POLY4_Y2_LH = 0x110,
	IPC_POLY4_Y2_HL = 0x114,
	IPC_POLY4_Y2_HH = 0x118,

	IPC_POLY4_Y3_LL = 0x11C,
	IPC_POLY4_Y3_LH = 0x120,
	IPC_POLY4_Y3_HL = 0x124,
	IPC_POLY4_Y3_HH = 0x128,

	IPC_POLY4_C0_LL = 0x12C,
	IPC_POLY4_C0_LH = 0x130,
	IPC_POLY4_C0_HL = 0x134,
	IPC_POLY4_C0_HH = 0x138,
	IPC_POLY4_C1_LL  = 0x13C,
	IPC_POLY4_C1_LH = 0x140,
	IPC_POLY4_C1_HL = 0x144,
	IPC_POLY4_C1_HH = 0x148,

	IPC_BYPASS = 0x200,
	IPC_PP_SATURATION =  0x20C,
	IPC_PP_SHARPNESS = 0x210,
                               
	IPC_PP_LINE_EQ0 = 0x218,
	IPC_PP_LINE_EQ1 = 0x21C,
	IPC_PP_LINE_EQ2 = 0x220,
	IPC_PP_LINE_EQ3 = 0x224,
	IPC_PP_LINE_EQ4 = 0x228,
	IPC_PP_LINE_EQ5 = 0x22C,
	IPC_PP_LINE_EQ6 = 0x230,
	IPC_PP_LINE_EQ7 = 0x234,
                               
	IPC_PP_BRIGHT_OFFSET = 0x238,	
	IPC_VERSION_INFO = 0x3FC
	
}IPC_SFR;

          
u32 IPC_RegResetValueVerify(void);
void Test_initReg();
	
void IPC_Init(oIPC_Source oIpc_Src, oIPC_Destination oIpc_Dst, oIPC_ControlVariable oIpc_ConVar);
void IPC_InitIp(u32 InHSz, u32 InVSz,  _2D_eIPC Ipc2d);
void IPC_ONOFF(IPC_eONOFF eONOFF);
void IPC_On(void);
void IPC_Off(void);
void IPC_SWReset(void);
void IPC_EnableIP(u32 uOnOff);
u8 IPC_IsProcessingDone(void);
void IPC_SetPostProcessingOnOff(u32 uOnOff);
void IPC_SetModeAndImgSize(oIPC_Source oIpc_Src, oIPC_Destination oIpc_Dst, oIPC_ControlVariable oIpc_ConVar);
void IPC_InitEnhancingParameter(void);
void IPC_SetContrast(u32 *uContrast);
void IPC_SetBrightness(u32 *uBrightness);
void IPC_SetBrightOffset(u32 uOffset);
void IPC_SetSaturation(u32 uSaturation);
void IPC_SetSharpness(IPC_eSHARPNESS eSharpness, u32 uThreshold);
void IPC_SetFilter(void);
void IPC_SetPolyPhaseFilterSet(IPC_eFILTER_H_PP eHFilter, IPC_eFILTER_V_PP eVFilter);
void IPC_SetPolyPhaseFilter(volatile u32 uFilterReg, const s8* sFilterCoef, u16 usTapSz);

void IPC_SaturationTest(void);
void IPC_SharpnessTH_HNOISE_Test(void);
void IPC_SharpnessTest(void);
void IPC_ContrastTest(void);
void IPC_Brightness_Test(void);
void IPC_TH_HNOISE_Test(void);
void IPC_BRIGHTOffsetTest(void);

void IPC_FILED_ID_Control(IPC_eFIELD_ID id );
void IPC_FILED_ID_Mode(IPC_eFIELD_ID_SEL sel,IPC_eFIELD_ID_TOGL toggle );
void IPC_2D_ENABLE(IPC_eON uOnOff);
void IPC_IPC_VERSION_INFO(void);
#endif



