/*-------------------------------------------------------------
 * Filename: lcd_module.c
 *
 * Contents: 
 *
 * Abbreviations:
 *
 * Person Involved:
 *
 * Notes: 
 *
 * History
 *
 * Copyright (c) 2009 SAMSUNG Electronics.
 --------------------------------------------------------------*/
#include "def.h"
#include "library.h"
#include "timer.h"
#include "lcd.h"
#include "lcd_module.h"
#include "gpio.h"

#define REG_DELAY_MS 0xffffffff
#define REG_END 0xfffffffe
#define REG_RESET_MS 0xfffffffd

//do not modify
#define LCDM_SDA_HIGH			Outp32(SDA_GPIO_ADDRESS+4,(Inp32(SDA_GPIO_ADDRESS+4) |= (1<<SDA_GPIO_BIT)))
#define LCDM_SDA_LOW			Outp32(SDA_GPIO_ADDRESS+4,(Inp32(SDA_GPIO_ADDRESS+4) &= ~(1<<SDA_GPIO_BIT)))
#define LCDM_SCL_HIGH			Outp32(SCL_GPIO_ADDRESS+4,(Inp32(SCL_GPIO_ADDRESS+4) |= (1<<SCL_GPIO_BIT)))
#define LCDM_SCL_LOW			Outp32(SCL_GPIO_ADDRESS+4,(Inp32(SCL_GPIO_ADDRESS+4) &= ~(1<<SCL_GPIO_BIT)))
#define LCDM_CS_HIGH			Outp32(CS_GPIO_ADDRESS+4,(Inp32(CS_GPIO_ADDRESS+4) |=(1<<CS_GPIO_BIT)))
#define LCDM_CS_LOW			Outp32(CS_GPIO_ADDRESS+4,(Inp32(CS_GPIO_ADDRESS+4) &= ~(1<<CS_GPIO_BIT)))
#define LCDM_BACKLIGHT_HIGH 	Outp32(BACKLIGHT_GPIO_ADDRESS+4,(Inp32(BACKLIGHT_GPIO_ADDRESS+4) |= (1<<BACKLIGHT_GPIO_BIT)))
#define LCDM_BACKLIGHT_LOW	Outp32(BACKLIGHT_GPIO_ADDRESS+4,(Inp32(BACKLIGHT_GPIO_ADDRESS+4) &= ~(1<<BACKLIGHT_GPIO_BIT)))
#define LCDM_RESET_HIGH 	Outp32(RESET_GPIO_ADDRESS+4,(Inp32(RESET_GPIO_ADDRESS+4) |= (1<<RESET_GPIO_BIT)))
#define LCDM_RESET_LOW		Outp32(RESET_GPIO_ADDRESS+4,(Inp32(RESET_GPIO_ADDRESS+4) &= ~(1<<RESET_GPIO_BIT)))
#define LCDM_POWER_HIGH 	Outp32(POWER_GPIO_ADDRESS+4,(Inp32(POWER_GPIO_ADDRESS+4) |= (1<<POWER_GPIO_BIT)))
#define LCDM_POWER_LOW		Outp32(POWER_GPIO_ADDRESS+4,(Inp32(POWER_GPIO_ADDRESS+4) &= ~(1<<POWER_GPIO_BIT)))
#define LCDM_POWER2_HIGH 	Outp32(POWER_GPIO_ADDRESS+4,(Inp32(POWER_GPIO_ADDRESS+4) |= (1<<POWER_GPIO_BIT)))
#define LCDM_POWER2_LOW	 	Outp32(POWER_GPIO_ADDRESS+4,(Inp32(POWER_GPIO_ADDRESS+4) &= ~(1<<POWER_GPIO_BIT)))
#define LCDM_IIC_SCL_HIGH      Outp32(SCL_GPIO_ADDRESS+4,(Inp32(SCL_GPIO_ADDRESS+4) |= (1<<SCL_GPIO_BIT)))
#define LCDM_IIC_SCL_LOW      Outp32(SCL_GPIO_ADDRESS+4,(Inp32(SCL_GPIO_ADDRESS+4) &= ~(1<<SCL_GPIO_BIT)))
#define LCDM_IIC_SDA_HIGH      Outp32(SDA_GPIO_ADDRESS+4,(Inp32(SDA_GPIO_ADDRESS+4) |= (1<<SDA_GPIO_BIT)))
#define LCDM_IIC_SDA_LOW      Outp32(SDA_GPIO_ADDRESS+4,(Inp32(SDA_GPIO_ADDRESS+4) &= ~(1<<SDA_GPIO_BIT)))


u32 gLCDM_HSIZE;
u32 gLCDM_VSIZE;	
u32 gVCLK_EDGE_DETECT;
u32 gHSYNC_POLARITY;
u32 gVSYNC_POLARITY;
u32 gVDEN_POLARITY;
u32 gLCDM_INTERFACE_TYPE;
u32 gDITHERING_FORMAT;
u32 gMODULE_VBPDE;
u32 gMODULE_VBPD;
u32 gMODULE_VFPD;
u32 gMODULE_VSPW;
u32 gMODULE_VFPDE;			
u32 gMODULE_HBPD;         
u32 gMODULE_HFPD;        
u32 gMODULE_HSPW;

void LCDM_DelayMS(u32 uMilli)
{
	DelayfrTimer(milli, uMilli);
}

void LCDM_DelayUS(u32 uMicro)
{
	DelayfrTimer(micro, uMicro);
}


void LCDM_BackLightOn(void)
{
	if(!BACKLIGHT_GPIO_ADDRESS)
		return;
	
	if(BACKLIGHT_ACTIVE == HIGH_ACTIVE)
		LCDM_BACKLIGHT_HIGH;
	else
		LCDM_BACKLIGHT_LOW;
}
void LCDM_BackLightOff(void)
{
	if(!BACKLIGHT_GPIO_ADDRESS)
		return;

	if(BACKLIGHT_ACTIVE == HIGH_ACTIVE)
		LCDM_BACKLIGHT_LOW;
	else
		LCDM_BACKLIGHT_HIGH;
}
void LCDM_ResetOn(void)
{
	if(!RESET_GPIO_ADDRESS)
		return;
	
	if(RESET_ACTIVE == HIGH_ACTIVE)
		LCDM_RESET_HIGH;
	else
		LCDM_RESET_LOW;
}
void LCDM_ResetOff(void)
{
	if(!RESET_GPIO_ADDRESS)
		return;

	if(RESET_ACTIVE == HIGH_ACTIVE)
		LCDM_RESET_LOW;
	else
		LCDM_RESET_HIGH;
}


void LCDM_Reset(uMilli) 
{
	LCDM_ResetOn();
	LCDM_DelayMS(uMilli);
	LCDM_ResetOff();
	LCDM_DelayMS(uMilli);
}

void LCDM_PowerOn(void)
{
	if(!POWER_GPIO_ADDRESS)
		return;

	if(POWER_ACTIVE == HIGH_ACTIVE)
		LCDM_POWER_HIGH;
	else
		LCDM_POWER_LOW;
}
void LCDM_PowerOff(void)
{
	if(!POWER_GPIO_ADDRESS)
		return;

	if(POWER_ACTIVE == HIGH_ACTIVE)
		LCDM_POWER_LOW;
	else
		LCDM_POWER_HIGH;
}

void LCDM_PowerOn2(void)
{
	if(!POWER_GPIO_ADDRESS2)
		return;

	if(POWER_ACTIVE == HIGH_ACTIVE)
		LCDM_POWER2_HIGH;
	else
		LCDM_POWER2_LOW;
}
void LCDM_PowerOff2(void)
{
	if(!POWER_GPIO_ADDRESS2)
		return;

	if(POWER_ACTIVE == HIGH_ACTIVE)
		LCDM_POWER2_LOW;
	else
		LCDM_POWER2_HIGH;
}


//without gpio.c
void LCDM_InitGPIO(u32 reg, u32 bitpos)
{
	u32 uDataValue;

	if(!reg)
		return;
	
	//output setting
	uDataValue = Inp32((reg));
	uDataValue = (uDataValue & ~(0xf<<bitpos*4)) | (1<<bitpos*4);
	Outp32((reg), uDataValue);

	//pull down disable
	uDataValue = Inp32((reg+0x8));
	uDataValue = (uDataValue & ~(0x3<<bitpos*2));
	Outp32((reg+0x8), uDataValue);

	//max drive strength
	uDataValue = Inp32((reg+0xc));
	uDataValue = ((uDataValue & ~(0x3<<bitpos*2)) | (0x3<<bitpos*2));
	Outp32((reg+0xc), uDataValue);

}


void LCDM_InitDISPConGPIO(void)
{
	if(gLCDM_INTERFACE_TYPE == RGB_PARALLEL_16bpp 
		|| gLCDM_INTERFACE_TYPE == RGB_PARALLEL_18bpp 
		|| gLCDM_INTERFACE_TYPE == RGB_PARALLEL_24bpp 
		|| gLCDM_INTERFACE_TYPE == RGB_DELTA_STRUCTURE 
		|| gLCDM_INTERFACE_TYPE == RGB_SERIAL)
	{
		
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	//--------- S5PV210 EVT0 needs MAX drive strength	---------//
	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	//-----------------------------------------------------------//
	
	}


	if(gLCDM_INTERFACE_TYPE == I80_CPU)
	{

	GPIO_SetFunctionAll(eGPIO_F0, 0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x33333333);	//set GPF1 as SYS_VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x33333333);	//set GPF2 as SYS_VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00303333);	//set GPF3 as SYS_VD[23:20], SYS_OE
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	//--------- S5PV210 EVT0 needs MAX drive strength	---------//
	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0xcff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	//-----------------------------------------------------------//
	}


}




 void iic_gpio_ack()
{
	//ack
	LCDM_IIC_SDA_LOW;
	Delay(10); //should be 10ms

	LCDM_IIC_SCL_LOW;
	Delay(10);
	LCDM_IIC_SCL_HIGH;
	Delay(10);
	LCDM_IIC_SCL_LOW;
	Delay(10);
}
void iic_write_serial(u8 data)
{
	int i;
	u8 bit;
		
	for( i = 0 ; i < 8 ; i++)
	{
		bit = (data>>(7-i))&1;
		if(bit)
			LCDM_IIC_SDA_HIGH;
		else
			LCDM_IIC_SDA_LOW;
		Delay(10);

		LCDM_IIC_SCL_LOW;
		Delay(10);
		LCDM_IIC_SCL_HIGH;
		Delay(10);
		LCDM_IIC_SCL_LOW;
		Delay(10);
	
	}

}
void iic_gpio_stop()
{
	//stop contidion
	LCDM_IIC_SCL_LOW;
	Delay(10);
	LCDM_IIC_SDA_LOW;
	Delay(10);

	LCDM_IIC_SCL_HIGH;
	Delay(10);
	LCDM_IIC_SDA_HIGH;
	Delay(10);
}
void iic_gpio_start()
{
	//start contidion
	LCDM_IIC_SDA_HIGH;
	Delay(10);
	LCDM_IIC_SCL_HIGH;
	Delay(10);

	LCDM_IIC_SDA_LOW;
	Delay(10);
	LCDM_IIC_SCL_LOW;
	Delay(10);

}

void iic_gpio_write(u8 slaveAddr, u8 regAddr, u8 data)
{
	Delay(10);
	Delay(10);
	
//	iic_gpio_stop();
//	iic_gpio_stop();

	iic_gpio_start();

	iic_write_serial(slaveAddr);
	iic_gpio_ack();

//	iic_gpio_start();

	iic_write_serial(regAddr);
	iic_gpio_ack();


	iic_write_serial(data);
	iic_gpio_ack();

	iic_gpio_stop();
}




void Write_LDI_LTS222Q(u32 uAddr, u32 uData)
{
	u32 uTemp;
	u32 i, j;

	LCDC_SetRsOnOff(0);		// RS signal low	
	LCDC_SetnWE(0);			// WE enable


	LCDM_CS_HIGH; // CS high
	LCDM_SCL_HIGH; // CLK high

	for (j=0; j<4; j++);

	LCDM_CS_LOW; // CS low

//	for (j=0; j<2; j++);
									
	for (i=7; i>=0; i--)
	{                                                               
		if (uAddr &  (1<<i))
		{      
			LCDM_SCL_LOW; // CLK low
			LCDM_SDA_HIGH; // DATA high

			for (j=0; j<2; j++);

			LCDM_SCL_HIGH; // CLK high
			//LCDM_SDA_HIGH; // DATA high	

			for (j=0; j<2; j++);
		}           

		else
		{                                                       
			LCDM_SCL_LOW; // CLK low
			LCDM_SDA_LOW; // DATA low

			for (j=0; j<2; j++);

			LCDM_SCL_HIGH; // CLK high
			//LCDM_SDA_LOW; // DATA low	

			for (j=0; j<2; j++);
		}
	}

	LCDM_CS_LOW; // CS low

////////////////////////////////////////////////

	LCDM_CS_HIGH; // CS high
	LCDM_SCL_HIGH; // CLK high

	for (j=0; j<4; j++);

	LCDM_CS_LOW; // CS low

//	for (j=0; j<2; j++);
									
	for (i=7; i>=0; i--)
	{                                                               
		if (uData &  (1<<i))
		{      
			LCDM_SCL_LOW; // CLK low
			LCDM_SDA_HIGH; // DATA high

			for (j=0; j<2; j++);

			LCDM_SCL_HIGH; // CLK high
			//LCDM_SDA_HIGH; // DATA high	

			for (j=0; j<2; j++);
		}           

		else
		{                                                       
			LCDM_SCL_LOW; // CLK low
			LCDM_SDA_LOW; // DATA low

			for (j=0; j<2; j++);

			LCDM_SCL_HIGH; // CLK high
			//LCDM_SDA_LOW; // DATA low	

			for (j=0; j<2; j++);
		}
	}

	LCDM_CS_LOW; // CS low

}



void Write_LDI_LTV350(u32 uAddr, u32 uData)
{
 	u8	dev_id_code=0x1D;
    	s8  	j;
	u8	DELAY=50;

	CalibrateDelay();
	
	LCDM_CS_HIGH; 		//	EN = High					CS high
	LCDM_SCL_HIGH;							//	SCL High
	LCDM_SDA_HIGH;							//	Data Low

	Delay(1);

	LCDM_CS_LOW; 		//	EN = Low				CS Low
	Delay(1);
	
	for (j = 5; j >= 0; j--)
	{	
		LCDM_SCL_LOW;							//	SCL Low

		if ((dev_id_code >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		Delay(1);

		LCDM_SCL_HIGH;			// CLOCK = High
		Delay(1);

	}
	
	// RS = "0" : index uData
	LCDM_SCL_LOW;			// CLOCK = Low
	LCDM_SDA_LOW;		// RS = 0
	Delay(1);
	LCDM_SCL_HIGH;			// CLOCK = High
	Delay(1);

	// Write (Low)
	LCDM_SCL_LOW;			// CLOCK = Low
	LCDM_SDA_LOW;		// Write
	Delay(1);
	LCDM_SCL_HIGH;			// CLOCK = High
	Delay(1);

	for (j = 15; j >= 0; j--)
	{
		LCDM_SCL_LOW;							//	SCL Low

		if ((uAddr >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		Delay(1);

		LCDM_SCL_HIGH;			// CLOCK = High
		Delay(1);

	}
	LCDM_SDA_HIGH;
	Delay(1);
	
	LCDM_CS_HIGH; 				// EN = High
	Delay(5*1);

	LCDM_CS_LOW; 		//	EN = Low				CS Low
	Delay(1);
	
	for (j = 5; j >= 0; j--)
	{	
		LCDM_SCL_LOW;							//	SCL Low

		if ((dev_id_code >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		Delay(1);

		LCDM_SCL_HIGH;			// CLOCK = High
		Delay(1);

	}
	
	// RS = "1" instruction uData
	LCDM_SCL_LOW;			// CLOCK = Low
	LCDM_SDA_HIGH;		// RS = 1
	Delay(1);
	LCDM_SCL_HIGH;			// CLOCK = High
	Delay(1);

	// Write
	LCDM_SCL_LOW;			// CLOCK = Low
	LCDM_SDA_LOW;		// Write
	Delay(1);
	LCDM_SCL_HIGH;			// CLOCK = High
	Delay(1);

	for (j = 15; j >= 0; j--)
	{
		LCDM_SCL_LOW;							//	SCL Low

		if ((uData >> j) & 0x0001)	// DATA HIGH or LOW
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		Delay(1);

		LCDM_SCL_HIGH;			// CLOCK = High
		Delay(1);

	}

	LCDM_SDA_HIGH;
	LCDM_CS_HIGH; 				// EN = High
	Delay(1);

}




void Write_LDI_AUO27(u32 address, u32 data)
{
	u32 dv = 1;
	u32 i;

	address<<=12;
	address&=0xf000;

	data&=0x7ff;

	data|=address;
	
	
	LCDM_CS_HIGH;
	LCDM_SCL_HIGH;
	LCDM_DelayMS(dv);


	LCDM_CS_LOW;
	LCDM_DelayMS(dv);

	for( i = 0 ; i < 16 ; i++)
	{
		LCDM_SCL_LOW;
		LCDM_DelayMS(dv);
		
		if(data&(1<<(15-i)))
			LCDM_SDA_HIGH;
		else
			LCDM_SDA_LOW;
		
		LCDM_DelayMS(dv);
		LCDM_SCL_HIGH;
		LCDM_DelayMS(dv);
	}

	LCDM_DelayMS(dv);
	LCDM_CS_HIGH;
	LCDM_DelayMS(dv);
}


void Write_LDI_TL2796(u16 uAddr, u16 uData)
{
	s32 j;


	if(uAddr != 0x0000)
	{
			LCDM_CS_HIGH;
			LCDM_SCL_HIGH;
		    LCDM_SDA_HIGH;
			   
			LCDM_CS_LOW;
			LCDM_SCL_LOW;

		    // Command
		    for (j = 15 ; j >= 0; j--)
			{
				LCDM_SCL_LOW;	

			    if ((uAddr >> j) & 0x0001)
			    {
			        LCDM_SDA_HIGH;
			    }
			    else
			    {
			        LCDM_SDA_LOW;
			    }
				LCDM_SCL_HIGH;		

			}
			
	}

	if(uAddr==0x0000)
	{
	       LCDM_SDA_HIGH;
	}
		
		LCDM_CS_HIGH;
		LCDM_SCL_HIGH;
		LCDM_CS_LOW;
		LCDM_SCL_LOW;

	// parameter
	for (j = 15 ; j >= 0; j--)
	{
		LCDM_SCL_LOW;	

	    if ((uData >> j) & 0x0001)
	    {
	        LCDM_SDA_HIGH;
	    }
	    else
	    {
	        LCDM_SDA_LOW;
	    }
	    LCDM_SCL_HIGH;
	}


		
}




 static void Write_LDI_LMS280GS01(u16 udata)

{

    int j;

    LCDM_CS_HIGH;
    LCDM_SCL_HIGH;
	LCDM_SDA_LOW;

     Delay(1);

     LCDM_CS_LOW;

    Delay(2); 

     //data write

//    for (j = 15; j >= 0; j--)
    for (j = 8; j >= 0; j--)
    {

        LCDM_SCL_LOW;

        

	    if ((udata >> j) & 0x0001)

        {

            LCDM_SDA_HIGH;

        }

        else

        {

            LCDM_SDA_LOW;

        }

 	   Delay(1);

       LCDM_SCL_HIGH;
	
 	   Delay(1);

    }   

 

//    LCDM_SCL_LOW;

// 	   Delay(100);

 	   Delay(1);

    LCDM_CS_HIGH;   

 	   Delay(5);

}
 


void Write_LDI_LTM030DK(u16 addr, u16 data)
{

#if 0	
	u8 devIDCode=0x1D;
    int j;
	u8 delay=50;
			
	LCDM_CS_HIGH; 		//	CS(EN) -> High	
	LCDM_SCL_HIGH;		//	SCL(DCLK) -> High
	LCDM_SDA_HIGH;		//	MOSI(DSERI) -> High

	delayLoop(delay);

	LCDM_CS_LOW; 		
	delayLoop(delay);

    #if 0 
	for (j = 5; j >= 0; j--)
	{	
		LCDM_SCL_LOW;	

		if ((devIDCode >> j) & 0x0001)
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		delayLoop(delay);

		LCDM_SCL_HIGH;	
		delayLoop(delay);

	}
	
    
	// RS = "0" : index data
	LCDM_SCL_LOW;			
	LCDM_SDA_LOW;
	delayLoop(delay);
	LCDM_SCL_HIGH;			
	delayLoop(delay);
    #endif
    
	// Write
	LCDM_SCL_LOW;			
	LCDM_SDA_LOW;
	delayLoop(delay);
	LCDM_SCL_HIGH;			
	delayLoop(delay);

	for (j = 7; j >= 0; j--)
	{
		LCDM_SCL_LOW;						

		if ((addr >> j) & 0x0001)	
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		delayLoop(delay);

		LCDM_SCL_HIGH;			
		delayLoop(delay);

	}
	LCDM_SDA_HIGH;
	delayLoop(delay);

    #if 0
	LCDM_CS_HIGH; 				
	delayLoop(delay*10);

	LCDM_CS_LOW; 		
	delayLoop(delay);
	
	for (j = 5; j >= 0; j--)
	{	
		LCDM_SCL_LOW;							

		if ((devIDCode >> j) & 0x0001)	
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		delayLoop(delay);

		LCDM_SCL_HIGH;			
		delayLoop(delay);
	}
	
	// RS = "1" instruction data
	LCDM_SCL_LOW;			
	LCDM_SDA_HIGH;
	delayLoop(delay);
	LCDM_SCL_HIGH;			
	delayLoop(delay);
    #endif
    
	// Write
	LCDM_SCL_LOW;			
	LCDM_SDA_LOW;
	delayLoop(delay);
	LCDM_SCL_HIGH;			
	delayLoop(delay);

	for (j = 7; j >= 0; j--)
	{
		LCDM_SCL_LOW;							

		if ((data >> j) & 0x0001)	
		{
			LCDM_SDA_HIGH;		
		}
		else
		{
			LCDM_SDA_LOW;
		}

		delayLoop(delay);

		LCDM_SCL_HIGH;			
		delayLoop(delay);
	}
	
	LCDM_CS_HIGH; 				
	delayLoop(delay);
    #else
    int j;

    LCDM_CS_HIGH;
    LCDM_SCL_LOW;

    Delay(10);

    LCDM_CS_LOW;
    Delay(10);

    //write operation and command selection	// 00000000b
    for (j = 7; j >= 0 ; j--)
    {
    	LCDM_SDA_LOW;
    	LCDM_SCL_LOW;
    Delay(10);
    	LCDM_SCL_HIGH;
    Delay(10);
    }
    LCDM_SCL_LOW;
    Delay(100);

    //addr write
    for (j = 7; j >= 0; j--)
    {
        LCDM_SCL_LOW;

         if ((addr >> j) & 0x0001)
        {
            LCDM_SDA_HIGH;
        }
        else
        {
            LCDM_SDA_LOW;
        }
    Delay(10);

        LCDM_SCL_HIGH;
    Delay(10);
    }

    LCDM_SCL_LOW;
    Delay(100);

    //write operation and data selection	// 00000001b
    for (j = 6; j >= 0 ; j--)
    {
    	LCDM_SDA_LOW;
    	LCDM_SCL_LOW;
    Delay(10);
    	LCDM_SCL_HIGH;
    Delay(10);
    }
	
    // data selection: set SDA high
    LCDM_SDA_HIGH;
    LCDM_SCL_LOW;
    Delay(10);
    LCDM_SCL_HIGH;
    Delay(10);

    // low...again
    LCDM_SCL_LOW;
    Delay(100);

    //data write
    for (j = 7; j >= 0; j--)
    {
        LCDM_SCL_LOW;

         if ((data >> j) & 0x0001)
        {
            LCDM_SDA_HIGH;
        }
        else
        {
            LCDM_SDA_LOW;
        }
            Delay(10);

        LCDM_SCL_HIGH;
            Delay(10);
    }

    LCDM_SCL_LOW;
        Delay(100);

    LCDM_CS_HIGH;	
        Delay(10);




    #endif
}




 static void Write_LDI_S6E63M0(u32 udata)

{

	int j;

	LCDM_CS_HIGH;
	LCDM_SCL_HIGH;
	LCDM_SDA_LOW;

	Delay(1);

	LCDM_CS_LOW;

	Delay(2); 

	//data write

//    for (j = 15; j >= 0; j--)
	for (j = 8; j >= 0; j--)
	{
		LCDM_SCL_LOW;

		if ((udata >> j) & 0x0001)
			LCDM_SDA_HIGH;
		else
			LCDM_SDA_LOW;

 	   	Delay(1);
		LCDM_SCL_HIGH;
		Delay(1);
	}   
	Delay(1);
	LCDM_CS_HIGH;   
	Delay(5);

}
 

void Write_LDI_AMS320FS01_0(u32 data,u32 size)
{
	u32 i;

	LCDM_CS_HIGH;
	LCDM_DelayUS(1);
	LCDM_SCL_HIGH;
	LCDM_DelayUS(1);


	LCDM_CS_LOW;
	LCDM_DelayUS(1);

	for( i = 0 ; i < size ; i++)
	{
		LCDM_SCL_LOW;
		LCDM_DelayUS(1);
		
		if(data&(1<<(size-1-i)))
			LCDM_SDA_HIGH;
		else
			LCDM_SDA_LOW;
		
		LCDM_DelayUS(1);
		LCDM_SCL_HIGH;
		LCDM_DelayUS(1);
	}

	LCDM_DelayUS(1);
	LCDM_CS_HIGH;
	LCDM_DelayUS(1);
}





void LCDM_InitLts222QForI80if(CPUIF_LDI eLdiMode)
{
	u32 temp;
	u32 uCmd[1];


 	
	// power funtion 1
	uCmd[0] = 0x2201; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100); // 50us, min. value. is 1
	uCmd[0] = 0x0301; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(500);	// 5ms
	
	//Initial funtion 1
	uCmd[0] = 0x00a0; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x0110; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x0200; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x0510; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x0d00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000); // 40ms, 40000us/120us = 333.33, in HCLK 20Mhz

	//Initial funtion 2
	uCmd[0] = 0x0e00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x0f01; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1000; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1100; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1200; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1300; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1400; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1500; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1600; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1700; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3401; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3500; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000); // 15 ms, 15000us/120us = 120, in HCLK 20Mhz

	//Initial funtion 3
	uCmd[0] = 0x8d01; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x8b28; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4b00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4c00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4d00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4e00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4f00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x5000; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x8600; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x8726; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x8802; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x8905; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3301; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3701; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100); // modified by kwan. letter
	uCmd[0] = 0x7600; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);	 // 15ms, 15000us/120us = 120 in HCLK 20Mhz

	//Initial funtion 4
	uCmd[0] = 0x4200; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4300; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4400; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4500; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x46ef; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4700; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4800; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4901; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4a3f; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3c00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3d00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3e01; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3f3f; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x4003; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100); // modified by kwan. letter
	uCmd[0] = 0x410a; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);

	//Initial funtion 5
	uCmd[0] = 0x8f00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x903f; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9133; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9277; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9377; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9417; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9500; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9600; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9733; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9877; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9977; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9a17; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9b00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9c00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x9d80; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);
	uCmd[0] = 0x1d08; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);
	
	//power funtion 2
	uCmd[0] = 0x2300; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(50);
	uCmd[0] = 0x2494; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(50);
	uCmd[0] = 0x256f; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000); 	// 40ms

	//power funtion 3
	uCmd[0] = 0x2810; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100); // modified by kwan. letter
	uCmd[0] = 0x1a00; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x2110; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1825; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);
	uCmd[0] = 0x1994; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100); // modified by kwan. letter
	uCmd[0] = 0x18e5; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);	 //40ms
	uCmd[0] = 0x18f7; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);
	uCmd[0] = 0x1b09; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);	 //40ms, modified by kwan. letter
	uCmd[0] = 0x1f78; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);// modified by kwan. letter
	uCmd[0] = 0x2045; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x1ec1; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);
	uCmd[0] = 0x2100; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(100);
	uCmd[0] = 0x3b01; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);	 //10ms
	uCmd[0] = 0x0020; LCDC_PutCmdToLdi(uCmd, 1, eLdiMode, LCD_NORMAL_CMD); Delay(4000);	 //40ms
}

void LCDM_InitUF24U276AorI80if(CPUIF_LDI eLdiMode)
{
	//Level2 command access
	LCDC_PutCmdToLdiByManual( 0xF0, eLdiMode); Delay(1);//(WRPWD)
	LCDC_PutDataToLdiByManual( 0x5A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x5A,eLdiMode); Delay(1);
                                  
	//Power Setting Sequence        
	LCDC_PutCmdToLdiByManual( 0xFF, eLdiMode); Delay(1);//(EDSTEST)
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x40,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF4, eLdiMode); Delay(1);//(VCOMCTL)
	LCDC_PutDataToLdiByManual( 0x64,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x64,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x75,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x75,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x55,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF3, eLdiMode); Delay(1);// (PWRCTL)
	LCDC_PutDataToLdiByManual( 0xFF,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x2E,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x0A,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x44,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x75,eLdiMode); Delay(1); 
                                  
	//Initializing Sequence         
	LCDC_PutCmdToLdiByManual( 0x35, eLdiMode); Delay(1); // MADCTL
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0x36, eLdiMode); Delay(1); // MADCTL
	LCDC_PutDataToLdiByManual( 0x48,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0x3A, eLdiMode); Delay(1);// COLMOD
	LCDC_PutDataToLdiByManual( 0x55,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF2, eLdiMode); Delay(1);//(DISCTL)
	LCDC_PutDataToLdiByManual( 0x0D,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x16,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x03,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x08,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x07,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x08,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x07,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x20,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x19,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x16,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF6, eLdiMode); Delay(1);//(SRCCTL)
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x80,eLdiMode); Delay(1);
                                  
	// Gamma Setting Sequence       
	LCDC_PutCmdToLdiByManual( 0xF5, eLdiMode); Delay(1);//(SRCCTL)
	LCDC_PutDataToLdiByManual( 0x10,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x06,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x05,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x30,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x14,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF7, eLdiMode); Delay(1);// (RPGAMCTL)
	LCDC_PutDataToLdiByManual( 0x80,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x2A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x2F,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x34,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x36,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x31,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x33,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x13,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x1B,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x33,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x28,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x14,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x22,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x21,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xF9, eLdiMode); Delay(1); // (GPGAMCTL)
	LCDC_PutDataToLdiByManual( 0x80,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x2A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x37,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x3A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x38,eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( 0x37,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x3C,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x08,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x0D,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x22,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x1F,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x0A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x22,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x20,eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0xFB, eLdiMode); Delay(1);//(GPGAMCTL)
	LCDC_PutDataToLdiByManual( 0x80,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x00,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x3A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x32,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x3B,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x39,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x38,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x3C,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x08,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x0D,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x20,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x1F,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x0A,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x22,eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( 0x20,eLdiMode); Delay(1);

	//Sleep out
	LCDC_PutCmdToLdiByManual( 0x11,eLdiMode); Delay(1);
	Delay(160);  //LCD Timing Margin (120->160)

	LCDC_PutCmdToLdiByManual( 0x29,eLdiMode); Delay(1);	// Diaplay On
   
	
}


void LCDM_InitLts222QForRgbif(void)
{
#if (LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI)
	
	GPIO_Init();
	

#else
	Assert(0);
#endif



	///////////////////////////////////////////////////////////////////
	// Power Setting Function 1
	//////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x22,0x01);	 // PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 1
	Write_LDI_LTS222Q(0x03,0x01);	 // RESET REGISTER

	///////////////////////////////////////////////////////////////////
	// Initializing Function 1
	///////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x00,0xa0); Delay(2); // CONTROL REGISTER 1, delay about 300ns
	Write_LDI_LTS222Q(0x01,0x10); Delay(2); // CONTROL REGISTER 2, delay about 300ns
	Write_LDI_LTS222Q(0x02,0x00); Delay(2);	// RGB INTERFACE REGISTER
	Write_LDI_LTS222Q(0x05,0x00); Delay(2);	// DATA ACCESS CONTROL REGISTER
	Write_LDI_LTS222Q(0x0D,0x00); Delay(132); // delay about 40ms

	///////////////////////////////////////////////////////////////////
	// Initializing Function 2
	///////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x0E,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x0F,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x10,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x11,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x12,0x00); Delay(2);  // delay about 300ns 
	Write_LDI_LTS222Q(0x13,0x00); Delay(2); // DISPLAY SIZE CONTROL REGISTER
	Write_LDI_LTS222Q(0x14,0x00); Delay(2); // PARTIAL-OFF AREA COLOR REGISTER 1
	Write_LDI_LTS222Q(0x15,0x00); Delay(2); // PARTIAL-OFF AREA COLOR REGISTER 2
	Write_LDI_LTS222Q(0x16,0x00); Delay(2);  // PARTIAL 1 DISPLAY AREA STARTING REGISTER 1
	Write_LDI_LTS222Q(0x17,0x00); Delay(2); // PARTIAL 1 DISPLAY AREA STARTING REGISTER 2
	Write_LDI_LTS222Q(0x34,0x01); Delay(2); // POWER SUPPLY SYSTEM CONTROL REGISTER 14
	Write_LDI_LTS222Q(0x35,0x00); Delay(132); // POWER SUPPLY SYSTEM CONTROL REGISTER 7

	////////////////////////////////////////////////////////////////////
	// Initializing Function 3
	////////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x8D,0x01); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x8B,0x28); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x4B,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x4C,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x4D,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x4E,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x4F,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x50,0x00); Delay(200);  //  ID CODE REGISTER 2, Check it out, delay about 50 ms
	Write_LDI_LTS222Q(0x86,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x87,0x26); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x88,0x02); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x89,0x05); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x33,0x01); Delay(2);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 13
	Write_LDI_LTS222Q(0x37,0x06); Delay(200); //  POWER SUPPLY SYSTEM CONTROL REGISTER 12, Check it out
	Write_LDI_LTS222Q(0x76,0x00); Delay(132); //  SCROLL AREA START REGISTER 2, delay about 30ms

	/////////////////////////////////////////////////////////////////////
	// Initializing Function 4
	/////////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x42,0x00); Delay(2); // delay about 300ns
	Write_LDI_LTS222Q(0x43,0x00); Delay(2); // delay about 300ns
	Write_LDI_LTS222Q(0x44,0x00); Delay(2); // delay about 300ns
	Write_LDI_LTS222Q(0x45,0x00); Delay(2); //  CALIBRATION REGISTER
	Write_LDI_LTS222Q(0x46,0xef); Delay(2);
	Write_LDI_LTS222Q(0x47,0x00); Delay(2);
	Write_LDI_LTS222Q(0x48,0x00); Delay(2);
	Write_LDI_LTS222Q(0x49,0x01); Delay(2);  //  ID CODE REGISTER 1							check it out
	Write_LDI_LTS222Q(0x4A,0x3f); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x3C,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x3D,0x00); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x3E,0x01); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x3F,0x3f); Delay(2);  // delay about 300ns
	Write_LDI_LTS222Q(0x40,0x01); Delay(2);  // delay about 300ns, horizontal back porch, 050105 Boaz.Kim
//	Write_LDI_LTS222Q(0x40,0x02); Delay(5); //	horizontal back porch	 //050105 Boaz.Kim
	Write_LDI_LTS222Q(0x41,0x0a); Delay(2); //	vertical back porch
//	Write_LDI_LTS222Q(0x41,0x08); Delay(5); //	vertical back porch
	Write_LDI_LTS222Q(0x8F,0x3f); Delay(132); // this value is more comfortable to look

	/////////////////////////////////////////////////////////////////////
	// Initializing Function 5
	/////////////////////////////////////////////////////////////////////


	Write_LDI_LTS222Q(0x90,0x3f); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x91,0x33); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x92,0x77); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x93,0x77); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x94,0x17); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x95,0x3f); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x96,0x00); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x97,0x33); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x98,0x77); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x99,0x77); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9A,0x17); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9B,0x07); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9C,0x07); Delay(5);  // delay about 300ns

/*
	Write_LDI_LTS222Q(0x90,0x05); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x91,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x92,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x93,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x94,0x33); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x95,0x05); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x96,0x05); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x97,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x98,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x99,0x44); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9A,0x33); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9B,0x33); Delay(5);  // delay about 300ns
	Write_LDI_LTS222Q(0x9C,0x33); Delay(5);  // delay about 300ns
*/

#if (LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SPI)
	Write_LDI_LTS222Q(0x9D,0x80); Delay(132); //	16 or 18bit RGB (BWS2="H": 16bit, BWS2="L": 18bit[default config in DualLcd b'd])		
#elif (LCD_MODEL == LCD_LTS222Q_SRGB)
	Write_LDI_LTS222Q(0x9D,0x81); Delay(132); //	6bit*3transfer RGB
#else 
	Assert(0);
#endif

	/////////////////////////////////////////////////////////////////////
	// Power Setting 2
	/////////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x1D,0x08); Delay(132); // delay about 50 us
	Write_LDI_LTS222Q(0x23,0x00); Delay(1); //  PARTIAL 2 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2
	Write_LDI_LTS222Q(0x24,0x94); Delay(1); //  POWER SUPPLY SYSTEM CONTROL REGISTER 1
	Write_LDI_LTS222Q(0x25,0x6f); Delay(132);  //  POWER SUPPLY SYSTEM CONTROL REGISTER 2

	/////////////////////////////////////////////////////////////////////
	// Power Setting 3
	/////////////////////////////////////////////////////////////////////
	Write_LDI_LTS222Q(0x28,0x1e); Delay(1); // 
	Write_LDI_LTS222Q(0x1A,0x00); Delay(1);// 
	Write_LDI_LTS222Q(0x21,0x10); Delay(1);//  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	Write_LDI_LTS222Q(0x18,0x25); Delay(1);//  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 40ms
	Delay(132);					
	Write_LDI_LTS222Q(0x19,0x48); Delay(1); //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 2
	Write_LDI_LTS222Q(0x18,0xe5);  Delay(1);//  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1

	// delay about 10ms
	Delay(132);					
	Write_LDI_LTS222Q(0x18,0xF7);  //  PARTIAL 2 DISPLAY AREA STARTING REGISTER 1 

	// delay about 40ms
	Delay(132);					
	Write_LDI_LTS222Q(0x1B,0x07);  // VS regulator ON at 4.5V

	// delay about 40ms
	Delay(132); 				
	Write_LDI_LTS222Q(0x1F,0x5a); Delay(1);
	Write_LDI_LTS222Q(0x20,0x54); Delay(1);
	Write_LDI_LTS222Q(0x1E,0xc1); Delay(1);

	// delay about 10ms
	Delay(33);					
	Write_LDI_LTS222Q(0x21,0x00); Delay(1);//  PARTIAL 1 DISPLAY AREA RASTER-ROW NUMBER REGISTER 2 
	Write_LDI_LTS222Q(0x3B,0x01); Delay(1); // 

	// delay about 20ms
	Delay(66);					
	Write_LDI_LTS222Q(0x00,0x20);  Delay(1);//  CONTROL REGISTER 1

#if (LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB)
	Write_LDI_LTS222Q(0x02,0x01);  //  RGB INTERFACE REGISTER
#elif (LCD_MODEL == LCD_LTS222Q_SPI)
	Write_LDI_LTS222Q(0x02,0x00);  //  SPI INTERFACE REGISTER
#else		//Disp("Wrong model in InitLTS222Q()\n");
	Assert(0);
#endif
	// delay about 10ms
	Delay(400);			

	// start addr setting
	Write_LDI_LTS222Q(0x44, 0x00);		// y addr 2
	Write_LDI_LTS222Q(0x42, 0x00);		// x addr
	Write_LDI_LTS222Q(0x43, 0x00);		// y addr 1
}


void LCDM_InitLtv350QVForRgbif(void)
{	

/*
	// LCD module reset
	rGPBDAT |= (1<<1);
	rGPBDAT &= ~(1<<1); // goes to LOW
	// delay about 5ms
	delayLoop(LCD_DELAY_1MS*10);	
	rGPBDAT |= (1<<1);  // goes to HIGH

	//debug_continue = TRUE;
	debug_continue = FALSE;
*/

/*


	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00002222);	//set GPF4 as VD[23:20]
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set TOUT3 as Output signal for PWRRESET
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High

	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);
*/
	
/*
	Outp32(0xe0200040,0x11110100);	//set spi1 signal as output signal, SPI0MISO as output signal(for RESET (fit1 bug))
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);

	// Reset
	Outp32(0xe0200044,0x4);			// Reset High
	Delay(3);
	Outp32(0xe0200044,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe0200044,0x4);			// Reset High
*/
	

	
/*
	// pull-up pull-down disable
	rGPLUDP &= ~(((3<<(LCD_DEN_BIT*2))) | ((3<<(LCD_DCLK_BIT*2))) | ((3<<(LCD_DSERI_BIT*2))));	
	rGPLUDP |= (((2<<(LCD_DEN_BIT*2))) | ((2<<(LCD_DCLK_BIT*2))) | ((2<<(LCD_DSERI_BIT*2))));
	
	// delay about 5ms
	delayLoop(LCD_DELAY_1MS*10);	
*/

	LCDM_CS_HIGH;
	LCDM_SCL_HIGH;
	LCDM_SDA_HIGH;	

	///////////////////////////////////////////////////////////////////
	// Init_Lcd_Function
	//////////////////////////////////////////////////////////////////
#if LTV350
	Write_LDI_LTV350(0x01,0x001d);	
	Write_LDI_LTV350(0x02,0x0000);    
    Write_LDI_LTV350(0x03,0x0000);    
    Write_LDI_LTV350(0x04,0x0000);
    Write_LDI_LTV350(0x05,0x50a3);
    Write_LDI_LTV350(0x06,0x0000);
    Write_LDI_LTV350(0x07,0x0000);
    Write_LDI_LTV350(0x08,0x0000);
   	Write_LDI_LTV350(0x09,0x0000);
   	Write_LDI_LTV350(0x0a,0x0000);
   	Write_LDI_LTV350(0x10,0x0000);
   	Write_LDI_LTV350(0x11,0x0000);
   	Write_LDI_LTV350(0x12,0x0000);
   	Write_LDI_LTV350(0x13,0x0000);
   	Write_LDI_LTV350(0x14,0x0000);
   	Write_LDI_LTV350(0x15,0x0000);
   	Write_LDI_LTV350(0x16,0x0000);
   	Write_LDI_LTV350(0x17,0x0000);
   	Write_LDI_LTV350(0x18,0x0000);
   	Write_LDI_LTV350(0x19,0x0000);
#else
	Write_LDI_LTV350(0x09,0x0000);
#endif
	///////////////////////////////////////////////////////////////////
	// Power On Reset Display off State
	//////////////////////////////////////////////////////////////////
	//Write_LDI_LTV350(0x09,0x0000);

	Delay(33);
	// delay about 10ms
//	delayLoop(LCD_DELAY_1MS*10);
	
	///////////////////////////////////////////////////////////////////
	// Power Setting Function 1
	//////////////////////////////////////////////////////////////////
#if LTV350
	Write_LDI_LTV350(0x09,0x4055);
	Write_LDI_LTV350(0x0a,0x0000);
#else
	Write_LDI_LTV350(0x09,0x4055);
	Write_LDI_LTV350(0x0a,0x2000);
#endif

	Delay(132);
	// delay about 40ms
//	delayLoop(LCD_DELAY_1MS*10);
	
	/////////////////////////////////////////////////////////////////////
	// Power Setting 2
	/////////////////////////////////////////////////////////////////////
#if LTV350
	Write_LDI_LTV350(0x0a,0x2000);
#else
	Write_LDI_LTV350(0x09,0x4055);
#endif

	Delay(50);
	// delay about 50ms
//	delayLoop(LCD_DELAY_1MS*50);
	
	///////////////////////////////////////////////////////////////////
	// Instruction Setting
	///////////////////////////////////////////////////////////////////
#if LTV350
	Write_LDI_LTV350(0x01,0x409d);
	Write_LDI_LTV350(0x02,0x0204);
	Write_LDI_LTV350(0x03,0x2100);
	Write_LDI_LTV350(0x04,0x1000);
	Write_LDI_LTV350(0x05,0x5003);
	Write_LDI_LTV350(0x06,0x0009);	//vbp
	Write_LDI_LTV350(0x07,0x000f);	//hbp
	Write_LDI_LTV350(0x08,0x0800);
	Write_LDI_LTV350(0x10,0x0000);
	Write_LDI_LTV350(0x11,0x0000);
	Write_LDI_LTV350(0x12,0x000f);
	Write_LDI_LTV350(0x13,0x1f00);
	Write_LDI_LTV350(0x14,0x0000);
	Write_LDI_LTV350(0x15,0x0000);
	Write_LDI_LTV350(0x16,0x0000);
	Write_LDI_LTV350(0x17,0x0000);
	Write_LDI_LTV350(0x18,0x0000);
	Write_LDI_LTV350(0x19,0x0000);
#else
	Write_LDI_LTV350(0x01,0x409d);
	Write_LDI_LTV350(0x02,0x0204);
	Write_LDI_LTV350(0x03,0x0100);
	Write_LDI_LTV350(0x04,0x3000);
	Write_LDI_LTV350(0x05,0x4003);
	Write_LDI_LTV350(0x06,0x0009);	//vbp
	Write_LDI_LTV350(0x07,0x000f);	//hbp
	Write_LDI_LTV350(0x08,0x0c00);
	Write_LDI_LTV350(0x10,0x0103);
	Write_LDI_LTV350(0x11,0x0301);
	Write_LDI_LTV350(0x12,0x1f0f);
	Write_LDI_LTV350(0x13,0x1f0f);
	Write_LDI_LTV350(0x14,0x0707);
	Write_LDI_LTV350(0x15,0x0307);
	Write_LDI_LTV350(0x16,0x0707);
	Write_LDI_LTV350(0x17,0x0000);
	Write_LDI_LTV350(0x18,0x0004);
	Write_LDI_LTV350(0x19,0x0000);
#endif
	

	Delay(198);
	// delay about 2 frames(60ms)
//	delayLoop(LCD_DELAY_1MS*50);
	

	///////////////////////////////////////////////////////////////////
	// Display On Sequence
	///////////////////////////////////////////////////////////////////
#if LTV350
	Write_LDI_LTV350(0x09,0x4a55);
	Write_LDI_LTV350(0x0a,0x2000);	
#else
	Write_LDI_LTV350(0x09,0x4a55);
	Write_LDI_LTV350(0x05,0x5003);	

#endif
 	Delay(10);
}


void LCDM_InitAUO27_SKIP(void)
{
/*
	Write_LDI_AUO27(0,	0x35);//reset
	Write_LDI_AUO27(0,	0x3d);//reset recover
	Write_LDI_AUO27(1,	0x0);//ups051 mode ???
	Write_LDI_AUO27(9,0x0);//external vcomdc

	Write_LDI_AUO27(0, 0x00);
	Write_LDI_AUO27(1, 0x00);
	Write_LDI_AUO27(2, 0x6c);
//	Write_LDI_AUO27(2, 0xff);
	Write_LDI_AUO27(3, 0x00);
	Write_LDI_AUO27(4, 0x52);
	Write_LDI_AUO27(5, 0x0a);
	Write_LDI_AUO27(6, 0x38);
	Write_LDI_AUO27(8, 0x07);
	Write_LDI_AUO27(9, 0xd);
*/

/* from CAM (Original)
	Write_LDI_AUO27(0,	0x05);//reset
	Write_LDI_AUO27(0,	0x0d);//reset recover
	Write_LDI_AUO27(1,	0x00);//ups051 mode ???
//	Write_LDI_AUO27(9,0x4b);//internal vcomdc
	Write_LDI_AUO27(9,0xb);//external vcomdc

	Write_LDI_AUO27(0, 0x00);
	Write_LDI_AUO27(1, 0x00);
	Write_LDI_AUO27(2, 0x6c);
	Write_LDI_AUO27(3, 0x00);
	Write_LDI_AUO27(4, 0x52);
	Write_LDI_AUO27(5, 0x0a);
	Write_LDI_AUO27(6, 0x38);
	Write_LDI_AUO27(8, 0x07);
	Write_LDI_AUO27(9, 0xd);
*/
/*// HYungYeon
	Write_LDI_AUO27(0,0x35);//reset
	Write_LDI_AUO27(0,0x3d);//reset recover
	Write_LDI_AUO27(1 , 0x11);//ups051 mode ???
	Write_LDI_AUO27(4 , 0x57);

	//Write_LDI_AUO27(0x9 , 0x4b);//internal vcomdc
	Write_LDI_AUO27(9 , 0x0);//external vcomdc 

	Write_LDI_AUO27(2 , 0x46);
	Write_LDI_AUO27(3 , 0x7);
	Write_LDI_AUO27(5 , 0x8);
	Write_LDI_AUO27(6 , 0x40);
	Write_LDI_AUO27(8 , 0x7);
	Write_LDI_AUO27(11 , 0x64);
	Write_LDI_AUO27(12 , 0x24);
	Write_LDI_AUO27(13 , 0x24);
*/

// Woojin
	Write_LDI_AUO27(0,	0x5);//reset
	Write_LDI_AUO27(0,	0xd);//reset recover
	Write_LDI_AUO27(1,	0x0);//ups051 mode 27MHz
//	Write_LDI_AUO27(9,0x4b);//internal vcomdc
	Write_LDI_AUO27(9,0x0);//external vcomdc

//	Write_LDI_AUO27(0, 0x00);
//	Write_LDI_AUO27(1, 0x00);
	Write_LDI_AUO27(2, 0x6c);
	Write_LDI_AUO27(3, 0x00);
//	Write_LDI_AUO27(4, 0x57);
	Write_LDI_AUO27(4, 0x52);
	Write_LDI_AUO27(5, 0x0a);
	Write_LDI_AUO27(6, 0x38);
	Write_LDI_AUO27(8, 0x07);
//	Write_LDI_AUO27(9, 0xd);

}

void LCDM_InitS6E63M0(void)
{
	u32 i;
	u32* pCmd;
	u32 uValue;
	
	u32 cmd[] = {
/*		
	0xb3,
		0x163, 0xc0, 0x32, 0x02,

	//===== GAMMA SET FROM SMD====
	0xfa,
		0x00, 0x18, 0x08, 0x24, 0x5b, 0x58, 0x45, 0xb4, 0xbc, 0xae, 0xb3, 0xb8, 0xaa, 0xc6, 0xc7, 0xbd, 
		0x00, 0xbc, 0x00, 0xbb, 0x00, 0xec, // gamma 300%
	0xf2, 
		0x02, 0x03, 0x1c, 0x0E, 0x10, 
	0xfa, 
		0x01, // gamma update enable set
	0xf7, 
		0x00, // GTCON set


	//=========== pentile SMD spec. code =======================
	0xb4, 
		0x00, 0x00, 0x00, //penteile gamma offeset
	0xb5, 
		0x2c, 0x12, 0x0c, 0x0a, 0x10, 0x0e, 0x17, 0x13, 0x1f, 0x1a, 0x2a, 0x24, 0x1f, 0x1b, 0x1a, 0x17,
		0x2b, 0x26, 0x22, 0x20, 0x3a, 0x34, 0x30, 0x2c, 0x29, 0x26, 0x25, 0x23, 0x21, 0x20, 0x1e, 0x1e, // delta Y for red
	0xb6, 
		0x00, 0x00, 0x11, 0x22, 0x33, 0x44, 0x44, 0x44, 0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, //delta, 0xX, 0xfor, 0xred
	0xb7, 
		0x2c, 0x12, 0x0c, 0x0a, 0x10, 0x0e, 0x17, 0x13, 0x1f, 0x1a, 0x2a, 0x24, 0x1f, 0x1b, 0x1a, 0x17, 
		0x2b, 0x26, 0x22, 0x20, 0x3a, 0x34, 0x30, 0x2c, 0x29, 0x26, 0x25, 0x23, 0x21, 0x20, 0x1e, 0x1e, //delta, 0xY, 0xfor, 0xgreen
	0xb8, 
		0x00, 0x00, 0x11, 0x22, 0x33, 0x44, 0x44, 0x44, 0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, //delta, 0xX, 0xfor, 0xgreen
	0xb9, 
		0x2c, 0x12, 0x0c, 0x0a, 0x10, 0x0e, 0x17, 0x13, 0x1f, 0x1a, 0x2a, 0x24, 0x1f, 0x1b, 0x1a, 0x17, 
		0x2b, 0x26, 0x22, 0x20, 0x3a, 0x34, 0x30, 0x2c, 0x29, 0x26, 0x25, 0x23, 0x21, 0x20, 0x1e, 0x1e, //delta, 0xY, 0xfor, 0xblue
	0xba, 
		0x00, 0x00, 0x11, 0x22, 0x33, 0x44, 0x44, 0x44, 0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, //delta, 0xx, 0xfor, 0xblue
	//===============================================

	0xf8,
		0x01, 0x26, 0x26, 0x07, 0x07, 0x53, 0x9b, 0x61, 0x82, 0x19, 0x32, 0x0d, 0x00, 0x00,
	0xf6,
		0x00, 0x8c, 0x07,
	0xf4,
		0xcf, 0x05, 0x07, 0x10, 0x19, 0x33, 0x02,
	0x11,
*/

	0xf0, 
		0x15a, 0x15a,
	0xf1, 
		0x15a, 0x15a,
	0xfc, 
		0x15a, 0x15a,
	0x35, 
		0x100,

	0xb3,
		0x163, 0x1c0, 0x132, 0x102,

	//===== GAMMA SET FROM SMD====
	0xfa,
		0x100, 0x118, 0x108, 0x124, 0x15b, 0x158, 0x145, 0x1b4, 0x1bc, 0x1ae, 0x1b3, 0x1b8, 0x1aa, 0x1c6, 0x1c7, 0x1bd, 
		0x100, 0x1bc, 0x100, 0x1bb, 0x100, 0x1ec, // gamma 300%
	0xf2,                             
		0x102, 0x103, 0x11c, 0x10E, 0x110,
	0xfa,                             
		0x101, // gamma1 updat1e enable set
	0xf7,                             
		0x100, // GTCON set              
            
            
	//=========== pentile SMD spec. code =======================
	0xb4,     
		0x100, 0x100, 0x100, //penteile gamma offeset
	0xb5,     
		0x12c, 0x112, 0x10c, 0x10a, 0x110, 0x10e, 0x117, 0x113, 0x11f, 0x11a, 0x12a, 0x124, 0x11f, 0x11b, 0x11a, 0x117,
		0x12b, 0x126, 0x122, 0x120, 0x13a, 0x134, 0x130, 0x12c, 0x129, 0x126, 0x125, 0x123, 0x121, 0x120, 0x11e, 0x11e, // delta Y for red
	0xb6,                                              
		0x100, 0x100, 0x111, 0x122, 0x133, 0x144, 0x144, 0x144, 0x155, 0x155, 0x166, 0x166, 0x166, 0x166, 0x166, 0x166, //delta, 0xX, 0xfor, 0xred
	0xb7,                                              
		0x12c, 0x112, 0x10c, 0x10a, 0x110, 0x10e, 0x117, 0x113, 0x11f, 0x11a, 0x12a, 0x124, 0x11f, 0x11b, 0x11a, 0x117, 
		0x12b, 0x126, 0x122, 0x120, 0x13a, 0x134, 0x130, 0x12c, 0x129, 0x126, 0x125, 0x123, 0x121, 0x120, 0x11e, 0x11e, //delta, 0xY, 0xfor, 0xgreen
	0xb8,                                              
		0x100, 0x100, 0x111, 0x122, 0x133, 0x144, 0x144, 0x144, 0x155, 0x155, 0x166, 0x166, 0x166, 0x166, 0x166, 0x166, //delta, 0xX, 0xfor, 0xgreen
	0xb9,                                              
		0x12c, 0x112, 0x10c, 0x10a, 0x110, 0x10e, 0x117, 0x113, 0x11f, 0x11a, 0x12a, 0x124, 0x11f, 0x11b, 0x11a, 0x117, 
		0x12b, 0x126, 0x122, 0x120, 0x13a, 0x134, 0x130, 0x12c, 0x129, 0x126, 0x125, 0x123, 0x121, 0x120, 0x11e, 0x11e, //delta, 0xY, 0xfor, 0xblue
	0xba,                                              
		0x100, 0x100, 0x111, 0x122, 0x133, 0x144, 0x144, 0x144, 0x155, 0x155, 0x166, 0x166, 0x166, 0x166, 0x166, 0x166, //delta, 0xx, 0xfor, 0xblue
	//===============================================  
                                                     
	0xf8,                                              
		0x101, 0x126, 0x126, 0x107, 0x107, 0x153, 0x19b, 0x161, 0x182, 0x119, 0x132, 0x10d, 0x100, 0x100,
	0xf6,     
		0x100, 0x18c, 0x107,
	0xf4,     
		0x1cf, 0x105, 0x107, 0x110, 0x119, 0x133, 0x102,
	0x11,
	REG_END
		
		};

	pCmd = cmd;
	
	while(1)
	{
		uValue = *pCmd;
		if(uValue==REG_END)
			break;
		else
			Write_LDI_S6E63M0(uValue);
		pCmd++;
	}
	

}

void LCDM_InitTL2796(void)
{
    Delay(100); // more than 20ms	
	//[1] Panel Condition Set
	Write_LDI_TL2796(0x7031, 0x7208);
	Write_LDI_TL2796(0x7032, 0x7214);
	Write_LDI_TL2796(0x7030, 0x7202);
	
#if 1
	Write_LDI_TL2796(0x7027, 0x7203);
#else
	Write_LDI_TL2796(0x7027, 0x7201);
#endif
	
	//[2] Display Condition Set(RGB Data Interface)
	Write_LDI_TL2796(0x7012, 0x7208); //0x7208
	Write_LDI_TL2796(0x7013, 0x7208);
#if 1
	Write_LDI_TL2796(0x7015, 0x7210); //0x10
#else
	Write_LDI_TL2796(0x7015, 0x7200); //0x00
#endif
	Write_LDI_TL2796(0x7016, 0x7200);	//00 24bit 02 16bit RGB interface 
	Write_LDI_TL2796(0x70ef, 0x72d0);	
	Write_LDI_TL2796(0x0000, 0x72e8);	

	// set gamma control 230cd
	Write_LDI_TL2796(0x7039, 0x7244);	
	Write_LDI_TL2796(0x7040, 0x7200); 
	Write_LDI_TL2796(0x7041, 0x723F); 
	Write_LDI_TL2796(0x7042, 0x722B); 
	Write_LDI_TL2796(0x7043, 0x721f); 
	Write_LDI_TL2796(0x7044, 0x7224); 
	Write_LDI_TL2796(0x7045, 0x721b); 
	Write_LDI_TL2796(0x7046, 0x7229); 
	Write_LDI_TL2796(0x7050, 0x7200); 
	Write_LDI_TL2796(0x7051, 0x7200); 
	Write_LDI_TL2796(0x7052, 0x7200); 
	Write_LDI_TL2796(0x7053, 0x721b); 
	Write_LDI_TL2796(0x7054, 0x7222); 
	Write_LDI_TL2796(0x7055, 0x721b); 
	Write_LDI_TL2796(0x7056, 0x722a); 
	Write_LDI_TL2796(0x7060, 0x7200); 
	Write_LDI_TL2796(0x7061, 0x723F); 
	Write_LDI_TL2796(0x7062, 0x7225); 
	Write_LDI_TL2796(0x7063, 0x721c); 
	Write_LDI_TL2796(0x7064, 0x7221); 
	Write_LDI_TL2796(0x7065, 0x7218); 
	Write_LDI_TL2796(0x7066, 0x723e); 

	//Analog Power Condition Set
	Write_LDI_TL2796(0x7017, 0x7222);	//Boosting Freq
	Write_LDI_TL2796(0x7018, 0x7233);	//power AMP Medium
	Write_LDI_TL2796(0x7019, 0x7203);	//Gamma Amp Medium
	Write_LDI_TL2796(0x701a, 0x7201);	//Power Boosting 
	Write_LDI_TL2796(0x7022, 0x72a4);	//Vinternal = 0.65*VCI
	Write_LDI_TL2796(0x7023, 0x7200);	//VLOUT1 Setting = 0.98*VCI
	Write_LDI_TL2796(0x7026, 0x72a0);	//Display Condition LTPS signal generation : Reference= DOTCLK

	//Stand-by Off Comman
	Write_LDI_TL2796(0x701d, 0x72a0);

	Delay(1000); // more than 250ms		

	//LCD ON
	Write_LDI_TL2796(0x7014, 0x7203);	

}


void LCDM_OffTL2796(void)
{

	//TL2796 off
	Write_LDI_TL2796(0x7014, 0x7200);
	LCDM_BackLightOff();		// BL High	
}


void LCDM_InitLMS280GS01(void)
{
	u32 i;
	
	u16 LMS280GS01_Dis_On[] = {


		0x0F0, //(WRPWD)
			0x15A,
			0x15A,

		0x0f3,
			0x100,

		0x0FF, //(EDSTEST)
			0x100,
			0x100,
			0x100,
			0x140,

		0x011,		// sleep out

		0x1ff,	200, // Delay 20ms

			// Power setting Sequence
		0x0f3,
			0x101,
			0x126,
			0x126,
			0x10B,
			0x122,
			0x166,
			0x160,
			0x12C,
			
		0x0f4,
			0x15D,
			0x160,
			0x16D,
			0x16D,
			0x144,

		0x0f5,
			0x112,	//need to be check (different between spec(0x102) and code fr TN(0x112)
			0x111,
			0x10A,
			0x1F0,
			0x133,
			0x11F,

		0x1ff,	400,	//Delay 40ms

		0x0f3,
			0x103,

		0x1ff,	200,	//Delay 20ms

		0x0ff,
			0x100,
			0x100,
			0x100,
			0x160,

		0x1ff,	200,	//Delay 20ms

		0x0f3,
			0x107,

		0x0ff,
			0x100,
			0x100,
			0x100,
			0x170,

		0x1ff,	400,	//Delay 40ms

		0x0f3,
			0x10f,

		0x0ff,
			0x100,
			0x100,
			0x100,
			0x178,

		0x1ff,	400,	//Delay 40ms

		0x0f3,
			0x11f,

		0x1ff,	400,	//Delay 40ms

		0x0f3,
			0x13f,

		0x1ff,	600,	//Delay 60ms

		0x0ff,
			0x100,
		0x0f2,
			0x116,
			0x116,
			0x101,
			0x10f,
			0x10f,
			0x10f,
			0x10f,
			0x11f,
			0x100,
			0x110,
			0x110,

		0x0fd,
			0x122,


			//Initializing Sequence

		0x03A,
			0x177,

		0x036,
			0x148,

		0x0f6,
			0x100,
			0x101,
			0x100,
			0x110,


			// Gamma setting Sequence

		0x0f7,		0x193,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x120,0x124,0x12b,0x125,0x10a,0x111,0x111,
		0x0f8,		0x180,0x104,0x117,0x11A,0x11D,0x11E,0x123,0x12E,0x114,0x117,0x124,0x120,0x106,0x111,0x111,
  		0x0F9,   	0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
 		0x0Fa,   	0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,
		0x0Fb,  	0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
		0x0Fc,   	0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,

			//B/L(CABC) Setting Sequence

		0x051,
			0x150,	// spec 0x17e code 0x150

		0x055,
			0x102,

		0x05e,
			0x100,

		0x0ca,
			0x180,
			0x180,
			0x120,

		0x0cb,		// only at code
			0x103,		// only at code

		0x0cc,
			0x13c,

		0x0cd,		// only at code
			0x153,		// only at code
			0x11e,		// only at code
		
			//-----------------------

		0x0f3,
			0x17f,

			//Display on
		0x029,

			//B/L(CABC) On
//
		0x0CB,
			0x103,

		0x0CD,
			0x17f,
			0x11e,

		0x055,
			0x102,	// turn on BL_PWM

		0x051,
			0x17e,

		0x053,
			0x12c,
//
		0x1ee		// end

	};

	u16 LMS280GS01_Dis_OnDouble[] = {


	0x1ff,  100, 
	0x0F0,  0x15A, 0x15A,
	0x0F3,  0x100,  // APON =0  
	0x0FF,  0x100, 0x100, 0x100, 0x140, 
	0x011, 
	0x1ff,  100, 

	 

	//----------------------------------------

	// Power Setting Sequence   
	0x0F3,  0x101, 0x126,0x126,0x10B,0x122,0x166,0x160, 0x12C,
	0x0F4,  0x15D,0x160,0x16D,0x16D,0x144, 
	0x0F5,  0x112,0x111,0x10A,0x1F0,0x133,0x11F,
	0x1ff,  200, 

	 

	// power sequence
	    0x0F3,  0x103,
	    0x1ff,  100, 
	    0x0FF,  0x100/*0x130*/, 0x100,0x100,0x160,  // 2008.6.19  AMLCD  û
	    0x1ff,  100, 
	    0x0F3,  0x107,
	    0x0FF,  0x100/*0x130*/,0x100,0x100,0x170,
	    0x1ff,  200, 
	    0x0F3,  0x10F,
	    0x0FF,  0x100/*0x130*/,0x100,0x100,0x178,
	    0x1ff,  200, 
	    0x0F3,  0x11F,
	    0x1ff,  200, 
	    0x0F3,  0x13F,
	    0x1ff,  300, 
	    0x0FF,  0x100,
	    0x0F2,  0x116,0x116,0x101,0x10F,0x10F,0x10F,0x10F,0x11F,0x100,0x110,0x110,
	    0x0FD,  0x122,

	 

	// Initializing Sequence
	     0x03A,   0x177,
	     0x036,   0x148, // 4/7
	     0x0F6,   0x100, 0x101,0x100,0x110,

	 

	// Gamma Setting Sequence
	// -- Gamma LCD   üʹ ϹǷ .
	    0x0F7,    0x193,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x120,0x124,0x12b,0x125,0x10a,0x111,0x111,
	    0x0F8,    0x180,0x104,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x114,0x117,0x124,0x120,0x106,0x111,0x111,
	    0x0F9,    0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
	    0x0Fa,    0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,
	    0x0Fb,    0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
	    0x0Fc,    0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,



	 

	// backlight, cabc control Sequence

	0x051, 0x150,
	     //0x053, 0x12c,
	     //0x055, 0x102,    // MIE on/off control
	     0x055, 0x100,    // MIE on/off control
	     0x05E, 0x100,    // backlight minimum.(0)
	     0x0CA, 0x180, 0x180, 0x120, 
	     0x0CB, 0x103,   // merged.
	     0x0CC, 0x13C,   //   
	     0x0CD, 0x153, 0x11E, // PWM=(53 form 7F), DT=3, STEP=2

	 
	    0x0F3,  0x17F,  //GON=1
	    0x029,          // Display On

	//----------------------------------------
	0x011, 
	0x1ff,  100, 

	 

	//----------------------------------------

	// Power Setting Sequence   
	0x0F3,  0x101, 0x126,0x126,0x10B,0x122,0x166,0x160, 0x12C,
	0x0F4,  0x15D,0x160,0x16D,0x16D,0x144, 
	0x0F5,  0x112,0x111,0x10A,0x1F0,0x133,0x11F,
	0x1ff,  200, 
	 

	// power sequence
	    0x0F3,  0x103,
	    0x1ff,  100, 
	    0x0FF,  0x100/*0x130*/, 0x100,0x100,0x160,  // 2008.6.19  AMLCD  û
	    0x1ff,  100, 
	    0x0F3,  0x107,
	    0x0FF,  0x100/*0x130*/,0x100,0x100,0x170,
	    0x1ff,  200, 
	    0x0F3,  0x10F,
	    0x0FF,  0x100/*0x130*/,0x100,0x100,0x178,
	    0x1ff,  200, 
	    0x0F3,  0x11F,
	    0x1ff,  200, 
	    0x0F3,  0x13F,
	    0x1ff,  300, 
	    0x0FF,  0x100,
	    0x0F2,  0x116,0x116,0x101,0x10F,0x10F,0x10F,0x10F,0x11F,0x100,0x110,0x110,
	    0x0FD,  0x122,
	 

	// Initializing Sequence
	     0x03A,   0x177,
	     0x036,   0x148, // 4/7
	     0x0F6,   0x100, 0x101,0x100,0x110,

	 

	// Gamma Setting Sequence

	//-- Gamma LCD   üʹ ϹǷ .
	    0x0F7,    0x193,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x120,0x124,0x12b,0x125,0x10a,0x111,0x111,
	    0x0F8,    0x180,0x104,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x114,0x117,0x124,0x120,0x106,0x111,0x111,
	    0x0F9,    0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
	    0x0Fa,    0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,
	    0x0Fb,    0x18f,0x115,0x12b,0x12c,0x130,0x129,0x126,0x127,0x11e,0x122,0x129,0x123,0x108,0x111,0x111,
	    0x0Fc,    0x180,0x100,0x117,0x11a,0x11d,0x11e,0x123,0x12e,0x112,0x115,0x122,0x11e,0x104,0x111,0x111,


	 

	// backlight, cabc control Sequence

	0x051, 0x150,

	     //0x053, 0x12c,
	     //0x055, 0x102,    // MIE on/off control
	     0x055, 0x100,    // MIE on/off control
	     0x05E, 0x100,    // backlight minimum.(0)
	     0x0CA, 0x180, 0x180, 0x120, 
	     0x0CB, 0x103,   // merged.
	     0x0CC, 0x13C,   //   
	     0x0CD, 0x153, 0x11E, // PWM=(53 form 7F), DT=3, STEP=2

	    0x0F3,  0x17F,  //GON=1
	    0x029,          // Display On
	0x1ee
		};



	i = 0;
	
	while(!(LMS280GS01_Dis_On[i] == 0x1ee))
	{
		if(LMS280GS01_Dis_On[i] == 0x1ff)
		{
			i ++;
			Delay(LMS280GS01_Dis_On[i]);
			i ++;
		}
		else
		{		
			Write_LDI_LMS280GS01(LMS280GS01_Dis_On[i]);
				i++;
		}
	}

/*
	while(!(LMS280GS01_Dis_OnDouble[i] == 0x1ee))
	{
		if(LMS280GS01_Dis_OnDouble[i] == 0x1ff)
		{
			i ++;
			Delay(LMS280GS01_Dis_OnDouble[i]);
			i ++;
		}
		else
		{		
			Write_LDI_LMS280GS01(LMS280GS01_Dis_OnDouble[i]);
				i++;
		}
	}
*/

	
}



void LCDM_SetALCforLTM030DK(void)
{

 
	iic_gpio_write(0xec, 0x01, 0x11); 
	iic_gpio_write(0xec, 0x03, 0x3c); 
	iic_gpio_write(0xec, 0x08, 0x00); 


#if 0
	IIC_Open(400000);

    #if 0
	IIC_Write(0xec, 0x00, 0x1); // reset
	IIC_Write(0xec, 0x01, 0x7); // led, alc control pwm invalid
	IIC_Write(0xec, 0x03, 0x63); // 10 mA setting.
	IIC_Write(0xec, 0x08, 0x5);
//	IIC_Write(0xec, 0x08, 0x55);
	IIC_Write(0xec, 0x0b, 0x55);	
    #else
	IIC_Write(0xec, 0x01, 0x11); // reset
	IIC_Write(0xec, 0x03, 0x3c); // reset
	IIC_Write(0xec, 0x08, 0x00); // reset
    #endif
	
	IIC_Close();
#endif
}

void LCDM_InitLTM030DK(void)
{	
	u32 i=0;

	LCDM_CS_HIGH;
	LCDM_SCL_HIGH;
	LCDM_SDA_HIGH;	
	
	///////////////////////////////////////////////////////////////////
	// Init_Lcd_Function
	//////////////////////////////////////////////////////////////////

	Write_LDI_LTM030DK(15,0x01);
	Delay(10);
	
	Write_LDI_LTM030DK(00,0x03);	// forward scan
	Write_LDI_LTM030DK(01,0x02);
	Write_LDI_LTM030DK(03,0x00);
	Write_LDI_LTM030DK(07,0x11);
	Write_LDI_LTM030DK(10,0x0A);
	Write_LDI_LTM030DK(11,0x05);	
	Write_LDI_LTM030DK(12,0x07);
	Write_LDI_LTM030DK(26,0x05);
	Write_LDI_LTM030DK(27,0x10);
	Write_LDI_LTM030DK(28,0x71);
	Write_LDI_LTM030DK(29,0xA1);
	Write_LDI_LTM030DK(30,0xAD);
	Write_LDI_LTM030DK(31,0x04);
	Write_LDI_LTM030DK(33,0x07);
	Write_LDI_LTM030DK(34,0x01);
	Write_LDI_LTM030DK(35,0x00);
	Write_LDI_LTM030DK(37,0x00);
	Write_LDI_LTM030DK(38,0xF8);
	Write_LDI_LTM030DK(39,0x0c);
	Write_LDI_LTM030DK(40,0x40);
	Write_LDI_LTM030DK(41,0x08);
	Write_LDI_LTM030DK(42,0x00);
	Write_LDI_LTM030DK(43,0x00);
	Write_LDI_LTM030DK(44,0xe7);

	Write_LDI_LTM030DK(66,0x01);
	Write_LDI_LTM030DK(67,0x53);
	Write_LDI_LTM030DK(68,0x33);
	Write_LDI_LTM030DK(69,0x41);
	Write_LDI_LTM030DK(70,0x01);
	Write_LDI_LTM030DK(71,0x00);
	Write_LDI_LTM030DK(72,0xFC);
	Write_LDI_LTM030DK(73,0x00);
	Write_LDI_LTM030DK(74,0x00);
	Write_LDI_LTM030DK(75,0x00);
	Write_LDI_LTM030DK(76,0x00);
	Write_LDI_LTM030DK(77,0x00);
	Write_LDI_LTM030DK(78,0xFC);
	Write_LDI_LTM030DK(79,0x00);

	Write_LDI_LTM030DK(80,0x00);
	Write_LDI_LTM030DK(81,0x00);
	Write_LDI_LTM030DK(82,0x00);
	Write_LDI_LTM030DK(83,0x00);
	Write_LDI_LTM030DK(84,0xFC);
	Write_LDI_LTM030DK(85,0x00);
	Write_LDI_LTM030DK(86,0x00);
	Write_LDI_LTM030DK(87,0x00);
	Write_LDI_LTM030DK(88,0x00);
	Write_LDI_LTM030DK(89,0x01);
	
	Write_LDI_LTM030DK(90,0xFF);	
	//UPD161206_write(91,0x01); // PWM Output on
	//UPD161206_write(91,0x00); // PWM Output off
	Write_LDI_LTM030DK(92,0x0D);
	Write_LDI_LTM030DK(93,0x07);
	Write_LDI_LTM030DK(94,0x7E);
	Write_LDI_LTM030DK(95,0x80);
	Write_LDI_LTM030DK(96,0x84);
	Write_LDI_LTM030DK(97,0x8c);
	Write_LDI_LTM030DK(98,0x95);
	Write_LDI_LTM030DK(99,0x9f);

	Write_LDI_LTM030DK(100,0xab);
	Write_LDI_LTM030DK(101,0xB7);
	Write_LDI_LTM030DK(102,0xc4);
	Write_LDI_LTM030DK(103,0xd0);
	Write_LDI_LTM030DK(104,0xdc);
	Write_LDI_LTM030DK(105,0xe7);
	Write_LDI_LTM030DK(106,0xf0);
	Write_LDI_LTM030DK(107,0xf8);
	Write_LDI_LTM030DK(108,0xfd);
	Write_LDI_LTM030DK(109,0xff);

	Write_LDI_LTM030DK(110,0x00);
	Write_LDI_LTM030DK(111,0x01);
	Write_LDI_LTM030DK(112,0x03);
	Write_LDI_LTM030DK(113,0x20);

	Write_LDI_LTM030DK(04,0x01);


}


void LCDM_InitAMS320FS01_0(void)
{
	u32 uAddress,uData;
	u32 uRegSize;
	u32* pReg;

//AMS320FS01_0 register setting sequence
	u32 Reg_AMS320FS01_0[] = {
	REG_DELAY_MS, 20,
	REG_RESET_MS, 60,
	REG_DELAY_MS, 20,
	0x01, 0x00,
	0x21, 0x33,
	0x22, 0x08,
	0x23, 0x00,
	0x24, 0x33,
	0x25, 0x33,
	0x26, 0x06,
	0x27, 0x42,
	0x27, 0x42,
	0x2f, 0x02,
	0x05, 0x01,
	REG_DELAY_MS,400,
	0x04, 0x01,
	REG_DELAY_MS,20,
	//initializing sequence
	0x06, 0x44,
	0x07, 0x04,
	0x08, 0x01,
	0x09, 0x04,
	0x0a, 0x11,
	0x0c, 0x00,
	0x0d, 0x14,
	0x0e, 0x00,
	0x0f, 0x1e,
	0x10, 0x00,
	0x1c, 0x08,
	0x1d, 0x05,
	0x1f, 0x00,
	//gamma selection sequence
	0x30, 0x33,
	0x31, 0x39,
	0x32, 0x37,
	0x33, 0x59,
	0x34, 0x74,
	0x35, 0x74,
	0x36, 0x1c,
	0x37, 0x19,
	0x38, 0x1a,
	0x39, 0x23,
	0x3a, 0x1f,
	0x3b, 0x20,
	0x3c, 0x29,
	0x3d, 0x1b,
	0x3e, 0x20,
	0x3f, 0x39,
	0x40, 0x21,
	0x41, 0x29,
	0x04, 0x05,
	REG_DELAY_MS,40,
	0x04, 0x07,	
	REG_END,REG_END
	};

	pReg = Reg_AMS320FS01_0;

	while(1)
	{
		uAddress = *pReg++;
		uData = *pReg;

		if(uAddress == REG_END)
		{
			break;
		}
		else if(uAddress == REG_DELAY_MS)
		{
			LCDM_DelayMS(uData);
		}
		else if(uAddress == REG_RESET_MS)
		{
			LCDM_Reset(uData);
		}
		else
		{

			Write_LDI_AMS320FS01_0( (uAddress<<8) | uData , 16);
		}
	}
		pReg++;
}
 


void LCDM_InitLdiSpec(u32 eLcdModel)
{


	//Timing parameter for LTV350QV(SAMSUNG)
	if(eLcdModel == LCD_LTV350QV_RGB) 
	{
		gLCDM_HSIZE	=	QVGA_HSIZE;
		gLCDM_VSIZE	=	QVGA_VSIZE;
		gVCLK_EDGE_DETECT =	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY =	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE =	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT =	DITHER_888;
		gMODULE_VBPDE=			(5-1);
		gMODULE_VBPD =          (5-1);
		gMODULE_VFPD =          (3-1);
		gMODULE_VSPW =          (4-1);
		gMODULE_VFPDE=			(3-1);
		gMODULE_HBPD =          (5-1);
		gMODULE_HFPD =          (3-1);
		gMODULE_HSPW =          (10-1);
	}
	// Timing parameter for LTS350Q1(SAMSUNG)
	else if(eLcdModel == LCD_LTS350Q1)
	{
		gLCDM_HSIZE	=	QVGA_HSIZE;
		gLCDM_VSIZE	=	QVGA_VSIZE;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_NORMAL;
		gVSYNC_POLARITY	=	VSYNC_NORMAL;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_16bpp;
		gDITHERING_FORMAT=	DITHER_565;
		gMODULE_VBPDE	=			0;
		gMODULE_VBPD	=			(2-1);
		gMODULE_VFPD	=			(3-1);
		gMODULE_VSPW	=	    	(2-1);
		gMODULE_VFPDE	=			0	;
		gMODULE_HBPD	=			(7-1);
		gMODULE_HFPD	=			(5-1);	// for rgbif margin
		gMODULE_HSPW	=	    	(4-1);
	}
	// Timing parameter for LTS222Q
	else if(eLcdModel == LCD_LTS222Q_RGB )
	{
		gLCDM_HSIZE	=	QVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	QVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_18bpp;
		gDITHERING_FORMAT=	DITHER_565;
		gMODULE_VBPDE		=	0;
		gMODULE_VBPD		=	(9-1); // Not (7-1)
		gMODULE_VFPD		=	(10-1);
		gMODULE_VSPW		=	(3-1);
		gMODULE_VFPDE		=	0;
		gMODULE_HBPD		=	(1-1); // Not (2-1)
		gMODULE_HFPD		=	(6-1);// for rgbif margin
		gMODULE_HSPW		=	(3-1);
	}
	else if(eLcdModel == LCD_LTS222Q_SRGB )
	{
		gLCDM_HSIZE	=	QVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	QVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_SERIAL;
		gDITHERING_FORMAT=	DITHER_565;
		gMODULE_VBPDE		=	0;
		gMODULE_VBPD		=	(9-1); // Not (7-1)
		gMODULE_VFPD		=	(10-1);
		gMODULE_VSPW		=	(3-1);
		gMODULE_VFPDE		=	0	;
		gMODULE_HBPD		=	(1-1); // Not (2-1)
		gMODULE_HFPD		=	(6-1);// for rgbif margin
		gMODULE_HSPW		=	(3-1);
	}

	else if(eLcdModel == LCD_LTS222Q_CPU || eLcdModel == LCD_UF24U276A )
	{
		gLCDM_HSIZE	=	QVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	QVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	I80_CPU;
		gDITHERING_FORMAT=	DITHER_565;
		gMODULE_VBPDE		=	0;
		gMODULE_VBPD		=	(9-1); // Not (7-1)
		gMODULE_VFPD		=	(10-1);
		gMODULE_VSPW		=	(3-1);
		gMODULE_VFPDE		=	0;
		gMODULE_HBPD		=	(1-1); // Not (2-1)
		gMODULE_HFPD		=	(6-1);// for rgbif margin
		gMODULE_HSPW		=	(3-1);
	}
	else if(eLcdModel == LCD_LMS280GS01)
	{
		gLCDM_HSIZE	=	QVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	QVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT =	VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_INVERT;
		gLCDM_INTERFACE_TYPE =	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT =	DITHER_888;
		gMODULE_VBPDE		=	8;
		gMODULE_VBPD		=	(8); // Not (7-1)
		gMODULE_VFPD		=	(8);
		gMODULE_VSPW		=	(8);
		gMODULE_VFPDE		=	8;
		gMODULE_HBPD		=	(8); // Not (2-1)
		gMODULE_HFPD		=	(8); // for rgbif margin
		gMODULE_HSPW		=	(8);
	}

	//Timing parameter for AUO27_SKIP 960x240
	/*
	else if(eLcdModel == LCD_AUO27_SKIP) 
	{
		gLCDM_HSIZE	=	960;
		gLCDM_VSIZE	=	240;
		gVCLK_EDGE_DETECT=	VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE	=	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE	=	0;
		gMODULE_VBPD   =     (21); // 4 x HSYNC
		gMODULE_VFPD   =     (1); // 4 x HSYNC
		gMODULE_VSPW   =     (1); // 1 x VCLK
		gMODULE_VFPDE	=	0;
		gMODULE_HBPD   =     (70); // 8 x VCLK
		gMODULE_HFPD   =     (686); // 8 x VCLK
		gMODULE_HSPW   =     (1); // 1 x VCLK
	}
	*/

	else if(eLcdModel == LCD_AUO27_SKIP) 		//delta-structure type
	{
		gLCDM_HSIZE	 =	960;
		gLCDM_VSIZE	=	240;
		gVCLK_EDGE_DETECT=	VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE	=RGB_DELTA_STRUCTURE;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE	=	0;
		gMODULE_VBPD  =      (11);
		gMODULE_VFPD  =      (1) ;
		gMODULE_VSPW  =      (1) ;
		gMODULE_VFPDE	=	0;
		gMODULE_HBPD  =      (109) ;
		gMODULE_HFPD  =      (255) ;
		gMODULE_HSPW  =      (1);
	}

	//Timing parameter for LTP700WV(SAMSUNG)
	else if(eLcdModel == LCD_LTP700WV_RGB)
	{
		gLCDM_HSIZE	=	WVGA_HSIZE;
		gLCDM_VSIZE	=	WVGA_VSIZE;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE =	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT =	DITHER_888;
		gMODULE_VBPDE		=	0;
		gMODULE_VBPD    =       (7-1);
		gMODULE_VFPD    =       (5-1);
		gMODULE_VSPW    =       (1-1);
		gMODULE_VFPDE		=	0	;
		gMODULE_HBPD    =       (13-1);
		gMODULE_HFPD    =       (8-1);			
		gMODULE_HSPW    =       (3-1);
	}

	//Timing parameter for LTM030DK3A 480x800
	else if(eLcdModel == LCD_LTM030DK) 
	{
		gLCDM_HSIZE	=	WVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	WVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT	=VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE	=	0;
		gMODULE_VBPD  =      (2-1); // 1 line back porch
		gMODULE_VFPD  =      (1-1); // 1 line front porch
		gMODULE_VSPW  =      (1-1); // 1 Line pulse width
		gMODULE_VFPDE	=	0;
		gMODULE_HBPD  =      (2-1); // 2 CLK back porch
		// MODULE_HBPD=        (1-1) // 2 CLK back porch for test. zues
		gMODULE_HFPD  =      (5-1); // 5 CLK front porch
		gMODULE_HSPW  =      (2-1); // 2 CLK pulse width
	}
	else if(eLcdModel == LCD_LTE480WV_RGB) 
	{
		gLCDM_HSIZE	=	WVGA_HSIZE;
		gLCDM_VSIZE	=	WVGA_VSIZE;
		gVCLK_EDGE_DETECT	=VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE		=6;
		gMODULE_VBPD    =    (6); // 1 line back porch
		gMODULE_VFPD    =    (4); // 1 line front porch
		gMODULE_VSPW    =    (0); // 1 Line pulse width
		gMODULE_VFPDE		=4;
		gMODULE_HBPD    =    (12); // 2 CLK back porch
		// MODULE_HBPD  =      (1-1); // 2 CLK back porch for test. zues
		gMODULE_HFPD    =    (7); // 5 CLK front porch
		gMODULE_HSPW    =    (2); // 2 CLK pulse width
	}

	//Timing parameter for TL2796 480x800
	else if(eLcdModel == LCD_TL2796) 
	{
		gLCDM_HSIZE	=	WVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	WVGA_PORT_VSIZE;
		gVCLK_EDGE_DETECT	=VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_INVERT;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE	=	0;
		gMODULE_VBPD   =     (4); // 4 x HSYNC
		gMODULE_VFPD   =     (4); // 4 x HSYNC
		gMODULE_VSPW   =     (1); // 1 x VCLK
		gMODULE_VFPDE		=0	;	
		gMODULE_HBPD   =     (8); // 8 x VCLK
		gMODULE_HFPD    =    (8); // 8 x VCLK
		gMODULE_HSPW    =    (1); // 1 x VCLK

	}


	//Timing parameter for HD
	else if(eLcdModel == LCD_HD) 
	{
		gLCDM_HSIZE	=	1366;
		gLCDM_VSIZE	=	768;
		gVCLK_EDGE_DETECT=	VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_18bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE		=14;
		gMODULE_VBPD    =    (14); // 0 x HSYNC
		gMODULE_VFPD    =    (3); // 0 x HSYNC
		gMODULE_VSPW    =    (5); // 3 x VCLK
		gMODULE_VFPDE		=3	;
		gMODULE_HBPD    =    (16); // 0 x VCLK
		gMODULE_HFPD    =    (48); // 0 x VCLK
		gMODULE_HSPW    =    (32); // 32 x VCLK
	}
	/*
	//Timing parameter for HD through D-SUB
	else if(eLcdModel == LCD_HD) 
	{
		gLCDM_HSIZE		=1366;
		gLCDM_VSIZE		=768;
		gVCLK_EDGE_DETECT	=VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE	=	RGB_PARALLEL_18bpp;
		gDITHERING_FORMAT=	DITHER_888;
		gMODULE_VBPDE		=23;
		gMODULE_VBPD    =    (23); 
		gMODULE_VFPD    =    (1); 
		gMODULE_VSPW    =    (3); 
		gMODULE_VFPDE		=1;		
		gMODULE_HBPD    =    (216);
		gMODULE_HFPD    =    (72);
		gMODULE_HSPW    =    (144);
	}
	*/


	//Timing parameter for XGA			// Virtual LCD module for test
	else if(eLcdModel == LCD_XGA) 
	{
		gLCDM_HSIZE	=	XGA_HSIZE;             
		gLCDM_VSIZE	=	XGA_VSIZE ;            
		gVCLK_EDGE_DETECT=VCLK_FALLING_EDGE ;
		gHSYNC_POLARITY		=HSYNC_INVERT ;    
		gVSYNC_POLARITY		=VSYNC_INVERT ;    
		gVDEN_POLARITY		=VDEN_NORMAL  ;    
		gLCDM_INTERFACE_TYPE=	RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888  ;    
		gMODULE_VBPDE		=0 ;                 
		gMODULE_VBPD    =    (4); // 4 x HSYN
		gMODULE_VFPD    =    (4); // 4 x HSYN
		gMODULE_VSPW    =    (1); // 1 x VCLK
		gMODULE_VFPDE		=0;                  
		gMODULE_HBPD    =    (8); // 8 x VCLK
		gMODULE_HFPD    =    (8); // 8 x VCLK
		gMODULE_HSPW    =    (1); // 1 x VCLK
	}



	//Timing parameter for SXGA		// Virtual LCD module for test
	else if(eLcdModel == LCD_SXGA)
	{
		gLCDM_HSIZE		= SXGA_HSIZE;               
		gLCDM_VSIZE		= SXGA_VSIZE;              
		gVCLK_EDGE_DETECT=		VCLK_FALLING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE	=RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;           
		gMODULE_VBPDE		=0 ;                      
		gMODULE_VBPD    =    (4); // 4 x HSYNC    
		gMODULE_VFPD    =    (4); // 4 x HSYNC    
		gMODULE_VSPW    =    (1); // 1 x VCLK     
		gMODULE_VFPDE		=0 ;                      
		gMODULE_HBPD    =    (8); // 8 x VCLK     
		gMODULE_HFPD    =    (8); // 8 x VCLK     
		gMODULE_HSPW    =    (1); // 1 x VCLK     
	}
	else if(eLcdModel == LCD_S6E63M0)
	{
		gLCDM_HSIZE	=	WVGA_PORT_HSIZE;
		gLCDM_VSIZE	=	WVGA_PORT_VSIZE;         
		gVCLK_EDGE_DETECT=		VCLK_RISING_EDGE;
		gHSYNC_POLARITY	=	HSYNC_INVERT;
		gVSYNC_POLARITY	=	VSYNC_INVERT;
		gVDEN_POLARITY	=	VDEN_NORMAL;
		gLCDM_INTERFACE_TYPE	=RGB_PARALLEL_24bpp;
		gDITHERING_FORMAT=	DITHER_888;           
		gMODULE_VBPDE		=0 ;                      
//		gMODULE_VBPD    =    (28); // 4 x HSYNC    
		gMODULE_VBPD    =    (1); // 4 x HSYNC    
		gMODULE_VFPD    =    (1); // 4 x HSYNC    
		gMODULE_VSPW    =    (2); // 1 x VCLK     
		gMODULE_VFPDE		=0 ;                      
		gMODULE_HBPD    =    (16); // 8 x VCLK     
		gMODULE_HFPD    =    (16); // 8 x VCLK     
		gMODULE_HSPW    =    (2); // 1 x VCLK     
	}
	else
	{
		Assert(0);
	}



}


void LCDM_InitLdi(u32 uLdiModule, u32 uLdiMode)
{
	u32* pReg;

	LCDM_InitGPIO(SDA_GPIO_ADDRESS,SDA_GPIO_BIT);
	LCDM_InitGPIO(SCL_GPIO_ADDRESS,SCL_GPIO_BIT);
	LCDM_InitGPIO(CS_GPIO_ADDRESS,CS_GPIO_BIT);
	LCDM_InitGPIO(IIC_SDA_GPIO_ADDRESS,IIC_SDA_GPIO_BIT);
	LCDM_InitGPIO(IIC_SCL_GPIO_ADDRESS,IIC_SCL_GPIO_BIT);
	LCDM_InitGPIO(BACKLIGHT_GPIO_ADDRESS,BACKLIGHT_GPIO_BIT);
	LCDM_InitGPIO(RESET_GPIO_ADDRESS,RESET_GPIO_BIT);
	LCDM_InitGPIO(POWER_GPIO_ADDRESS,POWER_GPIO_BIT);
	LCDM_InitGPIO(POWER_GPIO_ADDRESS2,POWER_GPIO_BIT2);

	
	LCDM_SDA_HIGH;
	LCDM_SCL_HIGH;
	LCDM_CS_HIGH;
	LCDM_IIC_SCL_HIGH;
	LCDM_IIC_SDA_HIGH;

	LCDM_BackLightOn();
	LCDM_ResetOff();

	LCDM_InitDISPConGPIO();
	LCDM_InitLdiSpec(uLdiModule);


//////////////////========= Module Initialize ========== /////////////////
	if (uLdiModule == LCD_LTV350QV_RGB)
	{
		LCDM_Reset(10);
		LCDM_InitLtv350QVForRgbif();
	}
	else if (uLdiModule == LCD_LTS222Q_CPU )
	{
		LCDM_Reset(10);
		if(uLdiMode == MAIN)
		{
			LCDC_SetCpuIfTiming(CS_SETUP_TIME,WR_SETUP_TIME,WR_ACT_TIME, WR_HOLD_TIME, MAIN);
			LCDC_SetAutoCmdRate(PER_TWO_FRM, MAIN);	
		}
		else
		{
			LCDC_SetCpuIfTiming(CS_SETUP_TIME,WR_SETUP_TIME,WR_ACT_TIME, WR_HOLD_TIME, SUB);
			LCDC_SetAutoCmdRate(PER_TWO_FRM, SUB);	
		}
		// In CPU I/F Normal, VIDOUT is determined and LCD is turned on
		// before RS, Enable and Normal Start bits are set

		LCDC_Start();
		LCDM_InitLts222QForI80if(uLdiMode);
		LCDC_InitStartPosOnLcd(uLdiMode);	
	}
	else if (uLdiModule == LCD_UF24U276A )
	{
		LCDM_PowerOn();
		LCDM_Reset(10);
		if(uLdiMode == MAIN)
		{
			LCDC_SetCpuIfTiming(CS_SETUP_TIME,WR_SETUP_TIME,WR_ACT_TIME, WR_HOLD_TIME, MAIN);
			LCDC_SetAutoCmdRate(PER_TWO_FRM, MAIN);	
		}
		else
		{
			LCDC_SetCpuIfTiming(CS_SETUP_TIME,WR_SETUP_TIME,WR_ACT_TIME, WR_HOLD_TIME, SUB);
			LCDC_SetAutoCmdRate(PER_TWO_FRM, SUB);	
		}
		// In CPU I/F Normal, VIDOUT is determined and LCD is turned on
		// before RS, Enable and Normal Start bits are set
		LCDC_Start();
		LCDM_InitUF24U276AorI80if(uLdiMode);
		LCDC_InitStartPosOnLcd(uLdiMode);		
	}
	else if (uLdiModule == LCD_LTS222Q_RGB || uLdiModule == LCD_LTS222Q_SRGB || uLdiModule == LCD_LTS222Q_SPI)
	{
		LCDM_Reset(10);
		LCDM_InitLts222QForRgbif();
		LCDC_InitStartPosOnLcd(MAIN);	
	}
	else if (uLdiModule == LCD_MIPIModule)
	{
	}
/*
	{
		{
			DDI_Configuration* oDDISpec = DDI_GetConfiguration();
			u32 uVIDCON0; 
			uVIDCON0 = DSI_ENABLE;
			uVIDCON0 |= (eLdiMode == MAIN) ? VIDOUT_I80IF0 : VIDOUT_I80IF1;
			LCDC_SetCpuIfTiming(	oDDISpec->m_03usVBack,
									oDDISpec->m_04usVFront, 
									oDDISpec->m_05usHBack,
									oDDISpec->m_06usHFront, 
									eLdiMode);		
			LCDC_SetAutoCmdRate(DISABLE_AUTO_FRM, eLdiMode);		
			LcdcOutp32(VIDCON0, uVIDCON0);
			LCDC_Start();
		}
	}
*/
	else if (uLdiModule == LCD_LTM030DK)
	{
		LCDM_BackLightOff();	//Set Control Back-Light Regulator Shotdown Pin
		LCDM_Reset(10);
		LCDM_InitGPIO(IIC_SDA_GPIO_ADDRESS,IIC_SDA_GPIO_BIT);
		LCDM_InitGPIO(IIC_SCL_GPIO_ADDRESS,IIC_SCL_GPIO_BIT);
		LCDM_SetALCforLTM030DK();
		LCDM_InitLTM030DK();
	}
	else if (uLdiModule == LCD_TL2796)
	{
		LCDM_Reset(10);
		LCDM_InitTL2796();
	}
	else if ( uLdiModule == LCD_AUO27_SKIP)
	{
		LCDM_PowerOn();
		LCDM_Reset(10);
		LCDC_InitBase();
		LCDC_Start();
		LCDM_InitAUO27_SKIP();
	}
	else if (uLdiModule == LCD_LMS280GS01)
	{
		LCDM_Reset(10);
		LCDM_InitLMS280GS01();
	}
	else if (uLdiModule == LCD_LTE480WV_RGB || uLdiModule == LCD_SXGA)
	{
		LCDM_Reset(10);
	}
	else if ( uLdiModule == LCD_HD )
	{
		LCDM_PowerOn();		// Power On
		LCDM_PowerOn2();		// LED_EN
		LCDM_Reset(10);	
	}
	else if( uLdiModule == LCD_S6E63M0 )
	{
		LCDM_PowerOn();		// Power On
		LCDM_Reset(10);
		LCDM_InitS6E63M0();
	}
	else
	{
		Assert(0);
	}

}





