/*--------------------------------------------------------------
 * Filename: lcd.c
 *
 * Contents: Implemention of "FIMDv5.0"
 *
 * Abbreviations:
 *
 * Person Involved:
 *
 * Notes: FIMD V5.0
 *
 * History
 *
 * Copyright (c) 2007 SAMSUNG Electronics.
 --------------------------------------------------------------*/

#include "system.h"
#include "sysc.h"
#include "library.h"
#include "util.h"
#include "lcd.h"
#include "v210_sfr.h"
#include "gpio.h"
#include "Def.h"
#include "timer.h"
#include "lcd_module.h"

#if ( LCD_MODEL == LCD_MIPIModule)
//#include "ddi_dummy.h" 
#endif



#if DBG_LCDC
#define LcdcOutp32(offset, x) {Disp("Outp1w(32'h%x, 32'h%x);\n", (LCDC_BASE+offset), (x)); Outp32(LCDC_BASE+offset, x);}
#define LcdcInp32(offset, x) {x=Inp32(LCDC_BASE+offset); /*Disp("Inp1w(32'h%x, 32'h%x);\n", (LCDC_BASE+offset), (x));*/}
#else
#define LcdcOutp32(offset, x) Outp32(LCDC_BASE+offset, x)
#define LcdcInp32(offset, x) {x=Inp32(LCDC_BASE+offset);}
#endif

enum LCDC_SFR
{
	VIDCON0		= 0x00000,
	VIDCON1		= 0x00004, 
	VIDCON2		= 0x00008,
	VIDCON3		= 0x0000C,		//new(v6.0)
	VIDTCON0		= 0x00010,
	VIDTCON1		= 0x00014, 
	VIDTCON2		= 0x00018,
	VIDTCON3		= 0x0001c,
	WINCON0		= 0x00020,
	WINCON1		= 0x00024,
	WINCON2		= 0x00028,
	WINCON3		= 0x0002C,
	WINCON4	     	= 0x00030,
	SHADOWCON	= 0x00034,		//new(v6.0)
	VIDOSD0A		= 0x00040,
	VIDOSD0B		= 0x00044,
	VIDOSD0C		= 0x00048,
	VIDOSD1A		= 0x00050,
	VIDOSD1B		= 0x00054,
	VIDOSD1C		= 0x00058,
	VIDOSD1D		= 0x0005C,
	VIDOSD2A		= 0x00060,
	VIDOSD2B		= 0x00064,
	VIDOSD2C		= 0x00068,
	VIDOSD2D		= 0x0006c,
	VIDOSD3A		= 0x00070,
	VIDOSD3B		= 0x00074,
	VIDOSD3C		= 0x00078,
	VIDOSD4A		= 0x00080,
	VIDOSD4B		= 0x00084,
	VIDOSD4C		= 0x00088,

	VIDW00ADD0B0	= 0x000A0,
	VIDW00ADD0B1	= 0x000A4,
	VIDW00ADD0B2	= 0x020A0,		// v6.2 for triple buffer
	VIDW01ADD0B0	= 0x000A8,
	VIDW01ADD0B1	= 0x000AC,
	VIDW01ADD0B2	= 0x020A8,		// v6.2 for triple buffer
	VIDW02ADD0B0	= 0x000B0,		//new(v6.0) win2~4 have double buffer
	VIDW02ADD0B1	= 0x000B4,
	VIDW02ADD0B2	= 0x020B0,		// v6.2 for triple buffer
	VIDW03ADD0B0	= 0x000B8,
	VIDW03ADD0B1	= 0x000BC,
	VIDW03ADD0B2	= 0x020B8,		// v6.2 for triple buffer
	VIDW04ADD0B0	= 0x000C0,
	VIDW04ADD0B1	= 0x000C4,
	VIDW04ADD0B2	= 0x020C0,		// v6.2 for triple buffer

	VIDW00ADD1B0	= 0x000D0,
	VIDW00ADD1B1	= 0x000D4,
	VIDW00ADD1B2	= 0x020D0,		// v6.2 for triple buffer	
	VIDW01ADD1B0	= 0x000D8,
	VIDW01ADD1B1	= 0x000DC,
	VIDW01ADD1B2	= 0x020D8,	// v6.2 for triple buffer	
	VIDW02ADD1B0	= 0x000E0,		//new(v6.0) win2~4 have double buffer
	VIDW02ADD1B1	= 0x000E4,
	VIDW02ADD1B2	= 0x020E0, // v6.2 for triple buffer	
	VIDW03ADD1B0	= 0x000E8,
	VIDW03ADD1B1	= 0x000EC,
	VIDW03ADD1B2	= 0x020E8,// v6.2 for triple buffer	
	VIDW04ADD1B0	= 0x000F0,
	VIDW04ADD1B1	= 0x000F4,
	VIDW04ADD1B2	= 0x020F0,// v6.2 for triple buffer	

	VIDW00ADD2     	= 0x00100,
	VIDW01ADD2     	= 0x00104,
	VIDW02ADD2     	= 0x00108,
	VIDW03ADD2     	= 0x0010C,
	VIDW04ADD2     	= 0x00110,

	VP1TCON0		= 0x00118,		//new(v6.0)
	VP1TCON1		= 0x0011c,

	VIDINTCON0		= 0x00130,
	VIDINTCON1		= 0x00134,
	W1KEYCON0		= 0x00140,
	W1KEYCON1		= 0x00144,
	W2KEYCON0		= 0x00148,
	W2KEYCON1		= 0x0014C,
	W3KEYCON0		= 0x00150,
	W3KEYCON1		= 0x00154,
	W4KEYCON0		= 0x00158,
	W4KEYCON1		= 0x0015C,

	W1KEYALPHA	= 0x00160,		//new(v6.0)
	W2KEYALPHA	= 0x00164,
	W3KEYALPHA	= 0x00168,
	W4KEYALPHA	= 0x0016C,

	DITHMODE		= 0x00170,

	WIN0MAP		= 0x00180,
	WIN1MAP		= 0x00184,
	WIN2MAP		= 0x00188,
	WIN3MAP		= 0x0018C,
	WIN4MAP		= 0x00190,

	WPALCON_H		= 0x0019C,
	WPALCON_L		= 0x001A0,	
	TRIGCON		= 0x001A4,

	ITUIFCON0		= 0x001A8, 

	I80IFCONA0		= 0x001B0,
	I80IFCONA1		= 0x001B4,
	I80IFCONB0		= 0x001B8,
	I80IFCONB1		= 0x001BC,

	COLORGAINCON	= 0x001C0,		//new(v6.0)
	
	VESFRCON0		= 0x001C4,		//new(v6.0)
	VESFRCON1		= 0x001C8,	
	VESFRCON2		= 0x001CC,
	
	LDI_CMDCON0	= 0x001D0,
	LDI_CMDCON1	= 0x001D4,

	SIFCCON0		= 0x001E0,
	SIFCCON1		= 0x001E4,
	SIFCCON2		= 0x001E8,

	HUECOEF00		= 0x001EC,		//new(v6.0)
	HUECOEF01		= 0x001F0,
	HUECOEF10		= 0x001F4,	
	HUECOEF11		= 0x001F8,
	HUEOFFSET		= 0x001FC,
	
	VIDW0ALPHA0	= 0x00200,
	VIDW0ALPHA1	= 0x00204,
	VIDW1ALPHA0	= 0x00208,
	VIDW1ALPHA1	= 0x0020C,
	VIDW2ALPHA0	= 0x00210,
	VIDW2ALPHA1	= 0x00214,
	VIDW3ALPHA0	= 0x00218,
	VIDW3ALPHA1	= 0x0021C,
	VIDW4ALPHA0	= 0x00220,
	VIDW4ALPHA1	= 0x00224,
	BLENDEQ1		= 0x00244,
	BLENDEQ2		= 0x00248,
	BLENDEQ3		= 0x0024C,
	BLENDEQ4		= 0x00250,
	BLENDCON		= 0x00260,

	W0RTQOSCON	= 0x00264,		//new(v6.0)
	W1RTQOSCON	= 0x00268,
	W2RTQOSCON	= 0x0026C,
	W3RTQOSCON	= 0x00270,
	W4RTQOSCON	= 0x00274,
	GPOUTCON0		= 0x00278,
	DUALCON		= 0x0027C,		//new(v6.0) need to change Reg. name (Temporary name now 09.Feb.16th)

	LDI_CMD0		= 0x00280,
	LDI_CMD1		= 0x00284,
	LDI_CMD2		= 0x00288,
	LDI_CMD3		= 0x0028C,
	LDI_CMD4		= 0x00290,
	LDI_CMD5		= 0x00294,
	LDI_CMD6		= 0x00298,
	LDI_CMD7		= 0x0029C,
	LDI_CMD8		= 0x002A0,
	LDI_CMD9		= 0x002A4,
	LDI_CMD10		= 0x002A8,
	LDI_CMD11		= 0x002AC,

	GAMMALUT_01_00	= 0x0037C,		//new(v6.0)
	GAMMALUT_03_02	= 0x00380,
	GAMMALUT_05_04	= 0x00384,
	GAMMALUT_07_06	= 0x00388,
	GAMMALUT_09_08	= 0x0038C,
	GAMMALUT_11_10	= 0x00390,
	GAMMALUT_13_12	= 0x00394,
	GAMMALUT_15_14	= 0x00398,
	GAMMALUT_17_16	= 0x0039C,
	GAMMALUT_19_18	= 0x003A0,
	GAMMALUT_21_20	= 0x003A4,
	GAMMALUT_23_22	= 0x003A8,
	GAMMALUT_25_24	= 0x003AC,
	GAMMALUT_27_26	= 0x003B0,
	GAMMALUT_29_28	= 0x003B4,
	GAMMALUT_31_30	= 0x003B8,
	GAMMALUT_33_32	= 0x003BC,
	GAMMALUT_35_34	= 0x003C0,
	GAMMALUT_37_36	= 0x003C4,
	GAMMALUT_39_38	= 0x003C8,
	GAMMALUT_41_40	= 0x003CC,
	GAMMALUT_43_42	= 0x003D0,
	GAMMALUT_45_44	= 0x003D4,
	GAMMALUT_47_46	= 0x003D8,
	GAMMALUT_49_48	= 0x003DC,
	GAMMALUT_51_50	= 0x003E0,
	GAMMALUT_53_52	= 0x003E4,
	GAMMALUT_55_54	= 0x003E8,
	GAMMALUT_57_56	= 0x003EC,
	GAMMALUT_59_58	= 0x003F0,
	GAMMALUT_61_60	= 0x003F4,
	GAMMALUT_63_62	= 0x003F8,
	GAMMALUT_xx_64	= 0x003FC,
	
	W0PDATA01_L		= 0x022c0,
	W0PDATA23_L		= 0x022c4,
	W0PDATA45_L		= 0x022c8,
	W0PDATA67_L		= 0x022cc,
	W0PDATA89_L		= 0x022d0,
	W0PDATAAB_L		= 0x022d4,
	W0PDATACD_L		= 0x022d8,
	W0PDATAEF_L		= 0x022dc,
	W0PDATA01_H		= 0x022e0,
	W0PDATA23_H		= 0x022e4,
	W0PDATA45_H		= 0x022e8,
	W0PDATA67_H		= 0x022ec,
	W0PDATA89_H		= 0x022f0,
	W0PDATAAB_H		= 0x022f4,
	W0PDATACD_H		= 0x022f8,
	W0PDATAEF_H		= 0x022fc,
	W1PDATA01_L		= 0x02300,
	W1PDATA23_L		= 0x02304,
	W1PDATA45_L		= 0x02308,
	W1PDATA67_L		= 0x0230c,
	W1PDATA89_L		= 0x02310,
	W1PDATAAB_L		= 0x02314,
	W1PDATACD_L		= 0x02318,
	W1PDATAEF_L		= 0x0231c,
	W1PDATA01_H		= 0x02320,
	W1PDATA23_H		= 0x02324,
	W1PDATA45_H		= 0x02328,
	W1PDATA67_H		= 0x0232c,
	W1PDATA89_H		= 0x02330,
	W1PDATAAB_H		= 0x02334,
	W1PDATACD_H		= 0x02338,
	W1PDATAEF_H		= 0x0233c,	
	W2PDATA01_L		= 0x02340,
	W2PDATA23_L		= 0x02344,
	W2PDATA45_L		= 0x02348,
	W2PDATA67_L		= 0x0234c,
	W2PDATA89_L		= 0x02350,
	W2PDATAAB_L		= 0x02354,
	W2PDATACD_L		= 0x02358,
	W2PDATAEF_L		= 0x0235c,
	W2PDATA01_H		= 0x02360,
	W2PDATA23_H		= 0x02364,
	W2PDATA45_H		= 0x02368,
	W2PDATA67_H		= 0x0236c,
	W2PDATA89_H		= 0x02370,
	W2PDATAAB_H		= 0x02374,
	W2PDATACD_H		= 0x02378,
	W2PDATAEF_H		= 0x0237c,
	W3PDATA01_L		= 0x02380,
	W3PDATA23_L		= 0x02384,
	W3PDATA45_L		= 0x02388,
	W3PDATA67_L		= 0x0238c,
	W3PDATA89_L		= 0x02390,
	W3PDATAAB_L		= 0x02394,
	W3PDATACD_L		= 0x02398,
	W3PDATAEF_L		= 0x0239c,
	W3PDATA01_H		= 0x023a0,
	W3PDATA23_H		= 0x023a4,
	W3PDATA45_H		= 0x023a8,
	W3PDATA67_H		= 0x023ac,
	W3PDATA89_H		= 0x023b0,
	W3PDATAAB_H		= 0x023b4,
	W3PDATACD_H		= 0x023b8,
	W3PDATAEF_H		= 0x023bc,
	W4PDATA01_L		= 0x023c0,
	W4PDATA23_L		= 0x023c4,
	W4PDATA45_L		= 0x023c8,
	W4PDATA67_L		= 0x023cc,
	W4PDATA89_L		= 0x023d0,
	W4PDATAAB_L		= 0x023d4,
	W4PDATACD_L		= 0x023d8,
	W4PDATAEF_L		= 0x023dc,
	W4PDATA01_H		= 0x023e0,
	W4PDATA23_H		= 0x023e4,
	W4PDATA45_H		= 0x023e8,
	W4PDATA67_H		= 0x023ec,
	W4PDATA89_H		= 0x023f0,
	W4PDATAAB_H		= 0x023f4,
	W4PDATACD_H		= 0x023f8,
	W4PDATAEF_H		= 0x023fc,


	W0PRAMSTART		= 0x02400,
	W1PRAMSTART   	 	= 0x02800,
	W2PRAMSTART   		= 0x02c00,
	W3PRAMSTART    		= 0x03000,
	W4PRAMSTART    		= 0x03400,
	
// VELUT1_00~VELUT1_FF need to be defined (08.Nov.15th)
	VELUT1_00			= 0x04800,

// VELUT2_000~VELUT1_1FF need to be defined (08.Nov.15th)
	VELUT2_000			= 0x05000

};

// VIDCON0 (VIDeo main CONtrol 0 register)
#define DSI_DISABLE				(0<<30)
#define DSI_ENABLE				(1<<30)

#define VID_PROGRESSIVE			(0<<29)
#define VID_INTERLACE			(1<<29)

#define VIDOUT_RGBIF			(0<<26)
#define VIDOUT_TV				(1<<26)		 // v6.0's case this is Write Back path
#define VIDOUT_I80IF0			(2<<26)
#define VIDOUT_I80IF1			(3<<26)
#define VIDOUT_TVNRGBIF	     		(4<<26)		// v6.0's case this is RGB(LCD) and WriteBack dual path (TV = WB)
#define VIDOUT_TVNI80IF0		(6<<26)	
#define VIDOUT_TVNI80IF1		(7<<26)	

// CPU Interface Data Format (SUB LDI)
#define SUB_16_MODE			(0<<23)
#define SUB_16PLUS2_MODE		(1<<23)
#define SUB_9PLUS9_MODE	    	(2<<23)
#define SUB_16PLUS8_MODE		(3<<23)
#define SUB_18_MODE		    	(4<<23)
#define SUB_8PLUS8_MODE		(5<<23)

// CPU Interface Data Format (MAIN LDI)
#define MAIN_16_MODE			(0<<20)
#define MAIN_16PLUS2_MODE		(1<<20)
#define MAIN_9PLUS9_MODE		(2<<20)
#define MAIN_16PLUS8_MODE		(3<<20)
#define MAIN_18_MODE			(4<<20)
#define MAIN_8PLUS8_MODE		(5<<20)		// new(v6.0)

// VIDCON0 (CPU I/F Masking)
#define LCD_OUT_MASKING	    	~(0x3<<26)
#define SUB_DATA_MASKING		~(0x7<<23)
#define MAIN_DATA_MASKING		~(0x7<<20)

#define PNRMODE_RGB_P			(0<<17)
#define PNRMODE_BGR_P			(1<<17)
#define PNRMODE_RGB_S			(2<<17)
#define PNRMODE_BGR_S			(3<<17)
#define PNRMODE_MASK			(3<<17)




#define CLKVALUP_ALWAYS	    	(0<<16)
#define CLKVALUP_ST_FRM	    	(1<<16)

#define CLKVAL_F(n)				(((n)&0xFF)<<6)

#define VCLKFREE_NORMAL		(0<<5) 
#define VCLKFREE_FREERUN		(1<<5) 

#define CLKDIR_F(n)				(((n)&0x1)<<4)
#define CLKDIR_DIRECT			(0<<4)
#define CLKDIR_DIVIDED			(1<<4)
 
#define CLKSEL_F_HCLK			(0<<2)
#define CLKSEL_F_SCLK        	(1<<2)		// LCD video Clock(fr SYSCON)
 
#define ENVID_DISABLE			(0<<1)
#define ENVID_ENABLE			(1<<1)

#define ENVID_F_DISABLE			(0<<0)
#define ENVID_F_ENABLE			(1<<0)

// VIDCON1 (VIDeo main CONtrol 1 register)
#define IVCLK_FALL_EDGE			(0<<7)
#define IVCLK_RISE_EDGE			(1<<7)
#define IHSYNC_NORMAL			(0<<6)
#define IHSYNC_INVERT			(1<<6)
#define IVSYNC_NORMAL			(0<<5)
#define IVSYNC_INVERT			(1<<5)
#define IVDEN_NORMAL			(0<<4)
#define IVDEN_INVERT			(1<<4)

// VIDCON2 (VIDeo main CONtrol 2 register)
#define RGB_SKIP_DISABLE		(0<<27)		// new(v6.0)
#define RGB_SKIP_ENABLE		(1<<27)
#define RGB_DUMMY_LAST			(0<<25)
#define RGB_DUMMY_FIRST		(1<<25)
#define RGB_DUMMY_DISABLE		(0<<24)
#define RGB_DUMMY_ENABLE		(1<<24)

#define EN601_DISABLE			(0<<23)
#define EN601_ENABLE			(1<<23)
#define EN656_DISABLE			(0<<22)
#define EN656_ENABLE			(1<<22)


#define RGBSPSEL_PARALLEL			(0<<18)
#define RGBSPSEL_SERIAL			(1<<18)

#define RGB_ORDER_E_RGB		(0<<19)		// new(v6.0)
#define RGB_ORDER_E_GBR		(1<<19)
#define RGB_ORDER_E_BRG		(2<<19)
#define RGB_ORDER_E_BGR		(4<<19)
#define RGB_ORDER_E_RBG		(5<<19)
#define RGB_ORDER_E_GRB		(6<<19)

#define RGB_ORDER_O_RGB		(0<<16)		// new(v6.0)
#define RGB_ORDER_O_GBR		(1<<16)
#define RGB_ORDER_O_BRG		(2<<16)
#define RGB_ORDER_O_BGR		(4<<16)
#define RGB_ORDER_O_RBG		(5<<16)
#define RGB_ORDER_O_GRB		(6<<16)

#define WRITEBACK_DISABLE		(0<<15)
#define WRITEBACK_ENABLE		(1<<15)
#define TVFORMATSEL0_HW	    	(0<<14)
#define TVFORMATSEL0_SW	    	(1<<14)
#define TVFORMATSEL1_RGB		(0<<12)
#define TVFORMATSEL1_YUV422	(1<<12)
#define TVFORMATSEL1_YUV444	(1<<13)	
#define ORGYCBCR_YCBCR		(0<<8)
#define ORGYCBCR_CBCRY		(1<<8)
#define YUVORD_CB_CR			(0<<7)
#define YUVORD_CR_CB			(1<<7)

#define TV_FRAM_SKIP(n)			(((n-1)&0x1F)<<0)		// new(v6.0) /  n=1 ; 1:1 /  n=2 ; 1:2 /   n=3 ; 1:3 ...

// VIDCON3 (VIDeo main CONtrol 3 register)		//new(v6.0)
#define VE_ON_DISABLE			(0<<20)
#define VE_ON_ENABLE			(1<<20)
#define CG_ON_DISABLE			(0<<18)
#define CG_ON_ENABLE			(1<<18)
#define GM_ON_DISABLE			(0<<16)
#define GM_ON_ENABLE			(1<<16)
#define HUE_CSC_F_WIDE			(0<<14)
#define HUE_CSC_F_NARROW		(1<<14)
#define HUE_CSC_F_EQ601		(0<<13)
#define HUE_CSC_F_EQ709		(1<<13)
#define HUE_CSC_F_DISABLE		(0<<12)
#define HUE_CSC_F_ENABLE		(1<<12)
#define HUE_CSC_B_WIDE			(0<<10)
#define HUE_CSC_B_NARROW		(1<<10)
#define HUE_CSC_B_EQ601		(0<<9)
#define HUE_CSC_B_EQ709		(1<<9)
#define HUE_CSC_B_DISABLE		(0<<8)
#define HUE_CSC_B_ENABLE		(1<<8)
#define HUE_ON_DISABLE			(0<<7)
#define HUE_ON_ENABLE			(1<<7)
#define PC_DIR_POS				(0<<1)
#define PC_DIR_NEG				(1<<1)
#define PC_ON_DISABLE			(0<<0)
#define PC_ON_ENABLE			(1<<0)



// VIDTCON0 (VIDeo Time CONtrol 0 register)
#define VBPDE(n)					(((n)&0xFF)<<24)
#define VBPD(n)					(((n)&0xFF)<<16)
#define VFPD(n)					(((n)&0xFF)<<8)
#define VSPW(n)					(((n)&0xFF)<<0)

// VIDTCON1 (VIDeo Time CONtrol 1 register)
#define VFPDE(n)					(((n)&0xFF)<<24)
#define HBPD(n)					(((n)&0xFF)<<16)
#define HFPD(n)					(((n)&0xFF)<<8)
#define HSPW(n)					(((n)&0xFF)<<0)

// VIDTCON2 (VIDeo Time CONtrol 2 register)
#define LINEVAL(n)				(((n)&0x7FF)<<11)
#define HOZVAL(n)				(((n)&0x7FF)<<0)

// VIDTCON3 (VIDeo Time CONtrol 3 register)
#define VSYNC_DISABLE			(0<<31)
#define VSYNC_ENABLE			(1<<31)
#define FRM_DISABLE				(0<<29)
#define FRM_ENABLE				(1<<29)
#define INVFRM_HIGH				(0<<28)
#define INVFRM_LOW				(1<<28)
#define FRMVRATE(n)				(((n)&0xF)<<24)
#define FRMVFPD(n)				(((n)&0xFF)<<8)
#define FRMVSPW(n)				(((n)&0xFF)<<0)

// WINCON0 (WINdow 0 CONtrol register) SFR for local path


// WINCON1 (WINdow 1 CONtrol register) SFR for local path
#define W1VP_DISABLE			(0<<24)
#define W1VP_ENABLE			(1<<24)


// WINCON2 (WINdow 2 CONtrol register) SFR for local path


// WINCON0, 1, 2, 3, 4 SFR's
#define LIMIT_DISABLE			(0<<29)		//new(v6.0)
#define LIMIT_ENABLE			(1<<29)
#define EQ601					(0<<28)
#define EQ709					(1<<28)
#define WIDE						(0<<26)
#define NARROW					(3<<26)
#define PATH_DMA				(0<<22)
#define PATH_LOCAL				(1<<22)

#define WBUF0					(0<<20)
#define WBUF1					(1<<20)
#define WBUF_MASK				(1<<20)
#define WBUFAUTO_DISABLE		(0<<19)
#define WBUFAUTO_ENABLE		(1<<19)
#define WBUFAUTO_MASK	    		(1<<19)

#define BITSWP_DISABLE			(0<<18)
#define BITSWP_ENABLE			(1<<18)
#define BYTSWP_DISABLE			(0<<17)
#define BYTSWP_ENABLE		 	(1<<17)
#define HAWSWP_DISABLE	    	(0<<16)
#define HAWSWP_ENABLE			(1<<16)
#define WRDSWP_DISABLE		    	(0<<15)
#define WRDSWP_ENABLE			(1<<15)

#define DOUBLE_BUFFER_MODE	(0<<14)
#define TRIPLE_BUFFER_MODE	(1<<14)

#define IN_LOCAL_RGB			(0<<13)
#define IN_LOCAL_YUV			(1<<13)
#define INRGB_MASK				(1<<13)

#define MAX_BURSTLEN_16WORD	(0<<9)
#define MAX_BURSTLEN_8WORD	(1<<9)
#define MAX_BURSTLEN_4WORD	(2<<9)

#define ALPHA_MUL_DISABLE		(0<<7)
#define ALPHA_MUL_ENABLE		(1<<7)

#define BLD_PIX_PLANE			(0<<6)
#define BLD_PIX_PIXEL			(1<<6)
#define BLD_PIX_MASK			(1<<6)

#define BPPMODE_F_1BPP			(0<<2)
#define BPPMODE_F_2BPP			(1<<2)
#define BPPMODE_F_4BPP			(2<<2)
#define BPPMODE_F_8BPP_PAL	(3<<2)
#define BPPMODE_F_8BPP_NOPAL	(4<<2) // A:1 R:2 G:3 B:2
#define BPPMODE_F_16BPP_565	(5<<2)
#define BPPMODE_F_16BPP_A555	(6<<2)
#define BPPMODE_F_16BPP_I555	(7<<2)
#define BPPMODE_F_18BPP_666	(8<<2)
#define BPPMODE_F_18BPP_A665	(9<<2)
#define BPPMODE_F_19BPP_A666	(0xa<<2)
#define BPPMODE_F_24BPP_888	(0xb<<2)
#define BPPMODE_F_24BPP_A887	(0xc<<2)
#define BPPMODE_F_25BPP_A888	(0xd<<2)
#define BPPMODE_F_13BPP_A444	(0xe<<2)
#define BPPMODE_F_32BPP_8888	(0xd<<2)
#define BPPMODE_F_16BPP_4444	(0xe<<2)
#define BPPMODE_F_15BPP_555	(0xf<<2)
#define BPPMODE_F_MASK		(0xf<<2)

// WINCON1,2,3,4 BLEND_SELECT_MODE
#define BLEND_ALPHA0_PLANE		(0<<1)
#define BLEND_ALPHA1_PLANE		(1<<1)
#define BLEND_AEN_PIXEL  		(0<<1)
#define BLEND_DATA_PIXEL		(1<<1)

#define ALPHA_SEL_0				~(1<<1)		// 

#define BLEND_COLORKEY_AREA	(0<<1) 		// ???

#define BLEND_SEL_MASK			(1<<1)

#define ENWIN_F_DISABLE	    	(0<<0)
#define ENWIN_F_ENABLE			(1<<0)

// SHADOWCON (window SHADOW CONtrol register)      new(v6.0)
#define W4_SHADOW_UPDATE		(0<<14)
#define W4_SHADOW_PROTECT	(1<<14)
#define W3_SHADOW_UPDATE		(0<<13)
#define W3_SHADOW_PROTECT	(1<<13)
#define W2_SHADOW_UPDATE		(0<<12)
#define W2_SHADOW_PROTECT	(1<<12)
#define W1_SHADOW_UPDATE		(0<<11)
#define W1_SHADOW_PROTECT	(1<<11)
#define W0_SHADOW_UPDATE		(0<<10)
#define W0_SHADOW_PROTECT	(1<<10)


// VIDOSD0A, VIDOSD1A, VIDOSD2A,VIDOSD3A, VIDOSD4A
// (VIDeo window 0, 1, 2, 3, 4 position control A register)
#define OSD_LTX_F(n)				(((n)&0x7FF)<<11)
#define OSD_LTY_F(n)				(((n)&0x7FF)<<0)

// VIDOSD0B, VIDOSD1B, VIDOSD2B,VIDOSD3B, VIDOSD4B
// (VIDeo window 0, 1, 2, 3, 4 position control B register)
#define OSD_RBX_F(n)			(((n)&0x7FF)<<11)
#define OSD_RBY_F(n)			(((n)&0x7FF)<<0)

// VIDOSD0C, VIDOSD1D, VIDOSD2D
// (VIDeo window 0 position control C & window 1,2 position control D register)
#define OSDSIZE(n)				(((n)&0xFFFFFF)<<0)



// VIDINTCON0 (VIDeo INTerrupt CONtrol 0 register)
// (LCD INTERRUPT CONTROL REGISTER)
#define INTVPEN_DISABLE			(0<<26)		//new(v6.0)
#define INTVPEN_ENABLE			(1<<26)
#define SYSMAINCON_DISABLE		(0<<19)
#define SYSMAINCON_ENABLE		(1<<19)
#define SYSSUBCON_DISABLE		(0<<18)
#define SYSSUBCON_ENABLE		(1<<18)
#define I80IFDONE_DISABLE		(0<<17)
#define I80IFDONE_ENABLE		(1<<17)
#define FRAMESEL0_BACK			(0<<15)
#define FRAMESEL0_VSYNC	    	(1<<15)
#define FRAMESEL0_ACTIVE		(2<<15)
#define FRAMESEL0_FRONT	    	(3<<15)
#define FRAMESEL1_NONE			(0<<13)
#define FRAMESEL1_BACK			(1<<13)
#define FRAMESEL1_VSYNC	    	(2<<13)
#define FRAMESEL1_FRONT		(3<<13)
#define INTFRMEN_DISABLE		(0<<12)
#define INTFRMEN_ENABLE	    	(1<<12)
#define FIFOSEL_WIN4			(1<<11)		// enable FIFO Interrupt of WIN4
#define FIFOSEL_WIN3			(1<<10)
#define FIFOSEL_WIN2			(1<<9)
#define FIFOSEL_WIN1			(1<<6)
#define FIFOSEL_WIN0			(1<<5)
#define FIFOSEL_ALL				(FIFOSEL_WIN0 | FIFOSEL_WIN1 | FIFOSEL_WIN2 | FIFOSEL_WIN3 | FIFOSEL_WIN4)
#define FIFOLEVEL_25			(0<<2)
#define FIFOLEVEL_50			(1<<2)
#define FIFOLEVEL_75			(2<<2)
#define FIFOLEVEL_EMPTY			(3<<2)
#define FIFOLEVEL_FULL			(4<<2)
#define INTFIFOEN_DISABLE		(0<<1)
#define INTFIFOEN_ENABLE		(1<<1)
#define INTEN_DISABLE			(0<<0)
#define INTEN_ENABLE			(1<<0)

// VIDINTCON1 (VIDeo INTerrupt CONtrol 1 register)
// (Video interrupt pending register)
#define INTVPPEND_NOREQ		(0<<5)
#define INTVPPEND_REQ			(1<<5)
#define INTI80PEND_NOREQ		(0<<2)
#define INTI80PEND_REQ			(1<<2)
#define INTFRMPEND_NOREQ		(0<<1)
#define INTFRMPEND_REQ			(1<<1)
#define INTFIFOPEND_NOREQ		(0<<0)
#define INTFIFOPEND_REQ   		(1<<0)

// W1KEYCON0, W2KEYCON0, W3KEYCON0, W4KEYCON0(Color Key Control Register)
#define KEYBLACKOUT_DISABLE		(0<<31)
#define KEYBLACKOUT_ENABLE		(1<<31)
#define KEYBLEN_F_DISABLE			(0<<26)
#define KEYBLEN_F_ENABLE			(1<<26)
#define KEYEN_F_DISABLE	    		(0<<25)
#define KEYEN_F_ENABLE			(1<<25)
#define DIRCON_MATCH_FG_IMAGE		(0<<24)		//display pixel from BG img
#define DIRCON_MATCH_BG_IMAGE	(1<<24)		//display pixel from FG img

// DITHMODE (DITHering MODE register)
#define RDITHPOS_8BIT			(0<<5)
#define RDITHPOS_6BIT			(1<<5)
#define RDITHPOS_5BIT			(2<<5)
#define GDITHPOS_8BIT			(0<<3)
#define GDITHPOS_6BIT			(1<<3)
#define GDITHPOS_5BIT			(2<<3)
#define BDITHPOS_8BIT			(0<<1)
#define BDITHPOS_6BIT			(1<<1)
#define BDITHPOS_5BIT			(2<<1)
#define RGB_DITHPOS_MASK		(0x3f<<1)
#define DITHERING_DISABLE		(0<<0)
#define DITHERING_ENABLE		(1<<0)

// WIN0MAP, WIN1MAP, WIN2MAP, WIN3MAP, WIN4MAP (WINdow color (MAP) control)
#define COLOR_MAP_DISABLE		(0<<24)
#define COLOR_MAP_ENABLE		(1<<24)

// TRIGCON (I80/RGB LCDC_Trigger CONtrol)
// LCDC_Trigger
#define W4_SW_TRIGGER			(1<<26)
#define W4_SW_TRIG_MODE		(1<<25)
#define W3_SW_TRIGGER			(1<<21)
#define W3_SW_TRIG_MODE		(1<<20)
#define W2_SW_TRIGGER			(1<<16)
#define W2_SW_TRIG_MODE		(1<<15)
#define W1_SW_TRIGGER			(1<<11)
#define W1_SW_TRIG_MODE		(1<<10)
#define W0_SW_TRIGGER			(1<<6)
#define W0_SW_TRIG_MODE		(1<<5)
#define I80_SW_TRIGGER			(1<<1)
#define I80_SW_TRIG_MODE		(1<<0)
#define SW_TRIGGER				(1<<1)		//need to be changed with src code(08.12.10)
#define SW_TRIG_MODE			(1<<0)		//need to be changed with src code(08.12.10)


// ITUIFCON0 (ITU(BT.601/656) InterFace CONtrol)
#define SELVSYNC_HSYNC			(0<<24)		// equal leading edge with Hsync
#define SELVSYNC_DELAYED		(1<<24)		// Delayed Vsync(standard)
#define DLYVSYNC(n)				(((n)&0xFF)<<16) // Numbers of clock cycles for delay fo the VSYNC signal
#define I656FIELD_NORMAL		(0<<9)		// new code on v6.0
#define I656FIELD_INVERT			(1<<9)
#define I656CLK_NORMAL			(0<<8)
#define I656CLK_INVERT			(1<<8)
#define I601HREF_NORMAL	    	(0<<6)
#define I601HREF_INVERT			(1<<6)
#define I601VSYNC_NORMAL		(0<<5)
#define I601VSYNC_INVERT		(1<<5)
#define I601HSYNC_NORMAL		(0<<4)
#define I601HSYNC_INVERT		(1<<4)
#define I601FIELD_NORMAL		(0<<3)
#define I601FIELD_INVERT			(1<<3)
#define I601CLK_NORMAL			(0<<2)
#define I601CLK_INVERT			(1<<2)

// I80IFCONA0, I80IFCONA1 (I80 InterFace CONtrol for main & sub LDI(LCD))
// (Main LCD System Interface Control)
#define LCD_CS_SETUP(n)			(((n)&0xF)<<16)
#define LCD_WR_SETUP(n)			(((n)&0xF)<<12)
#define LCD_WR_ACT(n)			(((n)&0xF)<<8)
#define LCD_WR_HOLD(n)			(((n)&0xF)<<4)
#define RSPOL_LOW				(0<<2)
#define RSPOL_HIGH				(1<<2)
#define I80IFEN_DISABLE			(0<<0)
#define I80IFEN_ENABLE			(1<<0)

// I80IFCONB0, I80IFCONB1 (I80 InterFace CONtrol for main & sub LDI(LCD))  added on v6.0 code
#define NORMAL_CMD_ST			(1<<9)
#define FRAME_SKIP_1			(0<<5)	//no skip
#define FRAME_SKIP_2			(1<<5)	
#define FRAME_SKIP_3			(2<<5)	
#define AUTO_CMD_DISABLE		(0x0<<0)
#define AUTO_CMD_RATE(n)		((((n>>1)&0xF))<<0)		//per n frame

// W1KEYALPHA, W2KEYALPHA, W3KEYALPHA, W4KEYALPHA (Color KEY ALPHA value register) there is no W0KEYALPHA
#define KEYALPHA_R(n)				(((n)&0xFF)<<16)
#define KEYALPHA_G(n)				(((n)&0xFF)<<8)
#define KEYALPHA_B(n)				(((n)&0xFF)<<0)

// VIDW0ALPHA0, VIDW0ALPHA1 (VIDeo Window 0 ALPHA register)
#define ALPHA0_R(n)				(((n)&0xFF)<<16)
#define ALPHA0_G(n)				(((n)&0xFF)<<8)
#define ALPHA0_B(n)				(((n)&0xFF)<<0)
#define ALPHA1_R(n)				(((n)&0xFF)<<16)
#define ALPHA1_G(n)				(((n)&0xFF)<<8)
#define ALPHA1_B(n)				(((n)&0xFF)<<0)


// VIDOSD1C, VIDOSD2C, VIDOSD3C, VIDOSD4C       new(v6.0)
// (VIDeo window 1,2,3,4 position control C register)
#define ALPHA0_R_H(n)			(((n)&0xF)<<20)
#define ALPHA0_G_H(n)			(((n)&0xF)<<16)
#define ALPHA0_B_H(n)			(((n)&0xF)<<12)
#define ALPHA1_R_H(n)			(((n)&0xF)<<8)
#define ALPHA1_G_H(n)			(((n)&0xF)<<4)
#define ALPHA1_B_H(n)			(((n)&0xF)<<0)

// VIDW1ALPHA0, VIDW1ALPHA1 (VIDeo Window 1 ALPHA register)
// VIDW2ALPHA0, VIDW2ALPHA1 (VIDeo Window 2 ALPHA register)
// VIDW3ALPHA0, VIDW3ALPHA1 (VIDeo Window 3 ALPHA register)
// VIDW4ALPHA0, VIDW4ALPHA1 (VIDeo Window 4 ALPHA register)
#define ALPHA0_R_L(n)			(((n)&0xF)<<16)
#define ALPHA0_G_L(n)			(((n)&0xF)<<8)
#define ALPHA0_B_L(n)			(((n)&0xF)<<0)
#define ALPHA1_R_L(n)			(((n)&0xF)<<16)
#define ALPHA1_G_L(n)			(((n)&0xF)<<8)
#define ALPHA1_B_L(n)			(((n)&0xF)<<0)

// New feature of FIMD v6.0 (Image Enhancement Block)
// BLENDEQ1, BLENDEQ2, BLENDEQ3, BLENDEQ4 (BLENDing EQuation)
#define Q_FUNC(n)				(((n)&0xF)<<18)
#define P_FUNC(n)				(((n)&0xF)<<12)
#define B_FUNC(n)				(((n)&0xF)<<6)
#define A_FUNC(n)				(((n)&0xF)<<0)

// BLENDCON (BLENDing CONtrol register)
#define BLEND_NEW_4BIT			(0<<0)	//for FIMD v4.2 usability
#define BLEND_NEW_8BIT			(1<<0)

// COLORGAINCON (COLOR GAIN CONtrol register)
#define CG_RGAIN(n)				(((n)&0x3FF)<<20)
#define CG_GGAIN(n)				(((n)&0x3FF)<<10)
#define CG_BGAIN(n)				(((n)&0x3FF)<<0)

// VESFRCON0 (Visibility Enhancement (ALPS) CONtrol register)
#define LUX_LOW					(0<<0)
#define LUX_HIGH				(1<<2)
#define VE_SW_RESET_F_DISABLE	(0<<1)
#define VE_SW_RESET_F_ENABLE	(1<<1)

// VESFRCON1 (Visibility Enhancement (ALPS) CONtrol register)
#define VE_VSIZE_F(n)			(((n)&0x7FF)<<21)
#define VE_HSIZE_F(n)			(((n)&0x7FF)<<10)

/*
#define ODV_SEL_DISABLE		(0<<8)
#define ODV_SEL_ENABLE			(1<<8)
*/
// VESFRCON2 (Visibility Enhancement (ALPS) CONtrol register)
#define ODV_PARA1_720_288		(0x14<<12)
#define ODV_PARA1_720_240		(0x18<<12)
#define ODV_PARA1_640_240		(0x1b<<12)
#define ODV_PARA1_640_288		(0x5b<<12)

#define ODV_PARA2_640_288		(0x00<<4)
#define ODV_PARA2_720_240		(0x2d<<4)
#define ODV_PARA2_720_288		(0x2e<<4)
#define ODV_PARA2_640_240		(0x2e<<4)

#define ODV_SEL_720_288		(0x00<<0)
#define ODV_SEL_720_240		(0x00<<0)
#define ODV_SEL_640_240		(0x00<<0)
#define ODV_SEL_640_288		(0x10<<0)

#define ODV_SEL_FREESIZE		(0x11<<0)

// HUECOEF00 (HUE COEFficient control register (coeff 00))
#define CBG0_P(n)				(((n)&0x3FF)<<16)
#define CBG0_N(n)				(((n)&0x3FF)<<0)

// HUECOEF01 (HUE COEFficient control register (coeff 00))
#define CBG1_P(n)				(((n)&0x3FF)<<16)
#define CBG1_N(n)				(((n)&0x3FF)<<0)


// HUECOEF10 (HUE COEFficient control register (coeff 00))
#define CRG0_P(n)				(((n)&0x3FF)<<16)
#define CRG0_N(n)				(((n)&0x3FF)<<0)


// HUECOEF11 (HUE COEFficient control register (coeff 00))
#define CRG1_P(n)				(((n)&0x3FF)<<16)
#define CRG1_N(n)				(((n)&0x3FF)<<0)

// HUEOFFSET (HUE OFFSET control register)
#define OFFSET_IN(n)				(((n)&0x1FF)<<16)
#define OFFSET_OUT(n)			(((n)&0x1FF)<<0)

// W0RTQOSCON, W1RTQOSCON, W2RTQOSCON, W3RTQOSCON, W4RTQOSCON (Window RTQOS CONtrol register)
#define FIFOLEVEL(n)				(((n)&0xFF)<<4)		// new(v6.0)
#define QOS_GATE				(0<<1)		// gated
#define QOS_GATE_DISABLE		(1<<1)		// not gated
	
// DUALCON									//new(v6.0)
#define DUAL_DIS					(0<<0)		// FIMD Single
#define DUAL_FIMD				(1<<0)
#define DUAL_MIE				(2<<0)
#define DUAL_MDNIE				(3<<0)
#define DUAL_LINESPLIT			(0<<2)
#define DUAL_FRAMESPLIT			(1<<2)
#define DUAL_SUBCOUNT(n)			(((n)&0xFFF)<<4)
#define DUAL_MAINCOUNT(n)			(((n)&0xFFF)<<18)
#define DUAL_VDEN_EN			(1<<16)
#define DUAL_VDEN_DIS			(0<<16)


extern u32 gLCDM_HSIZE;
extern u32 gLCDM_VSIZE;	
extern u32 gVCLK_EDGE_DETECT;
extern u32 gHSYNC_POLARITY;
extern u32 gVSYNC_POLARITY;
extern u32 gVDEN_POLARITY;
extern u32 gLCDM_INTERFACE_TYPE;
extern u32 gDITHERING_FORMAT;
extern u32 gMODULE_VBPDE;
extern u32 gMODULE_VBPD;
extern u32 gMODULE_VFPD;
extern u32 gMODULE_VSPW;
extern u32 gMODULE_VFPDE;			
extern u32 gMODULE_HBPD;         
extern u32 gMODULE_HFPD;        
extern u32 gMODULE_HSPW;


LCDC oLcdc;

//---------------------------------------------------------
// Function Name : IEIP_Select
// Function Description : This function select Image Enhancement IP
// Input : eSel ; MDNIE or MIE or BYPASS
// Output : none
// Version : v0.0
//---------------------------------------------------------
void IEIP_Select(MDNIE_SEL eSel)		// need to be created at VIC controller code later (09.01.23 WJ.Kim)
{


	u32 uTmpReg;

	LcdcInp32(DUALCON,uTmpReg);

	if(eSel == DISP_MDNIE)
		uTmpReg = uTmpReg & ~(0x3) | DUAL_MDNIE ;		//mDNIe single or Dual (selectable in mDNIe IELCD SFR)
	else if(eSel == DISP_MIE)
		uTmpReg = uTmpReg & ~(0x3) | DUAL_MDNIE ;		//MIE Single
	else		//bypass
		uTmpReg = uTmpReg & ~(0x3) | DUAL_DIS ;		

	LcdcOutp32(DUALCON,uTmpReg);
	
}



void LCDC_Start(void)
{
	u32 uLcdCon;

	LcdcInp32(VIDCON0, uLcdCon);
	uLcdCon |= 0x3<<0;
	LcdcOutp32(VIDCON0, uLcdCon);
}

void LCDC_Stop(void)	// Direct off
{
	u32 uLcdCon;
	u32 uSfr;

	LcdcInp32(VIDCON0, uLcdCon);
	uLcdCon &=~ (3<<0);
	LcdcOutp32(VIDCON0, uLcdCon);
}

void LCDC_PerFrameOff(void)
{
	u32 uLcdCon;
	u32 uSfr;

	LcdcInp32(VIDCON0, uLcdCon);
	
	if(uLcdCon&(1<<29)) // interlace
		uLcdCon &=~ ((1<<29)|(1<<0));
	else				// Progressive
		uLcdCon &=~ (1<<0);
	LcdcOutp32(VIDCON0, uLcdCon);

}

void LCDC_InitIp(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWin, bool bIsDoubleBuf)
{
	LCDC_InitBase();
	LCDC_InitWin(eBpp, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, 0, 0, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,
		0, 0, uFbAddr, eWin, bIsDoubleBuf);
}


void LCDC_InitIpDualFs(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan)
{
	u32 uFbAddrB;

	LCDC_InitBaseDualFs();

	if(eScan == LCD_LANDSCAPE)
	{
	//LCD A Init
	LCDC_InitWin(eBpp,oLcdc.m_uLcdHSz, (oLcdc.m_uLcdVSz/2), 0, 0, oLcdc.m_uLcdHSz, (oLcdc.m_uLcdVSz/2),
	0, 0, uFbAddr, eWinA, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
	
	//LCD B Init	
	LCDC_InitWin(eBpp, oLcdc.m_uLcdHSz,( oLcdc.m_uLcdVSz/2), 0, 0, oLcdc.m_uLcdHSz, (oLcdc.m_uLcdVSz/2),
	0, ((oLcdc.m_uLcdVSz/2)), uFbAddrB, eWinB, false);
	}

	else
	{
	//LCD A Init
	LCDC_InitWin(eBpp,(oLcdc.m_uLcdHSz*2), (oLcdc.m_uLcdVSz/2), 0, 0, oLcdc.m_uLcdHSz, (oLcdc.m_uLcdVSz/2),
	0, 0, uFbAddr, eWinA, false);

	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz*2),( oLcdc.m_uLcdVSz/2), (oLcdc.m_uLcdHSz), 0, oLcdc.m_uLcdHSz, (oLcdc.m_uLcdVSz/2),
	0, ((oLcdc.m_uLcdVSz/2)), uFbAddr, eWinB, false);
	}
	
}


void LCDC_InitIpDualLs(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan)
{
	u32 uFbAddrB;

	LCDC_InitBaseDualLs();


	if(eScan == LCD_LANDSCAPE)
	{
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz, 0, 0, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz,
	0, 0, uFbAddr, eWinA, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
	
	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz, 0, 0, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz,
	(oLcdc.m_uLcdHSz/2), 0, uFbAddrB, eWinB, false);
	}
	else
	{
/*	
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
	0, 0, uFbAddr, eWinA, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
	
	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
	0, (oLcdc.m_uLcdVSz/2), uFbAddrB, eWinB, false);
*/
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz), 0, 0, (oLcdc.m_uLcdHSz/2), (oLcdc.m_uLcdVSz),
	0, 0, uFbAddr, eWinA, false);

	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz), (oLcdc.m_uLcdHSz/2), 0, (oLcdc.m_uLcdHSz/2), (oLcdc.m_uLcdVSz),
	(oLcdc.m_uLcdHSz/2), 0, uFbAddr, eWinB, false);


	}
}

void LCDC_InitIpDualLsSel(u32 uLCDmodel,IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan)
{
	u32 uFbAddrB;

//	LCDC_InitBaseDualLsSel(uLCDmodel);
	LCDC_InitBaseDualLs();

	if(eScan == LCD_LANDSCAPE)
	{
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz, 0, 0, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz,
	0, 0, uFbAddr, eWinA, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
	
	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz, 0, 0, (oLcdc.m_uLcdHSz/2), oLcdc.m_uLcdVSz,
	(oLcdc.m_uLcdHSz/2), 0, uFbAddrB, eWinB, false);
	}
	else
	{
/*	
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
	0, 0, uFbAddr, eWinA, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
	
	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
	0, (oLcdc.m_uLcdVSz/2), uFbAddrB, eWinB, false);
*/
	//LCD A Init
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz), 0, 0, (oLcdc.m_uLcdHSz/2), (oLcdc.m_uLcdVSz),
	0, 0, uFbAddr, eWinA, false);

	//LCD B Init	
	LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz), (oLcdc.m_uLcdHSz/2), 0, (oLcdc.m_uLcdHSz/2), (oLcdc.m_uLcdVSz),
	(oLcdc.m_uLcdHSz/2), 0, uFbAddr, eWinB, false);


	}
}




void LCDC_InitIpDualp(IMG_FMT eBpp, u32 uFbAddr,u32 uHsize, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan)
{
	u32 uFbAddrB;

	LCDC_InitBaseDualp(uHsize);
	if(eScan == LCD_LANDSCAPE)
	{
		//LCD A Init
		LCDC_InitWin(eBpp, 800, oLcdc.m_uLcdVSz, 0, 0, 800, oLcdc.m_uLcdVSz,
		0, 0, uFbAddr, eWinA, false);

		LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
		
		//LCD B Init	
		LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz - 800), oLcdc.m_uLcdVSz, 0, 0, (oLcdc.m_uLcdHSz -800), oLcdc.m_uLcdVSz,
		(800), 0, uFbAddrB, eWinB, false);
	}
	else
	{
		//LCD A Init
		LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
		0, 0, uFbAddr, eWinA, false);

		LCDC_GetFbEndAddr(&uFbAddrB, eWinA);
		
		//LCD B Init	
		LCDC_InitWin(eBpp, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2), 0, 0, (oLcdc.m_uLcdHSz), (oLcdc.m_uLcdVSz/2),
		(0), (oLcdc.m_uLcdVSz/2), uFbAddrB, eWinB, false);
	}
	
}



void LCDC_InitBase(void)
{
	u32 uVidconReg=0;
	u32 uVidCon2Reg=0;
	u32 uTmpReg;
	u32 uVidOutFormat;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	u32 uVlkcPolarity,uHsyncPolarity,uVsyncPolarity,uVdenPolarity;
	LCD_WINDOW eWin;
	u32 i;
	
	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = 0; // progressive mode
	oLcdc.m_bFifoIn[0] = false;
	oLcdc.m_bFifoIn[1] = false;
	oLcdc.m_bFifoIn[2] = false;

	oLcdc.m_uLcdHSz = gLCDM_HSIZE;
	oLcdc.m_uLcdVSz = gLCDM_VSIZE;

	if(gLCDM_INTERFACE_TYPE == RGB_PARALLEL_24bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_18bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_16bpp || 
		gLCDM_INTERFACE_TYPE == RGB_DELTA_STRUCTURE || 
		gLCDM_INTERFACE_TYPE == RGB_SERIAL)
		uVidOutFormat = VIDOUT_RGBIF;
	else
		{
			LcdcInp32(VIDCON0,uTmpReg);
			uTmpReg = (uTmpReg>>26) & 0x3;
			if(uTmpReg == 0x3)
			uVidOutFormat = VIDOUT_I80IF1;
			else
			uVidOutFormat = VIDOUT_I80IF0;
		}

	switch(gDITHERING_FORMAT)
		{
			case DITHER_888:
				oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
				break;
			case DITHER_666:
				oLcdc.m_uDitherMode = RDITHPOS_6BIT|GDITHPOS_6BIT|BDITHPOS_6BIT;
				break;
			case DITHER_565:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
				break;
			case DITHER_555:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_5BIT|BDITHPOS_5BIT;
				break;
		}
				
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	if(gVCLK_EDGE_DETECT == VCLK_RISING_EDGE)
		uVlkcPolarity = 0x0 | IVCLK_RISE_EDGE;
	else
		uVlkcPolarity = 0x0 | IVCLK_FALL_EDGE;

	if(gHSYNC_POLARITY == HSYNC_INVERT)
		uHsyncPolarity = 0x0 | IHSYNC_INVERT;
	else
		uHsyncPolarity = 0x0 | IHSYNC_NORMAL;

	if(gVSYNC_POLARITY == VSYNC_INVERT)
		uVsyncPolarity = 0x0 | IVSYNC_INVERT;
	else
		uVsyncPolarity = 0x0 | IVSYNC_NORMAL;

	if(gVDEN_POLARITY == VDEN_INVERT)
		uVdenPolarity = 0x0 | IVDEN_INVERT;
	else
		uVdenPolarity = 0x0 | IVDEN_NORMAL;

	
	LcdcOutp32(VIDCON1, uVlkcPolarity | uHsyncPolarity | uVsyncPolarity | uVdenPolarity); 	
	LcdcOutp32(VIDTCON0, VBPDE(gMODULE_VBPDE) | VBPD(gMODULE_VBPD) | VFPD(gMODULE_VFPD) | VSPW(gMODULE_VSPW));
	LcdcOutp32(VIDTCON1, VFPDE(gMODULE_VFPDE) | HBPD(gMODULE_HBPD) | HFPD(gMODULE_HFPD) | HSPW(gMODULE_HSPW));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));
	LCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(gLCDM_INTERFACE_TYPE==RGB_SERIAL)
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}

	if(gLCDM_INTERFACE_TYPE==RGB_DELTA_STRUCTURE)
		{
			uVidCon2Reg = RGB_ORDER_E_GBR | RGB_ORDER_O_RGB | RGB_SKIP_ENABLE;
			LcdcOutp32(VIDCON2, uVidCon2Reg);
		}
	
	LcdcOutp32(VIDCON0, uVidconReg);

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off

	for (i=1; i<5; i++)
	{
		eWin =
			(i == 1) ? WIN1 :
			(i == 2) ? WIN2 :
			(i == 3) ? WIN3 : WIN4;

		LCDC_SetAlpha(0x0, 0x0, 0x0, 0x0, 0x0, 0x0, eWin);
	}

}

void LCDC_InitBaseDualFs(void)
{
	u32 uVidconReg=0,uVidCon2Reg=0;
	u32 uVidOutFormat;
	u32 uTmpReg;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	u32 uVlkcPolarity,uHsyncPolarity,uVsyncPolarity,uVdenPolarity;
	LCD_WINDOW eWin;
	u32 i;
	
	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = 0; // progressive mode
	oLcdc.m_bFifoIn[0] = false;
	oLcdc.m_bFifoIn[1] = false;
	oLcdc.m_bFifoIn[2] = false;

if (LCD_MODEL == LCD_LTM030DK ||  LCD_MODEL == LCD_LTE480WV_RGB || LCD_MODEL == LCD_LTV350QV_RGB)
{
	oLcdc.m_uLcdHSz = gLCDM_HSIZE;
	oLcdc.m_uLcdVSz = gLCDM_VSIZE*2;
}
	oLcdc.m_uLcdHSz = gLCDM_HSIZE*2;
	oLcdc.m_uLcdVSz = gLCDM_VSIZE;

	if(gLCDM_INTERFACE_TYPE == RGB_PARALLEL_24bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_18bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_16bpp || 
		gLCDM_INTERFACE_TYPE == RGB_DELTA_STRUCTURE || 
		gLCDM_INTERFACE_TYPE == RGB_SERIAL)
		uVidOutFormat = VIDOUT_RGBIF;
	else
		{
			LcdcInp32(VIDCON0,uTmpReg);
			uTmpReg = (uTmpReg>>26) & 0x3;
			if(uTmpReg == 0x3)
			uVidOutFormat = VIDOUT_I80IF1;
			else
			uVidOutFormat = VIDOUT_I80IF0;
		}

	switch(gDITHERING_FORMAT)
		{
			case DITHER_888:
				oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
				break;
			case DITHER_666:
				oLcdc.m_uDitherMode = RDITHPOS_6BIT|GDITHPOS_6BIT|BDITHPOS_6BIT;
				break;
			case DITHER_565:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
				break;
			case DITHER_555:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_5BIT|BDITHPOS_5BIT;
				break;
		}
				
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	if(gVCLK_EDGE_DETECT == VCLK_RISING_EDGE)
		uVlkcPolarity = IVCLK_RISE_EDGE;
	else
		uVlkcPolarity = IVCLK_FALL_EDGE;

	if(gHSYNC_POLARITY == HSYNC_INVERT)
		uHsyncPolarity == IHSYNC_INVERT;
	else
		uHsyncPolarity == IHSYNC_NORMAL;

	if(gVSYNC_POLARITY == VSYNC_INVERT)
		uVsyncPolarity == IVSYNC_INVERT;
	else
		uVsyncPolarity == IVSYNC_NORMAL;

	if(gVDEN_POLARITY == VDEN_INVERT)
		uVdenPolarity == IVDEN_INVERT;
	else
		uVdenPolarity == IVDEN_NORMAL;

	
	LcdcOutp32(VIDCON1, uVlkcPolarity | uHsyncPolarity | uVsyncPolarity); 	
	LcdcOutp32(VIDTCON0, VBPDE(gMODULE_VBPDE) | VBPD(gMODULE_VBPD) | VFPD(gMODULE_VFPD) | VSPW(gMODULE_VSPW));
	LcdcOutp32(VIDTCON1, VFPDE(gMODULE_VFPDE) | HBPD(gMODULE_HBPD) | HFPD(gMODULE_HFPD) | HSPW(gMODULE_HSPW));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));
	LCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(gLCDM_INTERFACE_TYPE==RGB_SERIAL)
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}

	if(gLCDM_INTERFACE_TYPE==RGB_DELTA_STRUCTURE)
		{
			uVidCon2Reg = RGB_ORDER_E_GBR | RGB_ORDER_O_RGB | RGB_SKIP_ENABLE;
			LcdcOutp32(VIDCON2, uVidCon2Reg);
		}
	
	LcdcOutp32(VIDCON0, uVidconReg);

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off

	for (i=1; i<5; i++)
	{
		eWin =
			(i == 1) ? WIN1 :
			(i == 2) ? WIN2 :
			(i == 3) ? WIN3 : WIN4;

		LCDC_SetAlpha(0x0, 0x0, 0x0, 0x0, 0x0, 0x0, eWin);
	}
}

void LCDC_InitBaseDualLs(void)
{
	u32 uVidconReg=0,uVidCon2Reg=0;
	u32 uVidOutFormat;
	u32 uTmpReg;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	u32 uVlkcPolarity,uHsyncPolarity,uVsyncPolarity,uVdenPolarity;
	LCD_WINDOW eWin;
	u32 i;
	
	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = 0; // progressive mode
	oLcdc.m_bFifoIn[0] = false;
	oLcdc.m_bFifoIn[1] = false;
	oLcdc.m_bFifoIn[2] = false;

	oLcdc.m_uLcdHSz = gLCDM_HSIZE*2;
	oLcdc.m_uLcdVSz = gLCDM_VSIZE;

	if(gLCDM_INTERFACE_TYPE == RGB_PARALLEL_24bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_18bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_16bpp || 
		gLCDM_INTERFACE_TYPE == RGB_DELTA_STRUCTURE || 
		gLCDM_INTERFACE_TYPE == RGB_SERIAL)
		uVidOutFormat = VIDOUT_RGBIF;
	else
		{
			LcdcInp32(VIDCON0,uTmpReg);
			uTmpReg = (uTmpReg>>26) & 0x3;
			if(uTmpReg == 0x3)
			uVidOutFormat = VIDOUT_I80IF1;
			else
			uVidOutFormat = VIDOUT_I80IF0;
		}

	switch(gDITHERING_FORMAT)
		{
			case DITHER_888:
				oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
				break;
			case DITHER_666:
				oLcdc.m_uDitherMode = RDITHPOS_6BIT|GDITHPOS_6BIT|BDITHPOS_6BIT;
				break;
			case DITHER_565:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
				break;
			case DITHER_555:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_5BIT|BDITHPOS_5BIT;
				break;
		}
				
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	if(gVCLK_EDGE_DETECT == VCLK_RISING_EDGE)
		uVlkcPolarity = 0x0 | IVCLK_RISE_EDGE;
	else
		uVlkcPolarity = 0x0 | IVCLK_FALL_EDGE;

	if(gHSYNC_POLARITY == HSYNC_INVERT)
		uHsyncPolarity = 0x0 | IHSYNC_INVERT;
	else
		uHsyncPolarity = 0x0 | IHSYNC_NORMAL;

	if(gVSYNC_POLARITY == VSYNC_INVERT)
		uVsyncPolarity = 0x0 | IVSYNC_INVERT;
	else
		uVsyncPolarity = 0x0 | IVSYNC_NORMAL;

	if(gVDEN_POLARITY == VDEN_INVERT)
		uVdenPolarity = 0x0 | IVDEN_INVERT;
	else
		uVdenPolarity = 0x0 | IVDEN_NORMAL;

	
	LcdcOutp32(VIDCON1, uVlkcPolarity | uHsyncPolarity | uVsyncPolarity | uVdenPolarity); 	
	LcdcOutp32(VIDTCON0, VBPDE(gMODULE_VBPDE) | VBPD(gMODULE_VBPD) | VFPD(gMODULE_VFPD) | VSPW(gMODULE_VSPW));
	LcdcOutp32(VIDTCON1, VFPDE(gMODULE_VFPDE) | HBPD(gMODULE_HBPD) | HFPD(gMODULE_HFPD) | HSPW(gMODULE_HSPW));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));
	LCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(gLCDM_INTERFACE_TYPE==RGB_SERIAL)
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}

	if(gLCDM_INTERFACE_TYPE==RGB_DELTA_STRUCTURE)
		{
			uVidCon2Reg = RGB_ORDER_E_GBR | RGB_ORDER_O_RGB | RGB_SKIP_ENABLE;
			LcdcOutp32(VIDCON2, uVidCon2Reg);
		}
	
	LcdcOutp32(VIDCON0, uVidconReg);

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off

	for (i=1; i<5; i++)
	{
		eWin =
			(i == 1) ? WIN1 :
			(i == 2) ? WIN2 :
			(i == 3) ? WIN3 : WIN4;

		LCDC_SetAlpha(0x0, 0x0, 0x0, 0x0, 0x0, 0x0, eWin);
	}

}


/*
void LCDC_InitBaseDualLsSel(u32 uLCDmodel)
{
	u32 uVidconReg=0;
	u32 uVidOutFormat;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	LCD_WINDOW eWin;
	u32 i;
	
	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = 0; // progressive mode
	oLcdc.m_bFifoIn[0] = false;
	oLcdc.m_bFifoIn[1] = false;
	oLcdc.m_bFifoIn[2] = false;

if (uLCDmodel == LCD_LTV350QV_RGB)
{
//	oLcdc.m_uLcdHSz = 320;
//	oLcdc.m_uLcdVSz = 480;
	oLcdc.m_uLcdHSz = 640;
	oLcdc.m_uLcdVSz = 240;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	LcdcOutp32(VIDCON1, IHSYNC_INVERT | IVSYNC_INVERT); 	
	LcdcOutp32(VIDTCON0, VBPDE(VBPD_LTV350QV) | VBPD(VBPD_LTV350QV) | VFPD(VFPD_LTV350QV) | VSPW(VSPW_LTV350QV));
	LcdcOutp32(VIDTCON1, VFPDE(VFPD_LTV350QV) | HBPD(HBPD_LTV350QV) | HFPD(HFPD_LTV350QV) | HSPW(HSPW_LTV350QV));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

}

else if ( uLCDmodel == LCD_LTS350Q1 )
{
	oLcdc.m_uLcdHSz = 480;
	oLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	LcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_NORMAL | IVSYNC_NORMAL | IVDEN_NORMAL);
	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_240320) | VFPD(VFPD_240320) | VSPW(VSPW_240320));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_240320) | HFPD(HFPD_240320) | HSPW(HSPW_240320));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
}	
else if ( uLCDmodel == LCD_LTS222Q_CPU || uLCDmodel == LCD_S6D0139_CPU )
{
	oLcdc.m_uLcdHSz = 480;
	oLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_I80IF0;
}	
else if ( uLCDmodel == LCD_LTS222Q_RGB )
{
	oLcdc.m_uLcdHSz = 480;
	oLcdc.m_uLcdVSz = 320;
	//oLcdc.m_uLcdHSz = 320;
	//oLcdc.m_uLcdVSz = 240;

	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	LcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
}

else if ( uLCDmodel == LCD_LTS222Q_SRGB)
{
	oLcdc.m_uLcdHSz = 480;
	oLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	uVidconReg |= PNRMODE_RGB_S;
	LcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
}

else if (uLCDmodel == LCD_LTE480WV_RGB)
{
	oLcdc.m_uLcdHSz = 1600;
	oLcdc.m_uLcdVSz = 480;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	LcdcOutp32(VIDCON1,IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	LcdcOutp32(VIDTCON0, VBPDE(6) | VBPD(6) | VFPD(4) | VSPW(0) );
	LcdcOutp32(VIDTCON1, VFPDE(4) | HBPD(12) | HFPD(7) | HSPW(2));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
}

else if (uLCDmodel == LCD_LTM030DK)
{
	oLcdc.m_uLcdHSz = 960;
	oLcdc.m_uLcdVSz = 800;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	
	LcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_NORMAL); //Check 

	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTM030DK3A ) | VFPD(VFPD_LTM030DK3A ) | VSPW(VSPW_LTM030DK3A ));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTM030DK3A ) | HFPD(HFPD_LTM030DK3A ) | HSPW(HSPW_LTM030DK3A ));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
}
else if (uLCDmodel == LCD_TL2796)
{
	oLcdc.m_uLcdHSz = 960;
	oLcdc.m_uLcdVSz = 800;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	
	LcdcOutp32(VIDCON1, IVCLK_RISE_EDGE| IHSYNC_INVERT | IVSYNC_INVERT |IVDEN_INVERT); //Check 

	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_TL2796) | VFPD(VFPD_TL2796 ) | VSPW(VSPW_TL2796 ));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_TL2796 ) | HFPD(HFPD_TL2796 ) | HSPW(HSPW_TL2796 ));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

}
else if (uLCDmodel == LCD_LMS280GS01)
{
	oLcdc.m_uLcdHSz = 480;
	oLcdc.m_uLcdVSz = 320;
	uVidOutFormat = VIDOUT_RGBIF;
	oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;
	LcdcOutp32(VIDCON1, IVCLK_RISE_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_INVERT);
	LcdcOutp32(VIDTCON0, VBPDE(8) | VBPD(8) | VFPD(8) | VSPW(8) );
	LcdcOutp32(VIDTCON1, VFPDE(8) | HBPD(8) | HFPD(8) | HSPW(8));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

}
else
	Assert(0);


	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));
	LCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(uLCDmodel==LCD_LTS222Q_SRGB)
	uVidconReg =
		VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
		CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
		ENVID_DISABLE | ENVID_F_DISABLE;
	else
	uVidconReg =
		VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
		CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
		ENVID_DISABLE | ENVID_F_DISABLE;

	LcdcOutp32(VIDCON0, uVidconReg);

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off

	for (i=1; i<5; i++)
	{
		eWin =
			(i == 1) ? WIN1 :
			(i == 2) ? WIN2 :
			(i == 3) ? WIN3 : WIN4;

		LCDC_SetAlpha(0x0, 0x0, 0x0, 0x0, 0x0, 0x0, eWin);
	}

}
*/


//Temporary code for WVGA 4.8" dual lcd test
void LCDC_InitBaseDualp(u32 uHsize)
{
	u32 uVidconReg=0,uVidCon2Reg=0;
	u32 uVidOutFormat;
	u32 uTmpReg;
	u32 uLcdCon;
	u32 uClkVal, uClkDir;
	u32 uVlkcPolarity,uHsyncPolarity,uVsyncPolarity,uVdenPolarity;
	LCD_WINDOW eWin;
	u32 i;
	
	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = 0; // progressive mode
	oLcdc.m_bFifoIn[0] = false;
	oLcdc.m_bFifoIn[1] = false;
	oLcdc.m_bFifoIn[2] = false;

	oLcdc.m_uLcdHSz = uHsize;
	oLcdc.m_uLcdVSz = gLCDM_VSIZE;

	if(gLCDM_INTERFACE_TYPE == RGB_PARALLEL_24bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_18bpp || 
		gLCDM_INTERFACE_TYPE == RGB_PARALLEL_16bpp || 
		gLCDM_INTERFACE_TYPE == RGB_DELTA_STRUCTURE || 
		gLCDM_INTERFACE_TYPE == RGB_SERIAL)
		uVidOutFormat = VIDOUT_RGBIF;
	else
		{
			LcdcInp32(VIDCON0,uTmpReg);
			uTmpReg = (uTmpReg>>26) & 0x3;
			if(uTmpReg == 0x3)
			uVidOutFormat = VIDOUT_I80IF1;
			else
			uVidOutFormat = VIDOUT_I80IF0;
		}

	switch(gDITHERING_FORMAT)
		{
			case DITHER_888:
				oLcdc.m_uDitherMode = RDITHPOS_8BIT|GDITHPOS_8BIT|BDITHPOS_8BIT;
				break;
			case DITHER_666:
				oLcdc.m_uDitherMode = RDITHPOS_6BIT|GDITHPOS_6BIT|BDITHPOS_6BIT;
				break;
			case DITHER_565:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
				break;
			case DITHER_555:
				oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_5BIT|BDITHPOS_5BIT;
				break;
		}
				
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	if(gVCLK_EDGE_DETECT == VCLK_RISING_EDGE)
		uVlkcPolarity = 0x0 | IVCLK_RISE_EDGE;
	else
		uVlkcPolarity = 0x0 | IVCLK_FALL_EDGE;

	if(gHSYNC_POLARITY == HSYNC_INVERT)
		uHsyncPolarity = 0x0 | IHSYNC_INVERT;
	else
		uHsyncPolarity = 0x0 | IHSYNC_NORMAL;

	if(gVSYNC_POLARITY == VSYNC_INVERT)
		uVsyncPolarity = 0x0 | IVSYNC_INVERT;
	else
		uVsyncPolarity = 0x0 | IVSYNC_NORMAL;

	if(gVDEN_POLARITY == VDEN_INVERT)
		uVdenPolarity = 0x0 | IVDEN_INVERT;
	else
		uVdenPolarity = 0x0 | IVDEN_NORMAL;

	
	LcdcOutp32(VIDCON1, uVlkcPolarity | uHsyncPolarity | uVsyncPolarity | uVdenPolarity); 	
	LcdcOutp32(VIDTCON0, VBPDE(gMODULE_VBPDE) | VBPD(gMODULE_VBPD) | VFPD(gMODULE_VFPD) | VSPW(gMODULE_VSPW));
	LcdcOutp32(VIDTCON1, VFPDE(gMODULE_VFPDE) | HBPD(gMODULE_HBPD) | HFPD(gMODULE_HFPD) | HSPW(gMODULE_HSPW));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix

	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));
	LCDC_Stop();
	
	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )	// checking whether disable the video output and the Display control signal or not.
			break;
	}

	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz,      &uClkVal, &uClkDir);

	if(gLCDM_INTERFACE_TYPE==RGB_SERIAL)
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_S | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}
	else
		{
			if(LCD_VCLKSRC == LCD_HCLK)
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_HCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
			else
			{
			uVidconReg = VID_PROGRESSIVE | uVidOutFormat | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
			CLKVAL_F(uClkVal) | VCLKFREE_NORMAL | CLKDIR_F(uClkDir) | CLKSEL_F_SCLK |
			ENVID_DISABLE | ENVID_F_DISABLE;
			}
		}

	if(gLCDM_INTERFACE_TYPE==RGB_DELTA_STRUCTURE)
		{
			uVidCon2Reg = RGB_ORDER_E_GBR | RGB_ORDER_O_RGB | RGB_SKIP_ENABLE;
			LcdcOutp32(VIDCON2, uVidCon2Reg);
		}
	
	LcdcOutp32(VIDCON0, uVidconReg);

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off

	for (i=1; i<5; i++)
	{
		eWin =
			(i == 1) ? WIN1 :
			(i == 2) ? WIN2 :
			(i == 3) ? WIN3 : WIN4;

		LCDC_SetAlpha(0x0, 0x0, 0x0, 0x0, 0x0, 0x0, eWin);
	}


}



void LCDC_InitWin(IMG_FMT eBpp, u32 uFrameH, u32 uFrameV, u32 uX_Frame, u32 uY_Frame,  u32 uViewH, u32 uViewV,
		u32 uX_Lcd, u32 uY_Lcd, u32 uFbAddr, LCD_WINDOW eWin, LCDC_AUTO_BUFFER_MODE bIsDoubleBuf) // For WIN0
{
	u32 uOffset;
	u32 uLineVal;
	u32 uBurstSize;

	Assert( (uFbAddr&0xe00000)!=0xe00000);
	
/*  /////  v6.0's WIN2,3,4 can support Double buffering  ////
	if ( (eWin != WIN0 && eWin != WIN1) && bIsDoubleBuf == true )
		Assert(0); // In WIN2, WIN3 or WIN4, Double buffering can't be supported
*/

	// Viewport size must be less than LCD size
	Assert(uViewH <= oLcdc.m_uLcdHSz);
	Assert(uViewV <= oLcdc.m_uLcdVSz);

	// Check (X,Y) coordinate is valid in LCD and Frame?
	Assert( ((uX_Frame + uViewH) <= uFrameH) && ((uY_Frame + uViewV) <= uFrameV) );
	Assert( (uX_Lcd + uViewH <= oLcdc.m_uLcdHSz) && (uY_Lcd + uViewV <= oLcdc.m_uLcdVSz) );
	
	oLcdc.m_uFrmHSz[eWin] = uFrameH;
	oLcdc.m_uFrmVSz[eWin] = uFrameV;

	oLcdc.m_uViewHSz[eWin] = uViewH;
	oLcdc.m_uViewVSz[eWin] = uViewV;

	oLcdc.m_uLcdStX = uX_Lcd;
	oLcdc.m_uLcdStY = uY_Lcd;

	uOffset = oLcdc.m_uFrmHSz[eWin] - oLcdc.m_uViewHSz[eWin];

	oLcdc.m_uBytSwpMode = BYTSWP_DISABLE;
	oLcdc.m_uHawSwpMode = HAWSWP_DISABLE;

	oLcdc.m_uMaxBurstLen = MAX_BURSTLEN_16WORD;
	
	if (eBpp == PAL1)
	{
		oLcdc.m_uBytes = 1;
		oLcdc.m_uBits = 4;
		Assert( !(uOffset%32) ); // Must keep to word-alignment
		oLcdc.m_uBppMode = BPPMODE_F_1BPP;

		oLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL2)
	{
		oLcdc.m_uBytes = 1;
		oLcdc.m_uBits = 4;
		Assert( !(uOffset%16) ); // Must keep to word-alignment
		oLcdc.m_uBppMode = BPPMODE_F_2BPP;

		oLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL4)
	{
		oLcdc.m_uBytes = 1;
		oLcdc.m_uBits = 2;

		Assert( !(uOffset%8) ); // Must keep to word-alignment
		oLcdc.m_uBppMode = BPPMODE_F_4BPP;

		oLcdc.m_uMaxBurstLen = MAX_BURSTLEN_4WORD;
	}
	else if (eBpp == PAL8)
	{
		oLcdc.m_uBytes = 1;
		oLcdc.m_uBits = 1;
		Assert( !(uOffset%4) ); // Must keep to word-alignment
		oLcdc.m_uBppMode = BPPMODE_F_8BPP_PAL;
		oLcdc.m_uBytSwpMode = BYTSWP_ENABLE;
	}
	else if (eBpp == ARGB8) // A232
	{
		oLcdc.m_uBytes = 1;
		oLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oLcdc.m_uBppMode = BPPMODE_F_8BPP_NOPAL;
		oLcdc.m_uHawSwpMode = BYTSWP_ENABLE;
	}
	else if (eBpp == RGB16)
	{
		oLcdc.m_uBytes = 2;
		oLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oLcdc.m_uBppMode = BPPMODE_F_16BPP_565;
		oLcdc.m_uHawSwpMode = HAWSWP_ENABLE;
		oLcdc.m_uWordSwpMode = WRDSWP_DISABLE;
	}
	else if (eBpp == ARGB16)
	{
		oLcdc.m_uBytes = 2;
		oLcdc.m_uBits = 1;
		Assert( !(uOffset%2) ); // Must keep to word-alignment

		oLcdc.m_uBppMode = BPPMODE_F_16BPP_A555;
		oLcdc.m_uHawSwpMode = HAWSWP_ENABLE;
	}
	else if (eBpp == RGB18)
	{
		oLcdc.m_uBytes = 4;
		oLcdc.m_uBits = 1;

		oLcdc.m_uWordSwpMode = WRDSWP_ENABLE;
		oLcdc.m_uBppMode = BPPMODE_F_18BPP_666;
	}
	else if (eBpp == RGB24)
	{
		oLcdc.m_uBytes = 4;
		oLcdc.m_uBits = 1;

		oLcdc.m_uWordSwpMode = WRDSWP_ENABLE;
		oLcdc.m_uBppMode = BPPMODE_F_24BPP_888;
	}
	else if (eBpp == ARGB24)
	{
		oLcdc.m_uBytes = 4;
		oLcdc.m_uBits = 1;

		oLcdc.m_uWordSwpMode = WRDSWP_ENABLE;
		oLcdc.m_uBppMode = BPPMODE_F_24BPP_A887;
	}

	else if (eBpp == ARGB25)
	{
		oLcdc.m_uBytes = 4;
		oLcdc.m_uBits = 1;
		oLcdc.m_uBppMode = BPPMODE_F_25BPP_A888;
	}

	else if (eBpp == ARGB8888)
	{
		oLcdc.m_uBytes = 4;
		oLcdc.m_uBits = 1;
		oLcdc.m_uBppMode = BPPMODE_F_32BPP_8888;
	}
	else
	{
		Assert(0);
	}

	// Get offsetsize, pagewidth and lineVal
	if (oLcdc.m_uFrmHSz[eWin] >= oLcdc.m_uViewHSz[eWin])
	{
		oLcdc.m_uOffsetSz[eWin] = uOffset*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uPageWidth[eWin] = oLcdc.m_uViewHSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;

		uBurstSize =
			(oLcdc.m_uMaxBurstLen == MAX_BURSTLEN_16WORD) ? 16*4 :
			(oLcdc.m_uMaxBurstLen == MAX_BURSTLEN_8WORD) ? 8*4 : 4*4;

		// Offset size must be more than the burst size
		Assert(oLcdc.m_uOffsetSz[eWin] == 0 || !(oLcdc.m_uOffsetSz[eWin]%4) );
		Assert(oLcdc.m_uPageWidth[eWin] > uBurstSize); // Page width must be more than burst size and be word-aligned
		Assert( !( (oLcdc.m_uPageWidth[eWin]+oLcdc.m_uOffsetSz[eWin])%4 ) );

		uLineVal = oLcdc.m_uViewVSz[eWin] - 1;
	}
	else
	{
		Assert(0);
	}
	
	oLcdc.m_uImgStAddr[eWin] = uFbAddr;

	oLcdc.m_uFbStAddr[eWin] = uFbAddr + (oLcdc.m_uFrmHSz[eWin]*uY_Frame + uX_Frame)*oLcdc.m_uBytes/oLcdc.m_uBits;
	oLcdc.m_uFbEndAddr[eWin] = oLcdc.m_uFbStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(uFrameV);  // ref.VIDWxxADD1
//	if ( (bIsDoubleBuf == true) && ((eWin == WIN0) || (eWin == WIN1)) )
//   v6.0's all windows support double buffer
	if ( bIsDoubleBuf == LCDC_BUF_SINGLE)
	{
		oLcdc.m_uDoubleBufImgStAddr[eWin] = oLcdc.m_uImgStAddr[eWin];
		oLcdc.m_uDoubleBufStAddr[eWin] = oLcdc.m_uFbStAddr[eWin];
		oLcdc.m_uDoubleBufEndAddr[eWin] = oLcdc.m_uFbEndAddr[eWin];

		oLcdc.m_uTripleBufImgStAddr[eWin] = oLcdc.m_uDoubleBufImgStAddr[eWin];
		oLcdc.m_uTripleBufStAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] ;
		oLcdc.m_uTripleBufEndAddr[eWin] = oLcdc.m_uDoubleBufEndAddr[eWin];
	}
	else if ( bIsDoubleBuf == LCDC_BUF_DOUBLE )
	{
		oLcdc.m_uDoubleBufImgStAddr[eWin] = oLcdc.m_uImgStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufStAddr[eWin] = oLcdc.m_uFbStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufEndAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(uFrameV);

		oLcdc.m_uTripleBufImgStAddr[eWin] = oLcdc.m_uDoubleBufImgStAddr[eWin];
		oLcdc.m_uTripleBufStAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] ;
		oLcdc.m_uTripleBufEndAddr[eWin] = oLcdc.m_uDoubleBufEndAddr[eWin];
		
	}
//	else if ( (bIsDoubleBuf == false) && ((eWin == WIN0) || (eWin == WIN1)) )
	else if ( bIsDoubleBuf == LCDC_BUF_TRIPLE)
	{
		oLcdc.m_uDoubleBufImgStAddr[eWin] = oLcdc.m_uImgStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufStAddr[eWin] = oLcdc.m_uFbStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufEndAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(uFrameV);

		oLcdc.m_uTripleBufImgStAddr[eWin] = oLcdc.m_uDoubleBufImgStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uTripleBufStAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uTripleBufEndAddr[eWin] = oLcdc.m_uTripleBufStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(uFrameV);

	}
	else
	{
		Assert(0);
	}

// For back-ward compatibility LCDC V4.0
// WIN0 do not support Blending Equation
	if ( eWin!=WIN0)
	{
		LCDC_SetBlendingEquation(0, 0, 3, 2, eWin);
	}
	LCDC_SetAlphaValWidth(ALPHA_8BIT);
	LCDC_InitWinRegs(eWin);

	LCDC_SetWinOnOff(1, eWin);	// Turn on window's ENWIN_F

}

void LCDC_InitWinRegs(LCD_WINDOW eWin)
{
	u32 uWinConXReg;
	u32 uFrmBufStAddrReg;
	u32 uFrmBufEndAddrReg;
	u32 uFrmDBufStAddrReg;
	u32 uFrmDBufEndAddrReg;	
	u32 uFrmDBufStAddrRegVal;
	u32 uFrmDBufEndAddrRegVal;
	u32 uFrmTBufStAddrReg;
	u32 uFrmTBufEndAddrReg;	
	u32 uOffsetPageWidthReg;
	u32 uOsdLeftPosReg;
	u32 uOsdRightPosReg;
	u32 uWinConXRegVal;
	u32 uAlphaRegH;
	u32 uAlpha0RegL;
	u32 uAlpha1RegL;
	u32 uLcdEndX, uLcdEndY;

	uWinConXReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	uFrmBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0:
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	uFrmBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B0 :
		(eWin == WIN1) ? VIDW01ADD1B0 :
		(eWin == WIN2) ? VIDW02ADD1B0 :
		(eWin == WIN3) ? VIDW03ADD1B0 : VIDW04ADD1B0;
		
	uFrmDBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B1 :
		(eWin == WIN1) ? VIDW01ADD0B1:
		(eWin == WIN2) ? VIDW02ADD0B1 :
		(eWin == WIN3) ? VIDW03ADD0B1 : VIDW04ADD0B1;

	uFrmDBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B1 :
		(eWin == WIN1) ? VIDW01ADD1B1 :
		(eWin == WIN2) ? VIDW02ADD1B1 :
		(eWin == WIN3) ? VIDW03ADD1B1 : VIDW04ADD1B1;

	uFrmTBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B2 :
		(eWin == WIN1) ? VIDW01ADD0B2:
		(eWin == WIN2) ? VIDW02ADD0B2 :
		(eWin == WIN3) ? VIDW03ADD0B2 : VIDW04ADD0B2;

	uFrmTBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B2 :
		(eWin == WIN1) ? VIDW01ADD1B2 :
		(eWin == WIN2) ? VIDW02ADD1B2 :
		(eWin == WIN3) ? VIDW03ADD1B2 : VIDW04ADD1B2;

	uOffsetPageWidthReg =
		(eWin == WIN0) ? VIDW00ADD2 :
		(eWin == WIN1) ? VIDW01ADD2 :
		(eWin == WIN2) ? VIDW02ADD2 :
		(eWin == WIN3) ? VIDW03ADD2 : VIDW04ADD2;

	uOsdLeftPosReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;

	uOsdRightPosReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	uWinConXRegVal = 0;
	
	if (eWin == WIN0)
	{
		if (!oLcdc.m_bFifoIn[0]) // Input path is DMA
		{
			uWinConXRegVal =
				PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
				oLcdc.m_uBytSwpMode | oLcdc.m_uHawSwpMode|oLcdc.m_uWordSwpMode|
				oLcdc.m_uMaxBurstLen |oLcdc.m_uBppMode | ENWIN_F_DISABLE;
			
		}
		
		else // Input path is Local
		
		{
			Assert(oLcdc.m_eLocalIn[0] == IN_POST);

			if(oLcdc.m_uLocalInColorSpace[0] == LOCAL_IF_YCBCR444)
			{
				uWinConXRegVal =
				PATH_LOCAL | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE | 
				HAWSWP_DISABLE | WRDSWP_DISABLE |IN_LOCAL_YUV |
				oLcdc.m_uMaxBurstLen | oLcdc.m_uBppMode | ENWIN_F_DISABLE;
			}
			else
			{
				uWinConXRegVal =
				PATH_LOCAL | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE | 
				HAWSWP_DISABLE | WRDSWP_DISABLE |IN_LOCAL_RGB |
				oLcdc.m_uMaxBurstLen | oLcdc.m_uBppMode | ENWIN_F_DISABLE;
			}
		}


//		LcdcOutp32(VIDW00ADD0B1, oLcdc.m_uDoubleBufStAddr[0]);
//		LcdcOutp32(VIDW00ADD1B1, oLcdc.m_uDoubleBufEndAddr[0]);
		LcdcOutp32(VIDOSD0C, OSDSIZE(oLcdc.m_uViewHSz[0]*oLcdc.m_uViewVSz[0]));

		// Set WIN0 alpha value
		LcdcOutp32(VIDW0ALPHA0, ALPHA0_R(0xFF) | ALPHA0_G(0xFF) | ALPHA0_B(0xFF));
		LcdcOutp32(VIDW0ALPHA1, ALPHA1_R(0xFF) | ALPHA1_G(0xFF) | ALPHA1_B(0xFF));
	}
	
	else //((eWin==WIN1)||(eWin==WIN2)||(eWin==WIN3)||(eWin==WIN4))
	{
		if (eWin == WIN1)
		{
			if (!oLcdc.m_bFifoIn[1]) // Input path is DMA
			{
				uWinConXRegVal =
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
					oLcdc.m_uBytSwpMode | oLcdc.m_uHawSwpMode|oLcdc.m_uWordSwpMode|
					oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE| oLcdc.m_uBppMode | 
					BLEND_ALPHA0_PLANE| ENWIN_F_DISABLE;
			}
			else // Input path is Local
			{
				Assert(oLcdc.m_eLocalIn[1] == IN_POST || oLcdc.m_eLocalIn[1] == IN_CIM);
				
				if(oLcdc.m_uLocalInColorSpace[1] == LOCAL_IF_YCBCR444)
				{
					uWinConXRegVal = PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
					HAWSWP_DISABLE |WRDSWP_DISABLE | IN_LOCAL_YUV |
					oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode |
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
				}
				else
				{	
					uWinConXRegVal = PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
					HAWSWP_DISABLE|WRDSWP_DISABLE| IN_LOCAL_RGB |
					oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode |
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;		
				}
			}
			
			// set double buf. addr. and offset size
//			LcdcOutp32(VIDW01ADD0B1, oLcdc.m_uDoubleBufStAddr[1]);
//			LcdcOutp32(VIDW01ADD1B1, oLcdc.m_uDoubleBufEndAddr[1]);

			LcdcOutp32(VIDOSD1D, OSDSIZE(oLcdc.m_uViewHSz[1]*oLcdc.m_uViewVSz[1]));					
		}
		
		else // eWin == WIN2 OR WIN3 OR WIN4
		{
			if (eWin == WIN2)
			{
				if (!oLcdc.m_bFifoIn[2]) // Input path is DMA
				{
					uWinConXRegVal =
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE |
						oLcdc.m_uBytSwpMode | oLcdc.m_uHawSwpMode|oLcdc.m_uWordSwpMode|
						oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode |
						BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
				}
				else // Input path is Local
				{
					Assert(oLcdc.m_eLocalIn[2] == IN_POST || oLcdc.m_eLocalIn[2] == IN_CIM);					
		
					if(oLcdc.m_uLocalInColorSpace[2] == LOCAL_IF_YCBCR444)
					{
						uWinConXRegVal = 
							PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
							HAWSWP_DISABLE |WRDSWP_DISABLE | IN_LOCAL_YUV |
							oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode |
							BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
					}
					else
					{
						uWinConXRegVal = 
							PATH_LOCAL| WBUF0 | WBUFAUTO_DISABLE | BITSWP_DISABLE | BYTSWP_DISABLE |
							HAWSWP_DISABLE|WRDSWP_DISABLE| IN_LOCAL_RGB |
							oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode |
							BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;		
					}
				}

				// set double buf. addr. and offset size
//				LcdcOutp32(VIDW02ADD0B1, oLcdc.m_uDoubleBufStAddr[2]);
//				LcdcOutp32(VIDW02ADD1B1, oLcdc.m_uDoubleBufEndAddr[2]);

				LcdcOutp32(VIDOSD2D, OSDSIZE(oLcdc.m_uViewHSz[2]*oLcdc.m_uViewVSz[2]));				
			}
			else // eWin == WIN3 || eWin == WIN4
			{
				uWinConXRegVal = 
					PATH_DMA | WBUF0 | WBUFAUTO_DISABLE |					
					BITSWP_DISABLE | oLcdc.m_uBytSwpMode | oLcdc.m_uHawSwpMode |oLcdc.m_uWordSwpMode|
					oLcdc.m_uMaxBurstLen | BLD_PIX_PLANE | oLcdc.m_uBppMode | 
					BLEND_ALPHA0_PLANE | ENWIN_F_DISABLE;
/*				
				if(eWin == WIN3)
				{
					LcdcOutp32(VIDW03ADD0B1, oLcdc.m_uDoubleBufStAddr[3]);
					LcdcOutp32(VIDW03ADD1B1, oLcdc.m_uDoubleBufEndAddr[3]);
				}
				else
				{
					LcdcOutp32(VIDW04ADD0B1, oLcdc.m_uDoubleBufStAddr[4]);
					LcdcOutp32(VIDW04ADD1B1, oLcdc.m_uDoubleBufEndAddr[4]);
				}
*/
			}
		}

		// Set WIN1, WIN2, WIN3, WIN4 alpha Value
		uAlphaRegH =
			(eWin == WIN1) ? VIDOSD1C :
			(eWin == WIN2) ? VIDOSD2C :
			(eWin == WIN3) ? VIDOSD3C : VIDOSD4C;
		uAlpha0RegL = 
			(eWin == WIN1) ? VIDW1ALPHA0 :
			(eWin == WIN2) ? VIDW2ALPHA0 :
			(eWin == WIN3) ? VIDW3ALPHA0 : VIDW4ALPHA0;
		uAlpha1RegL = 
			(eWin == WIN1) ? VIDW1ALPHA1 :
			(eWin == WIN2) ? VIDW2ALPHA1 :
			(eWin == WIN3) ? VIDW3ALPHA1 : VIDW4ALPHA1;
		LcdcOutp32(uAlphaRegH,
			ALPHA0_R_H(0xF) | ALPHA0_G_H(0xF) | ALPHA0_B_H(0xF) |
			ALPHA1_R_H(0xF) | ALPHA1_G_H(0xF) | ALPHA1_B_H(0xF));
		LcdcOutp32(uAlpha0RegL, ALPHA0_R_L(0xF) | ALPHA0_G_L(0xF) | ALPHA0_B_L(0xF));
		LcdcOutp32(uAlpha1RegL, ALPHA1_R_L(0xF) | ALPHA1_G_L(0xF) | ALPHA1_B_L(0xF));
	}

	LcdcOutp32(uWinConXReg, uWinConXRegVal);		

	LcdcOutp32(uFrmBufStAddrReg, oLcdc.m_uFbStAddr[eWin]);
	LcdcOutp32(uFrmBufEndAddrReg, oLcdc.m_uFbEndAddr[eWin]);
	LcdcOutp32(uFrmDBufStAddrReg, oLcdc.m_uDoubleBufStAddr[eWin]);
	LcdcOutp32(uFrmDBufEndAddrReg, oLcdc.m_uDoubleBufEndAddr[eWin]);	
	LcdcOutp32(uFrmTBufStAddrReg, oLcdc.m_uTripleBufStAddr[eWin]);
	LcdcOutp32(uFrmTBufEndAddrReg, oLcdc.m_uTripleBufEndAddr[eWin]);
	LcdcOutp32(uOffsetPageWidthReg, (oLcdc.m_uOffsetSz[eWin]<<13) | oLcdc.m_uPageWidth[eWin]);

	uLcdEndX = oLcdc.m_uLcdStX + oLcdc.m_uViewHSz[eWin] - 1;
	uLcdEndY = oLcdc.m_uLcdStY + oLcdc.m_uViewVSz[eWin] - 1;

	if (oLcdc.m_uScanMode == 1) // Interlace mode
	{
		Assert(!(oLcdc.m_uLcdStX%2)); // Left top Y coordinate must be even number in interlace mode
		Assert(uLcdEndY%2); // Rigth bottom  Y coordinate must be odd number in interlace mode

		// In interlace mode, Left Top Y(oLcdc.m_uLcdStY) and Right Bottom Y(uLcdEndY) must be divided by 2.
		// And, Right Bottom Y must be rounded down
		LcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(oLcdc.m_uLcdStX) | (OSD_LTY_F(oLcdc.m_uLcdStY)>>1));
		LcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uLcdEndX) | (OSD_RBY_F(uLcdEndY)>>1));
	}
	else // Progressive mode
	{
		LcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(oLcdc.m_uLcdStX) | OSD_LTY_F(oLcdc.m_uLcdStY));
		LcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uLcdEndX) | OSD_RBY_F(uLcdEndY));
	}
}


//-------------------------------------------------------------------------
// Function Name : LCDC_SetLocalEn
// Function Description : This function enables / disables LCD Local path
//                                In case of local path disable, ENWIN disable concurrently.
//                                But on the otherhand, Local path enable only enables local path not the ENWIN
// Input : eLocalEn ; LOCAL_DIS (Local path disable)  LOCAL_DIS (Local path enable)
//           eWin ; Target WINDOW
// Output : none
// Version : v0.0
//-------------------------------------------------------------------------
void LCDC_SetLocalEn(LCD_LOCAL_EN eLocalEn, LCD_WINDOW eWin)
{
	u32 uWinConReg;
	u32 uWinConVal;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 : Assert(0) ;

	LcdcInp32(uWinConReg, uWinConVal);
	if (eLocalEn == LOCAL_DIS)
		{
		uWinConVal = (uWinConVal & ~(1<<22)) & ~(0x1);
		}

	else
		{
		uWinConVal = (uWinConVal | (1<<22));
		}
	LcdcOutp32(uWinConReg, uWinConVal);
}




void LCDC_SetWinFrmBfAddr(u32 uFbAddr, LCD_WINDOW eWin,bool bIsDoubleBuf)
{
	u32 uOffset;
	u32 uLineVal;
	u32 uBurstSize;

	u32 uFrmBufStAddrReg;
	u32 uFrmBufEndAddrReg;
	u32 uOffsetPageWidthReg;

	uOffset = oLcdc.m_uFrmHSz[eWin] - oLcdc.m_uViewHSz[eWin];
	
	// Get offsetsize, pagewidth and lineVal
	if (oLcdc.m_uFrmHSz[eWin] >= oLcdc.m_uViewHSz[eWin])
	{
		oLcdc.m_uOffsetSz[eWin] = uOffset*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uPageWidth[eWin] = oLcdc.m_uViewHSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;

		uBurstSize =
			(oLcdc.m_uMaxBurstLen == MAX_BURSTLEN_16WORD) ? 16*4 :
			(oLcdc.m_uMaxBurstLen == MAX_BURSTLEN_8WORD) ? 8*4 : 4*4;

		// Offset size must be more than the burst size
		Assert(oLcdc.m_uOffsetSz[eWin] == 0 || !(oLcdc.m_uOffsetSz[eWin]%4) );
		Assert(oLcdc.m_uPageWidth[eWin] > uBurstSize); // Page width must be more than burst size and be word-aligned
		Assert( !( (oLcdc.m_uPageWidth[eWin]+oLcdc.m_uOffsetSz[eWin])%8 ) );

		uLineVal = oLcdc.m_uViewVSz[eWin] - 1;
	}
	else
	{
		Assert(0);
	}
	
	oLcdc.m_uImgStAddr[eWin] = uFbAddr;

	oLcdc.m_uFbStAddr[eWin] = uFbAddr + (oLcdc.m_uFrmHSz[eWin]*0 + 0)*oLcdc.m_uBytes/oLcdc.m_uBits;
	oLcdc.m_uFbEndAddr[eWin] = oLcdc.m_uFbStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(oLcdc.m_uFrmVSz[eWin]);  // ref.VIDWxxADD1


	if ( bIsDoubleBuf == true )
	{
		oLcdc.m_uDoubleBufImgStAddr[eWin] = oLcdc.m_uImgStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufStAddr[eWin] = oLcdc.m_uFbStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*oLcdc.m_uFrmVSz[eWin]*oLcdc.m_uBytes/oLcdc.m_uBits;
		oLcdc.m_uDoubleBufEndAddr[eWin] = oLcdc.m_uDoubleBufStAddr[eWin] + (oLcdc.m_uOffsetSz[eWin]+oLcdc.m_uPageWidth[eWin])*(oLcdc.m_uFrmVSz[eWin]);
	}
	else if ( bIsDoubleBuf == false )
	{
		oLcdc.m_uDoubleBufStAddr[eWin] = oLcdc.m_uFbStAddr[eWin];
		oLcdc.m_uDoubleBufEndAddr[eWin] = oLcdc.m_uFbEndAddr[eWin];
	}

	uFrmBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0:
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	uFrmBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B0 :
		(eWin == WIN1) ? VIDW01ADD1B0 :
		(eWin == WIN2) ? VIDW02ADD1B0 :
		(eWin == WIN3) ? VIDW03ADD1B0 : VIDW04ADD1B0;

	uOffsetPageWidthReg =
		(eWin == WIN0) ? VIDW00ADD2 :
		(eWin == WIN1) ? VIDW01ADD2 :
		(eWin == WIN2) ? VIDW02ADD2 :
		(eWin == WIN3) ? VIDW03ADD2 : VIDW04ADD2;

	LcdcOutp32(uFrmBufStAddrReg, oLcdc.m_uFbStAddr[eWin]);
	LcdcOutp32(uFrmBufEndAddrReg, oLcdc.m_uFbEndAddr[eWin]);
	LcdcOutp32(uOffsetPageWidthReg, (oLcdc.m_uOffsetSz[eWin]<<13) | oLcdc.m_uPageWidth[eWin]);


}




//--------------------------------------------------------------------------
// Function Name : LCDC_SetWinShadowP
// Function Description : This function set Window Shadow Register protect or unprotect
// Input : eWin ; WIN0~ WIN4 & ALLWIN          eEn ; 1: Protect    0 : unprotect
// Output : none
// Version : v0.0
//--------------------------------------------------------------------------
void LCDC_SetWinShadowP(LCD_WINDOW eWin, u32 eEn)
{
	u32 uTmpReg;

	LcdcInp32(SHADOWCON,uTmpReg);

	if(eEn == 1)
	{
		if(eWin == ALLWIN)
		{
		uTmpReg = (0x7c00);
		}
		else
		{
		uTmpReg = (uTmpReg & ~(0x400<<eWin)) | (0x400<<eWin) ;	
		}
	}
	else
	{
		if(eWin == ALLWIN)
		{
		uTmpReg = 0x0;
		}
		else
		{
		uTmpReg = uTmpReg & ~(0x400<<eWin);
		}
	}

	LcdcOutp32(SHADOWCON,uTmpReg);

}


// Window 0~4 Setting
void LCDC_SetAlpha(u32 uA0R, u32 uA0G, u32 uA0B, u32 uA1R, u32 uA1G, u32 uA1B, LCD_WINDOW eWin)
{
	u32 uWin0A0RVal;
	u32 uWin0A0GVal;
	u32 uWin0A0BVal;
	u32 uWin0A1RVal;
	u32 uWin0A1GVal;
	u32 uWin0A1BVal;
	u32 uA0RLVal, uA0RHVal;
	u32 uA0GLVal, uA0GHVal;
	u32 uA0BLVal, uA0BHVal;
	u32 uA1RLVal, uA1RHVal;
	u32 uA1GLVal, uA1GHVal;
	u32 uA1BLVal, uA1BHVal;
	u32 uAlphaRegH, uAlpha0RegL;
	u32 uAlpha1RegL; 
	
	// WIN0 alpha
	if(eWin == WIN0)
	{
		uWin0A0RVal = uA0R & 0xff;
		uWin0A0GVal = uA0G & 0xff;
		uWin0A0BVal = uA0B & 0xff;
		uWin0A1RVal = uA1R & 0xff;
		uWin0A1GVal = uA1G & 0xff;
		uWin0A1BVal = uA1B & 0xff;
		LcdcOutp32(VIDW0ALPHA0, ALPHA0_R(uWin0A0RVal) | ALPHA0_G(uWin0A0GVal) | ALPHA0_B(uWin0A0BVal));
		LcdcOutp32(VIDW0ALPHA1, ALPHA1_R(uWin0A1RVal) | ALPHA1_G(uWin0A1GVal) | ALPHA1_B(uWin0A1BVal));
	}
	// WIN1 or WIN2 or WIN3 or WIN4 alpha
	else//((eWin==WIN1)||(eWin==WIN2)||(eWin==WIN3)||(eWin==WIN4))
	{
		uA0RLVal = uA0R & 0x0f;
		uA0RHVal = ((uA0R & 0xf0)>>4) & 0xf;		
		uA0GLVal = uA0G & 0x0f;
		uA0GHVal = ((uA0G & 0xf0)>>4) & 0xf;
		uA0BLVal = uA0B & 0x0f;
		uA0BHVal = ((uA0B & 0xf0)>>4) & 0xf;		
		uA1RLVal = uA1R & 0x0f;
		uA1RHVal = ((uA1R & 0xf0)>>4) & 0xf;		
		uA1GLVal = uA1G & 0x0f;
		uA1GHVal = ((uA1G & 0xf0)>>4) & 0xf;		
		uA1BLVal = uA1B & 0x0f;
		uA1BHVal = ((uA1B & 0xf0)>>4) & 0xf;

		uAlphaRegH =
			(eWin == WIN1) ? VIDOSD1C :
			(eWin == WIN2) ? VIDOSD2C :
			(eWin == WIN3) ? VIDOSD3C : VIDOSD4C;
		LcdcOutp32(uAlphaRegH,
			ALPHA0_R_H(uA0RHVal) | ALPHA0_G_H(uA0GHVal) | ALPHA0_B_H(uA0BHVal) |
			ALPHA1_R_H(uA1RHVal) | ALPHA1_G_H(uA1GHVal) | ALPHA1_B_H(uA1BHVal));

		uAlpha0RegL = 
			(eWin == WIN1) ? VIDW1ALPHA0 :
			(eWin == WIN2) ? VIDW2ALPHA0 :
			(eWin == WIN3) ? VIDW3ALPHA0 : VIDW4ALPHA0;
		LcdcOutp32(uAlpha0RegL, ALPHA0_R_L(uA0RLVal) | ALPHA0_G_L(uA0GLVal) | ALPHA0_B_L(uA0BLVal));
			
		uAlpha1RegL= 
			(eWin == WIN1) ? VIDW1ALPHA1 :
			(eWin == WIN2) ? VIDW2ALPHA1 :
			(eWin == WIN3) ? VIDW3ALPHA1 : VIDW4ALPHA1;
		LcdcOutp32(uAlpha1RegL, ALPHA1_R_L(uA1RLVal) | ALPHA1_G_L(uA1GLVal) | ALPHA1_B_L(uA1BLVal));
	}

}

void LCDC_SetAlphaClear(LCD_WINDOW eWin)
{
	LCDC_SetAlpha(0, 0, 0, 0, 0, 0, eWin);
}

void LCDC_SetAlphaValWidth(ALPHA_WIDTH eAlphaValWidth)
{
	if(eAlphaValWidth == ALPHA_4BIT)
	{
		LcdcOutp32(BLENDCON, 0x0);
	}
	else // (eAlphaValWidth == ALPHA_8BIT)
	{
		LcdcOutp32(BLENDCON, 0x1);
	}
}


//---------------------------------------------------------
// Function Name : LCDC_SetWinOnOff
// Function Description : This function turns Window On or Off
// Input : uOnOff : 0 = window off     1 = window on
//            eWin : WIN0~4 : Windows0 ~ Windows4 which to turn on or off
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetWinOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uWinTemp;
	u32 uWinConReg;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	LcdcInp32(uWinConReg, uWinTemp);

	if (uOnOff) // Turn OSD on
	{
		uWinTemp |= ENWIN_F_ENABLE;
	}
	else // Turn OSD off
	{
		uWinTemp &= ~ENWIN_F_ENABLE;
	}

	LcdcOutp32(uWinConReg, uWinTemp);

}

void LCDC_SetAllWinOnOff(u32 uOnOff)
{
	u32 uWinTemp[5];


	LcdcInp32(WINCON0, uWinTemp[0]);
	LcdcInp32(WINCON1, uWinTemp[1]);
	LcdcInp32(WINCON2, uWinTemp[2]);
	LcdcInp32(WINCON3, uWinTemp[3]);
	LcdcInp32(WINCON4, uWinTemp[4]);


	if (uOnOff)
	{
		LcdcOutp32(WINCON0, uWinTemp[0]|ENWIN_F_ENABLE);
		LcdcOutp32(WINCON1, uWinTemp[1]|ENWIN_F_ENABLE);
		LcdcOutp32(WINCON2, uWinTemp[2]|ENWIN_F_ENABLE);
		LcdcOutp32(WINCON3, uWinTemp[3]|ENWIN_F_ENABLE);
		LcdcOutp32(WINCON4, uWinTemp[4]|ENWIN_F_ENABLE);
	}
	else
	{
		LcdcOutp32(WINCON0, uWinTemp[0]&~ENWIN_F_ENABLE);
		LcdcOutp32(WINCON1, uWinTemp[1]&~ENWIN_F_ENABLE);
		LcdcOutp32(WINCON2, uWinTemp[2]&~ENWIN_F_ENABLE);
		LcdcOutp32(WINCON3, uWinTemp[3]&~ENWIN_F_ENABLE);
		LcdcOutp32(WINCON4, uWinTemp[4]&~ENWIN_F_ENABLE);
	}
}

// Set the View-Port's position of LCD
void LCDC_SetViewPosOnLcd(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin) // For WIN0~4,
{
	u32 uDiv;
	u32 uX_Lcd1, uX_Lcd2, uY_Lcd2;
	u32 uTempLeftReg, uTempRightReg;

	Assert(eWin != WIN0);

	uDiv = oLcdc.m_uBytes/oLcdc.m_uBits;

	uTempLeftReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;


	uTempRightReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	if ((uX_Lcd+oLcdc.m_uViewHSz[eWin] < oLcdc.m_uLcdHSz+1) && (uY_Lcd+oLcdc.m_uViewVSz[eWin] < oLcdc.m_uLcdVSz+1))
	{
		uX_Lcd1 = (uX_Lcd/uDiv)*uDiv;

		uX_Lcd2 = uX_Lcd1 + oLcdc.m_uViewHSz[eWin] - 1;
		uY_Lcd2 = uY_Lcd + oLcdc.m_uViewVSz[eWin] - 1;

		LcdcOutp32( uTempLeftReg, OSD_LTX_F(uX_Lcd1) | OSD_LTY_F(uY_Lcd) );
		LcdcOutp32( uTempRightReg,OSD_RBX_F(uX_Lcd2) | OSD_RBY_F(uY_Lcd2) );
	}
}

//--------------------------------------------------------------------------
// ****  CAUTION : This API is only for test Shadow Protect function  ****
// Function Name : LCDC_SetViewPosOnLcddelay
// Function Description : This function set Windows OSD position with delay between left top and right bottom
// Input : eWin ; WIN0~ WIN4 & ALLWIN          eEn ; 1: Protect    0 : unprotect
// Output : none
// Version : v0.0
//--------------------------------------------------------------------------
void LCDC_SetViewPosOnLcddelay(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin) // For WIN0~4,
{
	u32 uDiv;
	u32 uX_Lcd1, uX_Lcd2, uY_Lcd2;
	u32 uTempLeftReg, uTempRightReg;

	Assert(eWin != WIN0);

	uDiv = oLcdc.m_uBytes/oLcdc.m_uBits;

	uTempLeftReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;


	uTempRightReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	if ((uX_Lcd+oLcdc.m_uViewHSz[eWin] < oLcdc.m_uLcdHSz+1) && (uY_Lcd+oLcdc.m_uViewVSz[eWin] < oLcdc.m_uLcdVSz+1))
	{
		uX_Lcd1 = (uX_Lcd/uDiv)*uDiv;

		uX_Lcd2 = uX_Lcd1 + oLcdc.m_uViewHSz[eWin] - 1;
		uY_Lcd2 = uY_Lcd + oLcdc.m_uViewVSz[eWin] - 1;

		LcdcOutp32( uTempLeftReg, OSD_LTX_F(uX_Lcd1) | OSD_LTY_F(uY_Lcd) );
		Delay(10000);
		LcdcOutp32( uTempRightReg,OSD_RBX_F(uX_Lcd2) | OSD_RBY_F(uY_Lcd2) );
	}
}




// Set the View-Port's position of Frame
void LCDC_SetViewPosOnFrame(u32 uX_Frame, u32 uY_Frame, LCD_WINDOW eWin) // For WIN0~4
{
	u32 uFbStAddrReg;

	uFbStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0 :
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	if ( (uX_Frame < oLcdc.m_uFrmHSz[eWin] - oLcdc.m_uLcdHSz + 1) && (uY_Frame < oLcdc.m_uFrmVSz[eWin] - oLcdc.m_uLcdVSz + 1) )
	{
		LcdcOutp32(uFbStAddrReg,
			oLcdc.m_uFbStAddr[eWin] + oLcdc.m_uFrmHSz[eWin]*uY_Frame*(oLcdc.m_uBytes/oLcdc.m_uBits) + uX_Frame*(oLcdc.m_uBytes/oLcdc.m_uBits));

		if (eWin == WIN0)
		{
			LcdcOutp32(VIDW00ADD0B1,
					oLcdc.m_uDoubleBufStAddr[0] + oLcdc.m_uFrmHSz[eWin]*uY_Frame*(oLcdc.m_uBytes/oLcdc.m_uBits) + uX_Frame*(oLcdc.m_uBytes/oLcdc.m_uBits));
		}
	}
}


//---------------------------------------------------------
// Function Name : LCDC_SetFreeRun
// Function Description : This function set Freerun mode of VIDCON0
// Input : uFreeEn ; 1 : Freerun Enable      0 : Freerun Disable(Normal)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetFreeRun(u32 uFreeEn)
{
	u32 uVidConReg;

	LcdcInp32(VIDCON0, uVidConReg);
	

	if(uFreeEn == 1)
	{
	LcdcOutp32(VIDCON0, uVidConReg & ~(VCLKFREE_FREERUN) | VCLKFREE_FREERUN);
	}
	else
	{
	LcdcOutp32(VIDCON0, uVidConReg & ~(VCLKFREE_FREERUN) | VCLKFREE_NORMAL);
	}


}

//---------------------------------------------------------
// Function Name : LCDC_SetRGBSkip
// Function Description : This function set RGBSkip mode of VIDCON2
// Input : uRGBskipEn ; 1 : RGB skip mode Enable      0 : RGB skip mode Disable(Normal)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetRGBSkip(RGBSKIP_EN eRGBskipEn)
{
	u32 uVidConReg;

	LcdcInp32(VIDCON2, uVidConReg);
	

	if(eRGBskipEn == SKIP_EN)
	{
	LcdcOutp32(VIDCON2, uVidConReg & ~(RGB_SKIP_ENABLE) | RGB_SKIP_ENABLE);
	}
	else
	{
	LcdcOutp32(VIDCON2, uVidConReg & ~(RGB_SKIP_ENABLE) | RGB_SKIP_DISABLE);
	}


}

//---------------------------------------------------------
// Function Name : LCDC_SetRGBdummy
// Function Description : This function set RGBdummy insertion mode of VIDCON2
// Input : uDummyEn ; 1 : uDummy Insertion Enable      0 : Dummy Insertion Disable(Normal)
//         uPosition; 1 : 1st position                 0 : last(4th) position
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetRGBdummy(DUMMY_POSITION ePosition, RGBDUMMY_EN eDummyEn)
{
	u32 uVidConReg0,uVidConReg2;

	LcdcInp32(VIDCON0, uVidConReg0);
	LcdcInp32(VIDCON2, uVidConReg2);
	

	if(eDummyEn == DUMMY_EN)
	{
	LcdcOutp32(VIDCON0, uVidConReg0 & ~(RGBSPSEL_SERIAL) | RGBSPSEL_SERIAL);
	
		if(ePosition == DUMMY_FIRST)
		LcdcOutp32(VIDCON2, uVidConReg2 & ~(0x3000000) |RGB_DUMMY_FIRST | RGB_DUMMY_ENABLE);
		else
		LcdcOutp32(VIDCON2, uVidConReg2 & ~(0x3000000) |RGB_DUMMY_LAST | RGB_DUMMY_ENABLE);		
	}
	else
	{
	LcdcOutp32(VIDCON2, uVidConReg2 & ~(0x3000000) | RGB_DUMMY_DISABLE);
	}

}



// if uWhichAddr is 0, then Buffer 0 is selected
// else then Buffer 1 is selected

void LCDC_GetDoubleBufAddr(u32* uFbAddr, u32 uWhichAddr, LCD_WINDOW eWin)
{
//	Assert (eWin == WIN0 || eWin == WIN1);
	Assert( oLcdc.m_uFbStAddr[eWin] != oLcdc.m_uDoubleBufStAddr[eWin]);
	Assert( uWhichAddr >= 0 && uWhichAddr <= 2);

	if(uWhichAddr==0)
		*uFbAddr = oLcdc.m_uImgStAddr[eWin];
	else if(uWhichAddr==1)
		*uFbAddr = oLcdc.m_uDoubleBufImgStAddr[eWin];
	else if(uWhichAddr==2)
		*uFbAddr = oLcdc.m_uTripleBufImgStAddr[eWin];
	else
		Assert(0);
}

void LCDC_GetBufIdx(u32* uBufNum, LCD_WINDOW eWin)
{
	u32 uWinCtrlReg, uWinCtrlVal;
	u32 uTmpVal;

//	Assert (eWin == WIN0 || eWin == WIN1);

	uWinCtrlReg = (eWin == WIN0) ? WINCON0 :
		        (eWin == WIN1) ? WINCON1 :
				(eWin == WIN2) ? WINCON2 :
				(eWin == WIN3) ? WINCON3 : WINCON4 ;

	LcdcInp32(uWinCtrlReg, uWinCtrlVal);
	uTmpVal = (((uWinCtrlVal>>31)&0x1)<<1) | ((uWinCtrlVal>>21)&0x1);
	*uBufNum = uTmpVal;
}

void LCDC_GetClkValAndClkDir(u32 uLcdHSz, u32 uLcdVSz, u32* uClkVal, u32* uClkDir)
{
	double dTmpVal;
	u32 uTmpClkVal;
	u32 uTotalTime;
	u32 uLCD_VCLK;
	double dFrmRate;
	u32 uClkDiv,uClkSelReg;
	u32 uFrameRate = LCD_FRM_RATE;
	
	uLcdHSz+= gMODULE_HBPD +gMODULE_HFPD +gMODULE_HSPW +3;
	uLcdVSz+= gMODULE_VBPD +gMODULE_VFPD +gMODULE_VSPW +3;


    if (gLCDM_INTERFACE_TYPE == I80_CPU) 
	uTotalTime = WR_ACT_TIME + WR_HOLD_TIME;
	else
	uTotalTime = 1;


	if(LCD_VCLKSRC == LCD_HCLK)
	{
		uClkSelReg = (u32)LCD_eHCLK ;
		uClkDiv = 1;
	}
	else
	{
		uClkDiv = SYSC_GetClkDiv(eCLKDIV_FIMD);
		uClkSelReg = SYSC_GetClkMuxReg(1);
		uClkSelReg = (uClkSelReg >>20) & 0xf ;
	}

		uLCD_VCLK =
		(uClkSelReg == (u32)LCD_eHCLK) ?		g_uHclkDsys :
		(uClkSelReg == (u32)LCD_eXXTI) ? 	FIN / uClkDiv	:
		(uClkSelReg == (u32)LCD_eXusbXTI) ? 	FIN	/ uClkDiv	:
		(uClkSelReg == (u32)LCD_eMPLL) ? 	g_uMPLL / uClkDiv :
		(uClkSelReg == (u32)LCD_eEPLL) ? 	g_uEPLL	 / uClkDiv	:
		(uClkSelReg == (u32)LCD_eVPLL) ? 	g_uVPLL	 / uClkDiv	: Assert(0);

/*	
	if(LCD_VCLKSRC == LCD_HCLK)
	{
		uLCD_VCLK = g_uHclkDsys ;
	}
	else if(LCD_VCLKSRC == LCD_MPLL)
	{
		uLCD_VCLK = g_uMPLL / 4;		// need to be defined later (09.07.14 by WJ.KIM)
	}
*/

#ifdef DBG_LCDC

	switch(uClkSelReg)
	{
		case LCD_eHCLK: Disp("LCD VCLK Source is HCLK "); break;
		case LCD_eXXTI: Disp("LCD VCLK Source is XXIT "); break;
		case LCD_eXusbXTI: Disp("LCD VCLK Source is XusbXTI "); break;
		case LCD_eMPLL: Disp("LCD VCLK Source is MPLL "); break;
		case LCD_eEPLL: Disp("LCD VCLK Source is EPLL "); break;
		case LCD_eVPLL: Disp("LCD VCLK Source is VPLL "); break;
		default:Disp("??? ");
	}

	Disp("with %3.3fMHz\n",(double)uLCD_VCLK/1000000);
	Disp("Output VCLK need to be %3.3fMHz\n",(double)(uTotalTime*uLcdHSz*uLcdVSz*uFrameRate)/1000000);
#endif

	dTmpVal = (double)(uLCD_VCLK)/(uTotalTime*uLcdHSz*uLcdVSz*uFrameRate) - 1;

	*uClkVal = (int)(dTmpVal+0.5);
	*uClkDir = (*uClkVal<1) ? 0 : 1;
	uTmpClkVal = *uClkVal;
	
#ifdef DBG_LCDC
	dFrmRate = (double)((u32)(uLCD_VCLK))/((uTmpClkVal+1)*uLcdHSz*uLcdVSz);
	Dbg("Frame Rate: %f\t ClkVal: %d\n", dFrmRate, (int)dTmpVal);
#endif

}

//---------------------------------------------------------
// Function Name :LCDC_WTrigger
// Function Description : This function changes(triggers) windows' frame buffer
// Input : eWin ; WINDOW number to trigger
// Output : none
// Version :v0.1
//---------------------------------------------------------
void LCDC_WTrigger(LCD_WINDOW eWin)
{
	u32 uTrigCtrl;
	
	LcdcInp32(TRIGCON, uTrigCtrl);
	
	if (oLcdc.m_bAutoBuf != LCDC_BUF_SINGLE)
	{
		switch(eWin)
			{
			case WIN0 :
				LcdcOutp32(TRIGCON, uTrigCtrl | W0_SW_TRIG_MODE | W0_SW_TRIGGER);				
				break;

			case WIN1 :
				LcdcOutp32(TRIGCON, uTrigCtrl | W1_SW_TRIG_MODE | W1_SW_TRIGGER);				
				break;

			case WIN2 :
				LcdcOutp32(TRIGCON, uTrigCtrl | W2_SW_TRIG_MODE | W2_SW_TRIGGER);				
				break;

			case WIN3 :
				LcdcOutp32(TRIGCON, uTrigCtrl | W3_SW_TRIG_MODE | W3_SW_TRIGGER);				
				break;

			case WIN4 :
				LcdcOutp32(TRIGCON, uTrigCtrl | W4_SW_TRIG_MODE | W4_SW_TRIGGER);				
				break;

			}

	}
	
	else
	{
#if ((LCD_MODEL == LCD_LTS222Q_CPU) ||  (LCD_MODEL == LCD_MIPIModule) || (LCD_MODEL == LCD_UF24U276A))
		LcdcOutp32(TRIGCON, uTrigCtrl | I80_SW_TRIG_MODE | I80_SW_TRIGGER);
#endif
	}
	
}


// CPU Interface
void LCDC_Trigger(void)
{
	u32 uTrigCtrl;
	
	LcdcInp32(TRIGCON, uTrigCtrl);
	
	if (oLcdc.m_bAutoBuf != LCDC_BUF_SINGLE)
	{
		LcdcOutp32(TRIGCON, uTrigCtrl | SW_TRIG_MODE | SW_TRIGGER);
	}
	else
	{
#if ((LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_S6D0139_CPU) || (LCD_MODEL == LCD_MIPIModule) || (LCD_MODEL == LCD_UF24U276A))
		LcdcOutp32(TRIGCON, uTrigCtrl | SW_TRIG_MODE | SW_TRIGGER);
#endif
	}
}


// if uScanMode is 0, progressive mode
// else interlace mode
void LCDC_SetScanMode(SCAN_MODE eScanMode)
{
	u32 uVidConRegVal;

	oLcdc.m_uScanMode = (eScanMode == PROGRESSIVE) ? 0 : 1;

	LcdcInp32(VIDCON0, uVidConRegVal);
	uVidConRegVal &= ~(1<<29);
	LcdcOutp32(VIDCON0, (uVidConRegVal | oLcdc.m_uScanMode<<29));
}

void LCDC_SetOutputPath(LCD_LOCAL_OUTPUT eOutLocal)
{
	u32 uVidConRegVal;
	u32 uPathVal;
	u32 uTmpReg;
	
	// if output mode is LCD mode, Scan mode always should be progressive mode
	if (eOutLocal == LCD_TV||eOutLocal == LCD_TVRGB)
	{
	LcdcInp32(VIDCON2,uTmpReg);
	uTmpReg = uTmpReg | WRITEBACK_ENABLE | TVFORMATSEL0_SW | TVFORMATSEL1_YUV444 ;
	LcdcOutp32(VIDCON2,uTmpReg);
	}
	
	else if(eOutLocal == LCD_MDNIE)
	{
	LcdcInp32(VIDCON2,uTmpReg);
	uTmpReg = uTmpReg | TVFORMATSEL0_SW | TVFORMATSEL1_YUV444 ;
	LcdcOutp32(VIDCON2,uTmpReg);
	}

	else
		
	{
	LcdcInp32(VIDCON2,uTmpReg);
//	uTmpReg = uTmpReg & ~(WRITEBACK_ENABLE);
	uTmpReg = uTmpReg & (WRITEBACK_ENABLE);
	LcdcOutp32(VIDCON2,uTmpReg);
	
	LCDC_SetScanMode(PROGRESSIVE);
	}

	uPathVal = 
		(eOutLocal == LCD_RGB) ? VIDOUT_RGBIF :
		(eOutLocal == LCD_TV) ? VIDOUT_TV :			
		(eOutLocal == LCD_I80F) ? VIDOUT_I80IF0 :
		(eOutLocal == LCD_I80S) ? VIDOUT_I80IF1 :
		(eOutLocal == LCD_TVRGB) ? VIDOUT_TVNRGBIF :
		(eOutLocal == LCD_MDNIE) ? VIDOUT_TVNRGBIF : 		//MDNIE use TV & RGB path
		(eOutLocal == LCD_TVI80F) ? VIDOUT_TVNI80IF0 : VIDOUT_TVNI80IF1;

	LcdcInp32(VIDCON0, uVidConRegVal);
	uVidConRegVal &= ~(0x7<<26); // masking [28:26]
	uVidConRegVal |= uPathVal;
	LcdcOutp32(VIDCON0, uVidConRegVal);
//	LCDC_SetClkVal(0);
}

void LCDC_SetWBFrameSkip(LCD_WB_SKIP eSkip)
{
	u32 uVidConVal;

	LcdcInp32(VIDCON2,uVidConVal);

	uVidConVal = (uVidConVal & ~(0x1f)) | (u32)eSkip;

	LcdcOutp32(VIDCON2, uVidConVal);
}


void LCDC_SetDualDisplay(LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual,LCD_DUAL_VDEN_EN eSelVden)
{
	u32 uDualSelReg;
	u32 uDualSel;
	u32 uHorVerSel;
	u32 uDualCount;
	u32 uVdenEn;


	if(eSelMethod == FRAME_SPLIT)
		{
	uDualCount = gLCDM_VSIZE;
	uHorVerSel = DUAL_FRAMESPLIT;
		}
	else
		{
	uDualCount = gLCDM_HSIZE;
	uHorVerSel = DUAL_LINESPLIT;
		}

/*
#if (LCD_MODEL == LCD_LTV350QV_RGB)
	if(eSelMethod == FRAME_SPLIT)
		{
	uDualCount = 240;
	uHorVerSel = DUAL_FRAMESPLIT;
		}
	else
		{
	uDualCount = 320;
	uHorVerSel = DUAL_LINESPLIT;

		}
//	oLcdc.m_uLcdHSz = 320;
//	oLcdc.m_uLcdVSz = 240;

#elif (( LCD_MODEL == LCD_LTS350Q1 )|| (LCD_MODEL == LCD_LTS222Q_CPU) || (LCD_MODEL == LCD_LTS222Q_RGB) || (LCD_MODEL == LCD_LTS222Q_SRGB))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
	

//	oLcdc.m_uLcdHSz = 240;
//	oLcdc.m_uLcdVSz = 320;
	
//	oLcdc.m_uLcdHSz = 320;
//	oLcdc.m_uLcdVSz = 480;

#elif ((LCD_MODEL == LCD_LTE480WV_RGB)||(LCD_MODEL == LCD_LTP700WV_RGB ))
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 480;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 800;
		uHorVerSel = DUAL_LINESPLIT;
	}

//	oLcdc.m_uLcdHSz = 800;
//	oLcdc.m_uLcdVSz = 480;



#elif (LCD_MODEL == LCD_LTM030DK)
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}

#elif (LCD_MODEL == LCD_TL2796)
	
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}

#elif (LCD_MODEL == LCD_LMS280GS01)

	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
	

#elif (LCD_MODEL == LCD_S6E63M0)

	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}
//	oLcdc.m_uLcdHSz = 480;
//	oLcdc.m_uLcdVSz = 800;

#else
	Assert(0);
#endif
*/

	uDualSel = 
		( eSelDual == FIMD_SINGLE ) ? DUAL_DIS :
		( eSelDual == FIMD_DUAL )	? DUAL_FIMD :
		( eSelDual == MIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MIE_DUAL )	? DUAL_MIE :
		( eSelDual == MDNIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MDNIE_DUAL )? DUAL_MDNIE :
			Assert(0);


	uVdenEn =
		( eSelVden == VDEN_DIS) ? DUAL_VDEN_DIS :
		( eSelVden == VDEN_EN) ? DUAL_VDEN_EN :
			Assert(0);					

	LcdcInp32(DUALCON,uDualSelReg);
/*
	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUALCOUNT(uDualCount) | (0x1<<3) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}
*/

	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUAL_MAINCOUNT(uDualCount +2)|uVdenEn|DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |uVdenEn| DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}

	LcdcOutp32(DUALCON,uDualSelReg);
	
}



void LCDC_SetDualDisplaySel(u32 uLCDmodel,LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual,LCD_DUAL_VDEN_EN eSelVden)
{
	u32 uDualSelReg;
	u32 uDualSel;
	u32 uHorVerSel;
	u32 uDualCount;
	u32 uVdenEn;


if (uLCDmodel == LCD_LTV350QV_RGB)
{
	if(eSelMethod == FRAME_SPLIT)
		{
	uDualCount = 240;
	uHorVerSel = DUAL_FRAMESPLIT;
		}
	else
		{
	uDualCount = 320;
	uHorVerSel = DUAL_LINESPLIT;

		}

}
else if (( uLCDmodel == LCD_LTS350Q1 )|| (uLCDmodel == LCD_LTS222Q_CPU) || (uLCDmodel == LCD_LTS222Q_RGB) || (uLCDmodel == LCD_LTS222Q_SRGB))
{
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
}	

else if ((uLCDmodel == LCD_LTE480WV_RGB)||(uLCDmodel == LCD_LTP700WV_RGB ))
{
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 480;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 800;
		uHorVerSel = DUAL_LINESPLIT;
	}

}


else if (uLCDmodel == LCD_LTM030DK)
{
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}
}
else if (uLCDmodel == LCD_TL2796)
{
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 800;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 480;
		uHorVerSel = DUAL_LINESPLIT;
	}
}
else if (uLCDmodel == LCD_LMS280GS01)
{
	if(eSelMethod == FRAME_SPLIT)
	{
		uDualCount = 320;
		uHorVerSel = DUAL_FRAMESPLIT;
	}
	else
	{
		uDualCount = 240;
		uHorVerSel = DUAL_LINESPLIT;
	}
	
}

else
	Assert(0);


	uDualSel = 
		( eSelDual == FIMD_SINGLE ) ? DUAL_DIS :
		( eSelDual == FIMD_DUAL )	? DUAL_FIMD :
		( eSelDual == MIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MIE_DUAL )	? DUAL_MIE :
		( eSelDual == MDNIE_SINGLE )? DUAL_MDNIE :
		( eSelDual == MDNIE_DUAL )? DUAL_MDNIE :
			Assert(0);


	uVdenEn =
		( eSelVden == VDEN_DIS) ? DUAL_VDEN_DIS :
		( eSelVden == VDEN_EN) ? DUAL_VDEN_EN :
			Assert(0);					

	LcdcInp32(DUALCON,uDualSelReg);
/*
	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUALCOUNT(uDualCount) | (0x1<<3) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}
*/
	if(eSelMethod == FRAME_SPLIT)
	{
	uDualSelReg = (uDualSelReg & ~(0x1FFF)) |DUAL_MAINCOUNT(uDualCount +2)|uVdenEn|DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;
//	uDualSelReg = uDualSelReg & ~(0x1FFF) |DUALCOUNT(uDualCount) | uHorVerSel | uDualSel ;
	}
	else
	{
	uDualSelReg = uDualSelReg & ~(0x1FFF) |uVdenEn| DUAL_SUBCOUNT(uDualCount) | uHorVerSel | uDualSel ;		
	}

	LcdcOutp32(DUALCON,uDualSelReg);
	
}





void LCDC_SetClkVal(u8 uClkVal)
{
	u32 uVidConRegVal;

	uClkVal &= 0xff;

	LcdcInp32(VIDCON0, uVidConRegVal);
	if ( uClkVal > 0 )
	{
		uVidConRegVal &= ~(0x1<<4);
		LcdcOutp32(VIDCON0, uVidConRegVal | (1<<4));
	}
	else if ( uClkVal == 0 )
	{
		uVidConRegVal &= ~(0x1<<4);
		LcdcOutp32(VIDCON0, uVidConRegVal | (0<<4));
	}

	LcdcInp32(VIDCON0, uVidConRegVal);
	LcdcOutp32(VIDCON0, uVidConRegVal & ~(0xff<<6) | (uClkVal<<6));
}
/*
void LCDC_SetClkSrc(CLK_SRC eClkSrc)
{
	u32 uVidConVal;
	u32 uClkSrc;

	uClkSrc =
		(eClkSrc == HCLK_SRC) ? CLKSEL_F_HCLK :
		(eClkSrc == ECLK1_SRC) ? CLKSEL_F_EXTCLK0 : CLKSEL_F_EXTCLK1;

	LcdcInp32(VIDCON0, uVidConVal);

	uVidConVal &= ~(0x3<<2);
	uVidConVal |= uClkSrc;

	LcdcOutp32(VIDCON0, uVidConVal);
}
*/
void LCDC_SetPaletteData(u32 uIdx, u32 uPalData, LCD_WINDOW eWin)
{
	u32 uRegAddr;
	
	Assert(uIdx < 256);
	
	uRegAddr = 
		(eWin == WIN0) ? W0PRAMSTART + ((uIdx)*4) :
		(eWin == WIN1) ? W1PRAMSTART + ((uIdx)*4) :
		(eWin == WIN2) ? W2PRAMSTART + ((uIdx)*4) :
		(eWin == WIN3) ? W3PRAMSTART + ((uIdx)*4) :
		(eWin == WIN4) ? W4PRAMSTART + ((uIdx)*4) :
			Assert(0);

	LcdcOutp32(uRegAddr, uPalData);
}

// Set data format for palette
// WPALCON = {WPALCON_H,WPALCON_L}
void LCDC_SetPaletteCtrl(IMG_FMT eBpp, LCD_WINDOW eWin)
{
	u32 uPalDataFormat_L;
	u32 uPalConVal_L;
	u32 uPalDataFormat_H;
	u32 uPalConVal_H;

	if((eWin == WIN0)||(eWin == WIN1))
	{
		uPalDataFormat_L=0x0, uPalConVal_L=0x0;

		uPalDataFormat_L =
			(eBpp == ARGB1888) ? 		0x0 :
			(eBpp == RGB888) ? 			0x1 :
			(eBpp == ARGB1666) ? 		0x2 :
			(eBpp == ARGB1665) ? 		0x3 :				
			(eBpp == RGB666) ? 			0x4 :				
			(eBpp == ARGB1555) ? 		0x5 :
			(eBpp == RGB565) ? 			0x6 :
			(eBpp == ARGB8888) ? 		0x7 :	0xf;
		if(uPalDataFormat_L == 0xf)
			Assert(0);

		LcdcInp32(WPALCON_L, uPalConVal_L);		
		if(eWin == WIN0)
		{
			LcdcOutp32(WPALCON_L, ((uPalConVal_L & ~(0x7)) | (uPalDataFormat_L<<0)));
		}
		else //(eWin == WIN1)
		{
			LcdcOutp32(WPALCON_L, ((uPalConVal_L & ~(0x38)) | (uPalDataFormat_L<<3)));
		}

//		LcdcOutp32(WPALCON_L, uPalDataFormat_L);
	}
	else //((eWin == WIN2)||(eWin == WIN3)||(eWin == WIN4))
	{
		uPalDataFormat_H=0x0, uPalConVal_H=0x0;
		uPalDataFormat_L=0x0, uPalConVal_L=0x0;


		uPalDataFormat_L =
			(eBpp == RGB565) ? 		0x0 :
			(eBpp == ARGB1555) ? 	0x1 :
			(eBpp == RGB666) ? 		0x0 :
			(eBpp == ARGB1665) ? 	0x1 :				
			(eBpp == ARGB1666) ? 	0x0 :				
			(eBpp == RGB888) ? 		0x1 :
			(eBpp == ARGB1888) ? 	0x0 :
			(eBpp == ARGB8888) ? 	0x1 :	0xf;
		if(uPalDataFormat_L == 0xf)
			Assert(0);

		uPalDataFormat_H =
			(eBpp == RGB565) ? 		0x0 :
			(eBpp == ARGB1555) ? 	0x0 :
			(eBpp == RGB666) ? 		0x1 :
			(eBpp == ARGB1665) ? 	0x1 :				
			(eBpp == ARGB1666) ? 	0x2 :				
			(eBpp == RGB888) ? 		0x2 :
			(eBpp == ARGB1888) ? 	0x3 :
			(eBpp == ARGB8888) ? 	0x3 :	0xf;
		if(uPalDataFormat_H == 0xf)
			Assert(0);
		
		LcdcInp32(WPALCON_H, uPalConVal_H);
		LcdcInp32(WPALCON_L, uPalConVal_L);
		
		if(eWin == WIN2)
		{
			LcdcOutp32(WPALCON_H, ((uPalConVal_H & ~(0x600)) | (uPalDataFormat_H<<9)));
			LcdcOutp32(WPALCON_L, ((uPalConVal_L & ~(0x40)) | (uPalDataFormat_L<<6)));
		}
		else if(eWin == WIN3)
		{
			LcdcOutp32(WPALCON_H, ((uPalConVal_H & ~(0x6000)) | (uPalDataFormat_H<<13)));
			LcdcOutp32(WPALCON_L, ((uPalConVal_L & ~(0x80)) | (uPalDataFormat_L<<7)));
		}
		else // (eWin == WIN4)
		{
			LcdcOutp32(WPALCON_H, ((uPalConVal_H & ~(0x60000)) | (uPalDataFormat_H<<17)));
			LcdcOutp32(WPALCON_L, ((uPalConVal_L & ~(0x100)) | (uPalDataFormat_L<<8)));
		}	
	}
}

// Set Palette Clk to set data to palette address
void LCDC_ChangePaletteClk(PAL_CLK ePalClkSrc)
{
	u32 uPalClk;

	LcdcInp32(WPALCON_L, uPalClk);

	if(ePalClkSrc == PAL_HCLK) // HCLK, Enable writting data to palette
	{
		uPalClk |= 1<<9;
	}
	else if(ePalClkSrc == PAL_VCLK) // VCLK, Normal Mode
	{
		uPalClk &= ~(1<<9);
	}
	else
	{
		Assert(0);
	}

	LcdcOutp32(WPALCON_L, uPalClk);

}

// When enable, Video DMA stops, and MapColor appears as back-ground image.
void LCDC_SetColorMapValue(u32 uVal, LCD_WINDOW eWin)
{
	u32 uColVal = uVal&0x00ffffff;
	u32 uWinMapReg;

	uWinMapReg =
		(eWin == WIN0) ? WIN0MAP :
		(eWin == WIN1) ? WIN1MAP :
		(eWin == WIN2) ? WIN2MAP :
		(eWin == WIN3) ? WIN3MAP : WIN4MAP;

	LcdcOutp32(uWinMapReg, COLOR_MAP_ENABLE|uColVal);
}

void LCDC_SetColorMapOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uWinMapReg, uWinMapVal;

	uWinMapReg =
		(eWin == WIN0) ? WIN0MAP :
		(eWin == WIN1) ? WIN1MAP :
		(eWin == WIN2) ? WIN2MAP :
		(eWin == WIN3) ? WIN3MAP : WIN4MAP;

	// Color Map is activated when next frame is run or ENVID_F is '0' and positive edge
	LcdcInp32(uWinMapReg, uWinMapVal);

	if (uOnOff)
	{
		LcdcOutp32(uWinMapReg, COLOR_MAP_ENABLE|uWinMapVal);
	}
	else
	{
		LcdcOutp32(uWinMapReg, ~COLOR_MAP_ENABLE&uWinMapVal);
	}

}

void LCDC_SetAllWinColorMapOnOff(u32 uOnOff)
{
	u32 uColorMapVal;
	u32 uColorMapReg;
	u32 i;

	for (i=0; i<5; i++)
	{
		uColorMapReg =
			(i == 0) ? WIN0MAP :
			(i == 1) ? WIN1MAP :
			(i == 2) ? WIN2MAP :
			(i == 3) ? WIN3MAP : WIN4MAP;

		LcdcInp32(uColorMapReg, uColorMapVal);

		if (uOnOff)
		{
			LcdcOutp32(uColorMapReg, COLOR_MAP_ENABLE|uColorMapVal);
		}
		else
		{
			LcdcOutp32(uColorMapReg, ~COLOR_MAP_ENABLE&uColorMapVal);
		}
	}
}

// Modified LCDC_SetColorKey func.
void LCDC_SetColorKeyOnOff(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uColorKeyReg, uColorKeyVal;

	Assert(eWin != WIN0);

	uColorKeyReg =
		(eWin == WIN1) ? W1KEYCON0 :
		(eWin == WIN2) ? W2KEYCON0 :
		(eWin == WIN3) ? W3KEYCON0 : W4KEYCON0;

	LcdcInp32(uColorKeyReg, uColorKeyVal);

	if (uOnOff) // Turn Color Key On
	{
		LcdcOutp32(uColorKeyReg, uColorKeyVal | KEYEN_F_ENABLE);
	}
	else
	{
		LcdcOutp32(uColorKeyReg, uColorKeyVal & KEYBLEN_F_DISABLE & KEYEN_F_DISABLE);
	}

}

void LCDC_SetAllWinColorKeyOnOff(u32 uOnOff)
{
	u32 uColorKeyReg, uColorKeyVal;
	u32 i;
	
	for (i=1; i<5; i++)
	{
		uColorKeyReg =
			(i == 1) ? W1KEYCON0 :
			(i == 2) ? W2KEYCON0 :
			(i == 3) ? W3KEYCON0 : W4KEYCON0;

		LcdcInp32(uColorKeyReg, uColorKeyVal);

		if (uOnOff)
		{
			LcdcOutp32(uColorKeyReg, uColorKeyVal | KEYEN_F_ENABLE);
		}
		else
		{
			LcdcOutp32(uColorKeyReg, uColorKeyVal & KEYBLEN_F_DISABLE & KEYEN_F_DISABLE);
		}
	}

}

void LCDC_SetColorKey(u32 uMaskKey, u32 uColorKey, COLOR_KEY_DIRECTION eDir, bool bIsBlending, LCD_WINDOW eWin )
{
	u32 uColorKeyReg_0, uColorKeyReg_1;
	u32 uColorKeyVal_0;

	u32 uBlending = KEYBLEN_F_DISABLE;
	u32 uEncolorKey, uDir;
	u32 uWinConReg, uWinConVal;

	Assert(eWin != WIN0);

	if (bIsBlending == true) // To use Key blending, BLD_PIX must be set 1 and ALPHA_SEL be set 0
	{
		uBlending = KEYBLEN_F_ENABLE;
	
		uWinConReg =
			(eWin == WIN1) ? WINCON1 :
			(eWin == WIN2) ? WINCON2 :
			(eWin == WIN3) ? WINCON3 : WINCON4;

		LcdcInp32(uWinConReg, uWinConVal);
		// Set BLD_PIX is set 1 and ALPHA_SEL is set 0
		LcdcOutp32(uWinConReg, uWinConVal | BLD_PIX_PIXEL & ALPHA_SEL_0);
	}

	uColorKeyReg_0 =
		(eWin == WIN1) ? W1KEYCON0 :
		(eWin == WIN2) ? W2KEYCON0 :
		(eWin == WIN3) ? W3KEYCON0 : W4KEYCON0;

	uColorKeyReg_1 =
		(eWin == WIN1) ? W1KEYCON1 :
		(eWin == WIN2) ? W2KEYCON1 :
		(eWin == WIN3) ? W3KEYCON1 : W4KEYCON1;

	uDir = (eDir == MATCH_FG_IMAGE) ? DIRCON_MATCH_FG_IMAGE : DIRCON_MATCH_BG_IMAGE;

	LcdcInp32(uColorKeyReg_0, uColorKeyVal_0);

	uColorKeyVal_0 &= ~(1<<26);
	uColorKeyVal_0 |= uBlending;

	uColorKeyVal_0 &= ~(1<<24);
	uColorKeyVal_0 |= uDir;

	uColorKeyVal_0 |= ( (uMaskKey&0xffffff)<<0 );
	LcdcOutp32(uColorKeyReg_0, uColorKeyVal_0);
	LcdcOutp32(uColorKeyReg_1, uColorKey);

}

void LCDC_SetColorKeyBlackOut(u32 uOnOff, LCD_WINDOW eWin)
{
	u32 uColorKeyReg, uColorKeyVal;

	Assert(eWin != WIN0);

	uColorKeyReg =
		(eWin == WIN1) ? W1KEYCON0 :
		(eWin == WIN2) ? W2KEYCON0 :
		(eWin == WIN3) ? W3KEYCON0 : W4KEYCON0;

	LcdcInp32(uColorKeyReg, uColorKeyVal);

	if (uOnOff) // Turn Color Key On
	{
		LcdcOutp32(uColorKeyReg, uColorKeyVal | KEYBLACKOUT_ENABLE);
	}
	else
	{
		LcdcOutp32(uColorKeyReg, uColorKeyVal & ~(KEYBLACKOUT_ENABLE));
	}



}



void LCDC_SetrScFmtInFifo(IMG_FMT eBpp, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal; 

	Assert((eBpp == RGB24) || (eBpp == YC444));

	uWinConReg =
		(eWin == WIN0) ? WINCON0:
		(eWin == WIN1) ? WINCON1:
		(eWin == WIN2) ? WINCON2: 
		(eWin == WIN3) ? WINCON3: WINCON4;

	LcdcInp32(uWinConReg, uWinConVal);
	
	if(eBpp == RGB24) // RGB
	{
		uWinConVal &= ~(1<<13); 
		LcdcOutp32(uWinConReg,uWinConVal);
	}
	else // YCbCr
	{
		uWinConVal |= (1<<13); 
		LcdcOutp32(uWinConReg,uWinConVal);
	}
}

void LCDC_SetBlendingType(BLENDING_APPLIED_UNIT eBldPix, BLENDING_SELECT_MODE eBldMode, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal;
	u32 uBlendUnit, uBlendSel;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 :
		(eWin == WIN4) ? WINCON4 :
			Assert(0);

	uBlendUnit =
		(eBldPix == PER_PLANE) ? BLD_PIX_PLANE :
		(eBldPix == PER_PIXEL) ? BLD_PIX_PIXEL :
			Assert(0);

	uBlendSel =
		(eBldMode == ALPHA0_PLANE) ? BLEND_ALPHA0_PLANE :
		(eBldMode == ALPHA1_PLANE) ? BLEND_ALPHA1_PLANE :
		(eBldMode == DATA_PIXEL) ? BLEND_DATA_PIXEL :
		(eBldMode == AEN_PIXEL) ? BLEND_AEN_PIXEL : 
		(eBldMode == COLORKEY_AREA) ? BLEND_COLORKEY_AREA :
			Assert(0);
		
	LcdcInp32(uWinConReg, uWinConVal);
	LcdcOutp32(uWinConReg, uWinConVal & ~BLD_PIX_MASK|uBlendUnit & ~ BLEND_SEL_MASK | uBlendSel);

}

void LCDC_SetBlendingEquation(u32 uBackAlphaValFactor, u32 uForeAlphaValFactor, u32 uBackDataFactor, u32 uForeDataFactor, LCD_WINDOW eWin)
{
	u32 uBlendEqReg =
		(eWin == WIN1) ? BLENDEQ1 :
		(eWin == WIN2) ? BLENDEQ2 :
		(eWin == WIN3) ? BLENDEQ3 :
		(eWin == WIN4) ? BLENDEQ4 :
			Assert(0);

	LcdcOutp32(uBlendEqReg, Q_FUNC(uBackAlphaValFactor)|P_FUNC(uForeAlphaValFactor)|
		B_FUNC(uBackDataFactor)|A_FUNC(uForeDataFactor));
	
}

//---------------------------------------------------------
// Function Name : LCDC_SetGAmmaOnOff
// Function Description : This function turn on or off Gamma control function
// Input : uEnable ; 1 = Enable gamma control    0 = Disable gamma control(bypass)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetGammaOnOff(u32 uEnable)
{
	u32 uGammaModeVal;
	u32 uGammaEnable;
	
	Assert( (uEnable == 1) || (uEnable == 0) );

	uGammaEnable = (uEnable ==1)? GM_ON_ENABLE : GM_ON_DISABLE;

	LcdcInp32(VIDCON3, uGammaModeVal);
	LcdcOutp32(VIDCON3, uGammaModeVal & ~GM_ON_ENABLE | uGammaEnable);

}

//---------------------------------------------------------
// Function Name : LCDC_SetGammaValue
// Function Description : This function set Gamma LUT
// Input : *pLUT ; call LUT array
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetGammaValue(u8* pLUT)
{
	u32* pStartGmLUT;
	u32   i;
	
	pStartGmLUT = (u32*) (LCDC_BASE|GAMMALUT_01_00);

	for(i=0;i<65;i++)			// GammaLUT clear
	{

		*pStartGmLUT = 0;
		pStartGmLUT++;

	}

	pStartGmLUT = (u32*) (LCDC_BASE|GAMMALUT_01_00);
	
	for(i=0;i<65;i++)
	{
		if(i%2 == 0)
		*pStartGmLUT = *pStartGmLUT|(pLUT[i]<<2);
		else
		{
		*pStartGmLUT = *pStartGmLUT|(pLUT[i]<<18);			
		pStartGmLUT++;
		}
	}
}


//---------------------------------------------------------
// Function Name : LCDC_SetColorGainOnOff
// Function Description : This function turn on or off Color Gain control function
// Input : uEnable ; 1 = Enable Color Gain control    0 = Disable Color Gain control(bypass)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetColorGainOnOff(u32 uEnable)
{
	u32 uCGModeVal;
	u32 uCGEnable;
	
	Assert( (uEnable == 1) || (uEnable == 0) );

	uCGEnable = (uEnable ==1)? CG_ON_ENABLE : CG_ON_DISABLE;

	LcdcInp32(VIDCON3, uCGModeVal);
	LcdcOutp32(VIDCON3, uCGModeVal & ~GM_ON_ENABLE | uCGEnable);

}


//---------------------------------------------------------
// Function Name : LCDC_SetColorGainValue
// Function Description : This function turn on or off Gamma control function
// Input : uCGRed , uCGGreen , uCGBlue 
//            ; 1 = Color gain 1/256   2 = Color gain 2/256  .... 256 = 256/256 ... 1023 = 1023/1024
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetColorGainValue(u32 uCGRed, u32 uCGGreen, u32 uCGBlue)
{
	u32 uCGModeVal;

//	LcdcInp32(COLORGAINCON, uCGModeVal);
	LcdcOutp32(COLORGAINCON, (uCGBlue <<0 | uCGGreen <<10 | uCGRed <<20));
}


//---------------------------------------------------------
// Function Name : LCDC_SetHUEOnOff
// Function Description : This function turn on or off HUE control function and HUE_CSC_F & B
// Input : uEnable ; 1 = Enable HUE control    0 = Disable HUE control(bypass)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetHUEOnOff(u32 uEnable)
{
	u32 uHUEModeVal;
	u32 uHUEEnable;
	
	Assert( (uEnable == 1) || (uEnable == 0) );

	uHUEEnable = (uEnable ==1)? (HUE_CSC_F_ENABLE | HUE_CSC_B_ENABLE |HUE_ON_ENABLE) : (HUE_CSC_F_DISABLE | HUE_CSC_B_DISABLE |HUE_ON_DISABLE);

	LcdcInp32(VIDCON3, uHUEModeVal);
	LcdcOutp32(VIDCON3, uHUEModeVal & ~(HUE_CSC_F_ENABLE|HUE_CSC_B_DISABLE|HUE_ON_ENABLE)| uHUEEnable);

}

//---------------------------------------------------------
// Function Name : LCDC_SetHUE_CSC_control
// Function Description : This function selects HUE CSC 's characteristic such as WIDE/NARROW & Eq601/709
// Input : eWide = CSC_WIDE / CSC_NARROW    eEq = CSC_EQ601 / CSC_EQ709
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetHUE_CSC_control(HUE_CSC_MODE eWide, HUE_CSC_MODE eEq)
{
	u32 uCSCModeVal;
	u32 uCSCwide;
	u32 uCSCeq;
	
	Assert( (eWide == CSC_WIDE) || (eWide == CSC_NARROW) );
	Assert( (eEq == CSC_EQ601) || (eEq == CSC_EQ709) );

	uCSCwide = (eWide ==CSC_WIDE)? (HUE_CSC_F_WIDE |HUE_CSC_B_WIDE) : (HUE_CSC_F_NARROW |HUE_CSC_B_NARROW);
	uCSCeq = (eEq ==CSC_EQ601)? (HUE_CSC_F_EQ601 |HUE_CSC_B_EQ601) : (HUE_CSC_F_EQ709 |HUE_CSC_B_EQ709);
	
	LcdcInp32(VIDCON3, uCSCModeVal);
	LcdcOutp32(VIDCON3, uCSCModeVal & ~(HUE_CSC_F_NARROW|HUE_CSC_F_EQ709|HUE_CSC_B_NARROW|HUE_CSC_F_EQ709)| uCSCwide | uCSCeq);

}


//---------------------------------------------------------
// Function Name : LCDC_SetHUE_Coef
// Function Description : This function sets HUE Coefficient values
// Input : eCBG0_P,eCBG0_N,eCBG1_P,eCBG1_N,eCRG0_P,eCRG0_N,eCRG1_P,eCRG1_N
//                 ; 0x0 = 0 , 0x1 = (1/256) , 0x2 = (2/256)  ... 0x100 = (256/256)     0x101 ~ 0x2FF : reserved
//                 ; 0x300 = (-256/256) ,  0x301 = (-255/256)  ,  0x302 = (-254/256) ... 0x3FF = (-1/256)
//                 ; default value = 0x100 
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetHUE_Coef(u16 eCBG0_P,u16 eCBG0_N,u16 eCBG1_P,u16 eCBG1_N,u16 eCRG0_P,u16 eCRG0_N,u16 eCRG1_P,u16 eCRG1_N)
{

/*
	Assert(((eCBG0_P >= 0x101) && (eCBG0_P <= 0x2FF))||((eCBG0_N >= 0x101) && (eCBG0_N <= 0x2FF)));
	Assert(((eCBG1_P >= 0x101) && (eCBG1_P <= 0x2FF))||((eCBG1_N >= 0x101) && (eCBG1_N <= 0x2FF)));
	Assert(((eCRG0_P >= 0x101) && (eCRG0_P <= 0x2FF))||((eCRG0_N >= 0x101) && (eCRG0_N <= 0x2FF)));
	Assert(((eCRG1_P >= 0x101) && (eCRG1_P <= 0x2FF))||((eCRG1_N >= 0x101) && (eCRG1_N <= 0x2FF)));
*/
	
	LcdcOutp32(HUECOEF00, (eCBG0_P<<16) | (eCBG0_N));
	LcdcOutp32(HUECOEF01, (eCBG1_P<<16) | (eCBG1_N));
	LcdcOutp32(HUECOEF10, (eCRG0_P<<16) | (eCRG0_N));	
	LcdcOutp32(HUECOEF11, (eCRG1_P<<16) | (eCRG1_N));	

}

//---------------------------------------------------------
// Function Name : LCDC_SetHUE_Offset
// Function Description : This function sets HUE offset
// Input : eOffsetIn , eOffsetOut    ; 0x0 = +0   0x1 = +1   0x2 = +2 ... 0xFF = +256
//                                             ; 0x100 = -256  0x101 = -255  0x102 = -254 ... 0x1FF = -1
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetHUE_Offset(u16 eOffsetIn,u16 eOffsetOut)
{
/*
	Assert((eOffsetIn > 0x1FF)
|| (eOffsetOut > 0x1FF));
*/

	LcdcOutp32(HUEOFFSET, (eOffsetIn<<16) | (eOffsetOut));
}

//---------------------------------------------------------
// Function Name : LCDC_SetALPSOnOff
// Function Description : This function turn on or off HUE control function and HUE_CSC_F & B
// Input : uEnable ; 1 = Enable ALPS control    0 = Disable ALPS control(bypass)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetALPSOnOff(u32 uEnable)
{
	u32 uALPSModeVal;
	u32 uALPSModeVal2;	
	u32 uALPSModeVal3;	
	u32 uALPSEnable;
	u32 uALPSEnable2;
	u32 uALPSEnable3;	
	
	Assert( (uEnable == 1) || (uEnable == 0) );

	uALPSEnable = (uEnable ==1)? VE_ON_ENABLE : VE_ON_DISABLE;
/*
	uALPSEnable2 = (uEnable ==1)? VE_EN_F_ENABLE : VE_EN_F_DISABLE;
	uALPSEnable3 = (uEnable ==1)? ODV_SEL_ENABLE : ODV_SEL_DISABLE;



	LcdcInp32(VESFRCON1, uALPSModeVal3);
	LcdcOutp32(VESFRCON1, uALPSModeVal3 & ~ODV_SEL_ENABLE | uALPSEnable3 | 0x10 );	//Turn on IP

	LcdcInp32(VESFRCON0, uALPSModeVal2);
	LcdcOutp32(VESFRCON0, uALPSModeVal2 & ~VE_EN_F_ENABLE | uALPSEnable2);		//connect ALPS with bus
*/

	LcdcInp32(VIDCON3, uALPSModeVal);
	LcdcOutp32(VIDCON3, uALPSModeVal & ~VE_ON_ENABLE | uALPSEnable);		//ALPS Enable


}

//---------------------------------------------------------
// Function Name : LCDC_SetALPSsize
// Function Description : This function set ALPS size by manual input
// Input : uHsz ; output LDI Horizental size (max 0x7FF)    uVsz ; output LDI Vertical size (max 0x7FF)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetALPSsize(u32 uHsz, u32 uVsz)
{
	u32 uALPSModeVal;
	u32 uALPSModeVal2;
	u32 uALPSEnable;
	u32 uALPSEnable2;

	LcdcInp32(VESFRCON2, uALPSModeVal2);
	LcdcOutp32(VESFRCON2, uALPSModeVal2 | ODV_SEL_FREESIZE );
	
	LcdcInp32(VESFRCON1, uALPSModeVal);
	LcdcOutp32(VESFRCON1, uALPSModeVal & ~(VE_VSIZE_F(0x7FF)) | VE_VSIZE_F(uVsz) | VE_HSIZE_F(uHsz) | 0x10 );	//Turn on IP

}


//---------------------------------------------------------
// Function Name : LCDC_SetALPSLux
// Function Description : This function set ALPS Lux
// Input : uLux ; CONTROL_LUX's LOW_LUX (20000~40000lux) or HIGH_LUX (40000 ~ 70000lux)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetALPSLux(CONTROL_LUX uLux)
{
	u32 uALPSModeVal;

	LcdcInp32(VESFRCON0, uALPSModeVal);

	if(uLux == LOW_LUX)
	{
	LcdcOutp32(VESFRCON0, uALPSModeVal & ~LUX_HIGH | LUX_LOW);	
	}
	else
	{
	LcdcOutp32(VESFRCON0, uALPSModeVal & ~LUX_HIGH | LUX_HIGH);
	}
}

//---------------------------------------------------------
// Function Name : LCDC_SetALPSLutValue
// Function Description : This function set ALPS LUT table
// Input :  pLow_R_LUT,  pLow_G_LUT,  pLow_B_LUT,  pHigh_R_LUT,  pHigh_G_LUT,  pHigh_B_LUT ; call LUT array
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetALPSLutValue(u8* pLow_R_LUT, u8* pLow_G_LUT, u8* pLow_B_LUT, u8* pHigh_R_LUT, u8* pHigh_G_LUT, u8* pHigh_B_LUT)
{
	u32* pStartALPSLUT1;
	u32* pStartALPSLUT2;	
	u32   i;
	
	pStartALPSLUT1 = (u32*) (LCDC_BASE|VELUT1_00);
	pStartALPSLUT2 = (u32*) (LCDC_BASE|VELUT2_000);	

	for(i=0;i<217;i++)			// GammaLUT clear
	{

		*pStartALPSLUT1 = 0;
		pStartALPSLUT1++;
		
		*pStartALPSLUT2 = 0;
		pStartALPSLUT2++;

	}

	pStartALPSLUT1 = (u32*) (LCDC_BASE|VELUT1_00);
	pStartALPSLUT2 = (u32*) (LCDC_BASE|VELUT2_000);	
	
	for(i=0;i<217;i++)
	{
		*pStartALPSLUT1 = (u32)( (pLow_B_LUT[i]<<16) | (pLow_G_LUT[i]<<8) | (pLow_R_LUT[i]<<0) );
		*pStartALPSLUT2 = (u32)( (pHigh_B_LUT[i]<<16) | (pHigh_G_LUT[i]<<8) | (pHigh_R_LUT[i]<<0) ) ;		
		pStartALPSLUT1++;
		pStartALPSLUT2++;		
	}
}

//---------------------------------------------------------
// Function Name : LCDC_SetALPSLutFullValue
// Function Description : This function set ALPS LUT table
// Input :  pLow_R_LUT,  pLow_G_LUT,  pLow_B_LUT,  pHigh_R_LUT,  pHigh_G_LUT,  pHigh_B_LUT ; call LUT array
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetALPSLutFullValue(u32* pLow_LUT, u32* pHigh_LUT)
{
	u32* pStartALPSFullLUT1;
	u32* pStartALPSFullLUT2;	
	u32   i;
	
	pStartALPSFullLUT1 = (u32*) (LCDC_BASE|VELUT1_00);
	pStartALPSFullLUT2 = (u32*) (LCDC_BASE|VELUT2_000);	

	for(i=0;i<256;i++)			// GammaLUT clear
	{

		*pStartALPSFullLUT1 = 0;
		pStartALPSFullLUT1++;
		
		*pStartALPSFullLUT2 = 0;
		pStartALPSFullLUT2++;

	}

	pStartALPSFullLUT1 = (u32*) (LCDC_BASE|VELUT1_00);
	pStartALPSFullLUT2 = (u32*) (LCDC_BASE|VELUT2_000);	
	
	for(i=0;i<256;i++)
	{
		*pStartALPSFullLUT1 = (u32)(pLow_LUT[i]<<0);
		*pStartALPSFullLUT2 = (u32)(pHigh_LUT[i]<<0);
		pStartALPSFullLUT1++;
		pStartALPSFullLUT2++;		
	}
}


//---------------------------------------------------------
// Function Name : LCDC_SetDitheringOnOff
// Function Description : This function turn on or off Dithering function
// Input : uEnable ; 1 = Enable Dithering    0 = Disable Dithering(bypass)
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetDitheringOnOff(u32 uEnable)
{
	u32 uDithModeVal;
	u32 uDithEnable;
	
	Assert( (uEnable == 1) || (uEnable == 0) );

	uDithEnable = (uEnable == 1) ? DITHERING_ENABLE : DITHERING_DISABLE;

	LcdcInp32(DITHMODE, uDithModeVal);
	LcdcOutp32(DITHMODE, uDithModeVal & ~RGB_DITHPOS_MASK|uDithEnable); //Do not write non-zero in [31:7]
}

//---------------------------------------------------------
// Function Name : LCDC_SetDitheringValue
// Function Description : This function set R,G,B Dithering Values
// Input : eRedDitherBit, eGreenDitherBit, eBlueDitherBit ; DITH_5BIT, DITH_6BIT, DITH_8BIT
// Output : none
// Version : v0.0
//---------------------------------------------------------
void LCDC_SetDitheringValue(DITHER_MODE eRedDitherBit, DITHER_MODE eGreenDitherBit, DITHER_MODE eBlueDitherBit)
{	
	u32 uDithModeVal;

	if(eRedDitherBit == DITH_5BIT)
		oLcdc.m_uDitherMode = RDITHPOS_5BIT;
	else if(eRedDitherBit == DITH_6BIT)
		oLcdc.m_uDitherMode = RDITHPOS_6BIT;
	else if(eRedDitherBit == DITH_8BIT)
		oLcdc.m_uDitherMode = RDITHPOS_8BIT;

	if(eGreenDitherBit == DITH_5BIT)
		oLcdc.m_uDitherMode |= GDITHPOS_5BIT;
	else if(eGreenDitherBit == DITH_6BIT)
		oLcdc.m_uDitherMode |= GDITHPOS_6BIT;
	else if(eGreenDitherBit == DITH_8BIT)
		oLcdc.m_uDitherMode |= GDITHPOS_8BIT;

	if(eBlueDitherBit == DITH_5BIT)
		oLcdc.m_uDitherMode |= BDITHPOS_5BIT;
	else if(eBlueDitherBit == DITH_6BIT)
		oLcdc.m_uDitherMode |= BDITHPOS_6BIT;
	else if(eBlueDitherBit == DITH_8BIT)
		oLcdc.m_uDitherMode |= BDITHPOS_8BIT;

	LcdcInp32(DITHMODE, uDithModeVal);
	LcdcOutp32(DITHMODE, uDithModeVal & ~RGB_DITHPOS_MASK | oLcdc.m_uDitherMode); 	//Do not write non-zero in [31:7]
}



// Select Active Frame Buffer in Double Buffer
// if uWhichBuf == 0, Buffer 0. if uWhichBuf == 1, Buffer 1
void LCDC_SetActiveFrameBuf(u32 uWhichBuf, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal;

//	Assert( (eWin == WIN0) || (eWin == WIN1) ); // Double buffering is supported in WIN 0 or WIN 1
//	Assert( (uWhichBuf == 0) || (uWhichBuf == 1) );

	uWinConReg = (eWin == WIN0) ? WINCON0 :
		              (eWin == WIN1) ? WINCON1 :
		              (eWin == WIN2) ? WINCON2 :
		              (eWin == WIN3) ? WINCON3 : WINCON4 ;
	LcdcInp32(uWinConReg, uWinConVal);


	if(uWhichBuf&0x1)
		uWinConVal |= (1<<20); // low select bit[0]
	else
		uWinConVal &= ~(1<<20); // low select bit[0]

	if(uWhichBuf&0x2)
		uWinConVal |= (1<<30); // high select bit[1]
	else
		uWinConVal &= ~(1<<30); // high select bit[1]

	LcdcOutp32(uWinConReg, uWinConVal);

}

// if uMode == 0, Normal Mode. if uMode == 1, AutoBuffer Mode
void LCDC_EnableAutoBuf(LCDC_AUTO_BUFFER_MODE uMode, LCD_WINDOW eWin)
{
	u32 uWinConVal;
	u32 uWinCtrlReg, uWinCtrlVal;

//	Assert( (eWin == WIN0) || (eWin == WIN1));
	Assert( (uMode == LCDC_BUF_SINGLE) || (uMode == LCDC_BUF_DOUBLE) || (uMode == LCDC_BUF_TRIPLE) );

	oLcdc.m_bAutoBuf = uMode;
	
	uWinCtrlReg = (eWin == WIN0) ? WINCON0 :
		             (eWin == WIN1) ? WINCON1 :
				(eWin == WIN2) ? WINCON2 :
				(eWin == WIN3) ? WINCON3 : WINCON4 ;

	LcdcInp32(uWinCtrlReg, uWinCtrlVal);
	
	if(uMode == LCDC_BUF_SINGLE)
	{
		uWinCtrlVal&=~WBUFAUTO_ENABLE;
	}
	else if(uMode == LCDC_BUF_DOUBLE)
	{
		uWinCtrlVal|=WBUFAUTO_ENABLE;
		uWinCtrlVal&=~TRIPLE_BUFFER_MODE;
	}
	else if(uMode == LCDC_BUF_TRIPLE)
	{
		uWinCtrlVal|=WBUFAUTO_ENABLE;
		uWinCtrlVal|=TRIPLE_BUFFER_MODE;
	}
	else
	{
		Assert(0);
	}
	LcdcOutp32(uWinCtrlReg, uWinCtrlVal);
	
}

// select RGB sequence
void LCDC_SetRgbFormat(PNR_MODE uPnr)
{
	u32 uVidConVal;
	u32 uStatus, uPnrMode;

	LcdcInp32(VIDCON0, uVidConVal);
	uStatus = uVidConVal&(0X3<<26); // Get VIDOUT [28:26]

	if ( (uStatus == VIDOUT_RGBIF) || (uStatus == VIDOUT_TVNRGBIF) )
	{
		uPnrMode =
			(uPnr == RGB_P) ? PNRMODE_RGB_P :
			(uPnr == BGR_P) ? PNRMODE_BGR_P :
			(uPnr == RGB_S) ? PNRMODE_RGB_S : PNRMODE_BGR_S;
	}
	else if ( (uStatus == VIDOUT_I80IF0) || (uStatus == VIDOUT_I80IF1) ||
		(uStatus == VIDOUT_TVNI80IF0) || (uStatus == VIDOUT_TVNI80IF1) )
	{
		uPnrMode = PNRMODE_RGB_P;
	}
	else
	{
		Assert(0);
	}

	LcdcOutp32(VIDCON0, uVidConVal & ~PNRMODE_MASK | uPnrMode);
}


void LCDC_SetRGBOrder(RGB_ORDER eEvenOrder, RGB_ORDER eOddOrder)
{
	u32 uRegValue;

	LcdcInp32(VIDCON2, uRegValue);
	uRegValue&=~(7<<19|7<<16);

	switch(eEvenOrder)
	{
		case RGB: uRegValue|=RGB_ORDER_E_RGB; break;
		case GBR: uRegValue|=RGB_ORDER_E_GBR; break;
		case BRG: uRegValue|=RGB_ORDER_E_BRG; break;
		case BGR: uRegValue|=RGB_ORDER_E_BGR; break;
		case RBG: uRegValue|=RGB_ORDER_E_RBG; break;
		case GRB: uRegValue|=RGB_ORDER_E_GRB; break;
		default : Assert(0);
	}
	
	switch(eOddOrder)
	{
		case RGB: uRegValue|=RGB_ORDER_O_RGB; break;
		case GBR: uRegValue|=RGB_ORDER_O_GBR; break;
		case BRG: uRegValue|=RGB_ORDER_O_BRG; break;
		case BGR: uRegValue|=RGB_ORDER_O_BGR; break;
		case RBG: uRegValue|=RGB_ORDER_O_RBG; break;
		case GRB: uRegValue|=RGB_ORDER_O_GRB; break;
		default : Assert(0);
	}
	LcdcOutp32(VIDCON2, uRegValue);
	
}


void LCDC_SetByteSwap(SWAP_MODE eBitSwap, SWAP_MODE eByteSwap, SWAP_MODE eHawSwap, SWAP_MODE eWordSwap, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal;
	u32 uBitTemp, uByteTemp, uHalfTemp, uWordTemp;

	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;

	uBitTemp = (eBitSwap == SWAP_BIT_ENABLE) ? 1 : 0;
	uByteTemp = (eByteSwap == SWAP_BYTE_ENABLE) ? 1 : 0;
	uHalfTemp = (eHawSwap == SWAP_HALFWORD_ENABLE) ? 1 : 0;
	uWordTemp = (eWordSwap == SWAP_WORD_ENABLE) ? 1 : 0;

	LcdcInp32(uWinConReg, uWinConVal);
	LcdcOutp32(uWinConReg, uWinConVal&~(0xf<<15)|(uBitTemp<<18)|(uByteTemp<<17)|(uHalfTemp<<16)|(uWordTemp<<15));
}


void LCDC_SetBurstLength(BURST_MODE eBurstLength, LCD_WINDOW eWin)
{
	u32 uWinConReg, uWinConVal;
		
	uWinConReg =
		(eWin == WIN0) ? WINCON0 :
		(eWin == WIN1) ? WINCON1 :
		(eWin == WIN2) ? WINCON2 :
		(eWin == WIN3) ? WINCON3 : WINCON4;
		
	LcdcInp32(uWinConReg, uWinConVal);

	if (eBurstLength == BURST16) 
		{
		LcdcOutp32(uWinConReg, uWinConVal & ~(0x3<<9)|MAX_BURSTLEN_16WORD);
		}
	else if (eBurstLength == BURST8) 
		{
		LcdcOutp32(uWinConReg, uWinConVal & ~(0x3<<9)|MAX_BURSTLEN_8WORD);
		}
	else if (eBurstLength == BURST4) 
		{
		LcdcOutp32(uWinConReg, uWinConVal & ~(0x3<<9)|MAX_BURSTLEN_4WORD);
		}
}

void LCDC_SetCpuIfDataFormat(CPUIF_LDI eLdiMode, CPUIF_DATA_FORMAT eFormat)
{
	u32 uVidConVal;
	u32 uLdi, uFormat;

	LcdcInp32(VIDCON0, uVidConVal);

	uLdi = (eLdiMode == MAIN) ? VIDOUT_I80IF0: VIDOUT_I80IF1;
	uVidConVal = (uVidConVal & LCD_OUT_MASKING) | uLdi;

	if (eLdiMode == MAIN)
	{
		uFormat =
			(eFormat == D16BIT) ? MAIN_16_MODE :
			(eFormat == D16PLUS2BIT) ? MAIN_16PLUS2_MODE :
			(eFormat == D9PLUS9BIT) ? MAIN_9PLUS9_MODE :
			(eFormat == D16PLUS8BIT) ? MAIN_16PLUS8_MODE : MAIN_18_MODE;

		uVidConVal = (uVidConVal & MAIN_DATA_MASKING) | uFormat;
	}
	else //ldiMode == SUB
	{
		uFormat =
			(eFormat == D16BIT) ? SUB_16_MODE :
			(eFormat == D16PLUS2BIT) ? SUB_16PLUS2_MODE :
			(eFormat == D9PLUS9BIT) ? SUB_9PLUS9_MODE :
			(eFormat == D16PLUS8BIT) ? SUB_16PLUS8_MODE : SUB_18_MODE;

		uVidConVal = (uVidConVal & SUB_DATA_MASKING) | uFormat;
	}

	LcdcOutp32(VIDCON0, uVidConVal);
}

void LCDC_SetTriggerMode(TRIGGER_MODE eTrig)
{
	u32 uTrigConVal, uTrigVal;

	uTrigVal = (eTrig == SW_TRIG) ? 1 : 0;
	uTrigVal |= (eTrig == SW_TRIG) ? 0x0<<0 : 0x3<<3;

	LcdcInp32(TRIGCON, uTrigConVal);
	uTrigConVal &= ~(0x1<<0); // Mask Trigger mode
	uTrigConVal &= ~(0x3<<3); // Mask H/W LCDC_Trigger Mask and H/W Trigger Enable bit
	LcdcOutp32(TRIGCON, uTrigConVal|uTrigVal);
}

void LCDC_SetCpuIfTiming(u8 ucCSSetUpTime, u8 ucWrSetUpTime, u8 ucWrActTime, u8 ucWrHoldTime, CPUIF_LDI eLdi)
{
	u32 uCpuIfTimeReg, uCpuIfTimeVal;

/*
	Outp32(0xe0200120,0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x33333333);	//set GPF1 as SYS_VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x33333333);	//set GPF2 as SYS_VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00303333);	//set GPF4 as SYS_VD[23:20], SYS_OEn
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set TOUT3 as Output signal for PWRRESET
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High

	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(33);
*/

	uCpuIfTimeReg = (eLdi == MAIN) ? I80IFCONA0 : I80IFCONA1;

	LcdcInp32(uCpuIfTimeReg, uCpuIfTimeVal);
	uCpuIfTimeVal =
		LCD_CS_SETUP((u32)ucCSSetUpTime) |
		LCD_WR_SETUP((u32)ucWrSetUpTime) |
		LCD_WR_ACT((u32)ucWrActTime) |
		LCD_WR_HOLD((u32)ucWrHoldTime) |
		#if ( LCD_MODEL == LCD_MIPIModule)
		RSPOL_LOW |
		#else
		RSPOL_HIGH |
		#endif
		I80IFEN_ENABLE;		
	LcdcOutp32(uCpuIfTimeReg, uCpuIfTimeVal);

}

void LCDC_DisplayPartialArea(
	u32 uSrcStX, u32 uSrcStY, u32 uDstStX, u32 uDstStY,
	u32 uPartialHSz, u32 uPartialVsz, u32 uSrcFbStAddr,
	LCD_WINDOW eWin,CPUIF_LDI eCpuIf)
{
	u32 uSrcEndX, uSrcEndY;
	u32 uOffsetSz, uPageWidth;

	u32 uFrmBufStAddrReg, uFrmBufEndAddrReg;
	u32 uOffsetPageWidthReg;
	u32 uOsdLeftPosReg, uOsdRightPosReg;

	u32 uFbEndAddr;

	u32 uCmdVal[6];
	u32 uLdiStYReg1, uLdiStYReg2;
	u32 uStYQutotient, uStYRemainder;
	u32 uLdiEndX, uLdiEndY;
	u32 uLdiEndYReg1, uLdiEndYReg2;
	u32 uEndYQutotient, uEndYRemainder;

	uSrcEndX = uSrcStX + uPartialHSz - 1;
	uSrcEndY = uSrcStY + uPartialVsz - 1;

	uFrmBufStAddrReg =
		(eWin == WIN0) ? VIDW00ADD0B0 :
		(eWin == WIN1) ? VIDW01ADD0B0:
		(eWin == WIN2) ? VIDW02ADD0B0 :
		(eWin == WIN3) ? VIDW03ADD0B0 : VIDW04ADD0B0;

	uFrmBufEndAddrReg =
		(eWin == WIN0) ? VIDW00ADD1B0 :
		(eWin == WIN1) ? VIDW01ADD1B0 :
		(eWin == WIN2) ? VIDW02ADD1B0 :
		(eWin == WIN3) ? VIDW03ADD1B0 : VIDW04ADD1B0;

	uOffsetPageWidthReg =
		(eWin == WIN0) ? VIDW00ADD2 :
		(eWin == WIN1) ? VIDW01ADD2 :
		(eWin == WIN2) ? VIDW02ADD2 :
		(eWin == WIN3) ? VIDW03ADD2 : VIDW04ADD2;

	uOsdLeftPosReg =
		(eWin == WIN0) ? VIDOSD0A :
		(eWin == WIN1) ? VIDOSD1A :
		(eWin == WIN2) ? VIDOSD2A :
		(eWin == WIN3) ? VIDOSD3A : VIDOSD4A;

	uOsdRightPosReg =
		(eWin == WIN0) ? VIDOSD0B :
		(eWin == WIN1) ? VIDOSD1B :
		(eWin == WIN2) ? VIDOSD2B :
		(eWin == WIN3) ? VIDOSD3B : VIDOSD4B;

	uFbEndAddr = uSrcFbStAddr + uPartialHSz*uPartialVsz*oLcdc.m_uBytes/oLcdc.m_uBits;

	uOffsetSz = (oLcdc.m_uFrmHSz[eWin] - uPartialHSz)*(oLcdc.m_uBytes/oLcdc.m_uBits);
	uPageWidth = uPartialHSz*(oLcdc.m_uBytes/oLcdc.m_uBits);

	/////////////////////////////////////////////////////////
	// Set LCD Controller's SFR                            //
	/////////////////////////////////////////////////////////

	// Set display size
	LcdcOutp32(VIDTCON2, LINEVAL(uPartialVsz-1) | HOZVAL(uPartialHSz-1));

	// Set start/ end addr. of frame buffer
	LcdcOutp32(uFrmBufStAddrReg, uSrcFbStAddr);
	LcdcOutp32(uFrmBufEndAddrReg, uFbEndAddr);

	// Set page width and offset size
	LcdcOutp32(uOffsetPageWidthReg, (oLcdc.m_uOffsetSz[eWin]<<13) | oLcdc.m_uPageWidth[eWin]);

	// Set window's left top and right down (X, Y) coordinate
	LcdcOutp32(uOsdLeftPosReg, OSD_LTX_F(uSrcStX) | OSD_LTY_F(uSrcStY));
	LcdcOutp32(uOsdRightPosReg, OSD_RBX_F(uSrcEndX) | OSD_RBY_F(uSrcEndY));

#if ( LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTS222Q_SPI) 	
	Assert(0);
#elif ( LCD_MODEL == LCD_MIPIModule)
	// will be updated	- NSH
	{
	}
#elif ( LCD_MODEL==LCD_LTS222Q_CPU  ) 
	Assert( (uDstStX == 0) && (uPartialHSz == 240) );
	
	uStYQutotient = uDstStY/0xff;
	uStYRemainder = uDstStY%0xff;
	uCmdVal[0] = 0x4200 + uDstStX;
	uCmdVal[1] = 0x4300 + uStYQutotient;
	uCmdVal[2] = 0x4400 + uStYRemainder;
	uLdiEndX = uDstStX + uPartialHSz - 1;
	uLdiEndY = uDstStY + uPartialVsz - 1;
	uEndYQutotient = uLdiEndY/0xff;
	uEndYRemainder = uLdiEndY%0xff;
	
	LCDC_PutCmdToLdi(uCmdVal, 3, eCpuIf, LCD_NORMAL_CMD);
		
#else
	Assert(0);
#endif

}

void LCDC_ClearPending(u32 uIntFlag)
{	
	LcdcOutp32(VIDINTCON1, uIntFlag);	
}

void LCDC_GetIntFlag(u32* pFlag)
{
	LcdcInp32(VIDINTCON1, *pFlag);
}

bool LCDC_IsFrameDone(void)
{
	u32 uTrigConVal;

	LcdcInp32(TRIGCON, uTrigConVal);

	// LCDC_IsFrameDone Function is valid only when TRGMODE[0] is set to 1
	Assert( (uTrigConVal&(0x1<<0)) == (0x1<<0) );

	return ( ((uTrigConVal&(0x1<<2)) == (0x1<<2)) ? true : false );
}

void LCDC_SetFrameSkipRate(CPU_FRAME_SKIP eFrmSkip, CPUIF_LDI eLdi)
{
	u32 uSkipVal;
	u32 uI80IfConReg, uI80IfConRegVal;

	// SKIP_PER_TWO_FRM : display one frame per two frame
	// SKIP_PER_THREE_FRM : display one frame per three frame
	uSkipVal =
		(eFrmSkip == NO_SKIP) ? (0x0<<5) :
		(eFrmSkip == SKIP_PER_TWO_FRM) ? (0x1<<5) : (0x2<<5);

	uI80IfConReg = (eLdi == MAIN) ? I80IFCONB0 : I80IFCONB1;

	LcdcInp32(uI80IfConReg, uI80IfConRegVal);
	uI80IfConRegVal &= ~(0x3<<5);
	uI80IfConRegVal |= uSkipVal;
	LcdcOutp32(uI80IfConReg, uI80IfConRegVal);
}

void LCDC_SetAutoCmdRate(CPU_AUTO_CMD_RATE eCmdRate, CPUIF_LDI eLdi)
{
	u32 uCmdRateVal;
	u32 uI80IfConReg, uI80IfConRegVal;

	uI80IfConReg = (eLdi == MAIN) ? I80IFCONB0 : I80IFCONB1;

	uCmdRateVal =
		(eCmdRate == DISABLE_AUTO_FRM) ? (0x0<<0) :
		(eCmdRate == PER_TWO_FRM) ? (0x1<<0) :
		(eCmdRate == PER_FOUR_FRM) ? (0x2<<0) :
		(eCmdRate == PER_SIX_FRM) ? (0x3<<0) :
		(eCmdRate == PER_EIGHT_FRM) ? (0x4<<0) :
		(eCmdRate == PER_TEN_FRM) ? (0x5<<0) :
		(eCmdRate == PER_TWELVE_FRM) ? (0x6<<0) :
		(eCmdRate == PER_FOURTEEN_FRM) ? (0x7<<0) :
		(eCmdRate == PER_SIXTEEN_FRM) ? (0x8<<0) :
		(eCmdRate == PER_EIGHTEEN_FRM) ? (0x9<<0) :
		(eCmdRate == PER_TWENTY_FRM) ? (0xa<<0) :
		(eCmdRate == PER_TWENTY_TWO_FRM) ? (0xb<<0) :
		(eCmdRate == PER_TWENTY_FOUR_FRM) ? (0xc<<0) :
		(eCmdRate == PER_TWENTY_SIX_FRM) ? (0xd<<0) :
		(eCmdRate == PER_TWENTY_EIGHT_FRM) ? (0xe<<0) : (0xf<<0);

	LcdcInp32(uI80IfConReg, uI80IfConRegVal);
	uI80IfConRegVal &= ~(0xf<<0);
	uI80IfConRegVal |= uCmdRateVal;
	LcdcOutp32(uI80IfConReg, uI80IfConRegVal);

}


//-----------------------------------------------------------------------------
// Function Name : LCDC_InitGpioMux
// Function Description : This function set GPIO to use FIMD
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitGpioMux(CPUIF_LDI eLdiMode)
{

#if (LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_SPI || LCD_MODEL == LCD_LTS350Q1 || LCD_MODEL==LCD_LTE480WV_RGB ||LCD_MODEL== LCD_LTV350QV_RGB || LCD_MODEL == LCD_TL2796 || LCD_MODEL == LCD_SXGA || LCD_MODEL == LCD_AUO27_SKIP)


	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High


/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/


	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	

/*		//SMRP
	GPIO_SetFunctionEach(eGPIO_H1,eGPIO_0, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H1,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x1);		// Reset High	
*/
	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);


	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)

	
	/*
	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00022222);	//set GPF3 as VD[23:20] 
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set GPD0's TOUT3 as PWM_MIE signal
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High


	
	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);
	*/

#elif(LCD_MODEL == LCD_LMS280GS01)


	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)


	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_6,0x1)	;		//Power on (SPI1_MISO)
	Delay(100);


	
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High


/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/

	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	


	
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)

	
#elif(LCD_MODEL == LCD_LTM030DK)

	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	//Set Control Back-Light Regulator Shotdown Pin
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x0);		// BL **LOW**
/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/

	//Reset LDI
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(10);	// 50ms delay
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(2);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	
//	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)


	
#elif (LCD_MODEL == LCD_LTS222Q_CPU)


	GPIO_SetFunctionAll(eGPIO_F0, 0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x33333333);	//set GPF1 as SYS_VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x33333333);	//set GPF2 as SYS_VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00303333);	//set GPF3 as SYS_VD[23:20], SYS_OE
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0xcff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	

	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(500);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(500);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	
//	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
//	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(100);

	
#elif (LCD_MODEL == LCD_UF24U276A)


	GPIO_SetFunctionAll(eGPIO_F0, 0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x33333333);	//set GPF1 as SYS_VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x33333333);	//set GPF2 as SYS_VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00303333);	//set GPF3 as SYS_VD[23:20], SYS_OE
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0xcff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	

	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_0, 0x1);	//set GPD0's TOUT3 as Output signal(IIC_SDA)
	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_1, 0x1);	//set GPD0's TOUT3 as Output signal(IIC_SCL)
	GPIO_SetPullUpDownAll(eGPIO_D1,0x0);			//set pull-up,down disable

/*
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_6,0x1)	;		//Power on (SPI1_MISO)
	Delay(100);

	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_0, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownEach(eGPIO_D1,eGPIO_0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x1);		// Reset High
	Delay(10);
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x0);		// Reset Low
	Delay(500);
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x1);		// Reset High	


	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x0);	//set GPH0's GPH0CON[6] as Input(LCD_FLM)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable

	
//	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
//	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(100);

	
//	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)

#elif (LCD_MODEL == LCD_HD)

	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_6,0x1)	;		//Power on (SPI1_MISO)
	
	Delay(100);


	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable

	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_7,0x1)	;		//LED_EN (SPI1_MOSI)

	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	





#elif (LCD_MODEL == LCD_MIPIModule)

#else
	Assert(0);
#endif

	
}

//-----------------------------------------------------------------------------
// Function Name : LCDC_InitGpioMux
// Function Description : This function set GPIO to use FIMD
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitGpioMuxSel(u32 uLCDmodel,CPUIF_LDI eLdiMode)
{

if (uLCDmodel == LCD_LTS222Q_RGB || uLCDmodel == LCD_LTS222Q_SRGB || uLCDmodel == LCD_LTS222Q_SPI || uLCDmodel == LCD_LTS350Q1 || uLCDmodel==LCD_LTE480WV_RGB ||uLCDmodel== LCD_LTV350QV_RGB || uLCDmodel == LCD_TL2796 || uLCDmodel == LCD_SXGA)
{

	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High


/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/

/*
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
*/

	GPIO_SetFunctionEach(eGPIO_H1,eGPIO_0, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H1,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H1,eGPIO_0, 0x1);		// Reset High	

	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);


	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)

	
	/*
	Outp32(0xe0200120,0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	Outp32(0xe0200128,0x0);	//set pull-up,down disable
	Outp32(0xe0200140,0x22222222);	//set GPF1 as VD[11:4]
	Outp32(0xe0200148,0x0);	//set pull-up,down disable
	Outp32(0xe0200160,0x22222222);	//set GPF2 as VD[19:12]
	Outp32(0xe0200168,0x0);	//set pull-up,down disable
	Outp32(0xe0200180,0x00022222);	//set GPF3 as VD[23:20] 
	Outp32(0xe0200188,0x0);	//set pull-up,down disable

	Outp32(0xe02000A0,0x1000);	//set GPD0's TOUT3 as PWM_MIE signal
	Outp32(0xe02000A8,0x0);		//set pull-up,down disable


	// Reset
	Outp32(0xe02000A4,0x8);			// Reset High
	Delay(3);
	Outp32(0xe02000A4,0x0);			// Reset Low
	Delay(1);
	Outp32(0xe02000A4,0x8);			// Reset High


	
	Outp32(0xe0200040,0x11110000);	//set spi1 signal as output signal
	Outp32(0xe0200048,0x0);			//pull-up pull-down disable
	Delay(10);
	*/
}
 else if(uLCDmodel == LCD_LMS280GS01)

 	{

	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20]
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)


	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_6,0x1)	;		//Power on (SPI1_MISO)
	Delay(100);


	
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High


/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/

	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(100);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	


	
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)
 	}
	
 else if(uLCDmodel == LCD_LTM030DK)
 	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x22222222);	//set GPF1 as VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x22222222);	//set GPF2 as VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	//Set Control Back-Light Regulator Shotdown Pin
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x0);		// BL **LOW**
/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/

	//Reset LDI
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(10);	// 50ms delay
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(2);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	
//	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)
 	}

	
 else if (uLCDmodel == LCD_LTS222Q_CPU)
 	{

	GPIO_SetFunctionAll(eGPIO_F0, 0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x33333333);	//set GPF1 as SYS_VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x33333333);	//set GPF2 as SYS_VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00303333);	//set GPF3 as SYS_VD[23:20], SYS_OE
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0xcff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	

	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
/*     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/
	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High
	Delay(500);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x0);		// Reset Low
	Delay(500);
	GPIO_SetDataEach(eGPIO_H0,eGPIO_6, 0x1);		// Reset High	
	
//	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
//	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(100);
 	}
	
 else if (uLCDmodel == LCD_UF24U276A)
 	{

	GPIO_SetFunctionAll(eGPIO_F0, 0x33333333);	//set GPF0 as SYS_CS0,CS1,RS,WE,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x33333333);	//set GPF1 as SYS_VD[11:4]
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x33333333);	//set GPF2 as SYS_VD[19:12]
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00303333);	//set GPF3 as SYS_VD[23:20], SYS_OE
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0xcff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
	

	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_0, 0x1);	//set GPD0's TOUT3 as Output (IIC_SDA) signal
	GPIO_SetPullUpDownAll(eGPIO_D1,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D1,eGPIO_3, 0x1);		// BL High


/*
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as Output (LCD_BL) signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D0,eGPIO_3, 0x1);		// BL High
     // MIE 
	GPIO_SetFunctionEach(eGPIO_D0,eGPIO_3, 0x1);	//set GPD0's TOUT3 as PWM_MIE signal
	GPIO_SetPullUpDownAll(eGPIO_D0,0x0);			//set pull-up,down disable
*/
	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(10);

	GPIO_SetDataEach(eGPIO_B,eGPIO_6,0x1)	;		//Power on (SPI1_MISO)
	Delay(100);

	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_0, 0x1);	//set GPH0's GPH0CON[6] as XEINT6 (LCD_RESET)
	GPIO_SetPullUpDownEach(eGPIO_D1,eGPIO_0,0x0);			//set pull-up,down disable
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x1);		// Reset High
	Delay(10);
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x0);		// Reset Low
	Delay(500);
	GPIO_SetDataEach(eGPIO_D1,eGPIO_0, 0x1);		// Reset High	


	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_6, 0x0);	//set GPH0's GPH0CON[6] as Input(LCD_FLM)
	GPIO_SetPullUpDownAll(eGPIO_H0,0x0);			//set pull-up,down disable

	
//	GPIO_SetFunctionAll(eGPIO_B, 0x11110000);		//set GPB's spi1 signal as output signal
//	GPIO_SetPullUpDownAll(eGPIO_B,0x0);			//set pull-up,down disable
	Delay(100);
 	}
	
//	GPIO_SetFunctionEach(eGPIO_H0,eGPIO_5, 0x1);	//set GPH0's GPH0CON[5] as XEINT5 (for Interrupt test toggle)
	
 else
	Assert(0);
	
}




//-----------------------------------------------------------------------------
// Function Name : LCDC_InitGpioMux
// Function Description : This function set GPIO to use FIMD
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitGpioDualLCD(LCD_SEL_DLCD eSelLCD)
{

#if (LCD_MODEL == LCD_LTS222Q_RGB ||	LCD_MODEL == LCD_LTS222Q_SRGB ||	LCD_MODEL == LCD_LTS222Q_SPI ||	LCD_MODEL == LCD_LTS350Q1 ||	LCD_MODEL==LCD_LTE480WV_RGB||	LCD_MODEL==LCD_LTV350QV_RGB||	LCD_MODEL== LCD_TL2796||	LCD_MODEL == LCD_LMS280GS01||	LCD_MODEL == LCD_S6E63M0)

if ( eSelLCD == LCD_DUAL )
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable
	}	
else if (eSelLCD == LCD_A)
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] & no VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable	
	}
else
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22220222);	//set GPF0 as LVD_HSYNC,VSYNC,VDEN,VD[3:0] & no VCLK
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable		
	}
#elif(LCD_MODEL == LCD_LTM030DK)

if ( eSelLCD == LCD_DUAL )
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable
	}	
else if(eSelLCD == LCD_A)
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] & no VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable	
	}
else
	{
	GPIO_SetFunctionAll(eGPIO_F0, 0x22220222);	//set GPF0 as LVD_HSYNC,VSYNC,VDEN,VD[3:0] & no VCLK
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable		
	}

#elif (LCD_MODEL == LCD_LTS222Q_CPU)

#else
	Assert(0);
#endif

	
}

//-----------------------------------------------------------------------------
// Function Name : LCDC_InitGpioMux
// Function Description : This function set GPIO to use FIMD
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitGpioDualSel(u32 uLCDmodel,LCD_SEL_DLCD eSelLCD)
{

if (uLCDmodel == LCD_LTS222Q_RGB || uLCDmodel == LCD_LTS222Q_SRGB || uLCDmodel == LCD_LTS222Q_SPI || uLCDmodel == LCD_LTS350Q1 || uLCDmodel==LCD_LTE480WV_RGB || uLCDmodel==LCD_LTV350QV_RGB || uLCDmodel==LCD_TL2796 || uLCDmodel == LCD_LMS280GS01)
	{
	if ( eSelLCD == LCD_DUAL )
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable
		}	
	else if (eSelLCD == LCD_A)
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] & no VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable	
		}
	else
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22220222);	//set GPF0 as LVD_HSYNC,VSYNC,VDEN,VD[3:0] & no VCLK
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable		
		}
	}
 else if(uLCDmodel == LCD_LTM030DK)
 	{
	if ( eSelLCD == LCD_DUAL )
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable
		}	
	else if(eSelLCD == LCD_A)
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22222222);	//set GPF0 as LVD_HSYNC,VSYNC,VCLK,VDEN,VD[3:0]
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00002222);	//set GPF3 as VD[23:20] & no VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable	
		}
	else
		{
		GPIO_SetFunctionAll(eGPIO_F0, 0x22220222);	//set GPF0 as LVD_HSYNC,VSYNC,VDEN,VD[3:0] & no VCLK
		GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
		GPIO_SetFunctionAll(eGPIO_F3, 0x00022222);	//set GPF3 as VD[23:20] and VCLK_SUB
		GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable		
		}
 	}

else
	Assert(0);

	
}



//-----------------------------------------------------------------------------
// Function Name : LCDC_InitLdi
// Function Description : This function inits LDI case by defined LCD_MODEL
//					   Therefore, LCD_MODEL should be defined before to use this function
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitLdi(CPUIF_LDI eLdiMode)
{
	LCDM_InitLdi(LCD_MODEL,eLdiMode);
}



//-----------------------------------------------------------------------------
// Function Name : LCDC_InitLdiSel
// Function Description : This function inits LDI case by user selection in API
// Input : eLdiMode : MAIN = LDI0    ,   SUB = LDI1
//         uLCDmodel : LCD_MODEL type
// Output : none
// Version : v0.0
//-----------------------------------------------------------------------------
void LCDC_InitLdiSel(u32 uLCDmodel,CPUIF_LDI eLdiMode)
{
	
	LCDM_InitLdi(uLCDmodel,eLdiMode);
	if (gLCDM_INTERFACE_TYPE == I80_CPU);
	LcdcOutp32(VIDCON0, (eLdiMode == MAIN) ? VIDOUT_I80IF0 : VIDOUT_I80IF1);
	
}


void LCDC_InitStartPosOnLcd(CPUIF_LDI eLdiMode)
{
	u32 uVal[3];

#if (LCD_MODEL == LCD_LTS222Q_CPU)
	// Auto cmd. mode in CPU(i80) I/F
	uVal[0] = 0x4400;
	uVal[1] = 0x4200;
	uVal[2] = 0x4300;
	LCDC_PutCmdToLdi(uVal, 3, eLdiMode, LCD_AUTO_CMD);
#elif (LCD_MODEL == LCD_UF24U276A)
                                  
	LCDC_PutCmdToLdiByManual( 0x2A, eLdiMode); Delay(1);//(VCOMCTL)
	LCDC_PutDataToLdiByManual( ((0&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (0&0xff),eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( ((239&0xff00) >> 8),eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( (239&0xff),eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0x2B, eLdiMode); Delay(1);// (PWRCTL)
	LCDC_PutDataToLdiByManual( ((0&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (0&0xff),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( ((319&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (319&0xff),eLdiMode); Delay(1); 


#elif (LCD_MODEL == LCD_LTS350Q1 || LCD_MODEL==LCD_LTE480WV_RGB)
	return;
#else
	Assert(0);
#endif
}

void LCDC_InitStartPosLCDSel(u32 uLCDmodel,CPUIF_LDI eLdiMode)
{
	u32 uVal[3];

if (uLCDmodel == LCD_LTS222Q_CPU)
{
	// Auto cmd. mode in CPU(i80) I/F
	uVal[0] = 0x4400;
	uVal[1] = 0x4200;
	uVal[2] = 0x4300;
	LCDC_PutCmdToLdi(uVal, 3, eLdiMode, LCD_AUTO_CMD);
}
else if (uLCDmodel == LCD_UF24U276A)
{
	LCDC_PutCmdToLdiByManual( 0x2A, eLdiMode); Delay(1);//(VCOMCTL)
	LCDC_PutDataToLdiByManual( ((0&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (0&0xff),eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( ((239&0xff00) >> 8),eLdiMode); Delay(1);
	LCDC_PutDataToLdiByManual( (239&0xff),eLdiMode); Delay(1);
                                  
	LCDC_PutCmdToLdiByManual( 0x2B, eLdiMode); Delay(1);// (PWRCTL)
	LCDC_PutDataToLdiByManual( ((0&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (0&0xff),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( ((319&0xff00) >> 8),eLdiMode); Delay(1); 
	LCDC_PutDataToLdiByManual( (319&0xff),eLdiMode); Delay(1); 
}
else
	Assert(0);

}


// For LDI ==========================================================================================

// Normal way in CPU(i80) I/F

void LCDC_PutCmdToLdiByManual(u32 uData, CPUIF_LDI eLdiMode)
{
	u32 uMode = 0;
/*
#if (LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI ) 	
	; //No operation
#elif (LCD_MODEL == LCD_MIPIModule || LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL==LCD_S6D0139_CPU || LCD_MODEL == LCD_UF24U276A) 
*/
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	LcdcOutp32(SIFCCON0, uMode|0x01);   // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x03);  // ADDR(RS) = 3'b00, OE = 0, WE = 1, enable = 1
	LcdcOutp32(SIFCCON1, uData);   // Put Cmd
	LcdcOutp32(SIFCCON0, uMode|0x01);   // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x00); // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 0
/*
#else
	Assert(0);
#endif
*/
}

//Add by NSH for MIPI DSIM
void LCDC_PutPayLoad(u32 uData, CPUIF_LDI eLdiMode)
{
	u32 uMode = 0;
#if (LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI  || LCD_MODEL==LCD_LTS222Q_CPU ) 	
	; //No operation
#elif (LCD_MODEL == LCD_MIPIModule) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	LcdcOutp32(SIFCCON0, uMode|0x41);	// ADDR(RS) = 3'b10, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x43);	// ADDR(RS) = 3'b10, OE = 0, WE = 1, enable = 1
	LcdcOutp32(SIFCCON1, uData);			// Put Cmd
	LcdcOutp32(SIFCCON0, uMode|0x41);   // ADDR(RS) = 3'b10, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x00); // ADDR(RS) = 3'b00, OE = 0, WE = 0, enable = 0
#else
	Assert(0);
#endif

}


void LCDC_PutDataToLdiByManual(u32 uData, CPUIF_LDI eLdiMode)
{
	u32 uMode = 0;
/*
#if (LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI ) 	
	; //No operation
#elif(LCD_MODEL == LCD_MIPIModule || LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU || LCD_MODEL == LCD_UF24U276A)
*/
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	LcdcOutp32(SIFCCON0, uMode|0x61);	// ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x63);	// ADDR(RS) = 3'b11, OE = 0, WE = 1, enable = 1
	LcdcOutp32(SIFCCON1, uData);		// Put data
	LcdcOutp32(SIFCCON0, uMode|0x61);	// ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x00);	// OE = 0, WE = 0, enable = 0
/*
#else
		Assert(0);
#endif
*/
}

void LCDC_GetCmdFromLdiByManual(u32* uCmd, CPUIF_LDI eLdiMode )
{
	u32 uMode = 0;

#if ( LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI  ) 	
	; //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL == LCD_UF24U276A ) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	LcdcOutp32(SIFCCON0, uMode|0x01); // OE = 0, WE = 1, ADDR(RS) = 3'b00, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x05); // OE = 1, WE = 1, ADDR(RS) = 3'b00, enable = 1
	LcdcInp32(SIFCCON2, *uCmd); // get command
	LcdcOutp32(SIFCCON0, uMode|0x01); // OE = 0, WE = 1, ADDR(RS) = 3'b00, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x00); // OE = 0, WE = 0, ADDR(RS) = 3'b00, enable = 0
	LcdcOutp32(SIFCCON0, uMode|0x03); // OE = 0, WR = 1, ADDR(RS) = 3'b00, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x07); // OE = 1, WR = 1, ADDR(RS) = 3'b00, enable = 1
	LcdcInp32(SIFCCON2, *uCmd); // Get command
	LcdcOutp32(SIFCCON0, uMode|0x00);	// OE = 0, WE = 0, ADDR(RS) = 3'b00, enable = 0
#else
	Assert(0);
#endif
}

void LCDC_GetDataFromLdiByManual(u32* uData, CPUIF_LDI eLdiMode )
{
	u32 uMode = 0;

#if ( LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU ) 	
	; //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL == LCD_UF24U276A ) 
	uMode = (eLdiMode == MAIN)? 0x10: 0x8;	// CS
	LcdcOutp32(SIFCCON0, uMode|0x61); // ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x65); // ADDR(RS) = 3'b11, OE = 1, WE = 0, enable = 1
	LcdcInp32(SIFCCON2, *uData); // Get Data
	LcdcOutp32(SIFCCON0, uMode|0x61); // ADDR(RS) = 3'b11, OE = 0, WE = 0, enable = 1
	LcdcOutp32(SIFCCON0, uMode|0x00);	 // OE = 0, WE = 0, enable = 0
#else
	Assert(0);
#endif
}

// Max. of uDtaNum : 12
void LCDC_PutCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode)
{
	LCDC_PutDataOrCmdToLdi(uData, uDataNum, eLdiMode, eCmdMode, true);
}

void LCDC_PutDataToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode)
{
	LCDC_PutDataOrCmdToLdi(uData, uDataNum, eLdiMode, eCmdMode, false);
}

// if IsCmd == 1, put cmd to LDI
// else put data to LDI
void LCDC_PutDataOrCmdToLdi(u32 uData[], u32 uDataNum,
	CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode, bool bIsCmd)
{
	u32 uCmdCnt;
	u32 uCmdEnVal = 0;
	u32 uEnBit;
	u32 uRsVal=0;
	u32 uCmdBaseAddr;
	u32 uConRegAddr;
	u32 uConRegVal;
	u32 uRsBitVal;
	u32 j;

	Assert(0 < uDataNum <= 12);

	if (eCmdMode == LCD_NORMAL_CMD || eCmdMode == LCD_NORMAL_N_AUTO_CMD)
	{
		uConRegAddr = (eLdiMode == MAIN) ? I80IFCONB0 : I80IFCONB1;

		// check the LCD_NORMAL_CMD CMD START bit to zero
		while(true)
		{
			LcdcInp32(uConRegAddr, uConRegVal);
			if ( (uConRegVal&(1<<9)) == 0)
				break;
		}
	}

#if (LCD_MODEL==LCD_LTS350Q1 || LCD_MODEL==LCD_LTS222Q_RGB || LCD_MODEL==LCD_LTS222Q_SRGB || LCD_MODEL==LCD_LTE480WV_RGB || LCD_MODEL==LCD_LTS222Q_SPI || LCD_MODEL==LCD_S6D0139_CPU ) 	
	Assert(0); //No operation
#elif (LCD_MODEL==LCD_LTS222Q_CPU || LCD_MODEL == LCD_UF24U276A ) 
	uCmdBaseAddr = LDI_CMD0;
	uCmdCnt = 0;
	uEnBit = 
		(eCmdMode == LCD_NORMAL_CMD) ? 0x1 :
		(eCmdMode == LCD_AUTO_CMD) ? 0x2 : 0x3;
		
	for (j=0; j<uDataNum; j++)
	{
		// set enable bit
		uCmdEnVal |= uEnBit<<(2*uCmdCnt);

		uRsBitVal = (bIsCmd == true) ? 0x0 : 0x1;

		// set RS bit to 0
		uRsVal |= (uRsBitVal<<uCmdCnt);

		// set data
		LcdcOutp32(uCmdBaseAddr, uData[j]);
		uCmdBaseAddr += 0x4;
		uCmdCnt++;
	}
	
	LcdcOutp32(LDI_CMDCON0, uCmdEnVal);
	LcdcOutp32(LDI_CMDCON1, uRsVal);

	if (eCmdMode == LCD_NORMAL_CMD || eCmdMode == LCD_NORMAL_N_AUTO_CMD)
	{
		// start NORMAL COMMAND START
		LcdcOutp32(uConRegAddr, uConRegVal|(1<<9));
	}	
	
#else
	Assert(0);
#endif

}

void LCDC_SetRsOnOff(u32 uOnOff)
{
	u32 uI80CmdVal;

	Assert (uOnOff == 1 || uOnOff == 0);

	LcdcInp32(SIFCCON0, uI80CmdVal);

	uI80CmdVal |= (0x1<<0);		// manual command mode enable

	uI80CmdVal = (uOnOff == 0) ? uI80CmdVal&~(0x7<<5) : uI80CmdVal|(0x7<<5); // Rs signal control 1:high, 0:low 

	LcdcOutp32(SIFCCON0, uI80CmdVal);
}

// uLowHigh: 0 - Write, 1- Read
void LCDC_SetnWE(u32 uLowHigh)
{
	u32 uI80CmdVal;
	
	Assert (uLowHigh == 1 || uLowHigh == 0);

	LcdcInp32(SIFCCON0, uI80CmdVal);

	uI80CmdVal |= (0x1<<0);		// manual command mode enable

	uI80CmdVal = (uLowHigh == 0) ? uI80CmdVal&~(0x3<<1)|(1<<1) : uI80CmdVal&~(0x3<<1)|(0x1<<2);

	LcdcOutp32(SIFCCON0, uI80CmdVal);
}


void LCDC_GetLcdSz(u32* uLcdHSz, u32* uLcdVSz)
{
	*uLcdHSz = oLcdc.m_uLcdHSz;
	*uLcdVSz = oLcdc.m_uLcdVSz;
}

void LCDC_GetFrmSz(u32* uFrmHSz, u32* uFrmVSz, LCD_WINDOW eWin)
{
	*uFrmHSz = oLcdc.m_uFrmHSz[eWin];
	*uFrmVSz = oLcdc.m_uFrmVSz[eWin];
}

void LCDC_GetFbStAddr(u32* uFbAddr, LCD_WINDOW eWin) 
{ 
	*uFbAddr = oLcdc.m_uFbStAddr[eWin]; 
}

void LCDC_GetFbEndAddr(u32* uFbAddr, LCD_WINDOW eWin) 
{ 
	*uFbAddr = oLcdc.m_uFbEndAddr[eWin]; 
}

void LCDC_GetImgStAddr(u32* uImgStAddr, LCD_WINDOW eWin) 
{ 
	*uImgStAddr = oLcdc.m_uImgStAddr[eWin]; 
}

u32 LCDC_GetLineCount(void)
{
	u32 uVidConReg;
	
	LcdcInp32(VIDCON1, uVidConReg);
	uVidConReg = (uVidConReg >> 16) ;

	return uVidConReg;

}

void LCDC_InitIpForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin)
{
	LCDC_InitBase();
	LCDC_InitWinForFifoIn(eInLocal, eWin);
}

void LCDC_InitWinForFifoIn(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oLcdc.m_bFifoIn[eWin] = true;
	oLcdc.m_eLocalIn[eWin] = eLocalIn;
	LCDC_InitWin(RGB24, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, 0, 0, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, 0, 0, 0, eWin, false);
}

void LCDC_InitWinForFifoIn1(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oLcdc.m_bFifoIn[eWin] = true;
	oLcdc.m_eLocalIn[eWin] = eLocalIn;
	oLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	LCDC_InitWin(RGB24, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, 0, 0, oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, 0, 0, 0, eWin, false);
}

void LCDC_InitWinForFifoIn2(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS, u32 uLcdHsize, u32 uLcdVsize)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oLcdc.m_bFifoIn[eWin] = true;
	oLcdc.m_eLocalIn[eWin] = eLocalIn;
	oLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	LCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, 0, 0, 0, eWin, false);
}

void LCDC_InitWinForFifoIn3(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd)
{
	Assert(eLocalIn == IN_CIM || eLocalIn == IN_POST);

	oLcdc.m_bFifoIn[eWin] = true;
	oLcdc.m_eLocalIn[eWin] = eLocalIn;

	LCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, uX_Lcd, uY_Lcd, 0, eWin, false);
}


void LCDC_InitWinForFifoIn4 (LOCAL_IF_TYPE eLocalInCS, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd)
{
	Assert(eLocalInCS == LOCAL_IF_RGB24 || eLocalInCS == LOCAL_IF_YCBCR444);
	
	oLcdc.m_bFifoIn[eWin] = true;
	oLcdc.m_eLocalIn[eWin] = IN_POST;
	oLcdc.m_uLocalInColorSpace[eWin] = eLocalInCS;

	LCDC_InitWin(RGB24, uLcdHsize, uLcdVsize, 0, 0, uLcdHsize, uLcdVsize, uX_Lcd, uY_Lcd, 0, eWin, false);
}

void LCD_InitInt(LCDC_INT eLcdInt, LCDC_INT_SYS eLcdIntSys, LCDC_FIFO_LEVEL eFifoIntLevel, LCDC_FIFO_INT_SEL eFifoIntSel, LCDC_FRAME_INT_SEL eFIntSel )
{
	u32 uIntCtrl;

	LcdcInp32(VIDINTCON0, uIntCtrl);

	if (eLcdInt == LCDC_FIFO_INT)
	{
		uIntCtrl &= (~(0x7F<<5)) & (~(0x7<<2)) & (~INTFIFOEN_ENABLE);
				
		if (eFifoIntLevel == UNDER25)  			uIntCtrl = uIntCtrl |FIFOLEVEL_25; 
		else if (eFifoIntLevel == UNDER50)		uIntCtrl = uIntCtrl |FIFOLEVEL_50; 
		else if (eFifoIntLevel == UNDER75)		uIntCtrl = uIntCtrl |FIFOLEVEL_75; 
		else if (eFifoIntLevel ==  EMPTY)	uIntCtrl = uIntCtrl |FIFOLEVEL_EMPTY; 
		else if (eFifoIntLevel ==  FULL) 	uIntCtrl = uIntCtrl |FIFOLEVEL_FULL; 

		if(eFifoIntSel == FIFO_INT_WIN0)  		uIntCtrl = uIntCtrl |FIFOSEL_WIN0; 
		else if (eFifoIntSel == FIFO_INT_WIN1)	uIntCtrl = uIntCtrl |FIFOSEL_WIN1; 
		else if (eFifoIntSel == FIFO_INT_WIN2)	uIntCtrl = uIntCtrl |FIFOSEL_WIN2; 
		else if (eFifoIntSel == FIFO_INT_WIN3)	uIntCtrl = uIntCtrl |FIFOSEL_WIN3; 
		else if (eFifoIntSel == FIFO_INT_WIN4) 	uIntCtrl = uIntCtrl |FIFOSEL_WIN4; 

		uIntCtrl = uIntCtrl |INTFIFOEN_ENABLE;		
	}
	else if (eLcdInt == LCDC_FRAME_INT)
	{
		uIntCtrl &= (~(0x3<<15)) & (~(0x3<<13)) & (~INTFRMEN_ENABLE);
				
		if (eFIntSel == FINT_BACKPORCH )  		 uIntCtrl = uIntCtrl |FRAMESEL0_BACK; 
		else if (eFIntSel == FINT_VSYNC)		 uIntCtrl = uIntCtrl |FRAMESEL0_VSYNC; 
		else if (eFIntSel == FINT_ACTIVE)		 uIntCtrl = uIntCtrl |FRAMESEL0_ACTIVE; 
		else if (eFIntSel == FINT_FRONTPORCH)	 uIntCtrl = uIntCtrl |FRAMESEL0_FRONT; 

		uIntCtrl |= INTFRMEN_ENABLE;	
	}
	else if (eLcdInt ==  LCDC_SYSIF_INT)
	{
		uIntCtrl = uIntCtrl & (~(0x1<<19)) & (~(0x1<<18)) & (~I80IFDONE_ENABLE);
				
		if (eLcdIntSys == LCDC_SYSMAIN_INT)			
			uIntCtrl = uIntCtrl |SYSMAINCON_ENABLE; 
		else if (eLcdIntSys == LCDC_SYSSUB_INT)  	
			uIntCtrl = uIntCtrl |SYSSUBCON_ENABLE; 				

		uIntCtrl = uIntCtrl |I80IFDONE_ENABLE;	
	}

//	UART_Printf("\n VIDINTCON0: 0x%x  \n", uIntCtrl);	
	LcdcOutp32(VIDINTCON0, uIntCtrl);

	return;
}

// Full Win fifo UnderRun Check
void LCDC_EnableAllWinFifoLvlInt(LCDC_FIFO_LEVEL eFifoLvl)
{
	u32 uFifoLvl;
	u32 uFifoStatus;

	switch(eFifoLvl)
	{
		case UNDER25:
			uFifoLvl = 0<<2;
			break;
		case UNDER50:
			uFifoLvl = 0x1<<2;
			break;
		case UNDER75:
			uFifoLvl = 0x2<<2;
			break;
		case EMPTY:
			uFifoLvl = 0x3<<2;
			break;
		case FULL:
			uFifoLvl = 0x4<<2;
			break;
		default:
			Assert(0);
			break;
	}
	
 	LcdcInp32(VIDINTCON0, uFifoStatus);
	uFifoStatus |= ((0x73<<5) | uFifoLvl | 0x3); 
	LcdcOutp32(VIDINTCON0, uFifoStatus);
}
// Full Win fifo UnderRun Check


// Full Win fifo UnderRun Check
void LCDC_EnableAllWinFrameInt(LCDC_FRAME_INT_SEL eIntSel)
{
	u32 uFifoLvl;
	u32 uVidIntCon;
	u32 uIntSel;

	LcdcInp32(VIDINTCON0, uVidIntCon);

	switch(eIntSel)
	{
		case FINT_BACKPORCH:
			uIntSel = (1<<12)|(0<<15);
			break;
		case FINT_VSYNC:
			uIntSel = (1<<12)|(0x1<<15);
			break;
		case FINT_ACTIVE:
			uIntSel = (1<<12)|(0x2<<15);
			break;
		case FINT_FRONTPORCH:
			uIntSel = (1<<12)|(0x3<<15);
			break;
		case FINT_NONE:
			uIntSel = (0<<12);
			break;	
		default:
			Assert(0);
			break;
	}
	
	uVidIntCon |= ((0x73<<5) | uIntSel | 0x1); 
	LcdcOutp32(VIDINTCON0, uVidIntCon);
}

void LCDC_SetAllWinIntCnt(LCDC_FIFO_LEVEL eFifoLvl, LCDC_FRAME_INT_SEL eIntSel)
{
	u32 uFifoLvl;
	u32 uVidIntCon;
	u32 uIntSel;

	LcdcInp32(VIDINTCON0, uVidIntCon);

	switch(eFifoLvl)
	{
		case UNDER25:
			uFifoLvl = (1<<1)|(0<<2);
			break;
		case UNDER50:
			uFifoLvl = (1<<1)|(0x1<<2);
			break;
		case UNDER75:
			uFifoLvl = (1<<1)|(0x2<<2);
			break;
		case EMPTY:
			uFifoLvl = (1<<1)|(0x3<<2);
			break;
		case FULL:
			uFifoLvl = (1<<1)|(0x4<<2);
			break;
		default:
			Assert(0);
			break;
	}

	switch(eIntSel)
	{
		case FINT_BACKPORCH:
			uIntSel = (1<<12)|(0<<15);
			break;
		case FINT_VSYNC:
			uIntSel = (1<<12)|(0x1<<15);
			break;
		case FINT_ACTIVE:
			uIntSel = (1<<12)|(0x2<<15);
			break;
		case FINT_FRONTPORCH:
			uIntSel = (1<<12)|(0x3<<15);
			break;
		case FINT_NONE:
			uIntSel = (0<<12);
			break;	
		default:
			Assert(0);
			break;
	}
	
	uVidIntCon |= ((0x73<<5) | uIntSel | uFifoLvl | 0x1); 
	LcdcOutp32(VIDINTCON0, uVidIntCon);
}


void LCDC_DisableInterrupt(void)
{
	u32 uLcdcInt;

	LcdcInp32(VIDINTCON0, uLcdcInt);
	uLcdcInt &= (~INTEN_ENABLE);
	LcdcOutp32(VIDINTCON0, uLcdcInt);
}

void LCDC_EnableInterrupt(void)
{
	u32 uLcdcInt;

	LcdcInp32(VIDINTCON0, uLcdcInt);
	uLcdcInt |= INTEN_ENABLE;
//	uLcdcInt |= 0x1;
	LcdcOutp32(VIDINTCON0, uLcdcInt);
}


void LCDC_DisableIntFifoLevel(LCD_WINDOW eWin)
{
	u32 uFifoStatus;
	
 	LcdcInp32(VIDINTCON0, uFifoStatus);

	if(eWin == WIN0)
		uFifoStatus &=~ (0x1<<5);
	else if(eWin == WIN1)
		uFifoStatus &=~ (0x1<<6);
	else if(eWin == WIN2)
		uFifoStatus &=~ (0x1<<9);
	else if(eWin == WIN3)
		uFifoStatus &=~ (0x1<<10);
	else if(eWin == WIN4)
		uFifoStatus &=~ (0x1<<11);
	else
		Assert(0);
	
	LcdcOutp32(VIDINTCON0, uFifoStatus);
}

void LCDC_SetITUInterface(LCD_ITU_INTERLACE eITU_SEL)
{
	u32 uTemp0, uTemp1;
	u32 uVIDCONReg, uITUIFCON0reg, uVIDCON2reg;
	u32 uSPCONreg;

	uVIDCONReg = Inp32(LCDC_BASE+VIDCON0);
	uITUIFCON0reg = Inp32(LCDC_BASE+ITUIFCON0);
	uVIDCON2reg = Inp32(LCDC_BASE+VIDCON2);


	if(eITU_SEL == ITU_INTERLACE)
	uVIDCONReg = (uVIDCONReg & ~(0x1<<29) ) | VID_INTERLACE; // Interlace setting
	else
	uVIDCONReg = (uVIDCONReg & ~(0x1<<29) ) | VID_PROGRESSIVE; // progressive setting	

	
	uVIDCONReg = (uVIDCONReg & ~(0x3<<26) ) | (0x1<<26); // TV(ITU) Interface setting.
	uVIDCON2reg = (uVIDCON2reg &~(0x3<<22)) | (0x1<<23); // ITU601 setting
	uVIDCON2reg = (uVIDCON2reg &~(0x7<<12)) | (0x5<<12); // Software and YUV422 setting.
	
	UART_Printf("Select Interface ---- 1: Delay count mode ,  2: Field signal mode-----\n");
	uTemp0 = UART_GetIntNum();

	switch ( uTemp0 )
	{
		case 1: // Delay count mode
			UART_Printf("Input delay count num =\n");
			uTemp1 = UART_GetIntNum();
//			uVIDCONReg = (uVIDCONReg & ~(0x1<<29) ); // Progessive setting
			uITUIFCON0reg = ( uITUIFCON0reg & ~(0x1<<24) ) | (0x1<<24); // delayed vsync.
			uITUIFCON0reg = ( uITUIFCON0reg & ~(0xff<<16) ) | (uTemp1<<16); // delay count num setting.
			break;
		case 2: // Field signal mode
			uITUIFCON0reg = ( uITUIFCON0reg & ~(0x1<<24) ); // field signal mode
			uITUIFCON0reg = ( uITUIFCON0reg & ~(0xff<<16) ); // delay count num zero setting.
			break;
	}

	GPIO_SetFunctionAll(eGPIO_F0, 0x44444444);	//set GPF0 as VEN_HSYNC,VEN_VSYNC,VEN_HREF,V601_CLK,VEN_DATA0~3
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x4444);	//set GPF1 as VEN_DATA4~7
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x0);			//set GPF2 as input
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00400000);	//set GPF3 as VEN_FIELD
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable

	
	LcdcOutp32(VIDCON0, uVIDCONReg); // VIDCON reg setting.
	LcdcOutp32(ITUIFCON0, uITUIFCON0reg); // ITU Interface reg setting.
	LcdcOutp32(VIDCON2, uVIDCON2reg); // ITU Interface reg setting.		
}

void LCDC_SetITUInterface_656(LCD_ITU_INTERLACE eITU_SEL)
{
	u32 uTemp0, uTemp1;
	u32 uVIDCONReg, uITUIFCON0reg, uVIDCON2reg;
	u32 uSPCONreg;

	uVIDCONReg = Inp32(LCDC_BASE+VIDCON0);
	uITUIFCON0reg = Inp32(LCDC_BASE+ITUIFCON0);
	uVIDCON2reg = Inp32(LCDC_BASE+VIDCON2);

	if(eITU_SEL == ITU_INTERLACE)
	uVIDCONReg = (uVIDCONReg & ~(0x1<<29) ) | VID_INTERLACE; // Interlace setting
	else
	uVIDCONReg = (uVIDCONReg & ~(0x1<<29) ) | VID_PROGRESSIVE; // progressive setting	

	uVIDCONReg = (uVIDCONReg & ~(0x3<<26) ) | (0x1<<26); // TV(ITU) Interface setting.
	uVIDCON2reg = (uVIDCON2reg &~(0x3<<22)) | (0x1<<22); // ITU656 setting
	uVIDCON2reg = (uVIDCON2reg &~(0x7<<12)) | (0x5<<12); // Software and YUV422 setting. YUV 422 is valid at ITU 601, ITU656 format. YCBYCR Format Set
	
	uITUIFCON0reg = 0x0;
	uITUIFCON0reg = ( uITUIFCON0reg & ~(0x3<<8) ) | (0x0<<8); // V656_CLK active edge 0: normal, 1 : inverted
	uITUIFCON0reg = ( uITUIFCON0reg & ~(0x3<<8) ) | (0x0<<9); // polarity of F value 0: normal 1: inverted

	GPIO_SetFunctionAll(eGPIO_F0, 0x0);			//set GPF0 as input
	GPIO_SetPullUpDownAll(eGPIO_F0,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F1, 0x44440000);	//set GPF1 as V656_DATA0~3
	GPIO_SetPullUpDownAll(eGPIO_F1,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F2, 0x4444);		//set GPF2 as V656_DATA4~7
	GPIO_SetPullUpDownAll(eGPIO_F2,0x0);			//set pull-up,down disable
	GPIO_SetFunctionAll(eGPIO_F3, 0x00004000);	//set GPF3 as V656_CLK
	GPIO_SetPullUpDownAll(eGPIO_F3,0x0);			//set pull-up,down disable
/*
	GPIO_SetDSAll(eGPIO_F0,0xffffffff);			//set GPF0 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F1,0xffffffff);			//set GPF1 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F2,0xffffffff);			//set GPF2 drive strength max by WJ.KIM(09.07.17)
	GPIO_SetDSAll(eGPIO_F3,0x3ff);					//set GPF3 drive strength max by WJ.KIM(09.07.17)
*/

	LcdcOutp32(VIDCON0, uVIDCONReg); // VIDCON reg setting.
	LcdcOutp32(ITUIFCON0, uITUIFCON0reg); // ITU Interface reg setting.
	LcdcOutp32(VIDCON2, uVIDCON2reg); // ITU Interface reg setting.	
	
}

//////////////////////////////////////////////////////////////////////////
// 
#if 0

#if 1
#define LCD_IIC_SCL_HI()      GPIO_SetDataEach(eGPIO_D1, eGPIO_1, 0x1)
#define LCD_IIC_SCL_LO()      GPIO_SetDataEach(eGPIO_D1, eGPIO_1, 0x0)
#define LCD_IIC_SDA_HI()      GPIO_SetDataEach(eGPIO_D1, eGPIO_0, 0x1)
#define LCD_IIC_SDA_LO()      GPIO_SetDataEach(eGPIO_D1, eGPIO_0, 0x0)
#define DELAY_TEMP 10			//10ms
#else
#define LCD_IIC_SCL_HI()      GPIO_SetDataEach(eGPIO_H3, eGPIO_6, 0x1)
#define LCD_IIC_SCL_LO()      GPIO_SetDataEach(eGPIO_H3, eGPIO_6, 0x0)
#define LCD_IIC_SDA_HI()      GPIO_SetDataEach(eGPIO_H3, eGPIO_4, 0x1)
#define LCD_IIC_SDA_LO()      GPIO_SetDataEach(eGPIO_H3, eGPIO_4, 0x0)
#define DELAY_TEMP 10			//10ms
#endif


 void iic_gpio_ack()
{
	//ack
	LCD_IIC_SDA_LO();
	Delay(DELAY_TEMP); //should be 10ms

	LCD_IIC_SCL_LO();
	Delay(DELAY_TEMP);
	LCD_IIC_SCL_HI();
	Delay(DELAY_TEMP);
	LCD_IIC_SCL_LO();
	Delay(DELAY_TEMP);
}
void iic_write_serial(u8 data)
{
	int i;
	u8 bit;
		
	for( i = 0 ; i < 8 ; i++)
	{
		bit = (data>>(7-i))&1;
		if(bit)
			LCD_IIC_SDA_HI();
		else
			LCD_IIC_SDA_LO();
		Delay(DELAY_TEMP);

		LCD_IIC_SCL_LO();
		Delay(DELAY_TEMP);
		LCD_IIC_SCL_HI();
		Delay(DELAY_TEMP);
		LCD_IIC_SCL_LO();
		Delay(DELAY_TEMP);
	
	}

}
void iic_gpio_stop()
{
	//stop contidion
	LCD_IIC_SCL_LO();
	Delay(DELAY_TEMP);
	LCD_IIC_SDA_LO();
	Delay(DELAY_TEMP);

	LCD_IIC_SCL_HI();
	Delay(DELAY_TEMP);
	LCD_IIC_SDA_HI();
	Delay(DELAY_TEMP);
}
void iic_gpio_start()
{
	//start contidion
	LCD_IIC_SDA_HI();
	Delay(DELAY_TEMP);
	LCD_IIC_SCL_HI();
	Delay(DELAY_TEMP);

	LCD_IIC_SDA_LO();
	Delay(DELAY_TEMP);
	LCD_IIC_SCL_LO();
	Delay(DELAY_TEMP);

}

void iic_gpio_write(u8 slaveAddr, u8 regAddr, u8 data)
{
	Delay(DELAY_TEMP);
	Delay(DELAY_TEMP);
	
//	iic_gpio_stop();
//	iic_gpio_stop();

	iic_gpio_start();

	iic_write_serial(slaveAddr);
	iic_gpio_ack();

//	iic_gpio_start();

	iic_write_serial(regAddr);
	iic_gpio_ack();


	iic_write_serial(data);
	iic_gpio_ack();

	iic_gpio_stop();
}

void LCDC_SetALC(void)
{

	GPIO_SetFunctionEach(eGPIO_D1, eGPIO_0, 1);		//I2C0_SDA
	GPIO_SetFunctionEach(eGPIO_D1, eGPIO_1, 1);		//I2C0_SCL


/*
	GPIO_SetFunctionEach(eGPIO_H3,eGPIO_4, 0x1);	//I2C0_SDA
	GPIO_SetFunctionEach(eGPIO_H3,eGPIO_6, 0x1);	//I2C0_SDA
 */
 
	iic_gpio_write(0xec, 0x01, 0x11); 
	iic_gpio_write(0xec, 0x03, 0x3c); 
	iic_gpio_write(0xec, 0x08, 0x00); 


#if 0
	IIC_Open(400000);

    #if 0
	IIC_Write(0xec, 0x00, 0x1); // reset
	IIC_Write(0xec, 0x01, 0x7); // led, alc control pwm invalid
	IIC_Write(0xec, 0x03, 0x63); // 10 mA setting.
	IIC_Write(0xec, 0x08, 0x5);
//	IIC_Write(0xec, 0x08, 0x55);
	IIC_Write(0xec, 0x0b, 0x55);	
    #else
	IIC_Write(0xec, 0x01, 0x11); // reset
	IIC_Write(0xec, 0x03, 0x3c); // reset
	IIC_Write(0xec, 0x08, 0x00); // reset
    #endif
	
	IIC_Close();
#endif
}


void LCDC_SetGPIOFunctionForLts222QLdi(void)
{
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_5, 0x1); // CS
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_4, 0x1);	// CLK
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_7, 0x1);	// DATA 
}

void LCDC_SetGPIODataForLts222QLdi(u8 cData)
{
	volatile int i, j;

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x1); // CS high
	GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high

	for (j=0; j<4; j++);

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x0); // CS low

//	for (j=0; j<2; j++);
									
	for (i=7; i>=0; i--)
	{                                                               
		if (cData &  (1<<i))
		{      
			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x0); // CLK low
			GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x1); // DATA high

			for (j=0; j<2; j++);

			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high
			//GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x1); // DATA high	

			for (j=0; j<2; j++);
		}           

		else
		{                                                       
			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x0); // CLK low
			GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x0); // DATA low

			for (j=0; j<2; j++);

			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high
			//GPIO_SetDataEach(eGPIO_N, eGPIO_3, 0x0); // DATA low	

			for (j=0; j<2; j++);
		}
	}

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x0); // CS low

}


#endif



#if 0
void LCDC_InitItuBase(ITU_R_STANDARD eItu, u32 uFrameHsz, u32 uFrameVsz, SCAN_MODE eScanMode)
{
	u32 uVidconReg=0;
	u32 uLcdCon;

	oLcdc.m_bAutoBuf = false;
	oLcdc.m_uScanMode = (eScanMode==PROGRESSIVE) ? 0 : 1; // progressive mode
	oLcdc.m_bFifoIn = false;
	
	oLcdc.m_uLcdHSz = uFrameHsz;
	oLcdc.m_uLcdVSz = uFrameVsz;

	oLcdc.m_uDitherMode = RDITHPOS_5BIT|GDITHPOS_6BIT|BDITHPOS_5BIT;
	oLcdc.m_uDitherMode &= ~DITHERING_ENABLE;

	LcdcOutp32(VIDCON1, IVCLK_FALL_EDGE | IHSYNC_INVERT | IVSYNC_INVERT | IVDEN_NORMAL);
	LcdcOutp32(VIDTCON0, VBPDE(0) | VBPD(VBPD_LTS222Q) | VFPD(VFPD_LTS222Q) | VSPW(VSPW_LTS222Q));
	LcdcOutp32(VIDTCON1, VFPDE(0) | HBPD(HBPD_LTS222Q) | HFPD(HFPD_LTS222Q) | HSPW(HSPW_LTS222Q));
	LcdcOutp32(DITHMODE, oLcdc.m_uDitherMode); // Fixed Dithering Matrix
	LcdcOutp32(VIDTCON2, LINEVAL(oLcdc.m_uLcdVSz-1) | HOZVAL(oLcdc.m_uLcdHSz-1));

	//LCDC_Trigger();
	LCDC_Stop();

	// Check up LCD to turn off
	while (1)
	{
		LcdcInp32(VIDCON0, uLcdCon);
		if( (uLcdCon&0x03) == 0 )
		{
			break;
		}
	}

	LcdcOutp32(VIDINTCON0, FRAMESEL0_BACK | FRAMESEL1_NONE | INTFRMEN_DISABLE |
				FIFOSEL_WIN0 | FIFOLEVEL_25 | INTFIFOEN_DISABLE | INTEN_DISABLE);

	LCDC_SetAllWinOnOff(0); // Turn all windows off
	LCDC_SetAllWinColorMapOnOff(0); // Turn all windows color map off
	LCDC_SetAllWinColorKeyOnOff(0); // Turn all windows Color Key off
	LCDC_SetItuMode(eItu, eScanMode);

}

void LCDC_SetItuMode(ITU_R_STANDARD eItu, SCAN_MODE eScanMode)
{
	u32 uVidconReg=0;
	u32 uVidconReg0=0;
	u32 uVidconReg2=0;
	u32 uItuifconReg0=0;
	u32 uDlyVsync = 0x00;
	u32 uClkVal, uClkDir;
	
	LCDC_GetClkValAndClkDir(oLcdc.m_uLcdHSz, oLcdc.m_uLcdVSz, &uClkVal, &uClkDir);
	
	uVidconReg0 =
		VIDOUT_TV | SUB_16_MODE | MAIN_16_MODE | PNRMODE_RGB_P | CLKVALUP_ALWAYS |
		CLKVAL_F(uClkVal) |VCLKFREE_NORMAL | CLKDIR_F(uClkDir) |CLKSEL_F_HCLK |
		ENVID_DISABLE | ENVID_F_DISABLE;
	uVidconReg0 |= ((eScanMode==PROGRESSIVE) ? VID_PROGRESSIVE : VID_INTERLACE);
	LcdcOutp32(VIDCON0, uVidconReg0);

	if (eItu==BT601)
	{
		uVidconReg2 = EN601_ENABLE|TVFORMATSEL0_SW|TVFORMATSEL1_YUV422|ORGYCBCR_YCBCR;
	}
	else if(eItu==BT656)
	{
		uVidconReg2 = EN656_ENABLE|TVFORMATSEL0_SW|TVFORMATSEL1_YUV422|ORGYCBCR_YCBCR;
	}
	else
	{
		Assert(0);
	}
	
	LcdcOutp32(VIDCON2, uVidconReg2);
	LcdcOutp32(ITUIFCON, uItuifconReg0);
}

void LCDC_InitStartPosOnLcdI80If(CPUIF_LDI eLdiMode)
{
	u32 uVal[3];
	
#if (LCD_MODEL == LCD_LTS222Q_CPU || LCD_MODEL == LCD_S6D0139_CPU)
	// Auto cmd. mode in CPU(i80) I/F
	uVal[0] = 0x4400;
	uVal[1] = 0x4200;
	uVal[2] = 0x4300;
	LCDC_PutCmdToLdi(uVal, 3, eLdiMode, LCD_AUTO_CMD);
	
#elif (LCD_MODEL == LCD_LTS350Q1)

#else
	Assert(0);
#endif
}
#endif



