/*----------------------------------------------------------------------
 *
 * Filename: lcd_test.c
 *
 * Contents: Implemention of "FIMD5.0"
 *
 * Abbreviations: 
 *
 * Persons Involved:
 *
 * Notes:
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 *
 *----------------------------------------------------------------------
 */

#include "system.h"
#include "sysc.h"
#include "util.h"
#include "lcd.h"
#include "fimc.h"
#include "lcd_GammaLUT.h"
#include "ALPS_3DLUT_090206.h"
#include "intc.h"
#include "glib.h"
#include "mfc.h"
#include "option.h"
#include "library.h"
#include "def.h"
#include "timer.h"
#include "Lcd_loadfile_list.h"


//#include "post.h"
//#include "post_conditions.h"
//#include "sun240320_16bpp.h"
//#include "sun240320_24bpp.h"
//#include "sun320240_16bpp.h"
#include "sun320240_24bpp.h"


// select bpp
static u32 uBppNum, uSelWin;
static u32 uBytes, uBits;

static LCD_WINDOW eBgWin, eFgWin, eFg1Win,eFg2Win,eFg3Win;
static LCD_WINDOW eFgWinArray[4], eBg1Win;
static LCDC_INT_SYS 	eLcdCpuifInt;
static IMG_FMT eBgBpp;
static IMG_FMT eFgBpp, eFgArgbBpp;
static IMG_FMT ePalDataBpp, ePalBpp;
static IMG_FMT eWinBpp[5];
static IMG_FMT eFgBppArray[4];
static IMG_FMT eVpImgType;
static ITU_R_STANDARD eMode;
static ALPHA_SEL eAlphaCh;

static bool bIsArgb = false;
static bool bIsRev = false;
static bool bIsAllWin = false;
static u32 uPalFlag;
static bool uPOSTDoneIssue = 0; 
static bool WinStopIssue = 0;
static u32 uCount;
static u32	uLine[100];

const static u32 uLcdFbAddr = CODEC_MEM_ST;
const static u32 uBMPSrcAddr = CODEC_MEM_ST+0x1000000;

const static char *pALPSTest_Image[24] =		{	
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/01.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/02.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/03.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/04.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/05.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/06.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/07.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/08.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/09.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/10.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/11.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/12.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/13.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/14.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/15.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/16.bmp",											
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0016.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0017.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0018.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0019.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0020.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0021.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0022.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/DCAM0023.bmp"
};


const static char *pDitherTest_Image[24] =		{	
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/dither_sky_sample16to24.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/dither_sky_sample.bmp",		
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/YUV420_to_RGB16.rgb16",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/ALPS_img/YUV420_to_RGB24.rgb24"
};


const static char *pWVGATest_Image[30] =			{	
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/bear.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment1.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment10.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment11.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment12.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment13.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment14.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment15.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment2.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment3.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment4.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment5.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment6.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment7.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment8.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/entertainment9.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate1.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate2.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate3.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate4.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate5.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate6.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate7.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate8.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/Illustrate9.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/smurf.bmp"
										};

const static char *pWVGATestp_Image[30] =			{	
"D:/00_Work/99_Study/FIMD/Test_IMGs/WVGA_img/testimg_WV_p.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_top_480.bmp",
"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_bottom_480.bmp"
										};



const static char *pDualTest_Image[13] =			{	
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/320_480.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/320_240.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_top.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_bottom.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/frame_800_960.bmp",	
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/frame2_800_960.bmp",		
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/Browser_800_960.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_top_480.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/browser_bottom_480.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/Browser_960_800.bmp"	,
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/Browser_480_1600.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/keyboard.bmp",	
	"D:/00_Work/99_Study/FIMD/Test_IMGs/DUAL_img/img_qvga_p.bmp"
										};


const static char *pDualDemo_Image[6] =			{	

/*
	"C:/Dual_Demo/Browser_800_960.bmp",
	"C:/Dual_Demo/keyboard.bmp",
	"C:/Dual_Demo/broken_iphone.bmp",
	"C:/Dual_Demo/apple_knife2.bmp",
	"C:/Dual_Demo/apple.bmp",
	"C:/Dual_Demo/apple_cut.bmp"	
*/	


	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/Browser_800_960.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/keyboard.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/broken_iphone.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/apple_knife2.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/apple.bmp",
	"D:/00_Work/99_Study/FIMD/Test_IMGs/Dual_Demo_img/apple_cut.bmp"	
	
										};


void LCD_Test(void);

void InitSysconForFIMD(void)
{
	// T-Block Power Off and On
	SYSC_SetBlockPowerOFF_IP(eFIMD);
	DelayfrTimer(milli, 100);
	SYSC_SetBlockPowerON_IP(eFIMD);

	// IP Clock Off and On
	SYSC_SetClkOFF_IP(eFIMD);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eFIMD);
}


void __irq Isr_LcdcUnderRun (void)
{
	u32 uIntFlag;

//	INTC_Disable(INT_LCD1);
//	LCDC_DisableInterrupt();

	LCDC_GetIntFlag(&uIntFlag);
	
	Disp("[FIFO UnderRun]\n");

	LCDC_ClearPending(uIntFlag);
	
	INTC_ClearVectAddr();	

//	INTC_Enable(INT_LCD1);
//	LCDC_EnableInterrupt();
}

__irq static void Isr_LcdcFifoLvlInt(void)
{
	u32 uIntFlag;

	LCDC_GetIntFlag(&uIntFlag);
	uLine[uCount] = LCDC_GetLineCount();
	uCount++;
	LCDC_ClearPending(uIntFlag);
	INTC_ClearVectAddr();	
}

  
void __irq Isr_InterruptHandler(void)
{
	Disp("[P]");
	if ( uPOSTDoneIssue == 1 ) 
	{
//		POST_StopAudoLoad();
		WinStopIssue = 1; 
 	}	
}
 void __irq Isr_LCD_I80Int(void)
 {
	u32 uIntFlag;

	
	INTC_Disable(NUM_LCD2);
	LCDC_DisableInterrupt();

	UART_Printf("\n I80 Interrupt Routine. \n");

	uCount++;

	LCDC_WTrigger(eBgWin);
	LCDC_GetIntFlag(&uIntFlag);
	LCDC_ClearPending(uIntFlag);
	INTC_ClearVectAddr();
	
	INTC_Enable(NUM_LCD2);
	LCDC_EnableInterrupt();

 }	
  
void __irq Isr_LcdcFrameInt(void) 
 {
	u32 uIntFlag;

	Disp("[FRAME]");
	INTC_Disable(NUM_LCD1);
	LCDC_DisableInterrupt();

	LCDC_GetIntFlag(&uIntFlag);
	LCDC_ClearPending(uIntFlag);

	INTC_ClearVectAddr();

	GPIO_SetDataEach(eGPIO_D0,eGPIO_2, 0x0);		// pwm_TOUT3 as Output Data Low
	Delay(5);
	GPIO_SetDataEach(eGPIO_D0,eGPIO_2, 0x1);		// Data High

	if (WinStopIssue == 1)
	{
		LCDC_SetWinOnOff(0, WIN0);
		LCDC_Stop();

	}
		
	INTC_Enable(NUM_LCD1);
	LCDC_EnableInterrupt();
}


/*
// make src image
static void GenerateSourceImage(POST_COLOR_FORMAT format,int width,int height)
{
	int i;
	u32 *tmp;
	u32 *tmp2;
	u32 *y;
	u32 *cb;
	u32 *cr;
	POST_CONDITION condition;
	unsigned long long *tmp1;
	unsigned long long TEMP_BUF[240*320];

	y=(u32 *)SRC_Y_ADDR;
	cb=(u32 *)SRC_Cb_ADDR;
	cr=(u32 *)SRC_Cr_ADDR;
	
	tmp1 = (unsigned long long *)TEMP_BUF;

	tmp = (u32 *)tmp1;
	for(i=0;i<240*320;i++)
	{
		tmp[i] = sun240320_24bpp[i];
		y[i]=0;
		cb[i]=0;
		cr[i]=0;
	}
		
	POST_getDefaultPostCondition(&condition);
	condition.src = POST_COLOR_FORMAT_RGB888;
	condition.dst = format;
	condition.InAddr.Y = (u32)tmp;
	condition.OutAddr1.Y = SRC_Y_ADDR;
	condition.OutAddr1.Cb = SRC_Cb_ADDR;
	condition.OutAddr1.Cr = SRC_Cr_ADDR;
	condition.OutAddr2.Y = SRC_Y_ADDR;
	condition.OutAddr2.Cb = SRC_Cb_ADDR;
	condition.OutAddr2.Cr = SRC_Cr_ADDR;
	condition.OutAddr3.Y = SRC_Y_ADDR;
	condition.OutAddr3.Cb = SRC_Cb_ADDR;
	condition.OutAddr3.Cr = SRC_Cr_ADDR;
	condition.OutAddr4.Y = SRC_Y_ADDR;
	condition.OutAddr4.Cb = SRC_Cb_ADDR;
	condition.OutAddr4.Cr = SRC_Cr_ADDR;
	condition.runMode = ONE_SHOT;
	condition.srcOriginalImageWidth=240;
	condition.srcOriginalImageHeight =320;
	condition.srcImageWidth= 240;
	condition.srcImageHeight=320;
	condition.dstScreenWidth = width;
	condition.dstScreenHeight=height;
	condition.dstImageWidth=width;
	condition.dstImageHeight=height;
	POST_SetCondition(condition);
	POST_DoConverting();
	POST_WaitConverting();
}
*/


static void SetRgbBpp(void)
{
	u32 uSelBpp;

	while (true)
	{
		Disp("[0] Exit\n");
		Disp("[1] RGB16 bpp (R:5 G:6 B:5)\n");
		Disp("[2] RGB24 bpp (R:8 G:8 B:8)\n");

		Disp("\n");
		Disp("> Select Background's Bpp: ");
		uSelBpp = UART_GetIntNum();

		if (uSelBpp == 0)
		{
			return;
		}
		else if (uSelBpp >= 1 && uSelBpp <= 2)
		{
			eBgBpp =  (uSelBpp == 1) ? RGB16 : RGB24;

			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}

	Disp("\n");

	while (true)
	{
		Disp("[0] Exit\n");
		Disp("[1] RGB16 bpp (R:5 G:6 B:5)\n");
		Disp("[2] RGB24 bpp (R:8 G:8 B:8)\n");
		Disp("[3] 1 bpp (Palette)\n");
		Disp("[4] 2 bpp (palette)\n");
		Disp("[5] 4 bpp (Palette)\n");
		Disp("[6] 8 bpp (Palette)\n");

		Disp("\n");
		Disp("> Select Foreground's Bpp: ");
		uSelBpp = UART_GetIntNum();

		if (uSelBpp == 0)
		{
			return;
		}
		else if (uSelBpp >= 1 && uSelBpp <= 2)
		{
			eFgBpp = (uSelBpp == 1) ? RGB16 : RGB24;

			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}
}

static void SetWinOfFgAndBg(void)
{
	u32 uBgWinSel, uFgWinSel;
	bool bIsBgExit = false;
	bool bIsFgExit = false;

	while (true)
	{
		while(true)
		{
			Disp("[0] Exit\n");
			Disp("[1] WINDOW 0\n");
			Disp("[2] WINDOW 1\n");
			Disp("[3] WINDOW 2\n");
			Disp("[4] WINDOW 3\n");
			Disp("[5] WINDOW 4\n");

			Disp("\n");
			Disp(">>Select Window Number Used For BACKGROUND: ");
			uBgWinSel = UART_GetIntNum();

			if (uBgWinSel == 0)
			{
				return;
			}
			else if (uBgWinSel >= 1 && uBgWinSel <= 5)
			{
				eBgWin =
					(uBgWinSel == 1) ? WIN0 :
					(uBgWinSel == 2) ? WIN1 :
					(uBgWinSel == 3) ? WIN2 :
					(uBgWinSel == 4) ? WIN3 : WIN4;

				bIsBgExit = true;
				break;
			}
			else
			{
				Disp("Invalid Input! Retry It!!\n");
			}
		}

		Disp("\n");

		while(true)
		{
			Disp("[0] Exit\n");
			Disp("[1] WINDOW 1\n");
			Disp("[2] WINDOW 2\n");
			Disp("[3] WINDOW 3\n");
			Disp("[4] WINDOW 4\n");

			Disp("\n");
			Disp(">>Select Window Number Used For FOREGROUND: ");
			uFgWinSel = UART_GetIntNum();

			if (uFgWinSel == 0)
			{
				return;
			}
			else if (uFgWinSel >= 1 && uFgWinSel <= 4)
			{
				eFgWin =
					(uFgWinSel == 1) ? WIN1 :
					(uFgWinSel == 2) ? WIN2 :
					(uFgWinSel == 3) ? WIN3 : WIN4;

				bIsFgExit = true;
				break;
			}
			else
			{
				Disp("Invalid Input! Retry It!!\n");
			}
		}

		if ( (bIsBgExit == true || bIsFgExit == true) && ((int)eBgWin < (int)eFgWin) )
		{
			break;
		}

		if ((int)eBgWin >= (int)eFgWin)
		{
			Disp("Win. Num. Correspond To Foreground Must Be Larger Than That Of Background!\n");
			Disp("\n");
		}
	}
}

static void SetPaletteBppAndWin(void)
{
	u32 uSelPalDataBpp, uSelPalBpp;
	u32 uSelWin;

	while (true)
	{
		Disp("[0] Exit\n");
		Disp("[1] WIN 0\n");
		Disp("[2] WIN 1\n");
		Disp("[3] WIN 2\n");
		Disp("[4] WIN 3\n");
		Disp("[5] WIN 4\n");

		Disp(">>Select Window Number: ");

		uSelWin = UART_GetIntNum();

		if (uSelWin == 0)
		{
			return;
		}
		else if (uSelWin >= 1 && uSelWin <= 5)
		{
			eBgWin =
				(uSelWin == 1) ? WIN0 :
				(uSelWin == 2) ? WIN1 :
				(uSelWin == 3) ? WIN2 :
				(uSelWin == 4) ? WIN3 :	WIN4;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
		Disp("\n");
	}

	Disp("\n");

	while (true)
	{
		Disp("[0] Exit\n");
		Disp("[1] Palette 1Bpp\n");
		Disp("[2] Palette 2Bpp\n");
		Disp("[3] Palette 4Bpp\n");
		Disp("[4] Palette 8Bpp\n");
		
		Disp(">>Select Palette Bpp: ");

		uSelPalBpp = UART_GetIntNum();

		if (uSelPalBpp == 0)
		{
			return;
		}
		else if ( uSelPalBpp >= 1 && uSelPalBpp <= 4)
		{
			ePalBpp =
					(uSelPalBpp == 1) ? PAL1 :
					(uSelPalBpp == 2) ? PAL2 :
					(uSelPalBpp == 3) ? PAL4 : PAL8;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}

		Disp("\n");
	}

	Disp("\n");

	while (true)
	{
		Disp("[0] Exit\n");
		Disp("[1] RGB 16Bpp (R:5 G:6 B:5)\n");
		Disp("[2] RGB 24Bpp (R:8 G:8 B:8)\n");

		Disp(">>Select Data Bpp Of Palette: ");
		
		uSelPalDataBpp = UART_GetIntNum();

		if (uSelPalDataBpp == 0)
		{
			return;
		}
		else if (uSelPalDataBpp >= 1 && uSelPalDataBpp <= 2)
		{
			ePalDataBpp = (uSelPalDataBpp == 1) ? RGB16 : RGB24;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}
}

static void SetArgbBpp(void)
{
	u32 uBgBpp, uSelFgArgb;

	while (true) // Set Background's Bpp
	{
		Disp("[0] Exit\n");
		Disp("[1] RGB16 Bpp (R:5 G:6 B:5)\n");
		Disp("[2] RGB24 Bpp (R:8 G:8 B:8)\n");

		Disp("\n");
		Disp("> Select Background's Bpp: ");
		uBgBpp = UART_GetIntNum();

		if (uBgBpp == 0)
		{
			return;
		}
		else if (uBgBpp >= 1 && uBgBpp <=2)
		{
			eBgBpp = (uBgBpp == 1) ? RGB16 : RGB24;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}

	Disp("\n");

	while(true) // Set Foreground's Bpp
	{
		Disp("[0] Exit\n");
		Disp("[1] ARGB 16Bpp (A:1 R:5 G:5 B:5)\n");
		Disp("[2] ARGB 24Bpp (A:1 R:8 G:8 B:7)\n");
		Disp("(\'A\' means ALPHA VALUE when PER-PIXEL BLENDING is tested)\n");
		Disp("This selection is applied for only PER-PIXEL BLENDING test\n");
		Disp("\n");

		Disp("> Select Foreground's Bpp: ");

		uSelFgArgb = UART_GetIntNum();

		if (uSelFgArgb == 0)
		{
			return;
		}
		else if (uSelFgArgb >= 1 && uSelFgArgb <= 2)
		{
			eFgArgbBpp = (uSelFgArgb == 1) ? ARGB16 : ARGB24;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}
}


static void TestRGBBasicDisplay(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;

	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);

	// 1. Set background
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);

	LCDC_Start();
	
	UART_Getc();

	LCDC_Stop();
	

}


static void TestSimpleDisplay(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;

	bIsRev = false;
	bIsAllWin = false;


	Disp("Select Background WINDOW\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	eBgWin=(LCD_WINDOW) UART_GetIntNum();
	Disp("\n");
	Disp("Select Foreground WINDOW\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	eFgWin=(LCD_WINDOW) UART_GetIntNum();
	Disp("\n");
	Disp("Enter Any Key To Test Simple Display\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);

	// 1. Set background
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
	LCDC_Start();	
	LCDC_WTrigger(eBgWin);
	
	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();

	// 2. Set foreground
	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	60, 80, uFgAddr, eFgWin, false); 	
	
	GLIB_InitInstance(uFgAddr, uHSz/2, uVSz/2, eFgBpp);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Foreground) Is Displayed\n", (int)eFgWin);
	LCDC_WTrigger(eFgWin);

	Disp("Enter Any Key To Test Case Which Img. Size Is Smaller\n");
	Disp("Than LCD Size In One Window\n");
	UART_Getc();

	// Test case in which img. size is smaller than LCD size in one window.
	LCDC_SetAllWinOnOff(0);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	60, 80, uFgAddr, eBgWin, false); 	
		
	GLIB_InitInstance(uLcdFbAddr, uHSz/2, uVSz/2, eBgBpp);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	LCDC_WTrigger(eBgWin);
}

static void TestFifoUnderRun(void)
{
	u32 uFgAddr,uWin1Addr,uWin2Addr,uWin3Addr,uWin4Addr;
	u32 uHSz, uVSz;
	u32 uTime;
	u32 uCnt;
	IMG_FMT eBgBpp = RGB24;
	IMG_FMT eFgBpp = RGB24;	
	LCDC_FIFO_LEVEL eIntLvl;
	bIsRev = false;
	bIsAllWin = false;

	uCount = 0;
	for(uCnt = 0; uCnt < 100 ; uCnt++)
	{
		uLine[uCnt] = 0;
	}
	Disp("Enter Any Key To Test Fifo Under-run Interrupt\n");
	UART_Getc();


	Disp("[0] 0~25% \n");
	Disp("[1] 0~50% \n");
	Disp("[2] 0~75% \n");	
	Disp("[3] Empty \n");
	Disp("[4] Full \n");		
	Disp("Select Fifo Level Interrupt : ");
	eIntLvl = (LCDC_FIFO_LEVEL)UART_GetIntNum();
	Disp("\n");		
	INTC_Init();
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcFifoLvlInt);
	INTC_Enable(NUM_LCD0);


	LCDC_InitLdi(MAIN);

	// 1. Set WIN0
	LCDC_InitIp(eBgBpp, uLcdFbAddr, WIN0, false);	// For WIN0
	LCDC_GetFrmSz(&uHSz,&uVSz,WIN0);
	LCDC_EnableAllWinFifoLvlInt(eIntLvl);

	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN0);
	LCDC_Trigger();
	
	Disp("Window 0\n");
	UART_Getc();

	// 2. Set WIN1
	LCDC_GetFbEndAddr(&uWin1Addr, WIN0);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uWin1Addr, WIN1, false); 
	GLIB_InitInstance(uWin1Addr, uHSz, uVSz, eBgBpp);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_ClearFrame(C_WHITE);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN1);
	LCDC_Trigger();

	Disp("Window 1\n");
	UART_Getc();

	// 3. Set WIN2
	LCDC_GetFbEndAddr(&uWin2Addr, WIN1);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,0, 0, uWin2Addr, WIN2, false); 	

	GLIB_InitInstance(uWin2Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern2(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN2);
	LCDC_Trigger();

	Disp("Window 2\n");
	UART_Getc();

	// 4. Set WIN3
	LCDC_GetFbEndAddr(&uWin3Addr, WIN2);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uWin3Addr, WIN3, false); 	
	
	GLIB_InitInstance(uWin3Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN3);
	LCDC_Trigger();

	Disp("Window 3\n");
	UART_Getc();
	
	// 5. Set WIN4
	LCDC_GetFbEndAddr(&uWin4Addr, WIN3);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uWin4Addr, WIN4, false); 	

	GLIB_InitInstance(uWin4Addr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern2(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", WIN4);
	LCDC_Trigger();

	Disp("Window 4\n");

	LCDC_Start();

//	DelayfrTimer(milli,5000);
//	Disp("%d time Interrupt occured in 5 second\n",uCount);


	StartTimer(2);
	while(uCount < 100);
	uTime = StopTimer(2);
	Disp("1000 time Interrupt occured in %d micro second\n",uTime);

	for(uCnt = 0;uCnt<100;uCnt++)
		{
	Disp("%d Interrupt occured at  %d Line\n",uCnt,uLine[uCnt]);
		}
	
	Disp("Press any key to stop Underrun Interrupt Test \n");
	UART_Getc();



	LCDC_Trigger();
	INTC_Disable(NUM_LCD0);
	LCDC_Stop();
	
}



static void TestPerFrameDirect(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	u8 cGetc;
	

	bIsRev = false;
	bIsAllWin = false;

	GPIO_Init();
	GPIO_SetFunctionEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output to test Interrupt
	GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output data High



	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
	LCDC_Start();	
	LCDC_WTrigger(WIN0);

	Disp("### This is the test to check Perframe off and Direct off, Please use Oscilloscope to see VCLK and VSYNC signal###\n");
	Disp("Press 'z' key to test Perframe off \nPress 'x' key to test Direct off\nPress 'c' key to start\nPress Enter key to stop test\n");

	while(1)
		{
		cGetc = UART_Getc();
		switch(cGetc)
			{
			case 'z' : LCDC_PerFrameOff();
					 GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x0);	//PWM_TOUT2 AS Output data High
					 Delay(100);
					 GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output data High
					 LCDC_Start();
					 break;

			case 'x' : LCDC_Stop();
					 GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x0);	//PWM_TOUT2 AS Output data High
					 Delay(100);
					 GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output data High
					 LCDC_Start();
					 break;

			case 'c' : LCDC_Start();
					 break;

			case '\r' : break;
			}
		if(cGetc == '\r')
			break;
		}

	LCDC_Stop();
	
}

void TestFrameInt(void)
{
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	LCDC_FRAME_INT_SEL	uFrInt;
	
	bIsRev = false;
	bIsAllWin = false;

	INTC_Init();
	INTC_SetVectAddr(NUM_LCD1, Isr_LcdcFrameInt);
	INTC_Enable(NUM_LCD1);

	GPIO_Init();
	GPIO_SetFunctionEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output to test Interrupt
	GPIO_SetDataEach(eGPIO_D0, eGPIO_2,0x1);	//PWM_TOUT2 AS Output data High


	LCDC_InitLdi(MAIN);

	// 1. Set background
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
	LCDC_Start();	
	LCDC_Trigger();

	uFrInt = FINT_NONE;
	LCDC_EnableAllWinFrameInt(uFrInt);
	
	
	Disp("Enter Any Key To Test FINT_BACKPORCH Interrupt\n");
	UART_Getc();

	uFrInt = FINT_BACKPORCH;
	LCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_BACKPORCH \n");



	Disp("Enter Any Key To Test FINT_VSYNC Interrupt\n");
	UART_Getc();

	uFrInt = FINT_VSYNC;
	LCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_VSYNC \n");


	Disp("Enter Any Key To Test FINT_ACTIVE(VDEN) Interrupt\n");
	UART_Getc();

	uFrInt = FINT_ACTIVE;
	LCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FINT_ACTIVE(VDEN) signal \n");



	Disp("Enter Any Key To Test FRONT_PORCH Interrupt\n");
	UART_Getc();

	uFrInt = FINT_FRONTPORCH;
	LCDC_EnableAllWinFrameInt(uFrInt);
	Disp("Check ENIT5 signal with FRONT_PORCH signal \n");
	UART_Getc();
	

	INTC_Disable(NUM_LCD1);


}

void TestRGBOrder(void)
{
	u32 uHSz;
	u32 uVSz;
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_SetRGBOrder(RGB,RGB); //	RGB, GBR, BRG, BGR, RBG, GRB
	LCDC_Start();

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	Disp("Start RGB order test---------------------\n");

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//100 001 010 011 110 101 000 111
	Disp("Enter anykey to set RBG.\n");
	Disp("[RED][BLUE][GREEN][CYAN][YELLOW][MAGENTA][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(RBG,RBG);

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//001 100 010 110 011 101 000 111
	Disp("Enter anykey to set GBR.\n");
	Disp("[BLUE][RED][GREEN][YELLOW][CYAN][MAGENTA][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(GBR,GBR);

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//010 001 100 101 110 011 000 111
	Disp("Enter anykey to set BRG.\n");
	Disp("[GREEN][BLUE][RED][MAGENTA][YELLOW][CYAN][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(BRG,BRG);

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//001 010 100 110 101 011 000 111
	Disp("Enter anykey to set BGR.\n");
	Disp("[BLUE][GREEN][RED][YELLOW][MAGENTA][CYAN][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(BGR,BGR);

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//100 001 010 011 110 101 000 111
	Disp("Enter anykey to set RBG.\n");
	Disp("[RED][BLUE][GREEN][CYAN][YELLOW][MAGENTA][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(RBG,RBG);

	// R   G   B   C    M    Y   Black W
	//100 010 001 011 101 110 000 111
	//010 100 001 101 011 110 000 111
	Disp("Enter anykey to set GRB.\n");
	Disp("[GREEN][RED][BLUE][MAGENTA][CYAN][YELLOW][BLACK][WHITE]\n");
	UART_Getc();
	LCDC_SetRGBOrder(GRB,GRB);

	Disp("Enter anykey to exit\n");
	UART_Getc();
	
	LCDC_SetRGBOrder(RGB,RGB); //	RGB, GBR, BRG, BGR, RBG, GRB

}

static void TestSwap(void)
{
	u32 uColor[16];
	u32 uHSz, uVSz, uNofPixel;
	u32 uFgAddr;
	LCD_WINDOW eWinTemp0, eWinTemp1;
	IMG_FMT eCspaceTemp;
	
	int i;

	#if (LCD_MODEL== LCD_LTV350QV_RGB)	
		uHSz=320;
		uVSz=240;
	
	#elif (LCD_MODEL == LCD_LTS222Q_CPU)
		uHSz=240;
		uVSz=320;

	#elif (LCD_MODEL == LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uHSz=800;
		uVSz=480;
	#else
		Assert(0);
	#endif

	bIsRev = false;
	bIsAllWin = false;

	eWinTemp0 = eBgWin;
	eWinTemp1 = eFgWin;
	eCspaceTemp = ePalBpp;
	
	eBgWin = WIN2;
	eFgWin = WIN3;
	ePalBpp = PAL4;

	LCDC_InitLdi(MAIN);

	LCDC_InitBase();
	LCDC_InitWin(ePalBpp, uHSz, uVSz, 0, 0, uHSz, uVSz*3/4, 0, 0, uLcdFbAddr, eBgWin, false);
	
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	
	LCDC_SetPaletteCtrl(ePalDataBpp, eBgWin); 

	GLIB_Init(uLcdFbAddr, uHSz, uVSz, ePalBpp);
	GLIB_SetPalDataFormat(ePalDataBpp);

	LCDC_Start();
	///////////////////////////////////////////////////////////
	// Palette Data BPP
	if (ePalDataBpp == RGB16)
	{
		uColor[0] = 0x0;	// Black
		uColor[1] = 0xffff; // White
		uColor[2] = 0x1f<<0; // Blue	
		uColor[3] = (0x1f<<11)|(0x3f<<6); // Yellow
		uColor[4] = (0x1f<<11)|(0x1f<<0); // Magenta
		uColor[5] = (0x3f<<6)|(0x1f<<0); // Cyan
		uColor[6] = 0x1f<<11; // Red
		uColor[7] = (0x23<<6)|(0x1f<<0); // Cyan2
		uColor[8] = (0x07<<11)|(0x15<<0); // Magenta1	
		uColor[9] =	(0x18<<11)|(0x17<<6); // Yellow1
		uColor[10] = 0x7777; // Gray	
		uColor[11] = 0x3f<<6; // Green	
		uColor[12] = (0x03<<11)|(0x1f<<0); // Magenta2		
		uColor[13] = (0x1f<<11)|(0x1a<<6); // Yellow2
		uColor[14] = (0x3f<<6)|(0x16<<0); // Cyan2
		uColor[15] = (0x10<<11)|(0x1d<<6)|(0x1f<<0); // Gray2							
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	UART_Printf("Byte Swap Test. \n");
	
	LCDC_ChangePaletteClk(PAL_HCLK);	

	for (i=0; i<16; i++)
		LCDC_SetPaletteData(i, uColor[i], eBgWin);
	
	LCDC_ChangePaletteClk(PAL_VCLK);


	LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE,SWAP_WORD_DISABLE, eBgWin);

	uNofPixel = uHSz*uVSz/8;
	
	for (i=0; i<uNofPixel; i++)
	{

		if(i<uNofPixel/16*4) *(u32*)(uLcdFbAddr+i*4) = 0x22;
		else if ( i >= uNofPixel/16*4 && i < uNofPixel/16*8) *(u32*)(uLcdFbAddr+i*4) = 0x33;
		else if ( i >= uNofPixel/16*8 && i < uNofPixel/16*12) *(u32*)(uLcdFbAddr+i*4) = 0x44;
		else if ( i >= uNofPixel/16*12 && i < uNofPixel/16*16) *(u32*)(uLcdFbAddr+i*4) = 0x0;
	}

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);

	LCDC_InitWin(ePalBpp, uHSz, uVSz, 0, 0, uHSz, uVSz/4, 0, uVSz*3/4, uFgAddr, eFgWin, false);
	LCDC_SetWinOnOff(1, eFgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	LCDC_SetPaletteCtrl(ePalDataBpp, eFgWin); 

	GLIB_Init(uFgAddr, uHSz, uVSz, ePalBpp);
	GLIB_SetPalDataFormat(ePalDataBpp);

	LCDC_ChangePaletteClk(PAL_HCLK);	

	uNofPixel = uHSz*uVSz/8;
	for (i=0; i<16; i++)
		LCDC_SetPaletteData(i, uColor[i], eFgWin);
	
	LCDC_ChangePaletteClk(PAL_VCLK);
	LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_DISABLE, SWAP_HALFWORD_DISABLE,SWAP_WORD_DISABLE, eFgWin);

		for (i=0 ; i<uNofPixel/16*4; i++)
	{
		*(u32*)(uFgAddr+i*4) = 0x11000000;
	}

	UART_Printf("Enter Any Key To Exit Current Display. (BYTE SWAP)\n");
	UART_Getc();
	////////////////////////////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////////////////////////////
	UART_Printf("HW Swap Test. \n");
	LCDC_ChangePaletteClk(PAL_HCLK);		

	for (i=0; i<16; i++)
		LCDC_SetPaletteData(i, uColor[i], eBgWin);
	
	LCDC_ChangePaletteClk(PAL_VCLK);


	LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_DISABLE, SWAP_HALFWORD_ENABLE,SWAP_WORD_DISABLE, eBgWin);

	uNofPixel = uHSz*uVSz/8;
	
	for (i=0; i<uNofPixel; i++)
	{

		if(i<uNofPixel/16*4) *(u32*)(uLcdFbAddr+i*4) = 0x22;
		else if ( i >= uNofPixel/16*4 && i < uNofPixel/16*8) *(u32*)(uLcdFbAddr+i*4) = 0x33;
		else if ( i >= uNofPixel/16*8 && i < uNofPixel/16*12) *(u32*)(uLcdFbAddr+i*4) = 0x44;
		else if ( i >= uNofPixel/16*12 && i < uNofPixel/16*16) *(u32*)(uLcdFbAddr+i*4) = 0x0;
	}

	UART_Printf("Enter Any Key To Exit Current Display. (HW SWAP)\n");
	UART_Getc();
	////////////////////////////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////////////////////////////
	UART_Printf("Bit Swap Test. \n");
	LCDC_ChangePaletteClk(PAL_HCLK);		

	for (i=0; i<16; i++)
		LCDC_SetPaletteData(i, uColor[i], eBgWin);
	
	LCDC_ChangePaletteClk(PAL_VCLK);

	LCDC_SetByteSwap(SWAP_BIT_ENABLE, SWAP_BYTE_DISABLE, SWAP_HALFWORD_DISABLE,SWAP_WORD_DISABLE, eBgWin);

	uNofPixel = uHSz*uVSz/8;
	
	for (i=0; i<uNofPixel; i++)
	{

		if(i<uNofPixel/16*4) *(u32*)(uLcdFbAddr+i*4) = 0x80000000;
		else if ( i >= uNofPixel/16*4 && i < uNofPixel/16*8) *(u32*)(uLcdFbAddr+i*4) = 0x80000000;
		else if ( i >= uNofPixel/16*8 && i < uNofPixel/16*12) *(u32*)(uLcdFbAddr+i*4) = 0x80000000;
		else if ( i >= uNofPixel/16*12 && i < uNofPixel/16*16) *(u32*)(uLcdFbAddr+i*4) = 0x0;
	}

	UART_Printf("Enter Any Key To Exit Current Display. (BIT SWAP)\n");
	UART_Getc();
	////////////////////////////////////////////////////////////////////////////////////////////////////
	
	eBgWin = eWinTemp0;
	eFgWin = eWinTemp1;
	ePalBpp = eCspaceTemp;
}

static void TestVDMABurstLength(void)
{
	u32 j;
	u32 uHSz, uVSz;
	BURST_MODE eBurstLen;
	LCDC_FIFO_LEVEL eFifoIntLevel;
	LCDC_FIFO_INT_SEL eFifoIntSel;

	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);

	INTC_Init();
	eFifoIntLevel = EMPTY; 
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	
	for(j=0;j<3;j++)
	{
		if(j==0)
		{
			eBurstLen = BURST16;
			UART_Printf("\nVDMA Burst 16 Word.\n");
		}
		else if(j==1) 
		{
			eBurstLen = BURST8;
			UART_Printf("\nVDMA Burst 8 Word.\n");
		}
		else if(j==2) 
		{
			eBurstLen = BURST4;
			UART_Printf("\nVDMA Burst 4 Word.\n");
		}
		
		LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCDC_SetBurstLength(eBurstLen, eBgWin);
		LCDC_SetWinOnOff(1, eBgWin);
		LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern(uHSz, uVSz);	
		
		 eFifoIntSel=
		(eBgWin == WIN0) ? FIFO_INT_WIN0 :
		(eBgWin == WIN1) ? FIFO_INT_WIN1 :
		(eBgWin == WIN2) ? FIFO_INT_WIN2 :
		(eBgWin == WIN3) ? FIFO_INT_WIN3 : FIFO_INT_WIN4;

		//UART_Printf("Background: WINDOW %d\n", (int)eBgWin);

		LCD_InitInt(LCDC_FIFO_INT, eLcdCpuifInt, eFifoIntLevel, eFifoIntSel, FINT_BACKPORCH);
		LCDC_EnableInterrupt();
		INTC_Enable(NUM_LCD0);
					
		LCDC_Start();
		
		while(!(UART_Getc()));
		
		LCDC_DisableInterrupt();
		INTC_Disable(NUM_LCD0);
		UART_Printf("\n");
	}	
}



static void TestDispAllWinByPalette(void)
{
	u32 uFbStAddr;
	u32 uHSz, uVSz;
	u32 uColor[16];
	int nWinNum, i;
	u32 uPosX, uPosY;
	u32 uColorNum, uColorIdxNum;
	u32 uPalIndex;

	bIsRev = false;
	bIsAllWin = true;

	// Register color(RGB16) for testing palette (win2 ~ win4) 
	uColor[0] = 0xffff;	// Black
	uColor[1] = 0x0; // White
	uColor[2] = 0x1f<<0; // Blue	
	uColor[3] = (0x1f<<11)|(0x3f<<6); // Yellow
	uColor[4] = (0x1f<<11)|(0x1f<<0); // Magenta
	uColor[5] = (0x3f<<6)|(0x1f<<0); // Cyan
	uColor[6] = 0x3f<<6; // Green
	uColor[7] = (0x23<<6)|(0x1f<<0); // Cyan2
	uColor[8] = (0x07<<11)|(0x15<<0); // Magenta1	
	uColor[9] =	(0x18<<11)|(0x17<<6); // Yellow1
	uColor[10] = 0x7777; // Gray	
	uColor[11] = 0x1f<<11; // Red	
	uColor[12] = (0x03<<11)|(0x1f<<0); // Magenta2		
	uColor[13] = (0x1f<<11)|(0x1a<<6); // Yellow2
	uColor[14] = (0x3f<<6)|(0x16<<0); // Cyan2
	uColor[15] = (0x10<<11)|(0x1d<<6)|(0x1f<<0); // Gray2					

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uHSz,&uVSz);
	LCDC_Start();

	uFbStAddr = uLcdFbAddr;
//	uHSz = 320;
//	uVSz = 240;
	
	// set Win 0 and Win 1

	for (nWinNum=0; nWinNum<2; nWinNum++)
	{
		LCDC_InitWin(eWinBpp[nWinNum], uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFbStAddr, (LCD_WINDOW)nWinNum, false);
	
		LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);
		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);

		GLIB_Init(uFbStAddr, uHSz, uVSz, eWinBpp[nWinNum]);
		GLIB_DrawPattern(uHSz, uVSz);

		GLIB_SetFontColor(C_BLACK, C_WHITE, true);
		if (nWinNum == 0)
			{
			GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", nWinNum);
//			uHSz = (uHSz/2), uVSz = (uVSz/4);
			}
		else 
			GLIB_Printf((uHSz/5), (uVSz/10), "WIN %d", nWinNum);

		LCDC_Trigger();
		LCDC_GetFbEndAddr(&uFbStAddr, (LCD_WINDOW)nWinNum);
		uHSz = 80 , uVSz = 160;
	}
  
	for (nWinNum=2; nWinNum<5; nWinNum++)
	{

	if (nWinNum != 4)
		{
			uPosX = uHSz*(nWinNum-1);
			uPosY = 0;
		}
		else 
		{
			uPosX = 0;
			uPosY = 160;
		}

/*
		if (nWinNum != 4)
		{
			uPosX = 0;
			uPosY = uVSz*(nWinNum-1);
		}
		else 
		{
			uPosX = uHSz/2;
			uPosY = 0;
		}
*/
		uColorNum = 
			(eWinBpp[nWinNum] == PAL4) ? 8 :
			(eWinBpp[nWinNum] == PAL2) ? 4 : 2;

		uColorIdxNum = (eWinBpp[nWinNum] == PAL4) ? 16 : uColorNum;

		uPalIndex =
			(eWinBpp[nWinNum] == PAL4) ? 0x76543210 :
			(eWinBpp[nWinNum] == PAL2) ? 0xfa50fa50 : 0xf0f0f0f0;

		
		LCDC_InitWin(eWinBpp[nWinNum], uHSz, uVSz, 0, 0, uHSz, uVSz, uPosX, uPosY, uFbStAddr, (LCD_WINDOW)nWinNum, false);
	
		LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);
		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		LCDC_SetPaletteCtrl(ePalDataBpp, (LCD_WINDOW)nWinNum); 		

		LCDC_ChangePaletteClk(PAL_HCLK); // Using HCLK;

		for (i=0; i<uColorIdxNum; i++)
			LCDC_SetPaletteData(i, uColor[i], (LCD_WINDOW)nWinNum);
		
		LCDC_ChangePaletteClk(PAL_VCLK); // Using VCLK;

		for (i=0; i<(uHSz*uVSz)/uColorNum; i++)
		{
			if (eWinBpp[nWinNum] != PAL4)
				*(u32*)(uFbStAddr+(i*4)) = uPalIndex;
			else
				*(u32*)(uFbStAddr+(i*4)) = uPalIndex+0x88888888*(i%2);
		}
		LCDC_Trigger();
		
		LCDC_GetFbEndAddr(&uFbStAddr, (LCD_WINDOW)nWinNum);
	}
}

static void TestComplexDisplay(void)
{

	u32 uFrmHSz, uFrmVSz;
	u32 uViewHSz, uViewVSz;

	u32 uLcd_X, uLcd_Y;
	u32 uFrm_X, uFrm_Y;
	LCD_WINDOW eBgWin = WIN1;

	Disp("Select Foreground WINDOW\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	eBgWin=(LCD_WINDOW) UART_GetIntNum();
	
	bIsRev = false;
	bIsAllWin = false;
#if LCD_MODEL == LCD_LTV350QV_RGB
	if (eBgBpp == RGB16)
	{
		if (eBgWin == WIN0)
		{
			uFrmVSz = 240*3/2, uFrmHSz = 320*3/2, 
			uFrm_Y = 120, uFrm_X = 60, 
			uViewVSz = 240, uViewHSz = 320;
			uLcd_Y = 0,	uLcd_X = 0;
		}
		else if (eBgWin == WIN1)
		{
			uFrmVSz = 240, uFrmHSz = 320, 
			uFrm_Y = 26, uFrm_X = 80, 
			uViewVSz = 70, uViewHSz = 37;
			uLcd_Y = 35, uLcd_X = 80;
		}
		else if (eBgWin == WIN2)
		{
			uFrmVSz = 120, uFrmHSz = 320;
			uFrm_Y = 20, uFrm_X =50;
			uViewVSz = 64, uViewHSz = 100;
			uLcd_Y = 80, uLcd_X = 100;
		}
		else if (eBgWin == WIN3)
		{
			uFrmVSz = 240, uFrmHSz = 160;
			uFrm_Y = 8,	uFrm_X = 4;
			uViewVSz = 116, uViewHSz = 155;
			uLcd_Y = 9,	uLcd_X = 164;
		}
		else // eBgWin == WIN4
		{
			uFrmVSz = 120, uFrmHSz = 160;
			uFrm_Y = 18, uFrm_X = 40;
			uViewVSz = 86, uViewHSz = 100;
			uLcd_Y = 60, uLcd_X = 60;
		}
	}

	else // eBgBpp == RGB24
	{
		if (eBgWin == WIN0)
		{
			uFrmVSz = 240*2, uFrmHSz = 320*2;
			uFrm_Y = 240, uFrm_X = 320;
			uViewVSz = 240,	uViewHSz = 320;
			uLcd_Y = 0,	uLcd_X = 0;
		}
		else if (eBgWin == WIN1)
		{
			uFrmVSz = 120, uFrmHSz = 80;
			uFrm_Y = 28, uFrm_X = 10;
			uViewVSz = 62, uViewHSz = 60;
			uLcd_Y = 40, uLcd_X = 60;
		}
		else if (eBgWin == WIN2)
		{
			uFrmVSz = 240, uFrmHSz = 80;
			uFrm_Y = 48, uFrm_X = 30;
			uViewVSz = 182,	uViewHSz = 40;
			uLcd_Y = 58, uLcd_X = 160;
		}
		else if (eBgWin == WIN3)
		{
			uFrmVSz = 240, uFrmHSz = 320;
			uFrm_Y = 32, uFrm_X = 115;
			uViewVSz = 168, uViewHSz = 162;
			uLcd_Y = 62, uLcd_X = 119;
		}
		else // eWin == WIN4
		{
			uFrmVSz = 120, uFrmHSz = 160;
			uFrm_Y = 28, uFrm_X = 85;
			uViewVSz = 82, uViewHSz = 75;
			uLcd_Y = 72, uLcd_X = 69;
		}
	}
#elif ((LCD_MODEL == LCD_LTS222Q_RGB)|(LCD_MODEL == LCD_LTS222Q_CPU))
	if (eBgBpp == RGB16)
	{
		if (eBgWin == WIN0)
		{
			uFrmHSz = 240*3/2, uFrmVSz = 320*3/2, 
			uFrm_X = 120, uFrm_Y = 60, 
			uViewHSz = 240, uViewVSz = 320;
			uLcd_X = 0,	uLcd_Y = 0;
		}
		else if (eBgWin == WIN1)
		{
			uFrmHSz = 240, uFrmVSz = 320, 
			uFrm_X = 26, uFrm_Y = 80, 
			uViewHSz = 70, uViewVSz = 37;
			uLcd_X = 35, uLcd_Y = 80;
		}
		else if (eBgWin == WIN2)
		{
			uFrmHSz = 120, uFrmVSz = 320;
			uFrm_X = 20, uFrm_Y =50;
			uViewHSz = 64, uViewVSz = 100;
			uLcd_X = 80, uLcd_Y = 100;
		}
		else if (eBgWin == WIN3)
		{
			uFrmHSz = 240, uFrmVSz = 160;
			uFrm_X = 8,	uFrm_Y = 4;
			uViewHSz = 116, uViewVSz = 155;
			uLcd_X = 9,	uLcd_Y = 164;
		}
		else // eBgWin == WIN4
		{
			uFrmHSz = 120, uFrmVSz = 160;
			uFrm_X = 18, uFrm_Y = 40;
			uViewHSz = 86, uViewVSz = 100;
			uLcd_X = 60, uLcd_Y = 60;
		}
	}

	else // eBgBpp == RGB24
	{
		if (eBgWin == WIN0)
		{
			uFrmHSz = 240*2, uFrmVSz = 320*2;
			uFrm_X = 240, uFrm_Y = 320;
			uViewHSz = 240,	uViewVSz = 320;
			uLcd_X = 0,	uLcd_Y = 0;
		}
		else if (eBgWin == WIN1)
		{
			uFrmHSz = 120, uFrmVSz = 80;
			uFrm_X = 28, uFrm_Y = 10;
			uViewHSz = 62, uViewVSz = 60;
			uLcd_X = 40, uLcd_Y = 60;
		}
		else if (eBgWin == WIN2)
		{
			uFrmHSz = 240, uFrmVSz = 80;
			uFrm_X = 48, uFrm_Y = 30;
			uViewHSz = 182,	uViewVSz = 40;
			uLcd_X = 58, uLcd_Y = 160;
		}
		else if (eBgWin == WIN3)
		{
			uFrmHSz = 240, uFrmVSz = 320;
			uFrm_X = 32, uFrm_Y = 115;
			uViewHSz = 168, uViewVSz = 162;
			uLcd_X = 62, uLcd_Y = 119;
		}
		else // eWin == WIN4
		{
			uFrmHSz = 120, uFrmVSz = 160;
			uFrm_X = 28, uFrm_Y = 85;
			uViewHSz = 82, uViewVSz = 75;
			uLcd_X = 72, uLcd_Y = 69;
		}
	}
#endif
	Disp("Enter Any Key To Test Complex Display\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);

	if ((int)eBgWin > 0) // Clear WIN 0 by using Color Map
	{
		LCDC_InitIp(eBgBpp, uLcdFbAddr, WIN0, false);
		LCDC_SetColorMapValue(0x000000ff, WIN0);
	}
	
	LCDC_InitBase();
	LCDC_InitWin(eBgBpp, uFrmHSz, uFrmVSz, uFrm_X, uFrm_Y, uViewHSz, uViewVSz, uLcd_X, uLcd_Y, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	
	if ((int)eBgWin > 0)// Set on WIN0 using Color Map
	{
		LCDC_SetColorMapOnOff(1, WIN0);
		LCDC_SetWinOnOff(1, WIN0);
	}

	GLIB_InitInstance(uLcdFbAddr, uFrmHSz, uFrmVSz, eBgBpp);
	GLIB_DrawPattern(uFrmHSz, uFrmVSz);
	LCDC_Trigger();
	Disp("Window %d is Displayed\n", (int)eBgWin);
	LCDC_Start();
}

static void TestDisplayAllWindow(void)
{
	u32 uWin1Addr, uWin2Addr, uWin3Addr, uWin4Addr; 
	u32 uHSz, uVSz;
//	u32 uHSz=320, uVSz=240;

	Disp("Enter Any Key To Win[0:4] Display Concurrently\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();

	// 1. Set WIN0
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);	// For WIN0
	LCDC_GetFrmSz(&uHSz,&uVSz,eBgWin);
	LCDC_Start();
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf((uHSz/3), (uVSz/2), "WIN %d", eBgWin);
	LCDC_Trigger();
	
	Disp("Window 0\n");
	UART_Getc();

	// 2. Set WIN1
	LCDC_GetFbEndAddr(&uWin1Addr, eBgWin);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2, 0, 0, uWin1Addr, WIN1, false); 
	GLIB_InitInstance(uWin1Addr, uHSz/2, uVSz/2, eBgBpp);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_ClearFrame(C_WHITE);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	GLIB_Printf(40, 80, "WIN %d", WIN1);
	LCDC_Trigger();

	Disp("Window 1\n");
	UART_Getc();

	// 3. Set WIN2
	LCDC_GetFbEndAddr(&uWin2Addr, WIN1);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	uHSz/2, 0, uWin2Addr, WIN2, false); 	

	GLIB_InitInstance(uWin2Addr, uHSz/2, uVSz/2, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	GLIB_Printf(40, 80, "WIN %d", WIN2);
	LCDC_Trigger();

	Disp("Window 2\n");
	UART_Getc();

	// 4. Set WIN3
	LCDC_GetFbEndAddr(&uWin3Addr, WIN2);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	0, uVSz/2, uWin3Addr, WIN3, false); 	
	
	GLIB_InitInstance(uWin3Addr, uHSz/2, uVSz/2, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	GLIB_Printf(40, 80, "WIN %d", WIN3);
	LCDC_Trigger();

	Disp("Window 3\n");
	UART_Getc();
	
	// 5. Set WIN4
	LCDC_GetFbEndAddr(&uWin4Addr, WIN3);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	uHSz/2, uVSz/2, uWin4Addr, WIN4, false); 	

	GLIB_InitInstance(uWin4Addr, uHSz/2, uVSz/2, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_DrawPattern(uHSz/2, uVSz/2);
	GLIB_Printf(40, 80, "WIN %d", WIN4);
	LCDC_Trigger();

	Disp("Window 4\n");
	UART_Getc();

}

static void TestReverseCombinationOfWins(void)
{
	u32 uFbStAddr = uLcdFbAddr;
	u32 uHSz, uVSz;
//	u32 uHSz = 320;
//	u32 uVSz = 240;
	u32 nWinNum;
	IMG_FMT eBpp;
	LCD_WINDOW eWinNum;
	u32 uPosX;

	bIsRev = true;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetFrmSz(&uHSz,&uVSz,eBgWin);
	LCDC_Start();
	
	for(nWinNum=0; nWinNum<3; nWinNum++)
	{
		eBpp = (nWinNum == 0) ? eBgBpp: eFgBppArray[nWinNum-1];
		eWinNum = (nWinNum == 0) ? eBg1Win : eFgWinArray[nWinNum-1];

		LCDC_InitWin(eBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFbStAddr, eWinNum, false); 	

		// clear alpha value
		LCDC_SetAlphaValWidth(ALPHA_8BIT);
		LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eWinNum);
		LCDC_SetAlphaClear(eWinNum);

		if (eWinNum != WIN0)
		{
			LCDC_SetAlpha(0x77, 0x77, 0x77, 0x0, 0x0, 0x0, eWinNum);
		}

		GLIB_InitInstance(uFbStAddr, uHSz, uVSz, eBpp);
		GLIB_DrawPattern(uHSz, uVSz);

		GLIB_SetFontColor(C_BLACK, C_WHITE, true);

		if (nWinNum == 0)
		{
			GLIB_Printf(200, 100, "WIN %d", (int)eWinNum);
		}
		else if (nWinNum == 1)
		{
			GLIB_Printf(100, 50, "WIN %d", (int)eWinNum);
		}
		else
		{
			GLIB_Printf(50, 20, "WIN %d", (int)eWinNum);
		}

		LCDC_Trigger();

		LCDC_GetFbEndAddr(&uFbStAddr, eWinNum);
		if (nWinNum == 0)
		{
			uHSz = 160, uVSz = 160;
		}
		else
		{
			uHSz = 80, uVSz = 80;
		}

		Disp("Enter Any Key To Display Next Window\n");
		UART_Getc();
	}
}
static void TestSelectNonPaletteBpp()
{
	s32 uSelection;

	Disp("Select non-palette bpp mode\n");
	Disp("0: RGB565     1: RGB888        ");
	uSelection=(IMG_FMT) UART_GetIntNum();
	Disp("\n");

	switch(uSelection)
	{
		case 1: 
			eBgBpp = RGB888; 
			break;
		default : 
			eBgBpp = RGB565;
	}

}
static void TestSelectPaletteBpp()
{
	s32 uSelection;

	Disp("Select palette bpp mode\n");
	Disp("0: PAL1(1bpp)     1: PAL2(2bpp)     2: PAL4(4bpp)     3: PAL8(8bpp)       ");
	uSelection=(IMG_FMT) UART_GetIntNum();
	Disp("\n");

	switch(uSelection)
	{
		case 1: 
			ePalBpp = PAL2; 
			break;
		case 2: 
			ePalBpp = PAL4; 
			break;
		case 3: 
			ePalBpp = PAL8; 
			break;
		default : 
			ePalBpp = PAL1;
	}
}
static void TestSelectPaletteDataBpp()
{
	s32 uSelection;

	Disp("Select palette data bpp mode\n");
	Disp("0: RGB16     1: RGB24        ");
	uSelection=(IMG_FMT) UART_GetIntNum();
	Disp("\n");

	switch(uSelection)
	{
		case 1: 
			ePalDataBpp = RGB24; 
			break;
		default : 
			ePalDataBpp = RGB16;
	}

}
static void TestSelectForegroundWindow()
{
	s32 uSelection;
	
	Disp("Select Foreground Window\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	uSelection=UART_GetIntNum();
	Disp("\n");

	switch(uSelection)
	{
		case 1: 
			eFgWin = WIN1; 
			break;
		case 2: 
			eFgWin = WIN2; 
			break;
		case 3: 
			eFgWin = WIN3; 
			break;
		case 4: 
			eFgWin = WIN4; 
			break;
		default : 
			eFgWin = WIN0;
	}
}
static void TestSelectBackgroundWindow()
{
	s32 uSelection;

	Disp("Select Background Window\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	uSelection=UART_GetIntNum();
	Disp("\n");

	switch(uSelection)
	{
		case 1: 
			eBgWin = WIN1; 
			break;
		case 2: 
			eBgWin = WIN2; 
			break;
		case 3: 
			eBgWin = WIN3; 
			break;
		case 4: 
			eBgWin = WIN4; 
			break;
		default : 
			eBgWin = WIN0;
	}
}
static void TestSetPaletteColor(IMG_FMT ePaletteDataBpp ,IMG_FMT ePaletteBpp,LCD_WINDOW nWinNum  )
{
	int i;
	u32 aColorData[256];
	u32 uColorLevel;
	
	switch(ePaletteBpp)
	{
		case PAL8:
			uColorLevel = 1<<8;
			break;
		case PAL4:
			uColorLevel = 1<<4;
			break;
		case PAL2:
			uColorLevel = 1<<2;
			break;
		case PAL1:
			uColorLevel = 1<<1;
			break;
	}

	switch(ePaletteDataBpp)
	{
		case RGB24:
			for(i=0; i<uColorLevel; i++)
			{
				//aColorData[i]=(0xff/(uColorLevel-1))*i;//only blue colors,8bit
				aColorData[i]=(0xff*i)/(uColorLevel-1);//only blue colors,8bit
			}
			break;
			
		case RGB16 :
			for(i=0; i<uColorLevel; i++)
			{
				if( uColorLevel < 0x20 )
					//aColorData[i]=(0x1f/(uColorLevel-1))*i;//only blue colors,5bit
					aColorData[i]=(0x1f*i)/(uColorLevel-1);//only blue colors,5bit
				else
					//aColorData[i] = i/((uColorLevel)/0x20); // B
					aColorData[i] = (i*0x20)/(uColorLevel); // B 0x20 is blue color's maximum color count
			}
			break;
			
	}

	LCDC_ChangePaletteClk(PAL_HCLK);

	for (i=0; i<uColorLevel; i++)	// palette ram 256 depth
		LCDC_SetPaletteData(i, aColorData[i], (LCD_WINDOW)nWinNum);

	LCDC_ChangePaletteClk(PAL_VCLK);
}
static void TestDrawHorizontalColorBar(u32* pFb, u32 uHSz, u32 uVSz, IMG_FMT eFormat)
{
#if 1
	u32 i,j,k;
	u32 uColor;
	u32 uColorLevel;
	u32* pBuffer;
	u32 uData;
	u32 uBitPerPixel;
	u32 uPixelPerByte;

	switch(eFormat)
	{
		case PAL8:
			uBitPerPixel = 8;
			break;
		case PAL4:
			uBitPerPixel = 4;
			break;
		case PAL2:
			uBitPerPixel = 2;
			break;
		case PAL1:
			uBitPerPixel = 1;
			break;
	}

	uColorLevel = (1<<uBitPerPixel);
	uPixelPerByte = 8/uBitPerPixel;
	
	pBuffer = pFb;

	for(i=0; i<uVSz; i++) 
	{
		uColor = (i*uColorLevel)/uVSz;
		uData = 0;
		for( k = 0 ; k < (4*uPixelPerByte) ; k++)
			uData |= uColor<<(k*uBitPerPixel);
		
		for(j=0; j<uHSz/(4*uPixelPerByte); j++)
			*pBuffer++ = uData;
	}
#endif
}
static void TestPrintBpp(IMG_FMT eBpp)
{

	switch(eBpp)
	{
//		case RGB24: Disp("RGB24 "); break;
//		case RGB16: Disp("RGB16 "); break;
		case RGB565: Disp("RGB565 "); break;
		case RGB666: Disp("RGB666 "); break;
		case RGB888: Disp("RGB888 "); break;
		case ARGB8888: Disp("ARGB8888 "); break;
		case ARGB1888: Disp("ARGB1888 "); break;
		case ARGB1887: Disp("ARGB1887 "); break;
		case ARGB1666: Disp("ARGB1666 "); break;
		case ARGB1555: Disp("ARGB1555 "); break;
		case ARGB4444: Disp("ARGB4444 "); break;
		case ARGB1232: Disp("ARGB1232 "); break;
		case PAL8: Disp("PAL8 "); break;
		case PAL4: Disp("PAL4 "); break;
		case PAL2: Disp("PAL2 "); break;
		case PAL1: Disp("PAL1 "); break;
		default:Disp("??? ");
	}

}
static void TestPrintWindow(LCD_WINDOW eWin)
{
	switch(eWin)
	{
		case WIN0: Disp("WIN0 "); break;
		case WIN1: Disp("WIN1 "); break;
		case WIN2: Disp("WIN2 "); break;
		case WIN3: Disp("WIN3 "); break;
		case WIN4: Disp("WIN4 "); break;
		case ALLWIN: Disp("ALLWIN "); break;
		default:Disp("??? ");
	}
}
static void TestPrintNonPaletteModeBpp(LCD_WINDOW eWin,IMG_FMT eBpp)
{
	Disp("Pattern will be displayed ");
	Disp("at ");
	TestPrintWindow(eWin);
	Disp("with ");
	TestPrintBpp(eBpp);
	Disp("\n");
	
}
static void TestPrintPaletteModeBpp(LCD_WINDOW eWin,IMG_FMT ePaletteBpp,IMG_FMT ePaletteDataBpp,u32 uTestHeight)
{

	Disp("%d blue line will be displayed ",uTestHeight);
	Disp("at ");
	TestPrintWindow(eWin);
	Disp("with ");
	switch(ePaletteBpp)
	{
		case PAL8: Disp("256 colors[PAL8], "); break;
		case PAL4: Disp("16 colors[PAL4], "); break;
		case PAL2: Disp("4 colors[PAL2], "); break;
		case PAL1: Disp("2 colors[PAL1], "); break;
		default:Disp("??? ");
	}
	TestPrintBpp(ePaletteDataBpp);
	Disp("\n");

}
static void TestNonPaletteModeBpp(void)
{
	u32 uTestWidth = 256;
	u32 uTestHeight = 256;
	LCD_WINDOW eWinTestCase[] = {WIN0,WIN1,WIN2,WIN3,WIN4};
	IMG_FMT eNonPalBppTestCase[] = {RGB24,RGB16,ARGB24,ARGB16,ARGB25};

	u32 uTestAllCase;
	u32 uHSz,uVSz;

	u32 uWin;
	u32 uBpp;

	Disp("========================================\n");
	Disp("TestNonPaletteModeBpp Start\n");
	Disp("========================================\n");

	Disp("0: Specific case  1: All case ");
	uTestAllCase = UART_GetIntNum();
	Disp("\n");

	for( uBpp = 0 ; uBpp < sizeof(eNonPalBppTestCase) ; uBpp++)
	for( uWin = 0 ; uWin < sizeof(eWinTestCase) ; uWin++)
	{
		if(uTestAllCase==0)
		{
			TestSelectBackgroundWindow();
			TestSelectNonPaletteBpp();
		}
		else
		{
			eBgWin = eWinTestCase[uWin];
			eBgBpp = eNonPalBppTestCase[uBpp];
		}

		TestPrintNonPaletteModeBpp(eBgWin,eBgBpp);
		Disp("Enter Any Key To Test ( x = exit ) \n");
		if(UART_Getc() == 'x')
			return;
		
		LCDC_InitLdi(MAIN);
		LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCDC_SetWinOnOff(1, eBgWin);
		LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
		LCDC_Start();	

		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern(uHSz, uVSz);
		GLIB_Printf(0, 0, "WINDOW %d", (int)eBgWin);
		LCDC_WTrigger(WIN0);

		if(uTestAllCase==0)
			return;

	}

}
static void TestPaletteModeBpp(void)
{
	u32 uTestWidth = 256;
	u32 uTestHeight = 256;
	u32 uTestAllCase;

	IMG_FMT ePalDataBppTestCase[] = {RGB24,RGB16};
	IMG_FMT ePalBppTestCase[] = {PAL8,PAL4,PAL2,PAL1};
	LCD_WINDOW eWinTestCase[] = {WIN0,WIN1,WIN2,WIN3,WIN4};
	u32 uPalDataBpp;
	u32 uPalBpp;
	u32 uWin;
	
	bIsRev = false;
	bIsAllWin = false;

	Disp("========================================\n");
	Disp("TestPaletteModeBpp Start\n");
	Disp("========================================\n");

	Disp("0: Specific case  1: All case ");
	uTestAllCase = UART_GetIntNum();
	Disp("\n");

	for( uWin = 0 ; uWin < sizeof(eWinTestCase) ; uWin++)
	for( uPalBpp = 0 ; uPalBpp < sizeof(ePalBppTestCase) ; uPalBpp++)
	for( uPalDataBpp = 0 ; uPalDataBpp < sizeof(ePalDataBppTestCase) ; uPalDataBpp++)
	{
		if(uTestAllCase==0)
		{
			TestSelectBackgroundWindow();
			TestSelectPaletteBpp();
			TestSelectPaletteDataBpp();
		}
		else
		{
			eBgWin = eWinTestCase[uWin];
			ePalBpp = ePalBppTestCase[uPalBpp];
			ePalDataBpp = ePalDataBppTestCase[uPalDataBpp];
		}

		TestPrintPaletteModeBpp(eBgWin,ePalBpp,ePalDataBpp,uTestHeight);
		Disp("Enter Any Key To Test ( x = exit ) \n");
		if(UART_Getc() == 'x')
			return;

		LCDC_InitLdi(MAIN);
		LCDC_InitBase();
		LCDC_InitWin(ePalBpp, uTestWidth, uTestHeight, 0, 0, uTestWidth, uTestHeight,0, 0, uLcdFbAddr, eBgWin, false);
		LCDC_SetPaletteCtrl(ePalDataBpp, eBgWin);
		LCDC_Start();

		TestSetPaletteColor(ePalDataBpp,ePalBpp,eBgWin);
		TestDrawHorizontalColorBar((u32*)uLcdFbAddr,uTestWidth,uTestHeight,ePalBpp);

		if(uTestAllCase==0)
			return;
	}
}

static void TestComplexPalette(void)
{
	u32 i,j=0;
	u32 uPalDataBpp,uPalBpp;
	u32 aColorData[256];
	IMG_FMT pePalDataBpp[] = {RGB24,RGB16};
	IMG_FMT ePalDataBpp;
	IMG_FMT pePalBpp[] = {PAL8,PAL4,PAL2,PAL1};
	IMG_FMT ePalBpp;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	u32 nWinNum=0;
	u32 uHSz, uVSz;
	u32 uBufEndAddr;
	u32 uColor;
	u32 uAlphaVal;
	u32 uBpp;
	u32 uPaletteDataColorLevel;
	u32 uColorLevel;
//	uHSz = 320, uVSz = 240;
	u32* pFB;
	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uHSz,&uVSz);

	for (nWinNum=0; nWinNum<3; nWinNum++)
	{
		uLcdFbAddr = CODEC_MEM_ST;
	for( uPalBpp = 0 ; uPalBpp < sizeof(pePalBpp) ; uPalBpp++)
	for( uPalDataBpp = 0 ; uPalDataBpp < sizeof(pePalDataBpp) ; uPalDataBpp++)
	{


			ePalBpp = pePalBpp[uPalBpp];
			ePalDataBpp = pePalDataBpp[uPalDataBpp];
			Disp("---------------------------------------------------\n");
			Disp("window:%d palette bpp:%d palette data bpp:%d\n",nWinNum,ePalBpp,ePalDataBpp);
			Disp("Enter Any Key To Test\n");
			UART_Getc();

			LCDC_SetAllWinOnOff(0);
			LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);	// win1, win2 off
			LCDC_InitWin(ePalBpp, 	uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);
			LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
			LCDC_SetPaletteCtrl(ePalDataBpp, (LCD_WINDOW)nWinNum);
			LCDC_Start();

			switch(ePalBpp)
			{
				case PAL8:
					uColorLevel = 1<<8;
					break;
				case PAL4:
					uColorLevel = 1<<4;
					break;
				case PAL2:
					uColorLevel = 1<<2;
					break;
				case PAL1:
					uColorLevel = 1<<1;
					break;
			}

			switch(ePalDataBpp)
			{
				case RGB24:
					for(i=0; i<uColorLevel; i++)
					{
						//aColorData[i]=(0xff/(uColorLevel-1))*i;//only blue colors,8bit
						aColorData[i]=(0xff*i)/(uColorLevel-1);//only blue colors,8bit
					}
					break;
					
				case RGB16 :
					for(i=0; i<uColorLevel; i++)
					{
						if( uColorLevel < 0x1f+1 )
							//aColorData[i]=(0x1f/(uColorLevel-1))*i;//only blue colors,5bit
							aColorData[i]=(0x1f*i)/(uColorLevel-1);//only blue colors,5bit
						else
							//aColorData[i] = i/((uColorLevel)/0x20); // B
							aColorData[i] = (i*0x20)/(uColorLevel); // B
					}
					break;
					
			}

			LCDC_ChangePaletteClk(PAL_HCLK);

			for (i=0; i<uColorLevel; i++)	// palette ram 256 depth
				LCDC_SetPaletteData(i, aColorData[i], (LCD_WINDOW)nWinNum);

			LCDC_ChangePaletteClk(PAL_VCLK);
			LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, (LCD_WINDOW)nWinNum);

#if 0
			pFB = (u32*)uLcdFbAddr;
			for(i=0; i<uVSz; i++) //PAL8 has 256 level color
			{
				for(j=0; j<uHSz/4; j++)
				{
					*(u32*)pFB = 0;
					pFB++;
				}
			}
			
			switch(ePalBpp)
			{
				case PAL8:
					for(i=0; i<uVSz; i++) //PAL4 has 256 level color, draw 256 horizontal color bar
					{
						//uColor = i/(uVSz/uColorLevel);
						uColor = (i*uColorLevel)/uVSz;
						for(j=0; j<uHSz/4; j++)
						{
							*(u32*)uLcdFbAddr = (uColor<<24|uColor<<16|uColor<<8|uColor);
							uLcdFbAddr+=4;
						}
					}
					break;
				case PAL4:
					for(i=0; i<uVSz; i++)//PAL4 has 16 level color, draw 16 horizontal color bar
					{
						uColor = (i*uColorLevel)/uVSz;
						for(j=0; j<uHSz/8; j++)
						{
							*(u32*)uLcdFbAddr = (uColor<<28|uColor<<24|uColor<<20|uColor<<16|uColor<<12|uColor<<8|uColor<<4|uColor);
							uLcdFbAddr+=4;
						}
					}
					break;
				case PAL2:
					for(i=0; i<uVSz; i++)//PAL2 has 4 level color, draw 4 horizontal color bar
					{
						uColor = (i*uColorLevel)/uVSz;
						for(j=0; j<uHSz/16; j++)
						{
							*(u32*)uLcdFbAddr =(uColor<<30|uColor<<28|uColor<<26|uColor<<24|uColor<<22|uColor<<20|uColor<<18|uColor<<16|
												uColor<<14|uColor<<12|uColor<<10|uColor<<8|uColor<<6|uColor<<4|uColor<<2|uColor);
							uLcdFbAddr+=4;
						}
					}
					break;
				case PAL1:
					for(i=0; i<uVSz; i++)// PAL1 has 2 level color, draw 2 horizontal color bar
					{
						uColor = (i*uColorLevel)/uVSz;
						for(j=0; j<uHSz/32; j++)
						{
							*(u32*)uLcdFbAddr = (uColor<<31|uColor<<30|uColor<<29|uColor<<28|uColor<<27|uColor<<26|uColor<<25|uColor<<24|
												uColor<<23|uColor<<22|uColor<<21|uColor<<20|uColor<<19|uColor<<18|uColor<<17|uColor<<16|
												uColor<<15|uColor<<14|uColor<<13|uColor<<12|uColor<<11|uColor<<10|uColor<<9|uColor<<8|
												uColor<<7|uColor<<6|uColor<<5|uColor<<4|uColor<<3|uColor<<2|uColor<<1|uColor);						
							uLcdFbAddr+=4;
						}
					}
					break;
			}
#else
//			TestDrawHorizontalColorBar(uLcdFbAddr,uHSz,uVSz,
#endif
			LCDC_Trigger();
//			uLcdFbAddr = uBufEndAddr;
		}
	}

	Disp("Enter Any Key To End Palette Ram Test\n", (LCD_WINDOW)nWinNum);
	UART_Getc();

	for(nWinNum=1; nWinNum<3; nWinNum++)
		LCDC_SetWinOnOff(0, (LCD_WINDOW)nWinNum);	// win1, win2 off


	ePalBpp = PAL8;
	ePalDataBpp = RGB24;
	for (nWinNum=1; nWinNum<3; nWinNum++)
	{

		Disp("Enter Any Key To Test WIN %d Palette By Alpha value(ARGB8888)\n", (LCD_WINDOW)nWinNum);
		UART_Getc();

		if(nWinNum == 1)
		{
			LCDC_InitWin(ePalBpp, 160, 120, 0, 0, 160, 120, 40, 20, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);		
			LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		}
		else if(nWinNum == 2)
		{
			LCDC_InitWin(ePalBpp, 160, 120, 0, 0, 160, 120, 120, 100, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);		
			LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		}
		
		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, ePalBpp);
		GLIB_SetPalDataFormat(ePalDataBpp);

		LCDC_SetBlendingType(PER_PIXEL, AEN_PIXEL, (LCD_WINDOW)nWinNum);
		LCDC_SetAlphaValWidth(ALPHA_8BIT);
		LCDC_SetPaletteCtrl(ARGB8888, (LCD_WINDOW)nWinNum);
		LCDC_Start();

		LCDC_ChangePaletteClk(PAL_HCLK); // Using HCLK

		if(nWinNum == 1)
			uAlphaVal = 0x33;
		else if(nWinNum == 2)
			uAlphaVal = 0x88;
		GLIB_SetAlpha8(C_RED, uAlphaVal);
		GLIB_GetPalDataFormat(C_RED, &  uColor);
		LCDC_SetPaletteData(C_RED, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_GREEN, uAlphaVal);
		GLIB_GetPalDataFormat(C_GREEN, &uColor);
		LCDC_SetPaletteData(C_GREEN, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_BLUE, uAlphaVal);
		GLIB_GetPalDataFormat(C_BLUE, &uColor);
		LCDC_SetPaletteData(C_BLUE, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_CYAN, uAlphaVal);
		GLIB_GetPalDataFormat(C_CYAN, &uColor);
		LCDC_SetPaletteData(C_CYAN, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_MAGENTA, uAlphaVal);
		GLIB_GetPalDataFormat(C_MAGENTA, &uColor);
		LCDC_SetPaletteData(C_MAGENTA, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_YELLOW, uAlphaVal);
		GLIB_GetPalDataFormat(C_YELLOW, &uColor);
		LCDC_SetPaletteData(C_YELLOW, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_BLACK, uAlphaVal);
		GLIB_GetPalDataFormat(C_BLACK, &uColor);
		LCDC_SetPaletteData(C_BLACK, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_WHITE, uAlphaVal);
		GLIB_GetPalDataFormat(C_WHITE, &uColor);
		LCDC_SetPaletteData(C_WHITE, uColor, (LCD_WINDOW)nWinNum);

		LCDC_ChangePaletteClk(PAL_VCLK); // Using VCLK
		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, (LCD_WINDOW)nWinNum);
	
		if(nWinNum == 1)
		{
			GLIB_DrawPattern(uHSz, uVSz);
			LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);	// win1 On.
			LCDC_Trigger();
		}
		else
		{
			GLIB_DrawPattern2(uHSz, uVSz);
			LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);	// win2 On.
			LCDC_Trigger();
		}
		LCDC_GetFbEndAddr(&uLcdFbAddr, (LCD_WINDOW)nWinNum);
	}
}


static void TestSimplePalette(void)
{
	u32 uColor[16];
	u32 uHSz, uVSz;
	u32 i;
	 
	bIsRev = false;
	bIsAllWin = false;


	Disp("Select Background WINDOW to test Palette\n");
	Disp("0: WIN0     1: WIN1     2: WIN2     3: WIN3     4: WIN4     ");
	eBgWin=(LCD_WINDOW) UART_GetIntNum();
	Disp("\n");
	if (eBgWin > 4 )
	{
		eBgWin = WIN0;
	}
	Disp("Background WINDOW is WINDOW %d \n\n",eBgWin);

	Disp("Select Palette Data format\n");
	Disp("0: RGB16     1: RGB24        ");
	ePalDataBpp=(IMG_FMT) UART_GetIntNum();
	Disp("\n");
	if(ePalDataBpp == 0 )
	{
		ePalDataBpp = RGB565;
		Disp("Palette Data format = RGB16 \n\n");
	}
	else if (ePalDataBpp ==  1)
		{
		ePalDataBpp = RGB888;
		Disp("Palette Data format = RGB24 \n");
		}
	else
	{
		ePalDataBpp = RGB565;
		Disp("Palette Data format = RGB16 \n");
	}

	Disp("Select Window bpp mode\n");
	Disp("0: PAL1(1bpp)     1: PAL2(2bpp)     2: PAL4(4bpp)     3: PAL8(8bpp)       ");
	ePalBpp=(IMG_FMT) UART_GetIntNum();
	Disp("\n");

	ePalBpp =	(ePalBpp == 0 ) ? PAL1 :
				(ePalBpp == 1 ) ? PAL2 :
				(ePalBpp == 2 ) ? PAL4 :
				(ePalBpp == 3 ) ? PAL8 : PAL1 ;
				
	Disp("Enter Any Key To Test Simple Display\n");
	UART_Getc();


	LCDC_InitLdi(MAIN);
	LCDC_InitIp(ePalBpp, uLcdFbAddr, eBgWin, false);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_SetPaletteCtrl(ePalDataBpp, eBgWin);
	LCDC_Start();

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, ePalBpp);
	GLIB_SetPalDataFormat(ePalDataBpp);


	if (ePalDataBpp == RGB565)
	{
		uColor[0] = 0x0;	// Black
		uColor[1] = 0xffff; // White
		uColor[2] = 0x1f<<0; // Blue
		uColor[3] = (0x1f<<11)|(0x3f<<6); // Yellow
		uColor[4] = (0x1f<<11)|(0x1f<<0); // Magenta
		uColor[5] = (0x3f<<6)|(0x1f<<0); // Cyan
		uColor[6] = 0x1f<<11; // Red
		uColor[7] = (0x23<<6)|(0x1f<<0); // Cyan2
		uColor[8] = (0x07<<11)|(0x15<<0); // Magenta1
		uColor[9] =	(0x18<<11)|(0x17<<6); // Yellow1
		uColor[10] = 0x7777; // Gray
		uColor[11] = 0x3f<<6; // Green
		uColor[12] = (0x03<<11)|(0x1f<<0); // Magenta2
		uColor[13] = (0x1f<<11)|(0x1a<<6); // Yellow2
		uColor[14] = (0x3f<<6)|(0x16<<0); // Cyan2
		uColor[15] = (0x10<<11)|(0x1d<<6)|(0x1f<<0); // Gray2
	}
	else // ePalDataBpp == RGB24
	{
		uColor[0] = 0x0; // Black
		uColor[1] = 0xffffff; // White
		uColor[2] = 0xff<<0; // Blue
		uColor[3] = (0xff<<16)|(0xff<<8); // Yellow
		uColor[4] = (0xff<<16)|(0xff<<0); // Magenta
		uColor[5] = (0xff<<8)|(0xff<<0); // Cyan
		uColor[6] = 0xff<<16; // Red
		uColor[7] = (0x67<<8)|(0xff<<0); // Cyan2
		uColor[8] = (0x2a<<16)|(0x15<<0); // Magenta1
		uColor[9] =	(0x2f<<16)|(0x2f<<8); // Yellow1
		uColor[10] = 0x777777; // Gray
		uColor[11] = 0xff<<8; // Green
		uColor[12] = (0x10<<16)|(0xff<<0); // Magenta2
		uColor[13] = (0xff<<16)|(0x2a<<8); // Yellow2
		uColor[14] = (0xff<<8)|(0x25<<0); // Cyan2
		uColor[15] = (0x2a<<16)|(0x3b<<8)|(0xff<<0); // Gray2
	}

	if (ePalBpp == PAL8)
	{
		LCDC_ChangePaletteClk(PAL_HCLK); // Using HCLK

		GLIB_GetPalDataFormat(C_RED, &uColor[0]);
		LCDC_SetPaletteData(C_RED, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_GREEN, &uColor[0]);
		LCDC_SetPaletteData(C_GREEN, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_BLUE, &uColor[0]);
		LCDC_SetPaletteData(C_BLUE, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_CYAN, &uColor[0]);
		LCDC_SetPaletteData(C_CYAN, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_MAGENTA, &uColor[0]);
		LCDC_SetPaletteData(C_MAGENTA, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_YELLOW, &uColor[0]);
		LCDC_SetPaletteData(C_YELLOW, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_BLACK, &uColor[0]);
		LCDC_SetPaletteData(C_BLACK, uColor[0], eBgWin);

		GLIB_GetPalDataFormat(C_WHITE, &uColor[0]);
		LCDC_SetPaletteData(C_WHITE, uColor[0], eBgWin);

		LCDC_ChangePaletteClk(PAL_VCLK); // Using VCLK
		
		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, eBgWin);
		
		GLIB_DrawPattern(uHSz, uVSz);
		LCDC_Trigger();
	}
	else if (ePalBpp == PAL4)
	{
		LCDC_ChangePaletteClk(PAL_HCLK);

		for (i=0; i<16; i++)
			LCDC_SetPaletteData(i, uColor[i], eBgWin);

		LCDC_ChangePaletteClk(PAL_VCLK);

		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, eBgWin);

		for (i=0; i<uHSz*uVSz/8; i++)
		{
			if (i%2 == 0)
				*(u32*)(uLcdFbAddr+i*4) = 0x01234567;
			else
				*(u32*)(uLcdFbAddr+i*4) = 0x89abcdef;
		}
		LCDC_Trigger();
	}
	else if (ePalBpp == PAL2)
	{
		LCDC_ChangePaletteClk(PAL_HCLK);

		for (i=0; i<4; i++)
			LCDC_SetPaletteData(i, uColor[i+1], eBgWin);

		LCDC_ChangePaletteClk(PAL_VCLK);
		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_DISABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, eBgWin);

		for (i=0; i<uHSz*uVSz/16; i++)
		{
			*(u32*)(uLcdFbAddr+i*4) = 0x1b1b1b1b;
		}
		LCDC_Trigger();
	}
	else // ePalBpp == 1Bpp
	{
		LCDC_ChangePaletteClk(PAL_HCLK);

		LCDC_SetPaletteData(0, uColor[0], eBgWin);
		LCDC_SetPaletteData(1, uColor[1], eBgWin);
		
		LCDC_ChangePaletteClk(PAL_VCLK);
		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, eBgWin);
		
		for (i=0; i<uHSz*uVSz/32; i++)
		{
			*(u32*)(uLcdFbAddr+i*4) = 0x0000f0f;
		}
		LCDC_Trigger();
	}
}
/*
static void TestComplexPalette(void)
{
	u32 i,j=0;
	u32 aColorData[256];
	IMG_FMT ePalDataBpp = RGB24;
	IMG_FMT ePalBpp = PAL8;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	u32 nWinNum=0;
	u32 uHSz, uVSz;
	u32 uBufEndAddr;
	u32 uColor;
	u32 uAlphaVal;

//	uHSz = 320, uVSz = 240;
	
	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uHSz,&uVSz);

	for (nWinNum=0; nWinNum<3; nWinNum++)
	{
		Disp("Enter Any Key To Test WIN %d Palette Ram (256x32)\n", (LCD_WINDOW)nWinNum);
		UART_Getc();

		LCDC_InitWin(ePalBpp, 	uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);
		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		LCDC_SetPaletteCtrl(ePalDataBpp, (LCD_WINDOW)nWinNum);
		LCDC_Start();

		aColorData[0]=0;
		if (nWinNum == 0)
			for(i=0; i<255; i++)
				aColorData[i+1] = i+1; // blue
		else if (nWinNum == 1)
			for(i=0; i<255; i++)
				aColorData[i+1] = i+1<<8;	// green
		else
			for(i=0; i<255; i++)
				aColorData[i+1] = i+1<<16;	// red

		LCDC_ChangePaletteClk(PAL_HCLK);

		for (i=0; i<256; i++)	// palette ram 256 depth
			LCDC_SetPaletteData(i, aColorData[i], (LCD_WINDOW)nWinNum);

		LCDC_ChangePaletteClk(PAL_VCLK);

		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, (LCD_WINDOW)nWinNum);

		// buffer clear
		for (i = 0; i<uHSz*uVSz/4; i++)
			*(u32 *)(uLcdFbAddr +i*4) = 0;
		uBufEndAddr = uLcdFbAddr +i*4;

		for(i=0; i<256; i++)
		{
			for(j=0; j<uHSz/4; j++)
			{
				*(u32*)uLcdFbAddr = (i<<24|i<<16|i<<8|i);
				uLcdFbAddr += 4;
			}
		}
		Disp("Verical line : 256 line\n\n");
	
		LCDC_Trigger();
		uLcdFbAddr = uBufEndAddr;
	}

	Disp("Enter Any Key To End Palette Ram Test\n", (LCD_WINDOW)nWinNum);
	UART_Getc();

	for(nWinNum=1; nWinNum<3; nWinNum++)
		LCDC_SetWinOnOff(0, (LCD_WINDOW)nWinNum);	// win1, win2 off

	for (nWinNum=1; nWinNum<3; nWinNum++)
	{

		Disp("Enter Any Key To Test WIN %d Palette By Alpha value(ARGB8888)\n", (LCD_WINDOW)nWinNum);
		UART_Getc();

		if(nWinNum == 1)
		{
			LCDC_InitWin(ePalBpp, 160, 120, 0, 0, 160, 120, 40, 20, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);		
			LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		}
		else if(nWinNum == 2)
		{
			LCDC_InitWin(ePalBpp, 160, 120, 0, 0, 160, 120, 80, 100, uLcdFbAddr, (LCD_WINDOW)nWinNum, false);		
			LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)nWinNum);
		}
		
		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, ePalBpp);
		GLIB_SetPalDataFormat(ePalDataBpp);

		LCDC_SetBlendingType(PER_PIXEL, AEN_PIXEL, (LCD_WINDOW)nWinNum);
		LCDC_SetAlphaValWidth(ALPHA_8BIT);
		LCDC_SetPaletteCtrl(ARGB8888, (LCD_WINDOW)nWinNum);
		LCDC_Start();

		LCDC_ChangePaletteClk(PAL_HCLK); // Using HCLK

		if(nWinNum == 1)
			uAlphaVal = 0x33;
		else if(nWinNum == 2)
			uAlphaVal = 0x88;
		GLIB_SetAlpha8(C_RED, uAlphaVal);
		GLIB_GetPalDataFormat(C_RED, &  uColor);
		LCDC_SetPaletteData(C_RED, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_GREEN, uAlphaVal);
		GLIB_GetPalDataFormat(C_GREEN, &uColor);
		LCDC_SetPaletteData(C_GREEN, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_BLUE, uAlphaVal);
		GLIB_GetPalDataFormat(C_BLUE, &uColor);
		LCDC_SetPaletteData(C_BLUE, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_CYAN, uAlphaVal);
		GLIB_GetPalDataFormat(C_CYAN, &uColor);
		LCDC_SetPaletteData(C_CYAN, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_MAGENTA, uAlphaVal);
		GLIB_GetPalDataFormat(C_MAGENTA, &uColor);
		LCDC_SetPaletteData(C_MAGENTA, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_YELLOW, uAlphaVal);
		GLIB_GetPalDataFormat(C_YELLOW, &uColor);
		LCDC_SetPaletteData(C_YELLOW, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_BLACK, uAlphaVal);
		GLIB_GetPalDataFormat(C_BLACK, &uColor);
		LCDC_SetPaletteData(C_BLACK, uColor, (LCD_WINDOW)nWinNum);

		GLIB_SetAlpha8(C_WHITE, uAlphaVal);
		GLIB_GetPalDataFormat(C_WHITE, &uColor);
		LCDC_SetPaletteData(C_WHITE, uColor, (LCD_WINDOW)nWinNum);

		LCDC_ChangePaletteClk(PAL_VCLK); // Using VCLK
		LCDC_SetByteSwap(SWAP_BIT_DISABLE, SWAP_BYTE_ENABLE, SWAP_HALFWORD_DISABLE, SWAP_WORD_DISABLE, (LCD_WINDOW)nWinNum);
	
		if(nWinNum == 1)
		{
			GLIB_DrawPattern(uHSz, uVSz);
			LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);	// win1 On.
			LCDC_Trigger();
		}
		else
		{
			GLIB_DrawPattern2(uHSz, uVSz);
			LCDC_SetWinOnOff(1, (LCD_WINDOW)nWinNum);	// win2 On.
			LCDC_Trigger();
		}
		LCDC_GetFbEndAddr(&uLcdFbAddr, (LCD_WINDOW)nWinNum);
	}
}
*/

static void TestColorMap(void)
{
	u32 uHSz, uVSz;
	u32 uColorMapVal_Bg, uColorMapVal_Fg;
	const char* pcColorStr;
	u32 uColorMapVal;

	bIsRev = false;
	bIsAllWin = false;

	// Can select a function for initializing Window 0 between InitIp() type and InitBaseAndSetOn() -> InitAndSetWinOn() type
	// InitIp() type is made for back-ward compatibility LCDC V2.0
	// So, recommand: InitBaseAndSetOn() -> InitAndSetWinOn() type
	Disp("Enter Any Key To Test Color Map\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);	
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_SetWinOnOff(1, eBgWin);	
	LCDC_Start();
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(100, 200, "WINDOW %d", (int)eBgWin);
	LCDC_Trigger();

	Disp("Enter Any Key To Test Window %d's Color-Map\n", (int)eBgWin);
	UART_Getc();

	uColorMapVal =
		((int)eBgWin == 0) ? 0x000000ff : // BLUE
		((int)eBgWin == 1) ? 0x00ff0000 : // RED
		((int)eBgWin == 2) ? 0x0000ff00 : // GREEN
		((int)eBgWin == 3) ? 0x00ffff00 : // YELLOW
		0x00ff00ff; // MAGENTA

	pcColorStr =
		(uColorMapVal == 0x000000ff) ? "BLUE" :
		(uColorMapVal == 0x00ff0000) ? "RED" :
		(uColorMapVal == 0x0000ff00) ? "GREEN" :
		(uColorMapVal == 0x00ffff00) ? "YELLOW" :
		(uColorMapVal == 0x00ff00ff) ? "MAGENTA" : "NOT DEFINED";

	LCDC_SetColorMapOnOff(1, eBgWin);
	LCDC_SetColorMapValue(uColorMapVal, eBgWin);
	LCDC_Trigger();

	Disp("The Color Of Color-Map's Color : %s\n", pcColorStr);
	Disp("Enter Any Key To Exit This Test\n");
	UART_Getc();
}

static void TestColorKey(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uKeyAreaColor, uNonKeyAreaColor;
	u32 uColorKey, uMaskKey;
	u32 k;

	bIsRev = false;
	bIsAllWin = false;

	if ((int)eBgWin >= (int)eFgWin)
	{
		Disp("Invalid Window Number Correspond to Foreground/ Background!\n");
		return;
	}

	Disp("Enter Any Key To Test Color Key\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	// Draw Pattern by using Glib for window 0
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);

	Disp("Window %d (Background) is Displayed\n", (int)eBgWin);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Start();
	LCDC_Trigger();

	if (eFgBpp == RGB24)
	{
		uColorKey =
			((int)eFgWin == 1) ? 0x0000ff :
			((int)eFgWin == 2) ? 0x00ff00 :
			((int)eFgWin == 3) ? 0xff0000 : 0xff00ff;

		uMaskKey =
			((int)eFgWin == 1) ? 0x00000c :
			((int)eFgWin == 2) ? 0x000c00 :
			((int)eFgWin == 3) ? 0x0c0000 : 0x00000c;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x0000f7 : // valid color: 0xf3, 0xf7, 0xfb, 0xff
			((int)eFgWin == 2) ? 0x00f300 : // valid color: 0x00f300, 0x00f700, 0x00fb00, 0x00ff00
			((int)eFgWin == 3) ? 0xf70000 : // valid color: 0xf30000, 0xf70000, 0xfb0000, 0xff0000
							     0xff00f3 ; // valid color: 0xff00f3, 0xff00f7, 0xff00fb, 0xff00ff

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0x00ff0000 : // RED
			((int)eFgWin == 2) ? 0x000000ff : // BLUE
			((int)eFgWin == 3) ? 0x0000ff00 : // GREEN
							    0x0000ffff; // CYAN
	}
	else if (eFgBpp == RGB16)
	{
		// In RGB16(565) Bpp,
		// The Valid bit position of color key value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uColorKey =
			((int)eFgWin == 1) ? 0x0000f8 : // BLUE
			((int)eFgWin == 2) ? 0x00fc00 : // GREEN
			((int)eFgWin == 3) ? 0xf80000 : // RED
			0xf800f8; // MAGENTA



		// In RGB16(565) Bpp,
		// Mask Key[18:16] must be 0x7
		// Mask Key[9:8] must be 0x3
		// Mask Key[2:0] must be 0x7 and
		// The valid bit postion of mask key(compare key) value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uMaskKey =
			((int)eFgWin == 1) ? 0x070337 :
			((int)eFgWin == 2) ? 0x071b07 :
			((int)eFgWin == 3) ? 0xc70307 : 0x070337;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x0019 : // valid color: 0x19, 0x1b, 0x1d, 0x1f
			((int)eFgWin == 2) ? 0x07e0 : // valid color: 0x720, 0x760, 0x790, 0x7e0
			((int)eFgWin == 3) ? 0x7800 : // valid color: 0x3800, 0x7800, 0xc800, 0xf800
			0xf81b; // valid color: 0xf819, 0xf81b, 0xf81d, 0xf81f			

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0xf800 : // RED
			((int)eFgWin == 2) ? 0x001f : // BLUE
			((int)eFgWin == 3) ? 0x07d0 : // GREEN
			0x07ff; // CYAN
	}
	else
	{
		Assert(0);
	}

	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, eFgWin, false); 
	LCDC_SetWinOnOff(1, eFgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
	GLIB_ClearFrame2(uKeyAreaColor);	 // Color key area
	LCDC_Trigger();

	GLIB_FillRectangle2(10, 80, 210, 120, uNonKeyAreaColor); // Non-color key area
	LCDC_Trigger();

	LCDC_SetColorKeyOnOff(1, eFgWin);

	Disp("Enter Any Key To Test Color Key (FOREGROUND MATCH)\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_FG_IMAGE, false, eFgWin);
	LCDC_Trigger();

	Disp("Enter Any Key To Test Color Key (BACKGROUDN MATCH)\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_BG_IMAGE, false, eFgWin);
	LCDC_Trigger();

	Disp("Enter Any Key To Test Color Key (FOREGROUND MATCH) + BLENDING\n");
	UART_Getc();
	Disp("\n");

	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_FG_IMAGE, true, eFgWin);
	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha(  0x0, 0x0, 0x0, 0x0+k, 0x0+k, 0x0+k, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha(	0x0+k, 0x0+k, 0x0+k, 0x0, 0x0, 0x0, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha(	0x0+k, 0x0+k, 0x0+k, 0x0+k, 0x0+k, 0x0+k, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	Disp("\n");
	Disp("Enter Any Key To Test Color Key (BACKGROUND MATCH) + BLENDING\n");
	UART_Getc();
	Disp("\n");

	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_BG_IMAGE, true, eFgWin);
	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha(  0x0, 0x0, 0x0, 0x0+k, 0x0+k, 0x0+k, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha(  0x0+k, 0x0+k, 0x0+k, 0x0, 0x0, 0x0, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	for(k=0; k<0xff; k+=32)
	{
		Disp("Enter Any Key To Process A Color Key Test\n");
		UART_Getc();
		LCDC_SetAlpha( 	0x0+k, 0x0+k, 0x0+k, 0x0+k, 0x0+k, 0x0+k, eFgWin);
		LCDC_Trigger();
	}
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();
}


static void TestColorKeyBlackout(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz,uFHSz,uFVSz;
	u32 uKeyAreaColor, uNonKeyAreaColor;
	u32 uColorKey, uMaskKey;
	
	bIsRev = false;
	bIsAllWin = false;

	if ((int)eBgWin >= (int)eFgWin)
	{
		Disp("Invalid Window Number Correspond to Foreground/ Background!\n");
		return;
	}

	if (eFgBpp == RGB24)
	{
		uColorKey =
			((int)eFgWin == 1) ? 0x0000ff :
			((int)eFgWin == 2) ? 0x00ff00 :
			((int)eFgWin == 3) ? 0xff0000 : 0xff00ff;

		uMaskKey =
			((int)eFgWin == 1) ? 0x00000c :
			((int)eFgWin == 2) ? 0x000c00 :
			((int)eFgWin == 3) ? 0x0c0000 : 0x00000c;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x0000f7 : // valid color: 0xf3, 0xf7, 0xfb, 0xff
			((int)eFgWin == 2) ? 0x00f300 : // valid color: 0x00f300, 0x00f700, 0x00fb00, 0x00ff00
			((int)eFgWin == 3) ? 0xf70000 : // valid color: 0xf30000, 0xf70000, 0xfb0000, 0xff0000
							     0xff00f3 ; // valid color: 0xff00f3, 0xff00f7, 0xff00fb, 0xff00ff

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0x00ff0000 : // RED
			((int)eFgWin == 2) ? 0x000000ff : // BLUE
			((int)eFgWin == 3) ? 0x0000ff00 : // GREEN
							    0x0000ffff; // CYAN
	}
	else if (eFgBpp == RGB16)
	{
		// In RGB16(565) Bpp,
		// The Valid bit position of color key value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uColorKey =
			((int)eFgWin == 1) ? 0x0000f8 : // BLUE
			((int)eFgWin == 2) ? 0x00fc00 : // GREEN
			((int)eFgWin == 3) ? 0xf80000 : // RED
			0xf800f8; // MAGENTA



		// In RGB16(565) Bpp,
		// Mask Key[18:16] must be 0x7
		// Mask Key[9:8] must be 0x3
		// Mask Key[2:0] must be 0x7 and
		// The valid bit postion of mask key(compare key) value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uMaskKey =
			((int)eFgWin == 1) ? 0x070337 :
			((int)eFgWin == 2) ? 0x071b07 :
			((int)eFgWin == 3) ? 0xc70307 : 0x070337;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x0019 : // valid color: 0x19, 0x1b, 0x1d, 0x1f
			((int)eFgWin == 2) ? 0x07e0 : // valid color: 0x720, 0x760, 0x790, 0x7e0
			((int)eFgWin == 3) ? 0x7800 : // valid color: 0x3800, 0x7800, 0xc800, 0xf800
			0xf81b; // valid color: 0xf819, 0xf81b, 0xf81d, 0xf81f			

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0xf800 : // RED
			((int)eFgWin == 2) ? 0x001f : // BLUE
			((int)eFgWin == 3) ? 0x07d0 : // GREEN
			0x07ff; // CYAN
	}
	else
	{
		Assert(0);
	}

	Disp("Enter Any Key To Test Color Key\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uHSz,&uVSz);
	LCDC_InitWin(eBgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,
		uHSz/4, uVSz/4, uLcdFbAddr, eBgWin, false);
//	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uFHSz, &uFVSz, eBgWin);

	// Draw Pattern by using Glib for window 0
	GLIB_InitInstance(uLcdFbAddr, uFHSz, uFVSz, eBgBpp);

	Disp("Window %d (Background) is Displayed\n", (int)eBgWin);
	GLIB_ClearFrame2(uNonKeyAreaColor);	 // Red
	LCDC_Start();
	LCDC_Trigger();


	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, eFgWin, false); 
	LCDC_SetWinOnOff(1, eFgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
	GLIB_ClearFrame2(uKeyAreaColor);	 // Color key area
	LCDC_Trigger();

//	GLIB_FillRectangle2(10, 80, 210, 120, uNonKeyAreaColor); // Non-color key area
	LCDC_Trigger();

	LCDC_SetColorKeyOnOff(1, eFgWin);

	Disp("Enter Any Key To Test Color Key (FOREGROUND MATCH)\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_FG_IMAGE, false, eFgWin);
	LCDC_Trigger();

	Disp("Enter Any Key To Test see Foreground unmatch area black out\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKeyBlackOut(1,eFgWin);

	Disp("Enter Any Key To Test Color Key (BACKGROUDN MATCH)\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKeyBlackOut(0,eFgWin);
	LCDC_SetColorKeyOnOff(0, eFgWin);
	LCDC_Stop();

	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,
		0, 0, uLcdFbAddr, eBgWin, false);
//	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);

	Disp("Window %d (Background) is Displayed\n", (int)eBgWin);
	GLIB_ClearFrame2(uKeyAreaColor);
	GLIB_SetFontColor(0xffffff,uKeyAreaColor,true);
	GLIB_Printf(0,uHSz/8,"Window %d",(int)eBgWin);
	LCDC_Start();

	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();


	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2, uHSz/4, uVSz/4, uFgAddr, eFgWin, false); 
	LCDC_SetWinOnOff(1, eFgWin);
	LCDC_GetFrmSz(&uFHSz, &uFVSz, eFgWin);

	GLIB_InitInstance(uFgAddr, uFHSz, uFVSz, eFgBpp);
	GLIB_ClearFrame2(uNonKeyAreaColor);	 
	GLIB_SetFontColor(0xffffff,uNonKeyAreaColor,true);
	GLIB_Printf(0,uHSz/8,"Window %d",(int)eFgBpp);
	LCDC_Trigger();

	Disp("Enter Any Key To Test Color Key (BACKGROUDN MATCH)\n");
	UART_Getc();
	Disp("\n");

	LCDC_SetColorKeyOnOff(1, eFgWin);
	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_BG_IMAGE, false, eFgWin);
	LCDC_Trigger();

	Disp("Enter Any Key To Test see Foreground unmatch area black out\n");
	UART_Getc();
	Disp("\n");
	LCDC_SetColorKeyBlackOut(1,eFgWin);


	Disp("Enter Any Key To End Colorkey Black out Test\n");
	UART_Getc();
	Disp("\n");	
	LCDC_SetColorKeyBlackOut(0,eFgWin);
	

}



static void TestBlendingDataPixel(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	IMG_FMT eFgBpp = ARGB8888;
	u32 uAlphaVal;
	u32 uColorIdx;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Per Plane Data Blending\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);

	// 1. Set background
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_Start();

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	LCDC_Trigger();

	Disp("Window %d(Background) is Displayed\n", (int)eBgWin);
	Disp("Enter Any Key To Display Window %d\n", (int)eFgWin);
	UART_Getc();
	
	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	 60, 80, uFgAddr, eFgWin, false); 	
	LCDC_SetWinOnOff(1, eFgWin);	
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);
	LCDC_SetBlendingType(PER_PIXEL, DATA_PIXEL, eFgWin);

//	uAlphaVal=0x55;
	uAlphaVal=0x99;

	GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
	for(uColorIdx=0; uColorIdx<8; uColorIdx++)
	{
		GLIB_SetAlpha8((COLOR)uColorIdx, uAlphaVal);
	}
	GLIB_DrawPattern(uHSz, uVSz);
	Disp("Data Blending is adopted to Win %d\n", eFgWin);
}


static void TestBlendingPerPlane(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 j;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Per Plane Blending\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);	
	LCDC_GetFrmSz(&uHSz,&uVSz, eBgWin);
	LCDC_Start();
	
	// Draw Pattern by using Glib for window 0
	Disp("Window %d(Background) is Displayed\n", (int)eBgWin);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Trigger();

	Disp("Enter Any Key To Display Window %d\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, eFgWin, false); 	
	LCDC_SetWinOnOff(1, eFgWin);	
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	// Draw Rectangles by using Glib for window 1
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)eFgWin);
	Disp("\n");

	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eFgWin);
	LCDC_SetAlphaClear(eFgWin);
	
	for (j=0; j<0xff; j+=10)
	{
		Disp("Enter Any Key To Test Per Plane Blending (Using ALPHA 0 VALUE)\n");
		UART_Getc();
		LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eFgWin);
		LCDC_Trigger();
	}

	Disp("Enter Any Key To Per Plane lending(Using ALPHA 1 VALUE)\n");
	Disp("\n");
	UART_Getc();

	GLIB_ClearFrame(C_YELLOW);
	LCDC_SetBlendingType(PER_PLANE, ALPHA1_PLANE, eFgWin);
	LCDC_SetAlphaClear(eFgWin);
	LCDC_Trigger();

	for (j=0; j<0xff; j+=10)
	{
		Disp("Enter Any Key To Test Per Plane Blending (Using ALPHA 1 VALUE)\n");
		UART_Getc();

		LCDC_SetAlpha(	0x0, 0x0, 0x0, 0x0+j, 0x0+j, 0x0+j, eFgWin);
		LCDC_Trigger();
	}
}

static void TestBlendingPerPixel(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	int j;
	
	bIsRev = false;
	bIsAllWin = false;
	
	Disp("Enter Any Key To Test Per Pixel Blending\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	
	LCDC_SetWinOnOff(1, eBgWin);	
	
	LCDC_GetFrmSz(&uHSz,  &uVSz, eBgWin);
	
	LCDC_Start();

	// Draw Pattern by using Glib for window 0
	Disp("Window 0(Background) is Displayed\n");	
	GLIB_Init(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Trigger();

	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	
	LCDC_InitWin(eFgArgbBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFgAddr, eFgWin, false);

	LCDC_SetWinOnOff(1, eFgWin);

	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	LCDC_SetBlendingType(PER_PIXEL, AEN_PIXEL, eFgWin);
	LCDC_SetAlphaValWidth(ALPHA_8BIT);
	
	GLIB_Init(uFgAddr, uHSz, uVSz, eFgArgbBpp);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);

	GLIB_ClearFrame3(C_RED, ALPHA_0);
	GLIB_Printf(20, 40, "Alpha 0 is applied");

	GLIB_FillRectangle3(40, 60, 160, 120, C_GREEN, ALPHA_1);
	GLIB_Printf(50, 70, "Alpha 1 is applied");
	LCDC_Trigger();		

	Disp("\n");
	Disp("Window %d (Foreground) is Displayed\n", (int)eFgWin);
	Disp("Enter Any Key To Test Per-Pixel Blending\n");
	UART_Getc();

	for (j=0; j<0xff; j+=10)
	{
		Disp("Enter Any Key To Test Per-Pixel Blending\n");
		UART_Getc();
		LCDC_SetAlpha(0x0+j, 0x0+j, 0x0+j, 0xff-j, 0xff-j, 0xff-j, eFgWin);
		
		LCDC_Trigger();		
	}
}

static void TestColorKeynBlending(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uKeyAreaColor, uNonKeyAreaColor;
	u32 uColorKey, uMaskKey;
	
	bIsRev = false;
	bIsAllWin = false;

	if ((int)eBgWin >= (int)eFgWin)
	{
		Disp("Invalid Window Number Correspond to Foreground/ Background!\n");
		return;
	}

	Disp("Enter Any Key To Test Color Key\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	// Draw Pattern by using Glib for window 0
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);

	Disp("Window %d (Background) is Displayed\n", (int)eBgWin);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Start();
	LCDC_Trigger();

	if (eFgArgbBpp == ARGB24)
	{
		uColorKey =
			((int)eFgWin == 1) ? 0x0000ff :
			((int)eFgWin == 2) ? 0x00ff00 :
			((int)eFgWin == 3) ? 0xff0000 : 0xff00ff;

		uMaskKey =
			((int)eFgWin == 1) ? 0x000001 :
			((int)eFgWin == 2) ? 0x000001 :
			((int)eFgWin == 3) ? 0x000001 : 0x000001;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x00007f : // valid color: 0xf3, 0xf7, 0xfb, 0xff
			((int)eFgWin == 2) ? 0x007f80 : // valid color: 0x00f300, 0x00f700, 0x00fb00, 0x00ff00
			((int)eFgWin == 3) ? 0x7f8000 : // valid color: 0xf30000, 0xf70000, 0xfb0000, 0xff0000
							     0x7f807f ; // valid color: 0xff00f3, 0xff00f7, 0xff00fb, 0xff00ff

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0x007f8000 : // RED
			((int)eFgWin == 2) ? 0x000000ff : // BLUE
			((int)eFgWin == 3) ? 0x0000ff00 : // GREEN
							    0x0000ffff; // CYAN
	}
	else if (eFgBpp == RGB16)
	{
		// In RGB16(565) Bpp,
		// The Valid bit position of color key value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uColorKey =
			((int)eFgWin == 1) ? 0x0000f8 : // BLUE
			((int)eFgWin == 2) ? 0x00fc00 : // GREEN
			((int)eFgWin == 3) ? 0xf80000 : // RED
			0xf800f8; // MAGENTA



		// In RGB16(565) Bpp,
		// Mask Key[18:16] must be 0x7
		// Mask Key[9:8] must be 0x3
		// Mask Key[2:0] must be 0x7 and
		// The valid bit postion of mask key(compare key) value
		// RED : COLVAL[23:19]
		// GREEN : COLVAL[15:10]
		// BLUE : COLVAL[7:3]
		uMaskKey =
			((int)eFgWin == 1) ? 0x070337 :
			((int)eFgWin == 2) ? 0x071b07 :
			((int)eFgWin == 3) ? 0xc70307 : 0x070337;

		uKeyAreaColor =
			((int)eFgWin == 1) ? 0x0019 : // valid color: 0x19, 0x1b, 0x1d, 0x1f
			((int)eFgWin == 2) ? 0x07e0 : // valid color: 0x720, 0x760, 0x790, 0x7e0
			((int)eFgWin == 3) ? 0x7800 : // valid color: 0x3800, 0x7800, 0xc800, 0xf800
			0xf81b; // valid color: 0xf819, 0xf81b, 0xf81d, 0xf81f			

		uNonKeyAreaColor =
			((int)eFgWin == 1) ? 0xf800 : // RED
			((int)eFgWin == 2) ? 0x001f : // BLUE
			((int)eFgWin == 3) ? 0x07d0 : // GREEN
			0x07ff; // CYAN
	}
	else
	{
		Assert(0);
	}

	Disp("Enter Any Key To Display Window %d (Foreground)\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eFgArgbBpp, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, eFgWin, false); 
	LCDC_SetWinOnOff(1, eFgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgArgbBpp);
//	GLIB_ClearFrame2(uColorKey);	 // Color key area
	GLIB_ClearFrame2(uKeyAreaColor);	 // Color key area
//	LCDC_Trigger();
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);

	GLIB_FillRectangle3(uHSz/2, 0, uHSz/4, uVSz, C_GREEN, ALPHA_1);
	GLIB_Printf(uHSz/2, uVSz/4, "Alpha 1");
	LCDC_Trigger();		

	GLIB_FillRectangle3(0, uVSz/2, uHSz, uVSz/4, C_RED, ALPHA_0);
	GLIB_Printf(uHSz/4, uVSz/2, "Alpha 0");
	LCDC_Trigger();		

/*

	GLIB_FillRectangle2(10, 80, 210, 120, uNonKeyAreaColor); // Non-color key area
	LCDC_Trigger();
*/

	Disp("Enter Any Key To Test Color Key (FOREGROUND MATCH)\n");
	UART_Getc();
	Disp("\n");

	LCDC_Trigger();


	LCDC_SetBlendingType(PER_PIXEL, AEN_PIXEL, eFgWin);
	LCDC_SetAlphaValWidth(ALPHA_8BIT);
	LCDC_SetAlpha(0x7F, 0x7F, 0x7F, 0xff, 0xff, 0xff, eFgWin);

	LCDC_SetColorKey(uMaskKey, uColorKey, MATCH_FG_IMAGE, true, eFgWin);
	LCDC_SetColorKeyOnOff(1, eFgWin);






}


static void TestSimpleBlendingEquation(void)
{
	u32 i,j;
	u32 uFg0Addr;
	u32 uFg1Addr;
	u32 uHSz, uVSz;
	u32 uAfunc;
	u32 uBfunc;
	u32 uABFunc[23][2] = {{0, 0}, {0, 1}, {1, 0}, {0, 0x3}, {0x2, 0}, 
						{0x2, 0x2}, {0x3, 0x3}, {0x3, 0x2},	{0xa, 0xc},	{0xc, 0xa},
						{0xa, 0xa}, {0xc, 0xc},	{0x2, 0xa},	{0, 0x4}, {0, 0x5},
						{0x5, 0x4}, {0x4, 0x5}, {0x4, 0x4}, {0x5, 0x5}, {0x2, 0x4},
						{0x3, 0x5}, {0x2, 0x5}, {0x3, 0x4}};
	
	Disp("Enter Any Key To Test Blending Equation\n");
	UART_Getc();
	
	// Init lcdc
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	// Draw Pattern1 to window 0
	Disp("Window %d(Background) is Displayed\n", (int)eBgWin);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Start();
	LCDC_Trigger();

	Disp("Enter Any Key To Display Window %d\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFg0Addr, eBgWin);	
	LCDC_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFg0Addr, eFgWin, false); 
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	// Draw Rectangles to window 1
	GLIB_InitInstance(uFg0Addr, uHSz, uVSz, eFgBpp);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)eFgWin);
	Disp("\n");

	Disp("\alphaA control test\n");
	for (i=0; i<8; i++)
	{
		uAfunc = uABFunc[i][0];
		uBfunc = uABFunc[i][1];
		LCDC_SetAlpha(  0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eFgWin);
		LCDC_SetBlendingEquation(0,0,uBfunc,uAfunc, eFgWin);
		Disp("A_FUNC : 0x%x, B_FUNC : 0x%x\n",uAfunc, uBfunc);
		
		for (j=0; j<0xff; j+=10)
		{
			Disp("alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eFgWin);
			LCDC_Trigger();
		}
	}

	Disp("\nColor Data control test\n");
	for (i=8; i<13; i++)
	{
		uAfunc = uABFunc[i][0];
		uBfunc = uABFunc[i][1];
		LCDC_SetAlpha(  0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eFgWin);
		LCDC_SetBlendingEquation(0,0,uBfunc,uAfunc, eFgWin);
		Disp("A_FUNC : 0x%x, B_FUNC : 0x%x\n",uAfunc, uBfunc);
		
		for (j=0; j<0xff; j+=10)
		{
			Disp("alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eFgWin);
			LCDC_Trigger();
		}
	}

	Disp("alphaB control test\n");
	for (i=13; i<19; i++)
	{
		uAfunc = uABFunc[i][0];
		uBfunc = uABFunc[i][1];
		LCDC_SetAlpha(  0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eBgWin);
		LCDC_SetBlendingEquation(0, 0, uBfunc, uAfunc, eFgWin);
		Disp("A_FUNC : 0x%x, B_FUNC : 0x%x\n", uAfunc, uBfunc);
		
		for (j=0; j<0xff; j+=10)
		{
			Disp("alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eBgWin);
			LCDC_Trigger();
		}
	}

	Disp("\nalphaA & alphaB control test\n");
	for (i=19; i<23; i++)
	{
		uAfunc = uABFunc[i][0];
		uBfunc = uABFunc[i][1];
		LCDC_SetAlpha(  0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eBgWin);
		LCDC_SetAlpha(  0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eFgWin);
		LCDC_SetBlendingEquation(0, 0, uBfunc, uAfunc, eFgWin);
		Disp("A_FUNC : 0x%x, B_FUNC : 0x%x\n", uAfunc, uBfunc);
		
		for (j=0; j<0xff; j+=10)
		{
			Disp("alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eFgWin);
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eBgWin);
			LCDC_Trigger();
		}
	}
}

static void TestComplexBlendingEquation(void)
{
	u32 uFg0Addr;
	u32 uFg1Addr;
	u32 uHSz, uVSz;
	u32 i,j;
	
	Disp("Enter Any Key To Test Blending Equation\n");
	UART_Getc();
	
	// Init lcdc
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);	

	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_Start();
	LCDC_Trigger();

	// Draw Rectangles to window 0
	Disp("Window %d is Displayed\n", (int)eBgWin);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_SetFontColor(C_YELLOW, C_WHITE, true);
//	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_ClearFrame(C_BLUE);
	GLIB_Printf(160, 40, "WIN %d", eBgWin);

	Disp("Enter Any Key To Display Window %d\n", (int)eFgWin);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFg0Addr, eBgWin);
	LCDC_InitWin(eFgBpp, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2, 20, 40, uFg0Addr, eFgWin, false); 
	LCDC_GetFrmSz(&uHSz, &uVSz, eFgWin);

	// Draw Rectangles to window 1
	GLIB_InitInstance(uFg0Addr, uHSz, uVSz, eFgBpp);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_ClearFrame(C_MAGENTA);
	GLIB_Printf(40, 50, "WIN %d", eFgWin);
	LCDC_Trigger();

	Disp("Window %d is Displayed\n", (int)eFgWin);
	Disp("\n");
	
	Disp("Enter Any Key To Display Window %d\n", (int)eFg1Win);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFg1Addr, eFgWin);
	LCDC_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 100, 120, uFg1Addr, eFg1Win, false); 
	LCDC_GetFrmSz(&uHSz, &uVSz, eFg1Win);

	// Draw Rectangles to window 2
	GLIB_InitInstance(uFg1Addr, uHSz, uVSz, eFgBpp);
	GLIB_SetFontColor(C_RED, C_WHITE, true);
	GLIB_ClearFrame(C_CYAN);
	GLIB_Printf(160, 280, "WIN %d", eFg1Win);
	LCDC_Trigger();
	Disp("Window %d is Displayed\n", (int)eFg1Win);
	Disp("\n");

	// if B_FUNC is alphaB', then ...
	// alphaB': Win0&Win1's alpha value, A_FUNC:WIN2 alpha value
	// alphaA:Win1 alpha value, alphaB:Win0 alpha value
	// B" = (background*alphaB') + (foreground*A_FUNC)	
	//	  = {background*(P*alphaA + Q*alphaB)} + (foreground*A_FUNC)

	LCDC_SetBlendingEquation(1,1,4,1, eFgWin);	  		// WIN1  
	LCDC_SetBlendingEquation(0,0,4,1, eFg1Win);	 		// WIN2	 
	// alphaB'=(p*0) + (q*win0's alphaB)
	// B'= fore*A + back*B = fore*1 + back*alphaB' = fore + back*(p*win1's alphaA+q*win0's alphaB) 
	//   = fore + back*( 1*win1's alphaA + 1*win0's alphaB ) 
	//	 = fore(->win2) + { back(->win1')*(win1's alphaA+win0's alphaB)}
	// changing win2's alpha value is no meaning.
	for (i=0; i<0xff; i+=50)
	{
		Disp("WIN 2 alpha 0 value : %d\n", i);
		LCDC_SetAlpha(	0x0+i, 0x0+i, 0x0+i, 0x0, 0x0, 0x0, eFgWin); 
		// Changing win1's alpha value have influence on win0&win1&win2 alpha blending area only.

		for (j=0; j<0xff; j+=50)
		{
			Disp("WIN0 alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eBgWin);
		}
	}
	
	LCDC_SetAlpha(	0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eBgWin);
	LCDC_SetAlpha(	0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eFgWin);
	LCDC_SetAlpha(	0xff, 0xff, 0xff, 0x0, 0x0, 0x0, eFg1Win);

	for (i=0; i<0xff; i+=50)
	{
		Disp("WIN 1 alpha 0 value : %d\n", i);
		LCDC_SetAlpha(	0x0+i, 0x0+i, 0x0+i, 0x0, 0x0, 0x0, eFg1Win); // win2's alpha value is  no meaning.

		for (j=0; j<0xff; j+=50)
		{
			Disp("WIN0 alpha 0 value : %d\n", j);
			UART_Getc();
			LCDC_SetAlpha(	0x0+j, 0x0+j, 0x0+j, 0x0, 0x0, 0x0, eBgWin);
		}
	}
}

static void TestSimpleDoubleBuffering(void)
{
	u32 uDoubleBufAddr;
	u32 uHSz, uVSz;
	int uColorIdx = 0;
	u32 uBufferIdx = 0;
	u32 eWin;
	
	COLOR eColor;
	bIsRev = false;
	bIsAllWin = false;

	// Enable Double Buffer
	Disp("Enter Any Key To Test Simple Double Buffering\n");
	UART_Getc();
	
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, WIN0, true);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);
	LCDC_Start();

	Disp("Window 0's Double Buffering Test\n");
	Disp("Enter Enter Key To Exit Double Buffering Test\n");
	
	while(GetKey() != '\r')
	{
		uBufferIdx = uBufferIdx%2;

		uColorIdx = uColorIdx%7;

		eColor =
			(uColorIdx == 0) ? C_RED :
			(uColorIdx == 1) ? C_GREEN :
			(uColorIdx == 2) ? C_BLUE :
			(uColorIdx == 3) ? C_CYAN :
			(uColorIdx == 4) ? C_MAGENTA :
			(uColorIdx == 5) ? C_YELLOW : C_WHITE;

		LCDC_GetDoubleBufAddr(&uDoubleBufAddr, uBufferIdx, WIN0);
		
		GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
		GLIB_ClearFrame(eColor);

		LCDC_Trigger();
		Delay(10);

		LCDC_SetActiveFrameBuf(uBufferIdx, WIN0);
		GLIB_SetFontColor(C_BLACK, eColor, false);
		GLIB_Printf(40, 160, "WINDOW 0's Buffer %d", uBufferIdx);
		LCDC_WTrigger(WIN0);

		Delay(400);

		uBufferIdx++;
		uColorIdx++;

	}
	LCDC_SetWinOnOff(0, WIN0);

	for ( eWin = 1 ; eWin < 5 ; eWin ++)
	{	

		LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW) eWin, true); 
		LCDC_SetWinOnOff(1, (LCD_WINDOW) eWin);

		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW) eWin);

		uColorIdx = 0;
		uBufferIdx = 0;

		Disp("\n");
		Disp("Window %d's Double Buffering Test\n",eWin);
		Disp("Enter Enter Key To Exit Double Buffering Test\n");
		while(GetKey() != '\r')
		{
			uBufferIdx = uBufferIdx%2;
			uColorIdx = uColorIdx%7;

			eColor =
				(uColorIdx == 0) ? C_CYAN :
				(uColorIdx == 1) ? C_RED :
				(uColorIdx == 2) ? C_WHITE :
				(uColorIdx == 3) ? C_BLUE :
				(uColorIdx == 4) ? C_YELLOW :
				(uColorIdx == 5) ? C_MAGENTA : C_GREEN;

			LCDC_GetDoubleBufAddr(&uDoubleBufAddr, uBufferIdx, (LCD_WINDOW) eWin);

			GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
			GLIB_ClearFrame(eColor);
			LCDC_WTrigger((LCD_WINDOW) eWin);

			Delay(10);

			LCDC_SetActiveFrameBuf(uBufferIdx, (LCD_WINDOW) eWin);
			GLIB_SetFontColor(C_BLACK, eColor, false);
			GLIB_Printf(40, 160, "WINDOW %d's Buffer %d", eWin, uBufferIdx);
			LCDC_Trigger();

			Delay(400);

			uBufferIdx++;
			uColorIdx++;
		}
		LCDC_SetWinOnOff(0, (LCD_WINDOW) eWin);
	}
}

static void TestComplexDoubleBuffering(void)
{
	u32 uDoubleBufAddr;
	u32 uHSz, uVSz;

	u32 uBufferIdx = 0;

	bIsRev = false;
	bIsAllWin = false;

	// Enable Double Buffer
	Disp("Enter Any Key To Test Complex Double Buffering\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(eBgBpp, 320*1.5, 240*1.5, 100, 100, 320, 240, 0, 0, uLcdFbAddr, WIN0, true);

	LCDC_SetWinOnOff(1, WIN0);
	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);

	LCDC_Start();
	
	Disp("Window 0's Double Buffering Test\n");
	Disp("Enter Any Key To Exit Test\n");
	while(GetKey() !='\r')
	{
		uBufferIdx = uBufferIdx%2;

		LCDC_GetDoubleBufAddr(&uDoubleBufAddr, uBufferIdx, WIN0);
		GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
		GLIB_SetFontColor(C_BLACK, C_WHITE, true);

		if (uBufferIdx == 0)
		{
			GLIB_DrawPattern(uHSz, uVSz);
			GLIB_Printf(260, 190, "WINDOW 0's Buffer %d", uBufferIdx);
			LCDC_Trigger();
		}
		else
		{
			GLIB_DrawPattern2(uHSz, uVSz);
			GLIB_Printf(260, 190, "WINDOW 0's Buffer %d", uBufferIdx);
			LCDC_Trigger();
		}

		LCDC_SetActiveFrameBuf(uBufferIdx, WIN0);
		LCDC_WTrigger(WIN0);
		uBufferIdx++;
	}

	LCDC_SetWinOnOff(0, WIN0);

	LCDC_InitWin(eBgBpp, uHSz, uVSz, 160, 120, 320, 240, 0, 0, uLcdFbAddr, WIN1, true);
	
	LCDC_SetWinOnOff(1, WIN1);

	LCDC_GetFrmSz(&uHSz, &uVSz, WIN1);
	
	Disp("\n");
	Disp("Window 1's Double Buffering Test\n");
	Disp("Enter Any Key To Exit Test\n");
	while(GetKey() !='\r')
	{
		uBufferIdx = uBufferIdx%2;

		LCDC_GetDoubleBufAddr(&uDoubleBufAddr, uBufferIdx, WIN1);
		GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
		GLIB_SetFontColor(C_BLACK, C_WHITE, true);

		if (uBufferIdx == 0)
		{
			GLIB_DrawPattern(uHSz, uVSz);
			GLIB_Printf(320, 200, "WINDOW 1's Buffer %d", uBufferIdx);
			LCDC_Trigger();
		}
		else
		{
			GLIB_DrawPattern2(uHSz, uVSz);
			GLIB_Printf(320, 200, "WINDOW 1's Buffer %d", uBufferIdx);
			LCDC_Trigger();
		}

		LCDC_SetActiveFrameBuf(uBufferIdx, WIN1);
		LCDC_WTrigger(WIN1);
		uBufferIdx++;
	}

	LCDC_SetWinOnOff(0, WIN1);
}

static void TestAutoDoubleBuffering(void)
{
	u32 uDoubleBufAddr;
	u32 uHSz, uVSz;
	u32 eWin;
	
	u32 uBufferIdx = 0;

	bIsRev = false;
	bIsAllWin = false;

	// Enable Double Buffer
	Disp("Enter Any Key To Test Auto Double Buffering\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);

	LCDC_InitIp(eBgBpp,  uLcdFbAddr, WIN0, true);

	LCDC_GetFrmSz(&uHSz, &uVSz, WIN0);
	LCDC_Start();

	LCDC_GetDoubleBufAddr(&uDoubleBufAddr, 0, WIN0);
	GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_Printf(uHSz/4, uVSz/2, "WINDOW 0's Buffer 0");

	LCDC_GetDoubleBufAddr(&uDoubleBufAddr, 1,    WIN0);
	GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern2(uHSz, uVSz);
	GLIB_Printf(uHSz/4, uVSz/2, "WINDOW 0's Buffer 1");
	
	LCDC_SetActiveFrameBuf(1, WIN0);
	LCDC_EnableAutoBuf(1, WIN0); // 0: Normal Double Buffering 1: Auto Double Buffering

	Disp("Enter Key To Exit Test\n");
	while (GetKey() != '\r')
	{
		LCDC_WTrigger(WIN0);
		LCDC_Trigger();
		LCDC_GetBufIdx(&uBufferIdx, WIN0);


		Disp("Selected Buffer Index(WIN 0): %d\n", uBufferIdx);
		Delay(800);
	}

	LCDC_SetWinOnOff(0, WIN0);
	
	for (eWin = 1 ; eWin < 5  ; eWin++)
	{
	Disp("\n");
	Disp("Enter Any Key To Test WIN %d's Auto Double Buffering\n",eWin);
	UART_Getc();



		LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW) eWin, true);

		uBufferIdx = 0;

		LCDC_GetDoubleBufAddr(&uDoubleBufAddr, 0, (LCD_WINDOW) eWin);
		GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern(uHSz, uVSz);
		GLIB_Printf(uHSz/4, uVSz/2, "WINDOW %d's Buffer %d", eWin, 0);
		LCDC_WTrigger((LCD_WINDOW) eWin);
		LCDC_Trigger();
		
		LCDC_GetDoubleBufAddr(&uDoubleBufAddr, 1,(LCD_WINDOW)  eWin);
		GLIB_InitInstance(uDoubleBufAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern2(uHSz, uVSz);
		GLIB_Printf(uHSz/4, uVSz/2, "WINDOW %d's Buffer %d", eWin, 1);
		LCDC_WTrigger((LCD_WINDOW) eWin);
		LCDC_Trigger();
		
		LCDC_SetActiveFrameBuf(1, (LCD_WINDOW) eWin);
		LCDC_EnableAutoBuf(1, (LCD_WINDOW) eWin); // 0: Normal Double Buffering 1: Auto Double Buffering

		Disp("Enter Key To Exit Test\n");
		while (GetKey() != '\r' )
		{
			LCDC_WTrigger((LCD_WINDOW) eWin);
			LCDC_Trigger();			
			LCDC_GetBufIdx(&uBufferIdx, (LCD_WINDOW) eWin);
			Disp("Selected Buffer Index(WIN %d): %d\n", eWin, uBufferIdx);

			Delay(800);
		}
	LCDC_SetWinOnOff(0, (LCD_WINDOW) eWin);
	}
}

static void TestManualTripleBuffering(void)
{
	u32 uHSz,uVSz;
	u32 uDAddr;
	u32 i,j;
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uHSz,&uVSz);
	
	LCDC_Start();



	for(j=0 ; j<5; j++)
	{
	uDAddr = uLcdFbAddr;
	Disp("\nTest WINDOW %d\n",j);

	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uDAddr, (LCD_WINDOW)j, LCDC_BUF_TRIPLE); 

	GLIB_InitInstance(uDAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);
	GLIB_Printf(0, 0, "buffer 0");
	
	LCDC_GetDoubleBufAddr(&uDAddr, 1, (LCD_WINDOW)j);
	
 	GLIB_InitInstance(uDAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_GREEN);
	GLIB_Printf(0, 0, "buffer 1");

	LCDC_GetDoubleBufAddr(&uDAddr, 2, (LCD_WINDOW)j);

 	GLIB_InitInstance(uDAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_BLUE);
	GLIB_Printf(0, 0, "buffer 2");

	LCDC_EnableAutoBuf(LCDC_BUF_TRIPLE, (LCD_WINDOW)j);
	
	UART_Printf("Trigger test(trigger control register)-----------------------\n");
	while(1)
	{
		Disp("Enter anykey to trigger(x=exit) \n");
		if(UART_Getc() == 'x')
			break;
		LCDC_WTrigger((LCD_WINDOW)j);
	}
	
	UART_Printf("Trigger test(buffer select register)-----------------------\n");
	while(1)
	{
		//buffer 0
		Disp("Enter anykey to select buffer 0....");
		if(UART_Getc() == 'x')
			break;

		LCDC_SetActiveFrameBuf(0,(LCD_WINDOW)j);
		Disp("buffer 0 selected.\n");

		Disp("Enter anykey to display current buffer...");
		if(UART_Getc() == 'x')
			break;
		LCDC_GetBufIdx(&i,(LCD_WINDOW)j);
		Disp("current buffer is %d.\n",i);

		//buffer 10
		Disp("Enter anykey to select buffer 1....");
		if(UART_Getc() == 'x')
			break;

		LCDC_SetActiveFrameBuf(1,(LCD_WINDOW)j);
		Disp("buffer 1 selected.\n");

		Disp("Enter anykey to display current buffer...");
		if(UART_Getc() == 'x')
			break;
		LCDC_GetBufIdx(&i,(LCD_WINDOW)j);
		Disp("current buffer is %d.\n",i);

		//buffer 2
		Disp("Enter anykey to select buffer 2....");
		if(UART_Getc() == 'x')
			break;
		
		LCDC_SetActiveFrameBuf(2,(LCD_WINDOW)j);
		Disp("buffer 2 selected.\n");
		
		Disp("Enter anykey to display current buffer...");
		if(UART_Getc() == 'x')
			break;
		LCDC_GetBufIdx(&i,(LCD_WINDOW)j);
		Disp("current buffer is %d.\n",i);
		
	}
		}

}




// For TestAboveAll, Above de-activated code is recommanded for detailed test
static void TestVirtualScreen(void) 
{
	u32 uBgWinNum, uFgWinNum;
	u32 uFgAddr;
	u32 uBgHSz, uBgVSz, uFgHSz, uFgVSz, uLcdHSz, uLcdVSz;

	u32 uViewPort_X, uViewPort_Y;
	u32 uOsd_X, uOsd_Y;

	u32 i;
	
	bIsRev = false;
	bIsAllWin = false;

	uBgWinNum =
		(eBgWin == WIN0) ? 0 :
		(eBgWin == WIN1) ? 1 :
		(eBgWin == WIN2) ? 2 :
		(eBgWin == WIN3) ? 3 : 4;

	uFgWinNum =
		(eFgWin == WIN0) ? 0 :
		(eFgWin == WIN1) ? 1 :
		(eFgWin == WIN2) ? 2 :
		(eFgWin == WIN3) ? 3 : 4;

	// The number of foreground window must be more than that of background window
	if (uBgWinNum >= uFgWinNum)
	{
		Disp("Error! Invalid Background Window Number or Foreground Window Number\n");
		return;
	}

	// Set Background Parameter
	#if ( LCD_MODEL == LCD_LTV350QV_RGB )
		uBgHSz = 320*2;
		uBgVSz = 240*2;
		
	#elif ( LCD_MODEL == LCD_LTS222Q_RGB || LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uBgHSz = 240*2;
		uBgVSz = 320*2;

	#elif ( LCD_MODEL== LCD_LTP700WV_RGB || LCD_MODEL == LCD_LTE480WV_RGB )
		uBgHSz = 800*2;
		uBgVSz = 480*2;	

	#else
			Assert(0);

	#endif

	Disp("Enter Any Key To Test Virtual Screen\n");
	UART_Getc();
	Disp("\n");

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();

	LCDC_InitWin(eBgBpp, uBgHSz, uBgVSz, 0, 0, uBgHSz/2, uBgVSz/2, 0, 0, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);

	LCDC_Start();


	// Draw Background
	GLIB_InitInstance(uLcdFbAddr, uBgHSz, uBgVSz, eBgBpp);
	GLIB_DrawPattern(uBgHSz, uBgVSz);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(100, 160, "BG's WIN %d", (int)eBgWin);

	GLIB_SetFontColor(C_RED, C_WHITE, true);
	GLIB_Printf(340, 160, "BG's WIN %d", (int)eBgWin);

	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(340, 480, "BG's WIN %d", (int)eBgWin);
	GLIB_Printf(100, 480, "BG's WIN %d", (int)eBgWin);
	LCDC_Trigger();

	// Set Foreground Parameter
	#if (LCD_MODEL == LCD_LTV350QV_RGB)
		uFgHSz = 320/2;
		uFgVSz = 240/2;
	#elif (LCD_MODEL == LCD_LTS222Q_RGB ||LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uFgHSz = 240/2;
		uFgVSz = 320/2;
	#elif (LCD_MODEL== LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uFgHSz = 800/2;
		uFgVSz = 480/2;	
	#else
		Assert(0);
	#endif
	
	uOsd_X = 0;
	uOsd_Y = 0;

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eBgBpp, uFgHSz, uFgVSz, 0, 0, uFgHSz, uFgVSz, uOsd_X, uOsd_Y, uFgAddr, eFgWin, false);
	
	LCDC_Start();

	// Draw foreground
	GLIB_InitInstance(uFgAddr, uFgHSz, uFgVSz, eBgBpp);
	GLIB_DrawPattern2(uFgHSz, uFgVSz);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(20, 60, "FG's WIN %d", (int)eFgWin);
	LCDC_Trigger();

	uViewPort_X = 0;
	uViewPort_Y = 0;

	#if (LCD_MODEL == LCD_LTV350QV_RGB)
		uLcdHSz = 320;
		uLcdVSz = 240;
	#elif (LCD_MODEL == LCD_LTS222Q_RGB ||LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uLcdHSz = 240;
		uLcdVSz = 320;
	#elif (LCD_MODEL== LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uLcdHSz = 800;
		uLcdVSz = 480;	
	#else
		Assert(0);
	#endif
	

	Disp("ViewPort Moving Test\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Right\n");
	Disp("\n");
	for (i=0; i<uBgHSz-uLcdHSz; i++)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Background RIGHT\n");
		if (UART_Getc() == '\r')
		{
			i = uBgHSz-uLcdHSz-1;
			break;
		}

		LCDC_SetViewPosOnFrame(i, uViewPort_Y, eBgWin);
		LCDC_Trigger();
		Disp("ViewPort's Left Top Coordinate (X, Y) : (%d, %d)\n", i, uViewPort_Y);
		Disp("\n");
	}
	uViewPort_X = i;

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Down\n");
	for (i=0; i<uBgVSz - uLcdVSz; i++)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Background DOWN\n");
		if (UART_Getc() == '\r')
		{
			i = uBgVSz - uLcdVSz - 1;
			break;
		}

		LCDC_SetViewPosOnFrame(uViewPort_X, i, eBgWin);
		LCDC_Trigger();
		Disp("ViewPort's Left Top Coordinate (X, Y) : (%d, %d)\n", uViewPort_X, i);
		Disp("\n");
	}
	uViewPort_Y = i;

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Left\n");
	for (i=uViewPort_X; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Background LEFT\n");
		if (UART_Getc() == '\r')
		{
			break;
		}

		LCDC_SetViewPosOnFrame(uViewPort_X--, uViewPort_Y, eBgWin);
		LCDC_Trigger();
		Disp("ViewPort's Left Top Coordinate (X, Y) : (%d, %d)\n", uViewPort_X, uViewPort_Y);
		Disp("\n");
	}

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Up\n");
	for (i=uViewPort_Y; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Background UP\n");
		if (UART_Getc() == '\r')
		{
			break;
		}

		LCDC_SetViewPosOnFrame(0, uViewPort_Y--, eBgWin);
		LCDC_Trigger();
		Disp("ViewPort's Left Top Coordinate (X, Y) : (0, %d)\n", uViewPort_Y);
		Disp("\n");
	}

	Disp("\n");
	Disp("Foreground Moving Test\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Right\n");
	for(i=0; i<uLcdHSz - uFgHSz; i++)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground RIGHT\n");
		if (UART_Getc() == '\r')
		{
			i = uLcdHSz - uFgHSz;
			break;
		}

		LCDC_SetViewPosOnLcd(i, uOsd_Y, eFgWin);
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", i, uOsd_Y);
		Disp("\n");
	}
	uOsd_X = i;

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Down\n");
	for(i=0; i<uLcdVSz - uFgVSz; i++)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground DOWN\n");
		if (UART_Getc() == '\r')
		{
			i = uLcdVSz - uFgVSz - 1;
			break;
		}

		LCDC_SetViewPosOnLcd(uOsd_X, i, eFgWin);
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", uOsd_X, i);
		Disp("\n");

	}
	uOsd_Y = i;

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Left\n");
	for(i=uOsd_X; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground LEFT\n");
		if (UART_Getc() == '\r')
		{
			break;
		}

		LCDC_SetViewPosOnLcd(uOsd_X--, uOsd_Y, eFgWin);
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", uOsd_X, uOsd_Y);
		Disp("\n");

	}

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Up\n");
	for(i=uOsd_Y; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground UP\n");
		if (UART_Getc() == '\r')
		{
			break;
		}

		LCDC_SetViewPosOnLcd(0, uOsd_Y--, eFgWin);
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", 0, uOsd_Y);
		Disp("\n");
	}
}



//////////////////////////// IMG Enhancement Test ///////////////////////////////

static void TestGammaControl(void)
{
	u32 uHSz=320, uVSz=240;
	u32 uWinNum;
	u32 i,j,k;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	
	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
//	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);

	for (uWinNum=0; uWinNum<5; uWinNum++)
	{


		Disp("Enter Any Key To Test WIN%d Gamma Control\n",(LCD_WINDOW)uWinNum);
		UART_Getc();

		LCDC_InitWin(RGB24, 	uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW)uWinNum, false);
		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)uWinNum);
		LCDC_SetGammaOnOff(0);

		
		k=uWinNum%3;
		
		for (i = 0; i<uHSz*uVSz*4; i++)			//buffer clear
		{
			*(u32 *)(uLcdFbAddr +i*4) = 0;
		}
		
			for(i=0; i<256; i++)				//fill in buffer with specific color value
			{
				for(j=0; j<uHSz; j++)
				{
					*(u32*)uLcdFbAddr = (i<<(16-(k*8)));
					uLcdFbAddr += 4;
				}
			}

		if (k==0)
		Disp("Now LCD is showing WIN%d with RED color gradation\n",(LCD_WINDOW)uWinNum);
		else if (k==1)
		Disp("Now LCD is showing WIN%d with GREEN color gradation\n",(LCD_WINDOW)uWinNum);
		else
		Disp("Now LCD is showing WIN%d with BLUE color gradation\n",(LCD_WINDOW)uWinNum);
	
		
	//	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	//	GLIB_DrawPattern(uHSz, uVSz);
		LCDC_Start();
		LCDC_Trigger();

		Disp("Enter Any Key To Test Default Gamma value\n");
		UART_Getc();

		LCDC_SetGammaValue((u8*)defaultLUT);
		LCDC_SetGammaOnOff(1);

		Disp("Enter Any Key To Test High Gamma value\n");
		UART_Getc();
		LCDC_SetGammaOnOff(0);

		LCDC_SetGammaValue((u8*)HighLUT);
		LCDC_SetGammaOnOff(1);

		Disp("Enter Any Key To Test Low Gamma value\n");
		UART_Getc();
		LCDC_SetGammaOnOff(0);

		LCDC_SetGammaValue((u8*)LowLUT);
		LCDC_SetGammaOnOff(1);

	}
	
}


static void TestColorGain(void)
{
	u32 uHSz=320, uVSz=240;
	u32 uCGRed = 256;
	u32 uCGGreen = 256;
	u32 uCGBlue = 256;
	u32 i,j,k;
	u32 uWinNum;
	u32 uLcdFbAddr = CODEC_MEM_ST;
	
	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();

	for (uWinNum=0; uWinNum<5; uWinNum++)
	{


		Disp("Enter Any Key To Test WIN%d Color Gain Control\n",(LCD_WINDOW)uWinNum);
		UART_Getc();

		LCDC_InitWin(RGB24, 	uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, (LCD_WINDOW)uWinNum, false);
		LCDC_GetFrmSz(&uHSz, &uVSz, (LCD_WINDOW)uWinNum);
		k = 0;
		
		while(k < 3)
		{


				
			for (i = 0; i<uHSz*uVSz*4; i++)			//buffer clear
			{
			*(u32 *)(uLcdFbAddr +i*4) = 0;
			}
			
			for(i=0; i<256; i++)				//fill in buffer with specific color value
			{
				for(j=0; j<uHSz; j++)
				{
				*(u32*)uLcdFbAddr = (i<<(16-(k*8)));
				uLcdFbAddr += 4;
				}
			}

			LCDC_Start();
			LCDC_Trigger();
			if (k==0)
			{
				Disp("Enter Any Key To Test Color Gain of RED\n");

				UART_Getc();
				for(i=0; i < 1024; i = i +20 )
				{
					uCGRed = i;
					LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
					Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256\n",uCGRed, uCGGreen, uCGBlue);
					LCDC_SetColorGainOnOff(1);
					
					Disp("Enter Any Key To increase Color Gain of RED\n");
					UART_Getc();	
				}
				uCGRed = 1023;
				LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
				Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256\n",uCGRed, uCGGreen, uCGBlue);
				LCDC_SetColorGainOnOff(1);
			}
			
			else if (k == 1)
			{
				Disp("Enter Any Key To Test Color Gain of GREEN\n");
				UART_Getc();
				uCGRed = 256;
				uCGBlue = 256;

					for(i=0; i < 1024; i = i +20 )
					{
						uCGGreen = i;
						LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
						Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256\n",uCGRed, uCGGreen, uCGBlue);
						LCDC_SetColorGainOnOff(1);

						Disp("Enter Any Key To increase Color Gain of GREEN\n");
						UART_Getc();	
					}
				uCGGreen = 1023;
				LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
				Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256",uCGRed, uCGGreen, uCGBlue);
				LCDC_SetColorGainOnOff(1);
			}

			else
			{
				Disp("Enter Any Key To Test Color Gain of BLUE\n");
				UART_Getc();
				uCGRed = 256;
				uCGGreen = 256;
				i = 0;
					for(i=0; i < 1024; i = i +20 )
					{
					uCGBlue = i;
					LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
					Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256\n",uCGRed, uCGGreen, uCGBlue);
					LCDC_SetColorGainOnOff(1);

					Disp("Enter Any Key To increase Color Gain of BLUE\n");
					UART_Getc();	
					}
				uCGBlue = 1023;
				LCDC_SetColorGainValue(uCGRed, uCGGreen, uCGBlue );
				Disp("Color Gain Red = %d / 256 , Green = %d / 256, Blue = %d / 256\n",uCGRed, uCGGreen, uCGBlue);
				LCDC_SetColorGainOnOff(1);
			}

			k ++ ;
			uLcdFbAddr = CODEC_MEM_ST;
		}

	}

}


static void TestHueControl(void)
{
	u32 uHSz=320, uVSz=240;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test HUE control\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Start();
	LCDC_Trigger();

	
	Disp("Enter Any Key to Test default value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x100,0x100,0x0,0x0, 0x0, 0x0, 0x100, 0x100);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	
	Disp("Enter Any Key to Test (default value - 0x20 ) = 0x80  of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x80,0x80,0x0,0x0, 0x0, 0x0, 0x80, 0x80);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	
	Disp("Enter Any Key to Test (default value -0x60) = 0x40 of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x40,0x40,0x0,0x0, 0x0, 0x0, 0x40, 0x40);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	Disp("Enter Any Key to Test (default value - 0x100) = 0x0 of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x0,0x0,0x0,0x0, 0x0, 0x0, 0x0, 0x0);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);
	
	Disp("Enter Any Key to Test default value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x100,0x100,0x0,0x0, 0x0, 0x0, 0x100, 0x100);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	Disp("Enter Any Key to Test convert value(CBG0 -> CBG1, CRG1-> CRG0) of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x0,0x0,0x100,0x100, 0x100, 0x100, 0x0, 0x0);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	Disp("Enter Any Key to Test default value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x100,0x100,0x0,0x0, 0x0, 0x0, 0x100, 0x100);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	Disp("Enter Any Key to Test 0x300(-1) value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x300,0x300,0x0,0x0, 0x0, 0x0, 0x300, 0x300);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);


	Disp("Enter Any Key to Test 0x340 value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x340,0x340,0x0,0x0, 0x0, 0x0, 0x340, 0x340);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);


	Disp("Enter Any Key to Test 0x380 value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x380,0x380,0x0,0x0, 0x0, 0x0, 0x380, 0x380);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);

	Disp("Enter Any Key to Test 0x3ff(max) value of HUE control\n");
	UART_Getc();
	
	LCDC_SetHUE_CSC_control(CSC_NARROW,CSC_EQ601);
	LCDC_SetHUE_Coef(0x3ff,0x3ff,0x0,0x0, 0x0, 0x0, 0x3ff, 0x3ff);
	LCDC_SetHUE_Offset(0x180, 0x080);
	LCDC_SetHUEOnOff(1);
	
}


static void TestALPSControl(void)
{
	u32 uHSz=320, uVSz=240;
	u32 uAHSz=320, uAVSz=240;	
	u32 uLcdFbAddr = CODEC_MEM_ST;
	u32 n;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Select ALPS test Image [0~23] : \n");
	n=UART_GetIntNum();	

	LCDC_InitLdi(MAIN);
	
	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
/*
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);

	if(LoadFromFile(pALPSTest_Image[n], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pALPSTest_Image[n]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
	}

/*
	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, ALPS_01_320240_24bpp[k++]);
		}
*/	

	LCDC_Trigger();
	LCDC_Start();

	
	Disp("Enter Any Key to Test ALPS\n");
	UART_Getc();
//	LCDC_SetALPSLutValue((u8*)m_LUT_low_R, (u8*)m_LUT_low_G,(u8*)m_LUT_low_B , (u8*)m_LUT_R, (u8*)m_LUT_G, (u8*)m_LUT_B);
	LCDC_SetALPSLutValue((u8*)m_LUT_low_R, (u8*)m_LUT_low_G,(u8*)m_LUT_low_B , (u8*)m_LUT_low_R, (u8*)m_LUT_low_G, (u8*)m_LUT_low_B);
	LCDC_SetALPSOnOff(1);
	LCDC_SetALPSLux(HIGH_LUX);
//	LCDC_SetALPSLux(LOW_LUX);
	while(1)
	{
		Disp("Enter 'x' will break increment test\n");
		LCDC_SetALPSsize(uAHSz,uAVSz);


		Disp("Press '+' key to see bigger screen size \n Press '-' key to see smaller screen size setting\n Press 'x' key to turn off ALPS \n Press 'z' key to turn on ALPS\nPress 'h' key to turn on HIGH_LUX\nPress 'l' key to turn on LOW_LUX\n\n");
		if (UART_Getc()=='x')
			{
			LCDC_SetALPSOnOff(0);
			}
		else if (UART_Getc()=='z')
			{
			LCDC_SetALPSOnOff(1);
			}
		else if (UART_Getc()=='h')
			{
			LCDC_SetALPSLutValue((u8*)m_LUT_low_R, (u8*)m_LUT_low_G,(u8*)m_LUT_low_B , (u8*)m_LUT_R, (u8*)m_LUT_G, (u8*)m_LUT_B);
			LCDC_SetALPSLux(HIGH_LUX);
			}
		else if (UART_Getc()=='l')
			{
			LCDC_SetALPSLutValue((u8*)m_LUT_low_R, (u8*)m_LUT_low_G,(u8*)m_LUT_low_B , (u8*)m_LUT_low_R, (u8*)m_LUT_low_G, (u8*)m_LUT_low_B);
			LCDC_SetALPSLux(HIGH_LUX);
//			LCDC_SetALPSLux(LOW_LUX);
			}
		else if (UART_Getc()=='n')
			{
			LCDC_SetALPSLutFullValue((u32*)m_Old_LUT_low, (u32*)m_Old_LUT_low);
			LCDC_SetALPSLux(HIGH_LUX);
			}
		else if (UART_Getc()=='m')
			{
			LCDC_SetALPSLutFullValue((u32*)m_Old_LUT_low, (u32*)m_Old_LUT_High);
			LCDC_SetALPSLux(HIGH_LUX);
//			LCDC_SetALPSLux(LOW_LUX);
			}
		else if(UART_Getc()=='+')
		{
			uAHSz = uAHSz + 10;
			uAVSz = uAVSz + 10;
			Disp("Horizental size = %d , Vertical size = %d \n",uAHSz , uAVSz);
			if(uAHSz > 1024)
			break;
		}
		else if(UART_Getc()=='-')
		{
			uAHSz = uAHSz - 10;
			uAVSz = uAVSz - 10;
			Disp("Horizental size = %d , Vertical size = %d \n",uAHSz , uAVSz);
			if(uAHSz < 240)
			break;
		}
		else if (UART_Getc()=='\r')
		break;



	}

	Disp("\n\n");

	LCDC_SetALPSOnOff(0);
	
}


static void TestPixelComp(void)
{
	u32 uHSz=320, uVSz=240;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Dithering\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Trigger();

}

//Result image is same to original image
static void TestDithering(void)
{
	u32 uHSz, uVSz;
	u32 i,j,k;
	u32 uSelNum;
	IMG_FMT eBpp;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Dithering\n\n");
	UART_Getc();


	Disp("[0] RGB 24bpp BMP Image(320x240)\n");
	Disp("[1] RGB 16bpp BMP Image(320x240)\n");
	Disp("[2] RGB 16bpp TN Image(480x384)\n");
	Disp("[3] RGB 24bpp TN Image(480x384)\n\n");	
	Disp("Select Image which you want to download :");
	uSelNum = UART_GetIntNum();
	Disp("\n");


	if(uSelNum == 0)
	{

		uHSz = 320;
		uVSz = 240;
		eBpp = RGB24;
		if(LoadFromFile(pDitherTest_Image[uSelNum], uBMPSrcAddr)) // Load NV12 img from mem
		{
			Disp("Success to load image(%s)\n", pDitherTest_Image[uSelNum]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
		}		

	}
	else if(uSelNum == 1)
	{

		uHSz = 320;
		uVSz = 240;
		eBpp = RGB16;
		if(LoadFromFile(pDitherTest_Image[0], uBMPSrcAddr)) // Load NV12 img from mem
		{
			Disp("Success to load image(%s)\n", pDitherTest_Image[uSelNum]);
			ConvertBmpToRgb16bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
		}		

	}
	else if(uSelNum == 2)
	{

		uHSz = 480;
		uVSz = 384;
		eBpp = RGB16;
			if(LoadFromFile(pDitherTest_Image[uSelNum], uLcdFbAddr) == 0)
				Disp("Fail to load image\n");
			else
			{
				LCDC_Trigger();
				Disp("Success to load image\n");
			}

	}
	else if(uSelNum == 3)
	{

		uHSz = 480;
		uVSz = 384;
		eBpp = RGB24;
			if(LoadFromFile(pDitherTest_Image[uSelNum], uLcdFbAddr) == 0)
				Disp("Fail to load image\n");
			else
			{
				LCDC_Trigger();
				Disp("Success to load image\n");
			}

	}	

	LCDC_InitLdi(MAIN);




	LCDC_InitBase();
	LCDC_InitWin(eBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, eBgWin, false);	
//	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
/*
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/	

/*
	GLIB_InitInstance(uLcdFbAddr, 320, 240, RGB16);

	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, sun320240_16bpp[k++]);
		}

	LCDC_Trigger();
*/
	Disp("Display Image BEFORE Dithering\n");


	LCDC_Start();


	Disp("\nEnter any key to dither 16bit.\n");

	UART_Getc();
	LCDC_SetDitheringOnOff(1); // 1 -> Enable Dithering
	LCDC_SetDitheringValue(DITH_5BIT, DITH_6BIT, DITH_5BIT); 

	Disp("\nEnter any key to dither 18bit.\n");
	UART_Getc();
	LCDC_SetDitheringValue(DITH_6BIT, DITH_6BIT, DITH_6BIT); 

	Disp("\nEnter any key to dither 24bit.\n");
	UART_Getc();
	LCDC_SetDitheringValue(DITH_8BIT, DITH_8BIT, DITH_8BIT); 

	Disp("Enter any key to exit");
	UART_Getc();

	
}


// [Test DMA-in FIFO-out for basic function]
static void TestLocalPath(void)
{
	u32 i;
	FIMC_CH eCh;
	u32 uSelNum;
	u8 bEnable;
	u32 uFgAddr;
	u32 uLcdHsz,uLcdVsz;
	u32 uDispHSz, uDispVSz;

	Disp("[0] FIMC 0\n");
	Disp("[1] IPC(FIMC 1)\n");
	Disp("[2] FIMC 2\n");	
	Disp("Selec Local path you want to test :");
	uSelNum = UART_GetIntNum();

	switch(uSelNum)
	{
		case 0: 	eCh = FIMC_A;
					break;
					
		case 1: 	eCh = FIMC_B;
					break;
					
		case 2: 	eCh = FIMC_C;
					break;					
	}
		
	INTC_Init();
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	INTC_Enable(NUM_LCD0);


	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHsz, &uLcdVsz);
	uDispHSz = (uLcdHsz/2)-((uLcdHsz/2)%16);
	uDispVSz = (uLcdVsz/2)-((uLcdVsz/2)%16);		
	switch(uSelNum)
	{
		case FIMC_A:
			LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN0, uDispHSz, uDispVSz, 32, 32);
			LCDC_SetWinOnOff(0, WIN0);
			break;
		case FIMC_B:
			LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, uDispHSz, uDispVSz, 32, 32);
			LCDC_SetWinOnOff(0, WIN1);			
			break;
		case FIMC_C:
			LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN2, uDispHSz, uDispVSz, 32, 32);
			LCDC_SetWinOnOff(0, WIN2);			
			break;
		default:
			Assert(0);
			break;			
	}
	LCDC_EnableAllWinFifoLvlInt(EMPTY);


///////////////////////// Enable WIN3 //////////////////////////
	uFgAddr = uLcdFbAddr + (800*480*4);

	LCDC_InitWin(RGB24, uLcdHsz, uLcdVsz/2, 0, 0, uLcdHsz, uLcdVsz/2,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(0, WIN3);	

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uLcdHsz, uLcdVsz/2, RGB24);
	GLIB_ClearFrame(C_YELLOW);
	LCDC_SetWinOnOff(1, WIN3);	
	
///////////////////////// Enable WIN4 //////////////////////////
	LCDC_GetFbEndAddr(&uFgAddr, WIN3);
	LCDC_InitWin(RGB24, uLcdHsz, uLcdVsz/2, 0, 0, uLcdHsz, uLcdVsz/2,	0, uLcdVsz/2, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(0, WIN4);	

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uLcdHsz, uLcdVsz/2, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_SetWinOnOff(1, WIN4);	

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 40, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);
	

	LCDC_Start();	

	for(i=0; i<2; i++)
	{

		
		Disp("\n Press any key to start local path! \n");
		UART_Getc();

		// Generate DMA input image
		GLIB_InitInstance(uLcdFbAddr, uLcdHsz, uLcdVsz, RGB24);
		switch(i)
		{
			case 0:
				GLIB_DrawPattern(uLcdHsz, uLcdVsz);
				break;
			case 1:
				GLIB_DrawPattern2(uLcdHsz, uLcdVsz);
				break;
			default:
				Assert(0);
				break;
		}		

		FIMC_InitIpForDinFout(eCh,
			uLcdHsz, uLcdVsz, 0,
			0, 0, uLcdHsz, uLcdVsz,
			uLcdFbAddr, RGB24, false,
			uDispHSz, uDispVSz, // Fifo out display size
			LOCAL_IF_YCBCR444, PROGRESSIVE,
			ROT_NO_FLIP_NO, CSC_ITU709, YCBCR_NARROW);

		FIMC_StartProcessing(eCh, false, 0, 0, false, 0);


		switch(uSelNum) 
		{
			case FIMC_A:
				LCDC_SetLocalEn(LOCAL_EN, WIN0);
				LCDC_SetWinOnOff(1, WIN0);
				break;
			case FIMC_B:
				LCDC_SetLocalEn(LOCAL_EN, WIN1);	
				LCDC_SetWinOnOff(1, WIN1);
				break;
			case FIMC_C:
				LCDC_SetLocalEn(LOCAL_EN, WIN2);	
				LCDC_SetWinOnOff(1, WIN2);
				break;
			default:
				Assert(0);
				break;			
		}



		Disp("\n Press any key to stop! \n");
		UART_Getc();



/////////////////////////////////////////////////////////////////////

		switch(uSelNum) 
		{
			case FIMC_A:
				LCDC_SetLocalEn(LOCAL_DIS, WIN0);
				break;
			case FIMC_B:
				LCDC_SetLocalEn(LOCAL_DIS, WIN1);	
				break;
			case FIMC_C:
				LCDC_SetLocalEn(LOCAL_DIS, WIN2);	
				break;
			default:
				Assert(0);
				break;			
		}

		do
		{
			FIMC_GetLcdcEnstatus(eCh, &bEnable);
		}
		while(bEnable);
		
		FIMC_SetDinEnvid(eCh, false); // ENVID forced off	
		
		FIMC_StopProcessing(eCh);

//////////////////////////////////////////////////////////////////////

	}

}


static void TestLocalPathChangeAging(void)
{
	u32 i;
	FIMC_CH eCh;
	u32 uSelNum;
	u8 bEnable;
	u32 uFgAddr;
	u32 uLcdHsz,uLcdVsz;
	u32 uDispHSz, uDispVSz;




	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_GetLcdSz(&uLcdHsz, &uLcdVsz);
	uDispHSz = (uLcdHsz/2)-((uLcdHsz/2)%16);
	uDispVSz = (uLcdVsz/2)-((uLcdVsz/2)%16);		
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN0, uDispHSz, uDispVSz, 32, 32);
	LCDC_SetWinOnOff(0, WIN0);
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, uDispHSz, uDispVSz, 32, 32);
	LCDC_SetWinOnOff(0, WIN1);			
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN2, uDispHSz, uDispVSz, 32, 32);
	LCDC_SetWinOnOff(0, WIN2);			

	LCDC_EnableAllWinFifoLvlInt(EMPTY);


///////////////////////// Enable WIN3 //////////////////////////
	uFgAddr = uLcdFbAddr + (800*480*4);

	LCDC_InitWin(RGB24, uLcdHsz, uLcdVsz/2, 0, 0, uLcdHsz, uLcdVsz/2,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(0, WIN3);	

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uLcdHsz, uLcdVsz/2, RGB24);
	GLIB_ClearFrame(C_YELLOW);
	LCDC_SetWinOnOff(1, WIN3);	
	
///////////////////////// Enable WIN4 //////////////////////////
	LCDC_GetFbEndAddr(&uFgAddr, WIN3);
	LCDC_InitWin(RGB24, uLcdHsz, uLcdVsz/2, 0, 0, uLcdHsz, uLcdVsz/2,	0, uLcdVsz/2, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(0, WIN4);	

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uLcdHsz, uLcdVsz/2, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_SetWinOnOff(1, WIN4);	

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 40, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);
	

	LCDC_Start();	

	// Generate DMA input image
	GLIB_InitInstance(uLcdFbAddr, uLcdHsz, uLcdVsz, RGB24);
	GLIB_DrawPattern(uLcdHsz, uLcdVsz);

	
	uSelNum = 0;
	while(!UART_GetKey())
	{



		switch(uSelNum)
		{
			case 0: 	eCh= FIMC_A;
						Disp("[0] FIMC 0\n");

						break;
						
			case 1: 	eCh= FIMC_B;
						Disp("[1] IPC(FIMC 1)\n");
						break;
						
			case 2: 	eCh= FIMC_C;
						Disp("[2] FIMC 2\n");	
						break;					
		}
			
		GLIB_Printf(0,0,"WIN %d",uSelNum);	


	

		FIMC_InitIpForDinFout(eCh,
			uLcdHsz, uLcdVsz, 0,
			0, 0, uLcdHsz, uLcdVsz,
			uLcdFbAddr, RGB24, false,
			uDispHSz, uDispVSz, // Fifo out display size
			LOCAL_IF_YCBCR444, PROGRESSIVE,
			ROT_NO_FLIP_NO, CSC_ITU709, YCBCR_NARROW);

		FIMC_StartProcessing(eCh,false, 0, 0, false, 0);


		switch(uSelNum) 
		{
			case FIMC_A:
				LCDC_SetLocalEn(LOCAL_EN, WIN0);
				LCDC_SetWinOnOff(1, WIN0);
				break;
			case FIMC_B:
				LCDC_SetLocalEn(LOCAL_EN, WIN1);	
				LCDC_SetWinOnOff(1, WIN1);
				break;
			case FIMC_C:
				LCDC_SetLocalEn(LOCAL_EN, WIN2);	
				LCDC_SetWinOnOff(1, WIN2);
				break;
			default:
				Assert(0);
				break;			
		}


		DelayfrTimer(milli,3000);

/////////////////////////////////////////////////////////////////////

		switch(uSelNum) 
		{
			case FIMC_A:
				LCDC_SetLocalEn(LOCAL_DIS, WIN0);
				break;
			case FIMC_B:
				LCDC_SetLocalEn(LOCAL_DIS, WIN1);	
				break;
			case FIMC_C:
				LCDC_SetLocalEn(LOCAL_DIS, WIN2);	
				break;
			default:
				Assert(0);
				break;			
		}

		do
		{
			FIMC_GetLcdcEnstatus(eCh,&bEnable);
		}
		while(bEnable);
		
		FIMC_SetDinEnvid(eCh,false); // ENVID forced off	
		
		FIMC_StopProcessing(eCh);

//////////////////////////////////////////////////////////////////////

		DelayfrTimer(milli,1000);

		uSelNum ++;
		if(uSelNum == 3)
			uSelNum = 0;

	}
}


void TestImgDown(void)
{
	u32 uTmpNum;
	u32 uSelNum,uSelNum2;
	u32 uHSz, uVSz;

	Disp("[0] WVGA test IMG \n");
	Disp("[1] ALPS test IMG \n");
	Disp("[2] Dual Display test IMG \n");	
	Disp("[3] WVGA portrait test IMG \n");		
	Disp("Select case which you want to download :");
	uSelNum = UART_GetIntNum();
	Disp("\n");
	
	if (uSelNum == 0 )
	{
	Disp("These are WVGA Landscape (800x480) Images \n");
	Disp(" [0] ~ [25] \n");
	Disp("Select Image number you want to download : ");
	uSelNum2 = UART_GetIntNum();
	Disp("\n");		
		if(LoadFromFile(pWVGATest_Image[uSelNum2], uBMPSrcAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pWVGATest_Image[uSelNum2]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 800, 480);
		}
	}
	else if(uSelNum == 2)
	{
		Disp("[0] 320x480\n");
		Disp("[1] 320x240\n");
		Disp("[2] 800x480 browser top\n");
		Disp("[3] 800x480 browser bottm\n");
		Disp("[4] 800x960 frame image\n");
		Disp("[5] 800x960 frame image dark\n");		
		Disp("[6] 800x960\n");
		Disp("[7] 480x800 browser top\n");
		Disp("[8] 480x800 browser bottm\n");
		Disp("[9] 960x800\n");	
		Disp("[10] 480x1600\n");
		Disp("[11] keyboard_800_480\n");
		Disp("Select Image you want to load :  ");
		uTmpNum = UART_GetIntNum();
		Disp("\n");

		switch(uTmpNum)
			{
			case 0 :  uHSz = 320;
					uVSz = 480;
					break;

			case 1 :  uHSz = 320;
					uVSz = 240;
					break;

			case 2 :  uHSz = 800;
					uVSz = 480;
					break;

			case 3 :  uHSz = 800;
					uVSz = 480;
					break;

			case 4 :  uHSz = 800;
					uVSz = 960;
					break;
					
			case 5 :  uHSz = 800;
					uVSz = 960;
					break;
					
			case 6 :  uHSz = 800;
					uVSz = 960;
					break;					
					
			case 7 :  uHSz = 480;
					uVSz = 800;
					break;
					
			case 8 :  uHSz = 480;
					uVSz = 800;
					break;				

			case 9 :  uHSz = 960;
					uVSz = 800;
					break;				

			case 10 : uHSz = 480;
					uVSz = 1600;
					break;
					
			case 11 : uHSz = 800;
					uVSz = 480;
					break;

			case 12 : uHSz = 240;
					uVSz = 320;

					break;

			}

		if(uTmpNum == 12)
		{
			if(LoadFromFile(pDualTest_Image[uTmpNum], uBMPSrcAddr)) // Load NV12 img from mem
			{
				UART_Printf("Success to load image(%s)\n", pDualTest_Image[uTmpNum]);
				ConvertBmpToRgb16bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
			}
		}

		else
		{
			if(LoadFromFile(pDualTest_Image[uTmpNum], uBMPSrcAddr)) // Load NV12 img from mem
			{
				UART_Printf("Success to load image(%s)\n", pDualTest_Image[uTmpNum]);
				ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
			}
		}
	}
	else if(uSelNum == 3)
	{
	Disp("These are WVGA Portrait (480x800) Images \n");
	Disp(" [0] ~ [25] \n");
	Disp("Select Image number you want to download : ");
	uSelNum2 = UART_GetIntNum();
	Disp("\n");		
		if(LoadFromFile(pWVGATestp_Image[uSelNum2], uBMPSrcAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pWVGATestp_Image[uSelNum2]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 480, 800);
		}
	}


}

void TestImgMake(void)
{
	u32 uSelNum,uSelNum2;
	u32 i;
	u32 uFbAddr = CODEC_MEM_ST;
	u32 uBMPAddr = CODEC_MEM_ST+0x4B000;


	Disp("Which frame do you want to start to make RGB24 raw data ? ");
	uSelNum = UART_GetIntNum();
	Disp("\nHow many frame do you want to make as an RGB24 raw data ? ");
	uSelNum2 = UART_GetIntNum();
	Disp("\n");
	uSelNum2 = uSelNum + uSelNum2;

	for(i = uSelNum ; i < uSelNum2 ; i++)
	{

	if(LoadFromFile(pmDNIeStream_Image[i], uBMPAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pmDNIeStream_Image[i]);
//			ConvertStrBmpToRgb24bpp((u32)uBMPAddr, (u32)uFbAddr, 320, 240);
			ConvertBmpToRgb24bpp((u32)uBMPAddr, (u32)uFbAddr, 320, 240);
		}

	uFbAddr	=	uFbAddr + 0x4B000;
	uBMPAddr = uFbAddr + 0x4B000;		

	}

	
}


void TestDualLcdDemo(void)
{

	u32 uTmpNum;
	u32 i;
	u32 uFbAddrB,uFbAddrC,uFbAddrD,uFbAddrE,uFbAddrF;

	bIsRev = false;
	bIsAllWin = false;

		if(LoadFromFile(pDualDemo_Image[0], uBMPSrcAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pDualDemo_Image[0]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 800, 960);
		}

		uFbAddrB = uLcdFbAddr + (800 * 960 * 4);

	if(LoadFromFile(pDualDemo_Image[1], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[1]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 800, 480);
	}

		uFbAddrC = uFbAddrB + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[2], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[2]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrC, 800, 480);
	}


		uFbAddrD = uFbAddrC + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[3], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[3]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrD, 800, 480);
	}

		uFbAddrE = uFbAddrD + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[4], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[4]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrE, 800, 480);
	}


		uFbAddrF = uFbAddrE + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[5], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[5]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrF, 800, 480);
	}





	Disp("Enter Any Key To test Dual Display\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
//	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
//	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	LCDC_InitBaseDualFs();
	LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eBgWin);
	
	//LCD B Init	
	LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrB, eFgWin, false);
	LCDC_SetWinOnOff(0,eFgWin);
	
//	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin,eFgWin, false,LCD_LANDSCAPE);


	Disp("Press any key To see dual display img \n");
	UART_Getc();
	LCDC_Stop();

	LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);
	LCDC_InitGpioDualLCD(LCD_DUAL);
	Disp("Display Dual LCD\n");

	LCDC_Start();	


	Disp("Press any key To see WIN1 blending of keyboard img \n");
	UART_Getc();
	
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eFgWin);
	LCDC_SetAlpha(0xAF, 0xAF, 0xAF, 0x0, 0x0, 0x0, eFgWin);
	LCDC_SetWinOnOff(1,WIN1);	


	Disp("Press any key To see WIN0 on LCD A               WIN1 on LCD B \n");
	UART_Getc();
	LCDC_SetAllWinOnOff(0);

	LCDC_GetFbEndAddr(&uFbAddrC, eFgWin);

	LCDC_InitWin(RGB24,800,480, 0, 0,800, 480,0,0, uFbAddrC, eBgWin, false);

	LCDC_GetFbEndAddr(&uFbAddrD, eBgWin);
	
	//LCD B Init	
	LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrD, eFgWin, false);
//	LCDC_SetWinOnOff(0,eFgWin);

	i = 0;
	while(!UART_GetKey())
		{
			if(i%2 == 0)		
			{
			LCDC_SetWinShadowP(ALLWIN, 1);
			LCDC_SetWinFrmBfAddr(uFbAddrE, eBgWin, false);
			LCDC_SetWinFrmBfAddr(uFbAddrF, eFgWin, false);		
			LCDC_SetWinShadowP(ALLWIN, 0);
			}
			else
			{
			LCDC_SetWinShadowP(ALLWIN, 1);
			LCDC_SetWinFrmBfAddr(uFbAddrC, eBgWin, false);
			LCDC_SetWinFrmBfAddr(uFbAddrD, eFgWin, false);		
			LCDC_SetWinShadowP(ALLWIN, 0);

			}
		i=i+1;
		Delay(100000);
		}


	while(1)	
		{
			Disp("Press 'q' key to see LCD A(Main)\nPress 'w' key to see LCD B(Sub)\nPress 'r' key to see Single mode\nPress 'e' key to see Demo 3 mode\nPress 'd' key to see Demo 4 mode\nPress 't' key to see Demo 1 mode\nPress 'y' key to see Demo 2 mode\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
	
			if(uTmpNum == 'q')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
				}				

			else if(uTmpNum == 'w')
				{
				Disp("Display LCD B(Sub)\n");
				LCDC_InitGpioDualLCD(LCD_B);
				}
			
			else if(uTmpNum == 'r')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
								
				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_SINGLE,VDEN_DIS);
				LCDC_InitIp(RGB24, uLcdFbAddr,eBgWin,false);
				LCDC_SetClkVal(1);
				LCDC_Start();								
				}

			else if(uTmpNum == 'e')
				{
				LCDC_SetAllWinOnOff(0);
				LCDC_InitGpioDualLCD(LCD_DUAL);

				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,480, 0, 0,800, 480,0,0, uFbAddrC, eBgWin, false);

				LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrD, eFgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				}

			else if(uTmpNum == 'd')
				{
				LCDC_SetAllWinOnOff(0);
				LCDC_InitGpioDualLCD(LCD_DUAL);

				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,480, 0, 0,800, 480,0,0, uFbAddrE, eBgWin, false);

				LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrF, eFgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				}

			else if(uTmpNum == 't')
				{
				LCDC_SetAllWinOnOff(0);				
				LCDC_InitGpioDualLCD(LCD_DUAL);
				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				
				}
			
			else if(uTmpNum == 'y')
				{
				LCDC_SetAllWinOnOff(0);				
				LCDC_InitGpioDualLCD(LCD_DUAL);
				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);
				LCDC_Start();				

				LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrB, eFgWin, false);
				LCDC_SetWinOnOff(0,eFgWin);

				LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eFgWin);
				LCDC_SetAlpha(0xAF, 0xAF, 0xAF, 0x0, 0x0, 0x0, eFgWin);
				LCDC_SetWinOnOff(1,WIN1);	

				
				}
								
												
	
			else if(uTmpNum == '\r')
				{
				break;
				}
			

		}



}

void TestDualLcdDemoLight(void)
{

	u32 uTmpNum;
	u32 uFbAddrB,uFbAddrC,uFbAddrD;

	bIsRev = false;
	bIsAllWin = false;

		if(LoadFromFile(pDualDemo_Image[0], uBMPSrcAddr)) // Load NV12 img from mem
		{
			UART_Printf("Success to load image(%s)\n", pDualDemo_Image[0]);
			ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 800, 960);
		}

		uFbAddrB = uLcdFbAddr + (800 * 960 * 4);

	if(LoadFromFile(pDualDemo_Image[1], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[1]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrB, 800, 480);
	}

		uFbAddrC = uFbAddrB + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[2], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[2]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrC, 800, 480);
	}

		uFbAddrD = uFbAddrC + (800 * 480 * 4);

	if(LoadFromFile(pDualDemo_Image[3], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualDemo_Image[3]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uFbAddrD, 800, 480);
	}

	Disp("Enter Any Key To test Dual Display\n");
	UART_Getc();

	LCDC_InitLdi(MAIN);
//	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
//	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	LCDC_InitBaseDualFs();
	LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

	LCDC_GetFbEndAddr(&uFbAddrB, eBgWin);
	
	//LCD B Init	
	LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrB, eFgWin, false);
	LCDC_SetWinOnOff(0,eFgWin);
	
//	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin,eFgWin, false,LCD_LANDSCAPE);


	Disp("Press any key To see dual display img \n");
	UART_Getc();
	LCDC_Stop();

	LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);
	LCDC_InitGpioDualLCD(LCD_DUAL);
	Disp("Display Dual LCD\n");

	LCDC_Start();	


	Disp("Press any key To see WIN1 blending of keyboard img \n");
	UART_Getc();
	
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eFgWin);
	LCDC_SetAlpha(0xAF, 0xAF, 0xAF, 0x0, 0x0, 0x0, eFgWin);
	LCDC_SetWinOnOff(1,WIN1);	


	Disp("Press any key To see WIN0 on LCD A               WIN1 on LCD B \n");
	UART_Getc();
	LCDC_SetAllWinOnOff(0);

	LCDC_GetFbEndAddr(&uFbAddrC, eFgWin);

	LCDC_InitWin(RGB24,800,480, 0, 0,800, 480,0,0, uFbAddrC, eBgWin, false);

	LCDC_GetFbEndAddr(&uFbAddrD, eBgWin);
	
	//LCD B Init	
	LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrD, eFgWin, false);
//	LCDC_SetWinOnOff(0,eFgWin);

	while(1)	
		{
			Disp("Press 'q' key to see LCD A(Main)\nPress 'w' key to see LCD B(Sub)\nPress 'r' key to see Single mode\nPress 'e' key to see Demo 3 mode\nPress 'd' key to see Demo 4 mode\nPress 't' key to see Demo 1 mode\nPress 'y' key to see Demo 2 mode\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
	
			if(uTmpNum == 'q')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
				}				

			else if(uTmpNum == 'w')
				{
				Disp("Display LCD B(Sub)\n");
				LCDC_InitGpioDualLCD(LCD_B);
				}
			
			else if(uTmpNum == 'r')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
								
				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_SINGLE,VDEN_DIS);
				LCDC_InitIp(RGB24, uLcdFbAddr,eBgWin,false);
				LCDC_SetClkVal(1);
				LCDC_Start();								
				}

			else if(uTmpNum == 'e')
				{
				LCDC_SetAllWinOnOff(0);
				LCDC_InitGpioDualLCD(LCD_DUAL);

				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,480, 0, 0,800, 480,0,0, uFbAddrC, eBgWin, false);

				LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrD, eFgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				}

			else if(uTmpNum == 't')
				{
				LCDC_SetAllWinOnOff(0);				
				LCDC_InitGpioDualLCD(LCD_DUAL);
				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				
				}
			
			else if(uTmpNum == 'y')
				{
				LCDC_SetAllWinOnOff(0);				
				LCDC_InitGpioDualLCD(LCD_DUAL);
				LCDC_InitBaseDualFs();
				LCDC_InitWin(RGB24,800,960, 0, 0,800, 960,0,0, uLcdFbAddr, eBgWin, false);

				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);
				LCDC_Start();				

				LCDC_InitWin(RGB24,800,480, 0, 0,800,480,0,480, uFbAddrB, eFgWin, false);
				LCDC_SetWinOnOff(0,eFgWin);

				LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, eFgWin);
				LCDC_SetAlpha(0xAF, 0xAF, 0xAF, 0x0, 0x0, 0x0, eFgWin);
				LCDC_SetWinOnOff(1,WIN1);	

				
				}
								
												
	
			else if(uTmpNum == '\r')
				{
				break;
				}
			

		}



}



void TestDualLcdFrameSp(void)
{

	u32 uTmpNum;
	u32 i;



	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To test Dual Display\n");
	UART_Getc();

	Disp("[0] LCD Landscape Scan type \n");
	Disp("[1] LCD Portrait Scan type \n");
	Disp("Select LCD Scan type  :");
	i = UART_GetIntNum();
	Disp("\n");
	if(i == 0)
	{
	LCDC_InitLdi(MAIN);
//	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
//	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin,eFgWin, false,LCD_LANDSCAPE);
	}
	else
	{
	LCDC_InitLdi(MAIN);
//	LCDC_InitIp(RGB24, uLcdFbAddr, eBgWin, false);
//	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin,eFgWin, false,LCD_PORTRAIT);
	}




/*
	LCDC_GetLcdSz(&uHSz, &uVSz);
	if(LoadFromFile(pDualTest_Image[4], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualTest_Image[4]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
	}
*/

	Disp("Press any key To see dual display img \n");
	UART_Getc();
	LCDC_Stop();

	LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);
	LCDC_InitGpioDualLCD(LCD_DUAL);
	Disp("Display Dual LCD\n");

	LCDC_Start();	


/*

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	


	if(LoadFromFile(pDualTest_Image[0], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualTest_Image[0]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
	}


	

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);

	k=0;
	for(i=0; i<uVSz; i++)
	for(j=0; j<uHSz; j++)
		{
		GLIB_PutPixel2(j, i, sun320240_24bpp[k++]);
		}

//	LCDC_Trigger();
*/


	while(1)	
		{
			Disp("Press 'q' key to see LCD A(Main)\nPress 'w' key to see LCD B(Sub)\nPress 'r' key to see Single mode\nPress 'e' key to see Dual mode\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
	
			if(uTmpNum == 'q')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
				}				

			else if(uTmpNum == 'w')
				{
				Disp("Display LCD B(Sub)\n");
				LCDC_InitGpioDualLCD(LCD_B);
				}
			
			else if(uTmpNum == 'r')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
								
				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_SINGLE,VDEN_DIS);
				LCDC_InitIp(RGB24, uLcdFbAddr,eBgWin,false);
				LCDC_SetClkVal(1);
				LCDC_Start();								
				}

			else if(uTmpNum == 'e')
				{
					LCDC_InitGpioDualLCD(LCD_DUAL);
					if(i==0)
					{
					LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_LANDSCAPE);
					}
					else
					{
					LCDC_InitIpDualFs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_PORTRAIT);
					}
				LCDC_SetDualDisplay(FRAME_SPLIT,FIMD_DUAL,VDEN_DIS);			
				LCDC_Start();				
				}
						
	
			else if(uTmpNum == '\r')
				{
				break;
				}
			

		}
}


void TestDualLcdLineSp(void)
{

	u32 uTmpNum;
	u32 i,k;
	u32 uHSz,uVSz;
	LCD_DUAL_VDEN_EN eVdenEn;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To test Dual Display\n");
	UART_Getc();


	Disp("[0] LCD Landscape Scan type \n");
	Disp("[1] LCD Portrait Scan type \n");
	Disp("Select LCD Scan type  :");
	i = UART_GetIntNum();
	Disp("\n");

	Disp("[0] Use VCLK split method \n");
	Disp("[1] Use VDEN split method \n");
	k = UART_GetIntNum();
	Disp("\n");


	if(i == 0)
	{
	LCDC_InitLdi(MAIN);
	LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_LANDSCAPE);
	}
	else if(i == 1)
	{
	LCDC_InitLdi(MAIN);
	LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_PORTRAIT);
	}
	else
	{
	LCDC_InitLdi(MAIN);
	LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_LANDSCAPE);
	}
	

//	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
//	GLIB_InitInstance(uLcdFbAddr, uHSz, (uVSz*2), RGB24);
//	GLIB_DrawPattern(uHSz, (uVSz*2));
//	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	


	LCDC_GetLcdSz(&uHSz, &uVSz);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	

/*
	LCDC_GetLcdSz(&uHSz, &uVSz);
	if(LoadFromFile(pDualTest_Image[4], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualTest_Image[4]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, uHSz, uVSz);
	}
*/


	LCDC_InitGpioDualLCD(LCD_DUAL);

	if(k==0)
	{
	eVdenEn = VDEN_DIS;
	}
	else
	{
	eVdenEn = VDEN_EN;
	}

	LCDC_SetDualDisplay(LINE_SPLIT,FIMD_DUAL,eVdenEn);
	
	Disp("Display Dual LCD\n");

	LCDC_Start();
	

	while(1)	
		{
			Disp("Press 'q' key to see LCD A(Main)\nPress 'w' key to see LCD B(Sub)\nPress 'r' key to see Single mode\nPress 'e' key to see Dual mode\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
	
			if(uTmpNum == 'q')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
				}				

			else if(uTmpNum == 'w')
				{
				Disp("Display LCD B(Sub)\n");
				LCDC_InitGpioDualLCD(LCD_B);
				}

			else if(uTmpNum == 'r')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
								
				LCDC_SetDualDisplay(LINE_SPLIT,FIMD_SINGLE,eVdenEn);
				LCDC_InitIp(RGB24, uLcdFbAddr,eBgWin,false);
				LCDC_SetClkVal(1);
				LCDC_Start();
				}

			else if(uTmpNum == 'e')
				{
				LCDC_InitGpioDualLCD(LCD_DUAL);				
				if (i == 0)
				{
				LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_LANDSCAPE);
				}
				else
				{
				LCDC_InitIpDualLs(RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_PORTRAIT);
				}
				LCDC_SetDualDisplay(LINE_SPLIT,FIMD_DUAL,eVdenEn);
				LCDC_Start();				
				}
						
	
			else if(uTmpNum == '\r')
				{
				break;
				}
			

		}
}



void TestDualLcdLineSp2(void)
{

	u32 i,k;
	u8 uTmpNum;
	u32 uTmpHsz;
	u32 uTmpReg;
	LCD_DUAL_VDEN_EN eVdenEn;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To test Dual Display\n");
	UART_Getc();




	Disp("[0] LCD Landscape Scan type \n");
	Disp("[1] LCD Portrait Scan type \n");
	Disp("Select LCD Scan type  :");
	i = UART_GetIntNum();
	Disp("\n");

	Disp("[0] Use VCLK split method \n");
	Disp("[1] Use VDEN split method \n");
	k = UART_GetIntNum();
	Disp("\n");


	
	if(i == 0)
		{
	LCDC_InitLdi(MAIN);
	LCDC_InitIpDualp(RGB24, uLcdFbAddr,840, eBgWin, eFgWin, false,LCD_LANDSCAPE);
		}
	else
		{
	LCDC_InitLdi(MAIN);
	LCDC_InitIpDualp(RGB24, uLcdFbAddr,840, eBgWin, eFgWin, false,LCD_PORTRAIT);
		}
/*
	if(LoadFromFile(pDualTest_Image[4], uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", pDualTest_Image[4]);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uLcdFbAddr, 800, 960);
	}
*/
/*
	GLIB_InitInstance(uLcdFbAddr, 800, 960, RGB24);
	GLIB_DrawPattern(800, 960);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/
	LCDC_InitGpioDualLCD(LCD_DUAL);

	if(k==0)
	{
	eVdenEn = VDEN_DIS;
	}
	else
	{
	eVdenEn = VDEN_EN;
	}

	LCDC_SetDualDisplay(LINE_SPLIT,FIMD_DUAL,eVdenEn);
	
	Disp("Display Dual LCD\n");

	LCDC_Start();

	uTmpHsz = 840;

	while(1)	
		{
			Disp("Press 'z' key to increase HSIZE\nPress 'x' key to decrease HSIZE\nPress 'f' key to set HSIZE\nPress 'q' key to see LCD A(Main)\nPress 'w' key to see LCD B(Sub)\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
	

			
			if(uTmpNum == 'z')
				{
				LCDC_Stop();
				uTmpHsz = uTmpHsz + 4;
				
				Disp("HSIZE is increased \n");
				if(i == 0)
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_LANDSCAPE);
					}
				else
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_PORTRAIT);
					}
				uTmpReg= Inp32(0xf8000018);
				Disp("Total HSIZE = %d\n",uTmpReg & 0x7ff );
				LCDC_InitGpioDualLCD(LCD_DUAL);				
				LCDC_Start();
				}

			else if(uTmpNum == 'x')
				{
				LCDC_Stop();
				uTmpHsz = uTmpHsz - 4;
				Disp("HSIZE is decreased\n");
				if(i == 0)
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_LANDSCAPE);
					}
				else
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_PORTRAIT);
					}
				
				uTmpReg= Inp32(0xf8000018);
				Disp("Total HSIZE = %d\n",uTmpReg & 0x7ff );
				LCDC_InitGpioDualLCD(LCD_DUAL);				
				LCDC_Start();
				}

			else if(uTmpNum == 'f')
				{
				LCDC_Stop();
				Disp("Write Hsize you want to test (must be over 800)\n");
				uTmpHsz = UART_GetIntNum();
				if ( i == 0 )
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_LANDSCAPE);
					}
				else
					{
				LCDC_InitIpDualp(RGB24, uLcdFbAddr,uTmpHsz, eBgWin, eFgWin, false,LCD_PORTRAIT);
					}
				uTmpReg= Inp32(0xf8000018);
				Disp("Total HSIZE = %d\n",uTmpReg & 0x7ff );
				LCDC_InitGpioDualLCD(LCD_DUAL);				
				LCDC_Start();
				}


			else if(uTmpNum == 'q')
				{
				Disp("Display LCD A(Main)\n");
				LCDC_InitGpioDualLCD(LCD_A);
				
				}				

			else if(uTmpNum == 'w')
				{
				Disp("Display LCD B(Sub)\n");
				LCDC_InitGpioDualLCD(LCD_B);
				}

			else if(uTmpNum == '\r')
				{
				break;
				}
			

		}

}

void TestShadowProtect(void)
{
	u32 uBgWinNum, uFgWinNum;
	u32 uFgAddr;
	u32 uBgHSz, uBgVSz, uFgHSz, uFgVSz, uLcdHSz, uLcdVSz;

	u32 uOsd_X, uOsd_Y;

	u32 i;
	
	bIsRev = false;
	bIsAllWin = false;

	uBgWinNum =
		(eBgWin == WIN0) ? 0 :
		(eBgWin == WIN1) ? 1 :
		(eBgWin == WIN2) ? 2 :
		(eBgWin == WIN3) ? 3 : 4;

	uFgWinNum =
		(eFgWin == WIN0) ? 0 :
		(eFgWin == WIN1) ? 1 :
		(eFgWin == WIN2) ? 2 :
		(eFgWin == WIN3) ? 3 : 4;

	// The number of foreground window must be more than that of background window
	if (uBgWinNum >= uFgWinNum)
	{
		Disp("Error! Invalid Background Window Number or Foreground Window Number\n");
		return;
	}

	// Set Background Parameter
	#if (LCD_MODEL == LCD_LTV350QV_RGB)
		uBgHSz = 320;
		uBgVSz = 240;
	#elif (LCD_MODEL == LCD_LTS222Q_RGB ||LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uBgHSz = 240;
		uBgVSz = 320;
	#elif (LCD_MODEL== LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uBgHSz = 800;
		uBgVSz = 480;	
	#else
		Assert(0);
	#endif

	Disp("Enter Any Key To Test Shadow Protect function\n");
	UART_Getc();
	Disp("\n");

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();

	LCDC_InitWin(eBgBpp, uBgHSz, uBgVSz, 0, 0, uBgHSz, uBgVSz, 0, 0, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_Start();

	LCDC_SetColorMapValue(0xffffff,eBgWin);
	LCDC_SetColorMapOnOff(1,eBgWin);

/*
	// Draw Background
	GLIB_InitInstance(uLcdFbAddr, uBgHSz, uBgVSz, eBgBpp);
	GLIB_ClearFrame(C_WHITE);
	
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(20, 60, "BG's WIN %d", (int)eBgWin);
	*/
	
	LCDC_Trigger();

	// Set Foreground Parameter
	#if (LCD_MODEL == LCD_LTV350QV_RGB)
		uFgHSz = 320/2;
		uFgVSz = 240/2;
	#elif (LCD_MODEL == LCD_LTS222Q_RGB ||LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uFgHSz = 240/2;
		uFgVSz = 320/2;
	#elif (LCD_MODEL== LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uFgHSz = 800/2;
		uFgVSz = 480/2;	
	#else
		Assert(0);
	#endif
	
	uOsd_X = 0;
	uOsd_Y = 0;

	LCDC_GetFbEndAddr(&uFgAddr, eBgWin);
	LCDC_InitWin(eBgBpp, uFgHSz, uFgVSz, 0, 0, uFgHSz, uFgVSz, uBgHSz/2,uBgVSz/2, uFgAddr, eFgWin, false);
	
	LCDC_Start();

	// Draw foreground
	GLIB_InitInstance(uFgAddr, uFgHSz, uFgVSz, eBgBpp);
	GLIB_DrawPattern2(uFgHSz, uFgVSz);
	GLIB_SetFontColor(C_BLACK, C_WHITE, true);
	GLIB_Printf(20, 60, "FG's WIN %d", (int)eFgWin);
	LCDC_Trigger();


	#if (LCD_MODEL == LCD_LTV350QV_RGB)
		uLcdHSz = 320;
		uLcdVSz = 240;
	#elif (LCD_MODEL == LCD_LTS222Q_RGB ||LCD_MODEL == LCD_LTS222Q_SRGB || LCD_MODEL == LCD_LTS222Q_CPU )
		uLcdHSz = 240;
		uLcdVSz = 320;
	#elif (LCD_MODEL== LCD_LTP700WV_RGB ||LCD_MODEL ==LCD_LTE480WV_RGB)
		uLcdHSz = 800;
		uLcdVSz = 480;	
	#else
		Assert(0);
	#endif
	

	uOsd_X = uLcdHSz/2;
	uOsd_Y = uLcdVSz/2;

	Disp("ViewPort Moving Test\n");

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Left\n");
	for(i=uOsd_X; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground LEFT\n");
		if (UART_Getc() == '\r')
		{
			break;
		}
		LCDC_SetWinShadowP(eFgWin,1);		//shadow Protect
		LCDC_SetViewPosOnLcddelay(uOsd_X--, uOsd_Y, eFgWin);
		
		LCDC_SetWinShadowP(eFgWin,0);		//shadow unProtect
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", uOsd_X, uOsd_Y);
		Disp("\n");

	}

	Disp("\n");
	Disp("Enter A \'Enter Key\' To Exit Moving Up\n");
	for(i=uOsd_Y; i>0; i--)
	{
		Disp("Enter Any Key Except \'Enter Key\' To Move Foreground UP\n");
		if (UART_Getc() == '\r')
		{
			break;
		}
		LCDC_SetWinShadowP(eFgWin,1);		//shadow Protect
		LCDC_SetViewPosOnLcddelay(0, uOsd_Y--, eFgWin);
		LCDC_SetWinShadowP(eFgWin,0);		//shadow Protect
		LCDC_Trigger();
		Disp("Foreground's Left Top Coordinate (X, Y) : (%d, %d)\n", 0, uOsd_Y);
		Disp("\n");
	}

}


///////////////////////////////////////////////////////////////////////////////

// manual commnand
static void TestCpuIfByAccessingLdi(void)
{
	u32 uGlibAddr;
	IMG_FMT eBgBpp;
	u32 uHSz, uVSz;
	u32 i;
	u32 uGetNum;
	CPUIF_LDI	eCpuIf;

	Disp("CPU type I/F test\n\n");
	while(1)
	{
	Disp("[0] MAIN           [1] SUB \n");
	Disp("\nWhich LDI do you want to test ?\n");
	uGetNum = UART_GetIntNum();

		if(uGetNum == 0)
		{
		eCpuIf = MAIN;
		break;
		}
		else if(uGetNum == 1)
		{
		eCpuIf = SUB;
		break;
		}
	}

	
	bIsRev = false;
	bIsAllWin = false;

	uGlibAddr = CODEC_MEM_ST;
	eBgBpp = RGB16; // Can't support 24Bpp
	uHSz = 240;
	uVSz = 320;

	GLIB_InitInstance(uGlibAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	LCDC_InitLdi(eCpuIf);

	if(LCD_MODEL == LCD_UF24U276A)
		LCDC_PutCmdToLdiByManual(0x2c, eCpuIf);


	for (i=0; i<uHSz*uVSz; i++)
	{
		LCDC_PutDataToLdiByManual(*((u16*)(uGlibAddr+i*2)), eCpuIf);
	}
	
}


// auto command
static void TestCpuIfAutoCmd(void)
{
	u32 uHSz, uVSz;
	u32 uCmdVal[3];
	u32 i=1;
	u32 uGetNum;
	CPUIF_LDI	eCpuIf;	


	Disp("CPU type I/F test\n\n");
	while(1)
	{
	Disp("[0] MAIN           [1] SUB \n");
	Disp("\nWhich LDI do you want to test ?\n");
	uGetNum = UART_GetIntNum();

		if(uGetNum == 0)
		{
		eCpuIf = MAIN;
		break;
		}
		else if(uGetNum == 1)
		{
		eCpuIf = SUB;
		break;
		}
	}

	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(eCpuIf);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_Start();

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	LCDC_SetAutoCmdRate(PER_TWO_FRM, eCpuIf);

	// LDI (X, Y) coordinate setting
	uCmdVal[0] = 0x4401;
	uCmdVal[1] = 0x4201;
	uCmdVal[2] = 0x4300;
	LCDC_PutCmdToLdi(uCmdVal, 3, eCpuIf, LCD_AUTO_CMD);

	LCDC_WTrigger(6);

	while(true)
	{
		if (LCDC_IsFrameDone() == true)
		{
			Disp("Enter a \'ENTER KEY\' To Exit This Test\n");
			if (UART_Getc() == '\r')
			{
				break;
			}

			LCDC_WTrigger(6);
			i++;
			Disp("Trig Count: %d\n", i);
			Disp("\n");

			if (i%2)
			{
				// Move (X,Y) coordinate by using Auto Command
				uCmdVal[0] += i;
				uCmdVal[1] += i;
				uCmdVal[2] = 0x4300;

				LCDC_PutCmdToLdi(uCmdVal, 3, eCpuIf, LCD_AUTO_CMD);
			}
			
		}
		
	}
	
}


// normal command
static void TestCpuIfPartialDisplay(void)
{
	u32 uHSz, uVSz;
	u32 uBytes;
	u32 uGlibStAddr;
	u32 uGetNum;
	CPUIF_LDI	eCpuIf;

	Disp("CPU type I/F test\n\n");
	while(1)
	{
	Disp("[0] MAIN           [1] SUB \n");
	Disp("\nWhich LDI do you want to test ?\n");
	uGetNum = UART_GetIntNum();

		if(uGetNum == 0)
		{
		eCpuIf = MAIN;
		break;
		}
		else if(uGetNum == 1)
		{
		eCpuIf = SUB;
		break;
		}
	}

	
	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(eCpuIf);
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	LCDC_Start();

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	LCDC_Trigger();

	uBytes = (eBgBpp == RGB24) ? 4: 2;

	uGlibStAddr = uLcdFbAddr + uHSz*uVSz*uBytes;
	GLIB_InitInstance(uGlibStAddr, uHSz, 120,   eBgBpp);
	GLIB_DrawPattern(uHSz, 120);

	Disp("Enter Any Key To Display Partial Area\n");
	UART_Getc();

	// In LCD_LTS222Q_CPU type LDI, Coordinate X must be 0 and Partial HSz must be same to LCD HSz
	LCDC_DisplayPartialArea(0, 0, 0, 100, 240, 120, uGlibStAddr, eBgWin,eCpuIf);
	LCDC_Trigger();
}


// manual command
static void TestCpuIfRead(void)
{
	u32 uGlibAddr;
	IMG_FMT eBgBpp;
	u32 uHSz, uVSz;
	u32 i;
	u32 uReadVal;
	u32 uGetNum;
	CPUIF_LDI	eCpuIf;

	Disp("CPU type I/F test\n\n");
	while(1)
	{
	Disp("[0] MAIN           [1] SUB \n");
	Disp("\nWhich LDI do you want to test ?\n");
	uGetNum = UART_GetIntNum();

		if(uGetNum == 0)
		{
		eCpuIf = MAIN;
		break;
		}
		else if(uGetNum == 1)
		{
		eCpuIf = SUB;
		break;
		}
	}



	bIsRev = false;
	bIsAllWin = false;

	uGlibAddr = CODEC_MEM_ST;
	eBgBpp = RGB16; // Can't support 24Bpp
	uHSz = 240;
	uVSz = 320;

	GLIB_InitInstance(uGlibAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);

	LCDC_InitLdi(eCpuIf);

	for (i=0; i<uHSz*uVSz; i++)
	{
		LCDC_PutDataToLdiByManual(*((u16*)(uGlibAddr+i*2)), eCpuIf);
	}

	Disp("Enter Any Key To Test CPU I/F Read\n");
	UART_Getc();

	//LCDC_InitStartPosOnLcdI80If(MAIN);
	LCDC_InitStartPosOnLcd(eCpuIf);

	LCDC_GetDataFromLdiByManual(&uReadVal, eCpuIf);
	Dbg("Read Data: 0x%x\n", uReadVal);

	LCDC_GetDataFromLdiByManual(&uReadVal, eCpuIf);
	Dbg("Read Data: 0x%x\n", uReadVal);

	LCDC_GetDataFromLdiByManual(&uReadVal, eCpuIf);
	Dbg("Read Data: 0x%x\n", uReadVal);

	LCDC_GetCmdFromLdiByManual(&uReadVal, eCpuIf);
	Dbg("Read Cmd: 0x%x\n", uReadVal);
}

static void TestCpuInt(void)
{	
	u32 uHSz, uVSz;

	bIsRev = false;
	bIsAllWin = false;	
	
	INTC_Init();
	INTC_SetVectAddr(NUM_LCD2, Isr_LCD_I80Int);
	INTC_Enable(NUM_LCD2);

	LCDC_InitLdi(MAIN);
	
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	LCDC_Start();

	INTC_SetVectAddr(NUM_LCD2, Isr_LCD_I80Int);
	
	GLIB_Init(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern2(uHSz, uVSz);

	LCD_InitInt(LCDC_SYSIF_INT, eLcdCpuifInt, UNDER25, FIFO_INT_WIN0, FINT_VSYNC);
	LCDC_EnableInterrupt();
//	INTC_Enable(NUM_LCD2);

	UART_Printf("Enter a 'Enter key' to exit test. \n");
	LCDC_WTrigger(6);
	
	uCount =0;
	
	while(!(UART_Getc() == '\r')){}

	INTC_Disable(NUM_LCD2);
	LCDC_DisableInterrupt();

	
}


static void TestFrmBfIssue(void)
{	
	u32 uHSz, uVSz;
	u8 *pFbAddr;
	u32 i;

	bIsRev = false;
	bIsAllWin = false;	


	
	LCDC_InitLdi(MAIN);
	
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	LCDC_Start();

	GLIB_Init(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern2(uHSz, uVSz);



	while(!UART_GetKey())
		{
		pFbAddr = (u8 *)uLcdFbAddr;		
		for(i=0;i<(uHSz*uVSz*4);i++)
			{
			*pFbAddr = 0xff;
			pFbAddr ++ ;
			}
		}	

	
}


static void DisplayCurrentParam(void)
{
	const char* pcBgBppStr, *pcFgBppStr;

	if (bIsArgb == false)
	{
		pcBgBppStr = (eBgBpp == RGB16) ? "RGB 16 (R:5 G:6 B:5)" : "RGB 24 (R:8 G:8 B:8)";
		pcFgBppStr = (eFgBpp == RGB16) ? "RGB 16 (R:5 G:6 B:5)" : "RGB 24 (R:8 G:8 B:8)";
	}
	else
	{
		pcBgBppStr = (eBgBpp == RGB16) ? "RGB 16 (R:5 G:6 B:5)" : "RGB 24 (R:8 G:8 B:8)";
		pcFgBppStr = (eFgArgbBpp == ARGB16) ? "ARGB 16 (A:1 R:5 G:5 B:5)" : "ARGB 24 (A:1 R:8 G:8 B:7)";
	}

	Disp("\n");
	Disp("==============================================================================\n");
	Disp("1. BACKGROUND INFO.\n");
	Disp("\t- BPP : %s \t - Window Number: WIN %d\n", pcBgBppStr, (int)eBgWin);
	Disp("2. FOREGROUND INFO.\n");
	Disp("\t- BPP : %s \t - Window Number: WIN %d\n", pcFgBppStr, (int)eFgWin);
	Disp("==============================================================================\n");
	
}

static void TestAboveAll(void)
{
	IMG_FMT eBgBppArray[2] = {RGB16, RGB24};
	IMG_FMT eFgBppArray[2] = {RGB16, RGB24};
	LCD_WINDOW eBgWinArray[1] = {WIN0};
	LCD_WINDOW eFgWinArray[4] = {WIN1, WIN2, WIN3, WIN4};

	u32 uBgBppNum = sizeof(eBgBppArray);
	u32 uFgBppNum = sizeof(eFgBppArray);
	u32 uBgWinNum = sizeof(eBgWinArray);
	u32 uFgWinNum = sizeof(eFgWinArray);

	u32 i, j, k, l;


	// complex, virtual screen test
	// Number of case : 16
	for(i=0; i<uBgBppNum; i++) // Test case : 2
	for(j=0; j<uFgBppNum; j++) // Test case : 2
	for(k=0; k<uBgWinNum; k++) // Test case : 1
	for(l=0; l<uFgWinNum; l++) // Test case : 4
	{
		eBgBpp = eBgBppArray[i];
		eFgBpp = eFgBppArray[j];
		eBgWin = eBgWinArray[k];
		eFgWin = eFgWinArray[l];

		bIsArgb = false;
		DisplayCurrentParam();

		Disp("\n");
		Disp("== Complex Display Test ================================\n");
		TestComplexDisplay();

		Disp("\n");
		Disp("== Virtual Screen Test / Soft Scrolling ================\n");
		TestVirtualScreen();
	}

	// complex double buffering test
	// Number of case : 2
	for(i=0; i<uBgBppNum; i++) // Test case : 2
	{
		eBgBpp = eBgBppArray[i];
		bIsArgb = false;
		
		DisplayCurrentParam();
		Disp("\n");
		Disp("== Complex Double Buffering Test =======================\n");
		TestComplexDoubleBuffering();

	}

	// color-key test
	// Number of case : 16
	for(i=0; i<uBgBppNum; i++) // Test case : 2
	for(j=0; j<uFgBppNum; j++) // Test case : 2
	for(k=0; k<uBgWinNum; k++) // Test case : 1
	for(l=0; l<uFgWinNum; l++) // Test case : 4
	{
		bIsArgb = false;

		eBgBpp = eBgBppArray[i];
		eFgBpp = eFgBppArray[j];
		eBgWin = eBgWinArray[k];
		eFgWin = eFgWinArray[l];

		DisplayCurrentParam();

		Disp("\n");
		Disp("== Color Key Test ======================================\n");
		TestColorKey();
	}

	// per-plane, blending test
	// Number of case : 32
	for(i=0; i<uBgBppNum; i++) // Test case : 2
	for(j=0; j<uFgBppNum; j++) // Test case : 2
	for(k=0; k<uBgWinNum; k++) // Test case : 1
	for(l=0; l<uFgWinNum; l++) // Test case : 4
	{
		bIsArgb = false;
		eBgBpp = eBgBppArray[i];
		eFgBpp = eFgBppArray[j];
		eBgWin = eBgWinArray[k];
		eFgWin = eFgWinArray[l];
		
		DisplayCurrentParam();
		Disp("\n");
		Disp("== Per Plane Blending Test =============================\n");
		TestBlendingPerPlane(); // Test case : 2(Alpha Channel)
	}

	// Per-pixel, blending test
	// Number of case : 16
	for(i=0; i<uBgBppNum; i++) // Test case : 2
	for(j=1; j<uFgBppNum; j++) // Test case : 1
	for(k=0; k<uBgWinNum; k++) // Test case : 1
	for(l=0; l<uFgWinNum; l++) // Test case : 4
	{
		eBgBpp = eBgBppArray[i];
		eFgBpp = eFgBppArray[1];
		eBgWin = eBgWinArray[k];
		eFgWin = eFgWinArray[l];
		
		bIsArgb = true;
		eFgArgbBpp = eBgBppArray[1];
		DisplayCurrentParam();
		
		Disp("\n");
		Disp("== Per Pixel Blending Test =============================\n");
			//TestBlendingPerPixel(); // Test case : 2(Alpha Channel)
	}

}



void TestBlendingAllwinPerPlane(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 j;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Per Plane Blending\n");
	UART_Getc();


//	INTC_Init();
//	INTC_SetVectAddr(NUM_LCD0, Isr_L cdcUnderRun);
//	INTC_Enable(NUM_LCD0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);	
	LCDC_GetFrmSz(&uHSz,&uVSz, WIN0);

//	LCDC_EnableAllWinFifoLvlInt(EMPTY);

	LCDC_Start();
	
	// Draw Pattern by using Glib for window 0
	Disp("Window %d(Background) is Displayed\n", (int)WIN0);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);

	Disp("Enter Any Key To Display Window %d\n", (int)WIN1);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN0);
	LCDC_InitWin(RGB24, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	0, 0, uFgAddr, WIN1, false); 	
	LCDC_SetWinOnOff(0, WIN1);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN1);

	// Draw Rectangles by using Glib for window 1
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_SetWinOnOff(1, WIN1);	

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN1);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN1);
	LCDC_InitWin(RGB24, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	0, 0, uFgAddr, WIN2, false); 	
	LCDC_SetWinOnOff(0, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN2);
	LCDC_InitWin(RGB24, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(0, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);
	LCDC_SetWinOnOff(1, WIN3);	
	
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN3);
	LCDC_InitWin(RGB24, uHSz/2, uVSz/2, 0, 0, uHSz/2, uVSz/2,	0, 0, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(0, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_SetWinOnOff(1, WIN4);	

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 40, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);

//	INTC_Disable(NUM_LCD0);

}

void TestPerformanceUnderrun(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 j;

	bIsRev = false;
	bIsAllWin = false;

	Disp("Enter Any Key To Test Per Plane Blending\n");
	UART_Getc();


	INTC_Init();
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdcUnderRun);
	INTC_Enable(NUM_LCD0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);	
	LCDC_GetFrmSz(&uHSz,&uVSz, WIN0);

	LCDC_EnableAllWinFifoLvlInt(EMPTY);

	LCDC_Start();
	
	// Draw Pattern by using Glib for window 0
	Disp("Window %d(Background) is Displayed\n", (int)WIN0);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);

	Disp("Enter Any Key To Display Window %d\n", (int)WIN1);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN0);

	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN1, false); 	
	LCDC_SetWinOnOff(0, WIN1);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN1);

	// Draw Rectangles by using Glib for window 1
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_SetWinOnOff(1, WIN1);	

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN1);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN1);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN2, false); 	
	LCDC_SetWinOnOff(0, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN2);
	uFgAddr = Align(uFgAddr, 0xe00000);	
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(0, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);
	LCDC_SetWinOnOff(1, WIN3);	
	
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN3);

	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(0, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_SetWinOnOff(1, WIN4);	

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 40, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);

//	INTC_Disable(NUM_LCD0);

}


void TestLCDonOff(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uLcdFbAddr = CODEC_MEM_ST;

	bIsRev = false;
	bIsAllWin = false;

	LCDC_InitLdi(MAIN);

	// 1. Set background
	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
	LCDC_Start();	

	UART_Getc();

	LCDC_Stop();
	LCDC_OffTL2796();

}



void TestImgEnhancement(void)
{
	int i, nSel;

	const testFuncMenu menu[]=
	{
		0,                                 "Exit\n",
		TestGammaControl,			"Gamma control Test\n",
		TestColorGain,				"Color Gain Test\n",
		TestHueControl,				"HUE control Test\n",
		TestALPSControl,				"ALPS control Test\n",
		TestPixelComp,				"Pixel Compensation\n",
		TestDithering, 	                   "Dithering Test (Source Img: 24Bpp LCD: 16Bpp)\n",
		0,							       0
	};

	while (1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("================================================================\n");


		Disp("\nSelect the function to test : ");
		nSel = UART_GetIntNum();
		Disp("\n");

		if (nSel == 0)
		{
			break;
		}
		if (nSel>0 && nSel<(sizeof(menu)/8-1))
		{
			 (menu[nSel].func)();
		}
	}
}

static void TestBasicITU656(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uTemp;

	u32 i,j,k; // add. jungil
	
	bIsRev = false;
	bIsAllWin = false;
	
	UART_Printf("Enter Any Key To Test Simple Display\n");
	UART_Getc();

	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_SetITUInterface_656(ITU_INTERLACE);
	UART_Printf("Window %d (Background) Is Displayed\n", (int)eBgWin);

	#if 0 // add jungil 
	LCD_GetFrmSz(&uHSz, &uVSz, eBgWin);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	k=0;
	for(i=0; i<480; i++)
		for(j=0; j<800; j++)
//			GLIB_PutPixel2(j, i, pSmile_3[k++]);
			GLIB_PutPixel2(j, i, pKangjjang01[k++]);		
	#else
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	#endif
	LCDC_Start();

	UART_Printf("Do You Want To See Choi Gang Hi ? Yes:1, No:other\n");
	uTemp = UART_GetIntNum();
	
	LCDC_SetAllWinOnOff(0);

	#if 0 
	if (uTemp == 1 )
	{
		LCD_InitDISPC(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCD_SetWinOnOff(1, eBgWin);
		LCD_GetFrmSz(&uHSz, &uVSz, eBgWin);
		LCD_Start();
		while(1)
		{
			LCD_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, eBgWin, false);
			UART_Printf("Window %d (Background) Is Displayed\n", (int)eBgWin);
			GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
			k=0;
			for(i=0; i<480; i++)
				for(j=0; j<800; j++)
					GLIB_PutPixel2(j, i, pKangjjang03[k++]);
			Delay(100000);
			LCD_SetWinOnOff(0, eBgWin);

			LCD_GetFbEndAddr(&uFgAddr, eBgWin);

			LCD_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFgAddr, eFgWin, false);
			GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
			k=0;
			for(i=0; i<480; i++)
				for(j=0; j<800; j++)
					GLIB_PutPixel2(j, i, pKangjjang01[k++]);
			UART_Printf("Window %d (Foreground) Is Displayed\n", (int)eFgWin);
			LCD_SetWinOnOff(1, eFgWin);
			Delay(100000);
			LCD_SetWinOnOff(0, eFgWin);
			if (UART_GetKey()) break;		
		}
		UART_Printf("\nIf you want to end this test, press any key\n");
		UART_Getc();
	}
	#endif
}

static void TestBasicITU601(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 uTemp;

	u32 i,j,k; // add. jungil
	
	bIsRev = false;
	bIsAllWin = false;
	
	UART_Printf("Enter Any Key To Test Simple Display\n");
	UART_Getc();



	LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
	LCDC_SetWinOnOff(1, eBgWin);
	LCDC_SetITUInterface(ITU_INTERLACE);
	UART_Printf("Window %d (Background) Is Displayed\n", (int)eBgWin);

	#if 0 // add jungil 
	LCD_GetFrmSz(&uHSz, &uVSz, eBgWin);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	k=0;
	for(i=0; i<480; i++)
		for(j=0; j<800; j++)
//			GLIB_PutPixel2(j, i, pSmile_3[k++]);
			GLIB_PutPixel2(j, i, pKangjjang01[k++]);		
	#else
	LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
	#endif
	LCDC_Start();

	UART_Printf("Do You Want To See Choi Gang Hi ? Yes:1, No:other\n");
	uTemp = UART_GetIntNum();
	
	LCDC_SetAllWinOnOff(0);

	#if 0 
	if (uTemp == 1 )
	{
		LCD_InitDISPC(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCD_SetWinOnOff(1, eBgWin);
		LCD_GetFrmSz(&uHSz, &uVSz, eBgWin);
		LCD_Start();
		while(1)
		{
			LCD_InitWin(eBgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uLcdFbAddr, eBgWin, false);
			UART_Printf("Window %d (Background) Is Displayed\n", (int)eBgWin);
			GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
			k=0;
			for(i=0; i<480; i++)
				for(j=0; j<800; j++)
					GLIB_PutPixel2(j, i, pKangjjang03[k++]);
			Delay(100000);
			LCD_SetWinOnOff(0, eBgWin);

			LCD_GetFbEndAddr(&uFgAddr, eBgWin);

			LCD_InitWin(eFgBpp, uHSz, uVSz, 0, 0, uHSz, uVSz, 0, 0, uFgAddr, eFgWin, false);
			GLIB_InitInstance(uFgAddr, uHSz, uVSz, eFgBpp);
			k=0;
			for(i=0; i<480; i++)
				for(j=0; j<800; j++)
					GLIB_PutPixel2(j, i, pKangjjang01[k++]);
			UART_Printf("Window %d (Foreground) Is Displayed\n", (int)eFgWin);
			LCD_SetWinOnOff(1, eFgWin);
			Delay(100000);
			LCD_SetWinOnOff(0, eFgWin);
			if (UART_GetKey()) break;		
		}
		UART_Printf("\nIf you want to end this test, press any key\n");
		UART_Getc();
	}
	#endif
}

void TestRGBSkip(void)
{
	u32 uHSz,uVSz;
	u32 i,j,k;
	u32* pLcdTestAddr;

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24,uLcdFbAddr,WIN0,false);
	LCDC_GetLcdSz(&uHSz,&uVSz);
	LCDC_SetRGBSkip(SKIP_EN);
	k=2;
	pLcdTestAddr = (u32* )uLcdFbAddr;

	for(i=0 ; i<uVSz ; i++)
	{
		for(j=0 ; j<uHSz ; j++)
		{
			*pLcdTestAddr = j << (k*8);
			pLcdTestAddr = pLcdTestAddr +1 ;
			
			if(k==0)
			k = 2;
			else
			k--;
						
		}
	}

	LCDC_Start();
	Disp("Check the data signal[23:16] to see RGB Skip\n");
	Disp("Each pixel data must have increment data\n\n");
	Disp("Press any key to Stop Test\n");	
	UART_Getc();
	LCDC_SetRGBSkip(SKIP_DIS);
	LCDC_Stop();	

}

void TestDummyInsersion(void)
{
	u32 uHSz,uVSz;
	u32 i,j,k;
	u32* pLcdTestAddr;

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24,uLcdFbAddr,WIN0,false);
	LCDC_GetLcdSz(&uHSz,&uVSz);

	
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_WHITE);
	
	LCDC_Start();

	Disp("Press any key to see RGB dummy Insertion with last position\n");
	UART_Getc();
	LCDC_SetRGBdummy(DUMMY_LAST,DUMMY_EN);	
	Disp("Check the data signal[23:16] to see dummy insertion\n\n");
	
	Disp("Press any key to see RGB dummy Insertion with First position\n");
	UART_Getc();
	LCDC_SetRGBdummy(DUMMY_FIRST,DUMMY_EN);	
	Disp("Check the data signal[23:16] to see dummy insertion\n\n");
	
	Disp("Press any key to Stop Test\n");	
	UART_Getc();
	LCDC_SetRGBdummy(DUMMY_FIRST,DUMMY_DIS);	
	LCDC_Stop();

}



void TestLCDCClkPowerOnoffAging(void)
{
	u32 uHSz,uVSz;
	u32 uCnt;
	
	while(!UART_GetKey())
	{
		// T-Block Power Off and On
		SYSC_SetBlockPowerOFF_IP(eFIMD);
		DelayfrTimer(milli, 100);
		SYSC_SetBlockPowerON_IP(eFIMD);

		LCDC_InitLdi(MAIN);

		// 1. Set background
		LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCDC_SetWinOnOff(1, eBgWin);
		LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern(uHSz, uVSz);
		GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
		Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
		LCDC_Start();
		DelayfrTimer(milli, 2000);

		// IP Clock Off and On
		SYSC_SetClkOFF_IP(eFIMD);
		DelayfrTimer(milli, 100);
		SYSC_SetClkON_IP(eFIMD);
		DelayfrTimer(milli, 100);
		
	}


}

void TestLCDClkSrcSelection(void)
{
	u32 uSelNum;
	u32 uHSz, uVSz;

	Disp("[0] XXTI \n");
	Disp("[1] XusbXTI \n");
	Disp("[2] MPLL	\n");
	Disp("[3] EPLL \n");
	Disp("[4] VPLL \n");
	Disp("Select Clock Source which you want to use : ");
	uSelNum = UART_GetIntNum();

	switch(uSelNum)
		{
		case 0 :
					SYSC_SetClkDiv(eCLKDIV_FIMD, 1);
					SYSC_SetClkMuxState(eCLKMUX_FIMD_XXTI);
					break;
		case 1 :
					SYSC_SetClkDiv(eCLKDIV_FIMD, 1);
					SYSC_SetClkMuxState(eCLKMUX_FIMD_XUSBXTI);
					break;			
		case 2 :
					SYSC_SetClkDiv(eCLKDIV_FIMD, 4);
					SYSC_SetClkMuxState(eCLKMUX_FIMD_SMPLL);
					break;
		case 3 :
					SYSC_SetClkDiv(eCLKDIV_FIMD, 1);
					SYSC_SetClkMuxState(eCLKMUX_FIMD_SEPLL);
					break;
		case 4 :
					SYSC_SetClkDiv(eCLKDIV_FIMD, 1);
					SYSC_SetClkMuxState(eCLKMUX_FIMD_SVPLL);
					break;
		}

		LCDC_InitLdi(MAIN);

		// 1. Set background
		LCDC_InitIp(eBgBpp, uLcdFbAddr, eBgWin, false);
		LCDC_SetWinOnOff(1, eBgWin);
		LCDC_GetFrmSz(&uHSz, &uVSz, eBgWin);

		GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
		GLIB_DrawPattern(uHSz, uVSz);
		GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);
		Disp("Window %d (Background) Is Displayed\n", (int)eBgWin);	
		LCDC_Start();

		Disp("Press any key to stop test \n");
		UART_Getc();
		LCDC_Stop();
		
	
}

void TestTripleLCD(void)
{

	u32 uTmpNum;
	u32 i,k;
	u32 uHSz,uVSz;
	u32 uGlibAddr;


	bIsRev = false;
	bIsAllWin = false;
	uGlibAddr = uLcdFbAddr + (480*320*4);
	GLIB_InitInstance(uLcdFbAddr, 480, 320, RGB24);
	GLIB_DrawPattern(480, 320);	
	GLIB_InitInstance(uGlibAddr, 240, 320, RGB16);
	GLIB_DrawPattern(240, 320);


	LCDC_InitLdiSel(LCD_LMS280GS01,MAIN);
	LCDC_InitIpDualLsSel(LCD_LMS280GS01,RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_PORTRAIT);

	LCDC_InitGpioDualSel(LCD_LMS280GS01,LCD_DUAL);
	LCDC_SetDualDisplaySel(LCD_LMS280GS01,LINE_SPLIT,FIMD_DUAL,VDEN_DIS);
	
	Disp("Display Dual LCD\n");

	LCDC_Start();

	UART_Getc();

	while(1)	
		{
			Disp("Press 'q' key to see Dual RGB interface\nPress 'w' key to see CPU interface\nPress Enter key to stop test\n"); 	

			uTmpNum = UART_Getc();
			if(uTmpNum == 'q')
				{
				LCDC_Stop();

				LCDC_InitLdiSel(LCD_LMS280GS01,MAIN);
				LCDC_InitIpDualLsSel(LCD_LMS280GS01,RGB24, uLcdFbAddr, eBgWin, eFgWin, false,LCD_PORTRAIT);
/*				
				LCDC_GetLcdSz(&uHSz, &uVSz);
				GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
				GLIB_DrawPattern(uHSz, uVSz);
				GLIB_PutLine(0, 0, 0, uVSz-1, C_BLUE);	
*/

				LCDC_InitGpioDualSel(LCD_LMS280GS01,LCD_DUAL);
				LCDC_SetDualDisplaySel(LCD_LMS280GS01,LINE_SPLIT,FIMD_DUAL,VDEN_DIS);
				
				Disp("Display Dual LCD\n");

				LCDC_Start();

				}
			else if(uTmpNum == 'w')
				{
				LCDC_Stop();
				
				LCDC_InitLdiSel(LCD_UF24U276A,MAIN);

				LCDC_PutCmdToLdiByManual(0x2c, MAIN);

				for (i=0; i<240*320; i++)
					{
						LCDC_PutDataToLdiByManual(*((u16*)(uGlibAddr+i*2)), MAIN);
					}
					

				}
			else if(uTmpNum == '\r')
				break;

		}

	LCDC_Stop();

}



void LCD_Test(void)
{
	int i, nSel;

	char pcBgBppStr[50];
	char pcFgBppStr[50], pcFgArgbBppStr[50];

	char pcBgBppStr_Rev[50];
	char pcFgBppStr_Rev[2][50];

	char pcBppStr_All[5][50];

	const testFuncMenu menu[]=
	{
		0,                          "Exit\n",
		TestImgDown,				"Down Load Image",
		TestImgMake,				"Build mDNIE test stream data\n",
		
		TestRGBBasicDisplay,		"Basic RGB display test(need to download Image)",
		TestSimpleDisplay,       	"Simple RGB Test",
		TestComplexDisplay,		"Complex RGB Test With ColorMap",
		TestFifoUnderRun,			"Test Fifo Under-Run Interrupt",
		TestFrameInt,				"Test Frame Interrupt",
		TestVDMABurstLength,		"Burst Length Change test",
		TestSwap,					"Test Data Swap function",
		TestRGBOrder,				"Test RGB if output order change",
		TestPerFrameDirect,		"Test PerFrame / Direct off",
		TestVirtualScreen,		"Virtual Screen/Soft Scrolling Test",
		TestDummyInsersion,		"Test RGB dummy insertion",
		TestRGBSkip,				"Test RGB skip mode\n",

		TestDisplayAllWindow,		"Test Display All Win",
		TestDispAllWinByPalette,	"Test Display All Win By Palette",
		TestPaletteModeBpp,		"Test palette mode bpp",
		TestNonPaletteModeBpp,	"Test non-palette mode bpp",
		TestComplexPalette,		"Test Complex Palette",
		SetPaletteBppAndWin,		"Select Palette Bpp, Data Bpp And Window Number\n",

//		TestAllWindowSigleDisplay,         "Test All Window display single\n",
		TestReverseCombinationOfWins,	"Test Reverse Combination Of WIN0~2 using Alpha blending\n",

		TestColorMap,						"Test Color Map",
		TestColorKey,                  	"Test Color Key",
		TestColorKeyBlackout,				"Test Color Key Black out\n",

		TestBlendingPerPlane,				"Test Per Plane Blending",
		TestBlendingAllwinPerPlane,		"All window plane blending test",
		TestBlendingPerPixel,				"Test Per Pixel Blending",
		TestBlendingDataPixel,			"Test Per Pixel Data Blending",
		TestColorKeynBlending,			"Test Key Blending with Alpha Blending",
		TestSimpleBlendingEquation,		"Test Simple Blending Equation",
		TestComplexBlendingEquation,		"Test Complex Blending Equation\n",

		TestSimpleDoubleBuffering,         "WIN 0~4 Simple Double Buffering Test ",
		TestComplexDoubleBuffering,        "WIN 0/ WIN 1 Complex Double Buffering Test",
		TestAutoDoubleBuffering,           "WIN 0~4 Auto Double Buffering Test",
		TestManualTripleBuffering,		"WIN 0 Triple Buffering Test\n",

		TestDualLcdDemo,					"Test Dual LCD Demo",
		TestDualLcdDemoLight,				"Test Dual LCD Demo Light",		
		TestDualLcdFrameSp,				"Test Dual Frame Split",
		TestDualLcdLineSp,				"Test Dual Line Split",
		TestDualLcdLineSp2,				"Test Dual Line Split debug\n",
		
		TestShadowProtect,				"Shadow Register Protect Test",
		TestImgEnhancement,				"Image Enhancement Functions Test\n",

		TestLocalPath,						"Test Local path with FIMC",
		TestLocalPathChangeAging,		"Test Local path on / off Agina\n",
		
		TestCpuIfByAccessingLdi,			"CPU I/F Test By Accessing LDI",
		TestCpuIfAutoCmd,					"CPU I/F Auto Command Test",
		TestCpuIfPartialDisplay,			"CPU I/F Partial Display Test",
		TestCpuIfRead,						"CPU I/F Read Test",
		TestCpuInt,						"CPU I/F interrupt Test\n",

		TestBasicITU601,					"ITU601 display (hidden spec)",
		TestBasicITU656,					"ITU656 display (hidden spec)\n",		

		TestFrmBfIssue,					"FIMD Fb write issue",
		TestPerformanceUnderrun,			"Test FIMD Bandwidth Underrun\n",
		TestTripleLCD,						"Test Triple LCD",

		SetRgbBpp,                         "Select LCD Bpp (RGB or Palette Data Format)",
		SetArgbBpp,                        "Select LCD Bpp (ARGB Data Format)",
		SetWinOfFgAndBg,                  "Select Window Number Of Foreground And Background\n",

		TestAboveAll,                      "Test Above All",
		
		TestLCDonOff,						"Test LCD on off",
		TestLCDCClkPowerOnoffAging,		"Test LCD clk/Power On/Off aging ",
		TestLCDClkSrcSelection,			"Test LCD Clock Source Selection ",
		0,							       0
	};


	InitSysconForFIMD();
	SYSC_InitClkForMM();
	

#ifdef LDI_INIT_GPIO
	GPIO_Init();
	LCDC_SetGPIOFunctionForLts222QLdi();
	#endif

	eBgWin = WIN0;
	eFgWin = WIN1;
	eFg1Win = WIN2;
	eFg2Win = WIN3;
	eFg3Win = WIN4;

	eBgBpp = RGB24;
	eFgBpp = RGB24;

	eFgArgbBpp = ARGB24;

	nSel = (int) LCD_CPUIF_CS;
	
	if(nSel == 0)
		eLcdCpuifInt = LCDC_SYSMAIN_INT;  
	else
		eLcdCpuifInt = LCDC_SYSSUB_INT;

	ePalBpp = PAL1;
	ePalDataBpp = RGB16;

	eAlphaCh = ALPHA_1; // need for pixel blending

	eWinBpp[0] = RGB24;
	eWinBpp[1] = RGB16;
	eWinBpp[2] = PAL4;
	eWinBpp[3] = PAL2;
	eWinBpp[4] = PAL1;

	eBgBpp = RGB24;
	eFgBppArray[0] = RGB24;
	eFgBppArray[1] = RGB16;

	eBg1Win = WIN2;
	eFgWinArray[0] = WIN1;
	eFgWinArray[1] = WIN0;

	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	
	while (1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("================================================================\n");

		if (bIsRev == false && bIsAllWin == false)
		{
			ConvertCSpaceToString(eBgBpp, pcBgBppStr);
			ConvertCSpaceToString(eFgBpp, pcFgBppStr);
			ConvertCSpaceToString(eFgArgbBpp, pcFgArgbBppStr);

			Disp("< Currnet Background : WINDOW %d >\n", (int)eBgWin);
			Disp("< Current Foreground : WINDOW %d >\n", (int)eFgWin);

			Disp("< Current Background's RGB BPP : %s >\n", pcBgBppStr);
			Disp("< Current Foreground's RGB BPP : %s >\n", pcFgBppStr);
			Disp("< Current Foreground's ARGB BPP : %s >\n", pcFgArgbBppStr);
		}
		else if (bIsRev == true)
		{
			ConvertCSpaceToString(eBgBpp, pcBgBppStr_Rev);
			ConvertCSpaceToString(eFgBppArray[0], pcFgBppStr_Rev[0]);
			ConvertCSpaceToString(eFgBppArray[1], pcFgBppStr_Rev[1]);

			Disp("< Currnet Background : WINDOW %d >\n", (int)eBg1Win);
			Disp("< Current Foreground1: WINDOW %d >\n", (int)eFgWinArray[0]);
			Disp("< Current Foreground2: WINDOW %d >\n", (int)eFgWinArray[1]);

			Disp("< Current Background's RGB BPP : %s >\n", pcBgBppStr_Rev);
			Disp("< Current Foreground1's RGB BPP : %s >\n", pcFgBppStr_Rev[0]);
			Disp("< Current Foreground2's RGB BPP : %s >\n", pcFgBppStr_Rev[1]);
		}
		else if (bIsAllWin == true)
		{
			for (i=0; i<5; i++)
			{
				ConvertCSpaceToString(eWinBpp[i], pcBppStr_All[i]);
				if (i==0)
				{
					Disp("< Currnet Background : WINDOW 0, BPP: %s >\n", pcBppStr_All[i]);
				}
				else
				{
					Disp("< Currnet Foreground%d : WINDOW %d, BPP: %s >\n", i, i, pcBppStr_All[i]);
				}
			}
		}


		Disp("\nSelect the function to test : ");
		nSel = UART_GetIntNum();
		Disp("\n");

		if (nSel == 0)
		{
			break;
		}
		if (nSel>0 && nSel<(sizeof(menu)/8-1))
		{
			 (menu[nSel].func)();
		}
	}
}

#if 0
static void TestLocalPathOffWorkAround()
{
	u32 *tmp;
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;
	LCD_WINDOW eWinNum;
	u32 nWinNum;

	INTC_Init();
	INTC_SetHandlerAndUnmask(INT_LCD1, Isr_LcdcFrameInt);
	INTC_SetHandlerAndUnmask(INT_LCD0, Isr_LcdcUnderRun);
	POST_SetInterruptHandler(Isr_InterruptHandler);
	
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_RGB888;
#if(LCD_MODEL == LCD_LTS222Q_RGB)
	#if 1
/*	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight= 320;
	defaultCond.srcImageWidth=240;
	defaultCond.srcImageHeight = 320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight =320;*/

	defaultCond.srcOriginalImageWidth = 800;
	defaultCond.srcOriginalImageHeight= 480;
	defaultCond.srcImageWidth=800;
	defaultCond.srcImageHeight = 480;
	defaultCond.dstScreenWidth = 400;
	defaultCond.dstScreenHeight = 240;
	defaultCond.dstImageWidth=400;
	defaultCond.dstImageHeight =240;
	#else
	defaultCond.srcOriginalImageWidth = 800;
	defaultCond.srcOriginalImageHeight= 480;
	defaultCond.srcImageWidth=800;
	defaultCond.srcImageHeight = 480;
	defaultCond.dstScreenWidth = 800;
	defaultCond.dstScreenHeight = 480;
	defaultCond.dstImageWidth=800;
	defaultCond.dstImageHeight =480;
	#endif
#elif(LCD_MODEL == LCD_LTE480WV_RGB)
	defaultCond.srcOriginalImageWidth = 800;
	defaultCond.srcOriginalImageHeight= 480;
	defaultCond.srcImageWidth=800;
	defaultCond.srcImageHeight = 480;
	defaultCond.dstScreenWidth = 800;
	defaultCond.dstScreenHeight = 480;
	defaultCond.dstImageWidth=800;
	defaultCond.dstImageHeight =480;
#endif

	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
	defaultCond.waitMode = POST_WAIT_MODE_INTERRUPT;

	LCDC_Stop();
	
	LCDC_SetWinOnOff(0, WIN0);
	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);

	LCDC_SetAllWinIntCnt(EMPTY, FINT_BACKPORCH);

	POST_SetCondition(defaultCond);
	POST_DoConverting();

	LCDC_Start();
	Disp("See the screen. press any key to escape from local path mode\n");
	UART_Getc();

	uPOSTDoneIssue = 1;

	while (1) 
	{
		if (( uPOSTDoneIssue == 1) & ( WinStopIssue == 1 ))
			break;
	}
	uPOSTDoneIssue = 0;
	WinStopIssue = 0;

	INTC_Disable(INT_LCD1);
}


static void TestSimpleDisplayItu601(void)
{
	u32 uHSz=240, uVSz=320;

	Disp("Enter Any Key To Test Simple Display For ITU 601 \n");
	UART_Getc();

	LCDC_InitItuBase(BT601, uHSz, uVSz, PROGRESSIVE);
	LCDC_InitWin(eBgBpp, uHSz, uVSz, 0, 0,  uHSz, uVSz,	0, 0, uLcdFbAddr, eBgWin, false); // For WIN0
	
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, eBgBpp);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Start();
}

static void TestComplexDisplayItuMode(void)
{
	u32 uHsz,uVsz;
	u32 uTmp;
	IMG_RESOLUTION eSize[4] = {QVGA,VGA, SVGA, SXGA};
	
	while(true)
	{
		Disp("0.LcdHalf(120 x 160)\n");
		Disp("1.LcdSize(240 x 320)\n");
		Disp("2.QVGA(320 x 240)\n");
		Disp("3.VGA (640 x 480)\n");
		Disp("4.SVGA(800 x 600)\n");
		Disp("5.SXGA(1280 x 1024)\n\n");
		Disp("Select the Number : ");
		uTmp = UART_GetIntNum();
		if (uTmp>1 && uTmp<6)
		{
			ConvertImgSzToNumber(eSize[uTmp-2], &uHsz, &uVsz);	
			break;
		}
		else if(uTmp==1)
		{
			uHsz=240, uVsz=320;		
			break;
		}
		else if (uTmp == 0)
		{
			uHsz=120, uVsz=160;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}

	while(true)
	{
		Disp("0.BT601\n");
		Disp("1.BT656\n\n");
		Disp("Select the Number : ");
		uTmp = UART_GetIntNum();
		if (uTmp == 0)
		{
			eMode = BT601;
			break;
		}
		else if (uTmp == 1)
		{
			eMode = BT656;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}
	while(true)
	{
		Disp("0.PROGRESSIVE\n");
		Disp("1.INTERLACE\n\n");
		Disp("Select the Number : ");
		uTmp = UART_GetIntNum();
		if(uTmp == 0)
		{
			eScanMode = PROGRESSIVE;
			break;
		}
		else if (uTmp == 1)
		{
			eScanMode =   INTERLACE;
			break;
		}
		else
		{
			Disp("Invalid Input! Retry It!!\n");
		}
	}

	LCDC_InitItuBase(eMode, uHsz, uVsz, eScanMode);
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0,  uHsz, uVsz,	0, 0, uLcdFbAddr, WIN0, false); // For WIN0

	GLIB_InitInstance(uLcdFbAddr, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern(uHsz, uVsz);
	LCDC_Start();
}

static void TestAllWindowSigleDisplay(void)
{
	u32 uHsz=240, uVsz=320;
	u32 uStAddr0 = CODEC_MEM_ST+uHsz*uVsz*4;
	u32 uStAddr1 = uStAddr0+uHsz*uVsz*4;
	u32 uStAddr2 = uStAddr1+uHsz*uVsz*4;
	u32 uStAddr3 = uStAddr2+uHsz*uVsz*4;
	u32 uStAddr4 = uStAddr3+uHsz*uVsz*4;
	
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0, uHsz, uVsz,	0, 0, uStAddr0, WIN0, false); 	
	GLIB_InitInstance(uStAddr0, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern(uHsz, uVsz);
	LCDC_Start();
	LCDC_Trigger();
	Disp("Window 0 displayed\n");
	UART_Getc();

	LCDC_SetAllWinOnOff(0);
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0, uHsz, uVsz,	0, 0, uStAddr1, WIN1, false); 	
	GLIB_InitInstance(uStAddr1, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern2(uHsz, uVsz);
	LCDC_Start();	
	LCDC_Trigger();
	Disp("Window 1 displayed\n");
	UART_Getc();

	LCDC_SetAllWinOnOff(0);	
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0, uHsz, uVsz,	0, 0, uStAddr2, WIN2, false); 	
	GLIB_InitInstance(uStAddr2, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern(uHsz, uVsz);
	LCDC_Start();
	LCDC_Trigger();
	Disp("Window 2 displayed\n");
	UART_Getc();

	LCDC_SetAllWinOnOff(0);	
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0, uHsz, uVsz,	0, 0, uStAddr3, WIN3, false); 	
	GLIB_InitInstance(uStAddr3, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern2(uHsz, uVsz);
	LCDC_Start();
	LCDC_Trigger();
	Disp("Window 3 displayed\n");
	UART_Getc();

	LCDC_SetAllWinOnOff(0);	
	LCDC_InitWin(eBgBpp, uHsz, uVsz, 0, 0, uHsz, uVsz,	0, 0, uStAddr4, WIN4, false); 	
	GLIB_InitInstance(uStAddr4, uHsz, uVsz, eBgBpp);
	GLIB_DrawPattern(uHsz, uVsz);
	LCDC_Start();
	LCDC_Trigger();
	Disp("Window 4 displayed\n");
	UART_Getc();
}
#endif

