/*-------------------------------------------------------------
 * Filename: lcd.h
 *
 * Contents: Implemention of "FIMD5.0"
 *
 * Abbreviations:
 *
 * Person Involved:
 *
 * Notes: FIMD v5.0
 *
 * History
 *
 * Copyright (c) 2007 SAMSUNG Electronics.
 --------------------------------------------------------------*/
 
#ifndef __LCD_H__
#define __LCD_H__

#define LDI_INIT_GPIO			1

#ifdef LDI_INIT_GPIO
#include "gpio.h"
#else
#include "hspi.h"
#endif

#include "def.h"

#define DBG_LCDC	0

/////////////////////////////////////////////////////
// LCD Module Type 

#define LCD_LTS350Q1			1
#define LCD_LTT200QV_LTPS	2
#define LCD_LTS222Q_CPU	3
#define LCD_LTS222Q_RGB	4
#define LCD_LTS222Q_SRGB	5
#define LCD_LTS222Q_SPI		6
#define LCD_S6D0139_CPU	7
#define LCD_LTP700WV_RGB 	9
#define LCD_LTE480WV_RGB 	10
#define LCD_LTV350QV_RGB	11
#define LTM030DK			12		// TN portrait WVGA (6410 test module)
#define LCD_TL2796			13
#define LCD_UF24U276A		14		// Triple B'd i80 i/F module
#define LCD_LMS280GS01		15		// Triple B'd RGB i/f module
#define LCD_HD				16
#define LCD_XGA				80
#define LCD_SXGA			81
#define LCD_MIPIModule		0x100

#define LCD_MODEL			LCD_TL2796

#define LCD_FRM_RATE     60


#define LCD_HCLK	10
#define LCD_SCLK	11

#define LCD_VCLKSRC  LCD_HCLK


/////////////////////////////////////////////////////
// I80 CPU I/F CS

#define LCD_CPUIF_CS			CS_MAIN
#define CS_MAIN					0
#define CS_SUB					1

//Timing parameter for LTS_222Q I80 I/F
#if 0 
#define CS_SETUP_TIME           (0&0xf)
#define WR_SETUP_TIME           (1&0xf)
#define WR_ACT_TIME             (6&0xf)
#define WR_HOLD_TIME            (0&0xf)
#else
#define CS_SETUP_TIME           (0xf&0xf)
#define WR_SETUP_TIME          (0xf&0xf)
#define WR_ACT_TIME              (0xf&0xf)
#define WR_HOLD_TIME            (0xf&0xf)
#endif




//Timing parameter for LTV350QV(SAMSUNG)
#define VBPD_LTV350QV           ((5-1)&0xff)
#define VFPD_LTV350QV           ((3-1)&0xff)
#define VSPW_LTV350QV           ((4-1)&0xff)
#define HBPD_LTV350QV           ((5-1)&0xff)
#define HFPD_LTV350QV           ((3-1)&0xff)			
#define HSPW_LTV350QV           ((10-1)&0xff)

// Timing parameter for LTS350Q1(SAMSUNG)
#define VBPD_240320				((2-1)&0xff)
#define VFPD_240320				((3-1)&0xff)
#define VSPW_240320		    	((2-1)&0xff)
#define HBPD_240320				((7-1)&0xff)
#define HFPD_240320				((5-1)&0xff)	// for rgbif margin
#define HSPW_240320		    	((4-1)&0xff)

// Timing parameter for LTS222Q
#define VBPD_LTS222Q			((9-1)&0xff) // Not (7-1)
#define VFPD_LTS222Q			((10-1)&0xff)
#define VSPW_LTS222Q			((3-1)&0xff)
#define HBPD_LTS222Q			((1-1)&0xff) // Not (2-1)
#define HFPD_LTS222Q			((6-1)&0xff) // for rgbif margin
#define HSPW_LTS222Q			((3-1)&0xff)

//Timing parameter for LTP700WV(SAMSUNG)
#define VBPD_LTP700WV           ((7-1)&0xff)
#define VFPD_LTP700WV           ((5-1)&0xff)
#define VSPW_LTP700WV           ((1-1)&0xff)
#define HBPD_LTP700WV           ((13-1)&0xff)
#define HFPD_LTP700WV           ((8-1)&0xff)			
#define HSPW_LTP700WV           ((3-1)&0xff)


//Timing parameter for LTM030DK3A 480x800
#define VBPD_LTM030DK3A        ((2-1)&0xff) // 1 line back porch
#define VFPD_LTM030DK3A        ((1-1)&0xff) // 1 line front porch
#define VSPW_LTM030DK3A        ((1-1)&0xff) // 1 Line pulse width
#define HBPD_LTM030DK3A        ((2-1)&0xff) // 2 CLK back porch
//#define HBPD_LTM030DK3A        ((1-1)&0xff) // 2 CLK back porch for test. zues
#define HFPD_LTM030DK3A        ((5-1)&0xff) // 5 CLK front porch
#define HSPW_LTM030DK3A        ((2-1)&0xff) // 2 CLK pulse width



//Timing parameter for TL2796 480x800
#define VBPD_TL2796        ((4)&0xff) // 4 x HSYNC
#define VFPD_TL2796        ((4)&0xff) // 4 x HSYNC
#define VSPW_TL2796        ((1)&0xff) // 1 x VCLK
#define HBPD_TL2796        ((8)&0xff) // 8 x VCLK
#define HFPD_TL2796        ((8)&0xff) // 8 x VCLK
#define HSPW_TL2796        ((1)&0xff) // 1 x VCLK


//Timing parameter for XGA
#define VBPD_HD        ((0)&0xff) // 4 x HSYNC
#define VFPD_HD        ((0)&0xff) // 4 x HSYNC
#define VSPW_HD        ((3)&0xff) // 1 x VCLK
#define HBPD_HD        ((0)&0xff) // 8 x VCLK
#define HFPD_HD        ((0)&0xff) // 8 x VCLK
#define HSPW_HD        ((32)&0xff) // 1 x VCLK


//Timing parameter for XGA
#define VBPD_XGA        ((4)&0xff) // 4 x HSYNC
#define VFPD_XGA        ((4)&0xff) // 4 x HSYNC
#define VSPW_XGA        ((1)&0xff) // 1 x VCLK
#define HBPD_XGA        ((8)&0xff) // 8 x VCLK
#define HFPD_XGA        ((8)&0xff) // 8 x VCLK
#define HSPW_XGA        ((1)&0xff) // 1 x VCLK



//Timing parameter for SXGA
#define VBPD_SXGA        ((4)&0xff) // 4 x HSYNC
#define VFPD_SXGA        ((4)&0xff) // 4 x HSYNC
#define VSPW_SXGA        ((1)&0xff) // 1 x VCLK
#define HBPD_SXGA        ((8)&0xff) // 8 x VCLK
#define HFPD_SXGA        ((8)&0xff) // 8 x VCLK
#define HSPW_SXGA        ((1)&0xff) // 1 x VCLK





	// set spi for lcd 
	// 1. set jumper like as 1-2 in J15 at SMDK board
	// 2. you can use the SPI1 to control LCD sfr register
	// nSS1 		---> SPI_LCDnSS  	---> GPB 5
	// SPIMOSI1	---> SPI_LCDMOSI      ---> GPL 7
	// SPICLK1    ---> SPI_LCDCLK        ---> GPL 4

#define LCD_DEN		(1<<5)
#define LCD_DSERI	(1<<7)
#define LCD_DCLK	(1<<4)

#define LCD_DEN_BIT		5		//SPI1_nCS
#define LCD_DSERI_BIT	7		//SPI1_MOSI
#define LCD_DCLK_BIT	4		//SPI1_CLK

//#define LCD_DEN_Lo		Outp32(0xe0200044,(Inp32(0xe0200044) &= ~LCD_DEN))
//#define LCD_DEN_Hi		Outp32(0xe0200044,(Inp32(0xe0200044) |=	LCD_DEN))
#define LCD_DEN_Lo		GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x0)
#define LCD_DEN_Hi		GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x1)
//#define LCD_DCLK_Lo		Outp32(0xe0200044,(Inp32(0xe0200044) &= ~LCD_DCLK))
//#define LCD_DCLK_Hi		Outp32(0xe0200044,(Inp32(0xe0200044) |=	LCD_DCLK))
#define LCD_DCLK_Lo		GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x0)
#define LCD_DCLK_Hi		GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1)

//#define LCD_DSERI_Lo	Outp32(0xe0200044,(Inp32(0xe0200044) &= ~LCD_DSERI))
//#define LCD_DSERI_Hi		Outp32(0xe0200044,(Inp32(0xe0200044) |=	LCD_DSERI))
#define LCD_DSERI_Lo	GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x0)
#define LCD_DSERI_Hi		GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x1)



typedef enum
{
	DISP_MDNIE,DISP_MIE,DISP_BYPASS
} MDNIE_SEL;

typedef enum
{
LCD_eXXTI = 0,LCD_eXusbXTI = 1,LCD_eMPLL = 6,LCD_eEPLL = 7, LCD_eVPLL =8, LCD_eHCLK = 10,
}LCD_SEL_CLKSRC;

typedef enum
{
	ITU_PROGRESSIVE,ITU_INTERLACE
}LCD_ITU_INTERLACE;

typedef enum
{
	FIMD_SINGLE,FIMD_DUAL,MIE_SINGLE,MIE_DUAL,MDNIE_SINGLE,MDNIE_DUAL
}LCD_SEL_DUAL;

typedef enum
{
	FRAME_SPLIT,LINE_SPLIT
}LCD_DUAL_METHOD;

typedef enum
{
	VDEN_EN, VDEN_DIS
}LCD_DUAL_VDEN_EN;

typedef enum
{
	LCD_DUAL,LCD_A,LCD_B
}LCD_SEL_DLCD;

typedef enum
{
	LCD_LANDSCAPE,LCD_PORTRAIT
}LCD_SCAN_TYPE;

typedef enum
{
	WIN0=0, WIN1=1, WIN2=2, WIN3=3, WIN4=4, ALLWIN
}LCD_WINDOW;

typedef enum 
{
	VCLK_FALLING_EDGE, VCLK_RISING_EDGE
} LCD_ACTIVE_EDGE;

typedef enum 
{
	LCD_NORMAL_POLARITY, LCD_INVERTED_POLARITY
} LCD_PULSE_POLARITY;


typedef enum 
{
	LOCAL_EN,LOCAL_DIS
} LCD_LOCAL_EN;

typedef enum 
{
	IN_POST, IN_CIM
} LCD_LOCAL_INPUT;

typedef enum
{
	LCD_RGB, LCD_TV, LCD_I80F, LCD_I80S,
	LCD_TVRGB, LCD_TVI80F, LCD_TVI80S, LCD_MDNIE
} LCD_LOCAL_OUTPUT;

typedef enum
{
	SKIP_1_1,SKIP_1_2,SKIP_1_3,SKIP_1_4,SKIP_1_5,SKIP_1_6,SKIP_1_7,SKIP_1_8,SKIP_1_9,SKIP_1_10,
	SKIP_1_11,SKIP_1_12,SKIP_1_13,SKIP_1_14,SKIP_1_15,SKIP_1_16,SKIP_1_17,SKIP_1_18,SKIP_1_19,SKIP_1_20,
	SKIP_1_21,SKIP_1_22,SKIP_1_23,SKIP_1_24,SKIP_1_25,SKIP_1_26,SKIP_1_27,SKIP_1_28,SKIP_1_29,SKIP_1_30
}LCD_WB_SKIP;


typedef enum 
{
	PER_PLANE, PER_PIXEL
} BLENDING_APPLIED_UNIT;

typedef enum 
{
	ALPHA0_PLANE, ALPHA1_PLANE, DATA_PIXEL, AEN_PIXEL, COLORKEY_AREA
} BLENDING_SELECT_MODE;

typedef enum 
{
	MATCH_FG_IMAGE, MATCH_BG_IMAGE
} COLOR_KEY_DIRECTION;


typedef enum 
{
	SWAP_BIT_DISABLE, SWAP_BIT_ENABLE, 
	SWAP_BYTE_DISABLE, SWAP_BYTE_ENABLE, 
	SWAP_HALFWORD_DISABLE, SWAP_HALFWORD_ENABLE,
	SWAP_WORD_DISABLE, SWAP_WORD_ENABLE
}SWAP_MODE;

typedef enum
{
	CSC_WIDE, CSC_NARROW, CSC_EQ601, CSC_EQ709
} HUE_CSC_MODE;

typedef enum
{
	LOW_LUX,HIGH_LUX
} CONTROL_LUX;


typedef enum 
{
	DITH_8BIT, DITH_6BIT, DITH_5BIT
} DITHER_MODE;

typedef enum 
{
	DITH_FIX, DITH_DYNAMIC
} DITHER_MATRIX;

// suffix: P=>Parallel, S=>Serial
typedef enum 
{
	RGB_P, BGR_P, RGB_S, BGR_S
} PNR_MODE;

typedef enum 
{
	RGB, GBR, BRG, BGR, RBG, GRB
} RGB_ORDER;

typedef enum
{
	SKIP_EN,SKIP_DIS
}RGBSKIP_EN;

typedef enum
{
	DUMMY_EN,DUMMY_DIS
}RGBDUMMY_EN;

typedef enum
{
	DUMMY_FIRST,DUMMY_LAST
}DUMMY_POSITION;


typedef enum 
{
	D16BIT, D16PLUS2BIT, D9PLUS9BIT, D16PLUS8BIT, D18BIT
}CPUIF_DATA_FORMAT;

typedef enum 
{
	MAIN, SUB
} CPUIF_LDI;

typedef enum 
{
	LCD_DISABLE_CMD, LCD_NORMAL_CMD, LCD_AUTO_CMD, LCD_NORMAL_N_AUTO_CMD
}CPU_COMMAND_MODE;
	
typedef enum 
{
	NO_SKIP, SKIP_PER_TWO_FRM, SKIP_PER_THREE_FRM
}CPU_FRAME_SKIP;

typedef enum 
{
	PAL_HCLK, PAL_VCLK
}PAL_CLK;

typedef enum 
{
	ALPHA_4BIT, ALPHA_8BIT
}ALPHA_WIDTH;

typedef enum 
{
	DISABLE_AUTO_FRM,
	PER_TWO_FRM,
	PER_FOUR_FRM,
	PER_SIX_FRM,	
	PER_EIGHT_FRM,
	PER_TEN_FRM,
	PER_TWELVE_FRM,	
	PER_FOURTEEN_FRM,
	PER_SIXTEEN_FRM,
	PER_EIGHTEEN_FRM,	
	PER_TWENTY_FRM,
	PER_TWENTY_TWO_FRM,
	PER_TWENTY_FOUR_FRM,
	PER_TWENTY_SIX_FRM,
	PER_TWENTY_EIGHT_FRM,
	PER_THIRTY_FRM
}CPU_AUTO_CMD_RATE;

typedef enum 
{
	SW_TRIG, HW_TRIG
}TRIGGER_MODE;

typedef enum 
{
	A = 1,
	B = 2,
	C = 3,
	D = 4,
	E = 5,
	F = 6,
	G = 7
} TRIGGER_SRC; // The element of TRIGGER_SRC are updated after setting a environment

typedef enum 
{
	Y_CBCR, CBCR_Y
}YUV_ORDER;

typedef enum 
{
	CB_CR, CR_CB
}CHROMA_ORDER;

typedef enum
{
	DIRECT_OFF, FRAME_OFF
}DISPLAY_OFF;


typedef enum 
{
	LCDC_FIFO_INT, LCDC_FRAME_INT, LCDC_SYSIF_INT
}LCDC_INT;

typedef enum 
{
	LCDC_SYSMAIN_INT,   LCDC_SYSSUB_INT
}LCDC_INT_SYS;


typedef enum
{
	UNDER25,
	UNDER50,
	UNDER75,
	EMPTY,
	FULL
}LCDC_FIFO_LEVEL;

typedef enum 
{
	FIFO_INT_WIN0, FIFO_INT_WIN1, FIFO_INT_WIN2, FIFO_INT_WIN3, FIFO_INT_WIN4
}LCDC_FIFO_INT_SEL;



typedef enum
{
	FINT_BACKPORCH, FINT_VSYNC, FINT_ACTIVE, FINT_FRONTPORCH, FINT_NONE
}LCDC_FRAME_INT_SEL;

typedef enum
{
	LCDC_BUF_SINGLE,LCDC_BUF_DOUBLE, LCDC_BUF_TRIPLE
}LCDC_AUTO_BUFFER_MODE;


typedef struct
{ 
	u32 m_uLcdHSz, m_uLcdVSz;
	u32 m_uLcdStX, m_uLcdStY;

	u32 m_uImgStAddr[5], m_uDoubleBufImgStAddr[5],m_uTripleBufImgStAddr[5];
	u32 m_uFbStAddr[5], m_uFbEndAddr[5];
	u32 m_uDoubleBufStAddr[5], m_uDoubleBufEndAddr[5];
	u32 m_uTripleBufStAddr[5], m_uTripleBufEndAddr[5];	
	u32 m_uFrmHSz[5], m_uFrmVSz[5];
	u32 m_uViewHSz[5], m_uViewVSz[5];
	u32 m_uPageWidth[5], m_uOffsetSz[5];
	
	u32 m_uBppMode;

	u32 m_uBytes, m_uBits;
	u32 m_uBitSwpMode,m_uBytSwpMode, m_uHawSwpMode, m_uWordSwpMode;

	u32 m_uMaxBurstLen;
	//u32 m_uMinBurstLen;
	
	u32 m_uDitherMode;

	LCDC_AUTO_BUFFER_MODE m_bAutoBuf;

	u32 m_uScanMode; // 0: Progressive, 1: Interlace 

	bool m_bFifoIn[3]; // false: DMA Path, true: Local Path
	LCD_LOCAL_INPUT m_eLocalIn[3]; // 0: CIM, 1: POST
	LOCAL_IF_TYPE m_uLocalInColorSpace[3];
#ifdef LDI_INIT_GPIO
#else
	SPI oSpi;
#endif
}LCDC;


void IEIP_Select(MDNIE_SEL eSel);


void LCDC_InitGpioMux(CPUIF_LDI eLdiMode);
void LCDC_InitGpioMuxSel(u32 uLCDmodel, CPUIF_LDI eLdiMode);
void LCDC_InitGpioDualLCD(LCD_SEL_DLCD eSelLCD);
void LCDC_InitGpioDualSel(u32 uLCDmodel, LCD_SEL_DLCD eSelLCD);
void LCDC_InitLdi(CPUIF_LDI eLdiMode);	
void LCDC_InitLdiSel(u32 uLCDmodel,CPUIF_LDI eLdiMode);
void LCDC_InitIp(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWin, bool bIsDoubleBuf);
void LCDC_InitIpDualFs(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan);
void LCDC_InitIpDualLs(IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan);
void LCDC_InitIpDualLsSel(u32 uLCDmodel, IMG_FMT eBpp, u32 uFbAddr, LCD_WINDOW eWinA, LCD_WINDOW eWinB, bool bIsDoubleBuf, LCD_SCAN_TYPE eScan);


//LCDC_InitIpDualp is temporary code for debug 800x480 landscape line split test
void LCDC_InitIpDualp(IMG_FMT eBpp, u32 uFbAddr,u32 uHsize, LCD_WINDOW eWinA,LCD_WINDOW eWinB, bool bIsDoubleBuf,LCD_SCAN_TYPE eScan);

void LCDC_InitBase(void);	
void LCDC_InitBaseDualp(u32 uHsize);  //LCDC_InitBaseDualp is temporary code for debug 800x480 landscape line split test
void LCDC_InitBaseDualFs(void);
void LCDC_InitBaseDualLs(void);
void LCDC_InitBaseDualLsSel(u32 uLCDmodel);
void LCDC_Start(void);
void LCDC_Stop(void); // Direct off
void LCDC_PerFrameOff(void);

void LCDC_InitItuBase(ITU_R_STANDARD eItu, u32 uFrameHsz, u32 uFrameVsz, SCAN_MODE eScanMode);
void LCDC_SetItuMode(ITU_R_STANDARD eItu, SCAN_MODE eScanMode);

void LCDC_InitWin(IMG_FMT eBpp, u32 uFrameH, u32 uFrameV, u32 uX_Frame, u32 uY_Frame,  u32 uViewH, u32 uViewV,
		u32 uX_Lcd, u32 uY_Lcd, u32 uFbAddr, LCD_WINDOW eWin, bool bIsDoubleBuf); // For WIN0
// In Fifo Input mode, Interface Data Format is RGB	

void LCDC_SetWinFrmBfAddr(u32 uFbAddr, LCD_WINDOW eWin,bool bIsDoubleBuf);
void LCDC_SetWinShadowP(LCD_WINDOW eWin, u32 eEn);
void LCDC_SetLocalEn(LCD_LOCAL_EN eLocalEn, LCD_WINDOW eWin);

void LCDC_SetVpOnOff(u32 uOnOff);
void LCDC_SetFifoInSrcFmt(LCD_WINDOW eWin, IMG_FMT eBpp);
void LCDC_SetWinOnOff(u32 uOnOff, LCD_WINDOW eWin);
void LCDC_SetAllWinOnOff(u32 uOnOff);

void LCDC_SetViewPosOnLcd(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin);
void LCDC_SetViewPosOnFrame(u32 uX_Frame, u32 uY_Frame, LCD_WINDOW eWin); // For WIN0~4
void LCDC_SetViewPosOnLcddelay(u32 uX_Lcd, u32 uY_Lcd, LCD_WINDOW eWin); // Only for test shadow protect
void LCDC_SetFreeRun(u32 uFreeEn);
void LCDC_SetRGBSkip(RGBSKIP_EN eRGBskipEn);
void LCDC_SetRGBdummy(DUMMY_POSITION ePosition, RGBDUMMY_EN eDummyEn);


void LCDC_GetDoubleBufAddr(u32* uFbAddr, u32 uWhichAddr, LCD_WINDOW eWin);
void LCDC_GetBufIdx(u32* uBufNum, LCD_WINDOW eWin);
void LCDC_SetActiveFrameBuf(u32 uWhichBuf, LCD_WINDOW eWin);	
void LCDC_EnableAutoBuf(LCDC_AUTO_BUFFER_MODE uMode, LCD_WINDOW eWin);
void LCDC_ChangePaletteClk(PAL_CLK ePalClkSrc);	
void LCDC_SetPaletteCtrl(IMG_FMT eBpp, LCD_WINDOW eWin);
void LCDC_SetPaletteData(u32 uIdx, u32 uPalData, LCD_WINDOW eWin);
void LCDC_SetColorMapValue(u32 uVal, LCD_WINDOW eWin);
void LCDC_SetColorMapOnOff(u32 uOnOff, LCD_WINDOW eWin);
void LCDC_SetAllWinColorMapOnOff(u32 uOnOff);
void LCDC_SetAlpha(u32 uA0R, u32 uA0G, u32 uA0B, u32 uA1R, u32 uA1G, u32 uA1B, LCD_WINDOW eWin);
void LCDC_SetAlphaClear(LCD_WINDOW eWin);
void LCDC_SetBlendingType(BLENDING_APPLIED_UNIT eBldPix, BLENDING_SELECT_MODE eBldMode, LCD_WINDOW eWin);
void LCDC_SetBlendingEquation(u32 uBackAlphaValFactor, u32 uForeAlphaValFactor, u32 uBackDataFactor, u32 uForeDataFactor, LCD_WINDOW eWin);
void LCDC_SetAlphaValWidth(ALPHA_WIDTH eAlphaValWidth);
void LCDC_SetRgbFormat(PNR_MODE ePnr);
void LCDC_SetRGBOrder(RGB_ORDER eEvenOrder, RGB_ORDER eOddOrder);
void LCDC_SetByteSwap(SWAP_MODE eBitSwap, SWAP_MODE eByteSwap, SWAP_MODE eHawSwap, SWAP_MODE eWordSwap, LCD_WINDOW eWin);	
void LCDC_SetBurstLength(BURST_MODE eBurstLength, LCD_WINDOW eWin);
void LCDC_SetColorKeyOnOff(u32 uOnOff, LCD_WINDOW eWin);
void LCDC_SetAllWinColorKeyOnOff(u32 uOnOff);
void LCDC_SetColorKey(u32 uMaskKey, u32 uColorKey, COLOR_KEY_DIRECTION eDir, bool bIsBlending, LCD_WINDOW eWin);
void LCDC_SetColorKeyBlackOut(u32 uOnOff, LCD_WINDOW eWin);
void LCDC_SetScanMode(SCAN_MODE eScanMode);
void LCDC_SetOutputPath(LCD_LOCAL_OUTPUT eOutLocal);
void LCDC_SetWBFrameSkip(LCD_WB_SKIP eSkip);
void LCDC_SetDualDisplay(LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual,LCD_DUAL_VDEN_EN eSelVden);
void LCDC_SetDualDisplaySel(u32 uLCDmodel, LCD_DUAL_METHOD eSelMethod, LCD_SEL_DUAL eSelDual, LCD_DUAL_VDEN_EN eSelVden);
void LCDC_SetFifoOut(void);
void LCDC_SetClkVal(u8 uClkVal);
void LCDC_SetrScFmtInFifo(IMG_FMT eBpp, LCD_WINDOW eWin);
void LCDC_GetLcdSz(u32* uLcdHSz, u32* uLcdVSz);
void LCDC_GetFrmSz(u32* uFrmHSz, u32* uFrmVSz, LCD_WINDOW eWin);
void LCDC_GetFbStAddr(u32* uFbAddr, LCD_WINDOW eWin);
void LCDC_GetFbEndAddr(u32* uFbAddr, LCD_WINDOW eWin);
void LCDC_GetImgStAddr(u32* uImgStAddr, LCD_WINDOW eWin);
u32 LCDC_GetLineCount(void);
void LCDC_InitIpForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin);
void LCDC_InitWinForFifoIn(LCD_LOCAL_INPUT eInLocal, LCD_WINDOW eWin);
void LCDC_InitWinForFifoIn1(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS);
void LCDC_InitWinForFifoIn2(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, LOCAL_IF_TYPE eLocalInCS, u32 uLcdHsize, u32 uLcdVsize);
void LCDC_InitWinForFifoIn3(LCD_LOCAL_INPUT eLocalIn, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd);
void LCDC_InitWinForFifoIn4 (LOCAL_IF_TYPE eLocalInCS, LCD_WINDOW eWin, u32 uLcdHsize, u32 uLcdVsize, u32 uX_Lcd, u32 uY_Lcd);
void LCDC_SetAlphaClear(LCD_WINDOW eWin);
void LCDC_WTrigger(LCD_WINDOW eWin);

void LCDC_SetALC(void);

/////////////////////////////////////////////////////////////////////////////////////
// Image Enhancement
/////////////////////////////////////////////////////////////////////////////////////	
void LCDC_SetGammaOnOff(u32 uEnable);
void LCDC_SetGammaValue(u8 * pLUT);
void LCDC_SetColorGainOnOff(u32 uEnable);
void LCDC_SetColorGainValue(u32 uCGRed, u32 uCGGreen, u32 uCGBlue);
void LCDC_SetHUEOnOff(u32 uEnable);
void LCDC_SetHUE_CSC_control(HUE_CSC_MODE eWide, HUE_CSC_MODE eEq);
void LCDC_SetHUE_Coef(u16 eCBG0_P,u16 eCBG0_N,u16 eCBG1_P,u16 eCBG1_N,u16 eCRG0_P,u16 eCRG0_N,u16 eCRG1_P,u16 eCRG1_N);
void LCDC_SetHUE_Offset(u16 eOffsetIn,u16 eOffsetOut);
void LCDC_SetALPSOnOff(u32 uEnable);
void LCDC_SetALPSsize(u32 uHsz, u32 uVsz);
void LCDC_SetALPSLux(CONTROL_LUX uLux);
void LCDC_SetALPSLutValue(u8* pLow_R_LUT, u8* pLow_G_LUT, u8* pLow_B_LUT, u8* pHigh_R_LUT, u8* pHigh_G_LUT, u8* pHigh_B_LUT);
void LCDC_SetALPSLutFullValue(u32* pLow_LUT, u32* pHigh_LUT);
void LCDC_SetDitheringOnOff(u32 uEnable);
void LCDC_SetDitheringValue(DITHER_MODE eRedDitherBit, DITHER_MODE eGreenDitherBit, DITHER_MODE eBlueDitherBit);

/////////////////////////////////////////////////////////////////////////////////////
// CPU-IF LCD
/////////////////////////////////////////////////////////////////////////////////////	
void LCDC_Trigger(void);	
void LCDC_UnmaskHwTrigger(TRIGGER_SRC eSrc);
void LCDC_SetCpuIfDataFormat(CPUIF_LDI eLdiMode, CPUIF_DATA_FORMAT eFormat);
void LCDC_SetCpuIfTiming(u8 ucCSSetUpTime, u8 ucWrSetUpTime, u8 ucWrActTime, u8 ucWrHoldTime, CPUIF_LDI eLdi);
bool LCDC_IsFrameDone(void);
void LCDC_SetFrameSkipRate(CPU_FRAME_SKIP eFrmSkip, CPUIF_LDI eLdi);
void LCDC_SetAutoCmdRate(CPU_AUTO_CMD_RATE eCmdRate, CPUIF_LDI eLdi);
void LCDC_DisplayPartialArea(u32 uSrcStX, u32 uSrcStY, u32 uDstStX, u32 uDstStY, 
	u32 uPartialHSz, u32 uPartialVsz, u32 uSrcFbStAddr, LCD_WINDOW eWin,CPUIF_LDI eCpuIf);
void LCDC_SetTriggerMode(TRIGGER_MODE eTrig);


void LCDC_InitLts222QForRgbif(void);
void LCDC_InitLtv350QVForRgbif(void);
void LCDC_InitTL2796(void);
void LCDC_OffTL2796(void);
void LCDC_InitLTM030DK(void);
void LCDC_InitLMS280GS01(void);
void LCDC_InitLts222QForI80if(CPUIF_LDI eLdiMode);
void LCDC_InitS6D0139ForI80if(CPUIF_LDI eLdiMode);
void LCDC_InitUF24U276AorI80if(CPUIF_LDI eLdiMode);

// Manual
void LCDC_PutCmdToLdiByManual(u32 uData, CPUIF_LDI eLdiMode);
void LCDC_PutPayLoad(u32 uData, CPUIF_LDI eLdiMode);				//Add by NSH for MIPI DSIM
void LCDC_PutDataToLdiByManual(u32 uData, CPUIF_LDI eLdiMode);
void LCDC_GetCmdFromLdiByManual(u32* uCmd, CPUIF_LDI eLdiMode );
void LCDC_GetDataFromLdiByManual(u32* uData, CPUIF_LDI eLdiMode );
// Normal/ Auto/ NormalNAuto way
void LCDC_PutCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode);
void LCDC_PutDataToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode);
void LCDC_PutDataOrCmdToLdi(u32 uData[], u32 uDataNum, CPUIF_LDI eLdiMode, CPU_COMMAND_MODE eCmdMode, bool IsCmd);	

//void LCDC_InitStartPosOnLcdI80If(CPUIF_LDI eLdiMode);
// uclkDir: 1 -> divieded clk. uClkDir: 0 -> direct clk.
void LCDC_GetClkValAndClkDir(u32 uLcdHSz, u32 uLcdVSz, u32* uClkVal, u32* uClkDir);
void LCDC_InitWinRegs(LCD_WINDOW eWin);
void LCDC_WriteCmd(u32 uAddr, u32 uData);
void LCDC_SetRsOnOff(u32 uOnOff);
void LCDC_SetnWE(u32 uLowHigh);
void LCDC_InitStartPosOnLcd(CPUIF_LDI eLdiMode);
void LCDC_InitStartPosLCDSel(u32 uLCDmodel, CPUIF_LDI eLdiMode);
void LCD_InitInt(LCDC_INT eLcdInt, LCDC_INT_SYS eLcdIntSys, LCDC_FIFO_LEVEL eFifoIntLevel, LCDC_FIFO_INT_SEL eFifoIntSel, LCDC_FRAME_INT_SEL eFIntSel );
void LCDC_DisableInterrupt(void);
void LCDC_EnableInterrupt(void);
void LCDC_EnableAllWinFifoLvlInt(LCDC_FIFO_LEVEL eFifoLvl);
void LCDC_EnableAllWinFrameInt(LCDC_FRAME_INT_SEL eIntSel);
void LCDC_SetAllWinIntCnt(LCDC_FIFO_LEVEL eFifoLvl, LCDC_FRAME_INT_SEL eIntSel);
void LCDC_DisableIntFifoLevel(LCD_WINDOW eWin);
void LCDC_DisableFifoInterrupt(void);
void LCDC_ClearPending(u32 uIntFlag);
void LCDC_GetIntFlag(u32* pFlag);


void LCDC_SetITUInterface(LCD_ITU_INTERLACE eITU_SEL);
void LCDC_SetITUInterface_656(LCD_ITU_INTERLACE eITU_SEL);


// LTS222Q LDI
void LCDC_SetGPIOFunctionForLts222QLdi(void);
void LCDC_SetGPIODataForLts222QLdi(u8 cData);


#endif //__LCD_H__



