
#ifndef __FIMC_H__
#define __FIMC_H__

//==================
//#define DISP_FIMC_REG
//#define FIMC_POLLING
//==================

#include "camera.h"

#if 0
typedef enum  // Ref. p42
{
//  MSB.............LSB
	CR1CB1CR0CB0, // C100 use only this
	CB1CR1CB0CR0,
	CR0CB0CR1CB1,
	CB0CR0CB1CR1
}YCBCR_2PLANE_ORDER;
#endif

typedef enum 
{
	ITU_CAMERA_A,
	ITU_CAMERA_B,
	MIPI_CAMERA_A,
	MIPI_CAMERA_B
}CAMERA;

typedef enum 
{
	FIMC_A,
	FIMC_B,
	FIMC_C
}FIMC_CH;

typedef enum  // Ref. p29
{
	ROT_NO_FLIP_NO, // 0 degree
	ROT_NO_FLIP_X,
	ROT_NO_FLIP_Y,
	ROT_NO_FLIP_XY, // 180 degree
	ROT_90_FLIP_NO, // 90 degree
	ROT_90_FLIP_X,
	ROT_90_FLIP_Y,
	ROT_90_FLIP_XY // 270 degree
}ROT_FLIP;

typedef enum 
{
	DMA_IN_DMA_OUT,
	FIFO_IN_DMA_OUT,
	DMA_IN_FIFO_OUT,
	DIRECT_FIFO_IN_DMA_OUT
}FIMC_PATH;

typedef enum  // Image effect
{
	EFF_BYPASS,
	ARBITRARY_CBCR,
	NEGATIVE,
	ART_FREEZE,
	EMBOSSING,
	SILHOUETTE
}IMG_EFF;

typedef enum  // Image effect location
{
	BEFORE_SCALING,
	AFTER_SCALING
}IMG_EFF_LOC;

typedef enum 
{
	EXTERNAL_CAMERA_INPUT,
	COLOR_BAR,
	HORIZONTAL_INCREMENT,
	VERTICAL_INCREMENT
}TEST_PATTERN;

typedef enum 
{
	PROGRESSIVE_IN_FIFO,
	INTERLACE_IN_ITU601_FIELD,
	INTERLACE_IN_ITU601_HSYNC,
	INTERLACE_IN_ITU656
}FIFO_IN_MODE;

typedef enum  // Just for FIFO-in DMA-out
{
	PROGRESSIVE_OUT,
	INTERLACE_OUT_EVEN_ODD,
	INTERLACE_OUT_WEAVING
}DMA_OUT_MODE;

typedef enum 
{
	PROGRESSIVE_IN_DMA,
	INTERLACE_IN_WEAVING
}DMA_IN_MODE;

typedef enum 
{
	EDGE,
	LEVEL
}INTR;

typedef enum 
{
	FIMC_SUCCESS,
	FIFO_Y_OVF,
	FIFO_CB_OVF,
	FIFO_CR_OVF,
	ROT_LINE_BUF_OVF // OVF (OVerFlow)
}FIMC_INTR_SRC;

typedef enum
{
	CSC_ITU601, // For SD
	CSC_ITU709 // For HD
}CSC_EQUATION;

typedef enum
{
	YCBCR_NARROW, // Y:16~235, Cb/Cr:16~240 
	YCBCR_WIDE // Y/Cb/Cr:0~255 (default)
}YCBCR_RANGE;

#define MAX_NUM_OF_FRM 64 // Maximum total frame number

/*
void FIMC_SetChA(void);
void FIMC_SetChB(void);
void FIMC_SetChC(void);
*/

void FIMC_StartProcessingForMfc(FIMC_CH eCh);
void FIMC_StartProcessing(FIMC_CH eCh, 
	u8 bCptFrmCtrl, u32 uCptSeqPattern, u32 uCptSeqPointer,
	u8 bCptCntCtrl, u32 uCptCnt);
void FIMC_StartProcessingForScalerBypass(FIMC_CH eCh);
void FIMC_StartProcessingForJpegInput(FIMC_CH eCh);
u8 FIMC_WaitForProcessingDone(FIMC_CH eCh);
u8 FIMC_WaitForProcessingDoneForCptFrmCtrl(FIMC_CH eCh);
void FIMC_StopProcessing(FIMC_CH eCh);

void FIMC_ClearInterrupt(FIMC_CH eCh);

void FIMC_InitIpForDinDout(FIMC_CH eCh,
	u32 uInImgHsz, u32 uInImgVsz, u32 uInImgLineSkip,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
	u32 uInImgAddr, IMG_FMT eInImgFmt,
	u32 uOutDispHsz, u32 uOutDispVsz,
	u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
	u32 uOutImgAddr, IMG_FMT eOutImgFmt,
	ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange, u8 bOne2One);

void FIMC_GetIntrSrc(FIMC_CH eCh, FIMC_INTR_SRC* eSrc);
void FIMC_InitCamera(CIS_MODEL g_eCisModel, IMG_FMT eFinImgType, IMG_RESOLUTION eSize);
void FIMC_InitCameraForTestPattern(CIS_MODEL eCisModel, IMG_FMT eFinImgType);
void FIMC_InitCameraForFimd(CAM_ATTR eCcir, FIFO_IN_MODE eFinMode,
	IMG_FMT eFinImgType, IMG_RESOLUTION eSize);
void FIMC_InitCameraForJpegInput(CIS_MODEL eCisModel, IMG_RESOLUTION eSize);
void FIMC_PreProcessForLastFrmCpt(FIMC_CH eCh);
void FIMC_GetFinImgSize(u32* uFinImgHsz, u32* uFinImgVsz);

void FIMC_InitIpForFinDout(FIMC_CH eCh, CAMERA eCamera,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
	u32 uOutDispHsz, u32 uOutDispVsz,
	u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
	u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
	ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);

void FIMC_InitIpForMFinDout(FIMC_CH eCh,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
	u32 uOutDispHsz, u32 uOutDispVsz,
	u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
	u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
	ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange,
	MIPI_DATA_ALIGN eDataAlign);

void FIMC_InitIpForDFinDout(FIMC_CH eCh,
		u32 uInImgHsz, u32 uInImgVsz,
		//u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
		u32 uOutDispHsz, u32 uOutDispVsz,
		u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
		u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);

void FIMC_InitIpForJFinDout(FIMC_CH eCh, CAMERA eCamera, u32 uOutImgAddr1, u32 uOutImgAddr2);

void FIMC_InitIpForDinFout(FIMC_CH eCh,
	u32 uInImgHsz, u32 uInImgVsz, u32 uInImgLineSkip,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
	u32 uInImgAddr, IMG_FMT eInImgFmt, u8 bFifoCtrl,
	u32 uOutImgHsz, u32 uOutImgVsz, LOCAL_IF_TYPE eOutLocalType, SCAN_MODE eOutScanMode,
	ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);

void FIMC_SetFinImgCroppingRegion(FIMC_CH eCh,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz);
void FIMC_SetDoutImgOffset(FIMC_CH eCh,
	IMG_FMT eOutImgFmt, u32 uOutImgStartX, u32 uOutImgStartY);
void FIMC_SetFinImgScaler(FIMC_CH eCh,
	u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz);
void FIMC_SetFinIrq(FIMC_CH eCh, u8 bEnableOfFrameStart, u8 bEnableOfFrameEnd);
void FIMC_SetDoutImgSize(FIMC_CH eCh, u32 uOutImgHsz, u32 uOutImgVsz, IMG_FMT eOutImgFmt, u32 uOutImgLineSkip);
void FIMC_SetDoutQos(FIMC_CH eCh, u32 uWriteBufThVal);

void FIMC_SetOutRotAndFlip(FIMC_CH eCh, ROT_FLIP eRotFlip);
void FIMC_SetImgEffect(FIMC_CH eCh, IMG_EFF eImgEff, u32 uCbVal, u32 uCrVal, IMG_EFF_LOC eImgEffLoc);	
void FIMC_SetTestPattern(FIMC_CH eCh, TEST_PATTERN eTestPattern);
void FIMC_GetDoutFrmCnt(FIMC_CH eCh, u32* uFrmCnt);
void	FIMC_GetLcdcEnstatus(FIMC_CH eCh, u8 *bEnable);
void	FIMC_GetEnvidStatus(FIMC_CH eCh, u8 *bEnable);
void FIMC_SetDinImgAddrForMfc(FIMC_CH eCh, IMG_FMT eInImgFmt, u32 uYAddr, u32 uCAddr); // For MFC
void FIMC_SetDinEnvid(FIMC_CH eCh, u8 bEnable);
void FIMC_SetDoutDispAddrForMfc(FIMC_CH eCh, IMG_FMT eOutImgFmt,
	u32 uOutImgAddr1OfY, u32 uOutImgAddr2OfY, u32 uOutImgAddr3OfY, u32 uOutImgAddr4OfY, 
	u32 uOutImgAddr1OfCb, u32 uOutImgAddr2OfCb, u32 uOutImgAddr3OfCb, u32 uOutImgAddr4OfCb);
void FIMC_SetDinQos(FIMC_CH eCh, u32 uReadBufThVal);

void FIMC_GetNextFbAddr(IMG_FMT eImgFmt, u32 uImgHsz, u32 uImgVsz,
	u32 uFirstFbAddr, u32* uNextFbAddr);
void FIMC_GetYCbCrSize(IMG_FMT eImgFmt, u32 uImgHsz, u32 uImgVsz,
	u32* uYSize, u32* uCbSize, u32* uCrSize);

void InitBaseHwForFIMC(void);

//=======================================================================
// Temp code for VP & MIXER verification -> It will be removed as soon as possible
//=======================================================================
void FIMC_ColorSpaceConversion(
	u32 srcAddr, u32 dstAddr,
	u32 srcFullWidth, u32 srcFullHeight, u32 dstFullWidth, u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);

void FIMC_CSC_YUVRange(CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);
//=======================================================================

#endif //__FIMC_H__
