
#include "def.h"
#include "v210_sfr.h"
#include "library.h"
#include "util.h"

#include "gpio.h"

#include "fimc.h"

/*
#ifdef DISP_FIMC_REG
#define fimcOutp32(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp32(0x%08x, 0x%08x); \n", a2, d2); Outp32(a2, d2);}
#define fimcOutp16(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp16(0x%08x, 0x%08x);\n", a2, d2); Outp16(a2, d2);}
#define fimcOutp8(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp8(0x%08x, 0x%08x);\n", a2, d2); Outp8(a2, d2);}

//#define fimcInp32(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp32(a2, d2); x=d2; Disp("Inp32(\'h%08x, d); // d=0x%08x\n", a2, d2);}
#define fimcInp32(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=Inp32(a2); x=d2; Disp("d = Inp32(0x%08x); // d=0x%08x\n", a2, d2);}

//#define fimcInp16(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp16(a2, d2); x=d2; Disp("Inp16(\'h%08x, d); // d=0x%08x\n", a2, d2);}
#define fimcInp16(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=Inp16(a2); x=d2; Disp("d = Inp16(0x%08x); // d=0x%08x\n", a2, d2);}

//#define fimcInp8(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp8(a2, d2); x=d2; Disp("Inp8(\'h%08x, d); // d=0x%08x\n", a2, ,d2);}
#define fimcInp8(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=Inp8(a2); x=d2; Disp("d = Inp8(0x%08x); // d=0x%08x\n", a2, ,d2);}

//#define fimcOutp32(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp32(\'h%08x, \'h%08x); \/\/ %s(line %d)\n", a2, d2, __FILE__, __LINE__); Outp32(a2, d2);}
//#define fimcInp32(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp32(a2, d2); x=d2; Disp("Inp32(\'h%08x, d); \/\/ %s(line %d)// d=0x%08x\n", a2, __FILE__, __LINE__,d2);}
//#define fimcOutp16(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp16(\'h%08x, \'h%08x); \/\/ %s(line %d)\n", a2, d2, __FILE__, __LINE__); Outp16(a2, d2);}
//#define fimcInp16(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp16(a2, d2); x=d2; Disp("Inp16(\'h%08x, d); \/\/ %s(line %d)// d=0x%08x\n", a2, __FILE__, __LINE__,d2);}
//#define fimcOutp8(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; d2=x; Disp("Outp8(\'h%08x, \'h%08x); \/\/ %s(line %d)\n", a2, d2, __FILE__, __LINE__); Outp8(a2, d2);}
//#define fimcInp8(offset, x) {u32 a2, d2; a2=g_uBaseAddress+offset; Inp8(a2, d2); x=d2; Disp("Inp8(\'h%08x, d); \/\/ %s(line %d)// d=0x%08x\n", a2, __FILE__, __LINE__,d2);}
#else
#define fimcOutp32(offset, x) Outp32(g_uBaseAddress+offset, x)
#define fimcOutp16(offset, x) Outp16(g_uBaseAddress+offset, x)
#define fimcOutp8(offset, x) Outp8(g_uBaseAddress+offset, x)

//#define fimcInp32(offset, x) Inp32(g_uBaseAddress+offset, x)
#define fimcInp32(offset, x) {x=Inp32(g_uBaseAddress+offset);}

//#define fimcInp16(offset, x) Inp16(g_uBaseAddress+offset, x)
#define fimcInp16(offset, x) {x=Inp16(g_uBaseAddress+offset);}

//#define fimcInp8(offset, x) Inp8(g_uBaseAddress+offset, x)
#define fimcInp8(offset, x) {x=Inp8(g_uBaseAddress+offset);}
#endif
*/

#ifdef DISP_FIMC_REG
#define fimcOutp32(ch, offset, x) \
{ \
	u32 a2, d2; \
	u32 BaseAddr; \
	switch(ch) \
	{ \
		case FIMC_A: \
			BaseAddr = FIMC_A_BASE; \
			break; \
		case FIMC_B: \
			BaseAddr = FIMC_B_BASE; \
			break; \
		case FIMC_C: \
			BaseAddr = FIMC_C_BASE; \
			break; \
		default: \
			Assert(0); \
			break; \
	} \
	a2 = BaseAddr+offset; \
	d2 = x; \
	Disp("Outp32(0x%08x, 0x%08x); \n", a2, d2); \
	Outp32(a2, d2); \
}
#define fimcInp32(ch, offset, x) \
{ \
	u32 a2, d2; \
	u32 BaseAddr; \
	switch(ch) \
	{ \
		case FIMC_A: \
			BaseAddr = FIMC_A_BASE; \
			break; \
		case FIMC_B: \
			BaseAddr = FIMC_B_BASE; \
			break; \
		case FIMC_C: \
			BaseAddr = FIMC_C_BASE; \
			break; \
		default: \
			Assert(0); \
			break; \
	} \
	a2=BaseAddr+offset; \
	d2=Inp32(a2); \
	x=d2; \
	Disp("d = Inp32(0x%08x); // d=0x%08x\n", a2, d2); \
}
#else
#define fimcOutp32(ch, offset, x) \
{ \
	u32 BaseAddr; \
	switch(ch) \
	{ \
		case FIMC_A: \
			BaseAddr = FIMC_A_BASE; \
			break; \
		case FIMC_B: \
			BaseAddr = FIMC_B_BASE; \
			break; \
		case FIMC_C: \
			BaseAddr = FIMC_C_BASE; \
			break; \
		default: \
			Assert(0); \
			break; \
	} \
	Outp32(BaseAddr+offset, x); \
}
#define fimcInp32(ch, offset, x) \
{ \
	u32 BaseAddr; \
	switch(ch) \
	{ \
		case FIMC_A: \
			BaseAddr = FIMC_A_BASE; \
			break; \
		case FIMC_B: \
			BaseAddr = FIMC_B_BASE; \
			break; \
		case FIMC_C: \
			BaseAddr = FIMC_C_BASE; \
			break; \
		default: \
			Assert(0); \
			break; \
	} \
	x=Inp32(BaseAddr+offset); \
}
#endif

typedef enum
{
	rCISRCFMT		= 0x00, // Input source format
	rCIWDOFST		= 0x04, // Window offset
	rCIGCTRL		= 0x08, // Global control
	rCIFCTRL1		= 0x0c, // Flash control 1
	rCIFCTRL2		= 0x10, // Flash control 2
	rCIWDOFST2		= 0x14, // Window offset 2

	// Output DMA start address
	// Y
	rCIOYSA1		= 0x18,
	rCIOYSA2		= 0x1c,
	rCIOYSA3		= 0x20,
	rCIOYSA4		= 0x24,
	// CB
	rCIOCBSA1		= 0x28,
	rCIOCBSA2		= 0x2c,
	rCIOCBSA3		= 0x30,
	rCIOCBSA4		= 0x34,
	// CR
	rCIOCRSA1		= 0x38,
	rCIOCRSA2		= 0x3c,
	rCIOCRSA3		= 0x40,
	rCIOCRSA4		= 0x44,
	
	rCITRGFMT		= 0x48, // Target image format of output DMA
	rCIOCTRL		= 0x4c, // Output DMA control related
	rCISCPRERATIO	= 0x50, // Pre-scaler control 1
	rCISCPREDST	= 0x54, // Pre-scaler control 2
	rCISCCTRL		= 0x58, // Main-scaler control
	rCITAREA		= 0x5c, // Target area

	rCIOLINESKIP	= 0x60, // Output DMA line skip
	
	rCISTATUS		= 0x64, // Status [READ ONLY!!!]

	// Image Capture Enable Register
	rCIIMGCPT		= 0xc0, // Image capture enable
	rCICPTSEQ		= 0xc4, // Capture sequence
	rCITHOLD		= 0xc8, // Qos(Quality of service) threshold
	rCIIMGEFF		= 0xd0, // Image effects
	
	// Input DMA start address
	rCIIYSA0		= 0xd4, // Y
	rCIICBSA0		= 0xd8, // CB
	rCIICRSA0		= 0xdc, // CR

	// Input DMA line skip
	rCIILINESKIP_Y	= 0xec, // Y
	rCIILINESKIP_CB	= 0xf0, // CB
	rCIILINESKIP_CR	= 0xf4, // CR
	
	rCIREAL_ISIZE	= 0Xf8, // Real input DMA image size
	rMSCTRL			= 0xfc, // Input DMA control
	
	// Output DMA offset
	rCIOYOFF		= 0x168, // Y
	rCIOCBOFF		= 0x16c, // CB
	rCIOCROFF		= 0x170, // CR
	
	// Input DMA offset
	rCIIYOFF		= 0x174, // Y
	rCIICBOFF		= 0x178, // CB
	rCIICROFF		= 0x17c, // CR

	rORGISIZE		= 0x180, // Input DMA original image size
	rORGOSIZE		= 0x184, // Output DMA original image size	
	rCIEXTEN		= 0x188, // Real Output DMA size
	
	rCIDMAPARAM	= 0x18c, // DMA parameter
	rCSIIMGFMT		= 0x194 // MIPI format register
}FIMC_SFR_OFFSET;

// Scaler and rotator max.size depend on line buffer size(p8)
//---------------------------------------------------------------------------------------------------------------
//#define MAIN_SC_IN_MAX_HSZ_A 			3264 // Main scaler input max H size(uPreDstHSz) of FIMC_A (Scaler ON)
//#define MAIN_SC_IN_MAX_HSZ_B 			1280 // Main scaler input max H size(uPreDstHSz) of FIMC_B (Scaler ON)
//#define MAIN_SC_IN_MAX_HSZ_C 			1440 // Main scaler input max H size(uPreDstHSz) of FIMC_C (Scaler ON)
#define MAIN_SC_IN_MAX_HSZ_A 			4224 // Main scaler input max H size(uPreDstHSz) of FIMC_A (Scaler ON)
#define MAIN_SC_IN_MAX_HSZ_B 			4224 // Main scaler input max H size(uPreDstHSz) of FIMC_B (Scaler ON)
#define MAIN_SC_IN_MAX_HSZ_C 			1920 // Main scaler input max H size(uPreDstHSz) of FIMC_C (Scaler ON)

#define SC_BP_IN_MAX_HSZ_A 			8192 // Scaler BYPASS input max H size of FIMC_A (Scaler OFF)
#define SC_BP_IN_MAX_VSZ_A 			8192 // Scaler BYPASS input max V size of FIMC_A (Scaler OFF)

#define SC_BP_IN_MAX_HSZ_B 			8192 // Scaler BYPASS input max H size of FIMC_B (Scaler OFF)
#define SC_BP_IN_MAX_VSZ_B 			8192 // Scaler BYPASS input max V size of FIMC_B (Scaler OFF)

#define SC_BP_IN_MAX_HSZ_C 			8192 // Scaler BYPASS input max H size of FIMC_C (Scaler OFF)
#define SC_BP_IN_MAX_VSZ_C 			8192 // Scaler BYPASS input max V size of FIMC_C (Scaler OFF)

// Output/input rotator use same line buffer(Line buffer size is '1280')
//#define OUTROT_BP_IN_MAX_HSZ_A		3264 // Output rotator BYPASS input max H size of FIMC_A (Scaler ON, ROT_NO)
//#define OUTROT_BP_IN_MAX_HSZ_B		1280 // Output rotator BYPASS input max H size of FIMC_B (Scaler ON, ROT_NO)
#define OUTROT_BP_IN_MAX_HSZ_A		4224 // Output rotator BYPASS input max H size of FIMC_A (Scaler ON, ROT_NO)
#define OUTROT_BP_IN_MAX_HSZ_B		4224 // Output rotator BYPASS input max H size of FIMC_B (Scaler ON, ROT_NO)
#define OUTROT_BP_IN_MAX_HSZ_C		1920 // Output rotator BYPASS input max H size of FIMC_C (Scaler ON, ROT_NO)

//#define OUTROT_IN_MAX_HSZ_A			1280 // Output rotator input max H size of FIMC_A (Scaler ON, ROT_90)
//#define OUTROT_IN_MAX_HSZ_B			 768 // Output rotator input max H size of FIMC_B (Scaler ON, ROT_90)
#define OUTROT_IN_MAX_HSZ_A			1920 // Output rotator input max H size of FIMC_A (Scaler ON, ROT_90)
#define OUTROT_IN_MAX_HSZ_B			1920 // Output rotator input max H size of FIMC_B (Scaler ON, ROT_90)
#define OUTROT_IN_MAX_HSZ_C			1280 // Output rotator input max H size of FIMC_C (Scaler ON, ROT_90)

#define INROT_BP_IN_MAX_HSZ_A			8192 // Input rotator BYPASS input max H size of FIMC_A (Scaler ON, ROT_NO)
#define INROT_BP_IN_MAX_HSZ_B			8192 // Input rotator BYPASS input max H size of FIMC_B (Scaler ON, ROT_NO)
#define INROT_BP_IN_MAX_HSZ_C			8192 // Input rotator BYPASS input max H size of FIMC_C (Scaler ON, ROT_NO)

//#define INROT_IN_MAX_VSZ_A			1280 // Input rotator input max V size of FIMC_A (Scaler ON, ROT_90)
//#define INROT_IN_MAX_VSZ_B			768 // Input rotator input max V size of FIMC_B (Scaler ON, ROT_90)
#define INROT_IN_MAX_VSZ_A				1920 // Input rotator input max V size of FIMC_A (Scaler ON, ROT_90)
#define INROT_IN_MAX_VSZ_B			 	1920 // Input rotator input max V size of FIMC_B (Scaler ON, ROT_90)
#define INROT_IN_MAX_VSZ_C				1280 // input rotator input max V size of FIMC_C (Scaler ON, ROT_90)
//---------------------------------------------------------------------------------------------------------------

#if 0
// To reduce Inp32() usage
static u32 g_uCISRCFMT; // register offset = 0x00
static u32 g_uCIWDOFST; // register offset = 0x04
static u32 g_uCIGCTRL; // register offset = 0x08
static u32 g_uCIWDOFST2; // register offset = 0x14
static u32 g_uCITRGFMT; // register offset = 0x48
static u32 g_uCIOCTRL; // register offset = 0x4c
static u32 g_uCISCPRERATIO; // register offset = 0x50
static u32 g_uCISCPREDST; // register offset = 0x54
static u32 g_uCISCCTRL; // register offset = 0x58
static u32 g_uCITAREA; // register offset = 0x5c
static u32 g_uCIOLINESKIP; // register offset = 0x60
static u32 g_uCIIMGCPT; // register offset = 0xc0
static u32 g_uCITHOLD; // register offset = 0xc8
static u32 g_uCIIMGEFF; // register offset = 0xd0
static u32 g_uCIILINESKIP_Y; //register offset = 0xec
static u32 g_uCIILINESKIP_CB; // register offset = 0xf0
static u32 g_uCIILINESKIP_CR; // register offset = 0xf4
static u32 g_uCIREAL_ISIZE; // register offset = 0xf8
static u32 g_uMSCTRL; // register offset = 0xfc
static u32 g_uORGISIZE; // register offset = 0x180
static u32 g_uORGOSIZE; // register offset = 0x184
static u32 g_uCIEXTEN; // register offset = 0x188
static u32 g_uCIDMAPARAM; // register offset = 0x18c
static u32 g_uCSIIMGFMT; // register offset = 0x194
#endif

//static u32 g_uBaseAddress;
//static FIMC_PATH g_ePath;
static FIMC_PATH g_ePathOfFimcA;
static FIMC_PATH g_ePathOfFimcB;
static FIMC_PATH g_ePathOfFimcC;

static u32 g_uInvPclk, g_uInvVsync, g_uInvHref, g_uInvField, g_uIfBits;
static u32 g_uCamInImgHsz, g_uCamInImgVsz;
static CAM_ATTR g_eCcir;
static IMG_FMT g_eFinInImgType;
static FIFO_IN_MODE g_eFinMode;

static void FIMC_SetPath(FIMC_CH eCh);

static void FIMC_SetInterrupt(FIMC_CH eCh, INTR eIntr);

static void FIMC_GetPreRatioAndShift(
	u32 uInImgCropSize, u32 uOutImgSize, u32* uPreRatio, u32* uShift);

static void FIMC_SetDinImgAddr(FIMC_CH eCh,
	u32 uInImgAddr, IMG_FMT eInImgFmt, 	u32 uInImgHsz, u32 uInImgVsz);
static void FIMC_SetDinImgFmt(FIMC_CH eCh, IMG_FMT eInImgFmt);
static void FIMC_SetDinFifoCtrl(FIMC_CH eCh, u8 bFifoCtrl);
static void FIMC_SetDinImgSize(FIMC_CH eCh,
	u32 uInImgHsz, u32 uInImgVsz, IMG_FMT eInImgFmt, u32 uInImgLineSkip);

static void FIMC_SetDinImgCroppingOffset(FIMC_CH eCh,
	IMG_FMT eInImgFmt, u32 uInImgCropStartX, u32 uInImgCropStartY);
static void FIMC_SetDinImgCroppingSize(FIMC_CH eCh, u32 uInImgCropHsz, u32 uInImgCropVsz);
static void FIMC_SetDinImgScaler(FIMC_CH eCh,
	IMG_FMT eInImgFmt, u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz);	
static void FIMC_SetDinMode(FIMC_CH eCh, DMA_IN_MODE eDmaInMode);

static void FIMC_SetDoutDispSize(FIMC_CH eCh, u32 uOutDispHsz, u32 uOutDispVsz);
static void FIMC_SetDoutDispAddr(FIMC_CH eCh, 
	u32 uOutImgAddr1, u32 uOutImgAddr2, u32 uOutImgAddr3, u32 uOutImgAddr4, 
	IMG_FMT eOutImgFmt, u32 uOutDispHsz, u32 uOutDispVsz);
//static void FIMC_SetDoutAddrForWeaving(FIMC_CH eCh, 
//	u32 uOutImgAddr, IMG_FMT eOutImgFmt, u32 uOutImgHsz, u32 uOutImgVsz);
static void FIMC_SetDoutImgFmt(FIMC_CH eCh, IMG_FMT eOutImgFmt);
static void FIMC_SetDoutWeave(FIMC_CH eCh, u8 bEnable);

static void FIMC_SetDinDoutOne2One(FIMC_CH eCh, 
	u32 uInImgCropHsz, u32 uInImgCropVsz, IMG_FMT eInImgFmt,
		u32 uOutImgHsz, u32 uOutImgVsz, IMG_FMT eOutImgFmt, u8 bOne2One);

static void FIMC_ResetCameraA(CIS_MODEL eCisModel);
static void FIMC_ResetCameraB(CIS_MODEL eCisModel);
static void FIMC_ResetCameraMipi(CIS_MODEL eCisModel);
static void FIMC_SelCamera(FIMC_CH eCh, CAMERA eCamera);
static void FIMC_ResetIpForFin(FIMC_CH eCh);
static void FIMC_ResetIpForDin(FIMC_CH eCh);
static void FIMC_SetFinMode(FIMC_CH eCh);
static void FIMC_SetFinOvfInt(FIMC_CH eCh, u8 bEnable);
static void FIMC_SetFinShadowUpdate(FIMC_CH eCh, u8 bEnable);
static void FIMC_SetScalerBypass(FIMC_CH eCh, u8 bEnable);
static void FIMC_SetCamModeAndBit(FIMC_CH eCh);
static void FIMC_SetInversePolarityAndHrefMask(FIMC_CH eCh);	
static void FIMC_SetFinImgSize(FIMC_CH eCh);
static void FIMC_SetFinImgYCbCrOrder(FIMC_CH eCh);
static void FIMC_SetMipiImgFmtAndDataAlign(FIMC_CH eCh, 
	IMG_FMT eMipiImgFmt, MIPI_DATA_ALIGN eDataAlign);

static void FIMC_SetInRotAndFlipAndDinImgScaler(FIMC_CH eCh, 
	IMG_FMT eInImgFmt, ROT_FLIP eRotFlip, 
	u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz);
static void FIMC_SetFoutImgFmt(FIMC_CH eCh, LOCAL_IF_TYPE eOutLocalType);
static void FIMC_SetOutScanMode(FIMC_CH eCh, SCAN_MODE eOutScanMode);
static void FIMC_SetFoutImgSize(FIMC_CH eCh, u32 uOutImgHsz, u32 uOutImgVsz);

static void FIMC_SetCscEquationAndYCbCrRange(FIMC_CH eCh, 
	CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange);

/*
// [Set FIMC channel A]
void FIMC_SetChA(void)
{
	g_uBaseAddress = FIMC_A_BASE;
}

// [Set FIMC channel B]
void FIMC_SetChB(void)
{	
	g_uBaseAddress = FIMC_B_BASE;
}

// [Set FIMC channel C]
void FIMC_SetChC(void)
{
	g_uBaseAddress = FIMC_C_BASE;		
}
*/

// [Set path]
static void FIMC_SetPath(FIMC_CH eCh)
{
	u32 uMSCTRL;
	u32 uCISCCTRL;
	u32 uCIGCTRL;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}

	switch(ePath)
	{
		case DMA_IN_DMA_OUT:
			fimcInp32(eCh, rMSCTRL, uMSCTRL); // The 1st order
			uMSCTRL = uMSCTRL |(0x1<<3); // DMA input
			fimcOutp32(eCh, rMSCTRL, uMSCTRL); // The 1st order

			fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
			uCISCCTRL = uCISCCTRL & (~(0x1<<26)); // DMA output
			fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
			break;
		case FIFO_IN_DMA_OUT:
			fimcInp32(eCh, rMSCTRL, uMSCTRL); // The 1st order
			uMSCTRL = uMSCTRL & (~(0x1<<3)); // FIFO input
			fimcOutp32(eCh, rMSCTRL, uMSCTRL); // The 1st order

			fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
			uCISCCTRL = uCISCCTRL & (~(0x1<<26)); // DMA output
			fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

			fimcInp32(eCh, rCIGCTRL, uCIGCTRL); // The 2nd order	
			uCIGCTRL = uCIGCTRL & (~(0x1<<6)); // FIFO input
			fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // The 2nd order			
			break;
		case DMA_IN_FIFO_OUT:
			fimcInp32(eCh, rMSCTRL, uMSCTRL); // The 1st order
			uMSCTRL = uMSCTRL |(0x1<<3); // DMA input
			fimcOutp32(eCh, rMSCTRL, uMSCTRL); // The 1st order

			fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
			uCISCCTRL = uCISCCTRL |(0x1<<26); // FIFO output
			fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
			break;
		case DIRECT_FIFO_IN_DMA_OUT:
			fimcInp32(eCh, rMSCTRL, uMSCTRL); // The 1st order
			uMSCTRL = uMSCTRL & (~(0x1<<3)); // FIFO input
			fimcOutp32(eCh, rMSCTRL, uMSCTRL); // The 1st order

			fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
			uCISCCTRL = uCISCCTRL & (~(0x1<<26)); // DMA output
			fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

			fimcInp32(eCh, rCIGCTRL, uCIGCTRL); // The 2nd order	
			uCIGCTRL = uCIGCTRL |(0x1<<6); // DIRECT-FIFO input
			fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // The 2nd order		
			break;
		default:
			Assert(0);
			break;
	}

}

// [Get pre-ratio and shift]
static void FIMC_GetPreRatioAndShift(
	u32 uInImgCropSize, u32 uOutImgSize, u32* uPreRatio, u32* uShift)
{
	if(uInImgCropSize >= (64*uOutImgSize))
	{
		Assert(0); // Out of scale range
	}	
	else if (uInImgCropSize >= (32*uOutImgSize))
	{
		*uPreRatio=32, *uShift=5;
	}
	else if (uInImgCropSize >= (16*uOutImgSize))
	{
		*uPreRatio=16, *uShift=4;
	}
	else if (uInImgCropSize >= (8*uOutImgSize))
	{
		*uPreRatio=8, *uShift=3;
	}
	else if (uInImgCropSize >= (4*uOutImgSize))
	{
		*uPreRatio=4, *uShift=2;
	}
	else if (uInImgCropSize >= (2*uOutImgSize))
	{
		*uPreRatio=2, *uShift=1;
	}
	else
	{
		*uPreRatio=1, *uShift=0;
	}
}

// [Set output rotator and flip]
void FIMC_SetOutRotAndFlip(FIMC_CH eCh, ROT_FLIP eRotFlip)
{
	u32 uCITRGFMT;
	u32 uMSCTRL;
	
	u32 uRotDeg, uFlip;
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO: // 0 degree
			uRotDeg = 0x0;
			uFlip = 0x0;				
			break;
		case ROT_NO_FLIP_X:
			uRotDeg = 0x0;
			uFlip = 0x1;				
			break;
		case ROT_NO_FLIP_Y:
			uRotDeg = 0x0;
			uFlip = 0x2;				
			break;	
		case ROT_NO_FLIP_XY: // 180 degree
			uRotDeg = 0x0;
			uFlip = 0x3;				
			break;
		case ROT_90_FLIP_NO: // 90 degree
			uRotDeg = 0x1;
			uFlip = 0x0;				
			break;			
		case ROT_90_FLIP_X:
			uRotDeg = 0x1;
			uFlip = 0x1;				
			break;		
		case ROT_90_FLIP_Y:
			uRotDeg = 0x1;
			uFlip = 0x2;				
			break;	
		case ROT_90_FLIP_XY: // 270 degree
			uRotDeg = 0x1;
			uFlip = 0x3;				
			break;
		default:
			Assert(0);
			break;
	}

	fimcInp32(eCh, rCITRGFMT, uCITRGFMT);	
	uCITRGFMT = uCITRGFMT & (~(0x1<<31)); // Input rotator bypass
	uCITRGFMT = uCITRGFMT & (~(0x3<<14));
	uCITRGFMT = uCITRGFMT |(uFlip<<14);
	uCITRGFMT = uCITRGFMT & (~(0x1<<13));
	uCITRGFMT = uCITRGFMT |(uRotDeg<<13);
	fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);	

	fimcInp32(eCh, rMSCTRL, uMSCTRL);
	uMSCTRL = uMSCTRL & (~(0x3<<13));
	fimcOutp32(eCh, rMSCTRL, uMSCTRL);
}

// [Set image effect]
void FIMC_SetImgEffect(FIMC_CH eCh, IMG_EFF eImgEff, u32 uCbVal, u32 uCrVal, IMG_EFF_LOC eImgEffLoc)
{
	u32 uCIIMGEFF;
	u32 uCISCCTRL;

	u32 uImgEffectSel;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
		
	switch(eImgEff)
	{
		case EFF_BYPASS:
			uImgEffectSel = 0x0;
			break;
		case ARBITRARY_CBCR:
			uImgEffectSel = 0x1;
			break;
		case NEGATIVE:
			uImgEffectSel = 0x2;
			break;
		case ART_FREEZE:
			uImgEffectSel = 0x3;
			break;
		case EMBOSSING:
			uImgEffectSel = 0x4;
			break;
		case SILHOUETTE:
			uImgEffectSel = 0x5;
			break;
		default:
			Assert(0);
			break;
	}
	
	fimcInp32(eCh, rCIIMGEFF, uCIIMGEFF);
	uCIIMGEFF = uCIIMGEFF |(0x1<<30); // Image effect function enable

	if(eImgEffLoc == AFTER_SCALING)
	{
		uCIIMGEFF = uCIIMGEFF |(0x1<<29); // Image effect location (After scaling)

		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & 0x80000000;
		if(uCISCCTRL == 0x80000000) // Scaler bypass ON
		{
			Assert(0);
		}
	}
	else if(eImgEffLoc == BEFORE_SCALING)
	{
		uCIIMGEFF = uCIIMGEFF & (~(0x1<<29)); // Image effect location (Before scaling)

		if(ePath != FIFO_IN_DMA_OUT)
		{
			Assert(0);
		}
	}
	else
	{
		Assert(0);
	}
	
	uCIIMGEFF = uCIIMGEFF & (~(0x7<<26));
	uCIIMGEFF = uCIIMGEFF |(uImgEffectSel<<26); // Image effect selection

	if(eImgEff == ARBITRARY_CBCR)
	{
		// Wide CSC range
		Assert((0<uCbVal)&&(uCbVal<255));
		Assert((0<uCrVal)&&(uCrVal<255));
		
		uCIIMGEFF = uCIIMGEFF & (~(0xff<<13));
		uCIIMGEFF = uCIIMGEFF |(uCbVal<<13);
		
		uCIIMGEFF = uCIIMGEFF & (~(0xff<<0));
		uCIIMGEFF = uCIIMGEFF |(uCrVal<<0);
	}

	fimcOutp32(eCh, rCIIMGEFF, uCIIMGEFF);
}

static void FIMC_SetCscEquationAndYCbCrRange(FIMC_CH eCh, 
	CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	u32 uCIGCTRL;
	u32 uCISCCTRL;
	
	// 1. Set color space conversion
	//--------------------------
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	switch(eCscEquation)
	{
		case CSC_ITU601:
			uCIGCTRL = uCIGCTRL & (~(0x1<<5)); // SD
			break;
		case CSC_ITU709:
			uCIGCTRL = uCIGCTRL |(0x1<<5); // HD
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);

	// 2. Set YCbCr range
	//-----------------
	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);	
	switch(eYCbCrRange)
	{
		case YCBCR_NARROW:
			uCISCCTRL = uCISCCTRL & (~(0x1<<28)); // Narrow (from RGB to YCbCr)
			uCISCCTRL = uCISCCTRL & (~(0x1<<27)); // Narrow (from YCbCr to RGB)
			break;
		case YCBCR_WIDE:
			uCISCCTRL = uCISCCTRL |(0x1<<28); // Wide (from RGB to YCbCr)
			uCISCCTRL = uCISCCTRL |(0x1<<27); // Wide (from YCbCr to RGB)
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);	
}

// [Get YCbCr size]
void FIMC_GetYCbCrSize(IMG_FMT eImgFmt,  u32 uImgHsz, u32 uImgVsz,
	u32* uYSize, u32* uCbSize, u32* uCrSize)
{
	// For TILE_NV12
	u32 uY_HSizeByte=0, uY_VSizeByte=0;
	u32 uCb_HSizeByte=0, uCb_VSizeByte=0;
	u32 uRemain; // To make 'uImgHsz and uImgVsz' be 16 multiple
	u32 uY_HSizeByteMinus, uY_VSizeByteMinus;
	u32 uY_HRoundUp, uY_VRoundUp;
	u32 uCb_HSizeByteMinus, uCb_VSizeByteMinus;
	u32 uCb_HRoundUp, uCb_VRoundUp;	
	
	switch(eImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
			*uYSize = uImgHsz*uImgVsz*4;
			break;
		case BayerRGB8:
			*uYSize = uImgHsz*uImgVsz;
			break;
		case BayerRGB10:
			Assert((uImgHsz*uImgVsz)%4==0);
			*uYSize = (uImgHsz*uImgVsz*5)/4;
			break;
		case BayerRGB12:
			Assert((uImgHsz*uImgVsz)%2==0);
			*uYSize = (uImgHsz*uImgVsz*3)/2;			
			break;
		// 1 plane
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			*uYSize = uImgHsz*uImgVsz*2;				
			break;
		// 2 plane
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = (uImgHsz*uImgVsz)/2;
			break;
		// 2 plane
		case TILE_NV12:
			// To make 'uImgHsz and uImgVsz' be 16 multiple
			uRemain = uImgHsz % 16;
			if(uRemain != 0)
			{
				uRemain = 16 - uRemain;
				uImgHsz = uImgHsz + uRemain;
			}
			uRemain = uImgVsz % 16;
			if(uRemain != 0)
			{
				uRemain = 16 - uRemain;
				uImgVsz = uImgVsz + uRemain;
			}
			Assert((uImgHsz)%16==0);
			Assert((uImgVsz)%16==0);

			uY_HSizeByte = uImgHsz;
			uY_VSizeByte = uImgVsz;
			uCb_HSizeByte = uImgHsz;
			uCb_VSizeByte = uImgVsz/2;	

			uY_HSizeByteMinus = uY_HSizeByte - 1;
			uY_VSizeByteMinus = uY_VSizeByte - 1;
			uY_HRoundUp = ((uY_HSizeByteMinus/16)/8) + 1;
			uY_VRoundUp = ((uY_VSizeByteMinus/16)/4) + 1;
			if((uY_VSizeByteMinus & 0x20) == 0)
			{
				uY_HSizeByteMinus = uY_HSizeByteMinus & 0x7f00;
				uY_HSizeByteMinus = uY_HSizeByteMinus >> 8;
				uY_HSizeByteMinus = uY_HSizeByteMinus & 0x7f;

				uY_VSizeByteMinus = uY_VSizeByteMinus & 0x7fc0;
				uY_VSizeByteMinus = uY_VSizeByteMinus >> 6;
				uY_VSizeByteMinus = uY_VSizeByteMinus & 0x1ff;
				
				*uYSize = uY_HSizeByteMinus + (uY_VSizeByteMinus*uY_HRoundUp) + 1;
			}
			else
			{
				*uYSize = uY_HRoundUp * uY_VRoundUp;
			}
			*uYSize = (*uYSize) << 13;

			uCb_HSizeByteMinus = uCb_HSizeByte - 1;
			uCb_VSizeByteMinus = uCb_VSizeByte - 1;
			uCb_HRoundUp = ((uCb_HSizeByteMinus/16)/8) + 1;
			uCb_VRoundUp = ((uCb_VSizeByteMinus/16)/4) + 1;
			if((uCb_VSizeByteMinus & 0x20) == 0)
			{
				uCb_HSizeByteMinus = uCb_HSizeByteMinus & 0x7f00;
				uCb_HSizeByteMinus = uCb_HSizeByteMinus >> 8;
				uCb_HSizeByteMinus = uCb_HSizeByteMinus & 0x7f;

				uCb_VSizeByteMinus = uCb_VSizeByteMinus & 0x7fc0;
				uCb_VSizeByteMinus = uCb_VSizeByteMinus >> 6;
				uCb_VSizeByteMinus = uCb_VSizeByteMinus & 0x1ff;
				
				*uCbSize = uCb_HSizeByteMinus + (uCb_VSizeByteMinus*uCb_HRoundUp) + 1;
			}
			else
			{
				*uCbSize = uCb_HRoundUp * uCb_VRoundUp;
			}
			*uCbSize = (*uCbSize) << 13;				
			break;
		// 2 plane
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = uImgHsz*uImgVsz;			
			break;
		// 2 plane
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = uImgHsz*uImgVsz*2;				
			break;
		// 3 plane
		case YC420:
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = (uImgHsz*uImgVsz)/4;
			*uCrSize = (uImgHsz*uImgVsz)/4;
			break;
		// 3 plane
		case YC422:
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = (uImgHsz*uImgVsz)/2;
			*uCrSize = (uImgHsz*uImgVsz)/2;
			break;	
		// 3 plane
		case YC444:
			*uYSize = uImgHsz*uImgVsz;
			*uCbSize = uImgHsz*uImgVsz;
			*uCrSize = uImgHsz*uImgVsz;
			break;			
		default:
			Assert(0);
			break;
	}

	// We need to keep below code  
	/*
	if(eImgMemType == LINEAR)
	{
		switch(eImgFmt)
		{
			// 1 plane
			case RGB24:
				uYSize = uImgHsz*uImgVsz*4;
				break;
			// 1 plane
			case RGB16:
			case YCBYCR:
			case YCRYCB:
			case CBYCRY:
			case CRYCBY:
				uYSize = uImgHsz*uImgVsz*2;				
				break;
			// 2 plane
			case NV12:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = (uImgHsz*uImgVsz)/2;
				break;
			// 2 plane
			case NV16:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = uImgHsz*uImgVsz;			
				break;
			// 2 plane
			case NV24:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = uImgHsz*uImgVsz*2;				
				break;
			// 3 plane
			case YC420:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = (uImgHsz*uImgVsz)/4;
				uCrSize = (uImgHsz*uImgVsz)/4;
				break;
			// 3 plane
			case YC422:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = (uImgHsz*uImgVsz)/2;
				uCrSize = (uImgHsz*uImgVsz)/2;
				break;	
			// 3 plane
			case YC444:
				uYSize = uImgHsz*uImgVsz;
				uCbSize = uImgHsz*uImgVsz;
				uCrSize = uImgHsz*uImgVsz;
				break;			
			default:
				Assert(0);
				break;
		}
	}
	else if(eImgMemType == TILE_64BY32)
	{
		u32 uY_HSizeByte=0, uY_VSizeByte=0;
		u32 uCb_HSizeByte=0, uCb_VSizeByte=0;
		u32 uCr_HSizeByte=0, uCr_VSizeByte=0;

		// To make 'uImgHsz and uImgVsz' be 16 multiple
		u32 uRemain;
		uRemain = uImgHsz % 16;
		if(uRemain != 0)
		{
			uRemain = 16 - uRemain;
			uImgHsz = uImgHsz + uRemain;
		}
		uRemain = uImgVsz % 16;
		if(uRemain != 0)
		{
			uRemain = 16 - uRemain;
			uImgVsz = uImgVsz + uRemain;
		}
		Assert((uImgHsz)%16==0);
		Assert((uImgVsz)%16==0);
				
		switch(eImgFmt)
		{
			// 1 plane
			case RGB24:
				uY_HSizeByte = uImgHsz*4;
				uY_VSizeByte = uImgVsz;
				break;
			// 1 plane
			case RGB16:
			case YCBYCR:
			case YCRYCB:
			case CBYCRY:
			case CRYCBY:
				uY_HSizeByte = uImgHsz*2;
				uY_VSizeByte = uImgVsz;				
				break;
			// 2 plane
			case NV12:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz;
				uCb_VSizeByte = uImgVsz/2;				
				break;
			// 2 plane
			case NV16:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz;
				uCb_VSizeByte = uImgVsz;				
				break;
			// 2 plane
			case NV24:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz*2;
				uCb_VSizeByte = uImgVsz;		
				break;
			// 3 plane
			case YC420:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz/2;
				uCb_VSizeByte = uImgVsz/2;
				uCr_HSizeByte = uImgHsz/2;
				uCr_VSizeByte = uImgVsz/2;
				break;
			// 3 plane
			case YC422:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz/2;
				uCb_VSizeByte = uImgVsz;
				uCr_HSizeByte = uImgHsz/2;
				uCr_VSizeByte = uImgVsz;		
				break;
			// 3plane
			case YC444:
				uY_HSizeByte = uImgHsz;
				uY_VSizeByte = uImgVsz;
				uCb_HSizeByte = uImgHsz;
				uCb_VSizeByte = uImgVsz;
				uCr_HSizeByte = uImgHsz;
				uCr_VSizeByte = uImgVsz;				
				break;
			default:
				Assert(0);
				break;				
		}

		u32 uTemp;

		u32 uY_HSizeByteMinus, uY_VSizeByteMinus;
		u32 uY_HRoundUp, uY_VRoundUp;
		uY_HSizeByteMinus = uY_HSizeByte - 1;
		uY_VSizeByteMinus = uY_VSizeByte - 1;
		uY_HRoundUp = ((uY_HSizeByteMinus/16)/8) + 1;
		uY_VRoundUp = ((uY_VSizeByteMinus/16)/4) + 1;
		if((uY_VSizeByteMinus & 0x20) == 0)
		{
			uY_HSizeByteMinus = uY_HSizeByteMinus & 0x7f00;
			uY_HSizeByteMinus = uY_HSizeByteMinus >> 8;
			uY_HSizeByteMinus = uY_HSizeByteMinus & 0x7f;

			uY_VSizeByteMinus = uY_VSizeByteMinus & 0x7fc0;
			uY_VSizeByteMinus = uY_VSizeByteMinus >> 6;
			uY_VSizeByteMinus = uY_VSizeByteMinus & 0x1ff;
			
			uYSize = uY_HSizeByteMinus + (uY_VSizeByteMinus*uY_HRoundUp) + 1;
		}
		else
		{
			uYSize = uY_HRoundUp * uY_VRoundUp;
		}
		uYSize = uYSize << 13;

		u32 uCb_HSizeByteMinus, uCb_VSizeByteMinus;
		u32 uCb_HRoundUp, uCb_VRoundUp;
		uCb_HSizeByteMinus = uCb_HSizeByte - 1;
		uCb_VSizeByteMinus = uCb_VSizeByte - 1;
		uCb_HRoundUp = ((uCb_HSizeByteMinus/16)/8) + 1;
		uCb_VRoundUp = ((uCb_VSizeByteMinus/16)/4) + 1;
		if((uCb_VSizeByteMinus & 0x20) == 0)
		{
			uCb_HSizeByteMinus = uCb_HSizeByteMinus & 0x7f00;
			uCb_HSizeByteMinus = uCb_HSizeByteMinus >> 8;
			uCb_HSizeByteMinus = uCb_HSizeByteMinus & 0x7f;

			uCb_VSizeByteMinus = uCb_VSizeByteMinus & 0x7fc0;
			uCb_VSizeByteMinus = uCb_VSizeByteMinus >> 6;
			uCb_VSizeByteMinus = uCb_VSizeByteMinus & 0x1ff;
			
			uCbSize = uCb_HSizeByteMinus + (uCb_VSizeByteMinus*uCb_HRoundUp) + 1;
		}
		else
		{
			uCbSize = uCb_HRoundUp * uCb_VRoundUp;
		}
		uCbSize = uCbSize << 13;

		u32 uCr_HSizeByteMinus, uCr_VSizeByteMinus;
		u32 uCr_HRoundUp, uCr_VRoundUp;
		uCr_HSizeByteMinus = uCr_HSizeByte - 1;
		uCr_VSizeByteMinus = uCr_VSizeByte - 1;
		uCr_HRoundUp = ((uCr_HSizeByteMinus/16)/8) + 1;
		uCr_VRoundUp = ((uCr_VSizeByteMinus/16)/4) + 1;
		if((uCr_VSizeByteMinus & 0x20) == 0)
		{
			uCr_HSizeByteMinus = uCr_HSizeByteMinus & 0x7f00;
			uCr_HSizeByteMinus = uCr_HSizeByteMinus >> 8;
			uCr_HSizeByteMinus = uCr_HSizeByteMinus & 0x7f;

			uCr_VSizeByteMinus = uCr_VSizeByteMinus & 0x7fc0;
			uCr_VSizeByteMinus = uCr_VSizeByteMinus >> 6;
			uCr_VSizeByteMinus = uCr_VSizeByteMinus & 0x1ff;
			
			uCrSize = uCr_HSizeByteMinus + (uCr_VSizeByteMinus*uCr_HRoundUp) + 1;
		}
		else
		{
			uCrSize = uCr_HRoundUp * uCr_VRoundUp;
		}				
		uCrSize = uCrSize << 13;
	}
	else
	{
		Assert(0);
	}
	*/
}

// [Get next frame buffer address]
void FIMC_GetNextFbAddr(IMG_FMT eImgFmt, u32 uImgHsz, u32 uImgVsz, u32 uFirstFbAddr,
	u32* uNextFbAddr)
{
	u32 uYSize, uCbSize, uCrSize;
	FIMC_GetYCbCrSize(eImgFmt, uImgHsz, uImgVsz, &uYSize, &uCbSize, &uCrSize);
	
	switch(eImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
		case RGB16:
		case YCBYCR:
		case YCRYCB:			
		case CBYCRY:
		case CRYCBY:
			*uNextFbAddr = uFirstFbAddr + uYSize;
			break;
		// 2 plane
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case TILE_NV12:
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			*uNextFbAddr = uFirstFbAddr + uYSize + uCbSize;
			break;
		// 3 plane
		case YC420:
		case YC422:	
		case YC444:			
			*uNextFbAddr = uFirstFbAddr + uYSize + uCbSize + uCrSize;
			break;
		default:
			Assert(0);
			break;		
	}
}

// [Wait for processing done]
u8 FIMC_WaitForProcessingDone(FIMC_CH eCh)
{
	u32 uCISTATUS;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}

	if(ePath == DMA_IN_DMA_OUT)
	{
		do
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
		}
		while((uCISTATUS&0x20000) != 0x20000);

		// [17]_bit is NOT auto clear, so we need to make [17]_bit be clear
		fimcInp32(eCh, rCISTATUS, uCISTATUS);
		uCISTATUS = uCISTATUS & (~(0x1<<17));
		fimcOutp32(eCh, rCISTATUS, uCISTATUS);
	}
	else if((ePath==FIFO_IN_DMA_OUT)||(ePath==DIRECT_FIFO_IN_DMA_OUT))
	{
		for(;;)
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
			
			if(((uCISTATUS&0x10000)==0x10000) // [16]: Last capture end
				&& ((uCISTATUS&0x80000000)==0x0) // [31]: Overflow state of FIFO Y
				&& ((uCISTATUS&0x40000000)==0x0) // [30]: Overflow state of FIFO Cb
				&& ((uCISTATUS&0x20000000)==0x0) // [29]: Overflow state of FIFO Cr
				&& ((uCISTATUS&0x40000)==0x0)) // [18]: Overflow status of line buffer for rotation
			{
				break;
			}
		}

		// [16]_bit is NOT auto clear, so we nedd to make [16]_bit be clear
		fimcInp32(eCh, rCISTATUS, uCISTATUS);
		uCISTATUS = uCISTATUS & (~(0x1<<16));
		fimcOutp32(eCh, rCISTATUS, uCISTATUS);		
	}
	else
	{
		Assert(0);
	}	

	return true;
}

// [Wait for processing done for capture frame control]
u8 FIMC_WaitForProcessingDoneForCptFrmCtrl(FIMC_CH eCh)
{
	u32 uCISTATUS;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
	
	Assert(ePath == FIFO_IN_DMA_OUT);
	
	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	if((uCISTATUS & 0x800) == 0x800) // Present capture enable
	{
		for(;;)
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
			
			if(((uCISTATUS&0x10000)==0x10000) // [16]: Last capture end
				&& ((uCISTATUS&0x80000000)==0x0) // [31]: Overflow state of FIFO Y
				&& ((uCISTATUS&0x40000000)==0x0) // [30]: Overflow state of FIFO Cb
				&& ((uCISTATUS&0x20000000)==0x0) // [29]: Overflow state of FIFO Cr
				&& ((uCISTATUS&0x40000)==0x0)) // [18]: Overflow status of line buffer for rotation
			{
				break;
			}
		}
	}
	else // Present capture disable
	{
		// Do NOT check LastCaptureEnd[16] in rCISTATUS
	}

	// [16]_bit is NOT auto clear, so we nedd to make [16]_bit be clear
	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & (~(0x1<<16));
	fimcOutp32(eCh, rCISTATUS, uCISTATUS);		

	return true;
}

// [Set interrupt]
static void FIMC_SetInterrupt(FIMC_CH eCh, INTR eIntr)
{
	u32 uCIGCTRL;
	
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);	
	switch(eIntr)
	{
		case EDGE:
			uCIGCTRL = uCIGCTRL & (~(0x1<<20)); // Edge interrupt
			break;
		case LEVEL:
			uCIGCTRL = uCIGCTRL |(0x1<<20); // Level interrupt
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Clear interrupt]
void FIMC_ClearInterrupt(FIMC_CH eCh)
{
	u32 uCIGCTRL;
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL |(0x1<<19); // Clear interrupt when LEVEL interrupt
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Initialize IP for DMA-in DMA-out]
void FIMC_InitIpForDinDout(FIMC_CH eCh,
		u32 uInImgHsz, u32 uInImgVsz, u32 uInImgLineSkip,
		u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,		
		u32 uInImgAddr, IMG_FMT eInImgFmt,
		u32 uOutDispHsz, u32 uOutDispVsz,
		u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
		u32 uOutImgAddr, IMG_FMT eOutImgFmt,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange, u8 bOne2One)
{
	u32 i;
	u32 uYSize, uCbSize, uCrSize;

	u32 uNextFbAddr;

	// Set DMA out mode
	DMA_OUT_MODE eDmaOutMode;
	switch(eOutImgFmt)
	{
		case RGB16_IB:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;			
			break;
		case RGB24_IB:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case NV12_IB:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;	
			break;
		case TILE_NV12_IB:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case RGB16_IW:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_WEAVING;			
			break;
		case RGB24_IW:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case NV12_IW:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;	
			break;
		case TILE_NV12_IW:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		default:
			eDmaOutMode = PROGRESSIVE_OUT;			
			break;
	}	

	Assert((eOutImgFmt!=BayerRGB8)&&(eOutImgFmt!=BayerRGB10)&&(eOutImgFmt!=BayerRGB12));
	
	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForDin(eCh);
	FIMC_SetScalerBypass(eCh, false);
	FIMC_SetImgEffect(eCh, EFF_BYPASS, 0, 0, AFTER_SCALING);	

	// Set DMA in, DMA out path
	//g_ePath = DMA_IN_DMA_OUT;
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA = DMA_IN_DMA_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB = DMA_IN_DMA_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC = DMA_IN_DMA_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	// Set DMA in/out One2One for MFC
	FIMC_SetDinDoutOne2One(eCh,
		uInImgCropHsz, uInImgCropVsz, eInImgFmt,
		uOutImgHsz, uOutImgVsz, eOutImgFmt, bOne2One);

	//======
	
	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, false);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);
		
	Assert((uInImgCropStartX+uInImgCropHsz) <= uInImgHsz);
	Assert((uInImgCropStartY+uInImgCropVsz) <= uInImgVsz);

	// Set DMA input image start address
	FIMC_SetDinImgAddr(eCh, uInImgAddr, eInImgFmt, uInImgHsz, uInImgVsz);
	
	// Set DMA input image size
	FIMC_SetDinImgSize(eCh, uInImgHsz, uInImgVsz, eInImgFmt, uInImgLineSkip);

	// Set DMA input image format
	FIMC_SetDinImgFmt(eCh, eInImgFmt);

	// Set DMA input image cropping offset
	FIMC_SetDinImgCroppingOffset(eCh, eInImgFmt, uInImgCropStartX, uInImgCropStartY);
	
	// Set DMA input image cropping size
	FIMC_SetDinImgCroppingSize(eCh, uInImgCropHsz, uInImgCropVsz);	

	//======

	if((eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR420_2P_CBCR_BE)
	||(eOutImgFmt==TILE_NV12)
	||(eOutImgFmt==YC420))
	{
		Assert((uOutImgVsz%2) == 0); // p30
	}

	// Set DMA input image scaler
	FIMC_SetDinImgScaler(eCh, 
		eInImgFmt, uInImgCropHsz, uInImgCropVsz, uOutImgHsz, uOutImgVsz);	

	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_BYPASS_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_A); // p8					
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_B); // p8					
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_C); // p8
					break;
				default:
					Assert(0);
					break;
			}
			Assert((uOutImgStartX+uOutImgHsz) <= uOutDispHsz);
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartY+(uOutImgVsz/2)) <= uOutDispVsz);
			}
			else
			{
				Assert((uOutImgStartY+uOutImgVsz) <= uOutDispVsz);			
			}
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_A); // p8
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_B); // p8
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartX+(uOutImgVsz/2)) <= uOutDispHsz);
			}
			else
			{
				Assert((uOutImgStartX+uOutImgVsz) <= uOutDispHsz);
			}
			Assert((uOutImgStartY+uOutImgHsz) <= uOutDispVsz);
			break;
		default:
			Assert(0);
			break;
	}	
	
	// Set output rotator and FlipMd and InFlipMd_M
	FIMC_SetOutRotAndFlip(eCh, eRotFlip);

	// Set color space conversion equation and YCbCr range
	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);

	//======

	switch(eDmaOutMode)
	{
		case PROGRESSIVE_OUT:			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr, uOutImgAddr, uOutImgAddr, uOutImgAddr, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);			
			
			FIMC_SetOutScanMode(eCh, PROGRESSIVE);
			FIMC_SetDoutWeave(eCh, false);			
			break;
		case INTERLACE_OUT_EVEN_ODD:			
			// uOutImgAddr: EVEN start address, uNextFbAddr: ODD start address
			FIMC_GetNextFbAddr(eOutImgFmt, uOutDispHsz, uOutDispVsz,
				uOutImgAddr, &uNextFbAddr);			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr, uNextFbAddr, uOutImgAddr, uNextFbAddr, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);	

			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, false);			
			break;
		case INTERLACE_OUT_WEAVING:			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr, uOutImgAddr, uOutImgAddr, uOutImgAddr, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);
			
			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, true);			
			break;
		default:
			Assert(0);
			break;
	}	

	// Set DMA output display size
	FIMC_SetDoutDispSize(eCh, uOutDispHsz, uOutDispVsz);
	
	// Set DMA output image format
	FIMC_SetDoutImgFmt(eCh, eOutImgFmt);

	// Set DMA output image offset
	FIMC_SetDoutImgOffset(eCh, eOutImgFmt, uOutImgStartX, uOutImgStartY);

	// Set DMA output image size
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			if(eDmaOutMode == PROGRESSIVE_OUT)
			{
				Assert(uOutImgVsz%16 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_EVEN_ODD)
			{
				Assert(uOutImgVsz%32 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_WEAVING)
			{
				Assert(0);
			}
			else
			{
				Assert(0);
			}
			break;
		default:
			Assert(0);
			break;			
	}
	FIMC_SetDoutImgSize(eCh, uOutImgHsz, uOutImgVsz, eOutImgFmt, uOutImgLineSkip);
}

void FIMC_SetDinQos(FIMC_CH eCh, u32 uReadBufThVal)
{
	u32 uCITHOLD;

	Assert((0x0<=uReadBufThVal)&&(uReadBufThVal<=0x7f));
	
	fimcInp32(eCh, rCITHOLD, uCITHOLD);		
	uCITHOLD = uCITHOLD |(0x1<<31); // Read channel buffer Qos mask	
	uCITHOLD = uCITHOLD & (~(0x7f<<16));
	uCITHOLD = uCITHOLD |(uReadBufThVal<<16); // Read buffer threshold
	fimcOutp32(eCh, rCITHOLD, uCITHOLD);
}

// [Set DMA-in image address]
static void FIMC_SetDinImgAddr(FIMC_CH eCh,
	u32 uInImgAddr, IMG_FMT eInImgFmt, u32 uInImgHsz, u32 uInImgVsz)
{
	u32 uCIREAL_ISIZE;
	u32 uYSize, uCbSize, uCrSize;

	fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
	uCIREAL_ISIZE = uCIREAL_ISIZE |(0x1<<30); // Input DMA address change DISABLE
	fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);

	Assert(uInImgAddr%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35

	FIMC_GetYCbCrSize(eInImgFmt, uInImgHsz, uInImgVsz, &uYSize, &uCbSize, &uCrSize);

	switch(eInImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			fimcOutp32(eCh, rCIIYSA0, uInImgAddr);
			break;
		// 2 plane
		case TILE_NV12:			
			// AIF v3.0 has a restriction when processing TILE_NV12
			Assert(uInImgAddr%0x1000==0); 
			Assert((uInImgAddr+uYSize)%0x1000==0);			
			fimcOutp32(eCh, rCIIYSA0, uInImgAddr);
			fimcOutp32(eCh, rCIICBSA0, uInImgAddr + uYSize);			
			break;
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:
			fimcOutp32(eCh, rCIIYSA0, uInImgAddr);
			fimcOutp32(eCh, rCIICBSA0, uInImgAddr + uYSize);
			break;
		// 3 plane
		case YC420:
		case YC422:	
		case YC444:			
			fimcOutp32(eCh, rCIIYSA0, uInImgAddr);
			fimcOutp32(eCh, rCIICBSA0, uInImgAddr + uYSize);
			fimcOutp32(eCh, rCIICRSA0, uInImgAddr + uYSize + uCbSize);
			break;
		default:
			Assert(0);
			break;
	}	

	fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
	uCIREAL_ISIZE = uCIREAL_ISIZE & (~(0x1<<30)); // Input DMA address change ENABLE
	fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
}

// [Set DMA-in image address]
void FIMC_SetDinImgAddrForMfc(FIMC_CH eCh, IMG_FMT eInImgFmt, u32 uYAddr, u32 uCAddr) // For MFC
{
	u32 uCIREAL_ISIZE;
		
	// TILE_NV12: MFC decoding scenario, NV12: MFC encoding scenario
	Assert((eInImgFmt==TILE_NV12)||(eInImgFmt==NV12));
	
	fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
	uCIREAL_ISIZE = uCIREAL_ISIZE |(0x1<<30); // Input DMA address change DISABLE
	fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);

	// AIF v3.0 has a restriction when processing TILE_NV12
	Assert(uYAddr%0x1000==0);
	Assert(uCAddr%0x1000==0);
	
	fimcOutp32(eCh, rCIIYSA0, uYAddr);
	fimcOutp32(eCh, rCIICBSA0, uCAddr);

	fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
	uCIREAL_ISIZE = uCIREAL_ISIZE & (~(0x1<<30)); // Input DMA address change ENABLE
	fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
}

// [Set DMA-in image format]
static void FIMC_SetDinImgFmt(FIMC_CH eCh, IMG_FMT eInImgFmt)
{
	u32 uCIEXTEN;
	u32 uMSCTRL;
	u32 uCISCCTRL;
	u32 uCIDMAPARAM;
	
	u32 uInputImgFmt;
	u32 uYCbCr2PlaneOrder;
	u32 uYCbCr1PlaneOrder;
	u32 uRgbFormat;

	u32 uInAddrAccess;

	Assert((eInImgFmt==RGB16)||(eInImgFmt==RGB18)||(eInImgFmt==RGB24) // RGB
		// YCbCr 420		
		||(eInImgFmt==NV12) // YCBCR420_2P_CRCB_LE
		||(eInImgFmt==YCBCR420_2P_CBCR_LE)
		||(eInImgFmt==YCBCR420_2P_CRCB_BE)
		||(eInImgFmt==YCBCR420_2P_CBCR_BE)
		||(eInImgFmt==TILE_NV12)
		||(eInImgFmt==YC420)
		// YCbCr 422
		||(eInImgFmt==YCBYCR)||(eInImgFmt==YCRYCB)||(eInImgFmt==CRYCBY)||(eInImgFmt==CBYCRY)			
		||(eInImgFmt==NV16) // YCBCR422_2P_CRCB_LE
		||(eInImgFmt==YCBCR422_2P_CBCR_LE)
		||(eInImgFmt==YCBCR422_2P_CRCB_BE)
		||(eInImgFmt==YCBCR422_2P_CBCR_BE)
		||(eInImgFmt==YC422)	
		// YCbCr 444
		||(eInImgFmt==NV24) // YCBCR444_2P_CRCB_LE
		||(eInImgFmt==YCBCR444_2P_CBCR_LE)
		||(eInImgFmt==YCBCR444_2P_CRCB_BE)
		||(eInImgFmt==YCBCR444_2P_CBCR_BE)
		||(eInImgFmt==YC444)); 

	// YCbCr 4:4:4 (2 or 3 plane input image DMA format)
	if((eInImgFmt==NV24) // YCBCR444_2P_CRCB_LE
	||(eInImgFmt==YCBCR444_2P_CBCR_LE)
	||(eInImgFmt==YCBCR444_2P_CRCB_BE)
	||(eInImgFmt==YCBCR444_2P_CBCR_BE)
	||(eInImgFmt==YC444)) 
	{
		fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
		uCIEXTEN = uCIEXTEN |(0x1<<20); // YCbCr444_IN (Priority is higher than InFormat_M)
		fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);		
	}
	else
	{
		fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
		uCIEXTEN = uCIEXTEN & (~(0x1<<20)); // YCbCr444_IN (Priority is higher than InFormat_M)
		fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);	
		
		switch(eInImgFmt)
		{
			case NV12: // YCBCR420_2P_CRCB_LE
			case YCBCR420_2P_CBCR_LE:
			case YCBCR420_2P_CRCB_BE:
			case YCBCR420_2P_CBCR_BE:
			case TILE_NV12:
			case YC420:
				uInputImgFmt = 0x0; // YCbCr 4:2:0 (2 or 3 plane input image DMA format)
				break;
			case NV16: // YCBCR422_2P_CRCB_LE
			case YCBCR422_2P_CBCR_LE:
			case YCBCR422_2P_CRCB_BE:
			case YCBCR422_2P_CBCR_BE:				
			case YC422:
				uInputImgFmt = 0x1; // YCbCr 4:2:2 (2 or 3 plane input image DMA format)
				break;
			case YCBYCR:
			case YCRYCB:
			case CRYCBY:
			case CBYCRY:
				uInputImgFmt = 0x2; // YCbCr 4:2:2 (1 plane input image DMA format)
				break;
			case RGB16:
			case RGB18:
			case RGB24:
				uInputImgFmt = 0x3; // RGB input image DMA format
				break;
			default:
				Assert(0);
				break;
		}
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL & (~(0x3<<1));
		uMSCTRL = uMSCTRL |(uInputImgFmt<<1);
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);
	}

	// 2 plane input DMA format
	if((eInImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eInImgFmt==YCBCR420_2P_CBCR_LE)
	||(eInImgFmt==YCBCR420_2P_CRCB_BE)
	||(eInImgFmt==YCBCR420_2P_CBCR_BE)	
	||(eInImgFmt==TILE_NV12)
	||(eInImgFmt==NV16) // YCBCR422_2P_CRCB_LE
	||(eInImgFmt==YCBCR422_2P_CBCR_LE)
	||(eInImgFmt==YCBCR422_2P_CRCB_BE)
	||(eInImgFmt==YCBCR422_2P_CBCR_BE)	
	||(eInImgFmt==NV24) // YCBCR444_2P_CRCB_LE
	||(eInImgFmt==YCBCR444_2P_CBCR_LE)
	||(eInImgFmt==YCBCR444_2P_CRCB_BE)
	||(eInImgFmt==YCBCR444_2P_CBCR_BE))	
	{
		switch(eInImgFmt)
		{
			case NV12: // YCBCR420_2P_CRCB_LE
			case TILE_NV12:
			case NV16: // YCBCR422_2P_CRCB_LE
			case NV24: // YCBCR444_2P_CRCB_LE
				uYCbCr2PlaneOrder = 0x0; // Cr3Cb3Cr2Cb2Cr1Cb1Cr0Cb0
				break;
			case YCBCR420_2P_CBCR_LE:
			case YCBCR422_2P_CBCR_LE:
			case YCBCR444_2P_CBCR_LE:
				uYCbCr2PlaneOrder = 0x1; // Cb3Cr3Cb2Cr2Cb1Cr1Cb0Cr0
				break;
			case YCBCR420_2P_CRCB_BE:
			case YCBCR422_2P_CRCB_BE:
			case YCBCR444_2P_CRCB_BE:
				uYCbCr2PlaneOrder = 0x2; // Cr0Cb0Cr1Cb1Cb2Cr2Cb3Cr3
				break;
			case YCBCR420_2P_CBCR_BE:
			case YCBCR422_2P_CBCR_BE:
			case YCBCR444_2P_CBCR_BE:
				uYCbCr2PlaneOrder = 0x3; // Cb0Cr0Cb1Cr1Cb2Cr2Cb3Cr3
				break;
			default:
				Assert(0);
				break;
		}
		
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL & (~(0x3<<16));
		uMSCTRL = uMSCTRL |(uYCbCr2PlaneOrder<<16);
		uMSCTRL = uMSCTRL |(0x1<<15); // YCbCr 4:2:0/4:2:2/4:4:4 2 plane input format
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);
	}
	// 3 plane input DMA format
	else if((eInImgFmt==YC420)||(eInImgFmt==YC422)||(eInImgFmt==YC444))
	{
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL & (~(0x1<<15)); // YCbCr 4:2:0/4:2:2/4:4:4 3 plane input format	
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);		
	}
	// 1 plane input DMA format
	else if((eInImgFmt==YCBYCR)||(eInImgFmt==YCRYCB)||(eInImgFmt==CRYCBY)||(eInImgFmt==CBYCRY))
	{
		switch(eInImgFmt)
		{
			case YCBYCR:
				uYCbCr1PlaneOrder = 0x0;
				break;
			case CBYCRY:
				uYCbCr1PlaneOrder = 0x1;
				break;
			case YCRYCB:
				uYCbCr1PlaneOrder = 0x2;
				break;
			case CRYCBY:
				uYCbCr1PlaneOrder = 0x3;
				break;
			default:
				Assert(0);
				break;
		}
				
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL & (~(0x3<<4));
		uMSCTRL = uMSCTRL |(uYCbCr1PlaneOrder<<4);
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);
	}
	// RGB input DMA format
	else if((eInImgFmt == RGB16)||(eInImgFmt == RGB18)||(eInImgFmt == RGB24))
	{
		switch(eInImgFmt)
		{
			case RGB16:
				uRgbFormat = 0x0; // RGB565 (Input DMA RGB format)
				break;
			case RGB18:
				uRgbFormat = 0x1; // RGB666 (Input DMA RGB format)
				break;				
			case RGB24:
				uRgbFormat = 0x2; // RGB888 (Input DMA RGB format)
				break;
			default:
				Assert(0);
				break;				
		}
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x3<<13));			
		uCISCCTRL = uCISCCTRL |(uRgbFormat<<13); 
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
	}
	else
	{
		Assert(0);
	}	

	// =====

	fimcInp32(eCh, rCIDMAPARAM, uCIDMAPARAM);
	uCIDMAPARAM = uCIDMAPARAM & (~(0x3<<29));
	
	if(eInImgFmt==TILE_NV12)
	{
		uInAddrAccess = 0x3;
	}
	else
	{
		uInAddrAccess = 0x0;
	}

	uCIDMAPARAM = uCIDMAPARAM |(uInAddrAccess<<29);
	fimcOutp32(eCh, rCIDMAPARAM, uCIDMAPARAM);
}

// [Set DMA input FIFO control]
static void FIMC_SetDinFifoCtrl(FIMC_CH eCh, u8 bFifoCtrl)
{
	u32 uMSCTRL;

	fimcInp32(eCh, rMSCTRL, uMSCTRL);
	switch(bFifoCtrl)
	{
		case false:
			uMSCTRL = uMSCTRL & (~(0x1<<12));
			break;
		case true:
			uMSCTRL = uMSCTRL |(0x1<<12);
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rMSCTRL, uMSCTRL);
}

// [Set DMA-in image size]
static void FIMC_SetDinImgSize(FIMC_CH eCh,
	u32 uInImgHsz, u32 uInImgVsz, IMG_FMT eInImgFmt, u32 uInImgLineSkip)
{
	u32 uORGISIZE;
	u32 uCIILINESKIP_Y;
	u32 uCIILINESKIP_CB;
	u32 uCIILINESKIP_CR;
		
	//Assert(uInImgHsz%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p48
	Assert(uInImgHsz%16==0); // p48	
	Assert(uInImgVsz>=8); // p48
	
	fimcInp32(eCh, rORGISIZE, uORGISIZE);
	uORGISIZE = uORGISIZE & (~(0x3fff<<16));
	uORGISIZE = uORGISIZE |(uInImgVsz<<16);
	uORGISIZE = uORGISIZE & (~(0x3fff<<0));
	uORGISIZE = uORGISIZE |(uInImgHsz<<0);
	fimcOutp32(eCh, rORGISIZE, uORGISIZE);

	Assert((0<=uInImgLineSkip)&&(uInImgLineSkip<=15));
	switch(eInImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			fimcInp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);
			uCIILINESKIP_Y = uCIILINESKIP_Y & (~(0xf<<24));
			uCIILINESKIP_Y = uCIILINESKIP_Y |(uInImgLineSkip<<24);
			fimcOutp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);
			break;
		// 2 plane
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case TILE_NV12:
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			fimcInp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);
			uCIILINESKIP_Y = uCIILINESKIP_Y & (~(0xf<<24));
			uCIILINESKIP_Y = uCIILINESKIP_Y |(uInImgLineSkip<<24);
			fimcOutp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);

			fimcInp32(eCh, rCIILINESKIP_CB, uCIILINESKIP_CB);
			uCIILINESKIP_CB = uCIILINESKIP_CB & (~(0xf<<24));
			uCIILINESKIP_CB = uCIILINESKIP_CB |(uInImgLineSkip<<24);			
			fimcOutp32(eCh, rCIILINESKIP_CB, uCIILINESKIP_CB);
			break;
		// 3 plane
		case YC420:
		case YC422:	
		case YC444:			
			fimcInp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);
			uCIILINESKIP_Y = uCIILINESKIP_Y & (~(0xf<<24));
			uCIILINESKIP_Y = uCIILINESKIP_Y |(uInImgLineSkip<<24);
			fimcOutp32(eCh, rCIILINESKIP_Y, uCIILINESKIP_Y);

			fimcInp32(eCh, rCIILINESKIP_CB, uCIILINESKIP_CB);
			uCIILINESKIP_CB = uCIILINESKIP_CB & (~(0xf<<24));
			uCIILINESKIP_CB = uCIILINESKIP_CB |(uInImgLineSkip<<24);
			fimcOutp32(eCh, rCIILINESKIP_CB, uCIILINESKIP_CB);

			fimcInp32(eCh, rCIILINESKIP_CR, uCIILINESKIP_CR);
			uCIILINESKIP_CR = uCIILINESKIP_CR & (~(0xf<<24));
			uCIILINESKIP_CR = uCIILINESKIP_CR |(uInImgLineSkip<<24);			
			fimcOutp32(eCh, rCIILINESKIP_CR, uCIILINESKIP_CR);
			break;
		default:
			Assert(0);
			break;
	}
	
}

// [Set DMA-in image cropping offset]
static void FIMC_SetDinImgCroppingOffset(FIMC_CH eCh,
	IMG_FMT eInImgFmt, u32 uInImgCropStartX, u32 uInImgCropStartY)
{	
	u32 IYOFF_H, IYOFF_V;
	u32 ICBOFF_H, ICBOFF_V;
	u32 ICROFF_H, ICROFF_V;

	// If you need to know below 'Assert', refer to manual last page
	switch(eInImgFmt)
	{
		case RGB24:
		case RGB18:
			IYOFF_H = uInImgCropStartX*4;
			IYOFF_V = uInImgCropStartY;
			Assert(IYOFF_H%8 == 0);
			break;
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			IYOFF_H = uInImgCropStartX*2;
			IYOFF_V = uInImgCropStartY;
			Assert(IYOFF_H%8 == 0);
			break;
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:			
		case TILE_NV12:
			Assert(uInImgCropStartY%2 == 0);
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX;
			ICBOFF_V = uInImgCropStartY/2;
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);
			break;
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX;
			ICBOFF_V = uInImgCropStartY;
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);			
			break;
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX*2;
			ICBOFF_V = uInImgCropStartY;
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);			
			break;			
		case YC420:
			Assert(uInImgCropStartX%2 == 0);
			Assert(uInImgCropStartY%2 == 0);
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX/2;
			ICBOFF_V = uInImgCropStartY/2;
			ICROFF_H = uInImgCropStartX/2;
			ICROFF_V = uInImgCropStartY/2;
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);
			Assert(ICROFF_H%8 == 0);
			break;
		case YC422:
			Assert(uInImgCropStartX%2 == 0);			
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX/2;
			ICBOFF_V = uInImgCropStartY;
			ICROFF_H = uInImgCropStartX/2;
			ICROFF_V = uInImgCropStartY;	
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);
			Assert(ICROFF_H%8 == 0);			
			break;	
		case YC444:
			IYOFF_H = uInImgCropStartX;
			IYOFF_V = uInImgCropStartY;
			ICBOFF_H = uInImgCropStartX;
			ICBOFF_V = uInImgCropStartY;
			ICROFF_H = uInImgCropStartX;
			ICROFF_V = uInImgCropStartY;		
			Assert(IYOFF_H%8 == 0);
			Assert(ICBOFF_H%8 == 0);
			Assert(ICROFF_H%8 == 0);			
			break;
		default:
			Assert(0);
			break;
	}

	fimcOutp32(eCh, rCIIYOFF, (IYOFF_V<<16)|(IYOFF_H<<0));
	fimcOutp32(eCh, rCIICBOFF, (ICBOFF_V<<16)|(ICBOFF_H<<0));
	fimcOutp32(eCh, rCIICROFF, (ICROFF_V<<16)|(ICROFF_H<<0));	
}

// [Set DMA-in image cropping size]
static void FIMC_SetDinImgCroppingSize(FIMC_CH eCh, u32 uInImgCropHsz, u32 uInImgCropVsz)
{
	u32 uCIREAL_ISIZE;
	
	fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
	uCIREAL_ISIZE = uCIREAL_ISIZE & (~(0x3fff<<16));
	uCIREAL_ISIZE = uCIREAL_ISIZE |(uInImgCropVsz<<16);
	uCIREAL_ISIZE = uCIREAL_ISIZE & (~(0x3fff<<0));
	uCIREAL_ISIZE = uCIREAL_ISIZE |(uInImgCropHsz<<0);
	fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
}

// [Set DMA-in image scaler]
static void FIMC_SetDinImgScaler(FIMC_CH eCh,
	IMG_FMT eInImgFmt, u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz)
{
	u32 uCISCPRERATIO;
	u32 uCISCPREDST;
	u32 uCISCCTRL;
	
	u32 uHScaleFlag;
	u32 uVScaleFlag;
	u32 uPreHRatio, uHShift;
	u32 uPreVRatio, uVShift;
	u32 uShiftFactor;
	u32 uPreDstHSz;
	u32 uPreDstVSz;
	u32 uMainHRatio;
	u32 uMainVRatio;

	if(uInImgCropHsz <= uOutImgHsz)
	{
		uHScaleFlag = 0x1; // Horizontal scale UP
	}
	else
	{
		uHScaleFlag = 0x0; // Horizontal scale DOWN
	}
	
	if(uInImgCropVsz <= uOutImgVsz)
	{
		uVScaleFlag = 0x1; // Vertical scale UP
	}
	else
	{
		uVScaleFlag = 0x0; // Vertical scale DOWN
	}

	FIMC_GetPreRatioAndShift(uInImgCropHsz, uOutImgHsz, &uPreHRatio, &uHShift);
	//Assert((uInImgCropHsz%8 == 0)&&(uInImgCropHsz >= 16)); // p41
	Assert((uInImgCropHsz%16 == 0)&&(uInImgCropHsz >= 16)); // p41
	Assert(uInImgCropHsz%(4*uPreHRatio) == 0); // p41
		
	FIMC_GetPreRatioAndShift(uInImgCropVsz, uOutImgVsz, &uPreVRatio, &uVShift);
	Assert(uInImgCropVsz >= 8); // p41
	switch(eInImgFmt)
	{
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case YC420:
		case TILE_NV12:
			Assert(uInImgCropVsz%(2*uPreVRatio) == 0); // p41
			break;
		default:
			Assert(uInImgCropVsz%uPreVRatio == 0); // p41
			break;
	}	

	uShiftFactor = 10 - (uHShift + uVShift);

	uPreDstHSz = uInImgCropHsz/uPreHRatio;

	switch(eCh)
	{
		case FIMC_A:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_A); // p8
			break;
		case FIMC_B:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_B); // p8
			break;
		case FIMC_C:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_C); // p8
			break;
		default:
			Assert(0);
			break;
	}	

	uPreDstVSz = uInImgCropVsz/uPreVRatio;
	
	uMainHRatio = (uInImgCropHsz<<8)/(uOutImgHsz<<uHShift);
	uMainVRatio = (uInImgCropVsz<<8)/(uOutImgVsz<<uVShift);

	fimcInp32(eCh, rCISCPRERATIO, uCISCPRERATIO);
	uCISCPRERATIO = uCISCPRERATIO & (~(0xf<<28));
	uCISCPRERATIO = uCISCPRERATIO |(uShiftFactor<<28);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<16));
	uCISCPRERATIO = uCISCPRERATIO |(uPreHRatio<<16);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<0));
	uCISCPRERATIO = uCISCPRERATIO |(uPreVRatio<<0);
	fimcOutp32(eCh, rCISCPRERATIO, uCISCPRERATIO);

	fimcInp32(eCh, rCISCPREDST, uCISCPREDST);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<16));
	uCISCPREDST = uCISCPREDST |(uPreDstHSz<<16);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<0));
	uCISCPREDST = uCISCPREDST |(uPreDstVSz<<0);
	fimcOutp32(eCh, rCISCPREDST, uCISCPREDST);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL & (~(0x1<<30));
	uCISCCTRL = uCISCCTRL |(uHScaleFlag<<30);
	uCISCCTRL = uCISCCTRL & (~(0x1<<29));
	uCISCCTRL = uCISCCTRL |(uVScaleFlag<<29);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<16));
	uCISCCTRL = uCISCCTRL |(uMainHRatio<<16);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<0));
	uCISCCTRL = uCISCCTRL |(uMainVRatio<<0);	
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);	
}

// [Set DMA-in mode]
static void FIMC_SetDinMode(FIMC_CH eCh, DMA_IN_MODE eDmaInMode)
{
	u32 uMSCTRL;

	fimcInp32(eCh, rMSCTRL, uMSCTRL);
	switch(eDmaInMode)
	{
		case PROGRESSIVE_IN_DMA:
			uMSCTRL = uMSCTRL & (~(0x1<<31));
			break;
		case INTERLACE_IN_WEAVING:
			uMSCTRL = uMSCTRL |(0x1<<31);
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rMSCTRL, uMSCTRL);
}

// [Set DMA-in ENVID]
void FIMC_SetDinEnvid(FIMC_CH eCh, u8 bEnable)
{
	u32 uMSCTRL;

	fimcInp32(eCh, rMSCTRL, uMSCTRL);
	switch(bEnable)
	{
		case false:
			uMSCTRL = uMSCTRL & (~(0x1<<0));
			break;
		case true:
			uMSCTRL = uMSCTRL |(0x1<<0);
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rMSCTRL, uMSCTRL);
}

// [Set DMA-out display address]
static void FIMC_SetDoutDispAddr(FIMC_CH eCh, 
	u32 uOutImgAddr1, u32 uOutImgAddr2, u32 uOutImgAddr3, u32 uOutImgAddr4, 
	IMG_FMT eOutImgFmt, u32 uOutDispHsz, u32 uOutDispVsz)
{
	u32 uYSize, uCbSize, uCrSize;
	
	Assert(uOutImgAddr1%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35
	Assert(uOutImgAddr2%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35
	Assert(uOutImgAddr3%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35
	Assert(uOutImgAddr4%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35
	
	FIMC_GetYCbCrSize(eOutImgFmt, uOutDispHsz, uOutDispVsz, &uYSize, &uCbSize, &uCrSize);

	switch(eOutImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
		case RGB16:
		case BayerRGB8:
		case BayerRGB10:
		case BayerRGB12:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			fimcOutp32(eCh, rCIOYSA1, uOutImgAddr1);
			fimcOutp32(eCh, rCIOYSA2, uOutImgAddr2);
			fimcOutp32(eCh, rCIOYSA3, uOutImgAddr3);
			fimcOutp32(eCh, rCIOYSA4, uOutImgAddr4);
			break;
		// 2 plane
		case TILE_NV12:			
			// AIF v3.0 has a restriction when processing TILE_NV12
			Assert(uOutImgAddr1%0x1000==0);
			Assert(uOutImgAddr2%0x1000==0);
			Assert(uOutImgAddr3%0x1000==0);
			Assert(uOutImgAddr4%0x1000==0);
			Assert((uOutImgAddr1+uYSize)%0x1000==0);
			Assert((uOutImgAddr2+uYSize)%0x1000==0);
			Assert((uOutImgAddr3+uYSize)%0x1000==0);
			Assert((uOutImgAddr4+uYSize)%0x1000==0);			
			fimcOutp32(eCh, rCIOYSA1, uOutImgAddr1);
			fimcOutp32(eCh, rCIOYSA2, uOutImgAddr2);
			fimcOutp32(eCh, rCIOYSA3, uOutImgAddr3);
			fimcOutp32(eCh, rCIOYSA4, uOutImgAddr4);
			fimcOutp32(eCh, rCIOCBSA1, uOutImgAddr1 + uYSize);
			fimcOutp32(eCh, rCIOCBSA2, uOutImgAddr2 + uYSize);
			fimcOutp32(eCh, rCIOCBSA3, uOutImgAddr3 + uYSize);
			fimcOutp32(eCh, rCIOCBSA4, uOutImgAddr4 + uYSize);			
			break;
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			fimcOutp32(eCh, rCIOYSA1, uOutImgAddr1);
			fimcOutp32(eCh, rCIOYSA2, uOutImgAddr2);
			fimcOutp32(eCh, rCIOYSA3, uOutImgAddr3);
			fimcOutp32(eCh, rCIOYSA4, uOutImgAddr4);
			fimcOutp32(eCh, rCIOCBSA1, uOutImgAddr1 + uYSize);
			fimcOutp32(eCh, rCIOCBSA2, uOutImgAddr2 + uYSize);
			fimcOutp32(eCh, rCIOCBSA3, uOutImgAddr3 + uYSize);
			fimcOutp32(eCh, rCIOCBSA4, uOutImgAddr4 + uYSize);			
			break;
		// 3 plane
		case YC420:
		case YC422:		
		case YC444:			
			fimcOutp32(eCh, rCIOYSA1, uOutImgAddr1);
			fimcOutp32(eCh, rCIOYSA2, uOutImgAddr2);
			fimcOutp32(eCh, rCIOYSA3, uOutImgAddr3);
			fimcOutp32(eCh, rCIOYSA4, uOutImgAddr4);
			fimcOutp32(eCh, rCIOCBSA1, uOutImgAddr1 + uYSize);
			fimcOutp32(eCh, rCIOCBSA2, uOutImgAddr2 + uYSize);
			fimcOutp32(eCh, rCIOCBSA3, uOutImgAddr3 + uYSize);
			fimcOutp32(eCh, rCIOCBSA4, uOutImgAddr4 + uYSize);
			fimcOutp32(eCh, rCIOCRSA1, uOutImgAddr1 + uYSize + uCbSize);
			fimcOutp32(eCh, rCIOCRSA2, uOutImgAddr2 + uYSize + uCbSize);
			fimcOutp32(eCh, rCIOCRSA3, uOutImgAddr3 + uYSize + uCbSize);
			fimcOutp32(eCh, rCIOCRSA4, uOutImgAddr4 + uYSize + uCbSize);			
			break;
		default:
			Assert(0);
			break;
	}
}

// [Set DMA-out display address for MFC]
void FIMC_SetDoutDispAddrForMfc(FIMC_CH eCh, IMG_FMT eOutImgFmt,
	u32 uOutImgAddr1OfY, u32 uOutImgAddr2OfY, u32 uOutImgAddr3OfY, u32 uOutImgAddr4OfY, 
	u32 uOutImgAddr1OfCb, u32 uOutImgAddr2OfCb, u32 uOutImgAddr3OfCb, u32 uOutImgAddr4OfCb)
{
	switch(eOutImgFmt)
	{
		case NV12:			
			// Should be aligned with DWORD(64 bits=8 bytes), p35
			Assert(uOutImgAddr1OfY%8==0); 
			Assert(uOutImgAddr2OfY%8==0);
			Assert(uOutImgAddr3OfY%8==0);
			Assert(uOutImgAddr4OfY%8==0);

			Assert(uOutImgAddr1OfCb%8==0);
			Assert(uOutImgAddr2OfCb%8==0);
			Assert(uOutImgAddr3OfCb%8==0);
			Assert(uOutImgAddr4OfCb%8==0);
			break;
		case TILE_NV12:
			// AIF v3.0 has a restriction when processing TILE_NV12
			Assert(uOutImgAddr1OfY%0x1000==0); 
			Assert(uOutImgAddr2OfY%0x1000==0);
			Assert(uOutImgAddr3OfY%0x1000==0);
			Assert(uOutImgAddr4OfY%0x1000==0);
	
			Assert(uOutImgAddr1OfCb%0x1000==0);
			Assert(uOutImgAddr2OfCb%0x1000==0);
			Assert(uOutImgAddr3OfCb%0x1000==0);
			Assert(uOutImgAddr4OfCb%0x1000==0);			
			break;
		default:
			Assert(0);
			break;
	}
	
	fimcOutp32(eCh, rCIOYSA1, uOutImgAddr1OfY);
	fimcOutp32(eCh, rCIOYSA2, uOutImgAddr2OfY);
	fimcOutp32(eCh, rCIOYSA3, uOutImgAddr3OfY);
	fimcOutp32(eCh, rCIOYSA4, uOutImgAddr4OfY);
	
	fimcOutp32(eCh, rCIOCBSA1, uOutImgAddr1OfCb);
	fimcOutp32(eCh, rCIOCBSA2, uOutImgAddr2OfCb);
	fimcOutp32(eCh, rCIOCBSA3, uOutImgAddr3OfCb);
	fimcOutp32(eCh, rCIOCBSA4, uOutImgAddr4OfCb);			
}

/*
// [Set DMA-out address for weaving]
static void FIMC_SetDoutAddrForWeaving(FIMC_CH eCh, 
	u32 uOutImgAddr, IMG_FMT eOutImgFmt, u32 uOutImgHsz, u32 uOutImgVsz)
{
	u32 YTopAddr, YBtmAddr;
	u32 CbTopAddr, CbBtmAddr;
	u32 CrTopAddr, CrBtmAddr;

	Assert(uOutImgAddr%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p35

	switch(eOutImgFmt)
	{
		// 1 plane
		case RGB24:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+(uOutImgHsz*4);
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);
			break;
		// 1 plane
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+(uOutImgHsz*2);
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);
			break;
		// 2 plane
		case NV12:
		case NV16:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+uOutImgHsz;
			CbTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz);
			CbBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+uOutImgHsz;
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);			
			fimcOutp32(eCh, rCIOCBSA1, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA2, CbBtmAddr);
			fimcOutp32(eCh, rCIOCBSA3, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA4, CbBtmAddr);			
			break;
		// 2 plane
		case NV24:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+uOutImgHsz;
			CbTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz);
			CbBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+(uOutImgHsz*2);
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);			
			fimcOutp32(eCh, rCIOCBSA1, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA2, CbBtmAddr);
			fimcOutp32(eCh, rCIOCBSA3, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA4, CbBtmAddr);			
			break;
		// 3 plane
		case YC420:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+uOutImgHsz;
			CbTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz);
			CbBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+(uOutImgHsz/2);
			CrTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+((uOutImgHsz/2)*(uOutImgVsz/2));
			CrBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+((uOutImgHsz/2)*(uOutImgVsz/2))+(uOutImgHsz/2);
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);
			fimcOutp32(eCh, rCIOCBSA1, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA2, CbBtmAddr);
			fimcOutp32(eCh, rCIOCBSA3, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA4, CbBtmAddr);
			fimcOutp32(eCh, rCIOCRSA1, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA2, CrBtmAddr);
			fimcOutp32(eCh, rCIOCRSA3, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA4, CrBtmAddr);			
			break;
		// 3 plane
		case YC422:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+uOutImgHsz;
			CbTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz);
			CbBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+(uOutImgHsz/2);
			CrTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+((uOutImgHsz/2)*uOutImgVsz);
			CrBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+((uOutImgHsz/2)*uOutImgVsz)+(uOutImgHsz/2);
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);
			fimcOutp32(eCh, rCIOCBSA1, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA2, CbBtmAddr);
			fimcOutp32(eCh, rCIOCBSA3, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA4, CbBtmAddr);
			fimcOutp32(eCh, rCIOCRSA1, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA2, CrBtmAddr);
			fimcOutp32(eCh, rCIOCRSA3, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA4, CrBtmAddr);					
			break;
		// 3 plane
		case YC444:
			YTopAddr=uOutImgAddr;
			YBtmAddr=uOutImgAddr+uOutImgHsz;
			CbTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz);
			CbBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+uOutImgHsz;
			CrTopAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+(uOutImgHsz*uOutImgVsz);
			CrBtmAddr=uOutImgAddr+(uOutImgHsz*uOutImgVsz)+(uOutImgHsz*uOutImgVsz)+uOutImgHsz;
			fimcOutp32(eCh, rCIOYSA1, YTopAddr);
			fimcOutp32(eCh, rCIOYSA2, YBtmAddr);
			fimcOutp32(eCh, rCIOYSA3, YTopAddr);
			fimcOutp32(eCh, rCIOYSA4, YBtmAddr);
			fimcOutp32(eCh, rCIOCBSA1, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA2, CbBtmAddr);
			fimcOutp32(eCh, rCIOCBSA3, CbTopAddr);
			fimcOutp32(eCh, rCIOCBSA4, CbBtmAddr);
			fimcOutp32(eCh, rCIOCRSA1, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA2, CrBtmAddr);
			fimcOutp32(eCh, rCIOCRSA3, CrTopAddr);
			fimcOutp32(eCh, rCIOCRSA4, CrBtmAddr);				
			break;
		default:
			Assert(0);
			break;
	}	
}
*/

// [Set DMA-out image format]
static void FIMC_SetDoutImgFmt(FIMC_CH eCh, IMG_FMT eOutImgFmt)
{
	u32 uCIEXTEN;
	u32 uCITRGFMT;
	u32 uCIOCTRL;
	u32 uCISCCTRL;
	u32 uCIDMAPARAM;
		
	u32 uOutputImgFmt;
	u32 uYCbCr2PlaneOrder;
	u32 uYCbCr1PlaneOrder;
	u32 uRgbFormat;
	u32 uInAddrAccess;

	Assert((eOutImgFmt==RGB16)||(eOutImgFmt==RGB18)||(eOutImgFmt==RGB24) // RGB
		// YCbCr 420
		||(eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
		||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
		||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
		||(eOutImgFmt==YCBCR420_2P_CBCR_BE)		
		||(eOutImgFmt==TILE_NV12)
		||(eOutImgFmt==YC420)
		// YCbCr 422
		||(eOutImgFmt==YCBYCR)||(eOutImgFmt==YCRYCB)||(eOutImgFmt==CRYCBY)||(eOutImgFmt==CBYCRY)
		||(eOutImgFmt==NV16) // YCBCR422_2P_CRCB_LE
		||(eOutImgFmt==YCBCR422_2P_CBCR_LE)
		||(eOutImgFmt==YCBCR422_2P_CRCB_BE)
		||(eOutImgFmt==YCBCR422_2P_CBCR_BE)		
		||(eOutImgFmt==YC422)
		// YCbCr 444
		||(eOutImgFmt==NV24) // YCBCR444_2P_CRCB_LE
		||(eOutImgFmt==YCBCR444_2P_CBCR_LE)
		||(eOutImgFmt==YCBCR444_2P_CRCB_BE)
		||(eOutImgFmt==YCBCR444_2P_CBCR_BE)		
		||(eOutImgFmt==YC444) 
		// BayerRGB
		||(eOutImgFmt==BayerRGB8)||(eOutImgFmt==BayerRGB10)||(eOutImgFmt==BayerRGB12)); 

	// YCbCr 4:4:4 (2 or 3 plane output image DMA format)
	if((eOutImgFmt==NV24) // YCBCR444_2P_CRCB_LE
	||(eOutImgFmt==YCBCR444_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR444_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR444_2P_CBCR_BE)
	||(eOutImgFmt==YC444)) 
	{
		fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
		uCIEXTEN = uCIEXTEN |(0x1<<22); // YCbCr444_OUT (Priority is higher than OutFormat)
		fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);
	}
	// BayerRGB
	else if((eOutImgFmt==BayerRGB8)||(eOutImgFmt==BayerRGB10)||(eOutImgFmt==BayerRGB12))
	{
		// Refer to the 'FIMC_SetMipiImgFmtAndDataAlign()'
	}
	else
	{
		fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
		uCIEXTEN = uCIEXTEN & (~(0x1<<22)); // YCbCr444_OUT (Priority is higher than OutFormat)
		fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);
		
		switch(eOutImgFmt)
		{
			case NV12: // YCBCR420_2P_CRCB_LE
			case YCBCR420_2P_CBCR_LE:
			case YCBCR420_2P_CRCB_BE:
			case YCBCR420_2P_CBCR_BE:			
			case TILE_NV12:
			case YC420:
				uOutputImgFmt = 0x0; // YCbCr 4:2:0 (2 or 3 plane output image DMA format)
				break;
			case NV16: // YCBCR422_2P_CRCB_LE
			case YCBCR422_2P_CBCR_LE:
			case YCBCR422_2P_CRCB_BE:
			case YCBCR422_2P_CBCR_BE:			
			case YC422:
				uOutputImgFmt = 0x1; // YCbCr 4:2:2 (2 or 3 plane output image DMA format)
				break;
			case YCBYCR:
			case YCRYCB:
			case CRYCBY:
			case CBYCRY:
				uOutputImgFmt = 0x2; // YCbCr 4:2:2 (1 plane output image DMA format)
				break;
			case RGB16:
			case RGB18:
			case RGB24:
				uOutputImgFmt = 0x3; // RGB output image DMA format
				break;
			default:
				Assert(0);
				break;			
		}
		fimcInp32(eCh, rCITRGFMT, uCITRGFMT);
		uCITRGFMT = uCITRGFMT & (~(0x3<<29));
		uCITRGFMT = uCITRGFMT |(uOutputImgFmt<<29);
		fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);
	}

	// 2 plane output DMA format
	if((eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR420_2P_CBCR_BE)	
	||(eOutImgFmt==TILE_NV12)
	||(eOutImgFmt==NV16) // YCBCR422_2P_CRCB_LE
	||(eOutImgFmt==YCBCR422_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR422_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR422_2P_CBCR_BE)	
	||(eOutImgFmt==NV24) // YCBCR444_2P_CRCB_LE
	||(eOutImgFmt==YCBCR444_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR444_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR444_2P_CBCR_BE))
	{
		switch(eOutImgFmt)
		{
			case NV12: // YCBCR420_2P_CRCB_LE
			case TILE_NV12:
			case NV16: // YCBCR422_2P_CRCB_LE
			case NV24: // YCBCR444_2P_CRCB_LE
				uYCbCr2PlaneOrder = 0x0; // Cr3Cb3Cr2Cb2Cr1Cb1Cr0Cb0
				break;
			case YCBCR420_2P_CBCR_LE:
			case YCBCR422_2P_CBCR_LE:
			case YCBCR444_2P_CBCR_LE:
				uYCbCr2PlaneOrder = 0x1; // Cb3Cr3Cb2Cr2Cb1Cr1Cb0Cr0
				break;
			case YCBCR420_2P_CRCB_BE:
			case YCBCR422_2P_CRCB_BE:
			case YCBCR444_2P_CRCB_BE:
				uYCbCr2PlaneOrder = 0x2; // Cr0Cb0Cr1Cb1Cb2Cr2Cb3Cr3
				break;
			case YCBCR420_2P_CBCR_BE:
			case YCBCR422_2P_CBCR_BE:
			case YCBCR444_2P_CBCR_BE:
				uYCbCr2PlaneOrder = 0x3; // Cb0Cr0Cb1Cr1Cb2Cr2Cb3Cr3
				break;
			default:
				Assert(0);
				break;
		}
		
		fimcInp32(eCh, rCIOCTRL, uCIOCTRL);
		uCIOCTRL = uCIOCTRL & (~(0x3<<24));
		uCIOCTRL = uCIOCTRL |(uYCbCr2PlaneOrder<<24);
		uCIOCTRL = uCIOCTRL |(0x1<<3); // YCbCr 4:2:0/4:2:2/4:4:4 2 plane output format
		fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);
	}
	// 3 plane output DMA format
	else if((eOutImgFmt==YC420)||(eOutImgFmt==YC422)||(eOutImgFmt==YC444))
	{
		fimcInp32(eCh, rCIOCTRL, uCIOCTRL);
		uCIOCTRL = uCIOCTRL & (~(0x1<<3)); // YCbCr 4:2:0/4:2:2/4:4:4 3 plane output format	
		fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);		
	}
	// 1 plane output DMA format
	else if((eOutImgFmt==YCBYCR)||(eOutImgFmt==YCRYCB)||(eOutImgFmt==CRYCBY)||(eOutImgFmt==CBYCRY))
	{
		switch(eOutImgFmt)
		{
			case CRYCBY:
				uYCbCr1PlaneOrder = 0x0;
				break;
			case CBYCRY:
				uYCbCr1PlaneOrder = 0x1;
				break;
			case YCRYCB:
				uYCbCr1PlaneOrder = 0x2;
				break;
			case YCBYCR:
				uYCbCr1PlaneOrder = 0x3;
				break;
			default:
				Assert(0);
				break;
		}
				
		fimcInp32(eCh, rCIOCTRL, uCIOCTRL);
		uCIOCTRL = uCIOCTRL & (~(0x3<<0));
		uCIOCTRL = uCIOCTRL |(uYCbCr1PlaneOrder<<0);
		fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);
	}
	// RGB output DMA format
	else if((eOutImgFmt == RGB16)||(eOutImgFmt == RGB18)||(eOutImgFmt == RGB24))
	{
		switch(eOutImgFmt)
		{
			case RGB16:
				uRgbFormat = 0x0; // RGB565 (Output DMA RGB format)
				break;
			case RGB18:
				uRgbFormat = 0x1; // RGB666 (Input DMA RGB format)
				break;					
			case RGB24:
				uRgbFormat = 0x2; // RGB888 (Output DMA RGB format)
				break;
			default:
				Assert(0);
				break;				
		}
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x3<<11));			
		uCISCCTRL = uCISCCTRL |(uRgbFormat<<11); 
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);				
	}
	// BayerRGB output DMA format
	else if((eOutImgFmt==BayerRGB8)||(eOutImgFmt==BayerRGB10)||(eOutImgFmt==BayerRGB12))
	{
		// Refer to the 'FIMC_SetMipiImgFmtAndDataAlign()'
	}	
	else
	{
		Assert(0);
	}		

	// =====

	fimcInp32(eCh, rCIDMAPARAM, uCIDMAPARAM);
	uCIDMAPARAM = uCIDMAPARAM & (~(0x3<<13));
	
	if(eOutImgFmt==TILE_NV12)
	{
		uInAddrAccess = 0x3;
	}
	else
	{
		uInAddrAccess = 0x0;
	}
	
	uCIDMAPARAM = uCIDMAPARAM |(uInAddrAccess<<13);
	fimcOutp32(eCh, rCIDMAPARAM, uCIDMAPARAM);
}

// [Set DMA-out display size]
static void FIMC_SetDoutDispSize(FIMC_CH eCh, u32 uOutDispHsz, u32 uOutDispVsz)
{
	u32 uORGOSIZE;
		
	//Assert(uOutDispHsz%8==0); // Should be aligned with DWORD(64 bits=8 bytes), p48
	Assert(uOutDispHsz%16==0); // p48
	Assert(uOutDispVsz>=8); // p48
	
	fimcInp32(eCh, rORGOSIZE, uORGOSIZE);
	uORGOSIZE = uORGOSIZE & (~(0x3fff<<16));
	uORGOSIZE = uORGOSIZE |(uOutDispVsz<<16);
	uORGOSIZE = uORGOSIZE & (~(0x3fff<<0));
	uORGOSIZE = uORGOSIZE |(uOutDispHsz<<0);
	fimcOutp32(eCh, rORGOSIZE, uORGOSIZE);
}

// [Set DMA-out image offset]
void FIMC_SetDoutImgOffset(FIMC_CH eCh, 
	IMG_FMT eOutImgFmt, u32 uOutImgStartX, u32 uOutImgStartY)
{
	u32 OYOFF_H, OYOFF_V;
	u32 OCBOFF_H, OCBOFF_V;
	u32 OCROFF_H, OCROFF_V;

	// If you need to know below 'Assert', refer to manual last page	
	switch(eOutImgFmt)
	{
		case RGB24:
		case RGB18:
			OYOFF_H = uOutImgStartX*4;
			OYOFF_V = uOutImgStartY;
			Assert(OYOFF_H%8 == 0);
			break;
		case BayerRGB8:
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;		
			Assert(OYOFF_H%8 == 0);			
			break;
		case BayerRGB10:
			OYOFF_H = (uOutImgStartX*5)/4;
			OYOFF_V = uOutImgStartY;			
			Assert(OYOFF_H%8 == 0);			
			break;
		case BayerRGB12:
			OYOFF_H = (uOutImgStartX*3)/2;
			OYOFF_V = uOutImgStartY;			
			Assert(OYOFF_H%8 == 0);			
			break;			
		case RGB16:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			OYOFF_H = uOutImgStartX*2;
			OYOFF_V = uOutImgStartY;	
			Assert(OYOFF_H%8 == 0);			
			break;
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case TILE_NV12:
			Assert(uOutImgStartY%2 == 0);
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX;
			OCBOFF_V = uOutImgStartY/2;
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);			
			break;
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX;
			OCBOFF_V = uOutImgStartY;
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);			
			break;
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:		
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX*2;
			OCBOFF_V = uOutImgStartY;
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);			
			break;			
		case YC420:
			Assert(uOutImgStartX%2 == 0);
			Assert(uOutImgStartY%2 == 0);
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX/2;
			OCBOFF_V = uOutImgStartY/2;
			OCROFF_H = uOutImgStartX/2;
			OCROFF_V = uOutImgStartY/2;	
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);
			Assert(OCROFF_H%8 == 0);
			break;
		case YC422:
			Assert(uOutImgStartX%2 == 0);
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX/2;
			OCBOFF_V = uOutImgStartY;
			OCROFF_H = uOutImgStartX/2;
			OCROFF_V = uOutImgStartY;	
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);
			Assert(OCROFF_H%8 == 0);			
			break;	
		case YC444:
			OYOFF_H = uOutImgStartX;
			OYOFF_V = uOutImgStartY;
			OCBOFF_H = uOutImgStartX;
			OCBOFF_V = uOutImgStartY;
			OCROFF_H = uOutImgStartX;
			OCROFF_V = uOutImgStartY;
			Assert(OYOFF_H%8 == 0);
			Assert(OCBOFF_H%8 == 0);
			Assert(OCROFF_H%8 == 0);			
			break;
		default:
			Assert(0);
			break;
	}

	fimcOutp32(eCh, rCIOYOFF, (OYOFF_V<<16)|(OYOFF_H<<0));
	fimcOutp32(eCh, rCIOCBOFF, (OCBOFF_V<<16)|(OCBOFF_H<<0));
	fimcOutp32(eCh, rCIOCROFF, (OCROFF_V<<16)|(OCROFF_H<<0));	
}

// [Get DMA-out frame count]
//'uFrmCnt' is the next frame number (Frame number iteration: 0->1->2->3)
void FIMC_GetDoutFrmCnt(FIMC_CH eCh, u32* uFrmCnt) 
{
	u32 uCISTATUS;
	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & 0x0c000000; // [27:26] FrameCnt
	*uFrmCnt = uCISTATUS>>26;	
}

static void FIMC_SetDoutWeave(FIMC_CH eCh, u8 bEnable)
{
	u32 uCIOCTRL;
	
	fimcInp32(eCh, rCIOCTRL, uCIOCTRL);	
	switch(bEnable)
	{
		case false:
			uCIOCTRL = uCIOCTRL & (~(0x1<<31)); // Normal
			break;
		case true:
			uCIOCTRL = uCIOCTRL |(0x1<<31); // Weave
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);	
}

void FIMC_SetDoutQos(FIMC_CH eCh, u32 uWriteBufThVal)
{
	u32 uCITHOLD;

	fimcInp32(eCh, rCITHOLD, uCITHOLD);
	
	uCITHOLD = uCITHOLD & (~(0x1<<31)); // Write channel buffer Qos mask

	Assert((0x0<=uWriteBufThVal)&&(uWriteBufThVal<=0x7f));
	uCITHOLD = uCITHOLD & (~(0x7f<<0));
	uCITHOLD = uCITHOLD |(uWriteBufThVal<<0); // Write buffer threshold
	
	fimcOutp32(eCh, rCITHOLD, uCITHOLD);
}

void	FIMC_GetLcdcEnstatus(FIMC_CH eCh, u8 *bEnable)
{
	u32 uCISTATUS;
	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & 0x200; // [9] LCD_ENSTATUS
	switch(uCISTATUS)
	{
		case 0x0:
			*bEnable = false;
			break;
		case 0x200:
			*bEnable = true;
			break;
		default:
			Assert(0);
			break;
	}	
}

void	FIMC_GetEnvidStatus(FIMC_CH eCh, u8 *bEnable)
{
	u32 uCISTATUS;
	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & 0x100; // [8] ENVID_STATUS
	switch(uCISTATUS)
	{
		case 0x0:
			*bEnable = false;
			break;
		case 0x100:
			*bEnable = true;
			break;
		default:
			Assert(0);
			break;
	}	
}

// [Set DMA-in DMA-out one to one]
static void FIMC_SetDinDoutOne2One(FIMC_CH eCh, 
	u32 uInImgCropHsz, u32 uInImgCropVsz, IMG_FMT eInImgFmt,
		u32 uOutImgHsz, u32 uOutImgVsz, IMG_FMT eOutImgFmt, u8 bOne2One)
{
	u32 uCISCCTRL;
	
	if(bOne2One == true)
	{
		// Same input/output image size (1 : 1 = REAL input : REAL output)
		Assert(uInImgCropHsz == uOutImgHsz);
		Assert(uInImgCropVsz == uOutImgVsz);
		
		// 0x58(Register)_[31](ScalerBypass) must be '0'
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & 0x80000000;
		Assert(uCISCCTRL == 0x0);

		// ONLY for MFC
		//Assert((eInImgFmt==TILE_NV12)&&(eOutImgFmt==YC420));

		// Set One2One ENABLE
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<9);
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);		
	}
	else if(bOne2One == false)
	{
		// Set One2One DISABLE
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);	
		uCISCCTRL = uCISCCTRL & (~(0x1<<9));
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
	}
	else
	{
		Assert(0);
	}
}

// [Set DMA output image size]
void FIMC_SetDoutImgSize(FIMC_CH eCh, u32 uOutImgHsz, u32 uOutImgVsz, IMG_FMT eOutImgFmt, u32 uOutImgLineSkip)
{
	u32 uCITRGFMT;
	u32 uCIEXTEN;
	u32 uCITAREA;
	u32 uCIOLINESKIP;
		
	u32 uOutImgCropHszLowBits;
	u32 uOutImgCropHszHighBit;
	u32 uOutImgCropVszLowBits;
	u32 uOutImgCropVszHighBit;
	u32 uOutputDmaTargetArea;

	Assert(uOutImgVsz >= 4); // p29

	uOutImgCropHszLowBits = uOutImgHsz & 0x1fff;
	uOutImgCropHszHighBit = uOutImgHsz & 0x2000;
	uOutImgCropHszHighBit = uOutImgCropHszHighBit >> 13;
	uOutImgCropHszHighBit = uOutImgCropHszHighBit & 0x1;

	uOutImgCropVszLowBits = uOutImgVsz & 0x1fff;
	uOutImgCropVszHighBit = uOutImgVsz & 0x2000;
	uOutImgCropVszHighBit = uOutImgCropVszHighBit >> 13;
	uOutImgCropVszHighBit = uOutImgCropVszHighBit & 0x1;	

	fimcInp32(eCh, rCITRGFMT, uCITRGFMT);
	uCITRGFMT = uCITRGFMT & (~(0x1fff<<16));
	uCITRGFMT = uCITRGFMT |(uOutImgCropHszLowBits<<16);
	uCITRGFMT = uCITRGFMT & (~(0x1fff<<0));
	uCITRGFMT = uCITRGFMT |(uOutImgCropVszLowBits<<0);
	fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);

	fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
	uCIEXTEN = uCIEXTEN & (~(0x1<<26));
	uCIEXTEN = uCIEXTEN |(uOutImgCropHszHighBit<<26);
	uCIEXTEN = uCIEXTEN & (~(0x1<<24));
	uCIEXTEN = uCIEXTEN |(uOutImgCropVszHighBit<<24);
	fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);
	
	uOutputDmaTargetArea = uOutImgHsz*uOutImgVsz;
	fimcInp32(eCh, rCITAREA, uCITAREA);
	uCITAREA = uCITAREA & (~(0xfffffff<<0));
	uCITAREA = uCITAREA |(uOutputDmaTargetArea<<0);
	fimcOutp32(eCh, rCITAREA, uCITAREA);	

	Assert((0<=uOutImgLineSkip)&&(uOutImgLineSkip<=15));
	fimcInp32(eCh, rCIOLINESKIP, uCIOLINESKIP);
	uCIOLINESKIP = uCIOLINESKIP & (~(0xf<<20)); // Cr
	uCIOLINESKIP = uCIOLINESKIP & (~(0xf<<10)); // Cb
	uCIOLINESKIP = uCIOLINESKIP & (~(0xf<<0)); // Y
	switch(eOutImgFmt)
	{
		// 1 plane
		case RGB24:
		case RGB18:
		case RGB16:
		case BayerRGB8:
		case BayerRGB10:
		case BayerRGB12:
		case YCBYCR:
		case YCRYCB:
		case CBYCRY:
		case CRYCBY:
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<0); // Y line skip
			break;
		// 2 plane
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case TILE_NV12:
		case NV16: // YCBCR422_2P_CRCB_LE
		case YCBCR422_2P_CBCR_LE:
		case YCBCR422_2P_CRCB_BE:
		case YCBCR422_2P_CBCR_BE:		
		case NV24: // YCBCR444_2P_CRCB_LE
		case YCBCR444_2P_CBCR_LE:
		case YCBCR444_2P_CRCB_BE:
		case YCBCR444_2P_CBCR_BE:
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<0); // Y line skip
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<10); // Cb line skip
			break;
		// 3 plane
		case YC420:
		case YC422:	
		case YC444:			
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<0); // Y line skip
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<10); // Cb line skip
			uCIOLINESKIP = uCIOLINESKIP |(uOutImgLineSkip<<20); // Cr line skip
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIOLINESKIP, uCIOLINESKIP);	
}

// [Set FIFO output image size]
void FIMC_SetFoutImgSize(FIMC_CH eCh, u32 uOutImgHsz, u32 uOutImgVsz)
{
	u32 uCITRGFMT;
	u32 uCIEXTEN;
	u32 uCITAREA;
		
	u32 uOutImgCropHszLowBits;
	u32 uOutImgCropHszHighBit;
	u32 uOutImgCropVszLowBits;
	u32 uOutImgCropVszHighBit;
	u32 uOutputDmaTargetArea;

	Assert(uOutImgVsz >= 4); // p29

	uOutImgCropHszLowBits = uOutImgHsz & 0x1fff;
	uOutImgCropHszHighBit = uOutImgHsz & 0x2000;
	uOutImgCropHszHighBit = uOutImgCropHszHighBit >> 13;
	uOutImgCropHszHighBit = uOutImgCropHszHighBit & 0x1;

	uOutImgCropVszLowBits = uOutImgVsz & 0x1fff;
	uOutImgCropVszHighBit = uOutImgVsz & 0x2000;
	uOutImgCropVszHighBit = uOutImgCropVszHighBit >> 13;
	uOutImgCropVszHighBit = uOutImgCropVszHighBit & 0x1;	

	fimcInp32(eCh, rCITRGFMT, uCITRGFMT);
	uCITRGFMT = uCITRGFMT & (~(0x1fff<<16));
	uCITRGFMT = uCITRGFMT |(uOutImgCropHszLowBits<<16);
	uCITRGFMT = uCITRGFMT & (~(0x1fff<<0));
	uCITRGFMT = uCITRGFMT |(uOutImgCropVszLowBits<<0);
	fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);

	fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
	uCIEXTEN = uCIEXTEN & (~(0x1<<26));
	uCIEXTEN = uCIEXTEN |(uOutImgCropHszHighBit<<26);
	uCIEXTEN = uCIEXTEN & (~(0x1<<24));
	uCIEXTEN = uCIEXTEN |(uOutImgCropVszHighBit<<24);
	fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);
	
	uOutputDmaTargetArea = uOutImgHsz*uOutImgVsz;
	fimcInp32(eCh, rCITAREA, uCITAREA);
	uCITAREA = uCITAREA & (~(0xfffffff<<0));
	uCITAREA = uCITAREA |(uOutputDmaTargetArea<<0);
	fimcOutp32(eCh, rCITAREA, uCITAREA);	
}

// [Start processing]
void FIMC_StartProcessing(FIMC_CH eCh,
	u8 bCptFrmCtrl, u32 uCptSeqPattern, u32 uCptSeqPointer,
	u8 bCptCntCtrl, u32 uCptCnt)
{
	u32 uCIIMGCPT;
	u32 uCISCCTRL;
	u32 uMSCTRL;
	u32 uCIREAL_ISIZE;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
	
	if(ePath == DMA_IN_DMA_OUT)
	{
		// Image capture
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);

		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

		// Read memory
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL |(0x1<<0); // Input DMA operation START!
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);
	}
	else if(ePath == FIFO_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);		
		if(bCptFrmCtrl == true)
		{
			Assert(g_eFinMode == PROGRESSIVE_IN_FIFO); //p39
			Assert((0<=uCptSeqPointer)&&(uCptSeqPointer<=31));
			
			fimcOutp32(eCh, rCICPTSEQ, uCptSeqPattern); // Capture sequence pattern
			
			uCIIMGCPT = uCIIMGCPT |(0x1<<25); // Capture frame control enable
			uCIIMGCPT = uCIIMGCPT & (~(0x1f<<19));
			uCIIMGCPT = uCIIMGCPT |(uCptSeqPointer<<19); // Capture sequence turn-around pointer (bit number)

			if(bCptCntCtrl == true)
			{
				Assert((0<=uCptCnt)&&(uCptCnt<=255));
				
				uCIIMGCPT = uCIIMGCPT |(0x1<<18); // Capture count control enable

				uCIIMGCPT = uCIIMGCPT & (~(0xff<<10));
				uCIIMGCPT = uCIIMGCPT |(uCptCnt<<10); // Capture count
			}
		}
		else // bCptFrmCtrl == false
		{
			uCIIMGCPT = uCIIMGCPT & (~(0x1<<25)); // Capture frame control disable
		}
		uCIIMGCPT = uCIIMGCPT |(0x1<<31); // Camera interface global capture enable
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);	
	}
	else if(ePath == DMA_IN_FIFO_OUT)
	{
		// Automatic DMA input RESTART
		fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
		uCIREAL_ISIZE = uCIREAL_ISIZE |(0x1<<31); // Autoload enable
		fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);

		// Image capture
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

		// Read memory
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL |(0x1<<0); // Input DMA operation START!
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);	
	}
	else if(ePath == DIRECT_FIFO_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);		
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<25)); // Capture frame control disable
		uCIIMGCPT = uCIIMGCPT |(0x1<<31); // Camera interface global capture enable
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);		
	}
	else
	{
		Assert(0);
	}
}

// [Start processing for MFC]
void FIMC_StartProcessingForMfc(FIMC_CH eCh)
{
	u32 uCIIMGCPT;
	u32 uCISCCTRL;
	u32 uMSCTRL;
	u32 uCIREAL_ISIZE;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
		
	if(ePath == DMA_IN_DMA_OUT)
	{
		// Image capture
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

		// Read memory
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL |(0x1<<0); // Input DMA operation START!
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);
	}
	else if(ePath == DMA_IN_FIFO_OUT)
	{
		// Automatic DMA input RESTART
		fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
		uCIREAL_ISIZE = uCIREAL_ISIZE |(0x1<<31); // Autoload enable
		fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);

		// Image capture
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT |(0x1<<30); // Capture enable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL |(0x1<<15); // Scaler start
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

		// Read memory
		fimcInp32(eCh, rMSCTRL, uMSCTRL);
		uMSCTRL = uMSCTRL |(0x1<<0); // Input DMA operation START!
		fimcOutp32(eCh, rMSCTRL, uMSCTRL);	
	}
	else
	{
		Assert(0);
	}	
}

// [Start processing for scaler bypass]
void FIMC_StartProcessingForScalerBypass(FIMC_CH eCh)
{
	u32 uCISCCTRL;
	u32 uCIIMGCPT;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
	
	Assert((ePath==FIFO_IN_DMA_OUT)||(ePath==DIRECT_FIFO_IN_DMA_OUT));

	switch(eCh)
	{
		case FIMC_A:
			Assert(g_uCamInImgHsz <= SC_BP_IN_MAX_HSZ_A); // p8
			Assert(g_uCamInImgVsz <= SC_BP_IN_MAX_VSZ_A); // p8
			break;
		case FIMC_B:
			Assert(g_uCamInImgHsz <= SC_BP_IN_MAX_HSZ_B); // p8
			Assert(g_uCamInImgVsz <= SC_BP_IN_MAX_VSZ_B); // p8
			break;
		case FIMC_C:
			Assert(g_uCamInImgHsz <= SC_BP_IN_MAX_HSZ_C); // p8
			Assert(g_uCamInImgVsz <= SC_BP_IN_MAX_VSZ_C); // p8
			break;
		default:
			Assert(0);
			break;
	}		

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL |(0x1<<31); // Scaler bypass ON
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL & (~(0x1<<15)); // Scaler bypass
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

	fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
	uCIIMGCPT = uCIIMGCPT & (~(0x1<<25)); // Capture frame control disable
	uCIIMGCPT = uCIIMGCPT |(0x1<<31); // Camera interface global capture enable
	uCIIMGCPT = uCIIMGCPT & (~(0x1<<30)); // Capture disable for scaler
	fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);
}

// [Start processing for Jpeg input]
void FIMC_StartProcessingForJpegInput(FIMC_CH eCh)
{
	u32 uCISCCTRL;
	u32 uCISRCFMT;
	u32 uCIGCTRL;
	u32 uCIIMGCPT;

	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}

	Assert(ePath==FIFO_IN_DMA_OUT);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL |(0x1<<31); // Scaler bypass ON
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);		

	fimcInp32(eCh, rCISRCFMT, uCISRCFMT);
	uCISRCFMT = uCISRCFMT |(0x1<<31); // ITU-R BT.601 YCbCr 8-bit mode enable
	fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);	

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL |(0x1<<8); // JPEG file input enable
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL & (~(0x1<<15)); // Scaler bypass
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

	fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
	uCIIMGCPT = uCIIMGCPT & (~(0x1<<25)); // Capture frame control disable
	uCIIMGCPT = uCIIMGCPT |(0x1<<31); // Camera interface global capture enable
	uCIIMGCPT = uCIIMGCPT & (~(0x1<<30)); // Capture disable for scaler
	fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);
}

// [Start processing]
void FIMC_StopProcessing(FIMC_CH eCh)
{
	u32 uCISCCTRL;
	u32 uCIIMGCPT;
	u32 uCISTATUS;
	u32 uCIREAL_ISIZE;
	u32 uCIGCTRL;
	
	FIMC_PATH ePath;
	switch(eCh)
	{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}
	
	if(ePath == DMA_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x1<<15)); // Scaler stop OR scaler bypass
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		// Image capture
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<30)); // Capture disable for scaler OR scaler bypass
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);

#if 1
		// Check hardware auto clear
		//u32 uInputDmaCtrlReg;
		//do
		//{
		//	fimcInp32(eCh, rMSCTRL, uInputDmaCtrlReg);
		//}
		//while((uInputDmaCtrlReg&0x1) != 0x0);		
		do
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
			//Disp("\n [c] \n");
		}
		while((uCISTATUS&0x100) != 0x0); // To check 'ENVID_STATUS'
#endif		
	}
	else if(ePath == FIFO_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x1<<31)); // Scaler bypass OFF
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);

		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL & (~(0x1<<8)); // JPEG file input disable
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);		
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x1<<15)); // Scaler stop
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<31)); // Camera interface global capture disable
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<30)); // Capture disable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);

		// To resolve Mipi-fifo-input DMA-output problem [CQ_ID:STAR00010095]
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<25)); // Capture frame control disable
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT); 

		do
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
		}
		while((uCISTATUS&0x00600000) != 0x0); // To check 'ImgCptEn' and 'ImgCptEn_SC'
	}
	else if(ePath == DMA_IN_FIFO_OUT)
	{
		// Automatic DMA input RESTART
		fimcInp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
		uCIREAL_ISIZE = uCIREAL_ISIZE & (~(0x1<<31)); // Autoload disable
		fimcOutp32(eCh, rCIREAL_ISIZE, uCIREAL_ISIZE);
		
	/*
		u32 uMainScalerCtrlRegVal;
		fimcInp32(eCh, rCISCCTRL, uMainScalerCtrlRegVal);
		uMainScalerCtrlRegVal = uMainScalerCtrlRegVal & (~(0x1<<15)); // Scaler stop OR scaler bypass
		fimcOutp32(eCh, rCISCCTRL, uMainScalerCtrlRegVal);
		
		// Image capture
		u32 uImgCaptureEnable;
		fimcInp32(eCh, rCIIMGCPT, uImgCaptureEnable);
		uImgCaptureEnable = uImgCaptureEnable & (~(0x1<<30)); // Capture disable for scaler OR scaler bypass
		fimcOutp32(eCh, rCIIMGCPT, uImgCaptureEnable);
	*/

#if 1
		// Check hardware auto clear
		//u32 uInputDmaCtrlReg;
		//do
		//{
		//	fimcInp32(eCh, rMSCTRL, uInputDmaCtrlReg);
		//}
		//while((uInputDmaCtrlReg&0x1) != 0x0);			
		do
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
			//Disp("\n [c] \n");
		}
		while((uCISTATUS&0x100) != 0x0); // To check 'ENVID_STATUS'
#endif
	}
	else if(ePath == DIRECT_FIFO_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x1<<31)); // Scaler bypass OFF
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
		uCISCCTRL = uCISCCTRL & (~(0x1<<15)); // Scaler stop
		fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
		
		fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<31)); // Camera interface global capture disable
		uCIIMGCPT = uCIIMGCPT & (~(0x1<<30)); // Capture disable for scaler
		fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);

		do
		{
			fimcInp32(eCh, rCISTATUS, uCISTATUS);
		}
		while((uCISTATUS&0x00600000) != 0x0); // To check 'ImgCptEn' and 'ImgCptEn_SC'
	}
	else
	{
		Assert(0);
	}
}

// [Reset camera A]
static void FIMC_ResetCameraA(CIS_MODEL eCisModel)
{
#ifdef S5PV210
	u32 uDelay1, uDelay2;
	
	switch(eCisModel)
	{
		case OV7620:			
			GPIO_SetFunctionEach(eGPIO_H0, eGPIO_2, eGPO); // XEINT2
			GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_2, eGPUDdis); // XEINT2
			
			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 1); // XEINT2
			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 0); // XEINT2
			break;
		case S5K3AAE:
		case S5K3BAF:
		case S5K4AAF:
		case S5K3C1F:
		case ADV7180:
		case M5MO:
			GPIO_SetFunctionEach(eGPIO_H0, eGPIO_2, eGPO); // XEINT2
			GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_2, eGPUDdis); // XEINT2

			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 0); // XEINT2
			
			if(eCisModel==ADV7180)
			{
				for(uDelay1=0;uDelay1<1000000;uDelay1++);
			}			
			
			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 1); // XEINT2
			
			if(eCisModel==ADV7180)
			{
				for(uDelay1=0;uDelay1<1000000;uDelay1++);
			}			
			break;
		case CE143Monaco:
			//for(uDelay1=0;uDelay1<1000;uDelay1++)
			//{
				for(uDelay2=0;uDelay2<1000000;uDelay2++)
				{
				}
			//}
			Disp("\n [Cam A] Before STBY delay end! \n");
			
			// STBY(standBy)
			GPIO_SetFunctionEach(eGPIO_H3, eGPIO_3, eGPO); // XEINT27
			GPIO_SetPullUpDownEach(eGPIO_H3, eGPIO_3, eGPUDdis); // XEINT27

			GPIO_SetDataEach(eGPIO_H3, eGPIO_3, 0); // XEINT27
			GPIO_SetDataEach(eGPIO_H3, eGPIO_3, 1); // XEINT27	
			
			//for(uDelay1=0;uDelay1<1000;uDelay1++)
			//{
				for(uDelay2=0;uDelay2<1000000;uDelay2++)
				{
				}
			//}
			Disp("\n [Cam A] After STBY delay end! \n");
			
			//------------------------------------------------------------

			// RESET
			GPIO_SetFunctionEach(eGPIO_H0, eGPIO_2, eGPO); // XEINT2
			GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_2, eGPUDdis); // XEINT2	

			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 0); // XEINT2
			GPIO_SetDataEach(eGPIO_H0, eGPIO_2, 1); // XEINT2	
			
			//for(uDelay1=0;uDelay1<1000;uDelay1++)
			//{
				for(uDelay2=0;uDelay2<1000000;uDelay2++)
				{
				}
			//}
			Disp("\n [Cam A] RESET delay end! \n");

			break;
		case S5K4CAGX: // Mipi camera
		case S5K6AAFX:
		case S5K4EAG:
		case S5K4E1GX:
		case EXTCAM:
			break;
		default:
			Assert(0);
			break;
	}		
#endif
}

// [Reset camera B]
static void FIMC_ResetCameraB(CIS_MODEL eCisModel)
{
#ifdef S5PV210
		u32 uDelay1, uDelay2;
		
		switch(eCisModel)
		{
			case OV7620:			
				GPIO_SetFunctionEach(eGPIO_H0, eGPIO_3, eGPO); // XEINT3
				GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_3, eGPUDdis); // XEINT3
				
				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 1); // XEINT3
				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3				
				break;
			case S5K3AAE:
			case S5K3BAF:
			case S5K4AAF:
			case S5K3C1F:
			case ADV7180:
			case M5MO:
				GPIO_SetFunctionEach(eGPIO_H0, eGPIO_3, eGPO); // XEINT3
				GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_3, eGPUDdis); // XEINT3

				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3	
				
				if(eCisModel==ADV7180)
				{
					for(uDelay1=0;uDelay1<1000000;uDelay1++);
				}			
				
				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 1); // XEINT3
				
				if(eCisModel==ADV7180)
				{
					for(uDelay1=0;uDelay1<1000000;uDelay1++);
				}			
				break;
			case CE143Monaco:
				//for(uDelay1=0;uDelay1<1000;uDelay1++)
				//{
					for(uDelay2=0;uDelay2<1000000;uDelay2++)
					{
					}
				//}
				Disp("\n [Cam B] Before STBY delay end! \n");
			
				// STBY(standBy)
				GPIO_SetFunctionEach(eGPIO_H3, eGPIO_3, eGPO); // XEINT27
				GPIO_SetPullUpDownEach(eGPIO_H3, eGPIO_3, eGPUDdis); // XEINT27

				GPIO_SetDataEach(eGPIO_H3, eGPIO_3, 0); // XEINT27
				GPIO_SetDataEach(eGPIO_H3, eGPIO_3, 1); // XEINT27
				
				//for(uDelay1=0;uDelay1<1000;uDelay1++)
				//{
					for(uDelay2=0;uDelay2<1000000;uDelay2++)
					{
					}
				//}
				Disp("\n [Cam B] After STBY delay end! \n");

				//------------------------------------------------------------

				// RESET
				GPIO_SetFunctionEach(eGPIO_H0, eGPIO_3, eGPO); // XEINT3
				GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_3, eGPUDdis); // XEINT3	

				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3	
				GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 1); // XEINT3
				
				//for(uDelay1=0;uDelay1<1000;uDelay1++)
				//{
					for(uDelay2=0;uDelay2<1000000;uDelay2++)
					{
					}
				//}
				Disp("\n [Cam B] RESET delay end! \n");

				break;				
			case S5K4CAGX: // Mipi camera
			case S5K6AAFX:			
			case S5K4EAG:
			case S5K4E1GX:			
			case EXTCAM:
				break;			
			default:
				Assert(0);
				break;
		}		
#endif
}

// [Reset camera mipi]
static void FIMC_ResetCameraMipi(CIS_MODEL eCisModel)
{
	switch(eCisModel)
	{
		case S5K4CAGX: // Mipi camera
		case S5K6AAFX:		
		case S5K4EAG:
			GPIO_SetFunctionEach(eGPIO_H0, eGPIO_3, eGPO); // XEINT3
			GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_3, eGPUDdis); // XEINT3
			GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3
			GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 1); // XEINT3		
			break;			
		case OV7620:			
		case S5K3AAE:
		case S5K3BAF:
		case S5K4AAF:
		case S5K3C1F:
		case ADV7180:
		case M5MO:
		case CE143Monaco:
			break;			
		default:
			Assert(0);
			break;
	}		
}

// [Select camera]
static void FIMC_SelCamera(FIMC_CH eCh, CAMERA eCamera)
{
	u32 uCIGCTRL;

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	switch(eCamera)
	{
		case ITU_CAMERA_A:
			uCIGCTRL = uCIGCTRL |(0x1<<29); // Select ITU camera A
			break;
		case ITU_CAMERA_B:
			uCIGCTRL = uCIGCTRL & (~(0x1<<29)); // Select ITU camera B
			break;
		case MIPI_CAMERA_A:
			uCIGCTRL = uCIGCTRL |(0x1<<7); // Select MIPI camera A
			break;
		case MIPI_CAMERA_B:
			uCIGCTRL = uCIGCTRL & (~(0x1<<7)); // Select MIPI camera B
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Initialize camera]
void FIMC_InitCamera(CIS_MODEL eCisModel, IMG_FMT eFinImgType, IMG_RESOLUTION eSize)
{
	// Initialize rCIGCTRL register
	//g_uCIGCTRL	= 0x20010080; // register offset = 0x08

	// ================= Notice =================
	// If you connect 'camera A' and 'camera B' to SMDK board,
	// you MUST reset 'camera A' and 'camera B' simultaneously
	// =======================================
	FIMC_ResetCameraA(eCisModel);
	FIMC_ResetCameraB(eCisModel);
//	FIMC_ResetCameraMipi(eCisModel);
	
	//FIMC_SelCamera(eCh, eCamera); // Select camera A or B

	// [Initalize the member variables and initalize the camera model]
	//==========================================
	
	g_uIfBits = 8;
	g_uInvField = 0x0; // Polarity of FIELD
/*
	if(eCisModel == OV7620)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
		g_eCcir = CCIR656;

		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
	   	//g_eFinInImgType = CRYCBY;
	   	g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitOV7620(g_eCcir, g_uIfBits, false, g_eFinInImgType);
	}
	else if(eCisModel == S5K3AAE)
	{
		g_uInvPclk = 0x1;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 1280, g_uCamInImgVsz = 1024;
		g_eCcir = CCIR656; 

		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
		//g_eFinInImgType = CBYCRY;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitS5K3AAE(g_eCcir, g_eFinInImgType, SXGA);
	}
	else if(eCisModel == S5K4AAF)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 1280, g_uCamInImgVsz = 1024; 
		g_eCcir = CCIR601;

		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
		//g_eFinInImgType = YCBYCR;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitS5K4AAF(g_eCcir, g_eFinInImgType, SXGA);
	}
	else if(eCisModel == S5K3BAF)
*/	
	if(eCisModel == S5K3BAF)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x1;
		g_uInvHref = 0x0;
		//g_uCamInImgHsz = 1600, g_uCamInImgVsz = 1200;
		g_eCcir = CCIR601;

		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
		//g_eFinInImgType = YCRYCB;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;	

		switch(eSize)
		{
			case UXGA:
				g_uCamInImgHsz = 1600, g_uCamInImgVsz = 1200;
				break;
			case SXGA:
				g_uCamInImgHsz = 1280, g_uCamInImgVsz = 1024;
				break;
			case VGA:
				g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
				break;
			case QVGA:
				g_uCamInImgHsz = 320, g_uCamInImgVsz = 240;
				break;
			case CIF:
				g_uCamInImgHsz = 352, g_uCamInImgVsz = 288;
				break;
			default:
				Assert(0);
				break;
		}
		CAM_InitS5K3BAF(g_eCcir, g_eFinInImgType, eSize);
	}
	else if(eCisModel == S5K4CAGX)
	{
		g_eCcir = MIPI;

		Assert((eFinImgType==BayerRGB8)||(eFinImgType==BayerRGB10)
			||(eFinImgType==BayerRGB12)||(eFinImgType==CBYCRY));
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		switch(eSize)
		{
			case QXGA:
				g_uCamInImgHsz = 2048, g_uCamInImgVsz = 1536;
				break;
			case HD720:
				g_uCamInImgHsz = 1280, g_uCamInImgVsz = 720;
				break;
			default:
				Assert(0);
				break;
		}

		InitS5K4CAGX(g_eCcir, g_eFinInImgType, eSize);
	}
	else if(eCisModel == S5K6AAFX)		
	{
		switch(eSize)
		{
			case VGA:
				g_uCamInImgHsz = VGA_HSIZE, g_uCamInImgVsz = VGA_VSIZE;
				break;
			case USER_DEFINE_SIZE:
				g_uCamInImgHsz = USER_DEFINE_SIZE_HSIZE, g_uCamInImgVsz = USER_DEFINE_SIZE_VSIZE;
				break;						
			default:
				Assert(0);
				break;
		}

		g_eCcir = MIPI;
		Assert(eFinImgType==CBYCRY);
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

//		InitS5K6AAFX(g_eCcir, g_eFinInImgType, eSize);
//		CSI_S_RESETN_LP11();		
	}		
	else if(eCisModel == S5K4EAG)		
	{
		switch(eSize)
		{
			case VGA:
				g_uCamInImgHsz = VGA_HSIZE, g_uCamInImgVsz = VGA_VSIZE;
				break;
			case WVGA:
				g_uCamInImgHsz = WVGA_HSIZE, g_uCamInImgVsz = WVGA_VSIZE;
				break;
			case WSVGA:
				g_uCamInImgHsz = WSVGA_HSIZE, g_uCamInImgVsz = WSVGA_VSIZE;
				break;				
			case HD720:
				g_uCamInImgHsz = HD720_HSIZE, g_uCamInImgVsz = HD720_VSIZE;
				break;
			case HD1080:
				g_uCamInImgHsz = HD1080_HSIZE, g_uCamInImgVsz = HD1080_VSIZE;
				break;
			case USER_DEFINE_SIZE:
				g_uCamInImgHsz = USER_DEFINE_SIZE_HSIZE, g_uCamInImgVsz = USER_DEFINE_SIZE_VSIZE;
				break;				
			default:
				Assert(0);
				break;
		}

		g_eCcir = MIPI;
		Assert(eFinImgType==CBYCRY || eFinImgType==BayerRGB8 || 
			eFinImgType==BayerRGB10 || eFinImgType==BayerRGB12);
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

//		InitS5K4EAG(g_eCcir, g_eFinInImgType, eSize, g_uCamInImgHsz, g_uCamInImgVsz);			
	}			
	else if(eCisModel == S5K4E1GX)		
	{
		switch(eSize)
		{
			case USER_DEFINE_SIZE:
				g_uCamInImgHsz = USER_DEFINE_SIZE_HSIZE, g_uCamInImgVsz = USER_DEFINE_SIZE_VSIZE;
				break;				
			default:
				Assert(0);
				break;
		}

		g_eCcir = MIPI;
		Assert(eFinImgType==BayerRGB8 || eFinImgType==BayerRGB10 || eFinImgType==BayerRGB12);
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

//		InitS5K4E1GX(g_eCcir, g_eFinInImgType, eSize, g_uCamInImgHsz, g_uCamInImgVsz);			
	}			
	else if(eCisModel == EXTCAM)		
	{
		switch(eSize)
		{
			case USER_DEFINE_SIZE:
				g_uCamInImgHsz = USER_DEFINE_SIZE_HSIZE, g_uCamInImgVsz = USER_DEFINE_SIZE_VSIZE;
				break;				
			default:
				Assert(0);
				break;
		}

		g_eCcir = MIPI;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;
	}		
	/*else if(eCisModel == S5K3C1F)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 2056, g_uCamInImgVsz = 1544;
		g_eCcir = CCIR601;

		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
		//g_eFinInImgType = YCRYCB;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitS5K3C1F();
	}*/
	else if(eCisModel == ADV7180)
	{
		g_uCamInImgHsz = 720, g_uCamInImgVsz = 480;
		g_eCcir = CCIR656;
		
		Assert(eFinImgType == CBYCRY);
		//g_eFinInImgType = CBYCRY;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = INTERLACE_IN_ITU656;

		InitADV7180();
	}
	else if(eCisModel == M5MO)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x1;
		g_uInvHref = 0x0;
		//g_uCamInImgHsz = 3264, g_uCamInImgVsz = 2448;
		g_eCcir = CCIR601;

		//Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
		//	||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
		Assert(eFinImgType==CBYCRY);
		//g_eFinInImgType = CBYCRY;
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		switch(eSize)
		{
			case QVGA:
				g_uCamInImgHsz = 320, g_uCamInImgVsz = 240;
				break;
			case VGA:
				g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
				break;
			case WVGA:
				g_uCamInImgHsz = 800, g_uCamInImgVsz = 480;
				break;			
			case CAM_8M:
				g_uCamInImgHsz = 3264, g_uCamInImgVsz = 2448;
				break;				
			default:
				Assert(0);
				break;
		}
		//CAM_InitS5K3BAF(g_eCcir, g_eFinInImgType, eSize);		
		InitM5moForPreview(eSize);
	}
	else if(eCisModel == CE143Monaco)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x1;
		g_uInvHref = 0x0;
		
		g_eCcir = CCIR601;

		Assert(eFinImgType==CBYCRY);
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;		

		switch(eSize)
		{
			case QVGA:
				g_uCamInImgHsz = 320, g_uCamInImgVsz = 240;
				break;
			case VGA:
				g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
				break;
			case SD480:
				g_uCamInImgHsz = 720, g_uCamInImgVsz = 480;
				break;			
			case WVGA:
				g_uCamInImgHsz = 800, g_uCamInImgVsz = 480;
				break;			
			case HD720:
				g_uCamInImgHsz = 1280, g_uCamInImgVsz = 720;
				break;			
			default:
				Assert(0);
				break;
		}	
		CAM_InitCE143MonacoForPreview(eSize);
	}
	else
	{
		Assert(0);
	}
}

// [Initialize camera for test pattern]
// ref. p24
// Test pattern needs ONLY 640x480(VGA)
void FIMC_InitCameraForTestPattern(CIS_MODEL eCisModel, IMG_FMT eFinImgType)
{
	// Initialize rCIGCTRL register
	//g_uCIGCTRL	= 0x20010080; // register offset = 0x08

	// ================= Notice =================
	// If you connect 'camera A' and 'camera B' to SMDK board,
	// you MUST reset 'camera A' and 'camera B' simultaneously
	// =======================================
	FIMC_ResetCameraA(eCisModel);
	FIMC_ResetCameraB(eCisModel);
	//FIMC_ResetCameraMipi();

	//FIMC_SelCamera(eCh, eCamera); // Select camera A or B

	// [Initalize the member variables and initalize the camera model]
	//==========================================
	
	g_uIfBits = 8;
	g_uInvField = 0x0; // Polarity of FIELD
/*
	if(eCisModel == OV7620)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
		g_eCcir = CCIR656;
	   	g_eFinInImgType = CRYCBY;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitOV7620(g_eCcir, g_uIfBits, false, g_eFinInImgType);
	}
	else if(eCisModel == S5K3AAE)
	{
		g_uInvPclk = 0x1;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;
		g_eCcir = CCIR656; 
		g_eFinInImgType = CBYCRY;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitS5K3AAE(g_eCcir, g_eFinInImgType, VGA);
	}
	else if(eCisModel == S5K4AAF)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x0;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;	
		g_eCcir = CCIR601;
		g_eFinInImgType = YCBYCR;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		InitS5K4AAF(g_eCcir, g_eFinInImgType, VGA);
	}
	else if(eCisModel == S5K3BAF)
*/
	if(eCisModel == S5K3BAF)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x1;
		g_uInvHref = 0x0;
		g_uCamInImgHsz = 640, g_uCamInImgVsz = 480;	
		g_eCcir = CCIR601;
#if 0		
		Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
			||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
#else
		Assert(eFinImgType==YCBYCR);
#endif
		g_eFinInImgType = eFinImgType;
		g_eFinMode = PROGRESSIVE_IN_FIFO;

		CAM_InitS5K3BAF(g_eCcir, g_eFinInImgType, VGA);
	}
	else
	{
		Assert(0);
	}
}

// [Initialize camera for FIMD]
void FIMC_InitCameraForFimd(CAM_ATTR eCcir, FIFO_IN_MODE eFinMode,
	IMG_FMT eFinImgType, IMG_RESOLUTION eSize)
{
	u32 uCIGCTRL;
		
	//FIMC_SelCamera(eCh, eCamera); // Select camera A or B

	// [Initalize the member variables and initalize the camera model]
	//==========================================
	
	g_uIfBits = 8;
	g_uInvField = 0x0; // Polarity of FIELD

	g_uInvPclk = 0x0;
	g_uInvVsync = 0x0;
	g_uInvHref = 0x0;
	
	g_eCcir = eCcir;

	Assert((eFinImgType==YCBYCR)||(eFinImgType==YCRYCB)
		||(eFinImgType==CBYCRY)||(eFinImgType==CRYCBY));
	//g_eFinInImgType = YCRYCB;
	g_eFinInImgType = eFinImgType;
	g_eFinMode = eFinMode;	

	switch(eSize)
	{
		case WVGA:
			g_uCamInImgHsz = 800, g_uCamInImgVsz = 480;
			break;
		case WVGA_PORT:
			g_uCamInImgHsz = 480, g_uCamInImgVsz = 800;
			break;
		case QVGA:
			g_uCamInImgHsz = 320, g_uCamInImgVsz = 240;
			break;
		case QVGA_PORT:
			g_uCamInImgHsz = 240, g_uCamInImgVsz = 320;
			break;
		default:
			Assert(0);
			break;
	}
}

// [Initialize camera For JPEG input]
void FIMC_InitCameraForJpegInput(CIS_MODEL eCisModel, IMG_RESOLUTION eSize)
{
	 u32 uDelay;
	 
	Assert(eCisModel == CE143Monaco);
		
	// Initialize rCIGCTRL register
	//g_uCIGCTRL	= 0x20010080; // register offset = 0x08

	// ================= Notice =================
	// If you connect 'camera A' and 'camera B' to SMDK board,
	// you MUST reset 'camera A' and 'camera B' simultaneously
	// =======================================
	FIMC_ResetCameraA(eCisModel);
	FIMC_ResetCameraB(eCisModel);
//	FIMC_ResetCameraMipi(eCisModel);
	
	//FIMC_SelCamera(eCh, eCamera); // Select camera A or B

	// [Initalize the member variables and initalize the camera model]
	//==========================================
	
	g_uIfBits = 8;
	g_uInvField = 0x0; // Polarity of FIELD

	if(eCisModel == CE143Monaco)
	{
		g_uInvPclk = 0x0;
		g_uInvVsync = 0x1;
		g_uInvHref = 0x0;
		
		g_eCcir = CCIR601;

		//Assert(eFinImgType==CBYCRY);
		//g_eFinInImgType = eFinImgType;
		g_eFinInImgType = CBYCRY;
		g_eFinMode = PROGRESSIVE_IN_FIFO;	

		g_uCamInImgHsz = 768, g_uCamInImgVsz = 3000;

		CAM_InitCE143MonacoToGetJpeg(eSize);
	}
	else
	{
		Assert(0);
	}
}

// [Reset IP for FIFO-in]
// Camera interface(CAMIF) software RESET
void FIMC_ResetIpForFin(FIMC_CH eCh)
{
	u32 uCISRCFMT;
	u32 uCIGCTRL;
	u32 uCISTATUS;

#if 0
	// Initialize register
	g_uCISRCFMT 		= 0x00000000; // register offset = 0x00
	g_uCIWDOFST 		= 0x00000000; // register offset = 0x04
	//g_uCIGCTRL 		= 0x20010080; // register offset = 0x08 -> Commented to keep g_uCIGCTRL in FIMC_InitCamera() or FIMC_InitCameraForTestPattern()
	g_uCIWDOFST2 		= 0x00000000; // register offset = 0x14
	g_uCITRGFMT 		= 0x00000000; // register offset = 0x48
	g_uCIOCTRL 			= 0x00000000; // register offset = 0x4c
	g_uCISCPRERATIO 	= 0x00000000; // register offset = 0x50
	g_uCISCPREDST 		= 0x00000000; // register offset = 0x54
	g_uCISCCTRL 		= 0x18000000; // register offset = 0x58
	g_uCITAREA 			= 0x00000000; // register offset = 0x5c
	g_uCIOLINESKIP		= 0x00000000; // register offset = 0x60
	g_uCIIMGCPT 		= 0x00000000; // register offset = 0xc0
	g_uCITHOLD			= 0x00000000; // register offset = 0xc8
	g_uCIIMGEFF 		= 0x00100080; // register offset = 0xd0
	g_uCIILINESKIP_Y	= 0x00000000; // register offset = 0xec
	g_uCIILINESKIP_CB	= 0x00000000; // register offset = 0xf0
	g_uCIILINESKIP_CR	= 0x00000000; // register offset = 0xf4
	//g_uCIREAL_ISIZE 	= 0x00000000; // register offset = 0xf8 -> Commented because of register relative to Din
	g_uMSCTRL 			= 0x04000000; // register offset = 0xfc
	//g_uORGISIZE 		= 0x00000000; // register offset = 0x180 -> Commented because of register relative to Din
	g_uORGOSIZE 		= 0x00000000; // register offset = 0x184
	g_uCIEXTEN 			= 0x00000000; // register offset = 0x188
	g_uCIDMAPARAM 		= 0x00000000; // register offset = 0x18c
	g_uCSIIMGFMT 		= 0x0000001e; // register offset = 0x194
#endif	
	
	// FIFO-IN case
	// ITU601 case: ITU601_656n '1' -> SwRst '1' -> SwRst '0'(RESET)
	// ITU656 case: ITU601_656n '1' -> SwRst '1' -> SwRst '0'(RESET) -> ITU601_656n '0'

	if(g_eCcir == CCIR601)
	{
		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);		
		uCISRCFMT = uCISRCFMT |(0x1<<31); // ITU-R BT.601 YCbCr 8-bit mode enable
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);	
	
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL |(0x1<<31);
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
	
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL &(~(0x1<<31));
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // Reset	
	}
	else if(g_eCcir == CCIR656)
	{
		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);		
		uCISRCFMT = uCISRCFMT |(0x1<<31);
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);
	
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL |(0x1<<31);
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
	
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL &(~(0x1<<31));
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // Reset

		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);
		uCISRCFMT = uCISRCFMT & (~(0x1<<31)); // ITU-R BT.656 YCbCr 8-bit mode enable
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);
	}
	else if(g_eCcir == MIPI)
	{
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL |(0x1<<31);
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);

		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL &(~(0x1<<31));
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // Reset	
	}
	else
	{
		Assert(0);
	}

	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & (~(0x1<<16));
	fimcOutp32(eCh, rCISTATUS, uCISTATUS);
}

// [Reset IP for DMA-in]
// Camera interface(CAMIF) software RESET
void FIMC_ResetIpForDin(FIMC_CH eCh)
{
	u32 uCIGCTRL;
	u32 uCISTATUS;

#if 0
	// Initialize register
	//g_uCISRCFMT 		= 0x00000000; // register offset = 0x00 -> Commented because of register relative to Fin
	//g_uCIWDOFST 		= 0x00000000; // register offset = 0x04 -> Commented because of register relative to Fin
	//g_uCIGCTRL 		= 0x20010080; // register offset = 0x08 -> Commented because of register relative to Fin
	//g_uCIWDOFST2 		= 0x00000000; // register offset = 0x14 -> Commented because of register relative to Fin
	g_uCITRGFMT 		= 0x00000000; // register offset = 0x48
	g_uCIOCTRL 			= 0x00000000; // register offset = 0x4c
	g_uCISCPRERATIO 	= 0x00000000; // register offset = 0x50
	g_uCISCPREDST 		= 0x00000000; // register offset = 0x54
	g_uCISCCTRL 		= 0x18000000; // register offset = 0x58
	g_uCITAREA 			= 0x00000000; // register offset = 0x5c
	g_uCIOLINESKIP		= 0x00000000; // register offset = 0x60
	g_uCIIMGCPT 		= 0x00000000; // register offset = 0xc0
	g_uCITHOLD			= 0x00000000; // register offset = 0xc8
	g_uCIIMGEFF 		= 0x00100080; // register offset = 0xd0
	g_uCIILINESKIP_Y	= 0x00000000; // register offset = 0xec
	g_uCIILINESKIP_CB	= 0x00000000; // register offset = 0xf0
	g_uCIILINESKIP_CR	= 0x00000000; // register offset = 0xf4
	g_uCIREAL_ISIZE 	= 0x00000000; // register offset = 0xf8
	g_uMSCTRL 			= 0x04000000; // register offset = 0xfc
	g_uORGISIZE 			= 0x00000000; // register offset = 0x180
	g_uORGOSIZE 		= 0x00000000; // register offset = 0x184
	g_uCIEXTEN 			= 0x00000000; // register offset = 0x188
	g_uCIDMAPARAM 		= 0x00000000; // register offset = 0x18c
	//g_uCSIIMGFMT 		= 0x0000001e; // register offset = 0x194 -> Commented because of register relative to Fin(MIPI CSI in)
#endif

	// DMA-IN case
	// SwRst '1' -> SwRst '0'(RESET)

#if 0
	//u32 uGlobalCtrlRegVal;
	//fimcInp32(eCh, rCIGCTRL, uGlobalCtrlRegVal);
	g_uCIGCTRL = g_uCIGCTRL |(0x1<<31);
	fimcOutp32(eCh, rCIGCTRL, g_uCIGCTRL);
	g_uCIGCTRL = g_uCIGCTRL &(~(0x1<<31));
	fimcOutp32(eCh, rCIGCTRL, g_uCIGCTRL); // Reset
#else
	//u32 uGlobalCtrlRegVal;
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL |(0x1<<31);
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL &(~(0x1<<31));
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL); // Reset
#endif

	fimcInp32(eCh, rCISTATUS, uCISTATUS);
	uCISTATUS = uCISTATUS & (~(0x1<<17));
	fimcOutp32(eCh, rCISTATUS, uCISTATUS);
}

// [Initialize IP for FIFO-in DMA-out]
void FIMC_InitIpForFinDout(FIMC_CH eCh, CAMERA eCamera,
		u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
		u32 uOutDispHsz, u32 uOutDispVsz,
		u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
		u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	DMA_OUT_MODE eDmaOutMode;
	switch(eOutImgFmt)
	{
		case RGB16_IB:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;				
			break;
		case RGB24_IB:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case NV12_IB:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case TILE_NV12_IB:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case RGB16_IW:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case RGB24_IW:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case NV12_IW:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case TILE_NV12_IW:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		default:
			eDmaOutMode = PROGRESSIVE_OUT;
			break;
	}
	
	Assert((eOutImgFmt!=BayerRGB8)&&(eOutImgFmt!=BayerRGB10)&&(eOutImgFmt!=BayerRGB12));

	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForFin(eCh);
	FIMC_SetImgEffect(eCh, EFF_BYPASS, 0, 0, AFTER_SCALING);

	// Set FIFO input mode
	FIMC_SetFinMode(eCh);

	// Select camera
	FIMC_SelCamera(eCh, eCamera);
	
	// Set FIFO in, DMA out path
	//g_ePath = FIFO_IN_DMA_OUT;
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA =  FIFO_IN_DMA_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB =  FIFO_IN_DMA_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC =  FIFO_IN_DMA_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	//======

	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, true);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);	
	
	// Set camera mode and bit
	FIMC_SetCamModeAndBit(eCh);

	// Set CMOS image sensor polarity of PCLK, VSYNC, HREF and Href_mask
	FIMC_SetInversePolarityAndHrefMask(eCh);

	// Set FIFO input image size
	FIMC_SetFinImgSize(eCh);

	// Set FIFO input image YCbCr 422 1 plane order
	FIMC_SetFinImgYCbCrOrder(eCh);

	// Set FIFO input image cropping offset
	FIMC_SetFinImgCroppingRegion(eCh, uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz);

	Assert(uOutImgHsz <= g_uCamInImgHsz); // p30
	Assert(uOutImgVsz <= g_uCamInImgVsz); // p30

	//======

	if((eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR420_2P_CBCR_BE)
	||(eOutImgFmt==TILE_NV12)
	||(eOutImgFmt==YC420))
	{
		Assert((uOutImgVsz%2) == 0); // p30
		Assert((uInImgCropVsz%2) == 0); // p23
		Assert(uInImgCropVsz >= 8); // p23
	}

	// Set FIFO input image scaler
	FIMC_SetFinImgScaler(eCh,
		uInImgCropHsz, uInImgCropVsz, uOutImgHsz, uOutImgVsz);

	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_BYPASS_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_A); // p8					
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_B); // p8					
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			Assert((uOutImgStartX+uOutImgHsz) <= uOutDispHsz);
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartY+(uOutImgVsz/2)) <= uOutDispVsz);
			}
			else
			{
				Assert((uOutImgStartY+uOutImgVsz) <= uOutDispVsz);
			}
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_A); // p8
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_B); // p8
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartX+(uOutImgVsz/2)) <= uOutDispHsz);
			}
			else
			{
				Assert((uOutImgStartX+uOutImgVsz) <= uOutDispHsz);
			}
			Assert((uOutImgStartY+uOutImgHsz) <= uOutDispVsz);
			break;
		default:
			Assert(0);
			break;
	}

	// Set output rotator and FlipMd and InFlipMd_M
	FIMC_SetOutRotAndFlip(eCh, eRotFlip);

	// Set color space conversion equation and YCbCr range
	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);

	//======

	switch(eDmaOutMode)
	{
		case PROGRESSIVE_OUT:			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);
			
			FIMC_SetOutScanMode(eCh, PROGRESSIVE);
			FIMC_SetDoutWeave(eCh, false);				
			break;
		case INTERLACE_OUT_EVEN_ODD:
			// uOutImgAddr1: EVEN start address, uOutImgAddr2: ODD start address
			FIMC_GetNextFbAddr(eOutImgFmt, uOutDispHsz, uOutDispVsz,
				uOutImgAddr1, &uOutImgAddr2);			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);

			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, false);			
			break;
		case INTERLACE_OUT_WEAVING:
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);		

			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, true);			
			break;
		default:
			Assert(0);
			break;
	}
	
	// Set DMA output display size
	FIMC_SetDoutDispSize(eCh, uOutDispHsz, uOutDispVsz);
	
	// Set DMA output image format
	FIMC_SetDoutImgFmt(eCh, eOutImgFmt);

	// Set DMA output image offset
	FIMC_SetDoutImgOffset(eCh, eOutImgFmt, uOutImgStartX, uOutImgStartY);

	// Set DMA output image size
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			if(eDmaOutMode == PROGRESSIVE_OUT)
			{
				Assert(uOutImgVsz%16 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_EVEN_ODD)
			{
				Assert(uOutImgVsz%32 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_WEAVING)
			{
				Assert(0);
			}
			else
			{
				Assert(0);
			}
			break;
		default:
			Assert(0);
			break;			
	}
	FIMC_SetDoutImgSize(eCh, uOutImgHsz, uOutImgVsz, eOutImgFmt, uOutImgLineSkip);
}

// [Initialize IP for YUV(CBYCRY)-MIPI-FIFO-in DMA-out]
void FIMC_InitIpForMFinDout(FIMC_CH eCh,
		u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
		u32 uOutDispHsz, u32 uOutDispVsz,
		u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
		u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange,
		MIPI_DATA_ALIGN eDataAlign)
{
	DMA_OUT_MODE eDmaOutMode;
	switch(eOutImgFmt)
	{
		case RGB16_IB:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;				
			break;
		case RGB24_IB:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case NV12_IB:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case TILE_NV12_IB:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_EVEN_ODD;
			break;
		case RGB16_IW:
			eOutImgFmt = RGB16;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case RGB24_IW:
			eOutImgFmt = RGB24;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case NV12_IW:
			eOutImgFmt = NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		case TILE_NV12_IW:
			eOutImgFmt = TILE_NV12;
			eDmaOutMode = INTERLACE_OUT_WEAVING;
			break;
		default:
			eDmaOutMode = PROGRESSIVE_OUT;
			break;
	}

	Assert(g_eFinInImgType==CBYCRY || g_eFinInImgType==BayerRGB8 || 
		g_eFinInImgType==BayerRGB10 || g_eFinInImgType==BayerRGB12);

	
	Assert(g_eFinMode==PROGRESSIVE_IN_FIFO);

	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForFin(eCh);
	FIMC_SetImgEffect(eCh, EFF_BYPASS, 0, 0, AFTER_SCALING);

	// Set FIFO input mode
	FIMC_SetFinMode(eCh);

	// Set camera (S5PV210 only support 'mipi camera A port')
	FIMC_SelCamera(eCh, MIPI_CAMERA_A);

	// Set FIFO in, DMA out path
	//g_ePath = FIFO_IN_DMA_OUT;
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA = FIFO_IN_DMA_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB = FIFO_IN_DMA_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC = FIFO_IN_DMA_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	//======

	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, true);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);
	
	FIMC_SetMipiImgFmtAndDataAlign(eCh, g_eFinInImgType, eDataAlign);

	// Set camera mode and bit
	FIMC_SetCamModeAndBit(eCh);

	// Set FIFO input image size
	FIMC_SetFinImgSize(eCh);

	// Set FIFO input image cropping offset
	FIMC_SetFinImgCroppingRegion(eCh, uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz);

	Assert(uOutImgHsz <= g_uCamInImgHsz); // p30
	Assert(uOutImgVsz <= g_uCamInImgVsz); // p30

	//======

	if((eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR420_2P_CBCR_BE)
	||(eOutImgFmt==TILE_NV12)
	||(eOutImgFmt==YC420))
	{
		Assert((uOutImgVsz%2) == 0); // p30
		Assert((uInImgCropVsz%2) == 0); // p23
		Assert(uInImgCropVsz >= 8); // p23
	}

	// Set FIFO input image scaler
	FIMC_SetFinImgScaler(eCh,
		uInImgCropHsz, uInImgCropVsz, uOutImgHsz, uOutImgVsz);

	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_BYPASS_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_A); // p8					
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_B); // p8					
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			Assert((uOutImgStartX+uOutImgHsz) <= uOutDispHsz);
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartY+(uOutImgVsz/2)) <= uOutDispVsz);
			}
			else
			{
				Assert((uOutImgStartY+uOutImgVsz) <= uOutDispVsz);
			}			
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_A); // p8
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_B); // p8
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			if(eDmaOutMode==INTERLACE_OUT_EVEN_ODD)
			{
				Assert((uOutImgStartX+(uOutImgVsz/2)) <= uOutDispHsz);
			}
			else
			{
				Assert((uOutImgStartX+uOutImgVsz) <= uOutDispHsz);
			}			
			Assert((uOutImgStartY+uOutImgHsz) <= uOutDispVsz);
			break;
		default:
			Assert(0);
			break;
	}

	// Set output rotator and FlipMd and InFlipMd_M
	FIMC_SetOutRotAndFlip(eCh, eRotFlip);

	// Set color space conversion equation and YCbCr range
	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);

	//======

	switch(eDmaOutMode)
	{
		case PROGRESSIVE_OUT:			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);
			
			FIMC_SetOutScanMode(eCh, PROGRESSIVE);
			FIMC_SetDoutWeave(eCh, false);				
			break;
		case INTERLACE_OUT_EVEN_ODD:
			// uOutImgAddr1: EVEN start address, uOutImgAddr2: ODD start address
			FIMC_GetNextFbAddr(eOutImgFmt, uOutDispHsz, uOutDispVsz,
				uOutImgAddr1, &uOutImgAddr2);			
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);

			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, false);			
			break;
		case INTERLACE_OUT_WEAVING:
			// Set DMA output display start address
			FIMC_SetDoutDispAddr(eCh,
				uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
				eOutImgFmt, uOutDispHsz, uOutDispVsz);		

			FIMC_SetOutScanMode(eCh, INTERLACED);
			FIMC_SetDoutWeave(eCh, true);			
			break;
		default:
			Assert(0);
			break;
	}

	// Set DMA output display size
	FIMC_SetDoutDispSize(eCh, uOutDispHsz, uOutDispVsz);
	
	// Set DMA output image format
	FIMC_SetDoutImgFmt(eCh, eOutImgFmt);

	// Set DMA output image offset
	FIMC_SetDoutImgOffset(eCh, eOutImgFmt, uOutImgStartX, uOutImgStartY);

	// Set DMA output image size
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			if(eDmaOutMode == PROGRESSIVE_OUT)
			{
				Assert(uOutImgVsz%16 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_EVEN_ODD)
			{
				Assert(uOutImgVsz%32 == 0);
			}
			else if(eDmaOutMode == INTERLACE_OUT_WEAVING)
			{
				Assert(0);
			}
			else
			{
				Assert(0);
			}
			break;
		default:
			Assert(0);
			break;			
	}
	FIMC_SetDoutImgSize(eCh, uOutImgHsz, uOutImgVsz, eOutImgFmt, uOutImgLineSkip);
}

// [Initialize IP for DIRECT-FIFO-in DMA-out]
void FIMC_InitIpForDFinDout(FIMC_CH eCh,
		u32 uInImgHsz, u32 uInImgVsz,
		//u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
		u32 uOutDispHsz, u32 uOutDispVsz,
		u32 uOutImgStartX, u32 uOutImgStartY, u32 uOutImgHsz, u32 uOutImgVsz, u32 uOutImgLineSkip,
		u32 uOutImgAddr1, u32 uOutImgAddr2, IMG_FMT eOutImgFmt,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	// Initialize rCIGCTRL register
	//g_uCIGCTRL	= 0x20010080; // register offset = 0x08 -> instead of FIMC_InitCamera()

	g_eCcir = CCIR601; // for FIMC_ResetIpForFin()
	g_eFinMode = PROGRESSIVE_IN_FIFO; // for FIMC_SetFinMode()
	g_uCamInImgHsz = uInImgHsz, g_uCamInImgVsz = uInImgVsz; // for FIMC_SetFinImgSize()
	g_eFinInImgType = YC444;

	//----------------------------

	//Assert((eOutImgFmt==NV12)||(eOutImgFmt==TILE_NV12)); // for VP
	
	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForFin(eCh);
	FIMC_SetImgEffect(eCh, EFF_BYPASS, 0, 0, AFTER_SCALING);

	// Set FIFO input mode
	FIMC_SetFinMode(eCh);
	
	// Set DIRECT-FIFO in, DMA out path
	//g_ePath = DIRECT_FIFO_IN_DMA_OUT;
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA = DIRECT_FIFO_IN_DMA_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB = DIRECT_FIFO_IN_DMA_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC = DIRECT_FIFO_IN_DMA_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	//======

	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, true);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);	
	
	// Set camera mode and bit
	//FIMC_SetCamModeAndBit(eCh);

	// Set CMOS image sensor polarity of PCLK, VSYNC, HREF and Href_mask
	//FIMC_SetInversePolarityAndHrefMask(eCh);

	// Set FIFO input image size
	FIMC_SetFinImgSize(eCh);

	// Set FIFO input image YCbCr 422 1 plane order
	//FIMC_SetFinImgYCbCrOrder(eCh);

	// Set FIFO input image cropping offset
#if 0
	FIMC_SetFinImgCroppingRegion(eCh, uInImgCropStartX, uInImgCropStartY, uInImgCropHsz, uInImgCropVsz);
#else
	FIMC_SetFinImgCroppingRegion(eCh, 0, 0, uInImgHsz, uInImgVsz);
#endif

	Assert(uOutImgHsz <= g_uCamInImgHsz); // p30
	Assert(uOutImgVsz <= g_uCamInImgVsz); // p30

	//======

	if((eOutImgFmt==NV12) // YCBCR420_2P_CRCB_LE
	||(eOutImgFmt==YCBCR420_2P_CBCR_LE)
	||(eOutImgFmt==YCBCR420_2P_CRCB_BE)
	||(eOutImgFmt==YCBCR420_2P_CBCR_BE)
	||(eOutImgFmt==TILE_NV12)
	||(eOutImgFmt==YC420))
	{
		Assert((uOutImgVsz%2) == 0); // p30
#if 0		
		Assert((uInImgCropVsz%2) == 0); // p23
		Assert(uInImgCropVsz >= 8); // p23
#else
		Assert((uInImgVsz%2) == 0); // p23
		Assert(uInImgVsz >= 8); // p23
#endif
	}

	// Set FIFO input image scaler
#if 0	
	FIMC_SetFinImgScaler(eCh, uInImgCropHsz, uInImgCropVsz, uOutImgHsz, uOutImgVsz);
#else
	FIMC_SetFinImgScaler(eCh, uInImgHsz, uInImgVsz, uOutImgHsz, uOutImgVsz);
#endif

	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_BYPASS_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_A); // p8					
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_B); // p8					
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_BP_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			Assert((uOutImgStartX+uOutImgHsz) <= uOutDispHsz);
			Assert((uOutImgStartY+uOutImgVsz) <= uOutDispVsz);
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			//Assert(uOutImgHsz <= OUTPUT_ROTATOR_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_A); // p8
					break;
				case FIMC_B:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_B); // p8
					break;
				case FIMC_C:
					Assert(uOutImgHsz <= OUTROT_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}			
			Assert((uOutImgStartX+uOutImgVsz) <= uOutDispHsz);				
			Assert((uOutImgStartY+uOutImgHsz) <= uOutDispVsz);
			break;
		default:
			Assert(0);
			break;
	}

	// Set output rotator and FlipMd and InFlipMd_M
	FIMC_SetOutRotAndFlip(eCh, eRotFlip);

	// Set color space conversion equation and YCbCr range
	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);

	//======

	// Set DMA output display start address
	FIMC_SetDoutDispAddr(eCh,
		uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
		eOutImgFmt, uOutDispHsz, uOutDispVsz);
	
	// Set DMA output display size
	FIMC_SetDoutDispSize(eCh, uOutDispHsz, uOutDispVsz);
	
	// Set DMA output image format
	FIMC_SetDoutImgFmt(eCh, eOutImgFmt);

	// Set DMA output image offset
	FIMC_SetDoutImgOffset(eCh, eOutImgFmt, uOutImgStartX, uOutImgStartY);

	// Set DMA output image size
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO:
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			break;
		case ROT_90_FLIP_NO:
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY:
			Assert(uOutImgHsz%16 == 0);
			Assert(uOutImgVsz%16 == 0);
			break;
		default:
			Assert(0);
			break;			
	}	
	FIMC_SetDoutImgSize(eCh, uOutImgHsz, uOutImgVsz, eOutImgFmt, uOutImgLineSkip);
}

// [Initialize IP for JPEG-FIFO-in DMA-out]
void FIMC_InitIpForJFinDout(FIMC_CH eCh, CAMERA eCamera, u32 uOutImgAddr1, u32 uOutImgAddr2)
{
	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForFin(eCh);
	
	// Set FIFO input mode
	FIMC_SetFinMode(eCh);

	// Select camera
	FIMC_SelCamera(eCh, eCamera);
	
	// Set FIFO in, DMA out path
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA =  FIFO_IN_DMA_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB =  FIFO_IN_DMA_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC =  FIFO_IN_DMA_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	//======

	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, true);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);	
	
	// Set camera mode and bit
	//FIMC_SetCamModeAndBit(eCh); // Refer to the 'FIMC_StartProcessingForJpegInput()'

	// Set CMOS image sensor polarity of PCLK, VSYNC, HREF and Href_mask
	FIMC_SetInversePolarityAndHrefMask(eCh);

	//======
			
	// Set DMA output display start address
	FIMC_SetDoutDispAddr(eCh,
		uOutImgAddr1, uOutImgAddr2, uOutImgAddr1, uOutImgAddr2, 
		//eOutImgFmt, uOutDispHsz, uOutDispVsz);
		RGB24, 0, 0);
	
	FIMC_SetOutScanMode(eCh, PROGRESSIVE);
	FIMC_SetDoutWeave(eCh, false);
}

// [Set MIPI image format and data align]
static void FIMC_SetMipiImgFmtAndDataAlign(FIMC_CH eCh, 
	IMG_FMT eMipiImgFmt, MIPI_DATA_ALIGN eDataAlign)
{
	u32 uCSIIMGFMT;
	
	fimcInp32(eCh, rCSIIMGFMT, uCSIIMGFMT);
	
	uCSIIMGFMT = uCSIIMGFMT & (~(0x3f<<0));
	switch(eMipiImgFmt)
	{
		case CBYCRY:
			uCSIIMGFMT = uCSIIMGFMT |(0x1e<<0);
			break;
		case BayerRGB8:
			uCSIIMGFMT = uCSIIMGFMT |(0x2a<<0);
			break;
		case BayerRGB10:
			uCSIIMGFMT = uCSIIMGFMT |(0x2b<<0);
			break;
		case BayerRGB12:
			uCSIIMGFMT = uCSIIMGFMT |(0x2c<<0);
			break;
		default:
			Assert(0);
			break;
	}

	switch(eDataAlign)
	{
		case MIPI_24BIT_ALIGN:
			uCSIIMGFMT = uCSIIMGFMT & (~(0x3<<8));
			break;
		case MIPI_32BIT_ALIGN:
			uCSIIMGFMT = uCSIIMGFMT & (~(0x3<<8));
			uCSIIMGFMT = uCSIIMGFMT |(0x1<<8);
			break;
		default:
			Assert(0);
			break;
	}
	
	fimcOutp32(eCh, rCSIIMGFMT, uCSIIMGFMT);
}

// [Set test pattern]
void FIMC_SetTestPattern(FIMC_CH eCh, TEST_PATTERN eTestPattern)
{
	u32 uCIGCTRL;
	u32 uPattern;

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL & (~(0x3<<27));

	switch(eTestPattern)
	{
		case EXTERNAL_CAMERA_INPUT:
			uPattern = 0x0;
			break;
		case COLOR_BAR:
			uPattern = 0x1;
			break;
		case HORIZONTAL_INCREMENT:
			uPattern = 0x2;
			break;
		case VERTICAL_INCREMENT:
			uPattern = 0x3;
			break;
		default:
			Assert(0);
			break;
	}

	if(eTestPattern != EXTERNAL_CAMERA_INPUT)
	{
		// p24
		Assert(g_uCamInImgHsz == 640);
		Assert(g_uCamInImgVsz == 480);
		
		Assert((g_eCcir==CCIR601)&&(g_uIfBits==8));
	}

	uCIGCTRL = uCIGCTRL |(uPattern<<27);
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Set camera mode and bit]
static void FIMC_SetCamModeAndBit(FIMC_CH eCh)
{
	u32 uCIGCTRL;
	u32 uCISRCFMT;
	
	if((g_eCcir==CCIR601)&&(g_uIfBits==8))
	{
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL & (~(0x1<<3)); // ITU camera
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
		
		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);		
		uCISRCFMT = uCISRCFMT |(0x1<<31); // ITU-R BT.601 YCbCr 8-bit mode enable
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);
	}
	else if((g_eCcir==CCIR656)&&(g_uIfBits==8))
	{
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL & (~(0x1<<3)); // ITU camera
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
		
		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);		
		uCISRCFMT = uCISRCFMT & (~(0x1<<31)); // ITU-R BT.656 YCbCr 8-bit mode enable
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);	
	}
	else if((g_eCcir==CCIR601)&&(g_uIfBits==16))
	{
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL & (~(0x1<<3)); // ITU camera
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);	
		
		fimcInp32(eCh, rCISRCFMT, uCISRCFMT);		
		uCISRCFMT = uCISRCFMT |(0x1<<29); // ITU-R BT601 YCbCr 16-bit mode enable
		fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);
	}
	else if((g_eCcir==MIPI)&&(g_uIfBits==8))
	{
		fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
		uCIGCTRL = uCIGCTRL |(0x1<<3); // MIPI camera
		fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);				
	}
	else
	{
		Assert(0);
	}	
}

// [Set inverse polarity and Href mask]
static void FIMC_SetInversePolarityAndHrefMask(FIMC_CH eCh)
{
	u32 uCIGCTRL;
	
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	uCIGCTRL = uCIGCTRL & (~(0x7<<24));
	uCIGCTRL = uCIGCTRL |(g_uInvPclk<<26);
	uCIGCTRL = uCIGCTRL |(g_uInvVsync<<25);
	uCIGCTRL = uCIGCTRL |(g_uInvHref<<24);
	uCIGCTRL = uCIGCTRL |(0x1<<21); // To ignore Href signal during Vsync high
	uCIGCTRL = uCIGCTRL |(g_uInvField<<1);
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Set FIFO-in mode]
static void FIMC_SetFinMode(FIMC_CH eCh)
{
	u32 uCIGCTRL;
		
	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	switch(g_eFinMode)
	{
		case PROGRESSIVE_IN_FIFO:
			uCIGCTRL = uCIGCTRL & (~(0x1<<0)); // Progressive
			break;
		case INTERLACE_IN_ITU601_FIELD:
			Assert(g_eCcir == CCIR601);
			uCIGCTRL = uCIGCTRL |(0x1<<2); // ITU601, field mode
			uCIGCTRL = uCIGCTRL |(0x1<<0); // Interlace
			break;
		case INTERLACE_IN_ITU601_HSYNC:
			Assert(g_eCcir == CCIR601);
			uCIGCTRL = uCIGCTRL & (~(0x1<<2)); // ITU601, Hsync mode
			uCIGCTRL = uCIGCTRL |(0x1<<0); // Interlace
			break;
		case INTERLACE_IN_ITU656:
			Assert(g_eCcir == CCIR656);
			uCIGCTRL = uCIGCTRL |(0x1<<0); // Interlace
			break;
		default:
			Assert(0);
			break;			
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Set FIFO-in overflow interrupt]
static void FIMC_SetFinOvfInt(FIMC_CH eCh, u8 bEnable)
{
	u32 uCIGCTRL;
	u32 uCIWDOFST;
	u32 uCISTATUS;

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	switch(bEnable)
	{
		case true:
			uCIGCTRL = uCIGCTRL |(0x1<<22); // Overflow interrupt enable
			break;
		case false:
			uCIGCTRL = uCIGCTRL & (~(0x1<<22)); // Overflow interrupt disable
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);

	if(bEnable == true)
	{
		fimcInp32(eCh, rCIWDOFST, uCIWDOFST);
		uCIWDOFST = uCIWDOFST |(0x1<<30); // Clear the overflow indication flag of input FIFO Y
		uCIWDOFST = uCIWDOFST |(0x1<<29); // Clear the overflow indication flag of line buffer for rotation
		uCIWDOFST = uCIWDOFST |(0x1<<15); // Clear the overflow indication flag of input FIFO Cb
		uCIWDOFST = uCIWDOFST |(0x1<<14); // Clear the overflow indication flag of input FIFO Cr
		fimcOutp32(eCh, rCIWDOFST, uCIWDOFST);
		
		fimcInp32(eCh, rCISTATUS, uCISTATUS);
		for(;;)
		{
			if(((uCISTATUS&0x80000000)==0x0) // [31]: Overflow state of FIFO Y
			&& ((uCISTATUS&0x40000000)==0x0) // [30]: Overflow state of FIFO Cb
			&& ((uCISTATUS&0x20000000)==0x0) // [29]: Overflow state of FIFO Cr
			&& ((uCISTATUS&0x40000)==0x0)) // [18]: Overflow status of line buffer for rotation
			{
				break;
			}
		}

		fimcInp32(eCh, rCIWDOFST, uCIWDOFST);
		uCIWDOFST = uCIWDOFST & (~(0x1<<30)); // Set normal (input FIFO Y)
		uCIWDOFST = uCIWDOFST & (~(0x1<<29)); // Set normal (line buffer for rotation)
		uCIWDOFST = uCIWDOFST & (~(0x1<<15)); // Set normal (input FIFO Cb)
		uCIWDOFST = uCIWDOFST & (~(0x1<<14)); // Set normal (input FIFO Cr)
		fimcOutp32(eCh, rCIWDOFST, uCIWDOFST);	
	}
}

// [Set FIFO-in image size]
static void FIMC_SetFinImgSize(FIMC_CH eCh)
{
	u32 uCIEXTEN;
	u32 uCISRCFMT;
	
	u32 uInImgHszLowBits;
	u32 uInImgHszHighBit;

	Assert(g_uCamInImgHsz%16 == 0); //p8
	
	uInImgHszLowBits = g_uCamInImgHsz & 0x1fff;
	uInImgHszHighBit = g_uCamInImgHsz & 0x2000;
	uInImgHszHighBit = uInImgHszHighBit >> 13;
	uInImgHszHighBit = uInImgHszHighBit & 0x1;

	fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
	uCIEXTEN = uCIEXTEN & (~(0x1<<30));
	uCIEXTEN = uCIEXTEN |(uInImgHszHighBit<<30);
	fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);

	fimcInp32(eCh, rCISRCFMT, uCISRCFMT);
	uCISRCFMT = uCISRCFMT & (~(0x1fff)<<16);
	uCISRCFMT = uCISRCFMT |(uInImgHszLowBits<<16);

	uCISRCFMT = uCISRCFMT & (~(0x3fff)<<0);
	uCISRCFMT = uCISRCFMT |(g_uCamInImgVsz<<0);
	fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);	
}

// [Get FIFO-in image size]
void FIMC_GetFinImgSize(u32* uFinImgHsz, u32* uFinImgVsz)
{
	*uFinImgHsz = g_uCamInImgHsz;
	*uFinImgVsz = g_uCamInImgVsz;
}

// [Set FIFO-in image YCbCr order]
void FIMC_SetFinImgYCbCrOrder(FIMC_CH eCh)
{
	u32 uCISRCFMT;
	
	u32 uFifoInputYCbCr422Order;

	if(g_uIfBits == 8)
	{
		switch(g_eFinInImgType)
		{
			case YCBYCR:
				uFifoInputYCbCr422Order = 0x0;
				break;
			case YCRYCB:
				uFifoInputYCbCr422Order = 0x1;
				break;			
			case CBYCRY:
				uFifoInputYCbCr422Order = 0x2;
				break;
			case CRYCBY:
				uFifoInputYCbCr422Order = 0x3;
				break;		
			default:
				Assert(0);
				break;
		}
	}
	else if(g_uIfBits == 16)
	{
		switch(g_eFinInImgType)
		{
			case YCBYCR:
				uFifoInputYCbCr422Order = 0x0;
				break;
			case YCRYCB:
				uFifoInputYCbCr422Order = 0x1;
				break;			
			default:
				Assert(0);
				break;
		}
	}
	else
	{
		Assert(0);
	}
	
	fimcInp32(eCh, rCISRCFMT, uCISRCFMT);
	uCISRCFMT = uCISRCFMT & (~(0x3<<14));
	uCISRCFMT = uCISRCFMT |(uFifoInputYCbCr422Order<<14);
	fimcOutp32(eCh, rCISRCFMT, uCISRCFMT);	
}

// [Set FIFO-in image cropping region]
void FIMC_SetFinImgCroppingRegion(FIMC_CH eCh,
	u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz)
{
	u32 uCIWDOFST;
	u32 uCIEXTEN;
	u32 uCIWDOFST2;
	
	u32 uWinHorOfstLowBits;
	u32 uWinHorOfstHighBit;
	u32 uWinHorOfst2;
	u32 uWinVerOfst2;	

	Assert((uInImgCropStartX+uInImgCropHsz) <= g_uCamInImgHsz);
	Assert((uInImgCropStartY+uInImgCropVsz) <= g_uCamInImgVsz);
	
	Assert(uInImgCropStartX%2 == 0); //p22
	Assert(uInImgCropHsz%16 == 0); //p22
	Assert(uInImgCropHsz >= 16); //p26

	// Window offset disable
	if((uInImgCropStartX==0)&&(uInImgCropStartY==0)&&
		(g_uCamInImgHsz==uInImgCropHsz)&&(g_uCamInImgVsz==uInImgCropVsz))
	{
		fimcInp32(eCh, rCIWDOFST, uCIWDOFST);
		uCIWDOFST = uCIWDOFST & (~(0x1<<31));
		fimcOutp32(eCh, rCIWDOFST, uCIWDOFST);
	}
	// Window offset enable
	else
	{
		fimcInp32(eCh, rCIWDOFST, uCIWDOFST);
		uCIWDOFST = uCIWDOFST |(0x1<<31);
		
		uWinHorOfstLowBits = uInImgCropStartX & 0x7ff;
		uWinHorOfstHighBit = uInImgCropStartX & 0x800;
		uWinHorOfstHighBit = uWinHorOfstHighBit >> 11;
		uWinHorOfstHighBit = uWinHorOfstHighBit & 0x1;

		uCIWDOFST = uCIWDOFST & (~(0x7ff<<16));
		uCIWDOFST = uCIWDOFST |(uWinHorOfstLowBits<<16);

		uCIWDOFST = uCIWDOFST & (~(0xfff<<0));
		uCIWDOFST = uCIWDOFST |(uInImgCropStartY<<0);
		fimcOutp32(eCh, rCIWDOFST, uCIWDOFST);

		fimcInp32(eCh, rCIEXTEN, uCIEXTEN);
		uCIEXTEN = uCIEXTEN & (~(0x1<<28));
		uCIEXTEN = uCIEXTEN |(uWinHorOfstHighBit<<28);
		fimcOutp32(eCh, rCIEXTEN, uCIEXTEN);

		uWinHorOfst2 = g_uCamInImgHsz - uInImgCropStartX - uInImgCropHsz;	
		Assert(uWinHorOfst2%2 == 0);	
		
		uWinVerOfst2 = g_uCamInImgVsz - uInImgCropStartY - uInImgCropVsz;

		fimcInp32(eCh, rCIWDOFST2, uCIWDOFST2);
		uCIWDOFST2 = uCIWDOFST2 & (~(0xfff<<16));
		uCIWDOFST2 = uCIWDOFST2 |(uWinHorOfst2<<16);
		uCIWDOFST2 = uCIWDOFST2 & (~(0xfff<<0));
		uCIWDOFST2 = uCIWDOFST2 |(uWinVerOfst2<<0);
		fimcOutp32(eCh, rCIWDOFST2, uCIWDOFST2);
	}	
}

// [Set FIFO-in image scaler]
void FIMC_SetFinImgScaler(FIMC_CH eCh,
	u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz)
{
	u32 uCISCPRERATIO;
	u32 uCISCPREDST;
	u32 uCISCCTRL;
	
	u32 uHScaleFlag;
	u32 uVScaleFlag;
	u32 uPreHRatio, uHShift;
	u32 uPreVRatio, uVShift;
	u32 uShiftFactor;
	u32 uPreDstHSz;
	u32 uPreDstVSz;
	u32 uMainHRatio;
	u32 uMainVRatio;

	if(uInImgCropHsz <= uOutImgHsz)
	{
		uHScaleFlag = 0x1; // Horizontal scale UP
	}
	else
	{
		uHScaleFlag = 0x0; // Horizontal scale DOWN
	}

	if(uInImgCropVsz <= uOutImgVsz)
	{
		uVScaleFlag = 0x1; // Vertical scale UP
	}
	else
	{
		uVScaleFlag = 0x0; // Vertical scale DOWN
	}

	FIMC_GetPreRatioAndShift(uInImgCropHsz, uOutImgHsz, &uPreHRatio, &uHShift);
	Assert((uInImgCropHsz%(4*uPreHRatio)) == 0); // p23, p21
	
	FIMC_GetPreRatioAndShift(uInImgCropVsz, uOutImgVsz, &uPreVRatio, &uVShift);
	if(uVScaleFlag == 0x0) // Vertical scale DOWN
	{
		Assert((uInImgCropVsz%uPreVRatio) == 0); // p23, p21
	}

	uShiftFactor = 10 - (uHShift + uVShift);

	uPreDstHSz = uInImgCropHsz/uPreHRatio;
	switch(eCh)
	{
		case FIMC_A:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_A); // p8
			break;
		case FIMC_B:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_B); // p8
			break;
		case FIMC_C:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_C); // p8
			break;
		default:
			Assert(0);
			break;
	}		
	uPreDstVSz = uInImgCropVsz/uPreVRatio;
	
	uMainHRatio = (uInImgCropHsz<<8)/(uOutImgHsz<<uHShift);
	uMainVRatio = (uInImgCropVsz<<8)/(uOutImgVsz<<uVShift);

	fimcInp32(eCh, rCISCPRERATIO, uCISCPRERATIO);
	uCISCPRERATIO = uCISCPRERATIO & (~(0xf<<28));
	uCISCPRERATIO = uCISCPRERATIO |(uShiftFactor<<28);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<16));
	uCISCPRERATIO = uCISCPRERATIO |(uPreHRatio<<16);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<0));
	uCISCPRERATIO = uCISCPRERATIO |(uPreVRatio<<0);
	fimcOutp32(eCh, rCISCPRERATIO, uCISCPRERATIO);

	fimcInp32(eCh, rCISCPREDST, uCISCPREDST);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<16));
	uCISCPREDST = uCISCPREDST |(uPreDstHSz<<16);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<0));
	uCISCPREDST = uCISCPREDST |(uPreDstVSz<<0);
	fimcOutp32(eCh, rCISCPREDST, uCISCPREDST);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL & (~(0x1<<30));
	uCISCCTRL = uCISCCTRL |(uHScaleFlag<<30);
	uCISCCTRL = uCISCCTRL & (~(0x1<<29));
	uCISCCTRL = uCISCCTRL |(uVScaleFlag<<29);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<16));
	uCISCCTRL = uCISCCTRL |(uMainHRatio<<16);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<0));
	uCISCCTRL = uCISCCTRL |(uMainVRatio<<0);	
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);	
}

static void FIMC_SetFinShadowUpdate(FIMC_CH eCh, u8 bEnable)
{
	u32 uCIGCTRL;

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);
	switch(bEnable)
	{
		case false:
			uCIGCTRL = uCIGCTRL |(0x1<<12); // Shadow update DISABLE
			break;
		case true:
			uCIGCTRL = uCIGCTRL & (~(0x1<<12)); // Shadow update ENABLE
			break;
		default:
			Assert(0);
			break;	
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);
}

// [Set scalerBypass]
static void FIMC_SetScalerBypass(FIMC_CH eCh, u8 bEnable)
{
	u32 uCISCCTRL;
	
	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	if(bEnable == true)
	{
		uCISCCTRL = uCISCCTRL |(0x1<<31);
	}
	else if(bEnable == false)
	{
		uCISCCTRL = uCISCCTRL & (~(0x1<<31));
	}
	else
	{
		Assert(0);
	}
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
}

void FIMC_SetFinIrq(FIMC_CH eCh, u8 bEnableOfFrameStart, u8 bEnableOfFrameEnd)
{
	u32 uCIGCTRL;

	fimcInp32(eCh, rCIGCTRL, uCIGCTRL);	
	switch(bEnableOfFrameStart)
	{
		case true:
			uCIGCTRL = uCIGCTRL & (~(0x1<<17)); // Interrupt enable at frame start point
			break;
		case false:
			uCIGCTRL = uCIGCTRL |(0x1<<17); // Interrupt disable at frame start point
			break;
		default:
			Assert(0);
			break;
	}
	switch(bEnableOfFrameEnd)
	{
		case true:
			uCIGCTRL = uCIGCTRL |(0x1<<18); // Interrupt enable at frame end point
			break;
		case false:
			uCIGCTRL = uCIGCTRL & (~(0x1<<18)); // Interrupt disable at frame end point
			break;
		default:
			Assert(0);
			break;
	}
	fimcOutp32(eCh, rCIGCTRL, uCIGCTRL);		
}

// [Get interrupt source]
void FIMC_GetIntrSrc(FIMC_CH eCh, FIMC_INTR_SRC* eSrc)
{
	u32 uCISTATUS;

	FIMC_PATH ePath;
	switch(eCh)
{
		case FIMC_A:
			ePath = g_ePathOfFimcA;
			break;
		case FIMC_B:
			ePath = g_ePathOfFimcB;
			break;
		case FIMC_C:
			ePath = g_ePathOfFimcC;
			break;
		default:
			Assert(0);
			break;
	}

	if(ePath == FIFO_IN_DMA_OUT)
	{
		fimcInp32(eCh, rCISTATUS, uCISTATUS);
		if((uCISTATUS & 0x80000000)==0x80000000)
		{
			*eSrc = FIFO_Y_OVF;
		}
		else if((uCISTATUS & 0x40000000)==0x40000000)
		{
			*eSrc = FIFO_CB_OVF;
		}
		else if((uCISTATUS & 0x20000000)==0x20000000)
		{
			*eSrc = FIFO_CR_OVF;
		}
		else if((uCISTATUS & 0x40000)==0x40000)
		{
			*eSrc = ROT_LINE_BUF_OVF;
		}
		else
		{
			*eSrc = FIMC_SUCCESS;
		}
	}
	else
	{
		*eSrc = FIMC_SUCCESS;
	}
}

// [Pre-process for last frame capture]
// Interrupt case: preprocessing for capturing last frame
// Polling case: nothing special
void FIMC_PreProcessForLastFrmCpt(FIMC_CH eCh)
{
	u32 uCIOCTRL;
	u32 uCIIMGCPT;
		
	FIMC_SetFinShadowUpdate(eCh, false);	

#ifndef FIMC_POLLING
	fimcInp32(eCh, rCIOCTRL, uCIOCTRL);
	uCIOCTRL = uCIOCTRL |(0x1<<2); // (2) LastIRQEn = 'high'
	fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);
#endif

	fimcInp32(eCh, rCIIMGCPT, uCIIMGCPT);
	uCIIMGCPT = uCIIMGCPT & (~(0x1<<31)); // (3) ImgCptEn = 'low"
	fimcOutp32(eCh, rCIIMGCPT, uCIIMGCPT);

#ifndef FIMC_POLLING
	fimcInp32(eCh, rCIOCTRL, uCIOCTRL);
	uCIOCTRL = uCIOCTRL & (~(0x1<<2)); // (4) LastIRQEn = 'low'
	fimcOutp32(eCh, rCIOCTRL, uCIOCTRL);	
#endif

	FIMC_SetFinShadowUpdate(eCh, true); 
}

// [Initialize for DMA-in FIFO-out]
void FIMC_InitIpForDinFout(FIMC_CH eCh,
		u32 uInImgHsz, u32 uInImgVsz, u32 uInImgLineSkip,
		u32 uInImgCropStartX, u32 uInImgCropStartY, u32 uInImgCropHsz, u32 uInImgCropVsz,
		u32 uInImgAddr, IMG_FMT eInImgFmt, u8 bFifoCtrl,
		u32 uOutImgHsz, u32 uOutImgVsz, LOCAL_IF_TYPE eOutLocalType, SCAN_MODE eOutScanMode,
		ROT_FLIP eRotFlip, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	u32 i;
	u32 uYSize, uCbSize, uCrSize;

	DMA_IN_MODE eDmaInMode;
	switch(eInImgFmt)
	{
		case RGB16_IB:
		case RGB24_IB:
		case NV12_IB:
		case TILE_NV12_IB:
		case RGB16_IW:
		case RGB24_IW:
		case NV12_IW:
			Assert(0);
			break;
		case TILE_NV12_IW:
			eInImgFmt = TILE_NV12;
			eDmaInMode = INTERLACE_IN_WEAVING;		
			
			Assert(eOutScanMode==INTERLACED); // weave-in & interlace-out
			break;
		default:
			eDmaInMode = PROGRESSIVE_IN_DMA;
			break;
	}

	// Reset camera interface(CAMIF) IP
	FIMC_ResetIpForDin(eCh);
	FIMC_SetScalerBypass(eCh, false);
	FIMC_SetImgEffect(eCh, EFF_BYPASS, 0, 0, AFTER_SCALING);	
	
	// Set DMA in, FIFO out path
	//g_ePath = DMA_IN_FIFO_OUT;
	switch(eCh)
	{
		case FIMC_A:
			g_ePathOfFimcA = DMA_IN_FIFO_OUT;
			break;
		case FIMC_B:
			g_ePathOfFimcB = DMA_IN_FIFO_OUT;
			break;
		case FIMC_C:
			g_ePathOfFimcC = DMA_IN_FIFO_OUT;
			break;
		default:
			Assert(0);
			break;
	}
	FIMC_SetPath(eCh);

	//======

	// Set overflow interrupt
	FIMC_SetFinOvfInt(eCh, false);

	// Set interrupt
	FIMC_SetInterrupt(eCh, LEVEL);
		
	Assert((uInImgCropStartX+uInImgCropHsz) <= uInImgHsz);
	Assert((uInImgCropStartY+uInImgCropVsz) <= uInImgVsz);

	// Set DMA input image start address
	FIMC_SetDinImgAddr(eCh, uInImgAddr, eInImgFmt, uInImgHsz, uInImgVsz);
	
	// Set DMA input image size
	FIMC_SetDinImgSize(eCh, uInImgHsz, uInImgVsz, eInImgFmt, uInImgLineSkip);

	// Set DMA input image format
	FIMC_SetDinImgFmt(eCh, eInImgFmt);

	// Set DMA input FIFO control
	FIMC_SetDinFifoCtrl(eCh, bFifoCtrl);

	// Set DMA input mode
	FIMC_SetDinMode(eCh, eDmaInMode);
	
	// Set DMA input image cropping offset
	FIMC_SetDinImgCroppingOffset(eCh, eInImgFmt, uInImgCropStartX, uInImgCropStartY);
	
	// Set DMA input image cropping size	
	FIMC_SetDinImgCroppingSize(eCh, uInImgCropHsz, uInImgCropVsz);	

	//======
	
	// Set input rotator and InFlipMd_M and DMA input image scaler
	// Order: Input rotator -> Scaler
	FIMC_SetInRotAndFlipAndDinImgScaler(eCh,
		eInImgFmt, eRotFlip,
		uInImgCropHsz, uInImgCropVsz, uOutImgHsz, uOutImgVsz);

	// Set color space conversion equation and YCbCr range
	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);	

	//======

	// Set FIFO output image format
	FIMC_SetFoutImgFmt(eCh, eOutLocalType);

	// Set FIFO output image size
	FIMC_SetFoutImgSize(eCh, uOutImgHsz, uOutImgVsz);

	// Set output scan mode
	FIMC_SetOutScanMode(eCh, eOutScanMode);
}

// [Set input rotator and flip and DMA-in image scaler]
static void FIMC_SetInRotAndFlipAndDinImgScaler(FIMC_CH eCh, 
	IMG_FMT eInImgFmt, ROT_FLIP eRotFlip, 
	u32 uInImgCropHsz, u32 uInImgCropVsz, u32 uOutImgHsz, u32 uOutImgVsz)
{
	u32 uCITRGFMT;
	u32 uMSCTRL;
	u32 uCISCPRERATIO;
	u32 uCISCPREDST;
	u32 uCISCCTRL;
	
	u32 uTemp;
	u32 uHScaleFlag;
	u32 uVScaleFlag;
	u32 uPreHRatio, uHShift;
	u32 uPreVRatio, uVShift;
	u32 uShiftFactor;
	u32 uPreDstHSz;
	u32 uPreDstVSz;
	u32 uMainHRatio;
	u32 uMainVRatio;

	// Set input rotator	
	u32 uRotDeg, uFlip;
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO: // 0 degree
			uRotDeg = 0x0;
			uFlip = 0x0;				
			break;
		case ROT_NO_FLIP_X:
			uRotDeg = 0x0;
			uFlip = 0x1;				
			break;
		case ROT_NO_FLIP_Y:
			uRotDeg = 0x0;
			uFlip = 0x2;				
			break;	
		case ROT_NO_FLIP_XY: // 180 degree
			uRotDeg = 0x0;
			uFlip = 0x3;				
			break;
		case ROT_90_FLIP_NO: // 90 degree
			uRotDeg = 0x1;
			uFlip = 0x0;				
			break;			
		case ROT_90_FLIP_X:
			uRotDeg = 0x1;
			uFlip = 0x1;				
			break;		
		case ROT_90_FLIP_Y:
			uRotDeg = 0x1;
			uFlip = 0x2;				
			break;	
		case ROT_90_FLIP_XY: // 270 degree
			uRotDeg = 0x1;
			uFlip = 0x3;				
			break;
		default:
			Assert(0);
			break;
	}

	fimcInp32(eCh, rCITRGFMT, uCITRGFMT);
	uCITRGFMT = uCITRGFMT & (~(0x1<<13)); // Output rotator bypass
	uCITRGFMT = uCITRGFMT & (~(0x1<<31));
	uCITRGFMT = uCITRGFMT |(uRotDeg<<31);
	fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);

	fimcInp32(eCh, rMSCTRL, uMSCTRL);
	uMSCTRL = uMSCTRL & (~(0x3<<13));
	uMSCTRL = uMSCTRL |(uFlip<<13);
	fimcOutp32(eCh, rMSCTRL, uMSCTRL);	

	//======
	
	// Scaler needs following exception because of input rotator
	switch(eRotFlip)
	{
		case ROT_NO_FLIP_NO: // 0 degree
		case ROT_NO_FLIP_X:
		case ROT_NO_FLIP_Y:
		case ROT_NO_FLIP_XY: // 180 degree
			//Assert(uInImgCropHsz <= INPUT_ROTATOR_BYPASS_INPUT_MAX_HSIZE); // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uInImgCropHsz <= INROT_BP_IN_MAX_HSZ_A); // p8
					break;
				case FIMC_B:
					Assert(uInImgCropHsz <= INROT_BP_IN_MAX_HSZ_B); // p8
					break;
				case FIMC_C:
					Assert(uInImgCropHsz <= INROT_BP_IN_MAX_HSZ_C); //p8
					break;
				default:
					Assert(0);
					break;
			}
			//Assert(uInImgCropVsz <= INPUT_ROTATOR_BYPASS_INPUT_MAX_VSIZE); // p8
			break;
		case ROT_90_FLIP_NO: // 90 degree
		case ROT_90_FLIP_X:
		case ROT_90_FLIP_Y:
		case ROT_90_FLIP_XY: // 270 degree	
			//Assert(uInImgCropVsz <= INPUT_ROTATOR_INPUT_MAX_VSIZE);  // p8
			switch(eCh)
			{
				case FIMC_A:
					Assert(uInImgCropVsz <= INROT_IN_MAX_VSZ_A);  // p8
					break;
				case FIMC_B:
					Assert(uInImgCropVsz <= INROT_IN_MAX_VSZ_B);  // p8
					break;
				case FIMC_C:
					Assert(uInImgCropVsz <= INROT_IN_MAX_VSZ_C); // p8
					break;
				default:
					Assert(0);
					break;
			}
			uTemp = uInImgCropHsz;
			uInImgCropHsz = uInImgCropVsz;
			uInImgCropVsz = uTemp;

			Assert(uInImgCropVsz%16 == 0); // p41
			break;
		default:
			Assert(0);
			break;			
	}

	//======

	// Set DMA input image scaler	
	if(uInImgCropHsz <= uOutImgHsz)
	{
		uHScaleFlag = 0x1; // Horizontal scale UP
	}
	else
	{
		uHScaleFlag = 0x0; // Horizontal scale DOWN
	}

	if(uInImgCropVsz <= uOutImgVsz)
	{
		uVScaleFlag = 0x1; // Vertical scale UP
	}
	else
	{
		uVScaleFlag = 0x0; // Vertical scale DOWN
	}

	FIMC_GetPreRatioAndShift(uInImgCropHsz, uOutImgHsz, &uPreHRatio, &uHShift);
	//Assert((uInImgCropHsz%8 == 0)&&(uInImgCropHsz >= 16)); // p41
	Assert((uInImgCropHsz%16 == 0)&&(uInImgCropHsz >= 16)); // p41
	Assert(uInImgCropHsz%(4*uPreHRatio) == 0); // p41
	
	FIMC_GetPreRatioAndShift(uInImgCropVsz, uOutImgVsz, &uPreVRatio, &uVShift);
	Assert(uInImgCropVsz >= 8); // p41
	switch(eInImgFmt)
	{
		case NV12: // YCBCR420_2P_CRCB_LE
		case YCBCR420_2P_CBCR_LE:
		case YCBCR420_2P_CRCB_BE:
		case YCBCR420_2P_CBCR_BE:		
		case YC420:
		case TILE_NV12:
			Assert(uInImgCropVsz%(2*uPreVRatio) == 0); // p41
			break;
		default:
			Assert(uInImgCropVsz%uPreVRatio == 0); // p41
			break;
	}		

	uShiftFactor = 10 - (uHShift + uVShift);

	uPreDstHSz = uInImgCropHsz/uPreHRatio;
	switch(eCh)
	{
		case FIMC_A:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_A); // p8
			break;
		case FIMC_B:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_B); // p8
			break;
		case FIMC_C:
			Assert(uPreDstHSz <= MAIN_SC_IN_MAX_HSZ_C); // p8
			break;
		default:
			Assert(0);
			break;
	}	
	uPreDstVSz = uInImgCropVsz/uPreVRatio;
	
	uMainHRatio = (uInImgCropHsz<<8)/(uOutImgHsz<<uHShift);
	uMainVRatio = (uInImgCropVsz<<8)/(uOutImgVsz<<uVShift);

	fimcInp32(eCh, rCISCPRERATIO, uCISCPRERATIO);
	uCISCPRERATIO = uCISCPRERATIO & (~(0xf<<28));
	uCISCPRERATIO = uCISCPRERATIO |(uShiftFactor<<28);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<16));
	uCISCPRERATIO = uCISCPRERATIO |(uPreHRatio<<16);
	uCISCPRERATIO = uCISCPRERATIO & (~(0x7f<<0));
	uCISCPRERATIO = uCISCPRERATIO |(uPreVRatio<<0);
	fimcOutp32(eCh, rCISCPRERATIO, uCISCPRERATIO);

	fimcInp32(eCh, rCISCPREDST, uCISCPREDST);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<16));
	uCISCPREDST = uCISCPREDST |(uPreDstHSz<<16);
	uCISCPREDST = uCISCPREDST & (~(0x3fff<<0));
	uCISCPREDST = uCISCPREDST |(uPreDstVSz<<0);
	fimcOutp32(eCh, rCISCPREDST, uCISCPREDST);

	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	uCISCCTRL = uCISCCTRL & (~(0x1<<30));
	uCISCCTRL = uCISCCTRL |(uHScaleFlag<<30);
	uCISCCTRL = uCISCCTRL & (~(0x1<<29));
	uCISCCTRL = uCISCCTRL |(uVScaleFlag<<29);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<16));
	uCISCCTRL = uCISCCTRL |(uMainHRatio<<16);	
	uCISCCTRL = uCISCCTRL & (~(0x1ff<<0));
	uCISCCTRL = uCISCCTRL |(uMainVRatio<<0);	
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);	
}

// [Set FIFO-out image format]
static void FIMC_SetFoutImgFmt(FIMC_CH eCh, LOCAL_IF_TYPE eOutLocalType)
{
	u32 uCITRGFMT;
	
	u32 uOutFmt;

	Assert((eOutLocalType==LOCAL_IF_RGB24)||(eOutLocalType==LOCAL_IF_YCBCR444)); // RGB24 or YCbCr 444

	switch(eOutLocalType)
	{
		case LOCAL_IF_RGB24:
			uOutFmt = 0x3;
			break;
		case LOCAL_IF_YCBCR444:
			uOutFmt = 0x0;
			break;
		default:
			Assert(0);
			break;		
	}
	
	fimcInp32(eCh, rCITRGFMT, uCITRGFMT);
	uCITRGFMT = uCITRGFMT & (~(0x3<<29));
	uCITRGFMT = uCITRGFMT |(uOutFmt<<29);
	fimcOutp32(eCh, rCITRGFMT, uCITRGFMT);
}

// [Set output scan mode]
static void FIMC_SetOutScanMode(FIMC_CH eCh, SCAN_MODE eOutScanMode)
{
	u32 uCISCCTRL;
		
	fimcInp32(eCh, rCISCCTRL, uCISCCTRL);
	if(eOutScanMode == PROGRESSIVE)
	{
		uCISCCTRL = uCISCCTRL & (~(0x1<<25));			
	}
	else if(eOutScanMode == INTERLACED)
	{
		uCISCCTRL = uCISCCTRL |(0x1<<25);
	}
	else
	{
		Assert(0);
	}
	fimcOutp32(eCh, rCISCCTRL, uCISCCTRL);
}

// [Initialize base H/W for FIMC]
void InitBaseHwForFIMC(void)
{
#ifdef S5PV210
	// [Power ON for external camera A]
	//--------------------------------
	Delay(50000);
	GPIO_SetFunctionEach(eGPIO_H0, eGPIO_5, eGINT); // EXT_INT[5], GPH0CON[5], (1.8V)
	GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_5, eGPUDdis);	
	GPIO_SetDataEach(eGPIO_H0, eGPIO_5, 1);
	Delay(5000);
	GPIO_SetFunctionEach(eGPIO_H1, eGPIO_2, eGINT); // EXT_INT[10], GPH1CON[2], (1.5V, 2.8V, 3.3V)
	GPIO_SetPullUpDownEach(eGPIO_H1, eGPIO_2, eGPUDdis);	
	GPIO_SetDataEach(eGPIO_H1, eGPIO_2, 1);
	
	// [GPIO setting for external camera A]
	//--------------------------------
#if 1
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_0, eGFunc_0); // CAM_A_PCLK, GPE0CON[0]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_1, eGFunc_0); // CAM_A_VSYNC, GPE0CON[1]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_2, eGFunc_0); // CAM_A_HREF, GPE0CON[2]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_3, eGFunc_0); // CAM_A_DATA[0], GPE0CON[3]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_4, eGFunc_0); // CAM_A_DATA[1], GPE0CON[4]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_5, eGFunc_0); // CAM_A_DATA[2], GPE0CON[5]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_6, eGFunc_0); // CAM_A_DATA[3], GPE0CON[6]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_7, eGFunc_0); // CAM_A_DATA[4], GPE0CON[7]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_0, eGFunc_0); // CAM_A_DATA[5], GPE1CON[0]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_1, eGFunc_0); // CAM_A_DATA[6], GPE1CON[1]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_2, eGFunc_0); // CAM_A_DATA[7], GPE1CON[2]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_3, eGFunc_0); // CAM_A_CLKOUT, GPE1CON[3]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_4, eGFunc_0); // CAM_A_FIELD, GPE1CON[4]
#else // Set high-Z for camera B test on Marcopolo FPGA board, notice: CFG12 '1=ON' '2=ON'
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_0, eGPI); // CAM_A_PCLK, GPE0CON[0]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_1, eGPI); // CAM_A_VSYNC, GPE0CON[1]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_2, eGPI); // CAM_A_HREF, GPE0CON[2]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_3, eGPI); // CAM_A_DATA[0], GPE0CON[3]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_4, eGPI); // CAM_A_DATA[1], GPE0CON[4]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_5, eGPI); // CAM_A_DATA[2], GPE0CON[5]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_6, eGPI); // CAM_A_DATA[3], GPE0CON[6]
	GPIO_SetFunctionEach(eGPIO_E0, eGPIO_7, eGPI); // CAM_A_DATA[4], GPE0CON[7]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_0, eGPI); // CAM_A_DATA[5], GPE1CON[0]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_1, eGPI); // CAM_A_DATA[6], GPE1CON[1]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_2, eGPI); // CAM_A_DATA[7], GPE1CON[2]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_3, eGPI); // CAM_A_CLKOUT, GPE1CON[3]
	GPIO_SetFunctionEach(eGPIO_E1, eGPIO_4, eGPI); // CAM_A_FIELD, GPE1CON[4]
#endif

	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_0, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_1, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_2, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_3, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_4, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_5, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_6, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E0, eGPIO_7, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E1, eGPIO_0, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E1, eGPIO_1, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E1, eGPIO_2, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E1, eGPIO_3, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_E1, eGPIO_4, eGPUDdis);
		
	// [GPIO setting for external camera B]
	//--------------------------------
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_0, eGFunc_1); // CAM_B_DATA[0], GPJ0CON[0]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_1, eGFunc_1); // CAM_B_DATA[1], GPJ0CON[1]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_2, eGFunc_1); // CAM_B_DATA[2], GPJ0CON[2]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_3, eGFunc_1); // CAM_B_DATA[3], GPJ0CON[3]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_4, eGFunc_1); // CAM_B_DATA[4], GPJ0CON[4]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_5, eGFunc_1); // CAM_B_DATA[5], GPJ0CON[5]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_6, eGFunc_1); // CAM_B_DATA[6], GPJ0CON[6]
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_7, eGFunc_1); // CAM_B_DATA[7], GPJ0CON[7]
	GPIO_SetFunctionEach(eGPIO_J1, eGPIO_0, eGFunc_1); // CAM_B_PCLK, GPJ1CON[0]
	GPIO_SetFunctionEach(eGPIO_J1, eGPIO_1, eGFunc_1); // CAM_B_VSYNC, GPJ1CON[1]
	GPIO_SetFunctionEach(eGPIO_J1, eGPIO_2, eGFunc_1); // CAM_B_HREF, GPJ1CON[2]
	GPIO_SetFunctionEach(eGPIO_J1, eGPIO_3, eGFunc_1); // CAM_B_FIELD, GPJ1CON[3]
	GPIO_SetFunctionEach(eGPIO_J1, eGPIO_4, eGFunc_1); // CAM_B_CLKOUT, GPJ1CON[4]	

	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_0, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_1, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_2, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_3, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_4, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_5, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_6, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J0, eGPIO_7, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J1, eGPIO_0, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J1, eGPIO_1, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J1, eGPIO_2, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J1, eGPIO_3, eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_J1, eGPIO_4, eGPUDdis);	

	// [Clock divider setting for CAM_A_CLKOUT, CAM_B_CLKOUT]
	//----------------------------------------------------

	// [Clock source selection (DOUT_MPLL, MOUT_EPLL, MOUT_HPLL, VCLK_54)]
	//---------------------------------------------------------------

	// [Clock divider setting for FIMC A/B/C]
	//---------------------------------

	// [Drive strength setting of CAM_A_CLKOUT]
	//-------------------------------------
	//Outp32(0xE020010C, 0xc0); // 12mA
	GPIO_SetDSEach(eGPIO_E1, eGPIO_3, 3);
	
#endif
}

//=======================================================================
// Temp code for VP & MIXER verification -> It will be removed as soon as possible
//=======================================================================
void FIMC_ColorSpaceConversion(
	u32 srcAddr,u32 dstAddr,
	u32 srcFullWidth,u32 srcFullHeight,u32 dstFullWidth,u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor, CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	FIMC_CH eCh = FIMC_A;

	u32 udstHeight;

	if( (dstColor == NV12_IB) || (dstColor == TILE_NV12_IB) )
	{
		udstHeight = dstFullHeight/2;
	}
	else
	{
		udstHeight = dstFullHeight;
	}
	
	//FIMC_SetChA();
	
	FIMC_InitIpForDinDout(eCh,
		srcFullWidth, srcFullHeight, 0,
		0, 0, srcFullWidth, srcFullHeight,
		srcAddr, srcColor,
		dstFullWidth, udstHeight,
		0, 0, dstFullWidth, dstFullHeight, 0, 
		dstAddr, dstColor,		
		ROT_NO_FLIP_NO, eCscEquation, eYCbCrRange, false);

	FIMC_StartProcessing(eCh, false, 0, 0, false, 0);
	FIMC_WaitForProcessingDone(eCh);	
	FIMC_StopProcessing(eCh);
}

void FIMC_CSC_YUVRange(CSC_EQUATION eCscEquation, YCBCR_RANGE eYCbCrRange)
{
	FIMC_CH eCh = FIMC_A;

	FIMC_SetCscEquationAndYCbCrRange(eCh, eCscEquation, eYCbCrRange);

	FIMC_StartProcessing(eCh, false, 0, 0, false, 0);
	FIMC_WaitForProcessingDone(eCh);	
	FIMC_StopProcessing(eCh);
}
//=======================================================================

