/*-------------------------------------------------------------
 * Filename: post_test.c
 *
 * Contents: Implemention test code of Post processor of s5c6440
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee 2008.09.08
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
//#include <system.h> 


#if defined(S5PC100)
#include "typedef.h"
#include "system.h"
#elif defined(S5PV210)
#include "string.h"
//#include "user_def.h"
#include "def.h"
#include "option.h"
#include "util.h"
#elif defined(S5P6442)
#include "string.h"
#include "user_def.h"
#include "def.h"
#include "option.h"
#endif

#include <fimc_2nd.h>
//#include <lcd.h>
#include <fimc_conditions.h>
#include <sun240320_24bpp.h>
#include "fimc_test_2nd.h"


#if defined(SYSTEM_6440)|defined(S5P6442)
#if 1
#define FRAMEBUFFER_ADDR 0x26000000
#define POST_SRC_ADDR 0x21000000 
#define CONDITION_BUFFER 0x24000000
#define TEMP_BUF 0x23000000
#else
#define FRAMEBUFFER_ADDR 0x56000000
#define POST_SRC_ADDR 0x51000000
#define CONDITION_BUFFER 0x54000000
#define TEMP_BUF 0x53000000
#endif
#elif defined(S5PV210)
#if 1
//#define FRAMEBUFFER_ADDR 0x66000000
//#define POST_SRC_ADDR 0x61000000
//#define CONDITION_BUFFER 0x64000000
//#define TEMP_BUF 0x63000000
/*
#define FRAMEBUFFER_ADDR 0x26000000
#define POST_SRC_ADDR 0x21000000 
#define CONDITION_BUFFER 0x24000000
#define TEMP_BUF 0x23000000
*/	//	by won
#define FRAMEBUFFER_ADDR 0x46000000
#define POST_SRC_ADDR 0x41000000 
#define CONDITION_BUFFER 0x44000000
#define TEMP_BUF 0x43000000

#else
#define FRAMEBUFFER_ADDR 0x56000000
#define POST_SRC_ADDR 0x51000000
#define CONDITION_BUFFER 0x54000000
#define TEMP_BUF 0x53000000
#endif
#endif



static int VerifyResult(POST_COLOR_FORMAT format,int OutBufIndex,int width, int height)
{
	int i,j;
	u32 *src1Y;
	u32 *src1Cb;
	u32 *src1Cr;
	u32 *src2Y;
	u32 *src2Cb;
	u32 *src2Cr;
	
	switch(OutBufIndex)
	{
		case 0:
			src1Y = (u32*)DST0_Y_ADDR;
			src1Cb = (u32*)DST0_Cb_ADDR;
			src1Cr = (u32*)DST0_Cr_ADDR;
			src2Y = (u32*)V_DST0_Y_ADDR;
			src2Cb = (u32*)V_DST0_Cb_ADDR;
			src2Cr = (u32*)V_DST0_Cr_ADDR;
			break;
		case 1:
			src1Y = (u32*)DST1_Y_ADDR;
			src1Cb = (u32*)DST1_Cb_ADDR;
			src1Cr = (u32*)DST1_Cr_ADDR;
			src2Y = (u32*)V_DST0_Y_ADDR;
			src2Cb = (u32*)V_DST0_Cb_ADDR;
			src2Cr = (u32*)V_DST0_Cr_ADDR;
			break;
		case 2:
			src1Y = (u32*)DST2_Y_ADDR;
			src1Cb = (u32*)DST2_Cb_ADDR;
			src1Cr = (u32*)DST2_Cr_ADDR;
			src2Y = (u32*)V_DST0_Y_ADDR;
			src2Cb = (u32*)V_DST0_Cb_ADDR;
			src2Cr = (u32*)V_DST0_Cr_ADDR;
			break;
		case 3:
			src1Y = (u32*)DST2_Y_ADDR;
			src1Cb = (u32*)DST2_Cb_ADDR;
			src1Cr = (u32*)DST2_Cr_ADDR;
			src2Y = (u32*)V_DST0_Y_ADDR;
			src2Cb = (u32*)V_DST0_Cb_ADDR;
			src2Cr = (u32*)V_DST0_Cr_ADDR;
			break;
	}

	switch(format)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y[0x%x]=0x%x src2Y[0x%x]=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y,src1Y[i],src2Y,src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CbCr=0x%x src2CbCr=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/4;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/4;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/4;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/4;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
#if defined(SYSTEM_6440)
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/2;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;

		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/2;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/2;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/2;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1CrCb=0x%x src2CrCb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			break;
#endif
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/16;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1Cb=0x%x src2Cb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/16;i++)
			{
				if(src1Cr[i]!=src2Cr[i])
				{
					Disp("Unmached at[%d] src1Cr=0x%x src2Cr=0x%x\n",
						i,src1Cr[i],src2Cr[i]);
					return 1;
				}
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			for(i=0;i<width*height/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d-%d,%d] src1Y=0x%x src2Y=0x%x\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src2Y[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cb[i]!=src2Cb[i])
				{
					Disp("Unmached at[%d] src1Cb=0x%x src2Cb=0x%x\n",
						i,src1Cb[i],src2Cb[i]);
					return 1;
				}
			}
			for(i=0;i<width*height/8;i++)
			{
				if(src1Cr[i]!=src2Cr[i])
				{
					Disp("Unmached at[%d] src1Cr=0x%x src2Cr=0x%x\n",
						i,src1Cr[i],src2Cr[i]);
					return 1;
				}
			}
			break;
#if defined(SYSTEM_6440)
		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			for(i=0;i<height*width/4;i++)
			{
				if(src1Y[i]!=src2Y[i] || src1Cb[i]!=src2Cb[i] ||src1Cr[i]!=src2Cr[i] )
				{
					Disp("Unmached at[%d-%d,%d] src1YCbCr=(%x,%x,%x) src2YCbCr=(%x,%x,%x)\n",
						(i*4)%width,(i*4)%width+3,(i*4)/width,src1Y[i],src1Cb[i],src1Cr[i],src2Y[i],src2Cb[i],src2Cr[i]);
					return 1;
				}		
			}
			break;
#endif
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
			for(i=0;i<height*width*2/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d] src1Y=0x%x src2Y=0x%x\n",
						i,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
			for(i=0;i<height*width*2/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d] src1Y=0x%x src2Y=0x%x\n",
						i,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
			for(i=0;i<height*width*2/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d] src1Y=0x%x src2Y=0x%x\n",
						i,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			for(i=0;i<height*width*2/4;i++)
			{
				if(src1Y[i]!=src2Y[i])
				{
					Disp("Unmached at[%d] src1Y=0x%x src2Y=0x%x\n",
						i,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_RGB565:
			for(i=0;i<height*width/2;i++)
			{
				if(src1Y[i]!=src2Y[i] )
				{
					Disp("Unmached at[%d-%d,%d] src1RGB=0x%x src2RGB=0x%x\n",
						(i*2)%width,(i*2)%width+1,(i*2)/width,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_RGB666:
			for(i=0;i<height*width/2;i++)
			{
				if(src1Y[i]!=src2Y[i] )
				{
					Disp("Unmached at[%d-%d,%d] src1RGB=0x%x src2RGB=0x%x\n",
						(i*2)%width,(i*2)%width+1,(i*2)/width,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
		case POST_COLOR_FORMAT_RGB888:
			for(i=0;i<height*width;i++)
			{
				if(src1Y[i]!=src2Y[i] )
				{
					Disp("Unmached at[%d,%d] src1RGB=0x%x src2RGB=0x%x\n",
						i%width,i/width,src1Y[i],src2Y[i]);
					return 1;
				}		
			}
			break;
	}

	Disp("Verifing completed\n");
	return 0;
}



static void GenerateSourceImage(POST_COLOR_FORMAT format,int width,int height)
{
	POST_CONDITION condition;
	#if 1
	int i;
	unsigned long long *tmp1;
	u32 *tmp;
	u32 *tmp2;
	u32 *y;
	u32 *cb;
	u32 *cr;

	y=(u32 *)SRC_Y_ADDR;	//0x22800000
	cb=(u32 *)SRC_Cb_ADDR;  //0x22900000
	cr=(u32 *)SRC_Cr_ADDR;	//0x22a00000
	
	tmp1 = (unsigned long long *)TEMP_BUF;	//0x23000000

	tmp = (u32 *)tmp1;
	
	/* a image is copied by for-loop */
	for(i=0;i<240*320;i++)
	{
		tmp[i] = sun240320_24bpp[i];
		y[i]=0;
		cb[i]=0;
		cr[i]=0;
	}
	#endif
		
	POST_getDefaultPostCondition(&condition);
	condition.src = POST_COLOR_FORMAT_RGB888;
	condition.dst = format;
	condition.InAddr.Y = (u32)tmp;
	#if 1
	condition.OutAddr1.Y = SRC_Y_ADDR;		//0x22800000
	condition.OutAddr1.Cb = SRC_Cb_ADDR;	//0x22900000
	condition.OutAddr1.Cr = SRC_Cr_ADDR;	//0x22a00000
	condition.OutAddr2.Y = SRC_Y_ADDR;
	condition.OutAddr2.Cb = SRC_Cb_ADDR;
	condition.OutAddr2.Cr = SRC_Cr_ADDR;
	condition.OutAddr3.Y = SRC_Y_ADDR;
	condition.OutAddr3.Cb = SRC_Cb_ADDR;
	condition.OutAddr3.Cr = SRC_Cr_ADDR;
	condition.OutAddr4.Y = SRC_Y_ADDR;
	condition.OutAddr4.Cb = SRC_Cb_ADDR;
	condition.OutAddr4.Cr = SRC_Cr_ADDR;
	#else
	condition.OutAddr1.Y = DST0_Y_ADDR;
	condition.OutAddr1.Cb = DST0_Cb_ADDR;
	condition.OutAddr1.Cr = DST0_Cr_ADDR;
	#endif
	condition.runMode = ONE_SHOT;
	condition.srcOriginalImageWidth=240;
	condition.srcOriginalImageHeight =320;
	condition.srcImageWidth= 240;
	condition.srcImageHeight=320;
	condition.dstScreenWidth = width;
	condition.dstScreenHeight=height;
	condition.dstImageWidth=width;
	condition.dstImageHeight=height;

	POST_SetCondition(condition);
	POST_DoConverting();
	POST_WaitConverting();
	
}

static void ClearDstBuffer(int width,int height,int bufIndex)
{
	int i;
	u32 *src1Y;
	u32 *src1Cb;
	u32 *src1Cr;
	u32 *src2Y;
	u32 *src2Cb;
	u32 *src2Cr;
	
	switch(bufIndex)
	{
		case 0:
			src1Y = (u32*)DST0_Y_ADDR;
			src1Cb = (u32*)DST0_Cb_ADDR;
			src1Cr = (u32*)DST0_Cr_ADDR;
			src2Y = (u32*)V_DST0_Y_ADDR;
			src2Cb = (u32*)V_DST0_Cb_ADDR;
			src2Cr = (u32*)V_DST0_Cr_ADDR;
			break;
		case 1:
			src1Y = (u32*)DST1_Y_ADDR;
			src1Cb = (u32*)DST1_Cb_ADDR;
			src1Cr = (u32*)DST1_Cr_ADDR;
			src2Y = (u32*)V_DST1_Y_ADDR;
			src2Cb = (u32*)V_DST1_Cb_ADDR;
			src2Cr = (u32*)V_DST1_Cr_ADDR;
			break;
		case 2:
			src1Y = (u32*)DST2_Y_ADDR;
			src1Cb = (u32*)DST2_Cb_ADDR;
			src1Cr = (u32*)DST2_Cr_ADDR;
			src2Y = (u32*)V_DST2_Y_ADDR;
			src2Cb = (u32*)V_DST2_Cb_ADDR;
			src2Cr = (u32*)V_DST2_Cr_ADDR;
			break;
		case 3:
			src1Y = (u32*)DST3_Y_ADDR;
			src1Cb = (u32*)DST3_Cb_ADDR;
			src1Cr = (u32*)DST3_Cr_ADDR;
			src2Y = (u32*)V_DST3_Y_ADDR;
			src2Cb = (u32*)V_DST3_Cb_ADDR;
			src2Cr = (u32*)V_DST3_Cr_ADDR;
			break;
	}
	
	
	for(i=0;i<width*height;i++)
	{
		src1Cr[i]=0;
		src1Cb[i]=0;
		src1Y[i]=0;
		src2Cr[i]=0;
		src2Cb[i]=0;
		src2Y[i]=0;
	}
	
}

static void DispCSCDebug()
{
	u8 *y,*cb,*cr;
	u8 *y_v,*cb_v,*cr_v;
	u8 *y_s,*cb_s,*cr_s;

	y=(u8 *)DST0_Y_ADDR;		// 0x26000000
	cb=(u8 *)DST0_Cb_ADDR;
	cr=(u8 *)DST0_Cr_ADDR;
	y_v=(u8 *)V_DST0_Y_ADDR;	// 0x25000000
	cb_v=(u8 *)V_DST0_Cb_ADDR;
	cr_v=(u8 *)V_DST0_Cr_ADDR;

	y_s=(u8 *)SRC_Y_ADDR;		// 0x22800000
	cb_s=(u8 *)SRC_Cb_ADDR;
	cr_s=(u8 *)SRC_Cr_ADDR;

	Disp("Src Y=%x %x %x %x %x %x %x %x\n",y_s[0],y_s[1],y_s[2],y_s[3],y_s[4],y_s[5],y_s[6],y_s[7]);
	Disp("Src Cb=%x %x %x %x %x %x %x %x | %x %x %x %x %x %x %x %x\n",cb_s[0],cb_s[1],cb_s[2],cb_s[3],cb_s[4],cb_s[5],cb_s[6],cb_s[7],
		cb_s[8],cb_s[9],cb_s[10],cb_s[11],cb_s[12],cb_s[13],cb_s[14],cb_s[15]);
	Disp("Srcl Cr=%x %x %x %x %x %x %x %x \n",cr_s[0],cr_s[1],cr_s[2],cr_s[3],cr_s[4],cr_s[5],cr_s[6],cr_s[7]);
	Disp("Real Y=%x %x %x %x %x %x %x %x\n",y[0],y[1],y[2],y[3],y[4],y[5],y[6],y[7]);
	Disp("Virtl Y=%x %x %x %x %x %x %x %x\n",y_v[0],y_v[1],y_v[2],y_v[3],y_v[4],y_v[5],y_v[6],y_v[7]);
	Disp("Real Cb=%x %x %x %x %x %x %x %x | %x %x %x %x %x %x %x %x\n",cb[0],cb[1],cb[2],cb[3],cb[4],cb[5],cb[6],cb[7],
		cb[8],cb[9],cb[10],cb[11],cb[12],cb[13],cb[14],cb[15]);
	Disp("Virtl Cb=%x %x %x %x %x %x %x %x | %x %x %x %x %x %x %x %x\n",cb_v[0],cb_v[1],cb_v[2],cb_v[3],cb_v[4],cb_v[5],cb_v[6],cb_v[7],
		cb_v[8],cb_v[9],cb_v[10],cb_v[11],cb_v[12],cb_v[13],cb_v[14],cb_v[15]);
	Disp("Real Cr=%x %x %x %x %x %x %x %x \n",cr[0],cr[1],cr[2],cr[3],cr[4],cr[5],cr[6],cr[7]);
	Disp("Virtl Cr=%x %x %x %x %x %x %x %x \n",cr_v[0],cr_v[1],cr_v[2],cr_v[3],cr_v[4],cr_v[5],cr_v[6],cr_v[7]);
		

}

void Test_SimpleScaling()
{
	int i;
	u32 *buf32;
	POST_COLOR_YCBCR srcAddr;
	POST_COLOR_YCBCR dstAddr;
	POST_RECT srcRect;
	POST_RECT dstRect;
	unsigned long long buf[240*320/2]; // This's for 64bit alignment

	buf32 = (u32 *)buf;

	for(i=0;i<240*320;i++)buf32[i] = sun240320_24bpp[i];

	srcAddr.Y = (u32)buf32;
	dstAddr.Y = (u32)FRAMEBUFFER_ADDR;
	srcRect.x=0;
	srcRect.y=0;
	srcRect.width = 240;
	srcRect.height=320;
	dstRect = srcRect;
	
	POST_NoramlScaling(srcAddr,dstAddr,240,320,240,320,srcRect,dstRect,
		POST_COLOR_FORMAT_RGB888, POST_COLOR_FORMAT_RGB888);
	POST_DoConverting();
	POST_WaitConverting();
}

#if 0 //for c_model (vega_L->c100)
static void InitLCD(CSPACE eBpp)
#else
//static void InitLCD(IMG_TYPE eBpp)
#endif
//{
#if 0 //for c_model (vega_L->c100)
	int i,j;
	u32 *tmp;

	#if defined(SYSTEM_6440)
	GPIO_Init();
	GPIO_SetFunctionForLts222QLdi();
	#endif
	LCDC_Stop();
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eBpp, FRAMEBUFFER_ADDR, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();	

	tmp=(u32 *)FRAMEBUFFER_ADDR;	
	for(i=0;i<320;i++)
	{
		for(j=0;j<240;j++)tmp[i*240+j]=0;
	}

#endif
//}


void Test_SimpleScalingLocalPath()
{
	int i;
	u32 *buf32;
	char key;
	int bufferIndex;
	POST_COLOR_YCBCR srcAddr;
	POST_COLOR_YCBCR dstAddr;
	POST_RECT srcRect;
	POST_RECT dstRect;
	unsigned long long buf[240*320/2]; // This's for 64bit alignment
	unsigned long long buf2[240*320/2]; // This's for 64bit alignment

	buf32 = (u32 *)buf;
	for(i=0;i<240*320;i++)buf32[i] = sun240320_24bpp[i];
	buf32 = (u32 *)buf2;
	for(i=0;i<240*320;i++)buf32[i] = ~(sun240320_24bpp[i]);

	srcAddr.Y = (u32)buf;
	dstAddr.Y = (u32)FRAMEBUFFER_ADDR;
	srcRect.x=0;
	srcRect.y=0;
	srcRect.width = 240;
	srcRect.height=320;
	dstRect = srcRect;
	
	POST_NoramlScaling(srcAddr,dstAddr,240,320,240,320,srcRect,dstRect,
		POST_COLOR_FORMAT_RGB888, POST_COLOR_FORMAT_RGB888);
	POST_SetOutputPath(POST_FIFO);
	POST_SetRunMode(FREE_RUN);
	POST_DoConverting();

	/* set lcd to local path mode. */
#if 0 //for c100
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);
	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
#endif 

	bufferIndex = 0;
	while(1)
	{
		Disp("press any key to change input dma buffer, except 'x' key for escape.\n");
		key=UART_Getc();
		if(key=='x')break;

		if(bufferIndex)
		{
			POST_SetAddChangeDisable(1);
			POST_SetInputDMAAddr((u32)buf, 0, 0);
			POST_SetAddChangeDisable(0);
			bufferIndex=0;
		}
		else
		{
			POST_SetAddChangeDisable(1);
			POST_SetInputDMAAddr((u32)buf2, 0, 0);
			POST_SetAddChangeDisable(0);
			bufferIndex=1;
		}
	}

	POST_StopAudoLoad();

	/*set lcd to normal mode*/
#if 0 //for c100
	InitLCD(RGB24);
#endif

}

static void Test_initReg()
{
#if 0
	if(POST_RegResetValueVerify()!=0xffffffff)
	{
		Disp("Invalid Reset Reg!!\n");
	}
#endif
}

static void Full_CSC_Test(POST_CONDITION *cond)
{
	
	int i;	
	for(i=0;1;i++)
//	for(i=353;1;i++)
	{
		Disp("[%d]",i);
		if(cond[i].temp<0)break;
		POST_DispPostCondition(&(cond[i]));
		Disp("...");
		GenerateSourceImage(cond[i].src,cond[i].srcOriginalImageWidth,cond[i].srcOriginalImageHeight);

		POST_SetCondition(cond[i]);
		POST_SetConditionSW(cond[i]);

		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,0);
		POST_DoConverting();
		POST_WaitConverting();

		POST_DoConvertingSW();
		POST_WaitConvertingSW();

		if(VerifyResult(cond[i].dst,0,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
		{
			DispCSCDebug();
			//UART_GetIntNum();
		}
	}

}

static void Test_CSC_DMAtoDMA()
{
	
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;	
	POST_getDefaultPostCondition(&defaultCond);
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);

	Full_CSC_Test(cond);
}

static void LocalPathTest(POST_CONDITION defaultCond)
{
	POST_CONDITION *cond;
	int i;
	volatile int j;

	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
	cond=POST_getLocalPathCondition(defaultCond, CONDITION_BUFFER);

	for(i=0;1;i++)
	{
		if(cond[i].temp<0)break;
		//if(cond[i].dst!=POST_COLOR_FORMAT_RGB888)continue;

		//if(i==21 || i==351 || i==417){}
		//else continue;
#if 0
		InitLCD(RGB24); //let's display framebuffer which is cleared by black.
#endif
		for(j=0;j<0xff;j++) //let's wait display more than 1 frame.
		//Disp("clearing screen.press any key\n");
		//GetChar();
#if 0 //for c100		
		LCDC_Stop();
		LCDC_SetWinOnOff(0, WIN0);

		LCDC_InitLdi(MAIN);
		LCDC_InitIpForFifoIn(IN_POST, WIN0);
		LCDC_SetWinOnOff(1, WIN0);
		LCDC_Start();

#endif
		Disp("[%d]",i);
		POST_DispPostCondition(&(cond[i]));
		Disp("...");

		//following code is need. because source YCbCr422 1-plane table is different from destination YCbCr422 1-plane table in the manual. 
		if(cond[i].src == POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER)
		{
			GenerateSourceImage(POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER,cond[i].srcOriginalImageWidth,cond[i].srcOriginalImageHeight);
		}
		else if(cond[i].src == POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER)
		{
			GenerateSourceImage(POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER,cond[i].srcOriginalImageWidth,cond[i].srcOriginalImageHeight);
		}
		else GenerateSourceImage(cond[i].src,cond[i].srcOriginalImageWidth,cond[i].srcOriginalImageHeight);

		POST_SetCondition(cond[i]);

		Disp("press any key to display\n");
		UART_Getc();
		POST_DoConverting();
	
		Disp("See the screen. press any key to continue\n");
		UART_Getc();
		POST_StopAudoLoad();
	}
	
}

static void Test_CSC_LocalPath()
{
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);
	LocalPathTest(defaultCond);
}

static void Test_R2Y_Narrow()
{
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);
	defaultCond.R2YRange=POST_CSC_NARROW;
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);
	Full_CSC_Test(cond);
}

static void Test_R2Y_Narraw_LocalPath()
{
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);
	defaultCond.R2YRange=POST_CSC_NARROW;
	
	LocalPathTest(defaultCond);

}
static void Test_R2Y_NarrowSample()
{
	u32 *rgbSrc;
	u32 result1;
	u32 result2;
	
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	rgbSrc=(u32 *)SRC_Y_ADDR;


	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.R2YRange = POST_CSC_WIDE;
	defaultCond.srcOriginalImageWidth=240;
	defaultCond.srcOriginalImageHeight =320;
	defaultCond.srcImageWidth= 240;
	defaultCond.srcImageHeight=320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight=320;
	GenerateSourceImage(POST_COLOR_FORMAT_RGB888,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight );
	POST_SetCondition(defaultCond);
	POST_DoConverting();

	result1 = *((u32 *)DST0_Y_ADDR);
	Disp("Wide completed  see LCD screen. press any key to continue\n");
	UART_GetIntNum();

	defaultCond.R2YRange = POST_CSC_NARROW;
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	
	result2= *((u32 *)DST0_Y_ADDR);

	Disp("Narrow completed see LCD screen. press any key to continue\n");
	UART_GetIntNum();
	Disp("[0,0] Original=0x%x(RGB) R2YRange-WIDE=0x%x(RGB) R2YRange-NARROW=0x%x(RGB)\n",
		rgbSrc[0],result1,result2);	
}

static void Test_Y2R_Narrow()
{
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);
	defaultCond.Y2RRange=POST_CSC_NARROW;
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);
	Full_CSC_Test(cond);
}

static void Test_Y2R_Narrow_LocalPath()
{

	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);
	defaultCond.Y2RRange=POST_CSC_NARROW;
	
	LocalPathTest(defaultCond);
}


static void Test_Y2R_NarrowSample()
{
	u32 *rgbSrc;
	u32 result1;
	u32 result2;
	
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	rgbSrc=(u32 *)SRC_Y_ADDR;


	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.Y2RRange = POST_CSC_WIDE;
	defaultCond.srcOriginalImageWidth=240;
	defaultCond.srcOriginalImageHeight =320;
	defaultCond.srcImageWidth= 240;
	defaultCond.srcImageHeight=320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight=320;
	GenerateSourceImage(POST_COLOR_FORMAT_RGB888,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_SetCondition(defaultCond);
	POST_DoConverting();

	result1 = *((u32 *)DST0_Y_ADDR);
	Disp("Wide completed  see LCD screen. press any key to continue\n");
	UART_GetIntNum();

	defaultCond.Y2RRange = POST_CSC_NARROW;
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	
	result2= *((u32 *)DST0_Y_ADDR);

	Disp("Narrow completed see LCD screen. press any key to continue\n");
	UART_GetIntNum();
	Disp("[0,0] Original=0x%x(RGB) Y2RRange-WIDE=0x%x(RGB) Y2RRange-NARROW=0x%x(RGB)\n",
		rgbSrc[0],result1,result2);	
}

static void Test_RGB_Extension()
{
	u32 result1;
	u32 result2;
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);
	
	defaultCond.src = POST_COLOR_FORMAT_RGB565;
	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcOriginalImageWidth=240;
	defaultCond.srcOriginalImageHeight =320;
	defaultCond.srcImageWidth= 240;
	defaultCond.srcImageHeight=320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight=320;
	defaultCond.RGBInputExtension = 0;
	GenerateSourceImage(POST_COLOR_FORMAT_RGB565,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_DispPostCondition(&defaultCond);
	Disp("...Generating RGBInput Normal...");

	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	POST_SetConditionSW(defaultCond);
	POST_DoConvertingSW();
	//VerifyResult(POST_COLOR_FORMAT format,int OutBufIndex,int width, int height)
	if(VerifyResult(defaultCond.dst,0,240,320))
	{
		Disp("Fail!!\n");
		return;
	}
	else
	{
		Disp("Generating completed. see LCD screen. press any key\n");
	}
	result1 = *((u32 *)DST0_Y_ADDR);
	UART_GetIntNum();
	
	POST_DispPostCondition(&defaultCond);
	Disp("...Generating RGBInput Extension...");
	defaultCond.RGBInputExtension = 1;
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	POST_SetConditionSW(defaultCond);
	POST_DoConvertingSW();
	//VerifyResult(POST_COLOR_FORMAT format,int OutBufIndex,int width, int height)
	result2 = *((u32 *)DST0_Y_ADDR);
	Disp("Normal=0x%x <==> Extension=0x%x\n",result1,result2);
	if(VerifyResult(defaultCond.dst,0,240,320))
	{
		Disp("Fail!!\n");
		return;
	}
	else
	{
		Disp("Generating completed. see LCD screen. press any key\n");
	}
	UART_GetIntNum();

	GenerateSourceImage(POST_COLOR_FORMAT_RGB666,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	
	POST_DispPostCondition(&defaultCond);
	Disp("...Generating RGBInput Normal...");
	defaultCond.src = POST_COLOR_FORMAT_RGB666;
	defaultCond.RGBInputExtension = 0;
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	POST_SetConditionSW(defaultCond);
	POST_DoConvertingSW();
	//VerifyResult(POST_COLOR_FORMAT format,int OutBufIndex,int width, int height)
	result1 = *((u32 *)DST0_Y_ADDR+1);
	if(VerifyResult(defaultCond.dst,0,240,320))
	{
		Disp("Fail!!\n");
		return;
	}
	else
	{
		Disp("Generating completed. see LCD screen. press any key\n");
	}
	UART_GetIntNum();
	POST_DispPostCondition(&defaultCond);
	Disp("...Generating RGBInput Extension...");
	defaultCond.src = POST_COLOR_FORMAT_RGB666;
	defaultCond.RGBInputExtension = 1;
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	POST_SetConditionSW(defaultCond);
	POST_DoConvertingSW();
	//VerifyResult(POST_COLOR_FORMAT format,int OutBufIndex,int width, int height)
	result2 = *((u32 *)DST0_Y_ADDR+1);
	Disp("Normal=0x%x <==> Extension=0x%x\n",result1,result2);
	if(VerifyResult(defaultCond.dst,0,240,320))
	{
		Disp("Fail!!\n");
		return;
	}
	else
	{
		Disp("Generating completed. see LCD screen. press any key\n");
	}
	UART_GetIntNum();
	
}

static void Test_Scaleup_All_CSC()
{
	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.srcImageWidth= 32;
	defaultCond.srcImageHeight=32;
	
	defaultCond.dstScreenWidth = 800;
	defaultCond.dstScreenHeight=480;
	defaultCond.dstImageWidth=defaultCond.srcImageWidth*2;
	defaultCond.dstImageHeight=defaultCond.srcImageHeight*2;

	
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);
	Full_CSC_Test(cond);
}

static void Test_Scaledown_All_CSC()
{

	POST_CONDITION defaultCond;
	POST_CONDITION *cond;

	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.srcImageWidth= 64;
	defaultCond.srcImageHeight=64;
	
	defaultCond.dstScreenWidth = 800;
	defaultCond.dstScreenHeight=480;
	defaultCond.dstImageWidth=defaultCond.srcImageWidth/2;
	defaultCond.dstImageHeight=defaultCond.srcImageHeight/2;
	
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);
	Full_CSC_Test(cond);
}
#if 0
#define SCALING_VARIOUS_SIZE_TEST 	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;\
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;\
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);\
	POST_DispPostCondition(&defaultCond);Disp("...");\
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);\
	POST_SetCondition(defaultCond);\
	POST_DoConverting();\
	POST_SetConditionSW(defaultCond);\
	POST_DoConvertingSW();	\
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))\
	{\
		DispCSCDebug();\
		UART_GetIntNum();\
	}
#else
#define SCALING_VARIOUS_SIZE_TEST 	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;\
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;\
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);\
	POST_DispPostCondition(&defaultCond);Disp("...");\
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);\
	POST_SetCondition(defaultCond);\
	POST_DoConverting();\
	POST_SetConditionSW(defaultCond);\
	POST_DoConvertingSW();
#endif
#if 0	
static void Test_Scaling_Various_SizeForSortingChip()
{
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_YCbCr420_3PLANE;

	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth = defaultCond.dstScreenWidth;
	defaultCond.dstImageHeight = defaultCond.dstScreenHeight;


	/*
	defaultCond.dstImageWidth = 128;
	defaultCond.dstImageHeight =96;
	defaultCond.srcOriginalImageWidth = 128;
	defaultCond.srcOriginalImageHeight = 96;
	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_DispPostCondition(&defaultCond);Disp("...");
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);
	POST_SetCondition(defaultCond);
	POST_DoConverting();
	POST_SetConditionSW(defaultCond);
	POST_DoConvertingSW();	
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
	{
		DispCSCDebug();
		GetInt();
	}
	*/
	
	defaultCond.srcOriginalImageWidth = 128;
	defaultCond.srcOriginalImageHeight = 96;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 176;
	defaultCond.srcOriginalImageHeight = 144;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 352;
	defaultCond.srcOriginalImageHeight = 288;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 704;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 320;
	defaultCond.srcOriginalImageHeight = 240;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 640;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 768;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 720;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.src = POST_COLOR_FORMAT_RGB565;
	defaultCond.srcOriginalImageWidth = 128;
	defaultCond.srcOriginalImageHeight = 96;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 176;
	defaultCond.srcOriginalImageHeight = 144;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 352;
	defaultCond.srcOriginalImageHeight = 288;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 704;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 320;
	defaultCond.srcOriginalImageHeight = 240;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 640;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 768;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_TEST;

	defaultCond.srcOriginalImageWidth = 720;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_TEST;
	
}
#else

typedef enum 
{
	FIMC_A,
	FIMC_B,
	FIMC_C
}FIMC_CH;

static FIMC_CH eFimc;

//static void Test_Scaling_Various_SizeForSortingChip()
static u8 Test_Scaling_Various_SizeForSortingChip()
{
	u32 uErrCount = 0;
	u32 uReturnValueOfVerifyResult = 0;
		
	u32 i,j, k,index;
	u32 count=0;
	u32 uInImgHVszList[11][2];
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	switch(eFimc)
	{
		case FIMC_A:
			uInImgHVszList[0][0]=128; uInImgHVszList[0][1]=96;
			break;
		case FIMC_B:
			uInImgHVszList[0][0]=128; uInImgHVszList[0][1]=96;
			break;
		case FIMC_C:
			uInImgHVszList[0][0]=128; uInImgHVszList[0][1]=96;
			break;
		default:
			//Assert(0);
			break;
	}
	
	
	defaultCond.dstScreenWidth = 32;
	defaultCond.dstScreenHeight=32;
	defaultCond.dstImageWidth = defaultCond.dstScreenWidth;
	defaultCond.dstImageHeight = defaultCond.dstScreenHeight;

				defaultCond.src =POST_COLOR_FORMAT_RGB888;

				defaultCond.dst = POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER;
		
				defaultCond.srcOriginalImageWidth = uInImgHVszList[0][0];
				defaultCond.srcOriginalImageHeight = uInImgHVszList[0][1];
				SCALING_VARIOUS_SIZE_TEST;
			
				uReturnValueOfVerifyResult = VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight);

				uErrCount = uErrCount + uReturnValueOfVerifyResult;

				if(uReturnValueOfVerifyResult == 1)
				{
					DispCSCDebug();
				}

			
		
	
	if(uErrCount == 0)
	{
		return true;
	}
	else
	{
		return false;
	}	
}

u8 Test_DinDoutForSortingChip(void)
{
	u8 bReturnValueOfFimcA;
	u8 bReturnValueOfFimcB;
	u8 bReturnValueOfFimcC;
		
	eFimc = FIMC_A;
	SelFimcPath(0);	
	Disp("\n[CAMIF 0]\n ");
	bReturnValueOfFimcA = Test_Scaling_Various_SizeForSortingChip();

	eFimc = FIMC_B;
	SelFimcPath(1);	
	Disp("\n[CAMIF 1]\n ");
	bReturnValueOfFimcB = Test_Scaling_Various_SizeForSortingChip();

	eFimc = FIMC_C;
	SelFimcPath(2);	
	Disp("\n[CAMIF 2]\n ");
	bReturnValueOfFimcC = Test_Scaling_Various_SizeForSortingChip();

	if((bReturnValueOfFimcA==true)&&(bReturnValueOfFimcB==true)&&(bReturnValueOfFimcC==true))
	{
		
		return true;
	}
	else
	{
		return false;
	}
}

//static void Test_Scaling_Various_Size()
static u8 Test_Scaling_Various_Size()
{
	u32 uErrCount = 0;
	u32 uReturnValueOfVerifyResult = 0;
		
	u32 i,j, k, m, index;
	u32 count=0;
	u32 uImgHVszList[4][2];
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	switch(eFimc)
	{
		case FIMC_A:
		case FIMC_B:
		case FIMC_C:
			// LCD
			uImgHVszList[0][0]=800; uImgHVszList[0][1]=480;

			// SD
			uImgHVszList[1][0]=720; uImgHVszList[1][1]=480;	

			// HD, Full HD
			uImgHVszList[2][0]=1280; uImgHVszList[2][1]=720;
			uImgHVszList[3][0]=1920; uImgHVszList[3][1]=1080;			
			break;
		default:
			//Assert(0);
			break;
	}
	
	//Disp("FIMC A selected, index %d\n",index);
	Disp(" index = %d \n", index);

#if 0
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth = defaultCond.dstScreenWidth;
	defaultCond.dstImageHeight = defaultCond.dstScreenHeight;
#endif

	count = 0;

	for(i = 0 ; i <22 ; i ++)
	{
		for(j = 0 ; j <22 ; j ++)
		{
			for(k = 0 ; k < 4 ; k++)
			{
				for(m = 0; m < 4; m++)
				{
					switch(eFimc)
					{
						case FIMC_A:
							Disp("\n [FIMC_A] ");
							break;
						case FIMC_B:
							Disp("\n [FIMC_B] ");
							break;
						case FIMC_C:
							Disp("\n [FIMC_C] ");
							break;
						default:
							//Assert(0);
							break;	
					}
					Disp(" Current: %d (max: 7744)\n", (i*22*4*4)+(j*4*4)+(k*4)+m);
					Disp("[%d][i=%d][j=%d][k=%d][m=%d]",count++,i,j,k,m);	

					defaultCond.src =i;
					defaultCond.dst = j;
					
				//	defaultCond.src =21;
				//	defaultCond.dst = 21;
					
					defaultCond.srcOriginalImageWidth = uImgHVszList[k][0];
					defaultCond.srcOriginalImageHeight = uImgHVszList[k][1];

					defaultCond.dstScreenWidth = uImgHVszList[m][0];
					defaultCond.dstScreenHeight = uImgHVszList[m][1];
					defaultCond.dstImageWidth = defaultCond.dstScreenWidth;
					defaultCond.dstImageHeight = defaultCond.dstScreenHeight;
					
					SCALING_VARIOUS_SIZE_TEST;
				//	GetIntNum();

					uReturnValueOfVerifyResult = VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight);

					uErrCount = uErrCount + uReturnValueOfVerifyResult;

					if(uReturnValueOfVerifyResult == 1)
					{
						DispCSCDebug();
					}
					
				}				
			}
		}
	}

	if(uErrCount == 0)
	{
		return true;
	}
	else
	{
		return false;
	}	
}

u8 Test_DinDoutUsingCModel(void)
{
	u8 bReturnValueOfFimcA;
	u8 bReturnValueOfFimcB;
	u8 bReturnValueOfFimcC;
		
	eFimc = FIMC_A;
	SelFimcPath(0);	
	Disp("\n[CAMIF 0]\n ");
	bReturnValueOfFimcA = Test_Scaling_Various_Size();

	eFimc = FIMC_B;
	SelFimcPath(1);	
	Disp("\n[CAMIF 1]\n ");
	bReturnValueOfFimcB = Test_Scaling_Various_Size();

	eFimc = FIMC_C;
	SelFimcPath(2);	
	Disp("\n[CAMIF 2]\n ");
	bReturnValueOfFimcC = Test_Scaling_Various_Size();

	if((bReturnValueOfFimcA==true)&&(bReturnValueOfFimcB==true)&&(bReturnValueOfFimcC==true))
	{
		
		return true;
	}
	else
	{
		return false;
	}
}
#endif

#if 0 //for c_model (vega_L->c100)
#define SCALING_VARIOUS_SIZE_LOCALPATH_TEST 	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;\
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;\
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);\
	POST_DispPostCondition(&defaultCond);Disp("...");\
	POST_SetCondition(defaultCond);\
	InitLCD(RGB24);\
	for(j=0;j<0xff;j++)j=j;\
	LCDC_Stop();\
	LCDC_SetWinOnOff(0, WIN0);\
	LCDC_InitLdi(MAIN);\
	LCDC_InitIpForFifoIn(IN_POST, WIN0);\
	LCDC_SetWinOnOff(1, WIN0);\
	LCDC_Start();\
	Disp("press any key to display image\n");\
	GetChar();\
	POST_DoConverting();\
	Disp("See screen. press any key to continue\n");\
	GetChar();\
	POST_StopAudoLoad()

void static Test_Scaling_Various_Size_LocalPath()
{
	volatile int j;
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_YCbCr420_3PLANE;
	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
	
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth = defaultCond.dstScreenWidth;
	defaultCond.dstImageHeight = defaultCond.dstScreenHeight;

	#if 0
	defaultCond.postPath = POST_DMA;
	defaultCond.runMode = ONE_SHOT;
	//defaultCond.srcOriginalImageWidth = 1408;
	//defaultCond.srcOriginalImageHeight = 1152;
	defaultCond.srcOriginalImageWidth = 1024;
	defaultCond.srcOriginalImageHeight = 768;
	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_DispPostCondition(&defaultCond);Disp("...");
	POST_SetCondition(defaultCond);
	InitLCD(RGB24);
	/*
	for(j=0;j<0xff;j++);
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);
	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
	*/
	Disp("press any key to display image\n");
	GetChar();
	POST_DoConverting();
	Disp("See screen. press any key to continue\n");
	GetChar();
	return;
	#endif

	/*
	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight = 320;
	defaultCond.srcImageWidth = defaultCond.srcOriginalImageWidth;
	defaultCond.srcImageHeight = defaultCond.srcOriginalImageHeight;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_DispPostCondition(&defaultCond);Disp("...");
	POST_SetCondition(defaultCond);
	InitLCD(RGB24);
	for(j=0;j<0xff;j++);
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);
	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
	Disp("press any key to display image\n");
	GetChar();
	POST_DoConverting();
	Disp("See screen. press any key to continue\n");
	GetChar();
	POST_StopAudoLoad();
	*/

	defaultCond.srcOriginalImageWidth = 128;
	defaultCond.srcOriginalImageHeight = 96;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;
	
	defaultCond.srcOriginalImageWidth = 176;
	defaultCond.srcOriginalImageHeight = 144;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 352;
	defaultCond.srcOriginalImageHeight = 288;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;
	
	defaultCond.srcOriginalImageWidth = 704;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 320;
	defaultCond.srcOriginalImageHeight = 240;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 640;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 768;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 720;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 128;
	defaultCond.srcOriginalImageHeight = 96;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.src = POST_COLOR_FORMAT_RGB565;
	defaultCond.srcOriginalImageWidth = 176;
	defaultCond.srcOriginalImageHeight = 144;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 352;
	defaultCond.srcOriginalImageHeight = 288;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;
	
	defaultCond.srcOriginalImageWidth = 704;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 320;
	defaultCond.srcOriginalImageHeight = 240;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 640;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 768;
	defaultCond.srcOriginalImageHeight = 576;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;

	defaultCond.srcOriginalImageWidth = 720;
	defaultCond.srcOriginalImageHeight = 480;
	SCALING_VARIOUS_SIZE_LOCALPATH_TEST;


	
}
#endif

#define ZOOM_TEST POST_DispPostCondition(&defaultCond);Disp("...");\
	ClearDstBuffer(defaultCond.dstScreenWidth,defaultCond.dstScreenHeight,0);\
	POST_SetCondition(defaultCond);\
	POST_DoConverting();\
	POST_SetConditionSW(defaultCond);\
	POST_DoConvertingSW();\
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))\
	{\
		DispCSCDebug();\
		UART_GetIntNum();\
	}

void static Test_Zoom()
{
	POST_CONDITION defaultCond;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_YCbCr420_3PLANE;
	
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight=320;
	defaultCond.dstImageWidth = 120;
	defaultCond.dstImageHeight = 160;
	defaultCond.srcOriginalImageWidth = 640;
	defaultCond.srcOriginalImageHeight = 480;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	defaultCond.srcImageWidth = 320;
	defaultCond.srcImageHeight = 240;
	defaultCond.srcOffsetX = 0;
	defaultCond.srcOffsetY = 240;
	defaultCond.dstOffsetX = 0;
	defaultCond.dstOffsetY = 0;
	ZOOM_TEST;

	defaultCond.srcImageWidth = 128;
	defaultCond.srcImageHeight = 96;
	defaultCond.srcOffsetX = 0;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 120;
	defaultCond.dstOffsetY = 0;
	ZOOM_TEST;

	defaultCond.srcImageWidth = 352;
	defaultCond.srcImageHeight = 288;
	defaultCond.srcOffsetX = 640-352;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 0;
	defaultCond.dstOffsetY = 160;
	ZOOM_TEST;

	defaultCond.srcImageWidth = 512;
	defaultCond.srcImageHeight = 480;
	defaultCond.srcOffsetX = 640-512;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 120;
	defaultCond.dstOffsetY = 160;
	ZOOM_TEST;

	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcImageWidth = 320;
	defaultCond.srcImageHeight = 240;
	defaultCond.srcOffsetX = 0;
	defaultCond.srcOffsetY = 240;
	defaultCond.dstOffsetX = 0;
	defaultCond.dstOffsetY = 0;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	ZOOM_TEST;

	defaultCond.srcImageWidth = 128;
	defaultCond.srcImageHeight = 96;
	defaultCond.srcOffsetX = 0;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 120;
	defaultCond.dstOffsetY = 0;
	ZOOM_TEST;

	defaultCond.srcImageWidth = 352;
	defaultCond.srcImageHeight = 288;
	defaultCond.srcOffsetX = 640-352;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 0;
	defaultCond.dstOffsetY = 160;
	ZOOM_TEST;

	defaultCond.srcImageWidth = 512;
	defaultCond.srcImageHeight = 480;
	defaultCond.srcOffsetX = 640-512;
	defaultCond.srcOffsetY = 0;
	defaultCond.dstOffsetX = 120;
	defaultCond.dstOffsetY = 160;
	ZOOM_TEST;
	
	
}

static void Test_InterruptHandler()
{
	Disp("Interrupt Occurred\n");
}

static void Test_Interrupt()
{

	POST_CONDITION defaultCond;
		POST_CONDITION *cond;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight= 320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=32;
	defaultCond.dstImageHeight =32;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	defaultCond.waitMode = POST_WAIT_MODE_INTERRUPT;

	POST_SetInterruptHandler(Test_InterruptHandler);

	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);
	Full_CSC_Test(cond);

}

static void Test_AutoLoadEnable_Output()
{
	POST_CONDITION defaultCond;
		POST_CONDITION *cond;
	u32 *tmp;
	u32 i;
	int s_index;
	int e_index;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcOriginalImageWidth = 480;
	defaultCond.srcOriginalImageHeight= 272;
	defaultCond.srcImageWidth=32;
	defaultCond.srcImageHeight = 32;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=32;
	defaultCond.dstImageHeight =32;
	defaultCond.srcOffsetX = 16;
	defaultCond.srcOffsetY = 16;
	defaultCond.runMode = FREE_RUN;

	defaultCond.OutAddr1.Y = DST0_Y_ADDR;
	defaultCond.OutAddr1.Cb = DST0_Cb_ADDR;
	defaultCond.OutAddr1.Cr = DST0_Cr_ADDR;
	defaultCond.OutAddr2.Y = DST1_Y_ADDR;
	defaultCond.OutAddr2.Cb = DST1_Cb_ADDR;
	defaultCond.OutAddr2.Cr = DST1_Cr_ADDR;
	defaultCond.OutAddr3.Y = DST2_Y_ADDR;
	defaultCond.OutAddr3.Cb = DST2_Cb_ADDR;
	defaultCond.OutAddr3.Cr = DST2_Cr_ADDR;
	defaultCond.OutAddr4.Y = DST3_Y_ADDR;
	defaultCond.OutAddr4.Cb = DST3_Cb_ADDR;
	defaultCond.OutAddr4.Cr = DST3_Cr_ADDR;	
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);

	for(i=0;1;i++)
	{
		Disp("[%d]",i);
		if(cond[i].temp<0)break;
		POST_DispPostCondition(&(cond[i]));
		Disp("...");
		GenerateSourceImage(cond[i].src,cond[i].srcOriginalImageWidth,cond[i].srcOriginalImageHeight);

		POST_SetCondition(cond[i]);
		POST_SetConditionSW(cond[i]);

		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,0);
		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,1);
		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,2);
		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,3);
		s_index = POST_GetCurrentOuputIndex();
		Disp("start index=%d\n",s_index);

		POST_DoConverting();

		while(1)
		{
			e_index=POST_GetCurrentOuputIndex();
			if((s_index+4)%4==e_index)break;
		}

		POST_StopAudoLoad();
		e_index = POST_GetCurrentOuputIndex();
		Disp("end index=%d\n",e_index);
		
		POST_DoConvertingSW();
		POST_WaitConvertingSW();

		
		if(VerifyResult(cond[i].dst,0,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
		if(VerifyResult(cond[i].dst,1,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
		if(VerifyResult(cond[i].dst,2,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
		if(VerifyResult(cond[i].dst,3,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
	}

	
}


static void Test_AutoLoadEnable_Input()
{
	POST_CONDITION defaultCond;
		POST_CONDITION *cond;
	u32 *tmp;
	u32 i,k;
	volatile u32 j;
	int s_index;
	int e_index;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight= 320;
	defaultCond.srcImageWidth=32;
	defaultCond.srcImageHeight = 32;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=32;
	defaultCond.dstImageHeight =32;
	defaultCond.srcOffsetX = 16;
	defaultCond.srcOffsetY = 16;
	defaultCond.runMode = FREE_RUN;
	cond=POST_getPostConditions(defaultCond, CONDITION_BUFFER);

	tmp = (u32 *)(SRC_Y_ADDR+0x300000);
	for(i=0;i<240*320;i++)tmp[i]=0;
	tmp = (u32 *)(SRC_Y_ADDR+0x400000);
	for(i=0;i<240*320;i++)tmp[i]=0;
	tmp = (u32 *)(SRC_Y_ADDR+0x500000);
	for(i=0;i<240*320;i++)tmp[i]=0;

	tmp = (u32 *)(SRC_Y_ADDR);
	for(i=0;i<240*320;i++)tmp[i]=0xff;
	tmp = (u32 *)(SRC_Y_ADDR+0x100000);
	for(i=0;i<240*320;i++)tmp[i]=0xff;
	tmp = (u32 *)(SRC_Y_ADDR+0x200000);
	for(i=0;i<240*320;i++)tmp[i]=0xff;

	#if 0
	defaultCond.dst = POST_COLOR_FORMAT_RGB565;
	defaultCond.src = POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER;
	defaultCond.runMode = ONE_SHOT;
//	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);
	POST_SetCondition(defaultCond);
	POST_SetConditionSW(defaultCond);
	POST_DoConverting();
	POST_WaitConverting();
	POST_DoConvertingSW();
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
	{
		DispCSCDebug();
		GetInt();
	}
	Disp("ok 1\n");
//	Disp("See screen filled by green.Press any key to enable 'ADD_CHG_DISABLE'\n");
//	GetChar();
	POST_SetAddChangeDisable(1);
	Disp("Set addr=0x%x 0x%x 0x%x\n",SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
	POST_SetInputDMAAddr(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
	POST_DoConverting();
	POST_WaitConverting();
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
	{
		DispCSCDebug();
		GetInt();
	}
	Disp("ok 2\n");
//	Disp("See screen filled by green too. Press any key to disable 'ADD_CHG_DISABLE'\n");
//	GetChar();
	POST_SetAddChangeDisable(0);
	Disp("Set addr=0x%x 0x%x 0x%x\n",SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
	POST_SetInputDMAAddr(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
	POST_SetInputDMAAddrSW(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
	POST_DoConverting();
	POST_WaitConverting();
	POST_DoConvertingSW();
	if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
	{
		DispCSCDebug();
		GetInt();
	}	
	Disp("ok 3\n");
//	Disp("See screen filled by block. Press any key to disable 'ADD_CHG_DISABLE'\n");
//	GetChar();
	//POST_DoConvertingSW();
	//DispCSCDebug();
	return;
	#endif

	for(i=0;1;i++)
	{
		Disp("[%d]",i);
		if(cond[i].temp<0)break;
		POST_DispPostCondition(&(cond[i]));
		Disp("...");

		POST_SetCondition(cond[i]);
		POST_SetConditionSW(cond[i]);

		ClearDstBuffer(cond[i].dstScreenWidth,cond[i].dstScreenHeight,0);
		POST_DoConverting();

		for(j=0;j<0xfff;j++)j=(j*2)/2; //delay

		if(i%2==0)
		{
			POST_SetAddChangeDisable(1);
			POST_SetInputDMAAddr(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
			s_index = POST_GetCurrentOuputIndex();

			#if 1		
			do
			{
				e_index = POST_GetCurrentOuputIndex();
			}while(s_index==e_index);
			#else
			POST_StopAudoLoad();
			#endif

			POST_StopAudoLoad();
			e_index = POST_GetCurrentOuputIndex();
			Disp("s_index=%d e_index=%d\n",s_index,e_index);

			POST_DoConvertingSW();

			if(VerifyResult(cond[i].dst,0,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
			{
				DispCSCDebug();
				UART_GetIntNum();
			}
		}	
		else
		{
			POST_SetAddChangeDisable(0);
			POST_SetInputDMAAddr(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);
			s_index = POST_GetCurrentOuputIndex();

			#if 1		
			do
			{
				e_index = POST_GetCurrentOuputIndex();
			}while(s_index==e_index);
			#else
			POST_StopAudoLoad();
			#endif

			POST_StopAudoLoad();
			e_index = POST_GetCurrentOuputIndex();
			Disp("s_index=%d e_index=%d\n",s_index,e_index);

			POST_SetInputDMAAddrSW(SRC_Y_ADDR+0x300000,SRC_Y_ADDR+0x400000,SRC_Y_ADDR+0x500000);	
			POST_DoConvertingSW();

			if(VerifyResult(cond[i].dst,0,cond[i].dstScreenWidth,cond[i].dstScreenHeight))
			{
				DispCSCDebug();
				UART_GetIntNum();
			}

		}

	}

	
}

static void Test_One2One()
{
	POST_CONDITION defaultCond;
	u32 i;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB565;
	defaultCond.src = POST_COLOR_FORMAT_RGB565;
	defaultCond.srcOriginalImageWidth = 480;
	defaultCond.srcOriginalImageHeight= 272;
	defaultCond.srcImageWidth=128;
	defaultCond.srcImageHeight = 240;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=128;
	defaultCond.dstImageHeight =240;
	defaultCond.srcOffsetX = 16;
	defaultCond.srcOffsetY = 16;	
	defaultCond.dstOffsetX = 32;
	defaultCond.dstOffsetY = 32;	
	defaultCond.One2One = 1;
#if defined(S5PV210)|defined(S5P6442)
	for(i=0;i<22;i++)
	{
		defaultCond.dst = i;
		defaultCond.src = defaultCond.dst ;
		
		POST_DispPostCondition(&defaultCond);
		GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

		POST_SetCondition(defaultCond);
		POST_SetConditionSW(defaultCond);	

		ClearDstBuffer(defaultCond.dstScreenWidth, defaultCond.dstScreenHeight  ,0);
		POST_DoConverting();
		POST_WaitConverting();

		POST_DoConvertingSW();
		POST_WaitConvertingSW();
		
		if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
	}
#elif  defined(S5PC100)
	for(i=0;i<22;i++)
	{
		defaultCond.dst = i;
		defaultCond.src = defaultCond.dst ;
		
		POST_DispPostCondition(&defaultCond);
		GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

		POST_SetCondition(defaultCond);
		POST_SetConditionSW(defaultCond);	

		ClearDstBuffer(defaultCond.dstScreenWidth, defaultCond.dstScreenHeight  ,0);
		POST_DoConverting();
		POST_WaitConverting();

		POST_DoConvertingSW();
		POST_WaitConvertingSW();
		
		if(VerifyResult(defaultCond.dst,0,defaultCond.dstScreenWidth,defaultCond.dstScreenHeight))
		{
			DispCSCDebug();
			UART_GetIntNum();
		}
		}
#endif	
}


static void Test_LocalPath()
{
	POST_CONDITION defaultCond;
		POST_CONDITION *cond;
	u32 *tmp;
	u32 i;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight= 320;
	defaultCond.srcImageWidth=240;
	defaultCond.srcImageHeight = 320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight =320;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
#if 0 //for c_model (vega_L->c100)
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
#endif
	POST_SetCondition(defaultCond);

	 tmp=(u32 *)FRAMEBUFFER_ADDR;
	 for(i=0;i<240*320;i++)tmp[i] = 0;
	 Disp("ready to local path. press any key to continue\n");
	 UART_Getc();

	POST_DoConverting();

	 Disp("See the screen. press any key to escape from local path mode\n");
	 UART_Getc();

	POST_StopAudoLoad();
#if 0 //for c_model (vega_L->c100)
	LCDC_PerFrameOff();
	LCDC_SetWinOnOff(0, WIN0);
	InitLCD(RGB24);
#endif


	
}

/* It has been dropped from spec.
void static Test_LocalPathWithDoubleBuffering()
{
	POST_CONDITION defaultCond;
	int i;
	u32 *tmpS;
	u32 *tmpD;
	int bufferIndex=0;
	
	POST_getDefaultPostCondition(&defaultCond);	
	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
	defaultCond.src = POST_COLOR_FORMAT_YCbCr420_3PLANE;
	//defaultCond.InputDoubleBufferEnable=1;

	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	tmpS = (u32 *)SRC_Y_ADDR;
	tmpD = (u32 *)(SRC_Y_ADDR+0x300000);
	for(i=0;i<defaultCond.srcOriginalImageWidth*defaultCond.srcOriginalImageHeight;i++)tmpD[i] = ~tmpS[i];
	tmpS = (u32 *)SRC_Cb_ADDR;
	tmpD = (u32 *)(SRC_Cb_ADDR+0x300000);
	for(i=0;i<defaultCond.srcOriginalImageWidth*defaultCond.srcOriginalImageHeight;i++)tmpD[i] = ~tmpS[i];
	tmpS = (u32 *)SRC_Cr_ADDR;
	tmpD = (u32 *)(SRC_Cr_ADDR+0x300000);
	for(i=0;i<defaultCond.srcOriginalImageWidth*defaultCond.srcOriginalImageHeight;i++)tmpD[i] = ~tmpS[i];

	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();	

	POST_SetCondition(defaultCond);
	POST_SetInputDMAAddr2(SRC_Y_ADDR+0x300000, SRC_Cb_ADDR+0x300000,SRC_Cr_ADDR+0x300000);
	POST_DoConverting();

	while(1)
	{
		Disp("Press 'x' to escape or any key to change input buffer\n");
		if(GetChar()=='x')break;

		if(bufferIndex)bufferIndex=0;
		else bufferIndex=1;
		POST_SetInputBuffer(bufferIndex);
	}
	
}
*/

void Test_SeeOriginalImage()
{
	 u32 *tmp;
	int i;
#if 0
	 InitLCD(RGB24);
#endif

	 tmp=(u32 *)FRAMEBUFFER_ADDR;
	 for(i=0;i<240*320;i++)tmp[i] = sun240320_24bpp[i];
}

static void Test_AutoEnable_ENVID()
{
	POST_CONDITION defaultCond;
		POST_CONDITION *cond;
	u32 *tmp;
	u32 i;
	POST_getDefaultPostCondition(&defaultCond);

	defaultCond.dst = POST_COLOR_FORMAT_RGB888;
	defaultCond.src = POST_COLOR_FORMAT_RGB888;
	defaultCond.srcOriginalImageWidth = 240;
	defaultCond.srcOriginalImageHeight= 320;
	defaultCond.srcImageWidth=240;
	defaultCond.srcImageHeight = 320;
	defaultCond.dstScreenWidth = 240;
	defaultCond.dstScreenHeight = 320;
	defaultCond.dstImageWidth=240;
	defaultCond.dstImageHeight =320;
	GenerateSourceImage(defaultCond.src,defaultCond.srcOriginalImageWidth,defaultCond.srcOriginalImageHeight);

	defaultCond.postPath = POST_FIFO;
	defaultCond.runMode = FREE_RUN;
#if 0 //for c_model (vega_L->c100)
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIpForFifoIn(IN_POST, WIN0);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_Start();
#endif

	POST_SetCondition(defaultCond);

	 tmp=(u32 *)FRAMEBUFFER_ADDR;
	 for(i=0;i<240*320;i++)tmp[i] = 0;
	 Disp("ready to local path. press any key to continue\n");
	 UART_Getc();

	POST_DoConverting();

	 Disp("See the screen. press any key to escape from local path mode\n");
	 UART_Getc();

	POST_StopAudoLoad();
	POST_CheckENVID();

#if 0 //for c_model (vega_L->c100)	
	LCDC_Stop();
	LCDC_SetWinOnOff(0, WIN0);
	InitLCD(RGB24);	
#endif

}

void Sel_Fimc_Path(void)
{
		u32 sel;
		Disp("\n Select the FIMC PATH to test : ");
		Disp("\n 0> FIMC_A  1>FIMC_B  2>FIMC_C: ");
		sel = UART_GetIntNum();
		switch(sel)
		{
			case 0: 
				eFimc = FIMC_A;
				break;
			case 1:
				eFimc = FIMC_B;
				break;
			case 2:
				eFimc = FIMC_C;
				break;
			default:
				//Assert(0);
				break;
			}
			
		SelFimcPath(sel);

}

void Test_FIMC_2nd(void) 
{
	int i, sel;

	testFuncMenu menu[]=
	{
		0,                 			"Exit",
			Sel_Fimc_Path,"Select FIMC path (A, B, C)",			
	//		Test_initReg,"Test initial register values (need to check more)",							//need to check more
	//		Test_SimpleScaling,"Test simple scaling (need to check more)",						//need to check more
			Test_SimpleScalingLocalPath,"Test simple scaling with localpath and changing input buffer",
			Test_CSC_DMAtoDMA,"Test Color Convertion DMA to DMA",
	//		Test_CSC_LocalPath , "Test Color Convertion LocalPath",
	//		Test_R2Y_Narrow,"Test R2Y Narrow DMA to DMA (need to check more)",					//need to check more
	//		Test_R2Y_Narraw_LocalPath,"Test R2Y Narrow LocalPath",
	//		Test_R2Y_NarrowSample,"Test R2Y Narrow example (need to check more)",				//need to check more
	//		Test_Y2R_Narrow,"Test Y2R Narrow DMA to DMA (need to check more)",					//need to check more
	//		Test_Y2R_Narrow_LocalPath,"Test Y2R Narrow LocalPath",
	//		Test_Y2R_NarrowSample,"Test Y2R Narrow example (need to check more)",				//need to check more
	//		Test_RGB_Extension,"Test RGB Extension (need to check more)",						//need to check more
			Test_Scaleup_All_CSC, "Test Scale up for All CSC",	
			Test_Scaledown_All_CSC, "Test Scale down for All CSC",
			Test_Scaling_Various_SizeForSortingChip, "Test Scaling various size for sorting chip",
			
			Test_DinDoutForSortingChip, "Test DMA-in DMA-out for sorting chip",
			Test_DinDoutUsingCModel, "Test DMA-in DMA-out using C model",
			
#if 0 //for c_model (vega_L->c100)
			Test_Scaling_Various_Size_LocalPath, "Test Scaling various size through localpath",
#endif

	//		Test_Zoom , "Test Zoom",
	//		Test_Interrupt, "Test Interrupt",
	//		Test_AutoLoadEnable_Output, "Test Auto Load for output DMA address changing",
	//		Test_AutoLoadEnable_Input, "Test Auto Load for input DMA address changing",
	//		Test_LocalPath, "Test Local path",
			//Test_LocalPathWithDoubleBuffering, "Test Local Path with double buffering",
	//		Test_One2One, "Test One2One",
	//		Test_SeeOriginalImage, " Original Image",
	//		Test_AutoEnable_ENVID, "Test AutoEnable and ENVID",
		0,0
	};

//	INTC_Init();		//Interrupt vector intialize
#if 0 //for c_model (vega_L->c100)
	 InitLCD(RGB24);
#endif

	while(true)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("\n Select the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
		{
			break;
		}
		else if (sel>0 && sel<(sizeof(menu)/8-1))
		{
			(menu[sel].func) ();
		}
		}
	
}

