/*-------------------------------------------------------------
 * Filename: post_condition.c
 *
 * Contents: Implemention of software emulation for Post processor of s5c6440
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee 2008.10.01
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
//#include<system.h>

#if defined(S5PC100)
#include "typedef.h"
#include "system.h"
#elif defined(S5PV210)
#include "string.h"
//#include "user_def.h"
#include "def.h"
#include "option.h"
#include "util.h"
#elif defined(S5P6442)
#include "string.h"
#include "user_def.h"
#include "def.h"
#include "option.h"
#endif

#include<fimc_2nd.h>
#include<fimc_conditions.h>
#include<fimc_sw.h>
#include<fimc_test_2nd.h>

POST_CONDITION cond;


#if 0 //for c_model (vega_L->c100)
#if TARGET==SYSTEM_6440
#define POST_SW_ETERNAL_BUF 0x22000000 
#else
#define POST_SW_ETERNAL_BUF 0x52000000 
#endif
#endif

//#if defined(S5PC100)
#if defined(S5PV210)
//#define POST_SW_ETERNAL_BUF 0x62000000 
//#define POST_SW_ETERNAL_BUF 0x52000000 
#define POST_SW_ETERNAL_BUF 0x42000000 
#elif defined(S5P6442)
#define POST_SW_ETERNAL_BUF 0x22000000 
#endif

static u32 DataBankIndex;

#define  FSize       8     
#define  BYPASS      0
#define  ARBIT_CBCR  1
#define  NEGATIVE    2
#define  ARTFREEZE   3
#define  EMBOSSING   4
#define  SILHOUETTE  5

typedef struct
{
	u32 PreHorRatio;
	u32 PreVerRatio;
	u32 H_Shift;
	u32 V_Shift;
	u32 PreDstWidth;
	u32 PreDstHeight;
	u32 MainHorRatio;
	u32 MainVerRatio;
	u32 SHfactor;
	u32 ScaleUp_H;
	u32 ScaleUp_V;
}SCALER_FACTOR;

static SCALER_FACTOR ScalerFactor;

static		unsigned int PreScaleDST_Width;
static	unsigned int PreScaleDST_Height;

static	int From420to444;
static	int From422to444;
static	int From444to444;
static	int InRGB;
static	int In422;

typedef struct
{
	u8 *y;
	u8 *cb;
	u8 *cr;
}YCBCR_BUF;

static YCBCR_BUF GetDataBuf(int index)
{
	YCBCR_BUF ycbcr;
	u32 *buf;
	int height;
	int width;
	buf = (u32 *)POST_SW_ETERNAL_BUF;
	if(cond.srcImageHeight>cond.dstImageHeight)height = cond.srcImageHeight;
	else height = cond.dstImageHeight;
	if(cond.srcImageWidth>cond.dstImageWidth)width = cond.srcImageWidth;
	else width = cond.dstImageWidth;

	buf+=height*width*index;

	ycbcr.y = (u8 *)buf;
	ycbcr.cb =ycbcr.y+height*width;
	ycbcr.cr = ycbcr.cb+height*width;

	return ycbcr;
}

/*************************
  Function CSCR2Y ( Color space Convertor RGB to YCbCr)

  Input
  R[7:0], G[7:0], B[7:0]
  Return Value
  CSCR2Y[23:16] : Y
  CSCR2Y[15: 8] : Cb
  CSCR2Y[ 7: 0] : Cr
  Control by R2YCSEL
0 : YCbCr Narrow Range
1 : YCbCr Wide Range
 ************************/
int CSCR2Y_C(int R, int G, int B, int R2YCSEL)
{
	int      i;
	int      y;
	int      cb;
	int      cr;
	int      Y;
	int      Cb;
	int      Cr;
	int      R25;
	int      G50;
	int      B09;
	int      R14;
	int      G29;
	int      B43;
	int      R43;
	int      G36;
	int      B07;
	int      r25;
	int      g50;
	int      b09;
	int      r14;
	int      g29;
	int      b43;
	int      r43;
	int      g36;
	int      b07;

	int             R25_8;
	int             r25_8;
	int             G50_8;
	int             g50_8;
	int             B09_8;
	int             b09_8;
	int             R14_8;
	int             r14_8;
	int             G29_8;
	int             g29_8;
	int             B43_8;
	int             b43_8;
	int             R43_8;
	int             r43_8;
	int             G36_8;
	int             g36_8;
	int             B07_8;
	int             b07_8;

	int      CSCR2Y;
	int      CSCR2y;

	// if ( R2YSel ) {
	//      y  = 0.299*r  + 0.587*g + 0.114*b;
	//      cb = -0.172*r - 0.339*g + 0.511*b + 128;
	//      cr = 0.511*r  - 0.428*g - 0.083*b + 128;
	// }
	// else {
	//      y  = 0.257*r  + 0.504*g + 0.098*b + 16;
	//      cb = -0.148*r - 0.291*g + 0.439*b + 128;
	//      cr = 0.439*r  - 0.368*g - 0.071*b + 128;

	R25     = (R<<6) + (R<<1);
	r25     = (R<<6) + (R<<3) + (R<<2) + (R);
	G50     = (G) + (G<<7);
	g50     = (G<<7) + (G<<4) + (G<<2) + (G<<1);
	B09     = (B<<4) + (B<<3) + (B);
	b09     = (B<<4) + (B<<3) + (B<<2) + (B);
	R14     = (R<<5) + (R<<2) + (R<<1);
	r14     = (R<<5) + (R<<3) + (R<<2);
	G29     = (G<<6) + (G<<3) + (G<<1);
	g29     = (G<<6) + (G<<4) + (G<<3) - (G);
	B43     = (B<<6) + (B<<5) + (B<<4);
	b43     = (B<<7) + (B<<1) + (B);
	R43     = (R<<6) + (R<<5) + (R<<4);
	r43     = (R<<7) + (R<<1) + (R);
	G36     = (G<<7) - (G<<5) - (G<<1);
	g36     = (G<<7) - (G<<4) - (G<<1);
	B07     = (B<<4) + (B<<1);
	b07     = (B<<4) + (B<<2) + (B);

	//Y  =    (R25>>8)  + (G50>>8) + (B09>>8) + 16 ;
	//Cb = (- (R14>>8)) - (G29>>8) + (B43>>8) + 128;
	//Cr =    (R43>>8)  - (G36>>8) - (B07>>8) + 128;

	Y  =    ((R25  + G50 + B09 + (16<<8) + 128)>>8);
	Cb = ((- R14 - G29 + B43 + (128<<8) + 128)>>8);
	Cr =    ((R43  - G36 - B07 + (128<<8) + 128)>>8);

	// for saturation
	if ( Y > 235 ) Y = 235;
	else if ( Y < 16 ) Y = 16;
	else Y = Y;

	if ( Cb > 240 ) Cb = 240;
	else if ( Cb < 16 ) Cb = 16;
	else Cb = Cb;

	if ( Cr > 240 ) Cr = 240;
	else if ( Cr < 16 ) Cr = 16;
	else Cr = Cr;

	//y  =    (r25>>8)  + (g50>>8) + (b09>>8);
	//cb = (- (r14>>8)) - (g29>>8) + (b43>>8) + 128;
	//cr =    (r43>>8)  - (g36>>8) - (b07>>8) + 128;
	
	y  =    ((r25  + g50 + b09 + 128)>>8);
	cb = ((- r14 - g29 + b43 + (128<<8) + 128)>>8);
	cr =    ((r43 - g36 - b07 + (128<<8) + 128)>>8);

	// for saturation
	if ( y > 255 ) y = 255;
	else if ( y < 0 ) y = 0;
	else y = y;

	if ( cb > 255 ) cb = 255;
	else if ( cb < 0 ) cb = 0;
	else cb = cb;

	if ( cr > 255 ) cr = 255;
	else if ( cr < 0 ) cr = 0;
	else cr = cr;

	//soo debug
	//printf("y = %d\n",y);
	//printf("cb = %d\n",cb);
	//printf("cr = %d\n",cr);

	/* R2YCSEL == 0 */ 
	CSCR2Y = 0x00ffffff & (((0xff&Y)<<16) + ((0xff&Cb)<<8) + ((0xff&Cr)<<0));
	/* R2YCSEL == 1 */
	CSCR2y = 0x00ffffff & (((0xff&y)<<16) + ((0xff&cb)<<8) + ((0xff&cr)<<0));

	//printf("ff&cb<<8  = %d\n",(0xff&cb)<<8);

	if (R2YCSEL) return CSCR2y;
	else  return CSCR2Y;

}

static u32 CSCY2R(int y,int cb,int cr,int Y2RCSEL)
{
	int r,g,b;
	int s_y,s_cb,s_cr;
	

	if(Y2RCSEL)
	{
		if (cb >= 128)
		{
			cb = cb - 128;
			s_cb = 1; 
		}
		else 
		{
			cb = 128 - cb;
			s_cb = -1;
		}
		if (cr >= 128)
		{
			cr = cr - 128;
			s_cr = 1;
		}
		else
		{
			cr = 128 - cr;
			s_cr = -1;
		}
		r = (((y<<8) + s_cr*((cr<<8) + (cr<<6) + (cr<<5)) + 128)>>8);
		g = (((y<<8) - s_cr*((cr<<7) + (cr<<5) + (cr<<4) + (cr<<1) + cr) - s_cb*((cb<<6) + (cb<<4) + (cb<<2) + (cb<<1)) + 128)>>8);
		b = (((y<<8) + s_cb * ((cb<<8) + (cb<<7) + (cb<<5) + (cb<<4) + (cb<<3) + (cb<<1) + cb) + 128)>>8);
	}
	else
	{
		if ( y < 16 ) y = 16;
		else if ( y > 235 ) y = 235;
		else y = y;

		if ( cb < 16 ) cb = 16;
		else if ( cb > 240 ) cb = 240;
		else cb = cb;

		if ( cr < 16 ) cr = 16;
		else if ( cr > 240 ) cr = 240;
		else cr = cr;

		y = y - 16;
		if (cb >= 128) 
		{
			cb = cb - 128;
			s_cb = 1;
		}
		else 
		{
			cb = 128 - cb;
			s_cb = -1;
		}

		if (cr >= 128) 
		{
			cr = cr - 128;
			s_cr = 1;
		}
		else 
		{
			cr = 128 - cr;
			s_cr = -1;
		}
	          r = ((((y<<7) + (y<<4) + (y<<2) + y) + s_cr * ((cr<<7) + (cr<<6) + (cr<<3) + (cr<<2)) + 64)>>7);
   	          g = ((((y<<7) + (y<<4) + (y<<2) + y) - s_cr * ((cr<<6) + (cr<<5) + (cr<<3)) - 
   	                   s_cb * ((cb<<5) + (cb<<4) + (cb<<1)) + 64)>>7);
   	          b = ((((y<<7) + (y<<4) + (y<<2) + y) + s_cb * ((cb<<8) + (cb<<1)) + 64)>>7);
	}

	if(r>255)r=255;
	if(r<0)r=0;
	if(g>255)g=255;
	if(g<0)g=0;
	if(b>255)b=255;
	if(b<0)b=0;

	return ((r & 0xff)<<16)|((g & 0xff)<<8)|(b & 0xff);

	
}

static void SetScalerFactorSW()
{
	if(cond.srcImageWidth>=64*cond.dstImageWidth)return;
	else if(cond.srcImageWidth>=32*cond.dstImageWidth){ScalerFactor.PreHorRatio=32; ScalerFactor.H_Shift=5;}
	else if(cond.srcImageWidth>=16*cond.dstImageWidth){ScalerFactor.PreHorRatio=16; ScalerFactor.H_Shift=4;}
	else if(cond.srcImageWidth>=8*cond.dstImageWidth){ScalerFactor.PreHorRatio=8; ScalerFactor.H_Shift=3;}
	else if(cond.srcImageWidth>=4*cond.dstImageWidth){ScalerFactor.PreHorRatio=4;ScalerFactor.H_Shift=2;}
	else if(cond.srcImageWidth>=2*cond.dstImageWidth){ScalerFactor.PreHorRatio=2; ScalerFactor.H_Shift=1;}
	else {ScalerFactor.PreHorRatio=1; ScalerFactor.H_Shift=0;}

	ScalerFactor.PreDstWidth=cond.srcImageWidth/ScalerFactor.PreHorRatio;
	ScalerFactor.MainHorRatio=(cond.srcImageWidth<<8)/(cond.dstImageWidth<<ScalerFactor.H_Shift);

	if(cond.srcImageHeight>=64*cond.dstImageHeight)return;
	else if(cond.srcImageHeight>=32*cond.dstImageHeight){ScalerFactor.PreVerRatio=32; ScalerFactor.V_Shift=5;}
	else if(cond.srcImageHeight>=16*cond.dstImageHeight){ScalerFactor.PreVerRatio=16; ScalerFactor.V_Shift=4;}
	else if(cond.srcImageHeight>=8*cond.dstImageHeight){ScalerFactor.PreVerRatio=8; ScalerFactor.V_Shift=3;}
	else if(cond.srcImageHeight>=4*cond.dstImageHeight){ScalerFactor.PreVerRatio=4;ScalerFactor.V_Shift=2;}
	else if(cond.srcImageHeight>=2*cond.dstImageHeight){ScalerFactor.PreVerRatio=2; ScalerFactor.V_Shift=1;}
	else {ScalerFactor.PreVerRatio=1; ScalerFactor.V_Shift=0;}

	ScalerFactor.PreDstHeight=cond.srcImageHeight/ScalerFactor.PreVerRatio;
	ScalerFactor.MainVerRatio=(cond.srcImageHeight<<8)/(cond.dstImageHeight<<ScalerFactor.V_Shift);
	ScalerFactor.SHfactor=10-(ScalerFactor.H_Shift + ScalerFactor.V_Shift);

	if(cond.dstImageWidth>=cond.srcImageWidth)ScalerFactor.ScaleUp_H=1;
	else ScalerFactor.ScaleUp_H=0;
	if(cond.dstImageHeight>=cond.srcImageHeight)ScalerFactor.ScaleUp_V=1;
	else ScalerFactor.ScaleUp_V=0;
}

 int POST_SetConditionSW(POST_CONDITION cond_)
{
	cond = cond_;
	#if 1
	cond.OutAddr1.Y = V_DST0_Y_ADDR;
	cond.OutAddr1.Cb = V_DST0_Cb_ADDR;
	cond.OutAddr1.Cr = V_DST0_Cr_ADDR;
	cond.OutAddr2.Y = V_DST1_Y_ADDR;
	cond.OutAddr2.Cb = V_DST1_Cb_ADDR;
	cond.OutAddr2.Cr = V_DST1_Cr_ADDR;
	cond.OutAddr3.Y = V_DST2_Y_ADDR;
	cond.OutAddr3.Cb = V_DST2_Cb_ADDR;
	cond.OutAddr3.Cr = V_DST2_Cr_ADDR;
	cond.OutAddr4.Y = V_DST3_Y_ADDR;
	cond.OutAddr4.Cb = V_DST3_Cb_ADDR;
	cond.OutAddr4.Cr = V_DST3_Cr_ADDR;
	#endif

	SetScalerFactorSW();


	PreScaleDST_Width = cond.srcImageWidth / ScalerFactor.PreHorRatio;
	PreScaleDST_Height = cond.srcImageHeight / ScalerFactor.PreVerRatio;

	switch(cond.src)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			InRGB = 0;
			In422 = 0;

			From420to444 = 1;
			From422to444 = 0;
			From444to444 = 0;

			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			InRGB = 0;
			In422 = 1;

			From420to444 = 0;
			From422to444 = 1;
			From444to444 = 0;

			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			InRGB = 1;
			In422 = 1;
			From420to444 = 0;
			From422to444 = 0;
			From444to444 = 1;
			break;
		case POST_COLOR_FORMAT_RGB565:
		case POST_COLOR_FORMAT_RGB666:
		case POST_COLOR_FORMAT_RGB888:
			InRGB = 1;
			In422 = 1;

			From420to444 = 0;
			From422to444 = 0;
			From444to444 = 1;

			break;
	}

}


static void setColor(POST_COLOR_ELEMENT RGBElement,POST_COLOR_ELEMENT YCbCrElement,
	int offset,int stride,POST_COLOR_YCBCR target,int x,int y)
{

	u8 *YAddr;
	u8 *CbAddr;
	u8 *CrAddr;
	u32 *RGB32;
	u16 *RGB16;
	u32 tmp;

	YAddr = (u8 *)target.Y;
	CbAddr = (u8 *)target.Cb;
	CrAddr = (u8 *)target.Cr;
	RGB32 = (u32 *)target.Y;
	RGB16 = (u16 *)target.Y;
		
	switch(cond.dst)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0 && y%2==0)
			{
				CbAddr[cond.dstOffsetX+(cond.dstOffsetY/2)*stride+x+(y/2)*stride] = YCbCrElement.YCbCr.Cb;
				CbAddr[cond.dstOffsetX+(cond.dstOffsetY/2)*stride+x+(y/2)*stride+1] = YCbCrElement.YCbCr.Cr;			
			}
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0 && y%2==0)
			{
				CbAddr[cond.dstOffsetX+(cond.dstOffsetY/2)*stride+x+(y/2)*stride+1] = YCbCrElement.YCbCr.Cb;
				CbAddr[cond.dstOffsetX+(cond.dstOffsetY/2)*stride+x+(y/2)*stride] = YCbCrElement.YCbCr.Cr;			
			}
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0 && y%2==0)
			{
				tmp = cond.dstOffsetX+(cond.dstOffsetY/2)*stride+(x+(y/2)*stride)+6-((x+(y/2)*stride)%8)*2;
				CbAddr[tmp] = YCbCrElement.YCbCr.Cb;
				CbAddr[tmp+1] = YCbCrElement.YCbCr.Cr;			
			}
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0 && y%2==0)
			{
				tmp = cond.dstOffsetX+(cond.dstOffsetY/2)*stride+(x+(y/2)*stride)+6-((x+(y/2)*stride)%8)*2;
				CbAddr[tmp] = YCbCrElement.YCbCr.Cr;
				CbAddr[tmp+1] = YCbCrElement.YCbCr.Cb;			
			}			
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				CbAddr[cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride] = YCbCrElement.YCbCr.Cb;
				CbAddr[cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride+1] = YCbCrElement.YCbCr.Cr;			
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				CbAddr[cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride] = YCbCrElement.YCbCr.Cr;
				CbAddr[cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride+1] = YCbCrElement.YCbCr.Cb;			
			}
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				tmp = cond.dstOffsetX+cond.dstOffsetY*stride+(x+(y)*stride)+6-((x+(y)*stride)%8)*2;				
				CbAddr[tmp] = YCbCrElement.YCbCr.Cb;
				CbAddr[tmp+1] = YCbCrElement.YCbCr.Cr;			
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				tmp = cond.dstOffsetX+cond.dstOffsetY*stride+(x+(y)*stride)+6-((x+(y)*stride)%8)*2;	
				CbAddr[tmp] = YCbCrElement.YCbCr.Cr;
				CbAddr[tmp+1] = YCbCrElement.YCbCr.Cb;			
			}
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			CbAddr[(cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride)*2] = YCbCrElement.YCbCr.Cb;
			CbAddr[(cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride)*2+1] = YCbCrElement.YCbCr.Cr;		
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			CbAddr[(cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride)*2] = YCbCrElement.YCbCr.Cr;
			CbAddr[(cond.dstOffsetX+cond.dstOffsetY*stride+x+y*stride)*2+1] = YCbCrElement.YCbCr.Cb;		
			break;
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			tmp = (cond.dstOffsetX+cond.dstOffsetY*stride)*2+ //offset
				(x+y*stride)*2+6-(((x+y*stride)*2)%8)*2;
			CbAddr[tmp] = YCbCrElement.YCbCr.Cb;
			CbAddr[tmp+1] = YCbCrElement.YCbCr.Cr;		
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			tmp = (cond.dstOffsetX+cond.dstOffsetY*stride)*2+ //offset
				(x+y*stride)*2+6-(((x+y*stride)*2)%8)*2;
			CbAddr[tmp] = YCbCrElement.YCbCr.Cr;
			CbAddr[tmp+1] = YCbCrElement.YCbCr.Cb;		
			break;

		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0 && y%2==0)
			{
				CbAddr[cond.dstOffsetX/2+(cond.dstOffsetY/2)*(stride/2)+x/2+(y/2)*(stride/2)] = YCbCrElement.YCbCr.Cb;
				CrAddr[cond.dstOffsetX/2+(cond.dstOffsetY/2)*(stride/2)+x/2+(y/2)*(stride/2)] = YCbCrElement.YCbCr.Cr;
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				CbAddr[cond.dstOffsetX/2+(cond.dstOffsetY)*(stride/2)+x/2+(y)*(stride/2)] = YCbCrElement.YCbCr.Cb;
				CrAddr[cond.dstOffsetX/2+(cond.dstOffsetY)*(stride/2)+x/2+(y)*(stride/2)] = YCbCrElement.YCbCr.Cr;
			}
			break;
	#if defined(SYSTEM_6440)
		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			YAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Y;
			CbAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Cb;
			CrAddr[offset + x + y*stride] = YCbCrElement.YCbCr.Cr;
			break;
	#endif
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
			YAddr[(offset+x+y*stride)*2] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				YAddr[(offset+x+y*stride)*2+1] = YCbCrElement.YCbCr.Cb;
				YAddr[(offset+x+y*stride)*2+3] = YCbCrElement.YCbCr.Cr;				
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
			YAddr[(offset+x+y*stride)*2] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				YAddr[(offset+x+y*stride)*2+1] = YCbCrElement.YCbCr.Cr;
				YAddr[(offset+x+y*stride)*2+3] = YCbCrElement.YCbCr.Cb;				
			}
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
			YAddr[(offset+x+y*stride)*2+1] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				YAddr[(offset+x+y*stride)*2] = YCbCrElement.YCbCr.Cb;
				YAddr[(offset+x+y*stride)*2+2] = YCbCrElement.YCbCr.Cr;				
			}
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			YAddr[(offset+x+y*stride)*2+1] = YCbCrElement.YCbCr.Y;
			if(x%2==0)
			{
				YAddr[(offset+x+y*stride)*2] = YCbCrElement.YCbCr.Cr;
				YAddr[(offset+x+y*stride)*2+2] = YCbCrElement.YCbCr.Cb;				
			}
			break;
		case POST_COLOR_FORMAT_RGB565:
			RGB16[offset+x+y*stride] = ((RGBElement.RGB.R>>3)<<11)
				|((RGBElement.RGB.G>>2)<<5)|((RGBElement.RGB.B>>3)<<0);
			break;
		case POST_COLOR_FORMAT_RGB666:
			RGB32[offset+x+y*stride] = ((RGBElement.RGB.R>>2)<<12)
				|((RGBElement.RGB.G>>2)<<6)|((RGBElement.RGB.B>>2)<<0);
			break;
		case POST_COLOR_FORMAT_RGB888:
			RGB32[offset+x+y*stride] = RGBElement.val & 0x00ffffff;
			break;
	}
}

static POST_COLOR_ELEMENT GetRGBonOne2One(u8 *buf,int index)
{
	u32 *buf32;
	POST_COLOR_ELEMENT rgb;

	buf32 = (u32 *)buf;
	if(cond.dst==POST_COLOR_FORMAT_RGB565)
	{
		rgb.RGB.R =  ((buf32[index]>>11) & 0x1f)<<3; 
		rgb.RGB.G =  ((buf32[index]>>5) & 0x3f)<<2; 
		rgb.RGB.B =  ((buf32[index]) & 0x1f)<<3; 
	}
	else if(cond.dst==POST_COLOR_FORMAT_RGB666)
	{
		rgb.RGB.R =  ((buf32[index]>>12) & 0x3f)<<2; 
		rgb.RGB.G =  ((buf32[index]>>6) & 0x3f)<<2; 
		rgb.RGB.B =  ((buf32[index]) & 0x3f)<<2; 
	}
	else
	{
		rgb.val = buf32[index];
	}
	return rgb;
}
static POST_COLOR_ELEMENT GetYCbCrOne2One(YCBCR_BUF buf,int x,int y)
{
	POST_COLOR_ELEMENT ycbcr;
	switch(cond.src)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			ycbcr.YCbCr.Y = buf.y[y*cond.srcImageWidth+x];
			ycbcr.YCbCr.Cb = buf.cb[y/2*cond.srcImageWidth/2+x/2];
			ycbcr.YCbCr.Cr = buf.cr[y/2*cond.srcImageWidth/2+x/2];
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			ycbcr.YCbCr.Y = buf.y[y*cond.srcImageWidth+x];
			ycbcr.YCbCr.Cb = buf.cb[y*cond.srcImageWidth/2+x/2];
			ycbcr.YCbCr.Cr = buf.cr[y*cond.srcImageWidth/2+x/2];
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			ycbcr.YCbCr.Y = buf.y[y*cond.srcImageWidth+x];
			ycbcr.YCbCr.Cb = buf.cb[y*cond.srcImageWidth+x];
			ycbcr.YCbCr.Cr = buf.cr[y*cond.srcImageWidth+x];
			break;

	}	

	return ycbcr;
}

static void DoColorConvertion(YCBCR_BUF input)
{
	int i,j;
	POST_COLOR_ELEMENT element;
	int R2YCSEL;
	int Y2RCSEL;
	POST_COLOR_ELEMENT RGBElement;
	POST_COLOR_ELEMENT YCbCrElement;
	int stride;
	int offset;
	
	if(cond.R2YRange==POST_CSC_WIDE)R2YCSEL=1;
	else R2YCSEL=0;

	if(cond.Y2RRange==POST_CSC_WIDE)Y2RCSEL=1;
	else Y2RCSEL=0;

	stride = cond.dstScreenWidth;
	offset = cond.dstOffsetX + cond.dstOffsetY*cond.dstScreenWidth;
	
	for(i=0;i<cond.dstImageHeight;i++)
	{
		for(j=0;j<cond.dstImageWidth;j++)
		{
			if(cond.One2One)
			{
				YCbCrElement=GetYCbCrOne2One(input,j,i);
				RGBElement = GetRGBonOne2One(input.y,i*cond.dstImageWidth+j);
				setColor(RGBElement,YCbCrElement,offset,stride,cond.OutAddr1,j,i);				
			}
			else
			{
				element.YCbCr.Y= input.y[i*cond.dstImageWidth+j];
				element.YCbCr.Cb = input.cb[i*cond.dstImageWidth+j];
				element.YCbCr.Cr = input.cr[i*cond.dstImageWidth+j];
				YCbCrElement=element;
				RGBElement.val = CSCY2R(YCbCrElement.YCbCr.Y, YCbCrElement.YCbCr.Cb, YCbCrElement.YCbCr.Cr, Y2RCSEL);
				setColor(RGBElement,YCbCrElement,offset,stride,cond.OutAddr1,j,i);
			}
		}
	}
}

static void DoLoadPixelData(YCBCR_BUF output)
{
	POST_COLOR_ELEMENT element;
	u8 *Yaddr;
	u8 *CbAddr;
	u8 *CrAddr;
	u32 *RGB32;
	u16 *RGB16;
	u32 r,g,b;
	u16 tmp16;
	u32 tmp32;
	u32 tmp32_2;
	int x,y;
	u8 *srcY,*srcCb,*srcCr;
	u32 *buf32;
	u32 offset;

	u32 R2YCSEL;

	srcY = (u8 *)cond.InAddr.Y;
	srcCb = (u8 *)cond.InAddr.Cb;
	srcCr = (u8 *)cond.InAddr.Cr;
	RGB16 = (u16 *)cond.InAddr.Y;
	RGB32 = (u32 *)cond.InAddr.Y;


	offset = cond.srcOffsetX+cond.srcOffsetY*cond.srcOriginalImageWidth;

	if(cond.R2YRange==POST_CSC_WIDE)R2YCSEL=1;
	else R2YCSEL=0;

	switch(cond.src)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CbAddr[x/2] = srcCb[x];
				else CrAddr[x/2] = srcCb[x];
			}
			#else
			tmp32 = cond.srcOffsetX+cond.srcOffsetY/2*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CbAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32
						+x+y/2*cond.srcOriginalImageWidth];
					else CrAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32
						+x+y/2*cond.srcOriginalImageWidth];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CrAddr[x/2] = srcCb[x];
				else CbAddr[x/2] = srcCb[x];
			}
			#else
			tmp32 = cond.srcOffsetX+cond.srcOffsetY/2*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CrAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32
						+x+y/2*cond.srcOriginalImageWidth];
					else CbAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32
						+x+y/2*cond.srcOriginalImageWidth];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CrAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
				else CbAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
			}
			#else
			tmp32_2 = cond.srcOffsetX+cond.srcOffsetY/2*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = x+y/2*cond.srcOriginalImageWidth;
					
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CrAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
					else CbAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CbAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
				else CrAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
			}
			#else
			tmp32_2 = cond.srcOffsetX+cond.srcOffsetY/2*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = x+y/2*cond.srcOriginalImageWidth;
					
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CbAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
					else CrAddr[x/2+(y/2)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CbAddr[x/2] = srcCb[x];
				else CrAddr[x/2] = srcCb[x];
			}
			#else
			tmp32_2  =cond.srcOffsetX+cond.srcOffsetY*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CbAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth];
					else CrAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth];
				}
			}			
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CrAddr[x/2] = srcCb[x];
				else CbAddr[x/2] = srcCb[x];
			}
			#else
			tmp32_2 = cond.srcOffsetX+cond.srcOffsetY*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CrAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth];
					else CbAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth];
				}
			}			
			#endif
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CrAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
				else CbAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
			}	
			#else
			tmp32_2 = cond.srcOffsetX+cond.srcOffsetY*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = x+y*cond.srcOriginalImageWidth;
					
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CrAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
					else CbAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				if(x%2==0)CbAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
				else CrAddr[x/2] = srcCb[7-(x%8) +(x-(x%8))];
			}
			#else
			tmp32_2 = cond.srcOffsetX+cond.srcOffsetY*cond.srcOriginalImageWidth;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = x+y*cond.srcOriginalImageWidth;
					
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					if(x%2==0)CbAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
					else CrAddr[x/2+(y)*cond.srcImageWidth/2] = srcCb[tmp32_2
						+7-(tmp32%8) +(tmp32-(tmp32%8))];
				}
			}
			#endif
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				CbAddr[x] = srcCb[x*2];
				CrAddr[x] = srcCb[x*2+1];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					CbAddr[x+(y)*cond.srcImageWidth] = srcCb[(offset
						+x+y*cond.srcOriginalImageWidth)*2];
					CrAddr[x+(y)*cond.srcImageWidth] = srcCb[(offset
						+x+y*cond.srcOriginalImageWidth)*2+1];
				}
			}	
	
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				CbAddr[x] = srcCb[x*2+1];
				CrAddr[x] = srcCb[x*2];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					CrAddr[x+(y)*cond.srcImageWidth] = srcCb[(offset
						+x+y*cond.srcOriginalImageWidth)*2];
					CbAddr[x+(y)*cond.srcImageWidth] = srcCb[(offset
						+x+y*cond.srcOriginalImageWidth)*2+1];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				CbAddr[3-(x%4)+(x-(x%4))] = srcCb[x*2];
				CrAddr[3-(x%4)+(x-(x%4))] = srcCb[x*2+1];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = (offset+x+y*cond.srcOriginalImageWidth)*2;
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					CrAddr[x+(y)*cond.srcImageWidth] = srcCb[7-(tmp32%8) +(tmp32-(tmp32%8))];
					CbAddr[x+(y)*cond.srcImageWidth] = srcCb[7-(tmp32%8) +(tmp32-(tmp32%8))-1];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				CbAddr[3-(x%4)+(x-(x%4))] = srcCb[x*2+1];
				CrAddr[3-(x%4)+(x-(x%4))] = srcCb[x*2];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					tmp32 = (offset+x+y*cond.srcOriginalImageWidth)*2;
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					CbAddr[x+(y)*cond.srcImageWidth] = srcCb[7-(tmp32%8) +(tmp32-(tmp32%8))];
					CrAddr[x+(y)*cond.srcImageWidth] = srcCb[7-(tmp32%8) +(tmp32-(tmp32%8))-1];
				}
			}
			#endif
			break;
#endif
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
			}
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth/4;x++)
			{
				CbAddr[x] = srcCb[x];
			}
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth/4;x++)
			{
				CrAddr[x] = srcCr[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
				}
			}
			tmp32_2 = cond.srcOffsetX/2+cond.srcOffsetY/2*cond.srcOriginalImageWidth/2;
			for(y=0;y<cond.srcImageHeight/2;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth/2];
				}
			}
			for(y=0;y<cond.srcImageHeight/2;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcCr[tmp32_2
						+x+y*cond.srcOriginalImageWidth/2];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
			}
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth/2;x++)
			{
				CbAddr[x] = srcCb[x];
			}
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth/2;x++)
			{
				CrAddr[x] = srcCr[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
				}
			}
			tmp32_2 = cond.srcOffsetX/2+cond.srcOffsetY*cond.srcOriginalImageWidth/2;
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcCb[tmp32_2
						+x+y*cond.srcOriginalImageWidth/2];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcCr[tmp32_2
						+x+y*cond.srcOriginalImageWidth/2];
				}
			}
			#endif
			break;

		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth;x++)
			{
				Yaddr[x] = srcY[x];
				CbAddr[x] = srcCb[x];
				CrAddr[x] = srcCr[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[offset+x+y*cond.srcOriginalImageWidth];
					CbAddr[x+y*cond.srcImageWidth] = srcCb[offset+x+y*cond.srcOriginalImageWidth];
					CrAddr[x+y*cond.srcImageWidth] = srcCr[offset+x+y*cond.srcOriginalImageWidth];
				}
			}
			#endif
			break;

		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth*2;x++)
			{
				if(x%2==1)Yaddr[x/2] = srcY[x];
				if(x%4==2)CbAddr[x/4] = srcY[x];
				if(x%4==0)CrAddr[x/4] = srcY[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[(offset+x+y*cond.srcOriginalImageWidth)*2+1];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+2];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:	
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth*2;x++)
			{
				if(x%2==0)Yaddr[x/2] = srcY[x];
				if(x%4==3)CbAddr[x/4] = srcY[x];
				if(x%4==1)CrAddr[x/4] = srcY[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[(offset+x+y*cond.srcOriginalImageWidth)*2];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+3];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+1];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth*2;x++)
			{
				if(x%2==1)Yaddr[x/2] = srcY[x];
				if(x%4==0)CbAddr[x/4] = srcY[x];
				if(x%4==2)CrAddr[x/4] = srcY[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[(offset+x+y*cond.srcOriginalImageWidth)*2+1];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+2];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			#if 0
			for(x=0;x<cond.srcImageHeight*cond.srcImageWidth*2;x++)
			{
				if(x%2==0)Yaddr[x/2] = srcY[x];
				if(x%4==1)CbAddr[x/4] = srcY[x];
				if(x%4==3)CrAddr[x/4] = srcY[x];
			}
			#else
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth;x++)
				{
					Yaddr[x+y*cond.srcImageWidth] = srcY[(offset+x+y*cond.srcOriginalImageWidth)*2];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CbAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+1];
				}
			}
			for(y=0;y<cond.srcImageHeight;y++)
			{
				for(x=0;x<cond.srcImageWidth/2;x++)
				{
					CrAddr[x+y*cond.srcImageWidth/2] = srcY[offset*2+x*4+y*cond.srcOriginalImageWidth*2+3];
				}
			}
			#endif
			break;
		case POST_COLOR_FORMAT_RGB565:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			if(cond.One2One)
			{
				buf32 = (u32 *)output.y;
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						buf32[y*cond.srcImageWidth+x] = RGB16[offset+y*cond.srcOriginalImageWidth+x];
					}
				}
			}
			else
			{
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						tmp16= RGB16[offset+y*cond.srcOriginalImageWidth+x];
						r = (tmp16>>11)&0x1f;
						g = (tmp16>>5)&0x3f;
						b = (tmp16>>0)&0x1f;
						if(cond.RGBInputExtension)
						{
							element.RGB.R = (r<<3) | (r>>2);
							element.RGB.G = (g<<2) | (g>>4);
							element.RGB.B = (b<<3) | (b>>2);
						}
						else
						{
							element.RGB.R = (r<<3);
							element.RGB.G = (g<<2);
							element.RGB.B = (b<<3);
						}
						element.val=CSCR2Y_C(element.RGB.R, element.RGB.G, element.RGB.B, R2YCSEL);
						Yaddr[y*cond.srcImageWidth+x] = element.YCbCr.Y;
						CbAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cb;
						CrAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cr;
					}
				}
			}
			break;
		case POST_COLOR_FORMAT_RGB666:
			Yaddr = output.y;
			CbAddr = output.cb;
			CrAddr = output.cr;
			if(cond.One2One)
			{
				buf32 = (u32 *)output.y;
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						buf32[y*cond.srcImageWidth+x] = RGB32[offset+y*cond.srcOriginalImageWidth+x];
					}
				}
			}
			else
			{
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						tmp32 = RGB32[offset+y*cond.srcOriginalImageWidth+x];
						r = (tmp32>>12)&0x3f;
						g = (tmp32>>6)&0x3f;
						b = (tmp32>>0)&0x3f;
						if(cond.RGBInputExtension)
						{
							element.RGB.R = (r<<2) | (r>>4);
							element.RGB.G = (g<<2) | (g>>4);
							element.RGB.B = (b<<2) | (b>>4);
						}
						else
						{
							element.RGB.R = (r<<2);
							element.RGB.G = (g<<2);
							element.RGB.B = (b<<2);
						}
						element.val=CSCR2Y_C(element.RGB.R, element.RGB.G, element.RGB.B, R2YCSEL);
						Yaddr[y*cond.srcImageWidth+x] = element.YCbCr.Y;
						CbAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cb;
						CrAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cr;

					}
				}
			}
			break;
		case POST_COLOR_FORMAT_RGB888:
			if(cond.One2One)
			{
				buf32 = (u32 *)output.y;
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						buf32[y*cond.srcImageWidth+x] = RGB32[offset+y*cond.srcOriginalImageWidth+x];
					}
				}
			}
			else
			{		
				Yaddr = output.y;
				CbAddr = output.cb;
				CrAddr = output.cr;				
				for(y=0;y<cond.srcImageHeight;y++)
				{
					for(x=0;x<cond.srcImageWidth;x++)
					{
						element.val = RGB32[offset+y*cond.srcOriginalImageWidth+x];
						element.val=CSCR2Y_C(element.RGB.R, element.RGB.G, element.RGB.B, R2YCSEL);
						Yaddr[y*cond.srcImageWidth+x] = element.YCbCr.Y;
						CbAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cb;
						CrAddr[y*cond.srcImageWidth+x] = element.YCbCr.Cr;
					}
				}
			}
			break;
	}

}

static void PreScaleCore ( unsigned int Height, unsigned int Width, u8 *input_F, u8 *output_F)
{
	unsigned int i, j;

	unsigned int vertical, horizontal;
	unsigned int PixelSum;
	unsigned int PreScaledPixel;
	u8*CurrentPixelPtr;
	unsigned int *SRCArray_Ref;
	u8 *SRC_color;
	int k;

	k=0;
	SRC_color = input_F;
	CurrentPixelPtr = SRC_color;

	PixelSum = 0;
	for ( vertical = 0 ; vertical < Height ; vertical += ScalerFactor.PreVerRatio)
		for ( horizontal = 0 ; horizontal < Width ; horizontal += ScalerFactor.PreHorRatio)
		{
			for ( i=0 ; i < ScalerFactor.PreVerRatio ; i++ )
				for ( j=0 ; j < ScalerFactor.PreHorRatio ; j++ )
				{
					CurrentPixelPtr = SRC_color + ( (vertical+i) * Width + horizontal + j );
					//printf ("x= %d y= %d  Pixel; = %d\n", horizontal + j , vertical+i, *CurrentPixelPtr );
					PixelSum +=  *CurrentPixelPtr;
				}
			//printf ( "PixelSum = %d         ", PixelSum);

			if ( (ScalerFactor.H_Shift==0) && (ScalerFactor.V_Shift==0) )  PreScaledPixel = PixelSum;
			else if ( (ScalerFactor.H_Shift + ScalerFactor.V_Shift) < 2 ) PreScaledPixel = (PixelSum + 1) >> 1;
			else PreScaledPixel =  ( (PixelSum >> ( ScalerFactor.H_Shift + ScalerFactor.V_Shift - 1 )) + 1) >> 1;


			//printf ( "DSTX = %d DSTY = %d Scaled Pixel = %d\n\n", 
			//		horizontal/PreScale_H_Ratio + 1, vertical/PreScale_V_Ratio + 1, PreScaledPixel);
			//fprintf ( output_F, "%3d\n", PreScaledPixel);
			output_F[k]=(u8)PreScaledPixel;
			k++;
			PixelSum = 0;
		}

}

void MainScaleCore (unsigned int Height, unsigned int Width, u8 *input_F, u8 *output_F, int Cx, int hd, int wd, int pr_co, int one2one420, int one2one422)
{

	unsigned int i,j;
	unsigned int horizontal, vertical;

	unsigned int SRC_LX, SRC_RX;
	unsigned int SRC_TY, SRC_BY;

	unsigned int dL, dR, dT, dB;

	unsigned int W0, W1, W2, W3;

	u8 *SRCArray_Ref;
	u8 *CurrentPixelPtr;

	u8 *LT_Ptr, *RT_Ptr, *LB_Ptr, *RB_Ptr;

	unsigned int NewPixel;

	unsigned int dx_move, dy_move;

	unsigned int DST_Height, DST_Width;
	int k;

	k=0;

	#if 0
	if (pr_co == 1) { DST_Height = DST_Height_Pr;   DST_Width =  DST_Width_Pr; }  /* Preview path */
	else            { DST_Height = DST_Height_Co;   DST_Width =  DST_Width_Co; }  /* Codec path */ 
	#else
	DST_Height = cond.dstImageHeight;
	DST_Width =  cond.dstImageWidth;
	#endif

	SRCArray_Ref = input_F;
	CurrentPixelPtr = SRCArray_Ref;

	if ( ScalerFactor.ScaleUp_V ) {
		SRC_TY = 0;
		SRC_BY = (1<<FSize);
		/*SRC_TY = (1<<(FSize-1)) - (dy>>1);
		  SRC_BY = (1<<(FSize-1)) + (dy>>1); */
	} else {
		/*SRC_TY = 0;
		  SRC_BY = (1<<FSize);*/
		SRC_TY = (ScalerFactor.MainVerRatio>>1) - ( 1<< (FSize-1));
		SRC_BY = (ScalerFactor.MainVerRatio>>1) + ( 1<< (FSize-1));
	}

	//printf (" SRC_TY = %x\n", SRC_TY);
	//printf (" SRC_BY = %x\n", SRC_BY);

	for ( vertical= 0 ; vertical < DST_Height/hd ; vertical++ )
	{
		if ( ScalerFactor.ScaleUp_H ) {
			SRC_LX = 0;
			SRC_RX = (1<<FSize);
			/*SRC_LX =  - (dx>>1) + (1<<(FSize-1));
			  SRC_RX = (dx>>1) + (1<<(FSize-1))*/;
		} else {
			/*SRC_LX = 0;
			  SRC_RX = (1<<FSize); */
			SRC_LX = (ScalerFactor.MainHorRatio>>1) - (1<<(FSize-1));
			SRC_RX = (ScalerFactor.MainHorRatio>>1) + (1<<(FSize-1)); 
		}

		//printf (" SRC_LX = %x\n", SRC_LX);
		//printf (" SRC_RX = %x\n", SRC_RX);

		for ( horizontal = 0 ; horizontal < DST_Width/wd ; horizontal ++ )
		{

			dR = (SRC_RX<<(32-FSize)) >> (32-FSize);
			dL = (1<<FSize) - dR; 

			dB = (SRC_BY<<(32-FSize)) >> (32-FSize);
			dT = (1<<FSize) - dB;

			W0 =  ( (dL * dT) & 0x1ff00 ) >> FSize;
			W1 =  ( (dR * dT) & 0x1ff00 ) >> FSize;
			W2 =  ( (dL * dB) & 0x1ff00 ) >> FSize;
			W3 =  (1<<8) - (W0 + W1 + W2);

			if ( (W0+W1+W2) > 256 ) {
				/*
				printf (" Area Coefficient Error\n"); 
				printf (" dL = %x, dR = %x\n", dL, dR);
				printf (" dB = %x, dT = %x\n", dB, dT);
				exit (-1);
				*/
				return;
			}


			LT_Ptr = SRCArray_Ref + ( (SRC_TY>>FSize) * Width + (SRC_LX>>FSize));

			if ( (Cx==1) && ((SRC_RX>>FSize) >= PreScaleDST_Width/(2-InRGB)) ) RT_Ptr = LT_Ptr;
			else if ( (Cx==0) && ((SRC_RX>>FSize) >= PreScaleDST_Width/wd) ) RT_Ptr = LT_Ptr;
			else RT_Ptr = SRCArray_Ref + ( (SRC_TY>>FSize) * Width + (SRC_RX>>FSize));


			if ( (Cx==1) && (From420to444==1) && ((SRC_BY>>FSize)>=PreScaleDST_Height/(2-InRGB)) )
			{ LB_Ptr = LT_Ptr; RB_Ptr = RT_Ptr;}
			//soo elif ( (Cx==1) && (pr_co==1) && ((SRC_BY>>FSize)>=PreScaleDST_Height) ) 
			else if ( (Cx==1) && ((SRC_BY>>FSize)>=PreScaleDST_Height) ) 
			{ LB_Ptr = LT_Ptr; RB_Ptr = RT_Ptr;}
			else if ( (Cx==0) && ((SRC_BY>>FSize)>=PreScaleDST_Height/hd)) 
			{ LB_Ptr = LT_Ptr; RB_Ptr = RT_Ptr;}
			else {
				LB_Ptr = SRCArray_Ref + ( (SRC_BY>>FSize) * Width + (SRC_LX>>FSize));

				if ( (Cx==1) && ((SRC_RX>>FSize) >= PreScaleDST_Width/(2-InRGB)) ) RB_Ptr = LB_Ptr;
				else if ( (Cx==0) && ((SRC_RX>>FSize) >= PreScaleDST_Width/wd) ) RB_Ptr = LB_Ptr;
				else RB_Ptr = SRCArray_Ref + ( (SRC_BY>>FSize) * Width + (SRC_RX>>FSize));	
			}

			NewPixel = ( W0 * (*LT_Ptr) + W1 * (*RT_Ptr) + W2 * (*LB_Ptr) + W3 * (*RB_Ptr) + (1<<7) ) >> 8;

			if ( NewPixel & ((1<<10)+(1<<9)+(1<<8)) ) NewPixel = 255;

			#if 0
			fprintf ( output_F, "%3d\n", NewPixel);
			#else
			output_F[k] = (u8)NewPixel;
			k++;
			#endif
			
			if ( (one2one420 == 1) || (one2one422 == 1) ) {
		           if ( (horizontal % 2) == 0 )
			      dx_move = 0; 
		           else
			      dx_move = ScalerFactor.MainHorRatio; 
			}
			else {
			   //soo if ( (Cx==1) && (MPEG4 == 0) && ( (pr_co == 1) || (From420to444 == 1) ) &&
			   if ( (Cx==1) && (1 == 0) && ( (horizontal == 0) || ( horizontal == (DST_Width/wd-1)) ) )
				dx_move = ScalerFactor.MainHorRatio >> 2;
			   //soo else if ( (Cx==1) && ( (pr_co == 1) || (From420to444 == 1) )  ) 
			   //soo else if else if (Cx==1)
			   // RFR_060522: merge changes from 20060519
			   else if ( (Cx==1) && ((From420to444 == 1) || (From422to444 == 1)))
				dx_move = ScalerFactor.MainHorRatio >> 1; 
			   else dx_move = ScalerFactor.MainHorRatio;
			}
	
			SRC_LX += dx_move;
			SRC_RX += dx_move;
		}

		if ( one2one420 == 1 ) {
			if ( (vertical % 2) == 0 )dy_move = 0; 
			else dy_move = ScalerFactor.MainVerRatio; 
		}
		else {
			if ( (Cx==1) && (From420to444 == 1) && ( (vertical == 0) || (vertical == (DST_Height/hd-1)) ) ) dy_move = ScalerFactor.MainVerRatio >> 2;
			else if ( (Cx==1) &&  (From420to444 == 1) )dy_move = ScalerFactor.MainVerRatio >> 1; 
			else dy_move = ScalerFactor.MainVerRatio;
		}

		SRC_TY += dy_move;
		SRC_BY += dy_move;
	}	
}


// format
// 0:444
// 1:422
// 2:420
static void DispYCbCrInBuf(YCBCR_BUF buf,int x,int y, int stride,int format)
{
	if(format==0)
	{
		Disp("Buf [%d,%d]=> YCbCr[%x,%x,%x]\n",
			x,y,buf.y[x+y*stride],buf.cb[x+y*stride],buf.cr[x+y*stride]);
	}
	else if(format==1)
	{
		Disp("Buf [%d,%d]=> YCbCr[%x,%x,%x]\n",
			x,y,buf.y[x+y*stride],buf.cb[x/2+y*(stride/2)],buf.cr[x/2+y*(stride/2)]);		
	}
	else if(format==2)
	{
		Disp("Buf [%d,%d]=> YCbCr[%x,%x,%x]\n",
			x,y,buf.y[x+y*stride],buf.cb[x/2+(y/2)*(stride/2)],buf.cr[x/2+(y/2)*(stride/2)]);		
	}
}

void POST_DoConvertingSW()
{
	YCBCR_BUF buf[3];
	buf[0] = GetDataBuf(0);
	buf[1] = GetDataBuf(1);
	DoLoadPixelData(buf[0]);

	if(cond.One2One)
	{
		/*
		Disp("[cb] = 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",
			buf[0].cb[0],buf[0].cb[1],buf[0].cb[2],buf[0].cb[3],buf[0].cb[4],buf[0].cb[5],buf[0].cb[6],buf[0].cb[7]);
		Disp("[cr] = 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",
			buf[0].cr[0],buf[0].cr[1],buf[0].cr[2],buf[0].cr[3],buf[0].cr[4],buf[0].cr[5],buf[0].cr[6],buf[0].cr[7]);
			*/
	}
	else
	{
		PreScaleCore ( cond.srcImageHeight, cond.srcImageWidth, buf[0].y, buf[1].y);
		PreScaleCore ( cond.srcImageHeight/(2-In422), cond.srcImageWidth/(2-InRGB), buf[0].cb, buf[1].cb);
		PreScaleCore ( cond.srcImageHeight/(2-In422), cond.srcImageWidth/(2-InRGB), buf[0].cr, buf[1].cr);


	//	DispYCbCrInBuf(buf[0],6,0,cond.srcImageWidth,1);
	//	DispYCbCrInBuf(buf[0],7,0,cond.srcImageWidth,1);
	//	DispYCbCrInBuf(buf[0],8,0,cond.srcImageWidth,1);
		MainScaleCore ( PreScaleDST_Height, PreScaleDST_Width, buf[1].y, buf[0].y, 0, 1, 1, 0, 0, 0);
		MainScaleCore ( PreScaleDST_Height/(2-In422), PreScaleDST_Width/(2-InRGB), buf[1].cb, buf[0].cb, 1, 1, 1, 0, 0, 0);
		MainScaleCore ( PreScaleDST_Height/(2-In422), PreScaleDST_Width/(2-InRGB), buf[1].cr, buf[0].cr, 1, 1, 1, 0, 0, 0);
	}

//	DispYCbCrInBuf(buf[0],6,0,cond.srcImageWidth,0);
//	DispYCbCrInBuf(buf[0],7,0,cond.srcImageWidth,0);
//	DispYCbCrInBuf(buf[0],8,0,cond.srcImageWidth,0);
	DoColorConvertion(buf[0]);
}
void POST_WaitConvertingSW()
{

}

void POST_SetInputDMAAddrSW(u32 y,u32 cb,u32 cr)
{	
	cond.InAddr.Y = y;
	cond.InAddr.Cb = cb;
	cond.InAddr.Cr = cr;
	
}
