/*-------------------------------------------------------------
 * Filename: post_conditions.c
 *
 * Contents: Implemention of conditions for Post processor of s5c6440
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee 2008.10.01
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
//#include <system.h>

#if defined(S5PC100)
#include "typedef.h"
#include "system.h"
#elif defined(S5PV210)
#include "string.h"
//#include "user_def.h"
#include "def.h"
#include "option.h"
#include "fimc_test_2nd.h"
#include "util.h"
#elif defined(S5P6442)
#include "string.h"
#include "user_def.h"
#include "def.h"
#include "option.h"
#include "fimc_test_2nd.h"
#endif

#include <fimc_2nd.h>
#include <fimc_conditions.h>

void POST_getDefaultPostCondition(POST_CONDITION *condition)
{
	memset(condition,0,sizeof(POST_CONDITION));
	
	condition->src = POST_COLOR_FORMAT_RGB888;
	condition->dst = POST_COLOR_FORMAT_RGB888;
	condition->runMode = ONE_SHOT;
	condition->OutAddr1.Y = DST0_Y_ADDR;		//0x26000000
	condition->OutAddr1.Cb = DST0_Cb_ADDR;
	condition->OutAddr1.Cr = DST0_Cr_ADDR;
	condition->OutAddr2.Y = DST0_Y_ADDR;
	condition->OutAddr2.Cb = DST0_Cb_ADDR;
	condition->OutAddr2.Cr = DST0_Cr_ADDR;
	condition->OutAddr3.Y = DST0_Y_ADDR;
	condition->OutAddr3.Cb = DST0_Cb_ADDR;
	condition->OutAddr3.Cr = DST0_Cr_ADDR;
	condition->OutAddr4.Y = DST0_Y_ADDR;
	condition->OutAddr4.Cb = DST0_Cb_ADDR;
	condition->OutAddr4.Cr = DST0_Cr_ADDR;

	condition->InAddr.Y = SRC_Y_ADDR;		//0x22800000
	condition->InAddr.Cb = SRC_Cb_ADDR;
	condition->InAddr.Cr = SRC_Cr_ADDR;
	
	condition->srcOriginalImageWidth=DEFAULT_WIDTH;
	condition->srcOriginalImageHeight =DEFAULT_HEIGHT;
	condition->srcImageWidth= DEFAULT_WIDTH;
	condition->srcImageHeight=DEFAULT_HEIGHT;

	condition->srcOffsetX=0;
	condition->srcOffsetY=0;
	condition->dstOffsetX=0;
	condition->dstOffsetY=0;
	
	condition->dstScreenWidth = DEFAULT_WIDTH;
	condition->dstScreenHeight=DEFAULT_HEIGHT;
	condition->dstImageWidth=DEFAULT_WIDTH;
	condition->dstImageHeight=DEFAULT_HEIGHT;

	condition->R2YRange = POST_CSC_WIDE;
	condition->Y2RRange = POST_CSC_WIDE;

	condition->RGBInputExtension=0;
	condition->One2One=0;

	condition->waitMode = POST_WAIT_MODE_POLLING;
	//				condition->waitMode = 		POST_WAIT_MODE_INTERRUPT;
	condition->postPath = POST_DMA;

	condition->InputDoubleBufferEnable=0;
	condition->temp=0;
}

POST_CONDITION *POST_getPostConditions(POST_CONDITION defaultCondition,u32 bufferAddr)
{
	int i,j;
	POST_CONDITION *condition;

	condition = (POST_CONDITION *)bufferAddr;

#if defined(S5PV210)|defined(S5P6442)
	for(i=0;i<22*22;i++)
	{
		condition[i] = defaultCondition;		
	}

	for(i=0;i<22;i++)
	{
		for(j=0;j<22;j++)
		{
			condition[i*22+j].src = i;		
			condition[i*22+j].dst = j;
		}
	}

	condition[22*22].temp=-1;
	
#elif defined(S5PC100)
	for(i=0;i<17*17;i++)
	{
		condition[i] = defaultCondition;		
	}

	for(i=0;i<17;i++)
	{
		for(j=0;j<17;j++)
		{
			condition[i*17+j].src = i;		
			condition[i*17+j].dst = j;
		}
	}

	condition[17*17].temp=-1;

#endif
	return condition;

}

POST_CONDITION *POST_getLocalPathCondition(POST_CONDITION defaultCondition,u32 bufferAddr)
{
	int i,j;
	POST_CONDITION *condition;
	int k;
	k=0;

	condition = (POST_CONDITION *)bufferAddr;

	/*
	for(i=0;i<22;i++,k++)
	{
		condition[k] = defaultCondition;
		condition[k].dst = POST_COLOR_FORMAT_YCbCr444_3PLANE;
		condition[k].src = i;
	}
	*/
#if defined(S5PV210)|defined(S5P6442)
	for(i=0;i<22;i++,k++)
	{
		condition[k] = defaultCondition;
		condition[k].dst = POST_COLOR_FORMAT_RGB888;
		condition[k].src = i;
	}
#elif defined(S5PC100) //There is no YUV444 format.
	for(i=0;i<17;i++,k++)
	{
		condition[k] = defaultCondition;
		condition[k].dst = POST_COLOR_FORMAT_RGB888;
		condition[k].src = i;
	}
#endif

	condition[k].temp=-1;

	return condition;
	
}

static DispColorFormat(POST_COLOR_FORMAT format)
{
	switch(format)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
			Disp("YCrCb420,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
			Disp("YCbCr420,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
			Disp("YCrCb420,2P,Forward");
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			Disp("YCbCr420,2P,Forward");
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
			Disp("YCrCb422,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
			Disp("YCbCr422,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
			Disp("YCrCb422,2P,Forward");
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			Disp("YCbCr422,2P,Forward");
			break;
#if defined(S5PV210)|defined(S5P6442)
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
			Disp("YCrCb444,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
			Disp("YCbCr444,2P,Reverse");
			break;
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
			Disp("YCrCb444,2P,Forward");
			break;
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			Disp("YCbCr444,2P,Forward");
			break;
#endif 
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			Disp("YCbCr420,3P");
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			Disp("YCbCr422,3P");
			break;
#if defined(S5PV210)|defined(S5P6442)
		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			Disp("YCbCr444,3P");
#endif 
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
			Disp("YCrCb422,1P,Table0");
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
			Disp("YCbCr422,1P,Table1");
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
			Disp("YCrCb422,1P,Table2");
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			Disp("YCbCr422,1P,Table3");
			break;
		case POST_COLOR_FORMAT_RGB565:
			Disp("RGB565");
			break;
		case POST_COLOR_FORMAT_RGB666:
			Disp("RGB666");
			break;
		case POST_COLOR_FORMAT_RGB888:
			Disp("RGB888");
			break;
	}
}

void POST_DispPostCondition(POST_CONDITION *condition)
{
	//src description start
	Disp("[SRC:"); 

	Disp("(");
	DispColorFormat(condition->src);
	Disp(")");
	Disp("(OffX=%d,Y=%d)",condition->srcOffsetX,condition->srcOffsetY);
	Disp("(RealW=%d,H=%d)",condition->srcImageWidth,condition->srcImageHeight);
	Disp("(OriW=%d,H=%d)",condition->srcOriginalImageWidth,condition->srcOriginalImageHeight);
	Disp("]"); 
	//src desc. end

	//dst desc. start
	Disp("[DST:");
	
	Disp("(");
	DispColorFormat(condition->dst);
	Disp(")");
	Disp("(OffX=%d,Y=%d)",condition->dstOffsetX,condition->dstOffsetY);
	Disp("(RealW=%d,H=%d)",condition->dstImageWidth,condition->dstImageHeight);
	Disp("(OriW=%d,H=%d)",condition->dstScreenWidth,condition->dstScreenHeight);
	Disp("]");
	//dst desc. end

	// genernal condition
	Disp("[");
	if(condition->One2One)Disp("One2One,");
	if(condition->RGBInputExtension)Disp("Ext_RGB,");
	if(condition->R2YRange==POST_CSC_NARROW)Disp("R2YNarrow,");
	if(condition->Y2RRange==POST_CSC_NARROW)Disp("Y2RNarrow,");	
	Disp("]");
	// general condition end	
}
