/*-------------------------------------------------------------
 * Filename: post.c
 *
 * Contents: Implemention of Post processor of s5c6440
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee 2008.09.08
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/

#ifndef __POST_H__
#define __POST_H__

#include <def.h>
#include <fimc_test_2nd.h>
/*************************************
old post defines
**************************************/
#define MAX_FRM_BUF_NUM   30

typedef enum 
{
	POST_DMA, POST_FIFO
}POST_PATH;

typedef enum
{
	FREE_RUN, ONE_SHOT
} POST_RUN_MODE;

typedef enum
{
	POST_SW_TRIG, POST_HW_TRIG
} POST_TRIG_MODE;

typedef enum
{
	POST_FRAME_END, POST_FIELD_END
} POST_BUFFER_CHANGE;

typedef enum
{
	POST_PROGRESSIVE_MODE, POST_INTERLACE_MODE
} POST_SCAN_MODE;

typedef enum
{
	RGB, YUV
} POST_FIFO_IF;

typedef enum
{
	POST_A, POST_B //tv scaler
} POST_CH;

/**************************************************************************/


typedef enum 
{
	POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER,
	POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER,
	
	POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER,
	POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER,
#if defined(S5PV210)|defined(S5P6442)
	POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER,
	POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER,
	POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER,
#endif
	POST_COLOR_FORMAT_YCbCr420_3PLANE,
	POST_COLOR_FORMAT_YCbCr422_3PLANE,
#if defined(S5PV210)|defined(S5P6442)
	POST_COLOR_FORMAT_YCbCr444_3PLANE,
#endif
	POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER, //Cr1Y3Cb1Y2Cr0Y1Cb0Y0		
	POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER, //Cb1Y3Cr1Y2Cb0Y1Cr0Y0		
	POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER, //Cr1Y3Cb1Y2Cr0Y1Cb0Y0		
	POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER, //Cb1Y3Cr1Y2Cb0Y1Cr0Y0		
	
	POST_COLOR_FORMAT_RGB565,
	POST_COLOR_FORMAT_RGB666,
	POST_COLOR_FORMAT_RGB888
}POST_COLOR_FORMAT;

typedef struct
{
	u32 Y;
	u32 Cb;
	u32 Cr;
}POST_COLOR_YCBCR;

typedef struct
{
	u32 x;
	u32 y;
	u32 width;
	u32 height;
}POST_RECT;

typedef union
{
	u32 val;
	struct
	{
		u32 Cr:8;
		u32 Cb:8;
		u32 Y:8;
		u32 format:8;
	}YCbCr;
	struct
	{
		u32 B:8;
		u32 G:8;
		u32 R:8;
		u32 format:8;
	}RGB;
}POST_COLOR_ELEMENT;

typedef enum
{
	POST_CSC_WIDE,POST_CSC_NARROW
}POST_CSC_RANGE;

typedef enum
{
	POST_WAIT_MODE_POLLING, POST_WAIT_MODE_INTERRUPT
}POST_WAIT_MODE;

 typedef struct
 {
	POST_COLOR_FORMAT src,dst;

	POST_COLOR_YCBCR OutAddr1;
	POST_COLOR_YCBCR OutAddr2;
	POST_COLOR_YCBCR OutAddr3;
	POST_COLOR_YCBCR OutAddr4;

	POST_COLOR_YCBCR InAddr;
	POST_COLOR_YCBCR InOffset;
	POST_COLOR_YCBCR OutOffset;
	
	u32 srcOriginalImageWidth;
	u32 srcOriginalImageHeight;
	u32 dstScreenWidth;
	u32 dstScreenHeight;

	u32 srcImageWidth;
	u32 srcImageHeight;
	u32 dstImageWidth;
	u32 dstImageHeight;

	u32 srcOffsetX;
	u32 srcOffsetY;
	u32 dstOffsetX;
	u32 dstOffsetY;

	POST_CSC_RANGE R2YRange;
	POST_CSC_RANGE Y2RRange;
	
	POST_RUN_MODE runMode;

	int temp;

	u32 RGBInputExtension;
	u32 One2One;
	POST_WAIT_MODE waitMode;

	POST_PATH postPath;

	u32 InputDoubleBufferEnable;
 }POST_CONDITION;

//u32 POST_RegResetValueVerify();
int POST_SetScaleFactor(u32 srcWidth,u32 srcHeight,u32 dstWidth,u32 dstHeight);
void POST_SetRunMode(POST_RUN_MODE mode);
void POST_SetSrcColorFormat(POST_COLOR_FORMAT colorFormat);
void POST_SetDstColorFormat(POST_COLOR_FORMAT colorFormat);
 int POST_SetCondition(POST_CONDITION cond);
 void POST_SetInputDMAAddr(u32 y,u32 cb,u32 cr);
 int POST_GetInputBuffer();
void POST_SetInterruptHandler(void (*handler)(void));
void POST_SetSrcSize(u32 OriginalWidth,u32 OriginalHeight,u32 RealWidth,u32 RealHeight);
void POST_SetDstSize(u32 OriginalWidth,u32 OriginalHeight,u32 RealWidth,u32 RealHeight);
int POST_SetOffset(int srcX,int srcY,int dstX,int dstY,POST_COLOR_FORMAT src,POST_COLOR_FORMAT dst);
void POST_SetAddChangeDisable(int disable);
 void POST_DoConverting();
 int POST_GetInputBuffer();
 void POST_StopAudoLoad();
 int POST_GetCurrentOuputIndex();
 void POST_CheckENVID();
 void SelFimcPath(u32 Fimc);

 #endif
