/*-------------------------------------------------------------
 * Filename: post.c
 *
 * Contents: Implemention of Post processor of s5c6440
 *
 * Abbreviations:
 *
 * Person Involved: chun gil lee
 *
 * Notes: 
 *
 * History
 *  - First created by chun gil lee 2008.09.08
 *
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/

#include <fimc_2nd.h>
#include <fimc_test_2nd.h>

//#include <system.h>

//#include "typedef.h"
//#include "system.h"
//#include "sfr_base.h"
//#include "vicint.h"
#include "string.h"
//#include "user_def.h"
#include "def.h"
#include "option.h"
#if defined(S5PV210)
#include "v210_sfr.h"
#include "util.h"
#elif defined(S5P6442)
#include "sfr6442.h"
#include "library.h"
#endif
//#include "intc.h"

#if 0
#if TARGET==SYSTEM_6440
#define POST_INTERRUPT_NUM INT_POST0
#else
#define POST_INTERRUPT_NUM 11
#endif
#else
#define INT_CAMIF_A 69
#define INT_CAMIF_B 70
#define INT_CAMIF_C 71
#define FIMC_INTERRUPT_NUM INT_CAMIF_A

#endif

//#define DBG_POST

#if 0
#define POST_6440_BASE POST_BASE
#define FIMC_C100_BASE CAMIF_BASE
#else
#define FIMC_v210_BASE	 FIMC_A_BASE
#endif

static u32 g_uBaseAddress;


//#define PPOutp32(offset, x) Outp32(g_uBaseAddress+offset, x)
//#define PPInp32(offset, x) {u32 a2, d2; a2 = g_uBaseAddress + offset; d2=x; Inp32(a2);}

//#define PPOutp32(offset, x) Outp32(FIMC_A_BASE+offset, x)
//#define PPInp32(offset, x) {u32 a2, d2; a2 = FIMC_A_BASE + offset; d2=x; Inp32(a2);}

#define PPOutp32(offset, x) Outp32(g_uBaseAddress+offset, x)
#define PPInp32(offset, x) {Inp32_( g_uBaseAddress + offset,x);}

typedef enum
{
	CISRCFMT=0x0,
	CIWDOFST=0x4,
	CIGCTRL=0x8,
	CIFCTRL1=0x0C,
	CIFCTRL2=0x10,
	CIWDOFST2=0x14,
	CIOYSA1=0x18,
	CIOYSA2=0x1C,
	CIOYSA3=0x20,
	CIOYSA4=0x24,
	CIOCBSA1=0x28,
	CIOCBSA2=0x2C,
	CIOCBSA3=0x30,
	CIOCBSA4=0x34,
	CIOCRSA1=0x38,
	CIOCRSA2=0x3C,
	CIOCRSA3=0x40,
	CIOCRSA4=0x44,
	CITRGFMT=0x48,
	CIOCTRL=0x4C,
	CISCPRERATIO=0x50,
	CISCPREDST=0x54,
	CISCCTRL=0x58,
	CITAREA=0x5C,
	CIOLINESKIP=0x60,
	CISTATUS=0x64,
	CIIMGCPT=0xC0,
	CICPTSEQ=0xC4,
	CITHOLD=0xC8,
	CIIMGEFF=0xD0,
	CIIYSA0=0xD4,
	CIICBSA0=0xD8,
	CIICRSA0=0xDC,
	CIILINESKIP_Y=0xEC,
	CIILINESKIP_Cb=0xF0,
	CIILINESKIP_Cr=0xF4,
	CIREAL_ISIZE=0xF8,
	MSCTRL=0xFC,
	CIIYSA1=0x144,		//vega_L
	CIICBSA1=0x148,		//vega_L
	CIICRSA1=0x14c,		//vega_L
	CIOYOFF=0x168,
	CIOCBOFF=0x16C,
	CIOCROFF=0x170,
	CIIYOFF=0x174,
	CIICBOFF=0x178,
	CIICROFF=0x17C,
	ORGISIZE=0x180,
	ORGOSIZE=0x184,
	CIEXTEN=0x188,
	CIDMAPARAM=0x18C,
	CSIIMGFMT=0x194,
	CIOGENERAL=0x198
}POST_ADDR;

typedef union
{
	u32 val;
	struct
	{
		u32 SrcVsize_CAM:14;
		u32 Order422_CAM:2;
		u32 SrcHsize_CAM:13;
		u32 In16bit:1;
		u32 UVOffset:1;
		u32 ITU601_656n:1;
	}CISRCFMT_REG;
	struct
	{
		u32 WinVerOfst:12;
		u32 reserved1:2;
		u32 ClrOvFiCr:1;
		u32 ClrOvFiCb:1;
		u32 WinHorOfst:11;
		u32 reserved2:2;
		u32 ClrOvRLB:1;
		u32 ClrOvFiY:1;
		u32 WinOfsEn:1;
	}CIWDOFST_REG;
	struct
	{
		u32 Cam_Interlace:1;
		u32 InvPolFIELD:1;
		u32 FIELDMODE:1;
		u32 SelCam_CAMIF:1;
		u32 InvPolHSYNC:1;
		u32 CSC_609_709:1;
		u32 SelWB_FIMC:1;
		u32 SelCam_MIPI:1;
		u32 CAM_JPEG:1;
		u32 reserved0:3;
		u32 ShadowDisable:1;
		u32 SwUpdate:1;
		u32 reserved3:2;
		u32 IRQ_Enable:1;
		u32 IRQ_StartEnable:1;
		u32 IRQ_EndDisable:1;
		u32 IRQ_CLR:1;
		u32 IRQ_LEVEL:1;
		u32 Href_mask:1;
		u32 IRQ_Ovfen:1;
		u32 CamRst_B:1;
		u32 InvPolHREF:1;
		u32 InvPolVSYNC:1;
		u32 InvPolPCLK:1;
		u32 TestPattern:2;
		u32 SelCam_ITU:1;
		u32 CamRst_A:1;
		u32 SwRst:1;
	}CIGCTRL_REG;	
	struct
	{
		u32 WinVerOfst2:12;
		u32 reserved:4;
		u32 WinHorOfst2:12;
		u32 reserved1:4;
	}CIWDOFST2_REG;

	struct
	{
		u32 TargetVsize:13;
		u32 OutRot90:1;
		u32 OutFlipMd:2;
		u32 TargetHsize:13;
		u32 OutFormat:2;
		u32 InRot90:1;
	}CITRGFMT_REG;
	struct
	{
		u32 Order422_out:2;
		u32 LastIRQEn:1;
		u32 C_INT_OUT:1;
		u32 reserved1:20;
		u32 Order2p_out:2;
		u32 reserved2:5;
		u32 Weave_out:1;
	}CIOCTRL_REG;
	struct
	{
		u32 PreVerRatio:7;
		u32 reserved1:9;
		u32 PreHorRatio:7;
		u32 reserved2:5;
		u32 SHfactor:4;
	}CISCPRERATIO_REG;
	struct
	{
		u32 PreDstHeight:14;
		u32 reserved1:2;
		u32 PreDstWidth:14;
		u32 reserved2:2;
	}CISCPREDST_REG;
	struct
	{
		u32 MainVerRatio:9;
		u32 One2One:1;
		u32 Ext_RGB:1;
		u32 OutRGB_FMT:2;
		u32 InRGB_FMT:2;
		u32 ScalerStart:1;
		u32 MainHorRatio:9;
		u32 Interlace:1;
		u32 LCDPathEn:1;
		u32 CSCY2R:1;
		u32 CSCR2Y:1;
		u32 ScaleUp_V:1;
		u32 ScaleUp_H:1;
		u32 ScalerBypass:1;
	}CISCCTRL_REG;
	struct
	{
		u32 reserved1:8;
		u32 ENVID_STATUS:1;
		u32 LCD_ENSTATUS:1;
		u32 FrameFieldStatus:1;
		u32 FrameCptStatus:1;
		u32 IRQ_DMAend:1;
		u32 IRQ_CAM:1;
		u32 VVALID_B:1;
		u32 VVALID_A:1;
		u32 LastCaptureEnd:1;
		u32 FrameEnd:1;
		u32 OvRLB:1;
		u32 VSYNC_B:1;
		u32 VSYNC_A:1;
		u32 ImgCptEn_SC:1;
		u32 ImgCptEn:1;
		u32 FlipMd:2;
		u32 WinOfstEn:1;
		u32 FrameCnt:2;
		u32 VSYNC:1;
		u32 OvFiCr:1;
		u32 OvFiCb:1;
		u32 OvFiY:1;
	}CISTATUS_REG;
	struct
	{
		u32 reserved1:10;
		u32 Cpt_FrCnt:8;
		u32 Cpt_FrMod:1;
		u32 Cpt_FrPtr:5;
		u32 reserved2:1;
		u32 Cpt_FrEn:1;
		u32 reserved3:4;
		u32 ImgCptEn_Sc:1;
		u32 ImgCptEn:1;
	}CIIMGCPT_REG;
	struct
	{
		u32 Cpt_FrSeq:32;
	}CICPTSEQ_REG;
	struct
	{
		u32 PAT_Cr:8;
		u32 reserved1:5;
		u32 PAT_Cb:8;
		u32 reserved2:5;
		u32 fIN:3;					
		u32 IE_AFTER_SC:1;
		u32 IE_ON:1;
		u32 reserved3:1;
		}CIIMGEFF_REG;
	struct
	{
		u32 REAL_WIDTH:14;
		u32 reserved1:2;
		u32 REAL_HEIGHT:14;
		u32 ADDR_CH_DIS:1;
		u32 AutoLoadEnable:1;
	}CIREAL_ISIZE_REG;
	struct
	{	
		
		u32 ENVID_M:1;
		u32 InFormat_M:2;
		u32 SEL_DMA_CAM:1;
		u32 Order422_M:2;
		u32 EOF_M:1;
		u32 reserved1:1;
		u32 Buffer_Ptr:1;
		u32 reserved2:1;
		u32 BC_SEL:1;
		u32 reserved3:2;
		u32 InFlipMd:2;
		u32 C_INT_IN:1;
		u32 Order2p_in:2;
		u32 reserved4:1;
		u32 InBuf_Mode:1;
		u32 reserved5:4;
		u32 Successive_cnt:4;
		u32 reserved6:3;
		u32 Weave_in:1;
	}MSCTRL_REG;
	struct
	{
		u32 OYOFF_H:15;
		u32 reserved1:1;
		u32 OYOFF_V:15;
		u32 reserved2:1;
	}CIOYOFF_REG;
	struct
	{
		u32 OCBOFF_H:15;
		u32 reserved1:1;
		u32 OCBOFF_V:15;
		u32 reserved2:1;
	}CIOCBOFF_REG;
	struct
	{
		u32 OCROFF_H:15;
		u32 reserved1:1;
		u32 OCROFF_V:15;
		u32 reserved2:1;
	}CIOCROFF_REG;
	struct
	{
		u32 IYOFF_H:15;
		u32 reserved1:1;
		u32 IYOFF_V:15;
		u32 reserved2:1;
	}CIIYOFF_REG;
	struct
	{
		u32 ICBOFF_H:15;
		u32 reserved1:1;
		u32 ICBOFF_V:15;
		u32 reserved2:1;
	}CIICBOFF_REG;
	struct
	{
		u32 ICROFF_H:15;
		u32 reserved1:1;
		u32 ICROFF_V:15;
		u32 reserved2:1;
	}CIICROFF_REG;
	struct
	{		
		u32 ORG_IN_H:14;
		u32 reserved1:2;
		u32 ORG_IN_V:14;
		u32 reserved2:2;
	}ORGISIZE_REG;
	struct
	{		
		u32 ORG_OUT_H:14;
		u32 reserved1:2;
		u32 ORG_OUT_V:14;
		u32 reserved2:2;
	}ORGOSIZE_REG;
	struct
	{
		u32 reserved1:20;
		u32 YCbCr444_IN:1;
		u32 reserved2:1;
		u32 YCbCr444_OUT:1;
		u32 reserved3:1;
		u32 TargetVsize_ext:1;
		u32 reserved4:1;
		u32 TargetHsize_ext:1;
		u32 reserved5:1;
		u32 WinHorOfst_ext:1;
		u32 reserved6:1;
		u32 SrcHsize_CAM_ext:1;
		u32 reserved7:1;
	}CIEXTEN_REG;
	struct
	{
		u32 reserved1:4;
		u32 reserved2:9;
		u32 MODE_W:2;
		u32 reserved3:14;
		u32 MODE_R:2;
		u32 reserved4:1;
	}CIDMAPARAM_REG;
	struct
	{
		u32 	ImgFormOfCh0:6;
		u32 reserved1:2;
		u32 DATAb_port:2;
		u32 reserved2:22;
	}CSIIMGFMT_REG;
	struct
	{
		u32 O_GENERAL:32;
	}CIOGENERAL;
	
}POST_REG;

static int post_interrupt_completed;
static POST_CONDITION condition;
static void (*POST_IRQHandler)(void)=0;
#if 0
REGISTER post_reg_info[] = 
{ 
	{"CIWDOFST",CIWDOFST,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIGCTRL",CIGCTRL,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0x0110000,0xffffffff,0},
	{"CIOYSA1",CIOYSA1,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOYSA2",CIOYSA2,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOYSA3",CIOYSA3,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOYSA4",CIOYSA4,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCBSA1",CIOCBSA1,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCBSA2",CIOCBSA2,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCBSA3",CIOCBSA3,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCBSA4",CIOCBSA4,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCRSA1",CIOCRSA1,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCRSA2",CIOCRSA2,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCRSA3",CIOCRSA3,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCRSA4",CIOCRSA4,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CITRGFMT",CITRGFMT,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCTRL",CIOCTRL,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CISCPRERATIO",CISCPRERATIO,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CISCPREDST",CISCPREDST,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CISCCTRL",CISCCTRL,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0x18000000,0xffffffff,0},
	{"CITAREA",CITAREA,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CISTATUS",CISTATUS,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIIMGCPT",CIIMGCPT,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIIMGEFF",CIIMGEFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0x00100080,0xffffffff,0},
	{"CIIYSA0",CIIYSA0,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIICBSA0",CIICBSA0,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIICRSA0",CIICRSA0,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIREAL_ISIZE",CIREAL_ISIZE,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"MSCTRL",MSCTRL,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0x02000000,0xffffffff,0},
	{"CIOYOFF",CIOYOFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCBOFF",CIOCBOFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIOCROFF",CIOCROFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIIYOFF",CIIYOFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIICBOFF",CIICBOFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIICROFF",CIICROFF,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"ORGISIZE",ORGISIZE,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"ORGOSIZE",ORGOSIZE,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIEXTEN",CIEXTEN,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
	{"CIDMAPARAM",CIDMAPARAM,REG_WRITE|REG_READ,0xffffffff,0xffffffff,0,0xffffffff,0},
};

// return : invalid reset value offset. if there is no invalid value, it returns 0xffffffff
u32 POST_RegResetValueVerify()
{
	u32 i;

	POST_REG reg;

	for(i=0;i<sizeof(post_reg_info)/sizeof(REGISTER);i++)
	{
		if(post_reg_info[i].type & REG_READ)
		{
			PPInp32(post_reg_info[i].offset, reg.val);
			Disp("%s correct value=0x%x actual value=0x%x masked=0x%x\n",post_reg_info[i].name,post_reg_info[i].resetValue,reg.val,
				(reg.val) & (post_reg_info[i].resetValueMask));
			if((reg.val&post_reg_info[i].resetValueMask)!=post_reg_info[i].resetValue)
			{
				Disp("Wrong reset value at %s(0x%x). correct value=0x%x actual value=0x%x\n",
					post_reg_info[i].name,post_reg_info[i].offset,post_reg_info[i].resetValue,reg.val);
			//	return i;
			}
		}
	}
	return 0xffffffff;
}
#endif

typedef enum 
{
	FIMC_A,
	FIMC_B,
	FIMC_C
}FIMC_CH;

// [Class CAMIF constructor]
void FIMC_SetChannel(FIMC_CH eFimcCh)
{
	switch(eFimcCh)
	{
		case FIMC_A:
			g_uBaseAddress = FIMC_A_BASE;	
			Disp("\n FIMC_A selected:[0x%x] \n",g_uBaseAddress);
			break;
		case FIMC_B:
			g_uBaseAddress = FIMC_B_BASE;
			Disp("\n FIMC_B selected:[0x%x] \n",g_uBaseAddress);
			break;
		case FIMC_C:
			g_uBaseAddress = FIMC_C_BASE;
			Disp("\n FIMC_C selected:[0x%x] \n",g_uBaseAddress);
		default:
			//Assert(0);
			break;
	}
}

// [Select FIMC A]
void SelFimcPath(u32 Fimc)
{
	FIMC_SetChannel(Fimc);
	
}


int POST_SetScaleFactor(u32 srcWidth,u32 srcHeight,u32 dstWidth,u32 dstHeight)
{
	u32 PreHorRatio;
	u32 PreVerRatio;
	u32 H_Shift;
	u32 V_Shift;
	u32 PreDstWidth;
	u32 PreDstHeight;
	u32 MainHorRatio;
	u32 MainVerRatio;
	u32 SHfactor;
	POST_REG reg;
	
	if(srcWidth>=64*dstWidth)return 1;
	else if(srcWidth>=32*dstWidth){PreHorRatio=32; H_Shift=5;}
	else if(srcWidth>=16*dstWidth){PreHorRatio=16; H_Shift=4;}
	else if(srcWidth>=8*dstWidth){PreHorRatio=8; H_Shift=3;}
	else if(srcWidth>=4*dstWidth){PreHorRatio=4;H_Shift=2;}
	else if(srcWidth>=2*dstWidth){PreHorRatio=2; H_Shift=1;}
	else {PreHorRatio=1; H_Shift=0;}

	PreDstWidth=srcWidth/PreHorRatio;
	MainHorRatio=(srcWidth<<8)/(dstWidth<<H_Shift);

	if(srcHeight>=64*dstHeight)return 1;
	else if(srcHeight>=32*dstHeight){PreVerRatio=32; V_Shift=5;}
	else if(srcHeight>=16*dstHeight){PreVerRatio=16; V_Shift=4;}
	else if(srcHeight>=8*dstHeight){PreVerRatio=8; V_Shift=3;}
	else if(srcHeight>=4*dstHeight){PreVerRatio=4;V_Shift=2;}
	else if(srcHeight>=2*dstHeight){PreVerRatio=2; V_Shift=1;}
	else {PreVerRatio=1; V_Shift=0;}

	PreDstHeight=srcHeight/PreVerRatio;
	MainVerRatio=(srcHeight<<8)/(dstHeight<<V_Shift);
	SHfactor=10-(H_Shift + V_Shift);

	reg.val=0;
	reg.CISCPRERATIO_REG.SHfactor=SHfactor;
	reg.CISCPRERATIO_REG.PreHorRatio=PreHorRatio;
	reg.CISCPRERATIO_REG.PreVerRatio = PreVerRatio;
	PPOutp32(CISCPRERATIO,reg.val);

	reg.val=0;
	reg.CISCPREDST_REG.PreDstWidth = PreDstWidth;
	reg.CISCPREDST_REG.PreDstHeight = PreDstHeight;
	PPOutp32(CISCPREDST,reg.val);

	PPInp32(CISCCTRL,reg.val);
	reg.CISCCTRL_REG.MainHorRatio= MainHorRatio;
	reg.CISCCTRL_REG.MainVerRatio= MainVerRatio;

	if(dstWidth>=srcWidth)reg.CISCCTRL_REG.ScaleUp_H=1;
	else reg.CISCCTRL_REG.ScaleUp_H=0;
	if(dstHeight>=srcHeight)reg.CISCCTRL_REG.ScaleUp_V=1;
	else reg.CISCCTRL_REG.ScaleUp_V=0;

	PPOutp32(CISCCTRL,reg.val);

}

void POST_SetRunMode(POST_RUN_MODE mode)
{
	POST_REG reg;
	PPInp32(CIREAL_ISIZE,reg.val);
	if(mode==FREE_RUN)reg.CIREAL_ISIZE_REG.AutoLoadEnable=1;
	else
	{
		reg.CIREAL_ISIZE_REG.AutoLoadEnable=0;
	}
	PPOutp32(CIREAL_ISIZE,reg.val);
}


void POST_SetSrcColorFormat(POST_COLOR_FORMAT colorFormat)
{
	POST_REG reg;
	reg.val=0;
	switch(colorFormat)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 1;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 2;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 3;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.InFormat_M=1;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 1;
			reg.MSCTRL_REG.InFormat_M=1;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 2;
			reg.MSCTRL_REG.InFormat_M=1;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 3;
			reg.MSCTRL_REG.InFormat_M=1;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 1;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 2;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 3;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=1;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.InFormat_M=0;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.InFormat_M=1;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCbCr444_3PLANE:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.C_INT_IN= 0;
			PPOutp32(MSCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.Order422_M =0;
			reg.MSCTRL_REG.InFormat_M=2;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.Order422_M =1;
			reg.MSCTRL_REG.InFormat_M=2;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.Order422_M =2;
			reg.MSCTRL_REG.InFormat_M=2;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.Order2p_in = 0;
			reg.MSCTRL_REG.Order422_M =3;
			reg.MSCTRL_REG.InFormat_M=2;
			reg.MSCTRL_REG.C_INT_IN=0;
			PPOutp32(MSCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB565:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.InFormat_M = 0x3;
			PPOutp32(MSCTRL,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.InRGB_FMT = 0;
			PPOutp32(CISCCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB666:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.InFormat_M = 0x3;
			PPOutp32(MSCTRL,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.InRGB_FMT = 1;
			PPOutp32(CISCCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB888:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_IN= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(MSCTRL,reg.val);
			reg.MSCTRL_REG.InFormat_M = 0x3;
			PPOutp32(MSCTRL,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.InRGB_FMT = 2;
			PPOutp32(CISCCTRL,reg.val);
			break;
		default :
			break;
	}

}
void POST_SetDstColorFormat(POST_COLOR_FORMAT colorFormat)
{
	POST_REG reg;
	reg.val=0;	
	switch(colorFormat)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 0;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 1;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 2;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 3;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 1;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 0;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 1;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 1;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 1;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 2;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 1;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 3;
			reg.CIOCTRL_REG.C_INT_OUT=1;
			PPOutp32(CIOCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 0;
			reg.CIOCTRL_REG.C_INT_OUT= 1;
			PPOutp32(CIOCTRL,reg.val);	
			break;

		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 1;
			reg.CIOCTRL_REG.C_INT_OUT= 1;
			PPOutp32(CIOCTRL,reg.val);	
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 2;
			reg.CIOCTRL_REG.C_INT_OUT= 1;
			PPOutp32(CIOCTRL,reg.val);	
			break;

		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order2p_out = 3;
			reg.CIOCTRL_REG.C_INT_OUT= 1;
			PPOutp32(CIOCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.C_INT_OUT=0;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 1;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.C_INT_OUT=0;
			PPOutp32(CIOCTRL,reg.val);
			break;

		case POST_COLOR_FORMAT_YCbCr444_3PLANE:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 1;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.C_INT_OUT= 0;
			PPOutp32(CIOCTRL,reg.val);	
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 2;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order422_out=0;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 2;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order422_out=1;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 2;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order422_out=2;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 2;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CIOCTRL,reg.val);
			reg.CIOCTRL_REG.Order422_out=3;
			PPOutp32(CIOCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB565:
			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0x3;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.OutRGB_FMT = 0;
			PPOutp32(CISCCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB666:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0x3;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.OutRGB_FMT = 1;
			PPOutp32(CISCCTRL,reg.val);
			break;
		case POST_COLOR_FORMAT_RGB888:

			PPInp32(CIEXTEN,reg.val);
			reg.CIEXTEN_REG.YCbCr444_OUT= 0;
			PPOutp32(CIEXTEN,reg.val);
			PPInp32(CITRGFMT,reg.val);
			reg.CITRGFMT_REG.OutFormat = 0x3;
			PPOutp32(CITRGFMT,reg.val);		
			PPInp32(CISCCTRL,reg.val);
			reg.CISCCTRL_REG.OutRGB_FMT = 2;
			PPOutp32(CISCCTRL,reg.val);
			break;
		default :
			break;
	}
}

void POST_SetSrcSize(u32 OriginalWidth,u32 OriginalHeight,u32 RealWidth,u32 RealHeight)
{
	POST_REG reg;
	reg.val=0;

	reg.ORGISIZE_REG.ORG_IN_H = OriginalWidth;
	reg.ORGISIZE_REG.ORG_IN_V = OriginalHeight;

	PPOutp32(ORGISIZE,reg.val);

	reg.val=0;
	PPInp32(CIREAL_ISIZE, reg.val);
	reg.CIREAL_ISIZE_REG.REAL_WIDTH = RealWidth;
	reg.CIREAL_ISIZE_REG.REAL_HEIGHT = RealHeight;
	PPOutp32(CIREAL_ISIZE, reg.val);
}


void POST_SetDstSize(u32 OriginalWidth,u32 OriginalHeight,u32 RealWidth,u32 RealHeight)
{
	POST_REG reg;
	reg.val=0;

	reg.ORGOSIZE_REG.ORG_OUT_H = OriginalWidth;
	reg.ORGOSIZE_REG.ORG_OUT_V = OriginalHeight;

	PPOutp32(ORGOSIZE,reg.val);

	reg.val=0;
	PPInp32(CITRGFMT,reg.val);
	reg.CITRGFMT_REG.TargetHsize=0x1fff & RealWidth;
	reg.CITRGFMT_REG.TargetVsize= 0x1fff & RealHeight;
	PPOutp32(CITRGFMT,reg.val);

	PPInp32(CIEXTEN,reg.val);
	reg.CIEXTEN_REG.TargetHsize_ext = 1 & ((0x2000 & RealWidth) >> 13);
	reg.CIEXTEN_REG.TargetVsize_ext = 1 & ((0x2000 & RealHeight) >> 13);
	PPOutp32(CIEXTEN,reg.val);

	PPOutp32(CITAREA,RealWidth*RealHeight);

}

int POST_SetOffset(int srcX,int srcY,int dstX,int dstY,POST_COLOR_FORMAT src,POST_COLOR_FORMAT dst)
{
	POST_REG dstRegY;
	POST_REG dstRegCb;
	POST_REG dstRegCr;
	POST_REG srcRegY;
	POST_REG srcRegCb;
	POST_REG srcRegCr;

	switch(dst)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY/2;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX*2;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;

		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX/2;
			dstRegCr.CIOCROFF_REG.OCROFF_H = dstX/2;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY/2;
			dstRegCr.CIOCROFF_REG.OCROFF_V = dstY/2;
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX/2;
			dstRegCr.CIOCROFF_REG.OCROFF_H = dstX/2;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY;
			dstRegCr.CIOCROFF_REG.OCROFF_V = dstY;
			break;

		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = dstX;
			dstRegCr.CIOCROFF_REG.OCROFF_H = dstX;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = dstY;
			dstRegCr.CIOCROFF_REG.OCROFF_V = dstY;

			break;
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX*2;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_RGB565:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX*2;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_RGB666:
		case POST_COLOR_FORMAT_RGB888:
			dstRegY.CIOYOFF_REG.OYOFF_H = dstX*4;
			dstRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_H = 0;

			dstRegY.CIOYOFF_REG.OYOFF_V = dstY;
			dstRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			dstRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
	}

	if(dstRegY.CIOYOFF_REG.OYOFF_H%8!=0)return 1;
	if(dstRegCb.CIOCBOFF_REG.OCBOFF_H%8!=0)return 1;
	if(dstRegCr.CIOCROFF_REG.OCROFF_H%8!=0)return 1;
		
	PPOutp32(CIOYOFF, dstRegY.val);
	PPOutp32(CIOCBOFF, dstRegCb.val);
	PPOutp32(CIOCROFF, dstRegCr.val);
	
	switch(src)
	{
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb420_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr420_2PLANE_FORWARD_ORDER:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY/2;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_2PLANE_FORWARD_ORDER:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;

		case POST_COLOR_FORMAT_YCrCb444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb444_2PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr444_2PLANE_FORWARD_ORDER:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX*2;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;

		case POST_COLOR_FORMAT_YCbCr420_3PLANE:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX/2;
			srcRegCr.CIOCROFF_REG.OCROFF_H = srcX/2;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY/2;
			srcRegCr.CIOCROFF_REG.OCROFF_V = srcY/2;
			break;
		case POST_COLOR_FORMAT_YCbCr422_3PLANE:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX/2;
			srcRegCr.CIOCROFF_REG.OCROFF_H = srcX/2;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY;
			srcRegCr.CIOCROFF_REG.OCROFF_V = srcY;
			break;

		case POST_COLOR_FORMAT_YCbCr444_3PLANE:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = srcX;
			srcRegCr.CIOCROFF_REG.OCROFF_H = srcX;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = srcY;
			srcRegCr.CIOCROFF_REG.OCROFF_V = srcY;
			break;

		case POST_COLOR_FORMAT_YCrCb422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_REVERSE_ORDER:
		case POST_COLOR_FORMAT_YCrCb422_1PLANE_FORWARD_ORDER:
		case POST_COLOR_FORMAT_YCbCr422_1PLANE_FORWARD_ORDER:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX*2;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_RGB565:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX*2;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
		case POST_COLOR_FORMAT_RGB666:
		case POST_COLOR_FORMAT_RGB888:
			srcRegY.CIOYOFF_REG.OYOFF_H = srcX*4;
			srcRegCb.CIOCBOFF_REG.OCBOFF_H = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_H = 0;

			srcRegY.CIOYOFF_REG.OYOFF_V = srcY;
			srcRegCb.CIOCBOFF_REG.OCBOFF_V = 0;
			srcRegCr.CIOCROFF_REG.OCROFF_V = 0;
			break;
	}

	if(srcRegY.CIIYOFF_REG.IYOFF_H%8!=0)return 1;
	if(srcRegCb.CIICBOFF_REG.ICBOFF_H%8!=0)return 1;
	if(srcRegCr.CIICROFF_REG.ICROFF_H %8!=0)return 1;
	
	
	PPOutp32(CIIYOFF, srcRegY.val);
	PPOutp32(CIICBOFF, srcRegCb.val);
	PPOutp32(CIICROFF, srcRegCr.val);

	return 0;

}

static void POST_InterruptHandler(void)
{
	
	POST_REG reg;
	Disp(">");
#if defined(S5PC100) //for c_model (vega_L->c100)
	INTC_Mask(POST_INTERRUPT_NUM);

	PPInp32(CIGCTRL,reg.val);
	reg.CIGCTRL_REG.IRQ_CLR=1;
	PPOutp32(CIGCTRL,reg.val);
	
	post_interrupt_completed=1;

	if(POST_IRQHandler)(*POST_IRQHandler)();

	INTC_ClearPending(POST_INTERRUPT_NUM);
	INTC_Unmask(POST_INTERRUPT_NUM);
#elif defined(S5PV210)|defined(S5P6442)
	//INTC_Mask(FIMC_INTERRUPT_NUM);
//	INTC_Disable(NUM_FIMC_A);

	PPInp32(CIGCTRL,reg.val);
	reg.CIGCTRL_REG.IRQ_CLR=1;
	PPOutp32(CIGCTRL,reg.val);
	
	post_interrupt_completed=1;

	if(POST_IRQHandler)(*POST_IRQHandler)();

//	INTC_ClearPending(FIMC_INTERRUPT_NUM);
//	INTC_Unmask(FIMC_INTERRUPT_NUM);
//	INTC_ClearVectAddr();
//	INTC_Enable(NUM_FIMC_A);
#endif

}

void POST_SetInputDMAAddr(u32 y,u32 cb,u32 cr)
{
	PPOutp32(CIIYSA0,y);
	PPOutp32(CIICBSA0,cb);
	PPOutp32(CIICRSA0,cr);
}

void POST_SetInputDMAAddr2(u32 y,u32 cb,u32 cr)
{
#if defined(S5PC100)|defined(S5P6442)//for c_model (vega_L->c100)
	PPOutp32(CIIYSA1,y);
	PPOutp32(CIICBSA1,cb);
	PPOutp32(CIICRSA1,cr);
#endif
}

void POST_SetOutputPath(POST_PATH path)
{
	POST_REG reg;
	if(path==POST_DMA)
	{
		PPInp32(CISCCTRL,reg.val);
		reg.CISCCTRL_REG.LCDPathEn = 0;
		reg.CISCCTRL_REG.Interlace=0;
		PPOutp32(CISCCTRL,reg.val);		
	}
	else
	{
		PPInp32(CISCCTRL,reg.val);
		reg.CISCCTRL_REG.LCDPathEn = 1;
		reg.CISCCTRL_REG.Interlace=0;
		PPOutp32(CISCCTRL,reg.val);		
	}
}

 int POST_SetCondition(POST_CONDITION cond)
 {
	POST_REG reg;
	
	PPOutp32(CIOYSA1,cond.OutAddr1.Y);
	PPOutp32(CIOYSA2,cond.OutAddr2.Y);
	PPOutp32(CIOYSA3,cond.OutAddr3.Y);
	PPOutp32(CIOYSA4,cond.OutAddr4.Y);

	PPOutp32(CIOCBSA1,cond.OutAddr1.Cb);
	PPOutp32(CIOCBSA2,cond.OutAddr2.Cb);
	PPOutp32(CIOCBSA3,cond.OutAddr3.Cb);
	PPOutp32(CIOCBSA4,cond.OutAddr4.Cb);

	PPOutp32(CIOCRSA1,cond.OutAddr1.Cr);
	PPOutp32(CIOCRSA2,cond.OutAddr2.Cr);
	PPOutp32(CIOCRSA3,cond.OutAddr3.Cr);
	PPOutp32(CIOCRSA4,cond.OutAddr4.Cr);

	POST_SetInputDMAAddr(cond.InAddr.Y,cond.InAddr.Cb,cond.InAddr.Cr);
	POST_SetScaleFactor(cond.srcImageWidth,cond.srcImageHeight,cond.dstImageWidth,cond.dstImageHeight);
	POST_SetRunMode(cond.runMode);
	POST_SetSrcColorFormat(cond.src); //TO be modified
	POST_SetDstColorFormat(cond.dst);
	POST_SetSrcSize(cond.srcOriginalImageWidth,cond.srcOriginalImageHeight,cond.srcImageWidth,cond.srcImageHeight);
	POST_SetDstSize(cond.dstScreenWidth,cond.dstScreenHeight,cond.dstImageWidth,cond.dstImageHeight);
	if(POST_SetOffset(cond.srcOffsetX,cond.srcOffsetY,cond.dstOffsetX,cond.dstOffsetY,cond.src,cond.dst))
	{
		return 1;
	}

	PPInp32(CISCCTRL,reg.val);
	if(cond.RGBInputExtension)reg.CISCCTRL_REG.Ext_RGB=1;
	else reg.CISCCTRL_REG.Ext_RGB=0;

	if(cond.One2One)reg.CISCCTRL_REG.One2One=1;
	else reg.CISCCTRL_REG.One2One=0;

	if(cond.R2YRange == POST_CSC_WIDE)reg.CISCCTRL_REG.CSCR2Y=1;
	else reg.CISCCTRL_REG.CSCR2Y=0;

	if(cond.Y2RRange == POST_CSC_WIDE)reg.CISCCTRL_REG.CSCY2R=1;
	else reg.CISCCTRL_REG.CSCY2R=0;
	PPOutp32(CISCCTRL,reg.val);


	if(cond.waitMode==POST_WAIT_MODE_INTERRUPT)
	{
		Disp("POST_WAIT_MODE_INTERRUPT Setting--------->");
		PPInp32(CIGCTRL,reg.val);
		reg.CIGCTRL_REG.IRQ_LEVEL=1;
		reg.CIGCTRL_REG.IRQ_Enable = 1;
		PPOutp32(CIGCTRL,reg.val);
#if defined(S5PC100)	//for c_model (vega_L->c100)
		INTC_SetVectAddr(POST_INTERRUPT_NUM, POST_InterruptHandler);
		INTC_Enable(POST_INTERRUPT_NUM);
#else

//		INTC_SetVectAddr(NUM_FIMC_A,POST_InterruptHandler);
//		INTC_Enable(NUM_FIMC_A);
#endif
	}
	else
	{
		PPInp32(CIGCTRL,reg.val);
		reg.CIGCTRL_REG.IRQ_Enable = 0;
		PPOutp32(CIGCTRL,reg.val);
	}

	POST_SetOutputPath(cond.postPath);

	if(cond.InputDoubleBufferEnable)
	{
		PPInp32(MSCTRL,reg.val);
		reg.MSCTRL_REG.InBuf_Mode=1;
		reg.MSCTRL_REG.SEL_DMA_CAM=1;
		reg.MSCTRL_REG.InBuf_Mode=1;
		reg.MSCTRL_REG.SEL_DMA_CAM=1;

		PPOutp32(MSCTRL,reg.val);
	}
	else
	{
		PPInp32(MSCTRL,reg.val);
		reg.MSCTRL_REG.InBuf_Mode=0;
		reg.MSCTRL_REG.SEL_DMA_CAM=1;
	//	reg.MSCTRL_REG.InBuf_Mode=1;
		reg.MSCTRL_REG.SEL_DMA_CAM=1;
		PPOutp32(MSCTRL,reg.val);
	}

	condition = cond;

	return 0;
 }

void POST_SetAddChangeDisable(int disable)
{
	POST_REG reg;
	if(disable)
	{
		PPInp32(CIREAL_ISIZE,reg.val);
		reg.CIREAL_ISIZE_REG.ADDR_CH_DIS=1;
		PPOutp32(CIREAL_ISIZE,reg.val);
	}
	else
	{
		PPInp32(CIREAL_ISIZE,reg.val);
		reg.CIREAL_ISIZE_REG.ADDR_CH_DIS=0;
		PPOutp32(CIREAL_ISIZE,reg.val);
	}		

}

 void POST_DoConverting()
 {
	POST_REG reg;
	POST_REG tmp;
	
	PPInp32(CIIMGCPT, reg.val);
	reg.CIIMGCPT_REG.ImgCptEn_Sc=1;
	PPOutp32(CIIMGCPT,reg.val);
#if 1		
	PPInp32(CISCCTRL, reg.val);
	reg.CISCCTRL_REG.ScalerStart=1;
	PPOutp32(CISCCTRL,reg.val);

	post_interrupt_completed = 0;

	PPInp32(MSCTRL, reg.val);
	reg.MSCTRL_REG.ENVID_M=1;
//	Disp("0x%x\n",reg.MSCTRL_REG);
	PPOutp32(MSCTRL,reg.val);
#else

	PPOutp32(CIGCTRL,0x20000080);
	PPOutp32(CIIMGCPT,0x40000000);
	PPOutp32(CISCCTRL,0x7900C100);
	PPOutp32(MSCTRL,0x0400000E);
	PPOutp32(MSCTRL,0x0400000F);

//	PPInp32(MSCTRL, reg.val);
//	reg.MSCTRL_REG.ENVID_M=1;
//	PPOutp32(MSCTRL,reg.val);
#endif	
 }

/* It has been dropped from spec.
void POST_SetInputBuffer(int index)
{
	POST_REG reg;
	if(index)
	{
		PPInp32(MSCTRL,reg.val);
		reg.MSCTRL_REG.Buffer_Ptr=1;
		PPOutp32(MSCTRL,reg.val);
	}
	else
	{
		PPInp32(MSCTRL,reg.val);
		reg.MSCTRL_REG.Buffer_Ptr=0;
		PPOutp32(MSCTRL,reg.val);

	}
}
*/

int POST_GetInputBuffer()
{
	POST_REG reg;
	PPInp32(MSCTRL,reg.val);
	return reg.MSCTRL_REG.Buffer_Ptr;
	return 0;

	
}

void POST_StopAudoLoad()
{
	POST_REG reg;
	PPInp32(CIREAL_ISIZE,reg.val);
	reg.CIREAL_ISIZE_REG.AutoLoadEnable=0;
	PPOutp32(CIREAL_ISIZE,reg.val);

	do{
		PPInp32(MSCTRL, reg.val);
	}while(reg.MSCTRL_REG.ENVID_M);
}

int POST_GetCurrentOuputIndex()
{
	POST_REG reg;
	PPInp32(CISTATUS,reg.val);
	return reg.CISTATUS_REG.FrameCnt;
}

void POST_CheckENVID()
{
	POST_REG reg;
	//Disp("Checking ENVID\n");

	do{
		PPInp32(MSCTRL, reg.val);
	}while(reg.MSCTRL_REG.ENVID_M==1);	

	//Disp("ENVID is low\n");
	
	do{
		PPInp32(MSCTRL, reg.val);
	}while(reg.MSCTRL_REG.ENVID_M==0);	
}

 void POST_WaitConverting()
 {
	POST_REG reg;
	
	if(condition.waitMode == POST_WAIT_MODE_INTERRUPT)
	{
		while(1)
		{
			if(post_interrupt_completed==1)break;
		}
		post_interrupt_completed=0;
	}
	else
	{
		do{
			PPInp32(MSCTRL, reg.val);
		}while(reg.MSCTRL_REG.ENVID_M);
	}

	
	PPInp32(CISTATUS,reg.val);
	reg.CISTATUS_REG.FrameEnd=0;
	PPOutp32(CISTATUS,reg.val);
	
 }

void POST_SetInterruptHandler(void (*handler)(void))
{
	POST_IRQHandler = handler;
}

void POST_NoramlScaling(POST_COLOR_YCBCR srcAddr,POST_COLOR_YCBCR dstAddr,
	int srcFullWidth,int srcFullHeight,int dstFullWidth,int dstFullHeight,
	POST_RECT srcRect,POST_RECT dstRect,POST_COLOR_FORMAT srcColor, POST_COLOR_FORMAT dstColor)
{
	POST_CONDITION condition;
	POST_getDefaultPostCondition(&condition);   

	condition.src = srcColor;
	condition.dst = dstColor;
	condition.srcOriginalImageWidth = srcFullWidth;
	condition.srcOriginalImageHeight = srcFullHeight;
	condition.dstScreenWidth = dstFullWidth;
	condition.dstScreenHeight = dstFullHeight;

	condition.InAddr = srcAddr;
	condition.OutAddr1 = dstAddr;
	condition.OutAddr2 = dstAddr;
	condition.OutAddr3 = dstAddr;
	condition.OutAddr4 = dstAddr;
	
	condition.srcImageWidth = srcRect.width;
	condition.srcImageHeight = srcRect.height;
	condition.srcOffsetX = srcRect.x;
	condition.srcOffsetY = srcRect.y;

	condition.dstImageWidth = dstRect.width;
	condition.dstImageHeight = dstRect.height;
	condition.dstOffsetX = dstRect.x;
	condition.dstOffsetY = dstRect.y;

	POST_SetCondition(condition);
}

