/**************************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2008 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : RawConverter.h
*  
*	File Description : This file implements converting BayerRGB to RGB24(For CSI-Slave functions).
*
*	Author : Jun,Kim
*	Dept. : AP Development Team
*	Created Date : 
*	Version : 0.1 
* 
*	History
*	- Created(Jun,Kim 2009/08/02)
**************************************************************************************/

#ifndef __MIPI_CAMERA_H__
#define __MIPI_CAMERA_H__

/*=====================================
				S5K4EA Defined
=====================================*/
/*========Defined Value(Don't modify)===========*/
#define S5K4EA_Speed_310Mbps		0
#define S5K4EA_Speed_368Mbps		1
#define S5K4EA_Speed_464Mbps		2
#define S5K4EA_Speed_552Mbps		3
#define S5K4EA_Speed_600Mbps		4
#define S5K4EA_Speed_648Mbps		5
#define S5K4EA_Speed_736Mbps		6
#define S5K4EA_Speed_832Mbps		7
#define S5K4EA_Speed_920Mbps		8

#define S5K4EA4Khz_0Mhz		0x0000
#define S5K4EA4Khz_38Mhz		0x251C
#define S5K4EA4Khz_46Mhz		0x2CEC
#define S5K4EA4Khz_58Mhz		0x38A4
#define S5K4EA4Khz_69Mhz		0x4362
#define S5K4EA4Khz_75Mhz		0x493E
#define S5K4EA4Khz_81Mhz		0x4F1A
#define S5K4EA4Khz_91Mhz		0x58DE
#define S5K4EA4Khz_92Mhz		0x59D8
#define S5K4EA4Khz_93Mhz		0x5AD2
#define S5K4EA4Khz_104Mhz		0x6590
#define S5K4EA4Khz_115Mhz		0x704E

#define S5K4EAFrTime_30fps		0x014D	// 33.3ms -> 30 fps
#define S5K4EAFrTime_15fps		0x029A	// 66.6ms -> 15 fps
#define S5K4EAFrTime_7P5fps		0x0535	// 133.3ms -> 7.5 fps
#define S5K4EAFrTime_1P5fps		0x1964	// 650.0ms -> 1.5 fps
/*=====================================*/
/*========Register map for S5K4EA EVT1(Don't modify)===========*/
#define S5K4EA_REG_TC_IPRM_InClockLSBs				0x0238
#define S5K4EA_REG_TC_IPRM_InClockMSBs				0x023A
#define S5K4EA_REG_TC_IPRM_UseNPviClocks				0x0252
#define S5K4EA_REG_TC_IPRM_UseNMipiClocks				0x0254
#define S5K4EA_REG_TC_IPRM_NumberOfMipiLanes			0x0256
#define S5K4EA_REG_TC_IPRM_OpClk4KHz_0				0x025A
#define S5K4EA_REG_TC_IPRM_MinOutRate4KHz_0			0x025C
#define S5K4EA_REG_TC_IPRM_MaxOutRate4KHz_0			0x025E
#define S5K4EA_REG_TC_IPRM_InitParamsUpdated			0x026E
#define S5K4EA_REG_TC_GP_EnablePreview				0x0280
#define S5K4EA_REG_TC_GP_EnablePreviewChanged		0x0282
#define S5K4EA_REG_TC_GP_EnableCapture				0x0284
#define S5K4EA_REG_TC_GP_EnableCaptureChanged		0x0286
#define S5K4EA_REG_TC_GP_NewConfigSync				0x0290
#define S5K4EA_REG_TC_GP_ActivePrevConfig				0x02A4
#define S5K4EA_REG_TC_GP_PrevConfigChanged			0x02A6
#define S5K4EA_REG_TC_GP_PrevOpenAfterChange			0x02A8
#define S5K4EA_REG_TC_GP_ActiveCapConfig				0x02AC
#define S5K4EA_REG_TC_GP_CapConfigChanged			0x02AE
#define S5K4EA_REG_0TC_PCFG_usWidth					0x02E2
#define S5K4EA_REG_0TC_PCFG_usHeight					0x02E4
#define S5K4EA_REG_0TC_PCFG_Format					0x02E6
#define S5K4EA_REG_0TC_PCFG_usMaxOut4KHzRate			0x02E8
#define S5K4EA_REG_0TC_PCFG_usMinOut4KHzRate			0x02EA
#define S5K4EA_REG_0TC_PCFG_PVIMask					0x02F0
#define S5K4EA_REG_0TC_PCFG_uClockInd					0x02F8
#define S5K4EA_REG_0TC_PCFG_FrRateQualityType			0x02FC
#define S5K4EA_REG_0TC_PCFG_usFrTimeType				0x02FA
#define S5K4EA_REG_0TC_PCFG_usMaxFrTimeMsecMult10	0x02FE
#define S5K4EA_REG_0TC_PCFG_usMinFrTimeMsecMult10	0x0300
/*================================================*/

/*=====================================
				S5K6AA Defined
=====================================*/
/*========Register map for S5K4EA EVT1(Don't modify)===========*/
#define	S5K6AA_REG_TC_GP_EnablePreview				0x01F0
#define	S5K6AA_REG_TC_GP_EnablePreviewChanged		0x01F2
#define	S5K6AA_REG_TC_GP_SleepMode					0x022E
#define	S5K6AA_REG_TC_GP_SleepModeChanged			0x0230
#define	S5K6AA_setot_usForceClocksSettings				0x0AEA
#define	S5K6AA_setot_usConfigClocksSettings				0x0AEC	
/*================================================*/

/*=====================================
				Public Functions
=====================================*/
void MIPICAM_Prepare(CIS_MODEL eCisModel, IMG_FMT eFinImgType, 
						IMG_RESOLUTION eImgSize, CSIS_DATA_LANE_NUM eCSISDataLaneNum);
void MIPICAM_Start(CIS_MODEL eCisModel, IMG_FMT eFinImgType, IMG_RESOLUTION eImgSize);
void MIPICAM_Disable(void);
#endif //__MIPI_CAMERA_H__

