/**************************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2008 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : RawConverter.c
*  
*	File Description : This file implements converting BayerRGB to RGB24(For CSI-Slave functions).
*
*	Author : Jun,Kim
*	Dept. : AP Development Team
*	Created Date : 
*	Version : 0.1 
* 
*	History
*	- Created(Jun,Kim 2009/08/02)
**************************************************************************************/
#include "util.h"
#include "sysc.h"
#include "gpio.h"
#include "iic.h"
#include "csi.h"
#include "mipi_camera.h"

static u8 ucCamI2CAddr;

static void MIPICAM_IICOpen()
{
	I2C_General_IP_Init();
}

static void SetRegByI2C_Byte3(u32 setFileValue)
{
	u8 *u8Array = (u8*)&setFileValue;
	u8  ucIicData[4];
	s32 iRetval = OK;	
	
	Assert(setFileValue < 0x1000000);

	ucIicData[0] = u8Array[2];	// Sub Address[15:8]
	ucIicData[1] = u8Array[1];	// Sub Address[7:0]
	ucIicData[2] = u8Array[0];	// Data[7:0]
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x3);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	
	
}

static void SetRegByI2C_Byte4(u32 setFileValue)
{
	u8 *u8Array = (u8*)&setFileValue;
	u8  ucIicData[4];
	s32 iRetval = OK;	
	
	Assert(setFileValue >= 0x10000);

	ucIicData[0] = u8Array[3];	// Sub Address[15:8]
	ucIicData[1] = u8Array[2];	// Sub Address[7:0]
	ucIicData[2] = u8Array[1];	// Data[15:8]
	ucIicData[3] = u8Array[0];	// Data[7:0]
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x4);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	
	
}

static void SetRegByI2C_Reg2Data2(u16 RegValue, u16 DataValue)
{
	u8 *u8Array = (u8*)&RegValue;
	u8 *u8Array2= (u8*)&DataValue;
	u8  ucIicData[4];
	s32 iRetval = OK;	

	ucIicData[0] = u8Array[1];	// Sub Address[15:8]
	ucIicData[1] = u8Array[0];	// Sub Address[7:0]
	ucIicData[2] = u8Array2[1];	// Data[15:8]
	ucIicData[3] = u8Array2[0];	// Data[7:0]
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x4);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	
}

static void SetRegOfS5K4EAGX(u32 RegValue, u16 DataValue)
{
	s32 iRetval = OK;	
	u8 *u8RegArray = (u8*)&RegValue;
	u8 *u8DataArray= (u8*)&DataValue;	
	u8 ucIicData[4];
	
	ucIicData[0]=0x00;
	ucIicData[1]=0x28;
	ucIicData[2]=u8RegArray[3];
	ucIicData[3]=u8RegArray[2];
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x4);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	

	ucIicData[0]=0x00;
	ucIicData[1]=0x2a;
	ucIicData[2]=u8RegArray[1];
	ucIicData[3]=u8RegArray[0];
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x4);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	

	ucIicData[0]=0x0f;
	ucIicData[1]=0x12;
	ucIicData[2]=u8DataArray[1];
	ucIicData[3]=u8DataArray[0];
	iRetval = I2C_Master_Polling_Write(I2C_CH0, ucCamI2CAddr, ucIicData, (s32)0x4);
	if(iRetval == ERROR)
	{
		Disp("\n\n\n\n\n ============ Check IIC !!! ============ \n\n\n\n\n");
	}	
}

/*========4EA Setting(Modify)=================*/
/*	FPS Setting	*/
#define S5K4EA_FrTime_MAX	S5K4EAFrTime_30fps
/*	Speed Setting	*/
#define S5K4EA_LANESPEED	S5K4EA_Speed_736Mbps
/*======================================*/
#if (S5K4EA_LANESPEED == S5K4EA_Speed_310Mbps)
// 368 Mbps(Pclk 46Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_38Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_38Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_368Mbps)
// 368 Mbps(Pclk 46Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_46Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_46Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_464Mbps)
// 464 Mbps (Pclk 58Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_58Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_58Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_552Mbps)
// 552 Mbps(Pclk 69Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_69Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_69Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_600Mbps)
// 600 Mbps(Pclk 75Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_75Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_75Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_648Mbps)
// 648 Mbps(Pclk 81Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_81Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_81Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_736Mbps)
// 736 Mbps(Pclk 92Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_91Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_93Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_832Mbps)
// 832 Mbps(Pclk 104Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_104Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_104Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_920Mbps)
// 920 Mbps(Pclk 115Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_115Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_115Mhz
#endif

// Module B'd Type(EVT1) SetFile(This setting don't work with Package type)
static void S5K4EA_Init(IMG_FMT eSrcFmt, u32 CamImgWidth, u32 CamImgHeight, CSIS_DATA_LANE_NUM eCSISDataLaneNum)
{
	u8 uNumOfMipiLanes;
	u16 uPreviewFormatValue;
	u16 uPCFGPVIMaskValue;
	u16 uCropSizeWidth, uCropSizeHeight;	
	u16 uInOffsetW, uInOffsetH;	

	Assert((eSrcFmt==CBYCRY) ||(eSrcFmt==BayerRGB8) ||(eSrcFmt==BayerRGB10) ||(eSrcFmt==BayerRGB12));

	if(CamImgWidth == 1920 && CamImgHeight == 1088) {
		uCropSizeWidth = 1920;
		uCropSizeHeight = 1088;
		uInOffsetW = 336;
		uInOffsetH = 432;
	}
	else if(CamImgWidth == 2592 && CamImgHeight == 1944) {
		uCropSizeWidth = 2592;
		uCropSizeHeight = 1944;
		uInOffsetW = 0;
		uInOffsetH = 0;
	}	
	else {
		uCropSizeWidth = 1920;
		uCropSizeHeight = 1080;
		uInOffsetW = 336;
		uInOffsetH = 432;
	}

	Disp("[4EA]Size : %d*%d\n", CamImgWidth, CamImgHeight);
	if(eCSISDataLaneNum == DATALANE1) {                                                  
		Disp("[4EA]Lane : 1 lane\n"); 
		uNumOfMipiLanes = 1;
	}                                                                                                                                                                                      
	else if (eCSISDataLaneNum == DATALANE2) {                                                                                                                                                         
		Disp("[4EA]Lane : 2 lane\n"); 
		uNumOfMipiLanes = 2;
	}                                                                                                                                                                                      
	else                                                                                                                                                                                   
		Assert(0);     

	if(eSrcFmt == CBYCRY) {
		Disp("[4EA]CBYCRY\n"); 	
		uPreviewFormatValue = 0x0005;
		uPCFGPVIMaskValue = 0x0000;
	}
	else {
		// Raw format supports only max. size
		Assert(CamImgWidth == 2592);                                                                                                                                                                    
		Assert(CamImgHeight == 1944);    
		uPreviewFormatValue = 0x0007;

		if(eSrcFmt == BayerRGB8) {
			Disp("[4EA]BayerRGB8\n"); 	
			uPCFGPVIMaskValue = 0x0100;
		}
		else if(eSrcFmt == BayerRGB10) {
			Disp("[4EA]BayerRGB10\n"); 	
			uPCFGPVIMaskValue = 0x0000;
		}
		else if(eSrcFmt == BayerRGB12) {
			Disp("[4EA]BayerRGB12\n"); 	
			uPCFGPVIMaskValue = 0x0200;
		}
		else
			Assert(0);
	}
		
#if (S5K4EA_FrTime_MAX == S5K4EAFrTime_30fps)
	Disp("[4EA]FPS : Under 30 fps\n"); 
#elif (S5K4EA_FrTime_MAX == S5K4EAFrTime_15fps)
	Disp("[4EA]FPS : Under 15 fps\n"); 		
#elif (S5K4EA_FrTime_MAX == S5K4EAFrTime_7P5fps)
	Disp("[4EA]FPS : Under 7.5 fps\n"); 
#endif

#if (S5K4EA_LANESPEED == S5K4EA_Speed_310Mbps)
	Disp("[4EA]Speed : Under 310 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_368Mbps)
	Disp("[4EA]Speed : Under 368 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_464Mbps)
	Disp("[4EA]Speed : Under 464 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_552Mbps)
	Disp("[4EA]Speed : Under 552 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_600Mbps)
	Disp("[4EA]Speed : Under 600 Mbps\n"); 	
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_648Mbps)
	Disp("[4EA]Speed : Under 648 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_736Mbps)
	Disp("[4EA]Speed : Under 736 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_832Mbps)
	Disp("[4EA]Speed : Under 832 Mbps\n"); 
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_920Mbps)
	Disp("[4EA]Speed : Under 920 Mbps\n"); 
#endif

	Delay(1000);	// p100	// Wait100mSec
	// Start user init script


	//////////////////////////////////////////////////////////////////////////////////////////
	// S5K4EAGX EVT0 CIS analog register setting
	// 2009.06.09	(High Speed)
	//////////////////////////////////////////////////////////////////////////////////////////
	SetRegByI2C_Byte4(0xFCFCD000);

	//======================================= Analog/APS setting ===============================================================                                                             
	//WRITE	D000F262	0000	// tgr_auto_exp (shutter off=0b shutter on=1b)
	SetRegByI2C_Byte4(0x0028D000);

	//002A	F468
	//0F12	0006	// For avg mode
	    	
	SetRegByI2C_Byte4(0x002AF404);
	SetRegByI2C_Byte4(0x0F12002A);	// ADC SAT(450mV): revised by Ana 090609
	SetRegByI2C_Byte4(0x002AF46E);
	SetRegByI2C_Byte4(0x0F120002);	// CDS TEST [0]SR/SS EN: revised by Ana 090126
	// [1]S1 H, [2]LDB H, [3]clp H
	// [4]S34 P X, [5]S24 N X
	SetRegByI2C_Byte4(0x002AF45A);
	SetRegByI2C_Byte4(0x0F120002);	// LD LDB EN : revised by Ana 090126
	SetRegByI2C_Byte4(0x002AF40E);
	SetRegByI2C_Byte4(0x0F120004);	// RMP REG 1.8V: revised by Ana 090126
	SetRegByI2C_Byte4(0x002AF40C);
	SetRegByI2C_Byte4(0x0F120020);	// rmp_option(RMP_INIT_DAC): revised by Ana 090126
	    	
	SetRegByI2C_Byte4(0x002AF420);
	SetRegByI2C_Byte4(0x0F120076);  //For SHBN 76	//0075	// COMP(CDS) bias [7:4] comp2, [3:0] comp1: revised by Ana 090126
	    	
	SetRegByI2C_Byte4(0x0F120005);	// pix current bias
	    	
	SetRegByI2C_Byte4(0x002AF426);
	SetRegByI2C_Byte4(0x0F1200D4);	// CLP level
	SetRegByI2C_Byte4(0x002AF460);
	SetRegByI2C_Byte4(0x0F120001);	// CLP on: revised by Ana 090126
	    	
	SetRegByI2C_Byte4(0x002AE304);
	SetRegByI2C_Byte4(0x0F120081);	// ADC OFFSET 128: revised by Ana 090126
	SetRegByI2C_Byte4(0x002AE308);
	SetRegByI2C_Byte4(0x0F120081);	// ADC DEFAULT 128: revised by Ana 090209

	// ADLC
	SetRegByI2C_Byte4(0x002AE506);
	SetRegByI2C_Byte4(0x0F120093);	// ADLC [7]FL,[6:5]FM,: revised by Ana 090126
	// [4]F,[3:2]LM,[1]L,[0]CH
	SetRegByI2C_Byte4(0x002AE402);
	SetRegByI2C_Byte4(0x0F12040C);	// ADLC BPR EN[10], th 12: revised by Ana 090126
	//WRITE	D000E510	3804	// adlc_frame_filter_co_reg[B][A]

	SetRegByI2C_Byte4(0x002AF42A);
	SetRegByI2C_Byte4(0x0F120080);	// ALL TX mode enable(ref_option[7]): revised by Ana 090130
	    	
	SetRegByI2C_Byte4(0x002AF408);
	SetRegByI2C_Byte4(0x0F12000E);	// aig_sig_mx: revised by Ana 090209
	SetRegByI2C_Byte4(0x0F120007);	/// aig_rst_mx: revised by Ana 090209
	SetRegByI2C_Byte4(0x002AF400);
	SetRegByI2C_Byte4(0x0F120007);	// 0007	//aig_off_rst1: for 92MHZ HS (full)
							// 0006	//aig_off_rst1: for 92MHz LS(full & avg)/ 46MHz LS(full)
							// 0005	//aig_off_rst1: for 46MHz LS(avg)
							// 0004 //aig_off_rst1: for 46MHz HS (full)

	// Doubler	
	SetRegByI2C_Byte4(0x002AF43C);
	SetRegByI2C_Byte4(0x0F120001);	// aig_pd_inrush_ctrl: revised by Ana 090126
	SetRegByI2C_Byte4(0x002AF440);
	SetRegByI2C_Byte4(0x0F120044);	// aig_rosc_tune_ncp[7:4], aig_rosc_tune_cp[3:0]: revised by Ana 090126
	SetRegByI2C_Byte4(0x002AF444);
	SetRegByI2C_Byte4(0x0F120008);	// aig_reg_tune_pix
	SetRegByI2C_Byte4(0x002AF448);
	SetRegByI2C_Byte4(0x0F120008);	// aig_reg_tune_ntg
	    	
	SetRegByI2C_Byte4(0x002AF45C);
	SetRegByI2C_Byte4(0x0F120001);	// aig_dshut_en

	//Multiple Sampling
	SetRegByI2C_Byte4(0x002AF406);
	SetRegByI2C_Byte4(0x0F120001);	// MS[2:0], No Multiple Sampling @92MHz,: revised by Ana 090130
	         		// 1b' 2 times multiple sampling(0001h) for 46MHz or LS@92MHz
	SetRegByI2C_Byte4(0x002AF410);
	SetRegByI2C_Byte4(0x0F120000);    // MSOFF_EN=0 : no Multiple sampling if gain < 2 : revised by Ana 090609    
	//== APS Timing ============================================================================================================             
	SetRegByI2C_Byte4(0x0028D000);
	SetRegByI2C_Byte4(0x002AF472);
	SetRegByI2C_Byte4(0x0F12005C);	//For 92MHz LS & HS aig_dstx_width(1us@92MHz)	: revised by Ana 090216 
							//002E	//aig_dstx_width(1us@46MHz)	: revised by Ana 090216

	//For 46MHz 7.5fps
	//002A	F476
	//0F12	0045	//aig_stx_width(1.5us@46MHz): revised by Ana 090216	 				
	    	
	SetRegByI2C_Byte4(0x0028D000);
	SetRegByI2C_Byte4(0x002AF470);
	SetRegByI2C_Byte4(0x0F120004);

	//== CDS Timing ============================================================================================================
	// Rom retreive address was changed from 0x70003880 to 0x7000 3C00. 
	//2009.03.16

	SetRegByI2C_Byte4(0x00287000);  

	//value       register                                     decription.  
	//700017CC    senHal_ContPtrs_senModesDataArr[0]           nomal speed, normal
	//700017D0    senHal_ContPtrs_senModesDataArr[1]           nomal speed, avg mode
	//700017D4    senHal_ContPtrs_senModesDataArr[2]           nomal speed, weighted mode
	//700017D8    senHal_ContPtrs_senHighSpeedModesDataArr[0]  high speed, normal       
	//700017DC    senHal_ContPtrs_senHighSpeedModesDataArr[1]  high speed, avg mode   
	//700017E0    senHal_ContPtrs_senHighSpeedModesDataArr[2]  high speed, weighted mode  

	//HS_Normal        
	SetRegByI2C_Byte4(0x002A17D8);	// High speed Normal/Dig-subsampling         
	SetRegByI2C_Byte4(0x0F123C00);	// senHal_ContPtrs_senModesDataArr         
	SetRegByI2C_Byte4(0x0F127000);	// senHal_ContPtrs_senModesDataArr   

	//1.15fps@92MHz,HS,Normal //2.15fps@92MHz,LS,Normal 
	//3.15fps@92MHz,HS,avg    //4.15fps@92MHz,LS,avg   

	//1.                                                                     
	SetRegByI2C_Byte4(0x002A3C00);    //1.    //2.    //3.    //4.  
	SetRegByI2C_Byte4(0x0F120003);    //0003  //0003  //0003  //0003
	SetRegByI2C_Byte4(0x0F1205BA);	  //05BA  //098A  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F1205BC);	  //05BC  //098C  //0414  //05CE
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //040F  //05C9
	SetRegByI2C_Byte4(0x0F1205BC);	  //05BC  //098C  //0820  //0B94
	SetRegByI2C_Byte4(0x0F120014);	  //0014  //0014  //0014  //0014
	SetRegByI2C_Byte4(0x0F1205BC);	  //05BC  //098C  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120014);	  //0014  //0014  //0422  //05DC
	SetRegByI2C_Byte4(0x0F1205BC);	  //05BC  //098C  //0820  //0B94
	SetRegByI2C_Byte4(0x0F1201AE);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F120238);	  //0238  //0310  //01D0  //0240
	SetRegByI2C_Byte4(0x0F1201AE);	  //01AE  //0286  //0554  //077E
	SetRegByI2C_Byte4(0x0F120238);	  //0238  //0310  //05DE  //0808
	SetRegByI2C_Byte4(0x0F120238);	  //0238  //0310  //01D0  //0240
	SetRegByI2C_Byte4(0x0F1205BA);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //05DE  //0808
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F1201AC);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0414  //05CE
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F1201AC);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F120240);	  //0240  //0318  //01D8  //0248
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //05E6  //0810
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12008C);	  //008C  //008C  //008C  //008C
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //049A  //0654
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12009E);	  //009E  //009E  //009E  //009E
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //04AC  //0666
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F1201AC);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F1200A6);	  //00A6  //00A6  //00A6  //00A6
	SetRegByI2C_Byte4(0x0F1205BA);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //04B4  //066E
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120292);	  //0292  //036A  //022A  //029A
	SetRegByI2C_Byte4(0x0F1205BA);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0638  //0862
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F1200D8);	  //00D8  //00D8  //00D8  //00D8
	SetRegByI2C_Byte4(0x0F1201A8);	  //01A8  //0278  //0140  //01A8
	SetRegByI2C_Byte4(0x0F1202C4);	  //02C4  //039C  //0292  //02CC
	SetRegByI2C_Byte4(0x0F1205B4);	  //05B4  //097C  //040A  //05BC
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //04E6  //06A0
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //054E  //0770
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //06A0  //0894
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0818  //0B84
	SetRegByI2C_Byte4(0x0F1201AA);	  //01AA  //0282  //0142  //01B2
	SetRegByI2C_Byte4(0x0F1201D6);	  //01D6  //02AE  //016E  //01DE
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //040C  //05C6
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0438  //05F2
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0550  //077A
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //057C  //07A6
	SetRegByI2C_Byte4(0x0F1201BB);	  //01BB  //0293  //014D  //01BD
	SetRegByI2C_Byte4(0x0F1201EF);	  //01EF  //02C7  //0182  //01F2
	SetRegByI2C_Byte4(0x0F1201F9);	  //01F9  //02D1  //018C  //01FC
	SetRegByI2C_Byte4(0x0F120203);	  //0203  //02DB  //0196  //0206
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0417  //05D1
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //044C  //0606
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0456  //0610
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0460  //061A
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //055B  //0785
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0590  //07BA
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //059A  //07C4
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //05A4  //07CE
	SetRegByI2C_Byte4(0x0F1201CC);	  //01CC  //02A4  //0158  //01C8
	SetRegByI2C_Byte4(0x0F1201EF);	  //01EF  //02C7  //0182  //01F2
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0422  //05DC
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //044C  //0606
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0566  //0790
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0590  //07BA
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12000D);	  //000D  //000D  //000D  //000D
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12000D);	  //000D  //000D  //000D  //000D
	SetRegByI2C_Byte4(0x0F1201AE);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F1201B6);	  //01B6  //028E  //014E  //01BE
	SetRegByI2C_Byte4(0x0F1205BA);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F1205C6);	  //05C6  //0996  //0418  //05D2
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0554  //077E
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //055C  //0786
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //082A  //0B9E
	SetRegByI2C_Byte4(0x0F1200D4);	  //00D4  //00D4  //00D4  //00D4
	SetRegByI2C_Byte4(0x0F1201AC);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F1202C0);	  //02C0  //0398  //028E  //02C8
	SetRegByI2C_Byte4(0x0F1205B8);	  //05B8  //0988  //040E  //05C8
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //04E2  //069C
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //069C  //0890
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //081C  //0B90
	SetRegByI2C_Byte4(0x0F1201AE);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F1205C9);	  //05C9  //0A7C  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0554  //077E
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0830  //0BA4
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000

	//HS_avg
	SetRegByI2C_Byte4(0x002A17DC);	// High speed Normal/Dig-subsampling         
	SetRegByI2C_Byte4(0x0F123CE0);	// senHal_ContPtrs_senModesDataArr         
	SetRegByI2C_Byte4(0x0F127000);	// senHal_ContPtrs_senModesDataArr   

	//1.15fps@92MHz,HS,Normal //2.15fps@92MHz,LS,Normal 
	//3.15fps@92MHz,HS,avg    //4.15fps@92MHz,LS,avg   

	//1.                                                                     
	SetRegByI2C_Byte4(0x002A3CE0);    //1.    //2.    //3.    //4.  
	SetRegByI2C_Byte4(0x0F120003);    //0003  //0003  //0003  //0003
	SetRegByI2C_Byte4(0x0F12081E);	  //05BA  //098A  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F120414);	  //05BC  //098C  //0414  //05CE
	SetRegByI2C_Byte4(0x0F12040F);	  //0001  //0001  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120820);	  //05BC  //098C  //0820  //0B94
	SetRegByI2C_Byte4(0x0F120014);	  //0014  //0014  //0014  //0014
	SetRegByI2C_Byte4(0x0F12040F);	  //05BC  //098C  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120422);	  //0014  //0014  //0422  //05DC
	SetRegByI2C_Byte4(0x0F120820);	  //05BC  //098C  //0820  //0B94
	SetRegByI2C_Byte4(0x0F120146);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F1201D0);	  //0238  //0310  //01D0  //0240
	SetRegByI2C_Byte4(0x0F120554);	  //01AE  //0286  //0554  //077E
	SetRegByI2C_Byte4(0x0F1205DE);	  //0238  //0310  //05DE  //0808
	SetRegByI2C_Byte4(0x0F1201D0);	  //0238  //0310  //01D0  //0240
	SetRegByI2C_Byte4(0x0F120410);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F1205DE);	  //0000  //0000  //05DE  //0808
	SetRegByI2C_Byte4(0x0F12081E);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F120144);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F120414);	  //0000  //0000  //0414  //05CE
	SetRegByI2C_Byte4(0x0F120552);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F120144);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F1201D8);	  //0240  //0318  //01D8  //0248
	SetRegByI2C_Byte4(0x0F120552);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F1205E6);	  //0000  //0000  //05E6  //0810
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12008C);	  //008C  //008C  //008C  //008C
	SetRegByI2C_Byte4(0x0F12040F);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F12049A);	  //0000  //0000  //049A  //0654
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12009E);	  //009E  //009E  //009E  //009E
	SetRegByI2C_Byte4(0x0F12040F);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F1204AC);	  //0000  //0000  //04AC  //0666
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F120144);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F12040F);	  //0000  //0000  //040F  //05C9
	SetRegByI2C_Byte4(0x0F120552);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F1200A6);	  //00A6  //00A6  //00A6  //00A6
	SetRegByI2C_Byte4(0x0F120410);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F1204B4);	  //0000  //0000  //04B4  //066E
	SetRegByI2C_Byte4(0x0F12081E);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F12022A);	  //0292  //036A  //022A  //029A
	SetRegByI2C_Byte4(0x0F120410);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120638);	  //0000  //0000  //0638  //0862
	SetRegByI2C_Byte4(0x0F12081E);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F1200D8);	  //00D8  //00D8  //00D8  //00D8
	SetRegByI2C_Byte4(0x0F120140);	  //01A8  //0278  //0140  //01A8
	SetRegByI2C_Byte4(0x0F120292);	  //02C4  //039C  //0292  //02CC
	SetRegByI2C_Byte4(0x0F12040A);	  //05B4  //097C  //040A  //05BC
	SetRegByI2C_Byte4(0x0F1204E6);	  //0000  //0000  //04E6  //06A0
	SetRegByI2C_Byte4(0x0F12054E);	  //0000  //0000  //054E  //0770
	SetRegByI2C_Byte4(0x0F1206A0);	  //0000  //0000  //06A0  //0894
	SetRegByI2C_Byte4(0x0F120818);	  //0000  //0000  //0818  //0B84
	SetRegByI2C_Byte4(0x0F120142);	  //01AA  //0282  //0142  //01B2
	SetRegByI2C_Byte4(0x0F12016E);	  //01D6  //02AE  //016E  //01DE
	SetRegByI2C_Byte4(0x0F12040C);	  //0000  //0000  //040C  //05C6
	SetRegByI2C_Byte4(0x0F120438);	  //0000  //0000  //0438  //05F2
	SetRegByI2C_Byte4(0x0F120550);	  //0000  //0000  //0550  //077A
	SetRegByI2C_Byte4(0x0F12057C);	  //0000  //0000  //057C  //07A6
	SetRegByI2C_Byte4(0x0F12014D);	  //01BB  //0293  //014D  //01BD
	SetRegByI2C_Byte4(0x0F120182);	  //01EF  //02C7  //0182  //01F2
	SetRegByI2C_Byte4(0x0F12018C);	  //01F9  //02D1  //018C  //01FC
	SetRegByI2C_Byte4(0x0F120196);	  //0203  //02DB  //0196  //0206
	SetRegByI2C_Byte4(0x0F120417);	  //0000  //0000  //0417  //05D1
	SetRegByI2C_Byte4(0x0F12044C);	  //0000  //0000  //044C  //0606
	SetRegByI2C_Byte4(0x0F120456);	  //0000  //0000  //0456  //0610
	SetRegByI2C_Byte4(0x0F120460);	  //0000  //0000  //0460  //061A
	SetRegByI2C_Byte4(0x0F12055B);	  //0000  //0000  //055B  //0785
	SetRegByI2C_Byte4(0x0F120590);	  //0000  //0000  //0590  //07BA
	SetRegByI2C_Byte4(0x0F12059A);	  //0000  //0000  //059A  //07C4
	SetRegByI2C_Byte4(0x0F1205A4);	  //0000  //0000  //05A4  //07CE
	SetRegByI2C_Byte4(0x0F120158);	  //01CC  //02A4  //0158  //01C8
	SetRegByI2C_Byte4(0x0F120182);	  //01EF  //02C7  //0182  //01F2
	SetRegByI2C_Byte4(0x0F120422);	  //0000  //0000  //0422  //05DC
	SetRegByI2C_Byte4(0x0F12044C);	  //0000  //0000  //044C  //0606
	SetRegByI2C_Byte4(0x0F120566);	  //0000  //0000  //0566  //0790
	SetRegByI2C_Byte4(0x0F120590);	  //0000  //0000  //0590  //07BA
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12000D);	  //000D  //000D  //000D  //000D
	SetRegByI2C_Byte4(0x0F120001);	  //0001  //0001  //0001  //0001
	SetRegByI2C_Byte4(0x0F12000D);	  //000D  //000D  //000D  //000D
	SetRegByI2C_Byte4(0x0F120146);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F12014E);	  //01B6  //028E  //014E  //01BE
	SetRegByI2C_Byte4(0x0F120410);	  //05BA  //098A  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120418);	  //05C6  //0996  //0418  //05D2
	SetRegByI2C_Byte4(0x0F120554);	  //0000  //0000  //0554  //077E
	SetRegByI2C_Byte4(0x0F12055C);	  //0000  //0000  //055C  //0786
	SetRegByI2C_Byte4(0x0F12081E);	  //0000  //0000  //081E  //0B92
	SetRegByI2C_Byte4(0x0F12082A);	  //0000  //0000  //082A  //0B9E
	SetRegByI2C_Byte4(0x0F1200D4);	  //00D4  //00D4  //00D4  //00D4
	SetRegByI2C_Byte4(0x0F120144);	  //01AC  //0284  //0144  //01B4
	SetRegByI2C_Byte4(0x0F12028E);	  //02C0  //0398  //028E  //02C8
	SetRegByI2C_Byte4(0x0F12040E);	  //05B8  //0988  //040E  //05C8
	SetRegByI2C_Byte4(0x0F1204E2);	  //0000  //0000  //04E2  //069C
	SetRegByI2C_Byte4(0x0F120552);	  //0000  //0000  //0552  //077C
	SetRegByI2C_Byte4(0x0F12069C);	  //0000  //0000  //069C  //0890
	SetRegByI2C_Byte4(0x0F12081C);	  //0000  //0000  //081C  //0B90
	SetRegByI2C_Byte4(0x0F120146);	  //01AE  //0286  //0146  //01B6
	SetRegByI2C_Byte4(0x0F120410);	  //05C9  //0A7C  //0410  //05CA
	SetRegByI2C_Byte4(0x0F120554);	  //0000  //0000  //0554  //077E
	SetRegByI2C_Byte4(0x0F120830);	  //0000  //0000  //0830  //0BA4
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000
	SetRegByI2C_Byte4(0x0F120000);	  //0000  //0000  //0000  //0000

	Delay(1000);	// p100

	//Current(00:2mA,01:4mA,10:6mA,11:8mA)
	SetRegByI2C_Byte4(0x0028D000);
	SetRegByI2C_Byte4(0x002A1082);	
	SetRegByI2C_Byte4(0x0F120155);	//FFFF	//D0_D4_cs12 [11:0]
	SetRegByI2C_Byte4(0x0F120155);	//FFFF	//D0_D4_cs12 [11:0]
	SetRegByI2C_Byte4(0x002A1088);	
	SetRegByI2C_Byte4(0x0F120555);	//05CF	//0555 //Sda_cd10	Scl_cd10	PCLK_cd10	Reserved	Vsync_cd10	Hsync_cd10

	Delay(1000);	// p100

	// End Analog script

	//////////////////////////////////////////////////////////////////
	// Start Tuning param for EVT1
	//////////////////////////////////////////////////////////////////

	/////////////////////// AF Setting Start
	// AF Interface Settings
	SetRegByI2C_Byte4(0x00287000);
	SetRegByI2C_Byte4(0x002A023E);	
	SetRegByI2C_Byte4(0x0F120003);	// AFModeType - 0:NONE, 2:VCM_PWM, 3:VCM_I2C
	SetRegByI2C_Byte4(0x002A023C);	
	SetRegByI2C_Byte4(0x0F120000);	// No Led Gpio
	SetRegByI2C_Byte4(0x002A0240);	
	SetRegByI2C_Byte4(0x0F120000);	// No PWM
	SetRegByI2C_Byte4(0x002A0242);	
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A0244);	
	SetRegByI2C_Byte4(0x0F120031);	// No GPIO Port,	31	// Use GPIO3 for Enable Port
	SetRegByI2C_Byte4(0x002A0246);	
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A024C);	
	SetRegByI2C_Byte4(0x0F12200C);	// Use GPIO1 for SCL, GPIO2 for SDA
	SetRegByI2C_Byte4(0x002A024E);	
	SetRegByI2C_Byte4(0x0F120320);	//0C0 //0190	//0320	// MI2C Speed : 400KHz

	// AF Window Settings
	SetRegByI2C_Byte4(0x002A02C6);
	SetRegByI2C_Byte4(0x0F120100);
	SetRegByI2C_Byte4(0x002A02C8);	
	SetRegByI2C_Byte4(0x0F1200E3);
	SetRegByI2C_Byte4(0x002A02CA);	
	SetRegByI2C_Byte4(0x0F120200);
	SetRegByI2C_Byte4(0x002A02CC);	
	SetRegByI2C_Byte4(0x0F120238);
	SetRegByI2C_Byte4(0x002A02CE);	
	SetRegByI2C_Byte4(0x0F12018C);
	SetRegByI2C_Byte4(0x002A02D0);	
	SetRegByI2C_Byte4(0x0F120166);
	SetRegByI2C_Byte4(0x002A02D2);	
	SetRegByI2C_Byte4(0x0F1200E6);
	SetRegByI2C_Byte4(0x002A02D4);	
	SetRegByI2C_Byte4(0x0F120132);
	SetRegByI2C_Byte4(0x002A02D6);	
	SetRegByI2C_Byte4(0x0F120001);

	// AF Setot Settings
	SetRegByI2C_Byte4(0x002A06BE);	
	SetRegByI2C_Byte4(0x0F1200FF);

	// AF Scene Settings
	SetRegByI2C_Byte4(0x002A15DA);	
	SetRegByI2C_Byte4(0x0F120003);

	// AF Fine Search Settings
	SetRegByI2C_Byte4(0x002A1550);	
	SetRegByI2C_Byte4(0x0F121002);
	SetRegByI2C_Byte4(0x002A155A);	
	SetRegByI2C_Byte4(0x0F120004);
	SetRegByI2C_Byte4(0x002A14E8);	
	SetRegByI2C_Byte4(0x0F120302);


	// AF Lens Position Table Settings
	SetRegByI2C_Byte4(0x002A14F0);	
	SetRegByI2C_Byte4(0x0F120011);	// 18 Steps	
	SetRegByI2C_Byte4(0x0f120036);	// af_pos_usTable
	SetRegByI2C_Byte4(0x0F12003D);	
	SetRegByI2C_Byte4(0x0F120044);	
	SetRegByI2C_Byte4(0x0F12004B);
	SetRegByI2C_Byte4(0x0F120052);	
	SetRegByI2C_Byte4(0x0F120059);
	SetRegByI2C_Byte4(0x0F120060);
	SetRegByI2C_Byte4(0x0F120067);	
	SetRegByI2C_Byte4(0x0F12006E);
	SetRegByI2C_Byte4(0x0F120075);
	SetRegByI2C_Byte4(0x0F12007C);
	SetRegByI2C_Byte4(0x0F120083);
	SetRegByI2C_Byte4(0x0F12008A);
	SetRegByI2C_Byte4(0x0F120091);
	SetRegByI2C_Byte4(0x0F120098);
	SetRegByI2C_Byte4(0x0F12009F);
	SetRegByI2C_Byte4(0x0F1200A6);
	SetRegByI2C_Byte4(0x0F1200AD);

	// AF Macro Position Setting
	SetRegByI2C_Byte4(0x002A14E2);	
	SetRegByI2C_Byte4(0x0F121104);

	/////////////////////// AF Setting End

	/////////////////////////////////////////Jpeg/////////////
	SetRegByI2C_Byte4(0x002A1690);
	SetRegByI2C_Byte4(0x0F12018E);	//jpeg_BrcMaxQuality
	SetRegByI2C_Byte4(0x002A16D6);
	SetRegByI2C_Byte4(0x0F120001);	//jpeg_MinQtblValue
	SetRegByI2C_Byte4(0x002A04C0);
	SetRegByI2C_Byte4(0x0F12005D);	//005F //005D //4EA_REG_TC_BRC_usCaptureQuality(4~99_dec)

	///////////////////////////////////////////
	//clk Settings
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_InClockLSBs);	//input=24MHz
	SetRegByI2C_Reg2Data2(0x0F12, 0x5DC0);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_InClockMSBs);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_UseNPviClocks);	//0 PVI configurations
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_UseNMipiClocks);	// 1 MIPI configurations
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_NumberOfMipiLanes);	// Num of lane MIPI 
	SetRegByI2C_Reg2Data2(0x0F12, uNumOfMipiLanes);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_OpClk4KHz_0);	// 1st system CLK 92MHz for parallel
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA4Khz_92Mhz);	// 2CEC
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_MinOutRate4KHz_0); 	// Pclk : 92Mhz
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA_PCLK_MIN);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_MaxOutRate4KHz_0);
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA_PCLK_MAX);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_IPRM_InitParamsUpdated);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	Delay(1000);	// p100

	//////////////////////////////////////////////AE Setting
	SetRegByI2C_Byte4(0x002A13C8);                                                                        
	SetRegByI2C_Byte4(0x0F120030);	//3C	//002D	//003C //003A //0030	//003A	//0038	//003C 0035		TVAR_ae_BrAve	  AE target	//
	SetRegByI2C_Byte4(0x002A13CE);
	SetRegByI2C_Byte4(0x0F12000F); //0011  ae_StatMode
	SetRegByI2C_Byte4(0x002A0590);
	SetRegByI2C_Byte4(0x0F123520);	//lt_uMaxExp1 (x4 8000/ 80ms)
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A0594);
	SetRegByI2C_Byte4(0x0F12C350);  
	SetRegByI2C_Byte4(0x0F120000);		//lt_uMaxExp2 (x4 25000/ 250ms)
	SetRegByI2C_Byte4(0x002A0598);
	SetRegByI2C_Byte4(0x0F123520);	
	SetRegByI2C_Byte4(0x0F120000);		//lt_uCapMaxExp1 (x4 8000/ 80ms)
	SetRegByI2C_Byte4(0x002A059C);
	SetRegByI2C_Byte4(0x0F12C350); 	//C350	//86A0	
	SetRegByI2C_Byte4(0x0F120000);		//lt_uCapMaxExp2 (x4 25000/ 250ms)
	SetRegByI2C_Byte4(0x002A05A0);
	SetRegByI2C_Byte4(0x0F120470);	//(1/12) //0350 (1/8) //0200	//lt_uMaxAnGain1
	SetRegByI2C_Byte4(0x002A05A2);
	SetRegByI2C_Byte4(0x0F121000);	//lt_uMaxAnGain2
	SetRegByI2C_Byte4(0x002A05A4);
	SetRegByI2C_Byte4(0x0F120100);	
	SetRegByI2C_Byte4(0x002A05A6);
	SetRegByI2C_Byte4(0x0F121000);	//lt_uMaxTotGain (Limit Gain)
	    	
	SetRegByI2C_Byte4(0x002A0574);
	SetRegByI2C_Byte4(0x0F120111);	//lt_uLimitHigh
	SetRegByI2C_Byte4(0x002A0576);
	SetRegByI2C_Byte4(0x0F1200EF);	//lt_uLimitLow

	///////////////////////////////////////////
	//PREVIEW CONFIGURATION 0 (FullHD, YUV, 20fps)
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_0TC_PCFG_usWidth);
	SetRegByI2C_Reg2Data2(0x0F12, CamImgWidth);	//1920    					
	SetRegByI2C_Reg2Data2(0x0F12, CamImgHeight);	//1080
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_0TC_PCFG_Format);
	SetRegByI2C_Reg2Data2(0x0F12, uPreviewFormatValue);
	SetRegByI2C_Byte4(0x002A02F8); 		//PLL config
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A02E8);		//PCLK max
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA_PCLK_MAX);
	SetRegByI2C_Byte4(0x002A02EA);		//PCLK min
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA_PCLK_MIN);
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_0TC_PCFG_PVIMask);	// KJ_090802 : Non-continuous clock
	SetRegByI2C_Reg2Data2(0x0F12, 0x0012|uPCFGPVIMaskValue);  // [4]UY0VY1	//0002
	SetRegByI2C_Byte4(0x002A02FC);		// 1b: FR (bin) 2b: Quality (no-bin)
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A02FA);
	SetRegByI2C_Byte4(0x0F120002);
	SetRegByI2C_Byte4(0x002A02FE);	//max frame time 
	SetRegByI2C_Byte4(0x0F120535);// 7.5fps	
	SetRegByI2C_Byte4(0x002A0300);
	SetRegByI2C_Byte4(0x0F120000);

	Delay(1000);	// p100

	//002A	17A0
	//0F12	0000												// [0]:dig [1]:avg
	//002A 	17A2				// 1/2 sub-sampling
	//0F12 	0002
	SetRegByI2C_Byte4(0x002A0540);		// use high speed analog
	SetRegByI2C_Byte4(0x0F120001);
	SetRegByI2C_Byte4(0x002A053A);
	SetRegByI2C_Byte4(0x0F120001);
	//002A	17B2					// 17B2 	
	//0F12	0549 					//
	//002A	17B6 					// 17B6
	//0F12	0549 					//
	//002A	17BA					// 17BA 	//
	//0F12	005B 					//

	//For C100 -  jpeg output data  type control 0028	 D000 002A	B032  0F12	 002A
	// JPEG data type (RAW8 type)

	SetRegByI2C_Byte4(0x00287000);

	///////////////////////////////////////////////
	// Capture Configuration	0	(2592x1944,  MJPEG, 15fps)
	SetRegByI2C_Byte4(0x002A03D6);
	SetRegByI2C_Byte4(0x0F120A20);        					//2592
	SetRegByI2C_Byte4(0x002A03D8);
	SetRegByI2C_Byte4(0x0F120798);        					//1944
	SetRegByI2C_Byte4(0x002A03DA);
	SetRegByI2C_Byte4(0x0F120009);					        //YUV
	SetRegByI2C_Byte4(0x002A03EC); 		//PLL config
	SetRegByI2C_Byte4(0x0F120000);
	SetRegByI2C_Byte4(0x002A03DC);		//PCLK max
	SetRegByI2C_Byte4(0x0F125AD2);
	SetRegByI2C_Byte4(0x002A03DE);		//PCLK min
	SetRegByI2C_Byte4(0x0F1258DE);
	SetRegByI2C_Byte4(0x002A03E4);
	SetRegByI2C_Byte4(0x0F120042);
	SetRegByI2C_Byte4(0x002A03F0);		// 1b: FR (bin) 2b: Quality (no-bin)
	SetRegByI2C_Byte4(0x0F120002);
	SetRegByI2C_Byte4(0x002A03EE);
	SetRegByI2C_Byte4(0x0F120002);
	SetRegByI2C_Byte4(0x002A03F2);	//max frame time : 15fps 029a
	SetRegByI2C_Byte4(0x0F120535); // 7.5 fps
	SetRegByI2C_Byte4(0x002A03F4);
	SetRegByI2C_Byte4(0x0F120000);

	////////////////////////////////////////////////////////
	//PREVIEW
	SetRegByI2C_Byte4(0x002A02A4);
	SetRegByI2C_Byte4(0x0F120000);

	SetRegByI2C_Byte4(0x002A02A8);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0290);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A02A6);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0280);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0282);
	SetRegByI2C_Byte4(0x0F120001);

	//////////////////////////////////////////////////////////////
#if 1
	// cropping inside CAM
	SetRegByI2C_Byte4(0x002A0292);
	SetRegByI2C_Reg2Data2(0x0F12, uCropSizeWidth); 	//input width
	SetRegByI2C_Reg2Data2(0x0F12, uCropSizeHeight); 	//input height
	SetRegByI2C_Reg2Data2(0x0F12, uInOffsetW);	//input w-offset	// 336
	SetRegByI2C_Reg2Data2(0x0F12, uInOffsetH);	//input h-offset		// 432

	SetRegByI2C_Byte4(0x002A04DA);	
	SetRegByI2C_Reg2Data2(0x0F12, uCropSizeWidth); 	//input width
	SetRegByI2C_Reg2Data2(0x0F12, uCropSizeHeight); 	//input height
	//0F12	0150	//w-offset
	//0F12	01B0	//h-offset

	SetRegByI2C_Byte4(0x002A02A2);	//4EA_REG_TC_GP_InputsChangeRequest
	SetRegByI2C_Byte4(0x0F120001);
	SetRegByI2C_Byte4(0x002A0290);	//4EA_REG_TC_GP_NewConfigSync
	SetRegByI2C_Byte4(0x0F120001);	

	Delay(2000);	// p200

	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_0TC_PCFG_usMaxFrTimeMsecMult10);	//max frame time 
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EA_FrTime_MAX);	//30fps	
#else
	// No cropping(5M Full Size)
	SetRegByI2C_Byte4(0x002A02A2);	//4EA_REG_TC_GP_InputsChangeRequest
	SetRegByI2C_Byte4(0x0F120001);
	SetRegByI2C_Byte4(0x002A0290);	//4EA_REG_TC_GP_NewConfigSync
	SetRegByI2C_Byte4(0x0F120001);	

	Delay(2000);	// p200
	
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_0TC_PCFG_usMaxFrTimeMsecMult10);	//max frame time 
	SetRegByI2C_Reg2Data2(0x0F12, S5K4EAFrTime_7P5fps);	//30fps	
#endif
	////////////////////////////////////////////////////////
	//PREVIEW
	SetRegByI2C_Byte4(0x002A02A4);
	SetRegByI2C_Byte4(0x0F120000);

	SetRegByI2C_Byte4(0x002A02A8);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0290);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A02A6);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0280);
	SetRegByI2C_Byte4(0x0F120001);

	SetRegByI2C_Byte4(0x002A0282);
	SetRegByI2C_Byte4(0x0F120001);
	//////////////////////////////////////////////////////////////

	// AF CMD
	SetRegByI2C_Byte4(0x002A02BE);	//#4EA_REG_TC_AF	
	SetRegByI2C_Byte4(0x0F120003);	//4EA_REG_TC_AF_AfCmd

	Delay(3000);	// p300

	SetRegByI2C_Byte4(0x002A02BE);	//#4EA_REG_TC_AF	
	SetRegByI2C_Byte4(0x0F120005);	//5:single AF, 6:continus AF

	Disp("[4EA]Init End.\n"); 
}		

static void S5K4EA_Sleep(void)
{
#if 1
	Delay(1000);	// p1000
	
	// Disable Preview(LP-11)
	SetRegByI2C_Reg2Data2(0x0028, 0x7000);			
	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnablePreview);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnablePreviewChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
#else
	// Enter ULPS Codes(LP-00)
	SetRegByI2C_Byte4(0x0028D000);
	SetRegByI2C_Byte4(0x002A107E);
	SetRegByI2C_Byte4(0x0F120001);  
#endif
	Delay(1000);	// p1000

	Disp("[4EA]Sleep\n");
}

static void S5K4EA_WakeUp(void)
{
	Delay(1000);	// p1000
#if 1
	Disp("[4EA]Continuous Clock\n");
	SetRegByI2C_Reg2Data2(0x0028, 0x7000);			
	SetRegByI2C_Byte4(0x002A02F0);
	SetRegByI2C_Byte4(0x0F120052);       // [4]UY0VY1	// Continuous clock

	SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_PrevConfigChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
#else
	Disp("[4EA]Non-continuous Clock\n");
#endif

#if 1
	#if 1
		// Enable Preview
		SetRegByI2C_Reg2Data2(0x0028, 0x7000);		
		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnablePreview);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnablePreviewChanged);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	#else
		SetRegByI2C_Reg2Data2(0x0028, 0xD000);
		SetRegByI2C_Reg2Data2(0x002A, 0xB032);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x0030);	// MIPI Packet Header : 0x30(User-Defined Byte)

		SetRegByI2C_Reg2Data2(0x0028, 0x7000);
		SetRegByI2C_Reg2Data2(0x002A, 0x03E6);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x1040);
		SetRegByI2C_Reg2Data2(0x002A, 0x0414);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x1040);
		SetRegByI2C_Reg2Data2(0x002A, 0x0442);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x1040);
		SetRegByI2C_Reg2Data2(0x002A, 0x0470);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x1040);
		SetRegByI2C_Reg2Data2(0x002A, 0x049E);	
		SetRegByI2C_Reg2Data2(0x0F12, 0x1040);


		Disp("[4EA]Enable Capture\n");		
		// Enable Capture configuration
		SetRegByI2C_Reg2Data2(0x0028, 0x7000);		
		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_ActiveCapConfig);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_NewConfigSync);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_CapConfigChanged);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnableCapture);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

		SetRegByI2C_Reg2Data2(0x002A, S5K4EA_REG_TC_GP_EnableCaptureChanged);
		SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	#endif
#else
	// Exit ULPS Codes
	SetRegByI2C_Byte4(0x0028D000);
	SetRegByI2C_Byte4(0x002A107E);
	SetRegByI2C_Byte4(0x0F120000);  
#endif
	Disp("[4EA]Wake-Up\n");
}

static void S5K6AA_Init(IMG_FMT eSrcFmt, u32 CamImgWidth, u32 CamImgHeight)
{
	if(eSrcFmt == CBYCRY)
	{
		Disp("[6AA]CBYCRY : 640*480\n");
		Disp("[6AA]Speed : Under 450 Mbps\n"); 
		Disp("[6AA]FPS : Under 30 fps\n"); 
		Assert(CamImgWidth == 640);
		Assert(CamImgHeight == 480);
		//==================================================

		//****************************************/
		SetRegByI2C_Byte4(0xFCFCD000);
		//****************************************/
		SetRegByI2C_Byte4(0x00100001);	// Reset
		SetRegByI2C_Byte4(0x10300000);	// Clear host interrupt so main will wait
		SetRegByI2C_Byte4(0x00140001);	// ARM go
		Delay(1000);	//p100	// Wait100mSec
		// Start T&P part
		SetRegByI2C_Byte4(0x00287000);
		SetRegByI2C_Byte4(0x002A1D60);
		SetRegByI2C_Byte4(0x0F12B570);
		SetRegByI2C_Byte4(0x0F124928);
		SetRegByI2C_Byte4(0x0F124828);
		SetRegByI2C_Byte4(0x0F122205);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F922);
		SetRegByI2C_Byte4(0x0F124927);
		SetRegByI2C_Byte4(0x0F122002);
		SetRegByI2C_Byte4(0x0F1283C8);
		SetRegByI2C_Byte4(0x0F122001);
		SetRegByI2C_Byte4(0x0F123120);
		SetRegByI2C_Byte4(0x0F128088);
		SetRegByI2C_Byte4(0x0F124925);
		SetRegByI2C_Byte4(0x0F124826);
		SetRegByI2C_Byte4(0x0F122204);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F917);
		SetRegByI2C_Byte4(0x0F124925);
		SetRegByI2C_Byte4(0x0F124825);
		SetRegByI2C_Byte4(0x0F122206);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F912);
		SetRegByI2C_Byte4(0x0F124924);
		SetRegByI2C_Byte4(0x0F124825);
		SetRegByI2C_Byte4(0x0F122207);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F90D);
		SetRegByI2C_Byte4(0x0F124924);
		SetRegByI2C_Byte4(0x0F124824);
		SetRegByI2C_Byte4(0x0F122208);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F908);
		SetRegByI2C_Byte4(0x0F124923);
		SetRegByI2C_Byte4(0x0F124824);
		SetRegByI2C_Byte4(0x0F122209);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F903);
		SetRegByI2C_Byte4(0x0F124923);
		SetRegByI2C_Byte4(0x0F124823);
		SetRegByI2C_Byte4(0x0F1260C1);
		SetRegByI2C_Byte4(0x0F126882);
		SetRegByI2C_Byte4(0x0F121A51);
		SetRegByI2C_Byte4(0x0F128201);
		SetRegByI2C_Byte4(0x0F124C22);
		SetRegByI2C_Byte4(0x0F122607);
		SetRegByI2C_Byte4(0x0F126821);
		SetRegByI2C_Byte4(0x0F120736);
		SetRegByI2C_Byte4(0x0F1242B1);
		SetRegByI2C_Byte4(0x0F12DA05);
		SetRegByI2C_Byte4(0x0F124820);
		SetRegByI2C_Byte4(0x0F1222D8);
		SetRegByI2C_Byte4(0x0F121C05);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8FA);
		SetRegByI2C_Byte4(0x0F126025);
		SetRegByI2C_Byte4(0x0F1268A1);
		SetRegByI2C_Byte4(0x0F1242B1);
		SetRegByI2C_Byte4(0x0F12DA07);
		SetRegByI2C_Byte4(0x0F12481B);
		SetRegByI2C_Byte4(0x0F122224);
		SetRegByI2C_Byte4(0x0F123824);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8F1);
		SetRegByI2C_Byte4(0x0F124819);
		SetRegByI2C_Byte4(0x0F123824);
		SetRegByI2C_Byte4(0x0F1260A0);
		SetRegByI2C_Byte4(0x0F124D18);
		SetRegByI2C_Byte4(0x0F126D29);
		SetRegByI2C_Byte4(0x0F1242B1);
		SetRegByI2C_Byte4(0x0F12DA07);
		SetRegByI2C_Byte4(0x0F124815);
		SetRegByI2C_Byte4(0x0F12228F);
		SetRegByI2C_Byte4(0x0F1200D2);
		SetRegByI2C_Byte4(0x0F1230D8);
		SetRegByI2C_Byte4(0x0F121C04);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8E3);
		SetRegByI2C_Byte4(0x0F12652C);
		SetRegByI2C_Byte4(0x0F12BC70);
		SetRegByI2C_Byte4(0x0F12BC08);
		SetRegByI2C_Byte4(0x0F124718);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F121F53);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12127B);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120398);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F121E4D);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12890D);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F121E73);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1227A9);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F121E91);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1227C5);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F121EF7);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12285F);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F121EB3);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1228FF);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F12206C);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1204AC);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1206CC);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1223A4);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F120704);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12B510);
		SetRegByI2C_Byte4(0x0F121C04);
		SetRegByI2C_Byte4(0x0F12484D);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8BB);
		SetRegByI2C_Byte4(0x0F124A4D);
		SetRegByI2C_Byte4(0x0F124B4D);
		SetRegByI2C_Byte4(0x0F128811);
		SetRegByI2C_Byte4(0x0F12885B);
		SetRegByI2C_Byte4(0x0F128852);
		SetRegByI2C_Byte4(0x0F124359);
		SetRegByI2C_Byte4(0x0F121889);
		SetRegByI2C_Byte4(0x0F124288);
		SetRegByI2C_Byte4(0x0F12D800);
		SetRegByI2C_Byte4(0x0F121C08);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F12BC10);
		SetRegByI2C_Byte4(0x0F12BC08);
		SetRegByI2C_Byte4(0x0F124718);
		SetRegByI2C_Byte4(0x0F12B510);
		SetRegByI2C_Byte4(0x0F121C04);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8B1);
		SetRegByI2C_Byte4(0x0F124944);
		SetRegByI2C_Byte4(0x0F128989);
		SetRegByI2C_Byte4(0x0F124348);
		SetRegByI2C_Byte4(0x0F120200);
		SetRegByI2C_Byte4(0x0F120C00);
		SetRegByI2C_Byte4(0x0F122101);
		SetRegByI2C_Byte4(0x0F120349);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8B0);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F12E7ED);
		SetRegByI2C_Byte4(0x0F12B510);
		SetRegByI2C_Byte4(0x0F121C04);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8B2);
		SetRegByI2C_Byte4(0x0F126821);
		SetRegByI2C_Byte4(0x0F120409);
		SetRegByI2C_Byte4(0x0F120C09);
		SetRegByI2C_Byte4(0x0F121A40);
		SetRegByI2C_Byte4(0x0F12493A);
		SetRegByI2C_Byte4(0x0F126849);
		SetRegByI2C_Byte4(0x0F124281);
		SetRegByI2C_Byte4(0x0F12D800);
		SetRegByI2C_Byte4(0x0F121C08);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8AF);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F12E7DC);
		SetRegByI2C_Byte4(0x0F12B570);
		SetRegByI2C_Byte4(0x0F126801);
		SetRegByI2C_Byte4(0x0F12040D);
		SetRegByI2C_Byte4(0x0F120C2D);
		SetRegByI2C_Byte4(0x0F126844);
		SetRegByI2C_Byte4(0x0F124833);
		SetRegByI2C_Byte4(0x0F128981);
		SetRegByI2C_Byte4(0x0F121C28);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F893);
		SetRegByI2C_Byte4(0x0F128060);
		SetRegByI2C_Byte4(0x0F124932);
		SetRegByI2C_Byte4(0x0F1269C9);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8A6);
		SetRegByI2C_Byte4(0x0F121C01);
		SetRegByI2C_Byte4(0x0F1280A0);
		SetRegByI2C_Byte4(0x0F120228);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F8A9);
		SetRegByI2C_Byte4(0x0F120400);
		SetRegByI2C_Byte4(0x0F120C00);
		SetRegByI2C_Byte4(0x0F128020);
		SetRegByI2C_Byte4(0x0F12492D);
		SetRegByI2C_Byte4(0x0F122300);
		SetRegByI2C_Byte4(0x0F125EC9);
		SetRegByI2C_Byte4(0x0F124288);
		SetRegByI2C_Byte4(0x0F12DA02);
		SetRegByI2C_Byte4(0x0F1220FF);
		SetRegByI2C_Byte4(0x0F123001);
		SetRegByI2C_Byte4(0x0F128020);
		SetRegByI2C_Byte4(0x0F12BC70);
		SetRegByI2C_Byte4(0x0F12BC08);
		SetRegByI2C_Byte4(0x0F124718);
		SetRegByI2C_Byte4(0x0F12B570);
		SetRegByI2C_Byte4(0x0F121C04);
		SetRegByI2C_Byte4(0x0F124828);
		SetRegByI2C_Byte4(0x0F124926);
		SetRegByI2C_Byte4(0x0F127803);
		SetRegByI2C_Byte4(0x0F126A8A);
		SetRegByI2C_Byte4(0x0F122B00);
		SetRegByI2C_Byte4(0x0F12D100);
		SetRegByI2C_Byte4(0x0F126A0A);
		SetRegByI2C_Byte4(0x0F124D20);
		SetRegByI2C_Byte4(0x0F122B00);
		SetRegByI2C_Byte4(0x0F1268A8);
		SetRegByI2C_Byte4(0x0F12D100);
		SetRegByI2C_Byte4(0x0F126868);
		SetRegByI2C_Byte4(0x0F126823);
		SetRegByI2C_Byte4(0x0F128DC9);
		SetRegByI2C_Byte4(0x0F12434A);
		SetRegByI2C_Byte4(0x0F120A12);
		SetRegByI2C_Byte4(0x0F12429A);
		SetRegByI2C_Byte4(0x0F12D30D);
		SetRegByI2C_Byte4(0x0F124D20);
		SetRegByI2C_Byte4(0x0F1226FF);
		SetRegByI2C_Byte4(0x0F128828);
		SetRegByI2C_Byte4(0x0F123601);
		SetRegByI2C_Byte4(0x0F1243B0);
		SetRegByI2C_Byte4(0x0F128028);
		SetRegByI2C_Byte4(0x0F126820);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F884);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F128828);
		SetRegByI2C_Byte4(0x0F124330);
		SetRegByI2C_Byte4(0x0F128028);
		SetRegByI2C_Byte4(0x0F12E7DA);
		SetRegByI2C_Byte4(0x0F121C0A);
		SetRegByI2C_Byte4(0x0F124342);
		SetRegByI2C_Byte4(0x0F120A12);
		SetRegByI2C_Byte4(0x0F12429A);
		SetRegByI2C_Byte4(0x0F12D304);
		SetRegByI2C_Byte4(0x0F120218);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F871);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F12E7F4);
		SetRegByI2C_Byte4(0x0F126020);
		SetRegByI2C_Byte4(0x0F12E7F2);
		SetRegByI2C_Byte4(0x0F12B510);
		SetRegByI2C_Byte4(0x0F124913);
		SetRegByI2C_Byte4(0x0F128FC8);
		SetRegByI2C_Byte4(0x0F122800);
		SetRegByI2C_Byte4(0x0F12D007);
		SetRegByI2C_Byte4(0x0F122000);
		SetRegByI2C_Byte4(0x0F1287C8);
		SetRegByI2C_Byte4(0x0F128F88);
		SetRegByI2C_Byte4(0x0F124C11);
		SetRegByI2C_Byte4(0x0F122800);
		SetRegByI2C_Byte4(0x0F12D002);
		SetRegByI2C_Byte4(0x0F122008);
		SetRegByI2C_Byte4(0x0F128020);
		SetRegByI2C_Byte4(0x0F12E77E);
		SetRegByI2C_Byte4(0x0F12480D);
		SetRegByI2C_Byte4(0x0F123060);
		SetRegByI2C_Byte4(0x0F128900);
		SetRegByI2C_Byte4(0x0F122800);
		SetRegByI2C_Byte4(0x0F12D103);
		SetRegByI2C_Byte4(0x0F12480C);
		SetRegByI2C_Byte4(0x0F122101);
		SetRegByI2C_Byte4(0x0F12F000);
		SetRegByI2C_Byte4(0x0F12F864);
		SetRegByI2C_Byte4(0x0F122010);
		SetRegByI2C_Byte4(0x0F128020);
		SetRegByI2C_Byte4(0x0F12E7F2);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F12F4B0);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F122058);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F121554);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F120080);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12046C);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F120468);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F121100);
		SetRegByI2C_Byte4(0x0F12D000);
		SetRegByI2C_Byte4(0x0F1201B8);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F12044E);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F120450);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F129CE7);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12F004);
		SetRegByI2C_Byte4(0x0F12E51F);
		SetRegByI2C_Byte4(0x0F129FB8);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F1288DF);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F12275D);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F121ED3);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F1226F9);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F124027);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F129F03);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12F004);
		SetRegByI2C_Byte4(0x0F12E51F);
		SetRegByI2C_Byte4(0x0F12A144);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F12285F);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F124778);
		SetRegByI2C_Byte4(0x0F1246C0);
		SetRegByI2C_Byte4(0x0F12C000);
		SetRegByI2C_Byte4(0x0F12E59F);
		SetRegByI2C_Byte4(0x0F12FF1C);
		SetRegByI2C_Byte4(0x0F12E12F);
		SetRegByI2C_Byte4(0x0F122001);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F12E848);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F12E848);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F120500);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		// End T&P part

		// Start tuning part

		//	Write memory example:
		//	m70003000 10CE
		//	Write HW register example:
		//	1004 5678

		SetRegByI2C_Byte4(0xF4540001);

		SetRegByI2C_Byte4(0x002A0E3A);
		SetRegByI2C_Byte4(0x0F1202C2);

		// Analog Settings
		SetRegByI2C_Byte4(0x002A112A);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A1132);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A113E);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A115C);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A1164);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A1174);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A1178);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x002A077A);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x002A07A2);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x002A07B6);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120005);
		SetRegByI2C_Byte4(0x0F120005);

		//	param_start	TVAR_ash_GASAlpha
		SetRegByI2C_Byte4(0x002A0712);
		SetRegByI2C_Byte4(0x0F120176);	//TVAR_ash_GASAlpha[0]
		SetRegByI2C_Byte4(0x0F120145);	//TVAR_ash_GASAlpha[1]
		SetRegByI2C_Byte4(0x0F120147);	//TVAR_ash_GASAlpha[2]
		SetRegByI2C_Byte4(0x0F120111);	//TVAR_ash_GASAlpha[3]
		SetRegByI2C_Byte4(0x0F120145);	//TVAR_ash_GASAlpha[4]
		SetRegByI2C_Byte4(0x0F120122);	//TVAR_ash_GASAlpha[5]
		SetRegByI2C_Byte4(0x0F120122);	//TVAR_ash_GASAlpha[6]
		SetRegByI2C_Byte4(0x0F120103);	//TVAR_ash_GASAlpha[7]
		SetRegByI2C_Byte4(0x0F120112);	//TVAR_ash_GASAlpha[8]
		SetRegByI2C_Byte4(0x0F1200EE);	//TVAR_ash_GASAlpha[9]
		SetRegByI2C_Byte4(0x0F1200F2);	//TVAR_ash_GASAlpha[10]
		SetRegByI2C_Byte4(0x0F1200D7);	//TVAR_ash_GASAlpha[11]
		SetRegByI2C_Byte4(0x0F1200EF);	//TVAR_ash_GASAlpha[12]
		SetRegByI2C_Byte4(0x0F12010C);	//TVAR_ash_GASAlpha[13]
		SetRegByI2C_Byte4(0x0F12010F);	//TVAR_ash_GASAlpha[14]
		SetRegByI2C_Byte4(0x0F1200F8);	//TVAR_ash_GASAlpha[15]
		SetRegByI2C_Byte4(0x0F12011C);	//TVAR_ash_GASAlpha[16]
		SetRegByI2C_Byte4(0x0F12011F);	//TVAR_ash_GASAlpha[17]
		SetRegByI2C_Byte4(0x0F12011E);	//TVAR_ash_GASAlpha[18]
		SetRegByI2C_Byte4(0x0F120127);	//TVAR_ash_GASAlpha[19]
		SetRegByI2C_Byte4(0x0F1200F6);	//TVAR_ash_GASAlpha[20]
		SetRegByI2C_Byte4(0x0F1200F7);	//TVAR_ash_GASAlpha[21]
		SetRegByI2C_Byte4(0x0F1200F5);	//TVAR_ash_GASAlpha[22]
		SetRegByI2C_Byte4(0x0F120104);	//TVAR_ash_GASAlpha[23]
		SetRegByI2C_Byte4(0x0F1200E9);	//TVAR_ash_GASAlpha[24]
		SetRegByI2C_Byte4(0x0F1200F1);	//TVAR_ash_GASAlpha[25]
		SetRegByI2C_Byte4(0x0F1200EE);	//TVAR_ash_GASAlpha[26]
		SetRegByI2C_Byte4(0x0F1200FE);	//TVAR_ash_GASAlpha[27]
		//	param_end	TVAR_ash_GASAlpha

		//	param_start	TVAR_ash_GASOutdoorAlpha
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_GASOutdoorAlpha[0]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_GASOutdoorAlpha[1]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_GASOutdoorAlpha[2]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_GASOutdoorAlpha[3]
		//	param_end	TVAR_ash_GASOutdoorAlpha

		SetRegByI2C_Byte4(0x002A075A);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120280);
		SetRegByI2C_Byte4(0x0F120200);
		SetRegByI2C_Byte4(0x0F12000E);
		SetRegByI2C_Byte4(0x0F12000F);


		//	param_start	TVAR_ash_pGAS
		SetRegByI2C_Byte4(0x002A247C);
		SetRegByI2C_Byte4(0x0F12017E);	//TVAR_ash_pGAS[0]
		SetRegByI2C_Byte4(0x0F12012A);	//TVAR_ash_pGAS[1]
		SetRegByI2C_Byte4(0x0F1200F0);	//TVAR_ash_pGAS[2]
		SetRegByI2C_Byte4(0x0F1200CB);	//TVAR_ash_pGAS[3]
		SetRegByI2C_Byte4(0x0F1200B3);	//TVAR_ash_pGAS[4]
		SetRegByI2C_Byte4(0x0F1200A4);	//TVAR_ash_pGAS[5]
		SetRegByI2C_Byte4(0x0F12009D);	//TVAR_ash_pGAS[6]
		SetRegByI2C_Byte4(0x0F1200A1);	//TVAR_ash_pGAS[7]
		SetRegByI2C_Byte4(0x0F1200AD);	//TVAR_ash_pGAS[8]
		SetRegByI2C_Byte4(0x0F1200BF);	//TVAR_ash_pGAS[9]
		SetRegByI2C_Byte4(0x0F1200DE);	//TVAR_ash_pGAS[10]
		SetRegByI2C_Byte4(0x0F12010F);	//TVAR_ash_pGAS[11]
		SetRegByI2C_Byte4(0x0F12014C);	//TVAR_ash_pGAS[12]
		SetRegByI2C_Byte4(0x0F120139);	//TVAR_ash_pGAS[13]
		SetRegByI2C_Byte4(0x0F1200FA);	//TVAR_ash_pGAS[14]
		SetRegByI2C_Byte4(0x0F1200C4);	//TVAR_ash_pGAS[15]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[16]
		SetRegByI2C_Byte4(0x0F12008A);	//TVAR_ash_pGAS[17]
		SetRegByI2C_Byte4(0x0F12007A);	//TVAR_ash_pGAS[18]
		SetRegByI2C_Byte4(0x0F120071);	//TVAR_ash_pGAS[19]
		SetRegByI2C_Byte4(0x0F120074);	//TVAR_ash_pGAS[20]
		SetRegByI2C_Byte4(0x0F120082);	//TVAR_ash_pGAS[21]
		SetRegByI2C_Byte4(0x0F120096);	//TVAR_ash_pGAS[22]
		SetRegByI2C_Byte4(0x0F1200B4);	//TVAR_ash_pGAS[23]
		SetRegByI2C_Byte4(0x0F1200E6);	//TVAR_ash_pGAS[24]
		SetRegByI2C_Byte4(0x0F12011B);	//TVAR_ash_pGAS[25]
		SetRegByI2C_Byte4(0x0F12010F);	//TVAR_ash_pGAS[26]
		SetRegByI2C_Byte4(0x0F1200D1);	//TVAR_ash_pGAS[27]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[28]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[29]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[30]
		SetRegByI2C_Byte4(0x0F12004E);	//TVAR_ash_pGAS[31]
		SetRegByI2C_Byte4(0x0F120049);	//TVAR_ash_pGAS[32]
		SetRegByI2C_Byte4(0x0F120046);	//TVAR_ash_pGAS[33]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[34]
		SetRegByI2C_Byte4(0x0F12006B);	//TVAR_ash_pGAS[35]
		SetRegByI2C_Byte4(0x0F12008B);	//TVAR_ash_pGAS[36]
		SetRegByI2C_Byte4(0x0F1200BA);	//TVAR_ash_pGAS[37]
		SetRegByI2C_Byte4(0x0F1200F1);	//TVAR_ash_pGAS[38]
		SetRegByI2C_Byte4(0x0F1200F0);	//TVAR_ash_pGAS[39]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[40]
		SetRegByI2C_Byte4(0x0F120088);	//TVAR_ash_pGAS[41]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[42]
		SetRegByI2C_Byte4(0x0F120042);	//TVAR_ash_pGAS[43]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_ash_pGAS[44]
		SetRegByI2C_Byte4(0x0F120021);	//TVAR_ash_pGAS[45]
		SetRegByI2C_Byte4(0x0F120024);	//TVAR_ash_pGAS[46]
		SetRegByI2C_Byte4(0x0F120030);	//TVAR_ash_pGAS[47]
		SetRegByI2C_Byte4(0x0F12004C);	//TVAR_ash_pGAS[48]
		SetRegByI2C_Byte4(0x0F12006E);	//TVAR_ash_pGAS[49]
		SetRegByI2C_Byte4(0x0F1200A1);	//TVAR_ash_pGAS[50]
		SetRegByI2C_Byte4(0x0F1200CF);	//TVAR_ash_pGAS[51]
		SetRegByI2C_Byte4(0x0F1200DB);	//TVAR_ash_pGAS[52]
		SetRegByI2C_Byte4(0x0F1200A8);	//TVAR_ash_pGAS[53]
		SetRegByI2C_Byte4(0x0F12007D);	//TVAR_ash_pGAS[54]
		SetRegByI2C_Byte4(0x0F12004F);	//TVAR_ash_pGAS[55]
		SetRegByI2C_Byte4(0x0F12002E);	//TVAR_ash_pGAS[56]
		SetRegByI2C_Byte4(0x0F120011);	//TVAR_ash_pGAS[57]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_ash_pGAS[58]
		SetRegByI2C_Byte4(0x0F12000C);	//TVAR_ash_pGAS[59]
		SetRegByI2C_Byte4(0x0F12001A);	//TVAR_ash_pGAS[60]
		SetRegByI2C_Byte4(0x0F120038);	//TVAR_ash_pGAS[61]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[62]
		SetRegByI2C_Byte4(0x0F12008B);	//TVAR_ash_pGAS[63]
		SetRegByI2C_Byte4(0x0F1200C5);	//TVAR_ash_pGAS[64]
		SetRegByI2C_Byte4(0x0F1200D9);	//TVAR_ash_pGAS[65]
		SetRegByI2C_Byte4(0x0F1200A5);	//TVAR_ash_pGAS[66]
		SetRegByI2C_Byte4(0x0F120077);	//TVAR_ash_pGAS[67]
		SetRegByI2C_Byte4(0x0F12004C);	//TVAR_ash_pGAS[68]
		SetRegByI2C_Byte4(0x0F120025);	//TVAR_ash_pGAS[69]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_ash_pGAS[70]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_ash_pGAS[71]
		SetRegByI2C_Byte4(0x0F120002);	//TVAR_ash_pGAS[72]
		SetRegByI2C_Byte4(0x0F120012);	//TVAR_ash_pGAS[73]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_ash_pGAS[74]
		SetRegByI2C_Byte4(0x0F12005A);	//TVAR_ash_pGAS[75]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[76]
		SetRegByI2C_Byte4(0x0F1200C3);	//TVAR_ash_pGAS[77]
		SetRegByI2C_Byte4(0x0F1200E4);	//TVAR_ash_pGAS[78]
		SetRegByI2C_Byte4(0x0F1200AE);	//TVAR_ash_pGAS[79]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[80]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[81]
		SetRegByI2C_Byte4(0x0F12002C);	//TVAR_ash_pGAS[82]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_ash_pGAS[83]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_ash_pGAS[84]
		SetRegByI2C_Byte4(0x0F12000B);	//TVAR_ash_pGAS[85]
		SetRegByI2C_Byte4(0x0F12001C);	//TVAR_ash_pGAS[86]
		SetRegByI2C_Byte4(0x0F12003A);	//TVAR_ash_pGAS[87]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[88]
		SetRegByI2C_Byte4(0x0F120096);	//TVAR_ash_pGAS[89]
		SetRegByI2C_Byte4(0x0F1200CC);	//TVAR_ash_pGAS[90]
		SetRegByI2C_Byte4(0x0F1200FC);	//TVAR_ash_pGAS[91]
		SetRegByI2C_Byte4(0x0F1200C2);	//TVAR_ash_pGAS[92]
		SetRegByI2C_Byte4(0x0F12008F);	//TVAR_ash_pGAS[93]
		SetRegByI2C_Byte4(0x0F120067);	//TVAR_ash_pGAS[94]
		SetRegByI2C_Byte4(0x0F120044);	//TVAR_ash_pGAS[95]
		SetRegByI2C_Byte4(0x0F12002D);	//TVAR_ash_pGAS[96]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[97]
		SetRegByI2C_Byte4(0x0F120024);	//TVAR_ash_pGAS[98]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_ash_pGAS[99]
		SetRegByI2C_Byte4(0x0F120051);	//TVAR_ash_pGAS[100]
		SetRegByI2C_Byte4(0x0F120078);	//TVAR_ash_pGAS[101]
		SetRegByI2C_Byte4(0x0F1200AD);	//TVAR_ash_pGAS[102]
		SetRegByI2C_Byte4(0x0F1200E5);	//TVAR_ash_pGAS[103]
		SetRegByI2C_Byte4(0x0F120127);	//TVAR_ash_pGAS[104]
		SetRegByI2C_Byte4(0x0F1200E7);	//TVAR_ash_pGAS[105]
		SetRegByI2C_Byte4(0x0F1200AE);	//TVAR_ash_pGAS[106]
		SetRegByI2C_Byte4(0x0F120088);	//TVAR_ash_pGAS[107]
		SetRegByI2C_Byte4(0x0F120066);	//TVAR_ash_pGAS[108]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_ash_pGAS[109]
		SetRegByI2C_Byte4(0x0F120045);	//TVAR_ash_pGAS[110]
		SetRegByI2C_Byte4(0x0F120048);	//TVAR_ash_pGAS[111]
		SetRegByI2C_Byte4(0x0F120057);	//TVAR_ash_pGAS[112]
		SetRegByI2C_Byte4(0x0F120074);	//TVAR_ash_pGAS[113]
		SetRegByI2C_Byte4(0x0F12009B);	//TVAR_ash_pGAS[114]
		SetRegByI2C_Byte4(0x0F1200CF);	//TVAR_ash_pGAS[115]
		SetRegByI2C_Byte4(0x0F12010D);	//TVAR_ash_pGAS[116]
		SetRegByI2C_Byte4(0x0F12016C);	//TVAR_ash_pGAS[117]
		SetRegByI2C_Byte4(0x0F12011D);	//TVAR_ash_pGAS[118]
		SetRegByI2C_Byte4(0x0F1200DD);	//TVAR_ash_pGAS[119]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[120]
		SetRegByI2C_Byte4(0x0F120097);	//TVAR_ash_pGAS[121]
		SetRegByI2C_Byte4(0x0F120082);	//TVAR_ash_pGAS[122]
		SetRegByI2C_Byte4(0x0F120077);	//TVAR_ash_pGAS[123]
		SetRegByI2C_Byte4(0x0F12007C);	//TVAR_ash_pGAS[124]
		SetRegByI2C_Byte4(0x0F12008B);	//TVAR_ash_pGAS[125]
		SetRegByI2C_Byte4(0x0F1200A2);	//TVAR_ash_pGAS[126]
		SetRegByI2C_Byte4(0x0F1200CA);	//TVAR_ash_pGAS[127]
		SetRegByI2C_Byte4(0x0F120105);	//TVAR_ash_pGAS[128]
		SetRegByI2C_Byte4(0x0F12014A);	//TVAR_ash_pGAS[129]
		SetRegByI2C_Byte4(0x0F1201AD);	//TVAR_ash_pGAS[130]
		SetRegByI2C_Byte4(0x0F120148);	//TVAR_ash_pGAS[131]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_pGAS[132]
		SetRegByI2C_Byte4(0x0F1200D2);	//TVAR_ash_pGAS[133]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[134]
		SetRegByI2C_Byte4(0x0F1200A5);	//TVAR_ash_pGAS[135]
		SetRegByI2C_Byte4(0x0F12009B);	//TVAR_ash_pGAS[136]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[137]
		SetRegByI2C_Byte4(0x0F1200B0);	//TVAR_ash_pGAS[138]
		SetRegByI2C_Byte4(0x0F1200CA);	//TVAR_ash_pGAS[139]
		SetRegByI2C_Byte4(0x0F1200F7);	//TVAR_ash_pGAS[140]
		SetRegByI2C_Byte4(0x0F12013D);	//TVAR_ash_pGAS[141]
		SetRegByI2C_Byte4(0x0F12018C);	//TVAR_ash_pGAS[142]
		SetRegByI2C_Byte4(0x0F120148);	//TVAR_ash_pGAS[143]
		SetRegByI2C_Byte4(0x0F1200F3);	//TVAR_ash_pGAS[144]
		SetRegByI2C_Byte4(0x0F1200C2);	//TVAR_ash_pGAS[145]
		SetRegByI2C_Byte4(0x0F1200A0);	//TVAR_ash_pGAS[146]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[147]
		SetRegByI2C_Byte4(0x0F120080);	//TVAR_ash_pGAS[148]
		SetRegByI2C_Byte4(0x0F12007A);	//TVAR_ash_pGAS[149]
		SetRegByI2C_Byte4(0x0F12007A);	//TVAR_ash_pGAS[150]
		SetRegByI2C_Byte4(0x0F120080);	//TVAR_ash_pGAS[151]
		SetRegByI2C_Byte4(0x0F120089);	//TVAR_ash_pGAS[152]
		SetRegByI2C_Byte4(0x0F1200A2);	//TVAR_ash_pGAS[153]
		SetRegByI2C_Byte4(0x0F1200C8);	//TVAR_ash_pGAS[154]
		SetRegByI2C_Byte4(0x0F120102);	//TVAR_ash_pGAS[155]
		SetRegByI2C_Byte4(0x0F120107);	//TVAR_ash_pGAS[156]
		SetRegByI2C_Byte4(0x0F1200CA);	//TVAR_ash_pGAS[157]
		SetRegByI2C_Byte4(0x0F12009C);	//TVAR_ash_pGAS[158]
		SetRegByI2C_Byte4(0x0F120081);	//TVAR_ash_pGAS[159]
		SetRegByI2C_Byte4(0x0F12006D);	//TVAR_ash_pGAS[160]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[161]
		SetRegByI2C_Byte4(0x0F120059);	//TVAR_ash_pGAS[162]
		SetRegByI2C_Byte4(0x0F120059);	//TVAR_ash_pGAS[163]
		SetRegByI2C_Byte4(0x0F12005F);	//TVAR_ash_pGAS[164]
		SetRegByI2C_Byte4(0x0F120069);	//TVAR_ash_pGAS[165]
		SetRegByI2C_Byte4(0x0F12007D);	//TVAR_ash_pGAS[166]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[167]
		SetRegByI2C_Byte4(0x0F1200D2);	//TVAR_ash_pGAS[168]
		SetRegByI2C_Byte4(0x0F1200E2);	//TVAR_ash_pGAS[169]
		SetRegByI2C_Byte4(0x0F1200A7);	//TVAR_ash_pGAS[170]
		SetRegByI2C_Byte4(0x0F120082);	//TVAR_ash_pGAS[171]
		SetRegByI2C_Byte4(0x0F120066);	//TVAR_ash_pGAS[172]
		SetRegByI2C_Byte4(0x0F12004F);	//TVAR_ash_pGAS[173]
		SetRegByI2C_Byte4(0x0F120041);	//TVAR_ash_pGAS[174]
		SetRegByI2C_Byte4(0x0F12003D);	//TVAR_ash_pGAS[175]
		SetRegByI2C_Byte4(0x0F120037);	//TVAR_ash_pGAS[176]
		SetRegByI2C_Byte4(0x0F12003B);	//TVAR_ash_pGAS[177]
		SetRegByI2C_Byte4(0x0F12004A);	//TVAR_ash_pGAS[178]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[179]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[180]
		SetRegByI2C_Byte4(0x0F1200AB);	//TVAR_ash_pGAS[181]
		SetRegByI2C_Byte4(0x0F1200C3);	//TVAR_ash_pGAS[182]
		SetRegByI2C_Byte4(0x0F12008E);	//TVAR_ash_pGAS[183]
		SetRegByI2C_Byte4(0x0F12006C);	//TVAR_ash_pGAS[184]
		SetRegByI2C_Byte4(0x0F12004E);	//TVAR_ash_pGAS[185]
		SetRegByI2C_Byte4(0x0F120037);	//TVAR_ash_pGAS[186]
		SetRegByI2C_Byte4(0x0F120022);	//TVAR_ash_pGAS[187]
		SetRegByI2C_Byte4(0x0F12001C);	//TVAR_ash_pGAS[188]
		SetRegByI2C_Byte4(0x0F12001D);	//TVAR_ash_pGAS[189]
		SetRegByI2C_Byte4(0x0F120022);	//TVAR_ash_pGAS[190]
		SetRegByI2C_Byte4(0x0F120033);	//TVAR_ash_pGAS[191]
		SetRegByI2C_Byte4(0x0F120049);	//TVAR_ash_pGAS[192]
		SetRegByI2C_Byte4(0x0F12006B);	//TVAR_ash_pGAS[193]
		SetRegByI2C_Byte4(0x0F12008E);	//TVAR_ash_pGAS[194]
		SetRegByI2C_Byte4(0x0F1200B0);	//TVAR_ash_pGAS[195]
		SetRegByI2C_Byte4(0x0F120083);	//TVAR_ash_pGAS[196]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[197]
		SetRegByI2C_Byte4(0x0F120040);	//TVAR_ash_pGAS[198]
		SetRegByI2C_Byte4(0x0F120027);	//TVAR_ash_pGAS[199]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_ash_pGAS[200]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[201]
		SetRegByI2C_Byte4(0x0F120008);	//TVAR_ash_pGAS[202]
		SetRegByI2C_Byte4(0x0F120010);	//TVAR_ash_pGAS[203]
		SetRegByI2C_Byte4(0x0F120023);	//TVAR_ash_pGAS[204]
		SetRegByI2C_Byte4(0x0F12003D);	//TVAR_ash_pGAS[205]
		SetRegByI2C_Byte4(0x0F12005A);	//TVAR_ash_pGAS[206]
		SetRegByI2C_Byte4(0x0F120086);	//TVAR_ash_pGAS[207]
		SetRegByI2C_Byte4(0x0F1200AE);	//TVAR_ash_pGAS[208]
		SetRegByI2C_Byte4(0x0F120080);	//TVAR_ash_pGAS[209]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[210]
		SetRegByI2C_Byte4(0x0F12003E);	//TVAR_ash_pGAS[211]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[212]
		SetRegByI2C_Byte4(0x0F120009);	//TVAR_ash_pGAS[213]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_ash_pGAS[214]
		SetRegByI2C_Byte4(0x0F120001);	//TVAR_ash_pGAS[215]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_ash_pGAS[216]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[217]
		SetRegByI2C_Byte4(0x0F12003B);	//TVAR_ash_pGAS[218]
		SetRegByI2C_Byte4(0x0F12005C);	//TVAR_ash_pGAS[219]
		SetRegByI2C_Byte4(0x0F120085);	//TVAR_ash_pGAS[220]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[221]
		SetRegByI2C_Byte4(0x0F120087);	//TVAR_ash_pGAS[222]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_ash_pGAS[223]
		SetRegByI2C_Byte4(0x0F120042);	//TVAR_ash_pGAS[224]
		SetRegByI2C_Byte4(0x0F120025);	//TVAR_ash_pGAS[225]
		SetRegByI2C_Byte4(0x0F120011);	//TVAR_ash_pGAS[226]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[227]
		SetRegByI2C_Byte4(0x0F120008);	//TVAR_ash_pGAS[228]
		SetRegByI2C_Byte4(0x0F120012);	//TVAR_ash_pGAS[229]
		SetRegByI2C_Byte4(0x0F120026);	//TVAR_ash_pGAS[230]
		SetRegByI2C_Byte4(0x0F120041);	//TVAR_ash_pGAS[231]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_ash_pGAS[232]
		SetRegByI2C_Byte4(0x0F12008D);	//TVAR_ash_pGAS[233]
		SetRegByI2C_Byte4(0x0F1200CA);	//TVAR_ash_pGAS[234]
		SetRegByI2C_Byte4(0x0F120097);	//TVAR_ash_pGAS[235]
		SetRegByI2C_Byte4(0x0F120071);	//TVAR_ash_pGAS[236]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[237]
		SetRegByI2C_Byte4(0x0F120037);	//TVAR_ash_pGAS[238]
		SetRegByI2C_Byte4(0x0F120026);	//TVAR_ash_pGAS[239]
		SetRegByI2C_Byte4(0x0F12001A);	//TVAR_ash_pGAS[240]
		SetRegByI2C_Byte4(0x0F12001C);	//TVAR_ash_pGAS[241]
		SetRegByI2C_Byte4(0x0F120024);	//TVAR_ash_pGAS[242]
		SetRegByI2C_Byte4(0x0F120039);	//TVAR_ash_pGAS[243]
		SetRegByI2C_Byte4(0x0F120053);	//TVAR_ash_pGAS[244]
		SetRegByI2C_Byte4(0x0F120076);	//TVAR_ash_pGAS[245]
		SetRegByI2C_Byte4(0x0F1200A2);	//TVAR_ash_pGAS[246]
		SetRegByI2C_Byte4(0x0F1200F0);	//TVAR_ash_pGAS[247]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[248]
		SetRegByI2C_Byte4(0x0F120089);	//TVAR_ash_pGAS[249]
		SetRegByI2C_Byte4(0x0F12006B);	//TVAR_ash_pGAS[250]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[251]
		SetRegByI2C_Byte4(0x0F120041);	//TVAR_ash_pGAS[252]
		SetRegByI2C_Byte4(0x0F120038);	//TVAR_ash_pGAS[253]
		SetRegByI2C_Byte4(0x0F120039);	//TVAR_ash_pGAS[254]
		SetRegByI2C_Byte4(0x0F120041);	//TVAR_ash_pGAS[255]
		SetRegByI2C_Byte4(0x0F120053);	//TVAR_ash_pGAS[256]
		SetRegByI2C_Byte4(0x0F12006E);	//TVAR_ash_pGAS[257]
		SetRegByI2C_Byte4(0x0F120093);	//TVAR_ash_pGAS[258]
		SetRegByI2C_Byte4(0x0F1200C7);	//TVAR_ash_pGAS[259]
		SetRegByI2C_Byte4(0x0F120133);	//TVAR_ash_pGAS[260]
		SetRegByI2C_Byte4(0x0F1200E7);	//TVAR_ash_pGAS[261]
		SetRegByI2C_Byte4(0x0F1200B0);	//TVAR_ash_pGAS[262]
		SetRegByI2C_Byte4(0x0F120090);	//TVAR_ash_pGAS[263]
		SetRegByI2C_Byte4(0x0F120078);	//TVAR_ash_pGAS[264]
		SetRegByI2C_Byte4(0x0F120069);	//TVAR_ash_pGAS[265]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[266]
		SetRegByI2C_Byte4(0x0F120061);	//TVAR_ash_pGAS[267]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[268]
		SetRegByI2C_Byte4(0x0F120077);	//TVAR_ash_pGAS[269]
		SetRegByI2C_Byte4(0x0F120094);	//TVAR_ash_pGAS[270]
		SetRegByI2C_Byte4(0x0F1200C3);	//TVAR_ash_pGAS[271]
		SetRegByI2C_Byte4(0x0F120101);	//TVAR_ash_pGAS[272]
		SetRegByI2C_Byte4(0x0F120174);	//TVAR_ash_pGAS[273]
		SetRegByI2C_Byte4(0x0F120111);	//TVAR_ash_pGAS[274]
		SetRegByI2C_Byte4(0x0F1200CC);	//TVAR_ash_pGAS[275]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[276]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[277]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[278]
		SetRegByI2C_Byte4(0x0F120076);	//TVAR_ash_pGAS[279]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[280]
		SetRegByI2C_Byte4(0x0F120085);	//TVAR_ash_pGAS[281]
		SetRegByI2C_Byte4(0x0F120096);	//TVAR_ash_pGAS[282]
		SetRegByI2C_Byte4(0x0F1200BB);	//TVAR_ash_pGAS[283]
		SetRegByI2C_Byte4(0x0F1200F7);	//TVAR_ash_pGAS[284]
		SetRegByI2C_Byte4(0x0F12013E);	//TVAR_ash_pGAS[285]
		SetRegByI2C_Byte4(0x0F12014F);	//TVAR_ash_pGAS[286]
		SetRegByI2C_Byte4(0x0F1200F9);	//TVAR_ash_pGAS[287]
		SetRegByI2C_Byte4(0x0F1200C7);	//TVAR_ash_pGAS[288]
		SetRegByI2C_Byte4(0x0F1200A2);	//TVAR_ash_pGAS[289]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[290]
		SetRegByI2C_Byte4(0x0F12007E);	//TVAR_ash_pGAS[291]
		SetRegByI2C_Byte4(0x0F120078);	//TVAR_ash_pGAS[292]
		SetRegByI2C_Byte4(0x0F120079);	//TVAR_ash_pGAS[293]
		SetRegByI2C_Byte4(0x0F120083);	//TVAR_ash_pGAS[294]
		SetRegByI2C_Byte4(0x0F120093);	//TVAR_ash_pGAS[295]
		SetRegByI2C_Byte4(0x0F1200B0);	//TVAR_ash_pGAS[296]
		SetRegByI2C_Byte4(0x0F1200DC);	//TVAR_ash_pGAS[297]
		SetRegByI2C_Byte4(0x0F120113);	//TVAR_ash_pGAS[298]
		SetRegByI2C_Byte4(0x0F120112);	//TVAR_ash_pGAS[299]
		SetRegByI2C_Byte4(0x0F1200D3);	//TVAR_ash_pGAS[300]
		SetRegByI2C_Byte4(0x0F1200A2);	//TVAR_ash_pGAS[301]
		SetRegByI2C_Byte4(0x0F120086);	//TVAR_ash_pGAS[302]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_ash_pGAS[303]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[304]
		SetRegByI2C_Byte4(0x0F120059);	//TVAR_ash_pGAS[305]
		SetRegByI2C_Byte4(0x0F120059);	//TVAR_ash_pGAS[306]
		SetRegByI2C_Byte4(0x0F120063);	//TVAR_ash_pGAS[307]
		SetRegByI2C_Byte4(0x0F120072);	//TVAR_ash_pGAS[308]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[309]
		SetRegByI2C_Byte4(0x0F1200B6);	//TVAR_ash_pGAS[310]
		SetRegByI2C_Byte4(0x0F1200E8);	//TVAR_ash_pGAS[311]
		SetRegByI2C_Byte4(0x0F1200ED);	//TVAR_ash_pGAS[312]
		SetRegByI2C_Byte4(0x0F1200B1);	//TVAR_ash_pGAS[313]
		SetRegByI2C_Byte4(0x0F12008B);	//TVAR_ash_pGAS[314]
		SetRegByI2C_Byte4(0x0F12006C);	//TVAR_ash_pGAS[315]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[316]
		SetRegByI2C_Byte4(0x0F120042);	//TVAR_ash_pGAS[317]
		SetRegByI2C_Byte4(0x0F12003D);	//TVAR_ash_pGAS[318]
		SetRegByI2C_Byte4(0x0F120038);	//TVAR_ash_pGAS[319]
		SetRegByI2C_Byte4(0x0F12003F);	//TVAR_ash_pGAS[320]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[321]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[322]
		SetRegByI2C_Byte4(0x0F120090);	//TVAR_ash_pGAS[323]
		SetRegByI2C_Byte4(0x0F1200BD);	//TVAR_ash_pGAS[324]
		SetRegByI2C_Byte4(0x0F1200D2);	//TVAR_ash_pGAS[325]
		SetRegByI2C_Byte4(0x0F12009A);	//TVAR_ash_pGAS[326]
		SetRegByI2C_Byte4(0x0F120077);	//TVAR_ash_pGAS[327]
		SetRegByI2C_Byte4(0x0F120056);	//TVAR_ash_pGAS[328]
		SetRegByI2C_Byte4(0x0F12003C);	//TVAR_ash_pGAS[329]
		SetRegByI2C_Byte4(0x0F120024);	//TVAR_ash_pGAS[330]
		SetRegByI2C_Byte4(0x0F12001D);	//TVAR_ash_pGAS[331]
		SetRegByI2C_Byte4(0x0F12001E);	//TVAR_ash_pGAS[332]
		SetRegByI2C_Byte4(0x0F120025);	//TVAR_ash_pGAS[333]
		SetRegByI2C_Byte4(0x0F12003A);	//TVAR_ash_pGAS[334]
		SetRegByI2C_Byte4(0x0F120054);	//TVAR_ash_pGAS[335]
		SetRegByI2C_Byte4(0x0F12007A);	//TVAR_ash_pGAS[336]
		SetRegByI2C_Byte4(0x0F12009D);	//TVAR_ash_pGAS[337]
		SetRegByI2C_Byte4(0x0F1200BF);	//TVAR_ash_pGAS[338]
		SetRegByI2C_Byte4(0x0F12008E);	//TVAR_ash_pGAS[339]
		SetRegByI2C_Byte4(0x0F12006E);	//TVAR_ash_pGAS[340]
		SetRegByI2C_Byte4(0x0F120049);	//TVAR_ash_pGAS[341]
		SetRegByI2C_Byte4(0x0F12002C);	//TVAR_ash_pGAS[342]
		SetRegByI2C_Byte4(0x0F120012);	//TVAR_ash_pGAS[343]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_ash_pGAS[344]
		SetRegByI2C_Byte4(0x0F120009);	//TVAR_ash_pGAS[345]
		SetRegByI2C_Byte4(0x0F120012);	//TVAR_ash_pGAS[346]
		SetRegByI2C_Byte4(0x0F120027);	//TVAR_ash_pGAS[347]
		SetRegByI2C_Byte4(0x0F120044);	//TVAR_ash_pGAS[348]
		SetRegByI2C_Byte4(0x0F120063);	//TVAR_ash_pGAS[349]
		SetRegByI2C_Byte4(0x0F12008F);	//TVAR_ash_pGAS[350]
		SetRegByI2C_Byte4(0x0F1200BE);	//TVAR_ash_pGAS[351]
		SetRegByI2C_Byte4(0x0F12008C);	//TVAR_ash_pGAS[352]
		SetRegByI2C_Byte4(0x0F120069);	//TVAR_ash_pGAS[353]
		SetRegByI2C_Byte4(0x0F120046);	//TVAR_ash_pGAS[354]
		SetRegByI2C_Byte4(0x0F120025);	//TVAR_ash_pGAS[355]
		SetRegByI2C_Byte4(0x0F12000B);	//TVAR_ash_pGAS[356]
		SetRegByI2C_Byte4(0x0F120001);	//TVAR_ash_pGAS[357]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_ash_pGAS[358]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_ash_pGAS[359]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[360]
		SetRegByI2C_Byte4(0x0F12003C);	//TVAR_ash_pGAS[361]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[362]
		SetRegByI2C_Byte4(0x0F120088);	//TVAR_ash_pGAS[363]
		SetRegByI2C_Byte4(0x0F1200C7);	//TVAR_ash_pGAS[364]
		SetRegByI2C_Byte4(0x0F120093);	//TVAR_ash_pGAS[365]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_ash_pGAS[366]
		SetRegByI2C_Byte4(0x0F12004A);	//TVAR_ash_pGAS[367]
		SetRegByI2C_Byte4(0x0F12002B);	//TVAR_ash_pGAS[368]
		SetRegByI2C_Byte4(0x0F120013);	//TVAR_ash_pGAS[369]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[370]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[371]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_ash_pGAS[372]
		SetRegByI2C_Byte4(0x0F120022);	//TVAR_ash_pGAS[373]
		SetRegByI2C_Byte4(0x0F12003D);	//TVAR_ash_pGAS[374]
		SetRegByI2C_Byte4(0x0F120061);	//TVAR_ash_pGAS[375]
		SetRegByI2C_Byte4(0x0F120089);	//TVAR_ash_pGAS[376]
		SetRegByI2C_Byte4(0x0F1200DB);	//TVAR_ash_pGAS[377]
		SetRegByI2C_Byte4(0x0F1200A3);	//TVAR_ash_pGAS[378]
		SetRegByI2C_Byte4(0x0F12007C);	//TVAR_ash_pGAS[379]
		SetRegByI2C_Byte4(0x0F12005A);	//TVAR_ash_pGAS[380]
		SetRegByI2C_Byte4(0x0F12003C);	//TVAR_ash_pGAS[381]
		SetRegByI2C_Byte4(0x0F120027);	//TVAR_ash_pGAS[382]
		SetRegByI2C_Byte4(0x0F120019);	//TVAR_ash_pGAS[383]
		SetRegByI2C_Byte4(0x0F120018);	//TVAR_ash_pGAS[384]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[385]
		SetRegByI2C_Byte4(0x0F120031);	//TVAR_ash_pGAS[386]
		SetRegByI2C_Byte4(0x0F120049);	//TVAR_ash_pGAS[387]
		SetRegByI2C_Byte4(0x0F12006D);	//TVAR_ash_pGAS[388]
		SetRegByI2C_Byte4(0x0F120096);	//TVAR_ash_pGAS[389]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_ash_pGAS[390]
		SetRegByI2C_Byte4(0x0F1200C3);	//TVAR_ash_pGAS[391]
		SetRegByI2C_Byte4(0x0F120094);	//TVAR_ash_pGAS[392]
		SetRegByI2C_Byte4(0x0F120074);	//TVAR_ash_pGAS[393]
		SetRegByI2C_Byte4(0x0F120057);	//TVAR_ash_pGAS[394]
		SetRegByI2C_Byte4(0x0F120043);	//TVAR_ash_pGAS[395]
		SetRegByI2C_Byte4(0x0F120037);	//TVAR_ash_pGAS[396]
		SetRegByI2C_Byte4(0x0F120035);	//TVAR_ash_pGAS[397]
		SetRegByI2C_Byte4(0x0F12003A);	//TVAR_ash_pGAS[398]
		SetRegByI2C_Byte4(0x0F120049);	//TVAR_ash_pGAS[399]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[400]
		SetRegByI2C_Byte4(0x0F120085);	//TVAR_ash_pGAS[401]
		SetRegByI2C_Byte4(0x0F1200B5);	//TVAR_ash_pGAS[402]
		SetRegByI2C_Byte4(0x0F120141);	//TVAR_ash_pGAS[403]
		SetRegByI2C_Byte4(0x0F1200F5);	//TVAR_ash_pGAS[404]
		SetRegByI2C_Byte4(0x0F1200BA);	//TVAR_ash_pGAS[405]
		SetRegByI2C_Byte4(0x0F120099);	//TVAR_ash_pGAS[406]
		SetRegByI2C_Byte4(0x0F12007D);	//TVAR_ash_pGAS[407]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[408]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[409]
		SetRegByI2C_Byte4(0x0F12005C);	//TVAR_ash_pGAS[410]
		SetRegByI2C_Byte4(0x0F120061);	//TVAR_ash_pGAS[411]
		SetRegByI2C_Byte4(0x0F12006B);	//TVAR_ash_pGAS[412]
		SetRegByI2C_Byte4(0x0F120085);	//TVAR_ash_pGAS[413]
		SetRegByI2C_Byte4(0x0F1200B1);	//TVAR_ash_pGAS[414]
		SetRegByI2C_Byte4(0x0F1200EB);	//TVAR_ash_pGAS[415]
		SetRegByI2C_Byte4(0x0F120182);	//TVAR_ash_pGAS[416]
		SetRegByI2C_Byte4(0x0F12011E);	//TVAR_ash_pGAS[417]
		SetRegByI2C_Byte4(0x0F1200D7);	//TVAR_ash_pGAS[418]
		SetRegByI2C_Byte4(0x0F1200AC);	//TVAR_ash_pGAS[419]
		SetRegByI2C_Byte4(0x0F120091);	//TVAR_ash_pGAS[420]
		SetRegByI2C_Byte4(0x0F120080);	//TVAR_ash_pGAS[421]
		SetRegByI2C_Byte4(0x0F120076);	//TVAR_ash_pGAS[422]
		SetRegByI2C_Byte4(0x0F120079);	//TVAR_ash_pGAS[423]
		SetRegByI2C_Byte4(0x0F12007D);	//TVAR_ash_pGAS[424]
		SetRegByI2C_Byte4(0x0F120089);	//TVAR_ash_pGAS[425]
		SetRegByI2C_Byte4(0x0F1200AB);	//TVAR_ash_pGAS[426]
		SetRegByI2C_Byte4(0x0F1200E6);	//TVAR_ash_pGAS[427]
		SetRegByI2C_Byte4(0x0F120124);	//TVAR_ash_pGAS[428]
		SetRegByI2C_Byte4(0x0F1200FB);	//TVAR_ash_pGAS[429]
		SetRegByI2C_Byte4(0x0F1200BB);	//TVAR_ash_pGAS[430]
		SetRegByI2C_Byte4(0x0F120093);	//TVAR_ash_pGAS[431]
		SetRegByI2C_Byte4(0x0F120079);	//TVAR_ash_pGAS[432]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[433]
		SetRegByI2C_Byte4(0x0F120061);	//TVAR_ash_pGAS[434]
		SetRegByI2C_Byte4(0x0F12005E);	//TVAR_ash_pGAS[435]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[436]
		SetRegByI2C_Byte4(0x0F120067);	//TVAR_ash_pGAS[437]
		SetRegByI2C_Byte4(0x0F120072);	//TVAR_ash_pGAS[438]
		SetRegByI2C_Byte4(0x0F12008A);	//TVAR_ash_pGAS[439]
		SetRegByI2C_Byte4(0x0F1200AD);	//TVAR_ash_pGAS[440]
		SetRegByI2C_Byte4(0x0F1200DB);	//TVAR_ash_pGAS[441]
		SetRegByI2C_Byte4(0x0F1200CD);	//TVAR_ash_pGAS[442]
		SetRegByI2C_Byte4(0x0F12009C);	//TVAR_ash_pGAS[443]
		SetRegByI2C_Byte4(0x0F120076);	//TVAR_ash_pGAS[444]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_ash_pGAS[445]
		SetRegByI2C_Byte4(0x0F120053);	//TVAR_ash_pGAS[446]
		SetRegByI2C_Byte4(0x0F12004A);	//TVAR_ash_pGAS[447]
		SetRegByI2C_Byte4(0x0F120045);	//TVAR_ash_pGAS[448]
		SetRegByI2C_Byte4(0x0F120046);	//TVAR_ash_pGAS[449]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_ash_pGAS[450]
		SetRegByI2C_Byte4(0x0F120059);	//TVAR_ash_pGAS[451]
		SetRegByI2C_Byte4(0x0F12006D);	//TVAR_ash_pGAS[452]
		SetRegByI2C_Byte4(0x0F120091);	//TVAR_ash_pGAS[453]
		SetRegByI2C_Byte4(0x0F1200BB);	//TVAR_ash_pGAS[454]
		SetRegByI2C_Byte4(0x0F1200A9);	//TVAR_ash_pGAS[455]
		SetRegByI2C_Byte4(0x0F12007D);	//TVAR_ash_pGAS[456]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[457]
		SetRegByI2C_Byte4(0x0F12004D);	//TVAR_ash_pGAS[458]
		SetRegByI2C_Byte4(0x0F12003C);	//TVAR_ash_pGAS[459]
		SetRegByI2C_Byte4(0x0F120031);	//TVAR_ash_pGAS[460]
		SetRegByI2C_Byte4(0x0F12002F);	//TVAR_ash_pGAS[461]
		SetRegByI2C_Byte4(0x0F12002C);	//TVAR_ash_pGAS[462]
		SetRegByI2C_Byte4(0x0F120031);	//TVAR_ash_pGAS[463]
		SetRegByI2C_Byte4(0x0F120040);	//TVAR_ash_pGAS[464]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[465]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_ash_pGAS[466]
		SetRegByI2C_Byte4(0x0F120097);	//TVAR_ash_pGAS[467]
		SetRegByI2C_Byte4(0x0F120095);	//TVAR_ash_pGAS[468]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[469]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[470]
		SetRegByI2C_Byte4(0x0F12003C);	//TVAR_ash_pGAS[471]
		SetRegByI2C_Byte4(0x0F12002B);	//TVAR_ash_pGAS[472]
		SetRegByI2C_Byte4(0x0F12001A);	//TVAR_ash_pGAS[473]
		SetRegByI2C_Byte4(0x0F120016);	//TVAR_ash_pGAS[474]
		SetRegByI2C_Byte4(0x0F120018);	//TVAR_ash_pGAS[475]
		SetRegByI2C_Byte4(0x0F12001E);	//TVAR_ash_pGAS[476]
		SetRegByI2C_Byte4(0x0F12002B);	//TVAR_ash_pGAS[477]
		SetRegByI2C_Byte4(0x0F12003F);	//TVAR_ash_pGAS[478]
		SetRegByI2C_Byte4(0x0F12005C);	//TVAR_ash_pGAS[479]
		SetRegByI2C_Byte4(0x0F120078);	//TVAR_ash_pGAS[480]
		SetRegByI2C_Byte4(0x0F120088);	//TVAR_ash_pGAS[481]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[482]
		SetRegByI2C_Byte4(0x0F12004C);	//TVAR_ash_pGAS[483]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_ash_pGAS[484]
		SetRegByI2C_Byte4(0x0F12001E);	//TVAR_ash_pGAS[485]
		SetRegByI2C_Byte4(0x0F12000B);	//TVAR_ash_pGAS[486]
		SetRegByI2C_Byte4(0x0F120004);	//TVAR_ash_pGAS[487]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_ash_pGAS[488]
		SetRegByI2C_Byte4(0x0F12000C);	//TVAR_ash_pGAS[489]
		SetRegByI2C_Byte4(0x0F12001C);	//TVAR_ash_pGAS[490]
		SetRegByI2C_Byte4(0x0F120031);	//TVAR_ash_pGAS[491]
		SetRegByI2C_Byte4(0x0F120047);	//TVAR_ash_pGAS[492]
		SetRegByI2C_Byte4(0x0F12006C);	//TVAR_ash_pGAS[493]
		SetRegByI2C_Byte4(0x0F120085);	//TVAR_ash_pGAS[494]
		SetRegByI2C_Byte4(0x0F120060);	//TVAR_ash_pGAS[495]
		SetRegByI2C_Byte4(0x0F12004A);	//TVAR_ash_pGAS[496]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_ash_pGAS[497]
		SetRegByI2C_Byte4(0x0F120019);	//TVAR_ash_pGAS[498]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_ash_pGAS[499]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_ash_pGAS[500]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_ash_pGAS[501]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[502]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_ash_pGAS[503]
		SetRegByI2C_Byte4(0x0F120029);	//TVAR_ash_pGAS[504]
		SetRegByI2C_Byte4(0x0F120042);	//TVAR_ash_pGAS[505]
		SetRegByI2C_Byte4(0x0F120065);	//TVAR_ash_pGAS[506]
		SetRegByI2C_Byte4(0x0F12008F);	//TVAR_ash_pGAS[507]
		SetRegByI2C_Byte4(0x0F120067);	//TVAR_ash_pGAS[508]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_ash_pGAS[509]
		SetRegByI2C_Byte4(0x0F120036);	//TVAR_ash_pGAS[510]
		SetRegByI2C_Byte4(0x0F12001F);	//TVAR_ash_pGAS[511]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_ash_pGAS[512]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[513]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_ash_pGAS[514]
		SetRegByI2C_Byte4(0x0F12000B);	//TVAR_ash_pGAS[515]
		SetRegByI2C_Byte4(0x0F120017);	//TVAR_ash_pGAS[516]
		SetRegByI2C_Byte4(0x0F12002A);	//TVAR_ash_pGAS[517]
		SetRegByI2C_Byte4(0x0F120044);	//TVAR_ash_pGAS[518]
		SetRegByI2C_Byte4(0x0F120065);	//TVAR_ash_pGAS[519]
		SetRegByI2C_Byte4(0x0F12009F);	//TVAR_ash_pGAS[520]
		SetRegByI2C_Byte4(0x0F120076);	//TVAR_ash_pGAS[521]
		SetRegByI2C_Byte4(0x0F12005C);	//TVAR_ash_pGAS[522]
		SetRegByI2C_Byte4(0x0F120044);	//TVAR_ash_pGAS[523]
		SetRegByI2C_Byte4(0x0F12002F);	//TVAR_ash_pGAS[524]
		SetRegByI2C_Byte4(0x0F120022);	//TVAR_ash_pGAS[525]
		SetRegByI2C_Byte4(0x0F120015);	//TVAR_ash_pGAS[526]
		SetRegByI2C_Byte4(0x0F120015);	//TVAR_ash_pGAS[527]
		SetRegByI2C_Byte4(0x0F120017);	//TVAR_ash_pGAS[528]
		SetRegByI2C_Byte4(0x0F120024);	//TVAR_ash_pGAS[529]
		SetRegByI2C_Byte4(0x0F120035);	//TVAR_ash_pGAS[530]
		SetRegByI2C_Byte4(0x0F12004F);	//TVAR_ash_pGAS[531]
		SetRegByI2C_Byte4(0x0F120070);	//TVAR_ash_pGAS[532]
		SetRegByI2C_Byte4(0x0F1200C1);	//TVAR_ash_pGAS[533]
		SetRegByI2C_Byte4(0x0F120093);	//TVAR_ash_pGAS[534]
		SetRegByI2C_Byte4(0x0F120071);	//TVAR_ash_pGAS[535]
		SetRegByI2C_Byte4(0x0F12005C);	//TVAR_ash_pGAS[536]
		SetRegByI2C_Byte4(0x0F120047);	//TVAR_ash_pGAS[537]
		SetRegByI2C_Byte4(0x0F12003A);	//TVAR_ash_pGAS[538]
		SetRegByI2C_Byte4(0x0F120030);	//TVAR_ash_pGAS[539]
		SetRegByI2C_Byte4(0x0F12002E);	//TVAR_ash_pGAS[540]
		SetRegByI2C_Byte4(0x0F120030);	//TVAR_ash_pGAS[541]
		SetRegByI2C_Byte4(0x0F120038);	//TVAR_ash_pGAS[542]
		SetRegByI2C_Byte4(0x0F12004A);	//TVAR_ash_pGAS[543]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_ash_pGAS[544]
		SetRegByI2C_Byte4(0x0F12008D);	//TVAR_ash_pGAS[545]
		SetRegByI2C_Byte4(0x0F1200FF);	//TVAR_ash_pGAS[546]
		SetRegByI2C_Byte4(0x0F1200C0);	//TVAR_ash_pGAS[547]
		SetRegByI2C_Byte4(0x0F120094);	//TVAR_ash_pGAS[548]
		SetRegByI2C_Byte4(0x0F12007B);	//TVAR_ash_pGAS[549]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[550]
		SetRegByI2C_Byte4(0x0F12005D);	//TVAR_ash_pGAS[551]
		SetRegByI2C_Byte4(0x0F120053);	//TVAR_ash_pGAS[552]
		SetRegByI2C_Byte4(0x0F120052);	//TVAR_ash_pGAS[553]
		SetRegByI2C_Byte4(0x0F120053);	//TVAR_ash_pGAS[554]
		SetRegByI2C_Byte4(0x0F120057);	//TVAR_ash_pGAS[555]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[556]
		SetRegByI2C_Byte4(0x0F12008E);	//TVAR_ash_pGAS[557]
		SetRegByI2C_Byte4(0x0F1200C0);	//TVAR_ash_pGAS[558]
		SetRegByI2C_Byte4(0x0F12012E);	//TVAR_ash_pGAS[559]
		SetRegByI2C_Byte4(0x0F1200DC);	//TVAR_ash_pGAS[560]
		SetRegByI2C_Byte4(0x0F1200A6);	//TVAR_ash_pGAS[561]
		SetRegByI2C_Byte4(0x0F120086);	//TVAR_ash_pGAS[562]
		SetRegByI2C_Byte4(0x0F120073);	//TVAR_ash_pGAS[563]
		SetRegByI2C_Byte4(0x0F12006A);	//TVAR_ash_pGAS[564]
		SetRegByI2C_Byte4(0x0F120062);	//TVAR_ash_pGAS[565]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_ash_pGAS[566]
		SetRegByI2C_Byte4(0x0F120065);	//TVAR_ash_pGAS[567]
		SetRegByI2C_Byte4(0x0F12006C);	//TVAR_ash_pGAS[568]
		SetRegByI2C_Byte4(0x0F120088);	//TVAR_ash_pGAS[569]
		SetRegByI2C_Byte4(0x0F1200BA);	//TVAR_ash_pGAS[570]
		SetRegByI2C_Byte4(0x0F1200EF);	//TVAR_ash_pGAS[571]

		SetRegByI2C_Byte4(0x002A0F12);
		SetRegByI2C_Byte4(0x0F1202C9);	//awbb_GLocusR
		SetRegByI2C_Byte4(0x0F12033F);	//awbb_GLocusB


		//	param_start	TVAR_ash_AwbAshCord
		SetRegByI2C_Byte4(0x002A0704);
		SetRegByI2C_Byte4(0x0F1200C7);	//TVAR_ash_AwbAshCord[0]
		SetRegByI2C_Byte4(0x0F1200F7);	//TVAR_ash_AwbAshCord[1]
		SetRegByI2C_Byte4(0x0F120107);	//TVAR_ash_AwbAshCord[2]
		SetRegByI2C_Byte4(0x0F120142);	//TVAR_ash_AwbAshCord[3]
		SetRegByI2C_Byte4(0x0F12017A);	//TVAR_ash_AwbAshCord[4]
		SetRegByI2C_Byte4(0x0F1201A0);	//TVAR_ash_AwbAshCord[5]
		SetRegByI2C_Byte4(0x0F1201B6);	//TVAR_ash_AwbAshCord[6]
		//	param_end	TVAR_ash_AwbAshCord

		SetRegByI2C_Byte4(0x002A0754);
		SetRegByI2C_Byte4(0x0F12247C);
		SetRegByI2C_Byte4(0x0F127000);



		//	param_start	awbb_IndoorGrZones_m_BGrid
		SetRegByI2C_Byte4(0x002A0C50);
		SetRegByI2C_Byte4(0x0F1203BA);
		SetRegByI2C_Byte4(0x0F1203E3);
		SetRegByI2C_Byte4(0x0F12039A);
		SetRegByI2C_Byte4(0x0F1203DB);
		SetRegByI2C_Byte4(0x0F12037B);
		SetRegByI2C_Byte4(0x0F1203CD);
		SetRegByI2C_Byte4(0x0F12035D);
		SetRegByI2C_Byte4(0x0F1203B2);
		SetRegByI2C_Byte4(0x0F120342);
		SetRegByI2C_Byte4(0x0F120397);
		SetRegByI2C_Byte4(0x0F120325);
		SetRegByI2C_Byte4(0x0F120380);
		SetRegByI2C_Byte4(0x0F12030E);
		SetRegByI2C_Byte4(0x0F120369);
		SetRegByI2C_Byte4(0x0F1202F8);
		SetRegByI2C_Byte4(0x0F12034B);
		SetRegByI2C_Byte4(0x0F1202DE);
		SetRegByI2C_Byte4(0x0F120336);
		SetRegByI2C_Byte4(0x0F1202BF);
		SetRegByI2C_Byte4(0x0F12031F);
		SetRegByI2C_Byte4(0x0F1202A6);
		SetRegByI2C_Byte4(0x0F120306);
		SetRegByI2C_Byte4(0x0F12028D);
		SetRegByI2C_Byte4(0x0F1202F4);
		SetRegByI2C_Byte4(0x0F12027D);
		SetRegByI2C_Byte4(0x0F1202DD);
		SetRegByI2C_Byte4(0x0F12026C);
		SetRegByI2C_Byte4(0x0F1202C2);
		SetRegByI2C_Byte4(0x0F12025C);
		SetRegByI2C_Byte4(0x0F1202AE);
		SetRegByI2C_Byte4(0x0F12024F);
		SetRegByI2C_Byte4(0x0F12029D);
		SetRegByI2C_Byte4(0x0F120245);
		SetRegByI2C_Byte4(0x0F12028B);
		SetRegByI2C_Byte4(0x0F12023E);
		SetRegByI2C_Byte4(0x0F12027F);
		SetRegByI2C_Byte4(0x0F120235);
		SetRegByI2C_Byte4(0x0F120272);
		SetRegByI2C_Byte4(0x0F12022B);
		SetRegByI2C_Byte4(0x0F120267);
		SetRegByI2C_Byte4(0x0F120220);
		SetRegByI2C_Byte4(0x0F12025B);
		SetRegByI2C_Byte4(0x0F120218);
		SetRegByI2C_Byte4(0x0F120250);
		SetRegByI2C_Byte4(0x0F12020E);
		SetRegByI2C_Byte4(0x0F120246);
		SetRegByI2C_Byte4(0x0F120206);
		SetRegByI2C_Byte4(0x0F12023D);
		SetRegByI2C_Byte4(0x0F1201FB);
		SetRegByI2C_Byte4(0x0F120234);
		SetRegByI2C_Byte4(0x0F1201F1);
		SetRegByI2C_Byte4(0x0F120229);
		SetRegByI2C_Byte4(0x0F1201E7);
		SetRegByI2C_Byte4(0x0F120220);
		SetRegByI2C_Byte4(0x0F1201DF);
		SetRegByI2C_Byte4(0x0F120216);
		SetRegByI2C_Byte4(0x0F1201DC);
		SetRegByI2C_Byte4(0x0F12020D);
		SetRegByI2C_Byte4(0x0F1201E1);
		SetRegByI2C_Byte4(0x0F1201FD);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		//	param_end	awbb_IndoorGrZones_m_BGrid
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0CF8);
		SetRegByI2C_Byte4(0x0F12010F);
		SetRegByI2C_Byte4(0x0F120000);
		//	param_start	awbb_LowBrGrZones_m_BGrid
		SetRegByI2C_Byte4(0x002A0D84);
		SetRegByI2C_Byte4(0x0F120406);
		SetRegByI2C_Byte4(0x0F120467);
		SetRegByI2C_Byte4(0x0F120371);
		SetRegByI2C_Byte4(0x0F1204B0);
		SetRegByI2C_Byte4(0x0F1202E5);
		SetRegByI2C_Byte4(0x0F120481);
		SetRegByI2C_Byte4(0x0F120298);
		SetRegByI2C_Byte4(0x0F12042E);
		SetRegByI2C_Byte4(0x0F120260);
		SetRegByI2C_Byte4(0x0F1203DE);
		SetRegByI2C_Byte4(0x0F12022F);
		SetRegByI2C_Byte4(0x0F120391);
		SetRegByI2C_Byte4(0x0F120201);
		SetRegByI2C_Byte4(0x0F12034D);
		SetRegByI2C_Byte4(0x0F1201DA);
		SetRegByI2C_Byte4(0x0F120310);
		SetRegByI2C_Byte4(0x0F1201B3);
		SetRegByI2C_Byte4(0x0F1202D4);
		SetRegByI2C_Byte4(0x0F12018F);
		SetRegByI2C_Byte4(0x0F120297);
		SetRegByI2C_Byte4(0x0F120181);
		SetRegByI2C_Byte4(0x0F120271);
		SetRegByI2C_Byte4(0x0F120181);
		SetRegByI2C_Byte4(0x0F12022A);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		//	param_end	awbb_LowBrGrZones_m_BGrid
		SetRegByI2C_Byte4(0x0F120006);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0DF0);
		SetRegByI2C_Byte4(0x0F120081);
		SetRegByI2C_Byte4(0x0F120000);
		//	param_start	awbb_OutdoorGrZones_m_BGrid
		SetRegByI2C_Byte4(0x002A0D08);
		SetRegByI2C_Byte4(0x0F120259);
		SetRegByI2C_Byte4(0x0F120268);
		SetRegByI2C_Byte4(0x0F12024F);
		SetRegByI2C_Byte4(0x0F12026C);
		SetRegByI2C_Byte4(0x0F120246);
		SetRegByI2C_Byte4(0x0F12026B);
		SetRegByI2C_Byte4(0x0F120240);
		SetRegByI2C_Byte4(0x0F120266);
		SetRegByI2C_Byte4(0x0F120239);
		SetRegByI2C_Byte4(0x0F12025E);
		SetRegByI2C_Byte4(0x0F120232);
		SetRegByI2C_Byte4(0x0F120258);
		SetRegByI2C_Byte4(0x0F12022D);
		SetRegByI2C_Byte4(0x0F120253);
		SetRegByI2C_Byte4(0x0F120227);
		SetRegByI2C_Byte4(0x0F12024D);
		SetRegByI2C_Byte4(0x0F120223);
		SetRegByI2C_Byte4(0x0F120247);
		SetRegByI2C_Byte4(0x0F12021F);
		SetRegByI2C_Byte4(0x0F120241);
		SetRegByI2C_Byte4(0x0F120219);
		SetRegByI2C_Byte4(0x0F12023C);
		SetRegByI2C_Byte4(0x0F120215);
		SetRegByI2C_Byte4(0x0F120236);
		SetRegByI2C_Byte4(0x0F120210);
		SetRegByI2C_Byte4(0x0F120231);
		SetRegByI2C_Byte4(0x0F12020B);
		SetRegByI2C_Byte4(0x0F12022D);
		SetRegByI2C_Byte4(0x0F120208);
		SetRegByI2C_Byte4(0x0F120227);
		SetRegByI2C_Byte4(0x0F120205);
		SetRegByI2C_Byte4(0x0F120220);
		SetRegByI2C_Byte4(0x0F120206);
		SetRegByI2C_Byte4(0x0F120216);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		//	param_end	awbb_OutdoorGrZones_m_BGrid
		SetRegByI2C_Byte4(0x0F120003);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0D74);
		SetRegByI2C_Byte4(0x0F12024C);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0E00);
		SetRegByI2C_Byte4(0x0F12034A);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120176);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F1271B8);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0E1A);
		SetRegByI2C_Byte4(0x0F12012F);
		SetRegByI2C_Byte4(0x0F120120);

		// awbb_LowTempRB
		SetRegByI2C_Byte4(0x002A0E68);
		SetRegByI2C_Byte4(0x0F1204F2);


		SetRegByI2C_Byte4(0x002A0E42);
		SetRegByI2C_Byte4(0x0F120002);

		SetRegByI2C_Byte4(0x002A0EE0);
		SetRegByI2C_Byte4(0x0F1200B5);	//
		SetRegByI2C_Byte4(0x0F1200B5);	//
		SetRegByI2C_Byte4(0x002A0ED0);
		SetRegByI2C_Byte4(0x0F120FA6);	//
		SetRegByI2C_Byte4(0x0F121000);	//
		SetRegByI2C_Byte4(0x0F121064);	//
		SetRegByI2C_Byte4(0x0F12111F);	//
		SetRegByI2C_Byte4(0x0F121151);	//
		SetRegByI2C_Byte4(0x0F1211BF);	//
		SetRegByI2C_Byte4(0x0F1200B8);	//
		SetRegByI2C_Byte4(0x0F1200B2);	//
		SetRegByI2C_Byte4(0x002A0ECA);
		SetRegByI2C_Byte4(0x0F120308);	//
		SetRegByI2C_Byte4(0x0F120344);	//
		SetRegByI2C_Byte4(0x0F120380);	//


		SetRegByI2C_Byte4(0x002A0E82);
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[0][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[0][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[0][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[0][3]
		SetRegByI2C_Byte4(0x0F120060);	// awbb_GridCorr_R[0][4]
		SetRegByI2C_Byte4(0x0F120170);	// awbb_GridCorr_R[0][5]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[1][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[1][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[1][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[1][3]
		SetRegByI2C_Byte4(0x0F120060);	// awbb_GridCorr_R[1][4]
		SetRegByI2C_Byte4(0x0F120170);	// awbb_GridCorr_R[1][5]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[2][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[2][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[2][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_R[2][3]
		SetRegByI2C_Byte4(0x0F120060);	// awbb_GridCorr_R[2][4]
		SetRegByI2C_Byte4(0x0F120170);	// awbb_GridCorr_R[2][5]

		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][3]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][4]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[0][5]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][3]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][4]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[1][5]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][0]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][1]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][2]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][3]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][4]
		SetRegByI2C_Byte4(0x0F120000);	// awbb_GridCorr_B[2][5]



		//	param_start	SARR_usGammaLutRGBIndoor
		SetRegByI2C_Byte4(0x002A04C8);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120009);
		SetRegByI2C_Byte4(0x0F120018);
		SetRegByI2C_Byte4(0x0F1200B8);
		SetRegByI2C_Byte4(0x0F120139);
		SetRegByI2C_Byte4(0x0F120188);
		SetRegByI2C_Byte4(0x0F1201DF);
		SetRegByI2C_Byte4(0x0F12022D);
		SetRegByI2C_Byte4(0x0F1202B5);
		SetRegByI2C_Byte4(0x0F120326);
		SetRegByI2C_Byte4(0x0F120376);
		SetRegByI2C_Byte4(0x0F1203AC);
		SetRegByI2C_Byte4(0x0F1203CA);
		SetRegByI2C_Byte4(0x0F1203DE);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120008);
		SetRegByI2C_Byte4(0x0F120010);
		SetRegByI2C_Byte4(0x0F12002D);
		SetRegByI2C_Byte4(0x0F1200C8);
		SetRegByI2C_Byte4(0x0F120139);
		SetRegByI2C_Byte4(0x0F120188);
		SetRegByI2C_Byte4(0x0F1201DF);
		SetRegByI2C_Byte4(0x0F12022D);
		SetRegByI2C_Byte4(0x0F1202B5);
		SetRegByI2C_Byte4(0x0F120326);
		SetRegByI2C_Byte4(0x0F120376);
		SetRegByI2C_Byte4(0x0F1203AC);
		SetRegByI2C_Byte4(0x0F1203CA);
		SetRegByI2C_Byte4(0x0F1203DE);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120004);
		SetRegByI2C_Byte4(0x0F120008);
		SetRegByI2C_Byte4(0x0F120010);
		SetRegByI2C_Byte4(0x0F12002D);
		SetRegByI2C_Byte4(0x0F1200C8);
		SetRegByI2C_Byte4(0x0F120139);
		SetRegByI2C_Byte4(0x0F120188);
		SetRegByI2C_Byte4(0x0F1201DF);
		SetRegByI2C_Byte4(0x0F12022D);
		SetRegByI2C_Byte4(0x0F1202B5);
		SetRegByI2C_Byte4(0x0F120326);
		SetRegByI2C_Byte4(0x0F120376);
		SetRegByI2C_Byte4(0x0F1203AC);
		SetRegByI2C_Byte4(0x0F1203CA);
		SetRegByI2C_Byte4(0x0F1203DE);
		//	param_end	SARR_usGammaLutRGBIndoor


		SetRegByI2C_Byte4(0x002A1000);
		SetRegByI2C_Byte4(0x0F12003E);	//0036

		SetRegByI2C_Byte4(0x002A108E);
		SetRegByI2C_Byte4(0x0F1200C7);
		SetRegByI2C_Byte4(0x0F1200F7);
		SetRegByI2C_Byte4(0x0F120107);
		SetRegByI2C_Byte4(0x0F120142);
		SetRegByI2C_Byte4(0x0F12017A);
		SetRegByI2C_Byte4(0x0F1201A0);
		SetRegByI2C_Byte4(0x0F1201B6);

		SetRegByI2C_Byte4(0x0F120100);	// 0112
		SetRegByI2C_Byte4(0x0F120100);	// 0122
		SetRegByI2C_Byte4(0x0F120100);	// 0136
		SetRegByI2C_Byte4(0x0F120100);	// 00F6
		SetRegByI2C_Byte4(0x0F120100);	// 0100
		SetRegByI2C_Byte4(0x0F120100);	// 00FE
		SetRegByI2C_Byte4(0x0F120100);	// 0100

		//	param_start	TVAR_wbt_pBaseCcms
		SetRegByI2C_Byte4(0x002A23A4);
		SetRegByI2C_Byte4(0x0F120204);	//01AF	//01C5 	//H
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFD5	//FFB8
		SetRegByI2C_Byte4(0x0F12FFF3);	//001D	//FFEA
		SetRegByI2C_Byte4(0x0F1200DA);	//005F	//0199
		SetRegByI2C_Byte4(0x0F120154);	//00F6	//00DE
		SetRegByI2C_Byte4(0x0F12FF6D);	//FF46	//FEDE
		SetRegByI2C_Byte4(0x0F12FEF9);	//FF2D	//FF58
		SetRegByI2C_Byte4(0x0F120209);	//016B	//0214
		SetRegByI2C_Byte4(0x0F12FF3C);	//FF83	//FF2C
		SetRegByI2C_Byte4(0x0F12FF2C);	//FF0F	//FEBC
		SetRegByI2C_Byte4(0x0F1200E7);	//019A	//01CC
		SetRegByI2C_Byte4(0x0F1200A5);	//0117	//00BC
		SetRegByI2C_Byte4(0x0F12FFBE);	//0005	//FFE4
		SetRegByI2C_Byte4(0x0F12FFDE);	//0020	//0004
		SetRegByI2C_Byte4(0x0F12020A);	//01CC	//01FF
		SetRegByI2C_Byte4(0x0F1200D4);	//0140	//016E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF46	//FF56
		SetRegByI2C_Byte4(0x0F1201E8);	//0136	//01BD

		SetRegByI2C_Byte4(0x0F120204);	//01C5    //A
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFB8
		SetRegByI2C_Byte4(0x0F12FFF3);	//FFEA
		SetRegByI2C_Byte4(0x0F1200DA);	//0199
		SetRegByI2C_Byte4(0x0F120154);	//00DE
		SetRegByI2C_Byte4(0x0F12FF6D);	//FEDE
		SetRegByI2C_Byte4(0x0F12FEF9);	//FF58
		SetRegByI2C_Byte4(0x0F120209);	//0214
		SetRegByI2C_Byte4(0x0F12FF3C);	//FF2C
		SetRegByI2C_Byte4(0x0F12FF2C);	//FEBC
		SetRegByI2C_Byte4(0x0F1200E7);	//01CC
		SetRegByI2C_Byte4(0x0F1200A5);	//00BC
		SetRegByI2C_Byte4(0x0F12FFBE);	//FFE4
		SetRegByI2C_Byte4(0x0F12FFDE);	//0004
		SetRegByI2C_Byte4(0x0F12020A);	//01FF
		SetRegByI2C_Byte4(0x0F1200D4);	//016E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF56
		SetRegByI2C_Byte4(0x0F1201E8);	//01BD

		SetRegByI2C_Byte4(0x0F120204);	//01C5	//WW
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFB8
		SetRegByI2C_Byte4(0x0F12FFF3);	//FFEA
		SetRegByI2C_Byte4(0x0F1200DA);	//0199
		SetRegByI2C_Byte4(0x0F120154);	//00DE
		SetRegByI2C_Byte4(0x0F12FF6D);	//FEDE
		SetRegByI2C_Byte4(0x0F12FEF9);	//FF58
		SetRegByI2C_Byte4(0x0F120209);	//0214
		SetRegByI2C_Byte4(0x0F12FF3C);	//FF2C
		SetRegByI2C_Byte4(0x0F12FF2C);	//FEBC
		SetRegByI2C_Byte4(0x0F1200E7);	//01CC
		SetRegByI2C_Byte4(0x0F1200A5);	//00BC
		SetRegByI2C_Byte4(0x0F12FFBE);	//FFE4
		SetRegByI2C_Byte4(0x0F12FFDE);	//0004
		SetRegByI2C_Byte4(0x0F12020A);	//01FF
		SetRegByI2C_Byte4(0x0F1200D4);	//016E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF56
		SetRegByI2C_Byte4(0x0F1201E8);	//01BD

		SetRegByI2C_Byte4(0x0F120204);	//01C5	//CW
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFB8
		SetRegByI2C_Byte4(0x0F12FFF3);	//FFEA
		SetRegByI2C_Byte4(0x0F1200DA);	//0199
		SetRegByI2C_Byte4(0x0F120154);	//00DE
		SetRegByI2C_Byte4(0x0F12FF6D);	//FEDE
		SetRegByI2C_Byte4(0x0F12FEF9);	//FF58
		SetRegByI2C_Byte4(0x0F120209);	//0214
		SetRegByI2C_Byte4(0x0F12FF3C);	//FF2C
		SetRegByI2C_Byte4(0x0F12FF2C);	//FEBC
		SetRegByI2C_Byte4(0x0F1200E7);	//01CC
		SetRegByI2C_Byte4(0x0F1200A5);	//00BC
		SetRegByI2C_Byte4(0x0F12FFBE);	//FFE4
		SetRegByI2C_Byte4(0x0F12FFDE);	//0004
		SetRegByI2C_Byte4(0x0F12020A);	//01FF
		SetRegByI2C_Byte4(0x0F1200D4);	//016E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF56
		SetRegByI2C_Byte4(0x0F1201E8);	//01BD


		SetRegByI2C_Byte4(0x0F120204);	//01C5	//D50
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFB8
		SetRegByI2C_Byte4(0x0F12FFF3);	//FFEA
		SetRegByI2C_Byte4(0x0F1200DA);	//0199
		SetRegByI2C_Byte4(0x0F120154);	//00DE
		SetRegByI2C_Byte4(0x0F12FF6D);	//FEDE
		SetRegByI2C_Byte4(0x0F12FEF9);	//FF58
		SetRegByI2C_Byte4(0x0F120209);	//0214
		SetRegByI2C_Byte4(0x0F12FF3C);	//FF2C
		SetRegByI2C_Byte4(0x0F12FF2C);	//FEBC
		SetRegByI2C_Byte4(0x0F1200E7);	//01CC
		SetRegByI2C_Byte4(0x0F1200A5);	//00BC
		SetRegByI2C_Byte4(0x0F12FFBE);	//FFE4
		SetRegByI2C_Byte4(0x0F12FFDE);	//0004
		SetRegByI2C_Byte4(0x0F12020A);	//01FF
		SetRegByI2C_Byte4(0x0F1200D4);	//016E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF56
		SetRegByI2C_Byte4(0x0F1201E8);	//01BD

		SetRegByI2C_Byte4(0x0F120204);	//0173	//D65
		SetRegByI2C_Byte4(0x0F12FFA2);	//FFCE
		SetRegByI2C_Byte4(0x0F12FFF3);	//FFF8
		SetRegByI2C_Byte4(0x0F1200DA);	//00DC
		SetRegByI2C_Byte4(0x0F120154);	//00F7
		SetRegByI2C_Byte4(0x0F12FF6D);	//FF6F
		SetRegByI2C_Byte4(0x0F12FEF9);	//FEF0
		SetRegByI2C_Byte4(0x0F120209);	//01CA
		SetRegByI2C_Byte4(0x0F12FF3C);	//FFA2
		SetRegByI2C_Byte4(0x0F12FF2C);	//FEDF
		SetRegByI2C_Byte4(0x0F1200E7);	//0172
		SetRegByI2C_Byte4(0x0F1200A5);	//00C6
		SetRegByI2C_Byte4(0x0F12FFBE);	//FFE8
		SetRegByI2C_Byte4(0x0F12FFDE);	//FFE8
		SetRegByI2C_Byte4(0x0F12020A);	//01A4
		SetRegByI2C_Byte4(0x0F1200D4);	//013E
		SetRegByI2C_Byte4(0x0F12FF55);	//FF62
		SetRegByI2C_Byte4(0x0F1201E8);	//0136
		//	param_end	TVAR_wbt_pBaseCcms

		//	param_start	TVAR_wbt_pOutdoorCcm
		SetRegByI2C_Byte4(0x002A2380);
		SetRegByI2C_Byte4(0x0F1201F0);	//019D
		SetRegByI2C_Byte4(0x0F12FFAE);	//FFC8
		SetRegByI2C_Byte4(0x0F12FFFA);	//000C
		SetRegByI2C_Byte4(0x0F1200F9);	//008D
		SetRegByI2C_Byte4(0x0F12013F);	//00CD
		SetRegByI2C_Byte4(0x0F12FF6E);	//FF3F
		SetRegByI2C_Byte4(0x0F12FECD);	//FEDD
		SetRegByI2C_Byte4(0x0F120230);	//01C6
		SetRegByI2C_Byte4(0x0F12FF7F);	//FF77
		SetRegByI2C_Byte4(0x0F12FF37);	//FEAB
		SetRegByI2C_Byte4(0x0F1201A2);	//015D
		SetRegByI2C_Byte4(0x0F120126);	//0082
		SetRegByI2C_Byte4(0x0F12FFE0);	//FFCA
		SetRegByI2C_Byte4(0x0F12FFBF);	//FFA2
		SetRegByI2C_Byte4(0x0F1201E6);	//016F
		SetRegByI2C_Byte4(0x0F120186);	//0171
		SetRegByI2C_Byte4(0x0F12FF4B);	//FF35
		SetRegByI2C_Byte4(0x0F1201B1);	//013E
		//	param_end	TVAR_wbt_pOutdoorCcm

		SetRegByI2C_Byte4(0x002A06D4);
		SetRegByI2C_Byte4(0x0F122380);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x002A06CC);
		SetRegByI2C_Byte4(0x0F1223A4);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x002A06E8);
		SetRegByI2C_Byte4(0x0F1223A4);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1223C8);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F1223EC);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F122410);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F122434);
		SetRegByI2C_Byte4(0x0F127000);
		SetRegByI2C_Byte4(0x0F122458);
		SetRegByI2C_Byte4(0x0F127000);

		SetRegByI2C_Byte4(0x002A06DA);
		SetRegByI2C_Byte4(0x0F1200BF);	//SARR_AwbCcmCord[0]                        	2   700006DA
		SetRegByI2C_Byte4(0x0F1200E6);	//SARR_AwbCcmCord[1]                        	2   700006DC
		SetRegByI2C_Byte4(0x0F1200F2);	//SARR_AwbCcmCord[2]                        	2   700006DE
		SetRegByI2C_Byte4(0x0F120143);	//SARR_AwbCcmCord[3]                        	2   700006E0
		SetRegByI2C_Byte4(0x0F120178);	//SARR_AwbCcmCord[4]                        	2   700006E2
		SetRegByI2C_Byte4(0x0F1201A3);	//SARR_AwbCcmCord[5]                        	2   700006E4

		//	param_start	SARR_uNormBrInDoor
		SetRegByI2C_Byte4(0x002A07E8);
		SetRegByI2C_Byte4(0x0F12000A);	//SARR_uNormBrInDoor[0]
		SetRegByI2C_Byte4(0x0F120019);	//SARR_uNormBrInDoor[1]
		SetRegByI2C_Byte4(0x0F120096);	//SARR_uNormBrInDoor[2]
		SetRegByI2C_Byte4(0x0F1201F4);	//SARR_uNormBrInDoor[3]
		SetRegByI2C_Byte4(0x0F1207D0);	//SARR_uNormBrInDoor[4]
		//	param_end	SARR_uNormBrInDoor
		//	param_start	afit_uNoiseIndInDoor
		SetRegByI2C_Byte4(0x002A07D0);
		SetRegByI2C_Byte4(0x0F120030);	//afit_uNoiseIndInDoor[0]
		SetRegByI2C_Byte4(0x0F120046);	//afit_uNoiseIndInDoor[1]
		SetRegByI2C_Byte4(0x0F120088);	//afit_uNoiseIndInDoor[2]
		SetRegByI2C_Byte4(0x0F120205);	//afit_uNoiseIndInDoor[3]
		SetRegByI2C_Byte4(0x0F1202BC);	//afit_uNoiseIndInDoor[4]
		//	param_end	afit_uNoiseIndInDoor
		SetRegByI2C_Byte4(0x002A07E6);
		SetRegByI2C_Byte4(0x0F120000);	//afit_bUseNoiseInd
		//	param_start	TVAR_afit_pBaseVals
		SetRegByI2C_Byte4(0x002A0828);
		SetRegByI2C_Byte4(0x0F120010);	//TVAR_afit_pBaseVals[0]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[1]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[2]
		SetRegByI2C_Byte4(0x0F12FFE2);	//TVAR_afit_pBaseVals[3]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[4]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[5]
		SetRegByI2C_Byte4(0x0F1200FF);	//TVAR_afit_pBaseVals[6]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[7]
		SetRegByI2C_Byte4(0x0F1200FF);	//TVAR_afit_pBaseVals[8]
		SetRegByI2C_Byte4(0x0F1200FF);	//TVAR_afit_pBaseVals[9]
		SetRegByI2C_Byte4(0x0F120129);	//TVAR_afit_pBaseVals[10]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[11]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[12]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[13]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[14]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[15]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[16]
		SetRegByI2C_Byte4(0x0F120344);	//TVAR_afit_pBaseVals[17]
		SetRegByI2C_Byte4(0x0F12033A);	//TVAR_afit_pBaseVals[18]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[19]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[20]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[21]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[22]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[23]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[24]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[25]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[26]
		SetRegByI2C_Byte4(0x0F120046);	//TVAR_afit_pBaseVals[27]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[28]
		SetRegByI2C_Byte4(0x0F120106);	//TVAR_afit_pBaseVals[29]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_afit_pBaseVals[30]
		SetRegByI2C_Byte4(0x0F120C0F);	//TVAR_afit_pBaseVals[31]
		SetRegByI2C_Byte4(0x0F120C0F);	//TVAR_afit_pBaseVals[32]
		SetRegByI2C_Byte4(0x0F120303);	//TVAR_afit_pBaseVals[33]
		SetRegByI2C_Byte4(0x0F120303);	//TVAR_afit_pBaseVals[34]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[35]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[36]
		SetRegByI2C_Byte4(0x0F122828);	//TVAR_afit_pBaseVals[37]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[38]
		SetRegByI2C_Byte4(0x0F12020A);	//TVAR_afit_pBaseVals[39]
		SetRegByI2C_Byte4(0x0F120480);	//TVAR_afit_pBaseVals[40]
		SetRegByI2C_Byte4(0x0F120E08);	//TVAR_afit_pBaseVals[41]
		SetRegByI2C_Byte4(0x0F12030A);	//TVAR_afit_pBaseVals[42]
		SetRegByI2C_Byte4(0x0F121403);	//TVAR_afit_pBaseVals[43]
		SetRegByI2C_Byte4(0x0F120A11);	//TVAR_afit_pBaseVals[44]
		SetRegByI2C_Byte4(0x0F120A0F);	//TVAR_afit_pBaseVals[45]
		SetRegByI2C_Byte4(0x0F12050A);	//TVAR_afit_pBaseVals[46]
		SetRegByI2C_Byte4(0x0F120914);	//TVAR_afit_pBaseVals[47]
		SetRegByI2C_Byte4(0x0F120012);	//TVAR_afit_pBaseVals[48]
		SetRegByI2C_Byte4(0x0F124040);	//TVAR_afit_pBaseVals[49]
		SetRegByI2C_Byte4(0x0F120005);	//TVAR_afit_pBaseVals[50]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[51]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[52]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[53]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[54]
		SetRegByI2C_Byte4(0x0F120A00);	//TVAR_afit_pBaseVals[55]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[56]
		SetRegByI2C_Byte4(0x0F120143);	//TVAR_afit_pBaseVals[57]
		SetRegByI2C_Byte4(0x0F12014D);	//TVAR_afit_pBaseVals[58]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_afit_pBaseVals[59]
		SetRegByI2C_Byte4(0x0F128030);	//TVAR_afit_pBaseVals[60]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[61]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[62]
		SetRegByI2C_Byte4(0x0F120010);	//TVAR_afit_pBaseVals[63]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[64]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[65]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[66]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[67]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[68]
		SetRegByI2C_Byte4(0x0F120020);	//TVAR_afit_pBaseVals[69]
		SetRegByI2C_Byte4(0x0F12000E);	//TVAR_afit_pBaseVals[70]
		SetRegByI2C_Byte4(0x0F120080);	//TVAR_afit_pBaseVals[71]
		SetRegByI2C_Byte4(0x0F1200FF);	//TVAR_afit_pBaseVals[72]
		SetRegByI2C_Byte4(0x0F120129);	//TVAR_afit_pBaseVals[73]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[74]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[75]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[76]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[77]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[78]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[79]
		SetRegByI2C_Byte4(0x0F120114);	//TVAR_afit_pBaseVals[80]
		SetRegByI2C_Byte4(0x0F12020A);	//TVAR_afit_pBaseVals[81]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[82]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[83]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[84]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[85]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[86]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[87]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[88]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[89]
		SetRegByI2C_Byte4(0x0F1200A0);	//TVAR_afit_pBaseVals[90]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[91]
		SetRegByI2C_Byte4(0x0F120106);	//TVAR_afit_pBaseVals[92]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_afit_pBaseVals[93]
		SetRegByI2C_Byte4(0x0F12050F);	//TVAR_afit_pBaseVals[94]
		SetRegByI2C_Byte4(0x0F120A0F);	//TVAR_afit_pBaseVals[95]
		SetRegByI2C_Byte4(0x0F120203);	//TVAR_afit_pBaseVals[96]
		SetRegByI2C_Byte4(0x0F120203);	//TVAR_afit_pBaseVals[97]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[98]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[99]
		SetRegByI2C_Byte4(0x0F122828);	//TVAR_afit_pBaseVals[100]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[101]
		SetRegByI2C_Byte4(0x0F12020A);	//TVAR_afit_pBaseVals[102]
		SetRegByI2C_Byte4(0x0F120480);	//TVAR_afit_pBaseVals[103]
		SetRegByI2C_Byte4(0x0F120E08);	//TVAR_afit_pBaseVals[104]
		SetRegByI2C_Byte4(0x0F12030A);	//TVAR_afit_pBaseVals[105]
		SetRegByI2C_Byte4(0x0F120A03);	//TVAR_afit_pBaseVals[106]
		SetRegByI2C_Byte4(0x0F120A11);	//TVAR_afit_pBaseVals[107]
		SetRegByI2C_Byte4(0x0F12320F);	//TVAR_afit_pBaseVals[108]
		SetRegByI2C_Byte4(0x0F120532);	//TVAR_afit_pBaseVals[109]
		SetRegByI2C_Byte4(0x0F12101E);	//TVAR_afit_pBaseVals[110]
		SetRegByI2C_Byte4(0x0F12101E);	//TVAR_afit_pBaseVals[111]
		SetRegByI2C_Byte4(0x0F123030);	//TVAR_afit_pBaseVals[112]
		SetRegByI2C_Byte4(0x0F120005);	//TVAR_afit_pBaseVals[113]
		SetRegByI2C_Byte4(0x0F120400);	//TVAR_afit_pBaseVals[114]
		SetRegByI2C_Byte4(0x0F120400);	//TVAR_afit_pBaseVals[115]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[116]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[117]
		SetRegByI2C_Byte4(0x0F120A00);	//TVAR_afit_pBaseVals[118]
		SetRegByI2C_Byte4(0x0F12100A);	//TVAR_afit_pBaseVals[119]
		SetRegByI2C_Byte4(0x0F120168);	//TVAR_afit_pBaseVals[120]
		SetRegByI2C_Byte4(0x0F120154);	//TVAR_afit_pBaseVals[121]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_afit_pBaseVals[122]
		SetRegByI2C_Byte4(0x0F128030);	//TVAR_afit_pBaseVals[123]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[124]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[125]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[126]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[127]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[128]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[129]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[130]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[131]
		SetRegByI2C_Byte4(0x0F12000E);	//TVAR_afit_pBaseVals[132]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_afit_pBaseVals[133]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_afit_pBaseVals[134]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[135]
		SetRegByI2C_Byte4(0x0F120002);	//TVAR_afit_pBaseVals[136]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[137]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[138]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[139]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[140]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[141]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[142]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[143]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[144]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[145]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[146]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[147]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[148]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[149]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[150]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[151]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[152]
		SetRegByI2C_Byte4(0x0F120010);	//TVAR_afit_pBaseVals[153]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[154]
		SetRegByI2C_Byte4(0x0F120106);	//TVAR_afit_pBaseVals[155]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_afit_pBaseVals[156]
		SetRegByI2C_Byte4(0x0F120202);	//TVAR_afit_pBaseVals[157]
		SetRegByI2C_Byte4(0x0F120502);	//TVAR_afit_pBaseVals[158]
		SetRegByI2C_Byte4(0x0F120101);	//TVAR_afit_pBaseVals[159]
		SetRegByI2C_Byte4(0x0F120102);	//TVAR_afit_pBaseVals[160]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[161]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[162]
		SetRegByI2C_Byte4(0x0F122828);	//TVAR_afit_pBaseVals[163]
		SetRegByI2C_Byte4(0x0F120606);	//TVAR_afit_pBaseVals[164]
		SetRegByI2C_Byte4(0x0F120205);	//TVAR_afit_pBaseVals[165]
		SetRegByI2C_Byte4(0x0F120480);	//TVAR_afit_pBaseVals[166]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_afit_pBaseVals[167]
		SetRegByI2C_Byte4(0x0F120005);	//TVAR_afit_pBaseVals[168]
		SetRegByI2C_Byte4(0x0F121903);	//TVAR_afit_pBaseVals[169]
		SetRegByI2C_Byte4(0x0F121911);	//TVAR_afit_pBaseVals[170]
		SetRegByI2C_Byte4(0x0F120A0F);	//TVAR_afit_pBaseVals[171]
		SetRegByI2C_Byte4(0x0F12050A);	//TVAR_afit_pBaseVals[172]
		SetRegByI2C_Byte4(0x0F122028);	//TVAR_afit_pBaseVals[173]
		SetRegByI2C_Byte4(0x0F122028);	//TVAR_afit_pBaseVals[174]
		SetRegByI2C_Byte4(0x0F122000);	//TVAR_afit_pBaseVals[175]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_afit_pBaseVals[176]
		SetRegByI2C_Byte4(0x0F120403);	//TVAR_afit_pBaseVals[177]
		SetRegByI2C_Byte4(0x0F120402);	//TVAR_afit_pBaseVals[178]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[179]
		SetRegByI2C_Byte4(0x0F120203);	//TVAR_afit_pBaseVals[180]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[181]
		SetRegByI2C_Byte4(0x0F121006);	//TVAR_afit_pBaseVals[182]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[183]
		SetRegByI2C_Byte4(0x0F120173);	//TVAR_afit_pBaseVals[184]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_afit_pBaseVals[185]
		SetRegByI2C_Byte4(0x0F12803C);	//TVAR_afit_pBaseVals[186]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[187]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[188]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[189]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[190]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[191]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[192]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[193]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[194]
		SetRegByI2C_Byte4(0x0F120008);	//TVAR_afit_pBaseVals[195]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_afit_pBaseVals[196]
		SetRegByI2C_Byte4(0x0F120064);	//TVAR_afit_pBaseVals[197]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[198]
		SetRegByI2C_Byte4(0x0F120002);	//TVAR_afit_pBaseVals[199]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[200]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[201]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[202]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[203]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[204]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[205]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[206]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[207]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[208]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[209]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[210]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[211]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[212]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[213]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[214]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[215]
		SetRegByI2C_Byte4(0x0F120010);	//TVAR_afit_pBaseVals[216]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[217]
		SetRegByI2C_Byte4(0x0F120106);	//TVAR_afit_pBaseVals[218]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_afit_pBaseVals[219]
		SetRegByI2C_Byte4(0x0F120202);	//TVAR_afit_pBaseVals[220]
		SetRegByI2C_Byte4(0x0F120502);	//TVAR_afit_pBaseVals[221]
		SetRegByI2C_Byte4(0x0F120101);	//TVAR_afit_pBaseVals[222]
		SetRegByI2C_Byte4(0x0F120102);	//TVAR_afit_pBaseVals[223]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[224]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[225]
		SetRegByI2C_Byte4(0x0F122828);	//TVAR_afit_pBaseVals[226]
		SetRegByI2C_Byte4(0x0F120606);	//TVAR_afit_pBaseVals[227]
		SetRegByI2C_Byte4(0x0F120205);	//TVAR_afit_pBaseVals[228]
		SetRegByI2C_Byte4(0x0F120480);	//TVAR_afit_pBaseVals[229]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_afit_pBaseVals[230]
		SetRegByI2C_Byte4(0x0F120005);	//TVAR_afit_pBaseVals[231]
		SetRegByI2C_Byte4(0x0F122803);	//TVAR_afit_pBaseVals[232]
		SetRegByI2C_Byte4(0x0F122811);	//TVAR_afit_pBaseVals[233]
		SetRegByI2C_Byte4(0x0F120A0F);	//TVAR_afit_pBaseVals[234]
		SetRegByI2C_Byte4(0x0F12050A);	//TVAR_afit_pBaseVals[235]
		SetRegByI2C_Byte4(0x0F122028);	//TVAR_afit_pBaseVals[236]
		SetRegByI2C_Byte4(0x0F122028);	//TVAR_afit_pBaseVals[237]
		SetRegByI2C_Byte4(0x0F122000);	//TVAR_afit_pBaseVals[238]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_afit_pBaseVals[239]
		SetRegByI2C_Byte4(0x0F120403);	//TVAR_afit_pBaseVals[240]
		SetRegByI2C_Byte4(0x0F120402);	//TVAR_afit_pBaseVals[241]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[242]
		SetRegByI2C_Byte4(0x0F120203);	//TVAR_afit_pBaseVals[243]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[244]
		SetRegByI2C_Byte4(0x0F121006);	//TVAR_afit_pBaseVals[245]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[246]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[247]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_afit_pBaseVals[248]
		SetRegByI2C_Byte4(0x0F12803C);	//TVAR_afit_pBaseVals[249]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[250]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[251]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[252]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[253]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[254]
		SetRegByI2C_Byte4(0x0F120014);	//TVAR_afit_pBaseVals[255]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[256]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[257]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_afit_pBaseVals[258]
		SetRegByI2C_Byte4(0x0F120006);	//TVAR_afit_pBaseVals[259]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[260]
		SetRegByI2C_Byte4(0x0F120050);	//TVAR_afit_pBaseVals[261]
		SetRegByI2C_Byte4(0x0F120002);	//TVAR_afit_pBaseVals[262]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[263]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[264]
		SetRegByI2C_Byte4(0x0F12000A);	//TVAR_afit_pBaseVals[265]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[266]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[267]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[268]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[269]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[270]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[271]
		SetRegByI2C_Byte4(0x0F1203FF);	//TVAR_afit_pBaseVals[272]
		SetRegByI2C_Byte4(0x0F120028);	//TVAR_afit_pBaseVals[273]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[274]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[275]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[276]
		SetRegByI2C_Byte4(0x0F120030);	//TVAR_afit_pBaseVals[277]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[278]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[279]
		SetRegByI2C_Byte4(0x0F120032);	//TVAR_afit_pBaseVals[280]
		SetRegByI2C_Byte4(0x0F120106);	//TVAR_afit_pBaseVals[281]
		SetRegByI2C_Byte4(0x0F12006F);	//TVAR_afit_pBaseVals[282]
		SetRegByI2C_Byte4(0x0F120202);	//TVAR_afit_pBaseVals[283]
		SetRegByI2C_Byte4(0x0F120502);	//TVAR_afit_pBaseVals[284]
		SetRegByI2C_Byte4(0x0F120101);	//TVAR_afit_pBaseVals[285]
		SetRegByI2C_Byte4(0x0F120101);	//TVAR_afit_pBaseVals[286]
		SetRegByI2C_Byte4(0x0F12FFFF);	//TVAR_afit_pBaseVals[287]
		SetRegByI2C_Byte4(0x0F12140A);	//TVAR_afit_pBaseVals[288]
		SetRegByI2C_Byte4(0x0F122828);	//TVAR_afit_pBaseVals[289]
		SetRegByI2C_Byte4(0x0F120606);	//TVAR_afit_pBaseVals[290]
		SetRegByI2C_Byte4(0x0F120205);	//TVAR_afit_pBaseVals[291]
		SetRegByI2C_Byte4(0x0F120880);	//TVAR_afit_pBaseVals[292]
		SetRegByI2C_Byte4(0x0F12000F);	//TVAR_afit_pBaseVals[293]
		SetRegByI2C_Byte4(0x0F120005);	//TVAR_afit_pBaseVals[294]
		SetRegByI2C_Byte4(0x0F122803);	//TVAR_afit_pBaseVals[295]
		SetRegByI2C_Byte4(0x0F122811);	//TVAR_afit_pBaseVals[296]
		SetRegByI2C_Byte4(0x0F120A0F);	//TVAR_afit_pBaseVals[297]
		SetRegByI2C_Byte4(0x0F12050A);	//TVAR_afit_pBaseVals[298]
		SetRegByI2C_Byte4(0x0F122020);	//TVAR_afit_pBaseVals[299]
		SetRegByI2C_Byte4(0x0F122020);	//TVAR_afit_pBaseVals[300]
		SetRegByI2C_Byte4(0x0F126400);	//TVAR_afit_pBaseVals[301]
		SetRegByI2C_Byte4(0x0F120007);	//TVAR_afit_pBaseVals[302]
		SetRegByI2C_Byte4(0x0F120408);	//TVAR_afit_pBaseVals[303]
		SetRegByI2C_Byte4(0x0F120406);	//TVAR_afit_pBaseVals[304]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[305]
		SetRegByI2C_Byte4(0x0F120608);	//TVAR_afit_pBaseVals[306]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[307]
		SetRegByI2C_Byte4(0x0F121006);	//TVAR_afit_pBaseVals[308]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[309]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[310]
		SetRegByI2C_Byte4(0x0F120100);	//TVAR_afit_pBaseVals[311]
		SetRegByI2C_Byte4(0x0F128050);	//TVAR_afit_pBaseVals[312]
		SetRegByI2C_Byte4(0x0F120180);	//TVAR_afit_pBaseVals[313]
		SetRegByI2C_Byte4(0x0F120000);	//TVAR_afit_pBaseVals[314]
		//	param_end	TVAR_afit_pBaseVals
		//	param_start	afit_pConstBaseVals
		SetRegByI2C_Byte4(0x0F1200FF);	//afit_pConstBaseVals[0]
		SetRegByI2C_Byte4(0x0F1200FF);	//afit_pConstBaseVals[1]
		SetRegByI2C_Byte4(0x0F120800);	//afit_pConstBaseVals[2]
		SetRegByI2C_Byte4(0x0F120600);	//afit_pConstBaseVals[3]
		SetRegByI2C_Byte4(0x0F120000);	//afit_pConstBaseVals[4]
		SetRegByI2C_Byte4(0x0F120000);	//afit_pConstBaseVals[5]
		SetRegByI2C_Byte4(0x0F120000);	//afit_pConstBaseVals[6]
		SetRegByI2C_Byte4(0x0F120300);	//afit_pConstBaseVals[7]
		SetRegByI2C_Byte4(0x0F120002);	//afit_pConstBaseVals[8]
		SetRegByI2C_Byte4(0x0F120400);	//afit_pConstBaseVals[9]
		SetRegByI2C_Byte4(0x0F120106);	//afit_pConstBaseVals[10]
		SetRegByI2C_Byte4(0x0F120005);	//afit_pConstBaseVals[11]
		SetRegByI2C_Byte4(0x0F120000);	//afit_pConstBaseVals[12]
		SetRegByI2C_Byte4(0x0F120003);	//afit_pConstBaseVals[13]
		SetRegByI2C_Byte4(0x0F120000);	//afit_pConstBaseVals[14]
		SetRegByI2C_Byte4(0x0F12FFD6);	//afit_pConstBaseVals[15]
		SetRegByI2C_Byte4(0x0F1253C1);	//afit_pConstBaseVals[16]//hys off : 4341
		SetRegByI2C_Byte4(0x0F12E1FE);	//afit_pConstBaseVals[17]//mixer on :E0FA
		SetRegByI2C_Byte4(0x0F120001);	//afit_pConstBaseVals[18]
		//	param_end	afit_pConstBaseVals


		SetRegByI2C_Byte4(0x002A0488);
		SetRegByI2C_Byte4(0x0F12416E);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F12A316);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A205C);
		SetRegByI2C_Byte4(0x0F12F424);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x002A0490);
		SetRegByI2C_Byte4(0x0F12416E);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F12A316);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A2060);
		SetRegByI2C_Byte4(0x0F12F424);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x002A0498);
		SetRegByI2C_Byte4(0x0F120180);
		SetRegByI2C_Byte4(0x0F120258);
		SetRegByI2C_Byte4(0x002A2064);
		SetRegByI2C_Byte4(0x0F120500);
		SetRegByI2C_Byte4(0x002A049C);
		SetRegByI2C_Byte4(0x0F120160);


		//WRITE #AWBBTune_EVT4_uMaxExp3     0000
		//WRITE #AWBBTune_EVT4_uCapMaxExp3  0000
		//WRITE #AWBBTune_EVT4_uMaxAnGain3  0000

		SetRegByI2C_Byte4(0x002A2058);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F120090);


		SetRegByI2C_Byte4(0x002A100E);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120201);
		SetRegByI2C_Byte4(0x0F120202);
		SetRegByI2C_Byte4(0x0F120202);
		SetRegByI2C_Byte4(0x0F120102);
		SetRegByI2C_Byte4(0x0F120201);
		SetRegByI2C_Byte4(0x0F120302);
		SetRegByI2C_Byte4(0x0F120203);
		SetRegByI2C_Byte4(0x0F120102);
		SetRegByI2C_Byte4(0x0F120201);
		SetRegByI2C_Byte4(0x0F120302);
		SetRegByI2C_Byte4(0x0F120203);
		SetRegByI2C_Byte4(0x0F120102);
		SetRegByI2C_Byte4(0x0F120201);
		SetRegByI2C_Byte4(0x0F120302);
		SetRegByI2C_Byte4(0x0F120203);
		SetRegByI2C_Byte4(0x0F120102);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120202);
		SetRegByI2C_Byte4(0x0F120202);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);
		SetRegByI2C_Byte4(0x0F120101);

		// End tuning part
		SetRegByI2C_Byte4(0x10000001);	// Set host interrupt so main start run
		Delay(100);	// p10	// Wait10mSec
		// Start user init script

		// End user init script
		SetRegByI2C_Byte4(0x002A0400);
		SetRegByI2C_Byte4(0x0F12005F);
		SetRegByI2C_Byte4(0x002A03DC);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x0F120001);
		///////////////////////////////////////////
		//clk Settings

		SetRegByI2C_Byte4(0x002A01B8);
		SetRegByI2C_Byte4(0x0F125DC0);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A01C6);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A01CC);
		SetRegByI2C_Byte4(0x0F121B58);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F121B58);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x002A01E0);
		SetRegByI2C_Byte4(0x0F120001);
		Delay(1000);	// p100

		///////////////////////////////////////////
		//PREVIEW CONFIGURATION 0 (SXGA, YUV, 15fps)

		SetRegByI2C_Byte4(0x002A0242);
		SetRegByI2C_Byte4(0x0F120500);	//1280
		SetRegByI2C_Byte4(0x0F120400);	//1024
		SetRegByI2C_Byte4(0x0F120005);	//YUV
		SetRegByI2C_Byte4(0x002A024E);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A0248);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F120042);
		SetRegByI2C_Byte4(0x002A0252);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x002A0250);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x002A0254);
		SetRegByI2C_Byte4(0x0F12029A);
		SetRegByI2C_Byte4(0x0F120000);

		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120000);


		///////////////////////////////////////////
		//PREVIEW CONFIGURATION 1 (VGA, YUV, 30fps)

		SetRegByI2C_Byte4(0x0F120280);	//640
		SetRegByI2C_Byte4(0x0F1201E0);	//480
		SetRegByI2C_Byte4(0x0F120005);	//YUV
		SetRegByI2C_Byte4(0x002A0274);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A026E);
		SetRegByI2C_Byte4(0x0F1236B0);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x0F120052);
		SetRegByI2C_Byte4(0x002A0278);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A0276);
		SetRegByI2C_Byte4(0x0F120002);
		SetRegByI2C_Byte4(0x002A027A);
		SetRegByI2C_Byte4(0x0F12014D);
		SetRegByI2C_Byte4(0x0F120000);

		////////////////////////////////////////////////////////
		////////////////////////////////////////////////////////
		//PREVIEW

		SetRegByI2C_Byte4(0x002A03B6);
		SetRegByI2C_Byte4(0x0F120000);
		SetRegByI2C_Byte4(0x002A03FA);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F1200C3);
		SetRegByI2C_Byte4(0x0F120001);


		SetRegByI2C_Byte4(0x002A021C);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A0220);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A01F8);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A021E);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x002A01F0);
		SetRegByI2C_Byte4(0x0F120001);
		SetRegByI2C_Byte4(0x0F120001);
//==================================================
		Delay(2000);
	}
	else
	{
		Assert(0);
	}

	Disp("[6AA]Init End.\n"); 	
}

static void S5K6AA_Sleep(void)
{
	SetRegByI2C_Reg2Data2(0x0028, 0x7000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_setot_usForceClocksSettings);
	SetRegByI2C_Reg2Data2(0x0F12, 0x001E);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_setot_usConfigClocksSettings);
	SetRegByI2C_Reg2Data2(0x0F12, 0x001E);

	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_EnablePreview);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_EnablePreviewChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

	Delay(1000);		//p100

	SetRegByI2C_Reg2Data2(0x0028, 0xD000);
	SetRegByI2C_Reg2Data2(0x002A, 0xB0B0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	Delay(1000);

	SetRegByI2C_Reg2Data2(0x002A, 0xB0B4);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

	SetRegByI2C_Reg2Data2(0x002A, 0xB0A0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0031);

	SetRegByI2C_Reg2Data2(0x002A, 0xB0A0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0010);

	SetRegByI2C_Reg2Data2(0x002A, 0xB0A0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

	SetRegByI2C_Reg2Data2(0x0028, 0x7000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_SleepMode);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_SleepModeChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
}

static void S5K6AA_WakeUp(void)
{
	SetRegByI2C_Reg2Data2(0x0028, 0x7000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_SleepMode);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_SleepModeChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

	SetRegByI2C_Reg2Data2(0x0028, 0xD000);
	SetRegByI2C_Reg2Data2(0x002A, 0x1000);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);

	SetRegByI2C_Reg2Data2(0x002A, 0x003A);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

	Delay(2000);	//p200

	SetRegByI2C_Reg2Data2(0x002A, 0xB0B0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0000);

	SetRegByI2C_Reg2Data2(0x002A, 0xB0A0);
	SetRegByI2C_Reg2Data2(0x0F12, 0x003B);	

	SetRegByI2C_Reg2Data2(0x002A, 0xB0B4);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0800);	

	Delay(100);	// p10

	SetRegByI2C_Reg2Data2(0x0028, 0x7000);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_EnablePreview);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
	SetRegByI2C_Reg2Data2(0x002A, S5K6AA_REG_TC_GP_EnablePreviewChanged);
	SetRegByI2C_Reg2Data2(0x0F12, 0x0001);
}

static void S5K4E1_Init(IMG_FMT eSrcFmt, u32 CamImgWidth, u32 CamImgHeight)
{
	if(eSrcFmt == BayerRGB10)
	{
		Disp("[4E1]BayerRGB10\n"); 
		// ******************* //
		// S5K4E1GX 
		// 
		// last update date : 2009. 02. 04
		//
		// Full size output (2608 x 1960)
		// This Setfile is optimized for 15fps or lower frame rate
		//
		// ******************* //


		//+++++++++++++++++++++++++++++++//
		// Reset for operation ...
		SetRegByI2C_Byte3(0x010000);		// stream off
		SetRegByI2C_Byte3(0x010301); 	// software reset

		//+++++++++++++++++++++++++++++++//
		// Analog Setting

		//// CDS timing setting ...
		SetRegByI2C_Byte3(0x300004);	// ct_ld_start (default = 07h)
		SetRegByI2C_Byte3(0x300102);	// ct_sl_start (default = 05h)
		SetRegByI2C_Byte3(0x30020C);	// ct_rx_start (default = 21h)
		SetRegByI2C_Byte3(0x30030E);	// ct_cds_start (default = 23h)
		SetRegByI2C_Byte3(0x30042C);	// ct_smp_width (default = 60h)
		SetRegByI2C_Byte3(0x30050D);	// ct_az_width (default = 28h)
		SetRegByI2C_Byte3(0x300639);	// ct_s1r_width (default = 88h)
		SetRegByI2C_Byte3(0x300702);	// ct_tx_start (default = 06h)
		SetRegByI2C_Byte3(0x30083C);	// ct_tx_width 1.5us (default = 7Ch)
		SetRegByI2C_Byte3(0x30093C);	// ct_stx_width 1.5us (default = 7Ch)
		SetRegByI2C_Byte3(0x300A28);	// ct_dtx_width 1us (default = 3Eh)
		SetRegByI2C_Byte3(0x300B15);	// ct_rmp_rst_start (default = 44h)
		SetRegByI2C_Byte3(0x300C15);	// ct_rmp_sig_start (default = 48h)
		SetRegByI2C_Byte3(0x300D02);	// ct_rmp_lat (default = 02h)
		SetRegByI2C_Byte3(0x300EA8);	// D-Shut en[7], CLP On[5], LD high[4]
       	
		//// CDS option setting ...
		SetRegByI2C_Byte3(0x301000);	// smp_en[2]=0(00) 1(04) row_id[1:0] = 00              
		SetRegByI2C_Byte3(0x30117A);	// RST_MX (288), SIG_MX (1024+352)
		SetRegByI2C_Byte3(0x301230);	// SIG offset1  48 code 
		SetRegByI2C_Byte3(0x3013A0);	// RST offset1  160 code
		SetRegByI2C_Byte3(0x301400);	// SIG offset2
		SetRegByI2C_Byte3(0x301500);	// RST offset2                                
		SetRegByI2C_Byte3(0x30160A);	// ADC_SAT (510mV)                             
		SetRegByI2C_Byte3(0x301794);	// RMP_INIT[3:0](RMP_REG) 1.8V MS[6:4]=1            
		SetRegByI2C_Byte3(0x301878);	// rmp option - ramp connect[MSB] +RMP INIT DAC MIN
		       	
		SetRegByI2C_Byte3(0x301DD4);	// CLP level (default = 0Fh)

		SetRegByI2C_Byte3(0x302102);	// inrush ctrl[1] off                              
		SetRegByI2C_Byte3(0x302241);	// pump ring oscillator set [7:4]=CP, [3:0]=NCP 
		SetRegByI2C_Byte3(0x302408);	// pix voltage 2.8V   (default = 88h)                          
		SetRegByI2C_Byte3(0x302708);	// ntg voltage (default = 04h)       
		       	
		//// Pixel option setting ...      
		SetRegByI2C_Byte3(0x301C05);	// Pixel Bias [3:0] (default = 03h)
		SetRegByI2C_Byte3(0x30D83F);	// All tx off 2f, on 3f
		 
		//+++++++++++++++++++++++++++++++//
		// ADLC setting ...
		SetRegByI2C_Byte3(0x30705F);	// [6]L-ADLC BPR, [4]ch sel, [3]L-ADLC, [2]F-ADLC
		SetRegByI2C_Byte3(0x307100);	// F&L-adlc max 127 (default = 11h, max 255)
		SetRegByI2C_Byte3(0x308004);	// F-ADLC filter A (default = 10h)
		SetRegByI2C_Byte3(0x308138);	// F-ADLC filter B (default = 20h)

		//+++++++++++++++++++++++++++++++//
		// Integration setting ... 
		SetRegByI2C_Byte3(0x020203);	// coarse integration time                                                    
		SetRegByI2C_Byte3(0x0203D9);	                              
		SetRegByI2C_Byte3(0x020401);	// analog gain[msb] 0100 x8 0080 x4
		SetRegByI2C_Byte3(0x020580);	// analog gain[lsb] 0040 x2 0020 x1     
		       	
		// Frame Length
		SetRegByI2C_Byte3(0x034007);	//Capture 07B4(1960[# of row]+12[V-blank])
		SetRegByI2C_Byte3(0x0341B4);	//Preview 03E0(980[# of row]+12[V-blank])

		// Line Length
		SetRegByI2C_Byte3(0x03420A);	//0AB2h(2738d 10b 15fps calculated ( PCLK/(Line Length*Frame Length)=14.93fps )
		SetRegByI2C_Byte3(0x0343B2);	//(Same as sensor default)


		//+++++++++++++++++++++++++++++++//
		// embedded 2-line OFF setting ...
		//// 2608 x 1960 
		SetRegByI2C_Byte3(0x308415);	// SYNC Mode

		//+++++++++++++++++++++++++++++++//
		// PLL & MIPI setting ...
		//// input clock 13MHz

		////// (1) Parallel(MIPI base, TST = 0100b), 15 fps
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B47C		// PLL M = 124
		//S30B501		// PLL S = 1 
		//S30BE05		// M_PCLKDIV_AUTO[4], M_DIV_PCLK[3:0]
		//
		//S311000		// pclk_inv[4]
		//S311706		// pclk_delay (default = 00h)
		//S31190A		// VSYNC[3:2], HSYNC[1:0] strength
		//S311AAA		// DATA[7:6], PCLK[5:4], STRB[3:0] strength

		//// (2) Parallel(SIMA base, TST = 0011b), 15 fps
		//S30B110 	// pll_s_ctrl_en[4] = 1 (def = 0)
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B47C		// PLL M = 124
		//S30B501		// PLL S = 1 
		//S030105		// VT_PIX_CLK_DIV
		//
		//S311000		// pclk_inv[4]
		//S311706		// pclk_delay (default = 00h)
		//S31190A		// VSYNC[3:2], HSYNC[1:0] strength
		//S311AAA		// DATA[7:6], PCLK[5:4], STRB[3:0] strength

		////// (3) MIPI 1-lane Serial(TST = 0000b or TST = 0010b), 15 fps
		SetRegByI2C_Byte3(0x30BD00);		// SEL_CCP[0]
		SetRegByI2C_Byte3(0x30B204);		// PLL P = 4
		SetRegByI2C_Byte3(0x30B300);		// PLL M[8] = 0
		// KJ_IMP_TEST : Speed Setting
	#if (0)
		Disp("Speed : 806 Mbps\n"); 
		SetRegByI2C_Byte3(0x30B47C);		// PLL M = 124	// 806 Mbps(412.3 Mhz -> Real : 403 Mhz)
		SetRegByI2C_Byte3(0x30B500);		// PLL S = 0 
	#elif (1)
		Disp("Speed : 720 Mbps\n"); 
		SetRegByI2C_Byte3(0x30B4D3);		// PLL M = 211	// 704 Mbps(350.7 Mhz -> Real : 352 Mhz)
		SetRegByI2C_Byte3(0x30B501);		// PLL S = 1 
	#elif (0)
		Disp("Speed : 608 Mbps\n"); 
		SetRegByI2C_Byte3(0x30B4B8);		// PLL M = 184	// 608 Mbps(305.9 Mhz -> Real : 304 Mhz)
		SetRegByI2C_Byte3(0x30B501);		// PLL S = 1 
	#elif (0)
		Disp("Speed : 408 Mbps\n"); 
		SetRegByI2C_Byte3(0x30B47C);		// PLL M = 124		// 408 Mbps(206.15 Mhz -> Real : 204 Mhz)
		SetRegByI2C_Byte3(0x30B501);		// PLL S = 1 		// SOT Error -> SetHSsettleTime(0x7)
	#endif
		SetRegByI2C_Byte3(0x30BE1A);		// M_PCLKDIV_AUTO[4], M_DIV_PCLK[3:0]

		SetRegByI2C_Byte3(0x30BFAB);		// outif_enable[7], data_type[5:0](2Bh = bayer 10bit)
		SetRegByI2C_Byte3(0x30C080);		// video_offset[7:4] 3260%12
		SetRegByI2C_Byte3(0x30C101);		// pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3260 = 2608 * 1.25
		SetRegByI2C_Byte3(0x30C9BC);		
		SetRegByI2C_Byte3(0x30E201);		// num lanes[1:0] = 1
		SetRegByI2C_Byte3(0x30EE02);		// DPHY enable [1]
		SetRegByI2C_Byte3(0x30F1D0);		// DPHY BANDCTRL 800MHz=80.6MHz
		SetRegByI2C_Byte3(0x311186);		// Embedded data off [5]
		//
		////// (4) CCP Serial(TST = 0000b or TST = 0001b), 12 fps
		//S30BD01		// SEL_CCP[0]
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B4C8		// PLL M = 200
		//S03010A		// VT_PIX_CLK_DIV                         
		//                       
		//s30B900		// data/clk phase inversion
		//s30BA70		// vcm centering
		//s011101		// data/clk mode	
		                         
		SetRegByI2C_Byte3(0x311710);
		SetRegByI2C_Byte3(0x311010);


	#if 0
		Disp("Size : 640*480\n"); 
		// Good : 640*480
		SetRegByI2C_Byte3(0x30C080);		//[7:4]video_offset 800%12 = 8
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C803);		// video_data_length 800 = 640 * 1.25
		SetRegByI2C_Byte3(0x30C920);		
		SetRegByI2C_Byte3(0x034C02);	//x_output_size 640
		SetRegByI2C_Byte3(0x034D80);
		SetRegByI2C_Byte3(0x034E01);	//y_output_size 480
		SetRegByI2C_Byte3(0x034FE0);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x034802);	//x_addr_end 639
		SetRegByI2C_Byte3(0x03497F);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A01);	//y_addr_end 479
		SetRegByI2C_Byte3(0x034BDF);
	#elif (0)
		Disp("Size : 1280*960\n"); 
		// Good : 1280*960
		SetRegByI2C_Byte3(0x30C040);		//[7:4]video_offset 1600%12 = 4
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C806);		// video_data_length 1600 = 1280 * 1.25
		SetRegByI2C_Byte3(0x30C940);		
		SetRegByI2C_Byte3(0x034C05);	//x_output_size 1280
		SetRegByI2C_Byte3(0x034D00);
		SetRegByI2C_Byte3(0x034E03);	//y_output_size 960
		SetRegByI2C_Byte3(0x034FC0);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x034804);	//x_addr_end 1279
		SetRegByI2C_Byte3(0x0349FF);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A03);	//y_addr_end 959
		SetRegByI2C_Byte3(0x034BBF);
	#elif (1)
		Disp("Size : 2560*1920\n"); 
		Assert(CamImgWidth == 2560);
		Assert(CamImgHeight == 1920);
		// Good : 2560*1920
		SetRegByI2C_Byte3(0x30C080);		//[7:4]video_offset 3200%12 = 8
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3200 = 2560 * 1.25
		SetRegByI2C_Byte3(0x30C980);		
		SetRegByI2C_Byte3(0x034C0A);	//x_output_size 2560
		SetRegByI2C_Byte3(0x034D00);
		SetRegByI2C_Byte3(0x034E07);	//y_output_size 1920
		SetRegByI2C_Byte3(0x034F80);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x034809);	//x_addr_end 2559
		SetRegByI2C_Byte3(0x0349FF);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A07);	//y_addr_end 1919
		SetRegByI2C_Byte3(0x034B7F);
	#elif (1)
		Disp("Size : 2608*1960\n"); 
		// Bad : 2608*1960
		SetRegByI2C_Byte3(0x30C080);		//[7:4]video_offset 3260%12 = 8
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3260 = 2608 * 1.25
		SetRegByI2C_Byte3(0x30C9BC);		
		SetRegByI2C_Byte3(0x034C0A);	//x_output_size 2608
		SetRegByI2C_Byte3(0x034D30);
		SetRegByI2C_Byte3(0x034E07);	//y_output_size 1960
		SetRegByI2C_Byte3(0x034FA8);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x03480A);	//x_addr_end 2607
		SetRegByI2C_Byte3(0x03492F);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A07);	//y_addr_end 1959
		SetRegByI2C_Byte3(0x034BA7);
	#elif (0)
		Disp("Size : 2560*1960\n"); 	
		// Good : 2560*1960
		SetRegByI2C_Byte3(0x30C080);		//[7:4]video_offset 3200%12 = 8
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3200 = 2560 * 1.25
		SetRegByI2C_Byte3(0x30C980);		
		SetRegByI2C_Byte3(0x034C0A);	//x_output_size 2560
		SetRegByI2C_Byte3(0x034D00);
		SetRegByI2C_Byte3(0x034E07);	//y_output_size 1960
		SetRegByI2C_Byte3(0x034FA8);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x034809);	//x_addr_end 2559
		SetRegByI2C_Byte3(0x0349FF);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A07);	//y_addr_end 1959
		SetRegByI2C_Byte3(0x034BA7);
	#elif (0)
		Disp("Size : 2608*1920\n"); 	
		// Bad : 2608*1920
		SetRegByI2C_Byte3(0x30C080);		//[7:4]video_offset 3260%12 = 8
		SetRegByI2C_Byte3(0x30C101);		//pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3260 = 2608 * 1.25
		SetRegByI2C_Byte3(0x30C9BC);		
		SetRegByI2C_Byte3(0x034C0A);	//x_output_size 2608
		SetRegByI2C_Byte3(0x034D30);
		SetRegByI2C_Byte3(0x034E07);	//y_output_size 1920
		SetRegByI2C_Byte3(0x034F80);
		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x03480A);	//x_addr_end 2607
		SetRegByI2C_Byte3(0x03492F);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A07);	//y_addr_end 1919
		SetRegByI2C_Byte3(0x034B7F);
	#endif

	#if 0
		Disp("Color Bar mode\n"); 	
		SetRegByI2C_Byte3(0x30A909);		// Color Bar 	////
		SetRegByI2C_Byte3(0x060102);		// Color Bar 	////
	#endif
			
		//+++++++++++++++++++++++++++++++//
		// Operating START
		SetRegByI2C_Byte3(0x010001);		// stream ON   
		/////////////////////////////////    
	}
	else if(eSrcFmt == BayerRGB12)
	{
		Disp("[4E1]BayerRGB12 : 2608*1960\n");	// 818Mbps
		Assert(CamImgWidth == 2608);
		Assert(CamImgHeight == 1960);

		// ******************* //
		// S5K4E1GX 
		// 
		// last update date : 2009. 02. 04
		//
		// Full size output (2608 x 1960)
		// This Setfile is optimized for 15fps or lower frame rate
		//
		// ******************* //


		//+++++++++++++++++++++++++++++++//
		// Reset for operation ...
		SetRegByI2C_Byte3(0x010000);		// stream off
		SetRegByI2C_Byte3(0x010301); 	// software reset

		//+++++++++++++++++++++++++++++++//
		// Analog Setting

		//// CDS timing setting ...
		SetRegByI2C_Byte3(0x300004);	// ct_ld_start (default = 07h)
		SetRegByI2C_Byte3(0x300102);	// ct_sl_start (default = 05h)
		SetRegByI2C_Byte3(0x30020C);	// ct_rx_start (default = 21h)
		SetRegByI2C_Byte3(0x30030E);	// ct_cds_start (default = 23h)
		SetRegByI2C_Byte3(0x30042C);	// ct_smp_width (default = 60h)
		SetRegByI2C_Byte3(0x30050D);	// ct_az_width (default = 28h)
		SetRegByI2C_Byte3(0x300639);	// ct_s1r_width (default = 88h)
		SetRegByI2C_Byte3(0x300702);	// ct_tx_start (default = 06h)
		SetRegByI2C_Byte3(0x30083C);	// ct_tx_width 1.5us (default = 7Ch)
		SetRegByI2C_Byte3(0x30093C);	// ct_stx_width 1.5us (default = 7Ch)
		SetRegByI2C_Byte3(0x300A28);	// ct_dtx_width 1us (default = 3Eh)
		SetRegByI2C_Byte3(0x300B15);	// ct_rmp_rst_start (default = 44h)
		SetRegByI2C_Byte3(0x300C15);	// ct_rmp_sig_start (default = 48h)
		SetRegByI2C_Byte3(0x300D02);	// ct_rmp_lat (default = 02h)
		SetRegByI2C_Byte3(0x300EA8);	// D-Shut en[7], CLP On[5], LD high[4]
		       	
		//// CDS option setting ...
		SetRegByI2C_Byte3(0x301000);	// smp_en[2]=0(00) 1(04) row_id[1:0] = 00              
		SetRegByI2C_Byte3(0x30117A);	// RST_MX (288), SIG_MX (1024+352)
		SetRegByI2C_Byte3(0x301230);	// SIG offset1  48 code 
		SetRegByI2C_Byte3(0x3013A0);	// RST offset1  160 code
		SetRegByI2C_Byte3(0x301400);	// SIG offset2
		SetRegByI2C_Byte3(0x301500);	// RST offset2                                
		SetRegByI2C_Byte3(0x30160A);	// ADC_SAT (510mV)                             
		SetRegByI2C_Byte3(0x301794);	// RMP_INIT[3:0](RMP_REG) 1.8V MS[6:4]=1            
		SetRegByI2C_Byte3(0x301878);	// rmp option - ramp connect[MSB] +RMP INIT DAC MIN
		       	
		SetRegByI2C_Byte3(0x301DD4);	// CLP level (default = 0Fh)

		SetRegByI2C_Byte3(0x302102);	// inrush ctrl[1] off                              
		SetRegByI2C_Byte3(0x302241);	// pump ring oscillator set [7:4]=CP, [3:0]=NCP 
		SetRegByI2C_Byte3(0x302408);	// pix voltage 2.8V   (default = 88h)                          
		SetRegByI2C_Byte3(0x302708);	// ntg voltage (default = 04h)       
		       	
		//// Pixel option setting ...      
		SetRegByI2C_Byte3(0x301C05);	// Pixel Bias [3:0] (default = 03h)
		SetRegByI2C_Byte3(0x30D83F);	// All tx off 2f, on 3f
		 
		//+++++++++++++++++++++++++++++++//
		// ADLC setting ...
		SetRegByI2C_Byte3(0x30705F);	// [6]L-ADLC BPR, [4]ch sel, [3]L-ADLC, [2]F-ADLC
		SetRegByI2C_Byte3(0x307100);	// F&L-adlc max 127 (default = 11h, max 255)
		SetRegByI2C_Byte3(0x308004);	// F-ADLC filter A (default = 10h)
		SetRegByI2C_Byte3(0x308138);	// F-ADLC filter B (default = 20h)

		//+++++++++++++++++++++++++++++++//
		// Integration setting ... 
		SetRegByI2C_Byte3(0x020203);	// coarse integration time                                                    
		SetRegByI2C_Byte3(0x0203D9);	                              
		SetRegByI2C_Byte3(0x020401);	// analog gain[msb] 0100 x8 0080 x4
		SetRegByI2C_Byte3(0x020580);	// analog gain[lsb] 0040 x2 0020 x1     
		       	
		// Frame Length
		SetRegByI2C_Byte3(0x034007);	//Capture 07B4(1960[# of row]+12[V-blank])
		SetRegByI2C_Byte3(0x0341B4);	//Preview 03E0(980[# of row]+12[V-blank])

		// Line Length
		SetRegByI2C_Byte3(0x03420A);	//0AB2h(2738d 10b 15fps calculated ( PCLK/(Line Length*Frame Length)=14.93fps )
		SetRegByI2C_Byte3(0x0343B2);	//(Same as sensor default)


		//+++++++++++++++++++++++++++++++//
		// embedded 2-line OFF setting ...
		//// 2608 x 1960 
		SetRegByI2C_Byte3(0x308415);	// SYNC Mode


		//+++++++++++++++++++++++++++++++//
		// PLL & MIPI setting ...
		//// input clock 13MHz

		////// (1) Parallel(MIPI base, TST = 0100b), 15 fps
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B47C		// PLL M = 124
		//S30B501		// PLL S = 1 
		//S30BE05		// M_PCLKDIV_AUTO[4], M_DIV_PCLK[3:0]
		//
		//S311000		// pclk_inv[4]
		//S311706		// pclk_delay (default = 00h)
		//S31190A		// VSYNC[3:2], HSYNC[1:0] strength
		//S311AAA		// DATA[7:6], PCLK[5:4], STRB[3:0] strength

		//// (2) Parallel(SIMA base, TST = 0011b), 15 fps
		//S30B110 	// pll_s_ctrl_en[4] = 1 (def = 0)
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B47C		// PLL M = 124
		//S30B501		// PLL S = 1 
		//S030105		// VT_PIX_CLK_DIV
		//
		//S311000		// pclk_inv[4]
		//S311706		// pclk_delay (default = 00h)
		//S31190A		// VSYNC[3:2], HSYNC[1:0] strength
		//S311AAA		// DATA[7:6], PCLK[5:4], STRB[3:0] strength

		////// (3) MIPI 1-lane Serial(TST = 0000b or TST = 0010b), 15 fps
		SetRegByI2C_Byte3(0x30BD00);		// SEL_CCP[0]
		SetRegByI2C_Byte3(0x30B204);		// PLL P = 4
		SetRegByI2C_Byte3(0x30B300);		// PLL M[8] = 0
		SetRegByI2C_Byte3(0x30B47C);		// PLL M = 124
		SetRegByI2C_Byte3(0x30B500);		// PLL S = 0 
		SetRegByI2C_Byte3(0x30BE1A);		// M_PCLKDIV_AUTO[4], M_DIV_PCLK[3:0]

		SetRegByI2C_Byte3(0x30BFAB);		// outif_enable[7], data_type[5:0](2Bh = bayer 10bit)
		SetRegByI2C_Byte3(0x30C080);		// video_offset[7:4] 3260%12
		SetRegByI2C_Byte3(0x30C101);		// pack video enable [0]
		SetRegByI2C_Byte3(0x30C80C);		// video_data_length 3260 = 2608 * 1.25
		SetRegByI2C_Byte3(0x30C9BC);		
		SetRegByI2C_Byte3(0x30E201);		// num lanes[1:0] = 1
		SetRegByI2C_Byte3(0x30EE02);		// DPHY enable [1]
		SetRegByI2C_Byte3(0x30F1D0);		// DPHY BANDCTRL 800MHz=80.6MHz
		SetRegByI2C_Byte3(0x311186);		// Embedded data off [5]
		//
		////// (4) CCP Serial(TST = 0000b or TST = 0001b), 12 fps
		//S30BD01		// SEL_CCP[0]
		//S30B204		// PLL P = 4
		//S30B300		// PLL M[8] = 0
		//S30B4C8		// PLL M = 200
		//S03010A		// VT_PIX_CLK_DIV                         
		//                       
		//s30B900		// data/clk phase inversion
		//s30BA70		// vcm centering
		//s011101		// data/clk mode	
		                         
		SetRegByI2C_Byte3(0x311710);
		SetRegByI2C_Byte3(0x311010);
		//+++++++++++++++++++++++++++++++//
		// Operating START
		SetRegByI2C_Byte3(0x010001);		// stream ON   

		/////////////////////////////////    
		//Normal 


		SetRegByI2C_Byte3(0x010000);	//Streaming off

		SetRegByI2C_Byte3(0x30300D);     //adc_res 12bit
		SetRegByI2C_Byte3(0x300d05);     //ct_rmp_lat = 5

		//S300E00	//[0]avg_mode
			//[1]v_avg_en
			//[2]h_avg_en
		//S30A901	//[0]h_wb_bypass
			//[1]h_averaged_en

		SetRegByI2C_Byte3(0x034007);	//frame_length_lines 1970
		SetRegByI2C_Byte3(0x0341B2);
		SetRegByI2C_Byte3(0x03421C);	//line_length_pck 7248
		SetRegByI2C_Byte3(0x034350);

		SetRegByI2C_Byte3(0x034400);	//x_addr_start 0
		SetRegByI2C_Byte3(0x034500);
		SetRegByI2C_Byte3(0x03480A);	//x_addr_end 2607
		SetRegByI2C_Byte3(0x03492F);	
		SetRegByI2C_Byte3(0x034600);	//y_addr_start 0
		SetRegByI2C_Byte3(0x034700);
		SetRegByI2C_Byte3(0x034A07);	//y_addr_end 1959
		SetRegByI2C_Byte3(0x034BA7);
		SetRegByI2C_Byte3(0x038000);	//x_even_inc 1
		SetRegByI2C_Byte3(0x038101);
		SetRegByI2C_Byte3(0x038200);	//x_odd_inc 1
		SetRegByI2C_Byte3(0x038201);
		SetRegByI2C_Byte3(0x038400);	//y_even_inc 1
		SetRegByI2C_Byte3(0x038501);
		SetRegByI2C_Byte3(0x038600);	//y_odd_inc 1
		SetRegByI2C_Byte3(0x038701);
		SetRegByI2C_Byte3(0x034C0A);	//x_output_size 2608
		SetRegByI2C_Byte3(0x034D30);
		SetRegByI2C_Byte3(0x034E07);	//y_output_size 1960
		SetRegByI2C_Byte3(0x034FA8);

		SetRegByI2C_Byte3(0x311106);		// Embedded data off
		SetRegByI2C_Byte3(0x30c101);		// pack video enable
		SetRegByI2C_Byte3(0x30ee02);		// DPHY enable
		SetRegByI2C_Byte3(0x30bfaC);		// outif_enable, data_type
				
		SetRegByI2C_Byte3(0x30C80f);		// video_data_length 3912 = 2608 * 1.5
		SetRegByI2C_Byte3(0x30C948);		
				
		SetRegByI2C_Byte3(0x30C0c0);		//[7:4]video_offset 3912%12 = 0
				
				
		SetRegByI2C_Byte3(0x30be1A);		// Mipi clk auto set[4] = 1
		SetRegByI2C_Byte3(0x30e201);		// num lanes[1:0] = 1
				
		SetRegByI2C_Byte3(0x30EA06);           //s_video_data_length		
		SetRegByI2C_Byte3(0x30EB5E);		

		// KJ_IMP_TEST
		//SetRegByI2C_Byte3(0x30A909);		// Color Bar 	////
		//SetRegByI2C_Byte3(0x060103);		// Color Bar 	////

		SetRegByI2C_Byte3(0x010001);	//streaming on
	}
	else
	{
		Assert(0);
	}
}

static void S5K4E1_Sleep(void)
{
	SetRegByI2C_Byte3(0x010000);	//streaming off
	Disp("[4E1]Sleep\n");
}

static void S5K4E1_WakeUp(void)
{
	SetRegByI2C_Byte3(0x010001);	//streaming on
	Disp("[4E1]Wake-Up\n");
}

// [Reset camera mipi]
static void MIPICAM_Reset(CIS_MODEL eCisModel)
{
	switch(eCisModel)
	{
		case S5K6AAFX:		
		case S5K4EAG:
		case S5K4E1GX:		
			GPIO_SetFunctionEach(eGPIO_H0, eGPIO_3, eGPO); // XEINT3
			GPIO_SetPullUpDownEach(eGPIO_H0, eGPIO_3, eGPUDdis); // XEINT3
			GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3
			GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 1); // XEINT3		
			break;			
		case EXTCAM:
			break;
		default:
			Assert(0);
			break;
	}		
}

static void MIPICAM_SetMclk(CIS_MODEL eCisModel)
{
	switch(eCisModel)
	{
		case S5K6AAFX:		
		case S5K4EAG:
			Disp("[MIPI]MCLK : 24 Mhz\n");
			// EPLL is 96 Mhz
			SYSC_SetClkMuxState(eCLKMUX_CAM0_SEPLL);				
			SYSC_SetClkDiv(eCLKDIV_CAM0, 4);		
			break;			
		case S5K4E1GX:				
			Disp("[MIPI]MCLK : 13.7 Mhz\n");
			// EPLL is 96 Mhz
			SYSC_SetClkMuxState(eCLKMUX_CAM0_SEPLL);				
			SYSC_SetClkDiv(eCLKDIV_CAM0, 7);		
			break;			
		case EXTCAM:
			break;
		default:
			Assert(0);
			break;
	}

	Delay(1000);	// p100	// Wait100mSec
}

void MIPICAM_Prepare(CIS_MODEL eCisModel, IMG_FMT eFinImgType, 
						IMG_RESOLUTION eImgSize, CSIS_DATA_LANE_NUM eCSISDataLaneNum)
{
	u32 uCamImgWidth, uCamImgHeight;

	MIPICAM_IICOpen();
	MIPICAM_SetMclk(eCisModel);
	MIPICAM_Reset(eCisModel);

	switch(eImgSize)
	{
		case QVGA:
			uCamImgWidth = QVGA_HSIZE, uCamImgHeight = QVGA_VSIZE;
			break;
		case VGA:
			uCamImgWidth = VGA_HSIZE, uCamImgHeight = VGA_VSIZE;
			break;
		case WSVGA:
			uCamImgWidth = WSVGA_HSIZE, uCamImgHeight = WSVGA_VSIZE;
			break;
		case WVGA:
			uCamImgWidth = WVGA_HSIZE, uCamImgHeight = WVGA_VSIZE;
			break;
		case HD720:
			uCamImgWidth = HD720_HSIZE, uCamImgHeight = HD720_VSIZE;
			break;
		case HD1080:
			uCamImgWidth = HD1080_HSIZE, uCamImgHeight = HD1080_VSIZE;
			break;
		case USER_DEFINE_SIZE:
			uCamImgWidth = USER_DEFINE_SIZE_HSIZE, uCamImgHeight = USER_DEFINE_SIZE_VSIZE;
			break;				
		default:
			Assert(0);
			break;
	}

	switch(eCisModel)
	{
		case S5K6AAFX:		
			ucCamI2CAddr = 0x78;
			S5K6AA_Init(eFinImgType, uCamImgWidth, uCamImgHeight);
			S5K6AA_Sleep();
			break;
		case S5K4EAG:
			ucCamI2CAddr = 0x5A;
			S5K4EA_Init(eFinImgType, uCamImgWidth, uCamImgHeight, eCSISDataLaneNum);			
			S5K4EA_Sleep();
			break;			
		case S5K4E1GX:
			ucCamI2CAddr = 0x20;
			S5K4E1_Init(eFinImgType, uCamImgWidth, uCamImgHeight);			
			S5K4E1_Sleep();
			break;	
		case EXTCAM:
			break;
		default:
			Assert(0);
			break;
	}
}

void MIPICAM_Start(CIS_MODEL eCisModel, IMG_FMT eFinImgType, IMG_RESOLUTION eImgSize)
{
	switch(eCisModel)
	{
		case S5K6AAFX:		
//			S5K6AA_Init(eFinImgType, eImgSize);
//			CSI_S_RESETN_LP11();				
			S5K6AA_WakeUp();
			break;
		case S5K4EAG:
			S5K4EA_WakeUp();
			break;			
		case S5K4E1GX:
			S5K4E1_WakeUp();
			break;			
		case EXTCAM:
			break;			
		default:
			Assert(0);
			break;
	}
}

void MIPICAM_Disable(void)
{
#ifdef S5PV210
	// Set nReset to low
	GPIO_SetDataEach(eGPIO_H0, eGPIO_3, 0); // XEINT3
	Delay(1000);	// p100	// Wait100mSec
#endif
}

